# Copyright 2012 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

{
  'variables': {
    # There are two sections of sources:
    # * "Platform"-based sources (OS, toolkit, etc.)
    # * Feature/directory-based sources (e.g., history, printing)

    ### Platform-based sources ###
    'chrome_browser_ui_non_ios_sources': [
      'browser/ui/accelerator_utils.h',
      'browser/ui/android/android_about_app_info.cc',
      'browser/ui/android/android_about_app_info.h',
      'browser/ui/android/external_protocol_dialog_android.cc',
      'browser/ui/android/status_tray_android.cc',
      'browser/ui/android/tab_model/tab_model_list.cc',
      'browser/ui/android/tab_model/tab_model_list.h',
      'browser/ui/app_list/app_list_util.cc',
      'browser/ui/app_list/app_list_util.h',
      # All other browser/ui/app_list files go in chrome_browser_ui_app_list_sources.
      'browser/ui/app_modal/chrome_javascript_native_dialog_factory.h',
      'browser/ui/autofill/autofill_dialog_controller.cc',
      'browser/ui/autofill/autofill_dialog_controller.h',
      'browser/ui/autofill/autofill_dialog_models.cc',
      'browser/ui/autofill/autofill_dialog_models.h',
      'browser/ui/autofill/autofill_dialog_types.cc',
      'browser/ui/autofill/autofill_dialog_types.h',
      'browser/ui/autofill/autofill_popup_controller.h',
      'browser/ui/autofill/autofill_popup_controller_impl.cc',
      'browser/ui/autofill/autofill_popup_controller_impl.h',
      'browser/ui/autofill/autofill_popup_view.h',
      'browser/ui/autofill/autofill_popup_view_delegate.h',
      'browser/ui/autofill/chrome_autofill_client.cc',
      'browser/ui/autofill/chrome_autofill_client.h',
      'browser/ui/autofill/country_combobox_model.cc',
      'browser/ui/autofill/country_combobox_model.h',
      'browser/ui/autofill/create_card_unmask_prompt_view.h',
      'browser/ui/autofill/credit_card_scanner_controller.cc',
      'browser/ui/autofill/credit_card_scanner_controller.h',
      'browser/ui/autofill/credit_card_scanner_view.cc',
      'browser/ui/autofill/credit_card_scanner_view.h',
      'browser/ui/autofill/credit_card_scanner_view_delegate.h',
      'browser/ui/autofill/loading_animation.cc',
      'browser/ui/autofill/loading_animation.h',
      'browser/ui/autofill/password_generation_popup_controller.h',
      'browser/ui/autofill/password_generation_popup_controller_impl.cc',
      'browser/ui/autofill/password_generation_popup_controller_impl.h',
      'browser/ui/autofill/password_generation_popup_observer.h',
      'browser/ui/autofill/password_generation_popup_view.cc',
      'browser/ui/autofill/password_generation_popup_view.h',
      'browser/ui/autofill/popup_controller_common.cc',
      'browser/ui/autofill/popup_controller_common.h',
      'browser/ui/autofill/save_card_bubble_controller.h',
      'browser/ui/autofill/save_card_bubble_controller_impl.cc',
      'browser/ui/autofill/save_card_bubble_controller_impl.h',
      'browser/ui/autofill/save_card_bubble_view.h',
      'browser/ui/blocked_content/blocked_window_params.cc',
      'browser/ui/blocked_content/blocked_window_params.h',
      'browser/ui/blocked_content/popup_blocker_tab_helper.cc',
      'browser/ui/blocked_content/popup_blocker_tab_helper.h',
      'browser/ui/bookmarks/bookmark_bar.h',
      'browser/ui/bookmarks/bookmark_bar_constants.h',
      'browser/ui/bookmarks/bookmark_bar_instructions_delegate.h',
      'browser/ui/bookmarks/bookmark_bubble_delegate.h',
      'browser/ui/bookmarks/bookmark_bubble_observer.h',
      'browser/ui/bookmarks/bookmark_editor.cc',
      'browser/ui/bookmarks/bookmark_editor.h',
      'browser/ui/bookmarks/bookmark_utils.cc',
      'browser/ui/bookmarks/bookmark_utils.h',
      'browser/ui/bookmarks/recently_used_folders_combo_model.cc',
      'browser/ui/bookmarks/recently_used_folders_combo_model.h',
      'browser/ui/browser_commands_chromeos.cc',
      'browser/ui/browser_commands_chromeos.h',
      'browser/ui/browser_commands_mac.cc',
      'browser/ui/browser_commands_mac.h',
      'browser/ui/browser_dialogs.h',
      'browser/ui/browser_mac.cc',
      'browser/ui/browser_mac.h',
      'browser/ui/browser_navigator_params.cc',
      'browser/ui/browser_navigator_params.h',
      'browser/ui/browser_ui_prefs.cc',
      'browser/ui/browser_ui_prefs.h',
      'browser/ui/browser_win.cc',
      'browser/ui/browser_window.h',
      'browser/ui/chrome_select_file_policy.cc',
      'browser/ui/chrome_select_file_policy.h',
      'browser/ui/confirm_bubble.h',
      'browser/ui/crypto_module_password_dialog.h',
      'browser/ui/find_bar/find_bar.h',
      'browser/ui/find_bar/find_bar_state.h',
      'browser/ui/find_bar/find_bar_state_factory.cc',
      'browser/ui/find_bar/find_bar_state_factory.h',
      'browser/ui/find_bar/find_notification_details.h',
      'browser/ui/find_bar/find_tab_helper.cc',
      'browser/ui/find_bar/find_tab_helper.h',
      'browser/ui/host_desktop.cc',
      'browser/ui/host_desktop.h',
      'browser/ui/login/login_interstitial_delegate.cc',
      'browser/ui/login/login_interstitial_delegate.h',
      'browser/ui/login/login_prompt.cc',
      'browser/ui/login/login_prompt.h',
      'browser/ui/media_utils.cc',
      'browser/ui/media_utils.h',
      'browser/ui/metro_pin_tab_helper_win.cc',
      'browser/ui/metro_pin_tab_helper_win.h',
      'browser/ui/navigation_correction_tab_observer.cc',
      'browser/ui/navigation_correction_tab_observer.h',
      'browser/ui/passwords/account_avatar_fetcher.cc',
      'browser/ui/passwords/account_avatar_fetcher.h',
      'browser/ui/passwords/account_chooser_more_combobox_model.cc',
      'browser/ui/passwords/account_chooser_more_combobox_model.h',
      'browser/ui/passwords/manage_passwords_state.cc',
      'browser/ui/passwords/manage_passwords_state.h',
      'browser/ui/passwords/manage_passwords_ui_controller.cc',
      'browser/ui/passwords/manage_passwords_ui_controller.h',
      'browser/ui/passwords/manage_passwords_view_utils.cc',
      'browser/ui/passwords/manage_passwords_view_utils.h',
      'browser/ui/passwords/password_manager_presenter.cc',
      'browser/ui/passwords/password_manager_presenter.h',
      'browser/ui/passwords/password_ui_view.h',
      'browser/ui/platform_keys_certificate_selector_chromeos.h',
      'browser/ui/prefs/prefs_tab_helper.cc',
      'browser/ui/prefs/prefs_tab_helper.h',
      'browser/ui/process_singleton_dialog_linux.h',
      'browser/ui/profile_chooser_constants.h',
      'browser/ui/profile_error_dialog.cc',
      'browser/ui/profile_error_dialog.h',
      'browser/ui/protocol_dialog_delegate.h',
      'browser/ui/proximity_auth/proximity_auth_error_bubble.cc',
      'browser/ui/proximity_auth/proximity_auth_error_bubble.h',
      'browser/ui/screen_capture_notification_ui.h',
      'browser/ui/search/instant_page.cc',
      'browser/ui/search/instant_page.h',
      'browser/ui/search/instant_search_prerenderer.cc',
      'browser/ui/search/instant_search_prerenderer.h',
      'browser/ui/search/instant_tab.cc',
      'browser/ui/search/instant_tab.h',
      'browser/ui/search/new_tab_page_interceptor_service.cc',
      'browser/ui/search/new_tab_page_interceptor_service.h',
      'browser/ui/search/new_tab_page_interceptor_service_factory.cc',
      'browser/ui/search/new_tab_page_interceptor_service_factory.h',
      'browser/ui/search/search_ipc_router.cc',
      'browser/ui/search/search_ipc_router.h',
      'browser/ui/search/search_ipc_router_policy_impl.cc',
      'browser/ui/search/search_ipc_router_policy_impl.h',
      'browser/ui/search/search_model.cc',
      'browser/ui/search/search_model.h',
      'browser/ui/search/search_model_observer.h',
      'browser/ui/search/search_tab_helper.cc',
      'browser/ui/search/search_tab_helper.h',
      'browser/ui/search/search_tab_helper_delegate.cc',
      'browser/ui/search/search_tab_helper_delegate.h',
      'browser/ui/search_engines/edit_search_engine_controller.cc',
      'browser/ui/search_engines/edit_search_engine_controller.h',
      'browser/ui/search_engines/keyword_editor_controller.cc',
      'browser/ui/search_engines/keyword_editor_controller.h',
      'browser/ui/search_engines/search_engine_tab_helper.cc',
      'browser/ui/search_engines/search_engine_tab_helper.h',
      'browser/ui/search_engines/template_url_table_model.cc',
      'browser/ui/search_engines/template_url_table_model.h',
      'browser/ui/session_crashed_bubble.h',
      'browser/ui/simple_message_box.h',
      'browser/ui/simple_message_box_internal.cc',
      'browser/ui/simple_message_box_internal.h',
      'browser/ui/status_bubble.h',
      'browser/ui/sync/profile_signin_confirmation_helper.cc',
      'browser/ui/sync/profile_signin_confirmation_helper.h',
      'browser/ui/sync/tab_contents_synced_tab_delegate.cc',
      'browser/ui/sync/tab_contents_synced_tab_delegate.h',
      'browser/ui/tab_contents/chrome_web_contents_view_delegate.h',
      'browser/ui/tab_contents/core_tab_helper.cc',
      'browser/ui/tab_contents/core_tab_helper.h',
      'browser/ui/tab_contents/core_tab_helper_delegate.cc',
      'browser/ui/tab_contents/core_tab_helper_delegate.h',
      'browser/ui/tab_dialogs.cc',
      'browser/ui/tab_dialogs.h',
      'browser/ui/tab_helpers.cc',
      'browser/ui/tab_helpers.h',
      'browser/ui/tab_modal_confirm_dialog.h',
      'browser/ui/translate/language_combobox_model.cc',
      'browser/ui/translate/language_combobox_model.h',
      'browser/ui/translate/translate_bubble_model.h',
      'browser/ui/translate/translate_bubble_model_impl.cc',
      'browser/ui/translate/translate_bubble_model_impl.h',
      'browser/ui/translate/translate_bubble_view_state_transition.cc',
      'browser/ui/translate/translate_bubble_view_state_transition.h',
      'browser/ui/uninstall_browser_prompt.h',
      'browser/ui/validation_message_bubble.h',
      'browser/ui/view_ids.h',
      'browser/ui/views/platform_keys_certificate_selector_chromeos.cc',
      'browser/ui/views/platform_keys_certificate_selector_chromeos.h',
      'browser/ui/web_contents_sizer.h',
      'browser/ui/website_settings/permission_bubble_request.cc',
      'browser/ui/website_settings/permission_bubble_request.h',
      'browser/ui/website_settings/website_settings.cc',
      'browser/ui/website_settings/website_settings.h',
      'browser/ui/website_settings/website_settings_ui.cc',
      'browser/ui/website_settings/website_settings_ui.h',
      'browser/ui/webui/about_ui.cc',
      'browser/ui/webui/about_ui.h',
      'browser/ui/webui/chrome_web_ui_controller_factory.cc',
      'browser/ui/webui/chrome_web_ui_controller_factory.h',
      'browser/ui/webui/chromeos/bluetooth_pairing_ui.cc',
      'browser/ui/webui/chromeos/bluetooth_pairing_ui.h',
      'browser/ui/webui/chromeos/certificate_manager_dialog_ui.cc',
      'browser/ui/webui/chromeos/certificate_manager_dialog_ui.h',
      'browser/ui/webui/chromeos/choose_mobile_network_ui.cc',
      'browser/ui/webui/chromeos/choose_mobile_network_ui.h',
      'browser/ui/webui/chromeos/cryptohome_ui.cc',
      'browser/ui/webui/chromeos/cryptohome_ui.h',
      'browser/ui/webui/chromeos/cryptohome_web_ui_handler.cc',
      'browser/ui/webui/chromeos/cryptohome_web_ui_handler.h',
      'browser/ui/webui/chromeos/drive_internals_ui.cc',
      'browser/ui/webui/chromeos/drive_internals_ui.h',
      'browser/ui/webui/chromeos/first_run/first_run_actor.cc',
      'browser/ui/webui/chromeos/first_run/first_run_actor.h',
      'browser/ui/webui/chromeos/first_run/first_run_handler.cc',
      'browser/ui/webui/chromeos/first_run/first_run_handler.h',
      'browser/ui/webui/chromeos/first_run/first_run_ui.cc',
      'browser/ui/webui/chromeos/first_run/first_run_ui.h',
      'browser/ui/webui/chromeos/image_source.cc',
      'browser/ui/webui/chromeos/image_source.h',
      'browser/ui/webui/chromeos/imageburner/imageburner_ui.cc',
      'browser/ui/webui/chromeos/imageburner/imageburner_ui.h',
      'browser/ui/webui/chromeos/keyboard_overlay_ui.cc',
      'browser/ui/webui/chromeos/keyboard_overlay_ui.h',
      'browser/ui/webui/chromeos/login/app_launch_splash_screen_handler.cc',
      'browser/ui/webui/chromeos/login/app_launch_splash_screen_handler.h',
      'browser/ui/webui/chromeos/login/authenticated_user_email_retriever.cc',
      'browser/ui/webui/chromeos/login/authenticated_user_email_retriever.h',
      'browser/ui/webui/chromeos/login/auto_enrollment_check_screen_handler.cc',
      'browser/ui/webui/chromeos/login/auto_enrollment_check_screen_handler.h',
      'browser/ui/webui/chromeos/login/base_screen_handler.cc',
      'browser/ui/webui/chromeos/login/base_screen_handler.h',
      'browser/ui/webui/chromeos/login/controller_pairing_screen_handler.cc',
      'browser/ui/webui/chromeos/login/controller_pairing_screen_handler.h',
      'browser/ui/webui/chromeos/login/core_oobe_handler.cc',
      'browser/ui/webui/chromeos/login/core_oobe_handler.h',
      'browser/ui/webui/chromeos/login/demo_mode_detector.cc',
      'browser/ui/webui/chromeos/login/demo_mode_detector.h',
      'browser/ui/webui/chromeos/login/device_disabled_screen_handler.cc',
      'browser/ui/webui/chromeos/login/device_disabled_screen_handler.h',
      'browser/ui/webui/chromeos/login/enable_debugging_screen_handler.cc',
      'browser/ui/webui/chromeos/login/enable_debugging_screen_handler.h',
      'browser/ui/webui/chromeos/login/enrollment_screen_handler.cc',
      'browser/ui/webui/chromeos/login/enrollment_screen_handler.h',
      'browser/ui/webui/chromeos/login/error_screen_handler.cc',
      'browser/ui/webui/chromeos/login/error_screen_handler.h',
      'browser/ui/webui/chromeos/login/eula_screen_handler.cc',
      'browser/ui/webui/chromeos/login/eula_screen_handler.h',
      'browser/ui/webui/chromeos/login/gaia_screen_handler.cc',
      'browser/ui/webui/chromeos/login/gaia_screen_handler.h',
      'browser/ui/webui/chromeos/login/hid_detection_screen_handler.cc',
      'browser/ui/webui/chromeos/login/hid_detection_screen_handler.h',
      'browser/ui/webui/chromeos/login/host_pairing_screen_handler.cc',
      'browser/ui/webui/chromeos/login/host_pairing_screen_handler.h',
      'browser/ui/webui/chromeos/login/inline_login_handler_chromeos.cc',
      'browser/ui/webui/chromeos/login/inline_login_handler_chromeos.h',
      'browser/ui/webui/chromeos/login/kiosk_app_menu_handler.cc',
      'browser/ui/webui/chromeos/login/kiosk_app_menu_handler.h',
      'browser/ui/webui/chromeos/login/kiosk_autolaunch_screen_handler.cc',
      'browser/ui/webui/chromeos/login/kiosk_autolaunch_screen_handler.h',
      'browser/ui/webui/chromeos/login/kiosk_enable_screen_handler.cc',
      'browser/ui/webui/chromeos/login/kiosk_enable_screen_handler.h',
      'browser/ui/webui/chromeos/login/l10n_util.cc',
      'browser/ui/webui/chromeos/login/l10n_util.h',
      'browser/ui/webui/chromeos/login/network_dropdown.cc',
      'browser/ui/webui/chromeos/login/network_dropdown.h',
      'browser/ui/webui/chromeos/login/network_dropdown_handler.cc',
      'browser/ui/webui/chromeos/login/network_dropdown_handler.h',
      'browser/ui/webui/chromeos/login/network_screen_handler.cc',
      'browser/ui/webui/chromeos/login/network_screen_handler.h',
      'browser/ui/webui/chromeos/login/network_state_informer.cc',
      'browser/ui/webui/chromeos/login/network_state_informer.h',
      'browser/ui/webui/chromeos/login/oobe_ui.cc',
      'browser/ui/webui/chromeos/login/oobe_ui.h',
      'browser/ui/webui/chromeos/login/reset_screen_handler.cc',
      'browser/ui/webui/chromeos/login/reset_screen_handler.h',
      'browser/ui/webui/chromeos/login/screenlock_icon_provider.cc',
      'browser/ui/webui/chromeos/login/screenlock_icon_provider.h',
      'browser/ui/webui/chromeos/login/screenlock_icon_source.cc',
      'browser/ui/webui/chromeos/login/screenlock_icon_source.h',
      'browser/ui/webui/chromeos/login/signin_screen_handler.cc',
      'browser/ui/webui/chromeos/login/signin_screen_handler.h',
      'browser/ui/webui/chromeos/login/supervised_user_creation_screen_handler.cc',
      'browser/ui/webui/chromeos/login/supervised_user_creation_screen_handler.h',
      'browser/ui/webui/chromeos/login/terms_of_service_screen_handler.cc',
      'browser/ui/webui/chromeos/login/terms_of_service_screen_handler.h',
      'browser/ui/webui/chromeos/login/update_screen_handler.cc',
      'browser/ui/webui/chromeos/login/update_screen_handler.h',
      'browser/ui/webui/chromeos/login/user_board_screen_handler.cc',
      'browser/ui/webui/chromeos/login/user_board_screen_handler.h',
      'browser/ui/webui/chromeos/login/user_image_screen_handler.cc',
      'browser/ui/webui/chromeos/login/user_image_screen_handler.h',
      'browser/ui/webui/chromeos/login/wrong_hwid_screen_handler.cc',
      'browser/ui/webui/chromeos/login/wrong_hwid_screen_handler.h',
      'browser/ui/webui/chromeos/mobile_setup_dialog.cc',
      'browser/ui/webui/chromeos/mobile_setup_dialog.h',
      'browser/ui/webui/chromeos/mobile_setup_ui.cc',
      'browser/ui/webui/chromeos/mobile_setup_ui.h',
      'browser/ui/webui/chromeos/network_ui.cc',
      'browser/ui/webui/chromeos/network_ui.h',
      'browser/ui/webui/chromeos/nfc_debug_ui.cc',
      'browser/ui/webui/chromeos/nfc_debug_ui.h',
      'browser/ui/webui/chromeos/power_ui.cc',
      'browser/ui/webui/chromeos/power_ui.h',
      'browser/ui/webui/chromeos/proxy_settings_ui.cc',
      'browser/ui/webui/chromeos/proxy_settings_ui.h',
      'browser/ui/webui/chromeos/salsa_ui.cc',
      'browser/ui/webui/chromeos/salsa_ui.h',
      'browser/ui/webui/chromeos/set_time_ui.cc',
      'browser/ui/webui/chromeos/set_time_ui.h',
      'browser/ui/webui/chromeos/sim_unlock_ui.cc',
      'browser/ui/webui/chromeos/sim_unlock_ui.h',
      'browser/ui/webui/chromeos/slow_trace_ui.cc',
      'browser/ui/webui/chromeos/slow_trace_ui.h',
      'browser/ui/webui/chromeos/slow_ui.cc',
      'browser/ui/webui/chromeos/slow_ui.h',
      'browser/ui/webui/chromeos/touch_view_controller_delegate.cc',
      'browser/ui/webui/chromeos/touch_view_controller_delegate.h',
      'browser/ui/webui/chromeos/ui_account_tweaks.cc',
      'browser/ui/webui/chromeos/ui_account_tweaks.h',
      'browser/ui/webui/components_ui.cc',
      'browser/ui/webui/components_ui.h',
      'browser/ui/webui/constrained_web_dialog_ui.cc',
      'browser/ui/webui/constrained_web_dialog_ui.h',
      'browser/ui/webui/cookies_tree_model_util.cc',
      'browser/ui/webui/cookies_tree_model_util.h',
      'browser/ui/webui/crashes_ui.cc',
      'browser/ui/webui/crashes_ui.h',
      'browser/ui/webui/device_log_ui.cc',
      'browser/ui/webui/device_log_ui.h',
      'browser/ui/webui/domain_reliability_internals_ui.cc',
      'browser/ui/webui/domain_reliability_internals_ui.h',
      'browser/ui/webui/engagement/site_engagement_ui.cc',
      'browser/ui/webui/engagement/site_engagement_ui.h',
      'browser/ui/webui/fallback_icon_source.cc',
      'browser/ui/webui/fallback_icon_source.h',
      'browser/ui/webui/favicon_source.cc',
      'browser/ui/webui/favicon_source.h',
      'browser/ui/webui/fileicon_source.cc',
      'browser/ui/webui/fileicon_source.h',
      'browser/ui/webui/flags_ui.cc',
      'browser/ui/webui/flags_ui.h',
      'browser/ui/webui/gcm_internals_ui.cc',
      'browser/ui/webui/gcm_internals_ui.h',
      'browser/ui/webui/history_ui.cc',
      'browser/ui/webui/history_ui.h',
      'browser/ui/webui/instant_ui.cc',
      'browser/ui/webui/instant_ui.h',
      'browser/ui/webui/interstitials/interstitial_ui.cc',
      'browser/ui/webui/interstitials/interstitial_ui.h',
      'browser/ui/webui/invalidations_message_handler.cc',
      'browser/ui/webui/invalidations_message_handler.h',
      'browser/ui/webui/invalidations_ui.cc',
      'browser/ui/webui/invalidations_ui.h',
      'browser/ui/webui/large_icon_source.cc',
      'browser/ui/webui/large_icon_source.h',
      'browser/ui/webui/local_state/local_state_ui.cc',
      'browser/ui/webui/local_state/local_state_ui.h',
      'browser/ui/webui/log_web_ui_url.cc',
      'browser/ui/webui/log_web_ui_url.h',
      'browser/ui/webui/memory_internals/memory_internals_handler.cc',
      'browser/ui/webui/memory_internals/memory_internals_handler.h',
      'browser/ui/webui/memory_internals/memory_internals_proxy.cc',
      'browser/ui/webui/memory_internals/memory_internals_proxy.h',
      'browser/ui/webui/memory_internals/memory_internals_ui.cc',
      'browser/ui/webui/memory_internals/memory_internals_ui.h',
      'browser/ui/webui/metrics_handler.cc',
      'browser/ui/webui/metrics_handler.h',
      'browser/ui/webui/mojo_web_ui_controller.cc',
      'browser/ui/webui/mojo_web_ui_controller.h',
      'browser/ui/webui/mojo_web_ui_handler.h',
      'browser/ui/webui/net_export_ui.cc',
      'browser/ui/webui/net_export_ui.h',
      'browser/ui/webui/net_internals/net_internals_ui.cc',
      'browser/ui/webui/net_internals/net_internals_ui.h',
      'browser/ui/webui/ntp/ntp_user_data_logger.cc',
      'browser/ui/webui/ntp/ntp_user_data_logger.h',
      'browser/ui/webui/omnibox/omnibox_ui.cc',
      'browser/ui/webui/omnibox/omnibox_ui.h',
      'browser/ui/webui/omnibox/omnibox_ui_handler.cc',
      'browser/ui/webui/omnibox/omnibox_ui_handler.h',
      'browser/ui/webui/password_manager_internals/password_manager_internals_ui.cc',
      'browser/ui/webui/password_manager_internals/password_manager_internals_ui.h',
      'browser/ui/webui/predictors/predictors_handler.cc',
      'browser/ui/webui/predictors/predictors_handler.h',
      'browser/ui/webui/predictors/predictors_ui.cc',
      'browser/ui/webui/predictors/predictors_ui.h',
      'browser/ui/webui/profiler_ui.cc',
      'browser/ui/webui/profiler_ui.h',
      'browser/ui/webui/signin_internals_ui.cc',
      'browser/ui/webui/signin_internals_ui.h',
      'browser/ui/webui/supervised_user_internals_message_handler.cc',
      'browser/ui/webui/supervised_user_internals_message_handler.h',
      'browser/ui/webui/supervised_user_internals_ui.cc',
      'browser/ui/webui/supervised_user_internals_ui.h',
      'browser/ui/webui/sync_internals_message_handler.cc',
      'browser/ui/webui/sync_internals_message_handler.h',
      'browser/ui/webui/sync_internals_ui.cc',
      'browser/ui/webui/sync_internals_ui.h',
      'browser/ui/webui/theme_source.cc',
      'browser/ui/webui/theme_source.h',
      'browser/ui/webui/translate_internals/translate_internals_handler.cc',
      'browser/ui/webui/translate_internals/translate_internals_handler.h',
      'browser/ui/webui/translate_internals/translate_internals_ui.cc',
      'browser/ui/webui/translate_internals/translate_internals_ui.h',
      'browser/ui/webui/user_actions/user_actions_ui.cc',
      'browser/ui/webui/user_actions/user_actions_ui.h',
      'browser/ui/webui/user_actions/user_actions_ui_handler.cc',
      'browser/ui/webui/user_actions/user_actions_ui_handler.h',
      'browser/ui/webui/version_handler.cc',
      'browser/ui/webui/version_handler.h',
      'browser/ui/webui/version_handler_chromeos.cc',
      'browser/ui/webui/version_handler_chromeos.h',
      'browser/ui/webui/version_ui.cc',
      'browser/ui/webui/version_ui.h',
      'browser/ui/window_sizer/window_sizer_mac.mm',
      'browser/ui/zoom/chrome_zoom_level_otr_delegate.cc',
      'browser/ui/zoom/chrome_zoom_level_otr_delegate.h',
      'browser/ui/zoom/chrome_zoom_level_prefs.cc',
      'browser/ui/zoom/chrome_zoom_level_prefs.h',
    ],
    'chrome_browser_ui_android_non_aura_sources': [
      'browser/ui/android/autofill/autofill_dialog_controller_android.cc',
      'browser/ui/android/autofill/autofill_dialog_controller_android.h',
      'browser/ui/android/autofill/autofill_dialog_result.cc',
      'browser/ui/android/autofill/autofill_dialog_result.h',
      'browser/ui/android/autofill/autofill_keyboard_accessory_view.cc',
      'browser/ui/android/autofill/autofill_keyboard_accessory_view.h',
      'browser/ui/android/autofill/autofill_logger_android.cc',
      'browser/ui/android/autofill/autofill_logger_android.h',
      'browser/ui/android/autofill/autofill_popup_view_android.cc',
      'browser/ui/android/autofill/autofill_popup_view_android.h',
      'browser/ui/android/autofill/card_unmask_prompt_view_android.cc',
      'browser/ui/android/autofill/card_unmask_prompt_view_android.h',
      'browser/ui/android/autofill/credit_card_scanner_view_android.cc',
      'browser/ui/android/autofill/credit_card_scanner_view_android.h',
      'browser/ui/android/autofill/password_generation_popup_view_android.cc',
      'browser/ui/android/autofill/password_generation_popup_view_android.h',
      'browser/ui/android/bluetooth_chooser_android.cc',
      'browser/ui/android/bluetooth_chooser_android.h',
      'browser/ui/android/certificate_viewer_android.cc',
      'browser/ui/android/certificate_viewer_android.h',
      'browser/ui/android/chrome_http_auth_handler.cc',
      'browser/ui/android/chrome_http_auth_handler.h',
      'browser/ui/android/color_chooser_dialog_android.cc',
      'browser/ui/android/connection_info_popup_android.cc',
      'browser/ui/android/connection_info_popup_android.h',
      'browser/ui/android/content_settings/popup_blocked_infobar_delegate.cc',
      'browser/ui/android/content_settings/popup_blocked_infobar_delegate.h',
      'browser/ui/android/context_menu_helper.cc',
      'browser/ui/android/context_menu_helper.h',
      'browser/ui/android/infobars/app_banner_infobar_android.cc',
      'browser/ui/android/infobars/app_banner_infobar_android.h',
      'browser/ui/android/infobars/auto_signin_first_run_infobar.cc',
      'browser/ui/android/infobars/auto_signin_first_run_infobar.h',
      'browser/ui/android/infobars/confirm_infobar.cc',
      'browser/ui/android/infobars/confirm_infobar.h',
      'browser/ui/android/infobars/data_reduction_proxy_infobar.cc',
      'browser/ui/android/infobars/data_reduction_proxy_infobar.h',
      'browser/ui/android/infobars/download_overwrite_infobar.cc',
      'browser/ui/android/infobars/download_overwrite_infobar.h',
      'browser/ui/android/infobars/generated_password_saved_infobar.cc',
      'browser/ui/android/infobars/generated_password_saved_infobar.h',
      'browser/ui/android/infobars/infobar_android.cc',
      'browser/ui/android/infobars/infobar_android.h',
      'browser/ui/android/infobars/infobar_container_android.cc',
      'browser/ui/android/infobars/infobar_container_android.h',
      'browser/ui/android/infobars/save_password_infobar.cc',
      'browser/ui/android/infobars/save_password_infobar.h',
      'browser/ui/android/infobars/translate_infobar.cc',
      'browser/ui/android/infobars/translate_infobar.h',
      'browser/ui/android/javascript_app_modal_dialog_android.cc',
      'browser/ui/android/login_prompt_android.cc',
      'browser/ui/android/omnibox/omnibox_url_emphasizer.cc',
      'browser/ui/android/omnibox/omnibox_url_emphasizer.h',
      'browser/ui/android/omnibox/omnibox_view_util.cc',
      'browser/ui/android/omnibox/omnibox_view_util.h',
      'browser/ui/android/simple_message_box_android.cc',
      'browser/ui/android/snackbars/auto_signin_prompt_controller.cc',
      'browser/ui/android/snackbars/auto_signin_prompt_controller.h',
      'browser/ui/android/ssl_client_certificate_request.cc',
      'browser/ui/android/ssl_client_certificate_request.h',
      'browser/ui/android/tab_contents/chrome_web_contents_view_delegate_android.cc',
      'browser/ui/android/tab_contents/chrome_web_contents_view_delegate_android.h',
      'browser/ui/android/tab_model/single_tab_model.cc',
      'browser/ui/android/tab_model/single_tab_model.h',
      'browser/ui/android/tab_model/tab_model.cc',
      'browser/ui/android/tab_model/tab_model.h',
      'browser/ui/android/tab_model/tab_model_jni_bridge.cc',
      'browser/ui/android/tab_model/tab_model_jni_bridge.h',
      'browser/ui/android/website_settings_popup_android.cc',
      'browser/ui/android/website_settings_popup_android.h',
      'browser/ui/android/window_android_helper.cc',
      'browser/ui/android/window_android_helper.h',
      'browser/ui/browser_otr_state_android.cc',
      'browser/ui/screen_capture_notification_ui_stub.cc',
      'browser/ui/webui/popular_sites_internals_message_handler.cc',
      'browser/ui/webui/popular_sites_internals_message_handler.h',
      'browser/ui/webui/popular_sites_internals_ui.cc',
      'browser/ui/webui/popular_sites_internals_ui.h',
    ],
    # Cross-platform ash sources.
    'chrome_browser_ui_ash_sources': [
      'browser/ui/ash/app_list/app_list_controller_ash.cc',
      'browser/ui/ash/app_list/app_list_controller_ash.h',
      'browser/ui/ash/app_list/app_list_service_ash.cc',
      'browser/ui/ash/app_list/app_list_service_ash.h',
      'browser/ui/ash/app_list/app_sync_ui_state_watcher.cc',
      'browser/ui/ash/app_list/app_sync_ui_state_watcher.h',
      'browser/ui/ash/app_sync_ui_state.cc',
      'browser/ui/ash/app_sync_ui_state.h',
      'browser/ui/ash/app_sync_ui_state_factory.cc',
      'browser/ui/ash/app_sync_ui_state_factory.h',
      'browser/ui/ash/app_sync_ui_state_observer.h',
      'browser/ui/ash/ash_init.cc',
      'browser/ui/ash/ash_init.h',
      'browser/ui/ash/ash_util.cc',
      'browser/ui/ash/ash_util.h',
      'browser/ui/ash/cast_config_delegate_chromeos.cc',
      'browser/ui/ash/cast_config_delegate_chromeos.h',
      'browser/ui/ash/chrome_keyboard_ui.cc',
      'browser/ui/ash/chrome_keyboard_ui.h',
      'browser/ui/ash/chrome_launcher_prefs.cc',
      'browser/ui/ash/chrome_launcher_prefs.h',
      'browser/ui/ash/chrome_new_window_delegate.cc',
      'browser/ui/ash/chrome_new_window_delegate.h',
      'browser/ui/ash/chrome_new_window_delegate_chromeos.cc',
      'browser/ui/ash/chrome_new_window_delegate_chromeos.h',
      'browser/ui/ash/chrome_screenshot_grabber.cc',
      'browser/ui/ash/chrome_screenshot_grabber.h',
      'browser/ui/ash/chrome_shell_content_state.cc',
      'browser/ui/ash/chrome_shell_content_state.h',
      'browser/ui/ash/chrome_shell_content_state_chromeos.cc',
      'browser/ui/ash/chrome_shell_delegate.cc',
      'browser/ui/ash/chrome_shell_delegate.h',
      'browser/ui/ash/chrome_shell_delegate_chromeos.cc',
      'browser/ui/ash/ime_controller_chromeos.cc',
      'browser/ui/ash/ime_controller_chromeos.h',
      'browser/ui/ash/launcher/app_shortcut_launcher_item_controller.cc',
      'browser/ui/ash/launcher/app_shortcut_launcher_item_controller.h',
      'browser/ui/ash/launcher/app_window_launcher_controller.cc',
      'browser/ui/ash/launcher/app_window_launcher_controller.h',
      'browser/ui/ash/launcher/app_window_launcher_item_controller.cc',
      'browser/ui/ash/launcher/app_window_launcher_item_controller.h',
      'browser/ui/ash/launcher/browser_shortcut_launcher_item_controller.cc',
      'browser/ui/ash/launcher/browser_shortcut_launcher_item_controller.h',
      'browser/ui/ash/launcher/browser_status_monitor.cc',
      'browser/ui/ash/launcher/browser_status_monitor.h',
      'browser/ui/ash/launcher/chrome_launcher_app_menu_item.cc',
      'browser/ui/ash/launcher/chrome_launcher_app_menu_item.h',
      'browser/ui/ash/launcher/chrome_launcher_app_menu_item_browser.cc',
      'browser/ui/ash/launcher/chrome_launcher_app_menu_item_browser.h',
      'browser/ui/ash/launcher/chrome_launcher_app_menu_item_tab.cc',
      'browser/ui/ash/launcher/chrome_launcher_app_menu_item_tab.h',
      'browser/ui/ash/launcher/chrome_launcher_app_menu_item_v2app.cc',
      'browser/ui/ash/launcher/chrome_launcher_app_menu_item_v2app.h',
      'browser/ui/ash/launcher/chrome_launcher_controller.cc',
      'browser/ui/ash/launcher/chrome_launcher_controller.h',
      'browser/ui/ash/launcher/chrome_launcher_controller_chromeos.cc',
      'browser/ui/ash/launcher/chrome_launcher_controller_win.cc',
      'browser/ui/ash/launcher/launcher_app_tab_helper.cc',
      'browser/ui/ash/launcher/launcher_app_tab_helper.h',
      'browser/ui/ash/launcher/launcher_application_menu_item_model.cc',
      'browser/ui/ash/launcher/launcher_application_menu_item_model.h',
      'browser/ui/ash/launcher/launcher_context_menu.cc',
      'browser/ui/ash/launcher/launcher_context_menu.h',
      'browser/ui/ash/launcher/launcher_favicon_loader.cc',
      'browser/ui/ash/launcher/launcher_favicon_loader.h',
      'browser/ui/ash/launcher/launcher_item_controller.cc',
      'browser/ui/ash/launcher/launcher_item_controller.h',
      'browser/ui/ash/launcher/multi_profile_app_window_launcher_controller.cc',
      'browser/ui/ash/launcher/multi_profile_app_window_launcher_controller.h',
      'browser/ui/ash/launcher/multi_profile_browser_status_monitor.cc',
      'browser/ui/ash/launcher/multi_profile_browser_status_monitor.h',
      'browser/ui/ash/media_delegate_chromeos.cc',
      'browser/ui/ash/media_delegate_chromeos.h',
      'browser/ui/ash/metrics/chrome_user_metrics_recorder.cc',
      'browser/ui/ash/metrics/chrome_user_metrics_recorder.h',
      'browser/ui/ash/multi_user/multi_user_context_menu_chromeos.cc',
      'browser/ui/ash/multi_user/multi_user_notification_blocker_chromeos.cc',
      'browser/ui/ash/multi_user/multi_user_notification_blocker_chromeos.h',
      'browser/ui/ash/multi_user/multi_user_util.cc',
      'browser/ui/ash/multi_user/multi_user_util.h',
      'browser/ui/ash/multi_user/multi_user_warning_dialog.cc',
      'browser/ui/ash/multi_user/multi_user_warning_dialog.h',
      'browser/ui/ash/multi_user/multi_user_window_manager.cc',
      'browser/ui/ash/multi_user/multi_user_window_manager.h',
      'browser/ui/ash/multi_user/multi_user_window_manager_chromeos.cc',
      'browser/ui/ash/multi_user/multi_user_window_manager_chromeos.h',
      'browser/ui/ash/multi_user/multi_user_window_manager_stub.cc',
      'browser/ui/ash/multi_user/multi_user_window_manager_stub.h',
      'browser/ui/ash/multi_user/user_switch_animator_chromeos.cc',
      'browser/ui/ash/multi_user/user_switch_animator_chromeos.h',
      'browser/ui/ash/network_connect_delegate_chromeos.cc',
      'browser/ui/ash/network_connect_delegate_chromeos.h',
      'browser/ui/ash/networking_config_delegate_chromeos.cc',
      'browser/ui/ash/networking_config_delegate_chromeos.h',
      'browser/ui/ash/session_state_delegate_chromeos.cc',
      'browser/ui/ash/session_state_delegate_chromeos.h',
      'browser/ui/ash/session_util.cc',
      'browser/ui/ash/session_util.h',
      'browser/ui/ash/solid_color_user_wallpaper_delegate.cc',
      'browser/ui/ash/solid_color_user_wallpaper_delegate.h',
      'browser/ui/ash/system_tray_delegate_chromeos.cc',
      'browser/ui/ash/system_tray_delegate_chromeos.h',
      'browser/ui/ash/system_tray_delegate_common.cc',
      'browser/ui/ash/system_tray_delegate_common.h',
      'browser/ui/ash/system_tray_delegate_utils.cc',
      'browser/ui/ash/system_tray_delegate_utils.h',
      'browser/ui/ash/user_accounts_delegate_chromeos.cc',
      'browser/ui/ash/user_accounts_delegate_chromeos.h',
      'browser/ui/ash/volume_controller_chromeos.cc',
      'browser/ui/ash/volume_controller_chromeos.h',
      'browser/ui/ash/vpn_delegate_chromeos.cc',
      'browser/ui/ash/vpn_delegate_chromeos.h',
      'browser/ui/views/ash/chrome_browser_main_extra_parts_ash.cc',
      'browser/ui/views/ash/chrome_browser_main_extra_parts_ash.h',
      'browser/ui/views/touch_uma/touch_uma_ash.cc',
      'browser/ui/window_sizer/window_sizer_ash.cc',
    ],
    # Used when Ash is enabled but not ChromeOS.
    'chrome_browser_ui_ash_non_chromeos': [
      'browser/ui/ash/chrome_shell_content_state_views.cc',
      'browser/ui/ash/chrome_shell_delegate_views.cc',
      'browser/ui/ash/multi_user/multi_user_context_menu.cc',
      'browser/ui/ash/multi_user/multi_user_context_menu.h',
      'browser/ui/ash/session_state_delegate_views.cc',
      'browser/ui/ash/session_state_delegate_views.h',
    ],
    # Ash + Views.
    'chrome_browser_ui_ash_views_sources': [
      'browser/ui/views/frame/browser_frame_ash.cc',
      'browser/ui/views/frame/browser_frame_ash.h',
      'browser/ui/views/frame/browser_header_painter_ash.cc',
      'browser/ui/views/frame/browser_header_painter_ash.h',
      'browser/ui/views/frame/browser_non_client_frame_view_ash.cc',
      'browser/ui/views/frame/browser_non_client_frame_view_ash.h',
      'browser/ui/views/frame/immersive_mode_controller_ash.cc',
      'browser/ui/views/frame/immersive_mode_controller_ash.h',
      'browser/ui/views/frame/web_app_left_header_view_ash.cc',
      'browser/ui/views/frame/web_app_left_header_view_ash.h',
      'browser/ui/views/tabs/window_finder_ash.cc',
      'browser/ui/views/tabs/window_finder_impl.h',
      'browser/ui/views/tabs/window_finder_impl.cc',
    ],
    # Used when Android + Views.
    'chrome_browser_ui_views_android_sources': [
      'browser/ui/views/tabs/window_finder_android.cc',
      'browser/ui/views/tabs/window_finder_impl.h',
      'browser/ui/views/tabs/window_finder_impl.cc',
    ],
    # Used when ash is disabled.
    'chrome_browser_ui_non_ash_sources': [
      'browser/ui/views/touch_uma/touch_uma.cc',
    ],
    # Cross-platform aura sources.
    'chrome_browser_ui_aura_sources': [
      'browser/ui/aura/accessibility/automation_manager_aura.cc',
      'browser/ui/aura/accessibility/automation_manager_aura.h',
      'browser/ui/aura/accessibility/ax_root_obj_wrapper.cc',
      'browser/ui/aura/accessibility/ax_root_obj_wrapper.h',
      'browser/ui/aura/accessibility/ax_tree_source_aura.cc',
      'browser/ui/aura/accessibility/ax_tree_source_aura.h',
      'browser/ui/aura/chrome_browser_main_extra_parts_aura.cc',
      'browser/ui/aura/chrome_browser_main_extra_parts_aura.h',
      'browser/ui/aura/native_window_tracker_aura.cc',
      'browser/ui/aura/native_window_tracker_aura.h',
      'browser/ui/aura/tab_contents/web_drag_bookmark_handler_aura.cc',
      'browser/ui/aura/tab_contents/web_drag_bookmark_handler_aura.h',
      'browser/ui/gesture_prefs_observer_factory_aura.cc',
      'browser/ui/gesture_prefs_observer_factory_aura.h',
      'browser/ui/views/crypto_module_password_dialog_view.cc',
      'browser/ui/views/crypto_module_password_dialog_view.h',
      'browser/ui/views/desktop_media_picker_views.cc',
      'browser/ui/views/desktop_media_picker_views.h',
      'browser/ui/views/link_disambiguation/link_disambiguation_popup.cc',
      'browser/ui/views/link_disambiguation/link_disambiguation_popup.h',
      'browser/ui/views/renderer_context_menu/render_view_context_menu_views.cc',
      'browser/ui/views/renderer_context_menu/render_view_context_menu_views.h',
      'browser/ui/views/tab_contents/chrome_web_contents_view_delegate_views.cc',
      'browser/ui/views/tab_contents/chrome_web_contents_view_delegate_views.h',
      'browser/ui/webui/gesture_config_ui.cc',
      'browser/ui/webui/gesture_config_ui.h',
      'browser/ui/window_sizer/window_sizer_aura.cc',
    ],
    # Aura but not ChromeOS.
    'chrome_browser_ui_aura_non_chromeos': [
      'browser/ui/aura/active_desktop_monitor.cc',
      'browser/ui/aura/active_desktop_monitor.h',
      'browser/ui/views/chrome_views_delegate_aura.cc',
      'browser/ui/views/frame/desktop_browser_frame_aura.cc',
      'browser/ui/views/frame/desktop_browser_frame_aura.h',
      'browser/ui/views/message_center/message_center_frame_view.cc',
      'browser/ui/views/message_center/message_center_frame_view.h',
      'browser/ui/views/message_center/web_notification_tray.cc',
      'browser/ui/views/message_center/web_notification_tray.h',
    ],
    # ChromeOS-only sources that don't end in _chromeos or live in a chromeos
    # directory.
    'chrome_browser_ui_chromeos_sources': [
      'browser/ui/app_list/search/launcher_search/launcher_search_icon_image_loader.cc',
      'browser/ui/app_list/search/launcher_search/launcher_search_icon_image_loader.h',
      'browser/ui/app_list/search/launcher_search/launcher_search_icon_image_loader_impl.cc',
      'browser/ui/app_list/search/launcher_search/launcher_search_icon_image_loader_impl.h',
      'browser/ui/app_list/search/launcher_search/launcher_search_provider.cc',
      'browser/ui/app_list/search/launcher_search/launcher_search_provider.h',
      'browser/ui/app_list/search/launcher_search/launcher_search_result.cc',
      'browser/ui/app_list/search/launcher_search/launcher_search_result.h',
      # On chromeos, file manager extension handles the file open/save dialog.
      'browser/ui/views/select_file_dialog_extension.cc',
      'browser/ui/views/select_file_dialog_extension.h',
      'browser/ui/views/select_file_dialog_extension_factory.cc',
      'browser/ui/views/select_file_dialog_extension_factory.h',
    ],
    # ChromeOS sources that should not be included in the official build.
    'chrome_browser_ui_chromeos_non_official_sources': [
      'browser/ui/webui/chromeos/emulator/device_emulator_message_handler.cc',
      'browser/ui/webui/chromeos/emulator/device_emulator_message_handler.h',
      'browser/ui/webui/chromeos/emulator/device_emulator_ui.cc',
      'browser/ui/webui/chromeos/emulator/device_emulator_ui.h',
    ],
    # Mac sources, except when mac_views_browser==1
    'chrome_browser_ui_cocoa_sources': [
      'browser/ui/cocoa/animatable_image.h',
      'browser/ui/cocoa/animatable_image.mm',
      'browser/ui/cocoa/animatable_view.h',
      'browser/ui/cocoa/animatable_view.mm',
      'browser/ui/cocoa/applescript/apple_event_util.h',
      'browser/ui/cocoa/applescript/apple_event_util.mm',
      'browser/ui/cocoa/applescript/bookmark_folder_applescript.h',
      'browser/ui/cocoa/applescript/bookmark_folder_applescript.mm',
      'browser/ui/cocoa/applescript/bookmark_item_applescript.h',
      'browser/ui/cocoa/applescript/bookmark_item_applescript.mm',
      'browser/ui/cocoa/applescript/bookmark_node_applescript.h',
      'browser/ui/cocoa/applescript/bookmark_node_applescript.mm',
      'browser/ui/cocoa/applescript/browsercrapplication+applescript.h',
      'browser/ui/cocoa/applescript/browsercrapplication+applescript.mm',
      'browser/ui/cocoa/applescript/constants_applescript.h',
      'browser/ui/cocoa/applescript/constants_applescript.mm',
      'browser/ui/cocoa/applescript/element_applescript.h',
      'browser/ui/cocoa/applescript/element_applescript.mm',
      'browser/ui/cocoa/applescript/error_applescript.h',
      'browser/ui/cocoa/applescript/error_applescript.mm',
      'browser/ui/cocoa/applescript/metrics_applescript.h',
      'browser/ui/cocoa/applescript/metrics_applescript.mm',
      'browser/ui/cocoa/applescript/tab_applescript.h',
      'browser/ui/cocoa/applescript/tab_applescript.mm',
      'browser/ui/cocoa/applescript/window_applescript.h',
      'browser/ui/cocoa/applescript/window_applescript.mm',
      'browser/ui/cocoa/apps/chrome_app_window_client_views_cocoa.mm',
      'browser/ui/cocoa/apps/native_app_window_cocoa.h',
      'browser/ui/cocoa/apps/native_app_window_cocoa.mm',
      'browser/ui/cocoa/autofill/autofill_bubble_controller.h',
      'browser/ui/cocoa/autofill/autofill_bubble_controller.mm',
      'browser/ui/cocoa/autofill/autofill_details_container.h',
      'browser/ui/cocoa/autofill/autofill_details_container.mm',
      'browser/ui/cocoa/autofill/autofill_dialog_cocoa.h',
      'browser/ui/cocoa/autofill/autofill_dialog_cocoa.mm',
      'browser/ui/cocoa/autofill/autofill_dialog_constants.h',
      'browser/ui/cocoa/autofill/autofill_dialog_window_controller.h',
      'browser/ui/cocoa/autofill/autofill_dialog_window_controller.mm',
      'browser/ui/cocoa/autofill/autofill_header.h',
      'browser/ui/cocoa/autofill/autofill_header.mm',
      'browser/ui/cocoa/autofill/autofill_layout.h',
      'browser/ui/cocoa/autofill/autofill_main_container.h',
      'browser/ui/cocoa/autofill/autofill_main_container.mm',
      'browser/ui/cocoa/autofill/autofill_notification_container.h',
      'browser/ui/cocoa/autofill/autofill_notification_container.mm',
      'browser/ui/cocoa/autofill/autofill_notification_controller.h',
      'browser/ui/cocoa/autofill/autofill_notification_controller.mm',
      'browser/ui/cocoa/autofill/autofill_pop_up_button.h',
      'browser/ui/cocoa/autofill/autofill_pop_up_button.mm',
      'browser/ui/cocoa/autofill/autofill_popup_base_view_cocoa.h',
      'browser/ui/cocoa/autofill/autofill_popup_base_view_cocoa.mm',
      'browser/ui/cocoa/autofill/autofill_popup_view_bridge.h',
      'browser/ui/cocoa/autofill/autofill_popup_view_bridge.mm',
      'browser/ui/cocoa/autofill/autofill_popup_view_cocoa.h',
      'browser/ui/cocoa/autofill/autofill_popup_view_cocoa.mm',
      'browser/ui/cocoa/autofill/autofill_section_container.h',
      'browser/ui/cocoa/autofill/autofill_section_container.mm',
      'browser/ui/cocoa/autofill/autofill_section_view.h',
      'browser/ui/cocoa/autofill/autofill_section_view.mm',
      'browser/ui/cocoa/autofill/autofill_suggestion_container.h',
      'browser/ui/cocoa/autofill/autofill_suggestion_container.mm',
      'browser/ui/cocoa/autofill/autofill_textfield.h',
      'browser/ui/cocoa/autofill/autofill_textfield.mm',
      'browser/ui/cocoa/autofill/autofill_tooltip_controller.h',
      'browser/ui/cocoa/autofill/autofill_tooltip_controller.mm',
      'browser/ui/cocoa/autofill/card_unmask_prompt_view_bridge.h',
      'browser/ui/cocoa/autofill/card_unmask_prompt_view_bridge.mm',
      'browser/ui/cocoa/autofill/down_arrow_popup_menu_cell.h',
      'browser/ui/cocoa/autofill/down_arrow_popup_menu_cell.mm',
      'browser/ui/cocoa/autofill/layout_view.h',
      'browser/ui/cocoa/autofill/layout_view.mm',
      'browser/ui/cocoa/autofill/new_credit_card_bubble_cocoa.h',
      'browser/ui/cocoa/autofill/new_credit_card_bubble_cocoa.mm',
      'browser/ui/cocoa/autofill/password_generation_popup_view_bridge.h',
      'browser/ui/cocoa/autofill/password_generation_popup_view_bridge.mm',
      'browser/ui/cocoa/autofill/password_generation_popup_view_cocoa.h',
      'browser/ui/cocoa/autofill/password_generation_popup_view_cocoa.mm',
      'browser/ui/cocoa/autofill/simple_grid_layout.h',
      'browser/ui/cocoa/autofill/simple_grid_layout.mm',
      'browser/ui/cocoa/background_gradient_view.h',
      'browser/ui/cocoa/background_gradient_view.mm',
      'browser/ui/cocoa/base_bubble_controller.h',
      'browser/ui/cocoa/base_bubble_controller.mm',
      'browser/ui/cocoa/bookmarks/bookmark_all_tabs_controller.h',
      'browser/ui/cocoa/bookmarks/bookmark_all_tabs_controller.mm',
      'browser/ui/cocoa/bookmarks/bookmark_bar_bridge.h',
      'browser/ui/cocoa/bookmarks/bookmark_bar_bridge.mm',
      'browser/ui/cocoa/bookmarks/bookmark_bar_constants.h',
      'browser/ui/cocoa/bookmarks/bookmark_bar_controller.h',
      'browser/ui/cocoa/bookmarks/bookmark_bar_controller.mm',
      'browser/ui/cocoa/bookmarks/bookmark_bar_folder_button_cell.h',
      'browser/ui/cocoa/bookmarks/bookmark_bar_folder_button_cell.mm',
      'browser/ui/cocoa/bookmarks/bookmark_bar_folder_controller.h',
      'browser/ui/cocoa/bookmarks/bookmark_bar_folder_controller.mm',
      'browser/ui/cocoa/bookmarks/bookmark_bar_folder_hover_state.h',
      'browser/ui/cocoa/bookmarks/bookmark_bar_folder_hover_state.mm',
      'browser/ui/cocoa/bookmarks/bookmark_bar_folder_view.h',
      'browser/ui/cocoa/bookmarks/bookmark_bar_folder_view.mm',
      'browser/ui/cocoa/bookmarks/bookmark_bar_folder_window.h',
      'browser/ui/cocoa/bookmarks/bookmark_bar_folder_window.mm',
      'browser/ui/cocoa/bookmarks/bookmark_bar_state.h',
      'browser/ui/cocoa/bookmarks/bookmark_bar_toolbar_view.h',
      'browser/ui/cocoa/bookmarks/bookmark_bar_toolbar_view.mm',
      'browser/ui/cocoa/bookmarks/bookmark_bar_view_cocoa.h',
      'browser/ui/cocoa/bookmarks/bookmark_bar_view_cocoa.mm',
      'browser/ui/cocoa/bookmarks/bookmark_bubble_controller.h',
      'browser/ui/cocoa/bookmarks/bookmark_bubble_controller.mm',
      'browser/ui/cocoa/bookmarks/bookmark_bubble_observer_cocoa.h',
      'browser/ui/cocoa/bookmarks/bookmark_bubble_observer_cocoa.mm',
      'browser/ui/cocoa/bookmarks/bookmark_button.h',
      'browser/ui/cocoa/bookmarks/bookmark_button.mm',
      'browser/ui/cocoa/bookmarks/bookmark_button_cell.h',
      'browser/ui/cocoa/bookmarks/bookmark_button_cell.mm',
      'browser/ui/cocoa/bookmarks/bookmark_context_menu_cocoa_controller.h',
      'browser/ui/cocoa/bookmarks/bookmark_context_menu_cocoa_controller.mm',
      'browser/ui/cocoa/bookmarks/bookmark_drag_drop_cocoa.mm',
      'browser/ui/cocoa/bookmarks/bookmark_editor_base_controller.h',
      'browser/ui/cocoa/bookmarks/bookmark_editor_base_controller.mm',
      'browser/ui/cocoa/bookmarks/bookmark_editor_controller.h',
      'browser/ui/cocoa/bookmarks/bookmark_editor_controller.mm',
      'browser/ui/cocoa/bookmarks/bookmark_folder_target.h',
      'browser/ui/cocoa/bookmarks/bookmark_folder_target.mm',
      'browser/ui/cocoa/bookmarks/bookmark_model_observer_for_cocoa.h',
      'browser/ui/cocoa/bookmarks/bookmark_model_observer_for_cocoa.mm',
      'browser/ui/cocoa/bookmarks/bookmark_name_folder_controller.h',
      'browser/ui/cocoa/bookmarks/bookmark_name_folder_controller.mm',
      'browser/ui/cocoa/bookmarks/bookmark_sync_promo_controller.h',
      'browser/ui/cocoa/bookmarks/bookmark_sync_promo_controller.mm',
      'browser/ui/cocoa/bookmarks/bookmark_tree_browser_cell.h',
      'browser/ui/cocoa/bookmarks/bookmark_tree_browser_cell.mm',
      'browser/ui/cocoa/browser/edit_search_engine_cocoa_controller.h',
      'browser/ui/cocoa/browser/edit_search_engine_cocoa_controller.mm',
      'browser/ui/cocoa/browser/zoom_bubble_controller.h',
      'browser/ui/cocoa/browser/zoom_bubble_controller.mm',
      'browser/ui/cocoa/browser_window_cocoa.h',
      'browser/ui/cocoa/browser_window_cocoa.mm',
      'browser/ui/cocoa/browser_window_controller.h',
      'browser/ui/cocoa/browser_window_controller.mm',
      'browser/ui/cocoa/browser_window_controller_private.h',
      'browser/ui/cocoa/browser_window_controller_private.mm',
      'browser/ui/cocoa/browser_window_factory_cocoa.mm',
      'browser/ui/cocoa/browser_window_fullscreen_transition.h',
      'browser/ui/cocoa/browser_window_fullscreen_transition.mm',
      'browser/ui/cocoa/browser_window_layout.h',
      'browser/ui/cocoa/browser_window_layout.mm',
      'browser/ui/cocoa/browser_window_utils.h',
      'browser/ui/cocoa/browser_window_utils.mm',
      'browser/ui/cocoa/bubble_combobox.h',
      'browser/ui/cocoa/bubble_combobox.mm',
      'browser/ui/cocoa/bubble_view.h',
      'browser/ui/cocoa/bubble_view.mm',
      'browser/ui/cocoa/chrome_browser_window.h',
      'browser/ui/cocoa/chrome_browser_window.mm',
      'browser/ui/cocoa/chrome_event_processing_window.h',
      'browser/ui/cocoa/chrome_event_processing_window.mm',
      'browser/ui/cocoa/clickhold_button_cell.h',
      'browser/ui/cocoa/clickhold_button_cell.mm',
      'browser/ui/cocoa/confirm_bubble_cocoa.h',
      'browser/ui/cocoa/confirm_bubble_cocoa.mm',
      'browser/ui/cocoa/confirm_bubble_controller.h',
      'browser/ui/cocoa/confirm_bubble_controller.mm',
      'browser/ui/cocoa/constrained_web_dialog_delegate_mac.mm',
      'browser/ui/cocoa/constrained_window/constrained_window_alert.h',
      'browser/ui/cocoa/constrained_window/constrained_window_alert.mm',
      'browser/ui/cocoa/constrained_window/constrained_window_button.h',
      'browser/ui/cocoa/constrained_window/constrained_window_button.mm',
      'browser/ui/cocoa/constrained_window/constrained_window_control_utils.h',
      'browser/ui/cocoa/constrained_window/constrained_window_control_utils.mm',
      'browser/ui/cocoa/constrained_window/constrained_window_custom_sheet.h',
      'browser/ui/cocoa/constrained_window/constrained_window_custom_sheet.mm',
      'browser/ui/cocoa/constrained_window/constrained_window_custom_window.h',
      'browser/ui/cocoa/constrained_window/constrained_window_custom_window.mm',
      'browser/ui/cocoa/constrained_window/constrained_window_web_dialog_sheet.h',
      'browser/ui/cocoa/constrained_window/constrained_window_web_dialog_sheet.mm',
      'browser/ui/cocoa/content_settings/collected_cookies_mac.h',
      'browser/ui/cocoa/content_settings/collected_cookies_mac.mm',
      'browser/ui/cocoa/content_settings/content_setting_bubble_cocoa.h',
      'browser/ui/cocoa/content_settings/content_setting_bubble_cocoa.mm',
      'browser/ui/cocoa/content_settings/cookie_details.h',
      'browser/ui/cocoa/content_settings/cookie_details.mm',
      'browser/ui/cocoa/content_settings/cookie_details_view_controller.h',
      'browser/ui/cocoa/content_settings/cookie_details_view_controller.mm',
      'browser/ui/cocoa/content_settings/cookie_tree_node.h',
      'browser/ui/cocoa/content_settings/cookie_tree_node.mm',
      'browser/ui/cocoa/content_settings/cookies_tree_controller_bridge.h',
      'browser/ui/cocoa/content_settings/cookies_tree_controller_bridge.mm',
      'browser/ui/cocoa/create_native_web_modal_manager_cocoa.mm',
      'browser/ui/cocoa/custom_frame_view.h',
      'browser/ui/cocoa/custom_frame_view.mm',
      'browser/ui/cocoa/dev_tools_controller.h',
      'browser/ui/cocoa/dev_tools_controller.mm',
      'browser/ui/cocoa/download/background_theme.h',
      'browser/ui/cocoa/download/background_theme.mm',
      'browser/ui/cocoa/download/download_item_button.h',
      'browser/ui/cocoa/download/download_item_button.mm',
      'browser/ui/cocoa/download/download_item_cell.h',
      'browser/ui/cocoa/download/download_item_cell.mm',
      'browser/ui/cocoa/download/download_item_controller.h',
      'browser/ui/cocoa/download/download_item_controller.mm',
      'browser/ui/cocoa/download/download_item_mac.h',
      'browser/ui/cocoa/download/download_item_mac.mm',
      'browser/ui/cocoa/download/download_shelf_context_menu_controller.h',
      'browser/ui/cocoa/download/download_shelf_context_menu_controller.mm',
      'browser/ui/cocoa/download/download_shelf_controller.h',
      'browser/ui/cocoa/download/download_shelf_controller.mm',
      'browser/ui/cocoa/download/download_shelf_mac.h',
      'browser/ui/cocoa/download/download_shelf_mac.mm',
      'browser/ui/cocoa/download/download_shelf_view_cocoa.h',
      'browser/ui/cocoa/download/download_shelf_view_cocoa.mm',
      'browser/ui/cocoa/download/download_show_all_button.h',
      'browser/ui/cocoa/download/download_show_all_button.mm',
      'browser/ui/cocoa/download/download_show_all_cell.h',
      'browser/ui/cocoa/download/download_show_all_cell.mm',
      'browser/ui/cocoa/download/download_started_animation_mac.mm',
      'browser/ui/cocoa/drag_util.h',
      'browser/ui/cocoa/drag_util.mm',
      'browser/ui/cocoa/draggable_button.h',
      'browser/ui/cocoa/draggable_button.mm',
      'browser/ui/cocoa/draggable_button_mixin.h',
      'browser/ui/cocoa/draggable_button_mixin.mm',
      'browser/ui/cocoa/exclusive_access_bubble_view.h',
      'browser/ui/cocoa/exclusive_access_bubble_view.mm',
      'browser/ui/cocoa/exclusive_access_bubble_window_controller.h',
      'browser/ui/cocoa/exclusive_access_bubble_window_controller.mm',
      'browser/ui/cocoa/extensions/browser_action_button.h',
      'browser/ui/cocoa/extensions/browser_action_button.mm',
      'browser/ui/cocoa/extensions/browser_actions_container_view.h',
      'browser/ui/cocoa/extensions/browser_actions_container_view.mm',
      'browser/ui/cocoa/extensions/browser_actions_controller.h',
      'browser/ui/cocoa/extensions/browser_actions_controller.mm',
      'browser/ui/cocoa/extensions/bundle_util.h',
      'browser/ui/cocoa/extensions/bundle_util.mm',
      'browser/ui/cocoa/extensions/device_permissions_dialog_controller.h',
      'browser/ui/cocoa/extensions/device_permissions_dialog_controller.mm',
      'browser/ui/cocoa/extensions/device_permissions_view_controller.h',
      'browser/ui/cocoa/extensions/device_permissions_view_controller.mm',
      'browser/ui/cocoa/extensions/extension_action_platform_delegate_cocoa.h',
      'browser/ui/cocoa/extensions/extension_action_platform_delegate_cocoa.mm',
      'browser/ui/cocoa/extensions/extension_install_dialog_controller.h',
      'browser/ui/cocoa/extensions/extension_install_dialog_controller.mm',
      'browser/ui/cocoa/extensions/extension_install_view_controller.h',
      'browser/ui/cocoa/extensions/extension_install_view_controller.mm',
      'browser/ui/cocoa/extensions/extension_installed_bubble_bridge.mm',
      'browser/ui/cocoa/extensions/extension_installed_bubble_controller.h',
      'browser/ui/cocoa/extensions/extension_installed_bubble_controller.mm',
      'browser/ui/cocoa/extensions/extension_keybinding_registry_cocoa.h',
      'browser/ui/cocoa/extensions/extension_keybinding_registry_cocoa.mm',
      'browser/ui/cocoa/extensions/extension_message_bubble_bridge.h',
      'browser/ui/cocoa/extensions/extension_message_bubble_bridge.mm',
      'browser/ui/cocoa/extensions/extension_popup_controller.h',
      'browser/ui/cocoa/extensions/extension_popup_controller.mm',
      'browser/ui/cocoa/extensions/extension_uninstall_dialog_cocoa.mm',
      'browser/ui/cocoa/extensions/extension_view_mac.h',
      'browser/ui/cocoa/extensions/extension_view_mac.mm',
      'browser/ui/cocoa/extensions/media_galleries_dialog_cocoa.h',
      'browser/ui/cocoa/extensions/media_galleries_dialog_cocoa.mm',
      'browser/ui/cocoa/extensions/media_gallery_list_entry_view.h',
      'browser/ui/cocoa/extensions/media_gallery_list_entry_view.mm',
      'browser/ui/cocoa/extensions/toolbar_actions_bar_bubble_mac.h',
      'browser/ui/cocoa/extensions/toolbar_actions_bar_bubble_mac.mm',
      'browser/ui/cocoa/extensions/windowed_install_dialog_controller.h',
      'browser/ui/cocoa/extensions/windowed_install_dialog_controller.mm',
      'browser/ui/cocoa/external_protocol_dialog.h',
      'browser/ui/cocoa/external_protocol_dialog.mm',
      'browser/ui/cocoa/fast_resize_view.h',
      'browser/ui/cocoa/fast_resize_view.mm',
      'browser/ui/cocoa/find_bar/find_bar_bridge.h',
      'browser/ui/cocoa/find_bar/find_bar_bridge.mm',
      'browser/ui/cocoa/find_bar/find_bar_cocoa_controller.h',
      'browser/ui/cocoa/find_bar/find_bar_cocoa_controller.mm',
      'browser/ui/cocoa/find_bar/find_bar_text_field.h',
      'browser/ui/cocoa/find_bar/find_bar_text_field.mm',
      'browser/ui/cocoa/find_bar/find_bar_text_field_cell.h',
      'browser/ui/cocoa/find_bar/find_bar_text_field_cell.mm',
      'browser/ui/cocoa/find_bar/find_bar_view_cocoa.h',
      'browser/ui/cocoa/find_bar/find_bar_view_cocoa.mm',
      'browser/ui/cocoa/first_run_bubble_controller.h',
      'browser/ui/cocoa/first_run_bubble_controller.mm',
      'browser/ui/cocoa/floating_bar_backing_view.h',
      'browser/ui/cocoa/floating_bar_backing_view.mm',
      'browser/ui/cocoa/framed_browser_window.h',
      'browser/ui/cocoa/framed_browser_window.mm',
      'browser/ui/cocoa/full_size_content_window.h',
      'browser/ui/cocoa/full_size_content_window.mm',
      'browser/ui/cocoa/fullscreen_window.h',
      'browser/ui/cocoa/fullscreen_window.mm',
      'browser/ui/cocoa/global_error_bubble_controller.h',
      'browser/ui/cocoa/global_error_bubble_controller.mm',
      'browser/ui/cocoa/gradient_button_cell.h',
      'browser/ui/cocoa/gradient_button_cell.mm',
      'browser/ui/cocoa/has_weak_browser_pointer.h',
      'browser/ui/cocoa/hover_close_button.h',
      'browser/ui/cocoa/hover_close_button.mm',
      'browser/ui/cocoa/hung_renderer_controller.h',
      'browser/ui/cocoa/hung_renderer_controller.mm',
      'browser/ui/cocoa/image_button_cell.h',
      'browser/ui/cocoa/image_button_cell.mm',
      'browser/ui/cocoa/importer/import_lock_dialog_cocoa.mm',
      'browser/ui/cocoa/info_bubble_view.h',
      'browser/ui/cocoa/info_bubble_view.mm',
      'browser/ui/cocoa/info_bubble_window.h',
      'browser/ui/cocoa/info_bubble_window.mm',
      'browser/ui/cocoa/infobars/after_translate_infobar_controller.h',
      'browser/ui/cocoa/infobars/after_translate_infobar_controller.mm',
      'browser/ui/cocoa/infobars/alternate_nav_infobar_controller.h',
      'browser/ui/cocoa/infobars/alternate_nav_infobar_controller.mm',
      'browser/ui/cocoa/infobars/before_translate_infobar_controller.h',
      'browser/ui/cocoa/infobars/before_translate_infobar_controller.mm',
      'browser/ui/cocoa/infobars/confirm_infobar_controller.h',
      'browser/ui/cocoa/infobars/confirm_infobar_controller.mm',
      'browser/ui/cocoa/infobars/infobar_cocoa.h',
      'browser/ui/cocoa/infobars/infobar_cocoa.mm',
      'browser/ui/cocoa/infobars/infobar_container_cocoa.h',
      'browser/ui/cocoa/infobars/infobar_container_cocoa.mm',
      'browser/ui/cocoa/infobars/infobar_container_controller.h',
      'browser/ui/cocoa/infobars/infobar_container_controller.mm',
      'browser/ui/cocoa/infobars/infobar_controller.h',
      'browser/ui/cocoa/infobars/infobar_controller.mm',
      'browser/ui/cocoa/infobars/infobar_gradient_view.h',
      'browser/ui/cocoa/infobars/infobar_gradient_view.mm',
      'browser/ui/cocoa/infobars/infobar_utilities.h',
      'browser/ui/cocoa/infobars/infobar_utilities.mm',
      'browser/ui/cocoa/infobars/save_password_infobar_controller.mm',
      'browser/ui/cocoa/infobars/translate_infobar_base.h',
      'browser/ui/cocoa/infobars/translate_infobar_base.mm',
      'browser/ui/cocoa/infobars/translate_message_infobar_controller.h',
      'browser/ui/cocoa/infobars/translate_message_infobar_controller.mm',
      'browser/ui/cocoa/javascript_app_modal_dialog_cocoa.h',
      'browser/ui/cocoa/javascript_app_modal_dialog_cocoa.mm',
      'browser/ui/cocoa/location_bar/autocomplete_text_field.h',
      'browser/ui/cocoa/location_bar/autocomplete_text_field.mm',
      'browser/ui/cocoa/location_bar/autocomplete_text_field_cell.h',
      'browser/ui/cocoa/location_bar/autocomplete_text_field_cell.mm',
      'browser/ui/cocoa/location_bar/autocomplete_text_field_editor.h',
      'browser/ui/cocoa/location_bar/autocomplete_text_field_editor.mm',
      'browser/ui/cocoa/location_bar/bubble_decoration.h',
      'browser/ui/cocoa/location_bar/bubble_decoration.mm',
      'browser/ui/cocoa/location_bar/content_setting_decoration.h',
      'browser/ui/cocoa/location_bar/content_setting_decoration.mm',
      'browser/ui/cocoa/location_bar/ev_bubble_decoration.h',
      'browser/ui/cocoa/location_bar/ev_bubble_decoration.mm',
      'browser/ui/cocoa/location_bar/image_decoration.h',
      'browser/ui/cocoa/location_bar/image_decoration.mm',
      'browser/ui/cocoa/location_bar/keyword_hint_decoration.h',
      'browser/ui/cocoa/location_bar/keyword_hint_decoration.mm',
      'browser/ui/cocoa/location_bar/location_bar_decoration.h',
      'browser/ui/cocoa/location_bar/location_bar_decoration.mm',
      'browser/ui/cocoa/location_bar/location_bar_view_mac.h',
      'browser/ui/cocoa/location_bar/location_bar_view_mac.mm',
      'browser/ui/cocoa/location_bar/location_icon_decoration.h',
      'browser/ui/cocoa/location_bar/location_icon_decoration.mm',
      'browser/ui/cocoa/location_bar/manage_passwords_decoration.h',
      'browser/ui/cocoa/location_bar/manage_passwords_decoration.mm',
      'browser/ui/cocoa/location_bar/mic_search_decoration.h',
      'browser/ui/cocoa/location_bar/mic_search_decoration.mm',
      'browser/ui/cocoa/location_bar/page_action_decoration.h',
      'browser/ui/cocoa/location_bar/page_action_decoration.mm',
      'browser/ui/cocoa/location_bar/selected_keyword_decoration.h',
      'browser/ui/cocoa/location_bar/selected_keyword_decoration.mm',
      'browser/ui/cocoa/location_bar/star_decoration.h',
      'browser/ui/cocoa/location_bar/star_decoration.mm',
      'browser/ui/cocoa/location_bar/translate_decoration.h',
      'browser/ui/cocoa/location_bar/translate_decoration.mm',
      'browser/ui/cocoa/location_bar/zoom_decoration.h',
      'browser/ui/cocoa/location_bar/zoom_decoration.mm',
      'browser/ui/cocoa/login_prompt_cocoa.h',
      'browser/ui/cocoa/login_prompt_cocoa.mm',
      'browser/ui/cocoa/main_menu_item.h',
      'browser/ui/cocoa/menu_button.h',
      'browser/ui/cocoa/menu_button.mm',
      'browser/ui/cocoa/multi_key_equivalent_button.h',
      'browser/ui/cocoa/multi_key_equivalent_button.mm',
      'browser/ui/cocoa/new_tab_button.h',
      'browser/ui/cocoa/new_tab_button.mm',
      'browser/ui/cocoa/omnibox/omnibox_popup_cell.h',
      'browser/ui/cocoa/omnibox/omnibox_popup_cell.mm',
      'browser/ui/cocoa/omnibox/omnibox_popup_matrix.h',
      'browser/ui/cocoa/omnibox/omnibox_popup_matrix.mm',
      'browser/ui/cocoa/omnibox/omnibox_popup_separator_view.h',
      'browser/ui/cocoa/omnibox/omnibox_popup_separator_view.mm',
      'browser/ui/cocoa/omnibox/omnibox_popup_view_mac.h',
      'browser/ui/cocoa/omnibox/omnibox_popup_view_mac.mm',
      'browser/ui/cocoa/omnibox/omnibox_view_mac.h',
      'browser/ui/cocoa/omnibox/omnibox_view_mac.mm',
      'browser/ui/cocoa/one_click_signin_bubble_controller.h',
      'browser/ui/cocoa/one_click_signin_bubble_controller.mm',
      'browser/ui/cocoa/one_click_signin_dialog_controller.h',
      'browser/ui/cocoa/one_click_signin_dialog_controller.mm',
      'browser/ui/cocoa/one_click_signin_view_controller.h',
      'browser/ui/cocoa/one_click_signin_view_controller.mm',
      'browser/ui/cocoa/panels/mouse_drag_controller.h',
      'browser/ui/cocoa/panels/mouse_drag_controller.mm',
      'browser/ui/cocoa/panels/panel_cocoa.h',
      'browser/ui/cocoa/panels/panel_cocoa.mm',
      'browser/ui/cocoa/panels/panel_stack_window_cocoa.h',
      'browser/ui/cocoa/panels/panel_stack_window_cocoa.mm',
      'browser/ui/cocoa/panels/panel_titlebar_view_cocoa.h',
      'browser/ui/cocoa/panels/panel_titlebar_view_cocoa.mm',
      'browser/ui/cocoa/panels/panel_utils_cocoa.h',
      'browser/ui/cocoa/panels/panel_utils_cocoa.mm',
      'browser/ui/cocoa/panels/panel_window_controller_cocoa.h',
      'browser/ui/cocoa/panels/panel_window_controller_cocoa.mm',
      'browser/ui/cocoa/passwords/account_avatar_fetcher_manager.h',
      'browser/ui/cocoa/passwords/account_avatar_fetcher_manager.mm',
      'browser/ui/cocoa/passwords/account_chooser_view_controller.h',
      'browser/ui/cocoa/passwords/account_chooser_view_controller.mm',
      'browser/ui/cocoa/passwords/auto_signin_view_controller.h',
      'browser/ui/cocoa/passwords/auto_signin_view_controller.mm',
      'browser/ui/cocoa/passwords/base_passwords_content_view_controller.h',
      'browser/ui/cocoa/passwords/base_passwords_content_view_controller.mm',
      'browser/ui/cocoa/passwords/confirmation_password_saved_view_controller.h',
      'browser/ui/cocoa/passwords/confirmation_password_saved_view_controller.mm',
      'browser/ui/cocoa/passwords/credential_item_view.h',
      'browser/ui/cocoa/passwords/credential_item_view.mm',
      'browser/ui/cocoa/passwords/manage_passwords_view_controller.h',
      'browser/ui/cocoa/passwords/manage_passwords_view_controller.mm',
      'browser/ui/cocoa/passwords/password_item_views.h',
      'browser/ui/cocoa/passwords/passwords_bubble_cocoa.h',
      'browser/ui/cocoa/passwords/passwords_bubble_cocoa.mm',
      'browser/ui/cocoa/passwords/passwords_bubble_controller.h',
      'browser/ui/cocoa/passwords/passwords_bubble_controller.mm',
      'browser/ui/cocoa/passwords/passwords_list_view_controller.h',
      'browser/ui/cocoa/passwords/passwords_list_view_controller.mm',
      'browser/ui/cocoa/passwords/pending_password_view_controller.h',
      'browser/ui/cocoa/passwords/pending_password_view_controller.mm',
      'browser/ui/cocoa/presentation_mode_controller.h',
      'browser/ui/cocoa/presentation_mode_controller.mm',
      'browser/ui/cocoa/profiles/avatar_base_controller.h',
      'browser/ui/cocoa/profiles/avatar_base_controller.mm',
      'browser/ui/cocoa/profiles/avatar_button.h',
      'browser/ui/cocoa/profiles/avatar_button.mm',
      'browser/ui/cocoa/profiles/avatar_button_controller.h',
      'browser/ui/cocoa/profiles/avatar_button_controller.mm',
      'browser/ui/cocoa/profiles/avatar_icon_controller.h',
      'browser/ui/cocoa/profiles/avatar_icon_controller.mm',
      'browser/ui/cocoa/profiles/avatar_label_button.h',
      'browser/ui/cocoa/profiles/avatar_label_button.mm',
      'browser/ui/cocoa/profiles/avatar_menu_bubble_controller.h',
      'browser/ui/cocoa/profiles/avatar_menu_bubble_controller.mm',
      'browser/ui/cocoa/profiles/profile_chooser_controller.h',
      'browser/ui/cocoa/profiles/profile_chooser_controller.mm',
      'browser/ui/cocoa/profiles/profile_signin_confirmation_dialog_cocoa.h',
      'browser/ui/cocoa/profiles/profile_signin_confirmation_dialog_cocoa.mm',
      'browser/ui/cocoa/profiles/profile_signin_confirmation_view_controller.h',
      'browser/ui/cocoa/profiles/profile_signin_confirmation_view_controller.mm',
      'browser/ui/cocoa/profiles/user_manager_mac.h',
      'browser/ui/cocoa/profiles/user_manager_mac.mm',
      'browser/ui/cocoa/rect_path_utils.h',
      'browser/ui/cocoa/rect_path_utils.mm',
      'browser/ui/cocoa/restart_browser.h',
      'browser/ui/cocoa/restart_browser.mm',
      'browser/ui/cocoa/screen_capture_notification_ui_cocoa.h',
      'browser/ui/cocoa/screen_capture_notification_ui_cocoa.mm',
      'browser/ui/cocoa/session_crashed_bubble.mm',
      'browser/ui/cocoa/simple_message_box_mac.mm',
      'browser/ui/cocoa/spinner_view.h',
      'browser/ui/cocoa/spinner_view.mm',
      'browser/ui/cocoa/sprite_view.h',
      'browser/ui/cocoa/sprite_view.mm',
      'browser/ui/cocoa/ssl_client_certificate_selector_cocoa.h',
      'browser/ui/cocoa/ssl_client_certificate_selector_cocoa.mm',
      'browser/ui/cocoa/status_bubble_mac.h',
      'browser/ui/cocoa/status_bubble_mac.mm',
      'browser/ui/cocoa/styled_text_field.h',
      'browser/ui/cocoa/styled_text_field.mm',
      'browser/ui/cocoa/styled_text_field_cell.h',
      'browser/ui/cocoa/styled_text_field_cell.mm',
      'browser/ui/cocoa/tab_contents/favicon_util_mac.h',
      'browser/ui/cocoa/tab_contents/favicon_util_mac.mm',
      'browser/ui/cocoa/tab_contents/overlayable_contents_controller.h',
      'browser/ui/cocoa/tab_contents/overlayable_contents_controller.mm',
      'browser/ui/cocoa/tab_contents/sad_tab_controller.h',
      'browser/ui/cocoa/tab_contents/sad_tab_controller.mm',
      'browser/ui/cocoa/tab_contents/sad_tab_view_cocoa.h',
      'browser/ui/cocoa/tab_contents/sad_tab_view_cocoa.mm',
      'browser/ui/cocoa/tab_contents/tab_contents_controller.h',
      'browser/ui/cocoa/tab_contents/tab_contents_controller.mm',
      'browser/ui/cocoa/tab_dialogs_cocoa.h',
      'browser/ui/cocoa/tab_dialogs_cocoa.mm',
      'browser/ui/cocoa/tab_modal_confirm_dialog_mac.h',
      'browser/ui/cocoa/tab_modal_confirm_dialog_mac.mm',
      'browser/ui/cocoa/table_row_nsimage_cache.h',
      'browser/ui/cocoa/table_row_nsimage_cache.mm',
      'browser/ui/cocoa/tabs/media_indicator_button_cocoa.h',
      'browser/ui/cocoa/tabs/media_indicator_button_cocoa.mm',
      'browser/ui/cocoa/tabs/tab_controller.h',
      'browser/ui/cocoa/tabs/tab_controller.mm',
      'browser/ui/cocoa/tabs/tab_strip_background_view.h',
      'browser/ui/cocoa/tabs/tab_strip_background_view.mm',
      'browser/ui/cocoa/tabs/tab_strip_controller.h',
      'browser/ui/cocoa/tabs/tab_strip_controller.mm',
      'browser/ui/cocoa/tabs/tab_strip_drag_controller.h',
      'browser/ui/cocoa/tabs/tab_strip_drag_controller.mm',
      'browser/ui/cocoa/tabs/tab_strip_model_observer_bridge.h',
      'browser/ui/cocoa/tabs/tab_strip_model_observer_bridge.mm',
      'browser/ui/cocoa/tabs/tab_strip_view.h',
      'browser/ui/cocoa/tabs/tab_strip_view.mm',
      'browser/ui/cocoa/tabs/tab_view.h',
      'browser/ui/cocoa/tabs/tab_view.mm',
      'browser/ui/cocoa/tabs/tab_window_controller.h',
      'browser/ui/cocoa/tabs/tab_window_controller.mm',
      'browser/ui/cocoa/task_manager_mac.h',
      'browser/ui/cocoa/task_manager_mac.mm',
      'browser/ui/cocoa/themed_window.h',
      'browser/ui/cocoa/themed_window.mm',
      'browser/ui/cocoa/toolbar/back_forward_menu_controller.h',
      'browser/ui/cocoa/toolbar/back_forward_menu_controller.mm',
      'browser/ui/cocoa/toolbar/media_router_action_platform_delegate_cocoa.h',
      'browser/ui/cocoa/toolbar/media_router_action_platform_delegate_cocoa.mm',
      'browser/ui/cocoa/toolbar/reload_button_cocoa.h',
      'browser/ui/cocoa/toolbar/reload_button_cocoa.mm',
      'browser/ui/cocoa/toolbar/toolbar_button_cocoa.h',
      'browser/ui/cocoa/toolbar/toolbar_button_cocoa.mm',
      'browser/ui/cocoa/toolbar/toolbar_controller.h',
      'browser/ui/cocoa/toolbar/toolbar_controller.mm',
      'browser/ui/cocoa/toolbar/toolbar_view_cocoa.h',
      'browser/ui/cocoa/toolbar/toolbar_view_cocoa.mm',
      'browser/ui/cocoa/toolbar/wrench_toolbar_button_cell.h',
      'browser/ui/cocoa/toolbar/wrench_toolbar_button_cell.mm',
      'browser/ui/cocoa/translate/translate_bubble_controller.h',
      'browser/ui/cocoa/translate/translate_bubble_controller.mm',
      'browser/ui/cocoa/url_drop_target.h',
      'browser/ui/cocoa/url_drop_target.mm',
      'browser/ui/cocoa/validation_message_bubble_cocoa.h',
      'browser/ui/cocoa/validation_message_bubble_cocoa.mm',
      'browser/ui/cocoa/validation_message_bubble_controller.h',
      'browser/ui/cocoa/vertical_gradient_view.h',
      'browser/ui/cocoa/vertical_gradient_view.mm',
      'browser/ui/cocoa/view_id_util.h',
      'browser/ui/cocoa/view_id_util.mm',
      'browser/ui/cocoa/view_resizer.h',
      'browser/ui/cocoa/web_contents_modal_dialog_manager_views_mac.h',
      'browser/ui/cocoa/web_contents_modal_dialog_manager_views_mac.mm',
      'browser/ui/cocoa/web_dialog_window_controller.h',
      'browser/ui/cocoa/web_dialog_window_controller.mm',
      'browser/ui/cocoa/website_settings/permission_bubble_cocoa.h',
      'browser/ui/cocoa/website_settings/permission_bubble_cocoa.mm',
      'browser/ui/cocoa/website_settings/permission_bubble_controller.h',
      'browser/ui/cocoa/website_settings/permission_bubble_controller.mm',
      'browser/ui/cocoa/website_settings/permission_selector_button.h',
      'browser/ui/cocoa/website_settings/permission_selector_button.mm',
      'browser/ui/cocoa/website_settings/split_block_button.h',
      'browser/ui/cocoa/website_settings/split_block_button.mm',
      'browser/ui/cocoa/website_settings/website_settings_bubble_controller.h',
      'browser/ui/cocoa/website_settings/website_settings_bubble_controller.mm',
      'browser/ui/cocoa/website_settings/website_settings_utils_cocoa.h',
      'browser/ui/cocoa/website_settings/website_settings_utils_cocoa.mm',
      'browser/ui/cocoa/window_size_autosaver.h',
      'browser/ui/cocoa/window_size_autosaver.mm',
      'browser/ui/cocoa/wrench_menu/menu_tracked_button.h',
      'browser/ui/cocoa/wrench_menu/menu_tracked_button.mm',
      'browser/ui/cocoa/wrench_menu/menu_tracked_root_view.h',
      'browser/ui/cocoa/wrench_menu/menu_tracked_root_view.mm',
      'browser/ui/cocoa/wrench_menu/recent_tabs_menu_model_delegate.h',
      'browser/ui/cocoa/wrench_menu/recent_tabs_menu_model_delegate.mm',
      'browser/ui/cocoa/wrench_menu/wrench_menu_button_cell.h',
      'browser/ui/cocoa/wrench_menu/wrench_menu_button_cell.mm',
      'browser/ui/cocoa/wrench_menu/wrench_menu_controller.h',
      'browser/ui/cocoa/wrench_menu/wrench_menu_controller.mm',
    ],
    # Files used only on desktop systems (not iOS, Android, ChromeOS).
    'chrome_browser_ui_desktop_sources': [
      'browser/ui/startup/default_browser_prompt.cc',
      'browser/ui/startup/default_browser_prompt.h',
      'browser/ui/startup/default_browser_prompt_win.cc',
      'browser/ui/sync/one_click_signin_bubble_delegate.h',
      'browser/ui/sync/one_click_signin_bubble_links_delegate.cc',
      'browser/ui/sync/one_click_signin_bubble_links_delegate.h',
      'browser/ui/sync/one_click_signin_sync_observer.cc',
      'browser/ui/sync/one_click_signin_sync_observer.h',
      'browser/ui/sync/one_click_signin_sync_starter.cc',
      'browser/ui/sync/one_click_signin_sync_starter.h',
      'browser/ui/views/profiles/new_avatar_button.cc',
      'browser/ui/views/profiles/new_avatar_button.h',
      'browser/ui/webui/app_launcher_page_ui.cc',
      'browser/ui/webui/app_launcher_page_ui.h',
      'browser/ui/webui/signin/inline_login_handler_impl.cc',
      'browser/ui/webui/signin/inline_login_handler_impl.h',
      'browser/ui/webui/signin/user_manager_screen_handler.cc',
      'browser/ui/webui/signin/user_manager_screen_handler.h',
      'browser/ui/webui/signin/user_manager_ui.cc',
      'browser/ui/webui/signin/user_manager_ui.h',
    ],
    # Desktop Linux. Assume aura/ash/views/x11.
    'chrome_browser_ui_desktop_linux_sources': [
      'browser/ui/views/app_list/linux/app_list_linux.cc',
      'browser/ui/views/app_list/linux/app_list_linux.h',
      'browser/ui/views/app_list/linux/app_list_service_linux.cc',
      'browser/ui/views/app_list/linux/app_list_service_linux.h',
      'browser/ui/views/first_run_dialog.cc',
      'browser/ui/views/first_run_dialog.h',
      'browser/ui/views/frame/browser_desktop_window_tree_host.h',
      'browser/ui/views/frame/browser_desktop_window_tree_host_x11.cc',
      'browser/ui/views/frame/browser_desktop_window_tree_host_x11.h',
      'browser/ui/views/frame/desktop_browser_frame_auralinux.cc',
      'browser/ui/views/frame/desktop_browser_frame_auralinux.h',
      'browser/ui/views/frame/global_menu_bar_registrar_x11.cc',
      'browser/ui/views/frame/global_menu_bar_registrar_x11.h',
      'browser/ui/views/frame/global_menu_bar_x11.cc',
      'browser/ui/views/frame/global_menu_bar_x11.h',
      'browser/ui/views/frame/native_browser_frame_factory_auralinux.cc',
      'browser/ui/views/frame/native_browser_frame_factory_desktop_ash.cc',
      'browser/ui/views/javascript_app_modal_dialog_views_x11.cc',
      'browser/ui/views/javascript_app_modal_dialog_views_x11.h',
      'browser/ui/views/status_icons/status_icon_linux_wrapper.cc',
      'browser/ui/views/status_icons/status_icon_linux_wrapper.h',
      'browser/ui/webui/help/version_updater_basic.cc',
      'browser/ui/webui/help/version_updater_basic.h',
    ],
    # Files used on iOS. iOS uses only these files and does not share other
    # lists, so a file may appear here and in the non_ios_sources also.
    'chrome_browser_ui_ios_sources': [
      'browser/ui/profile_error_dialog.cc',
      'browser/ui/profile_error_dialog.h',
    ],
    # Counts desktop Linux and ChromeOS.
    'chrome_browser_ui_linux_sources': [
      'browser/ui/certificate_dialogs.cc',
      'browser/ui/certificate_dialogs.h',
      'browser/ui/startup/autolaunch_prompt.cc',
      'browser/ui/views/apps/chrome_app_window_client_views.cc',
      'browser/ui/webui/certificate_viewer_ui.cc',
      'browser/ui/webui/certificate_viewer_ui.h',
      'browser/ui/webui/certificate_viewer_webui.cc',
      'browser/ui/webui/certificate_viewer_webui.h',
    ],
    'chrome_browser_ui_mac_sources': [
      'browser/ui/cocoa/accelerator_utils_cocoa.mm',
      'browser/ui/cocoa/accelerators_cocoa.h',
      'browser/ui/cocoa/accelerators_cocoa.mm',
      'browser/ui/cocoa/apps/app_shim_menu_controller_mac.h',
      'browser/ui/cocoa/apps/app_shim_menu_controller_mac.mm',
      'browser/ui/cocoa/apps/quit_with_apps_controller_mac.cc',
      'browser/ui/cocoa/apps/quit_with_apps_controller_mac.h',
      'browser/ui/cocoa/apps/titlebar_background_view.h',
      'browser/ui/cocoa/apps/titlebar_background_view.mm',
      'browser/ui/cocoa/bookmarks/bookmark_menu_bridge.h',
      'browser/ui/cocoa/bookmarks/bookmark_menu_bridge.mm',
      'browser/ui/cocoa/bookmarks/bookmark_menu_cocoa_controller.h',
      'browser/ui/cocoa/bookmarks/bookmark_menu_cocoa_controller.mm',
      'browser/ui/cocoa/browser_window_command_handler.h',
      'browser/ui/cocoa/browser_window_command_handler.mm',
      'browser/ui/cocoa/certificate_viewer_mac.mm',
      'browser/ui/cocoa/chrome_command_dispatcher_delegate.h',
      'browser/ui/cocoa/chrome_command_dispatcher_delegate.mm',
      'browser/ui/cocoa/color_chooser_mac.mm',
      'browser/ui/cocoa/confirm_quit.h',
      'browser/ui/cocoa/confirm_quit_panel_controller.h',
      'browser/ui/cocoa/confirm_quit_panel_controller.mm',
      'browser/ui/cocoa/constrained_window/constrained_window_mac.h',
      'browser/ui/cocoa/constrained_window/constrained_window_mac.mm',
      'browser/ui/cocoa/constrained_window/constrained_window_sheet.h',
      'browser/ui/cocoa/constrained_window/constrained_window_sheet_controller.h',
      'browser/ui/cocoa/constrained_window/constrained_window_sheet_controller.mm',
      'browser/ui/cocoa/constrained_window/constrained_window_sheet_info.h',
      'browser/ui/cocoa/constrained_window/constrained_window_sheet_info.mm',
      'browser/ui/cocoa/dock_icon.h',
      'browser/ui/cocoa/dock_icon.mm',
      'browser/ui/cocoa/download/download_item_drag_mac.mm',
      'browser/ui/cocoa/download/download_util_mac.h',
      'browser/ui/cocoa/download/download_util_mac.mm',
      'browser/ui/cocoa/encoding_menu_controller_delegate_mac.h',
      'browser/ui/cocoa/encoding_menu_controller_delegate_mac.mm',
      'browser/ui/cocoa/first_run_dialog.h',
      'browser/ui/cocoa/first_run_dialog.mm',
      'browser/ui/cocoa/handoff_active_url_observer.cc',
      'browser/ui/cocoa/handoff_active_url_observer.h',
      'browser/ui/cocoa/handoff_active_url_observer_bridge.h',
      'browser/ui/cocoa/handoff_active_url_observer_bridge.mm',
      'browser/ui/cocoa/handoff_active_url_observer_delegate.h',
      'browser/ui/cocoa/history_menu_bridge.h',
      'browser/ui/cocoa/history_menu_bridge.mm',
      'browser/ui/cocoa/history_menu_cocoa_controller.h',
      'browser/ui/cocoa/history_menu_cocoa_controller.mm',
      'browser/ui/cocoa/history_overlay_controller.h',
      'browser/ui/cocoa/history_overlay_controller.mm',
      'browser/ui/cocoa/key_equivalent_constants.h',
      'browser/ui/cocoa/key_equivalent_constants.mm',
      'browser/ui/cocoa/keystone_infobar_delegate.h',
      'browser/ui/cocoa/keystone_infobar_delegate.mm',
      'browser/ui/cocoa/l10n_util.h',
      'browser/ui/cocoa/l10n_util.mm',
      'browser/ui/cocoa/last_active_browser_cocoa.cc',
      'browser/ui/cocoa/last_active_browser_cocoa.h',
      'browser/ui/cocoa/media_picker/desktop_media_picker_bridge.h',
      'browser/ui/cocoa/media_picker/desktop_media_picker_bridge.mm',
      'browser/ui/cocoa/media_picker/desktop_media_picker_cocoa.h',
      'browser/ui/cocoa/media_picker/desktop_media_picker_cocoa.mm',
      'browser/ui/cocoa/media_picker/desktop_media_picker_controller.h',
      'browser/ui/cocoa/media_picker/desktop_media_picker_controller.mm',
      'browser/ui/cocoa/media_picker/desktop_media_picker_item.h',
      'browser/ui/cocoa/media_picker/desktop_media_picker_item.mm',
      'browser/ui/cocoa/native_window_tracker_cocoa.h',
      'browser/ui/cocoa/native_window_tracker_cocoa.mm',
      'browser/ui/cocoa/notifications/message_center_tray_bridge.h',
      'browser/ui/cocoa/notifications/message_center_tray_bridge.mm',
      'browser/ui/cocoa/nsmenuitem_additions.h',
      'browser/ui/cocoa/nsmenuitem_additions.mm',
      'browser/ui/cocoa/panels/display_settings_provider_cocoa.mm',
      'browser/ui/cocoa/profiles/profile_menu_controller.h',
      'browser/ui/cocoa/profiles/profile_menu_controller.mm',
      'browser/ui/cocoa/renderer_context_menu/render_view_context_menu_mac.h',
      'browser/ui/cocoa/renderer_context_menu/render_view_context_menu_mac.mm',
      'browser/ui/cocoa/single_web_contents_dialog_manager_cocoa.h',
      'browser/ui/cocoa/single_web_contents_dialog_manager_cocoa.mm',
      'browser/ui/cocoa/status_icons/status_icon_mac.h',
      'browser/ui/cocoa/status_icons/status_icon_mac.mm',
      'browser/ui/cocoa/status_icons/status_tray_mac.h',
      'browser/ui/cocoa/status_icons/status_tray_mac.mm',
      'browser/ui/cocoa/tab_contents/chrome_web_contents_view_delegate_mac.h',
      'browser/ui/cocoa/tab_contents/chrome_web_contents_view_delegate_mac.mm',
      'browser/ui/cocoa/tab_contents/web_drag_bookmark_handler_mac.h',
      'browser/ui/cocoa/tab_contents/web_drag_bookmark_handler_mac.mm',
      'browser/ui/cocoa/ui_localizer.h',
      'browser/ui/cocoa/ui_localizer.mm',
      'browser/ui/cocoa/web_contents_modal_dialog_host_cocoa.h',
      'browser/ui/cocoa/web_contents_modal_dialog_host_cocoa.mm',
      # TODO(estade): this class should be folded into
      # manage_passwords_decoration.mm
      'browser/ui/passwords/manage_passwords_icon.cc',
      'browser/ui/passwords/manage_passwords_icon.h',
      'browser/ui/startup/autolaunch_prompt.cc',
      'browser/ui/web_contents_sizer.mm',
    ],
    'chrome_browser_ui_media_router_sources': [
      'browser/ui/toolbar/media_router_action.cc',
      'browser/ui/toolbar/media_router_action.h',
      'browser/ui/toolbar/media_router_action_platform_delegate.h',
      'browser/ui/toolbar/media_router_contextual_menu.cc',
      'browser/ui/toolbar/media_router_contextual_menu.h',
      'browser/ui/views/toolbar/media_router_action_platform_delegate_views.cc',
      'browser/ui/views/toolbar/media_router_action_platform_delegate_views.h',
      'browser/ui/webui/media_router/media_cast_mode.cc',
      'browser/ui/webui/media_router/media_cast_mode.h',
      'browser/ui/webui/media_router/media_router_dialog_controller_impl.cc',
      'browser/ui/webui/media_router/media_router_dialog_controller_impl.h',
      'browser/ui/webui/media_router/media_router_localized_strings_provider.cc',
      'browser/ui/webui/media_router/media_router_localized_strings_provider.h',
      'browser/ui/webui/media_router/media_router_resources_provider.cc',
      'browser/ui/webui/media_router/media_router_resources_provider.h',
      'browser/ui/webui/media_router/media_router_ui.cc',
      'browser/ui/webui/media_router/media_router_ui.h',
      'browser/ui/webui/media_router/media_router_webui_message_handler.cc',
      'browser/ui/webui/media_router/media_router_webui_message_handler.h',
      'browser/ui/webui/media_router/media_sink_with_cast_modes.cc',
      'browser/ui/webui/media_router/media_sink_with_cast_modes.h',
      'browser/ui/webui/media_router/query_result_manager.cc',
      'browser/ui/webui/media_router/query_result_manager.h',
    ],
    'chrome_browser_ui_non_mac_sources': [
      'browser/ui/web_contents_sizer.cc',
    ],
    'chrome_browser_ui_non_mobile_sources': [
      'browser/ui/apps/app_info_dialog.h',
      'browser/ui/apps/apps_metro_handler_win.cc',
      'browser/ui/apps/apps_metro_handler_win.h',
      'browser/ui/apps/chrome_app_delegate.cc',
      'browser/ui/apps/chrome_app_delegate.h',
      'browser/ui/apps/chrome_app_window_client.cc',
      'browser/ui/apps/chrome_app_window_client.h',
      'browser/ui/apps/directory_access_confirmation_dialog.cc',
      'browser/ui/apps/directory_access_confirmation_dialog.h',
      'browser/ui/autofill/new_credit_card_bubble_controller.cc',
      'browser/ui/autofill/new_credit_card_bubble_controller.h',
      'browser/ui/autofill/new_credit_card_bubble_view.cc',
      'browser/ui/autofill/new_credit_card_bubble_view.h',
      'browser/ui/blocked_content/app_modal_dialog_helper.cc',
      'browser/ui/blocked_content/app_modal_dialog_helper.h',
      'browser/ui/bookmarks/bookmark_bubble_sign_in_delegate.cc',
      'browser/ui/bookmarks/bookmark_bubble_sign_in_delegate.h',
      'browser/ui/bookmarks/bookmark_context_menu_controller.cc',
      'browser/ui/bookmarks/bookmark_context_menu_controller.h',
      'browser/ui/bookmarks/bookmark_drag_drop.cc',
      'browser/ui/bookmarks/bookmark_drag_drop.h',
      'browser/ui/bookmarks/bookmark_tab_helper.cc',
      'browser/ui/bookmarks/bookmark_tab_helper.h',
      'browser/ui/bookmarks/bookmark_tab_helper_delegate.cc',
      'browser/ui/bookmarks/bookmark_tab_helper_delegate.h',
      'browser/ui/bookmarks/bookmark_utils_desktop.cc',
      'browser/ui/bookmarks/bookmark_utils_desktop.h',
      'browser/ui/bookmarks/enhanced_bookmark_key_service.cc',
      'browser/ui/bookmarks/enhanced_bookmark_key_service.h',
      'browser/ui/bookmarks/enhanced_bookmark_key_service_factory.cc',
      'browser/ui/bookmarks/enhanced_bookmark_key_service_factory.h',
      'browser/ui/browser.cc',
      'browser/ui/browser.h',
      'browser/ui/browser_command_controller.cc',
      'browser/ui/browser_command_controller.h',
      'browser/ui/browser_commands.cc',
      'browser/ui/browser_commands.h',
      'browser/ui/browser_content_setting_bubble_model_delegate.cc',
      'browser/ui/browser_content_setting_bubble_model_delegate.h',
      'browser/ui/browser_finder.cc',
      'browser/ui/browser_finder.h',
      'browser/ui/browser_instant_controller.cc',
      'browser/ui/browser_instant_controller.h',
      'browser/ui/browser_iterator.cc',
      'browser/ui/browser_iterator.h',
      'browser/ui/browser_list.cc',
      'browser/ui/browser_list.h',
      'browser/ui/browser_live_tab_context.cc',
      'browser/ui/browser_live_tab_context.h',
      'browser/ui/browser_navigator.cc',
      'browser/ui/browser_navigator.h',
      'browser/ui/browser_otr_state.cc',
      'browser/ui/browser_otr_state.h',
      'browser/ui/browser_tab_restorer.cc',
      'browser/ui/browser_tab_strip_model_delegate.cc',
      'browser/ui/browser_tab_strip_model_delegate.h',
      'browser/ui/browser_tab_strip_tracker.cc',
      'browser/ui/browser_tab_strip_tracker.h',
      'browser/ui/browser_tab_strip_tracker_delegate.h',
      'browser/ui/browser_tabrestore.cc',
      'browser/ui/browser_tabrestore.h',
      'browser/ui/browser_tabstrip.cc',
      'browser/ui/browser_tabstrip.h',
      'browser/ui/browser_toolbar_model_delegate.cc',
      'browser/ui/browser_toolbar_model_delegate.h',
      'browser/ui/browser_view_prefs.cc',
      'browser/ui/browser_view_prefs.h',
      'browser/ui/browser_window_state.cc',
      'browser/ui/browser_window_state.h',
      'browser/ui/chrome_bubble_manager.cc',
      'browser/ui/chrome_bubble_manager.h',
      'browser/ui/chrome_pages.cc',
      'browser/ui/chrome_pages.h',
      'browser/ui/chrome_style.cc',
      'browser/ui/chrome_style.h',
      'browser/ui/chrome_web_modal_dialog_manager_delegate.cc',
      'browser/ui/chrome_web_modal_dialog_manager_delegate.h',
      'browser/ui/collected_cookies_infobar_delegate.cc',
      'browser/ui/collected_cookies_infobar_delegate.h',
      'browser/ui/confirm_bubble_model.cc',
      'browser/ui/confirm_bubble_model.h',
      'browser/ui/content_settings/content_setting_bubble_model.cc',
      'browser/ui/content_settings/content_setting_bubble_model.h',
      'browser/ui/content_settings/content_setting_bubble_model_delegate.h',
      'browser/ui/content_settings/content_setting_image_model.cc',
      'browser/ui/content_settings/content_setting_image_model.h',
      'browser/ui/content_settings/content_setting_media_menu_model.cc',
      'browser/ui/content_settings/content_setting_media_menu_model.h',
      'browser/ui/exclusive_access/exclusive_access_bubble.cc',
      'browser/ui/exclusive_access/exclusive_access_bubble.h',
      'browser/ui/exclusive_access/exclusive_access_bubble_type.cc',
      'browser/ui/exclusive_access/exclusive_access_bubble_type.h',
      'browser/ui/exclusive_access/exclusive_access_context.cc',
      'browser/ui/exclusive_access/exclusive_access_context.h',
      'browser/ui/exclusive_access/exclusive_access_controller_base.cc',
      'browser/ui/exclusive_access/exclusive_access_controller_base.h',
      'browser/ui/exclusive_access/exclusive_access_manager.cc',
      'browser/ui/exclusive_access/exclusive_access_manager.h',
      'browser/ui/exclusive_access/fullscreen_controller.cc',
      'browser/ui/exclusive_access/fullscreen_controller.h',
      'browser/ui/exclusive_access/fullscreen_within_tab_helper.cc',
      'browser/ui/exclusive_access/fullscreen_within_tab_helper.h',
      'browser/ui/exclusive_access/mouse_lock_controller.cc',
      'browser/ui/exclusive_access/mouse_lock_controller.h',
      'browser/ui/fast_unload_controller.cc',
      'browser/ui/fast_unload_controller.h',
      'browser/ui/find_bar/find_bar_controller.cc',
      'browser/ui/find_bar/find_bar_controller.h',
      'browser/ui/global_error/global_error.cc',
      'browser/ui/global_error/global_error.h',
      'browser/ui/global_error/global_error_bubble_view_base.h',
      'browser/ui/global_error/global_error_service.cc',
      'browser/ui/global_error/global_error_service.h',
      'browser/ui/global_error/global_error_service_factory.cc',
      'browser/ui/global_error/global_error_service_factory.h',
      'browser/ui/infobar_container_delegate.cc',
      'browser/ui/infobar_container_delegate.h',
      'browser/ui/location_bar/location_bar.cc',
      'browser/ui/location_bar/location_bar.h',
      'browser/ui/location_bar/location_bar_util.cc',
      'browser/ui/location_bar/location_bar_util.h',
      'browser/ui/native_window_tracker.h',
      'browser/ui/panels/detached_panel_collection.cc',
      'browser/ui/panels/detached_panel_collection.h',
      'browser/ui/panels/detached_panel_drag_handler.cc',
      'browser/ui/panels/detached_panel_drag_handler.h',
      'browser/ui/panels/display_settings_provider.cc',
      'browser/ui/panels/display_settings_provider.h',
      'browser/ui/panels/docked_panel_collection.cc',
      'browser/ui/panels/docked_panel_collection.h',
      'browser/ui/panels/docked_panel_drag_handler.cc',
      'browser/ui/panels/docked_panel_drag_handler.h',
      'browser/ui/panels/native_panel.h',
      'browser/ui/panels/native_panel_stack_window.h',
      'browser/ui/panels/panel.cc',
      'browser/ui/panels/panel.h',
      'browser/ui/panels/panel_bounds_animation.cc',
      'browser/ui/panels/panel_bounds_animation.h',
      'browser/ui/panels/panel_collection.cc',
      'browser/ui/panels/panel_collection.h',
      'browser/ui/panels/panel_constants.h',
      'browser/ui/panels/panel_drag_controller.cc',
      'browser/ui/panels/panel_drag_controller.h',
      'browser/ui/panels/panel_host.cc',
      'browser/ui/panels/panel_host.h',
      'browser/ui/panels/panel_manager.cc',
      'browser/ui/panels/panel_manager.h',
      'browser/ui/panels/panel_mouse_watcher.cc',
      'browser/ui/panels/panel_mouse_watcher.h',
      'browser/ui/panels/panel_mouse_watcher_observer.h',
      'browser/ui/panels/panel_mouse_watcher_timer.cc',
      'browser/ui/panels/panel_resize_controller.cc',
      'browser/ui/panels/panel_resize_controller.h',
      'browser/ui/panels/stacked_panel_collection.cc',
      'browser/ui/panels/stacked_panel_collection.h',
      'browser/ui/panels/stacked_panel_drag_handler.cc',
      'browser/ui/panels/stacked_panel_drag_handler.h',
      'browser/ui/passwords/manage_passwords_bubble_model.cc',
      'browser/ui/passwords/manage_passwords_bubble_model.h',
      'browser/ui/passwords/manage_passwords_icon_view.h',
      'browser/ui/passwords/manage_passwords_view_utils_desktop.cc',
      'browser/ui/passwords/manage_passwords_view_utils_desktop.h',
      'browser/ui/pdf/adobe_reader_info_win.cc',
      'browser/ui/pdf/adobe_reader_info_win.h',
      'browser/ui/pdf/chrome_pdf_web_contents_helper_client.cc',
      'browser/ui/pdf/chrome_pdf_web_contents_helper_client.h',
      'browser/ui/pdf/pdf_unsupported_feature.cc',
      'browser/ui/pdf/pdf_unsupported_feature.h',
      'browser/ui/sad_tab.cc',
      'browser/ui/sad_tab.h',
      'browser/ui/sad_tab_helper.cc',
      'browser/ui/sad_tab_helper.h',
      'browser/ui/sad_tab_types.h',
      'browser/ui/scoped_tabbed_browser_displayer.cc',
      'browser/ui/scoped_tabbed_browser_displayer.h',
      'browser/ui/search/instant_controller.cc',
      'browser/ui/search/instant_controller.h',
      'browser/ui/search/search_delegate.cc',
      'browser/ui/search/search_delegate.h',
      'browser/ui/search/search_ui.cc',
      'browser/ui/search/search_ui.h',
      'browser/ui/search_engines/search_engine_tab_helper_delegate.cc',
      'browser/ui/search_engines/search_engine_tab_helper_delegate.h',
      'browser/ui/settings_window_manager.cc',
      'browser/ui/settings_window_manager.h',
      'browser/ui/settings_window_manager_observer.h',
      'browser/ui/singleton_tabs.cc',
      'browser/ui/singleton_tabs.h',
      'browser/ui/startup/autolaunch_prompt.h',
      'browser/ui/startup/autolaunch_prompt_win.cc',
      'browser/ui/startup/bad_flags_prompt.cc',
      'browser/ui/startup/bad_flags_prompt.h',
      'browser/ui/startup/google_api_keys_infobar_delegate.cc',
      'browser/ui/startup/google_api_keys_infobar_delegate.h',
      'browser/ui/startup/obsolete_system_infobar_delegate.cc',
      'browser/ui/startup/obsolete_system_infobar_delegate.h',
      'browser/ui/startup/session_crashed_infobar_delegate.cc',
      'browser/ui/startup/session_crashed_infobar_delegate.h',
      'browser/ui/startup/startup_browser_creator.cc',
      'browser/ui/startup/startup_browser_creator.h',
      'browser/ui/startup/startup_browser_creator_impl.cc',
      'browser/ui/startup/startup_browser_creator_impl.h',
      'browser/ui/startup/startup_tab.cc',
      'browser/ui/startup/startup_tab.h',
      'browser/ui/startup/startup_types.h',
      'browser/ui/sync/browser_synced_window_delegate.cc',
      'browser/ui/sync/browser_synced_window_delegate.h',
      'browser/ui/sync/browser_synced_window_delegates_getter.cc',
      'browser/ui/sync/browser_synced_window_delegates_getter.h',
      'browser/ui/sync/inline_login_dialog.cc',
      'browser/ui/sync/inline_login_dialog.h',
      'browser/ui/sync/sync_promo_ui.cc',
      'browser/ui/sync/sync_promo_ui.h',
      'browser/ui/tab_contents/tab_contents_iterator.cc',
      'browser/ui/tab_contents/tab_contents_iterator.h',
      'browser/ui/tab_modal_confirm_dialog_delegate.cc',
      'browser/ui/tab_modal_confirm_dialog_delegate.h',
      'browser/ui/tabs/hover_tab_selector.cc',
      'browser/ui/tabs/hover_tab_selector.h',
      'browser/ui/tabs/pinned_tab_codec.cc',
      'browser/ui/tabs/pinned_tab_codec.h',
      'browser/ui/tabs/pinned_tab_service.cc',
      'browser/ui/tabs/pinned_tab_service.h',
      'browser/ui/tabs/pinned_tab_service_factory.cc',
      'browser/ui/tabs/pinned_tab_service_factory.h',
      'browser/ui/tabs/tab_menu_model.cc',
      'browser/ui/tabs/tab_menu_model.h',
      'browser/ui/tabs/tab_strip_model.cc',
      'browser/ui/tabs/tab_strip_model.h',
      'browser/ui/tabs/tab_strip_model_delegate.h',
      'browser/ui/tabs/tab_strip_model_observer.cc',
      'browser/ui/tabs/tab_strip_model_observer.h',
      'browser/ui/tabs/tab_strip_model_order_controller.cc',
      'browser/ui/tabs/tab_strip_model_order_controller.h',
      'browser/ui/tabs/tab_strip_model_stats_recorder.cc',
      'browser/ui/tabs/tab_strip_model_stats_recorder.h',
      'browser/ui/tabs/tab_strip_model_utils.cc',
      'browser/ui/tabs/tab_strip_model_utils.h',
      'browser/ui/tabs/tab_utils.cc',
      'browser/ui/tabs/tab_utils.h',
      'browser/ui/task_manager/task_manager_columns.cc',
      'browser/ui/task_manager/task_manager_columns.h',
      'browser/ui/task_manager/task_manager_table_model.cc',
      'browser/ui/task_manager/task_manager_table_model.h',
      'browser/ui/toolbar/app_menu_badge_controller.cc',
      'browser/ui/toolbar/app_menu_badge_controller.h',
      'browser/ui/toolbar/app_menu_icon_painter.cc',
      'browser/ui/toolbar/app_menu_icon_painter.h',
      'browser/ui/toolbar/app_menu_model.cc',
      'browser/ui/toolbar/app_menu_model.h',
      'browser/ui/toolbar/back_forward_menu_model.cc',
      'browser/ui/toolbar/back_forward_menu_model.h',
      'browser/ui/toolbar/bookmark_sub_menu_model.cc',
      'browser/ui/toolbar/bookmark_sub_menu_model.h',
      'browser/ui/toolbar/component_toolbar_actions_factory.cc',
      'browser/ui/toolbar/component_toolbar_actions_factory.h',
      'browser/ui/toolbar/encoding_menu_controller.cc',
      'browser/ui/toolbar/encoding_menu_controller.h',
      'browser/ui/toolbar/recent_tabs_sub_menu_model.cc',
      'browser/ui/toolbar/recent_tabs_sub_menu_model.h',
      'browser/ui/toolbar/toolbar_action_view_controller.h',
      'browser/ui/toolbar/toolbar_action_view_delegate.h',
      'browser/ui/toolbar/toolbar_actions_bar.cc',
      'browser/ui/toolbar/toolbar_actions_bar.h',
      'browser/ui/toolbar/toolbar_actions_bar_bubble_delegate.h',
      'browser/ui/toolbar/toolbar_actions_bar_delegate.h',
      'browser/ui/toolbar/toolbar_actions_bar_observer.h',
      'browser/ui/translate/translate_bubble_factory.cc',
      'browser/ui/translate/translate_bubble_factory.h',
      'browser/ui/uma_browsing_activity_observer.cc',
      'browser/ui/uma_browsing_activity_observer.h',
      'browser/ui/unload_controller.cc',
      'browser/ui/unload_controller.h',
      'browser/ui/user_manager.cc',
      'browser/ui/user_manager.h',
      'browser/ui/website_settings/permission_bubble_manager.cc',
      'browser/ui/website_settings/permission_bubble_manager.h',
      'browser/ui/website_settings/permission_bubble_view.h',
      'browser/ui/website_settings/permission_menu_model.cc',
      'browser/ui/website_settings/permission_menu_model.h',
      'browser/ui/website_settings/website_settings_infobar_delegate.cc',
      'browser/ui/website_settings/website_settings_infobar_delegate.h',
      'browser/ui/website_settings/website_settings_utils.cc',
      'browser/ui/website_settings/website_settings_utils.h',
      'browser/ui/webui/app_launcher_login_handler.cc',
      'browser/ui/webui/app_launcher_login_handler.h',
      'browser/ui/webui/bookmarks_ui.cc',
      'browser/ui/webui/bookmarks_ui.h',
      'browser/ui/webui/chrome_web_contents_handler.cc',
      'browser/ui/webui/chrome_web_contents_handler.h',
      'browser/ui/webui/constrained_web_dialog_delegate_base.cc',
      'browser/ui/webui/constrained_web_dialog_delegate_base.h',
      'browser/ui/webui/copresence_ui.cc',
      'browser/ui/webui/copresence_ui.h',
      'browser/ui/webui/copresence_ui_handler.cc',
      'browser/ui/webui/copresence_ui_handler.h',
      'browser/ui/webui/devtools_ui.cc',
      'browser/ui/webui/devtools_ui.h',
      'browser/ui/webui/downloads_dom_handler.cc',
      'browser/ui/webui/downloads_dom_handler.h',
      'browser/ui/webui/downloads_ui.cc',
      'browser/ui/webui/downloads_ui.h',
      'browser/ui/webui/downloads_util.cc',
      'browser/ui/webui/downloads_util.h',
      'browser/ui/webui/extensions/extension_loader_handler.cc',
      'browser/ui/webui/extensions/extension_loader_handler.h',
      'browser/ui/webui/extensions/extension_settings_handler.cc',
      'browser/ui/webui/extensions/extension_settings_handler.h',
      'browser/ui/webui/extensions/extensions_ui.cc',
      'browser/ui/webui/extensions/extensions_ui.h',
      'browser/ui/webui/extensions/install_extension_handler.cc',
      'browser/ui/webui/extensions/install_extension_handler.h',
      'browser/ui/webui/foreign_session_handler.cc',
      'browser/ui/webui/foreign_session_handler.h',
      'browser/ui/webui/help/help_handler.cc',
      'browser/ui/webui/help/help_handler.h',
      'browser/ui/webui/help/help_ui.cc',
      'browser/ui/webui/help/help_ui.h',
      'browser/ui/webui/help/help_utils_chromeos.cc',
      'browser/ui/webui/help/help_utils_chromeos.h',
      'browser/ui/webui/help/version_updater.h',
      'browser/ui/webui/help/version_updater_chromeos.cc',
      'browser/ui/webui/help/version_updater_chromeos.h',
      'browser/ui/webui/help/version_updater_mac.h',
      'browser/ui/webui/help/version_updater_mac.mm',
      'browser/ui/webui/help/version_updater_win.cc',
      'browser/ui/webui/history_login_handler.cc',
      'browser/ui/webui/history_login_handler.h',
      'browser/ui/webui/identity_internals_ui.cc',
      'browser/ui/webui/identity_internals_ui.h',
      'browser/ui/webui/inspect_ui.cc',
      'browser/ui/webui/inspect_ui.h',
      'browser/ui/webui/md_downloads/md_downloads_dom_handler.cc',
      'browser/ui/webui/md_downloads/md_downloads_dom_handler.h',
      'browser/ui/webui/md_downloads/md_downloads_ui.cc',
      'browser/ui/webui/md_downloads/md_downloads_ui.h',
      'browser/ui/webui/ntp/app_launcher_handler.cc',
      'browser/ui/webui/ntp/app_launcher_handler.h',
      'browser/ui/webui/ntp/app_resource_cache_factory.cc',
      'browser/ui/webui/ntp/app_resource_cache_factory.h',
      'browser/ui/webui/ntp/core_app_launcher_handler.cc',
      'browser/ui/webui/ntp/core_app_launcher_handler.h',
      'browser/ui/webui/ntp/favicon_webui_handler.cc',
      'browser/ui/webui/ntp/favicon_webui_handler.h',
      'browser/ui/webui/ntp/new_tab_page_handler.cc',
      'browser/ui/webui/ntp/new_tab_page_handler.h',
      'browser/ui/webui/ntp/new_tab_page_sync_handler.cc',
      'browser/ui/webui/ntp/new_tab_page_sync_handler.h',
      'browser/ui/webui/ntp/new_tab_ui.cc',
      'browser/ui/webui/ntp/new_tab_ui.h',
      'browser/ui/webui/ntp/ntp_resource_cache.cc',
      'browser/ui/webui/ntp/ntp_resource_cache.h',
      'browser/ui/webui/ntp/ntp_resource_cache_factory.cc',
      'browser/ui/webui/ntp/ntp_resource_cache_factory.h',
      'browser/ui/webui/ntp/ntp_stats.h',
      'browser/ui/webui/options/advanced_options_utils.h',
      'browser/ui/webui/options/advanced_options_utils_linux.cc',
      'browser/ui/webui/options/advanced_options_utils_mac.mm',
      'browser/ui/webui/options/advanced_options_utils_win.cc',
      'browser/ui/webui/options/autofill_options_handler.cc',
      'browser/ui/webui/options/autofill_options_handler.h',
      'browser/ui/webui/options/automatic_settings_reset_handler.cc',
      'browser/ui/webui/options/automatic_settings_reset_handler.h',
      'browser/ui/webui/options/browser_options_handler.cc',
      'browser/ui/webui/options/browser_options_handler.h',
      'browser/ui/webui/options/chromeos/accounts_options_handler.cc',
      'browser/ui/webui/options/chromeos/accounts_options_handler.h',
      'browser/ui/webui/options/chromeos/bluetooth_options_handler.cc',
      'browser/ui/webui/options/chromeos/bluetooth_options_handler.h',
      'browser/ui/webui/options/chromeos/change_picture_options_handler.cc',
      'browser/ui/webui/options/chromeos/change_picture_options_handler.h',
      'browser/ui/webui/options/chromeos/consumer_management_handler.cc',
      'browser/ui/webui/options/chromeos/consumer_management_handler.h',
      'browser/ui/webui/options/chromeos/core_chromeos_options_handler.cc',
      'browser/ui/webui/options/chromeos/core_chromeos_options_handler.h',
      'browser/ui/webui/options/chromeos/cros_language_options_handler.cc',
      'browser/ui/webui/options/chromeos/cros_language_options_handler.h',
      'browser/ui/webui/options/chromeos/date_time_options_handler.cc',
      'browser/ui/webui/options/chromeos/date_time_options_handler.h',
      'browser/ui/webui/options/chromeos/display_options_handler.cc',
      'browser/ui/webui/options/chromeos/display_options_handler.h',
      'browser/ui/webui/options/chromeos/display_overscan_handler.cc',
      'browser/ui/webui/options/chromeos/display_overscan_handler.h',
      'browser/ui/webui/options/chromeos/internet_options_handler.cc',
      'browser/ui/webui/options/chromeos/internet_options_handler.h',
      'browser/ui/webui/options/chromeos/internet_options_handler_strings.cc',
      'browser/ui/webui/options/chromeos/internet_options_handler_strings.h',
      'browser/ui/webui/options/chromeos/keyboard_handler.cc',
      'browser/ui/webui/options/chromeos/keyboard_handler.h',
      'browser/ui/webui/options/chromeos/pointer_handler.cc',
      'browser/ui/webui/options/chromeos/pointer_handler.h',
      'browser/ui/webui/options/chromeos/power_handler.cc',
      'browser/ui/webui/options/chromeos/power_handler.h',
      'browser/ui/webui/options/chromeos/proxy_handler.cc',
      'browser/ui/webui/options/chromeos/proxy_handler.h',
      'browser/ui/webui/options/chromeos/stats_options_handler.cc',
      'browser/ui/webui/options/chromeos/stats_options_handler.h',
      'browser/ui/webui/options/chromeos/user_image_source.cc',
      'browser/ui/webui/options/chromeos/user_image_source.h',
      'browser/ui/webui/options/clear_browser_data_handler.cc',
      'browser/ui/webui/options/clear_browser_data_handler.h',
      'browser/ui/webui/options/content_settings_handler.cc',
      'browser/ui/webui/options/content_settings_handler.h',
      'browser/ui/webui/options/cookies_view_handler.cc',
      'browser/ui/webui/options/cookies_view_handler.h',
      'browser/ui/webui/options/core_options_handler.cc',
      'browser/ui/webui/options/core_options_handler.h',
      'browser/ui/webui/options/create_profile_handler.cc',
      'browser/ui/webui/options/create_profile_handler.h',
      'browser/ui/webui/options/easy_unlock_handler.cc',
      'browser/ui/webui/options/easy_unlock_handler.h',
      'browser/ui/webui/options/font_settings_handler.cc',
      'browser/ui/webui/options/font_settings_handler.h',
      'browser/ui/webui/options/font_settings_utils.h',
      'browser/ui/webui/options/font_settings_utils_linux.cc',
      'browser/ui/webui/options/font_settings_utils_mac.mm',
      'browser/ui/webui/options/font_settings_utils_win.cc',
      'browser/ui/webui/options/handler_options_handler.cc',
      'browser/ui/webui/options/handler_options_handler.h',
      'browser/ui/webui/options/help_overlay_handler.cc',
      'browser/ui/webui/options/help_overlay_handler.h',
      'browser/ui/webui/options/home_page_overlay_handler.cc',
      'browser/ui/webui/options/home_page_overlay_handler.h',
      'browser/ui/webui/options/import_data_handler.cc',
      'browser/ui/webui/options/import_data_handler.h',
      'browser/ui/webui/options/language_dictionary_overlay_handler.cc',
      'browser/ui/webui/options/language_dictionary_overlay_handler.h',
      'browser/ui/webui/options/language_options_handler.cc',
      'browser/ui/webui/options/language_options_handler.h',
      'browser/ui/webui/options/language_options_handler_common.cc',
      'browser/ui/webui/options/language_options_handler_common.h',
      'browser/ui/webui/options/manage_profile_handler.cc',
      'browser/ui/webui/options/manage_profile_handler.h',
      'browser/ui/webui/options/media_devices_selection_handler.cc',
      'browser/ui/webui/options/media_devices_selection_handler.h',
      'browser/ui/webui/options/options_handlers_helper.cc',
      'browser/ui/webui/options/options_handlers_helper.h',
      'browser/ui/webui/options/options_ui.cc',
      'browser/ui/webui/options/options_ui.h',
      'browser/ui/webui/options/password_manager_handler.cc',
      'browser/ui/webui/options/password_manager_handler.h',
      'browser/ui/webui/options/pepper_flash_content_settings_utils.cc',
      'browser/ui/webui/options/pepper_flash_content_settings_utils.h',
      'browser/ui/webui/options/reset_profile_settings_handler.cc',
      'browser/ui/webui/options/reset_profile_settings_handler.h',
      'browser/ui/webui/options/search_engine_manager_handler.cc',
      'browser/ui/webui/options/search_engine_manager_handler.h',
      'browser/ui/webui/options/startup_pages_handler.cc',
      'browser/ui/webui/options/startup_pages_handler.h',
      'browser/ui/webui/options/supervised_user_create_confirm_handler.cc',
      'browser/ui/webui/options/supervised_user_create_confirm_handler.h',
      'browser/ui/webui/options/supervised_user_import_handler.cc',
      'browser/ui/webui/options/supervised_user_import_handler.h',
      'browser/ui/webui/options/supervised_user_learn_more_handler.cc',
      'browser/ui/webui/options/supervised_user_learn_more_handler.h',
      'browser/ui/webui/options/sync_setup_handler.cc',
      'browser/ui/webui/options/sync_setup_handler.h',
      'browser/ui/webui/policy_indicator_localized_strings_provider.cc',
      'browser/ui/webui/policy_indicator_localized_strings_provider.h',
      'browser/ui/webui/profile_info_watcher.cc',
      'browser/ui/webui/profile_info_watcher.h',
      'browser/ui/webui/quota_internals/quota_internals_handler.cc',
      'browser/ui/webui/quota_internals/quota_internals_handler.h',
      'browser/ui/webui/quota_internals/quota_internals_proxy.cc',
      'browser/ui/webui/quota_internals/quota_internals_proxy.h',
      'browser/ui/webui/quota_internals/quota_internals_types.cc',
      'browser/ui/webui/quota_internals/quota_internals_types.h',
      'browser/ui/webui/quota_internals/quota_internals_ui.cc',
      'browser/ui/webui/quota_internals/quota_internals_ui.h',
      'browser/ui/webui/settings/appearance_handler.cc',
      'browser/ui/webui/settings/appearance_handler.h',
      'browser/ui/webui/settings/downloads_handler.cc',
      'browser/ui/webui/settings/downloads_handler.h',
      'browser/ui/webui/settings/font_handler.cc',
      'browser/ui/webui/settings/font_handler.h',
      'browser/ui/webui/settings/languages_handler.cc',
      'browser/ui/webui/settings/languages_handler.h',
      'browser/ui/webui/settings/md_settings_localized_strings_provider.cc',
      'browser/ui/webui/settings/md_settings_localized_strings_provider.h',
      'browser/ui/webui/settings/md_settings_ui.cc',
      'browser/ui/webui/settings/md_settings_ui.h',
      'browser/ui/webui/settings/settings_clear_browsing_data_handler.cc',
      'browser/ui/webui/settings/settings_clear_browsing_data_handler.h',
      'browser/ui/webui/settings/settings_default_browser_handler.cc',
      'browser/ui/webui/settings/settings_default_browser_handler.h',
      'browser/ui/webui/settings/settings_startup_pages_handler.cc',
      'browser/ui/webui/settings/settings_startup_pages_handler.h',
      'browser/ui/webui/settings/sync_handler.cc',
      'browser/ui/webui/settings/sync_handler.h',
      'browser/ui/webui/signin/inline_login_handler.cc',
      'browser/ui/webui/signin/inline_login_handler.h',
      'browser/ui/webui/signin/inline_login_ui.cc',
      'browser/ui/webui/signin/inline_login_ui.h',
      'browser/ui/webui/signin/login_ui_service.cc',
      'browser/ui/webui/signin/login_ui_service.h',
      'browser/ui/webui/signin/login_ui_service_factory.cc',
      'browser/ui/webui/signin/login_ui_service_factory.h',
      'browser/ui/webui/signin/profile_signin_confirmation_dialog.cc',
      'browser/ui/webui/signin/profile_signin_confirmation_dialog.h',
      'browser/ui/webui/signin/profile_signin_confirmation_ui.cc',
      'browser/ui/webui/signin/profile_signin_confirmation_ui.h',
      'browser/ui/webui/sync_file_system_internals/dump_database_handler.cc',
      'browser/ui/webui/sync_file_system_internals/dump_database_handler.h',
      'browser/ui/webui/sync_file_system_internals/extension_statuses_handler.cc',
      'browser/ui/webui/sync_file_system_internals/extension_statuses_handler.h',
      'browser/ui/webui/sync_file_system_internals/file_metadata_handler.cc',
      'browser/ui/webui/sync_file_system_internals/file_metadata_handler.h',
      'browser/ui/webui/sync_file_system_internals/sync_file_system_internals_handler.cc',
      'browser/ui/webui/sync_file_system_internals/sync_file_system_internals_handler.h',
      'browser/ui/webui/sync_file_system_internals/sync_file_system_internals_ui.cc',
      'browser/ui/webui/sync_file_system_internals/sync_file_system_internals_ui.h',
      'browser/ui/webui/system_info_ui.cc',
      'browser/ui/webui/system_info_ui.h',
      'browser/ui/webui/theme_handler.cc',
      'browser/ui/webui/theme_handler.h',
      'browser/ui/webui/uber/uber_ui.cc',
      'browser/ui/webui/uber/uber_ui.h',
      'browser/ui/window_sizer/window_sizer.cc',
      'browser/ui/window_sizer/window_sizer.h',
    ],
    # Cross-platform views sources also ready for toolkit-views on Mac.
    'chrome_browser_ui_views_sources': [
      'browser/ui/app_list/app_list_controller_delegate_views.cc',
      'browser/ui/app_list/app_list_controller_delegate_views.h',
      'browser/ui/app_list/app_list_service_views.cc',
      'browser/ui/app_list/app_list_service_views.h',
      'browser/ui/app_list/app_list_shower_views.cc',
      'browser/ui/app_list/app_list_shower_views.h',
      'browser/ui/browser_dialogs_mac.cc',
      'browser/ui/views/apps/app_info_dialog/app_info_dialog_views.cc',
      'browser/ui/views/apps/app_info_dialog/app_info_dialog_views.h',
      'browser/ui/views/apps/app_info_dialog/app_info_footer_panel.cc',
      'browser/ui/views/apps/app_info_dialog/app_info_footer_panel.h',
      'browser/ui/views/apps/app_info_dialog/app_info_header_panel.cc',
      'browser/ui/views/apps/app_info_dialog/app_info_header_panel.h',
      'browser/ui/views/apps/app_info_dialog/app_info_panel.cc',
      'browser/ui/views/apps/app_info_dialog/app_info_panel.h',
      'browser/ui/views/apps/app_info_dialog/app_info_permissions_panel.cc',
      'browser/ui/views/apps/app_info_dialog/app_info_permissions_panel.h',
      'browser/ui/views/apps/app_info_dialog/app_info_summary_panel.cc',
      'browser/ui/views/apps/app_info_dialog/app_info_summary_panel.h',
      'browser/ui/views/apps/app_window_native_widget_mac.h',
      'browser/ui/views/apps/app_window_native_widget_mac.mm',
      'browser/ui/views/apps/chrome_native_app_window_views.cc',
      'browser/ui/views/apps/chrome_native_app_window_views.h',
      'browser/ui/views/apps/chrome_native_app_window_views_mac.h',
      'browser/ui/views/apps/chrome_native_app_window_views_mac.mm',
      'browser/ui/views/apps/native_app_window_frame_view_mac.h',
      'browser/ui/views/apps/native_app_window_frame_view_mac.mm',
      'browser/ui/views/bookmarks/bookmark_bubble_view.cc',
      'browser/ui/views/bookmarks/bookmark_bubble_view.h',
      'browser/ui/views/bookmarks/bookmark_editor_view.cc',
      'browser/ui/views/bookmarks/bookmark_editor_view.h',
      'browser/ui/views/bookmarks/bookmark_sync_promo_view.cc',
      'browser/ui/views/bookmarks/bookmark_sync_promo_view.h',
      'browser/ui/views/browser_dialogs_views_mac.cc',
      'browser/ui/views/chrome_browser_main_extra_parts_views.cc',
      'browser/ui/views/chrome_browser_main_extra_parts_views.h',
      'browser/ui/views/chrome_constrained_window_views_client.cc',
      'browser/ui/views/chrome_constrained_window_views_client.h',
      'browser/ui/views/chrome_views_delegate.cc',
      'browser/ui/views/chrome_views_delegate.h',
      'browser/ui/views/collected_cookies_views.cc',
      'browser/ui/views/collected_cookies_views.h',
      'browser/ui/views/cookie_info_view.cc',
      'browser/ui/views/cookie_info_view.h',
      'browser/ui/views/extensions/extension_keybinding_registry_views.cc',
      'browser/ui/views/extensions/extension_keybinding_registry_views.h',
      'browser/ui/views/frame/native_widget_mac_frameless_nswindow.h',
      'browser/ui/views/frame/native_widget_mac_frameless_nswindow.mm',
      'browser/ui/views/login_prompt_views.cc',
      'browser/ui/views/login_view.cc',
      'browser/ui/views/login_view.h',
      'browser/ui/views/website_settings/permission_selector_view.cc',
      'browser/ui/views/website_settings/permission_selector_view.h',
      'browser/ui/views/website_settings/permission_selector_view_observer.h',
      'browser/ui/views/website_settings/website_settings_popup_view.cc',
      'browser/ui/views/website_settings/website_settings_popup_view.h',
    ],
    # Views files for everywhere but ChromeOS.
    'chrome_browser_ui_views_non_chromeos_sources': [
      'browser/ui/external_protocol_dialog_delegate.cc',
      'browser/ui/external_protocol_dialog_delegate.h',
      'browser/ui/views/external_protocol_dialog.cc',
      'browser/ui/views/external_protocol_dialog.h',
      'browser/ui/views/frame/opaque_browser_frame_view.cc',
      'browser/ui/views/frame/opaque_browser_frame_view.h',
      'browser/ui/views/frame/opaque_browser_frame_view_layout.cc',
      'browser/ui/views/frame/opaque_browser_frame_view_layout.h',
      'browser/ui/views/frame/opaque_browser_frame_view_layout_delegate.h',
      'browser/ui/views/frame/opaque_browser_frame_view_linux.cc',
      'browser/ui/views/frame/opaque_browser_frame_view_linux.h',
      'browser/ui/views/frame/opaque_browser_frame_view_platform_specific.cc',
      'browser/ui/views/frame/opaque_browser_frame_view_platform_specific.h',
      'browser/ui/views/screen_capture_notification_ui_views.cc',
      'browser/ui/views/sync/one_click_signin_bubble_view.cc',
      'browser/ui/views/sync/one_click_signin_bubble_view.h',
    ],
    # Cross-platform (except Mac) views sources. We assume app list is enabled.
    'chrome_browser_ui_views_non_mac_sources': [
      'browser/ui/views/accelerator_utils_aura.cc',
      'browser/ui/views/accessibility/invert_bubble_view.cc',
      'browser/ui/views/accessibility/invert_bubble_view.h',
      'browser/ui/views/apps/app_window_desktop_native_widget_aura_win.cc',
      'browser/ui/views/apps/app_window_desktop_native_widget_aura_win.h',
      'browser/ui/views/apps/app_window_desktop_window_tree_host_win.cc',
      'browser/ui/views/apps/app_window_desktop_window_tree_host_win.h',
      'browser/ui/views/apps/app_window_easy_resize_window_targeter.cc',
      'browser/ui/views/apps/app_window_easy_resize_window_targeter.h',
      'browser/ui/views/apps/chrome_app_window_client_views_win.cc',
      'browser/ui/views/apps/chrome_native_app_window_views_aura.cc',
      'browser/ui/views/apps/chrome_native_app_window_views_aura.h',
      'browser/ui/views/apps/chrome_native_app_window_views_win.cc',
      'browser/ui/views/apps/chrome_native_app_window_views_win.h',
      'browser/ui/views/apps/glass_app_window_frame_view_win.cc',
      'browser/ui/views/apps/glass_app_window_frame_view_win.h',
      'browser/ui/views/apps/shaped_app_window_targeter.cc',
      'browser/ui/views/apps/shaped_app_window_targeter.h',
      'browser/ui/views/ash/tab_scrubber.cc',
      'browser/ui/views/ash/tab_scrubber.h',
      'browser/ui/views/auto_keep_alive.cc',
      'browser/ui/views/auto_keep_alive.h',
      'browser/ui/views/autofill/autofill_dialog_views.cc',
      'browser/ui/views/autofill/autofill_dialog_views.h',
      'browser/ui/views/autofill/autofill_popup_base_view.cc',
      'browser/ui/views/autofill/autofill_popup_base_view.h',
      'browser/ui/views/autofill/autofill_popup_view_views.cc',
      'browser/ui/views/autofill/autofill_popup_view_views.h',
      'browser/ui/views/autofill/card_unmask_prompt_views.cc',
      'browser/ui/views/autofill/card_unmask_prompt_views.h',
      'browser/ui/views/autofill/decorated_textfield.cc',
      'browser/ui/views/autofill/decorated_textfield.h',
      'browser/ui/views/autofill/expanding_textfield.cc',
      'browser/ui/views/autofill/expanding_textfield.h',
      'browser/ui/views/autofill/info_bubble.cc',
      'browser/ui/views/autofill/info_bubble.h',
      'browser/ui/views/autofill/new_credit_card_bubble_views.cc',
      'browser/ui/views/autofill/new_credit_card_bubble_views.h',
      'browser/ui/views/autofill/password_generation_popup_view_views.cc',
      'browser/ui/views/autofill/password_generation_popup_view_views.h',
      'browser/ui/views/autofill/save_card_bubble_views.cc',
      'browser/ui/views/autofill/save_card_bubble_views.h',
      'browser/ui/views/autofill/save_card_icon_view.cc',
      'browser/ui/views/autofill/save_card_icon_view.h',
      'browser/ui/views/autofill/tooltip_icon.cc',
      'browser/ui/views/autofill/tooltip_icon.h',
      'browser/ui/views/bar_control_button.cc',
      'browser/ui/views/bar_control_button.h',
      'browser/ui/views/bookmarks/bookmark_bar_instructions_view.cc',
      'browser/ui/views/bookmarks/bookmark_bar_instructions_view.h',
      'browser/ui/views/bookmarks/bookmark_bar_view.cc',
      'browser/ui/views/bookmarks/bookmark_bar_view.h',
      'browser/ui/views/bookmarks/bookmark_bar_view_observer.h',
      'browser/ui/views/bookmarks/bookmark_context_menu.cc',
      'browser/ui/views/bookmarks/bookmark_context_menu.h',
      'browser/ui/views/bookmarks/bookmark_drag_drop_views.cc',
      'browser/ui/views/bookmarks/bookmark_menu_controller_observer.h',
      'browser/ui/views/bookmarks/bookmark_menu_controller_views.cc',
      'browser/ui/views/bookmarks/bookmark_menu_controller_views.h',
      'browser/ui/views/bookmarks/bookmark_menu_delegate.cc',
      'browser/ui/views/bookmarks/bookmark_menu_delegate.h',
      'browser/ui/views/browser_dialogs_views.cc',
      'browser/ui/views/certificate_selector.cc',
      'browser/ui/views/certificate_selector.h',
      'browser/ui/views/certificate_viewer_win.cc',
      'browser/ui/views/chrome_javascript_native_dialog_factory_views.cc',
      'browser/ui/views/chrome_views_delegate_chromeos.cc',
      'browser/ui/views/chrome_web_dialog_view.cc',
      'browser/ui/views/color_chooser_aura.cc',
      'browser/ui/views/color_chooser_aura.h',
      'browser/ui/views/color_chooser_win.cc',
      'browser/ui/views/confirm_bubble_views.cc',
      'browser/ui/views/confirm_bubble_views.h',
      'browser/ui/views/conflicting_module_view_win.cc',
      'browser/ui/views/conflicting_module_view_win.h',
      'browser/ui/views/constrained_web_dialog_delegate_views.cc',
      'browser/ui/views/content_setting_bubble_contents.cc',
      'browser/ui/views/content_setting_bubble_contents.h',
      'browser/ui/views/create_application_shortcut_view.cc',
      'browser/ui/views/create_application_shortcut_view.h',
      'browser/ui/views/critical_notification_bubble_view.cc',
      'browser/ui/views/critical_notification_bubble_view.h',
      'browser/ui/views/download/download_danger_prompt_views.cc',
      'browser/ui/views/download/download_feedback_dialog_view.cc',
      'browser/ui/views/download/download_feedback_dialog_view.h',
      'browser/ui/views/download/download_in_progress_dialog_view.cc',
      'browser/ui/views/download/download_in_progress_dialog_view.h',
      'browser/ui/views/download/download_item_view.cc',
      'browser/ui/views/download/download_item_view.h',
      'browser/ui/views/download/download_item_view_md.cc',
      'browser/ui/views/download/download_item_view_md.h',
      'browser/ui/views/download/download_shelf_context_menu_view.cc',
      'browser/ui/views/download/download_shelf_context_menu_view.h',
      'browser/ui/views/download/download_shelf_view.cc',
      'browser/ui/views/download/download_shelf_view.h',
      'browser/ui/views/download/download_started_animation_views.cc',
      'browser/ui/views/dropdown_bar_host.cc',
      'browser/ui/views/dropdown_bar_host.h',
      'browser/ui/views/dropdown_bar_host_aura.cc',
      'browser/ui/views/dropdown_bar_host_delegate.h',
      'browser/ui/views/dropdown_bar_host_mac.mm',
      'browser/ui/views/dropdown_bar_view.cc',
      'browser/ui/views/dropdown_bar_view.h',
      'browser/ui/views/edit_search_engine_dialog.cc',
      'browser/ui/views/edit_search_engine_dialog.h',
      'browser/ui/views/elevation_icon_setter.cc',
      'browser/ui/views/elevation_icon_setter.h',
      'browser/ui/views/exclusive_access_bubble_views.cc',
      'browser/ui/views/exclusive_access_bubble_views.h',
      'browser/ui/views/exclusive_access_bubble_views_context.h',
      'browser/ui/views/find_bar_host.cc',
      'browser/ui/views/find_bar_host.h',
      'browser/ui/views/find_bar_view.cc',
      'browser/ui/views/find_bar_view.h',
      'browser/ui/views/first_run_bubble.cc',
      'browser/ui/views/first_run_bubble.h',
      'browser/ui/views/frame/browser_command_handler_linux.cc',
      'browser/ui/views/frame/browser_command_handler_linux.h',
      'browser/ui/views/frame/browser_frame.cc',
      'browser/ui/views/frame/browser_frame.h',
      'browser/ui/views/frame/browser_frame_android.cc',
      'browser/ui/views/frame/browser_frame_android.h',
      'browser/ui/views/frame/browser_frame_common_win.cc',
      'browser/ui/views/frame/browser_frame_common_win.h',
      'browser/ui/views/frame/browser_frame_mac.h',
      'browser/ui/views/frame/browser_frame_mac.mm',
      'browser/ui/views/frame/browser_non_client_frame_view.cc',
      'browser/ui/views/frame/browser_non_client_frame_view.h',
      'browser/ui/views/frame/browser_non_client_frame_view_factory_aura.cc',
      'browser/ui/views/frame/browser_non_client_frame_view_factory_mac.mm',
      'browser/ui/views/frame/browser_non_client_frame_view_mac.h',
      'browser/ui/views/frame/browser_non_client_frame_view_mac.mm',
      'browser/ui/views/frame/browser_root_view.cc',
      'browser/ui/views/frame/browser_root_view.h',
      'browser/ui/views/frame/browser_shutdown.cc',
      'browser/ui/views/frame/browser_shutdown.h',
      'browser/ui/views/frame/browser_view.cc',
      'browser/ui/views/frame/browser_view.h',
      'browser/ui/views/frame/browser_view_layout.cc',
      'browser/ui/views/frame/browser_view_layout.h',
      'browser/ui/views/frame/browser_view_layout_delegate.h',
      'browser/ui/views/frame/browser_window_factory.cc',
      'browser/ui/views/frame/browser_window_property_manager_win.cc',
      'browser/ui/views/frame/browser_window_property_manager_win.h',
      'browser/ui/views/frame/contents_layout_manager.cc',
      'browser/ui/views/frame/contents_layout_manager.h',
      'browser/ui/views/frame/contents_web_view.cc',
      'browser/ui/views/frame/contents_web_view.h',
      'browser/ui/views/frame/immersive_mode_controller.cc',
      'browser/ui/views/frame/immersive_mode_controller.h',
      'browser/ui/views/frame/immersive_mode_controller_factory_ash.cc',
      'browser/ui/views/frame/immersive_mode_controller_factory_mac.cc',
      'browser/ui/views/frame/immersive_mode_controller_stub.cc',
      'browser/ui/views/frame/immersive_mode_controller_stub.h',
      'browser/ui/views/frame/minimize_button_metrics_win.cc',
      'browser/ui/views/frame/minimize_button_metrics_win.h',
      'browser/ui/views/frame/native_browser_frame.h',
      'browser/ui/views/frame/native_browser_frame_factory.cc',
      'browser/ui/views/frame/native_browser_frame_factory.h',
      'browser/ui/views/frame/native_browser_frame_factory_android.cc',
      'browser/ui/views/frame/native_browser_frame_factory_chromeos.cc',
      'browser/ui/views/frame/native_browser_frame_factory_mac.mm',
      'browser/ui/views/frame/system_menu_insertion_delegate_win.cc',
      'browser/ui/views/frame/system_menu_insertion_delegate_win.h',
      'browser/ui/views/frame/system_menu_model_builder.cc',
      'browser/ui/views/frame/system_menu_model_builder.h',
      'browser/ui/views/frame/system_menu_model_delegate.cc',
      'browser/ui/views/frame/system_menu_model_delegate.h',
      'browser/ui/views/frame/taskbar_decorator.cc',
      'browser/ui/views/frame/taskbar_decorator.h',
      'browser/ui/views/frame/taskbar_decorator_win.cc',
      'browser/ui/views/frame/top_container_view.cc',
      'browser/ui/views/frame/top_container_view.h',
      'browser/ui/views/frame/web_contents_close_handler.cc',
      'browser/ui/views/frame/web_contents_close_handler.h',
      'browser/ui/views/frame/web_contents_close_handler_delegate.h',
      'browser/ui/views/global_error_bubble_view.cc',
      'browser/ui/views/global_error_bubble_view.h',
      'browser/ui/views/hung_renderer_view.cc',
      'browser/ui/views/hung_renderer_view.h',
      'browser/ui/views/importer/import_lock_dialog_view.cc',
      'browser/ui/views/importer/import_lock_dialog_view.h',
      'browser/ui/views/infobars/alternate_nav_infobar_view.cc',
      'browser/ui/views/infobars/alternate_nav_infobar_view.h',
      'browser/ui/views/infobars/confirm_infobar.cc',
      'browser/ui/views/infobars/confirm_infobar.h',
      'browser/ui/views/infobars/infobar_background.cc',
      'browser/ui/views/infobars/infobar_background.h',
      'browser/ui/views/infobars/infobar_container_view.cc',
      'browser/ui/views/infobars/infobar_container_view.h',
      'browser/ui/views/infobars/infobar_view.cc',
      'browser/ui/views/infobars/infobar_view.h',
      'browser/ui/views/layout_constants.cc',
      'browser/ui/views/layout_constants.h',
      'browser/ui/views/load_complete_listener.cc',
      'browser/ui/views/load_complete_listener.h',
      'browser/ui/views/location_bar/background_with_1_px_border.cc',
      'browser/ui/views/location_bar/background_with_1_px_border.h',
      'browser/ui/views/location_bar/bubble_icon_view.cc',
      'browser/ui/views/location_bar/bubble_icon_view.h',
      'browser/ui/views/location_bar/content_setting_image_view.cc',
      'browser/ui/views/location_bar/content_setting_image_view.h',
      'browser/ui/views/location_bar/ev_bubble_view.cc',
      'browser/ui/views/location_bar/ev_bubble_view.h',
      'browser/ui/views/location_bar/icon_label_bubble_view.cc',
      'browser/ui/views/location_bar/icon_label_bubble_view.h',
      'browser/ui/views/location_bar/keyword_hint_view.cc',
      'browser/ui/views/location_bar/keyword_hint_view.h',
      'browser/ui/views/location_bar/location_bar_bubble_delegate_view.cc',
      'browser/ui/views/location_bar/location_bar_bubble_delegate_view.h',
      'browser/ui/views/location_bar/location_bar_decoration_view.cc',
      'browser/ui/views/location_bar/location_bar_decoration_view.h',
      'browser/ui/views/location_bar/location_bar_layout.cc',
      'browser/ui/views/location_bar/location_bar_layout.h',
      'browser/ui/views/location_bar/location_bar_view.cc',
      'browser/ui/views/location_bar/location_bar_view.h',
      'browser/ui/views/location_bar/location_icon_view.cc',
      'browser/ui/views/location_bar/location_icon_view.h',
      'browser/ui/views/location_bar/open_pdf_in_reader_view.cc',
      'browser/ui/views/location_bar/open_pdf_in_reader_view.h',
      'browser/ui/views/location_bar/page_action_image_view.cc',
      'browser/ui/views/location_bar/page_action_image_view.h',
      'browser/ui/views/location_bar/page_action_with_badge_view.cc',
      'browser/ui/views/location_bar/page_action_with_badge_view.h',
      'browser/ui/views/location_bar/page_info_helper.cc',
      'browser/ui/views/location_bar/page_info_helper.h',
      'browser/ui/views/location_bar/selected_keyword_view.cc',
      'browser/ui/views/location_bar/selected_keyword_view.h',
      'browser/ui/views/location_bar/star_view.cc',
      'browser/ui/views/location_bar/star_view.h',
      'browser/ui/views/location_bar/zoom_bubble_view.cc',
      'browser/ui/views/location_bar/zoom_bubble_view.h',
      'browser/ui/views/location_bar/zoom_view.cc',
      'browser/ui/views/location_bar/zoom_view.h',
      'browser/ui/views/new_task_manager_view.cc',
      'browser/ui/views/new_task_manager_view.h',
      'browser/ui/views/omnibox/omnibox_popup_contents_view.cc',
      'browser/ui/views/omnibox/omnibox_popup_contents_view.h',
      'browser/ui/views/omnibox/omnibox_result_view.cc',
      'browser/ui/views/omnibox/omnibox_result_view.h',
      'browser/ui/views/omnibox/omnibox_view_views.cc',
      'browser/ui/views/omnibox/omnibox_view_views.h',
      'browser/ui/views/open_pdf_in_reader_bubble_view.cc',
      'browser/ui/views/open_pdf_in_reader_bubble_view.h',
      'browser/ui/views/outdated_upgrade_bubble_view.cc',
      'browser/ui/views/outdated_upgrade_bubble_view.h',
      'browser/ui/views/panels/panel_frame_view.cc',
      'browser/ui/views/panels/panel_frame_view.h',
      'browser/ui/views/panels/panel_stack_view.cc',
      'browser/ui/views/panels/panel_stack_view.h',
      'browser/ui/views/panels/panel_view.cc',
      'browser/ui/views/panels/panel_view.h',
      'browser/ui/views/panels/taskbar_window_thumbnailer_win.cc',
      'browser/ui/views/panels/taskbar_window_thumbnailer_win.h',
      'browser/ui/views/panels/x11_panel_resizer.cc',
      'browser/ui/views/panels/x11_panel_resizer.h',
      'browser/ui/views/passwords/credentials_item_view.cc',
      'browser/ui/views/passwords/credentials_item_view.h',
      'browser/ui/views/passwords/credentials_selection_view.cc',
      'browser/ui/views/passwords/credentials_selection_view.h',
      'browser/ui/views/passwords/manage_password_items_view.cc',
      'browser/ui/views/passwords/manage_password_items_view.h',
      'browser/ui/views/passwords/manage_passwords_bubble_view.cc',
      'browser/ui/views/passwords/manage_passwords_bubble_view.h',
      'browser/ui/views/passwords/manage_passwords_icon_views.cc',
      'browser/ui/views/passwords/manage_passwords_icon_views.h',
      'browser/ui/views/process_singleton_dialog_linux.cc',
      'browser/ui/views/profiles/avatar_menu_button.cc',
      'browser/ui/views/profiles/avatar_menu_button.h',
      'browser/ui/views/profiles/profile_chooser_view.cc',
      'browser/ui/views/profiles/profile_chooser_view.h',
      'browser/ui/views/profiles/profile_reset_bubble_view.cc',
      'browser/ui/views/profiles/profile_reset_bubble_view.h',
      'browser/ui/views/profiles/supervised_user_avatar_label.cc',
      'browser/ui/views/profiles/supervised_user_avatar_label.h',
      'browser/ui/views/profiles/user_manager_view.cc',
      'browser/ui/views/profiles/user_manager_view.h',
      'browser/ui/views/proximity_auth/proximity_auth_error_bubble_view.cc',
      'browser/ui/views/proximity_auth/proximity_auth_error_bubble_view.h',
      'browser/ui/views/sad_tab_view.cc',
      'browser/ui/views/sad_tab_view.h',
      'browser/ui/views/session_crashed_bubble_view.cc',
      'browser/ui/views/session_crashed_bubble_view.h',
      'browser/ui/views/settings_api_bubble_helper_views.cc',
      'browser/ui/views/settings_api_bubble_helper_views.h',
      'browser/ui/views/simple_message_box_views.cc',
      'browser/ui/views/ssl_client_certificate_selector.cc',
      'browser/ui/views/ssl_client_certificate_selector.h',
      'browser/ui/views/status_bubble_views.cc',
      'browser/ui/views/status_bubble_views.h',
      'browser/ui/views/status_icons/status_icon_win.cc',
      'browser/ui/views/status_icons/status_icon_win.h',
      'browser/ui/views/status_icons/status_tray_linux.cc',
      'browser/ui/views/status_icons/status_tray_linux.h',
      'browser/ui/views/status_icons/status_tray_state_changer_win.cc',
      'browser/ui/views/status_icons/status_tray_state_changer_win.h',
      'browser/ui/views/status_icons/status_tray_win.cc',
      'browser/ui/views/status_icons/status_tray_win.h',
      'browser/ui/views/sync/profile_signin_confirmation_dialog_views.cc',
      'browser/ui/views/sync/profile_signin_confirmation_dialog_views.h',
      'browser/ui/views/tab_dialogs_views.cc',
      'browser/ui/views/tab_dialogs_views.h',
      'browser/ui/views/tab_icon_view.cc',
      'browser/ui/views/tab_icon_view.h',
      'browser/ui/views/tab_modal_confirm_dialog_views.cc',
      'browser/ui/views/tab_modal_confirm_dialog_views.h',
      'browser/ui/views/tabs/browser_tab_strip_controller.cc',
      'browser/ui/views/tabs/browser_tab_strip_controller.h',
      'browser/ui/views/tabs/media_indicator_button.cc',
      'browser/ui/views/tabs/media_indicator_button.h',
      'browser/ui/views/tabs/stacked_tab_strip_layout.cc',
      'browser/ui/views/tabs/stacked_tab_strip_layout.h',
      'browser/ui/views/tabs/tab.cc',
      'browser/ui/views/tabs/tab.h',
      'browser/ui/views/tabs/tab_controller.h',
      'browser/ui/views/tabs/tab_drag_controller.cc',
      'browser/ui/views/tabs/tab_drag_controller.h',
      'browser/ui/views/tabs/tab_strip.cc',
      'browser/ui/views/tabs/tab_strip.h',
      'browser/ui/views/tabs/tab_strip_controller.h',
      'browser/ui/views/tabs/tab_strip_layout.cc',
      'browser/ui/views/tabs/tab_strip_layout.h',
      'browser/ui/views/tabs/window_finder.h',
      'browser/ui/views/tabs/window_finder_chromeos.cc',
      'browser/ui/views/tabs/window_finder_mac.mm',
      'browser/ui/views/tabs/window_finder_win.cc',
      'browser/ui/views/task_manager_view.cc',
      'browser/ui/views/theme_image_mapper.cc',
      'browser/ui/views/theme_image_mapper.h',
      'browser/ui/views/toolbar/app_menu.cc',
      'browser/ui/views/toolbar/app_menu.h',
      'browser/ui/views/toolbar/app_menu_button.cc',
      'browser/ui/views/toolbar/app_menu_button.h',
      'browser/ui/views/toolbar/app_menu_observer.h',
      'browser/ui/views/toolbar/back_button.cc',
      'browser/ui/views/toolbar/back_button.h',
      'browser/ui/views/toolbar/browser_actions_container.cc',
      'browser/ui/views/toolbar/browser_actions_container.h',
      'browser/ui/views/toolbar/chevron_menu_button.cc',
      'browser/ui/views/toolbar/chevron_menu_button.h',
      'browser/ui/views/toolbar/extension_toolbar_menu_view.cc',
      'browser/ui/views/toolbar/extension_toolbar_menu_view.h',
      'browser/ui/views/toolbar/home_button.cc',
      'browser/ui/views/toolbar/home_button.h',
      'browser/ui/views/toolbar/reload_button.cc',
      'browser/ui/views/toolbar/reload_button.h',
      'browser/ui/views/toolbar/toolbar_action_view.cc',
      'browser/ui/views/toolbar/toolbar_action_view.h',
      'browser/ui/views/toolbar/toolbar_action_view_delegate_views.h',
      'browser/ui/views/toolbar/toolbar_button.cc',
      'browser/ui/views/toolbar/toolbar_button.h',
      'browser/ui/views/toolbar/toolbar_view.cc',
      'browser/ui/views/toolbar/toolbar_view.h',
      'browser/ui/views/touch_uma/touch_uma.h',
      'browser/ui/views/translate/translate_bubble_view.cc',
      'browser/ui/views/translate/translate_bubble_view.h',
      'browser/ui/views/translate/translate_icon_view.cc',
      'browser/ui/views/translate/translate_icon_view.h',
      'browser/ui/views/update_recommended_message_box.cc',
      'browser/ui/views/update_recommended_message_box.h',
      'browser/ui/views/validation_message_bubble_delegate.cc',
      'browser/ui/views/validation_message_bubble_delegate.h',
      'browser/ui/views/validation_message_bubble_view.cc',
      'browser/ui/views/validation_message_bubble_view.h',
      'browser/ui/views/web_contents_modal_dialog_manager_views.cc',
      'browser/ui/views/website_settings/permissions_bubble_view.cc',
      'browser/ui/views/website_settings/permissions_bubble_view.h',
    ],
    'chrome_browser_ui_views_extensions_non_mac_sources': [
      'browser/ui/views/extensions/bookmark_app_bubble_view.cc',
      'browser/ui/views/extensions/bookmark_app_bubble_view.h',
      'browser/ui/views/extensions/browser_action_drag_data.cc',
      'browser/ui/views/extensions/browser_action_drag_data.h',
      'browser/ui/views/extensions/bundle_installed_bubble.cc',
      'browser/ui/views/extensions/device_permissions_dialog_view.cc',
      'browser/ui/views/extensions/device_permissions_dialog_view.h',
      'browser/ui/views/extensions/extension_action_platform_delegate_views.cc',
      'browser/ui/views/extensions/extension_action_platform_delegate_views.h',
      'browser/ui/views/extensions/extension_dialog.cc',
      'browser/ui/views/extensions/extension_dialog.h',
      'browser/ui/views/extensions/extension_dialog_observer.cc',
      'browser/ui/views/extensions/extension_dialog_observer.h',
      'browser/ui/views/extensions/extension_install_dialog_view.cc',
      'browser/ui/views/extensions/extension_installed_bubble_view.cc',
      'browser/ui/views/extensions/extension_installed_bubble_view.h',
      'browser/ui/views/extensions/extension_message_bubble_view.cc',
      'browser/ui/views/extensions/extension_message_bubble_view.h',
      'browser/ui/views/extensions/extension_popup.cc',
      'browser/ui/views/extensions/extension_popup.h',
      'browser/ui/views/extensions/extension_popup_aura.cc',
      'browser/ui/views/extensions/extension_popup_aura.h',
      'browser/ui/views/extensions/extension_toolbar_icon_surfacing_bubble_views.cc',
      'browser/ui/views/extensions/extension_toolbar_icon_surfacing_bubble_views.h',
      'browser/ui/views/extensions/extension_uninstall_dialog_view.cc',
      'browser/ui/views/extensions/extension_view_views.cc',
      'browser/ui/views/extensions/extension_view_views.h',
      'browser/ui/views/extensions/media_galleries_dialog_views.cc',
      'browser/ui/views/extensions/media_galleries_dialog_views.h',
      'browser/ui/views/extensions/media_gallery_checkbox_view.cc',
      'browser/ui/views/extensions/media_gallery_checkbox_view.h',
    ],
    # MacViews sources that we still want to keep behind a compile-time flag.
    # TODO(jackhou): Move items to chrome_browser_ui_views_sources when they
    # migrate from mac_views_browser to a chrome://flag.
    'chrome_browser_ui_views_mac_experimental_sources': [
      'browser/ui/views/apps/chrome_app_window_client_views_mac.mm',
      'browser/ui/views/infobars/save_password_infobar.cc',
    ],
    # Windows-only. Assume ash/aura/views.
    'chrome_browser_ui_win_sources': [
      'browser/ui/network_profile_bubble.cc',
      'browser/ui/network_profile_bubble.h',
      'browser/ui/views/color_chooser_dialog.cc',
      'browser/ui/views/color_chooser_dialog.h',
      'browser/ui/views/frame/browser_desktop_window_tree_host.h',
      'browser/ui/views/frame/browser_desktop_window_tree_host_win.cc',
      'browser/ui/views/frame/browser_desktop_window_tree_host_win.h',
      'browser/ui/views/frame/browser_frame_ashwin.cc',
      'browser/ui/views/frame/browser_frame_ashwin.h',
      'browser/ui/views/frame/glass_browser_frame_view.cc',
      'browser/ui/views/frame/glass_browser_frame_view.h',
      'browser/ui/views/frame/native_browser_frame_factory_aurawin.cc',
      'browser/ui/views/frame/native_browser_frame_factory_desktop_ash.cc',
      'browser/ui/views/network_profile_bubble_view.cc',
      'browser/ui/views/network_profile_bubble_view.h',
      'browser/ui/views/uninstall_view.cc',
      'browser/ui/views/uninstall_view.h',
      'browser/ui/webui/conflicts_ui.cc',
      'browser/ui/webui/conflicts_ui.h',
      'browser/ui/webui/set_as_default_browser_ui.cc',
      'browser/ui/webui/set_as_default_browser_ui.h',
    ],
    # Compiled for X11: desktop Linux and ChromeOS. We assume aura/views/ash.
    'chrome_browser_ui_x11_sources': [
      'browser/ui/views/javascript_app_modal_event_blocker_x11.cc',
      'browser/ui/views/javascript_app_modal_event_blocker_x11.h',
      'browser/ui/views/tabs/window_finder_x11.cc',
    ],

    ### Feature-based sources ###
    # Variables should generally be alphabetical within this section.

    # Note that we assume app list is enabled on all views builds, so the
    # views-specific app list files are in the views section.
    'chrome_browser_ui_app_list_sources': [
      'browser/ui/app_list/app_context_menu.cc',
      'browser/ui/app_list/app_context_menu.h',
      'browser/ui/app_list/app_context_menu_delegate.h',
      'browser/ui/app_list/app_list_controller_delegate.cc',
      'browser/ui/app_list/app_list_controller_delegate.h',
      'browser/ui/app_list/app_list_controller_delegate_impl.cc',
      'browser/ui/app_list/app_list_controller_delegate_impl.h',
      'browser/ui/app_list/app_list_icon_win.cc',
      'browser/ui/app_list/app_list_icon_win.h',
      'browser/ui/app_list/app_list_positioner.cc',
      'browser/ui/app_list/app_list_positioner.h',
      'browser/ui/app_list/app_list_prefs.cc',
      'browser/ui/app_list/app_list_prefs.h',
      'browser/ui/app_list/app_list_prefs_factory.cc',
      'browser/ui/app_list/app_list_prefs_factory.h',
      'browser/ui/app_list/app_list_service.cc',
      'browser/ui/app_list/app_list_service.h',
      'browser/ui/app_list/app_list_service_cocoa_mac.h',
      'browser/ui/app_list/app_list_service_cocoa_mac.mm',
      'browser/ui/app_list/app_list_service_impl.cc',
      'browser/ui/app_list/app_list_service_impl.h',
      'browser/ui/app_list/app_list_service_mac.h',
      'browser/ui/app_list/app_list_service_mac.mm',
      'browser/ui/app_list/app_list_shower_delegate.h',
      'browser/ui/app_list/app_list_syncable_service.cc',
      'browser/ui/app_list/app_list_syncable_service.h',
      'browser/ui/app_list/app_list_syncable_service_factory.cc',
      'browser/ui/app_list/app_list_syncable_service_factory.h',
      'browser/ui/app_list/app_list_view_delegate.cc',
      'browser/ui/app_list/app_list_view_delegate.h',
      'browser/ui/app_list/extension_app_item.cc',
      'browser/ui/app_list/extension_app_item.h',
      'browser/ui/app_list/extension_app_model_builder.cc',
      'browser/ui/app_list/extension_app_model_builder.h',
      'browser/ui/app_list/extension_uninstaller.cc',
      'browser/ui/app_list/extension_uninstaller.h',
      'browser/ui/app_list/fast_show_pickler.cc',
      'browser/ui/app_list/fast_show_pickler.h',
      'browser/ui/app_list/google_now_extension.cc',
      'browser/ui/app_list/google_now_extension.h',
      'browser/ui/app_list/launcher_page_event_dispatcher.cc',
      'browser/ui/app_list/launcher_page_event_dispatcher.h',
      'browser/ui/app_list/model_pref_updater.cc',
      'browser/ui/app_list/model_pref_updater.h',
      'browser/ui/app_list/profile_loader.cc',
      'browser/ui/app_list/profile_loader.h',
      'browser/ui/app_list/profile_store.h',
      'browser/ui/app_list/search/app_result.cc',
      'browser/ui/app_list/search/app_result.h',
      'browser/ui/app_list/search/app_search_provider.cc',
      'browser/ui/app_list/search/app_search_provider.h',
      'browser/ui/app_list/search/common/json_response_fetcher.cc',
      'browser/ui/app_list/search/common/json_response_fetcher.h',
      'browser/ui/app_list/search/common/url_icon_source.cc',
      'browser/ui/app_list/search/common/url_icon_source.h',
      'browser/ui/app_list/search/common/webservice_cache.cc',
      'browser/ui/app_list/search/common/webservice_cache.h',
      'browser/ui/app_list/search/common/webservice_cache_factory.cc',
      'browser/ui/app_list/search/common/webservice_cache_factory.h',
      'browser/ui/app_list/search/common/webservice_search_provider.cc',
      'browser/ui/app_list/search/common/webservice_search_provider.h',
      'browser/ui/app_list/search/history_factory.cc',
      'browser/ui/app_list/search/history_factory.h',
      'browser/ui/app_list/search/omnibox_provider.cc',
      'browser/ui/app_list/search/omnibox_provider.h',
      'browser/ui/app_list/search/omnibox_result.cc',
      'browser/ui/app_list/search/omnibox_result.h',
      'browser/ui/app_list/search/people/people_provider.cc',
      'browser/ui/app_list/search/people/people_provider.h',
      'browser/ui/app_list/search/people/people_result.cc',
      'browser/ui/app_list/search/people/people_result.h',
      'browser/ui/app_list/search/people/person.cc',
      'browser/ui/app_list/search/people/person.h',
      'browser/ui/app_list/search/search_controller_factory.cc',
      'browser/ui/app_list/search/search_controller_factory.h',
      'browser/ui/app_list/search/search_resource_manager.cc',
      'browser/ui/app_list/search/search_resource_manager.h',
      'browser/ui/app_list/search/search_util.cc',
      'browser/ui/app_list/search/search_util.h',
      'browser/ui/app_list/search/search_webstore_result.cc',
      'browser/ui/app_list/search/search_webstore_result.h',
      'browser/ui/app_list/search/suggestions/suggestions_search_provider.cc',
      'browser/ui/app_list/search/suggestions/suggestions_search_provider.h',
      'browser/ui/app_list/search/suggestions/url_suggestion_result.cc',
      'browser/ui/app_list/search/suggestions/url_suggestion_result.h',
      'browser/ui/app_list/search/webstore/webstore_installer.cc',
      'browser/ui/app_list/search/webstore/webstore_installer.h',
      'browser/ui/app_list/search/webstore/webstore_provider.cc',
      'browser/ui/app_list/search/webstore/webstore_provider.h',
      'browser/ui/app_list/search/webstore/webstore_result.cc',
      'browser/ui/app_list/search/webstore/webstore_result.h',
      'browser/ui/app_list/speech_auth_helper.cc',
      'browser/ui/app_list/speech_auth_helper.h',
      'browser/ui/app_list/speech_recognizer.cc',
      'browser/ui/app_list/speech_recognizer.h',
      'browser/ui/app_list/speech_recognizer_delegate.h',
      'browser/ui/app_list/start_page_observer.h',
      'browser/ui/app_list/start_page_service.cc',
      'browser/ui/app_list/start_page_service.h',
      'browser/ui/app_list/start_page_service_factory.cc',
      'browser/ui/app_list/start_page_service_factory.h',
      'browser/ui/views/app_list/app_list_dialog_container.cc',
      'browser/ui/views/app_list/app_list_dialog_container.h',
      'browser/ui/views/app_list/win/activation_tracker_win.cc',
      'browser/ui/views/app_list/win/activation_tracker_win.h',
      'browser/ui/views/app_list/win/app_list_controller_delegate_win.cc',
      'browser/ui/views/app_list/win/app_list_controller_delegate_win.h',
      'browser/ui/views/app_list/win/app_list_service_win.cc',
      'browser/ui/views/app_list/win/app_list_service_win.h',
      'browser/ui/views/app_list/win/app_list_win.cc',
      'browser/ui/views/app_list/win/app_list_win.h',
      'browser/ui/webui/app_list/start_page_handler.cc',
      'browser/ui/webui/app_list/start_page_handler.h',
      'browser/ui/webui/app_list/start_page_ui.cc',
      'browser/ui/webui/app_list/start_page_ui.h',
    ],
    # Used when the app list is disabled.
    'chrome_browser_ui_non_app_list_sources': [
      'browser/ui/app_list/app_list_service_disabled.cc',
    ],
    # Autofill sources used everywhere autofill dialog is enabled.
    'chrome_browser_ui_autofill_dialog_sources': [
      'browser/ui/autofill/autofill_dialog_common.cc',
      'browser/ui/autofill/autofill_dialog_common.h',
    ],
    # Autofill sources used on desktop and ChromeOS.
    'chrome_browser_ui_autofill_dialog_non_mobile_sources': [
      'browser/ui/autofill/autofill_dialog_controller_impl.cc',
      'browser/ui/autofill/autofill_dialog_controller_impl.h',
      'browser/ui/autofill/autofill_dialog_i18n_input.cc',
      'browser/ui/autofill/autofill_dialog_i18n_input.h',
      'browser/ui/autofill/autofill_dialog_view.cc',
      'browser/ui/autofill/autofill_dialog_view.h',
      'browser/ui/autofill/autofill_dialog_view_delegate.h',
      'browser/ui/autofill/data_model_wrapper.cc',
      'browser/ui/autofill/data_model_wrapper.h',
    ],
    'chrome_browser_ui_extensions_sources': [
      'browser/ui/extensions/accelerator_priority.cc',
      'browser/ui/extensions/accelerator_priority.h',
      'browser/ui/extensions/app_launch_params.cc',
      'browser/ui/extensions/app_launch_params.h',
      'browser/ui/extensions/application_launch.cc',
      'browser/ui/extensions/application_launch.h',
      'browser/ui/extensions/extension_action_platform_delegate.h',
      'browser/ui/extensions/extension_action_view_controller.cc',
      'browser/ui/extensions/extension_action_view_controller.h',
      'browser/ui/extensions/extension_enable_flow.cc',
      'browser/ui/extensions/extension_enable_flow.h',
      'browser/ui/extensions/extension_enable_flow_delegate.h',
      'browser/ui/extensions/extension_install_ui_default.cc',
      'browser/ui/extensions/extension_install_ui_default.h',
      'browser/ui/extensions/extension_install_ui_factory.cc',
      'browser/ui/extensions/extension_install_ui_factory.h',
      'browser/ui/extensions/extension_installed_bubble.cc',
      'browser/ui/extensions/extension_installed_bubble.h',
      'browser/ui/extensions/extension_message_bubble_factory.cc',
      'browser/ui/extensions/extension_message_bubble_factory.h',
      'browser/ui/extensions/extension_toolbar_icon_surfacing_bubble_delegate.cc',
      'browser/ui/extensions/extension_toolbar_icon_surfacing_bubble_delegate.h',
      'browser/ui/extensions/hosted_app_browser_controller.cc',
      'browser/ui/extensions/hosted_app_browser_controller.h',
      'browser/ui/webui/extensions/chromeos/kiosk_apps_handler.cc',
      'browser/ui/webui/extensions/chromeos/kiosk_apps_handler.h',
      'browser/ui/webui/extensions/extension_basic_info.cc',
      'browser/ui/webui/extensions/extension_basic_info.h',
      'browser/ui/webui/extensions/extension_icon_source.cc',
      'browser/ui/webui/extensions/extension_icon_source.h',
    ],
    'chrome_browser_ui_google_now_non_android_sources': [
      # These are non-Android because Android excludes all of options.
      'browser/ui/webui/options/geolocation_options_handler.cc',
      'browser/ui/webui/options/geolocation_options_handler.h',
    ],
    'chrome_browser_ui_nacl_sources': [
      'browser/ui/webui/nacl_ui.cc',
      'browser/ui/webui/nacl_ui.h',
    ],
    'chrome_browser_ui_nss_sources': [
      'browser/ui/crypto_module_delegate_nss.cc',
      'browser/ui/crypto_module_delegate_nss.h',
      'browser/ui/crypto_module_password_dialog_nss.cc',
      'browser/ui/crypto_module_password_dialog_nss.h',
      'browser/ui/webui/options/certificate_manager_handler.cc',
      'browser/ui/webui/options/certificate_manager_handler.h',
    ],
    'chrome_browser_ui_omnibox_non_mobile_sources': [
      'browser/ui/omnibox/alternate_nav_infobar_delegate.cc',
      'browser/ui/omnibox/alternate_nav_infobar_delegate.h',
      'browser/ui/omnibox/chrome_omnibox_client.cc',
      'browser/ui/omnibox/chrome_omnibox_client.h',
      'browser/ui/omnibox/chrome_omnibox_edit_controller.cc',
      'browser/ui/omnibox/chrome_omnibox_edit_controller.h',
      'browser/ui/omnibox/chrome_omnibox_navigation_observer.cc',
      'browser/ui/omnibox/chrome_omnibox_navigation_observer.h',
      'browser/ui/omnibox/clipboard_utils.cc',
      'browser/ui/omnibox/clipboard_utils.h',
    ],
    'chrome_browser_ui_plugin_sources': [
      'browser/ui/hung_plugin_tab_helper.cc',
      'browser/ui/hung_plugin_tab_helper.h',
      'browser/ui/webui/flash_ui.cc',
      'browser/ui/webui/flash_ui.h',
      'browser/ui/webui/plugins_ui.cc',
      'browser/ui/webui/plugins_ui.h',
    ],
    'chrome_browser_ui_policy_sources': [
      'browser/ui/webui/policy_ui.cc',
      'browser/ui/webui/policy_ui.h',
    ],
    'chrome_browser_ui_print_preview_sources': [
      'browser/ui/webui/print_preview/extension_printer_handler.cc',
      'browser/ui/webui/print_preview/extension_printer_handler.h',
      'browser/ui/webui/print_preview/print_preview_distiller.cc',
      'browser/ui/webui/print_preview/print_preview_distiller.h',
      'browser/ui/webui/print_preview/print_preview_handler.cc',
      'browser/ui/webui/print_preview/print_preview_handler.h',
      'browser/ui/webui/print_preview/print_preview_ui.cc',
      'browser/ui/webui/print_preview/print_preview_ui.h',
      'browser/ui/webui/print_preview/printer_handler.cc',
      'browser/ui/webui/print_preview/printer_handler.h',
      'browser/ui/webui/print_preview/sticky_settings.cc',
      'browser/ui/webui/print_preview/sticky_settings.h',
    ],
    # For when enable_service_discovery is set.
    'chrome_browser_ui_service_discovery_sources': [
      'browser/ui/webui/local_discovery/local_discovery_ui.cc',
      'browser/ui/webui/local_discovery/local_discovery_ui.h',
      'browser/ui/webui/local_discovery/local_discovery_ui_handler.cc',
      'browser/ui/webui/local_discovery/local_discovery_ui_handler.h',
    ],
    'chrome_browser_ui_toolbar_model_sources': [
      'browser/ui/android/toolbar/toolbar_model_android.cc',
      'browser/ui/android/toolbar/toolbar_model_android.h',
      'browser/ui/toolbar/chrome_toolbar_model.cc',
      'browser/ui/toolbar/chrome_toolbar_model.h',
      'browser/ui/toolbar/toolbar_model_delegate.h',
      'browser/ui/toolbar/toolbar_model_impl.cc',
      'browser/ui/toolbar/toolbar_model_impl.h',
    ],
    'chrome_browser_ui_webrtc_sources': [
      'browser/ui/webui/media/webrtc_logs_ui.cc',
      'browser/ui/webui/media/webrtc_logs_ui.h',
    ],
  },
  'targets': [
    {
      'target_name': 'browser_ui',
      'type': 'static_library',
      'variables': {
        'enable_wexit_time_destructors': 1,
        # TODO(thakis): Remove this once http://crbug.com/383820 is figured out
        'clang_warning_flags': [ '-Wno-nonnull' ],
      },
      # Since browser and browser_ui actually depend on each other,
      # we must omit the dependency from browser_ui to browser.
      # However, this means browser_ui and browser should more or less
      # have the same dependencies. Once browser_ui is untangled from
      # browser, then we can clean up these dependencies.
      'dependencies': [
        # NOTE: New dependencies should generally be added in the OS!="ios"
        # dependencies block below, rather than here.
        'chrome_browser_ui_views.gyp:browser_ui_views',
        'chrome_resources.gyp:chrome_extra_resources',
        'chrome_resources.gyp:chrome_resources',
        'chrome_resources.gyp:chrome_strings',
        'chrome_resources.gyp:platform_locale_settings',
        'chrome_resources.gyp:theme_resources',
        'common',
        '../components/components.gyp:auto_login_parser',
        '../components/components.gyp:certificate_reporting',
        '../components/components.gyp:device_event_log_component',
        '../components/components.gyp:dom_distiller_core',
        '../components/components.gyp:dom_distiller_webui',
        '../components/components.gyp:invalidation_impl',
        '../components/components.gyp:omnibox_common',
        '../components/components.gyp:onc_component',
        '../components/components.gyp:password_manager_core_browser',
        '../components/components.gyp:sync_driver',
        '../components/components.gyp:toolbar',
        '../components/components.gyp:ui_zoom',
        '../components/components.gyp:update_client',
        '../components/components.gyp:version_ui',
        '../components/components_resources.gyp:components_resources',
        '../components/components_strings.gyp:components_strings',
        '../components/url_formatter/url_formatter.gyp:url_formatter',
        '../content/content.gyp:content_browser',
        '../content/content.gyp:content_common',
        '../crypto/crypto.gyp:crypto',
        '../skia/skia.gyp:skia',
        '../sync/sync.gyp:sync',
        '../third_party/cacheinvalidation/cacheinvalidation.gyp:cacheinvalidation',
        '../third_party/cacheinvalidation/cacheinvalidation.gyp:cacheinvalidation_proto_cpp',
        '../third_party/icu/icu.gyp:icui18n',
        '../third_party/icu/icu.gyp:icuuc',
        '../third_party/zlib/zlib.gyp:zlib',
        '../ui/accessibility/accessibility.gyp:accessibility',
        '../ui/base/ui_base.gyp:ui_base',
        '../ui/content_accelerators/ui_content_accelerators.gyp:ui_content_accelerators',
        '../ui/events/events.gyp:events',
        '../ui/events/events.gyp:gesture_detection',
        '../ui/gfx/gfx.gyp:gfx',
        '../ui/gfx/gfx.gyp:gfx_geometry',
        '../ui/message_center/message_center.gyp:message_center',
        '../ui/resources/ui_resources.gyp:ui_resources',
        '../ui/snapshot/snapshot.gyp:snapshot',
        '../ui/strings/ui_strings.gyp:ui_strings',
      ],
      'include_dirs': [
        '..',
        '<(INTERMEDIATE_DIR)',
        # Needed by pepper_flash_component_installer.cc.
        '<(SHARED_INTERMEDIATE_DIR)',
      ],
      'export_dependent_settings': [
        '../components/components.gyp:dom_distiller_core',
        '../sync/sync.gyp:sync',
      ],
      'includes': [
        # Disable LTO due to undefined reference
        # crbug.com/422252
        '../build/android/disable_gcc_lto.gypi',
      ],
      'conditions': [
        ['OS != "ios"', {
          'sources': [
            '<@(chrome_browser_ui_non_ios_sources)',
            '<@(chrome_browser_ui_toolbar_model_sources)',
            '<(SHARED_INTERMEDIATE_DIR)/chrome/browser/ui/webui/engagement/site_engagement.mojom.cc',
            '<(SHARED_INTERMEDIATE_DIR)/chrome/browser/ui/webui/omnibox/omnibox.mojom.cc',
          ],
          'dependencies': [
            'chrome_web_ui_mojo_bindings.gyp:web_ui_mojo_bindings',
            'common_net',
            'debugger',
            'installer_util',
            '../components/components.gyp:app_modal',
            '../components/components.gyp:autofill_content_risk_proto',
            '../components/components.gyp:crash_core_browser',
            '../components/components.gyp:flags_ui',
            '../components/components.gyp:net_log',
            '../components/components.gyp:page_load_metrics_browser',
            '../components/components.gyp:translate_content_common',
            '../content/app/resources/content_resources.gyp:content_resources',
            '../media/media.gyp:media',
            '../net/net.gyp:net_with_v8',
            '../storage/storage_browser.gyp:storage',
            '../storage/storage_common.gyp:storage_common',
            '../third_party/leveldatabase/leveldatabase.gyp:leveldatabase',
            '../third_party/mojo/mojo_edk.gyp:mojo_system_impl',
            '../third_party/re2/re2.gyp:re2',
            '../ui/base/ime/ui_base_ime.gyp:ui_base_ime',
            '../ui/compositor/compositor.gyp:compositor',
            '../ui/native_theme/native_theme.gyp:native_theme',
            '../ui/surface/surface.gyp:surface',
            '../ui/web_dialogs/web_dialogs.gyp:web_dialogs',
            '../v8/tools/gyp/v8.gyp:v8',
          ],
        }, {  # OS == "ios"
          'sources': [
            '<@(chrome_browser_ui_ios_sources)'
          ],
          'sources!': [
            'browser/ui/external_protocol_dialog_delegate.cc',
          ],
          'dependencies': [
            '../net/net.gyp:net',
          ],
        }],
        ['enable_basic_printing==1 or enable_print_preview==1', {
          'dependencies': [
            '../printing/printing.gyp:printing',
          ],
        }],
        ['disable_nacl==0', {
          'sources': [ '<@(chrome_browser_ui_nacl_sources)' ],
          'dependencies': [
            '../native_client/src/trusted/service_runtime/service_runtime.gyp:sel',
          ],
        }],
        ['debug_devtools==1', {
          'defines': [
            'DEBUG_DEVTOOLS=1',
          ],
        }],
        ['configuration_policy==1', {
          'sources': [ '<@(chrome_browser_ui_policy_sources)' ],
          'dependencies': [
            '../components/components.gyp:policy',
          ],
        }],
        ['enable_plugins==1', {
          'sources': [ '<@(chrome_browser_ui_plugin_sources)' ],
          'dependencies': [
            '../ppapi/ppapi_internal.gyp:ppapi_ipc',
            '../third_party/adobe/flash/flash_player.gyp:flapper_version_h',
          ],
        }],
        ['safe_browsing==1', {
          'dependencies': [
            'safe_browsing_chunk_proto',
            'safe_browsing_proto',
          ],
        }],
        ['buildtype!="Official" and chromeos==1', {
          'sources': [ '<@(chrome_browser_ui_chromeos_non_official_sources)' ],
        }],
        ['chromeos==1', {
          'sources': [ '<@(chrome_browser_ui_chromeos_sources)' ],
          'dependencies': [
            'browser_chromeos',
            '../components/components.gyp:proximity_auth_webui',
            '../device/nfc/nfc.gyp:device_nfc',
            '../ui/chromeos/ui_chromeos.gyp:ui_chromeos',
            '../ui/chromeos/ui_chromeos.gyp:ui_chromeos_resources',
          ],
        }],
        ['use_cups==1', {
          'dependencies': [
            '../printing/printing.gyp:cups',
          ],
        }],
        ['use_ash==1', {
          'sources': [ '<@(chrome_browser_ui_ash_sources)' ],
          'dependencies': [
            '../ash/ash.gyp:ash',
            '../ash/ash.gyp:ash_with_content',
            '../ash/ash_strings.gyp:ash_strings',
            '../components/components.gyp:user_manager',
          ],
          'conditions': [
            ['chromeos == 0', {
              'sources': [ '<@(chrome_browser_ui_ash_non_chromeos)' ],
            }],
          ],
        }, { # use_ash==0
          'sources': [ '<@(chrome_browser_ui_non_ash_sources)' ],
        }],
        ['toolkit_views==1', {
          'sources': [ '<@(chrome_browser_ui_views_sources)' ],
          'dependencies': [
            '<(DEPTH)/components/components.gyp:constrained_window',
          ],
          'conditions': [
            ['chromeos == 0 and (OS!="mac" or mac_views_browser==1)', {
              'sources': [ '<@(chrome_browser_ui_views_non_chromeos_sources)' ],
            }],
            ['use_ash == 1', {
              'sources': [ '<@(chrome_browser_ui_ash_views_sources)' ],
            }],
            ['OS!="mac"', {
              'sources': [ '<@(chrome_browser_ui_views_non_mac_sources)' ],
              'dependencies': [
                '../ui/gfx/gfx.gyp:gfx_vector_icons',
              ],
              'conditions': [
                ['enable_extensions==1', {
                  'sources': [ '<@(chrome_browser_ui_views_extensions_non_mac_sources)' ],
                }],
              ],
            }],
            ['OS=="android"', {
              'sources': [ '<@(chrome_browser_ui_views_android_sources)' ],
            }],
            ['enable_extensions==1', {
              'dependencies': [
                '<(DEPTH)/extensions/components/extensions_components.gyp:native_app_window',
              ],
            }],
          ],
        }],
        ['use_aura==1 and chromeos==0 and use_ozone==0 and OS=="linux"', {
          'dependencies': [
            # gtk2 is the only component that can interact with gtk2 in our new
            # world.
            'browser/ui/libgtk2ui/libgtk2ui.gyp:gtk2ui',
            '../build/linux/system.gyp:gio',
          ],
        }],
        ['OS=="win" or OS=="mac" or desktop_linux==1', {
          # A temporary define to make it easier to remove CrOS dependencies on
          # avatar button code. TODO(estade): remove.
          'defines': [ 'FRAME_AVATAR_BUTTON=1', ],
          'sources': [ '<@(chrome_browser_ui_desktop_sources)' ],
        }],
        ['use_aura==1', {
          'sources': [ '<@(chrome_browser_ui_aura_sources)'] ,
          'dependencies': [
            # aura uses some of ash resources.
            '../ash/ash_resources.gyp:ash_resources',
            '../ui/aura/aura.gyp:aura',
            '../ui/keyboard/keyboard.gyp:keyboard',
            '../ui/keyboard/keyboard.gyp:keyboard_with_content',
            '../ui/keyboard/keyboard.gyp:keyboard_resources',
            '../ui/wm/wm.gyp:wm',
          ],
          'conditions': [
            ['chromeos == 0', {
              'sources': [ '<@(chrome_browser_ui_aura_non_chromeos)' ],
            }],
          ],
        }],
        ['ui_compositor_image_transport==1', {
          'dependencies': [
            '../ui/gl/gl.gyp:gl',
          ],
        }],
        ['use_nss_certs==1', {
          'sources': [ '<@(chrome_browser_ui_nss_sources)' ],
        }],
        ['enable_themes==0', {
          'sources!': [
            'browser/ui/webui/theme_source.cc',
          ],
        }],
        ['enable_print_preview==1', {
          'sources': [ '<@(chrome_browser_ui_print_preview_sources)' ],
        }],
        ['OS=="android"', {
          'dependencies': [
            '../components/components.gyp:web_contents_delegate_android',
            '../third_party/boringssl/boringssl.gyp:boringssl',
            'chrome_browser_jni_headers',
          ],
          'dependencies!': [
             '../ui/events/events.gyp:events',
             'chrome_browser_ui_views.gyp:browser_ui_views',
          ],
          'sources': [ '<@(chrome_browser_ui_android_non_aura_sources)' ],
        }],
        ['OS=="mac"', {
          'sources': [ '<@(chrome_browser_ui_mac_sources)' ],
          'dependencies': [
            '../third_party/apple_sample_code/apple_sample_code.gyp:apple_sample_code',
            '../third_party/google_toolbox_for_mac/google_toolbox_for_mac.gyp:google_toolbox_for_mac',
            '../third_party/molokocacao/molokocacao.gyp:molokocacao',
            '../third_party/mozilla/mozilla.gyp:mozilla',
          ],
          'conditions': [
            ['mac_views_browser==1', {
              'sources': [
                '<@(chrome_browser_ui_views_mac_experimental_sources)',
                '<@(chrome_browser_ui_views_non_mac_sources)',
                '<@(chrome_browser_ui_views_extensions_non_mac_sources)',
              ],
            }, {
              'sources': [ '<@(chrome_browser_ui_cocoa_sources)' ],
            }],
          ],
          'link_settings': {
            'libraries': [
              '$(SDKROOT)/System/Library/Frameworks/Quartz.framework',
            ],
          },
          'actions': [
            {
              # This action is used to extract the localization data from xib
              # files and generate table for the ui localizer from it.
              'variables': {
                'xib_localizer_tool_path':
                    'tools/build/mac/generate_localizer',
              },
              'includes': [
                'chrome_nibs.gypi',
              ],
              'action_name': 'Process xibs for localization',
              'inputs': [
                '<(xib_localizer_tool_path)',
                '<@(mac_translated_xibs)',
              ],
              'outputs': [
                '<(INTERMEDIATE_DIR)/ui_localizer_table.h',
              ],
              'action': ['<(xib_localizer_tool_path)',
                          '<@(_outputs)',
                          '<@(mac_translated_xibs)'],
            },
          ],
        }, {  # non-Mac.
          'sources': [ '<@(chrome_browser_ui_non_mac_sources)' ],
          'sources/': [
            ['exclude', '^browser/ui/cocoa/'],
          ],
        }],
        ['OS=="win"', {
          'include_dirs': [
            '<(DEPTH)/third_party/wtl/include',
          ],
          'dependencies': [
            'installer_util_strings',
            'metro_utils',
            '../components/components.gyp:browser_watcher',
            '../google_update/google_update.gyp:google_update',
            '../third_party/iaccessible2/iaccessible2.gyp:iaccessible2',
            '../third_party/isimpledom/isimpledom.gyp:isimpledom',
            '../ui/app_list/app_list.gyp:app_list',
            '../ui/views/controls/webview/webview.gyp:webview',
            '../ui/views/views.gyp:views',
          ],
          'export_dependent_settings': [
            '../ui/views/controls/webview/webview.gyp:webview',
            '../ui/views/views.gyp:views',
          ],
          'sources': [ '<@(chrome_browser_ui_win_sources)' ],
          'sources!': [
            'browser/ui/views/apps/keyboard_hook_handler.cc',
            'browser/ui/views/frame/taskbar_decorator.cc'
          ],
          'conditions': [
            ['win_use_allocator_shim==1', {
              'dependencies': [
                '<(allocator_target)',
              ],
            }],
            ['branding!="Chrome"', {
              'dependencies!': [
                '../google_update/google_update.gyp:google_update',
              ],
              'sources!': [
                'browser/ui/webui/help/version_updater_win.cc',
              ],
              'sources': [
                'browser/ui/webui/help/version_updater_basic.cc',
                'browser/ui/webui/help/version_updater_basic.h',
              ],
            }],
          ],
        }, {  # 'OS!="win"
          'conditions': [
            ['toolkit_views==1', {
              'dependencies': [
                '../ui/views/controls/webview/webview.gyp:webview',
                '../ui/views/views.gyp:views',
              ],
              'include_dirs': [
                '<(INTERMEDIATE_DIR)',
                '<(INTERMEDIATE_DIR)/chrome',
              ],
            }, { # else: toolkit_views==0
              'sources/': [
                # Exclude all of views.
                ['exclude', '^browser/ui/views/'],
              ]
            }],
          ],
        }],
        ['desktop_linux==1', {
          'sources': [ '<@(chrome_browser_ui_desktop_linux_sources)' ],
        }],
        ['OS=="linux"', {  # Both desktop Linux and ChromeOS.
          'sources': [ '<@(chrome_browser_ui_linux_sources)' ],
          'conditions': [
            ['use_aura==1', {
              'dependencies': [
                '../build/linux/system.gyp:dbus',
                '../build/linux/system.gyp:fontconfig',
                '../dbus/dbus.gyp:dbus',
              ],
            }],
            # x11 build
            ['use_x11==1', {
              'sources': [ '<@(chrome_browser_ui_x11_sources)' ],
              'dependencies': [
                '../build/linux/system.gyp:x11',
                '../build/linux/system.gyp:gio',
                '../ui/events/devices/events_devices.gyp:events_devices',
              ],
            }],
            ['use_udev==1', {
              'dependencies': [
                '../device/udev_linux/udev.gyp:udev_linux',
              ],
            }],
          ],
        }],
        ['enable_app_list==1', {
          'sources': [ '<@(chrome_browser_ui_app_list_sources)' ],
          'dependencies': [
            '../ui/app_list/app_list.gyp:app_list',
          ],
        }, {
          'sources': [ '<@(chrome_browser_ui_non_app_list_sources)' ],
        }],
        ['enable_autofill_dialog==1', {
          'sources': [ '<@(chrome_browser_ui_autofill_dialog_sources)' ],
          'conditions': [
            ['OS!="android" and OS!="ios"', {
              'sources': [
                '<@(chrome_browser_ui_autofill_dialog_non_mobile_sources)',
              ],
              'dependencies': [
                '../third_party/libaddressinput/libaddressinput.gyp:libaddressinput',
                '../third_party/libaddressinput/libaddressinput.gyp:libaddressinput_strings',
              ],
            }],
          ],
        }],
        ['enable_extensions==1', {
          'dependencies': [
            'browser_extensions',
            'browser/extensions/api/api_registration.gyp:chrome_api_registration',
            'common/extensions/api/api.gyp:chrome_api',
          ],
          'sources': [ '<@(chrome_browser_ui_extensions_sources)' ],
        }],
        ['enable_google_now==1 and OS!="android"', {
          'sources': [ '<@(chrome_browser_ui_google_now_non_android_sources)' ],
        }],
        ['enable_media_router==1 and OS!="android" and OS!="ios"', {
          'dependencies': [
            'browser/media/router/media_router.gyp:media_router',
          ],
          'sources': [ '<@(chrome_browser_ui_media_router_sources)' ],
        }],
        ['enable_supervised_users==0', {
          'sources!': [
            'browser/ui/views/profiles/supervised_user_avatar_label.cc',
            'browser/ui/views/profiles/supervised_user_avatar_label.h',
            'browser/ui/webui/options/supervised_user_create_confirm_handler.cc',
            'browser/ui/webui/options/supervised_user_create_confirm_handler.h',
            'browser/ui/webui/options/supervised_user_import_handler.cc',
            'browser/ui/webui/options/supervised_user_import_handler.h',
            'browser/ui/webui/options/supervised_user_learn_more_handler.cc',
            'browser/ui/webui/options/supervised_user_learn_more_handler.h',
          ],
        }],
        ['enable_webrtc==1', {
          'sources': [ '<@(chrome_browser_ui_webrtc_sources)' ],
        }],
        ['enable_service_discovery==1', {
          'sources': [ '<@(chrome_browser_ui_service_discovery_sources)' ],
        }],
        ['enable_extensions==1', {
          'dependencies': [
            '<(DEPTH)/extensions/components/extensions_components.gyp:javascript_dialog_extensions_client',
          ],
        }],
        ['OS=="win" and (chromium_win_pch==0 or syzyasan==1)', {
          'msvs_shard': 4,
        }],
        ['OS!="android" and OS!="ios"', {
          'dependencies': [
            '../components/components.gyp:bubble',
            '../components/components.gyp:feedback_proto',
            '../device/bluetooth/bluetooth.gyp:device_bluetooth',
            '../third_party/libusb/libusb.gyp:libusb',
          ],
          'sources': [
            '<@(chrome_browser_ui_non_mobile_sources)',
            '<@(chrome_browser_ui_omnibox_non_mobile_sources)',
          ],
        }],
      ],
    },
  ],
}
