// Copyright 2015 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

package org.chromium.chrome.browser.dom_distiller;

import org.chromium.chrome.browser.ChromeActivity;
import org.chromium.chrome.browser.compositor.bottombar.readermode.ReaderModePanel;

/**
 * Delegate for the panel to call into the manager.
 */
public interface ReaderModeManagerDelegate {
    /**
     * @return Reader mode header background color.
     */
    int getReaderModeHeaderBackgroundColor();

    /**
     * @return One of ReaderModeManager.POSSIBLE, NOT_POSSIBLE, STARTED constants.
     */
    int getReaderModeStatus();

    /**
     * @param panel The panel to be managed.
     */
    void setReaderModePanel(ReaderModePanel panel);

    /**
     * Load a URL in a new tab.
     * @param url The URL to load in the tab.
     */
    void createNewTab(String url);

    /**
     * Notify the manager that the panel was closed using the "x" icon.
     */
    void onCloseButtonPressed();

    /**
     * Notify the manager that the panel is starting to peek.
     */
    void onPanelPeek();

    /**
     * @return The ChromeActivity that owns the manager.
     */
    ChromeActivity getChromeActivity();
}
