// Copyright (c) 2012 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/nacl/renderer/plugin/nacl_subprocess.h"

#include <stdarg.h>
#include <stddef.h>
#include <stdint.h>

#include <sstream>

#include "components/nacl/renderer/plugin/plugin_error.h"

namespace plugin {

NaClSubprocess::NaClSubprocess(const std::string& description,
                               ServiceRuntime* service_runtime)
  : description_(description),
    service_runtime_(service_runtime) {
}

std::string NaClSubprocess::detailed_description() const {
  std::stringstream ss;
  ss << description()
     << "={ this=" << static_cast<const void*>(this)
     << ", service_runtime=" << static_cast<void*>(service_runtime_.get())
     << " }";
  return ss.str();
}

// Shutdown the socket connection and service runtime, in that order.
void NaClSubprocess::Shutdown() {
  if (service_runtime_.get() != NULL) {
    service_runtime_->Shutdown();
    service_runtime_.reset(NULL);
  }
}

NaClSubprocess::~NaClSubprocess() {
  Shutdown();
}

}  // namespace plugin
