// Copyright 2015 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef NET_BASE_NET_ERROR_DETAILS_H_
#define NET_BASE_NET_ERROR_DETAILS_H_

#include "net/quic/quic_protocol.h"

namespace net {

// A record of net errors with granular error specification generated by
// net stack.
struct NET_EXPORT NetErrorDetails {
  NetErrorDetails()
      : quic_broken(false), quic_connection_error(QUIC_NO_ERROR) {}

  NetErrorDetails(bool quic_broken, QuicErrorCode quic_connection_error)
      : quic_broken(quic_broken),
        quic_connection_error(quic_connection_error) {}

  // True if all QUIC alternative services are marked broken for the origin.
  bool quic_broken;
  // QUIC granular error info.
  QuicErrorCode quic_connection_error;
};

}  // namespace net

#endif
