// Copyright (c) 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/net/nss_context.h"

#include "content/public/browser/browser_thread.h"
#include "crypto/nss_util_internal.h"
#include "net/cert/nss_cert_database.h"

namespace {
net::NSSCertDatabase* g_nss_cert_database = NULL;
}  // namespace

crypto::ScopedPK11Slot GetPublicNSSKeySlotForResourceContext(
    content::ResourceContext* context) {
  DCHECK_CURRENTLY_ON(content::BrowserThread::IO);
  return crypto::ScopedPK11Slot(crypto::GetPersistentNSSKeySlot());
}

crypto::ScopedPK11Slot GetPrivateNSSKeySlotForResourceContext(
    content::ResourceContext* context,
    const base::Callback<void(crypto::ScopedPK11Slot)>& callback) {
  DCHECK_CURRENTLY_ON(content::BrowserThread::IO);
  return crypto::ScopedPK11Slot(crypto::GetPersistentNSSKeySlot());
}

net::NSSCertDatabase* GetNSSCertDatabaseForResourceContext(
    content::ResourceContext* context,
    const base::Callback<void(net::NSSCertDatabase*)>& callback) {
  // This initialization is not thread safe. This CHECK ensures that this code
  // is only run on a single thread.
  CHECK(content::BrowserThread::CurrentlyOn(content::BrowserThread::IO));
  if (!g_nss_cert_database) {
    // Linux has only a single persistent slot compared to ChromeOS's separate
    // public and private slot.
    // Redirect any slot usage to this persistent slot on Linux.
    g_nss_cert_database = new net::NSSCertDatabase(
        crypto::ScopedPK11Slot(
            crypto::GetPersistentNSSKeySlot()) /* public slot */,
        crypto::ScopedPK11Slot(
            crypto::GetPersistentNSSKeySlot()) /* private slot */);
  }
  return g_nss_cert_database;
}
