// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MASH_SCREENLOCK_SCREENLOCK_H_
#define MASH_SCREENLOCK_SCREENLOCK_H_

#include <map>

#include "base/macros.h"
#include "base/memory/scoped_ptr.h"
#include "mash/shell/public/interfaces/shell.mojom.h"
#include "mojo/public/cpp/bindings/binding_set.h"
#include "mojo/services/tracing/public/cpp/tracing_impl.h"
#include "mojo/shell/public/cpp/shell_client.h"

namespace views {
class AuraInit;
}

namespace mash {
namespace screenlock {

class Screenlock : public mojo::ShellClient,
                   public shell::mojom::ScreenlockStateListener {
 public:
  Screenlock();
  ~Screenlock() override;

 private:
  // mojo::ShellClient:
  void Initialize(mojo::Connector* connector, const std::string& url,
                  uint32_t id, uint32_t user_id) override;

  // mash::shell::mojom::ScreenlockStateListener:
  void ScreenlockStateChanged(bool locked) override;

  mojo::TracingImpl tracing_;
  scoped_ptr<views::AuraInit> aura_init_;
  mojo::BindingSet<mash::shell::mojom::ScreenlockStateListener> bindings_;

  DISALLOW_COPY_AND_ASSIGN(Screenlock);
};

}  // namespace screenlock
}  // namespace mash

#endif  // MASH_SCREENLOCK_SCREENLOCK_H_
