# Copyright 2014 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

# This file is shared between the regular GYP build, the NaCl GYP build, and
# the GN build. For GN support, it must have no conditionals or anything like
# that beyond the simple one-level-deep dictionary of values.
{
  'variables': {
    # Subset of net source files that are compiled for NaCl (net_nacl target).
    # These files must not depend on files listed in sources list in the net
    # target.
    'net_nacl_common_sources' : [
      'base/address_family.cc',
      'base/address_family.h',
      'base/address_list.cc',
      'base/address_list.h',
      'base/auth.cc',
      'base/auth.h',
      'base/completion_callback.h',
      'base/connection_type_histograms.cc',
      'base/connection_type_histograms.h',
      'base/escape.cc',
      'base/escape.h',
      'base/hash_value.cc',
      'base/hash_value.h',
      'base/host_port_pair.cc',
      'base/host_port_pair.h',
      'base/io_buffer.cc',
      'base/io_buffer.h',
      'base/ip_address.cc',
      'base/ip_address.h',
      'base/ip_address_number.cc',
      'base/ip_address_number.h',
      'base/ip_endpoint.cc',
      'base/ip_endpoint.h',
      'base/load_timing_info.cc',
      'base/load_timing_info.h',
      'base/lookup_string_in_fixed_set.cc',
      'base/lookup_string_in_fixed_set.h',
      'base/net_error_details.h',
      'base/net_error_list.h',
      'base/net_errors.cc',
      'base/net_errors.h',
      'base/net_errors_posix.cc',
      'base/net_export.h',
      'base/net_module.cc',
      'base/net_module.h',
      'base/net_string_util.h',
      'base/network_interfaces.cc',
      'base/network_interfaces.h',
      'base/network_interfaces_posix.cc',
      'base/openssl_private_key_store.h',
      'base/openssl_private_key_store_android.cc',
      'base/openssl_private_key_store_memory.cc',
      'base/port_util.cc',
      'base/port_util.h',
      'base/rand_callback.h',
      'base/registry_controlled_domains/registry_controlled_domain.cc',
      'base/registry_controlled_domains/registry_controlled_domain.h',
      'base/sockaddr_storage.cc',
      'base/sockaddr_storage.h',
      'base/socket_performance_watcher.cc',
      'base/socket_performance_watcher.h',
      'base/socket_performance_watcher_factory.h',
      'base/sys_addrinfo.h',
      'base/url_util.cc',
      'base/url_util.h',
      'base/zap.cc',
      'base/zap.h',
      'cert/asn1_util.cc',
      'cert/asn1_util.h',
      'cert/cert_database.cc',
      'cert/cert_database.h',
      'cert/cert_database_openssl.cc',
      'cert/cert_status_flags.cc',
      'cert/cert_status_flags.h',
      'cert/cert_verifier.cc',
      'cert/cert_verifier.h',
      'cert/cert_verify_result.cc',
      'cert/cert_verify_result.h',
      'cert/client_cert_verifier.h',
      'cert/crl_set.cc',
      'cert/crl_set.h',
      'cert/ct_known_logs.cc',
      'cert/ct_known_logs.h',
      'cert/ct_known_logs_static.h',
      'cert/ct_policy_enforcer.cc',
      'cert/ct_policy_enforcer.h',
      'cert/ct_policy_status.h',
      'cert/ct_verifier.h',
      'cert/ct_verify_result.cc',
      'cert/ct_verify_result.h',
      'cert/internal/certificate_policies.cc',
      'cert/internal/certificate_policies.h',
      'cert/internal/extended_key_usage.cc',
      'cert/internal/extended_key_usage.h',
      'cert/internal/name_constraints.cc',
      'cert/internal/name_constraints.h',
      'cert/internal/parse_certificate.cc',
      'cert/internal/parse_certificate.h',
      'cert/internal/parse_name.cc',
      'cert/internal/parse_name.h',
      'cert/internal/signature_algorithm.cc',
      'cert/internal/signature_algorithm.h',
      'cert/internal/signature_policy.cc',
      'cert/internal/signature_policy.h',
      'cert/internal/verify_certificate_chain.cc',
      'cert/internal/verify_certificate_chain.h',
      'cert/internal/verify_name_match.cc',
      'cert/internal/verify_name_match.h',
      'cert/internal/verify_signed_data.cc',
      'cert/internal/verify_signed_data.h',
      'cert/pem_tokenizer.cc',
      'cert/pem_tokenizer.h',
      'cert/signed_certificate_timestamp.cc',
      'cert/signed_certificate_timestamp.h',
      'cert/signed_tree_head.cc',
      'cert/signed_tree_head.h',
      'cert/x509_cert_types.cc',
      'cert/x509_cert_types.h',
      'cert/x509_certificate.cc',
      'cert/x509_certificate.h',
      'cert/x509_certificate_net_log_param.cc',
      'cert/x509_certificate_net_log_param.h',
      'cert/x509_certificate_openssl.cc',
      'cert/x509_util.cc',
      'cert/x509_util.h',
      'cert/x509_util_openssl.cc',
      'cert/x509_util_openssl.h',
      'der/input.cc',
      'der/input.h',
      'der/parse_values.cc',
      'der/parse_values.h',
      'der/parser.cc',
      'der/parser.h',
      'der/tag.cc',
      'der/tag.h',
      'dns/dns_util.cc',
      'dns/dns_util.h',
      'http/http_auth_challenge_tokenizer.cc',
      'http/http_auth_challenge_tokenizer.h',
      'http/http_auth_scheme.cc',
      'http/http_auth_scheme.h',
      'http/http_byte_range.cc',
      'http/http_byte_range.h',
      'http/http_log_util.cc',
      'http/http_log_util.h',
      'http/http_request_headers.cc',
      'http/http_request_headers.h',
      'http/http_response_headers.cc',
      'http/http_response_headers.h',
      'http/http_response_info.cc',
      'http/http_response_info.h',
      'http/http_security_headers.cc',
      'http/http_security_headers.h',
      'http/http_status_line_validator.cc',
      'http/http_status_line_validator.h',
      'http/http_util.cc',
      'http/http_util.h',
      'http/http_vary_data.cc',
      'http/http_vary_data.h',
      'http/transport_security_state.cc',
      'http/transport_security_state.h',
      'log/net_log.cc',
      'log/net_log.h',
      'log/net_log_capture_mode.cc',
      'log/net_log_capture_mode.h',
      'log/net_log_event_type_list.h',
      'log/net_log_source_type_list.h',
      'socket/client_socket_handle.cc',
      'socket/client_socket_handle.h',
      'socket/connection_attempts.h',
      'socket/next_proto.cc',
      'socket/next_proto.h',
      'socket/socket.h',
      'socket/ssl_client_socket.cc',
      'socket/ssl_client_socket.h',
      'socket/ssl_client_socket_openssl.cc',
      'socket/ssl_client_socket_openssl.h',
      'socket/ssl_socket.h',
      'ssl/channel_id_service.cc',
      'ssl/channel_id_service.h',
      'ssl/channel_id_store.cc',
      'ssl/channel_id_store.h',
      'ssl/client_key_store.cc',
      'ssl/client_key_store.h',
      'ssl/default_channel_id_store.cc',
      'ssl/default_channel_id_store.h',
      'ssl/openssl_client_key_store.cc',
      'ssl/openssl_client_key_store.h',
      'ssl/openssl_ssl_util.cc',
      'ssl/openssl_ssl_util.h',
      'ssl/signed_certificate_timestamp_and_status.cc',
      'ssl/signed_certificate_timestamp_and_status.h',
      'ssl/ssl_cert_request_info.cc',
      'ssl/ssl_cert_request_info.h',
      'ssl/ssl_cipher_suite_names.cc',
      'ssl/ssl_cipher_suite_names.h',
      'ssl/ssl_client_auth_cache.cc',
      'ssl/ssl_client_auth_cache.h',
      'ssl/ssl_client_cert_type.h',
      'ssl/ssl_client_session_cache_openssl.cc',
      'ssl/ssl_client_session_cache_openssl.h',
      'ssl/ssl_config.cc',
      'ssl/ssl_config.h',
      'ssl/ssl_config_service.cc',
      'ssl/ssl_config_service.h',
      'ssl/ssl_failure_state.h',
      'ssl/ssl_info.cc',
      'ssl/ssl_info.h',
      'ssl/ssl_private_key.h',
      'ssl/ssl_server_config.cc',
      'ssl/ssl_server_config.h',

      # Most files in net/quic are in net_nacl_common_sources, except for the
      # files that have dependency on SPDY (net/spdy) or NSS.
      'quic/congestion_control/cubic.cc',
      'quic/congestion_control/cubic.h',
      'quic/congestion_control/cubic_bytes.cc',
      'quic/congestion_control/cubic_bytes.h',
      'quic/congestion_control/general_loss_algorithm.cc',
      'quic/congestion_control/general_loss_algorithm.h',
      'quic/congestion_control/hybrid_slow_start.cc',
      'quic/congestion_control/hybrid_slow_start.h',
      'quic/congestion_control/loss_detection_interface.cc',
      'quic/congestion_control/loss_detection_interface.h',
      'quic/congestion_control/pacing_sender.cc',
      'quic/congestion_control/pacing_sender.h',
      'quic/congestion_control/prr_sender.cc',
      'quic/congestion_control/prr_sender.h',
      'quic/congestion_control/rtt_stats.cc',
      'quic/congestion_control/rtt_stats.h',
      'quic/congestion_control/send_algorithm_interface.cc',
      'quic/congestion_control/send_algorithm_interface.h',
      'quic/congestion_control/tcp_cubic_bytes_sender.cc',
      'quic/congestion_control/tcp_cubic_bytes_sender.h',
      'quic/congestion_control/tcp_cubic_sender.cc',
      'quic/congestion_control/tcp_cubic_sender.h',
      'quic/congestion_control/tcp_cubic_sender_base.cc',
      'quic/congestion_control/tcp_cubic_sender_base.h',
      'quic/congestion_control/tcp_cubic_sender_bytes.cc',
      'quic/congestion_control/tcp_cubic_sender_base.h',
      'quic/congestion_control/tcp_cubic_sender_packets.cc',
      'quic/congestion_control/tcp_cubic_sender_packets.h',
      'quic/crypto/aead_base_decrypter.h',
      'quic/crypto/aead_base_decrypter_openssl.cc',
      'quic/crypto/aead_base_encrypter.h',
      'quic/crypto/aead_base_encrypter_openssl.cc',
      'quic/crypto/aes_128_gcm_12_decrypter.h',
      'quic/crypto/aes_128_gcm_12_decrypter_openssl.cc',
      'quic/crypto/aes_128_gcm_12_encrypter.h',
      'quic/crypto/aes_128_gcm_12_encrypter_openssl.cc',
      'quic/crypto/chacha20_poly1305_decrypter.h',
      'quic/crypto/chacha20_poly1305_decrypter_openssl.cc',
      'quic/crypto/chacha20_poly1305_encrypter.h',
      'quic/crypto/chacha20_poly1305_encrypter_openssl.cc',
      'quic/crypto/chacha20_poly1305_rfc7539_decrypter.h',
      'quic/crypto/chacha20_poly1305_rfc7539_decrypter_openssl.cc',
      'quic/crypto/chacha20_poly1305_rfc7539_encrypter.h',
      'quic/crypto/chacha20_poly1305_rfc7539_encrypter_openssl.cc',
      'quic/crypto/channel_id.cc',
      'quic/crypto/channel_id.h',
      'quic/crypto/channel_id_chromium.cc',
      'quic/crypto/channel_id_chromium.h',
      'quic/crypto/channel_id_openssl.cc',
      'quic/crypto/common_cert_set.cc',
      'quic/crypto/common_cert_set.h',
      'quic/crypto/crypto_framer.cc',
      'quic/crypto/crypto_framer.h',
      'quic/crypto/crypto_handshake.cc',
      'quic/crypto/crypto_handshake.h',
      'quic/crypto/crypto_handshake_message.cc',
      'quic/crypto/crypto_handshake_message.h',
      'quic/crypto/crypto_protocol.h',
      'quic/crypto/crypto_secret_boxer.cc',
      'quic/crypto/crypto_secret_boxer.h',
      'quic/crypto/crypto_server_config_protobuf.cc',
      'quic/crypto/crypto_server_config_protobuf.h',
      'quic/crypto/crypto_utils.cc',
      'quic/crypto/crypto_utils.h',
      'quic/crypto/curve25519_key_exchange.cc',
      'quic/crypto/curve25519_key_exchange.h',
      'quic/crypto/ephemeral_key_source.h',
      'quic/crypto/key_exchange.h',
      'quic/crypto/local_strike_register_client.cc',
      'quic/crypto/local_strike_register_client.h',
      'quic/crypto/null_decrypter.cc',
      'quic/crypto/null_decrypter.h',
      'quic/crypto/null_encrypter.cc',
      'quic/crypto/null_encrypter.h',
      'quic/crypto/p256_key_exchange.h',
      'quic/crypto/p256_key_exchange_openssl.cc',
      'quic/crypto/proof_source.cc',
      'quic/crypto/proof_source.h',
      'quic/crypto/proof_verifier.h',
      'quic/crypto/proof_verifier_chromium.cc',
      'quic/crypto/proof_verifier_chromium.h',
      'quic/crypto/properties_based_quic_server_info.cc',
      'quic/crypto/properties_based_quic_server_info.h',
      'quic/crypto/quic_decrypter.cc',
      'quic/crypto/quic_decrypter.h',
      'quic/crypto/quic_encrypter.cc',
      'quic/crypto/quic_encrypter.h',
      'quic/crypto/quic_random.cc',
      'quic/crypto/quic_random.h',
      'quic/crypto/quic_server_info.cc',
      'quic/crypto/quic_server_info.h',
      'quic/crypto/scoped_evp_aead_ctx.cc',
      'quic/crypto/scoped_evp_aead_ctx.h',
      'quic/crypto/strike_register.cc',
      'quic/crypto/strike_register.h',
      'quic/crypto/strike_register_client.h',
      'quic/interval.h',
      'quic/interval_set.h',
      'quic/iovector.cc',
      'quic/iovector.h',
      'quic/p2p/quic_p2p_crypto_config.cc',
      'quic/p2p/quic_p2p_crypto_config.h',
      'quic/p2p/quic_p2p_crypto_stream.cc',
      'quic/p2p/quic_p2p_crypto_stream.h',
      'quic/p2p/quic_p2p_session.cc',
      'quic/p2p/quic_p2p_session.h',
      'quic/p2p/quic_p2p_stream.cc',
      'quic/p2p/quic_p2p_stream.h',
      'quic/port_suggester.cc',
      'quic/port_suggester.h',
      'quic/quic_address_mismatch.cc',
      'quic/quic_address_mismatch.h',
      'quic/quic_alarm.cc',
      'quic/quic_alarm.h',
      'quic/quic_arena_scoped_ptr.h',
      'quic/quic_bandwidth.cc',
      'quic/quic_bandwidth.h',
      'quic/quic_bug_tracker.h',
      'quic/quic_blocked_writer_interface.h',
      'quic/quic_clock.cc',
      'quic/quic_clock.h',
      'quic/quic_config.cc',
      'quic/quic_config.h',
      'quic/quic_connection.cc',
      'quic/quic_connection.h',
      'quic/quic_connection_logger.cc',
      'quic/quic_connection_logger.h',
      'quic/quic_connection_stats.cc',
      'quic/quic_connection_stats.h',
      'quic/quic_crypto_stream.cc',
      'quic/quic_crypto_stream.h',
      'quic/quic_chromium_connection_helper.cc',
      'quic/quic_chromium_connection_helper.h',
      'quic/quic_chromium_packet_reader.cc',
      'quic/quic_chromium_packet_reader.h',
      'quic/quic_chromium_packet_writer.cc',
      'quic/quic_chromium_packet_writer.h',
      'quic/quic_data_reader.cc',
      'quic/quic_data_reader.h',
      'quic/quic_data_writer.cc',
      'quic/quic_data_writer.h',
      'quic/quic_fec_group.cc',
      'quic/quic_fec_group.h',
      'quic/quic_fec_group_interface.cc',
      'quic/quic_fec_group_interface.h',
      'quic/quic_flags.cc',
      'quic/quic_flags.h',
      'quic/quic_flow_controller.cc',
      'quic/quic_flow_controller.h',
      'quic/quic_frame_list.cc',
      'quic/quic_frame_list.h',
      'quic/quic_framer.cc',
      'quic/quic_framer.h',
      'quic/quic_multipath_received_packet_manager.cc',
      'quic/quic_multipath_received_packet_manager.h',
      'quic/quic_multipath_transmissions_map.cc',
      'quic/quic_multipath_transmissions_map.h',
      'quic/quic_one_block_arena.h',
      'quic/quic_packet_creator.cc',
      'quic/quic_packet_creator.h',
      'quic/quic_packet_generator.cc',
      'quic/quic_packet_generator.h',
      'quic/quic_packet_writer.h',
      'quic/quic_protocol.cc',
      'quic/quic_protocol.h',
      'quic/quic_received_packet_manager.cc',
      'quic/quic_received_packet_manager.h',
      'quic/quic_sent_entropy_manager.cc',
      'quic/quic_sent_entropy_manager.h',
      'quic/quic_sent_packet_manager.cc',
      'quic/quic_sent_packet_manager.h',
      'quic/quic_server_id.cc',
      'quic/quic_server_id.h',
      'quic/quic_session.cc',
      'quic/quic_session.h',
      'quic/quic_simple_buffer_allocator.cc',
      'quic/quic_simple_buffer_allocator.h',
      'quic/quic_socket_address_coder.cc',
      'quic/quic_socket_address_coder.h',
      'quic/quic_stream_sequencer.cc',
      'quic/quic_stream_sequencer.h',
      'quic/quic_stream_sequencer_buffer_interface.h',
      'quic/quic_sustained_bandwidth_recorder.cc',
      'quic/quic_sustained_bandwidth_recorder.h',
      'quic/quic_time.cc',
      'quic/quic_time.h',
      'quic/quic_types.cc',
      'quic/quic_types.h',
      'quic/quic_unacked_packet_map.cc',
      'quic/quic_unacked_packet_map.h',
      'quic/quic_utils.cc',
      'quic/quic_utils.h',
      'quic/quic_utils_chromium.h',
      'quic/quic_write_blocked_list.cc',
      'quic/quic_write_blocked_list.h',
      'quic/reliable_quic_stream.cc',
      'quic/reliable_quic_stream.h',
      'quic/stream_sequencer_buffer.cc',
      'quic/stream_sequencer_buffer.h',
    ],
    'net_non_nacl_sources': [
      'android/cert_verify_result_android.cc',
      'android/cert_verify_result_android.h',
      'android/gurl_utils.cc',
      'android/gurl_utils.h',
      'android/http_auth_negotiate_android.cc',
      'android/http_auth_negotiate_android.h',
      'android/keystore.cc',
      'android/keystore.h',
      'android/keystore_openssl.cc',
      'android/keystore_openssl.h',
      'android/legacy_openssl.h',
      'android/net_jni_registrar.cc',
      'android/net_jni_registrar.h',
      'android/network_change_notifier_android.cc',
      'android/network_change_notifier_android.h',
      'android/network_change_notifier_delegate_android.cc',
      'android/network_change_notifier_delegate_android.h',
      'android/network_change_notifier_factory_android.cc',
      'android/network_change_notifier_factory_android.h',
      'android/network_library.cc',
      'android/network_library.h',
      'android/traffic_stats.cc',
      'android/traffic_stats.h',
      'base/address_tracker_linux.cc',
      'base/address_tracker_linux.h',
      'base/backoff_entry.cc',
      'base/backoff_entry.h',
      'base/backoff_entry_serializer.cc',
      'base/backoff_entry_serializer.h',
      'base/cache_type.h',
      'base/chunked_upload_data_stream.cc',
      'base/chunked_upload_data_stream.h',
      'base/crypto_module.h',
      'base/crypto_module_nss.cc',
      'base/crypto_module_openssl.cc',
      'base/data_url.cc',
      'base/data_url.h',
      'base/elements_upload_data_stream.cc',
      'base/elements_upload_data_stream.h',
      'base/expiring_cache.h',
      'base/external_estimate_provider.h',
      'base/file_stream.cc',
      'base/file_stream.h',
      'base/file_stream_context.cc',
      'base/file_stream_context.h',
      'base/file_stream_context_posix.cc',
      'base/file_stream_context_win.cc',
      'base/filename_util.cc',
      'base/filename_util.h',
      'base/filename_util_internal.cc',
      'base/filename_util_internal.h',
      'base/host_mapping_rules.cc',
      'base/host_mapping_rules.h',
      'base/int128.cc',
      'base/int128.h',
      'base/iovec.h',
      'base/ip_pattern.cc',
      'base/ip_pattern.h',
      'base/keygen_handler.cc',
      'base/keygen_handler.h',
      'base/keygen_handler_mac.cc',
      'base/keygen_handler_nss.cc',
      'base/keygen_handler_openssl.cc',
      'base/keygen_handler_win.cc',
      # TODO(tc): gnome-vfs? xdgmime? /etc/mime.types?
      'base/layered_network_delegate.cc',
      'base/layered_network_delegate.h',
      'base/linked_hash_map.h',
      'base/load_flags.h',
      'base/load_flags_list.h',
      'base/load_states.h',
      'base/load_states_list.h',
      'base/mime_extension_chromeos.cc',
      'base/mime_extension_chromeos.h',
      'base/mime_sniffer.cc',
      'base/mime_sniffer.h',
      'base/mime_util.cc',
      'base/mime_util.h',
      'base/net_errors_win.cc',
      'base/net_info_source_list.h',
      'base/network_activity_monitor.cc',
      'base/network_activity_monitor.h',
      'base/network_change_notifier.cc',
      'base/network_change_notifier.h',
      'base/network_change_notifier_factory.h',
      'base/network_change_notifier_linux.cc',
      'base/network_change_notifier_linux.h',
      'base/network_change_notifier_mac.cc',
      'base/network_change_notifier_mac.h',
      'base/network_change_notifier_win.cc',
      'base/network_change_notifier_win.h',
      'base/network_config_watcher_mac.cc',
      'base/network_config_watcher_mac.h',
      'base/network_delegate.cc',
      'base/network_delegate.h',
      'base/network_delegate_impl.cc',
      'base/network_delegate_impl.h',
      'base/network_interfaces_linux.cc',
      'base/network_interfaces_mac.cc',
      'base/network_interfaces_win.cc',
      'base/network_quality_estimator.cc',
      'base/network_quality_estimator.h',
      'base/nss_memio.c',
      'base/nss_memio.h',
      'base/platform_mime_util.h',
      'base/platform_mime_util_linux.cc',
      'base/platform_mime_util_mac.mm',
      'base/platform_mime_util_win.cc',
      'base/prioritized_dispatcher.cc',
      'base/prioritized_dispatcher.h',
      'base/priority_queue.h',
      'base/proxy_delegate.h',
      'base/request_priority.cc',
      'base/request_priority.h',
      'base/sdch_dictionary.cc',
      'base/sdch_dictionary.h',
      'base/sdch_manager.cc',
      'base/sdch_manager.h',
      'base/sdch_net_log_params.cc',
      'base/sdch_net_log_params.h',
      'base/sdch_observer.cc',
      'base/sdch_observer.h',
      'base/sdch_problem_code_list.h',
      'base/sdch_problem_codes.h',
      'base/static_cookie_policy.cc',
      'base/static_cookie_policy.h',
      'base/test_data_stream.cc',
      'base/test_data_stream.h',
      'base/upload_bytes_element_reader.cc',
      'base/upload_bytes_element_reader.h',
      'base/upload_data_stream.cc',
      'base/upload_data_stream.h',
      'base/upload_element_reader.cc',
      'base/upload_element_reader.h',
      'base/upload_file_element_reader.cc',
      'base/upload_file_element_reader.h',
      'base/upload_progress.h',
      'base/winsock_init.cc',
      'base/winsock_init.h',
      'base/winsock_util.cc',
      'base/winsock_util.h',
      'cert/cert_database_android.cc',
      'cert/cert_database_ios.cc',
      'cert/cert_database_mac.cc',
      'cert/cert_database_nss.cc',
      'cert/cert_database_win.cc',
      'cert/cert_net_fetcher.h',
      'cert/cert_trust_anchor_provider.h',
      'cert/cert_verify_proc.cc',
      'cert/cert_verify_proc.h',
      'cert/cert_verify_proc_android.cc',
      'cert/cert_verify_proc_android.h',
      'cert/cert_verify_proc_mac.cc',
      'cert/cert_verify_proc_mac.h',
      'cert/cert_verify_proc_nss.cc',
      'cert/cert_verify_proc_nss.h',
      'cert/cert_verify_proc_openssl.cc',
      'cert/cert_verify_proc_openssl.h',
      'cert/cert_verify_proc_whitelist.cc',
      'cert/cert_verify_proc_whitelist.h',
      'cert/cert_verify_proc_win.cc',
      'cert/cert_verify_proc_win.h',
      'cert/crl_set_storage.cc',
      'cert/crl_set_storage.h',
      'cert/ct_ev_whitelist.h',
      'cert/ct_log_response_parser.cc',
      'cert/ct_log_response_parser.h',
      'cert/ct_log_verifier.cc',
      'cert/ct_log_verifier.h',
      'cert/ct_log_verifier_nss.cc',
      'cert/ct_log_verifier_openssl.cc',
      'cert/ct_log_verifier_util.cc',
      'cert/ct_log_verifier_util.h',
      'cert/ct_objects_extractor.h',
      'cert/ct_objects_extractor_nss.cc',
      'cert/ct_objects_extractor_openssl.cc',
      'cert/ct_serialization.cc',
      'cert/ct_serialization.h',
      'cert/ct_signed_certificate_timestamp_log_param.cc',
      'cert/ct_signed_certificate_timestamp_log_param.h',
      'cert/ev_root_ca_metadata.cc',
      'cert/ev_root_ca_metadata.h',
      'cert/jwk_serializer.h',
      'cert/jwk_serializer_nss.cc',
      'cert/jwk_serializer_openssl.cc',
      'cert/merkle_consistency_proof.cc',
      'cert/merkle_consistency_proof.h',
      'cert/multi_log_ct_verifier.cc',
      'cert/multi_log_ct_verifier.h',
      'cert/multi_threaded_cert_verifier.cc',
      'cert/multi_threaded_cert_verifier.h',
      'cert/nss_cert_database.cc',
      'cert/nss_cert_database.h',
      'cert/nss_cert_database_chromeos.cc',
      'cert/nss_cert_database_chromeos.h',
      'cert/nss_profile_filter_chromeos.cc',
      'cert/nss_profile_filter_chromeos.h',
      'cert/scoped_nss_types.h',
      'cert/sct_status_flags.h',
      'cert/test_root_certs.cc',
      'cert/test_root_certs.h',
      'cert/test_root_certs_android.cc',
      'cert/test_root_certs_mac.cc',
      'cert/test_root_certs_nss.cc',
      'cert/test_root_certs_openssl.cc',
      'cert/test_root_certs_win.cc',
      'cert/x509_cert_types_mac.cc',
      'cert/x509_cert_types_win.cc',
      'cert/x509_certificate_ios.cc',
      'cert/x509_certificate_mac.cc',
      'cert/x509_certificate_nss.cc',
      'cert/x509_certificate_win.cc',
      'cert/x509_util_android.cc',
      'cert/x509_util_android.h',
      'cert/x509_util_ios.cc',
      'cert/x509_util_ios.h',
      'cert/x509_util_mac.cc',
      'cert/x509_util_mac.h',
      'cert/x509_util_nss.cc',
      'cert/x509_util_nss.h',
      'cert/x509_util_nss_certs.cc',
      'cert_net/cert_net_fetcher_impl.cc',
      'cert_net/cert_net_fetcher_impl.h',
      'cookies/canonical_cookie.cc',
      'cookies/canonical_cookie.h',
      'cookies/cookie_constants.cc',
      'cookies/cookie_constants.h',
      'cookies/cookie_monster.cc',
      'cookies/cookie_monster.h',
      'cookies/cookie_options.cc',
      'cookies/cookie_options.h',
      'cookies/cookie_store.cc',
      'cookies/cookie_store.h',
      'cookies/cookie_util.cc',
      'cookies/cookie_util.h',
      'cookies/parsed_cookie.cc',
      'cookies/parsed_cookie.h',
      'disk_cache/blockfile/addr.cc',
      'disk_cache/blockfile/addr.h',
      'disk_cache/blockfile/backend_impl.cc',
      'disk_cache/blockfile/backend_impl.h',
      'disk_cache/blockfile/backend_impl_v3.cc',
      'disk_cache/blockfile/backend_impl_v3.h',
      'disk_cache/blockfile/backend_worker_v3.cc',
      'disk_cache/blockfile/backend_worker_v3.h',
      'disk_cache/blockfile/bitmap.cc',
      'disk_cache/blockfile/bitmap.h',
      'disk_cache/blockfile/block_bitmaps_v3.cc',
      'disk_cache/blockfile/block_bitmaps_v3.h',
      'disk_cache/blockfile/block_files.cc',
      'disk_cache/blockfile/block_files.h',
      'disk_cache/blockfile/disk_format.cc',
      'disk_cache/blockfile/disk_format.h',
      'disk_cache/blockfile/disk_format_base.h',
      'disk_cache/blockfile/disk_format_v3.h',
      'disk_cache/blockfile/entry_impl.cc',
      'disk_cache/blockfile/entry_impl.h',
      'disk_cache/blockfile/entry_impl_v3.cc',
      'disk_cache/blockfile/entry_impl_v3.h',
      'disk_cache/blockfile/errors.h',
      'disk_cache/blockfile/eviction.cc',
      'disk_cache/blockfile/eviction.h',
      'disk_cache/blockfile/eviction_v3.cc',
      'disk_cache/blockfile/eviction_v3.h',
      'disk_cache/blockfile/experiments.h',
      'disk_cache/blockfile/file.cc',
      'disk_cache/blockfile/file.h',
      'disk_cache/blockfile/file_block.h',
      'disk_cache/blockfile/file_ios.cc',
      'disk_cache/blockfile/file_lock.cc',
      'disk_cache/blockfile/file_lock.h',
      'disk_cache/blockfile/file_posix.cc',
      'disk_cache/blockfile/file_win.cc',
      'disk_cache/blockfile/histogram_macros.h',
      'disk_cache/blockfile/histogram_macros_v3.h',
      'disk_cache/blockfile/in_flight_backend_io.cc',
      'disk_cache/blockfile/in_flight_backend_io.h',
      'disk_cache/blockfile/in_flight_io.cc',
      'disk_cache/blockfile/in_flight_io.h',
      'disk_cache/blockfile/index_table_v3.cc',
      'disk_cache/blockfile/index_table_v3.h',
      'disk_cache/blockfile/mapped_file.cc',
      'disk_cache/blockfile/mapped_file.h',
      'disk_cache/blockfile/mapped_file_avoid_mmap_posix.cc',
      'disk_cache/blockfile/mapped_file_posix.cc',
      'disk_cache/blockfile/mapped_file_win.cc',
      'disk_cache/blockfile/rankings.cc',
      'disk_cache/blockfile/rankings.h',
      'disk_cache/blockfile/sparse_control.cc',
      'disk_cache/blockfile/sparse_control.h',
      'disk_cache/blockfile/stats.cc',
      'disk_cache/blockfile/stats.h',
      'disk_cache/blockfile/storage_block-inl.h',
      'disk_cache/blockfile/storage_block.h',
      'disk_cache/blockfile/stress_support.h',
      'disk_cache/blockfile/trace.cc',
      'disk_cache/blockfile/trace.h',
      'disk_cache/blockfile/webfonts_histogram.cc',
      'disk_cache/blockfile/webfonts_histogram.h',
      'disk_cache/cache_creator.cc',
      'disk_cache/cache_util.cc',
      'disk_cache/cache_util.h',
      'disk_cache/cache_util_posix.cc',
      'disk_cache/cache_util_win.cc',
      'disk_cache/disk_cache.h',
      'disk_cache/memory/mem_backend_impl.cc',
      'disk_cache/memory/mem_backend_impl.h',
      'disk_cache/memory/mem_entry_impl.cc',
      'disk_cache/memory/mem_entry_impl.h',
      'disk_cache/net_log_parameters.cc',
      'disk_cache/net_log_parameters.h',
      'disk_cache/simple/simple_backend_impl.cc',
      'disk_cache/simple/simple_backend_impl.h',
      'disk_cache/simple/simple_backend_version.h',
      'disk_cache/simple/simple_entry_format.cc',
      'disk_cache/simple/simple_entry_format.h',
      'disk_cache/simple/simple_entry_format_history.h',
      'disk_cache/simple/simple_entry_impl.cc',
      'disk_cache/simple/simple_entry_impl.h',
      'disk_cache/simple/simple_entry_operation.cc',
      'disk_cache/simple/simple_entry_operation.h',
      'log/net_log_util.cc',
      'log/net_log_util.h',
      'log/trace_net_log_observer.cc',
      'log/trace_net_log_observer.h',
      'log/write_to_file_net_log_observer.cc',
      'log/write_to_file_net_log_observer.h',
      'disk_cache/simple/simple_histogram_macros.h' ,
      'cert_net/nss_ocsp.cc',
      'cert_net/nss_ocsp.h',
      'disk_cache/simple/simple_index.cc',
      'disk_cache/simple/simple_index.h',
      'disk_cache/simple/simple_index_delegate.h',
      'disk_cache/simple/simple_index_file.cc',
      'disk_cache/simple/simple_index_file.h',
      'disk_cache/simple/simple_index_file_posix.cc',
      'disk_cache/simple/simple_index_file_win.cc',
      'disk_cache/simple/simple_net_log_parameters.cc',
      'disk_cache/simple/simple_net_log_parameters.h',
      'disk_cache/simple/simple_synchronous_entry.cc',
      'disk_cache/simple/simple_synchronous_entry.h',
      'disk_cache/simple/simple_util.cc',
      'disk_cache/simple/simple_util.h',
      'disk_cache/simple/simple_util_posix.cc',
      'disk_cache/simple/simple_util_win.cc',
      'disk_cache/simple/simple_version_upgrade.cc',
      'disk_cache/simple/simple_version_upgrade.h',
      'dns/address_sorter.h',
      'dns/address_sorter_posix.cc',
      'dns/address_sorter_posix.h',
      'dns/address_sorter_win.cc',
      'dns/dns_client.cc',
      'dns/dns_client.h',
      'dns/dns_config_service.cc',
      'dns/dns_config_service.h',
      'dns/dns_config_service_posix.cc',
      'dns/dns_config_service_posix.h',
      'dns/dns_config_service_win.cc',
      'dns/dns_config_service_win.h',
      'dns/dns_config_watcher_mac.cc',
      'dns/dns_config_watcher_mac.h',
      'dns/dns_hosts.cc',
      'dns/dns_hosts.h',
      'dns/dns_protocol.h',
      'dns/dns_query.cc',
      'dns/dns_query.h',
      'dns/dns_reloader.cc',
      'dns/dns_reloader.h',
      'dns/dns_response.cc',
      'dns/dns_response.h',
      'dns/dns_session.cc',
      'dns/dns_session.h',
      'dns/dns_socket_pool.cc',
      'dns/dns_socket_pool.h',
      'dns/dns_transaction.cc',
      'dns/dns_transaction.h',
      'dns/host_cache.cc',
      'dns/host_cache.h',
      'dns/host_resolver.cc',
      'dns/host_resolver.h',
      'dns/host_resolver_impl.cc',
      'dns/host_resolver_impl.h',
      'dns/host_resolver_proc.cc',
      'dns/host_resolver_proc.h',
      'dns/mapped_host_resolver.cc',
      'dns/mapped_host_resolver.h',
      'dns/mdns_cache.cc',
      'dns/mdns_cache.h',
      'dns/mdns_client.cc',
      'dns/mdns_client.h',
      'dns/mdns_client_impl.cc',
      'dns/mdns_client_impl.h',
      'dns/notify_watcher_mac.cc',
      'dns/notify_watcher_mac.h',
      'dns/record_parsed.cc',
      'dns/record_parsed.h',
      'dns/record_rdata.cc',
      'dns/record_rdata.h',
      'dns/serial_worker.cc',
      'dns/serial_worker.h',
      'dns/single_request_host_resolver.cc',
      'dns/single_request_host_resolver.h',
      'filter/filter.cc',
      'filter/filter.h',
      'filter/gzip_filter.cc',
      'filter/gzip_filter.h',
      'filter/gzip_header.cc',
      'filter/gzip_header.h',
      'filter/sdch_filter.cc',
      'filter/sdch_filter.h',
      'http/des.cc',
      'http/des.h',
      'http/disk_cache_based_quic_server_info.cc',
      'http/disk_cache_based_quic_server_info.h',
      'http/failing_http_transaction_factory.cc',
      'http/failing_http_transaction_factory.h',
      'http/http_auth.cc',
      'http/http_auth.h',
      'http/http_auth_cache.cc',
      'http/http_auth_cache.h',
      'http/http_auth_controller.cc',
      'http/http_auth_controller.h',
      'http/http_auth_filter.cc',
      'http/http_auth_filter.h',
      'http/http_auth_filter_win.h',
      'http/http_auth_gssapi_posix.cc',
      'http/http_auth_gssapi_posix.h',
      'http/http_auth_handler.cc',
      'http/http_auth_handler.h',
      'http/http_auth_handler_basic.cc',
      'http/http_auth_handler_basic.h',
      'http/http_auth_handler_digest.cc',
      'http/http_auth_handler_digest.h',
      'http/http_auth_handler_factory.cc',
      'http/http_auth_handler_factory.h',
      'http/http_auth_handler_negotiate.cc',
      'http/http_auth_handler_negotiate.h',
      'http/http_auth_handler_ntlm.cc',
      'http/http_auth_handler_ntlm.h',
      'http/http_auth_handler_ntlm_portable.cc',
      'http/http_auth_handler_ntlm_win.cc',
      'http/http_auth_multi_round_parse.cc',
      'http/http_auth_multi_round_parse.h',
      'http/http_auth_preferences.cc',
      'http/http_auth_preferences.h',
      'http/http_auth_sspi_win.cc',
      'http/http_auth_sspi_win.h',
      'http/http_basic_state.cc',
      'http/http_basic_state.h',
      'http/http_basic_stream.cc',
      'http/http_basic_stream.h',
      'http/http_cache.cc',
      'http/http_cache.h',
      'http/http_cache_transaction.cc',
      'http/http_cache_transaction.h',
      'http/http_chunked_decoder.cc',
      'http/http_chunked_decoder.h',
      'http/http_content_disposition.cc',
      'http/http_content_disposition.h',
      'http/http_network_layer.cc',
      'http/http_network_layer.h',
      'http/http_network_session.cc',
      'http/http_network_session.h',
      'http/http_network_session_peer.cc',
      'http/http_network_session_peer.h',
      'http/http_network_transaction.cc',
      'http/http_network_transaction.h',
      'http/http_proxy_client_socket.cc',
      'http/http_proxy_client_socket.h',
      'http/http_proxy_client_socket_pool.cc',
      'http/http_proxy_client_socket_pool.h',
      'http/http_proxy_client_socket_wrapper.cc',
      'http/http_proxy_client_socket_wrapper.h',
      'http/http_request_info.cc',
      'http/http_request_info.h',
      'http/http_response_body_drainer.cc',
      'http/http_response_body_drainer.h',
      'http/http_server_properties.cc',
      'http/http_server_properties.h',
      'http/http_server_properties_impl.cc',
      'http/http_server_properties_impl.h',
      'http/http_server_properties_manager.cc',
      'http/http_server_properties_manager.h',
      'http/http_status_code.cc',
      'http/http_status_code.h',
      'http/http_stream.h',
      'http/http_stream_factory.cc',
      'http/http_stream_factory.h',
      'http/http_stream_factory_impl.cc',
      'http/http_stream_factory_impl.h',
      'http/http_stream_factory_impl_job.cc',
      'http/http_stream_factory_impl_job.h',
      'http/http_stream_factory_impl_request.cc',
      'http/http_stream_factory_impl_request.h',
      'http/http_stream_parser.cc',
      'http/http_stream_parser.h',
      'http/http_transaction.h',
      'http/http_transaction_factory.h',
      'http/http_version.h',
      'http/md4.cc',
      'http/md4.h',
      'http/partial_data.cc',
      'http/partial_data.h',
      'http/proxy_client_socket.cc',
      'http/proxy_client_socket.h',
      'http/proxy_connect_redirect_http_stream.cc',
      'http/proxy_connect_redirect_http_stream.h',
      'http/transport_security_persister.cc',
      'http/transport_security_persister.h',
      'http/transport_security_state_static.h',
      'http/url_security_manager.cc',
      'http/url_security_manager.h',
      'http/url_security_manager_posix.cc',
      'http/url_security_manager_win.cc',
      'proxy/dhcp_proxy_script_adapter_fetcher_win.cc',
      'proxy/dhcp_proxy_script_adapter_fetcher_win.h',
      'proxy/dhcp_proxy_script_fetcher.cc',
      'proxy/dhcp_proxy_script_fetcher.h',
      'proxy/dhcp_proxy_script_fetcher_factory.cc',
      'proxy/dhcp_proxy_script_fetcher_factory.h',
      'proxy/dhcp_proxy_script_fetcher_win.cc',
      'proxy/dhcp_proxy_script_fetcher_win.h',
      'proxy/dhcpcsvc_init_win.cc',
      'proxy/dhcpcsvc_init_win.h',
      'proxy/multi_threaded_proxy_resolver.cc',
      'proxy/multi_threaded_proxy_resolver.h',
      'proxy/network_delegate_error_observer.cc',
      'proxy/network_delegate_error_observer.h',
      'proxy/polling_proxy_config_service.cc',
      'proxy/polling_proxy_config_service.h',
      'proxy/proxy_bypass_rules.cc',
      'proxy/proxy_bypass_rules.h',
      'proxy/proxy_config.cc',
      'proxy/proxy_config.h',
      'proxy/proxy_config_service.h',
      'proxy/proxy_config_service_android.cc',
      'proxy/proxy_config_service_android.h',
      'proxy/proxy_config_service_fixed.cc',
      'proxy/proxy_config_service_fixed.h',
      'proxy/proxy_config_service_ios.cc',
      'proxy/proxy_config_service_ios.h',
      'proxy/proxy_config_service_linux.cc',
      'proxy/proxy_config_service_linux.h',
      'proxy/proxy_config_service_mac.cc',
      'proxy/proxy_config_service_mac.h',
      'proxy/proxy_config_service_win.cc',
      'proxy/proxy_config_service_win.h',
      'proxy/proxy_config_source.cc',
      'proxy/proxy_config_source.h',
      'proxy/proxy_info.cc',
      'proxy/proxy_info.h',
      'proxy/proxy_list.cc',
      'proxy/proxy_list.h',
      'proxy/proxy_resolver.h',
      'proxy/proxy_resolver_error_observer.h',
      'proxy/proxy_resolver_factory.cc',
      'proxy/proxy_resolver_factory.h',
      'proxy/proxy_resolver_mac.cc',
      'proxy/proxy_resolver_mac.h',
      'proxy/proxy_resolver_script.h',
      'proxy/proxy_resolver_script_data.cc',
      'proxy/proxy_resolver_script_data.h',
      'proxy/proxy_resolver_winhttp.cc',
      'proxy/proxy_resolver_winhttp.h',
      'proxy/proxy_retry_info.h',
      'proxy/proxy_script_decider.cc',
      'proxy/proxy_script_decider.h',
      'proxy/proxy_script_fetcher.h',
      'proxy/proxy_script_fetcher_impl.cc',
      'proxy/proxy_script_fetcher_impl.h',
      'proxy/proxy_server.cc',
      'proxy/proxy_server.h',
      'proxy/proxy_server_mac.cc',
      'proxy/proxy_service.cc',
      'proxy/proxy_service.h',
      'quic/crypto/aead_base_decrypter_nss.cc',
      'quic/crypto/aead_base_encrypter_nss.cc',
      'quic/crypto/aes_128_gcm_12_decrypter_nss.cc',
      'quic/crypto/aes_128_gcm_12_encrypter_nss.cc',
      'quic/crypto/cert_compressor.cc',
      'quic/crypto/cert_compressor.h',
      'quic/crypto/chacha20_poly1305_decrypter_nss.cc',
      'quic/crypto/chacha20_poly1305_encrypter_nss.cc',
      'quic/crypto/chacha20_poly1305_rfc7539_decrypter_nss.cc',
      'quic/crypto/chacha20_poly1305_rfc7539_encrypter_nss.cc',
      'quic/crypto/channel_id_nss.cc',
      'quic/crypto/p256_key_exchange_nss.cc',
      'quic/crypto/proof_source_chromium.h',
      'quic/crypto/proof_source_chromium_nss.cc',
      'quic/crypto/proof_source_chromium_openssl.cc',
      'quic/crypto/quic_crypto_client_config.cc',
      'quic/crypto/quic_crypto_client_config.h',
      'quic/crypto/quic_crypto_server_config.cc',
      'quic/crypto/quic_crypto_server_config.h',
      'quic/network_connection.cc',
      'quic/network_connection.h',
      'quic/quic_chromium_client_session.cc',
      'quic/quic_chromium_client_session.h',
      'quic/quic_chromium_client_stream.cc',
      'quic/quic_chromium_client_stream.h',
      'quic/quic_client_session_base.cc',
      'quic/quic_client_session_base.h',
      'quic/quic_client_promised_info.cc',
      'quic/quic_client_promised_info.h',
      'quic/quic_client_push_promise_index.cc',
      'quic/quic_client_push_promise_index.h',
      'quic/quic_crypto_client_stream.cc',
      'quic/quic_crypto_client_stream.h',
      'quic/quic_crypto_client_stream_factory.cc',
      'quic/quic_crypto_client_stream_factory.h',
      'quic/quic_crypto_server_stream.cc',
      'quic/quic_crypto_server_stream.h',
      'quic/quic_headers_stream.cc',
      'quic/quic_headers_stream.h',
      'quic/quic_http_stream.cc',
      'quic/quic_http_stream.h',
      'quic/quic_http_utils.cc',
      'quic/quic_http_utils.h',
      'quic/quic_spdy_session.cc',
      'quic/quic_spdy_session.h',
      'quic/quic_spdy_stream.cc',
      'quic/quic_spdy_stream.h',
      'quic/quic_stream_factory.cc',
      'quic/quic_stream_factory.h',
      'quic/spdy_utils.cc',
      'quic/spdy_utils.h',
      'sdch/sdch_owner.cc',
      'sdch/sdch_owner.h',
      'socket/client_socket_factory.cc',
      'socket/client_socket_factory.h',
      'socket/client_socket_pool.cc',
      'socket/client_socket_pool.h',
      'socket/client_socket_pool_base.cc',
      'socket/client_socket_pool_base.h',
      'socket/client_socket_pool_manager.cc',
      'socket/client_socket_pool_manager.h',
      'socket/client_socket_pool_manager_impl.cc',
      'socket/client_socket_pool_manager_impl.h',
      'socket/nss_ssl_util.cc',
      'socket/nss_ssl_util.h',
      'socket/server_socket.cc',
      'socket/server_socket.h',
      'socket/socket_descriptor.cc',
      'socket/socket_descriptor.h',
      'socket/socket_net_log_params.cc',
      'socket/socket_net_log_params.h',
      'socket/socket_posix.cc',
      'socket/socket_posix.h',
      'socket/socks5_client_socket.cc',
      'socket/socks5_client_socket.h',
      'socket/socks_client_socket.cc',
      'socket/socks_client_socket.h',
      'socket/socks_client_socket_pool.cc',
      'socket/socks_client_socket_pool.h',
      'socket/ssl_client_socket_nss.cc',
      'socket/ssl_client_socket_nss.h',
      'socket/ssl_client_socket_pool.cc',
      'socket/ssl_client_socket_pool.h',
      'socket/ssl_server_socket.h',
      'socket/ssl_server_socket_nss.cc',
      'socket/ssl_server_socket_nss.h',
      'socket/ssl_server_socket_openssl.cc',
      'socket/ssl_server_socket_openssl.h',
      'socket/stream_socket.cc',
      'socket/stream_socket.h',
      'socket/tcp_client_socket.cc',
      'socket/tcp_client_socket.h',
      'socket/tcp_server_socket.cc',
      'socket/tcp_server_socket.h',
      'socket/tcp_socket.h',
      'socket/tcp_socket_posix.cc',
      'socket/tcp_socket_posix.h',
      'socket/tcp_socket_win.cc',
      'socket/tcp_socket_win.h',
      'socket/transport_client_socket_pool.cc',
      'socket/transport_client_socket_pool.h',
      'socket/unix_domain_client_socket_posix.cc',
      'socket/unix_domain_client_socket_posix.h',
      'socket/unix_domain_server_socket_posix.cc',
      'socket/unix_domain_server_socket_posix.h',
      'socket/websocket_endpoint_lock_manager.cc',
      'socket/websocket_endpoint_lock_manager.h',
      'socket/websocket_transport_client_socket_pool.cc',
      'socket/websocket_transport_client_socket_pool.h',
      'socket/websocket_transport_connect_sub_job.cc',
      'socket/websocket_transport_connect_sub_job.h',
      'spdy/buffered_spdy_framer.cc',
      'spdy/buffered_spdy_framer.h',
      'spdy/fuzzing/hpack_fuzz_util.cc',
      'spdy/fuzzing/hpack_fuzz_util.h',
      'spdy/hpack/hpack_constants.cc',
      'spdy/hpack/hpack_constants.h',
      'spdy/hpack/hpack_decoder.cc',
      'spdy/hpack/hpack_decoder.h',
      'spdy/hpack/hpack_encoder.cc',
      'spdy/hpack/hpack_encoder.h',
      'spdy/hpack/hpack_entry.cc',
      'spdy/hpack/hpack_entry.h',
      'spdy/hpack/hpack_header_table.cc',
      'spdy/hpack/hpack_header_table.h',
      'spdy/hpack/hpack_huffman_decoder.cc',
      'spdy/hpack/hpack_huffman_decoder.h',
      'spdy/hpack/hpack_huffman_table.cc',
      'spdy/hpack/hpack_huffman_table.h',
      'spdy/hpack/hpack_input_stream.cc',
      'spdy/hpack/hpack_input_stream.h',
      'spdy/hpack/hpack_output_stream.cc',
      'spdy/hpack/hpack_output_stream.h',
      'spdy/hpack/hpack_static_table.cc',
      'spdy/hpack/hpack_static_table.h',
      'spdy/http2_write_scheduler.h',
      'spdy/priority_write_scheduler.h',
      'spdy/spdy_alt_svc_wire_format.cc',
      'spdy/spdy_alt_svc_wire_format.h',
      'spdy/spdy_bitmasks.h',
      'spdy/spdy_buffer.cc',
      'spdy/spdy_buffer.h',
      'spdy/spdy_buffer_producer.cc',
      'spdy/spdy_buffer_producer.h',
      'spdy/spdy_frame_builder.cc',
      'spdy/spdy_frame_builder.h',
      'spdy/spdy_frame_reader.cc',
      'spdy/spdy_frame_reader.h',
      'spdy/spdy_framer.cc',
      'spdy/spdy_framer.h',
      'spdy/spdy_header_block.cc',
      'spdy/spdy_header_block.h',
      'spdy/spdy_headers_block_parser.cc',
      'spdy/spdy_headers_block_parser.h',
      'spdy/spdy_headers_handler_interface.h',
      'spdy/spdy_http_stream.cc',
      'spdy/spdy_http_stream.h',
      'spdy/spdy_http_utils.cc',
      'spdy/spdy_http_utils.h',
      'spdy/spdy_pinnable_buffer_piece.cc',
      'spdy/spdy_pinnable_buffer_piece.h',
      'spdy/spdy_prefixed_buffer_reader.cc',
      'spdy/spdy_prefixed_buffer_reader.h',
      'spdy/spdy_protocol.cc',
      'spdy/spdy_protocol.h',
      'spdy/spdy_proxy_client_socket.cc',
      'spdy/spdy_proxy_client_socket.h',
      'spdy/spdy_read_queue.cc',
      'spdy/spdy_read_queue.h',
      'spdy/spdy_session.cc',
      'spdy/spdy_session.h',
      'spdy/spdy_session_key.cc',
      'spdy/spdy_session_key.h',
      'spdy/spdy_session_pool.cc',
      'spdy/spdy_session_pool.h',
      'spdy/spdy_stream.cc',
      'spdy/spdy_stream.h',
      'spdy/spdy_write_queue.cc',
      'spdy/spdy_write_queue.h',
      'spdy/write_blocked_list.h',
      'ssl/client_cert_store.h',
      'ssl/client_cert_store_mac.cc',
      'ssl/client_cert_store_mac.h',
      'ssl/client_cert_store_nss.cc',
      'ssl/client_cert_store_nss.h',
      'ssl/client_cert_store_win.cc',
      'ssl/client_cert_store_win.h',
      'ssl/ssl_config_service_defaults.cc',
      'ssl/ssl_config_service_defaults.h',
      'ssl/ssl_key_logger.cc',
      'ssl/ssl_key_logger.h',
      'ssl/ssl_platform_key.h',
      'ssl/ssl_platform_key_android.cc',
      'ssl/ssl_platform_key_mac.cc',
      'ssl/ssl_platform_key_nss.cc',
      'ssl/ssl_platform_key_task_runner.cc',
      'ssl/ssl_platform_key_task_runner.h',
      'ssl/ssl_platform_key_win.cc',
      'ssl/test_ssl_private_key.cc',
      'ssl/test_ssl_private_key.h',
      'ssl/threaded_ssl_private_key.cc',
      'ssl/threaded_ssl_private_key.h',
      'ssl/token_binding.h',
      'ssl/token_binding_nss.cc',
      'ssl/token_binding_openssl.cc',
      'third_party/mozilla_security_manager/nsKeygenHandler.cpp',
      'third_party/mozilla_security_manager/nsKeygenHandler.h',
      'third_party/mozilla_security_manager/nsNSSCertificateDB.cpp',
      'third_party/mozilla_security_manager/nsNSSCertificateDB.h',
      'third_party/mozilla_security_manager/nsPKCS12Blob.cpp',
      'third_party/mozilla_security_manager/nsPKCS12Blob.h',
      'udp/datagram_client_socket.h',
      'udp/datagram_server_socket.h',
      'udp/datagram_socket.h',
      'udp/diff_serv_code_point.h',
      'udp/udp_client_socket.cc',
      'udp/udp_client_socket.h',
      'udp/udp_net_log_parameters.cc',
      'udp/udp_net_log_parameters.h',
      'udp/udp_server_socket.cc',
      'udp/udp_server_socket.h',
      'udp/udp_socket.h',
      'udp/udp_socket_posix.cc',
      'udp/udp_socket_posix.h',
      'udp/udp_socket_win.cc',
      'udp/udp_socket_win.h',
      'url_request/certificate_report_sender.cc',
      'url_request/certificate_report_sender.h',
      'url_request/data_protocol_handler.cc',
      'url_request/data_protocol_handler.h',
      'url_request/http_user_agent_settings.h',
      'url_request/redirect_info.cc',
      'url_request/redirect_info.h',
      'url_request/sdch_dictionary_fetcher.cc',
      'url_request/sdch_dictionary_fetcher.h',
      'url_request/static_http_user_agent_settings.cc',
      'url_request/static_http_user_agent_settings.h',
      'url_request/url_fetcher.cc',
      'url_request/url_fetcher.h',
      'url_request/url_fetcher_core.cc',
      'url_request/url_fetcher_core.h',
      'url_request/url_fetcher_delegate.cc',
      'url_request/url_fetcher_delegate.h',
      'url_request/url_fetcher_factory.h',
      'url_request/url_fetcher_impl.cc',
      'url_request/url_fetcher_impl.h',
      'url_request/url_fetcher_response_writer.cc',
      'url_request/url_fetcher_response_writer.h',
      'url_request/url_range_request_job.cc',
      'url_request/url_range_request_job.h',
      'url_request/url_request.cc',
      'url_request/url_request.h',
      'url_request/url_request_backoff_manager.cc',
      'url_request/url_request_backoff_manager.h',
      'url_request/url_request_context.cc',
      'url_request/url_request_context.h',
      'url_request/url_request_context_builder.cc',
      'url_request/url_request_context_builder.h',
      'url_request/url_request_context_getter.cc',
      'url_request/url_request_context_getter.h',
      'url_request/url_request_context_getter_observer.h',
      'url_request/url_request_context_storage.cc',
      'url_request/url_request_context_storage.h',
      'url_request/url_request_data_job.cc',
      'url_request/url_request_data_job.h',
      'url_request/url_request_error_job.cc',
      'url_request/url_request_error_job.h',
      'url_request/url_request_filter.cc',
      'url_request/url_request_filter.h',
      'url_request/url_request_http_job.cc',
      'url_request/url_request_http_job.h',
      'url_request/url_request_intercepting_job_factory.cc',
      'url_request/url_request_intercepting_job_factory.h',
      'url_request/url_request_interceptor.cc',
      'url_request/url_request_interceptor.h',
      'url_request/url_request_job.cc',
      'url_request/url_request_job.h',
      'url_request/url_request_job_factory.cc',
      'url_request/url_request_job_factory.h',
      'url_request/url_request_job_factory_impl.cc',
      'url_request/url_request_job_factory_impl.h',
      'url_request/url_request_job_manager.cc',
      'url_request/url_request_job_manager.h',
      'url_request/url_request_netlog_params.cc',
      'url_request/url_request_netlog_params.h',
      'url_request/url_request_redirect_job.cc',
      'url_request/url_request_redirect_job.h',
      'url_request/url_request_simple_job.cc',
      'url_request/url_request_simple_job.h',
      'url_request/url_request_status.cc',
      'url_request/url_request_status.h',
      'url_request/url_request_test_job.cc',
      'url_request/url_request_test_job.h',
      'url_request/url_request_throttler_entry.cc',
      'url_request/url_request_throttler_entry.h',
      'url_request/url_request_throttler_entry_interface.h',
      'url_request/url_request_throttler_manager.cc',
      'url_request/url_request_throttler_manager.h',
      'url_request/view_cache_helper.cc',
      'url_request/view_cache_helper.h',
      'url_request/websocket_handshake_userdata_key.cc',
      'url_request/websocket_handshake_userdata_key.h',
    ],
    'net_extras_sources': [
      'extras/sqlite/cookie_crypto_delegate.h',
      'extras/sqlite/sqlite_channel_id_store.cc',
      'extras/sqlite/sqlite_channel_id_store.h',
      'extras/sqlite/sqlite_persistent_cookie_store.cc',
      'extras/sqlite/sqlite_persistent_cookie_store.h',
    ],
    'net_test_sources': [
      'android/dummy_spnego_authenticator.cc',
      'android/dummy_spnego_authenticator.h',
      'android/http_auth_negotiate_android_unittest.cc',
      'android/keystore_unittest.cc',
      'android/network_change_notifier_android_unittest.cc',
      'android/traffic_stats_unittest.cc',
      'base/address_family_unittest.cc',
      'base/address_list_unittest.cc',
      'base/address_tracker_linux_unittest.cc',
      'base/backoff_entry_serializer_unittest.cc',
      'base/backoff_entry_unittest.cc',
      'base/chunked_upload_data_stream_unittest.cc',
      'base/data_url_unittest.cc',
      'base/directory_lister_unittest.cc',
      'base/directory_listing_unittest.cc',
      'base/elements_upload_data_stream_unittest.cc',
      'base/escape_unittest.cc',
      'base/expiring_cache_unittest.cc',
      'base/file_stream_unittest.cc',
      'base/filename_util_unittest.cc',
      'base/host_mapping_rules_unittest.cc',
      'base/host_port_pair_unittest.cc',
      'base/int128_unittest.cc',
      'base/ip_address_number_unittest.cc',
      'base/ip_address_unittest.cc',
      'base/ip_endpoint_unittest.cc',
      'base/ip_pattern_unittest.cc',
      'base/keygen_handler_unittest.cc',
      'base/layered_network_delegate_unittest.cc',
      'base/lookup_string_in_fixed_set_unittest.cc',
      'base/mime_sniffer_unittest.cc',
      'base/mime_util_unittest.cc',
      'base/network_activity_monitor_unittest.cc',
      'base/network_change_notifier_unittest.cc',
      'base/network_change_notifier_win_unittest.cc',
      'base/network_interfaces_unittest.cc',
      'base/network_quality_estimator_unittest.cc',
      'base/port_util_unittest.cc',
      'base/prioritized_dispatcher_unittest.cc',
      'base/priority_queue_unittest.cc',
      'base/registry_controlled_domains/registry_controlled_domain_unittest.cc',
      'base/sdch_dictionary_unittest.cc',
      'base/sdch_manager_unittest.cc',
      'base/stale_while_revalidate_experiment_domains_unittest.cc',
      'base/static_cookie_policy_unittest.cc',
      'base/test_completion_callback_unittest.cc',
      'base/test_proxy_delegate.cc',
      'base/test_proxy_delegate.h',
      'base/upload_bytes_element_reader_unittest.cc',
      'base/upload_file_element_reader_unittest.cc',
      'base/url_util_unittest.cc',
      'cert/ct_policy_enforcer_unittest.cc',
      'cert/cert_verify_proc_unittest.cc',
      'cert/cert_verify_proc_whitelist_unittest.cc',
      'cert/crl_set_unittest.cc',
      'cert/ct_log_response_parser_unittest.cc',
      'cert/ct_log_verifier_unittest.cc',
      'cert/ct_objects_extractor_unittest.cc',
      'cert/ct_serialization_unittest.cc',
      'cert/ev_root_ca_metadata_unittest.cc',
      'cert/internal/certificate_policies_unittest.cc',
      'cert/internal/extended_key_usage_unittest.cc',
      'cert/internal/name_constraints_unittest.cc',
      'cert/internal/nist_pkits_unittest.h',
      'cert/internal/parse_certificate_unittest.cc',
      'cert/internal/parse_name_unittest.cc',
      'cert/internal/signature_algorithm_unittest.cc',
      'cert/internal/test_helpers.cc',
      'cert/internal/test_helpers.h',
      'cert/internal/verify_certificate_chain_unittest.cc',
      'cert/internal/verify_certificate_chain_pkits_unittest.cc',
      'cert/internal/verify_name_match_unittest.cc',
      'cert/internal/verify_signed_data_unittest.cc',
      'cert/jwk_serializer_unittest.cc',
      'cert/multi_log_ct_verifier_unittest.cc',
      'cert/multi_threaded_cert_verifier_unittest.cc',
      'cert/nss_cert_database_chromeos_unittest.cc',
      'cert/nss_cert_database_unittest.cc',
      'cert/nss_profile_filter_chromeos_unittest.cc',
      'cert/pem_tokenizer_unittest.cc',
      'cert/signed_certificate_timestamp_unittest.cc',
      'cert/test_root_certs_unittest.cc',
      'cert/x509_cert_types_unittest.cc',
      'cert/x509_certificate_unittest.cc',
      'cert/x509_util_unittest.cc',
      'cert_net/cert_net_fetcher_impl_unittest.cc',
      'cert_net/nss_ocsp_unittest.cc',
      'cookies/canonical_cookie_unittest.cc',
      'cookies/cookie_constants_unittest.cc',
      'cookies/cookie_monster_unittest.cc',
      'cookies/cookie_store_unittest.cc',
      'cookies/cookie_util_unittest.cc',
      'cookies/parsed_cookie_unittest.cc',
      'der/input_unittest.cc',
      'der/parse_values_unittest.cc',
      'der/parser_unittest.cc',
      'disk_cache/backend_unittest.cc',
      'disk_cache/blockfile/addr_unittest.cc',
      'disk_cache/blockfile/bitmap_unittest.cc',
      'disk_cache/blockfile/block_bitmaps_v3_unittest.cc',
      'disk_cache/blockfile/block_files_unittest.cc',
      'disk_cache/blockfile/index_table_v3_unittest.cc',
      'disk_cache/blockfile/mapped_file_unittest.cc',
      'disk_cache/blockfile/stats_unittest.cc',
      'disk_cache/blockfile/storage_block_unittest.cc',
      'disk_cache/cache_util_unittest.cc',
      'disk_cache/entry_unittest.cc',
      'disk_cache/simple/simple_index_file_unittest.cc',
      'disk_cache/simple/simple_index_unittest.cc',
      'disk_cache/simple/simple_test_util.cc',
      'disk_cache/simple/simple_test_util.h',
      'disk_cache/simple/simple_util_unittest.cc',
      'disk_cache/simple/simple_version_upgrade_unittest.cc',
      'dns/address_sorter_posix_unittest.cc',
      'dns/address_sorter_unittest.cc',
      'dns/dns_config_service_posix_unittest.cc',
      'dns/dns_config_service_unittest.cc',
      'dns/dns_config_service_win_unittest.cc',
      'dns/dns_hosts_unittest.cc',
      'dns/dns_query_unittest.cc',
      'dns/dns_response_unittest.cc',
      'dns/dns_session_unittest.cc',
      'dns/dns_transaction_unittest.cc',
      'dns/dns_util_unittest.cc',
      'dns/host_cache_unittest.cc',
      'dns/host_resolver_impl_unittest.cc',
      'dns/host_resolver_mojo_unittest.cc',
      'dns/mapped_host_resolver_unittest.cc',
      'dns/mdns_cache_unittest.cc',
      'dns/mdns_client_unittest.cc',
      'dns/mojo_host_resolver_impl_unittest.cc',
      'dns/record_parsed_unittest.cc',
      'dns/record_rdata_unittest.cc',
      'dns/serial_worker_unittest.cc',
      'dns/single_request_host_resolver_unittest.cc',
      'extras/sqlite/sqlite_channel_id_store_unittest.cc',
      'extras/sqlite/sqlite_persistent_cookie_store_unittest.cc',
      'filter/brotli_filter_unittest.cc',
      'filter/filter_unittest.cc',
      'filter/gzip_filter_unittest.cc',
      'filter/mock_filter_context.cc',
      'filter/mock_filter_context.h',
      'filter/sdch_filter_unittest.cc',
      'ftp/ftp_auth_cache_unittest.cc',
      'ftp/ftp_ctrl_response_buffer_unittest.cc',
      'ftp/ftp_directory_listing_parser_ls_unittest.cc',
      'ftp/ftp_directory_listing_parser_unittest.cc',
      'ftp/ftp_directory_listing_parser_unittest.h',
      'ftp/ftp_directory_listing_parser_vms_unittest.cc',
      'ftp/ftp_directory_listing_parser_windows_unittest.cc',
      'ftp/ftp_network_transaction_unittest.cc',
      'ftp/ftp_util_unittest.cc',
      'http/bidirectional_stream_unittest.cc',
      'http/des_unittest.cc',
      'http/disk_cache_based_quic_server_info_unittest.cc',
      'http/http_auth_cache_unittest.cc',
      'http/http_auth_challenge_tokenizer_unittest.cc',
      'http/http_auth_controller_unittest.cc',
      'http/http_auth_filter_unittest.cc',
      'http/http_auth_gssapi_posix_unittest.cc',
      'http/http_auth_handler_basic_unittest.cc',
      'http/http_auth_handler_digest_unittest.cc',
      'http/http_auth_handler_factory_unittest.cc',
      'http/http_auth_handler_mock.cc',
      'http/http_auth_handler_mock.h',
      'http/http_auth_handler_negotiate_unittest.cc',
      'http/http_auth_handler_unittest.cc',
      'http/http_auth_multi_round_parse_unittest.cc',
      'http/http_auth_preferences_unittest.cc',
      'http/http_auth_sspi_win_unittest.cc',
      'http/http_auth_unittest.cc',
      'http/http_basic_state_unittest.cc',
      'http/http_byte_range_unittest.cc',
      'http/http_cache_unittest.cc',
      'http/http_chunked_decoder_unittest.cc',
      'http/http_content_disposition_unittest.cc',
      'http/http_log_util_unittest.cc',
      'http/http_network_layer_unittest.cc',
      'http/http_network_transaction_ssl_unittest.cc',
      'http/http_network_transaction_unittest.cc',
      'http/http_proxy_client_socket_pool_unittest.cc',
      'http/http_request_headers_unittest.cc',
      'http/http_response_body_drainer_unittest.cc',
      'http/http_response_headers_unittest.cc',
      'http/http_response_info_unittest.cc',
      'http/http_security_headers_unittest.cc',
      'http/http_server_properties_impl_unittest.cc',
      'http/http_server_properties_manager_unittest.cc',
      'http/http_status_code_unittest.cc',
      'http/http_status_line_validator_unittest.cc',
      'http/http_stream_factory_impl_request_unittest.cc',
      'http/http_stream_factory_impl_unittest.cc',
      'http/http_stream_parser_unittest.cc',
      'http/http_util_unittest.cc',
      'http/http_vary_data_unittest.cc',
      'http/mock_allow_http_auth_preferences.cc',
      'http/mock_allow_http_auth_preferences.h',
      'http/mock_gssapi_library_posix.cc',
      'http/mock_gssapi_library_posix.h',
      'http/mock_http_cache.cc',
      'http/mock_http_cache.h',
      'http/mock_sspi_library_win.cc',
      'http/mock_sspi_library_win.h',
      'http/transport_security_persister_unittest.cc',
      'http/transport_security_state_unittest.cc',
      'http/url_security_manager_unittest.cc',
      'log/net_log_capture_mode_unittest.cc',
      'log/net_log_unittest.cc',
      'log/net_log_util_unittest.cc',
      'log/trace_net_log_observer_unittest.cc',
      'log/write_to_file_net_log_observer_unittest.cc',
      'proxy/dhcp_proxy_script_adapter_fetcher_win_unittest.cc',
      'proxy/dhcp_proxy_script_fetcher_factory_unittest.cc',
      'proxy/dhcp_proxy_script_fetcher_win_unittest.cc',
      'proxy/mojo_proxy_resolver_factory_impl_unittest.cc',
      'proxy/mojo_proxy_resolver_impl_unittest.cc',
      'proxy/mojo_proxy_resolver_v8_tracing_bindings_unittest.cc',
      'proxy/multi_threaded_proxy_resolver_unittest.cc',
      'proxy/network_delegate_error_observer_unittest.cc',
      'proxy/proxy_bypass_rules_unittest.cc',
      'proxy/proxy_config_service_android_unittest.cc',
      'proxy/proxy_config_service_linux_unittest.cc',
      'proxy/proxy_config_service_win_unittest.cc',
      'proxy/proxy_config_unittest.cc',
      'proxy/proxy_info_unittest.cc',
      'proxy/proxy_list_unittest.cc',
      'proxy/proxy_resolver_factory_mojo_unittest.cc',
      'proxy/proxy_resolver_v8_tracing_unittest.cc',
      'proxy/proxy_resolver_v8_tracing_wrapper_unittest.cc',
      'proxy/proxy_resolver_v8_unittest.cc',
      'proxy/proxy_script_decider_unittest.cc',
      'proxy/proxy_script_fetcher_impl_unittest.cc',
      'proxy/proxy_server_unittest.cc',
      'proxy/proxy_service_mojo_unittest.cc',
      'proxy/proxy_service_unittest.cc',
      'quic/congestion_control/cubic_bytes_test.cc',
      'quic/congestion_control/cubic_test.cc',
      'quic/congestion_control/general_loss_algorithm_test.cc',
      'quic/congestion_control/hybrid_slow_start_test.cc',
      'quic/congestion_control/pacing_sender_test.cc',
      'quic/congestion_control/prr_sender_test.cc',
      'quic/congestion_control/rtt_stats_test.cc',
      'quic/congestion_control/send_algorithm_simulator.cc',
      'quic/congestion_control/send_algorithm_simulator.h',
      'quic/congestion_control/tcp_cubic_bytes_sender_test.cc',
      'quic/congestion_control/tcp_cubic_sender_test.cc',
      'quic/congestion_control/tcp_cubic_sender_bytes_test.cc',
      'quic/congestion_control/tcp_cubic_sender_packets_test.cc',
      'quic/crypto/aes_128_gcm_12_decrypter_test.cc',
      'quic/crypto/aes_128_gcm_12_encrypter_test.cc',
      'quic/crypto/cert_compressor_test.cc',
      'quic/crypto/chacha20_poly1305_decrypter_test.cc',
      'quic/crypto/chacha20_poly1305_encrypter_test.cc',
      'quic/crypto/chacha20_poly1305_rfc7539_decrypter_test.cc',
      'quic/crypto/chacha20_poly1305_rfc7539_encrypter_test.cc',
      'quic/crypto/channel_id_test.cc',
      'quic/crypto/common_cert_set_test.cc',
      'quic/crypto/crypto_framer_test.cc',
      'quic/crypto/crypto_handshake_message_test.cc',
      'quic/crypto/crypto_secret_boxer_test.cc',
      'quic/crypto/crypto_server_test.cc',
      'quic/crypto/crypto_utils_test.cc',
      'quic/crypto/curve25519_key_exchange_test.cc',
      'quic/crypto/local_strike_register_client_test.cc',
      'quic/crypto/null_decrypter_test.cc',
      'quic/crypto/null_encrypter_test.cc',
      'quic/crypto/p256_key_exchange_test.cc',
      'quic/crypto/proof_test.cc',
      'quic/crypto/proof_verifier_chromium_test.cc',
      'quic/crypto/properties_based_quic_server_info_test.cc',
      'quic/crypto/quic_crypto_client_config_test.cc',
      'quic/crypto/quic_crypto_server_config_test.cc',
      'quic/crypto/quic_random_test.cc',
      'quic/crypto/strike_register_test.cc',
      'quic/interval_set_test.cc',
      'quic/interval_test.cc',
      'quic/iovector_test.cc',
      'quic/network_connection_unittest.cc',
      'quic/p2p/quic_p2p_session_test.cc',
      'quic/port_suggester_unittest.cc',
      'quic/quic_address_mismatch_test.cc',
      'quic/quic_alarm_test.cc',
      'quic/quic_arena_scoped_ptr_test.cc',
      'quic/quic_bandwidth_test.cc',
      'quic/quic_chromium_client_session_test.cc',
      'quic/quic_chromium_client_stream_test.cc',
      'quic/quic_chromium_connection_helper_test.cc',
      'quic/quic_client_push_promise_index_test.cc',
      'quic/quic_clock_test.cc',
      'quic/quic_config_test.cc',
      'quic/quic_connection_logger_unittest.cc',
      'quic/quic_connection_test.cc',
      'quic/quic_crypto_client_stream_test.cc',
      'quic/quic_crypto_server_stream_test.cc',
      'quic/quic_crypto_stream_test.cc',
      'quic/quic_data_writer_test.cc',
      'quic/quic_fec_group_test.cc',
      'quic/quic_flow_controller_test.cc',
      'quic/quic_framer_test.cc',
      'quic/quic_headers_stream_test.cc',
      'quic/quic_http_stream_test.cc',
      'quic/quic_http_utils_test.cc',
      'quic/quic_multipath_received_packet_manager_test.cc',
      'quic/quic_multipath_transmissions_map_test.cc',
      'quic/quic_network_transaction_unittest.cc',
      'quic/quic_one_block_arena_test.cc',
      'quic/quic_packet_creator_test.cc',
      'quic/quic_packet_generator_test.cc',
      'quic/quic_protocol_test.cc',
      'quic/quic_received_packet_manager_test.cc',
      'quic/quic_sent_entropy_manager_test.cc',
      'quic/quic_sent_packet_manager_test.cc',
      'quic/quic_server_id_test.cc',
      'quic/quic_session_test.cc',
      'quic/quic_simple_buffer_allocator_test.cc',
      'quic/quic_socket_address_coder_test.cc',
      'quic/quic_spdy_stream_test.cc',
      'quic/quic_stream_factory_test.cc',
      'quic/quic_stream_sequencer_test.cc',
      'quic/quic_sustained_bandwidth_recorder_test.cc',
      'quic/quic_time_test.cc',
      'quic/quic_unacked_packet_map_test.cc',
      'quic/quic_utils_chromium_test.cc',
      'quic/quic_utils_test.cc',
      'quic/quic_write_blocked_list_test.cc',
      'quic/reliable_quic_stream_test.cc',
      'quic/spdy_utils_test.cc',
      'quic/stream_sequencer_buffer_test.cc',
      'quic/test_tools/crypto_test_utils.cc',
      'quic/test_tools/crypto_test_utils.h',
      'quic/test_tools/crypto_test_utils_chromium.cc',
      'quic/test_tools/crypto_test_utils_nss.cc',
      'quic/test_tools/crypto_test_utils_openssl.cc',
      'quic/test_tools/delayed_verify_strike_register_client.cc',
      'quic/test_tools/delayed_verify_strike_register_client.h',
      'quic/test_tools/mock_clock.cc',
      'quic/test_tools/mock_clock.h',
      'quic/test_tools/mock_crypto_client_stream.cc',
      'quic/test_tools/mock_crypto_client_stream.h',
      'quic/test_tools/mock_crypto_client_stream_factory.cc',
      'quic/test_tools/mock_crypto_client_stream_factory.h',
      'quic/test_tools/mock_quic_client_promised_info.cc',
      'quic/test_tools/mock_quic_client_promised_info.h',
      'quic/test_tools/mock_quic_dispatcher.cc',
      'quic/test_tools/mock_quic_dispatcher.h',
      'quic/test_tools/mock_quic_spdy_client_stream.cc',
      'quic/test_tools/mock_quic_spdy_client_stream.h',
      'quic/test_tools/mock_random.cc',
      'quic/test_tools/mock_random.h',
      'quic/test_tools/quic_chromium_client_session_peer.cc',
      'quic/test_tools/quic_chromium_client_session_peer.h',
      'quic/test_tools/quic_config_peer.cc',
      'quic/test_tools/quic_config_peer.h',
      'quic/test_tools/quic_connection_peer.cc',
      'quic/test_tools/quic_connection_peer.h',
      'quic/test_tools/quic_flow_controller_peer.cc',
      'quic/test_tools/quic_flow_controller_peer.h',
      'quic/test_tools/quic_framer_peer.cc',
      'quic/test_tools/quic_framer_peer.h',
      'quic/test_tools/quic_packet_creator_peer.cc',
      'quic/test_tools/quic_packet_creator_peer.h',
      'quic/test_tools/quic_packet_generator_peer.cc',
      'quic/test_tools/quic_packet_generator_peer.h',
      'quic/test_tools/quic_received_packet_manager_peer.cc',
      'quic/test_tools/quic_received_packet_manager_peer.h',
      'quic/test_tools/quic_sent_packet_manager_peer.cc',
      'quic/test_tools/quic_sent_packet_manager_peer.h',
      'quic/test_tools/quic_session_peer.cc',
      'quic/test_tools/quic_session_peer.h',
      'quic/test_tools/quic_spdy_session_peer.cc',
      'quic/test_tools/quic_spdy_session_peer.h',
      'quic/test_tools/quic_spdy_stream_peer.cc',
      'quic/test_tools/quic_spdy_stream_peer.h',
      'quic/test_tools/quic_stream_factory_peer.cc',
      'quic/test_tools/quic_stream_factory_peer.h',
      'quic/test_tools/quic_stream_sequencer_peer.cc',
      'quic/test_tools/quic_stream_sequencer_peer.h',
      'quic/test_tools/quic_sustained_bandwidth_recorder_peer.cc',
      'quic/test_tools/quic_sustained_bandwidth_recorder_peer.h',
      'quic/test_tools/quic_test_packet_maker.cc',
      'quic/test_tools/quic_test_packet_maker.h',
      'quic/test_tools/quic_test_utils.cc',
      'quic/test_tools/quic_test_utils.h',
      'quic/test_tools/reliable_quic_stream_peer.cc',
      'quic/test_tools/reliable_quic_stream_peer.h',
      'quic/test_tools/rtt_stats_peer.cc',
      'quic/test_tools/rtt_stats_peer.h',
      'quic/test_tools/simple_quic_framer.cc',
      'quic/test_tools/simple_quic_framer.h',
      'quic/test_tools/test_task_runner.cc',
      'quic/test_tools/test_task_runner.h',
      'sdch/sdch_owner_unittest.cc',
      'server/http_connection_unittest.cc',
      'server/http_server_response_info_unittest.cc',
      'server/http_server_unittest.cc',
      'server/web_socket_encoder_unittest.cc',
      'socket/client_socket_pool_base_unittest.cc',
      'socket/mock_client_socket_pool_manager.cc',
      'socket/mock_client_socket_pool_manager.h',
      'socket/sequenced_socket_data_unittest.cc',
      'socket/socks5_client_socket_unittest.cc',
      'socket/socks_client_socket_pool_unittest.cc',
      'socket/socks_client_socket_unittest.cc',
      'socket/ssl_client_socket_pool_unittest.cc',
      'socket/ssl_client_socket_unittest.cc',
      'socket/ssl_server_socket_unittest.cc',
      'socket/tcp_client_socket_unittest.cc',
      'socket/tcp_server_socket_unittest.cc',
      'socket/tcp_socket_unittest.cc',
      'socket/transport_client_socket_pool_test_util.cc',
      'socket/transport_client_socket_pool_test_util.h',
      'socket/transport_client_socket_pool_unittest.cc',
      'socket/transport_client_socket_unittest.cc',
      'socket/unix_domain_client_socket_posix_unittest.cc',
      'socket/unix_domain_server_socket_posix_unittest.cc',
      'socket/websocket_endpoint_lock_manager_unittest.cc',
      'socket/websocket_transport_client_socket_pool_unittest.cc',
      'spdy/buffered_spdy_framer_unittest.cc',
      'spdy/fuzzing/hpack_fuzz_util_test.cc',
      'spdy/hpack/hpack_decoder_test.cc',
      'spdy/hpack/hpack_encoder_test.cc',
      'spdy/hpack/hpack_entry_test.cc',
      'spdy/hpack/hpack_header_table_test.cc',
      'spdy/hpack/hpack_huffman_decoder_test.cc',
      'spdy/hpack/hpack_huffman_table_test.cc',
      'spdy/hpack/hpack_input_stream_test.cc',
      'spdy/hpack/hpack_output_stream_test.cc',
      'spdy/hpack/hpack_round_trip_test.cc',
      'spdy/hpack/hpack_static_table_test.cc',
      'spdy/http2_write_scheduler_test.cc',
      'spdy/mock_spdy_framer_visitor.cc',
      'spdy/mock_spdy_framer_visitor.h',
      'spdy/priority_write_scheduler_test.cc',
      'spdy/spdy_alt_svc_wire_format_test.cc',
      'spdy/spdy_buffer_unittest.cc',
      'spdy/spdy_frame_builder_test.cc',
      'spdy/spdy_frame_reader_test.cc',
      'spdy/spdy_framer_test.cc',
      'spdy/spdy_header_block_test.cc',
      'spdy/spdy_headers_block_parser_test.cc',
      'spdy/spdy_http_stream_unittest.cc',
      'spdy/spdy_http_utils_unittest.cc',
      'spdy/spdy_network_transaction_unittest.cc',
      'spdy/spdy_pinnable_buffer_piece_test.cc',
      'spdy/spdy_prefixed_buffer_reader_test.cc',
      'spdy/spdy_protocol_test.cc',
      'spdy/spdy_proxy_client_socket_unittest.cc',
      'spdy/spdy_read_queue_unittest.cc',
      'spdy/spdy_session_pool_unittest.cc',
      'spdy/spdy_session_test_util.cc',
      'spdy/spdy_session_test_util.h',
      'spdy/spdy_session_unittest.cc',
      'spdy/spdy_stream_test_util.cc',
      'spdy/spdy_stream_test_util.h',
      'spdy/spdy_stream_unittest.cc',
      'spdy/spdy_test_util_common.cc',
      'spdy/spdy_test_util_common.h',
      'spdy/spdy_test_utils.cc',
      'spdy/spdy_test_utils.h',
      'spdy/spdy_write_queue_unittest.cc',
      'spdy/write_blocked_list_test.cc',
      'ssl/channel_id_service_unittest.cc',
      'ssl/client_cert_store_mac_unittest.cc',
      'ssl/client_cert_store_nss_unittest.cc',
      'ssl/client_cert_store_unittest-inl.h',
      'ssl/client_cert_store_win_unittest.cc',
      'ssl/default_channel_id_store_unittest.cc',
      'ssl/openssl_client_key_store_unittest.cc',
      'ssl/ssl_cipher_suite_names_unittest.cc',
      'ssl/ssl_client_auth_cache_unittest.cc',
      'ssl/ssl_client_session_cache_openssl_unittest.cc',
      'ssl/ssl_config_service_unittest.cc',
      'ssl/ssl_config_unittest.cc',
      'ssl/ssl_connection_status_flags_unittest.cc',
      'test/embedded_test_server/embedded_test_server_unittest.cc',
      'test/embedded_test_server/http_request_unittest.cc',
      'test/embedded_test_server/http_response_unittest.cc',
      'test/gtest_util.h',
      'test/python_utils_unittest.cc',
      'test/run_all_unittests.cc',
      'test/scoped_disable_exit_on_dfatal.cc',
      'test/scoped_disable_exit_on_dfatal.h',
      'third_party/nist-pkits/pkits_testcases-inl.h',
      'tools/balsa/balsa_frame_test.cc',
      'tools/balsa/balsa_headers_test.cc',
      'tools/quic/quic_simple_client_test.cc',
      'tools/quic/test_tools/mock_quic_server_session_visitor.cc',
      'tools/quic/test_tools/mock_quic_server_session_visitor.h',
      'tools/tld_cleanup/tld_cleanup_util_unittest.cc',
      'udp/udp_socket_unittest.cc',
      'url_request/certificate_report_sender_unittest.cc',
      'url_request/sdch_dictionary_fetcher_unittest.cc',
      'url_request/url_fetcher_impl_unittest.cc',
      'url_request/url_fetcher_response_writer_unittest.cc',
      'url_request/url_request_backoff_manager_unittest.cc',
      'url_request/url_request_context_builder_unittest.cc',
      'url_request/url_request_data_job_unittest.cc',
      'url_request/url_request_file_dir_job_unittest.cc',
      'url_request/url_request_file_job_unittest.cc',
      'url_request/url_request_filter_unittest.cc',
      'url_request/url_request_ftp_job_unittest.cc',
      'url_request/url_request_http_job_unittest.cc',
      'url_request/url_request_job_factory_impl_unittest.cc',
      'url_request/url_request_job_unittest.cc',
      'url_request/url_request_simple_job_unittest.cc',
      'url_request/url_request_throttler_simulation_unittest.cc',
      'url_request/url_request_throttler_test_support.cc',
      'url_request/url_request_throttler_test_support.h',
      'url_request/url_request_throttler_unittest.cc',
      'url_request/url_request_unittest.cc',
      'url_request/view_cache_helper_unittest.cc',
      'websockets/websocket_basic_stream_test.cc',
      'websockets/websocket_channel_test.cc',
      'websockets/websocket_deflate_parameters_test.cc',
      'websockets/websocket_deflate_predictor_impl_test.cc',
      'websockets/websocket_deflate_stream_test.cc',
      'websockets/websocket_deflater_test.cc',
      'websockets/websocket_end_to_end_test.cc',
      'websockets/websocket_errors_test.cc',
      'websockets/websocket_extension_parser_test.cc',
      'websockets/websocket_extension_test.cc',
      'websockets/websocket_frame_parser_test.cc',
      'websockets/websocket_frame_test.cc',
      'websockets/websocket_handshake_challenge_test.cc',
      'websockets/websocket_handshake_stream_create_helper_test.cc',
      'websockets/websocket_inflater_test.cc',
      'websockets/websocket_stream_cookie_test.cc',
      'websockets/websocket_stream_create_test_base.cc',
      'websockets/websocket_stream_create_test_base.h',
      'websockets/websocket_stream_test.cc',
      'websockets/websocket_test_util.cc',
      'websockets/websocket_test_util.h',
    ],
    'net_linux_test_sources': [
      'quic/quic_end_to_end_unittest.cc',
      'tools/quic/end_to_end_test.cc',
      'tools/quic/quic_client_session_test.cc',
      'tools/quic/quic_client_test.cc',
      'tools/quic/quic_dispatcher_test.cc',
      'tools/quic/quic_epoll_clock_test.cc',
      'tools/quic/quic_epoll_connection_helper_test.cc',
      'tools/quic/quic_in_memory_cache_test.cc',
      'tools/quic/quic_server_session_base_test.cc',
      'tools/quic/quic_server_test.cc',
      'tools/quic/quic_simple_server_session_test.cc',
      'tools/quic/quic_simple_server_test.cc',
      'tools/quic/quic_spdy_client_stream_test.cc',
      'tools/quic/quic_time_wait_list_manager_test.cc',
      'tools/quic/spdy_balsa_utils_test.cc',
      'tools/quic/test_tools/http_message.cc',
      'tools/quic/test_tools/http_message.h',
      'tools/quic/test_tools/limited_mtu_test_writer.cc',
      'tools/quic/test_tools/limited_mtu_test_writer.h',
      'tools/quic/test_tools/mock_epoll_server.cc',
      'tools/quic/test_tools/mock_epoll_server.h',
      'tools/quic/test_tools/mock_quic_time_wait_list_manager.cc',
      'tools/quic/test_tools/mock_quic_time_wait_list_manager.h',
      'tools/quic/test_tools/packet_dropping_test_writer.cc',
      'tools/quic/test_tools/packet_dropping_test_writer.h',
      'tools/quic/test_tools/quic_client_peer.cc',
      'tools/quic/test_tools/quic_client_peer.h',
      'tools/quic/test_tools/quic_dispatcher_peer.cc',
      'tools/quic/test_tools/quic_dispatcher_peer.h',
      'tools/quic/test_tools/quic_in_memory_cache_peer.cc',
      'tools/quic/test_tools/quic_in_memory_cache_peer.h',
      'tools/quic/test_tools/quic_server_peer.cc',
      'tools/quic/test_tools/quic_server_peer.h',
      'tools/quic/test_tools/quic_test_client.cc',
      'tools/quic/test_tools/quic_test_client.h',
      'tools/quic/test_tools/quic_test_server.cc',
      'tools/quic/test_tools/quic_test_server.h',
      'tools/quic/test_tools/server_thread.cc',
      'tools/quic/test_tools/server_thread.h',
      'tools/quic/test_tools/simple_client.cc',
      'tools/quic/test_tools/simple_client.h',
    ],
    'net_base_mac_ios_sources': [
      'base/mac/url_conversions.h',
      'base/mac/url_conversions.mm',
    ],
    'net_base_test_mac_ios_sources': [
      'base/mac/url_conversions_unittest.mm',
    ],
    'net_file_support_sources': [
      "base/directory_lister.cc",
      "base/directory_lister.h",
      "base/directory_listing.cc",
      "base/directory_listing.h",
      "url_request/file_protocol_handler.cc",
      "url_request/file_protocol_handler.h",
      "url_request/url_request_file_dir_job.cc",
      "url_request/url_request_file_dir_job.h",
      "url_request/url_request_file_job.cc",
      "url_request/url_request_file_job.h",
    ],
    'net_ftp_support_sources': [
      "ftp/ftp_auth_cache.cc",
      "ftp/ftp_auth_cache.h",
      "ftp/ftp_ctrl_response_buffer.cc",
      "ftp/ftp_ctrl_response_buffer.h",
      "ftp/ftp_directory_listing_parser.cc",
      "ftp/ftp_directory_listing_parser.h",
      "ftp/ftp_directory_listing_parser_ls.cc",
      "ftp/ftp_directory_listing_parser_ls.h",
      "ftp/ftp_directory_listing_parser_vms.cc",
      "ftp/ftp_directory_listing_parser_vms.h",
      "ftp/ftp_directory_listing_parser_windows.cc",
      "ftp/ftp_directory_listing_parser_windows.h",
      "ftp/ftp_network_layer.cc",
      "ftp/ftp_network_layer.h",
      "ftp/ftp_network_session.cc",
      "ftp/ftp_network_session.h",
      "ftp/ftp_network_transaction.cc",
      "ftp/ftp_network_transaction.h",
      "ftp/ftp_request_info.h",
      "ftp/ftp_response_info.cc",
      "ftp/ftp_response_info.h",
      "ftp/ftp_server_type_histograms.cc",
      "ftp/ftp_server_type_histograms.h",
      "ftp/ftp_transaction.h",
      "ftp/ftp_transaction_factory.h",
      "ftp/ftp_util.cc",
      "ftp/ftp_util.h",
      "url_request/ftp_protocol_handler.cc",
      "url_request/ftp_protocol_handler.h",
      "url_request/url_request_ftp_job.cc",
      "url_request/url_request_ftp_job.h",
    ],
    'net_bidirectional_stream_sources': [
      'http/bidirectional_stream.cc',
      'http/bidirectional_stream.h',
      'http/bidirectional_stream_job.cc',
      'http/bidirectional_stream_job.h',
      'http/bidirectional_stream_request_info.cc',
      'http/bidirectional_stream_request_info.h',
      'spdy/bidirectional_stream_spdy_job.cc',
      'spdy/bidirectional_stream_spdy_job.h',
    ],
    'net_websockets_sources': [
      "websockets/websocket_basic_handshake_stream.cc",
      "websockets/websocket_basic_handshake_stream.h",
      "websockets/websocket_basic_stream.cc",
      "websockets/websocket_basic_stream.h",
      "websockets/websocket_channel.cc",
      "websockets/websocket_channel.h",
      "websockets/websocket_deflate_parameters.cc",
      "websockets/websocket_deflate_parameters.h",
      "websockets/websocket_deflate_predictor.h",
      "websockets/websocket_deflate_predictor_impl.cc",
      "websockets/websocket_deflate_predictor_impl.h",
      "websockets/websocket_deflate_stream.cc",
      "websockets/websocket_deflate_stream.h",
      "websockets/websocket_deflater.cc",
      "websockets/websocket_deflater.h",
      "websockets/websocket_errors.cc",
      "websockets/websocket_errors.h",
      "websockets/websocket_extension.cc",
      "websockets/websocket_extension.h",
      "websockets/websocket_extension_parser.cc",
      "websockets/websocket_extension_parser.h",
      "websockets/websocket_frame.cc",
      "websockets/websocket_frame.h",
      "websockets/websocket_frame_parser.cc",
      "websockets/websocket_frame_parser.h",
      "websockets/websocket_handshake_challenge.cc",
      "websockets/websocket_handshake_challenge.h",
      "websockets/websocket_handshake_constants.cc",
      "websockets/websocket_handshake_constants.h",
      "websockets/websocket_handshake_request_info.cc",
      "websockets/websocket_handshake_request_info.h",
      "websockets/websocket_handshake_response_info.cc",
      "websockets/websocket_handshake_response_info.h",
      "websockets/websocket_handshake_stream_base.h",
      "websockets/websocket_handshake_stream_create_helper.cc",
      "websockets/websocket_handshake_stream_create_helper.h",
      "websockets/websocket_inflater.cc",
      "websockets/websocket_inflater.h",
      "websockets/websocket_mux.h",
      "websockets/websocket_stream.cc",
      "websockets/websocket_stream.h",
    ],
    'net_docs_script': 'tools/net_docs/net_docs.py',
    'net_docs_sources': [
      'README.md',
      'docs/bug-triage.md',
      'docs/bug-triage-labels.md',
      'docs/bug-triage-suggested-workflow.md',
      'docs/code-patterns.md',
      'docs/crash-course-in-net-internals.md',
      'docs/life-of-a-url-request.md',
      'sdch/README.md',
    ],
    'net_docs_output_dir': '<(PRODUCT_DIR)/net/docs',
  }
}
