# Copyright 2014 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

from telemetry.page import page as page
from telemetry import story


archive_data_file_path = 'data/service_worker_micro_benchmark.json'


class ServiceWorkerBenchmarkPage(page.Page):
  """Page for workload to measure some specific functions in JS"""

  def RunNavigateSteps(self, action_runner):
    super(ServiceWorkerBenchmarkPage, self).RunNavigateSteps(action_runner)
    action_runner.WaitForJavaScriptCondition('window.done')


class ServiceWorkerMicroBenchmarkPageSet(story.StorySet):
  """Page set for micro benchmarking of each functions with ServiceWorker"""

  def __init__(self):
    super(ServiceWorkerMicroBenchmarkPageSet, self).__init__(
        archive_data_file=archive_data_file_path,
        cloud_storage_bucket=story.PUBLIC_BUCKET)

    # pylint: disable=line-too-long
    # The latest code of localhost:8091 is from:
    # https://github.com/horo-t/Service-Worker-Performance/tree/fix-flakyness
    # (rev: 0cc35c2398526665399ca99fe53147ff81101408)
    # TODO(falken): House the code in GoogleChrome's GitHub repository.
    # pylint: enable=C0301
    # Why: to measure performance of many concurrent fetches
    self.AddStory(ServiceWorkerBenchmarkPage(
        'http://localhost:8091/index.html', self,
        make_javascript_deterministic=False))
