// Copyright 2015 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MASH_SHELL_SHELL_APPLICATION_DELEGATE_H_
#define MASH_SHELL_SHELL_APPLICATION_DELEGATE_H_

#include <map>

#include "base/callback.h"
#include "base/macros.h"
#include "base/memory/scoped_ptr.h"
#include "mash/shell/public/interfaces/shell.mojom.h"
#include "mojo/public/cpp/bindings/binding_set.h"
#include "mojo/public/cpp/bindings/interface_ptr_set.h"
#include "mojo/shell/public/cpp/interface_factory.h"
#include "mojo/shell/public/cpp/shell_client.h"

namespace mojo {
class Connection;
}

namespace mash {
namespace shell {

class ShellApplicationDelegate
    : public mojo::ShellClient,
      public mash::shell::mojom::Shell,
      public mojo::InterfaceFactory<mash::shell::mojom::Shell> {
 public:
  ShellApplicationDelegate();
  ~ShellApplicationDelegate() override;

 private:
  // mojo::ShellClient:
  void Initialize(mojo::Connector* connector,
                  const mojo::Identity& identity,
                  uint32_t id) override;
  bool AcceptConnection(mojo::Connection* connection) override;

  // mash::shell::mojom::Shell:
  void AddScreenlockStateListener(
      mojom::ScreenlockStateListenerPtr listener) override;
  void LockScreen() override;
  void UnlockScreen() override;

  // mojo::InterfaceFactory<mash::shell::mojom::Shell>:
  void Create(mojo::Connection* connection,
              mojo::InterfaceRequest<mash::shell::mojom::Shell> r) override;

  void StartWindowManager();
  void StartSystemUI();
  void StartBrowserDriver();
  void StartQuickLaunch();

  void StartScreenlock();
  void StopScreenlock();

  // Starts the application at |url|, running |restart_callback| if the
  // connection to the application is closed.
  void StartRestartableService(const std::string& url,
                               const base::Closure& restart_callback);

  mojo::Connector* connector_;
  std::map<std::string, scoped_ptr<mojo::Connection>> connections_;
  bool screen_locked_;
  mojo::BindingSet<mash::shell::mojom::Shell> bindings_;
  mojo::InterfacePtrSet<mojom::ScreenlockStateListener> screenlock_listeners_;

  DISALLOW_COPY_AND_ASSIGN(ShellApplicationDelegate);
};

}  // namespace shell
}  // namespace mash

#endif  // MASH_SHELL_SHELL_APPLICATION_DELEGATE_H_
