// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_APP_LIST_SEARCH_ARC_APP_RESULT_H_
#define CHROME_BROWSER_UI_APP_LIST_SEARCH_ARC_APP_RESULT_H_

#include <string>

#include "base/macros.h"
#include "base/memory/scoped_ptr.h"
#include "chrome/browser/ui/app_icon_loader_delegate.h"
#include "chrome/browser/ui/app_list/search/app_result.h"

class AppListControllerDelegate;
class ArcAppContextMenu;
class ArcAppIconLoader;
class Profile;

namespace app_list {

class ArcAppResult : public AppResult,
                     public AppIconLoaderDelegate {
 public:
  ArcAppResult(Profile* profile,
               const std::string& app_id,
               AppListControllerDelegate* controller,
               bool is_recommendation);
  ~ArcAppResult() override;

  // SearchResult overrides:
  void Open(int event_flags) override;
  scoped_ptr<SearchResult> Duplicate() const override;
  ui::MenuModel* GetContextMenuModel() override;

  // AppContextMenuDelegate overrides:
  void ExecuteLaunchCommand(int event_flags) override;

  // AppIconLoaderDelegate overrides:
  void OnAppImageUpdated(const std::string& app_id,
                         const gfx::ImageSkia& image) override;

 private:
  scoped_ptr<ArcAppIconLoader> icon_loader_;
  scoped_ptr<ArcAppContextMenu> context_menu_;

  DISALLOW_COPY_AND_ASSIGN(ArcAppResult);
};

}  // namespace app_list

#endif  // CHROME_BROWSER_UI_APP_LIST_SEARCH_ARC_APP_RESULT_H_
