// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

package org.chromium.chrome.browser.ntp.snippets;

import android.graphics.Rect;
import android.support.v7.widget.RecyclerView;
import android.view.View;

/**
 * A class that decorates the RecyclerView elements.
 */
public class SnippetItemDecoration extends RecyclerView.ItemDecoration {
    private static final int VERTICAL_SPACE = 1;

    @Override
    public void getItemOffsets(Rect outRect, View view, RecyclerView parent,
            RecyclerView.State state) {
        // Reset the bounds of the outRect.
        outRect.setEmpty();

        // Do not add a vertical space to the last item.
        if (parent.getChildAdapterPosition(view) != parent.getAdapter().getItemCount() - 1) {
            outRect.bottom = VERTICAL_SPACE;
        }
    }
}