// Copyright 2015 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MASH_BROWSER_DRIVER_BROWSER_DRIVER_APPLICATION_DELEGATE_H_
#define MASH_BROWSER_DRIVER_BROWSER_DRIVER_APPLICATION_DELEGATE_H_

#include <stdint.h>

#include <map>

#include "base/callback.h"
#include "base/macros.h"
#include "base/memory/weak_ptr.h"
#include "components/mus/public/interfaces/accelerator_registrar.mojom.h"
#include "mojo/public/cpp/bindings/binding.h"
#include "services/shell/public/cpp/shell_client.h"

namespace mash {
namespace browser_driver {

class BrowserDriverApplicationDelegate : public shell::ShellClient,
                                         public mus::mojom::AcceleratorHandler {
 public:
  BrowserDriverApplicationDelegate();
  ~BrowserDriverApplicationDelegate() override;

 private:
  // shell::ShellClient:
  void Initialize(shell::Connector* connector,
                  const shell::Identity& identity,
                  uint32_t id) override;
  bool AcceptConnection(shell::Connection* connection) override;
  bool ShellConnectionLost() override;

  // mus::mojom::AcceleratorHandler:
  void OnAccelerator(uint32_t id, mus::mojom::EventPtr event) override;

  void AddAccelerators();

  shell::Connector* connector_;
  mojo::Binding<mus::mojom::AcceleratorHandler> binding_;
  base::WeakPtrFactory<BrowserDriverApplicationDelegate> weak_factory_;

  DISALLOW_COPY_AND_ASSIGN(BrowserDriverApplicationDelegate);
};

}  // namespace browser_driver
}  // namespace mash

#endif  // MASH_BROWSER_DRIVER_BROWSER_DRIVER_APPLICATION_DELEGATE_H_
