# Copyright 2012 the V8 project authors. All rights reserved.
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
#
#     * Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimer.
#     * Redistributions in binary form must reproduce the above
#       copyright notice, this list of conditions and the following
#       disclaimer in the documentation and/or other materials provided
#       with the distribution.
#     * Neither the name of Google Inc. nor the names of its
#       contributors may be used to endorse or promote products derived
#       from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

{
  'variables': {
    'icu_use_data_file_flag%': 0,
    'v8_code': 1,
    'v8_random_seed%': 314159265,
    'v8_vector_stores%': 0,
    'embed_script%': "",
    'warmup_script%': "",
    'v8_extra_library_files%': [],
    'v8_experimental_extra_library_files%': [],
    'mksnapshot_exec': '<(PRODUCT_DIR)/<(EXECUTABLE_PREFIX)mksnapshot<(EXECUTABLE_SUFFIX)',
  },
  'includes': ['../gypfiles/toolchain.gypi', '../gypfiles/features.gypi'],
  'targets': [
    {
      'target_name': 'v8',
      'dependencies_traverse': 1,
      'dependencies': ['v8_maybe_snapshot'],
      'conditions': [
        ['want_separate_host_toolset==1', {
          'toolsets': ['host', 'target'],
        }, {
          'toolsets': ['target'],
        }],
        ['component=="shared_library"', {
          'type': '<(component)',
          'sources': [
            # Note: on non-Windows we still build this file so that gyp
            # has some sources to link into the component.
            'v8dll-main.cc',
          ],
          'include_dirs': [
            '..',
          ],
          'defines': [
            'V8_SHARED',
            'BUILDING_V8_SHARED',
          ],
          'direct_dependent_settings': {
            'defines': [
              'V8_SHARED',
              'USING_V8_SHARED',
            ],
          },
          'target_conditions': [
            ['OS=="android" and _toolset=="target"', {
              'libraries': [
                '-llog',
              ],
              'include_dirs': [
                'src/common/android/include',
              ],
            }],
          ],
          'conditions': [
            ['OS=="mac"', {
              'xcode_settings': {
                'OTHER_LDFLAGS': ['-dynamiclib', '-all_load']
              },
            }],
            ['soname_version!=""', {
              'product_extension': 'so.<(soname_version)',
            }],
          ],
        },
        {
          'type': 'none',
        }],
      ],
      'direct_dependent_settings': {
        'include_dirs': [
          '../include',
        ],
      },
    },
    {
      # This rule delegates to either v8_snapshot, v8_nosnapshot, or
      # v8_external_snapshot, depending on the current variables.
      # The intention is to make the 'calling' rules a bit simpler.
      'target_name': 'v8_maybe_snapshot',
      'type': 'none',
      'conditions': [
        ['v8_use_snapshot!="true"', {
          # The dependency on v8_base should come from a transitive
          # dependency however the Android toolchain requires libv8_base.a
          # to appear before libv8_snapshot.a so it's listed explicitly.
          'dependencies': ['v8_base', 'v8_nosnapshot'],
        }],
        ['v8_use_snapshot=="true" and v8_use_external_startup_data==0', {
          # The dependency on v8_base should come from a transitive
          # dependency however the Android toolchain requires libv8_base.a
          # to appear before libv8_snapshot.a so it's listed explicitly.
          'dependencies': ['v8_base', 'v8_snapshot'],
        }],
        ['v8_use_snapshot=="true" and v8_use_external_startup_data==1 and want_separate_host_toolset==0', {
          'dependencies': ['v8_base', 'v8_external_snapshot'],
          'inputs': [ '<(PRODUCT_DIR)/snapshot_blob.bin', ],
        }],
        ['v8_use_snapshot=="true" and v8_use_external_startup_data==1 and want_separate_host_toolset==1', {
          'dependencies': ['v8_base', 'v8_external_snapshot'],
          'target_conditions': [
            ['_toolset=="host"', {
              'inputs': [
                '<(PRODUCT_DIR)/snapshot_blob_host.bin',
              ],
            }, {
              'inputs': [
                '<(PRODUCT_DIR)/snapshot_blob.bin',
              ],
            }],
          ],
        }],
        ['want_separate_host_toolset==1', {
          'toolsets': ['host', 'target'],
        }, {
          'toolsets': ['target'],
        }],
      ]
    },
    {
      'target_name': 'v8_snapshot',
      'type': 'static_library',
      'conditions': [
        ['want_separate_host_toolset==1', {
          'toolsets': ['host', 'target'],
          'dependencies': [
            'mksnapshot#host',
            'js2c#host',
          ],
        }, {
          'toolsets': ['target'],
          'dependencies': [
            'mksnapshot',
            'js2c',
          ],
        }],
        ['component=="shared_library"', {
          'defines': [
            'V8_SHARED',
            'BUILDING_V8_SHARED',
          ],
          'direct_dependent_settings': {
            'defines': [
              'V8_SHARED',
              'USING_V8_SHARED',
            ],
          },
        }],
      ],
      'dependencies': [
        'v8_base',
      ],
      'include_dirs+': [
        '..',
      ],
      'sources': [
        '<(SHARED_INTERMEDIATE_DIR)/libraries.cc',
        '<(SHARED_INTERMEDIATE_DIR)/experimental-libraries.cc',
        '<(SHARED_INTERMEDIATE_DIR)/extras-libraries.cc',
        '<(SHARED_INTERMEDIATE_DIR)/experimental-extras-libraries.cc',
        '<(INTERMEDIATE_DIR)/snapshot.cc',
      ],
      'actions': [
        {
          'action_name': 'run_mksnapshot',
          'inputs': [
            '<(mksnapshot_exec)',
          ],
          'conditions': [
            ['embed_script!=""', {
              'inputs': [
                '<(embed_script)',
              ],
            }],
            ['warmup_script!=""', {
              'inputs': [
                '<(warmup_script)',
              ],
            }],
          ],
          'outputs': [
            '<(INTERMEDIATE_DIR)/snapshot.cc',
          ],
          'variables': {
            'mksnapshot_flags': [],
            'conditions': [
              ['v8_random_seed!=0', {
                'mksnapshot_flags': ['--random-seed', '<(v8_random_seed)'],
              }],
              ['v8_vector_stores!=0', {
                'mksnapshot_flags': ['--vector-stores'],
              }],
            ],
          },
          'action': [
            '<(mksnapshot_exec)',
            '<@(mksnapshot_flags)',
            '--startup_src', '<@(INTERMEDIATE_DIR)/snapshot.cc',
            '<(embed_script)',
            '<(warmup_script)',
          ],
        },
      ],
    },
    {
      'target_name': 'v8_nosnapshot',
      'type': 'static_library',
      'dependencies': [
        'v8_base',
      ],
      'include_dirs+': [
        '..',
      ],
      'sources': [
        '<(SHARED_INTERMEDIATE_DIR)/libraries.cc',
        '<(SHARED_INTERMEDIATE_DIR)/experimental-libraries.cc',
        '<(SHARED_INTERMEDIATE_DIR)/extras-libraries.cc',
        '<(SHARED_INTERMEDIATE_DIR)/experimental-extras-libraries.cc',
        'snapshot/snapshot-empty.cc',
      ],
      'conditions': [
        ['want_separate_host_toolset==1', {
          'toolsets': ['host', 'target'],
          'dependencies': ['js2c#host'],
        }, {
          'toolsets': ['target'],
          'dependencies': ['js2c'],
        }],
        ['component=="shared_library"', {
          'defines': [
            'BUILDING_V8_SHARED',
            'V8_SHARED',
          ],
        }],
      ]
    },
    {
      'target_name': 'v8_external_snapshot',
      'type': 'static_library',
      'conditions': [
        [ 'v8_use_external_startup_data==1', {
          'conditions': [
            ['want_separate_host_toolset==1', {
              'toolsets': ['host', 'target'],
              'dependencies': [
                'mksnapshot#host',
                'js2c#host',
                'natives_blob',
            ]}, {
              'toolsets': ['target'],
              'dependencies': [
                'mksnapshot',
                'js2c',
                'natives_blob',
              ],
            }],
            ['component=="shared_library"', {
              'defines': [
                'V8_SHARED',
                'BUILDING_V8_SHARED',
              ],
              'direct_dependent_settings': {
                'defines': [
                  'V8_SHARED',
                  'USING_V8_SHARED',
                ],
              },
            }],
          ],
          'dependencies': [
            'v8_base',
          ],
          'include_dirs+': [
            '..',
          ],
          'sources': [
            'snapshot/natives-external.cc',
            'snapshot/snapshot-external.cc',
          ],
          'actions': [
            {
              'action_name': 'run_mksnapshot (external)',
              'inputs': [
                '<(mksnapshot_exec)',
              ],
              'variables': {
                'mksnapshot_flags': [],
                'conditions': [
                  ['v8_random_seed!=0', {
                    'mksnapshot_flags': ['--random-seed', '<(v8_random_seed)'],
                  }],
                  ['v8_vector_stores!=0', {
                    'mksnapshot_flags': ['--vector-stores'],
                  }],
                ],
              },
              'conditions': [
                ['embed_script!=""', {
                  'inputs': [
                    '<(embed_script)',
                  ],
                }],
                ['warmup_script!=""', {
                  'inputs': [
                    '<(warmup_script)',
                  ],
                }],
                ['want_separate_host_toolset==1', {
                  'target_conditions': [
                    ['_toolset=="host"', {
                      'outputs': [
                        '<(PRODUCT_DIR)/snapshot_blob_host.bin',
                      ],
                      'action': [
                        '<(mksnapshot_exec)',
                        '<@(mksnapshot_flags)',
                        '--startup_blob', '<(PRODUCT_DIR)/snapshot_blob_host.bin',
                        '<(embed_script)',
                        '<(warmup_script)',
                      ],
                    }, {
                      'outputs': [
                        '<(PRODUCT_DIR)/snapshot_blob.bin',
                      ],
                      'action': [
                        '<(mksnapshot_exec)',
                        '<@(mksnapshot_flags)',
                        '--startup_blob', '<(PRODUCT_DIR)/snapshot_blob.bin',
                        '<(embed_script)',
                        '<(warmup_script)',
                      ],
                    }],
                  ],
                }, {
                  'outputs': [
                    '<(PRODUCT_DIR)/snapshot_blob.bin',
                  ],
                  'action': [
                    '<(mksnapshot_exec)',
                    '<@(mksnapshot_flags)',
                    '--startup_blob', '<(PRODUCT_DIR)/snapshot_blob.bin',
                    '<(embed_script)',
                    '<(warmup_script)',
                  ],
                }],
              ],
            },
          ],
        }],
      ],
    },
    {
      'target_name': 'v8_base',
      'type': 'static_library',
      'dependencies': [
        'v8_libbase',
      ],
      'variables': {
        'optimize': 'max',
      },
      'include_dirs+': [
        '..',
        # To be able to find base/trace_event/common/trace_event_common.h
        '../..',
      ],
      'sources': [  ### gcmole(all) ###
        '../include/v8-debug.h',
        '../include/v8-experimental.h',
        '../include/v8-platform.h',
        '../include/v8-profiler.h',
        '../include/v8-testing.h',
        '../include/v8-util.h',
        '../include/v8-version.h',
        '../include/v8.h',
        '../include/v8config.h',
        'accessors.cc',
        'accessors.h',
        'address-map.cc',
        'address-map.h',
        'allocation.cc',
        'allocation.h',
        'allocation-site-scopes.cc',
        'allocation-site-scopes.h',
        'api-experimental.cc',
        'api-experimental.h',
        'api.cc',
        'api.h',
        'api-arguments.cc',
        'api-arguments.h',
        'api-natives.cc',
        'api-natives.h',
        'arguments.cc',
        'arguments.h',
        'assembler.cc',
        'assembler.h',
        'assert-scope.h',
        'assert-scope.cc',
        'ast/ast-expression-rewriter.cc',
        'ast/ast-expression-rewriter.h',
        'ast/ast-expression-visitor.cc',
        'ast/ast-expression-visitor.h',
        'ast/ast-literal-reindexer.cc',
        'ast/ast-literal-reindexer.h',
        'ast/ast-numbering.cc',
        'ast/ast-numbering.h',
        'ast/ast-type-bounds.h',
        'ast/ast-value-factory.cc',
        'ast/ast-value-factory.h',
        'ast/ast.cc',
        'ast/ast.h',
        'ast/modules.cc',
        'ast/modules.h',
        'ast/prettyprinter.cc',
        'ast/prettyprinter.h',
        'ast/scopeinfo.cc',
        'ast/scopeinfo.h',
        'ast/scopes.cc',
        'ast/scopes.h',
        'ast/variables.cc',
        'ast/variables.h',
        'background-parsing-task.cc',
        'background-parsing-task.h',
        'bailout-reason.cc',
        'bailout-reason.h',
        'basic-block-profiler.cc',
        'basic-block-profiler.h',
        'bignum-dtoa.cc',
        'bignum-dtoa.h',
        'bignum.cc',
        'bignum.h',
        'bit-vector.cc',
        'bit-vector.h',
        'bootstrapper.cc',
        'bootstrapper.h',
        'builtins.cc',
        'builtins.h',
        'cached-powers.cc',
        'cached-powers.h',
        'cancelable-task.cc',
        'cancelable-task.h',
        'char-predicates.cc',
        'char-predicates-inl.h',
        'char-predicates.h',
        'checks.h',
        'code-factory.cc',
        'code-factory.h',
        'code-stub-assembler.cc',
        'code-stub-assembler.h',
        'code-stubs.cc',
        'code-stubs.h',
        'code-stubs-hydrogen.cc',
        'codegen.cc',
        'codegen.h',
        'collector.h',
        'compilation-cache.cc',
        'compilation-cache.h',
        'compilation-dependencies.cc',
        'compilation-dependencies.h',
        'compilation-statistics.cc',
        'compilation-statistics.h',
        'compiler/access-builder.cc',
        'compiler/access-builder.h',
        'compiler/access-info.cc',
        'compiler/access-info.h',
        'compiler/all-nodes.cc',
        'compiler/all-nodes.h',
        'compiler/ast-graph-builder.cc',
        'compiler/ast-graph-builder.h',
        'compiler/ast-loop-assignment-analyzer.cc',
        'compiler/ast-loop-assignment-analyzer.h',
        'compiler/basic-block-instrumentor.cc',
        'compiler/basic-block-instrumentor.h',
        'compiler/branch-elimination.cc',
        'compiler/branch-elimination.h',
        'compiler/bytecode-branch-analysis.cc',
        'compiler/bytecode-branch-analysis.h',
        'compiler/bytecode-graph-builder.cc',
        'compiler/bytecode-graph-builder.h',
        'compiler/c-linkage.cc',
        'compiler/coalesced-live-ranges.cc',
        'compiler/coalesced-live-ranges.h',
        'compiler/code-generator-impl.h',
        'compiler/code-generator.cc',
        'compiler/code-generator.h',
        'compiler/code-assembler.cc',
        'compiler/code-assembler.h',
        'compiler/common-node-cache.cc',
        'compiler/common-node-cache.h',
        'compiler/common-operator-reducer.cc',
        'compiler/common-operator-reducer.h',
        'compiler/common-operator.cc',
        'compiler/common-operator.h',
        'compiler/control-builders.cc',
        'compiler/control-builders.h',
        'compiler/control-equivalence.cc',
        'compiler/control-equivalence.h',
        'compiler/control-flow-optimizer.cc',
        'compiler/control-flow-optimizer.h',
        'compiler/dead-code-elimination.cc',
        'compiler/dead-code-elimination.h',
        'compiler/diamond.h',
        'compiler/effect-control-linearizer.cc',
        'compiler/effect-control-linearizer.h',
        'compiler/escape-analysis.cc',
        'compiler/escape-analysis.h',
        "compiler/escape-analysis-reducer.cc",
        "compiler/escape-analysis-reducer.h",
        'compiler/frame.cc',
        'compiler/frame.h',
        'compiler/frame-elider.cc',
        'compiler/frame-elider.h',
        "compiler/frame-states.cc",
        "compiler/frame-states.h",
        'compiler/gap-resolver.cc',
        'compiler/gap-resolver.h',
        'compiler/graph-reducer.cc',
        'compiler/graph-reducer.h',
        'compiler/graph-replay.cc',
        'compiler/graph-replay.h',
        'compiler/graph-trimmer.cc',
        'compiler/graph-trimmer.h',
        'compiler/graph-visualizer.cc',
        'compiler/graph-visualizer.h',
        'compiler/graph.cc',
        'compiler/graph.h',
        'compiler/greedy-allocator.cc',
        'compiler/greedy-allocator.h',
        'compiler/instruction-codes.h',
        'compiler/instruction-selector-impl.h',
        'compiler/instruction-selector.cc',
        'compiler/instruction-selector.h',
        'compiler/instruction-scheduler.cc',
        'compiler/instruction-scheduler.h',
        'compiler/instruction.cc',
        'compiler/instruction.h',
        'compiler/int64-lowering.cc',
        'compiler/int64-lowering.h',
        'compiler/js-builtin-reducer.cc',
        'compiler/js-builtin-reducer.h',
        'compiler/js-call-reducer.cc',
        'compiler/js-call-reducer.h',
        'compiler/js-context-specialization.cc',
        'compiler/js-context-specialization.h',
        'compiler/js-create-lowering.cc',
        'compiler/js-create-lowering.h',
        'compiler/js-frame-specialization.cc',
        'compiler/js-frame-specialization.h',
        'compiler/js-generic-lowering.cc',
        'compiler/js-generic-lowering.h',
        'compiler/js-global-object-specialization.cc',
        'compiler/js-global-object-specialization.h',
        'compiler/js-graph.cc',
        'compiler/js-graph.h',
        'compiler/js-inlining.cc',
        'compiler/js-inlining.h',
        'compiler/js-inlining-heuristic.cc',
        'compiler/js-inlining-heuristic.h',
        'compiler/js-intrinsic-lowering.cc',
        'compiler/js-intrinsic-lowering.h',
        'compiler/js-native-context-specialization.cc',
        'compiler/js-native-context-specialization.h',
        'compiler/js-operator.cc',
        'compiler/js-operator.h',
        'compiler/js-typed-lowering.cc',
        'compiler/js-typed-lowering.h',
        'compiler/jump-threading.cc',
        'compiler/jump-threading.h',
        'compiler/linkage.cc',
        'compiler/linkage.h',
        'compiler/liveness-analyzer.cc',
        'compiler/liveness-analyzer.h',
        'compiler/live-range-separator.cc',
        'compiler/live-range-separator.h',
        'compiler/load-elimination.cc',
        'compiler/load-elimination.h',
        'compiler/loop-analysis.cc',
        'compiler/loop-analysis.h',
        'compiler/loop-peeling.cc',
        'compiler/loop-peeling.h',
        'compiler/machine-operator-reducer.cc',
        'compiler/machine-operator-reducer.h',
        'compiler/machine-operator.cc',
        'compiler/machine-operator.h',
        'compiler/memory-optimizer.cc',
        'compiler/memory-optimizer.h',
        'compiler/move-optimizer.cc',
        'compiler/move-optimizer.h',
        'compiler/node-aux-data.h',
        'compiler/node-cache.cc',
        'compiler/node-cache.h',
        'compiler/node-marker.cc',
        'compiler/node-marker.h',
        'compiler/node-matchers.cc',
        'compiler/node-matchers.h',
        'compiler/node-properties.cc',
        'compiler/node-properties.h',
        'compiler/node.cc',
        'compiler/node.h',
        'compiler/opcodes.cc',
        'compiler/opcodes.h',
        'compiler/operator-properties.cc',
        'compiler/operator-properties.h',
        'compiler/operator.cc',
        'compiler/operator.h',
        'compiler/osr.cc',
        'compiler/osr.h',
        'compiler/pipeline.cc',
        'compiler/pipeline.h',
        'compiler/pipeline-statistics.cc',
        'compiler/pipeline-statistics.h',
        'compiler/raw-machine-assembler.cc',
        'compiler/raw-machine-assembler.h',
        'compiler/register-allocator.cc',
        'compiler/register-allocator.h',
        'compiler/register-allocator-verifier.cc',
        'compiler/register-allocator-verifier.h',
        'compiler/representation-change.cc',
        'compiler/representation-change.h',
        'compiler/schedule.cc',
        'compiler/schedule.h',
        'compiler/scheduler.cc',
        'compiler/scheduler.h',
        'compiler/select-lowering.cc',
        'compiler/select-lowering.h',
        'compiler/simplified-lowering.cc',
        'compiler/simplified-lowering.h',
        'compiler/simplified-operator-reducer.cc',
        'compiler/simplified-operator-reducer.h',
        'compiler/simplified-operator.cc',
        'compiler/simplified-operator.h',
        'compiler/source-position.cc',
        'compiler/source-position.h',
        'compiler/state-values-utils.cc',
        'compiler/state-values-utils.h',
        'compiler/tail-call-optimization.cc',
        'compiler/tail-call-optimization.h',
        'compiler/type-hint-analyzer.cc',
        'compiler/type-hint-analyzer.h',
        'compiler/type-hints.cc',
        'compiler/type-hints.h',
        'compiler/typer.cc',
        'compiler/typer.h',
        'compiler/value-numbering-reducer.cc',
        'compiler/value-numbering-reducer.h',
        'compiler/verifier.cc',
        'compiler/verifier.h',
        'compiler/wasm-compiler.cc',
        'compiler/wasm-compiler.h',
        'compiler/wasm-linkage.cc',
        'compiler/zone-pool.cc',
        'compiler/zone-pool.h',
        'compiler.cc',
        'compiler.h',
        'context-measure.cc',
        'context-measure.h',
        'contexts-inl.h',
        'contexts.cc',
        'contexts.h',
        'conversions-inl.h',
        'conversions.cc',
        'conversions.h',
        'counters-inl.h',
        'counters.cc',
        'counters.h',
        'crankshaft/compilation-phase.cc',
        'crankshaft/compilation-phase.h',
        'crankshaft/hydrogen-alias-analysis.h',
        'crankshaft/hydrogen-bce.cc',
        'crankshaft/hydrogen-bce.h',
        'crankshaft/hydrogen-canonicalize.cc',
        'crankshaft/hydrogen-canonicalize.h',
        'crankshaft/hydrogen-check-elimination.cc',
        'crankshaft/hydrogen-check-elimination.h',
        'crankshaft/hydrogen-dce.cc',
        'crankshaft/hydrogen-dce.h',
        'crankshaft/hydrogen-dehoist.cc',
        'crankshaft/hydrogen-dehoist.h',
        'crankshaft/hydrogen-environment-liveness.cc',
        'crankshaft/hydrogen-environment-liveness.h',
        'crankshaft/hydrogen-escape-analysis.cc',
        'crankshaft/hydrogen-escape-analysis.h',
        'crankshaft/hydrogen-flow-engine.h',
        'crankshaft/hydrogen-gvn.cc',
        'crankshaft/hydrogen-gvn.h',
        'crankshaft/hydrogen-infer-representation.cc',
        'crankshaft/hydrogen-infer-representation.h',
        'crankshaft/hydrogen-infer-types.cc',
        'crankshaft/hydrogen-infer-types.h',
        'crankshaft/hydrogen-instructions.cc',
        'crankshaft/hydrogen-instructions.h',
        'crankshaft/hydrogen-load-elimination.cc',
        'crankshaft/hydrogen-load-elimination.h',
        'crankshaft/hydrogen-mark-deoptimize.cc',
        'crankshaft/hydrogen-mark-deoptimize.h',
        'crankshaft/hydrogen-mark-unreachable.cc',
        'crankshaft/hydrogen-mark-unreachable.h',
        'crankshaft/hydrogen-osr.cc',
        'crankshaft/hydrogen-osr.h',
        'crankshaft/hydrogen-range-analysis.cc',
        'crankshaft/hydrogen-range-analysis.h',
        'crankshaft/hydrogen-redundant-phi.cc',
        'crankshaft/hydrogen-redundant-phi.h',
        'crankshaft/hydrogen-removable-simulates.cc',
        'crankshaft/hydrogen-removable-simulates.h',
        'crankshaft/hydrogen-representation-changes.cc',
        'crankshaft/hydrogen-representation-changes.h',
        'crankshaft/hydrogen-sce.cc',
        'crankshaft/hydrogen-sce.h',
        'crankshaft/hydrogen-store-elimination.cc',
        'crankshaft/hydrogen-store-elimination.h',
        'crankshaft/hydrogen-types.cc',
        'crankshaft/hydrogen-types.h',
        'crankshaft/hydrogen-uint32-analysis.cc',
        'crankshaft/hydrogen-uint32-analysis.h',
        'crankshaft/hydrogen.cc',
        'crankshaft/hydrogen.h',
        'crankshaft/lithium-allocator-inl.h',
        'crankshaft/lithium-allocator.cc',
        'crankshaft/lithium-allocator.h',
        'crankshaft/lithium-codegen.cc',
        'crankshaft/lithium-codegen.h',
        'crankshaft/lithium.cc',
        'crankshaft/lithium.h',
        'crankshaft/lithium-inl.h',
        'crankshaft/typing.cc',
        'crankshaft/typing.h',
        'crankshaft/unique.h',
        'date.cc',
        'date.h',
        'dateparser-inl.h',
        'dateparser.cc',
        'dateparser.h',
        'debug/debug-evaluate.cc',
        'debug/debug-evaluate.h',
        'debug/debug-frames.cc',
        'debug/debug-frames.h',
        'debug/debug-scopes.cc',
        'debug/debug-scopes.h',
        'debug/debug.cc',
        'debug/debug.h',
        'debug/liveedit.cc',
        'debug/liveedit.h',
        'deoptimizer.cc',
        'deoptimizer.h',
        'disasm.h',
        'disassembler.cc',
        'disassembler.h',
        'diy-fp.cc',
        'diy-fp.h',
        'double.h',
        'dtoa.cc',
        'dtoa.h',
        'effects.h',
        'elements-kind.cc',
        'elements-kind.h',
        'elements.cc',
        'elements.h',
        'execution.cc',
        'execution.h',
        'extensions/externalize-string-extension.cc',
        'extensions/externalize-string-extension.h',
        'extensions/free-buffer-extension.cc',
        'extensions/free-buffer-extension.h',
        'extensions/gc-extension.cc',
        'extensions/gc-extension.h',
        'extensions/ignition-statistics-extension.cc',
        'extensions/ignition-statistics-extension.h',
        'extensions/statistics-extension.cc',
        'extensions/statistics-extension.h',
        'extensions/trigger-failure-extension.cc',
        'extensions/trigger-failure-extension.h',
        'external-reference-table.cc',
        'external-reference-table.h',
        'factory.cc',
        'factory.h',
        'fast-accessor-assembler.cc',
        'fast-accessor-assembler.h',
        'fast-dtoa.cc',
        'fast-dtoa.h',
        'field-index.h',
        'field-index-inl.h',
        'field-type.cc',
        'field-type.h',
        'fixed-dtoa.cc',
        'fixed-dtoa.h',
        'flag-definitions.h',
        'flags.cc',
        'flags.h',
        'frames-inl.h',
        'frames.cc',
        'frames.h',
        'full-codegen/full-codegen.cc',
        'full-codegen/full-codegen.h',
        'futex-emulation.cc',
        'futex-emulation.h',
        'gdb-jit.cc',
        'gdb-jit.h',
        'global-handles.cc',
        'global-handles.h',
        'globals.h',
        'handles-inl.h',
        'handles.cc',
        'handles.h',
        'hashmap.h',
        'heap-symbols.h',
        'heap/array-buffer-tracker.cc',
        'heap/array-buffer-tracker.h',
        'heap/memory-reducer.cc',
        'heap/memory-reducer.h',
        'heap/gc-idle-time-handler.cc',
        'heap/gc-idle-time-handler.h',
        'heap/gc-tracer.cc',
        'heap/gc-tracer.h',
        'heap/heap-inl.h',
        'heap/heap.cc',
        'heap/heap.h',
        'heap/incremental-marking-inl.h',
        'heap/incremental-marking-job.cc',
        'heap/incremental-marking-job.h',
        'heap/incremental-marking.cc',
        'heap/incremental-marking.h',
        'heap/mark-compact-inl.h',
        'heap/mark-compact.cc',
        'heap/mark-compact.h',
        'heap/object-stats.cc',
        'heap/object-stats.h',
        'heap/objects-visiting-inl.h',
        'heap/objects-visiting.cc',
        'heap/objects-visiting.h',
        'heap/page-parallel-job.h',
        'heap/remembered-set.cc',
        'heap/remembered-set.h',
        'heap/scavenge-job.h',
        'heap/scavenge-job.cc',
        'heap/scavenger-inl.h',
        'heap/scavenger.cc',
        'heap/scavenger.h',
        'heap/slot-set.h',
        'heap/spaces-inl.h',
        'heap/spaces.cc',
        'heap/spaces.h',
        'heap/store-buffer.cc',
        'heap/store-buffer.h',
        'i18n.cc',
        'i18n.h',
        'icu_util.cc',
        'icu_util.h',
        'ic/access-compiler.cc',
        'ic/access-compiler.h',
        'ic/call-optimization.cc',
        'ic/call-optimization.h',
        'ic/handler-compiler.cc',
        'ic/handler-compiler.h',
        'ic/ic-inl.h',
        'ic/ic-state.cc',
        'ic/ic-state.h',
        'ic/ic.cc',
        'ic/ic.h',
        'ic/ic-compiler.cc',
        'ic/ic-compiler.h',
        'identity-map.cc',
        'identity-map.h',
        'interface-descriptors.cc',
        'interface-descriptors.h',
        'interpreter/bytecodes.cc',
        'interpreter/bytecodes.h',
        'interpreter/bytecode-array-builder.cc',
        'interpreter/bytecode-array-builder.h',
        'interpreter/bytecode-array-iterator.cc',
        'interpreter/bytecode-array-iterator.h',
        'interpreter/bytecode-array-writer.cc',
        'interpreter/bytecode-array-writer.h',
        'interpreter/bytecode-peephole-optimizer.cc',
        'interpreter/bytecode-peephole-optimizer.h',
        'interpreter/bytecode-pipeline.cc',
        'interpreter/bytecode-pipeline.h',
        'interpreter/bytecode-register-allocator.cc',
        'interpreter/bytecode-register-allocator.h',
        'interpreter/bytecode-generator.cc',
        'interpreter/bytecode-generator.h',
        'interpreter/bytecode-traits.h',
        'interpreter/constant-array-builder.cc',
        'interpreter/constant-array-builder.h',
        'interpreter/control-flow-builders.cc',
        'interpreter/control-flow-builders.h',
        'interpreter/handler-table-builder.cc',
        'interpreter/handler-table-builder.h',
        'interpreter/interpreter.cc',
        'interpreter/interpreter.h',
        'interpreter/interpreter-assembler.cc',
        'interpreter/interpreter-assembler.h',
        'interpreter/interpreter-intrinsics.cc',
        'interpreter/interpreter-intrinsics.h',
        'interpreter/source-position-table.cc',
        'interpreter/source-position-table.h',
        'isolate-inl.h',
        'isolate.cc',
        'isolate.h',
        'json-parser.h',
        'json-stringifier.h',
        'keys.h',
        'keys.cc',
        'layout-descriptor-inl.h',
        'layout-descriptor.cc',
        'layout-descriptor.h',
        'list-inl.h',
        'list.h',
        'locked-queue-inl.h',
        'locked-queue.h',
        'log-inl.h',
        'log-utils.cc',
        'log-utils.h',
        'log.cc',
        'log.h',
        'lookup.cc',
        'lookup.h',
        'macro-assembler.h',
        'machine-type.cc',
        'machine-type.h',
        'messages.cc',
        'messages.h',
        'msan.h',
        'objects-body-descriptors-inl.h',
        'objects-body-descriptors.h',
        'objects-debug.cc',
        'objects-inl.h',
        'objects-printer.cc',
        'objects.cc',
        'objects.h',
        'optimizing-compile-dispatcher.cc',
        'optimizing-compile-dispatcher.h',
        'ostreams.cc',
        'ostreams.h',
        'parsing/expression-classifier.h',
        'parsing/func-name-inferrer.cc',
        'parsing/func-name-inferrer.h',
        'parsing/parameter-initializer-rewriter.cc',
        'parsing/parameter-initializer-rewriter.h',
        'parsing/parser-base.h',
        'parsing/parser.cc',
        'parsing/parser.h',
        'parsing/pattern-rewriter.cc',
        'parsing/preparse-data-format.h',
        'parsing/preparse-data.cc',
        'parsing/preparse-data.h',
        'parsing/preparser.cc',
        'parsing/preparser.h',
        'parsing/rewriter.cc',
        'parsing/rewriter.h',
        'parsing/scanner-character-streams.cc',
        'parsing/scanner-character-streams.h',
        'parsing/scanner.cc',
        'parsing/scanner.h',
        'parsing/token.cc',
        'parsing/token.h',
        'pending-compilation-error-handler.cc',
        'pending-compilation-error-handler.h',
        'perf-jit.cc',
        'perf-jit.h',
        'profiler/allocation-tracker.cc',
        'profiler/allocation-tracker.h',
        'profiler/circular-queue-inl.h',
        'profiler/circular-queue.h',
        'profiler/cpu-profiler-inl.h',
        'profiler/cpu-profiler.cc',
        'profiler/cpu-profiler.h',
        'profiler/heap-profiler.cc',
        'profiler/heap-profiler.h',
        'profiler/heap-snapshot-generator-inl.h',
        'profiler/heap-snapshot-generator.cc',
        'profiler/heap-snapshot-generator.h',
        'profiler/profile-generator-inl.h',
        'profiler/profile-generator.cc',
        'profiler/profile-generator.h',
        'profiler/sampler.cc',
        'profiler/sampler.h',
        'profiler/sampling-heap-profiler.cc',
        'profiler/sampling-heap-profiler.h',
        'profiler/strings-storage.cc',
        'profiler/strings-storage.h',
        'profiler/tick-sample.cc',
        'profiler/tick-sample.h',
        'profiler/unbound-queue-inl.h',
        'profiler/unbound-queue.h',
        'property-descriptor.cc',
        'property-descriptor.h',
        'property-details.h',
        'property.cc',
        'property.h',
        'prototype.h',
        'regexp/bytecodes-irregexp.h',
        'regexp/interpreter-irregexp.cc',
        'regexp/interpreter-irregexp.h',
        'regexp/jsregexp-inl.h',
        'regexp/jsregexp.cc',
        'regexp/jsregexp.h',
        'regexp/regexp-ast.cc',
        'regexp/regexp-ast.h',
        'regexp/regexp-macro-assembler-irregexp-inl.h',
        'regexp/regexp-macro-assembler-irregexp.cc',
        'regexp/regexp-macro-assembler-irregexp.h',
        'regexp/regexp-macro-assembler-tracer.cc',
        'regexp/regexp-macro-assembler-tracer.h',
        'regexp/regexp-macro-assembler.cc',
        'regexp/regexp-macro-assembler.h',
        'regexp/regexp-parser.cc',
        'regexp/regexp-parser.h',
        'regexp/regexp-stack.cc',
        'regexp/regexp-stack.h',
        'register-configuration.cc',
        'register-configuration.h',
        'runtime-profiler.cc',
        'runtime-profiler.h',
        'runtime/runtime-array.cc',
        'runtime/runtime-atomics.cc',
        'runtime/runtime-classes.cc',
        'runtime/runtime-collections.cc',
        'runtime/runtime-compiler.cc',
        'runtime/runtime-date.cc',
        'runtime/runtime-debug.cc',
        'runtime/runtime-forin.cc',
        'runtime/runtime-function.cc',
        'runtime/runtime-futex.cc',
        'runtime/runtime-generator.cc',
        'runtime/runtime-i18n.cc',
        'runtime/runtime-internal.cc',
        'runtime/runtime-interpreter.cc',
        'runtime/runtime-json.cc',
        'runtime/runtime-literals.cc',
        'runtime/runtime-liveedit.cc',
        'runtime/runtime-maths.cc',
        'runtime/runtime-numbers.cc',
        'runtime/runtime-object.cc',
        'runtime/runtime-operators.cc',
        'runtime/runtime-proxy.cc',
        'runtime/runtime-regexp.cc',
        'runtime/runtime-scopes.cc',
        'runtime/runtime-simd.cc',
        'runtime/runtime-strings.cc',
        'runtime/runtime-symbol.cc',
        'runtime/runtime-test.cc',
        'runtime/runtime-typedarray.cc',
        'runtime/runtime-uri.cc',
        'runtime/runtime-utils.h',
        'runtime/runtime.cc',
        'runtime/runtime.h',
        'safepoint-table.cc',
        'safepoint-table.h',
        'signature.h',
        'simulator.h',
        'small-pointer-list.h',
        'snapshot/code-serializer.cc',
        'snapshot/code-serializer.h',
        'snapshot/deserializer.cc',
        'snapshot/deserializer.h',
        'snapshot/natives.h',
        'snapshot/natives-common.cc',
        'snapshot/partial-serializer.cc',
        'snapshot/partial-serializer.h',
        'snapshot/serializer.cc',
        'snapshot/serializer.h',
        'snapshot/serializer-common.cc',
        'snapshot/serializer-common.h',
        'snapshot/snapshot.h',
        'snapshot/snapshot-common.cc',
        'snapshot/snapshot-source-sink.cc',
        'snapshot/snapshot-source-sink.h',
        'snapshot/startup-serializer.cc',
        'snapshot/startup-serializer.h',
        'source-position.h',
        'splay-tree.h',
        'splay-tree-inl.h',
        'startup-data-util.cc',
        'startup-data-util.h',
        'string-builder.cc',
        'string-builder.h',
        'string-search.h',
        'string-stream.cc',
        'string-stream.h',
        'strtod.cc',
        'strtod.h',
        'ic/stub-cache.cc',
        'ic/stub-cache.h',
        'tracing/trace-event.cc',
        'tracing/trace-event.h',
        'transitions-inl.h',
        'transitions.cc',
        'transitions.h',
        'type-cache.cc',
        'type-cache.h',
        'type-feedback-vector-inl.h',
        'type-feedback-vector.cc',
        'type-feedback-vector.h',
        'type-info.cc',
        'type-info.h',
        'types.cc',
        'types.h',
        'typing-asm.cc',
        'typing-asm.h',
        'unicode-inl.h',
        'unicode.cc',
        'unicode.h',
        'unicode-cache-inl.h',
        'unicode-cache.h',
        'unicode-decoder.cc',
        'unicode-decoder.h',
        'uri.cc',
        'uri.h',
        'utils-inl.h',
        'utils.cc',
        'utils.h',
        'v8.cc',
        'v8.h',
        'v8memory.h',
        'v8threads.cc',
        'v8threads.h',
        'vector.h',
        'version.cc',
        'version.h',
        'vm-state-inl.h',
        'vm-state.h',
        'wasm/asm-wasm-builder.cc',
        'wasm/asm-wasm-builder.h',
        'wasm/ast-decoder.cc',
        'wasm/ast-decoder.h',
        'wasm/decoder.h',
        'wasm/encoder.cc',
        'wasm/encoder.h',
        'wasm/leb-helper.h',
        'wasm/module-decoder.cc',
        'wasm/module-decoder.h',
        'wasm/switch-logic.h',
        'wasm/switch-logic.cc',
        'wasm/wasm-external-refs.cc',
        'wasm/wasm-external-refs.h',
        'wasm/wasm-function-name-table.cc',
        'wasm/wasm-function-name-table.h',
        'wasm/wasm-js.cc',
        'wasm/wasm-js.h',
        'wasm/wasm-macro-gen.h',
        'wasm/wasm-module.cc',
        'wasm/wasm-module.h',
        'wasm/wasm-opcodes.cc',
        'wasm/wasm-opcodes.h',
        'wasm/wasm-result.cc',
        'wasm/wasm-result.h',
        'zone.cc',
        'zone.h',
        'zone-allocator.h',
        'zone-containers.h',
        'third_party/fdlibm/fdlibm.cc',
        'third_party/fdlibm/fdlibm.h',
      ],
      'conditions': [
        ['want_separate_host_toolset==1', {
          'toolsets': ['host', 'target'],
        }, {
          'toolsets': ['target'],
        }],
        ['v8_target_arch=="arm"', {
          'sources': [  ### gcmole(arch:arm) ###
            'arm/assembler-arm-inl.h',
            'arm/assembler-arm.cc',
            'arm/assembler-arm.h',
            'arm/builtins-arm.cc',
            'arm/code-stubs-arm.cc',
            'arm/code-stubs-arm.h',
            'arm/codegen-arm.cc',
            'arm/codegen-arm.h',
            'arm/constants-arm.h',
            'arm/constants-arm.cc',
            'arm/cpu-arm.cc',
            'arm/deoptimizer-arm.cc',
            'arm/disasm-arm.cc',
            'arm/frames-arm.cc',
            'arm/frames-arm.h',
            'arm/interface-descriptors-arm.cc',
            'arm/interface-descriptors-arm.h',
            'arm/macro-assembler-arm.cc',
            'arm/macro-assembler-arm.h',
            'arm/simulator-arm.cc',
            'arm/simulator-arm.h',
            'compiler/arm/code-generator-arm.cc',
            'compiler/arm/instruction-codes-arm.h',
            'compiler/arm/instruction-scheduler-arm.cc',
            'compiler/arm/instruction-selector-arm.cc',
            'crankshaft/arm/lithium-arm.cc',
            'crankshaft/arm/lithium-arm.h',
            'crankshaft/arm/lithium-codegen-arm.cc',
            'crankshaft/arm/lithium-codegen-arm.h',
            'crankshaft/arm/lithium-gap-resolver-arm.cc',
            'crankshaft/arm/lithium-gap-resolver-arm.h',
            'debug/arm/debug-arm.cc',
            'full-codegen/arm/full-codegen-arm.cc',
            'ic/arm/access-compiler-arm.cc',
            'ic/arm/handler-compiler-arm.cc',
            'ic/arm/ic-arm.cc',
            'ic/arm/ic-compiler-arm.cc',
            'ic/arm/stub-cache-arm.cc',
            'regexp/arm/regexp-macro-assembler-arm.cc',
            'regexp/arm/regexp-macro-assembler-arm.h',
          ],
        }],
        ['v8_target_arch=="arm64"', {
          'sources': [  ### gcmole(arch:arm64) ###
            'arm64/assembler-arm64.cc',
            'arm64/assembler-arm64.h',
            'arm64/assembler-arm64-inl.h',
            'arm64/builtins-arm64.cc',
            'arm64/codegen-arm64.cc',
            'arm64/codegen-arm64.h',
            'arm64/code-stubs-arm64.cc',
            'arm64/code-stubs-arm64.h',
            'arm64/constants-arm64.h',
            'arm64/cpu-arm64.cc',
            'arm64/decoder-arm64.cc',
            'arm64/decoder-arm64.h',
            'arm64/decoder-arm64-inl.h',
            'arm64/deoptimizer-arm64.cc',
            'arm64/disasm-arm64.cc',
            'arm64/disasm-arm64.h',
            'arm64/frames-arm64.cc',
            'arm64/frames-arm64.h',
            'arm64/instructions-arm64.cc',
            'arm64/instructions-arm64.h',
            'arm64/instrument-arm64.cc',
            'arm64/instrument-arm64.h',
            'arm64/interface-descriptors-arm64.cc',
            'arm64/interface-descriptors-arm64.h',
            'arm64/macro-assembler-arm64.cc',
            'arm64/macro-assembler-arm64.h',
            'arm64/macro-assembler-arm64-inl.h',
            'arm64/simulator-arm64.cc',
            'arm64/simulator-arm64.h',
            'arm64/utils-arm64.cc',
            'arm64/utils-arm64.h',
            'compiler/arm64/code-generator-arm64.cc',
            'compiler/arm64/instruction-codes-arm64.h',
            'compiler/arm64/instruction-scheduler-arm64.cc',
            'compiler/arm64/instruction-selector-arm64.cc',
            'crankshaft/arm64/delayed-masm-arm64.cc',
            'crankshaft/arm64/delayed-masm-arm64.h',
            'crankshaft/arm64/delayed-masm-arm64-inl.h',
            'crankshaft/arm64/lithium-arm64.cc',
            'crankshaft/arm64/lithium-arm64.h',
            'crankshaft/arm64/lithium-codegen-arm64.cc',
            'crankshaft/arm64/lithium-codegen-arm64.h',
            'crankshaft/arm64/lithium-gap-resolver-arm64.cc',
            'crankshaft/arm64/lithium-gap-resolver-arm64.h',
            'debug/arm64/debug-arm64.cc',
            'full-codegen/arm64/full-codegen-arm64.cc',
            'ic/arm64/access-compiler-arm64.cc',
            'ic/arm64/handler-compiler-arm64.cc',
            'ic/arm64/ic-arm64.cc',
            'ic/arm64/ic-compiler-arm64.cc',
            'ic/arm64/stub-cache-arm64.cc',
            'regexp/arm64/regexp-macro-assembler-arm64.cc',
            'regexp/arm64/regexp-macro-assembler-arm64.h',
          ],
        }],
        ['v8_target_arch=="ia32"', {
          'sources': [  ### gcmole(arch:ia32) ###
            'ia32/assembler-ia32-inl.h',
            'ia32/assembler-ia32.cc',
            'ia32/assembler-ia32.h',
            'ia32/builtins-ia32.cc',
            'ia32/code-stubs-ia32.cc',
            'ia32/code-stubs-ia32.h',
            'ia32/codegen-ia32.cc',
            'ia32/codegen-ia32.h',
            'ia32/cpu-ia32.cc',
            'ia32/deoptimizer-ia32.cc',
            'ia32/disasm-ia32.cc',
            'ia32/frames-ia32.cc',
            'ia32/frames-ia32.h',
            'ia32/interface-descriptors-ia32.cc',
            'ia32/macro-assembler-ia32.cc',
            'ia32/macro-assembler-ia32.h',
            'compiler/ia32/code-generator-ia32.cc',
            'compiler/ia32/instruction-codes-ia32.h',
            'compiler/ia32/instruction-scheduler-ia32.cc',
            'compiler/ia32/instruction-selector-ia32.cc',
            'crankshaft/ia32/lithium-codegen-ia32.cc',
            'crankshaft/ia32/lithium-codegen-ia32.h',
            'crankshaft/ia32/lithium-gap-resolver-ia32.cc',
            'crankshaft/ia32/lithium-gap-resolver-ia32.h',
            'crankshaft/ia32/lithium-ia32.cc',
            'crankshaft/ia32/lithium-ia32.h',
            'debug/ia32/debug-ia32.cc',
            'full-codegen/ia32/full-codegen-ia32.cc',
            'ic/ia32/access-compiler-ia32.cc',
            'ic/ia32/handler-compiler-ia32.cc',
            'ic/ia32/ic-ia32.cc',
            'ic/ia32/ic-compiler-ia32.cc',
            'ic/ia32/stub-cache-ia32.cc',
            'regexp/ia32/regexp-macro-assembler-ia32.cc',
            'regexp/ia32/regexp-macro-assembler-ia32.h',
          ],
        }],
        ['v8_target_arch=="x87"', {
          'sources': [  ### gcmole(arch:x87) ###
            'x87/assembler-x87-inl.h',
            'x87/assembler-x87.cc',
            'x87/assembler-x87.h',
            'x87/builtins-x87.cc',
            'x87/code-stubs-x87.cc',
            'x87/code-stubs-x87.h',
            'x87/codegen-x87.cc',
            'x87/codegen-x87.h',
            'x87/cpu-x87.cc',
            'x87/deoptimizer-x87.cc',
            'x87/disasm-x87.cc',
            'x87/frames-x87.cc',
            'x87/frames-x87.h',
            'x87/interface-descriptors-x87.cc',
            'x87/macro-assembler-x87.cc',
            'x87/macro-assembler-x87.h',
            'compiler/x87/code-generator-x87.cc',
            'compiler/x87/instruction-codes-x87.h',
            'compiler/x87/instruction-scheduler-x87.cc',
            'compiler/x87/instruction-selector-x87.cc',
            'crankshaft/x87/lithium-codegen-x87.cc',
            'crankshaft/x87/lithium-codegen-x87.h',
            'crankshaft/x87/lithium-gap-resolver-x87.cc',
            'crankshaft/x87/lithium-gap-resolver-x87.h',
            'crankshaft/x87/lithium-x87.cc',
            'crankshaft/x87/lithium-x87.h',
            'debug/x87/debug-x87.cc',
            'full-codegen/x87/full-codegen-x87.cc',
            'ic/x87/access-compiler-x87.cc',
            'ic/x87/handler-compiler-x87.cc',
            'ic/x87/ic-x87.cc',
            'ic/x87/ic-compiler-x87.cc',
            'ic/x87/stub-cache-x87.cc',
            'regexp/x87/regexp-macro-assembler-x87.cc',
            'regexp/x87/regexp-macro-assembler-x87.h',
          ],
        }],
        ['v8_target_arch=="mips" or v8_target_arch=="mipsel"', {
          'sources': [  ### gcmole(arch:mipsel) ###
            'mips/assembler-mips.cc',
            'mips/assembler-mips.h',
            'mips/assembler-mips-inl.h',
            'mips/builtins-mips.cc',
            'mips/codegen-mips.cc',
            'mips/codegen-mips.h',
            'mips/code-stubs-mips.cc',
            'mips/code-stubs-mips.h',
            'mips/constants-mips.cc',
            'mips/constants-mips.h',
            'mips/cpu-mips.cc',
            'mips/deoptimizer-mips.cc',
            'mips/disasm-mips.cc',
            'mips/frames-mips.cc',
            'mips/frames-mips.h',
            'mips/interface-descriptors-mips.cc',
            'mips/macro-assembler-mips.cc',
            'mips/macro-assembler-mips.h',
            'mips/simulator-mips.cc',
            'mips/simulator-mips.h',
            'compiler/mips/code-generator-mips.cc',
            'compiler/mips/instruction-codes-mips.h',
            'compiler/mips/instruction-scheduler-mips.cc',
            'compiler/mips/instruction-selector-mips.cc',
            'crankshaft/mips/lithium-codegen-mips.cc',
            'crankshaft/mips/lithium-codegen-mips.h',
            'crankshaft/mips/lithium-gap-resolver-mips.cc',
            'crankshaft/mips/lithium-gap-resolver-mips.h',
            'crankshaft/mips/lithium-mips.cc',
            'crankshaft/mips/lithium-mips.h',
            'full-codegen/mips/full-codegen-mips.cc',
            'debug/mips/debug-mips.cc',
            'ic/mips/access-compiler-mips.cc',
            'ic/mips/handler-compiler-mips.cc',
            'ic/mips/ic-mips.cc',
            'ic/mips/ic-compiler-mips.cc',
            'ic/mips/stub-cache-mips.cc',
            'regexp/mips/regexp-macro-assembler-mips.cc',
            'regexp/mips/regexp-macro-assembler-mips.h',
          ],
        }],
        ['v8_target_arch=="mips64" or v8_target_arch=="mips64el"', {
          'sources': [  ### gcmole(arch:mips64el) ###
            'mips64/assembler-mips64.cc',
            'mips64/assembler-mips64.h',
            'mips64/assembler-mips64-inl.h',
            'mips64/builtins-mips64.cc',
            'mips64/codegen-mips64.cc',
            'mips64/codegen-mips64.h',
            'mips64/code-stubs-mips64.cc',
            'mips64/code-stubs-mips64.h',
            'mips64/constants-mips64.cc',
            'mips64/constants-mips64.h',
            'mips64/cpu-mips64.cc',
            'mips64/deoptimizer-mips64.cc',
            'mips64/disasm-mips64.cc',
            'mips64/frames-mips64.cc',
            'mips64/frames-mips64.h',
            'mips64/interface-descriptors-mips64.cc',
            'mips64/macro-assembler-mips64.cc',
            'mips64/macro-assembler-mips64.h',
            'mips64/simulator-mips64.cc',
            'mips64/simulator-mips64.h',
            'compiler/mips64/code-generator-mips64.cc',
            'compiler/mips64/instruction-codes-mips64.h',
            'compiler/mips64/instruction-scheduler-mips64.cc',
            'compiler/mips64/instruction-selector-mips64.cc',
            'crankshaft/mips64/lithium-codegen-mips64.cc',
            'crankshaft/mips64/lithium-codegen-mips64.h',
            'crankshaft/mips64/lithium-gap-resolver-mips64.cc',
            'crankshaft/mips64/lithium-gap-resolver-mips64.h',
            'crankshaft/mips64/lithium-mips64.cc',
            'crankshaft/mips64/lithium-mips64.h',
            'debug/mips64/debug-mips64.cc',
            'full-codegen/mips64/full-codegen-mips64.cc',
            'ic/mips64/access-compiler-mips64.cc',
            'ic/mips64/handler-compiler-mips64.cc',
            'ic/mips64/ic-mips64.cc',
            'ic/mips64/ic-compiler-mips64.cc',
            'ic/mips64/stub-cache-mips64.cc',
            'regexp/mips64/regexp-macro-assembler-mips64.cc',
            'regexp/mips64/regexp-macro-assembler-mips64.h',
          ],
        }],
        ['v8_target_arch=="x64" or v8_target_arch=="x32"', {
          'sources': [  ### gcmole(arch:x64) ###
            'crankshaft/x64/lithium-codegen-x64.cc',
            'crankshaft/x64/lithium-codegen-x64.h',
            'crankshaft/x64/lithium-gap-resolver-x64.cc',
            'crankshaft/x64/lithium-gap-resolver-x64.h',
            'crankshaft/x64/lithium-x64.cc',
            'crankshaft/x64/lithium-x64.h',
            'x64/assembler-x64-inl.h',
            'x64/assembler-x64.cc',
            'x64/assembler-x64.h',
            'x64/builtins-x64.cc',
            'x64/code-stubs-x64.cc',
            'x64/code-stubs-x64.h',
            'x64/codegen-x64.cc',
            'x64/codegen-x64.h',
            'x64/cpu-x64.cc',
            'x64/deoptimizer-x64.cc',
            'x64/disasm-x64.cc',
            'x64/frames-x64.cc',
            'x64/frames-x64.h',
            'x64/interface-descriptors-x64.cc',
            'x64/macro-assembler-x64.cc',
            'x64/macro-assembler-x64.h',
            'debug/x64/debug-x64.cc',
            'full-codegen/x64/full-codegen-x64.cc',
            'ic/x64/access-compiler-x64.cc',
            'ic/x64/handler-compiler-x64.cc',
            'ic/x64/ic-x64.cc',
            'ic/x64/ic-compiler-x64.cc',
            'ic/x64/stub-cache-x64.cc',
            'regexp/x64/regexp-macro-assembler-x64.cc',
            'regexp/x64/regexp-macro-assembler-x64.h',
          ],
        }],
        ['v8_target_arch=="x64"', {
          'sources': [
            'compiler/x64/code-generator-x64.cc',
            'compiler/x64/instruction-codes-x64.h',
            'compiler/x64/instruction-scheduler-x64.cc',
            'compiler/x64/instruction-selector-x64.cc',
          ],
        }],
        ['v8_target_arch=="ppc" or v8_target_arch=="ppc64"', {
          'sources': [  ### gcmole(arch:ppc) ###
            'compiler/ppc/code-generator-ppc.cc',
            'compiler/ppc/instruction-codes-ppc.h',
            'compiler/ppc/instruction-scheduler-ppc.cc',
            'compiler/ppc/instruction-selector-ppc.cc',
            'crankshaft/ppc/lithium-ppc.cc',
            'crankshaft/ppc/lithium-ppc.h',
            'crankshaft/ppc/lithium-codegen-ppc.cc',
            'crankshaft/ppc/lithium-codegen-ppc.h',
            'crankshaft/ppc/lithium-gap-resolver-ppc.cc',
            'crankshaft/ppc/lithium-gap-resolver-ppc.h',
            'debug/ppc/debug-ppc.cc',
            'full-codegen/ppc/full-codegen-ppc.cc',
            'ic/ppc/access-compiler-ppc.cc',
            'ic/ppc/handler-compiler-ppc.cc',
            'ic/ppc/ic-ppc.cc',
            'ic/ppc/ic-compiler-ppc.cc',
            'ic/ppc/stub-cache-ppc.cc',
            'ppc/assembler-ppc-inl.h',
            'ppc/assembler-ppc.cc',
            'ppc/assembler-ppc.h',
            'ppc/builtins-ppc.cc',
            'ppc/code-stubs-ppc.cc',
            'ppc/code-stubs-ppc.h',
            'ppc/codegen-ppc.cc',
            'ppc/codegen-ppc.h',
            'ppc/constants-ppc.h',
            'ppc/constants-ppc.cc',
            'ppc/cpu-ppc.cc',
            'ppc/deoptimizer-ppc.cc',
            'ppc/disasm-ppc.cc',
            'ppc/frames-ppc.cc',
            'ppc/frames-ppc.h',
            'ppc/interface-descriptors-ppc.cc',
            'ppc/macro-assembler-ppc.cc',
            'ppc/macro-assembler-ppc.h',
            'ppc/simulator-ppc.cc',
            'ppc/simulator-ppc.h',
            'regexp/ppc/regexp-macro-assembler-ppc.cc',
            'regexp/ppc/regexp-macro-assembler-ppc.h',
          ],
        }],
        ['v8_target_arch=="s390" or v8_target_arch=="s390x"', {
          'sources': [  ### gcmole(arch:s390) ###
            'compiler/s390/code-generator-s390.cc',
            'compiler/s390/instruction-codes-s390.h',
            'compiler/s390/instruction-scheduler-s390.cc',
            'compiler/s390/instruction-selector-s390.cc',
            'crankshaft/s390/lithium-codegen-s390.cc',
            'crankshaft/s390/lithium-codegen-s390.h',
            'crankshaft/s390/lithium-gap-resolver-s390.cc',
            'crankshaft/s390/lithium-gap-resolver-s390.h',
            'crankshaft/s390/lithium-s390.cc',
            'crankshaft/s390/lithium-s390.h',
            'debug/s390/debug-s390.cc',
            'full-codegen/s390/full-codegen-s390.cc',
            'ic/s390/access-compiler-s390.cc',
            'ic/s390/handler-compiler-s390.cc',
            'ic/s390/ic-compiler-s390.cc',
            'ic/s390/ic-s390.cc',
            'ic/s390/stub-cache-s390.cc',
            'regexp/s390/regexp-macro-assembler-s390.cc',
            'regexp/s390/regexp-macro-assembler-s390.h',
            's390/assembler-s390.cc',
            's390/assembler-s390.h',
            's390/assembler-s390-inl.h',
            's390/builtins-s390.cc',
            's390/codegen-s390.cc',
            's390/codegen-s390.h',
            's390/code-stubs-s390.cc',
            's390/code-stubs-s390.h',
            's390/constants-s390.cc',
            's390/constants-s390.h',
            's390/cpu-s390.cc',
            's390/deoptimizer-s390.cc',
            's390/disasm-s390.cc',
            's390/frames-s390.cc',
            's390/frames-s390.h',
            's390/interface-descriptors-s390.cc',
            's390/macro-assembler-s390.cc',
            's390/macro-assembler-s390.h',
            's390/simulator-s390.cc',
            's390/simulator-s390.h',
          ],
        }],
        ['OS=="win"', {
          'variables': {
            'gyp_generators': '<!(echo $GYP_GENERATORS)',
          },
          'msvs_disabled_warnings': [4351, 4355, 4800],
          # When building Official, the .lib is too large and exceeds the 2G
          # limit. This breaks it into multiple pieces to avoid the limit.
          # See http://crbug.com/485155.
          'msvs_shard': 4,
        }],
        ['component=="shared_library"', {
          'defines': [
            'BUILDING_V8_SHARED',
            'V8_SHARED',
          ],
        }],
        ['v8_postmortem_support=="true"', {
          'sources': [
            '<(SHARED_INTERMEDIATE_DIR)/debug-support.cc',
          ]
        }],
        ['v8_enable_i18n_support==1', {
          'dependencies': [
            '<(icu_gyp_path):icui18n',
            '<(icu_gyp_path):icuuc',
          ],
          'conditions': [
            ['icu_use_data_file_flag==1', {
              'defines': ['ICU_UTIL_DATA_IMPL=ICU_UTIL_DATA_FILE'],
            }, { # else icu_use_data_file_flag !=1
              'conditions': [
                ['OS=="win"', {
                  'defines': ['ICU_UTIL_DATA_IMPL=ICU_UTIL_DATA_SHARED'],
                }, {
                  'defines': ['ICU_UTIL_DATA_IMPL=ICU_UTIL_DATA_STATIC'],
                }],
              ],
            }],
          ],
        }, {  # v8_enable_i18n_support==0
          'sources!': [
            'i18n.cc',
            'i18n.h',
          ],
        }],
        ['OS=="win" and v8_enable_i18n_support==1', {
          'dependencies': [
            '<(icu_gyp_path):icudata',
          ],
        }],
      ],
    },
    {
      'target_name': 'v8_libbase',
      'type': 'static_library',
      'variables': {
        'optimize': 'max',
      },
      'include_dirs+': [
        '..',
      ],
      'sources': [
        'base/accounting-allocator.cc',
        'base/accounting-allocator.h',
        'base/adapters.h',
        'base/atomic-utils.h',
        'base/atomicops.h',
        'base/atomicops_internals_arm64_gcc.h',
        'base/atomicops_internals_arm_gcc.h',
        'base/atomicops_internals_atomicword_compat.h',
        'base/atomicops_internals_mac.h',
        'base/atomicops_internals_mips_gcc.h',
        'base/atomicops_internals_mips64_gcc.h',
        'base/atomicops_internals_portable.h',
        'base/atomicops_internals_ppc_gcc.h',
        'base/atomicops_internals_s390_gcc.h',
        'base/atomicops_internals_tsan.h',
        'base/atomicops_internals_x86_gcc.cc',
        'base/atomicops_internals_x86_gcc.h',
        'base/atomicops_internals_x86_msvc.h',
        'base/bits.cc',
        'base/bits.h',
        'base/build_config.h',
        'base/compiler-specific.h',
        'base/cpu.cc',
        'base/cpu.h',
        'base/division-by-constant.cc',
        'base/division-by-constant.h',
        'base/flags.h',
        'base/format-macros.h',
        'base/functional.cc',
        'base/functional.h',
        'base/iterator.h',
        'base/lazy-instance.h',
        'base/logging.cc',
        'base/logging.h',
        'base/macros.h',
        'base/once.cc',
        'base/once.h',
        'base/platform/elapsed-timer.h',
        'base/platform/time.cc',
        'base/platform/time.h',
        'base/platform/condition-variable.cc',
        'base/platform/condition-variable.h',
        'base/platform/mutex.cc',
        'base/platform/mutex.h',
        'base/platform/platform.h',
        'base/platform/semaphore.cc',
        'base/platform/semaphore.h',
        'base/safe_conversions.h',
        'base/safe_conversions_impl.h',
        'base/safe_math.h',
        'base/safe_math_impl.h',
        'base/smart-pointers.h',
        'base/sys-info.cc',
        'base/sys-info.h',
        'base/utils/random-number-generator.cc',
        'base/utils/random-number-generator.h',
      ],
      'conditions': [
        ['want_separate_host_toolset==1', {
          'toolsets': ['host', 'target'],
        }, {
          'toolsets': ['target'],
        }],
        ['OS=="linux"', {
            'conditions': [
              ['nacl_target_arch=="none"', {
                'link_settings': {
                  'libraries': [
                    '-ldl',
                    '-lrt'
                  ],
                },
              }, {
                'defines': [
                  'V8_LIBRT_NOT_AVAILABLE=1',
                ],
              }],
            ],
            'sources': [
              'base/platform/platform-linux.cc',
              'base/platform/platform-posix.cc'
            ],
          }
        ],
        ['OS=="android"', {
            'sources': [
              'base/platform/platform-posix.cc'
            ],
            'link_settings': {
              'target_conditions': [
                ['_toolset=="host" and host_os!="mac"', {
                  # Only include libdl and librt on host builds because they
                  # are included by default on Android target builds, and we
                  # don't want to re-include them here since this will change
                  # library order and break (see crbug.com/469973).
                  # These libraries do not exist on Mac hosted builds.
                  'libraries': [
                    '-ldl',
                    '-lrt'
                  ]
                }]
              ]
            },
            'conditions': [
              ['host_os=="mac"', {
                'target_conditions': [
                  ['_toolset=="host"', {
                    'sources': [
                      'base/platform/platform-macos.cc'
                    ]
                  }, {
                    'sources': [
                      'base/platform/platform-linux.cc'
                    ]
                  }],
                ],
              }, {
                'sources': [
                  'base/platform/platform-linux.cc'
                ]
              }],
            ],
          },
        ],
        ['OS=="qnx"', {
            'link_settings': {
              'target_conditions': [
                ['_toolset=="host" and host_os=="linux"', {
                  'libraries': [
                    '-lrt'
                  ],
                }],
                ['_toolset=="target"', {
                  'libraries': [
                    '-lbacktrace'
                  ],
                }],
              ],
            },
            'sources': [
              'base/platform/platform-posix.cc',
              'base/qnx-math.h',
            ],
            'target_conditions': [
              ['_toolset=="host" and host_os=="linux"', {
                'sources': [
                  'base/platform/platform-linux.cc'
                ],
              }],
              ['_toolset=="host" and host_os=="mac"', {
                'sources': [
                  'base/platform/platform-macos.cc'
                ],
              }],
              ['_toolset=="target"', {
                'sources': [
                  'base/platform/platform-qnx.cc'
                ],
              }],
            ],
          },
        ],
        ['OS=="freebsd"', {
            'link_settings': {
              'libraries': [
                '-L/usr/local/lib -lexecinfo',
            ]},
            'sources': [
              'base/platform/platform-freebsd.cc',
              'base/platform/platform-posix.cc'
            ],
          }
        ],
        ['OS=="openbsd"', {
            'link_settings': {
              'libraries': [
                '-L/usr/local/lib -lexecinfo',
            ]},
            'sources': [
              'base/platform/platform-openbsd.cc',
              'base/platform/platform-posix.cc'
            ],
          }
        ],
        ['OS=="netbsd"', {
            'link_settings': {
              'libraries': [
                '-L/usr/pkg/lib -Wl,-R/usr/pkg/lib -lexecinfo',
            ]},
            'sources': [
              'base/platform/platform-openbsd.cc',
              'base/platform/platform-posix.cc'
            ],
          }
        ],
        ['OS=="aix"', {
          'sources': [
            'base/platform/platform-aix.cc',
            'base/platform/platform-posix.cc'
          ]},
        ],
        ['OS=="solaris"', {
            'link_settings': {
              'libraries': [
                '-lnsl -lrt',
            ]},
            'sources': [
              'base/platform/platform-solaris.cc',
              'base/platform/platform-posix.cc'
            ],
          }
        ],
        ['OS=="mac"', {
          'sources': [
            'base/platform/platform-macos.cc',
            'base/platform/platform-posix.cc'
          ]},
        ],
        ['OS=="win"', {
          'defines': [
            '_CRT_RAND_S'  # for rand_s()
          ],
          'variables': {
            'gyp_generators': '<!(echo $GYP_GENERATORS)',
          },
          'conditions': [
            ['gyp_generators=="make"', {
              'variables': {
                'build_env': '<!(uname -o)',
              },
              'conditions': [
                ['build_env=="Cygwin"', {
                  'sources': [
                    'base/platform/platform-cygwin.cc',
                    'base/platform/platform-posix.cc'
                  ],
                }, {
                  'sources': [
                    'base/platform/platform-win32.cc',
                    'base/win32-headers.h',
                  ],
                }],
              ],
              'link_settings':  {
                'libraries': [ '-lwinmm', '-lws2_32' ],
              },
            }, {
              'sources': [
                'base/platform/platform-win32.cc',
                'base/win32-headers.h',
              ],
              'msvs_disabled_warnings': [4351, 4355, 4800],
              'link_settings':  {
                'libraries': [ '-lwinmm.lib', '-lws2_32.lib' ],
              },
            }],
          ],
        }],
      ],
    },
    {
      'target_name': 'v8_libplatform',
      'type': 'static_library',
      'variables': {
        'optimize': 'max',
      },
      'dependencies': [
        'v8_libbase',
      ],
      'include_dirs+': [
        '..',
        '../include',
      ],
      'sources': [
        '../include/libplatform/libplatform.h',
        'libplatform/default-platform.cc',
        'libplatform/default-platform.h',
        'libplatform/task-queue.cc',
        'libplatform/task-queue.h',
        'libplatform/worker-thread.cc',
        'libplatform/worker-thread.h',
      ],
      'conditions': [
        ['want_separate_host_toolset==1', {
          'toolsets': ['host', 'target'],
        }, {
          'toolsets': ['target'],
        }],
      ],
      'direct_dependent_settings': {
        'include_dirs': [
          '../include',
        ],
      },
    },
    {
      'target_name': 'natives_blob',
      'type': 'none',
      'conditions': [
        [ 'v8_use_external_startup_data==1', {
          'conditions': [
            ['want_separate_host_toolset==1', {
              'dependencies': ['js2c#host'],
            }, {
              'dependencies': ['js2c'],
            }],
          ],
          'actions': [{
            'action_name': 'concatenate_natives_blob',
            'inputs': [
              '../tools/concatenate-files.py',
              '<(SHARED_INTERMEDIATE_DIR)/libraries.bin',
              '<(SHARED_INTERMEDIATE_DIR)/libraries-experimental.bin',
              '<(SHARED_INTERMEDIATE_DIR)/libraries-extras.bin',
              '<(SHARED_INTERMEDIATE_DIR)/libraries-experimental-extras.bin',
            ],
            'conditions': [
              ['want_separate_host_toolset==1', {
                'target_conditions': [
                  ['_toolset=="host"', {
                    'outputs': [
                      '<(PRODUCT_DIR)/natives_blob_host.bin',
                    ],
                    'action': [
                      'python', '<@(_inputs)', '<(PRODUCT_DIR)/natives_blob_host.bin'
                    ],
                  }, {
                    'outputs': [
                      '<(PRODUCT_DIR)/natives_blob.bin',
                    ],
                    'action': [
                      'python', '<@(_inputs)', '<(PRODUCT_DIR)/natives_blob.bin'
                    ],
                  }],
                ],
              }, {
                'outputs': [
                  '<(PRODUCT_DIR)/natives_blob.bin',
                ],
                'action': [
                  'python', '<@(_inputs)', '<(PRODUCT_DIR)/natives_blob.bin'
                ],
              }],
            ],
          }],
        }],
        ['want_separate_host_toolset==1', {
          'toolsets': ['host', 'target'],
        }, {
          'toolsets': ['target'],
        }],
      ]
    },
    {
      'target_name': 'js2c',
      'type': 'none',
      'conditions': [
        ['want_separate_host_toolset==1', {
          'toolsets': ['host'],
        }, {
          'toolsets': ['target'],
        }],
      ],
      'variables': {
        'library_files': [
          'js/macros.py',
          'messages.h',
          'js/prologue.js',
          'js/runtime.js',
          'js/v8natives.js',
          'js/symbol.js',
          'js/array.js',
          'js/string.js',
          'js/uri.js',
          'js/math.js',
          'third_party/fdlibm/fdlibm.js',
          'js/regexp.js',
          'js/arraybuffer.js',
          'js/typedarray.js',
          'js/iterator-prototype.js',
          'js/collection.js',
          'js/weak-collection.js',
          'js/collection-iterator.js',
          'js/promise.js',
          'js/messages.js',
          'js/json.js',
          'js/array-iterator.js',
          'js/string-iterator.js',
          'js/templates.js',
          'js/spread.js',
          'js/proxy.js',
          'debug/mirrors.js',
          'debug/debug.js',
          'debug/liveedit.js',
        ],
        'experimental_library_files': [
          'js/macros.py',
          'messages.h',
          'js/harmony-atomics.js',
          'js/harmony-regexp-exec.js',
          'js/harmony-sharedarraybuffer.js',
          'js/harmony-simd.js',
          'js/harmony-species.js',
          'js/harmony-unicode-regexps.js',
          'js/harmony-string-padding.js',
          'js/promise-extra.js',
          'js/harmony-async-await.js'
        ],
        'libraries_bin_file': '<(SHARED_INTERMEDIATE_DIR)/libraries.bin',
        'libraries_experimental_bin_file': '<(SHARED_INTERMEDIATE_DIR)/libraries-experimental.bin',
        'libraries_extras_bin_file': '<(SHARED_INTERMEDIATE_DIR)/libraries-extras.bin',
        'libraries_experimental_extras_bin_file': '<(SHARED_INTERMEDIATE_DIR)/libraries-experimental-extras.bin',
        'conditions': [
          ['v8_enable_i18n_support==1', {
            'library_files': ['js/i18n.js'],
            'experimental_library_files': [
              'js/icu-case-mapping.js',
              'js/intl-extra.js',
             ],
          }],
        ],
      },
      'actions': [
        {
          'action_name': 'js2c',
          'inputs': [
            '../tools/js2c.py',
            '<@(library_files)',
          ],
          'outputs': ['<(SHARED_INTERMEDIATE_DIR)/libraries.cc'],
          'action': [
            'python',
            '../tools/js2c.py',
            '<(SHARED_INTERMEDIATE_DIR)/libraries.cc',
            'CORE',
            '<@(library_files)',
          ],
        },
        {
          'action_name': 'js2c_bin',
          'inputs': [
            '../tools/js2c.py',
            '<@(library_files)',
          ],
          'outputs': ['<@(libraries_bin_file)'],
          'action': [
            'python',
            '../tools/js2c.py',
            '<(SHARED_INTERMEDIATE_DIR)/libraries.cc',
            'CORE',
            '<@(library_files)',
            '--startup_blob', '<@(libraries_bin_file)',
            '--nojs',
          ],
        },
        {
          'action_name': 'js2c_experimental',
          'inputs': [
            '../tools/js2c.py',
            '<@(experimental_library_files)',
          ],
          'outputs': ['<(SHARED_INTERMEDIATE_DIR)/experimental-libraries.cc'],
          'action': [
            'python',
            '../tools/js2c.py',
            '<(SHARED_INTERMEDIATE_DIR)/experimental-libraries.cc',
            'EXPERIMENTAL',
            '<@(experimental_library_files)',
          ],
        },
        {
          'action_name': 'js2c_experimental_bin',
          'inputs': [
            '../tools/js2c.py',
            '<@(experimental_library_files)',
          ],
          'outputs': ['<@(libraries_experimental_bin_file)'],
          'action': [
            'python',
            '../tools/js2c.py',
            '<(SHARED_INTERMEDIATE_DIR)/experimental-libraries.cc',
            'EXPERIMENTAL',
            '<@(experimental_library_files)',
            '--startup_blob', '<@(libraries_experimental_bin_file)',
            '--nojs',
          ],
        },
        {
          'action_name': 'js2c_extras',
          'inputs': [
            '../tools/js2c.py',
            '<@(v8_extra_library_files)',
          ],
          'outputs': ['<(SHARED_INTERMEDIATE_DIR)/extras-libraries.cc'],
          'action': [
            'python',
            '../tools/js2c.py',
            '<(SHARED_INTERMEDIATE_DIR)/extras-libraries.cc',
            'EXTRAS',
            '<@(v8_extra_library_files)',
          ],
        },
        {
          'action_name': 'js2c_extras_bin',
          'inputs': [
            '../tools/js2c.py',
            '<@(v8_extra_library_files)',
          ],
          'outputs': ['<@(libraries_extras_bin_file)'],
          'action': [
            'python',
            '../tools/js2c.py',
            '<(SHARED_INTERMEDIATE_DIR)/extras-libraries.cc',
            'EXTRAS',
            '<@(v8_extra_library_files)',
            '--startup_blob', '<@(libraries_extras_bin_file)',
            '--nojs',
          ],
        },
        {
          'action_name': 'js2c_experimental_extras',
          'inputs': [
            '../tools/js2c.py',
            '<@(v8_experimental_extra_library_files)',
          ],
          'outputs': [
            '<(SHARED_INTERMEDIATE_DIR)/experimental-extras-libraries.cc',
          ],
          'action': [
            'python',
            '../tools/js2c.py',
            '<(SHARED_INTERMEDIATE_DIR)/experimental-extras-libraries.cc',
            'EXPERIMENTAL_EXTRAS',
            '<@(v8_experimental_extra_library_files)',
          ],
        },
        {
          'action_name': 'js2c_experimental_extras_bin',
          'inputs': [
            '../tools/js2c.py',
            '<@(v8_experimental_extra_library_files)',
          ],
          'outputs': ['<@(libraries_experimental_extras_bin_file)'],
          'action': [
            'python',
            '../tools/js2c.py',
            '<(SHARED_INTERMEDIATE_DIR)/experimental-extras-libraries.cc',
            'EXPERIMENTAL_EXTRAS',
            '<@(v8_experimental_extra_library_files)',
            '--startup_blob', '<@(libraries_experimental_extras_bin_file)',
            '--nojs',
          ],
        },
      ],
    },
    {
      'target_name': 'postmortem-metadata',
      'type': 'none',
      'variables': {
        'heapobject_files': [
            'objects.h',
            'objects-inl.h',
        ],
      },
      'actions': [
          {
            'action_name': 'gen-postmortem-metadata',
            'inputs': [
              '../tools/gen-postmortem-metadata.py',
              '<@(heapobject_files)',
            ],
            'outputs': [
              '<(SHARED_INTERMEDIATE_DIR)/debug-support.cc',
            ],
            'action': [
              'python',
              '../tools/gen-postmortem-metadata.py',
              '<@(_outputs)',
              '<@(heapobject_files)'
            ]
          }
        ]
    },
    {
      'target_name': 'mksnapshot',
      'type': 'executable',
      'dependencies': ['v8_base', 'v8_nosnapshot', 'v8_libplatform'],
      'include_dirs+': [
        '..',
      ],
      'sources': [
        'snapshot/mksnapshot.cc',
      ],
      'conditions': [
        ['v8_enable_i18n_support==1', {
          'dependencies': [
            '<(icu_gyp_path):icui18n',
            '<(icu_gyp_path):icuuc',
          ]
        }],
        ['want_separate_host_toolset==1', {
          'toolsets': ['host'],
        }, {
          'toolsets': ['target'],
        }],
      ],
    },
  ],
}
