# Copyright 2012 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.
{
  'variables': {
    'chrome_unit_tests_sources': [
      # histograms.xml is analyzed by AboutFlagsHistogramTest, so this
      # dependency is needed to make commit bots run unit_tests on
      # histograms.xml changes.
      '../tools/metrics/histograms/histograms.xml',
      # All unittests in browser, common, renderer and service.
      'browser/about_flags_unittest.cc',
      'browser/after_startup_task_utils_unittest.cc',
      'browser/android/bookmarks/partner_bookmarks_shim_unittest.cc',
      'browser/android/compositor/layer/tab_layer_unittest.cc',
      'browser/android/contextualsearch/contextual_search_delegate_unittest.cc',
      'browser/android/contextualsearch/contextual_search_field_trial_unittest.cc',
      'browser/android/data_usage/data_use_matcher_unittest.cc',
      'browser/android/data_usage/data_use_tab_model_unittest.cc',
      'browser/android/data_usage/data_use_ui_tab_model_unittest.cc',
      'browser/android/data_usage/external_data_use_observer_unittest.cc',
      'browser/android/data_usage/external_data_use_reporter_unittest.cc',
      'browser/android/data_usage/tab_data_use_entry_unittest.cc',
      'browser/android/download/download_manager_service_unittest.cc',
      'browser/android/history_report/delta_file_backend_leveldb_unittest.cc',
      'browser/android/history_report/delta_file_commons_unittest.cc',
      'browser/android/history_report/usage_reports_buffer_backend_unittest.cc',
      # TODO(newt): move this to test_support_unit?
      'browser/android/mock_location_settings.cc',
      'browser/android/mock_location_settings.h',
      'browser/android/net/external_estimate_provider_android_unittest.cc',
      'browser/android/preferences/important_sites_util_unittest.cc',
      'browser/android/preferences/pref_service_bridge_unittest.cc',
      'browser/android/shortcut_info_unittest.cc',
      'browser/android/thumbnail/scoped_ptr_expiring_cache_unittest.cc',
      'browser/android/webapk/webapk_icon_hasher_unittest.cc',
      'browser/android/webapk/webapk_installer_unittest.cc',
      'browser/app_controller_mac_unittest.mm',
      'browser/autocomplete/search_provider_unittest.cc',
      'browser/autocomplete/shortcuts_provider_extension_unittest.cc',
      'browser/background_sync/background_sync_controller_impl_unittest.cc',
      'browser/background_sync/background_sync_permission_context_unittest.cc',
      'browser/banners/app_banner_settings_helper_unittest.cc',
      'browser/bitmap_fetcher/bitmap_fetcher_service_unittest.cc',
      'browser/bookmarks/managed_bookmark_service_unittest.cc',
      'browser/browser_about_handler_unittest.cc',
      'browser/browser_process_impl_unittest.cc',
      'browser/browsing_data/browsing_data_appcache_helper_unittest.cc',
      'browser/browsing_data/browsing_data_cache_storage_helper_unittest.cc',
      'browser/browsing_data/browsing_data_channel_id_helper_unittest.cc',
      'browser/browsing_data/browsing_data_cookie_helper_unittest.cc',
      'browser/browsing_data/browsing_data_counter_utils_unittest.cc',
      'browser/browsing_data/browsing_data_database_helper_unittest.cc',
      'browser/browsing_data/browsing_data_file_system_helper_unittest.cc',
      'browser/browsing_data/browsing_data_helper_unittest.cc',
      'browser/browsing_data/browsing_data_indexed_db_helper_unittest.cc',
      'browser/browsing_data/browsing_data_local_storage_helper_unittest.cc',
      'browser/browsing_data/browsing_data_quota_helper_unittest.cc',
      'browser/browsing_data/browsing_data_remover_test_util.cc',
      'browser/browsing_data/browsing_data_remover_test_util.h',
      'browser/browsing_data/browsing_data_remover_unittest.cc',
      'browser/browsing_data/browsing_data_service_worker_helper_unittest.cc',
      'browser/browsing_data/cookies_tree_model_unittest.cc',
      'browser/browsing_data/origin_filter_builder_unittest.cc',
      'browser/browsing_data/registrable_domain_filter_builder_unittest.cc',
      'browser/browsing_data/site_data_size_collector_unittest.cc',
      'browser/budget_service/budget_manager_unittest.cc',
      'browser/budget_service/budget_database_unittest.cc',
      'browser/chrome_browser_application_mac_unittest.mm',
      'browser/chrome_content_browser_client_unittest.cc',
      'browser/chrome_process_singleton_win_unittest.cc',
      'browser/command_updater_unittest.cc',
      'browser/component_updater/chrome_component_updater_configurator_unittest.cc',
      'browser/component_updater/sth_set_component_installer_unittest.cc',
      'browser/component_updater/sw_reporter_installer_win_unittest.cc',
      'browser/component_updater/subresource_filter_component_installer_unittest.cc',
      'browser/component_updater/supervised_user_whitelist_installer_unittest.cc',
      'browser/content_settings/content_settings_default_provider_unittest.cc',
      'browser/content_settings/content_settings_mock_observer.cc',
      'browser/content_settings/content_settings_mock_observer.h',
      'browser/content_settings/content_settings_origin_identifier_value_map_unittest.cc',
      'browser/content_settings/content_settings_policy_provider_unittest.cc',
      'browser/content_settings/content_settings_pref_provider_unittest.cc',
      'browser/content_settings/content_settings_usages_state_unittest.cc',
      'browser/content_settings/cookie_settings_factory_unittest.cc',
      'browser/content_settings/host_content_settings_map_unittest.cc',
      'browser/content_settings/mock_settings_observer.cc',
      'browser/content_settings/mock_settings_observer.h',
      'browser/content_settings/tab_specific_content_settings_unittest.cc',
      'browser/custom_handlers/protocol_handler_registry_unittest.cc',
      'browser/data_usage/tab_id_annotator_unittest.cc',
      'browser/data_usage/tab_id_provider_unittest.cc',
      'browser/devtools/devtools_network_controller_unittest.cc',
      'browser/download/all_download_item_notifier_unittest.cc',
      'browser/download/chrome_download_manager_delegate_unittest.cc',
      'browser/download/download_history_unittest.cc',
      'browser/download/download_item_model_unittest.cc',
      'browser/download/download_path_reservation_tracker_unittest.cc',
      'browser/download/download_prefs_unittest.cc',
      'browser/download/download_query_unittest.cc',
      'browser/download/download_request_infobar_delegate_unittest.cc',
      'browser/download/download_request_limiter_unittest.cc',
      'browser/download/download_resource_throttle_unittest.cc',
      'browser/download/download_status_updater_unittest.cc',
      'browser/download/download_target_determiner_unittest.cc',
      'browser/download/download_ui_controller_unittest.cc',
      'browser/engagement/site_engagement_eviction_policy_unittest.cc',
      'browser/engagement/site_engagement_helper_unittest.cc',
      'browser/engagement/site_engagement_score_unittest.cc',
      'browser/engagement/site_engagement_service_unittest.cc',
      'browser/external_protocol/external_protocol_handler_unittest.cc',
      'browser/favicon/chrome_fallback_icon_client_unittest.cc',
      'browser/file_select_helper_unittest.cc',
      'browser/geolocation/geolocation_permission_context_unittest.cc',
      'browser/global_keyboard_shortcuts_mac_unittest.mm',
      'browser/google/google_update_settings_unittest.cc',
      'browser/google/google_update_win_unittest.cc',
      'browser/history/android/android_cache_database_unittest.cc',
      'browser/history/android/android_history_provider_service_unittest.cc',
      'browser/history/android/android_provider_backend_unittest.cc',
      'browser/history/android/android_urls_database_unittest.cc',
      'browser/history/android/bookmark_model_sql_handler_unittest.cc',
      'browser/history/android/sqlite_cursor_unittest.cc',
      'browser/history/android/urls_sql_handler_unittest.cc',
      'browser/history/android/visit_sql_handler_unittest.cc',
      'browser/image_holder_unittest.cc',
      'browser/install_verification/win/loaded_module_verification_unittest.cc',
      'browser/install_verification/win/module_ids_unittest.cc',
      'browser/install_verification/win/module_info_unittest.cc',
      'browser/install_verification/win/module_list_unittest.cc',
      'browser/install_verification/win/module_verification_test.cc',
      'browser/install_verification/win/module_verification_test.h',
      'browser/installable/installable_manager_unittest.cc',
      'browser/internal_auth_unittest.cc',
      'browser/io_thread_unittest.cc',
      'browser/logging_chrome_unittest.cc',
      'browser/mac/keystone_glue_unittest.mm',
      'browser/manifest/manifest_icon_downloader_unittest.cc',
      'browser/manifest/manifest_icon_selector_unittest.cc',
      'browser/media/media_stream_device_permission_context_unittest.cc',
      'browser/media/midi_permission_context_unittest.cc',
      'browser/metrics/antivirus_metrics_provider_win_unittest.cc',
      'browser/metrics/chrome_browser_main_extra_parts_metrics_unittest.cc',
      'browser/metrics/chrome_metrics_service_accessor_unittest.cc',
      'browser/metrics/perf/perf_provider_chromeos_unittest.cc',
      'browser/metrics/subprocess_metrics_provider_unittest.cc',
      'browser/metrics/thread_watcher_android_unittest.cc',
      'browser/metrics/thread_watcher_unittest.cc',
      'browser/metrics/time_ticks_experiment_unittest.cc',
      'browser/mod_pagespeed/mod_pagespeed_metrics_unittest.cc',
      'browser/net/chrome_network_delegate_unittest.cc',
      'browser/net/dns_probe_runner_unittest.cc',
      'browser/net/dns_probe_service_unittest.cc',
      'browser/net/file_downloader_unittest.cc',
      'browser/net/net_error_tab_helper_unittest.cc',
      'browser/net/predictor_unittest.cc',
      'browser/net/probe_message_unittest.cc',
      'browser/net/quota_policy_channel_id_store_unittest.cc',
      'browser/net/safe_search_util_unittest.cc',
      'browser/net/spdyproxy/chrome_data_use_group_provider_unittest.cc',
      'browser/net/spdyproxy/chrome_data_use_group_unittest.cc',
      'browser/net/spdyproxy/data_reduction_proxy_chrome_settings_unittest.cc',
      'browser/net/spdyproxy/data_reduction_proxy_settings_unittest_android.cc',
      'browser/net/url_info_unittest.cc',
      'browser/page_load_metrics/metrics_web_contents_observer_unittest.cc',
      'browser/page_load_metrics/observers/aborts_page_load_metrics_observer_unittest.cc',
      'browser/page_load_metrics/observers/core_page_load_metrics_observer_unittest.cc',
      'browser/page_load_metrics/observers/data_reduction_proxy_metrics_observer_unittest.cc',
      'browser/page_load_metrics/observers/document_write_page_load_metrics_observer_unittest.cc',
      'browser/page_load_metrics/observers/from_gws_page_load_metrics_observer_unittest.cc',
      'browser/page_load_metrics/observers/google_captcha_observer_unittest.cc',
      'browser/page_load_metrics/observers/page_load_metrics_observer_test_harness.cc',
      'browser/page_load_metrics/observers/page_load_metrics_observer_test_harness.h',
      'browser/page_load_metrics/observers/previews_page_load_metrics_observer_unittest.cc',
      'browser/page_load_metrics/observers/service_worker_page_load_metrics_observer_unittest.cc',
      'browser/password_manager/chrome_password_manager_client_unittest.cc',
      'browser/password_manager/password_manager_internals_service_unittest.cc',
      'browser/password_manager/password_store_mac_unittest.cc',
      'browser/password_manager/password_store_proxy_mac_unittest.cc',
      'browser/password_manager/password_store_win_unittest.cc',
      'browser/password_manager/password_store_x_unittest.cc',
      'browser/password_manager/simple_password_store_mac_unittest.cc',
      'browser/permissions/chooser_context_base_unittest.cc',
      'browser/permissions/delegation_tracker_unittest.cc',
      'browser/permissions/permission_context_base_unittest.cc',
      'browser/permissions/permission_decision_auto_blocker_unittest.cc',
      'browser/permissions/permission_manager_unittest.cc',
      'browser/permissions/permission_uma_util_unittest.cc',
      'browser/permissions/permission_util_unittest.cc',
      'browser/policy/cloud/cloud_policy_invalidator_unittest.cc',
      'browser/policy/cloud/remote_commands_invalidator_unittest.cc',
      'browser/policy/cloud/user_policy_signin_service_unittest.cc',
      'browser/policy/file_selection_dialogs_policy_handler_unittest.cc',
      'browser/policy/javascript_policy_handler_unittest.cc',
      'browser/policy/managed_bookmarks_policy_handler_unittest.cc',
      'browser/policy/policy_path_parser_unittest.cc',
      'browser/policy/profile_policy_connector_unittest.cc',
      'browser/predictors/autocomplete_action_predictor_table_unittest.cc',
      'browser/predictors/autocomplete_action_predictor_unittest.cc',
      'browser/predictors/resource_prefetch_common_unittest.cc',
      'browser/predictors/resource_prefetch_predictor_tables_unittest.cc',
      'browser/predictors/resource_prefetch_predictor_unittest.cc',
      'browser/predictors/resource_prefetcher_unittest.cc',
      'browser/prefs/chrome_pref_service_unittest.cc',
      'browser/prefs/command_line_pref_store_proxy_unittest.cc',
      'browser/prefs/command_line_pref_store_ssl_manager_unittest.cc',
      'browser/prefs/command_line_pref_store_unittest.cc',
      'browser/prefs/incognito_mode_prefs_unittest.cc',
      'browser/prefs/profile_pref_store_manager_unittest.cc',
      'browser/prefs/proxy_policy_unittest.cc',
      'browser/prefs/session_startup_pref_unittest.cc',
      'browser/prerender/prerender_history_unittest.cc',
      'browser/prerender/prerender_resource_throttle_unittest.cc',
      'browser/prerender/prerender_unittest.cc',
      'browser/prerender/prerender_util_unittest.cc',
      'browser/process_singleton_win_unittest.cc',
      'browser/profiles/gaia_info_update_service_unittest.cc',
      'browser/profiles/incognito_mode_policy_handler_unittest.cc',
      'browser/profiles/profile_attributes_storage_unittest.cc',
      'browser/profiles/profile_avatar_icon_util_unittest.cc',
      'browser/profiles/profile_downloader_unittest.cc',
      'browser/profiles/profile_info_cache_unittest.cc',
      'browser/profiles/profile_info_cache_unittest.h',
      'browser/profiles/profile_manager_unittest.cc',
      'browser/profiles/profile_shortcut_manager_unittest_win.cc',
      'browser/push_messaging/push_messaging_app_identifier_unittest.cc',
      'browser/push_messaging/push_messaging_notification_manager_unittest.cc',
      'browser/push_messaging/push_messaging_service_unittest.cc',
      'browser/renderer_host/chrome_navigation_data_unittest.cc',
      'browser/renderer_host/chrome_render_widget_host_view_mac_history_swiper_unit_test.mm',
      'browser/renderer_host/chrome_resource_dispatcher_host_delegate_unittest.cc',
      'browser/resources_util_unittest.cc',
      'browser/search/contextual_search_policy_handler_android_unittest.cc',
      'browser/search/iframe_source_unittest.cc',
      'browser/search/thumbnail_source_unittest.cc',

      # TODO(hashimoto): those tests should be componentized and moved to
      # //components:components_unittests, http://crbug.com/527882.
      'browser/search_engines/template_url_fetcher_unittest.cc',
      'browser/search_engines/template_url_parser_unittest.cc',
      'browser/search_engines/template_url_service_sync_unittest.cc',
      'browser/search_engines/template_url_service_unittest.cc',

      'browser/service_process/service_process_control_mac_unittest.mm',
      'browser/services/gcm/fake_gcm_profile_service.cc',
      'browser/services/gcm/fake_gcm_profile_service.h',
      'browser/sessions/restore_on_startup_policy_handler_unittest.cc',
      'browser/shell_integration_win_unittest.cc',
      'browser/signin/account_reconcilor_unittest.cc',
      'browser/signin/chrome_signin_client_unittest.cc',
      'browser/signin/chrome_signin_status_metrics_provider_delegate_unittest.cc',
      'browser/signin/local_auth_unittest.cc',
      'browser/signin/signin_manager_unittest.cc',
      'browser/signin/signin_status_metrics_provider_chromeos_unittest.cc',
      'browser/signin/signin_tracker_unittest.cc',
      'browser/signin/test_signin_client_builder.cc',
      'browser/ssl/chrome_expect_ct_reporter_unittest.cc',
      'browser/ssl/ssl_error_handler_unittest.cc',
      'browser/status_icons/status_icon_menu_model_unittest.cc',
      'browser/status_icons/status_icon_unittest.cc',
      'browser/status_icons/status_tray_unittest.cc',
      'browser/storage/durable_storage_permission_context_unittest.cc',
      'browser/sync/profile_sync_service_factory_unittest.cc',
      'browser/sync/sync_startup_tracker_unittest.cc',
      'browser/task_profiler/task_profiler_data_serializer_unittest.cc',
      'browser/thumbnails/content_analysis_unittest.cc',
      'browser/thumbnails/content_based_thumbnailing_algorithm_unittest.cc',
      'browser/thumbnails/simple_thumbnail_crop_unittest.cc',
      'browser/thumbnails/thumbnail_service_unittest.cc',
      'browser/translate/translate_service_unittest.cc',
      'browser/ui/android/tab_model/tab_model_list_unittest.cc',
      'browser/ui/android/tab_model/tab_model_unittest.cc',
      'browser/ui/autofill/autofill_dialog_models_unittest.cc',
      'browser/ui/autofill/autofill_popup_layout_model_unittest.cc',
      'browser/ui/autofill/popup_view_common_unittest.cc',
      'browser/ui/bookmarks/bookmark_editor_unittest.cc',
      'browser/ui/bookmarks/bookmark_ui_utils_desktop_unittest.cc',
      'browser/ui/bookmarks/recently_used_folders_combo_model_unittest.cc',
      'browser/ui/chrome_select_file_policy_unittest.cc',
      'browser/ui/find_bar/find_backend_unittest.cc',
      'browser/ui/login/login_handler_unittest.cc',
      'browser/ui/passwords/manage_passwords_state_unittest.cc',
      'browser/ui/passwords/manage_passwords_view_utils_unittest.cc',
      'browser/ui/passwords/password_manager_presenter_unittest.cc',
      'browser/ui/search_engines/keyword_editor_controller_unittest.cc',
      'browser/ui/sync/profile_signin_confirmation_helper_unittest.cc',
      'browser/ui/sync/sync_promo_ui_unittest.cc',
      'browser/ui/tests/ui_gfx_image_unittest.cc',
      'browser/ui/tests/ui_gfx_image_unittest.mm',
      'browser/ui/website_settings/mock_permission_prompt.cc',
      'browser/ui/website_settings/mock_permission_prompt.h',
      'browser/ui/website_settings/mock_permission_prompt_factory.cc',
      'browser/ui/website_settings/mock_permission_prompt_factory.h',
      'browser/ui/website_settings/website_settings_unittest.cc',
      'browser/ui/webui/browsing_history_handler_unittest.cc',
      'browser/ui/webui/fileicon_source_unittest.cc',
      'browser/ui/webui/local_state/local_state_ui_unittest.cc',
      'browser/ui/webui/log_web_ui_url_unittest.cc',
      'browser/update_client/chrome_update_query_params_delegate_unittest.cc',
      'browser/win/chrome_elf_init_unittest.cc',
      'browser/win/enumerate_modules_model_unittest.cc',
      'browser/win/private_working_set_snapshot_unittest.cc',
      'common/chrome_content_client_unittest.cc',
      'common/chrome_paths_unittest.cc',
      'common/component_flash_hint_file_linux_unittest.cc',
      'common/crash_keys_unittest.cc',
      'common/ini_parser_unittest.cc',
      'common/mac/cfbundle_blocker_unittest.mm',
      'common/mac/mock_launchd.cc',
      'common/mac/mock_launchd.h',
      'common/origin_trials/chrome_origin_trial_policy_unittest.cc',
      'common/partial_circular_buffer_unittest.cc',
      'common/pref_names_util_unittest.cc',
      'common/search/instant_types_unittest.cc',
      'common/search/search_urls_unittest.cc',
      'common/secure_origin_whitelist_unittest.cc',
      'common/switch_utils_unittest.cc',
      'common/variations/variations_util_unittest.cc',
      'common/variations/child_process_field_trial_syncer_unittest.cc',
      'renderer/app_categorizer_unittest.cc',
      'renderer/chrome_content_renderer_client_unittest.cc',
      'renderer/content_settings_observer_unittest.cc',
      'renderer/instant_restricted_id_cache_unittest.cc',
      'renderer/page_load_metrics/fake_page_timing_metrics_ipc_sender.cc',
      'renderer/page_load_metrics/fake_page_timing_metrics_ipc_sender.h',
      'renderer/page_load_metrics/metrics_render_frame_observer_unittest.cc',
      'renderer/page_load_metrics/page_timing_metrics_sender_unittest.cc',
      'renderer/plugins/plugin_uma_unittest.cc',
      'renderer/prerender/prerender_dispatcher_unittest.cc',
      'renderer/searchbox/search_bouncer_unittest.cc',
      'renderer/searchbox/searchbox_extension_unittest.cc',
      'renderer/searchbox/searchbox_unittest.cc',
      'renderer/web_apps_unittest.cc',
      'test/base/chrome_render_view_test.cc',
      'test/base/chrome_render_view_test.h',
      'test/base/menu_model_test.cc',
      'test/base/menu_model_test.h',
      'test/base/v8_unit_test.cc',
      'test/base/v8_unit_test.h',
      'test/logging/win/mof_data_parser_unittest.cc',
      'utility/image_decoder_impl_unittest.cc',

      # Duplicate these tests here because PathService has more items in
      # unit_tests than in base_unittests.
      '../base/path_service_unittest.cc',

      '../testing/gtest_mac_unittest.mm',
      '../third_party/zlib/google/compression_utils_unittest.cc',
      '../third_party/zlib/google/zip_reader_unittest.cc',
      '../third_party/zlib/google/zip_unittest.cc',
      '../tools/json_schema_compiler/test/additional_properties_unittest.cc',
      '../tools/json_schema_compiler/test/any_unittest.cc',
      '../tools/json_schema_compiler/test/arrays_unittest.cc',
      '../tools/json_schema_compiler/test/callbacks_unittest.cc',
      '../tools/json_schema_compiler/test/choices_unittest.cc',
      '../tools/json_schema_compiler/test/crossref_unittest.cc',
      '../tools/json_schema_compiler/test/enums_unittest.cc',
      '../tools/json_schema_compiler/test/error_generation_unittest.cc',
      '../tools/json_schema_compiler/test/functions_as_parameters_unittest.cc',
      '../tools/json_schema_compiler/test/functions_on_types_unittest.cc',
      '../tools/json_schema_compiler/test/idl_schemas_unittest.cc',
      '../tools/json_schema_compiler/test/objects_unittest.cc',
      '../tools/json_schema_compiler/test/simple_api_unittest.cc',
    ],
    'chrome_unit_tests_android_sources': [
      'browser/autofill/autofill_credit_card_filling_infobar_delegate_mobile_unittest.cc',
      'browser/autofill/autofill_save_card_infobar_delegate_mobile_unittest.cc',
      'browser/password_manager/account_chooser_dialog_android_unittest.cc',
      'browser/password_manager/auto_signin_first_run_dialog_android_unittest.cc',
      'browser/password_manager/save_password_infobar_delegate_android_unittest.cc',
      'browser/permissions/permission_queue_controller_unittest.cc',
    ],
    'chrome_unit_tests_non_mobile_sources': [
      'browser/download/download_dir_policy_handler_unittest.cc',
      'browser/lifetime/keep_alive_registry_unittest.cc',
      'browser/renderer_context_menu/render_view_context_menu_test_util.cc',
      'browser/renderer_context_menu/render_view_context_menu_test_util.h',
      'browser/ui/autofill/country_combobox_model_unittest.cc',
      'browser/ui/autofill/save_card_bubble_controller_impl_unittest.cc',
      'browser/ui/passwords/manage_passwords_ui_controller_unittest.cc',
    ],
    'chrome_unit_tests_spellchecker_sources': [
      'browser/spellchecker/spellcheck_custom_dictionary_unittest.cc',
      'browser/spellchecker/spellcheck_message_filter_platform_mac_unittest.cc',
      'browser/spellchecker/spellcheck_message_filter_unittest.cc',
      'browser/spellchecker/spellcheck_service_unittest.cc',
      'browser/spellchecker/spelling_service_client_unittest.cc',
      'tools/convert_dict/convert_dict_unittest.cc',
    ],
    'chrome_unit_tests_background_sources': [
      'browser/background/background_application_list_model_unittest.cc',
      'browser/background/background_contents_service_unittest.cc',
      'browser/background/background_mode_manager_unittest.cc',
      'browser/background/background_mode_optimizer_unittest.cc',
    ],
    'chrome_unit_tests_extensions_sources': [
      '../apps/saved_files_service_unittest.cc',
      '../components/drive/drive_api_util_unittest.cc',
      '../components/drive/drive_app_registry_unittest.cc',
      '../components/drive/drive_uploader_unittest.cc',
      '../components/drive/event_logger_unittest.cc',
      '../components/drive/service/drive_api_service_unittest.cc',
      '../components/drive/service/fake_drive_service_unittest.cc',
      '../tools/json_schema_compiler/test/features_generation_unittest.cc',
      'browser/apps/app_shim/app_shim_host_mac_unittest.cc',
      'browser/apps/app_shim/extension_app_shim_handler_mac_unittest.cc',
      'browser/autocomplete/keyword_extensions_delegate_impl_unittest.cc',
      'browser/browsing_data/hosted_apps_counter_unittest.cc',
      'browser/extensions/active_tab_unittest.cc',
      'browser/extensions/activity_log/activity_database_unittest.cc',
      'browser/extensions/activity_log/activity_log_enabled_unittest.cc',
      'browser/extensions/activity_log/activity_log_policy_unittest.cc',
      'browser/extensions/activity_log/activity_log_unittest.cc',
      'browser/extensions/activity_log/counting_policy_unittest.cc',
      'browser/extensions/activity_log/database_string_table_unittest.cc',
      'browser/extensions/activity_log/fullstream_ui_policy_unittest.cc',
      'browser/extensions/api/activity_log_private/activity_log_private_api_unittest.cc',
      'browser/extensions/api/bookmarks/bookmark_api_helpers_unittest.cc',
      'browser/extensions/api/content_settings/content_settings_store_unittest.cc',
      'browser/extensions/api/content_settings/content_settings_unittest.cc',
      'browser/extensions/api/cookies/cookies_unittest.cc',
      'browser/extensions/api/cryptotoken_private/cryptotoken_private_api_unittest.cc',
      'browser/extensions/api/declarative/rules_registry_service_unittest.cc',
      'browser/extensions/api/declarative/rules_registry_with_cache_unittest.cc',
      'browser/extensions/api/declarative_content/chrome_content_rules_registry_unittest.cc',
      'browser/extensions/api/declarative_content/content_action_unittest.cc',
      'browser/extensions/api/declarative_content/content_condition_unittest.cc',
      'browser/extensions/api/declarative_content/declarative_content_condition_tracker_test.cc',
      'browser/extensions/api/declarative_content/declarative_content_condition_tracker_test.h',
      'browser/extensions/api/declarative_content/declarative_content_css_condition_tracker_unittest.cc',
      'browser/extensions/api/declarative_content/declarative_content_is_bookmarked_condition_tracker_unittest.cc',
      'browser/extensions/api/declarative_content/declarative_content_page_url_condition_tracker_unittest.cc',
      'browser/extensions/api/declarative_webrequest/webrequest_action_unittest.cc',
      'browser/extensions/api/declarative_webrequest/webrequest_rules_registry_unittest.cc',
      'browser/extensions/api/developer_private/developer_private_api_unittest.cc',
      'browser/extensions/api/developer_private/extension_info_generator_unittest.cc',
      'browser/extensions/api/device_permissions_manager_unittest.cc',
      'browser/extensions/api/dial/dial_device_data_unittest.cc',
      'browser/extensions/api/dial/dial_registry_unittest.cc',
      'browser/extensions/api/dial/dial_service_unittest.cc',
      'browser/extensions/api/downloads/downloads_api_unittest.cc',
      'browser/extensions/api/easy_unlock_private/easy_unlock_private_api_chromeos_unittest.cc',
      'browser/extensions/api/experience_sampling_private/experience_sampling_private_api_unittest.cc',
      'browser/extensions/api/extension_action/browser_action_unittest.cc',
      'browser/extensions/api/extension_action/extension_action_prefs_unittest.cc',
      'browser/extensions/api/file_handlers/api_file_handler_util_unittest.cc',
      'browser/extensions/api/file_handlers/directory_util_unittest.cc',
      'browser/extensions/api/file_handlers/mime_util_unittest.cc',
      'browser/extensions/api/file_system/file_system_api_unittest.cc',
      'browser/extensions/api/identity/extension_token_key_unittest.cc',
      'browser/extensions/api/identity/gaia_web_auth_flow_unittest.cc',
      'browser/extensions/api/identity/identity_mint_queue_unittest.cc',
      'browser/extensions/api/image_writer_private/destroy_partitions_operation_unittest.cc',
      'browser/extensions/api/image_writer_private/operation_manager_unittest.cc',
      'browser/extensions/api/image_writer_private/operation_unittest.cc',
      'browser/extensions/api/image_writer_private/removable_storage_provider_chromeos_unittest.cc',
      'browser/extensions/api/image_writer_private/test_utils.cc',
      'browser/extensions/api/image_writer_private/write_from_file_operation_unittest.cc',
      'browser/extensions/api/image_writer_private/write_from_url_operation_unittest.cc',
      'browser/extensions/api/management/management_api_unittest.cc',
      'browser/extensions/api/omnibox/omnibox_unittest.cc',
      'browser/extensions/api/permissions/permissions_api_helpers_unittest.cc',
      'browser/extensions/api/permissions/permissions_api_unittest.cc',
      'browser/extensions/api/preference/preference_api_prefs_unittest.cc',
      'browser/extensions/api/proxy/proxy_api_helpers_unittest.cc',
      'browser/extensions/api/runtime/chrome_runtime_api_delegate_unittest.cc',
      'browser/extensions/api/signed_in_devices/id_mapping_helper_unittest.cc',
      'browser/extensions/api/signed_in_devices/signed_in_devices_api_unittest.cc',
      'browser/extensions/api/signed_in_devices/signed_in_devices_manager_unittest.cc',
      'browser/extensions/api/socket/combined_socket_unittest.cc',
      'browser/extensions/api/socket/socket_api_unittest.cc',
      'browser/extensions/api/socket/tcp_socket_unittest.cc',
      'browser/extensions/api/socket/tls_socket_unittest.cc',
      'browser/extensions/api/socket/udp_socket_unittest.cc',
      'browser/extensions/api/sockets_tcp_server/sockets_tcp_server_api_unittest.cc',
      'browser/extensions/api/storage/policy_value_store_unittest.cc',
      'browser/extensions/api/storage/settings_sync_unittest.cc',
      'browser/extensions/api/streams_private/streams_private_manifest_unittest.cc',
      'browser/extensions/api/tabs/tabs_api_unittest.cc',
      'browser/extensions/api/web_navigation/frame_navigation_state_unittest.cc',
      'browser/extensions/api/web_request/web_request_api_unittest.cc',
      'browser/extensions/api/web_request/web_request_permissions_unittest.cc',
      'browser/extensions/app_data_migrator_unittest.cc',
      'browser/extensions/blacklist_state_fetcher_unittest.cc',
      'browser/extensions/bookmark_app_helper_unittest.cc',
      'browser/extensions/chrome_app_sorting_unittest.cc',
      'browser/extensions/chrome_component_extension_resource_manager_unittest.cc',
      'browser/extensions/chrome_extension_function_unittest.cc',
      'browser/extensions/chrome_info_map_unittest.cc',
      'browser/extensions/component_loader_unittest.cc',
      'browser/extensions/component_migration_helper_unittest.cc',
      'browser/extensions/convert_user_script_unittest.cc',
      'browser/extensions/convert_web_app_unittest.cc',
      'browser/extensions/default_apps_unittest.cc',
      'browser/extensions/display_info_provider_chromeos_unittest.cc',
      'browser/extensions/error_console/error_console_unittest.cc',
      'browser/extensions/event_router_forwarder_unittest.cc',
      'browser/extensions/extension_action_icon_factory_unittest.cc',
      'browser/extensions/extension_action_manager_unittest.cc',
      'browser/extensions/extension_action_runner_unittest.cc',
      'browser/extensions/extension_action_unittest.cc',
      'browser/extensions/extension_api_unittest.cc',
      'browser/extensions/extension_api_unittest.h',
      'browser/extensions/extension_context_menu_model_unittest.cc',
      'browser/extensions/extension_creator_filter_unittest.cc',
      'browser/extensions/extension_error_controller_unittest.cc',
      'browser/extensions/extension_function_test_utils.cc',
      'browser/extensions/extension_function_test_utils.h',
      'browser/extensions/extension_garbage_collector_chromeos_unittest.cc',
      'browser/extensions/extension_garbage_collector_unittest.cc',
      'browser/extensions/extension_gcm_app_handler_unittest.cc',
      'browser/extensions/extension_icon_manager_unittest.cc',
      'browser/extensions/extension_install_checker_unittest.cc',
      'browser/extensions/extension_install_prompt_unittest.cc',
      'browser/extensions/extension_management_test_util.cc',
      'browser/extensions/extension_management_test_util.h',
      'browser/extensions/extension_management_unittest.cc',
      'browser/extensions/extension_message_bubble_controller_unittest.cc',
      'browser/extensions/extension_migrator_unittest.cc',
      'browser/extensions/extension_path_util_unittest.cc',
      'browser/extensions/extension_prefs_unittest.cc',
      'browser/extensions/extension_prefs_unittest.h',
      'browser/extensions/extension_protocols_unittest.cc',
      'browser/extensions/extension_reenabler_unittest.cc',
      'browser/extensions/extension_service_sync_unittest.cc',
      'browser/extensions/extension_service_test_base.cc',
      'browser/extensions/extension_service_test_base.h',
      'browser/extensions/extension_service_test_with_install.cc',
      'browser/extensions/extension_service_test_with_install.h',
      'browser/extensions/extension_service_unittest.cc',
      'browser/extensions/extension_special_storage_policy_unittest.cc',
      'browser/extensions/extension_sync_data_unittest.cc',
      'browser/extensions/extension_test_message_listener_unittest.cc',
      'browser/extensions/extension_user_script_loader_unittest.cc',
      'browser/extensions/extension_web_ui_unittest.cc',
      'browser/extensions/external_policy_loader_unittest.cc',
      'browser/extensions/external_provider_impl_chromeos_unittest.cc',
      'browser/extensions/external_provider_impl_unittest.cc',
      'browser/extensions/favicon_downloader_unittest.cc',
      'browser/extensions/install_tracker_unittest.cc',
      'browser/extensions/location_bar_controller_unittest.cc',
      'browser/extensions/menu_manager_unittest.cc',
      'browser/extensions/pack_extension_unittest.cc',
      'browser/extensions/permission_message_combinations_unittest.cc',
      'browser/extensions/permission_messages_unittest.cc',
      'browser/extensions/permissions_based_management_policy_provider_unittest.cc',
      'browser/extensions/permissions_updater_unittest.cc',
      'browser/extensions/policy_handlers_unittest.cc',
      'browser/extensions/scripting_permissions_modifier_unittest.cc',
      'browser/extensions/shared_module_service_unittest.cc',
      'browser/extensions/standard_management_policy_provider_unittest.cc',
      'browser/extensions/tab_helper_unittest.cc',
      'browser/extensions/token_cache/token_cache_service_unittest.cc',
      'browser/extensions/update_install_gate_unittest.cc',
      'browser/extensions/updater/extension_cache_fake.cc',
      'browser/extensions/updater/extension_cache_fake.h',
      'browser/extensions/updater/extension_updater_unittest.cc',
      'browser/extensions/user_script_listener_unittest.cc',
      'browser/extensions/warning_badge_service_unittest.cc',
      'browser/extensions/webstore_inline_installer_unittest.cc',
      'browser/extensions/webstore_installer_unittest.cc',
      'browser/extensions/zipfile_installer_unittest.cc',
      'browser/media/cast_transport_host_filter_unittest.cc',
      'browser/metrics/extensions_metrics_provider_unittest.cc',
      'browser/notifications/extension_welcome_notification_unittest.cc',
      'browser/notifications/notification_conversion_helper_unittest.cc',
      'browser/renderer_context_menu/context_menu_content_type_unittest.cc',
      'browser/search/hotword_service_unittest.cc',
      'browser/signin/easy_unlock_app_manager_unittest.cc',
      'browser/signin/easy_unlock_auth_attempt_unittest.cc',
      'browser/signin/easy_unlock_screenlock_state_handler_unittest.cc',
      'browser/signin/easy_unlock_service_unittest_chromeos.cc',
      'browser/signin/mutable_profile_oauth2_token_service_delegate_unittest.cc',
      'browser/sync/glue/extensions_activity_monitor_unittest.cc',
      'browser/sync_file_system/drive_backend/callback_helper_unittest.cc',
      'browser/sync_file_system/drive_backend/callback_tracker_unittest.cc',
      'browser/sync_file_system/drive_backend/conflict_resolver_unittest.cc',
      'browser/sync_file_system/drive_backend/drive_backend_sync_unittest.cc',
      'browser/sync_file_system/drive_backend/drive_backend_test_util.cc',
      'browser/sync_file_system/drive_backend/drive_backend_test_util.h',
      'browser/sync_file_system/drive_backend/fake_drive_service_helper.cc',
      'browser/sync_file_system/drive_backend/fake_drive_service_helper.h',
      'browser/sync_file_system/drive_backend/fake_drive_uploader.cc',
      'browser/sync_file_system/drive_backend/fake_drive_uploader.h',
      'browser/sync_file_system/drive_backend/fake_sync_worker.cc',
      'browser/sync_file_system/drive_backend/fake_sync_worker.h',
      'browser/sync_file_system/drive_backend/leveldb_wrapper_unittest.cc',
      'browser/sync_file_system/drive_backend/list_changes_task_unittest.cc',
      'browser/sync_file_system/drive_backend/local_to_remote_syncer_unittest.cc',
      'browser/sync_file_system/drive_backend/metadata_database_index_on_disk_unittest.cc',
      'browser/sync_file_system/drive_backend/metadata_database_index_unittest.cc',
      'browser/sync_file_system/drive_backend/metadata_database_unittest.cc',
      'browser/sync_file_system/drive_backend/metadata_db_migration_util_unittest.cc',
      'browser/sync_file_system/drive_backend/register_app_task_unittest.cc',
      'browser/sync_file_system/drive_backend/remote_to_local_syncer_unittest.cc',
      'browser/sync_file_system/drive_backend/sync_engine_initializer_unittest.cc',
      'browser/sync_file_system/drive_backend/sync_engine_unittest.cc',
      'browser/sync_file_system/drive_backend/sync_task_manager_unittest.cc',
      'browser/sync_file_system/drive_backend/sync_worker_unittest.cc',
      'browser/sync_file_system/drive_backend/task_dependency_manager_unittest.cc',
      'browser/sync_file_system/fake_remote_change_processor.cc',
      'browser/sync_file_system/fake_remote_change_processor.h',
      'browser/sync_file_system/file_change_unittest.cc',
      'browser/sync_file_system/local/canned_syncable_file_system.cc',
      'browser/sync_file_system/local/canned_syncable_file_system.h',
      'browser/sync_file_system/local/local_file_change_tracker_unittest.cc',
      'browser/sync_file_system/local/local_file_sync_context_unittest.cc',
      'browser/sync_file_system/local/local_file_sync_service_unittest.cc',
      'browser/sync_file_system/local/local_file_sync_status_unittest.cc',
      'browser/sync_file_system/local/mock_sync_status_observer.cc',
      'browser/sync_file_system/local/mock_sync_status_observer.h',
      'browser/sync_file_system/local/syncable_file_operation_runner_unittest.cc',
      'browser/sync_file_system/local/syncable_file_system_unittest.cc',
      'browser/sync_file_system/logger_unittest.cc',
      'browser/sync_file_system/mock_local_change_processor.cc',
      'browser/sync_file_system/mock_local_change_processor.h',
      'browser/sync_file_system/mock_remote_change_processor.cc',
      'browser/sync_file_system/mock_remote_change_processor.h',
      'browser/sync_file_system/mock_remote_file_sync_service.cc',
      'browser/sync_file_system/mock_remote_file_sync_service.h',
      'browser/sync_file_system/subtree_set_unittest.cc',
      'browser/sync_file_system/sync_file_system_service_unittest.cc',
      'browser/sync_file_system/sync_file_system_test_util.cc',
      'browser/sync_file_system/sync_file_system_test_util.h',
      'browser/sync_file_system/sync_process_runner_unittest.cc',
      'browser/sync_file_system/syncable_file_system_util_unittest.cc',
      'browser/web_applications/web_app_mac_unittest.mm',
      'browser/web_applications/web_app_unittest.cc',
      'common/extensions/api/commands/commands_manifest_unittest.cc',
      'common/extensions/api/common_extension_api_unittest.cc',
      'common/extensions/api/extension_action/browser_action_manifest_unittest.cc',
      'common/extensions/api/extension_action/page_action_manifest_unittest.cc',
      'common/extensions/api/storage/storage_schema_manifest_handler_unittest.cc',
      'common/extensions/chrome_extensions_client_unittest.cc',
      'common/extensions/chrome_manifest_url_handlers_unittest.cc',
      'common/extensions/command_unittest.cc',
      'common/extensions/extension_icon_set_unittest.cc',
      'common/extensions/extension_unittest.cc',
      'common/extensions/feature_switch_unittest.cc',
      'common/extensions/manifest_handlers/automation_unittest.cc',
      'common/extensions/manifest_handlers/content_scripts_manifest_unittest.cc',
      'common/extensions/manifest_handlers/exclude_matches_manifest_unittest.cc',
      'common/extensions/manifest_handlers/settings_overrides_handler_unittest.cc',
      'common/extensions/manifest_handlers/ui_overrides_handler_unittest.cc',
      'common/extensions/manifest_tests/chrome_manifest_test.cc',
      'common/extensions/manifest_tests/chrome_manifest_test.h',
      'common/extensions/manifest_tests/extension_manifests_about_unittest.cc',
      'common/extensions/manifest_tests/extension_manifests_background_unittest.cc',
      'common/extensions/manifest_tests/extension_manifests_chromepermission_unittest.cc',
      'common/extensions/manifest_tests/extension_manifests_contentsecuritypolicy_unittest.cc',
      'common/extensions/manifest_tests/extension_manifests_default_extent_path_unittest.cc',
      'common/extensions/manifest_tests/extension_manifests_devtools_unittest.cc',
      'common/extensions/manifest_tests/extension_manifests_dummy_unittest.cc',
      'common/extensions/manifest_tests/extension_manifests_experimental_unittest.cc',
      'common/extensions/manifest_tests/extension_manifests_homepage_unittest.cc',
      'common/extensions/manifest_tests/extension_manifests_icons_unittest.cc',
      'common/extensions/manifest_tests/extension_manifests_initvalue_unittest.cc',
      'common/extensions/manifest_tests/extension_manifests_isolatedapp_unittest.cc',
      'common/extensions/manifest_tests/extension_manifests_kiosk_unittest.cc',
      'common/extensions/manifest_tests/extension_manifests_launch_unittest.cc',
      'common/extensions/manifest_tests/extension_manifests_launcher_page_unittest.cc',
      'common/extensions/manifest_tests/extension_manifests_manifest_version_unittest.cc',
      'common/extensions/manifest_tests/extension_manifests_offline_unittest.cc',
      'common/extensions/manifest_tests/extension_manifests_old_unittest.cc',
      'common/extensions/manifest_tests/extension_manifests_options_unittest.cc',
      'common/extensions/manifest_tests/extension_manifests_override_unittest.cc',
      'common/extensions/manifest_tests/extension_manifests_platformapp_unittest.cc',
      'common/extensions/manifest_tests/extension_manifests_portsinpermissions_unittest.cc',
      'common/extensions/manifest_tests/extension_manifests_requirements_unittest.cc',
      'common/extensions/manifest_tests/extension_manifests_sandboxed_unittest.cc',
      'common/extensions/manifest_tests/extension_manifests_storage_unittest.cc',
      'common/extensions/manifest_tests/extension_manifests_ui_unittest.cc',
      'common/extensions/manifest_tests/extension_manifests_update_unittest.cc',
      'common/extensions/manifest_tests/extension_manifests_validapp_unittest.cc',
      'common/extensions/manifest_tests/extension_manifests_web_accessible_resources_unittest.cc',
      'common/extensions/manifest_tests/extension_manifests_web_unittest.cc',
      'common/extensions/manifest_tests/extension_manifests_webview_accessible_resources_unittest.cc',
      'common/extensions/manifest_unittest.cc',
      'common/extensions/permissions/chrome_permission_message_provider_unittest.cc',
      'common/extensions/permissions/chrome_permission_message_rules_unittest.cc',
      'common/extensions/permissions/media_galleries_permission_unittest.cc',
      'common/extensions/permissions/permission_set_unittest.cc',
      'common/extensions/permissions/permissions_data_unittest.cc',
      'common/extensions/permissions/settings_override_permission_unittest.cc',
      'common/extensions/sync_type_unittest.cc',
      'common/extensions/value_counter_unittest.cc',
      'renderer/extensions/extension_localization_peer_unittest.cc',
      'renderer/extensions/renderer_permissions_policy_delegate_unittest.cc',
      'renderer/media/cast_ipc_dispatcher_unittest.cc',
      'utility/image_writer/image_writer_unittest.cc',
    ],
    'chrome_unit_tests_extensions_service_discovery_sources': [
      'browser/extensions/api/gcd_private/privet_v3_context_getter_unittest.cc',
      'browser/extensions/api/gcd_private/privet_v3_session_unittest.cc',
      'browser/extensions/api/mdns/dns_sd_registry_unittest.cc',
      'browser/extensions/api/mdns/mdns_api_unittest.cc',
    ],
    'chrome_unit_tests_extensions_non_chromeos_sources': [
      'browser/extensions/api/messaging/native_message_process_host_unittest.cc',
      'browser/extensions/api/messaging/native_messaging_host_manifest_unittest.cc',
      'browser/extensions/api/messaging/native_messaging_policy_handler_unittest.cc',
    ],
    'chrome_unit_tests_ash_sources': [
      'browser/media/desktop_media_list_ash_unittest.cc',
      'browser/renderer_context_menu/mock_render_view_context_menu.cc',
      'browser/renderer_context_menu/mock_render_view_context_menu.h',
      'browser/renderer_context_menu/open_with_menu_factory_ash_unittest.cc',
      'browser/signin/signin_error_notifier_ash_unittest.cc',
      'browser/sync/sync_error_notifier_ash_unittest.cc',
      # Ash implies the app list is enabled (only disabled on mobile).
      'browser/ui/ash/accessibility/ax_tree_source_aura_unittest.cc',
      'browser/ui/ash/chrome_screenshot_grabber_unittest.cc',
      'browser/ui/ash/launcher/chrome_launcher_controller_impl_unittest.cc',
      'browser/ui/ash/launcher/launcher_application_menu_item_model_unittest.cc',
      'browser/ui/ash/launcher/launcher_context_menu_unittest.cc',
      'browser/ui/ash/multi_user/multi_user_context_menu_chromeos_unittest.cc',
      'browser/ui/ash/multi_user/multi_user_notification_blocker_chromeos_unittest.cc',
      'browser/ui/ash/multi_user/multi_user_util_chromeos_unittest.cc',
      'browser/ui/ash/multi_user/multi_user_window_manager_chromeos_unittest.cc',
      'browser/ui/ash/multi_user/user_switch_util_unittest.cc',
      'browser/ui/ash/session_state_delegate_chromeos_unittest.cc',
      'browser/ui/ash/system_tray_delegate_chromeos_unittest.cc',
      'browser/ui/ash/window_positioner_unittest.cc',
      'browser/ui/window_sizer/window_sizer_ash_unittest.cc',
    ],
    'chrome_test_support_unit_ash_sources': [
      'browser/ui/ash/launcher/test/launcher_application_menu_item_model_test_api.cc',
      'browser/ui/ash/launcher/test/launcher_application_menu_item_model_test_api.h',
      'browser/ui/ash/launcher/test/test_chrome_launcher_app_menu_item.cc',
      'browser/ui/ash/launcher/test/test_chrome_launcher_app_menu_item.h',
    ],
    'chrome_unit_tests_task_manager_sources': [
      'browser/task_manager/providers/browser_process_task_unittest.cc',
      'browser/task_manager/providers/child_process_task_unittest.cc',
      'browser/task_manager/sampling/task_manager_impl_unittest.cc',
      'browser/task_manager/task_manager_observer_unittest.cc',
      'browser/task_manager/test_task_manager.cc',
      'browser/task_manager/test_task_manager.h',
    ],
    'chrome_unit_tests_mdns_sources': [
      'browser/local_discovery/local_domain_resolver_unittest.cc',
      'browser/local_discovery/service_discovery_client_unittest.cc',
      'browser/printing/cloud_print/privet_device_lister_unittest.cc',
      'browser/printing/cloud_print/privet_local_printer_lister_unittest.cc',
    ],
    'chrome_unit_tests_service_discovery_sources': [
      'browser/devtools/device/cast_device_provider_unittest.cc',
      'browser/local_discovery/service_discovery_client_mac_unittest.mm',
      'browser/printing/cloud_print/cloud_print_printer_list_unittest.cc',
      'browser/printing/cloud_print/gcd_api_flow_unittest.cc',
      'browser/printing/cloud_print/privet_confirm_api_flow_unittest.cc',
      'browser/printing/cloud_print/privet_http_unittest.cc',
      'browser/printing/cloud_print/privet_notifications_unittest.cc',
      'browser/printing/cloud_print/privet_url_fetcher_unittest.cc',
    ],
    'chrome_unit_tests_speech_sources': [
      'browser/speech/extension_api/extension_manifests_tts_unittest.cc',
      'browser/speech/tts_controller_unittest.cc',
    ],
    'chrome_unit_tests_notifications_sources': [
      'browser/notifications/desktop_notification_profile_util_unittest.cc',
      'browser/notifications/message_center_notifications_unittest.cc',
      'browser/notifications/message_center_settings_controller_unittest.cc',
      'browser/notifications/notification_permission_context_unittest.cc',
      'browser/notifications/notification_platform_bridge_mac_unittest.mm',
      'browser/notifications/platform_notification_service_unittest.cc',
    ],
     # Used by Full Safe Browsing (safe_browsing==1)
     # and by Mobile Safe Browsing (==2) modes.
    'chrome_unit_tests_shared_safe_browsing_sources': [
      'browser/safe_browsing/ping_manager_unittest.cc',
      'browser/safe_browsing/safe_browsing_blocking_page_unittest.cc',
      'browser/safe_browsing/threat_details_unittest.cc',
      'browser/safe_browsing/ui_manager_unittest.cc',
      'common/safe_browsing/file_type_policies_unittest.cc',
      'common/safe_browsing/file_type_policies_test_util.cc',
      'common/safe_browsing/file_type_policies_test_util.h',
     ],
    'chrome_unit_tests_full_safe_browsing_sources': [
      'browser/safe_browsing/browser_feature_extractor_unittest.cc',
      'browser/safe_browsing/chunk_range_unittest.cc',
      'browser/safe_browsing/client_side_detection_host_unittest.cc',
      'browser/safe_browsing/client_side_detection_service_unittest.cc',
      'browser/safe_browsing/client_side_model_loader_unittest.cc',
      'browser/safe_browsing/download_feedback_service_unittest.cc',
      'browser/safe_browsing/download_feedback_unittest.cc',
      'browser/safe_browsing/download_protection_service_unittest.cc',
      'browser/safe_browsing/incident_reporting/binary_integrity_analyzer_mac_unittest.cc',
      'browser/safe_browsing/incident_reporting/binary_integrity_analyzer_win_unittest.cc',
      'browser/safe_browsing/incident_reporting/binary_integrity_incident_unittest.cc',
      'browser/safe_browsing/incident_reporting/blacklist_load_analyzer_win_unittest.cc',
      'browser/safe_browsing/incident_reporting/blacklist_load_incident_unittest.cc',
      'browser/safe_browsing/incident_reporting/delayed_callback_runner_unittest.cc',
      'browser/safe_browsing/incident_reporting/download_metadata_manager_unittest.cc',
      'browser/safe_browsing/incident_reporting/environment_data_collection_win_unittest.cc',
      'browser/safe_browsing/incident_reporting/extension_data_collection_unittest.cc',
      'browser/safe_browsing/incident_reporting/incident_report_uploader_impl_unittest.cc',
      'browser/safe_browsing/incident_reporting/incident_reporting_service_unittest.cc',
      'browser/safe_browsing/incident_reporting/last_download_finder_unittest.cc',
      'browser/safe_browsing/incident_reporting/mock_incident_receiver.cc',
      'browser/safe_browsing/incident_reporting/mock_incident_receiver.h',
      'browser/safe_browsing/incident_reporting/module_integrity_unittest_util_win.cc',
      'browser/safe_browsing/incident_reporting/module_integrity_unittest_util_win.h',
      'browser/safe_browsing/incident_reporting/module_integrity_verifier_win_unittest.cc',
      'browser/safe_browsing/incident_reporting/module_load_analyzer_win_unittest.cc',
      'browser/safe_browsing/incident_reporting/platform_state_store_unittest.cc',
      'browser/safe_browsing/incident_reporting/platform_state_store_win_unittest.cc',
      'browser/safe_browsing/incident_reporting/preference_validation_delegate_unittest.cc',
      'browser/safe_browsing/incident_reporting/resource_request_detector_unittest.cc',
      'browser/safe_browsing/incident_reporting/state_store_unittest.cc',
      'browser/safe_browsing/incident_reporting/suspicious_module_incident_unittest.cc',
      'browser/safe_browsing/incident_reporting/tracked_preference_incident_unittest.cc',
      'browser/safe_browsing/incident_reporting/variations_seed_signature_incident_unittest.cc',
      'browser/safe_browsing/local_database_manager_unittest.cc',
      'browser/safe_browsing/local_two_phase_testserver.cc',
      'browser/safe_browsing/path_sanitizer_unittest.cc',
      'browser/safe_browsing/permission_reporter_unittest.cc',
      'browser/safe_browsing/protocol_manager_unittest.cc',
      'browser/safe_browsing/protocol_parser_unittest.cc',
      'browser/safe_browsing/safe_browsing_database_unittest.cc',
      'browser/safe_browsing/safe_browsing_store_file_unittest.cc',
      'browser/safe_browsing/safe_browsing_store_unittest.cc',
      'browser/safe_browsing/sandboxed_dmg_analyzer_mac_unittest.cc',
      'browser/safe_browsing/sandboxed_zip_analyzer_unittest.cc',
      'browser/safe_browsing/signature_evaluator_mac_unittest.cc',
      'browser/safe_browsing/two_phase_uploader_unittest.cc',
      'common/safe_browsing/binary_feature_extractor_mac_unittest.cc',
      'common/safe_browsing/binary_feature_extractor_unittest.cc',
      'common/safe_browsing/binary_feature_extractor_win_unittest.cc',
      'common/safe_browsing/download_protection_util_unittest.cc',
      'common/safe_browsing/ipc_protobuf_message_test_messages.h',
      'common/safe_browsing/ipc_protobuf_message_unittest.cc',
      'common/safe_browsing/mach_o_image_reader_mac_unittest.cc',
      'common/safe_browsing/pe_image_reader_win_unittest.cc',
      'renderer/safe_browsing/features_unittest.cc',
      'renderer/safe_browsing/murmurhash3_util_unittest.cc',
      'renderer/safe_browsing/phishing_term_feature_extractor_unittest.cc',
      'renderer/safe_browsing/phishing_url_feature_extractor_unittest.cc',
      'renderer/safe_browsing/scorer_unittest.cc',
      'utility/safe_browsing/mac/dmg_test_utils.cc',
      'utility/safe_browsing/mac/hfs_unittest.cc',
      'utility/safe_browsing/mac/read_stream_unittest.cc',
      'utility/safe_browsing/mac/udif_unittest.cc',
    ],
    'chrome_unit_tests_plugins_sources': [
      'browser/component_updater/component_installers_unittest.cc',
      'browser/metrics/chrome_stability_metrics_provider_unittest.cc',
      'browser/metrics/plugin_metrics_provider_unittest.cc',
      'browser/plugins/plugin_finder_unittest.cc',
      'browser/plugins/plugin_info_message_filter_unittest.cc',
      'browser/plugins/plugin_installer_unittest.cc',
      'browser/plugins/plugin_metadata_unittest.cc',
      'browser/plugins/plugin_prefs_unittest.cc',
      'common/pepper_permission_util_unittest.cc',
    ],
    'chrome_unit_tests_print_preview_sources': [
      'browser/printing/cloud_print/cloud_print_proxy_service_unittest.cc',
      'browser/printing/print_job_unittest.cc',
      'browser/printing/print_preview_dialog_controller_unittest.cc',
      'browser/printing/print_preview_test.cc',
      'browser/printing/print_preview_test.h',
      'browser/ui/webui/print_preview/extension_printer_handler_unittest.cc',
      'browser/ui/webui/print_preview/print_preview_ui_unittest.cc',
      'common/cloud_print/cloud_print_helpers_unittest.cc',
      'common/service_process_util_unittest.cc',
      'service/cloud_print/cloud_print_service_helpers_unittest.cc',
      'service/cloud_print/cloud_print_token_store_unittest.cc',
      'service/cloud_print/cloud_print_url_fetcher_unittest.cc',
      'service/cloud_print/connector_settings_unittest.cc',
      'service/cloud_print/printer_job_handler_unittest.cc',
      'service/cloud_print/printer_job_queue_handler_unittest.cc',
      'service/service_ipc_server_unittest.cc',
      'service/service_process_prefs_unittest.cc',
      'utility/cloud_print/pwg_encoder_unittest.cc',
    ],
    'chrome_unit_tests_captive_portal_sources': [
      'browser/captive_portal/captive_portal_service_unittest.cc',
      'browser/captive_portal/captive_portal_tab_helper_unittest.cc',
      'browser/captive_portal/captive_portal_tab_reloader_unittest.cc',
    ],
    'chrome_unit_tests_session_service_sources': [
      'browser/sessions/session_restore_stats_collector_unittest.cc',
      'browser/sessions/session_service_unittest.cc',
      'browser/ui/startup/session_crashed_infobar_delegate_unittest.cc',
    ],
    'chrome_unit_tests_webrtc_sources': [
      'browser/media/webrtc_log_uploader_unittest.cc',
      'browser/media/webrtc_log_util_unittest.cc',
      'browser/media/webrtc_rtp_dump_handler_unittest.cc',
      'browser/media/webrtc_rtp_dump_writer_unittest.cc',
      'renderer/media/chrome_webrtc_log_message_delegate_unittest.cc',
    ],
    'chrome_unit_tests_js_sources': [
      'browser/resources/google_now/background.js',
      'browser/resources/google_now/background_test_util.js',
      'browser/resources/google_now/cards.js',
      'browser/resources/google_now/common_test_util.js',
      'browser/resources/google_now/utility.js',
      'browser/resources/google_now/utility_test_util.js',
      'browser/resources/md_downloads/action_service.js',
      'browser/resources/print_preview/data/measurement_system.js',
      'browser/resources/print_preview/print_preview_utils.js',
      'renderer/resources/extensions/notifications_custom_bindings.js',
      'renderer/resources/extensions/notifications_test_util.js',
      '../ui/webui/resources/js/cr.js',
    ],
    'chrome_unit_tests_gtestjs_sources': [
      'browser/resources/google_now/background_unittest.gtestjs',
      'browser/resources/google_now/cards_unittest.gtestjs',
      'browser/resources/google_now/utility_unittest.gtestjs',
      'browser/resources/md_downloads/action_service_unittest.gtestjs',
      'browser/resources/print_preview/data/measurement_system_unittest.gtestjs',
      'browser/resources/print_preview/print_preview_utils_unittest.gtestjs',
      'renderer/resources/extensions/notifications_custom_bindings.gtestjs',
      'test/data/unit/framework_unittest.gtestjs',
    ],
    'chrome_unit_tests_chromeos_sources': [
      # TODO(lukasza): Move Drive tests outside of CrOS (crbug.com/498951).
      '../components/drive/change_list_loader_unittest.cc',
      '../components/drive/change_list_processor_unittest.cc',
      '../components/drive/chromeos/file_cache_unittest.cc',
      '../components/drive/directory_loader_unittest.cc',
      '../components/drive/fake_file_system_unittest.cc',
      '../components/drive/file_change_unittest.cc',
      '../components/drive/file_system/copy_operation_unittest.cc',
      '../components/drive/file_system/create_directory_operation_unittest.cc',
      '../components/drive/file_system/create_file_operation_unittest.cc',
      '../components/drive/file_system/download_operation_unittest.cc',
      '../components/drive/file_system/get_file_for_saving_operation_unittest.cc',
      '../components/drive/file_system/move_operation_unittest.cc',
      '../components/drive/file_system/open_file_operation_unittest.cc',
      '../components/drive/file_system/operation_test_base.cc',
      '../components/drive/file_system/operation_test_base.h',
      '../components/drive/file_system/remove_operation_unittest.cc',
      '../components/drive/file_system/search_operation_unittest.cc',
      '../components/drive/file_system/set_property_operation_unittest.cc',
      '../components/drive/file_system/touch_operation_unittest.cc',
      '../components/drive/file_system/truncate_operation_unittest.cc',
      '../components/drive/file_system_core_util_unittest.cc',
      '../components/drive/file_system_unittest.cc',
      '../components/drive/file_write_watcher_unittest.cc',
      '../components/drive/job_queue_unittest.cc',
      '../components/drive/job_scheduler_unittest.cc',
      '../components/drive/local_file_reader_unittest.cc',
      '../components/drive/remove_stale_cache_files_unittest.cc',
      '../components/drive/resource_entry_conversion_unittest.cc',
      '../components/drive/resource_metadata_storage_unittest.cc',
      '../components/drive/resource_metadata_unittest.cc',
      '../components/drive/search_metadata_unittest.cc',
      '../components/drive/sync/entry_revert_performer_unittest.cc',
      '../components/drive/sync/entry_update_performer_unittest.cc',
      '../components/drive/sync/remove_performer_unittest.cc',
      '../components/drive/sync_client_unittest.cc',
      '../ui/base/ime/chromeos/input_method_whitelist.cc',
      '../ui/base/ime/chromeos/input_method_whitelist.h',
      'browser/chromeos/accessibility/magnification_manager_unittest.cc',
      'browser/chromeos/accessibility/spoken_feedback_event_rewriter_unittest.cc',
      'browser/chromeos/attestation/attestation_ca_client_unittest.cc',
      'browser/chromeos/attestation/attestation_policy_observer_unittest.cc',
      'browser/chromeos/attestation/fake_certificate.cc',
      'browser/chromeos/attestation/fake_certificate.h',
      'browser/chromeos/attestation/platform_verification_flow_unittest.cc',
      'browser/chromeos/base/file_flusher_unittest.cc',
      'browser/chromeos/certificate_provider/certificate_provider_service_unittest.cc',
      'browser/chromeos/customization/customization_document_unittest.cc',
      'browser/chromeos/display/display_preferences_unittest.cc',
      'browser/chromeos/drive/download_handler_unittest.cc',
      'browser/chromeos/drive/drive_file_stream_reader_unittest.cc',
      'browser/chromeos/drive/drive_integration_service_unittest.cc',
      'browser/chromeos/drive/file_system_util_unittest.cc',
      'browser/chromeos/drive/file_task_executor_unittest.cc',
      'browser/chromeos/drive/fileapi/fileapi_worker_unittest.cc',
      'browser/chromeos/drive/fileapi/webkit_file_stream_reader_impl_unittest.cc',
      'browser/chromeos/drive/write_on_cache_file_unittest.cc',
      'browser/chromeos/events/event_rewriter_unittest.cc',
      'browser/chromeos/events/keyboard_driven_event_rewriter_unittest.cc',
      'browser/chromeos/extensions/default_app_order_unittest.cc',
      'browser/chromeos/extensions/device_local_account_external_policy_loader_unittest.cc',
      'browser/chromeos/extensions/device_local_account_management_policy_provider_unittest.cc',
      'browser/chromeos/extensions/external_cache_unittest.cc',
      'browser/chromeos/extensions/file_manager/device_event_router_unittest.cc',
      'browser/chromeos/extensions/file_manager/job_event_router_unittest.cc',
      'browser/chromeos/extensions/gfx_utils_unittest.cc',
      'browser/chromeos/extensions/quick_unlock_private/quick_unlock_private_api_unittest.cc',
      'browser/chromeos/extensions/wallpaper_private_api_unittest.cc',
      'browser/chromeos/external_metrics_unittest.cc',
      'browser/chromeos/file_manager/file_tasks_unittest.cc',
      'browser/chromeos/file_manager/file_watcher_unittest.cc',
      'browser/chromeos/file_manager/fileapi_util_unittest.cc',
      'browser/chromeos/file_manager/mount_test_util.cc',
      'browser/chromeos/file_manager/path_util_unittest.cc',
      'browser/chromeos/file_manager/url_util_unittest.cc',
      'browser/chromeos/file_manager/volume_manager_unittest.cc',
      'browser/chromeos/file_system_provider/fake_provided_file_system.cc',
      'browser/chromeos/file_system_provider/fake_provided_file_system.h',
      'browser/chromeos/file_system_provider/fileapi/buffering_file_stream_reader_unittest.cc',
      'browser/chromeos/file_system_provider/fileapi/buffering_file_stream_writer_unittest.cc',
      'browser/chromeos/file_system_provider/fileapi/file_stream_reader_unittest.cc',
      'browser/chromeos/file_system_provider/fileapi/file_stream_writer_unittest.cc',
      'browser/chromeos/file_system_provider/fileapi/provider_async_file_util_unittest.cc',
      'browser/chromeos/file_system_provider/mount_path_util_unittest.cc',
      'browser/chromeos/file_system_provider/operations/abort_unittest.cc',
      'browser/chromeos/file_system_provider/operations/add_watcher_unittest.cc',
      'browser/chromeos/file_system_provider/operations/close_file_unittest.cc',
      'browser/chromeos/file_system_provider/operations/configure_unittest.cc',
      'browser/chromeos/file_system_provider/operations/copy_entry_unittest.cc',
      'browser/chromeos/file_system_provider/operations/create_directory_unittest.cc',
      'browser/chromeos/file_system_provider/operations/create_file_unittest.cc',
      'browser/chromeos/file_system_provider/operations/delete_entry_unittest.cc',
      'browser/chromeos/file_system_provider/operations/execute_action_unittest.cc',
      'browser/chromeos/file_system_provider/operations/get_actions_unittest.cc',
      'browser/chromeos/file_system_provider/operations/get_metadata_unittest.cc',
      'browser/chromeos/file_system_provider/operations/move_entry_unittest.cc',
      'browser/chromeos/file_system_provider/operations/open_file_unittest.cc',
      'browser/chromeos/file_system_provider/operations/read_directory_unittest.cc',
      'browser/chromeos/file_system_provider/operations/read_file_unittest.cc',
      'browser/chromeos/file_system_provider/operations/remove_watcher_unittest.cc',
      'browser/chromeos/file_system_provider/operations/test_util.cc',
      'browser/chromeos/file_system_provider/operations/test_util.h',
      'browser/chromeos/file_system_provider/operations/truncate_unittest.cc',
      'browser/chromeos/file_system_provider/operations/unmount_unittest.cc',
      'browser/chromeos/file_system_provider/operations/write_file_unittest.cc',
      'browser/chromeos/file_system_provider/provided_file_system_unittest.cc',
      'browser/chromeos/file_system_provider/queue_unittest.cc',
      'browser/chromeos/file_system_provider/registry_unittest.cc',
      'browser/chromeos/file_system_provider/request_manager_unittest.cc',
      'browser/chromeos/file_system_provider/scoped_file_opener_unittest.cc',
      'browser/chromeos/file_system_provider/service_unittest.cc',
      'browser/chromeos/file_system_provider/throttled_file_system_unittest.cc',
      'browser/chromeos/fileapi/external_file_url_request_job_unittest.cc',
      'browser/chromeos/fileapi/external_file_url_util_unittest.cc',
      'browser/chromeos/fileapi/file_access_permissions_unittest.cc',
      'browser/chromeos/fileapi/file_system_backend_unittest.cc',
      'browser/chromeos/hats/hats_notification_controller_unittest.cc',
      'browser/chromeos/input_method/browser_state_monitor_unittest.cc',
      'browser/chromeos/input_method/input_method_configuration_unittest.cc',
      'browser/chromeos/input_method/input_method_engine_unittest.cc',
      'browser/chromeos/input_method/input_method_manager_impl_unittest.cc',
      'browser/chromeos/input_method/input_method_persistence_unittest.cc',
      'browser/chromeos/input_method/input_method_util_unittest.cc',
      'browser/chromeos/locale_change_guard_unittest.cc',
      'browser/chromeos/login/auth/cryptohome_authenticator_unittest.cc',
      'browser/chromeos/login/easy_unlock/easy_unlock_challenge_wrapper_unittest.cc',
      'browser/chromeos/login/easy_unlock/easy_unlock_tpm_key_manager_unittest.cc',
      'browser/chromeos/login/error_screens_histogram_helper_unittest.cc',
      'browser/chromeos/login/existing_user_controller_auto_login_unittest.cc',
      'browser/chromeos/login/hwid_checker_unittest.cc',
      'browser/chromeos/login/profile_auth_data_unittest.cc',
      'browser/chromeos/login/quick_unlock/pin_storage_unittest.cc',
      'browser/chromeos/login/saml/saml_offline_signin_limiter_unittest.cc',
      'browser/chromeos/login/signin/merge_session_load_page_unittest.cc',
      'browser/chromeos/login/supervised/supervised_user_authentication_unittest.cc',
      'browser/chromeos/login/users/affiliation_unittest.cc',
      'browser/chromeos/login/users/multi_profile_user_controller_unittest.cc',
      'browser/chromeos/login/users/user_manager_unittest.cc',
      'browser/chromeos/login/users/wallpaper/wallpaper_manager_unittest.cc',
      'browser/chromeos/mobile/mobile_activator_unittest.cc',
      'browser/chromeos/mobile_config_unittest.cc',
      'browser/chromeos/net/cert_verify_proc_chromeos_unittest.cc',
      'browser/chromeos/net/client_cert_store_chromeos_unittest.cc',
      'browser/chromeos/net/network_portal_detector_impl_unittest.cc',
      'browser/chromeos/net/network_portal_notification_controller_unittest.cc',
      'browser/chromeos/net/wake_on_wifi_manager_unittest.cc',
      'browser/chromeos/options/network_property_ui_data_unittest.cc',
      'browser/chromeos/ownership/fake_owner_settings_service.cc',
      'browser/chromeos/ownership/fake_owner_settings_service.h',
      'browser/chromeos/ownership/owner_settings_service_chromeos_unittest.cc',
      'browser/chromeos/policy/affiliated_cloud_policy_invalidator_unittest.cc',
      'browser/chromeos/policy/affiliated_invalidation_service_provider_impl_unittest.cc',
      'browser/chromeos/policy/android_management_client_unittest.cc',
      'browser/chromeos/policy/auto_enrollment_client_unittest.cc',
      'browser/chromeos/policy/bluetooth_policy_handler_unittest.cc',
      'browser/chromeos/policy/cloud_external_data_manager_base_unittest.cc',
      'browser/chromeos/policy/cloud_external_data_policy_observer_unittest.cc',
      'browser/chromeos/policy/cloud_external_data_store_unittest.cc',
      'browser/chromeos/policy/configuration_policy_handler_chromeos_unittest.cc',
      'browser/chromeos/policy/device_cloud_policy_initializer_unittest.cc',
      'browser/chromeos/policy/device_cloud_policy_manager_chromeos_unittest.cc',
      'browser/chromeos/policy/device_cloud_policy_store_chromeos_unittest.cc',
      'browser/chromeos/policy/device_local_account_policy_service_unittest.cc',
      'browser/chromeos/policy/enterprise_install_attributes_unittest.cc',
      'browser/chromeos/policy/extension_cache_unittest.cc',
      'browser/chromeos/policy/fake_affiliated_invalidation_service_provider.cc',
      'browser/chromeos/policy/fake_affiliated_invalidation_service_provider.h',
      'browser/chromeos/policy/heartbeat_scheduler_unittest.cc',
      'browser/chromeos/policy/network_configuration_updater_unittest.cc',
      'browser/chromeos/policy/recommendation_restorer_unittest.cc',
      'browser/chromeos/policy/remote_commands/device_command_screenshot_job_unittest.cc',
      'browser/chromeos/policy/server_backed_state_keys_broker_unittest.cc',
      'browser/chromeos/policy/status_uploader_unittest.cc',
      'browser/chromeos/policy/system_log_uploader_unittest.cc',
      'browser/chromeos/policy/upload_job_unittest.cc',
      'browser/chromeos/policy/user_cloud_policy_manager_chromeos_unittest.cc',
      'browser/chromeos/policy/user_cloud_policy_store_chromeos_unittest.cc',
      'browser/chromeos/power/extension_event_observer_unittest.cc',
      'browser/chromeos/power/power_data_collector_unittest.cc',
      'browser/chromeos/power/power_prefs_unittest.cc',
      'browser/chromeos/power/renderer_freezer_unittest.cc',
      'browser/chromeos/preferences_unittest.cc',
      'browser/chromeos/printer_detector/printer_detector_unittest.cc',
      'browser/chromeos/printing/printer_pref_manager_unittest.cc',
      'browser/chromeos/profiles/profile_list_chromeos_unittest.cc',
      'browser/chromeos/proxy_config_service_impl_unittest.cc',
      'browser/chromeos/resource_reporter/resource_reporter_unittest.cc',
      'browser/chromeos/session_length_limiter_unittest.cc',
      'browser/chromeos/settings/cros_settings_unittest.cc',
      'browser/chromeos/settings/device_oauth2_token_service_unittest.cc',
      'browser/chromeos/settings/device_settings_provider_unittest.cc',
      'browser/chromeos/settings/device_settings_service_unittest.cc',
      'browser/chromeos/settings/scoped_cros_settings_test_helper.cc',
      'browser/chromeos/settings/scoped_cros_settings_test_helper.h',
      'browser/chromeos/settings/session_manager_operation_unittest.cc',
      'browser/chromeos/settings/shutdown_policy_handler_unittest.cc',
      'browser/chromeos/settings/stub_cros_settings_provider_unittest.cc',
      'browser/chromeos/status/data_promo_notification_unittest.cc',
      'browser/chromeos/system/automatic_reboot_manager_unittest.cc',
      'browser/chromeos/system/device_disabling_manager_unittest.cc',
      'browser/chromeos/ui/accessibility_focus_ring_controller_unittest.cc',
      'browser/chromeos/ui/idle_app_name_notification_view_unittest.cc',
      'browser/chromeos/ui/low_disk_notification_unittest.cc',
      'browser/download/notification/download_item_notification_unittest.cc',
      'browser/extensions/api/enterprise_platform_keys/enterprise_platform_keys_api_unittest.cc',
      'browser/extensions/api/enterprise_platform_keys_private/enterprise_platform_keys_private_api_unittest.cc',
      'browser/extensions/api/log_private/syslog_parser_unittest.cc',
      'browser/extensions/updater/local_extension_cache_unittest.cc',
      'browser/metrics/chromeos_metrics_provider_unittest.cc',
      'browser/metrics/leak_detector/leak_detector_controller_unittest.cc',
      'browser/metrics/perf/cpu_identity_unittest.cc',
      'browser/metrics/perf/random_selector_unittest.cc',
      'browser/notifications/login_state_notification_blocker_chromeos_unittest.cc',
      'browser/policy/default_geolocation_policy_handler_unittest.cc',
      'browser/ui/browser_finder_chromeos_unittest.cc',
      # TODO(zturner): Enable this on Windows. See
      # BrowserWithTestWindowTest::SetUp() for a comment explaining why this is
      # broken.
      'browser/ui/views/frame/immersive_mode_controller_ash_unittest.cc',
      'browser/ui/views/frame/web_app_left_header_view_ash_unittest.cc',
      'browser/ui/views/select_file_dialog_extension_unittest.cc',
      'browser/ui/webui/chromeos/login/l10n_util_test_util.cc',
      'browser/ui/webui/chromeos/login/l10n_util_test_util.h',
      'browser/ui/webui/chromeos/login/l10n_util_unittest.cc',
      'browser/ui/webui/chromeos/login/signin_userlist_unittest.cc',
      'browser/ui/webui/options/chromeos/cros_language_options_handler_unittest.cc',
      'browser/ui/webui/settings/chromeos/easy_unlock_settings_handler_unittest.cc',
      'common/extensions/api/file_browser_handlers/file_browser_handler_manifest_unittest.cc',
      'common/extensions/api/file_system_provider/file_system_provider_handler_unittest.cc',
    ],
    'chrome_unit_tests_chromeos_js_sources': [
      'browser/resources/chromeos/braille_ime/braille_ime.js',
    ],
    'chrome_unit_tests_chromeos_gtestjs_sources': [
      'browser/resources/chromeos/braille_ime/braille_ime_unittest.gtestjs',
    ],
    'chrome_unit_tests_desktop_linux_sources': [
      'browser/ui/input_method/input_method_engine_unittest.cc',
      'browser/password_manager/native_backend_kwallet_x_unittest.cc',
      'browser/shell_integration_linux_unittest.cc',
    ],
    # Tests corresponding to the files in chrome_browser_ui_cocoa_sources.
    # Built on Mac, except when mac_views_browser==1.
    'chrome_unit_tests_cocoa_sources': [
      'browser/ui/cocoa/accelerators_cocoa_unittest.mm',
      'browser/ui/cocoa/animatable_image_unittest.mm',
      'browser/ui/cocoa/animatable_view_unittest.mm',
      'browser/ui/cocoa/app_menu/app_menu_button_cell_unittest.mm',
      'browser/ui/cocoa/app_menu/app_menu_controller_unittest.mm',
      'browser/ui/cocoa/app_menu/menu_tracked_root_view_unittest.mm',
      'browser/ui/cocoa/applescript/apple_event_util_unittest.mm',
      'browser/ui/cocoa/applescript/bookmark_applescript_utils_unittest.h',
      'browser/ui/cocoa/applescript/bookmark_applescript_utils_unittest.mm',
      'browser/ui/cocoa/applescript/bookmark_folder_applescript_unittest.mm',
      'browser/ui/cocoa/applescript/bookmark_item_applescript_unittest.mm',
      'browser/ui/cocoa/autofill/autofill_bubble_controller_unittest.mm',
      'browser/ui/cocoa/autofill/autofill_pop_up_button_unittest.mm',
      'browser/ui/cocoa/autofill/autofill_textfield_unittest.mm',
      'browser/ui/cocoa/autofill/autofill_tooltip_controller_unittest.mm',
      'browser/ui/cocoa/autofill/down_arrow_popup_menu_cell_unittest.mm',
      'browser/ui/cocoa/autofill/layout_view_unittest.mm',
      'browser/ui/cocoa/autofill/password_generation_popup_view_cocoa_unittest.mm',
      'browser/ui/cocoa/autofill/save_card_bubble_view_unittest.mm',
      'browser/ui/cocoa/autofill/simple_grid_layout_unittest.mm',
      'browser/ui/cocoa/background_gradient_view_unittest.mm',
      'browser/ui/cocoa/base_bubble_controller_unittest.mm',
      'browser/ui/cocoa/bookmarks/bookmark_all_tabs_controller_unittest.mm',
      'browser/ui/cocoa/bookmarks/bookmark_bar_bridge_unittest.mm',
      'browser/ui/cocoa/bookmarks/bookmark_bar_controller_unittest.mm',
      'browser/ui/cocoa/bookmarks/bookmark_bar_folder_button_cell_unittest.mm',
      'browser/ui/cocoa/bookmarks/bookmark_bar_folder_controller_unittest.mm',
      'browser/ui/cocoa/bookmarks/bookmark_bar_folder_hover_state_unittest.mm',
      'browser/ui/cocoa/bookmarks/bookmark_bar_folder_view_unittest.mm',
      'browser/ui/cocoa/bookmarks/bookmark_bar_folder_window_unittest.mm',
      'browser/ui/cocoa/bookmarks/bookmark_bar_toolbar_view_unittest.mm',
      'browser/ui/cocoa/bookmarks/bookmark_bar_unittest_helper.h',
      'browser/ui/cocoa/bookmarks/bookmark_bar_unittest_helper.mm',
      'browser/ui/cocoa/bookmarks/bookmark_bar_view_cocoa_unittest.mm',
      'browser/ui/cocoa/bookmarks/bookmark_bubble_controller_unittest.mm',
      'browser/ui/cocoa/bookmarks/bookmark_button_cell_unittest.mm',
      'browser/ui/cocoa/bookmarks/bookmark_button_unittest.mm',
      'browser/ui/cocoa/bookmarks/bookmark_editor_base_controller_unittest.mm',
      'browser/ui/cocoa/bookmarks/bookmark_editor_controller_unittest.mm',
      'browser/ui/cocoa/bookmarks/bookmark_folder_target_unittest.mm',
      'browser/ui/cocoa/bookmarks/bookmark_menu_bridge_unittest.mm',
      'browser/ui/cocoa/bookmarks/bookmark_menu_cocoa_controller_unittest.mm',
      'browser/ui/cocoa/bookmarks/bookmark_model_observer_for_cocoa_unittest.mm',
      'browser/ui/cocoa/bookmarks/bookmark_name_folder_controller_unittest.mm',
      'browser/ui/cocoa/bookmarks/bookmark_tree_browser_cell_unittest.mm',
      'browser/ui/cocoa/browser/zoom_bubble_controller_unittest.mm',
      'browser/ui/cocoa/browser_window_cocoa_unittest.mm',
      'browser/ui/cocoa/browser_window_controller_unittest.mm',
      'browser/ui/cocoa/browser_window_layout_unittest.mm',
      'browser/ui/cocoa/browser_window_utils_unittest.mm',
      'browser/ui/cocoa/bubble_view_unittest.mm',
      'browser/ui/cocoa/chrome_browser_window_unittest.mm',
      'browser/ui/cocoa/clickhold_button_cell_unittest.mm',
      'browser/ui/cocoa/cocoa_profile_test.h',
      'browser/ui/cocoa/cocoa_profile_test.mm',
      'browser/ui/cocoa/confirm_bubble_controller_unittest.mm',
      'browser/ui/cocoa/confirm_quit_panel_controller_unittest.mm',
      'browser/ui/cocoa/constrained_window/constrained_window_alert_unittest.mm',
      'browser/ui/cocoa/constrained_window/constrained_window_button_unittest.mm',
      'browser/ui/cocoa/constrained_window/constrained_window_custom_window_unittest.mm',
      'browser/ui/cocoa/constrained_window/constrained_window_sheet_controller_unittest.mm',
      'browser/ui/cocoa/content_settings/collected_cookies_mac_unittest.mm',
      'browser/ui/cocoa/content_settings/cookie_details_unittest.mm',
      'browser/ui/cocoa/content_settings/cookie_details_view_controller_unittest.mm',
      'browser/ui/cocoa/custom_frame_view_unittest.mm',
      'browser/ui/cocoa/download/download_item_button_unittest.mm',
      'browser/ui/cocoa/download/download_item_cell_unittest.mm',
      'browser/ui/cocoa/download/download_item_controller_unittest.mm',
      'browser/ui/cocoa/download/download_shelf_controller_unittest.mm',
      'browser/ui/cocoa/download/download_shelf_mac_unittest.mm',
      'browser/ui/cocoa/download/download_shelf_view_cocoa_unittest.mm',
      'browser/ui/cocoa/download/download_util_mac_unittest.mm',
      'browser/ui/cocoa/draggable_button_unittest.mm',
      'browser/ui/cocoa/extensions/browser_actions_container_view_unittest.mm',
      'browser/ui/cocoa/extensions/chooser_dialog_cocoa_controller_unittest.mm',
      'browser/ui/cocoa/extensions/extension_install_prompt_test_utils.h',
      'browser/ui/cocoa/extensions/extension_install_prompt_test_utils.mm',
      'browser/ui/cocoa/extensions/extension_install_view_controller_unittest.mm',
      'browser/ui/cocoa/extensions/extension_installed_bubble_controller_unittest.mm',
      'browser/ui/cocoa/extensions/media_galleries_dialog_cocoa_unittest.mm',
      'browser/ui/cocoa/extensions/toolbar_actions_bar_bubble_mac_unittest.mm',
      'browser/ui/cocoa/find_bar/find_bar_bridge_unittest.mm',
      'browser/ui/cocoa/find_bar/find_bar_cocoa_controller_unittest.mm',
      'browser/ui/cocoa/find_bar/find_bar_text_field_cell_unittest.mm',
      'browser/ui/cocoa/find_bar/find_bar_text_field_unittest.mm',
      'browser/ui/cocoa/find_bar/find_bar_view_unittest.mm',
      'browser/ui/cocoa/find_pasteboard_unittest.mm',
      'browser/ui/cocoa/first_run_bubble_controller_unittest.mm',
      'browser/ui/cocoa/floating_bar_backing_view_unittest.mm',
      'browser/ui/cocoa/framed_browser_window_unittest.mm',
      'browser/ui/cocoa/fullscreen_low_power_coordinator_unittest.mm',
      'browser/ui/cocoa/fullscreen_window_unittest.mm',
      'browser/ui/cocoa/gradient_button_cell_unittest.mm',
      'browser/ui/cocoa/history_menu_bridge_unittest.mm',
      'browser/ui/cocoa/history_menu_cocoa_controller_unittest.mm',
      'browser/ui/cocoa/history_overlay_controller_unittest.mm',
      'browser/ui/cocoa/hover_close_button_unittest.mm',
      'browser/ui/cocoa/hung_renderer_controller_unittest.mm',
      'browser/ui/cocoa/image_button_cell_unittest.mm',
      'browser/ui/cocoa/info_bubble_view_unittest.mm',
      'browser/ui/cocoa/info_bubble_window_unittest.mm',
      'browser/ui/cocoa/infobars/confirm_infobar_controller_unittest.mm',
      'browser/ui/cocoa/infobars/infobar_container_controller_unittest.mm',
      'browser/ui/cocoa/infobars/infobar_gradient_view_unittest.mm',
      'browser/ui/cocoa/infobars/mock_confirm_infobar_delegate.cc',
      'browser/ui/cocoa/infobars/mock_confirm_infobar_delegate.h',
      'browser/ui/cocoa/infobars/translate_infobar_unittest.mm',
      'browser/ui/cocoa/location_bar/autocomplete_text_field_cell_unittest.mm',
      'browser/ui/cocoa/location_bar/autocomplete_text_field_editor_unittest.mm',
      'browser/ui/cocoa/location_bar/autocomplete_text_field_unittest.mm',
      'browser/ui/cocoa/location_bar/autocomplete_text_field_unittest_helper.mm',
      'browser/ui/cocoa/location_bar/ev_bubble_decoration_unittest.mm',
      'browser/ui/cocoa/location_bar/image_decoration_unittest.mm',
      'browser/ui/cocoa/location_bar/keyword_hint_decoration_unittest.mm',
      'browser/ui/cocoa/location_bar/manage_passwords_decoration_unittest.mm',
      'browser/ui/cocoa/location_bar/selected_keyword_decoration_unittest.mm',
      'browser/ui/cocoa/location_bar/zoom_decoration_unittest.mm',
      'browser/ui/cocoa/media_picker/desktop_media_picker_controller_deprecated_unittest.mm',
      'browser/ui/cocoa/media_picker/desktop_media_picker_controller_unittest.mm',
      'browser/ui/cocoa/menu_button_unittest.mm',
      'browser/ui/cocoa/notifications/notification_builder_mac_unittest.mm',
      'browser/ui/cocoa/notifications/notification_response_builder_mac_unittest.mm',
      'browser/ui/cocoa/nsmenuitem_additions_unittest.mm',
      'browser/ui/cocoa/omnibox/omnibox_popup_cell_unittest.mm',
      'browser/ui/cocoa/omnibox/omnibox_popup_matrix_unittest.mm',
      'browser/ui/cocoa/omnibox/omnibox_popup_separator_view_unittest.mm',
      'browser/ui/cocoa/omnibox/omnibox_popup_view_mac_unittest.mm',
      'browser/ui/cocoa/omnibox/omnibox_view_mac_unittest.mm',
      'browser/ui/cocoa/passwords/account_chooser_view_controller_unittest.mm',
      'browser/ui/cocoa/passwords/autosignin_prompt_view_controller_unittest.mm',
      'browser/ui/cocoa/passwords/base_passwords_controller_test.h',
      'browser/ui/cocoa/passwords/base_passwords_controller_test.mm',
      'browser/ui/cocoa/passwords/confirmation_password_saved_view_controller_unittest.mm',
      'browser/ui/cocoa/passwords/manage_passwords_view_controller_unittest.mm',
      'browser/ui/cocoa/passwords/passwords_bubble_cocoa_unittest.mm',
      'browser/ui/cocoa/passwords/passwords_bubble_controller_unittest.mm',
      'browser/ui/cocoa/passwords/passwords_list_view_controller_unittest.mm',
      'browser/ui/cocoa/passwords/save_pending_password_view_controller_unittest.mm',
      'browser/ui/cocoa/passwords/signin_promo_view_controller_unittest.mm',
      'browser/ui/cocoa/passwords/update_pending_password_view_controller_unittest.mm',
      'browser/ui/cocoa/profiles/avatar_button_controller_unittest.mm',
      'browser/ui/cocoa/profiles/avatar_button_unittest.mm',
      'browser/ui/cocoa/profiles/avatar_icon_controller_unittest.mm',
      'browser/ui/cocoa/profiles/avatar_menu_bubble_controller_unittest.mm',
      'browser/ui/cocoa/profiles/profile_chooser_controller_unittest.mm',
      'browser/ui/cocoa/profiles/profile_menu_controller_unittest.mm',
      'browser/ui/cocoa/profiles/user_manager_mac_unittest.mm',
      'browser/ui/cocoa/run_loop_testing_unittest.mm',
      'browser/ui/cocoa/screen_capture_notification_ui_cocoa_unittest.mm',
      'browser/ui/cocoa/spinner_view_unittest.mm',
      'browser/ui/cocoa/sprite_view_unittest.mm',
      'browser/ui/cocoa/status_bubble_mac_unittest.mm',
      'browser/ui/cocoa/status_icons/status_icon_mac_unittest.mm',
      'browser/ui/cocoa/styled_text_field_cell_unittest.mm',
      'browser/ui/cocoa/styled_text_field_test_helper.h',
      'browser/ui/cocoa/styled_text_field_test_helper.mm',
      'browser/ui/cocoa/styled_text_field_unittest.mm',
      'browser/ui/cocoa/tab_contents/sad_tab_controller_unittest.mm',
      'browser/ui/cocoa/tab_contents/sad_tab_view_cocoa_unittest.mm',
      'browser/ui/cocoa/tabs/alert_indicator_button_cocoa_unittest.mm',
      'browser/ui/cocoa/tabs/tab_controller_unittest.mm',
      'browser/ui/cocoa/tabs/tab_strip_controller_unittest.mm',
      'browser/ui/cocoa/tabs/tab_strip_view_unittest.mm',
      'browser/ui/cocoa/tabs/tab_view_unittest.mm',
      'browser/ui/cocoa/toolbar/app_toolbar_button_cell_unittest.mm',
      'browser/ui/cocoa/toolbar/reload_button_unittest.mm',
      'browser/ui/cocoa/toolbar/toolbar_button_unittest.mm',
      'browser/ui/cocoa/toolbar/toolbar_controller_unittest.mm',
      'browser/ui/cocoa/toolbar/toolbar_view_unittest.mm',
      'browser/ui/cocoa/translate/translate_bubble_controller_unittest.mm',
      'browser/ui/cocoa/url_drop_target_unittest.mm',
      'browser/ui/cocoa/validation_message_bubble_controller_unittest.mm',
      'browser/ui/cocoa/vertical_gradient_view_unittest.mm',
      'browser/ui/cocoa/view_resizer_pong.h',
      'browser/ui/cocoa/view_resizer_pong.mm',
      'browser/ui/cocoa/website_settings/permission_bubble_controller_unittest.mm',
      'browser/ui/cocoa/website_settings/permission_selector_button_unittest.mm',
      'browser/ui/cocoa/website_settings/website_settings_bubble_controller_unittest.mm',
      'browser/ui/cocoa/window_size_autosaver_unittest.mm',
    ],
    # Cross-platform views unit tests ready for toolkit-views on Mac.
    # TODO(tapted): Enable toolkit-views unit_tests on Mac when their
    # respective implementations are linked in. http://crbug.com/412234.
    'chrome_unit_tests_views_sources': [
      '../ui/views/controls/webview/webview_unittest.cc',
      'browser/ui/views/apps/app_info_dialog/app_info_dialog_views_unittest.cc',
      'browser/ui/views/apps/app_info_dialog/app_info_permissions_panel_unittest.cc',
      'browser/ui/views/website_settings/website_settings_popup_view_unittest.cc',
    ],
    # Views unit_tests for everywhere but ChromeOS.
    'chrome_unit_tests_views_non_chromeos_sources': [
      'browser/ui/views/frame/opaque_browser_frame_view_layout_unittest.cc',
      'browser/ui/views/sync/one_click_signin_dialog_view_unittest.cc',
    ],
    # Cross-platform (except Mac) views unit tests.
    'chrome_unit_tests_views_non_mac_sources': [
      'browser/ui/views/accelerator_table_unittest.cc',
      'browser/ui/views/apps/shaped_app_window_targeter_unittest.cc',
      'browser/ui/views/bookmarks/bookmark_bar_view_unittest.cc',
      'browser/ui/views/bookmarks/bookmark_bubble_view_unittest.cc',
      'browser/ui/views/bookmarks/bookmark_context_menu_unittest.cc',
      'browser/ui/views/bookmarks/bookmark_editor_view_unittest.cc',
      'browser/ui/views/bookmarks/bookmark_menu_delegate_unittest.cc',
      'browser/ui/views/chooser_content_view_unittest.cc',
      'browser/ui/views/confirm_bubble_views_unittest.cc',
      'browser/ui/views/crypto_module_password_dialog_view_unittest.cc',
      'browser/ui/views/desktop_capture/desktop_media_picker_views_unittest.cc',
      'browser/ui/views/desktop_media_picker_views_deprecated_unittest.cc',
      'browser/ui/views/extensions/chooser_dialog_view_unittest.cc',
      'browser/ui/views/extensions/media_galleries_dialog_views_unittest.cc',
      'browser/ui/views/first_run_bubble_unittest.cc',
      'browser/ui/views/frame/browser_view_layout_unittest.cc',
      'browser/ui/views/frame/browser_view_unittest.cc',
      'browser/ui/views/frame/test_with_browser_view.cc',
      'browser/ui/views/frame/test_with_browser_view.h',
      'browser/ui/views/frame/web_contents_close_handler_unittest.cc',
      'browser/ui/views/location_bar/icon_label_bubble_view_unittest.cc',
      'browser/ui/views/omnibox/omnibox_view_views_unittest.cc',
      'browser/ui/views/status_icons/status_tray_win_unittest.cc',
      'browser/ui/views/sync/bubble_sync_promo_view_unittest.cc',
      'browser/ui/views/tab_contents/chrome_web_contents_view_delegate_views_unittest.cc',
      'browser/ui/views/tabs/alert_indicator_button_unittest.cc',
      'browser/ui/views/tabs/fake_base_tab_strip_controller.cc',
      'browser/ui/views/tabs/fake_base_tab_strip_controller.h',
      'browser/ui/views/tabs/stacked_tab_strip_layout_unittest.cc',
      'browser/ui/views/tabs/tab_strip_layout_unittest.cc',
      'browser/ui/views/tabs/tab_strip_unittest.cc',
      'browser/ui/views/tabs/tab_unittest.cc',
      'browser/ui/views/toolbar/reload_button_unittest.cc',
      'browser/ui/views/toolbar/toolbar_action_view_unittest.cc',
      'browser/ui/views/toolbar/toolbar_actions_bar_bubble_views_unittest.cc',
      'browser/ui/views/translate/translate_bubble_view_unittest.cc',
    ],
    'chrome_unit_tests_win_sources': [
      'app/chrome_dll.rc',
      'browser/ui/input_method/input_method_engine_unittest.cc',
      'test/data/resource.rc',
    ],
    'chrome_unit_tests_win_mac_sources': [
      'browser/media_galleries/fileapi/itunes_file_util_unittest.cc',
      'browser/media_galleries/fileapi/picasa_file_util_unittest.cc',
      'utility/media_galleries/itunes_library_parser_unittest.cc',
      'utility/media_galleries/picasa_album_table_reader_unittest.cc',
      'utility/media_galleries/picasa_albums_indexer_unittest.cc',
      'utility/media_galleries/pmp_column_reader_unittest.cc',
    ],
    'chrome_unit_tests_themes_sources': [
      'browser/themes/browser_theme_pack_unittest.cc',
      'browser/themes/theme_properties_unittest.cc',
      'browser/themes/theme_service_unittest.cc',
      'browser/themes/theme_syncable_service_unittest.cc',
      'browser/ui/webui/theme_source_unittest.cc',
    ],
    'chrome_unit_tests_supervised_user_sources': [
      'browser/content_settings/content_settings_supervised_provider_unittest.cc',
      'browser/supervised_user/child_accounts/family_info_fetcher_unittest.cc',
      'browser/supervised_user/child_accounts/permission_request_creator_apiary_unittest.cc',
      'browser/supervised_user/experimental/safe_search_url_reporter_unittest.cc',
      'browser/supervised_user/experimental/supervised_user_async_url_checker_unittest.cc',
      'browser/supervised_user/supervised_user_bookmarks_handler_unittest.cc',
      'browser/supervised_user/supervised_user_pref_store_unittest.cc',
      'browser/supervised_user/supervised_user_service_unittest.cc',
      'browser/supervised_user/supervised_user_settings_service_unittest.cc',
      'browser/supervised_user/supervised_user_url_filter_unittest.cc',
      'browser/supervised_user/supervised_user_whitelist_service_unittest.cc',
    ],
    # TODO(bauerb): This code should be removed (on desktop) once child account
    # support has launched (https://crbug.com/505443).
    'chrome_unit_tests_supervised_user_legacy_sources': [
      'browser/supervised_user/legacy/supervised_user_pref_mapping_service_unittest.cc',
      'browser/supervised_user/legacy/supervised_user_refresh_token_fetcher_unittest.cc',
      'browser/supervised_user/legacy/supervised_user_registration_utility_unittest.cc',
      'browser/supervised_user/legacy/supervised_user_shared_settings_service_unittest.cc',
      'browser/supervised_user/legacy/supervised_user_shared_settings_update_unittest.cc',
      'browser/supervised_user/legacy/supervised_user_sync_service_unittest.cc',
    ],
    'chrome_unit_tests_media_router_sources': [
      'browser/media/router/create_presentation_connection_request_unittest.cc',
      'browser/media/router/issue_manager_unittest.cc',
      'browser/media/router/issue_unittest.cc',
      'browser/media/router/media_route_unittest.cc',
      'browser/media/router/media_router_factory_unittest.cc',
      'browser/media/router/media_sink_unittest.cc',
      'browser/media/router/media_sinks_observer_unittest.cc',
      'browser/media/router/media_source_helper_unittest.cc',
      'browser/media/router/media_source_unittest.cc',
      'browser/media/router/presentation_media_sinks_observer_unittest.cc',
      'browser/media/router/presentation_request_unittest.cc',
      'browser/media/router/presentation_service_delegate_impl_unittest.cc',
    ],
    'chrome_unit_tests_media_router_non_android_sources': [
      'browser/media/router/mojo/media_router_mojo_impl_unittest.cc',
      'browser/media/router/mojo/media_router_mojo_metrics_unittest.cc',
      'browser/media/router/mojo/media_router_type_converters_unittest.cc',
      'browser/ui/toolbar/media_router_action_unittest.cc',
      'browser/ui/toolbar/media_router_contextual_menu_unittest.cc',
      'browser/ui/webui/media_router/media_cast_mode_unittest.cc',
      'browser/ui/webui/media_router/media_router_dialog_controller_impl_unittest.cc',
      'browser/ui/webui/media_router/media_router_test.cc',
      'browser/ui/webui/media_router/media_router_test.h',
      'browser/ui/webui/media_router/media_router_ui_unittest.cc',
      'browser/ui/webui/media_router/media_router_webui_message_handler_unittest.cc',
      'browser/ui/webui/media_router/query_result_manager_unittest.cc',
    ],
    # Everything but Android and iOS (iOS is handled separately).
    'chrome_unit_tests_non_android_sources': [
      # Bookmark export/import are handled via the BookmarkColumns
      # ContentProvider.
      'browser/bookmarks/bookmark_html_writer_unittest.cc',
      'browser/browser_commands_unittest.cc',
      'browser/diagnostics/diagnostics_controller_unittest.cc',
      'browser/diagnostics/diagnostics_model_unittest.cc',
      'browser/download/download_commands_unittest.cc',
      'browser/download/download_shelf_unittest.cc',
      'browser/first_run/first_run_unittest.cc',
      'browser/font_family_cache_unittest.cc',
      'browser/importer/firefox_profile_lock_unittest.cc',
      'browser/importer/profile_writer_unittest.cc',
      'browser/media/combined_desktop_media_list_unittest.cc',
      'browser/media/tab_desktop_media_list_unittest.cc',
      'browser/media_galleries/fileapi/native_media_file_util_unittest.cc',
      'browser/media_galleries/gallery_watch_manager_unittest.cc',
      'browser/media_galleries/linux/mtp_device_object_enumerator_unittest.cc',
      'browser/media_galleries/mac/mtp_device_delegate_impl_mac_unittest.mm',
      'browser/media_galleries/media_file_system_registry_unittest.cc',
      'browser/media_galleries/media_galleries_dialog_controller_mock.cc',
      'browser/media_galleries/media_galleries_dialog_controller_mock.h',
      'browser/media_galleries/media_galleries_dialog_controller_test_util.cc',
      'browser/media_galleries/media_galleries_dialog_controller_test_util.h',
      'browser/media_galleries/media_galleries_permission_controller_unittest.cc',
      'browser/media_galleries/media_galleries_permissions_unittest.cc',
      'browser/media_galleries/media_galleries_preferences_unittest.cc',
      'browser/media_galleries/win/mtp_device_delegate_impl_win_unittest.cc',
      'browser/media_galleries/win/mtp_device_object_enumerator_unittest.cc',
      'browser/memory/tab_manager_delegate_chromeos_unittest.cc',
      'browser/memory/tab_manager_unittest.cc',
      'browser/memory/tab_manager_web_contents_data_unittest.cc',
      'browser/net/firefox_proxy_settings_unittest.cc',
      'browser/permissions/permission_request_manager_unittest.cc',
      'browser/platform_util_unittest.cc',
      'browser/power/process_power_collector_unittest.cc',
      'browser/process_singleton_posix_unittest.cc',
      'browser/profile_resetter/profile_resetter_unittest.cc',
      'browser/profile_resetter/triggered_profile_resetter_win_unittest.cc',
      'browser/renderer_context_menu/render_view_context_menu_unittest.cc',
      'browser/search/instant_service_unittest.cc',
      'browser/search/instant_unittest_base.cc',
      'browser/search/instant_unittest_base.h',
      'browser/search/search_unittest.cc',
      # GCMDriverAndroid is not yet implemented.
      'browser/services/gcm/gcm_profile_service_unittest.cc',
      'browser/sessions/persistent_tab_restore_service_unittest.cc',
      'browser/sync/sessions/sessions_sync_manager_unittest.cc',
      'browser/sync/sync_ui_util_unittest.cc',  # Sync setup uses native ui.
      'browser/translate/translate_manager_render_view_host_unittest.cc',
      # The autofill popup is implemented in mostly native code on Android.
      'browser/ui/autofill/autofill_popup_controller_unittest.cc',
      'browser/ui/bookmarks/bookmark_context_menu_controller_unittest.cc',
      'browser/ui/bookmarks/bookmark_unittest.cc',
      'browser/ui/browser_close_unittest.cc',
      'browser/ui/browser_command_controller_unittest.cc',
      'browser/ui/browser_instant_controller_unittest.cc',
      'browser/ui/browser_unittest.cc',
      'browser/ui/chrome_bubble_manager_unittest.cc',
      'browser/ui/content_settings/content_setting_bubble_model_unittest.cc',
      'browser/ui/content_settings/content_setting_image_model_unittest.cc',
      'browser/ui/exclusive_access/fullscreen_controller_state_unittest.cc',
      'browser/ui/extensions/extension_action_view_controller_unittest.cc',
      'browser/ui/global_error/global_error_service_unittest.cc',
      'browser/ui/omnibox/clipboard_utils_unittest.cc',
      'browser/ui/omnibox/omnibox_controller_unittest.cc',
      'browser/ui/passwords/manage_passwords_bubble_model_unittest.cc',
      'browser/ui/passwords/manage_passwords_view_utils_desktop_unittest.cc',
      'browser/ui/passwords/password_dialog_controller_impl_unittest.cc',
      'browser/ui/search/instant_search_prerenderer_unittest.cc',
      'browser/ui/search/instant_tab_unittest.cc',
      'browser/ui/search/search_delegate_unittest.cc',
      'browser/ui/search/search_ipc_router_policy_unittest.cc',
      'browser/ui/search/search_ipc_router_unittest.cc',
      'browser/ui/search/search_model_unittest.cc',
      'browser/ui/search/search_tab_helper_unittest.cc',
      'browser/ui/tab_contents/tab_contents_iterator_unittest.cc',
      'browser/ui/tabs/pinned_tab_codec_unittest.cc',
      'browser/ui/tabs/pinned_tab_service_unittest.cc',
      'browser/ui/tabs/pinned_tab_test_utils.cc',
      'browser/ui/tabs/tab_menu_model_unittest.cc',
      'browser/ui/tabs/tab_strip_model_stats_recorder_unittest.cc',
      'browser/ui/tabs/tab_strip_model_unittest.cc',
      'browser/ui/tabs/test_tab_strip_model_delegate.cc',
      'browser/ui/tabs/test_tab_strip_model_delegate.h',
      'browser/ui/toolbar/app_menu_icon_painter_unittest.cc',
      'browser/ui/toolbar/app_menu_model_unittest.cc',
      'browser/ui/toolbar/back_forward_menu_model_unittest.cc',
      'browser/ui/toolbar/encoding_menu_controller_unittest.cc',
      'browser/ui/toolbar/mock_component_toolbar_actions_factory.cc',
      'browser/ui/toolbar/mock_component_toolbar_actions_factory.h',
      'browser/ui/toolbar/recent_tabs_builder_test_helper.cc',
      'browser/ui/toolbar/recent_tabs_builder_test_helper.h',
      'browser/ui/toolbar/recent_tabs_sub_menu_model_unittest.cc',
      'browser/ui/toolbar/test_toolbar_actions_bar_bubble_delegate.cc',
      'browser/ui/toolbar/test_toolbar_actions_bar_bubble_delegate.h',
      'browser/ui/toolbar/toolbar_actions_bar_unittest.cc',
      'browser/ui/toolbar/toolbar_actions_bar_unittest.h',
      'browser/ui/toolbar/toolbar_actions_model_unittest.cc',
      'browser/ui/toolbar/toolbar_model_unittest.cc',
      'browser/ui/website_settings/permission_menu_model_unittest.cc',
      'browser/ui/webui/help/version_updater_chromeos_unittest.cc',
      'browser/ui/webui/md_downloads/downloads_list_tracker_unittest.cc',
      'browser/ui/webui/md_downloads/md_downloads_dom_handler_unittest.cc',
      'browser/ui/webui/ntp/ntp_user_data_logger_unittest.cc',
      'browser/ui/webui/options/autofill_options_handler_unittest.cc',
      'browser/ui/webui/options/language_options_handler_unittest.cc',
      'browser/ui/webui/options/password_manager_handler_unittest.cc',
      'browser/ui/webui/options/pepper_flash_content_settings_utils_unittest.cc',
      'browser/ui/webui/options/sync_setup_handler_unittest.cc',
      'browser/ui/webui/settings/metrics_reporting_handler_unittest.cc',
      'browser/ui/webui/settings/people_handler_unittest.cc',
      'browser/ui/webui/settings/profile_info_handler_unittest.cc',
      'browser/ui/webui/settings/reset_settings_handler_unittest.cc',
      'browser/ui/webui/settings/settings_manage_profile_handler_unittest.cc',
      'browser/ui/webui/settings/site_settings_handler_unittest.cc',
      'browser/ui/webui/settings_utils_unittest.cc',
      'browser/ui/webui/signin/login_ui_service_unittest.cc',
      'browser/ui/webui/sync_internals_message_handler_unittest.cc',
      'browser/ui/webui/web_dialog_web_contents_delegate_unittest.cc',
      'browser/ui/window_sizer/window_sizer_common_unittest.cc',
      'browser/ui/window_sizer/window_sizer_unittest.cc',
      'browser/ui/zoom/zoom_controller_unittest.cc',
      'browser/usb/usb_chooser_context_unittest.cc',
      'browser/usb/usb_chooser_controller_unittest.cc',
      'browser/usb/web_usb_detector_unittest.cc',
      # The importer code is not used on Android.
      'common/importer/firefox_importer_utils_unittest.cc',
      # No service process (which also requires multiprocess lock).
      'common/multi_process_lock_unittest.cc',
      'test/base/browser_with_test_window_test.cc',
      'test/base/browser_with_test_window_test.h',
      'utility/importer/bookmark_html_reader_unittest.cc',
      'utility/importer/bookmarks_file_importer_unittest.cc',
      'utility/importer/edge_database_reader_unittest_win.cc',
      'utility/importer/firefox_importer_unittest.cc',
      'utility/importer/firefox_importer_unittest_messages_internal.h',
      'utility/importer/firefox_importer_unittest_utils.h',
      'utility/importer/firefox_importer_unittest_utils_mac.cc',
      'utility/importer/safari_importer_unittest.mm',
    ],
    # Everything but Android, ChromeOS and iOS (iOS is handled separately).
    'chrome_unit_tests_non_android_or_chromeos_sources': [
      'browser/media/native_desktop_media_list_unittest.cc',
      'browser/metrics/desktop_engagement/desktop_engagement_service_unittest.cc',
      'browser/signin/cross_device_promo_unittest.cc',
      'browser/signin/signin_global_error_unittest.cc',
      'browser/sync/sync_global_error_unittest.cc',
      'browser/ui/webui/signin/signin_create_profile_handler_unittest.cc',
      'browser/ui/webui/signin/sync_confirmation_handler_unittest.cc',
      'browser/upgrade_detector_impl_unittest.cc',
    ],
    'chrome_unit_tests_app_list_sources': [
      'browser/apps/drive/drive_app_mapping_unittest.cc',
      'browser/ui/app_list/app_context_menu_unittest.cc',
      'browser/ui/app_list/app_list_positioner_unittest.cc',
      'browser/ui/app_list/app_list_service_unittest.cc',
      'browser/ui/app_list/app_list_test_util.cc',
      'browser/ui/app_list/app_list_test_util.h',
      'browser/ui/app_list/extension_app_model_builder_unittest.cc',
      'browser/ui/app_list/model_pref_updater_unittest.cc',
      'browser/ui/app_list/profile_loader_unittest.cc',
      'browser/ui/app_list/search/app_search_provider_unittest.cc',
      'browser/ui/app_list/search/history_unittest.cc',
      'browser/ui/app_list/search/omnibox_result_unittest.cc',
      'browser/ui/app_list/search/suggestions/suggestions_search_provider_unittest.cc',
      'browser/ui/app_list/speech_auth_helper_unittest.cc',
      'browser/ui/app_list/test/fake_profile.cc',
      'browser/ui/app_list/test/fake_profile.h',
      'browser/ui/app_list/test/fake_profile_store.cc',
      'browser/ui/app_list/test/fake_profile_store.h',
      'browser/ui/app_list/test/fast_show_pickler_unittest.cc',
      'browser/ui/views/app_list/linux/app_list_linux_unittest.cc',
    ],
    # ChromeOS only sources of app_list.
    'chrome_unit_tests_app_list_chromeos_sources': [
      'browser/ui/app_list/arc/arc_app_test.cc',
      'browser/ui/app_list/arc/arc_app_test.h',
      'browser/ui/app_list/arc/arc_app_unittest.cc',
      'browser/ui/app_list/search/launcher_search/launcher_search_icon_image_loader_unittest.cc',
      'browser/ui/views/apps/app_info_dialog/app_info_dialog_ash_unittest.cc',
    ],
    'chrome_unit_tests_arc_sources': [
      'browser/chromeos/arc/arc_auth_service_unittest.cc',
      'browser/chromeos/arc/arc_policy_bridge_unittest.cc',
      'browser/ui/views/intent_picker_bubble_view_unittest.cc',
    ],
    # Sources for Offline pages. For now only for Android.
    'chrome_unit_tests_offline_pages_sources': [
      'browser/android/offline_pages/offline_page_mhtml_archiver_unittest.cc',
      'browser/android/offline_pages/offline_page_request_job_unittest.cc',
      'browser/android/offline_pages/offline_page_utils_unittest.cc',
      'browser/android/offline_pages/prerender_adapter_unittest.cc',
      'browser/android/offline_pages/prerendering_loader_unittest.cc',
      'browser/android/offline_pages/prerendering_offliner_unittest.cc',
      'browser/android/offline_pages/recent_tab_helper_unittest.cc',
      'browser/android/offline_pages/request_coordinator_factory_unittest.cc',
      'browser/android/offline_pages/test_offline_page_model_builder.cc',
      'browser/android/offline_pages/test_offline_page_model_builder.h',
    ],
  },
  'targets': [
    {
      # This target contains mocks and test utilities that don't belong in
      # production libraries but are used by more than one test executable.
      #
      # GN version: //chrome/test:test_support but that is split apart into
      # separate test_support targets for that various subdirectories under
      # chrome.
      'target_name': 'test_support_common',
      'type': 'static_library',
      'dependencies': [
        # NOTE: New dependencies should generally be added in the OS!="ios"
        # dependencies block below, rather than here.
        'browser',
        'chrome_features.gyp:chrome_common_features',
        'chrome_resources.gyp:chrome_resources',
        'chrome_resources.gyp:chrome_strings',
        'chrome_resources.gyp:theme_resources',
        'common',
        '../base/base.gyp:test_support_base',
        '../components/components.gyp:bookmarks_test_support',
        '../components/components.gyp:browser_sync_browser_test_support',
        '../components/components.gyp:gcm_driver_test_support',
        '../components/components.gyp:history_core_test_support',
        '../components/components.gyp:instance_id_test_support',
        '../components/components.gyp:invalidation_impl',
        '../components/components.gyp:invalidation_test_support',
        '../components/components.gyp:metrics_test_support',
        '../components/components.gyp:offline_pages_test_support',
        '../components/components.gyp:omnibox_test_support',
        '../components/components.gyp:password_manager_core_browser_test_support',
        '../components/components.gyp:policy_component_test_support',
        '../components/components.gyp:policy_test_support',
        '../components/components.gyp:pref_registry_test_support',
        '../components/components.gyp:rappor_test_support',
        '../components/components.gyp:search_engines_test_support',
        '../components/components.gyp:signin_core_browser_test_support',
        '../components/components.gyp:sync_sessions_test_support',
        '../components/components.gyp:syncable_prefs_test_support',
        '../components/components.gyp:toolbar_test_support',
        '../components/components.gyp:update_client_test_support',
        '../components/components.gyp:user_prefs_tracked_test_support',
        '../components/prefs/prefs.gyp:prefs_test_support',
        '../content/content.gyp:content_app_both',
        '../content/content_shell_and_tests.gyp:content_browser_test_base',
        '../content/content_shell_and_tests.gyp:test_support_content',
        '../net/net.gyp:net',
        '../net/net.gyp:net_test_support',
        '../skia/skia.gyp:skia',
        '../sql/sql.gyp:sql',
        '../sql/sql.gyp:test_support_sql',
        '../components/sync.gyp:sync',
        '../components/sync.gyp:test_support_sync_driver',
        '../testing/gmock.gyp:gmock',
        '../testing/gtest.gyp:gtest',
        '../third_party/zlib/zlib.gyp:zlib',
        '../ui/gfx/gfx.gyp:gfx_test_support',
        '../ui/message_center/message_center.gyp:message_center_test_support',
      ],
      'export_dependent_settings': [
        '../base/base.gyp:test_support_base',
        '../components/components.gyp:policy_component_test_support',
        '../components/components.gyp:policy_test_support',
        '../content/content_shell_and_tests.gyp:test_support_content',
      ],
      'include_dirs': [
        '..',
      ],
      'sources': [
        'app/chrome_main_delegate.cc',
        'app/chrome_main_delegate.h',
        'browser/browsing_data/mock_browsing_data_appcache_helper.cc',
        'browser/browsing_data/mock_browsing_data_appcache_helper.h',
        'browser/browsing_data/mock_browsing_data_cache_storage_helper.cc',
        'browser/browsing_data/mock_browsing_data_cache_storage_helper.h',
        'browser/browsing_data/mock_browsing_data_channel_id_helper.cc',
        'browser/browsing_data/mock_browsing_data_channel_id_helper.h',
        'browser/browsing_data/mock_browsing_data_cookie_helper.cc',
        'browser/browsing_data/mock_browsing_data_cookie_helper.h',
        'browser/browsing_data/mock_browsing_data_database_helper.cc',
        'browser/browsing_data/mock_browsing_data_database_helper.h',
        'browser/browsing_data/mock_browsing_data_file_system_helper.cc',
        'browser/browsing_data/mock_browsing_data_file_system_helper.h',
        'browser/browsing_data/mock_browsing_data_flash_lso_helper.cc',
        'browser/browsing_data/mock_browsing_data_flash_lso_helper.h',
        'browser/browsing_data/mock_browsing_data_indexed_db_helper.cc',
        'browser/browsing_data/mock_browsing_data_indexed_db_helper.h',
        'browser/browsing_data/mock_browsing_data_local_storage_helper.cc',
        'browser/browsing_data/mock_browsing_data_local_storage_helper.h',
        'browser/browsing_data/mock_browsing_data_quota_helper.cc',
        'browser/browsing_data/mock_browsing_data_quota_helper.h',
        'browser/browsing_data/mock_browsing_data_service_worker_helper.cc',
        'browser/browsing_data/mock_browsing_data_service_worker_helper.h',
        'browser/chooser_controller/mock_chooser_controller.cc',
        'browser/chooser_controller/mock_chooser_controller.h',
        'browser/download/download_test_file_activity_observer.cc',
        'browser/download/download_test_file_activity_observer.h',
        'browser/download/test_download_shelf.cc',
        'browser/download/test_download_shelf.h',
        'browser/media/fake_desktop_media_list.cc',
        'browser/media/fake_desktop_media_list.h',
        'browser/net/dns_probe_test_util.cc',
        'browser/net/dns_probe_test_util.h',
        'browser/net/url_request_mock_util.cc',
        'browser/net/url_request_mock_util.h',
        'browser/notifications/notification_test_util.cc',
        'browser/notifications/notification_test_util.h',
        'browser/notifications/stub_notification_platform_bridge.cc',
        'browser/notifications/stub_notification_platform_bridge.h',
        'browser/permissions/mock_permission_request.cc',
        'browser/permissions/mock_permission_request.h',
        'browser/policy/test/local_policy_test_server.cc',
        'browser/policy/test/local_policy_test_server.h',
        'browser/profile_resetter/profile_resetter_test_base.cc',
        'browser/profile_resetter/profile_resetter_test_base.h',
        'browser/search_engines/template_url_service_factory_test_util.cc',
        'browser/search_engines/template_url_service_factory_test_util.h',
        'browser/search_engines/template_url_service_test_util.cc',
        'browser/search_engines/template_url_service_test_util.h',
        'browser/sessions/session_restore_test_helper.cc',
        'browser/sessions/session_restore_test_helper.h',
        'browser/sessions/session_service_test_helper.cc',
        'browser/sessions/session_service_test_helper.h',
        'browser/signin/fake_account_fetcher_service_builder.cc',
        'browser/signin/fake_account_fetcher_service_builder.h',
        'browser/signin/fake_gaia_cookie_manager_service_builder.cc',
        'browser/signin/fake_gaia_cookie_manager_service_builder.h',
        'browser/signin/fake_profile_oauth2_token_service_builder.cc',
        'browser/signin/fake_profile_oauth2_token_service_builder.h',
        'browser/signin/fake_signin_manager_builder.cc',
        'browser/signin/fake_signin_manager_builder.h',
        'browser/ssl/ssl_client_auth_requestor_mock.cc',
        'browser/ssl/ssl_client_auth_requestor_mock.h',
        'browser/sync/profile_sync_test_util.cc',
        'browser/sync/profile_sync_test_util.h',
        'browser/ui/browser.h',
        'browser/ui/cocoa/cocoa_test_helper.h',
        'browser/ui/cocoa/cocoa_test_helper.mm',
        'browser/ui/cocoa/extensions/browser_action_test_util_mac.mm',
        'browser/ui/cocoa/find_bar/find_bar_host_unittest_util_cocoa.mm',
        'browser/ui/cocoa/run_loop_testing.h',
        'browser/ui/cocoa/run_loop_testing.mm',
        'browser/ui/exclusive_access/fullscreen_controller_state_test.cc',
        'browser/ui/exclusive_access/fullscreen_controller_state_test.h',
        'browser/ui/exclusive_access/fullscreen_controller_state_tests.h',
        'browser/ui/exclusive_access/fullscreen_controller_test.cc',
        'browser/ui/exclusive_access/fullscreen_controller_test.h',
        'browser/ui/find_bar/find_bar_host_unittest_util.h',
        'browser/ui/login/login_handler_test_utils.cc',
        'browser/ui/login/login_handler_test_utils.h',
        'browser/ui/passwords/manage_passwords_ui_controller_mock.cc',
        'browser/ui/passwords/manage_passwords_ui_controller_mock.h',
        'browser/ui/passwords/password_dialog_controller_mock.cc',
        'browser/ui/passwords/password_dialog_controller_mock.h',
        'browser/ui/test/test_confirm_bubble_model.cc',
        'browser/ui/test/test_confirm_bubble_model.h',
        'browser/ui/toolbar/test_toolbar_action_view_controller.cc',
        'browser/ui/toolbar/test_toolbar_action_view_controller.h',
        'browser/ui/views/find_bar_host_unittest_util_views.cc',
        'browser/ui/views/toolbar/browser_action_test_util_views.cc',
        'renderer/chrome_mock_render_thread.cc',
        'renderer/chrome_mock_render_thread.h',
        'renderer/safe_browsing/mock_feature_extractor_clock.cc',
        'renderer/safe_browsing/mock_feature_extractor_clock.h',
        'renderer/safe_browsing/test_utils.cc',
        'renderer/safe_browsing/test_utils.h',
        'test/base/chrome_process_util.cc',
        'test/base/chrome_process_util.h',
        'test/base/chrome_process_util_mac.cc',
        'test/base/chrome_render_view_host_test_harness.cc',
        'test/base/chrome_render_view_host_test_harness.h',
        'test/base/chrome_test_launcher.cc',
        'test/base/chrome_test_launcher.h',
        'test/base/chrome_test_suite.cc',
        'test/base/chrome_test_suite.h',
        'test/base/chrome_unit_test_suite.cc',
        'test/base/chrome_unit_test_suite.h',
        'test/base/dialog_test_browser_window.cc',
        'test/base/dialog_test_browser_window.h',
        'test/base/find_in_page_observer.cc',
        'test/base/find_in_page_observer.h',
        'test/base/scoped_browser_locale.cc',
        'test/base/scoped_browser_locale.h',
        'test/base/scoped_bundle_swizzler_mac.h',
        'test/base/scoped_bundle_swizzler_mac.mm',
        'test/base/scoped_testing_local_state.cc',
        'test/base/scoped_testing_local_state.h',
        'test/base/search_test_utils.cc',
        'test/base/search_test_utils.h',
        'test/base/test_browser_window.cc',
        'test/base/test_browser_window.h',
        'test/base/test_launcher_utils.cc',
        'test/base/test_launcher_utils.h',
        'test/base/test_switches.cc',
        'test/base/test_switches.h',
        'test/base/testing_browser_process.cc',
        'test/base/testing_browser_process.h',
        'test/base/testing_browser_process_platform_part.cc',
        'test/base/testing_browser_process_platform_part.h',
        'test/base/testing_io_thread_state.cc',
        'test/base/testing_io_thread_state.h',
        'test/base/testing_profile.cc',
        'test/base/testing_profile.h',
        'test/base/testing_profile_manager.cc',
        'test/base/testing_profile_manager.h',
        'test/base/tracing.cc',
        'test/base/tracing.h',
        'test/logging/win/file_logger.cc',
        'test/logging/win/file_logger.h',
        'test/logging/win/log_file_printer.cc',
        'test/logging/win/log_file_printer.h',
        'test/logging/win/log_file_reader.cc',
        'test/logging/win/log_file_reader.h',
        'test/logging/win/mof_data_parser.cc',
        'test/logging/win/mof_data_parser.h',
        'test/logging/win/test_log_collector.cc',
        'test/logging/win/test_log_collector.h',
      ],
      'conditions': [
        ['OS!="ios"', {
          'dependencies': [
            'child',
            'gpu',
            'renderer',
            'utility',
            '../content/content.gyp:content_gpu',
            '../content/content.gyp:content_ppapi_plugin',
            '../content/content.gyp:content_renderer',
            '../content/content.gyp:content_utility',
            '../components/components.gyp:autofill_core_test_support',
            '../components/components.gyp:captive_portal_test_support',
            '../components/components.gyp:gcm_driver_crypto_test_support',
            '../components/components.gyp:rappor_test_support',
            '../components/components.gyp:sessions_test_support',
            '../components/components.gyp:wallpaper',
            '../components/components.gyp:web_resource_test_support',
            '../google_apis/google_apis.gyp:google_apis_test_support',
            '../ipc/ipc.gyp:test_support_ipc',
            '../media/media.gyp:media_test_support',
            '../ppapi/ppapi_internal.gyp:ppapi_shared',
            '../sql/sql.gyp:test_support_sql',
            '../third_party/leveldatabase/leveldatabase.gyp:leveldatabase',
          ],
          'export_dependent_settings': [
            'renderer',
          ],
        }, {  # OS=="ios"
          'sources/': [
            # Exclude everything but iOS-specific files.
            ['exclude', '\\.(cc|mm)$'],
            ['include', '_ios\\.(cc|mm)$'],
            ['include', '(^|/)ios/'],
            # TODO(ios): Add files here as they are updated to compile on iOS.
            ['include', '^test/base/chrome_test_suite\\.cc$'],
            ['include', '^test/base/chrome_unit_test_suite\\.cc$'],
            ['include', '^test/base/testing_browser_process'],
          ],
        }],
        ['OS=="ios" or OS=="android"', {
          'sources!': [
            'browser/chooser_controller/mock_chooser_controller.cc',
            'browser/chooser_controller/mock_chooser_controller.h',
            'browser/permissions/mock_permission_request.cc',
            'browser/permissions/mock_permission_request.h',
            'browser/ui/passwords/manage_passwords_ui_controller_mock.cc',
            'browser/ui/passwords/manage_passwords_ui_controller_mock.h',
            'browser/ui/passwords/password_dialog_controller_mock.cc',
            'browser/ui/passwords/password_dialog_controller_mock.h',
          ]
        }],
        ['OS=="android"', {
          'dependencies!': [
            '../ui/message_center/message_center.gyp:message_center_test_support',
          ],
          'sources!': [
            'browser/download/test_download_shelf.cc',
            'browser/download/test_download_shelf.h',
            'browser/profile_resetter/profile_resetter_test_base.cc',
            'browser/profile_resetter/profile_resetter_test_base.h',
            'browser/sessions/session_restore_test_helper.cc',
            'browser/sessions/session_restore_test_helper.h',
            'browser/sessions/session_service_test_helper.cc',
            'browser/sessions/session_service_test_helper.h',
            'browser/ui/exclusive_access/fullscreen_controller_state_test.cc',
            'browser/ui/exclusive_access/fullscreen_controller_state_test.h',
            'browser/ui/exclusive_access/fullscreen_controller_state_tests.h',
            'browser/ui/exclusive_access/fullscreen_controller_test.cc',
            'browser/ui/exclusive_access/fullscreen_controller_test.h',
            'browser/ui/test/test_confirm_bubble_model.cc',
            'browser/ui/test/test_confirm_bubble_model.h',
            'renderer/safe_browsing/mock_feature_extractor_clock.cc',
            'renderer/safe_browsing/mock_feature_extractor_clock.h',
            'test/base/dialog_test_browser_window.cc',
            'test/base/dialog_test_browser_window.h',
            'test/base/test_browser_window.cc',
            'test/base/test_browser_window.h',
          ],
        }],
        ['chromeos==1', {
          'dependencies': [
            '../build/linux/system.gyp:dbus',
            '../chromeos/chromeos.gyp:chromeos_test_support',
            '../components/components.gyp:user_manager_test_support',
            '../third_party/icu/icu.gyp:icui18n',
          ],
          'sources': [
            # Note: sources list duplicated in GN build.
            'browser/chromeos/app_mode/fake_cws.cc',
            'browser/chromeos/app_mode/fake_cws.h',
            'browser/chromeos/file_manager/fake_disk_mount_manager.cc',
            'browser/chromeos/file_manager/fake_disk_mount_manager.h',
            'browser/chromeos/input_method/mock_candidate_window_controller.cc',
            'browser/chromeos/input_method/mock_candidate_window_controller.h',
            'browser/chromeos/input_method/mock_input_method_engine.cc',
            'browser/chromeos/input_method/mock_input_method_engine.h',
            'browser/chromeos/input_method/mock_input_method_manager.cc',
            'browser/chromeos/input_method/mock_input_method_manager.h',
            'browser/chromeos/login/screens/mock_device_disabled_screen_actor.cc',
            'browser/chromeos/login/screens/mock_device_disabled_screen_actor.h',
            'browser/chromeos/login/session/user_session_manager_test_api.cc',
            'browser/chromeos/login/session/user_session_manager_test_api.h',
            'browser/chromeos/login/test/js_checker.cc',
            'browser/chromeos/login/test/js_checker.h',
            'browser/chromeos/login/test/oobe_screen_waiter.cc',
            'browser/chromeos/login/test/oobe_screen_waiter.h',
            'browser/chromeos/login/ui/mock_login_display.cc',
            'browser/chromeos/login/ui/mock_login_display.h',
            'browser/chromeos/login/ui/mock_login_display_host.cc',
            'browser/chromeos/login/ui/mock_login_display_host.h',
            'browser/chromeos/login/users/avatar/mock_user_image_manager.cc',
            'browser/chromeos/login/users/avatar/mock_user_image_manager.h',
            'browser/chromeos/login/users/fake_chrome_user_manager.cc',
            'browser/chromeos/login/users/fake_chrome_user_manager.h',
            'browser/chromeos/login/users/fake_supervised_user_manager.cc',
            'browser/chromeos/login/users/fake_supervised_user_manager.h',
            'browser/chromeos/login/users/mock_user_manager.cc',
            'browser/chromeos/login/users/mock_user_manager.h',
            'browser/chromeos/net/network_portal_detector_test_utils.cc',
            'browser/chromeos/net/network_portal_detector_test_utils.h',
            'browser/chromeos/policy/cloud_external_data_manager_base_test_util.cc',
            'browser/chromeos/policy/cloud_external_data_manager_base_test_util.h',
            'browser/chromeos/policy/device_policy_builder.cc',
            'browser/chromeos/policy/device_policy_builder.h',
            'browser/chromeos/policy/fake_device_cloud_policy_initializer.cc',
            'browser/chromeos/policy/fake_device_cloud_policy_initializer.h',
            'browser/chromeos/policy/fake_device_cloud_policy_manager.cc',
            'browser/chromeos/policy/fake_device_cloud_policy_manager.h',
            'browser/chromeos/policy/stub_enterprise_install_attributes.cc',
            'browser/chromeos/policy/stub_enterprise_install_attributes.h',
            'browser/chromeos/settings/device_settings_test_helper.cc',
            'browser/chromeos/settings/device_settings_test_helper.h',
          ],
        }],
        ['use_aura==1', {
          'sources': [
            'test/base/test_browser_window_aura.cc',
            'test/base/test_browser_window_aura.h',
          ],
        }],
        ['use_ash==1', {
          'sources': [
            'test/base/default_ash_event_generator_delegate.cc',
            'test/base/default_ash_event_generator_delegate.h',
          ],
          'dependencies': [
            '../ash/ash.gyp:ash',
            '../ui/aura/aura.gyp:aura',
            '../ui/aura/aura.gyp:aura_test_support',
          ],
        }],
        ['safe_browsing==1', {
          'sources': [
            'browser/extensions/fake_safe_browsing_database_manager.cc',
            'browser/extensions/fake_safe_browsing_database_manager.h',
          ],
        }],
        ['OS=="linux"', {
          'dependencies': [
            '../build/linux/system.gyp:nss',
          ],
        }],
        ['enable_print_preview==1', {
          'dependencies': [
            'service',
          ],
        }],
        ['enable_extensions==1', {
          'dependencies': [
            '../components/components.gyp:drive_test_support',
            '../components/components.gyp:storage_monitor_test_support',
            '../extensions/extensions.gyp:extensions_test_support',
            'common/extensions/api/api.gyp:chrome_api',
          ],
          'sources': [
            'browser/extensions/api/messaging/native_messaging_test_util.cc',
            'browser/extensions/api/messaging/native_messaging_test_util.h',
            'browser/extensions/extension_action_test_util.cc',
            'browser/extensions/extension_action_test_util.h',
            'browser/extensions/mock_extension_special_storage_policy.cc',
            'browser/extensions/mock_extension_special_storage_policy.h',
            'browser/extensions/test_blacklist.cc',
            'browser/extensions/test_blacklist.h',
            'browser/extensions/test_blacklist_state_fetcher.cc',
            'browser/extensions/test_blacklist_state_fetcher.h',
            'browser/extensions/test_extension_dir.cc',
            'browser/extensions/test_extension_dir.h',
            'browser/extensions/test_extension_environment.cc',
            'browser/extensions/test_extension_environment.h',
            'browser/extensions/test_extension_prefs.cc',
            'browser/extensions/test_extension_prefs.h',
            'browser/extensions/test_extension_service.cc',
            'browser/extensions/test_extension_service.h',
            'browser/extensions/test_extension_system.cc',
            'browser/extensions/test_extension_system.h',
            'browser/media_galleries/media_galleries_test_util.cc',
            'browser/media_galleries/media_galleries_test_util.h',
            'common/extensions/extension_test_util.cc',
            'common/extensions/extension_test_util.h',
          ],
        }],
        ['OS=="win"', {
          'include_dirs': [
            '<(DEPTH)/third_party/wtl/include',
          ],
          'dependencies': [
            'chrome.gyp:install_static_util',
            '../components/components.gyp:crash_component',
            '../third_party/crashpad/crashpad/handler/handler.gyp:crashpad_handler',
          ],
          'sources': [
            'app/chrome_crash_reporter_client_win.cc',
          ],
        }],
        ['OS=="win" or OS=="mac"', {
          'sources': [
            'common/media_galleries/picasa_test_util.cc',
            'common/media_galleries/picasa_test_util.cc',
            'common/media_galleries/pmp_test_util.cc',
            'common/media_galleries/pmp_test_util.h',
          ],
        }],
        ['OS=="mac"', {
          'dependencies': [
            '../breakpad/breakpad.gyp:breakpad',
            '../components/components.gyp:crash_component',
            '../third_party/ocmock/ocmock.gyp:*',
          ],
          'sources': [
            'app/chrome_crash_reporter_client.cc',
            'app/chrome_crash_reporter_client_mac.mm',
            'app/chrome_main_mac.mm',
          ],
          'conditions': [
            ['mac_views_browser==1', {
              'sources!': [
                'browser/ui/cocoa/extensions/browser_action_test_util_mac.mm',
                'browser/ui/cocoa/find_bar/find_bar_host_unittest_util_cocoa.mm',
              ],
            }, {
              'sources!': [
                'browser/ui/views/find_bar_host_unittest_util_views.cc',
                'browser/ui/views/toolbar/browser_action_test_util_views.cc',
              ],
            }],
          ],
        }],
        ['chromeos==1', {
          'dependencies': [
            '../components/components.gyp:ownership',
          ],
        }],
        ['enable_mdns==1', {
          'sources': [
            'browser/local_discovery/test_service_discovery_client.cc',
            'browser/local_discovery/test_service_discovery_client.h',
          ],
        }],
        ['enable_app_list==1', {
          'sources': [
            'browser/ui/app_list/test/chrome_app_list_test_support.cc',
            'browser/ui/app_list/test/chrome_app_list_test_support.h',
            'browser/ui/app_list/test/test_app_list_controller_delegate.cc',
            'browser/ui/app_list/test/test_app_list_controller_delegate.h',
          ],
        }],
        ['enable_webrtc==1', {
          'sources': [
            'renderer/media/mock_webrtc_logging_message_filter.cc',
            'renderer/media/mock_webrtc_logging_message_filter.h',
          ],
        }],
        ['enable_plugins==1', {
          'dependencies': [
            '../pdf/pdf.gyp:pdf',
          ],
        }],
        ['enable_plugins==1 and disable_nacl==0', {
          'dependencies': [
            '<(DEPTH)/components/nacl/renderer/plugin/plugin.gyp:nacl_trusted_plugin',
          ],
        }],
        ['toolkit_views==1', {
          'dependencies': [
            '../ui/views/views.gyp:views',
          ],
        }],
        ['enable_pepper_cdms==1', {
          'sources' : [
            'browser/media/pepper_cdm_test_constants.cc',
            'browser/media/pepper_cdm_test_constants.h',
            'browser/media/pepper_cdm_test_helper.cc',
            'browser/media/pepper_cdm_test_helper.h',
          ],
          'dependencies': [
            '../media/media.gyp:cdm_paths',
          ],
        }],
      ],
    },
    {
      # GN version: //chrome/test:test_support_unit
      'target_name': 'test_support_unit',
      'type': 'static_library',
      'dependencies': [
        'chrome_resources.gyp:chrome_resources',
        'chrome_resources.gyp:chrome_strings',
        'browser',
        'common',
        'test_support_common',
        '../base/base.gyp:base',
        '../mojo/mojo_edk.gyp:mojo_system_impl',
        '../skia/skia.gyp:skia',
        '../components/sync.gyp:sync',
        '../testing/gmock.gyp:gmock',
        '../testing/gtest.gyp:gtest',
      ],
      'include_dirs': [
        '..',
      ],
      'sources': [
        'browser/sync/glue/session_sync_test_helper.cc',
        'browser/sync/glue/session_sync_test_helper.h',
        'test/base/run_all_unittests.cc',
      ],
      'conditions': [
        ['enable_media_router==1', {
          'dependencies': [
            'browser/media/router/media_router.gyp:media_router_test_support',
          ],
        }],
        ['use_ash==1', {
          'sources': [ '<@(chrome_test_support_unit_ash_sources)' ],
        }],
      ],
    },
    {
      # GN version: //chrome/test:unit_tests
      'target_name': 'unit_tests',
      'type': '<(gtest_target_type)',
      'dependencies': [
        # NOTE: New dependencies should generally be added in the OS!="ios"
        # dependencies block below, rather than here.
        # Unit tests should only depend on:
        # 1) everything that the chrome binaries depend on:
        '<@(chromium_browser_dependencies)',
        '<@(chromium_child_dependencies)',
        # 2) test-specific support libraries:
        '../base/base.gyp:test_support_base',
        '../components/components_resources.gyp:components_resources',
        '../components/components.gyp:browser_sync_browser_test_support',
        '../components/components.gyp:content_settings_core_test_support',
        '../components/components.gyp:gcm_driver',
        '../components/components.gyp:password_manager_core_browser_test_support',
        '../components/components.gyp:syncable_prefs_test_support',
        '../components/components.gyp:zoom_test_support',
        '../content/content_shell_and_tests.gyp:test_support_content',
        '../content/content.gyp:content_app_both',
        '../crypto/crypto.gyp:crypto_test_support',
        '../net/net.gyp:net',
        '../net/net.gyp:net_test_support',
        '../components/sync.gyp:test_support_sync_api',
        '../components/sync.gyp:test_support_sync_core',
        '../components/sync.gyp:test_support_sync_core_impl',
        '../testing/gmock.gyp:gmock',
        '../testing/gtest.gyp:gtest',
        'test_support_common',
        'test_support_unit',
        # 3) anything tests directly depend on
        '../components/components.gyp:component_updater_test_support',
        '../components/components.gyp:generate_version_info',
        '../components/components.gyp:subresource_filter_core_browser_test_support',
        '../courgette/courgette.gyp:courgette_lib',
        '../google_apis/google_apis.gyp:google_apis',
        '../skia/skia.gyp:skia',
        '../third_party/cacheinvalidation/cacheinvalidation.gyp:cacheinvalidation',
        '../third_party/icu/icu.gyp:icui18n',
        '../third_party/icu/icu.gyp:icuuc',
        '../third_party/libxml/libxml.gyp:libxml',
        '../ui/base/ui_base.gyp:ui_base_test_support',
        '../ui/display/display.gyp:display_test_support',
        '../ui/gfx/gfx.gyp:gfx_test_support',
        '../ui/resources/ui_resources.gyp:ui_resources',
        'chrome_features.gyp:chrome_common_features',
        'chrome_resources.gyp:chrome_resources',
        'chrome_resources.gyp:chrome_strings',
      ],
      'include_dirs': [
        '..',
      ],
      'msvs_settings': {
        'VCLinkerTool': {
          'conditions': [
            ['incremental_chrome_dll==1', {
              'UseLibraryDependencyInputs': "true",
            }],
          ],
        },
      },
      'sources': [
        '<@(chrome_unit_tests_sources)',
      ],
      'conditions': [
        ['OS!="ios"', {
          'dependencies': [
            '../components/components.gyp:autofill_content_test_support',
            '../components/components.gyp:component_metrics_proto',
            '../components/components.gyp:data_reduction_proxy_test_support',
            '../components/components.gyp:data_use_measurement_core',
            '../components/components.gyp:os_crypt_test_support',
            '../components/components.gyp:safe_json_test_support',
            '../components/components.gyp:webdata_services_test_support',
            '../components/components_strings.gyp:components_strings',
            '../content/app/resources/content_resources.gyp:content_resources',
            '../device/core/core.gyp:device_core_mocks',
            '../device/bluetooth/bluetooth.gyp:device_bluetooth_mocks',
            '../device/usb/usb.gyp:device_usb_mocks',
            '../gpu/gpu.gyp:gpu_unittest_utils',
            '../media/media.gyp:media_test_support',
            '../ppapi/ppapi_internal.gyp:ppapi_unittest_shared',
            '../third_party/leveldatabase/leveldatabase.gyp:leveldatabase',
            '../third_party/libaddressinput/libaddressinput.gyp:libaddressinput',
            '../third_party/libphonenumber/libphonenumber.gyp:libphonenumber',
            '../third_party/webrtc/modules/modules.gyp:desktop_capture',
            '../tools/json_schema_compiler/test/json_schema_compiler_tests.gyp:json_schema_compiler_tests',
            '../ui/gl/gl.gyp:gl',
            '../ui/gl/gl.gyp:gl_test_support',
          ],
          'include_dirs': [
            '<(SHARED_INTERMEDIATE_DIR)/chrome',
          ],
        }, {  # OS=="ios"
          'dependencies': [
            '../third_party/ocmock/ocmock.gyp:ocmock',
          ],
          'sources/': [
            # Exclude everything but iOS-specific files.
            ['exclude', '\\.(cc|mm)$'],
            ['include', '_ios\\.(cc|mm)$'],
            ['include', '(^|/)ios/'],
            # TODO(ios): Add files here as they are updated to compile on iOS.
            ['include', '^common/translate/language_detection_util_unittest\\.cc$'],
            ['include', '^common/translate/translate_util_unittest\\.cc$'],
            ['include', '^common/zip_'],
          ],
          # Bundle all the necessary resources into the test bundle.
          'includes': ['chrome_ios_bundle_resources.gypi'],
          'xcode_settings': {'OTHER_LDFLAGS': ['-ObjC']},
        }],
        ['OS=="android"', {
          'sources': [ '<@(chrome_unit_tests_offline_pages_sources)' ],
          'sources!': [
            'browser/policy/policy_path_parser_unittest.cc',
          ],
          'dependencies!': [
            '../third_party/libaddressinput/libaddressinput.gyp:libaddressinput',
          ],
          'ldflags': [
            # Some android targets still depend on --gc-sections to link.
            # TODO: remove --gc-sections for Debug builds (crbug.com/159847).
            '-Wl,--gc-sections',
          ],
          'dependencies': [
            '../testing/android/native_test.gyp:native_test_native_code',
            '../components/components.gyp:offline_pages',
          ],
        }, {  # Not Android.
          'sources': [ '<@(chrome_unit_tests_non_android_sources)' ],
          'sources!': [
            'browser/download/download_request_infobar_delegate_unittest.cc',
          ],
        }],
        ['OS!="android" and OS!="ios"', {
          'dependencies': [
            '../v8/src/v8.gyp:v8',
          ],
          'includes': [
            'js_unittest_rules.gypi',
          ],
          'include_dirs': [
            '<(SHARED_INTERMEDIATE_DIR)/chrome',
          ],
          'sources': [
            '<@(chrome_unit_tests_non_mobile_sources)',
            '<@(chrome_unit_tests_js_sources)',
            '<@(chrome_unit_tests_gtestjs_sources)',
          ],
        }],
        ['chromeos==1', {
          'sources!': [
            'browser/policy/cloud/user_policy_signin_service_unittest.cc',
            'browser/signin/chrome_signin_status_metrics_provider_delegate_unittest.cc',
          ],
        }],
        ['enable_background==1', {
          'sources': [ '<@(chrome_unit_tests_background_sources)' ],
        }],
        ['enable_spellcheck==1', {
          'sources': [ '<@(chrome_unit_tests_spellchecker_sources)' ],
          'conditions': [
            ['OS!="mac" and OS!="ios"', {
              'dependencies': [ '../third_party/hunspell/hunspell.gyp:hunspell' ],
            }],
          ],
        }],
        ['enable_one_click_signin==1', {
          'sources': [
            'browser/ui/sync/one_click_signin_sync_observer_unittest.cc',
            'browser/ui/sync/one_click_signin_sync_starter_unittest.cc',
          ],
        }],
        ['enable_extensions==1', {
          'sources': [ '<@(chrome_unit_tests_extensions_sources)' ],
          'dependencies': [
            'common/extensions/api/api.gyp:chrome_api',
            '../device/hid/hid.gyp:device_hid_mocks',
            '../extensions/extensions_resources.gyp:extensions_resources',
            '../extensions/extensions_strings.gyp:extensions_strings',
            '../tools/json_schema_compiler/test/json_schema_compiler_tests.gyp:feature_compiler_tests',
          ],
          'conditions': [
            ['enable_service_discovery==1', {
              'sources': [ '<@(chrome_unit_tests_extensions_service_discovery_sources)' ],
            }],
            ['chromeos==0', {
              'sources': [
                '<@(chrome_unit_tests_extensions_non_chromeos_sources)',
              ],
            }],
          ],
        }],
        ['use_ash==1', {
          # TODO(calamity): Consider moving the tests to regular
          # "chrome_unit_tests_sources" and not require Ash. crbug.com/439542.
          'sources': [ '<@(chrome_unit_tests_ash_sources)' ],
          'dependencies': [
            '../ash/ash.gyp:ash_test_support',
            '../ash/ash_resources.gyp:ash_resources',
            '../ash/ash_strings.gyp:ash_strings',
          ],
          # We eventually want to compile both in Win Aura builds, see
          # http://crbug.com/155545.
          'conditions': [
            ['OS !="win"', {
              'sources!': [
                'browser/ui/window_sizer/window_sizer_unittest.cc',
              ],
            }],
          ],
        }],
        ['use_aura==1', {
          'dependencies': [
            '../ui/wm/wm.gyp:wm',
            '../ui/aura/aura.gyp:aura_test_support',
          ],
        }],
        ['chromeos==0 and OS=="linux"', {
          'sources': [ '<@(chrome_unit_tests_desktop_linux_sources)' ],
        }],
        ['OS!="android" and OS!="ios" and chromeos==0', {
          'sources': [
            'browser/net/disk_cache_dir_policy_handler_unittest.cc',
            'browser/profiles/profile_list_desktop_unittest.cc',
            'browser/profiles/profile_statistics_unittest.cc',
            'browser/ui/startup/default_browser_infobar_delegate_unittest.cc',
          ],
        }],
        ['chromeos==0 and use_ozone==0 and OS=="linux"', {
          'dependencies': [
            'browser/ui/libgtk2ui/libgtk2ui.gyp:gtk2ui',
            '../build/linux/system.gyp:gio',
          ],
        }],
        ['use_aura==1 or toolkit_views==1', {
          'dependencies': [
            '../ui/events/events.gyp:events_test_support',
          ],
        }],
        ['enable_task_manager==1', {
          'sources': [ '<@(chrome_unit_tests_task_manager_sources)' ],
          'dependencies': [ '../gpu/gpu.gyp:gpu' ],
        }],
        ['enable_mdns==1', {
          'sources': [ '<@(chrome_unit_tests_mdns_sources)' ],
        }],
        ['enable_service_discovery==1', {
          'sources': [ '<@(chrome_unit_tests_service_discovery_sources)' ],
        }],
        ['enable_web_speech==1', {
          'sources': [ '<@(chrome_unit_tests_speech_sources)' ],
        }],
        ['notifications==1', {
          'sources': [ '<@(chrome_unit_tests_notifications_sources)' ],
          'conditions': [
            ['OS == "android"', {
              'sources!': [
                # Android does not use the Message Center notification system.
                'browser/notifications/message_center_notifications_unittest.cc',
                'browser/notifications/message_center_settings_controller_unittest.cc',
              ],
            }],
          ],
        }],
        ['safe_browsing==1', {
          # TODO(sgurun): enable tests for safe_browsing==2.
          'sources': [ '<@(chrome_unit_tests_full_safe_browsing_sources)',
                       '<@(chrome_unit_tests_shared_safe_browsing_sources)',
                     ],
          'dependencies': [
            '../components/components.gyp:test_database_manager',
            'ipc_protobuf_message_test_proto',
          ],
        }],
        ['safe_browsing==2', {
          'sources': [ '<@(chrome_unit_tests_shared_safe_browsing_sources)' ],
        }],
        ['enable_plugins==1', {
          'sources': [ '<@(chrome_unit_tests_plugins_sources)' ],
        }],
        ['enable_print_preview==1', {
          'sources': [ '<@(chrome_unit_tests_print_preview_sources)' ],
        }],
        ['enable_media_router==1', {
          'sources': [ '<@(chrome_unit_tests_media_router_sources)' ],
          'dependencies': [ 'browser/media/router/media_router.gyp:media_router_test_support' ],
          'conditions': [
            ['OS!="android"', {
              'sources': [ '<@(chrome_unit_tests_media_router_non_android_sources)' ],
            }],
          ],
        }],
        ['enable_captive_portal_detection==1', {
          'sources': [ '<@(chrome_unit_tests_captive_portal_sources)' ],
        }],
        ['enable_session_service==1', {
          'sources': [ '<@(chrome_unit_tests_session_service_sources)' ],
        }],
        ['enable_webrtc==1', {
          'sources': [ '<@(chrome_unit_tests_webrtc_sources)' ],
        }],
        ['chromeos==1', {
          'sources': [
            '<@(chrome_unit_tests_chromeos_sources)',
            '<@(chrome_unit_tests_chromeos_gtestjs_sources)',
            '<@(chrome_unit_tests_chromeos_js_sources)',
          ],
          'dependencies': [
            '../ash/ash_resources.gyp:ash_resources',
            '../chromeos/ime/input_method.gyp:gencode',
            '../components/components.gyp:drive_test_support',
            '../components/components.gyp:drive_test_support_chromeos',
            '../ui/chromeos/ui_chromeos.gyp:ui_chromeos_resources',
          ],
          'sources!': [
            'browser/signin/signin_manager_unittest.cc',
            'browser/signin/signin_names_io_thread_unittest.cc',
          ],
        }],
        ['use_x11==1', {
          'dependencies': [
            '../tools/xdisplaycheck/xdisplaycheck.gyp:xdisplaycheck',
            '../ui/events/devices/events_devices.gyp:events_devices',
          ],
        }],
        ['OS=="linux"', {
          'dependencies': [
            '../build/linux/system.gyp:nss',
          ],
        }],
        # Only add this test for 64 bit builds because otherwise we need the 32
        # bit library on 64 bit systems when running this test.
        ['use_gnome_keyring == 1 and target_arch=="x64"', {
          'sources': [
            'browser/password_manager/native_backend_gnome_x_unittest.cc',
          ],
          # We use a few library functions directly, so link directly.
          'dependencies': [
            '../build/linux/system.gyp:gnome_keyring_direct',
          ],
        }],
        ['OS=="linux" and chromeos!=1', {
          'sources': [
            'browser/password_manager/native_backend_libsecret_unittest.cc',
          ],
          'include_dirs' : [
            '../third_party/libsecret/'
          ],
        }],
        ['OS=="linux" and use_aura==1', {
          'dependencies': [
            '../build/linux/system.gyp:dbus',
            '../dbus/dbus.gyp:dbus_test_support',
            '../ui/aura/aura.gyp:aura_test_support',
          ],
        }],
        ['OS=="linux" and branding=="Chrome" and target_arch=="ia32"', {
          'configurations': {
            'Release': {
              'ldflags': [
                '-Wl,--strip-debug',
              ],
            },
          },
        }],
        ['OS=="mac"', {
          # The test fetches resources which means Mac need the app bundle to
          # exist on disk so it can pull from it.
          'dependencies': [
            '../third_party/google_toolbox_for_mac/google_toolbox_for_mac.gyp:google_toolbox_for_mac',
            '../third_party/ocmock/ocmock.gyp:ocmock',
            'chrome',
          ],
          'sources!': [
            # This tests the function GetSpellCheckLanguages which is not used
            # on Mac.
            'browser/spellchecker/spellcheck_service_unittest.cc',
            'browser/ui/tests/ui_gfx_image_unittest.cc',
            # This tests Chrome's spellchecker which Mac doesn't use.
            'tools/convert_dict/convert_dict_unittest.cc',
          ],
          'conditions': [
            ['mac_views_browser==1', {
              # TODO(tapted): Add chrome_unit_tests_views_non_mac_sources here.
            }, {
              'sources': [ '<@(chrome_unit_tests_cocoa_sources)' ],
            }],
          ],
          # TODO(mark): We really want this for all non-static library targets,
          # but when we tried to pull it up to the common.gypi level, it broke
          # other things like the ui and startup tests. *shrug*
          'xcode_settings': {'OTHER_LDFLAGS': ['-Wl,-ObjC']},
        }],
        ['OS=="android"', {
          'sources': [ '<@(chrome_unit_tests_android_sources)' ],
        }],
        ['OS!="mac" and OS!="ios"', {
          'dependencies': [
            '../third_party/hunspell/hunspell.gyp:hunspell',
            'chrome_resources.gyp:packed_extra_resources',
            'chrome_resources.gyp:packed_resources',
            'tools/convert_dict/convert_dict.gyp:convert_dict_lib',
          ],
        }],
        ['OS=="win" or OS=="mac"', {
          'sources': [ '<@(chrome_unit_tests_win_mac_sources)' ],
        }],
        ['OS=="win" or OS=="mac" or chromeos==1', {
          'sources': [
            'common/extensions/api/networking_private/networking_private_crypto_unittest.cc',
          ],
        }],
        ['enable_rlz_support==1', {
          'sources': [
            'browser/rlz/chrome_rlz_tracker_delegate_unittest.cc',
          ],
          'dependencies': [
            '../components/components.gyp:rlz',
            '../rlz/rlz.gyp:test_support_rlz',
            'browser_rlz',
          ],
        }],
        ['OS=="win" and component!="shared_library"', {
          # Unit_tests pdb files can get too big when incremental linking is
          # on, disabling for this target.
          'configurations': {
            'Debug': {
              'msvs_settings': {
                'VCLinkerTool': {
                  'LinkIncremental': '<(msvs_debug_link_nonincremental)',
                },
              },
            },
          },
        }],
        ['OS=="win"', {
          'dependencies': [
            'browser/safe_browsing/incident_reporting/verifier_test/verifier_unittest.gyp:verifier_test_dll_1',
            'browser/safe_browsing/incident_reporting/verifier_test/verifier_unittest.gyp:verifier_test_dll_2',
            'chrome_version_resources',
            'installer_util_strings',
            '../chrome_elf/chrome_elf.gyp:blacklist_test_dll_1',
            '../third_party/iaccessible2/iaccessible2.gyp:iaccessible2',
            '../third_party/isimpledom/isimpledom.gyp:isimpledom',
          ],
          'conditions': [
            ['branding!="Chrome"', {
              'sources!': [
                'browser/google/google_update_win_unittest.cc',
              ],
            }],
          ],
          'include_dirs': [
            '<(DEPTH)/third_party/wtl/include',
          ],
          'sources': [
            '<@(chrome_unit_tests_win_sources)',
            '<(SHARED_INTERMEDIATE_DIR)/chrome/installer/util/installer_util_strings.rc',
            # TODO:  It would be nice to have these pulled in
            # automatically from direct_dependent_settings in
            # their various targets (net.gyp:net_resources, etc.),
            # but that causes errors in other targets when
            # resulting .res files get referenced multiple times.
            '<(SHARED_INTERMEDIATE_DIR)/chrome_version/other_version.rc',
            '<(SHARED_INTERMEDIATE_DIR)/ui/resources/ui_unscaled_resources.rc',
          ],
          'link_settings': {
            'libraries': [
              '-lcomsupp.lib',
              '-loleacc.lib',
              '-lrpcrt4.lib',
              '-lurlmon.lib',
              '-lwinmm.lib',
            ],
          },
        }],
        ['OS=="android" or OS=="ios"', {
          'sources!': [
            'browser/ui/bookmarks/bookmark_ui_utils_desktop_unittest.cc',
            'browser/ui/sync/sync_promo_ui_unittest.cc',
          ],
        }, { # 'OS!="android" and OS!="ios"'
          'dependencies': [
            '../components/components.gyp:bubble_test_support',
          ],
        }],
        ['OS != "android" and chromeos == 0', {
          'sources': [ '<@(chrome_unit_tests_non_android_or_chromeos_sources)' ],
        }],
        ['enable_themes == 1', {
          'sources': [ '<@(chrome_unit_tests_themes_sources)' ],
        }],
        ['toolkit_views==1', {
          'dependencies': [
            '../components/components.gyp:web_modal_test_support',
            '../ui/views/views.gyp:views',
            '../ui/views/views.gyp:views_test_support',
          ],
          'sources': [ '<@(chrome_unit_tests_views_sources)' ],
          'conditions': [
            ['chromeos == 0 and (OS != "mac" or mac_views_browser == 1)', {
              'sources': [ '<@(chrome_unit_tests_views_non_chromeos_sources)' ],
            }],
            ['OS != "mac"', {
              'sources': [ '<@(chrome_unit_tests_views_non_mac_sources)' ],
            }],
          ],
        }],
        ['OS != "android" and use_nss_certs == 1', {
          'sources': [
            'common/net/x509_certificate_model_unittest.cc',
          ],
        }],
        ['enable_supervised_users == 1', {
          'sources': [ '<@(chrome_unit_tests_supervised_user_sources)' ],
        }],
        ['enable_supervised_users == 1 and OS != "android" and OS != "ios"', {
          'sources': [ '<@(chrome_unit_tests_supervised_user_legacy_sources)' ],
        }],
        ['enable_supervised_users == 1 and OS != "android" and chromeos == 0', {
          'sources': [
            'browser/ui/webui/signin/signin_supervised_user_import_handler_unittest.cc',
          ],
        }],
        ['safe_browsing==1 and enable_extensions==1', {
          'sources': [
            'browser/extensions/blacklist_unittest.cc',
          ],
        }],
        ['enable_app_list==1', {
          'sources': [ '<@(chrome_unit_tests_app_list_sources)' ],
          'dependencies': [
            '../ui/app_list/app_list.gyp:app_list_test_support',
          ],
          'conditions': [
            ['chromeos==1', {
              'sources': [ '<@(chrome_unit_tests_app_list_chromeos_sources)' ],
              'dependencies': [
                '../components/components.gyp:arc_test_support',
              ],
              'sources!': [
                'browser/ui/views/app_list/linux/app_list_linux_unittest.cc',
              ],
            }],
          ],
        }],
        ['chromeos==1', {
          'sources': [ '<@(chrome_unit_tests_arc_sources)' ],
          'dependencies': [
            '../components/components.gyp:arc_test_support',
          ],
        }],
        ['enable_plugin_installation==0', {
          'sources!': [
            'browser/plugins/plugin_installer_unittest.cc',
          ],
        }],
        ['safe_browsing==1 and OS=="mac"', {
          'actions': [
            {
              'action_name': 'Generate safe_browsing DMG test data',
              'variables': {
                'generate_test_data': 'test/data/safe_browsing/dmg/generate_test_data.sh',
              },
              'inputs': [
                '<(generate_test_data)',
                'test/data/safe_browsing/dmg/make_hfs.sh',
                'test/data/safe_browsing/mach_o/executablefat',
                'test/data/safe_browsing/mach_o/lib64.dylib',
              ],
              'outputs': [
                '<(PRODUCT_DIR)/test_data/chrome/safe_browsing_dmg/dmg_UDBZ_GPTSPUD.dmg',
                '<(PRODUCT_DIR)/test_data/chrome/safe_browsing_dmg/dmg_UDBZ_NONE.dmg',
                '<(PRODUCT_DIR)/test_data/chrome/safe_browsing_dmg/dmg_UDBZ_SPUD.dmg',
                '<(PRODUCT_DIR)/test_data/chrome/safe_browsing_dmg/dmg_UDCO_GPTSPUD.dmg',
                '<(PRODUCT_DIR)/test_data/chrome/safe_browsing_dmg/dmg_UDCO_NONE.dmg',
                '<(PRODUCT_DIR)/test_data/chrome/safe_browsing_dmg/dmg_UDCO_SPUD.dmg',
                '<(PRODUCT_DIR)/test_data/chrome/safe_browsing_dmg/dmg_UDRO_GPTSPUD.dmg',
                '<(PRODUCT_DIR)/test_data/chrome/safe_browsing_dmg/dmg_UDRO_NONE.dmg',
                '<(PRODUCT_DIR)/test_data/chrome/safe_browsing_dmg/dmg_UDRO_SPUD.dmg',
                '<(PRODUCT_DIR)/test_data/chrome/safe_browsing_dmg/dmg_UDRW_GPTSPUD.dmg',
                '<(PRODUCT_DIR)/test_data/chrome/safe_browsing_dmg/dmg_UDRW_NONE.dmg',
                '<(PRODUCT_DIR)/test_data/chrome/safe_browsing_dmg/dmg_UDRW_SPUD.dmg',
                '<(PRODUCT_DIR)/test_data/chrome/safe_browsing_dmg/dmg_UDSP_GPTSPUD.sparseimage',
                '<(PRODUCT_DIR)/test_data/chrome/safe_browsing_dmg/dmg_UDSP_NONE.sparseimage',
                '<(PRODUCT_DIR)/test_data/chrome/safe_browsing_dmg/dmg_UDSP_SPUD.sparseimage',
                '<(PRODUCT_DIR)/test_data/chrome/safe_browsing_dmg/dmg_UDTO_GPTSPUD.cdr',
                '<(PRODUCT_DIR)/test_data/chrome/safe_browsing_dmg/dmg_UDTO_NONE.cdr',
                '<(PRODUCT_DIR)/test_data/chrome/safe_browsing_dmg/dmg_UDTO_SPUD.cdr',
                '<(PRODUCT_DIR)/test_data/chrome/safe_browsing_dmg/dmg_UDZO_GPTSPUD.dmg',
                '<(PRODUCT_DIR)/test_data/chrome/safe_browsing_dmg/dmg_UDZO_NONE.dmg',
                '<(PRODUCT_DIR)/test_data/chrome/safe_browsing_dmg/dmg_UDZO_SPUD.dmg',
                '<(PRODUCT_DIR)/test_data/chrome/safe_browsing_dmg/dmg_UFBI_GPTSPUD.dmg',
                '<(PRODUCT_DIR)/test_data/chrome/safe_browsing_dmg/dmg_UFBI_NONE.dmg',
                '<(PRODUCT_DIR)/test_data/chrome/safe_browsing_dmg/dmg_UFBI_SPUD.dmg',
                '<(PRODUCT_DIR)/test_data/chrome/safe_browsing_dmg/hfs_plus.img',
                '<(PRODUCT_DIR)/test_data/chrome/safe_browsing_dmg/hfsx_case_sensitive.img',
                '<(PRODUCT_DIR)/test_data/chrome/safe_browsing_dmg/mach_o_in_dmg.dmg',
              ],
              'action': [ '<(generate_test_data)', '<(PRODUCT_DIR)/test_data/chrome/safe_browsing_dmg' ],
            },
          ],
        }],
        # Adding more conditions? Don't forget to update the GN build.
      ],
    },
    {
      # GN: //chrome/test:chrome_app_unittests
      'target_name': 'chrome_app_unittests',
      'type': 'executable',
      'dependencies': [
        # unit tests should only depend on
        # 1) everything that the chrome binaries depend on:
        '<@(chromium_browser_dependencies)',
        '<@(chromium_child_dependencies)',
        '../components/components.gyp:crash_core_common',
        '../components/components.gyp:flags_ui_switches',
        '../content/content.gyp:content_app_both',
        '../third_party/kasko/kasko.gyp:kasko_features',
        # 2) test-specific support libraries:
        '../base/base.gyp:run_all_unittests',
        '../testing/gmock.gyp:gmock',
        '../testing/gtest.gyp:gtest',
        'test_support_common',
      ],
      'include_dirs': [
        '..',
      ],
      'sources': [
        'app/chrome_watcher_client_unittest_win.cc',
        'app/chrome_watcher_client_win.cc',
        'app/chrome_watcher_command_line_win.cc',
        'app/chrome_watcher_command_line_win_unittest.cc',
        'app/resources/resources_unittest.cc',
        'common/crash_keys.cc',
        'common/crash_keys.h',
      ],
      'conditions': [
        ['OS=="mac" or OS=="ios"', {
          'include_dirs': [
            '<(DEPTH)/breakpad/src',
          ],
        }],
        ['OS=="mac"', {
          # TODO(mark): We really want this for all non-static library targets,
          # but when we tried to pull it up to the common.gypi level, it broke
          # other things like the ui and startup tests. *shrug*
          'xcode_settings': {'OTHER_LDFLAGS': ['-Wl,-ObjC']},
        }],
        ['OS=="win"', {
          'dependencies': [
            # breakpad is currently only tested on Windows.
            '../breakpad/breakpad.gyp:*',
            '../components/components.gyp:crash_component',
          ],
        }],
      ],
    },
    {
      # Protobuf compiler / generator for IPC protobuf message tests.

      # GN version: //chrome/test:test_proto
      'target_name': 'ipc_protobuf_message_test_proto',
      'type': 'static_library',
      'sources': [
        'common/safe_browsing/ipc_protobuf_message_test.proto'
      ],
      'variables': {
        'proto_in_dir': 'common/safe_browsing',
        'proto_out_dir': 'chrome/common/safe_browsing',
      },
      'includes': [ '../build/protoc.gypi' ],
    },
  ],

  'conditions': [
    ['OS == "android"', {
      'targets': [
        {
          'target_name': 'unit_tests_java',
          'type': 'none',
          'variables': {
            'java_in_dir': 'test/android/unit_tests_apk',
          },
          'dependencies': [
            'chrome_java',
          ],
          'includes': [ '../build/java.gypi' ],
        },
        {
          'target_name': 'unit_tests_apk',
          'type': 'none',
          'dependencies': [
            'chrome_java',
            'unit_tests_java',
            'unit_tests',
          ],
          'variables': {
            'test_suite_name': 'unit_tests',
            'isolate_file': 'unit_tests.isolate',
            'android_manifest_path': 'test/android/unit_tests_apk/AndroidManifest.xml',
            'enable_multidex': 1,
            'conditions': [
              ['v8_use_external_startup_data==1', {
                'asset_location': '<(PRODUCT_DIR)/unit_tests_apk/assets',
                'additional_input_paths': [
                  '<(PRODUCT_DIR)/unit_tests_apk/assets/natives_blob_<(arch_suffix).bin',
                  '<(PRODUCT_DIR)/unit_tests_apk/assets/snapshot_blob_<(arch_suffix).bin',
                ],
              }],
            ],
          },
          'conditions': [
            ['v8_use_external_startup_data==1', {
              'dependencies': [
                '../v8/src/v8.gyp:v8_external_snapshot',
              ],
              'variables': {
                'dest_path': '<(asset_location)',
                'renaming_sources': [
                  '<(PRODUCT_DIR)/natives_blob.bin',
                  '<(PRODUCT_DIR)/snapshot_blob.bin',
                ],
                'renaming_destinations': [
                  'natives_blob_<(arch_suffix).bin',
                  'snapshot_blob_<(arch_suffix).bin',
                ],
                'clear': 1,
              },
              'includes': ['../build/android/copy_ex.gypi'],
            }],
          ],
          'includes': [
            '../build/apk_test.gypi',
            '../build/android/v8_external_startup_data_arch_suffix.gypi'
          ],
        },
      ],
      'conditions': [
        ['test_isolation_mode != "noop"', {
          'targets': [
            {
              'target_name': 'unit_tests_apk_run',
              'type': 'none',
              'dependencies': [
                'unit_tests_apk',
              ],
              'includes': [
                '../build/isolate.gypi',
              ],
              'sources': [
                'unit_tests_apk.isolate',
              ],
            },
          ],
        }],
      ],
    }],
    ['test_isolation_mode != "noop"', {
      'targets': [
        {
          'target_name': 'chrome_app_unittests_run',
          'type': 'none',
          'dependencies': [
            'chrome_app_unittests',
          ],
          'includes': [
            '../build/isolate.gypi',
          ],
          'sources': [
            'chrome_app_unittests.isolate',
          ],
        },
        {
          'target_name': 'unit_tests_run',
          'type': 'none',
          'dependencies': [
            'unit_tests',
          ],
          'includes': [
            '../build/isolate.gypi',
          ],
          'sources': [
            'unit_tests.isolate',
          ],
          'conditions': [
            ['use_x11 == 1', {
              'dependencies': [
                '../tools/xdisplaycheck/xdisplaycheck.gyp:xdisplaycheck',
              ],
            }],
          ],
        },
      ],
    }],
  ],  # 'conditions'
}
