# Copyright 2013 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

{
  'variables': {
    'chromium_code': 1,
    # Setting these two variables allows other targets to use the
    # sync_proto_sources variable as the list of sync protocol buffer files.
    'sync_proto_sources_dir': 'sync/protocol',
    'sync_proto_sources': [
      '<@(sync_proto_source_paths)',
    ],
  },

  'includes': [
    'sync/protocol/protocol.gypi',
    'sync/sync_android.gypi',
    'sync/sync_tests.gypi',
  ],

  'targets': [
    # This target will add '-lsync_core' and '-lsync_proto' to the link line of
    # targets that depend on it.  Anything that depends on sync code should
    # declare a dependency on this target.
    {
      'target_name': 'sync',
      'type': 'none',
      'dependencies': [
        'sync_core',
        'sync_proto',
      ],
      'export_dependent_settings': [
        'sync_core',
        'sync_proto',
      ],
    },

    # Contains everything related to sync implementation that does not depend
    # on chrome/ or components/.  Do not depend on this directly.  Depend on
    # the 'sync' target to get the sync protobufs, too.
    {
      'target_name': 'sync_core',
      'type': '<(component)',
      'variables': { 'enable_wexit_time_destructors': 1, },
      'defines': [
        'SYNC_IMPLEMENTATION',
      ],
      'include_dirs': [
        '..',
      ],
      'dependencies': [
        '../base/base.gyp:base',
        '../base/base.gyp:base_i18n',
        '../crypto/crypto.gyp:crypto',
        '../google_apis/google_apis.gyp:google_apis',
        '../net/net.gyp:net',
        '../sql/sql.gyp:sql',
        '../third_party/cacheinvalidation/cacheinvalidation.gyp:cacheinvalidation',
        '../third_party/cacheinvalidation/cacheinvalidation.gyp:cacheinvalidation_proto_cpp',
        '../third_party/leveldatabase/leveldatabase.gyp:leveldatabase',
        '../third_party/protobuf/protobuf.gyp:protobuf_lite',
        '../third_party/zlib/zlib.gyp:zlib',
        '../url/url.gyp:url_lib',
        'components.gyp:data_use_measurement_core',
        'components.gyp:invalidation_public',
        'components.gyp:metrics',
        'components.gyp:os_crypt',
        'components.gyp:signin_core_browser',
        'components.gyp:version_info',
        'attachment_store_proto',
        'sync_proto',
      ],
      'export_dependent_settings': [
        '../net/net.gyp:net',
        'sync_proto',
      ],
      'sources': [
        'sync/api/attachments/attachment.cc',
        'sync/api/attachments/attachment.h',
        'sync/api/attachments/attachment_id.cc',
        'sync/api/attachments/attachment_id.h',
        'sync/api/attachments/attachment_metadata.cc',
        'sync/api/attachments/attachment_metadata.h',
        'sync/api/attachments/attachment_store.cc',
        'sync/api/attachments/attachment_store.h',
        'sync/api/attachments/attachment_store_backend.cc',
        'sync/api/attachments/attachment_store_backend.h',
        'sync/api/conflict_resolution.cc',
        'sync/api/conflict_resolution.h',
        'sync/api/data_batch.h',
        'sync/api/entity_change.cc',
        'sync/api/entity_change.h',
        'sync/api/entity_data.cc',
        'sync/api/entity_data.h',
        'sync/api/metadata_batch.cc',
        'sync/api/metadata_batch.h',
        'sync/api/metadata_change_list.h',
        'sync/api/model_type_change_processor.cc',
        'sync/api/model_type_change_processor.h',
        'sync/api/model_type_service.cc',
        'sync/api/model_type_service.h',
        'sync/api/model_type_store.cc',
        'sync/api/model_type_store.h',
        'sync/api/string_ordinal.h',
        'sync/api/sync_change.cc',
        'sync/api/sync_change.h',
        'sync/api/sync_change_processor.cc',
        'sync/api/sync_change_processor.h',
        'sync/api/sync_data.cc',
        'sync/api/sync_data.h',
        'sync/api/sync_error.cc',
        'sync/api/sync_error.h',
        'sync/api/sync_error_factory.cc',
        'sync/api/sync_error_factory.h',
        'sync/api/sync_merge_result.cc',
        'sync/api/sync_merge_result.h',
        'sync/api/syncable_service.cc',
        'sync/api/syncable_service.h',
        'sync/api/time.h',
        'sync/base/sync_export.h',
        'sync/engine_impl/all_status.cc',
        'sync/engine_impl/all_status.h',
        'sync/engine_impl/apply_control_data_updates.cc',
        'sync/engine_impl/apply_control_data_updates.h',
        'sync/engine_impl/backoff_delay_provider.cc',
        'sync/engine_impl/backoff_delay_provider.h',
        'sync/engine_impl/clear_server_data.cc',
        'sync/engine_impl/clear_server_data.h',
        'sync/engine_impl/commit.cc',
        'sync/engine_impl/commit.h',
        'sync/engine_impl/commit_contribution.cc',
        'sync/engine_impl/commit_contribution.h',
        'sync/engine_impl/commit_contributor.cc',
        'sync/engine_impl/commit_contributor.h',
        'sync/engine_impl/commit_processor.cc',
        'sync/engine_impl/commit_processor.h',
        'sync/engine_impl/commit_queue.cc',
        'sync/engine_impl/commit_queue.h',
        'sync/engine_impl/commit_util.cc',
        'sync/engine_impl/commit_util.h',
        'sync/engine_impl/conflict_resolver.cc',
        'sync/engine_impl/conflict_resolver.h',
        'sync/engine_impl/conflict_util.cc',
        'sync/engine_impl/conflict_util.h',
        'sync/engine_impl/directory_commit_contribution.cc',
        'sync/engine_impl/directory_commit_contribution.h',
        'sync/engine_impl/directory_commit_contributor.cc',
        'sync/engine_impl/directory_commit_contributor.h',
        'sync/engine_impl/directory_update_handler.cc',
        'sync/engine_impl/directory_update_handler.h',
        'sync/engine_impl/get_commit_ids.cc',
        'sync/engine_impl/get_commit_ids.h',
        'sync/engine_impl/get_updates_delegate.cc',
        'sync/engine_impl/get_updates_delegate.h',
        'sync/engine_impl/get_updates_processor.cc',
        'sync/engine_impl/get_updates_processor.h',
        'sync/engine_impl/model_type_worker.cc',
        'sync/engine_impl/model_type_worker.h',
        'sync/engine_impl/net/server_connection_manager.cc',
        'sync/engine_impl/net/server_connection_manager.h',
        'sync/engine_impl/net/url_translator.cc',
        'sync/engine_impl/net/url_translator.h',
        'sync/engine_impl/non_blocking_type_commit_contribution.cc',
        'sync/engine_impl/non_blocking_type_commit_contribution.h',
        'sync/engine_impl/nudge_handler.cc',
        'sync/engine_impl/nudge_handler.h',
        'sync/engine_impl/nudge_source.cc',
        'sync/engine_impl/nudge_source.h',
        'sync/engine_impl/process_updates_util.cc',
        'sync/engine_impl/process_updates_util.h',
        'sync/engine_impl/sync_cycle_event.cc',
        'sync/engine_impl/sync_cycle_event.h',
        'sync/engine_impl/sync_engine_event_listener.cc',
        'sync/engine_impl/sync_engine_event_listener.h',
        'sync/engine_impl/sync_scheduler.cc',
        'sync/engine_impl/sync_scheduler.h',
        'sync/engine_impl/sync_scheduler_impl.cc',
        'sync/engine_impl/sync_scheduler_impl.h',
        'sync/engine_impl/syncer.cc',
        'sync/engine_impl/syncer.h',
        'sync/engine_impl/syncer_proto_util.cc',
        'sync/engine_impl/syncer_proto_util.h',
        'sync/engine_impl/syncer_types.h',
        'sync/engine_impl/syncer_util.cc',
        'sync/engine_impl/syncer_util.h',
        'sync/engine_impl/traffic_logger.cc',
        'sync/engine_impl/traffic_logger.h',
        'sync/engine_impl/update_applicator.cc',
        'sync/engine_impl/update_applicator.h',
        'sync/engine_impl/update_handler.cc',
        'sync/engine_impl/update_handler.h',
        'sync/engine_impl/worker_entity_tracker.cc',
        'sync/engine_impl/worker_entity_tracker.h',
        'sync/core/activation_context.cc',
        'sync/core_impl/attachments/attachment_downloader.cc',
        'sync/core_impl/attachments/attachment_downloader_impl.cc',
        'sync/core_impl/attachments/attachment_service.cc',
        'sync/core_impl/attachments/attachment_service_impl.cc',
        'sync/core_impl/attachments/attachment_service_proxy.cc',
        'sync/core_impl/attachments/attachment_service_proxy_for_test.cc',
        'sync/core_impl/attachments/attachment_store_frontend.cc',
        'sync/core_impl/attachments/attachment_uploader.cc',
        'sync/core_impl/attachments/attachment_uploader_impl.cc',
        'sync/core_impl/attachments/attachment_util.cc',
        'sync/core_impl/attachments/fake_attachment_downloader.cc',
        'sync/core_impl/attachments/fake_attachment_uploader.cc',
        'sync/core_impl/attachments/in_memory_attachment_store.cc',
        'sync/core_impl/attachments/on_disk_attachment_store.cc',
        'sync/core_impl/attachments/task_queue.cc',
        'sync/core/base_node.cc',
        'sync/core/base_transaction.cc',
        'sync/core/change_record.cc',
        'sync/core_impl/change_reorder_buffer.cc',
        'sync/core_impl/change_reorder_buffer.h',
        'sync/core_impl/debug_info_event_listener.cc',
        'sync/core_impl/debug_info_event_listener.h',
        'sync/core/delete_journal.cc',
        'sync/engine/events/clear_server_data_request_event.cc',
        'sync/engine/events/clear_server_data_response_event.cc',
        'sync/engine/events/commit_request_event.cc',
        'sync/engine/events/commit_response_event.cc',
        'sync/engine/events/configure_get_updates_request_event.cc',
        'sync/engine/events/get_updates_response_event.cc',
        'sync/engine/events/normal_get_updates_request_event.cc',
        'sync/engine/events/poll_get_updates_request_event.cc',
        'sync/engine/events/protocol_event.cc',
        'sync/core/http_bridge.cc',
        'sync/core/http_bridge_network_resources.cc',
        'sync/core/internal_components_factory_impl.cc',
        'sync/core_impl/js_mutation_event_observer.cc',
        'sync/core_impl/js_mutation_event_observer.h',
        'sync/core_impl/js_sync_encryption_handler_observer.cc',
        'sync/core_impl/js_sync_encryption_handler_observer.h',
        'sync/core_impl/js_sync_manager_observer.cc',
        'sync/core_impl/js_sync_manager_observer.h',
        'sync/core/model_type_connector.cc',
        'sync/core_impl/model_type_connector_proxy.cc',
        'sync/core/model_type_store_backend.cc',
        'sync/core/model_type_store_impl.cc',
        'sync/core/processor_entity_tracker.cc',
        'sync/core_impl/protocol_event_buffer.cc',
        'sync/core_impl/protocol_event_buffer.h',
        'sync/core/activation_context.h',
        'sync/core/attachments/attachment_downloader.h',
        'sync/core/attachments/attachment_downloader_impl.h',
        'sync/core/attachments/attachment_service.h',
        'sync/core/attachments/attachment_service_impl.h',
        'sync/core/attachments/attachment_service_proxy.h',
        'sync/core/attachments/attachment_service_proxy_for_test.h',
        'sync/core/attachments/attachment_store_frontend.h',
        'sync/core/attachments/attachment_uploader.h',
        'sync/core/attachments/attachment_uploader_impl.h',
        'sync/core/attachments/attachment_util.h',
        'sync/core/attachments/fake_attachment_downloader.h',
        'sync/core/attachments/fake_attachment_uploader.h',
        'sync/core/attachments/in_memory_attachment_store.h',
        'sync/core/attachments/on_disk_attachment_store.h',
        'sync/core/attachments/task_queue.h',
        'sync/base/attachment_id_proto.cc',
        'sync/base/attachment_id_proto.h',
        'sync/base/cancelation_observer.cc',
        'sync/base/cancelation_observer.h',
        'sync/base/cancelation_signal.cc',
        'sync/base/cancelation_signal.h',
        'sync/base/enum_set.h',
        'sync/base/enum_set.h',
        'sync/base/invalidation_interface.cc',
        'sync/base/invalidation_interface.h',
        'sync/base/model_type.h',
        'sync/base/node_ordinal.cc',
        'sync/base/node_ordinal.h',
        'sync/base/ordinal.h',
        'sync/base/progress_marker_map.cc',
        'sync/base/progress_marker_map.h',
        'sync/base/stop_source.h',
        'sync/base/unique_position.cc',
        'sync/base/unique_position.h',
        'sync/core/base_node.h',
        'sync/core/base_transaction.h',
        'sync/core/change_record.h',
        'sync/core/configure_reason.h',
        'sync/core/connection_status.h',
        'sync/core/data_batch_impl.h',
        'sync/core/data_batch_impl.cc',
        'sync/core/data_type_association_stats.cc',
        'sync/core/data_type_association_stats.h',
        'sync/core/data_type_debug_info_listener.cc',
        'sync/core/data_type_debug_info_listener.h',
        'sync/core/data_type_error_handler.h',
        'sync/core/delete_journal.h',
        'sync/engine/model_safe_worker.cc',
        'sync/engine/model_safe_worker.h',
        'sync/engine/passive_model_worker.cc',
        'sync/engine/passive_model_worker.h',
        'sync/engine/polling_constants.cc',
        'sync/engine/polling_constants.h',
        'sync/engine/sync_status.cc',
        'sync/engine/sync_status.h',
        'sync/engine/events/clear_server_data_request_event.h',
        'sync/engine/events/clear_server_data_response_event.h',
        'sync/engine/events/commit_request_event.h',
        'sync/engine/events/commit_response_event.h',
        'sync/engine/events/configure_get_updates_request_event.h',
        'sync/engine/events/get_updates_response_event.h',
        'sync/engine/events/normal_get_updates_request_event.h',
        'sync/engine/events/poll_get_updates_request_event.h',
        'sync/engine/events/protocol_event.h',
        'sync/core/http_bridge.h',
        'sync/core/http_bridge_network_resources.h',
        'sync/core/http_post_provider_factory.h',
        'sync/core/http_post_provider_interface.h',
        'sync/core/internal_components_factory.h',
        'sync/core/internal_components_factory_impl.h',
        'sync/core/model_type_connector.h',
        'sync/core/model_type_connector_proxy.h',
        'sync/core/model_type_processor.cc',
        'sync/core/model_type_processor.h',
        'sync/core/model_type_store_backend.h',
        'sync/core/model_type_store_impl.h',
        'sync/core/network_resources.h',
        'sync/core/non_blocking_sync_common.cc',
        'sync/core/non_blocking_sync_common.h',
        'sync/core/processor_entity_tracker.h',
        'sync/core/read_node.h',
        'sync/core/read_transaction.h',
        'sync/sessions/commit_counters.cc',
        'sync/sessions/commit_counters.h',
        'sync/sessions/model_neutral_state.cc',
        'sync/sessions/model_neutral_state.h',
        'sync/sessions/status_counters.cc',
        'sync/sessions/status_counters.h',
        'sync/sessions/sync_session_snapshot.cc',
        'sync/sessions/sync_session_snapshot.h',
        'sync/sessions/type_debug_info_observer.cc',
        'sync/sessions/type_debug_info_observer.h',
        'sync/sessions/update_counters.cc',
        'sync/sessions/update_counters.h',
        'sync/core/shared_model_type_processor.h',
        'sync/core/shutdown_reason.h',
        'sync/core/simple_metadata_change_list.cc',
        'sync/core/simple_metadata_change_list.h',
        'sync/core/sync_auth_provider.h',
        'sync/core/sync_encryption_handler.cc',
        'sync/core/sync_encryption_handler.h',
        'sync/core/sync_manager.cc',
        'sync/core/sync_manager.h',
        'sync/core/sync_manager_factory.h',
        'sync/core/user_share.h',
        'sync/base/experiments.h',
        'sync/base/immutable.h',
        'sync/base/proto_value_ptr.h',
        'sync/base/sync_db_util.h',
        'sync/base/sync_string_conversions.cc',
        'sync/base/sync_string_conversions.h',
        'sync/base/syncer_error.cc',
        'sync/base/syncer_error.h',
        'sync/base/unrecoverable_error_handler.h',
        'sync/base/unrecoverable_error_info.cc',
        'sync/base/unrecoverable_error_info.h',
        'sync/base/weak_handle.cc',
        'sync/base/weak_handle.h',
        'sync/core/write_node.h',
        'sync/core/write_transaction.h',
        'sync/core/read_node.cc',
        'sync/core/read_transaction.cc',
        'sync/core/shared_model_type_processor.cc',
        'sync/core/sync_db_util.cc',
        'sync/core_impl/sync_encryption_handler_impl.cc',
        'sync/core_impl/sync_encryption_handler_impl.h',
        'sync/core/sync_manager_factory.cc',
        'sync/core_impl/sync_manager_impl.cc',
        'sync/core_impl/sync_manager_impl.h',
        'sync/core_impl/syncapi_internal.cc',
        'sync/core_impl/syncapi_internal.h',
        'sync/core_impl/syncapi_server_connection_manager.cc',
        'sync/core_impl/syncapi_server_connection_manager.h',
        'sync/core/user_share.cc',
        'sync/core/write_node.cc',
        'sync/core/write_transaction.cc',
        'sync/js/js_backend.h',
        'sync/js/js_controller.h',
        'sync/js/js_event_details.cc',
        'sync/js/js_event_details.h',
        'sync/js/js_event_handler.h',
        'sync/js/sync_js_controller.cc',
        'sync/js/sync_js_controller.h',
        'sync/protocol/proto_enum_conversions.cc',
        'sync/protocol/proto_enum_conversions.h',
        'sync/protocol/proto_value_conversions.cc',
        'sync/protocol/proto_value_conversions.h',
        'sync/protocol/sync_protocol_error.cc',
        'sync/protocol/sync_protocol_error.h',
        'sync/sessions_impl/data_type_tracker.cc',
        'sync/sessions_impl/data_type_tracker.h',
        'sync/sessions_impl/debug_info_getter.h',
        'sync/sessions_impl/directory_type_debug_info_emitter.cc',
        'sync/sessions_impl/directory_type_debug_info_emitter.h',
        'sync/sessions_impl/model_type_registry.cc',
        'sync/sessions_impl/model_type_registry.h',
        'sync/sessions_impl/nudge_tracker.cc',
        'sync/sessions_impl/nudge_tracker.h',
        'sync/sessions_impl/status_controller.cc',
        'sync/sessions_impl/status_controller.h',
        'sync/sessions_impl/sync_session.cc',
        'sync/sessions_impl/sync_session.h',
        'sync/sessions_impl/sync_session_context.cc',
        'sync/sessions_impl/sync_session_context.h',
        'sync/syncable/dir_open_result.h',
        'sync/syncable/directory.cc',
        'sync/syncable/directory.h',
        'sync/syncable/directory_backing_store.cc',
        'sync/syncable/directory_backing_store.h',
        'sync/syncable/directory_change_delegate.h',
        'sync/syncable/entry.cc',
        'sync/syncable/entry.h',
        'sync/syncable/entry_kernel.cc',
        'sync/syncable/entry_kernel.h',
        'sync/syncable/in_memory_directory_backing_store.cc',
        'sync/syncable/in_memory_directory_backing_store.h',
        'sync/syncable/invalid_directory_backing_store.cc',
        'sync/syncable/invalid_directory_backing_store.h',
        'sync/syncable/metahandle_set.h',
        'sync/syncable/model_neutral_mutable_entry.cc',
        'sync/syncable/model_neutral_mutable_entry.h',
        'sync/syncable/model_type.cc',
        'sync/syncable/mutable_entry.cc',
        'sync/syncable/mutable_entry.h',
        'sync/syncable/nigori_handler.cc',
        'sync/syncable/nigori_handler.h',
        'sync/syncable/nigori_util.cc',
        'sync/syncable/nigori_util.h',
        'sync/syncable/on_disk_directory_backing_store.cc',
        'sync/syncable/on_disk_directory_backing_store.h',
        'sync/syncable/parent_child_index.cc',
        'sync/syncable/parent_child_index.h',
        'sync/syncable/scoped_kernel_lock.cc',
        'sync/syncable/scoped_kernel_lock.h',
        'sync/syncable/scoped_parent_child_index_updater.cc',
        'sync/syncable/scoped_parent_child_index_updater.h',
        'sync/syncable/syncable-inl.h',
        'sync/syncable/syncable_base_transaction.cc',
        'sync/syncable/syncable_base_transaction.h',
        'sync/syncable/syncable_base_write_transaction.cc',
        'sync/syncable/syncable_base_write_transaction.h',
        'sync/syncable/syncable_changes_version.h',
        'sync/syncable/syncable_columns.h',
        'sync/syncable/syncable_delete_journal.cc',
        'sync/syncable/syncable_delete_journal.h',
        'sync/syncable/syncable_enum_conversions.cc',
        'sync/syncable/syncable_enum_conversions.h',
        'sync/syncable/syncable_id.cc',
        'sync/syncable/syncable_id.h',
        'sync/syncable/syncable_model_neutral_write_transaction.cc',
        'sync/syncable/syncable_model_neutral_write_transaction.h',
        'sync/syncable/syncable_proto_util.cc',
        'sync/syncable/syncable_proto_util.h',
        'sync/syncable/syncable_read_transaction.cc',
        'sync/syncable/syncable_read_transaction.h',
        'sync/syncable/syncable_util.cc',
        'sync/syncable/syncable_util.h',
        'sync/syncable/syncable_write_transaction.cc',
        'sync/syncable/syncable_write_transaction.h',
        'sync/syncable/transaction_observer.h',
        'sync/syncable/write_transaction_info.cc',
        'sync/syncable/write_transaction_info.h',
        'sync/base/cryptographer.cc',
        'sync/base/cryptographer.h',
        'sync/base/data_type_histogram.cc',
        'sync/base/data_type_histogram.h',
        'sync/base/encryptor.h',
        'sync/base/extensions_activity.cc',
        'sync/base/extensions_activity.h',
        'sync/base/get_session_name.cc',
        'sync/base/get_session_name.h',
        'sync/base/get_session_name_ios.h',
        'sync/base/get_session_name_ios.mm',
        'sync/base/get_session_name_linux.cc',
        'sync/base/get_session_name_linux.h',
        'sync/base/get_session_name_mac.h',
        'sync/base/get_session_name_mac.mm',
        'sync/base/get_session_name_win.cc',
        'sync/base/get_session_name_win.h',
        'sync/base/logging.cc',
        'sync/base/logging.h',
        'sync/base/nigori.cc',
        'sync/base/nigori.h',
        'sync/base/time.cc',
        'sync/base/time.h',
        'sync/driver/about_sync_util.cc',
        'sync/driver/about_sync_util.h',
        'sync/driver/backend_data_type_configurer.cc',
        'sync/driver/backend_data_type_configurer.h',
        'sync/driver/backend_migrator.cc',
        'sync/driver/backend_migrator.h',
        'sync/driver/change_processor.cc',
        'sync/driver/change_processor.h',
        'sync/driver/data_type_controller.cc',
        'sync/driver/data_type_controller.h',
        'sync/driver/data_type_encryption_handler.cc',
        'sync/driver/data_type_encryption_handler.h',
        'sync/driver/data_type_manager.cc',
        'sync/driver/data_type_manager.h',
        'sync/driver/data_type_manager_impl.cc',
        'sync/driver/data_type_manager_impl.h',
        'sync/driver/data_type_manager_observer.h',
        'sync/driver/data_type_status_table.cc',
        'sync/driver/data_type_status_table.h',
        'sync/driver/device_count_metrics_provider.cc',
        'sync/driver/device_count_metrics_provider.h',
        'sync/driver/device_info.cc',
        'sync/driver/device_info.h',
        'sync/driver/device_info_data_type_controller.cc',
        'sync/driver/device_info_data_type_controller.h',
        'sync/driver/device_info_service.cc',
        'sync/driver/device_info_service.h',
        'sync/driver/device_info_sync_service.cc',
        'sync/driver/device_info_sync_service.h',
        'sync/driver/device_info_tracker.h',
        'sync/driver/device_info_util.cc',
        'sync/driver/device_info_util.h',
        'sync/driver/directory_data_type_controller.cc',
        'sync/driver/directory_data_type_controller.h',
        'sync/driver/frontend_data_type_controller.cc',
        'sync/driver/frontend_data_type_controller.h',
        'sync/driver/generic_change_processor.cc',
        'sync/driver/generic_change_processor.h',
        'sync/driver/generic_change_processor_factory.cc',
        'sync/driver/generic_change_processor_factory.h',
        'sync/driver/glue/browser_thread_model_worker.cc',
        'sync/driver/glue/browser_thread_model_worker.h',
        'sync/driver/glue/chrome_report_unrecoverable_error.cc',
        'sync/driver/glue/chrome_report_unrecoverable_error.h',
        'sync/driver/glue/sync_backend_host.cc',
        'sync/driver/glue/sync_backend_host.h',
        'sync/driver/glue/sync_backend_host_core.cc',
        'sync/driver/glue/sync_backend_host_core.h',
        'sync/driver/glue/sync_backend_host_impl.cc',
        'sync/driver/glue/sync_backend_host_impl.h',
        'sync/driver/glue/sync_backend_registrar.cc',
        'sync/driver/glue/sync_backend_registrar.h',
        'sync/driver/glue/ui_model_worker.cc',
        'sync/driver/glue/ui_model_worker.h',
        'sync/driver/invalidation_adapter.cc',
        'sync/driver/invalidation_adapter.h',
        'sync/driver/invalidation_helper.cc',
        'sync/driver/invalidation_helper.h',
        'sync/driver/local_device_info_provider.h',
        'sync/driver/local_device_info_provider_impl.cc',
        'sync/driver/local_device_info_provider_impl.h',
        'sync/driver/model_association_manager.cc',
        'sync/driver/model_association_manager.h',
        'sync/driver/model_associator.h',
        'sync/driver/non_blocking_data_type_controller.cc',
        'sync/driver/non_blocking_data_type_controller.h',
        'sync/driver/non_ui_data_type_controller.cc',
        'sync/driver/non_ui_data_type_controller.h',
        'sync/driver/non_ui_model_type_controller.cc',
        'sync/driver/non_ui_model_type_controller.h',
        'sync/driver/pref_names.cc',
        'sync/driver/pref_names.h',
        'sync/driver/profile_sync_auth_provider.cc',
        'sync/driver/profile_sync_auth_provider.h',
        'sync/driver/protocol_event_observer.cc',
        'sync/driver/protocol_event_observer.h',
        'sync/driver/proxy_data_type_controller.cc',
        'sync/driver/proxy_data_type_controller.h',
        'sync/driver/shared_change_processor.cc',
        'sync/driver/shared_change_processor.h',
        'sync/driver/shared_change_processor_ref.cc',
        'sync/driver/shared_change_processor_ref.h',
        'sync/driver/signin_manager_wrapper.cc',
        'sync/driver/signin_manager_wrapper.h',
        'sync/driver/startup_controller.cc',
        'sync/driver/startup_controller.h',
        'sync/driver/sync_api_component_factory.h',
        'sync/driver/sync_client.cc',
        'sync/driver/sync_client.h',
        'sync/driver/sync_driver_switches.cc',
        'sync/driver/sync_driver_switches.h',
        'sync/driver/sync_error_controller.cc',
        'sync/driver/sync_error_controller.h',
        'sync/driver/sync_frontend.cc',
        'sync/driver/sync_frontend.h',
        'sync/driver/sync_prefs.cc',
        'sync/driver/sync_prefs.h',
        'sync/driver/sync_service.cc',
        'sync/driver/sync_service.h',
        'sync/driver/sync_service_observer.cc',
        'sync/driver/sync_service_observer.h',
        'sync/driver/sync_service_utils.cc',
        'sync/driver/sync_service_utils.h',
        'sync/driver/sync_stopped_reporter.cc',
        'sync/driver/sync_stopped_reporter.h',
        'sync/driver/sync_type_preference_provider.h',
        'sync/driver/sync_util.cc',
        'sync/driver/sync_util.h',
        'sync/driver/system_encryptor.cc',
        'sync/driver/system_encryptor.h',
        'sync/driver/ui_data_type_controller.cc',
        'sync/driver/ui_data_type_controller.h',
        'sync/driver/ui_model_type_controller.cc',
        'sync/driver/ui_model_type_controller.h',
        'sync/driver/user_selectable_sync_type.h',
      ],

      'conditions': [
        ['OS=="linux" and chromeos==1', {
          # Required by get_session_name.cc on Chrome OS.
          'dependencies': [
            '../chromeos/chromeos.gyp:chromeos',
            ],
        }],
        ['OS=="mac"', {
          'link_settings': {
            'libraries': [
              # Required by get_session_name_mac.mm on Mac.
              '$(SDKROOT)/System/Library/Frameworks/SystemConfiguration.framework',
            ]
          },
        }],
        ['OS=="android"', {
          'dependencies': [
            'sync_jni_headers',
          ],
          'sources': [
            'sync/android/model_type_helper.cc',
            'sync/android/model_type_helper.h',
            'sync/android/sync_jni_registrar.cc',
            'sync/android/sync_jni_registrar.h',
          ],
        }],
        ['configuration_policy==1', {
          'dependencies': [
            'components.gyp:policy',
            'components.gyp:policy_component',
          ],
          'sources': [
            'sync/driver/sync_policy_handler.cc',
            'sync/driver/sync_policy_handler.h',
          ],
        }],
      ],
    },
    {
      # Contains sync protobuf definitions.  Do not depend on this directly.
      # Depend on the 'sync' target to get the relevant C++ code, too.
      #
      # GN version: //components/sync/protocol
      'target_name': 'sync_proto',
      'type': '<(component)',
      'include_dirs': [
        '..',
      ],
      'defines': [
        'SYNC_PROTO_IMPLEMENTATION',
      ],
      'sources': [
        # When adding a new proto source file, add its path to the list defined
        # in sync/protocol/protocol.gypi.
        '<@(sync_proto_sources)',
      ],
      'variables': {
        'enable_wexit_time_destructors': 1,
        'proto_in_dir': './sync/protocol',
        'proto_out_dir': 'components/sync/protocol',
        'cc_generator_options': 'dllexport_decl=SYNC_PROTO_EXPORT:',
        'cc_include': 'components/sync/protocol/sync_proto_export.h',
      },
      'includes': [
        '../build/protoc.gypi'
      ],
    },
    {
      # Contains attachment_store protobuf definitions.  Do not depend on this
      # directly.
      # Depend on the 'sync' target to get the relevant C++ code, too.
      #
      # GN version: //components/sync/core_impl/attachments/proto
      'target_name': 'attachment_store_proto',
      'type': 'static_library',
      'sources': [
        # NOTE: If you add a file to this list, also add it to
        # sync/core_impl/attachments/proto/BUILD.gn
        'sync/core_impl/attachments/proto/attachment_store.proto',
      ],
      'variables': {
        'enable_wexit_time_destructors': 1,
        'proto_in_dir': './sync/core_impl/attachments/proto',
        'proto_out_dir': 'components/sync/core_impl/attachments/proto',
        'cc_generator_options': 'dllexport_decl=SYNC_EXPORT:',
        'cc_include': 'components/sync/base/sync_export.h',
      },
      'includes': [
        '../build/protoc.gypi'
      ],
      'defines': [
        'SYNC_IMPLEMENTATION'
      ],
    },
  ],
}
