# Copyright 2013 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

{
  'targets': [
    # Test support files for the 'sync_core' target.
    # GN version: //components/sync:test_support_sync_core
    {
      'target_name': 'test_support_sync_core',
      'type': 'static_library',
      'variables': { 'enable_wexit_time_destructors': 1, },
      'include_dirs': [
        '..',
      ],
      'defines': [
        'SYNC_TEST'
      ],
      'dependencies': [
        '../base/base.gyp:base',
        '../testing/gmock.gyp:gmock',
        '../testing/gtest.gyp:gtest',
        'sync',
      ],
      'export_dependent_settings': [
        '../testing/gmock.gyp:gmock',
        '../testing/gtest.gyp:gtest',
        'sync',
      ],
      'sources': [
        'base/model_type_test_util.cc',
        'base/model_type_test_util.h',
        'js/js_test_util.cc',
        'js/js_test_util.h',
        'sessions_impl/test_util.cc',
        'sessions_impl/test_util.h',
        'test/callback_counter.h',
        "test/directory_backing_store_corruption_testing.cc",
        "test/directory_backing_store_corruption_testing.h",
        'test/engine/fake_model_worker.cc',
        'test/engine/fake_model_worker.h',
        'test/engine/fake_sync_scheduler.cc',
        'test/engine/fake_sync_scheduler.h',
        'test/engine/mock_connection_manager.cc',
        'test/engine/mock_connection_manager.h',
        'test/engine/mock_model_type_processor.cc',
        'test/engine/mock_model_type_processor.h',
        'test/engine/mock_model_type_worker.cc',
        'test/engine/mock_model_type_worker.h',
        'test/engine/mock_nudge_handler.cc',
        'test/engine/mock_nudge_handler.h',
        'test/engine/mock_update_handler.cc',
        'test/engine/mock_update_handler.h',
        'test/engine/single_type_mock_server.cc',
        'test/engine/single_type_mock_server.h',
        'test/engine/test_directory_setter_upper.cc',
        'test/engine/test_directory_setter_upper.h',
        'test/engine/test_id_factory.h',
        'test/engine/test_syncable_utils.cc',
        'test/engine/test_syncable_utils.h',
        'base/fake_encryptor.cc',
        'base/fake_encryptor.h',
        'test/fake_sync_encryption_handler.cc',
        'test/fake_sync_encryption_handler.h',
        'test/mock_invalidation.cc',
        'test/mock_invalidation.h',
        'test/mock_invalidation_tracker.cc',
        'test/mock_invalidation_tracker.h',
        'test/null_directory_change_delegate.cc',
        'test/null_directory_change_delegate.h',
        'test/null_transaction_observer.cc',
        'test/null_transaction_observer.h',
        'test/sessions/mock_debug_info_getter.cc',
        'test/sessions/mock_debug_info_getter.h',
        'test/sessions/test_scoped_session_event_listener.h',
        'test/test_directory_backing_store.cc',
        'test/test_directory_backing_store.h',
        'test/test_transaction_observer.cc',
        'test/test_transaction_observer.h',
        'test/trackable_mock_invalidation.cc',
        'test/trackable_mock_invalidation.h',
        'base/mock_unrecoverable_error_handler.cc',
        'base/mock_unrecoverable_error_handler.h',
        'base/test_unrecoverable_error_handler.cc',
        'base/test_unrecoverable_error_handler.h',
      ],
    },

    # Test support files for the python sync test server.
    # GN version: //components/sync:test_support_sync_testserver
    {
      'target_name': 'test_support_sync_testserver',
      'type': 'static_library',
      'variables': { 'enable_wexit_time_destructors': 1, },
      'include_dirs': [
        '..',
      ],
      'dependencies': [
        '../base/base.gyp:base',
        '../net/net.gyp:net_test_support',
        # The sync test server uses Python modules generated by the sync protos.
        '../third_party/protobuf/protobuf.gyp:py_proto',
        'sync',
      ],
      'export_dependent_settings': [
        '../base/base.gyp:base',
        '../net/net.gyp:net_test_support',
      ],
      'sources': [
        'test/local_sync_test_server.cc',
        'test/local_sync_test_server.h',
      ],
    },

    # Test support files for the fake sync server.
    # GN version: //components/sync:test_support_sync_fake_server
    {
      'target_name': 'test_support_sync_fake_server',
      'type': 'static_library',
      'variables': { 'enable_wexit_time_destructors': 1, },
      'include_dirs': [
        '..',
      ],
      'dependencies': [
        '../base/base.gyp:base',
        '../net/net.gyp:net',
        '../testing/gtest.gyp:gtest',
        '../third_party/protobuf/protobuf.gyp:protobuf_lite',
        'sync',
      ],
      'export_dependent_settings': [
        'sync',
      ],
      'sources': [
        'test/fake_server/bookmark_entity.cc',
        'test/fake_server/bookmark_entity.h',
        'test/fake_server/bookmark_entity_builder.cc',
        'test/fake_server/bookmark_entity_builder.h',
        'test/fake_server/entity_builder_factory.cc',
        'test/fake_server/entity_builder_factory.h',
        'test/fake_server/fake_server.cc',
        'test/fake_server/fake_server.h',
        'test/fake_server/fake_server_entity.cc',
        'test/fake_server/fake_server_entity.h',
        'test/fake_server/fake_server_http_post_provider.cc',
        'test/fake_server/fake_server_http_post_provider.h',
        'test/fake_server/fake_server_network_resources.cc',
        'test/fake_server/fake_server_network_resources.h',
        'test/fake_server/fake_server_verifier.cc',
        'test/fake_server/fake_server_verifier.h',
        'test/fake_server/permanent_entity.cc',
        'test/fake_server/permanent_entity.h',
        'test/fake_server/sessions_hierarchy.cc',
        'test/fake_server/sessions_hierarchy.h',
        'test/fake_server/tombstone_entity.cc',
        'test/fake_server/tombstone_entity.h',
        'test/fake_server/unique_client_entity.cc',
        'test/fake_server/unique_client_entity.h',
      ],
    },

    # Test support files for the 'sync_core_impl' target.
    # GN version: //components/sync:test_support_sync_core_impl
    {
      'target_name': 'test_support_sync_core_impl',
      'type': 'static_library',
      'variables': { 'enable_wexit_time_destructors': 1, },
      'include_dirs': [
        '..',
      ],
      'defines': [
        'SYNC_TEST'
      ],
      'dependencies': [
        '../base/base.gyp:base',
        '../testing/gtest.gyp:gtest',
        'sync',
        'test_support_sync_core',
      ],
      'export_dependent_settings': [
        '../testing/gtest.gyp:gtest',
        'sync',
        'test_support_sync_core',
      ],
      'sources': [
        'core/test/data_type_error_handler_mock.h',
        'core/test/fake_model_type_connector.h',
        'core/test/fake_model_type_processor.h',
        'core/test/fake_sync_manager.h',
        'core/test/model_type_store_test_util.h',
        'core/test/sync_manager_factory_for_profile_sync_test.h',
        'core/test/test_entry_factory.h',
        'core/test/test_internal_components_factory.h',
        'core/test/test_user_share.h',
        'core_impl/test/data_type_error_handler_mock.cc',
        'core_impl/test/fake_model_type_connector.cc',
        'core_impl/test/fake_model_type_processor.cc',
        'core_impl/test/fake_sync_manager.cc',
        'core_impl/test/model_type_store_test_util.cc',
        'core_impl/test/sync_manager_factory_for_profile_sync_test.cc',
        'core_impl/test/sync_manager_for_profile_sync_test.cc',
        'core_impl/test/sync_manager_for_profile_sync_test.h',
        'core_impl/test/test_entry_factory.cc',
        'core_impl/test/test_internal_components_factory.cc',
        'core_impl/test/test_user_share.cc',
      ],
    },

    # Test support files for the 'sync_api' target.
    # GN version: //components/sync:test_support_sync_api
    {
      'target_name': 'test_support_sync_api',
      'type': 'static_library',
      'include_dirs': [
        '..',
      ],
      'defines': [
        'SYNC_TEST'
      ],
      'dependencies': [
        '../testing/gmock.gyp:gmock',
        'sync',
      ],
      'export_dependent_settings': [
        '../testing/gmock.gyp:gmock',
        'sync',
      ],
      'sources': [
        'api/fake_model_type_change_processor.cc',
        'api/fake_model_type_change_processor.h',
        'api/fake_model_type_service.cc',
        'api/fake_model_type_service.h',
        'api/fake_sync_change_processor.cc',
        'api/fake_sync_change_processor.h',
        'api/fake_syncable_service.cc',
        'api/fake_syncable_service.h',
        'api/mock_model_type_store.cc',
        'api/mock_model_type_store.h',
        'api/sync_change_processor_wrapper_for_test.cc',
        'api/sync_change_processor_wrapper_for_test.h',
        'api/sync_error_factory_mock.cc',
        'api/sync_error_factory_mock.h',
      ],
    },
    {
      'target_name': 'test_support_sync_driver',
      'type': 'static_library',
      'dependencies': [
        'sync',
        'test_support_sync_core_impl',
        'components.gyp:version_info',
        '../base/base.gyp:base',
        '../testing/gmock.gyp:gmock',
        '../testing/gtest.gyp:gtest',
      ],
      'include_dirs': [
        '..',
      ],
      'sources': [
        'driver/change_processor_mock.cc',
        'driver/change_processor_mock.h',
        'driver/data_type_controller_mock.cc',
        'driver/data_type_controller_mock.h',
        'driver/data_type_manager_mock.cc',
        'driver/data_type_manager_mock.h',
        'driver/fake_data_type_controller.cc',
        'driver/fake_data_type_controller.h',
        'driver/fake_generic_change_processor.cc',
        'driver/fake_generic_change_processor.h',
        'driver/fake_sync_client.cc',
        'driver/fake_sync_client.h',
        'driver/fake_sync_service.cc',
        'driver/fake_sync_service.h',
        'driver/frontend_data_type_controller_mock.cc',
        'driver/frontend_data_type_controller_mock.h',
        'driver/glue/sync_backend_host_mock.cc',
        'driver/glue/sync_backend_host_mock.h',
        'driver/local_device_info_provider_mock.cc',
        'driver/local_device_info_provider_mock.h',
        'driver/model_associator_mock.cc',
        'driver/model_associator_mock.h',
        'driver/non_ui_data_type_controller_mock.cc',
        'driver/non_ui_data_type_controller_mock.h',
        'driver/sync_api_component_factory_mock.cc',
        'driver/sync_api_component_factory_mock.h',
      ],
    },
  ],
  'conditions': [
    ['OS != "ios"', {
      'targets': [
        # A tool that can be used to launch a python sync server instance.
        {
          'target_name': 'run_sync_testserver',
          'type': 'executable',
          'dependencies': [
            '../base/base.gyp:base',
            '../base/base.gyp:test_support_base',
            '../net/net.gyp:net_test_support',
            '../testing/gtest.gyp:gtest',
            'test_support_sync_testserver',
          ],
          'sources': [
            'tools/testserver/run_sync_testserver.cc',
          ],
        },
      ],
    }],
    ['OS == "android"', {
      'targets': [
        {
          # GN: //components/sync/android:sync_javatests
          'target_name': 'sync_javatests',
          'type': 'none',
          'variables': {
            'java_in_dir': '../components/sync/android/javatests',
          },
          'dependencies': [
            'sync_java',
            'sync_java_test_support',
            '../base/base.gyp:base_java_test_support',
          ],
          'includes': [ '../../build/java.gypi' ],
        },
        {
          # GN: //components/sync:sync_java_test_support
          'target_name': 'sync_java_test_support',
          'type': 'none',
          'variables': {
            'java_in_dir': '../components/sync/test/android/javatests',
          },
          'dependencies': [
            'sync_java',
            '../base/base.gyp:base_java_test_support',
          ],
          'includes': [ '../../build/java.gypi' ],
        },
        {
          # GN: //components/sync:sync_fake_server_jni_headers
          'target_name': 'sync_fake_server_jni_headers',
          'type': 'none',
          'sources': [
            '../chrome/android/sync_shell/javatests/src/org/chromium/chrome/browser/sync/FakeServerHelper.java',
          ],
          'variables': {
            'jni_gen_package': 'sync/test/fake_server',
            'jni_generator_ptr_type': 'long',
          },
          'includes': [ '../../build/jni_generator.gypi' ],
        },
        {
          # GN: //components/sync:test_support_sync_proto_java
          'target_name': 'test_support_sync_proto_java',
          'type': 'none',
          'variables': {
            'proto_in_dir': '<(INTERMEDIATE_DIR)/sync_protos',
            # Set this variable so that sync_proto_source_paths refers to the
            # temporary proto definitions created here.
            'sync_proto_sources_dir': '<(INTERMEDIATE_DIR)/sync_protos',
          },
          'actions': [
            {
              'action_name': 'run_script',
              'inputs': [
                'protocol/prepare_protos_for_java_tests.py',
                # Use the original list of proto files (defined in sync.gyp).
                '<@(sync_proto_sources)',
              ],
              'outputs': [
                '<@(sync_proto_source_paths)',
              ],
              'action': [
                'python',
                'protocol/prepare_protos_for_java_tests.py',
                '--output_dir',
                '<(INTERMEDIATE_DIR)/sync_protos',
                # Use the original list of proto files (defined in sync.gyp).
                '<@(sync_proto_sources)'
              ],
            },
          ],
          'sources': [
            '<@(sync_proto_source_paths)',
          ],
          'includes': ['protocol/protocol.gypi', '../../build/protoc_java.gypi'],
        },
        {
          # GN: //components/sync:test_support_sync_fake_server_android
          'target_name': 'test_support_sync_fake_server_android',
          'type': 'static_library',
          'dependencies': [
            'sync_fake_server_jni_headers',
            'test_support_sync_fake_server',
            '../testing/gtest.gyp:gtest',
            '../base/base.gyp:base',
          ],
          'export_dependent_settings': [
            '../testing/gtest.gyp:gtest',
          ],
          'sources': [
            'test/fake_server/android/fake_server_helper_android.cc',
            'test/fake_server/android/fake_server_helper_android.h',
          ],
        },
      ],
    }],
  ],
}
