// Copyright 2015 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_CHROMEOS_LOGIN_USERS_AFFILIATION_H_
#define CHROME_BROWSER_CHROMEOS_LOGIN_USERS_AFFILIATION_H_

#include <set>
#include <string>

namespace chromeos {

typedef std::set<std::string> AffiliationIDSet;

// Returns true if there is at least one common element in two sets.
// Complexity: O(n + m), where n - size of the first set, m - size of
// the second set.
bool HaveCommonElement(const std::set<std::string>& set1,
                       const std::set<std::string>& set2);

// TODO(peletskyi): Remove email and enterprise domain after affiliation
// based implementation will fully work. http://crbug.com/515476
// The function makes a decision if user with |user_affiliation_ids| and
// |email| is affiliated on the device with |device_affiliation_ids| and
// |enterprise_domain|.
bool IsUserAffiliated(const AffiliationIDSet& user_affiliation_ids,
                      const AffiliationIDSet& device_affiliation_ids,
                      const std::string& email,
                      const std::string& enterprise_domain);

}  // namespace chromeos

#endif  // CHROME_BROWSER_CHROMEOS_LOGIN_USERS_AFFILIATION_H_
