// Copyright (c) 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_CERTIFICATE_VIEWER_MAC_H_
#define CHROME_BROWSER_UI_CERTIFICATE_VIEWER_MAC_H_

#import <Cocoa/Cocoa.h>
#import <SecurityInterface/SFCertificatePanel.h>

namespace content {
class WebContents;
}

namespace net {
class X509Certificate;
}

// Base class for the certificate viewer generated by macOS for Chrome Mac.
// It grabs the certificates for a given WebContents object and displays the
// certificate viewer.
@interface SSLCertificateViewerMac : NSObject

// Initializes |certificates_| with the certificate chain for a given
// certificate.
- (instancetype)initWithCertificate:(net::X509Certificate*)certificate
                     forWebContents:(content::WebContents*)webContents;

// Shows the certificate viewer as a Cocoa sheet.
- (void)showCertificateSheet:(NSWindow*)window;

// Closes the certificate viewer sheet, but doesn't release it.
- (void)closeCertificateSheet;

// Releases the native SFCertificatePanel window sheet created in
// initWithCertificate:forWebContents:.
- (void)releaseSheetWindow;

// Returns the certificate panel used as the certificate viewer sheet.
- (NSWindow*)certificatePanel;

@end

// SSLCertificateViewerMac is split into two interfaces to separate the public
// interface (above) to the one only subclasses need to know (below).
@interface SSLCertificateViewerMac (Protected)
// Closes the certificate viewer Cocoa sheet. Subclasses must implement this.
- (void)sheetDidEnd:(NSWindow*)parent
         returnCode:(NSInteger)returnCode
            context:(void*)context;
@end

#endif  // CHROME_BROWSER_UI_CERTIFICATE_VIEWER_MAC_H_
