// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/bookmarks/browser/bookmark_match.h"

#include "base/logging.h"
#include "base/strings/string16.h"

namespace bookmarks {

BookmarkMatch::BookmarkMatch() : node(NULL) {}

BookmarkMatch::BookmarkMatch(const BookmarkMatch& other) = default;

BookmarkMatch::~BookmarkMatch() {}

// static
std::vector<size_t> BookmarkMatch::OffsetsFromMatchPositions(
    const MatchPositions& match_positions) {
  std::vector<size_t> offsets;
  for (MatchPositions::const_iterator i = match_positions.begin();
       i != match_positions.end(); ++i) {
    offsets.push_back(i->first);
    offsets.push_back(i->second);
  }
  return offsets;
}

// static
BookmarkMatch::MatchPositions BookmarkMatch::ReplaceOffsetsInMatchPositions(
    const MatchPositions& match_positions,
    const std::vector<size_t>& offsets) {
  DCHECK_EQ(2 * match_positions.size(), offsets.size());
  MatchPositions new_match_positions;
  std::vector<size_t>::const_iterator offset_iter = offsets.begin();
  for (MatchPositions::const_iterator match_iter = match_positions.begin();
       match_iter != match_positions.end(); ++match_iter, ++offset_iter) {
    const size_t begin = *offset_iter;
    ++offset_iter;
    const size_t end = *offset_iter;
    if ((begin != base::string16::npos) && (end != base::string16::npos)) {
      const MatchPosition new_match_position(begin, end);
      new_match_positions.push_back(new_match_position);
    }
  }
  return new_match_positions;
}

}  // namespace bookmarks
