// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef BLIMP_CLIENT_SUPPORT_COMPOSITOR_BLIMP_GPU_MEMORY_BUFFER_MANAGER_H_
#define BLIMP_CLIENT_SUPPORT_COMPOSITOR_BLIMP_GPU_MEMORY_BUFFER_MANAGER_H_

#include <memory>

#include "base/macros.h"
#include "cc/output/buffer_to_texture_target_map.h"
#include "gpu/command_buffer/client/gpu_memory_buffer_manager.h"

namespace blimp {
namespace client {

class BlimpGpuMemoryBufferManager : public gpu::GpuMemoryBufferManager {
 public:
  BlimpGpuMemoryBufferManager();
  ~BlimpGpuMemoryBufferManager() override;

  static cc::BufferToTextureTargetMap GetDefaultBufferToTextureTargetMap();

  // Overridden from gpu::GpuMemoryBufferManager:
  std::unique_ptr<gfx::GpuMemoryBuffer> CreateGpuMemoryBuffer(
      const gfx::Size& size,
      gfx::BufferFormat format,
      gfx::BufferUsage usage,
      gpu::SurfaceHandle surface_handle) override;
  void SetDestructionSyncToken(gfx::GpuMemoryBuffer* buffer,
                               const gpu::SyncToken& sync_token) override;

 private:
  DISALLOW_COPY_AND_ASSIGN(BlimpGpuMemoryBufferManager);
};

}  // namespace client
}  // namespace blimp

#endif  // BLIMP_CLIENT_SUPPORT_COMPOSITOR_BLIMP_GPU_MEMORY_BUFFER_MANAGER_H_
