// Copyright 2015 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "android_webview/lib/main/webview_jni_onload.h"
#include "base/android/jni_android.h"
#include "base/android/library_loader/library_loader_hooks.h"
#include "base/bind.h"
#include "chrome/app/android/chrome_jni_onload.h"

namespace {

bool NativeInit() {
  JNIEnv* env = base::android::AttachCurrentThread();
  int library_process_type = base::android::GetLibraryProcessType(env);
  switch (library_process_type) {
    case base::android::PROCESS_WEBVIEW:
    case base::android::PROCESS_WEBVIEW_CHILD:
      return android_webview::OnJNIOnLoadInit();
      break;
    case base::android::PROCESS_BROWSER:
    case base::android::PROCESS_CHILD:
      return android::OnJNIOnLoadInit();
      break;
    default:
      NOTREACHED();
      return false;
  }
}

}  // namespace

// This is called by the VM when the shared library is first loaded.
JNI_EXPORT jint JNI_OnLoad(JavaVM* vm, void* reserved) {
  base::android::InitVM(vm);
  base::android::SetJniRegistrationType(base::android::NO_JNI_REGISTRATION);
  base::android::SetNativeInitializationHook(NativeInit);
  return JNI_VERSION_1_4;
}
