// Copyright 2017 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef NET_CERT_X509_UTIL_IOS_H_
#define NET_CERT_X509_UTIL_IOS_H_

#include <Security/Security.h>

#include "base/mac/scoped_cftyperef.h"
#include "net/base/net_export.h"

namespace net {

class X509Certificate;

namespace x509_util {

// Returns a SecCertificate representing |cert|, or NULL on failure.
NET_EXPORT base::ScopedCFTypeRef<SecCertificateRef>
CreateSecCertificateFromX509Certificate(const X509Certificate* cert);

}  // namespace x509_util

}  // namespace net

#endif  // NET_CERT_X509_UTIL_IOS_H_
