// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_INSTALL_STATIC_USER_DATA_DIR_H_
#define CHROME_INSTALL_STATIC_USER_DATA_DIR_H_

#include <string>

namespace install_static {

struct InstallConstants;

// Populates |result| with the user data dir, respecting various overrides in
// the manner of chrome_main_delegate.cc InitializeUserDataDir(). This includes
// overrides on the command line, overrides by registry policy, and fallback to
// the default User Data dir if the directory is invalid or unspecified.
//
// If a directory was given by the user (either on the command line, or by
// registry policy), but it was invalid or unusable, then
// |invalid_supplied_directory| will be filled with the value that was unusable
// for reporting an error to the user.
//
// Other than in test situations, it is generally only appropriate to call this
// function once on startup and use the result for subsequent callers, otherwise
// there's a race with registry modification (which could cause a different
// derivation) so different subsystems would see different values). In normal
// usage, it should be called only once and cached.
bool DeriveUserDataDirectoryImpl(
    const std::wstring& user_data_dir_from_command_line,
    const InstallConstants& mode,
    std::wstring* result,
    std::wstring* invalid_supplied_directory);

// Retrieves the user data directory, and any invalid directory specified on the
// command line, for reporting an error to the user. This function should only
// be called once on startup and the result should be cached, to avoid
// derivation inconsistencies.
bool DeriveUserDataDirectory(const InstallConstants& mode,
                             std::wstring* user_data_directory,
                             std::wstring* invalid_user_data_directory);

}  // namespace install_static

#endif  // CHROME_INSTALL_STATIC_USER_DATA_DIR_H_
