# Copyright 2012 the V8 project authors. All rights reserved.
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
#
#     * Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimer.
#     * Redistributions in binary form must reproduce the above
#       copyright notice, this list of conditions and the following
#       disclaimer in the documentation and/or other materials provided
#       with the distribution.
#     * Neither the name of Google Inc. nor the names of its
#       contributors may be used to endorse or promote products derived
#       from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

{
  'variables': {
    'v8_code': 1,
    'v8_random_seed%': 314159265,
    'v8_vector_stores%': 0,
    'embed_script%': "",
    'warmup_script%': "",
    'v8_extra_library_files%': [],
    'v8_experimental_extra_library_files%': [],
    'mksnapshot_exec': '<(PRODUCT_DIR)/<(EXECUTABLE_PREFIX)mksnapshot<(EXECUTABLE_SUFFIX)',
    'v8_os_page_size%': 0,
  },
  'includes': ['../gypfiles/toolchain.gypi', '../gypfiles/features.gypi', 'inspector/inspector.gypi'],
  'targets': [
    {
      'target_name': 'v8',
      'dependencies_traverse': 1,
      'dependencies': ['v8_maybe_snapshot'],
      'conditions': [
        ['want_separate_host_toolset==1', {
          'toolsets': ['host', 'target'],
        }, {
          'toolsets': ['target'],
        }],
        ['component=="shared_library"', {
          'type': '<(component)',
          'sources': [
            # Note: on non-Windows we still build this file so that gyp
            # has some sources to link into the component.
            'v8dll-main.cc',
          ],
          'include_dirs': [
            '..',
          ],
          'defines': [
            'BUILDING_V8_SHARED',
          ],
          'direct_dependent_settings': {
            'defines': [
              'USING_V8_SHARED',
            ],
          },
          'conditions': [
            ['OS=="mac"', {
              'xcode_settings': {
                'OTHER_LDFLAGS': ['-dynamiclib', '-all_load']
              },
            }],
            ['soname_version!=""', {
              'product_extension': 'so.<(soname_version)',
            }],
          ],
        },
        {
          'type': 'none',
        }],
      ],
      'direct_dependent_settings': {
        'include_dirs': [
          '../include',
        ],
      },
    },
    {
      # This rule delegates to either v8_snapshot, v8_nosnapshot, or
      # v8_external_snapshot, depending on the current variables.
      # The intention is to make the 'calling' rules a bit simpler.
      'target_name': 'v8_maybe_snapshot',
      'type': 'none',
      'conditions': [
        ['v8_use_snapshot!="true"', {
          # The dependency on v8_base should come from a transitive
          # dependency however the Android toolchain requires libv8_base.a
          # to appear before libv8_snapshot.a so it's listed explicitly.
          'dependencies': ['v8_base', 'v8_builtins_setup', 'v8_nosnapshot'],
        }],
        ['v8_use_snapshot=="true" and v8_use_external_startup_data==0', {
          # The dependency on v8_base should come from a transitive
          # dependency however the Android toolchain requires libv8_base.a
          # to appear before libv8_snapshot.a so it's listed explicitly.
          'dependencies': ['v8_base', 'v8_snapshot'],
        }],
        ['v8_use_snapshot=="true" and v8_use_external_startup_data==1 and want_separate_host_toolset==0', {
          'dependencies': ['v8_base', 'v8_external_snapshot'],
          'inputs': [ '<(PRODUCT_DIR)/snapshot_blob.bin', ],
        }],
        ['v8_use_snapshot=="true" and v8_use_external_startup_data==1 and want_separate_host_toolset==1', {
          'dependencies': ['v8_base', 'v8_external_snapshot'],
          'target_conditions': [
            ['_toolset=="host"', {
              'inputs': [
                '<(PRODUCT_DIR)/snapshot_blob_host.bin',
              ],
            }, {
              'inputs': [
                '<(PRODUCT_DIR)/snapshot_blob.bin',
              ],
            }],
          ],
        }],
        ['want_separate_host_toolset==1', {
          'toolsets': ['host', 'target'],
        }, {
          'toolsets': ['target'],
        }],
      ]
    },
    {
      'target_name': 'v8_builtins_setup',
      'type': 'static_library',
      'dependencies': [
        'v8_builtins_generators',
      ],
      'variables': {
        'optimize': 'max',
      },
      'include_dirs+': [
        '..',
        '../include',
      ],
      'sources': [  ### gcmole(all) ###
        'setup-isolate-full.cc',
      ],
      'conditions': [
        ['want_separate_host_toolset==1', {
          'toolsets': ['host', 'target'],
        }, {
          'toolsets': ['target'],
        }],
      ],
    },
    {
      'target_name': 'v8_builtins_generators',
      'type': 'static_library',
      'dependencies': [
        'v8_base',
      ],
       'variables': {
        'optimize': 'max',
      },
      'include_dirs+': [
        '..',
        '../include',
      ],
      'sources': [  ### gcmole(all) ###
        'builtins/builtins-arguments-gen.cc',
        'builtins/builtins-arguments-gen.h',
        'builtins/builtins-array-gen.cc',
        'builtins/builtins-async-function-gen.cc',
        'builtins/builtins-async-gen.cc',
        'builtins/builtins-async-gen.h',
        'builtins/builtins-async-generator-gen.cc',
        'builtins/builtins-async-iterator-gen.cc',
        'builtins/builtins-boolean-gen.cc',
        'builtins/builtins-call-gen.cc',
        'builtins/builtins-call-gen.h',
        'builtins/builtins-collections-gen.cc',
        'builtins/builtins-console-gen.cc',
        'builtins/builtins-constructor-gen.cc',
        'builtins/builtins-constructor-gen.h',
        'builtins/builtins-constructor.h',
        'builtins/builtins-conversion-gen.cc',
        'builtins/builtins-conversion-gen.h',
        'builtins/builtins-date-gen.cc',
        'builtins/builtins-debug-gen.cc',
        'builtins/builtins-forin-gen.cc',
        'builtins/builtins-forin-gen.h',
        'builtins/builtins-function-gen.cc',
        'builtins/builtins-generator-gen.cc',
        'builtins/builtins-global-gen.cc',
        'builtins/builtins-handler-gen.cc',
        'builtins/builtins-ic-gen.cc',
        'builtins/builtins-internal-gen.cc',
        'builtins/builtins-interpreter-gen.cc',
        'builtins/builtins-intl-gen.cc',
        'builtins/builtins-iterator-gen.h',
        'builtins/builtins-iterator-gen.cc',
        'builtins/builtins-math-gen.cc',
        'builtins/builtins-number-gen.cc',
        'builtins/builtins-object-gen.cc',
        'builtins/builtins-promise-gen.cc',
        'builtins/builtins-promise-gen.h',
        'builtins/builtins-regexp-gen.cc',
        'builtins/builtins-regexp-gen.h',
        'builtins/builtins-sharedarraybuffer-gen.cc',
        'builtins/builtins-string-gen.cc',
        'builtins/builtins-string-gen.h',
        'builtins/builtins-symbol-gen.cc',
        'builtins/builtins-typedarray-gen.cc',
        'builtins/builtins-utils-gen.h',
        'builtins/builtins-wasm-gen.cc',
        'builtins/setup-builtins-internal.cc',
        'ic/accessor-assembler.cc',
        'ic/accessor-assembler.h',
        'ic/binary-op-assembler.cc',
        'ic/binary-op-assembler.h',
        'ic/keyed-store-generic.cc',
        'ic/keyed-store-generic.h',
        'interpreter/interpreter-assembler.cc',
        'interpreter/interpreter-assembler.h',
        'interpreter/interpreter-generator.cc',
        'interpreter/interpreter-generator.h',
        'interpreter/interpreter-intrinsics-generator.cc',
        'interpreter/interpreter-intrinsics-generator.h',
        'interpreter/setup-interpreter-internal.cc',
        'interpreter/setup-interpreter.h',
      ],
      'conditions': [
        ['want_separate_host_toolset==1', {
          'toolsets': ['host', 'target'],
        }, {
          'toolsets': ['target'],
        }],
        ['v8_target_arch=="ia32"', {
          'sources': [  ### gcmole(arch:ia32) ###
            'builtins/ia32/builtins-ia32.cc',
          ],
        }],
        ['v8_target_arch=="x64"', {
          'sources': [  ### gcmole(arch:x64) ###
            'builtins/x64/builtins-x64.cc',
          ],
        }],
        ['v8_target_arch=="arm"', {
          'sources': [  ### gcmole(arch:arm) ###
            'builtins/arm/builtins-arm.cc',
          ],
        }],
        ['v8_target_arch=="arm64"', {
          'sources': [  ### gcmole(arch:arm64) ###
            'builtins/arm64/builtins-arm64.cc',
          ],
        }],
        ['v8_target_arch=="mips" or v8_target_arch=="mipsel"', {
          'sources': [  ### gcmole(arch:mipsel) ###
            'builtins/mips/builtins-mips.cc',
          ],
        }],
        ['v8_target_arch=="mips64" or v8_target_arch=="mips64el"', {
          'sources': [  ### gcmole(arch:mips64el) ###
            'builtins/mips64/builtins-mips64.cc',
          ],
        }],
        ['v8_target_arch=="ppc" or v8_target_arch=="ppc64"', {
          'sources': [  ### gcmole(arch:ppc) ###
            'builtins/ppc/builtins-ppc.cc',
          ],
        }],
        ['v8_target_arch=="s390" or v8_target_arch=="s390x"', {
          'sources': [  ### gcmole(arch:s390) ###
            'builtins/s390/builtins-s390.cc',
          ],
        }],
        ['v8_target_arch=="x87"', {
          'sources': [  ### gcmole(arch:x87) ###
            'builtins/x87/builtins-x87.cc',
          ],
        }],
        ['v8_enable_i18n_support==0', {
          'sources!': [
            'builtins/builtins-intl-gen.cc',
          ],
        }],
      ],
    },
    {
      'target_name': 'v8_snapshot',
      'type': 'static_library',
      'conditions': [
        ['want_separate_host_toolset==1', {
          'toolsets': ['host', 'target'],
          'dependencies': [
            'mksnapshot#host',
            'js2c#host',
          ],
        }, {
          'toolsets': ['target'],
          'dependencies': [
            'mksnapshot',
            'js2c',
          ],
        }],
        ['component=="shared_library"', {
          'defines': [
            'BUILDING_V8_SHARED',
          ],
          'direct_dependent_settings': {
            'defines': [
              'USING_V8_SHARED',
            ],
          },
        }],
      ],
      'dependencies': [
        'v8_base',
      ],
      'include_dirs+': [
        '..',
        '<(DEPTH)',
      ],
      'sources': [
        '<(SHARED_INTERMEDIATE_DIR)/libraries.cc',
        '<(SHARED_INTERMEDIATE_DIR)/extras-libraries.cc',
        '<(SHARED_INTERMEDIATE_DIR)/experimental-extras-libraries.cc',
        '<(INTERMEDIATE_DIR)/snapshot.cc',
        'setup-isolate-deserialize.cc',
      ],
      'actions': [
        {
          'action_name': 'run_mksnapshot',
          'inputs': [
            '<(mksnapshot_exec)',
          ],
          'conditions': [
            ['embed_script!=""', {
              'inputs': [
                '<(embed_script)',
              ],
            }],
            ['warmup_script!=""', {
              'inputs': [
                '<(warmup_script)',
              ],
            }],
          ],
          'outputs': [
            '<(INTERMEDIATE_DIR)/snapshot.cc',
          ],
          'variables': {
            'mksnapshot_flags': [],
            'conditions': [
              ['v8_random_seed!=0', {
                'mksnapshot_flags': ['--random-seed', '<(v8_random_seed)'],
              }],
              ['v8_vector_stores!=0', {
                'mksnapshot_flags': ['--vector-stores'],
              }],
            ],
          },
          'action': [
            '<(mksnapshot_exec)',
            '<@(mksnapshot_flags)',
            '--startup_src', '<@(INTERMEDIATE_DIR)/snapshot.cc',
            '<(embed_script)',
            '<(warmup_script)',
          ],
        },
      ],
    },
    {
      'target_name': 'v8_nosnapshot',
      'type': 'static_library',
      'dependencies': [
        'v8_base',
      ],
      'include_dirs+': [
        '..',
        '<(DEPTH)',
      ],
      'sources': [
        '<(SHARED_INTERMEDIATE_DIR)/libraries.cc',
        '<(SHARED_INTERMEDIATE_DIR)/extras-libraries.cc',
        '<(SHARED_INTERMEDIATE_DIR)/experimental-extras-libraries.cc',
        'snapshot/snapshot-empty.cc',
      ],
      'conditions': [
        ['want_separate_host_toolset==1', {
          'toolsets': ['host', 'target'],
          'dependencies': ['js2c#host'],
        }, {
          'toolsets': ['target'],
          'dependencies': ['js2c'],
        }],
        ['component=="shared_library"', {
          'defines': [
            'BUILDING_V8_SHARED',
          ],
        }],
      ]
    },
    {
      'target_name': 'v8_external_snapshot',
      'type': 'static_library',
      'conditions': [
        [ 'v8_use_external_startup_data==1', {
          'conditions': [
            ['want_separate_host_toolset==1', {
              'toolsets': ['host', 'target'],
              'dependencies': [
                'mksnapshot#host',
                'js2c#host',
                'natives_blob',
            ]}, {
              'toolsets': ['target'],
              'dependencies': [
                'mksnapshot',
                'js2c',
                'natives_blob',
              ],
            }],
            ['component=="shared_library"', {
              'defines': [
                'BUILDING_V8_SHARED',
              ],
              'direct_dependent_settings': {
                'defines': [
                  'USING_V8_SHARED',
                ],
              },
            }],
          ],
          'dependencies': [
            'v8_base',
          ],
          'include_dirs+': [
            '..',
            '<(DEPTH)',
          ],
          'sources': [
            'setup-isolate-deserialize.cc',
            'snapshot/natives-external.cc',
            'snapshot/snapshot-external.cc',
          ],
          'actions': [
            {
              'action_name': 'run_mksnapshot (external)',
              'inputs': [
                '<(mksnapshot_exec)',
              ],
              'variables': {
                'mksnapshot_flags': [],
                'conditions': [
                  ['v8_random_seed!=0', {
                    'mksnapshot_flags': ['--random-seed', '<(v8_random_seed)'],
                  }],
                  ['v8_vector_stores!=0', {
                    'mksnapshot_flags': ['--vector-stores'],
                  }],
                  ['v8_os_page_size!=0', {
                    'mksnapshot_flags': ['--v8_os_page_size', '<(v8_os_page_size)'],
                  }],
                ],
              },
              'conditions': [
                ['embed_script!=""', {
                  'inputs': [
                    '<(embed_script)',
                  ],
                }],
                ['warmup_script!=""', {
                  'inputs': [
                    '<(warmup_script)',
                  ],
                }],
                ['want_separate_host_toolset==1', {
                  'target_conditions': [
                    ['_toolset=="host"', {
                      'outputs': [
                        '<(PRODUCT_DIR)/snapshot_blob_host.bin',
                      ],
                      'action': [
                        '<(mksnapshot_exec)',
                        '<@(mksnapshot_flags)',
                        '--startup_blob', '<(PRODUCT_DIR)/snapshot_blob_host.bin',
                        '<(embed_script)',
                        '<(warmup_script)',
                      ],
                    }, {
                      'outputs': [
                        '<(PRODUCT_DIR)/snapshot_blob.bin',
                      ],
                      'action': [
                        '<(mksnapshot_exec)',
                        '<@(mksnapshot_flags)',
                        '--startup_blob', '<(PRODUCT_DIR)/snapshot_blob.bin',
                        '<(embed_script)',
                        '<(warmup_script)',
                      ],
                    }],
                  ],
                }, {
                  'outputs': [
                    '<(PRODUCT_DIR)/snapshot_blob.bin',
                  ],
                  'action': [
                    '<(mksnapshot_exec)',
                    '<@(mksnapshot_flags)',
                    '--startup_blob', '<(PRODUCT_DIR)/snapshot_blob.bin',
                    '<(embed_script)',
                    '<(warmup_script)',
                  ],
                }],
              ],
            },
          ],
        }],
      ],
    },
    {
      'target_name': 'v8_base',
      'type': 'static_library',
      'dependencies': [
        'v8_libbase',
        'v8_libsampler',
        'inspector/inspector.gyp:protocol_generated_sources#target',
        'inspector/inspector.gyp:inspector_injected_script#target',
        'inspector/inspector.gyp:inspector_debugger_script#target',
      ],
      'objs': ['foo.o'],
      'variables': {
        'optimize': 'max',
      },
      'include_dirs+': [
        '..',
        '<(DEPTH)',
        '<(SHARED_INTERMEDIATE_DIR)'
      ],
      'sources': [  ### gcmole(all) ###
        '<@(inspector_all_sources)',
        '../include/v8-debug.h',
        '../include/v8-platform.h',
        '../include/v8-profiler.h',
        '../include/v8-testing.h',
        '../include/v8-util.h',
        '../include/v8-value-serializer-version.h',
        '../include/v8-version-string.h',
        '../include/v8-version.h',
        '../include/v8.h',
        '../include/v8config.h',
        'accessors.cc',
        'accessors.h',
        'address-map.cc',
        'address-map.h',
        'allocation.cc',
        'allocation.h',
        'allocation-site-scopes.cc',
        'allocation-site-scopes.h',
        'api.cc',
        'api.h',
        'api-arguments-inl.h',
        'api-arguments.cc',
        'api-arguments.h',
        'api-natives.cc',
        'api-natives.h',
        'arguments.cc',
        'arguments.h',
        'asmjs/asm-js.cc',
        'asmjs/asm-js.h',
        'asmjs/asm-names.h',
        'asmjs/asm-parser.cc',
        'asmjs/asm-parser.h',
        'asmjs/asm-scanner.cc',
        'asmjs/asm-scanner.h',
        'asmjs/asm-types.cc',
        'asmjs/asm-types.h',
        'asmjs/switch-logic.h',
        'asmjs/switch-logic.cc',
        'assembler.cc',
        'assembler.h',
        'assembler-inl.h',
        'assert-scope.h',
        'assert-scope.cc',
        'ast/ast-expression-rewriter.cc',
        'ast/ast-expression-rewriter.h',
        'ast/ast-function-literal-id-reindexer.cc',
        'ast/ast-function-literal-id-reindexer.h',
        'ast/ast-numbering.cc',
        'ast/ast-numbering.h',
        'ast/ast-traversal-visitor.h',
        'ast/ast-type-bounds.h',
        'ast/ast-types.cc',
        'ast/ast-types.h',
        'ast/ast-value-factory.cc',
        'ast/ast-value-factory.h',
        'ast/ast.cc',
        'ast/ast.h',
        'ast/compile-time-value.cc',
        'ast/compile-time-value.h',
        'ast/context-slot-cache.cc',
        'ast/context-slot-cache.h',
        'ast/modules.cc',
        'ast/modules.h',
        'ast/prettyprinter.cc',
        'ast/prettyprinter.h',
        'ast/scopes.cc',
        'ast/scopes.h',
        'ast/variables.cc',
        'ast/variables.h',
        'background-parsing-task.cc',
        'background-parsing-task.h',
        'bailout-reason.cc',
        'bailout-reason.h',
        'basic-block-profiler.cc',
        'basic-block-profiler.h',
        'bignum-dtoa.cc',
        'bignum-dtoa.h',
        'bignum.cc',
        'bignum.h',
        'bit-vector.cc',
        'bit-vector.h',
        'bootstrapper.cc',
        'bootstrapper.h',
        'builtins/builtins-api.cc',
        'builtins/builtins-arraybuffer.cc',
        'builtins/builtins-array.cc',
        'builtins/builtins-boolean.cc',
        'builtins/builtins-call.cc',
        'builtins/builtins-callsite.cc',
        'builtins/builtins-console.cc',
        'builtins/builtins-constructor.h',
        'builtins/builtins-dataview.cc',
        'builtins/builtins-date.cc',
        'builtins/builtins-definitions.h',
        'builtins/builtins-descriptors.h',
        'builtins/builtins-error.cc',
        'builtins/builtins-function.cc',
        'builtins/builtins-global.cc',
        'builtins/builtins-internal.cc',
        'builtins/builtins-interpreter.cc',
        'builtins/builtins-json.cc',
        'builtins/builtins-math.cc',
        'builtins/builtins-number.cc',
        'builtins/builtins-object.cc',
        'builtins/builtins-proxy.cc',
        'builtins/builtins-reflect.cc',
        'builtins/builtins-regexp.cc',
        'builtins/builtins-sharedarraybuffer.cc',
        'builtins/builtins-string.cc',
        'builtins/builtins-intl.cc',
        'builtins/builtins-symbol.cc',
        'builtins/builtins-typedarray.cc',
        'builtins/builtins-utils.h',
        'builtins/builtins.cc',
        'builtins/builtins.h',
        'cached-powers.cc',
        'cached-powers.h',
        'callable.h',
        'cancelable-task.cc',
        'cancelable-task.h',
        'char-predicates.cc',
        'char-predicates-inl.h',
        'char-predicates.h',
        'checks.h',
        'code-events.h',
        'code-factory.cc',
        'code-factory.h',
        'code-stub-assembler.cc',
        'code-stub-assembler.h',
        'code-stubs.cc',
        'code-stubs.h',
        'code-stubs-hydrogen.cc',
        'code-stubs-utils.h',
        'codegen.cc',
        'codegen.h',
        'collector.h',
        'compilation-cache.cc',
        'compilation-cache.h',
        'compilation-dependencies.cc',
        'compilation-dependencies.h',
        'compilation-info.cc',
        'compilation-info.h',
        'compilation-statistics.cc',
        'compilation-statistics.h',
        'compiler/access-builder.cc',
        'compiler/access-builder.h',
        'compiler/access-info.cc',
        'compiler/access-info.h',
        'compiler/all-nodes.cc',
        'compiler/all-nodes.h',
        'compiler/ast-graph-builder.cc',
        'compiler/ast-graph-builder.h',
        'compiler/ast-loop-assignment-analyzer.cc',
        'compiler/ast-loop-assignment-analyzer.h',
        'compiler/basic-block-instrumentor.cc',
        'compiler/basic-block-instrumentor.h',
        'compiler/branch-elimination.cc',
        'compiler/branch-elimination.h',
        'compiler/bytecode-analysis.cc',
        'compiler/bytecode-analysis.h',
        'compiler/bytecode-graph-builder.cc',
        'compiler/bytecode-graph-builder.h',
        'compiler/bytecode-liveness-map.cc',
        'compiler/bytecode-liveness-map.h',
        'compiler/c-linkage.cc',
        'compiler/checkpoint-elimination.cc',
        'compiler/checkpoint-elimination.h',
        'compiler/code-generator-impl.h',
        'compiler/code-generator.cc',
        'compiler/code-generator.h',
        'compiler/code-assembler.cc',
        'compiler/code-assembler.h',
        'compiler/common-node-cache.cc',
        'compiler/common-node-cache.h',
        'compiler/common-operator-reducer.cc',
        'compiler/common-operator-reducer.h',
        'compiler/common-operator.cc',
        'compiler/common-operator.h',
        'compiler/control-builders.cc',
        'compiler/control-builders.h',
        'compiler/control-equivalence.cc',
        'compiler/control-equivalence.h',
        'compiler/control-flow-optimizer.cc',
        'compiler/control-flow-optimizer.h',
        'compiler/dead-code-elimination.cc',
        'compiler/dead-code-elimination.h',
        'compiler/diamond.h',
        'compiler/effect-control-linearizer.cc',
        'compiler/effect-control-linearizer.h',
        'compiler/escape-analysis.cc',
        'compiler/escape-analysis.h',
        'compiler/escape-analysis-reducer.cc',
        'compiler/escape-analysis-reducer.h',
        'compiler/frame.cc',
        'compiler/frame.h',
        'compiler/frame-elider.cc',
        'compiler/frame-elider.h',
        'compiler/frame-states.cc',
        'compiler/frame-states.h',
        'compiler/gap-resolver.cc',
        'compiler/gap-resolver.h',
        'compiler/graph-assembler.cc',
        'compiler/graph-assembler.h',
        'compiler/graph-reducer.cc',
        'compiler/graph-reducer.h',
        'compiler/graph-trimmer.cc',
        'compiler/graph-trimmer.h',
        'compiler/graph-visualizer.cc',
        'compiler/graph-visualizer.h',
        'compiler/graph.cc',
        'compiler/graph.h',
        'compiler/instruction-codes.h',
        'compiler/instruction-selector-impl.h',
        'compiler/instruction-selector.cc',
        'compiler/instruction-selector.h',
        'compiler/instruction-scheduler.cc',
        'compiler/instruction-scheduler.h',
        'compiler/instruction.cc',
        'compiler/instruction.h',
        'compiler/int64-lowering.cc',
        'compiler/int64-lowering.h',
        'compiler/js-builtin-reducer.cc',
        'compiler/js-builtin-reducer.h',
        'compiler/js-call-reducer.cc',
        'compiler/js-call-reducer.h',
        'compiler/js-context-specialization.cc',
        'compiler/js-context-specialization.h',
        'compiler/js-create-lowering.cc',
        'compiler/js-create-lowering.h',
        'compiler/js-frame-specialization.cc',
        'compiler/js-frame-specialization.h',
        'compiler/js-generic-lowering.cc',
        'compiler/js-generic-lowering.h',
        'compiler/js-graph.cc',
        'compiler/js-graph.h',
        'compiler/js-inlining.cc',
        'compiler/js-inlining.h',
        'compiler/js-inlining-heuristic.cc',
        'compiler/js-inlining-heuristic.h',
        'compiler/js-intrinsic-lowering.cc',
        'compiler/js-intrinsic-lowering.h',
        'compiler/js-native-context-specialization.cc',
        'compiler/js-native-context-specialization.h',
        'compiler/js-operator.cc',
        'compiler/js-operator.h',
        'compiler/js-type-hint-lowering.cc',
        'compiler/js-type-hint-lowering.h',
        'compiler/js-typed-lowering.cc',
        'compiler/js-typed-lowering.h',
        'compiler/jump-threading.cc',
        'compiler/jump-threading.h',
        'compiler/linkage.cc',
        'compiler/linkage.h',
        'compiler/liveness-analyzer.cc',
        'compiler/liveness-analyzer.h',
        'compiler/live-range-separator.cc',
        'compiler/live-range-separator.h',
        'compiler/load-elimination.cc',
        'compiler/load-elimination.h',
        'compiler/loop-analysis.cc',
        'compiler/loop-analysis.h',
        'compiler/loop-peeling.cc',
        'compiler/loop-peeling.h',
        'compiler/loop-variable-optimizer.cc',
        'compiler/loop-variable-optimizer.h',
        'compiler/machine-operator-reducer.cc',
        'compiler/machine-operator-reducer.h',
        'compiler/machine-operator.cc',
        'compiler/machine-operator.h',
        'compiler/machine-graph-verifier.cc',
        'compiler/machine-graph-verifier.h',
        'compiler/memory-optimizer.cc',
        'compiler/memory-optimizer.h',
        'compiler/move-optimizer.cc',
        'compiler/move-optimizer.h',
        'compiler/node-aux-data.h',
        'compiler/node-cache.cc',
        'compiler/node-cache.h',
        'compiler/node-marker.cc',
        'compiler/node-marker.h',
        'compiler/node-matchers.cc',
        'compiler/node-matchers.h',
        'compiler/node-properties.cc',
        'compiler/node-properties.h',
        'compiler/node.cc',
        'compiler/node.h',
        'compiler/opcodes.cc',
        'compiler/opcodes.h',
        'compiler/operation-typer.cc',
        'compiler/operation-typer.h',
        'compiler/operator-properties.cc',
        'compiler/operator-properties.h',
        'compiler/operator.cc',
        'compiler/operator.h',
        'compiler/osr.cc',
        'compiler/osr.h',
        'compiler/pipeline.cc',
        'compiler/pipeline.h',
        'compiler/pipeline-statistics.cc',
        'compiler/pipeline-statistics.h',
        'compiler/raw-machine-assembler.cc',
        'compiler/raw-machine-assembler.h',
        'compiler/redundancy-elimination.cc',
        'compiler/redundancy-elimination.h',
        'compiler/register-allocator.cc',
        'compiler/register-allocator.h',
        'compiler/register-allocator-verifier.cc',
        'compiler/register-allocator-verifier.h',
        'compiler/representation-change.cc',
        'compiler/representation-change.h',
        'compiler/schedule.cc',
        'compiler/schedule.h',
        'compiler/scheduler.cc',
        'compiler/scheduler.h',
        'compiler/select-lowering.cc',
        'compiler/select-lowering.h',
        'compiler/simd-scalar-lowering.cc',
        'compiler/simd-scalar-lowering.h',
        'compiler/simplified-lowering.cc',
        'compiler/simplified-lowering.h',
        'compiler/simplified-operator-reducer.cc',
        'compiler/simplified-operator-reducer.h',
        'compiler/simplified-operator.cc',
        'compiler/simplified-operator.h',
        'compiler/compiler-source-position-table.cc',
        'compiler/compiler-source-position-table.h',
        'compiler/state-values-utils.cc',
        'compiler/state-values-utils.h',
        'compiler/store-store-elimination.cc',
        'compiler/store-store-elimination.h',
        'compiler/tail-call-optimization.cc',
        'compiler/tail-call-optimization.h',
        'compiler/types.cc',
        'compiler/types.h',
        'compiler/type-cache.cc',
        'compiler/type-cache.h',
        'compiler/typed-optimization.cc',
        'compiler/typed-optimization.h',
        'compiler/typer.cc',
        'compiler/typer.h',
        'compiler/unwinding-info-writer.h',
        'compiler/value-numbering-reducer.cc',
        'compiler/value-numbering-reducer.h',
        'compiler/verifier.cc',
        'compiler/verifier.h',
        'compiler/wasm-compiler.cc',
        'compiler/wasm-compiler.h',
        'compiler/wasm-linkage.cc',
        'compiler/zone-stats.cc',
        'compiler/zone-stats.h',
        'compiler-dispatcher/compiler-dispatcher.cc',
        'compiler-dispatcher/compiler-dispatcher.h',
        'compiler-dispatcher/compiler-dispatcher-job.cc',
        'compiler-dispatcher/compiler-dispatcher-job.h',
        'compiler-dispatcher/compiler-dispatcher-tracer.cc',
        'compiler-dispatcher/compiler-dispatcher-tracer.h',
        'compiler-dispatcher/optimizing-compile-dispatcher.cc',
        'compiler-dispatcher/optimizing-compile-dispatcher.h',
        'compiler.cc',
        'compiler.h',
        'contexts-inl.h',
        'contexts.cc',
        'contexts.h',
        'conversions-inl.h',
        'conversions.cc',
        'conversions.h',
        'counters-inl.h',
        'counters.cc',
        'counters.h',
        'crankshaft/compilation-phase.cc',
        'crankshaft/compilation-phase.h',
        'crankshaft/hydrogen-alias-analysis.h',
        'crankshaft/hydrogen-bce.cc',
        'crankshaft/hydrogen-bce.h',
        'crankshaft/hydrogen-canonicalize.cc',
        'crankshaft/hydrogen-canonicalize.h',
        'crankshaft/hydrogen-check-elimination.cc',
        'crankshaft/hydrogen-check-elimination.h',
        'crankshaft/hydrogen-dce.cc',
        'crankshaft/hydrogen-dce.h',
        'crankshaft/hydrogen-dehoist.cc',
        'crankshaft/hydrogen-dehoist.h',
        'crankshaft/hydrogen-environment-liveness.cc',
        'crankshaft/hydrogen-environment-liveness.h',
        'crankshaft/hydrogen-escape-analysis.cc',
        'crankshaft/hydrogen-escape-analysis.h',
        'crankshaft/hydrogen-flow-engine.h',
        'crankshaft/hydrogen-gvn.cc',
        'crankshaft/hydrogen-gvn.h',
        'crankshaft/hydrogen-infer-representation.cc',
        'crankshaft/hydrogen-infer-representation.h',
        'crankshaft/hydrogen-infer-types.cc',
        'crankshaft/hydrogen-infer-types.h',
        'crankshaft/hydrogen-instructions.cc',
        'crankshaft/hydrogen-instructions.h',
        'crankshaft/hydrogen-load-elimination.cc',
        'crankshaft/hydrogen-load-elimination.h',
        'crankshaft/hydrogen-mark-unreachable.cc',
        'crankshaft/hydrogen-mark-unreachable.h',
        'crankshaft/hydrogen-osr.cc',
        'crankshaft/hydrogen-osr.h',
        'crankshaft/hydrogen-range-analysis.cc',
        'crankshaft/hydrogen-range-analysis.h',
        'crankshaft/hydrogen-redundant-phi.cc',
        'crankshaft/hydrogen-redundant-phi.h',
        'crankshaft/hydrogen-removable-simulates.cc',
        'crankshaft/hydrogen-removable-simulates.h',
        'crankshaft/hydrogen-representation-changes.cc',
        'crankshaft/hydrogen-representation-changes.h',
        'crankshaft/hydrogen-sce.cc',
        'crankshaft/hydrogen-sce.h',
        'crankshaft/hydrogen-store-elimination.cc',
        'crankshaft/hydrogen-store-elimination.h',
        'crankshaft/hydrogen-types.cc',
        'crankshaft/hydrogen-types.h',
        'crankshaft/hydrogen-uint32-analysis.cc',
        'crankshaft/hydrogen-uint32-analysis.h',
        'crankshaft/hydrogen.cc',
        'crankshaft/hydrogen.h',
        'crankshaft/lithium-allocator-inl.h',
        'crankshaft/lithium-allocator.cc',
        'crankshaft/lithium-allocator.h',
        'crankshaft/lithium-codegen.cc',
        'crankshaft/lithium-codegen.h',
        'crankshaft/lithium.cc',
        'crankshaft/lithium.h',
        'crankshaft/lithium-inl.h',
        'crankshaft/typing.cc',
        'crankshaft/typing.h',
        'crankshaft/unique.h',
        'date.cc',
        'date.h',
        'dateparser-inl.h',
        'dateparser.cc',
        'dateparser.h',
        'debug/debug-coverage.cc',
        'debug/debug-coverage.h',
        'debug/debug-evaluate.cc',
        'debug/debug-evaluate.h',
        'debug/debug-interface.h',
        'debug/debug-frames.cc',
        'debug/debug-frames.h',
        'debug/debug-scopes.cc',
        'debug/debug-scopes.h',
        'debug/debug.cc',
        'debug/debug.h',
        'debug/interface-types.h',
        'debug/liveedit.cc',
        'debug/liveedit.h',
        'deoptimize-reason.cc',
        'deoptimize-reason.h',
        'deoptimizer.cc',
        'deoptimizer.h',
        'disasm.h',
        'disassembler.cc',
        'disassembler.h',
        'diy-fp.cc',
        'diy-fp.h',
        'double.h',
        'dtoa.cc',
        'dtoa.h',
        'effects.h',
        'eh-frame.cc',
        'eh-frame.h',
        'elements-kind.cc',
        'elements-kind.h',
        'elements.cc',
        'elements.h',
        'execution.cc',
        'execution.h',
        'extensions/externalize-string-extension.cc',
        'extensions/externalize-string-extension.h',
        'extensions/free-buffer-extension.cc',
        'extensions/free-buffer-extension.h',
        'extensions/gc-extension.cc',
        'extensions/gc-extension.h',
        'extensions/ignition-statistics-extension.cc',
        'extensions/ignition-statistics-extension.h',
        'extensions/statistics-extension.cc',
        'extensions/statistics-extension.h',
        'extensions/trigger-failure-extension.cc',
        'extensions/trigger-failure-extension.h',
        'external-reference-table.cc',
        'external-reference-table.h',
        'factory.cc',
        'factory.h',
        'fast-dtoa.cc',
        'fast-dtoa.h',
        'feedback-vector-inl.h',
        'feedback-vector.cc',
        'feedback-vector.h',
        'ffi/ffi-compiler.cc',
        'ffi/ffi-compiler.h',
        'field-index.h',
        'field-index-inl.h',
        'field-type.cc',
        'field-type.h',
        'find-and-replace-pattern.h',
        'fixed-dtoa.cc',
        'fixed-dtoa.h',
        'flag-definitions.h',
        'flags.cc',
        'flags.h',
        'frames-inl.h',
        'frames.cc',
        'frames.h',
        'full-codegen/full-codegen.cc',
        'full-codegen/full-codegen.h',
        'futex-emulation.cc',
        'futex-emulation.h',
        'gdb-jit.cc',
        'gdb-jit.h',
        'global-handles.cc',
        'global-handles.h',
        'globals.h',
        'handles-inl.h',
        'handles.cc',
        'handles.h',
        'heap-symbols.h',
        'heap/array-buffer-tracker-inl.h',
        'heap/array-buffer-tracker.cc',
        'heap/array-buffer-tracker.h',
        'heap/code-stats.cc',
        'heap/code-stats.h',
        'heap/concurrent-marking-deque.h',
        'heap/concurrent-marking.cc',
        'heap/concurrent-marking.h',
        'heap/embedder-tracing.cc',
        'heap/embedder-tracing.h',
        'heap/memory-reducer.cc',
        'heap/memory-reducer.h',
        'heap/gc-idle-time-handler.cc',
        'heap/gc-idle-time-handler.h',
        'heap/gc-tracer.cc',
        'heap/gc-tracer.h',
        'heap/heap-inl.h',
        'heap/heap.cc',
        'heap/heap.h',
        'heap/incremental-marking-inl.h',
        'heap/incremental-marking-job.cc',
        'heap/incremental-marking-job.h',
        'heap/incremental-marking.cc',
        'heap/incremental-marking.h',
        'heap/item-parallel-job.h',
        'heap/mark-compact-inl.h',
        'heap/mark-compact.cc',
        'heap/mark-compact.h',
        'heap/marking.h',
        'heap/object-stats.cc',
        'heap/object-stats.h',
        'heap/objects-visiting-inl.h',
        'heap/objects-visiting.cc',
        'heap/objects-visiting.h',
        'heap/page-parallel-job.h',
        'heap/remembered-set.h',
        'heap/scavenge-job.h',
        'heap/scavenge-job.cc',
        'heap/scavenger-inl.h',
        'heap/scavenger.cc',
        'heap/scavenger.h',
        'heap/sequential-marking-deque.cc',
        'heap/sequential-marking-deque.h',
        'heap/slot-set.h',
        'heap/spaces-inl.h',
        'heap/spaces.cc',
        'heap/spaces.h',
        'heap/store-buffer.cc',
        'heap/store-buffer.h',
        'heap/workstealing-marking-deque.h',
        'intl.cc',
        'intl.h',
        'icu_util.cc',
        'icu_util.h',
        'ic/access-compiler-data.h',
        'ic/access-compiler.cc',
        'ic/access-compiler.h',
        'ic/call-optimization.cc',
        'ic/call-optimization.h',
        'ic/handler-compiler.cc',
        'ic/handler-compiler.h',
        'ic/handler-configuration-inl.h',
        'ic/handler-configuration.h',
        'ic/ic-inl.h',
        'ic/ic-state.cc',
        'ic/ic-state.h',
        'ic/ic-stats.cc',
        'ic/ic-stats.h',
        'ic/ic.cc',
        'ic/ic.h',
        'identity-map.cc',
        'identity-map.h',
        'interface-descriptors.cc',
        'interface-descriptors.h',
        'interpreter/bytecodes.cc',
        'interpreter/bytecodes.h',
        'interpreter/bytecode-array-accessor.cc',
        'interpreter/bytecode-array-accessor.h',
        'interpreter/bytecode-array-builder.cc',
        'interpreter/bytecode-array-builder.h',
        'interpreter/bytecode-array-iterator.cc',
        'interpreter/bytecode-array-iterator.h',
        'interpreter/bytecode-array-random-iterator.cc',
        'interpreter/bytecode-array-random-iterator.h',
        'interpreter/bytecode-array-writer.cc',
        'interpreter/bytecode-array-writer.h',
        'interpreter/bytecode-decoder.cc',
        'interpreter/bytecode-decoder.h',
        'interpreter/bytecode-flags.cc',
        'interpreter/bytecode-flags.h',
        'interpreter/bytecode-generator.cc',
        'interpreter/bytecode-generator.h',
        'interpreter/bytecode-label.cc',
        'interpreter/bytecode-label.h',
        'interpreter/bytecode-node.cc',
        'interpreter/bytecode-node.h',
        'interpreter/bytecode-operands.cc',
        'interpreter/bytecode-operands.h',
        'interpreter/bytecode-register.cc',
        'interpreter/bytecode-register.h',
        'interpreter/bytecode-register-allocator.h',
        'interpreter/bytecode-register-optimizer.cc',
        'interpreter/bytecode-register-optimizer.h',
        'interpreter/bytecode-source-info.cc',
        'interpreter/bytecode-source-info.h',
        'interpreter/bytecode-jump-table.h',
        'interpreter/bytecode-traits.h',
        'interpreter/constant-array-builder.cc',
        'interpreter/constant-array-builder.h',
        'interpreter/control-flow-builders.cc',
        'interpreter/control-flow-builders.h',
        'interpreter/handler-table-builder.cc',
        'interpreter/handler-table-builder.h',
        'interpreter/interpreter.cc',
        'interpreter/interpreter.h',
        'interpreter/interpreter-generator.h',
        'interpreter/interpreter-intrinsics.cc',
        'interpreter/interpreter-intrinsics.h',
        'isolate-inl.h',
        'isolate.cc',
        'isolate.h',
        'json-parser.cc',
        'json-parser.h',
        'json-stringifier.cc',
        'json-stringifier.h',
        'keys.h',
        'keys.cc',
        'label.h',
        'layout-descriptor-inl.h',
        'layout-descriptor.cc',
        'layout-descriptor.h',
        'list-inl.h',
        'list.h',
        'locked-queue-inl.h',
        'locked-queue.h',
        'log-inl.h',
        'log-utils.cc',
        'log-utils.h',
        'log.cc',
        'log.h',
        'lookup-cache-inl.h',
        'lookup-cache.cc',
        'lookup-cache.h',
        'lookup.cc',
        'lookup.h',
        'map-updater.cc',
        'map-updater.h',
        'macro-assembler-inl.h',
        'macro-assembler.h',
        'machine-type.cc',
        'machine-type.h',
        'managed.h',
        'messages.cc',
        'messages.h',
        'msan.h',
        'objects-body-descriptors-inl.h',
        'objects-body-descriptors.h',
        'objects-debug.cc',
        'objects-inl.h',
        'objects-printer.cc',
        'objects.cc',
        'objects.h',
        'objects/code-cache.h',
        'objects/code-cache-inl.h',
        'objects/compilation-cache.h',
        'objects/compilation-cache-inl.h',
        'objects/debug-objects-inl.h',
        'objects/debug-objects.cc',
        'objects/debug-objects.h',
        'objects/descriptor-array.h',
        'objects/dictionary.h',
        'objects/frame-array.h',
        'objects/frame-array-inl.h',
        'objects/hash-table.h',
        'objects/intl-objects.cc',
        'objects/intl-objects.h',
        'objects/literal-objects.cc',
        'objects/literal-objects.h',
        'objects/map-inl.h',
        'objects/map.h',
        'objects/module-info.h',
        'objects/object-macros.h',
        'objects/object-macros-undef.h',
        'objects/regexp-match-info.h',
        'objects/scope-info.cc',
        'objects/scope-info.h',
        'objects/script.h',
        'objects/script-inl.h',
        'objects/shared-function-info-inl.h',
        'objects/shared-function-info.h',
        'objects/string-table.h',
        'ostreams.cc',
        'ostreams.h',
        'parsing/duplicate-finder.h',
        'parsing/expression-classifier.h',
        'parsing/func-name-inferrer.cc',
        'parsing/func-name-inferrer.h',
        'parsing/parameter-initializer-rewriter.cc',
        'parsing/parameter-initializer-rewriter.h',
        'parsing/parse-info.cc',
        'parsing/parse-info.h',
        'parsing/parser-base.h',
        'parsing/parser.cc',
        'parsing/parser.h',
        'parsing/parsing.cc',
        'parsing/parsing.h',
        'parsing/pattern-rewriter.cc',
        'parsing/preparse-data-format.h',
        'parsing/preparse-data.cc',
        'parsing/preparse-data.h',
        'parsing/preparsed-scope-data.cc',
        'parsing/preparsed-scope-data.h',
        'parsing/preparser.cc',
        'parsing/preparser.h',
        'parsing/rewriter.cc',
        'parsing/rewriter.h',
        'parsing/scanner-character-streams.cc',
        'parsing/scanner-character-streams.h',
        'parsing/scanner.cc',
        'parsing/scanner.h',
        'parsing/token.cc',
        'parsing/token.h',
        'pending-compilation-error-handler.cc',
        'pending-compilation-error-handler.h',
        'perf-jit.cc',
        'perf-jit.h',
        'profiler/allocation-tracker.cc',
        'profiler/allocation-tracker.h',
        'profiler/circular-queue-inl.h',
        'profiler/circular-queue.h',
        'profiler/cpu-profiler-inl.h',
        'profiler/cpu-profiler.cc',
        'profiler/cpu-profiler.h',
        'profiler/heap-profiler.cc',
        'profiler/heap-profiler.h',
        'profiler/heap-snapshot-generator-inl.h',
        'profiler/heap-snapshot-generator.cc',
        'profiler/heap-snapshot-generator.h',
        'profiler/profiler-listener.cc',
        'profiler/profiler-listener.h',
        'profiler/profile-generator-inl.h',
        'profiler/profile-generator.cc',
        'profiler/profile-generator.h',
        'profiler/sampling-heap-profiler.cc',
        'profiler/sampling-heap-profiler.h',
        'profiler/strings-storage.cc',
        'profiler/strings-storage.h',
        'profiler/tick-sample.cc',
        'profiler/tick-sample.h',
        'profiler/tracing-cpu-profiler.cc',
        'profiler/tracing-cpu-profiler.h',
        'profiler/unbound-queue-inl.h',
        'profiler/unbound-queue.h',
        'property-descriptor.cc',
        'property-descriptor.h',
        'property-details.h',
        'property.cc',
        'property.h',
        'prototype.h',
        'regexp/bytecodes-irregexp.h',
        'regexp/interpreter-irregexp.cc',
        'regexp/interpreter-irregexp.h',
        'regexp/jsregexp-inl.h',
        'regexp/jsregexp.cc',
        'regexp/jsregexp.h',
        'regexp/regexp-ast.cc',
        'regexp/regexp-ast.h',
        'regexp/regexp-macro-assembler-irregexp-inl.h',
        'regexp/regexp-macro-assembler-irregexp.cc',
        'regexp/regexp-macro-assembler-irregexp.h',
        'regexp/regexp-macro-assembler-tracer.cc',
        'regexp/regexp-macro-assembler-tracer.h',
        'regexp/regexp-macro-assembler.cc',
        'regexp/regexp-macro-assembler.h',
        'regexp/regexp-parser.cc',
        'regexp/regexp-parser.h',
        'regexp/regexp-stack.cc',
        'regexp/regexp-stack.h',
        'regexp/regexp-utils.cc',
        'regexp/regexp-utils.h',
        'register-configuration.cc',
        'register-configuration.h',
        'runtime-profiler.cc',
        'runtime-profiler.h',
        'runtime/runtime-array.cc',
        'runtime/runtime-atomics.cc',
        'runtime/runtime-classes.cc',
        'runtime/runtime-collections.cc',
        'runtime/runtime-compiler.cc',
        'runtime/runtime-date.cc',
        'runtime/runtime-debug.cc',
        'runtime/runtime-forin.cc',
        'runtime/runtime-function.cc',
        'runtime/runtime-error.cc',
        'runtime/runtime-futex.cc',
        'runtime/runtime-generator.cc',
        'runtime/runtime-intl.cc',
        'runtime/runtime-internal.cc',
        'runtime/runtime-interpreter.cc',
        'runtime/runtime-literals.cc',
        'runtime/runtime-liveedit.cc',
        'runtime/runtime-maths.cc',
        'runtime/runtime-module.cc',
        'runtime/runtime-numbers.cc',
        'runtime/runtime-object.cc',
        'runtime/runtime-operators.cc',
        'runtime/runtime-promise.cc',
        'runtime/runtime-proxy.cc',
        'runtime/runtime-regexp.cc',
        'runtime/runtime-scopes.cc',
        'runtime/runtime-strings.cc',
        'runtime/runtime-symbol.cc',
        'runtime/runtime-test.cc',
        'runtime/runtime-typedarray.cc',
        'runtime/runtime-utils.h',
        'runtime/runtime-wasm.cc',
        'runtime/runtime.cc',
        'runtime/runtime.h',
        'safepoint-table.cc',
        'safepoint-table.h',
        'setup-isolate.h',
        'signature.h',
        'simulator.h',
        'small-pointer-list.h',
        'snapshot/code-serializer.cc',
        'snapshot/code-serializer.h',
        'snapshot/deserializer.cc',
        'snapshot/deserializer.h',
        'snapshot/natives.h',
        'snapshot/natives-common.cc',
        'snapshot/partial-serializer.cc',
        'snapshot/partial-serializer.h',
        'snapshot/serializer.cc',
        'snapshot/serializer.h',
        'snapshot/serializer-common.cc',
        'snapshot/serializer-common.h',
        'snapshot/snapshot.h',
        'snapshot/snapshot-common.cc',
        'snapshot/snapshot-source-sink.cc',
        'snapshot/snapshot-source-sink.h',
        'snapshot/startup-serializer.cc',
        'snapshot/startup-serializer.h',
        'source-position-table.cc',
        'source-position-table.h',
        'source-position.cc',
        'source-position.h',
        'splay-tree.h',
        'splay-tree-inl.h',
        'startup-data-util.cc',
        'startup-data-util.h',
        'string-builder.cc',
        'string-builder.h',
        'string-case.cc',
        'string-case.h',
        'string-hasher-inl.h',
        'string-hasher.h',
        'string-search.h',
        'string-stream.cc',
        'string-stream.h',
        'strtod.cc',
        'strtod.h',
        'ic/stub-cache.cc',
        'ic/stub-cache.h',
        'tracing/trace-event.cc',
        'tracing/trace-event.h',
        'tracing/traced-value.cc',
        'tracing/traced-value.h',
        'tracing/tracing-category-observer.cc',
        'tracing/tracing-category-observer.h',
        'transitions-inl.h',
        'transitions.cc',
        'transitions.h',
        'trap-handler/handler-outside.cc',
        'trap-handler/handler-shared.cc',
        'trap-handler/trap-handler.h',
        'trap-handler/trap-handler-internal.h',
        'type-hints.cc',
        'type-hints.h',
        'type-info.cc',
        'type-info.h',
        'unicode-inl.h',
        'unicode.cc',
        'unicode.h',
        'unicode-cache-inl.h',
        'unicode-cache.h',
        'unicode-decoder.cc',
        'unicode-decoder.h',
        'uri.cc',
        'uri.h',
        'utils-inl.h',
        'utils.cc',
        'utils.h',
        'v8.cc',
        'v8.h',
        'v8memory.h',
        'v8threads.cc',
        'v8threads.h',
        'value-serializer.cc',
        'value-serializer.h',
        'vector.h',
        'version.cc',
        'version.h',
        'visitors.cc',
        'visitors.h',
        'vm-state-inl.h',
        'vm-state.h',
        'wasm/decoder.h',
        'wasm/function-body-decoder.cc',
        'wasm/function-body-decoder.h',
        'wasm/function-body-decoder-impl.h',
        'wasm/leb-helper.h',
        'wasm/local-decl-encoder.cc',
        'wasm/local-decl-encoder.h',
        'wasm/module-compiler.cc',
        'wasm/module-compiler.h',
        'wasm/module-decoder.cc',
        'wasm/module-decoder.h',
        'wasm/signature-map.cc',
        'wasm/signature-map.h',
        'wasm/streaming-decoder.cc',
        'wasm/streaming-decoder.h',
        'wasm/wasm-code-specialization.h',
        'wasm/wasm-code-specialization.cc',
        'wasm/wasm-debug.cc',
        'wasm/wasm-external-refs.cc',
        'wasm/wasm-external-refs.h',
        'wasm/wasm-js.cc',
        'wasm/wasm-js.h',
        'wasm/wasm-limits.h',
        'wasm/wasm-module.cc',
        'wasm/wasm-module.h',
        'wasm/wasm-module-builder.cc',
        'wasm/wasm-module-builder.h',
        'wasm/wasm-interpreter.cc',
        'wasm/wasm-interpreter.h',
        'wasm/wasm-objects.cc',
        'wasm/wasm-objects.h',
        'wasm/wasm-opcodes.cc',
        'wasm/wasm-opcodes.h',
        'wasm/wasm-result.cc',
        'wasm/wasm-result.h',
        'wasm/wasm-text.cc',
        'wasm/wasm-text.h',
        'zone/accounting-allocator.cc',
        'zone/accounting-allocator.h',
        'zone/zone-segment.cc',
        'zone/zone-segment.h',
        'zone/zone.cc',
        'zone/zone.h',
        'zone/zone-chunk-list.h',
        'zone/zone-segment.cc',
        'zone/zone-segment.h',
        'zone/zone-allocator.h',
        'zone/zone-containers.h',
        'zone/zone-handle-set.h',
      ],
      'conditions': [
        ['want_separate_host_toolset==1', {
          'toolsets': ['host', 'target'],
        }, {
          'toolsets': ['target'],
        }],
        ['v8_target_arch=="arm"', {
          'sources': [  ### gcmole(arch:arm) ###
            'arm/assembler-arm-inl.h',
            'arm/assembler-arm.cc',
            'arm/assembler-arm.h',
            'arm/code-stubs-arm.cc',
            'arm/code-stubs-arm.h',
            'arm/codegen-arm.cc',
            'arm/codegen-arm.h',
            'arm/constants-arm.h',
            'arm/constants-arm.cc',
            'arm/cpu-arm.cc',
            'arm/deoptimizer-arm.cc',
            'arm/disasm-arm.cc',
            'arm/frames-arm.cc',
            'arm/frames-arm.h',
            'arm/interface-descriptors-arm.cc',
            'arm/interface-descriptors-arm.h',
            'arm/macro-assembler-arm.cc',
            'arm/macro-assembler-arm.h',
            'arm/simulator-arm.cc',
            'arm/simulator-arm.h',
            'arm/eh-frame-arm.cc',
            'compiler/arm/code-generator-arm.cc',
            'compiler/arm/instruction-codes-arm.h',
            'compiler/arm/instruction-scheduler-arm.cc',
            'compiler/arm/instruction-selector-arm.cc',
            'compiler/arm/unwinding-info-writer-arm.h',
            'compiler/arm/unwinding-info-writer-arm.cc',
            'crankshaft/arm/lithium-arm.cc',
            'crankshaft/arm/lithium-arm.h',
            'crankshaft/arm/lithium-codegen-arm.cc',
            'crankshaft/arm/lithium-codegen-arm.h',
            'crankshaft/arm/lithium-gap-resolver-arm.cc',
            'crankshaft/arm/lithium-gap-resolver-arm.h',
            'debug/arm/debug-arm.cc',
            'full-codegen/arm/full-codegen-arm.cc',
            'ic/arm/access-compiler-arm.cc',
            'ic/arm/handler-compiler-arm.cc',
            'ic/arm/ic-arm.cc',
            'regexp/arm/regexp-macro-assembler-arm.cc',
            'regexp/arm/regexp-macro-assembler-arm.h',
          ],
        }],
        ['v8_target_arch=="arm64"', {
          'sources': [  ### gcmole(arch:arm64) ###
            'arm64/assembler-arm64.cc',
            'arm64/assembler-arm64.h',
            'arm64/assembler-arm64-inl.h',
            'arm64/codegen-arm64.cc',
            'arm64/codegen-arm64.h',
            'arm64/code-stubs-arm64.cc',
            'arm64/code-stubs-arm64.h',
            'arm64/constants-arm64.h',
            'arm64/cpu-arm64.cc',
            'arm64/decoder-arm64.cc',
            'arm64/decoder-arm64.h',
            'arm64/decoder-arm64-inl.h',
            'arm64/deoptimizer-arm64.cc',
            'arm64/disasm-arm64.cc',
            'arm64/disasm-arm64.h',
            'arm64/frames-arm64.cc',
            'arm64/frames-arm64.h',
            'arm64/instructions-arm64.cc',
            'arm64/instructions-arm64.h',
            'arm64/instrument-arm64.cc',
            'arm64/instrument-arm64.h',
            'arm64/interface-descriptors-arm64.cc',
            'arm64/interface-descriptors-arm64.h',
            'arm64/macro-assembler-arm64.cc',
            'arm64/macro-assembler-arm64.h',
            'arm64/macro-assembler-arm64-inl.h',
            'arm64/simulator-arm64.cc',
            'arm64/simulator-arm64.h',
            'arm64/simulator-logic-arm64.cc',
            'arm64/utils-arm64.cc',
            'arm64/utils-arm64.h',
            'arm64/eh-frame-arm64.cc',
            'compiler/arm64/code-generator-arm64.cc',
            'compiler/arm64/instruction-codes-arm64.h',
            'compiler/arm64/instruction-scheduler-arm64.cc',
            'compiler/arm64/instruction-selector-arm64.cc',
            'compiler/arm64/unwinding-info-writer-arm64.h',
            'compiler/arm64/unwinding-info-writer-arm64.cc',
            'crankshaft/arm64/delayed-masm-arm64.cc',
            'crankshaft/arm64/delayed-masm-arm64.h',
            'crankshaft/arm64/delayed-masm-arm64-inl.h',
            'crankshaft/arm64/lithium-arm64.cc',
            'crankshaft/arm64/lithium-arm64.h',
            'crankshaft/arm64/lithium-codegen-arm64.cc',
            'crankshaft/arm64/lithium-codegen-arm64.h',
            'crankshaft/arm64/lithium-gap-resolver-arm64.cc',
            'crankshaft/arm64/lithium-gap-resolver-arm64.h',
            'debug/arm64/debug-arm64.cc',
            'full-codegen/arm64/full-codegen-arm64.cc',
            'ic/arm64/access-compiler-arm64.cc',
            'ic/arm64/handler-compiler-arm64.cc',
            'ic/arm64/ic-arm64.cc',
            'regexp/arm64/regexp-macro-assembler-arm64.cc',
            'regexp/arm64/regexp-macro-assembler-arm64.h',
          ],
        }],
        ['v8_target_arch=="ia32"', {
          'sources': [  ### gcmole(arch:ia32) ###
            'ia32/assembler-ia32-inl.h',
            'ia32/assembler-ia32.cc',
            'ia32/assembler-ia32.h',
            'ia32/code-stubs-ia32.cc',
            'ia32/code-stubs-ia32.h',
            'ia32/codegen-ia32.cc',
            'ia32/codegen-ia32.h',
            'ia32/cpu-ia32.cc',
            'ia32/deoptimizer-ia32.cc',
            'ia32/disasm-ia32.cc',
            'ia32/frames-ia32.cc',
            'ia32/frames-ia32.h',
            'ia32/interface-descriptors-ia32.cc',
            'ia32/macro-assembler-ia32.cc',
            'ia32/macro-assembler-ia32.h',
            'ia32/simulator-ia32.cc',
            'ia32/simulator-ia32.h',
            'ia32/sse-instr.h',
            'compiler/ia32/code-generator-ia32.cc',
            'compiler/ia32/instruction-codes-ia32.h',
            'compiler/ia32/instruction-scheduler-ia32.cc',
            'compiler/ia32/instruction-selector-ia32.cc',
            'crankshaft/ia32/lithium-codegen-ia32.cc',
            'crankshaft/ia32/lithium-codegen-ia32.h',
            'crankshaft/ia32/lithium-gap-resolver-ia32.cc',
            'crankshaft/ia32/lithium-gap-resolver-ia32.h',
            'crankshaft/ia32/lithium-ia32.cc',
            'crankshaft/ia32/lithium-ia32.h',
            'debug/ia32/debug-ia32.cc',
            'full-codegen/ia32/full-codegen-ia32.cc',
            'ic/ia32/access-compiler-ia32.cc',
            'ic/ia32/handler-compiler-ia32.cc',
            'ic/ia32/ic-ia32.cc',
            'regexp/ia32/regexp-macro-assembler-ia32.cc',
            'regexp/ia32/regexp-macro-assembler-ia32.h',
          ],
        }],
        ['v8_target_arch=="x87"', {
          'sources': [  ### gcmole(arch:x87) ###
            'x87/assembler-x87-inl.h',
            'x87/assembler-x87.cc',
            'x87/assembler-x87.h',
            'x87/code-stubs-x87.cc',
            'x87/code-stubs-x87.h',
            'x87/codegen-x87.cc',
            'x87/codegen-x87.h',
            'x87/cpu-x87.cc',
            'x87/deoptimizer-x87.cc',
            'x87/disasm-x87.cc',
            'x87/frames-x87.cc',
            'x87/frames-x87.h',
            'x87/interface-descriptors-x87.cc',
            'x87/macro-assembler-x87.cc',
            'x87/macro-assembler-x87.h',
            'x87/simulator-x87.cc',
            'x87/simulator-x87.h',
            'compiler/x87/code-generator-x87.cc',
            'compiler/x87/instruction-codes-x87.h',
            'compiler/x87/instruction-scheduler-x87.cc',
            'compiler/x87/instruction-selector-x87.cc',
            'crankshaft/x87/lithium-codegen-x87.cc',
            'crankshaft/x87/lithium-codegen-x87.h',
            'crankshaft/x87/lithium-gap-resolver-x87.cc',
            'crankshaft/x87/lithium-gap-resolver-x87.h',
            'crankshaft/x87/lithium-x87.cc',
            'crankshaft/x87/lithium-x87.h',
            'debug/x87/debug-x87.cc',
            'full-codegen/x87/full-codegen-x87.cc',
            'ic/x87/access-compiler-x87.cc',
            'ic/x87/handler-compiler-x87.cc',
            'ic/x87/ic-x87.cc',
            'regexp/x87/regexp-macro-assembler-x87.cc',
            'regexp/x87/regexp-macro-assembler-x87.h',
          ],
        }],
        ['v8_target_arch=="mips" or v8_target_arch=="mipsel"', {
          'sources': [  ### gcmole(arch:mipsel) ###
            'mips/assembler-mips.cc',
            'mips/assembler-mips.h',
            'mips/assembler-mips-inl.h',
            'mips/codegen-mips.cc',
            'mips/codegen-mips.h',
            'mips/code-stubs-mips.cc',
            'mips/code-stubs-mips.h',
            'mips/constants-mips.cc',
            'mips/constants-mips.h',
            'mips/cpu-mips.cc',
            'mips/deoptimizer-mips.cc',
            'mips/disasm-mips.cc',
            'mips/frames-mips.cc',
            'mips/frames-mips.h',
            'mips/interface-descriptors-mips.cc',
            'mips/macro-assembler-mips.cc',
            'mips/macro-assembler-mips.h',
            'mips/simulator-mips.cc',
            'mips/simulator-mips.h',
            'compiler/mips/code-generator-mips.cc',
            'compiler/mips/instruction-codes-mips.h',
            'compiler/mips/instruction-scheduler-mips.cc',
            'compiler/mips/instruction-selector-mips.cc',
            'crankshaft/mips/lithium-codegen-mips.cc',
            'crankshaft/mips/lithium-codegen-mips.h',
            'crankshaft/mips/lithium-gap-resolver-mips.cc',
            'crankshaft/mips/lithium-gap-resolver-mips.h',
            'crankshaft/mips/lithium-mips.cc',
            'crankshaft/mips/lithium-mips.h',
            'full-codegen/mips/full-codegen-mips.cc',
            'debug/mips/debug-mips.cc',
            'ic/mips/access-compiler-mips.cc',
            'ic/mips/handler-compiler-mips.cc',
            'ic/mips/ic-mips.cc',
            'regexp/mips/regexp-macro-assembler-mips.cc',
            'regexp/mips/regexp-macro-assembler-mips.h',
          ],
        }],
        ['v8_target_arch=="mips64" or v8_target_arch=="mips64el"', {
          'sources': [  ### gcmole(arch:mips64el) ###
            'mips64/assembler-mips64.cc',
            'mips64/assembler-mips64.h',
            'mips64/assembler-mips64-inl.h',
            'mips64/codegen-mips64.cc',
            'mips64/codegen-mips64.h',
            'mips64/code-stubs-mips64.cc',
            'mips64/code-stubs-mips64.h',
            'mips64/constants-mips64.cc',
            'mips64/constants-mips64.h',
            'mips64/cpu-mips64.cc',
            'mips64/deoptimizer-mips64.cc',
            'mips64/disasm-mips64.cc',
            'mips64/frames-mips64.cc',
            'mips64/frames-mips64.h',
            'mips64/interface-descriptors-mips64.cc',
            'mips64/macro-assembler-mips64.cc',
            'mips64/macro-assembler-mips64.h',
            'mips64/simulator-mips64.cc',
            'mips64/simulator-mips64.h',
            'compiler/mips64/code-generator-mips64.cc',
            'compiler/mips64/instruction-codes-mips64.h',
            'compiler/mips64/instruction-scheduler-mips64.cc',
            'compiler/mips64/instruction-selector-mips64.cc',
            'crankshaft/mips64/lithium-codegen-mips64.cc',
            'crankshaft/mips64/lithium-codegen-mips64.h',
            'crankshaft/mips64/lithium-gap-resolver-mips64.cc',
            'crankshaft/mips64/lithium-gap-resolver-mips64.h',
            'crankshaft/mips64/lithium-mips64.cc',
            'crankshaft/mips64/lithium-mips64.h',
            'debug/mips64/debug-mips64.cc',
            'full-codegen/mips64/full-codegen-mips64.cc',
            'ic/mips64/access-compiler-mips64.cc',
            'ic/mips64/handler-compiler-mips64.cc',
            'ic/mips64/ic-mips64.cc',
            'regexp/mips64/regexp-macro-assembler-mips64.cc',
            'regexp/mips64/regexp-macro-assembler-mips64.h',
          ],
        }],
        ['v8_target_arch=="x64"', {
          'sources': [  ### gcmole(arch:x64) ###
            'compiler/x64/code-generator-x64.cc',
            'compiler/x64/instruction-codes-x64.h',
            'compiler/x64/instruction-scheduler-x64.cc',
            'compiler/x64/instruction-selector-x64.cc',
            'compiler/x64/unwinding-info-writer-x64.h',
            'compiler/x64/unwinding-info-writer-x64.cc',
            'crankshaft/x64/lithium-codegen-x64.cc',
            'crankshaft/x64/lithium-codegen-x64.h',
            'crankshaft/x64/lithium-gap-resolver-x64.cc',
            'crankshaft/x64/lithium-gap-resolver-x64.h',
            'crankshaft/x64/lithium-x64.cc',
            'crankshaft/x64/lithium-x64.h',
            'x64/assembler-x64-inl.h',
            'x64/assembler-x64.cc',
            'x64/assembler-x64.h',
            'x64/code-stubs-x64.cc',
            'x64/code-stubs-x64.h',
            'x64/codegen-x64.cc',
            'x64/codegen-x64.h',
            'x64/cpu-x64.cc',
            'x64/deoptimizer-x64.cc',
            'x64/disasm-x64.cc',
            'x64/eh-frame-x64.cc',
            'x64/frames-x64.cc',
            'x64/frames-x64.h',
            'x64/interface-descriptors-x64.cc',
            'x64/macro-assembler-x64.cc',
            'x64/macro-assembler-x64.h',
            'x64/simulator-x64.cc',
            'x64/simulator-x64.h',
            'x64/sse-instr.h',
            'debug/x64/debug-x64.cc',
            'full-codegen/x64/full-codegen-x64.cc',
            'ic/x64/access-compiler-x64.cc',
            'ic/x64/handler-compiler-x64.cc',
            'ic/x64/ic-x64.cc',
            'regexp/x64/regexp-macro-assembler-x64.cc',
            'regexp/x64/regexp-macro-assembler-x64.h',
            'third_party/valgrind/valgrind.h',
          ],
        }],
        ['v8_target_arch=="x64" and OS=="linux"', {
            'sources': ['trap-handler/handler-inside.cc']
        }],
        ['v8_target_arch=="ppc" or v8_target_arch=="ppc64"', {
          'sources': [  ### gcmole(arch:ppc) ###
            'compiler/ppc/code-generator-ppc.cc',
            'compiler/ppc/instruction-codes-ppc.h',
            'compiler/ppc/instruction-scheduler-ppc.cc',
            'compiler/ppc/instruction-selector-ppc.cc',
            'crankshaft/ppc/lithium-ppc.cc',
            'crankshaft/ppc/lithium-ppc.h',
            'crankshaft/ppc/lithium-codegen-ppc.cc',
            'crankshaft/ppc/lithium-codegen-ppc.h',
            'crankshaft/ppc/lithium-gap-resolver-ppc.cc',
            'crankshaft/ppc/lithium-gap-resolver-ppc.h',
            'debug/ppc/debug-ppc.cc',
            'full-codegen/ppc/full-codegen-ppc.cc',
            'ic/ppc/access-compiler-ppc.cc',
            'ic/ppc/handler-compiler-ppc.cc',
            'ic/ppc/ic-ppc.cc',
            'ppc/assembler-ppc-inl.h',
            'ppc/assembler-ppc.cc',
            'ppc/assembler-ppc.h',
            'ppc/code-stubs-ppc.cc',
            'ppc/code-stubs-ppc.h',
            'ppc/codegen-ppc.cc',
            'ppc/codegen-ppc.h',
            'ppc/constants-ppc.h',
            'ppc/constants-ppc.cc',
            'ppc/cpu-ppc.cc',
            'ppc/deoptimizer-ppc.cc',
            'ppc/disasm-ppc.cc',
            'ppc/frames-ppc.cc',
            'ppc/frames-ppc.h',
            'ppc/interface-descriptors-ppc.cc',
            'ppc/macro-assembler-ppc.cc',
            'ppc/macro-assembler-ppc.h',
            'ppc/simulator-ppc.cc',
            'ppc/simulator-ppc.h',
            'regexp/ppc/regexp-macro-assembler-ppc.cc',
            'regexp/ppc/regexp-macro-assembler-ppc.h',
          ],
        }],
        ['v8_target_arch=="s390" or v8_target_arch=="s390x"', {
          'sources': [  ### gcmole(arch:s390) ###
            'compiler/s390/code-generator-s390.cc',
            'compiler/s390/instruction-codes-s390.h',
            'compiler/s390/instruction-scheduler-s390.cc',
            'compiler/s390/instruction-selector-s390.cc',
            'crankshaft/s390/lithium-codegen-s390.cc',
            'crankshaft/s390/lithium-codegen-s390.h',
            'crankshaft/s390/lithium-gap-resolver-s390.cc',
            'crankshaft/s390/lithium-gap-resolver-s390.h',
            'crankshaft/s390/lithium-s390.cc',
            'crankshaft/s390/lithium-s390.h',
            'debug/s390/debug-s390.cc',
            'full-codegen/s390/full-codegen-s390.cc',
            'ic/s390/access-compiler-s390.cc',
            'ic/s390/handler-compiler-s390.cc',
            'ic/s390/ic-s390.cc',
            'regexp/s390/regexp-macro-assembler-s390.cc',
            'regexp/s390/regexp-macro-assembler-s390.h',
            's390/assembler-s390.cc',
            's390/assembler-s390.h',
            's390/assembler-s390-inl.h',
            's390/codegen-s390.cc',
            's390/codegen-s390.h',
            's390/code-stubs-s390.cc',
            's390/code-stubs-s390.h',
            's390/constants-s390.cc',
            's390/constants-s390.h',
            's390/cpu-s390.cc',
            's390/deoptimizer-s390.cc',
            's390/disasm-s390.cc',
            's390/frames-s390.cc',
            's390/frames-s390.h',
            's390/interface-descriptors-s390.cc',
            's390/macro-assembler-s390.cc',
            's390/macro-assembler-s390.h',
            's390/simulator-s390.cc',
            's390/simulator-s390.h',
          ],
        }],
        ['OS=="win"', {
          'variables': {
            'gyp_generators': '<!(echo $GYP_GENERATORS)',
          },
          'msvs_disabled_warnings': [4351, 4355, 4800],
          # When building Official, the .lib is too large and exceeds the 2G
          # limit. This breaks it into multiple pieces to avoid the limit.
          # See http://crbug.com/485155.
          'msvs_shard': 4,
        }],
        ['component=="shared_library"', {
          'defines': [
            'BUILDING_V8_SHARED',
          ],
        }],
        ['v8_postmortem_support=="true"', {
          'sources': [
            '<(SHARED_INTERMEDIATE_DIR)/debug-support.cc',
          ]
        }],
        ['v8_enable_i18n_support==1', {
          'dependencies': [
            '<(icu_gyp_path):icui18n',
            '<(icu_gyp_path):icuuc',
          ],
          'conditions': [
            ['icu_use_data_file_flag==1', {
              'defines': ['ICU_UTIL_DATA_IMPL=ICU_UTIL_DATA_FILE'],
            }, { # else icu_use_data_file_flag !=1
              'conditions': [
                ['OS=="win"', {
                  'defines': ['ICU_UTIL_DATA_IMPL=ICU_UTIL_DATA_SHARED'],
                }, {
                  'defines': ['ICU_UTIL_DATA_IMPL=ICU_UTIL_DATA_STATIC'],
                }],
              ],
            }],
          ],
        }, {  # v8_enable_i18n_support==0
          'sources!': [
            'builtins/builtins-intl.cc',
            'intl.cc',
            'intl.h',
            'objects/intl-objects.cc',
            'objects/intl-objects.h',
            'runtime/runtime-intl.cc',
          ],
        }],
        ['OS=="win" and v8_enable_i18n_support==1', {
          'dependencies': [
            '<(icu_gyp_path):icudata',
          ],
        }],
      ],
    },
    {
      'target_name': 'v8_libbase',
      'type': '<(component)',
      'variables': {
        'optimize': 'max',
      },
      'include_dirs+': [
        '..',
      ],
      'sources': [
        'base/adapters.h',
        'base/atomic-utils.h',
        'base/atomicops.h',
        'base/atomicops_internals_atomicword_compat.h',
        'base/atomicops_internals_portable.h',
        'base/atomicops_internals_x86_msvc.h',
        'base/base-export.h',
        'base/bits.cc',
        'base/bits.h',
        'base/build_config.h',
        'base/compiler-specific.h',
        'base/cpu.cc',
        'base/cpu.h',
        'base/division-by-constant.cc',
        'base/division-by-constant.h',
        'base/debug/stack_trace.cc',
        'base/debug/stack_trace.h',
        'base/export-template.h',
        'base/file-utils.cc',
        'base/file-utils.h',
        'base/flags.h',
        'base/format-macros.h',
        'base/free_deleter.h',
        'base/functional.cc',
        'base/functional.h',
        'base/hashmap.h',
        'base/hashmap-entry.h',
        'base/ieee754.cc',
        'base/ieee754.h',
        'base/iterator.h',
        'base/lazy-instance.h',
        'base/logging.cc',
        'base/logging.h',
        'base/macros.h',
        'base/once.cc',
        'base/once.h',
        'base/optional.h',
        'base/platform/elapsed-timer.h',
        'base/platform/time.cc',
        'base/platform/time.h',
        'base/platform/condition-variable.cc',
        'base/platform/condition-variable.h',
        'base/platform/mutex.cc',
        'base/platform/mutex.h',
        'base/platform/platform.h',
        'base/platform/semaphore.cc',
        'base/platform/semaphore.h',
        'base/ring-buffer.h',
        'base/safe_conversions.h',
        'base/safe_conversions_impl.h',
        'base/safe_math.h',
        'base/safe_math_impl.h',
        'base/sys-info.cc',
        'base/sys-info.h',
        'base/template-utils.h',
        'base/timezone-cache.h',
        'base/utils/random-number-generator.cc',
        'base/utils/random-number-generator.h',
      ],
      'target_conditions': [
        ['OS=="android" and _toolset=="target"', {
          'libraries': [
            '-llog',
          ],
          'include_dirs': [
            'src/common/android/include',
          ],
        }],
      ],
      'conditions': [
        ['want_separate_host_toolset==1', {
          'toolsets': ['host', 'target'],
        }, {
          'toolsets': ['target'],
        }],
        ['component=="shared_library"', {
          'defines': [
            'BUILDING_V8_BASE_SHARED',
          ],
          'direct_dependent_settings': {
            'defines': [
              'USING_V8_BASE_SHARED',
            ],
          },
        }],
        ['OS=="linux"', {
            'link_settings': {
              'libraries': [
                '-ldl',
                '-lrt'
              ],
            },
            'sources': [
              'base/debug/stack_trace_posix.cc',
              'base/platform/platform-linux.cc',
              'base/platform/platform-posix.h',
              'base/platform/platform-posix.cc',
            ],
          }
        ],
        ['OS=="android"', {
            'sources': [
              'base/debug/stack_trace_android.cc',
              'base/platform/platform-posix.h',
              'base/platform/platform-posix.cc',
            ],
            'link_settings': {
              'target_conditions': [
                ['_toolset=="host" and host_os!="mac"', {
                  # Only include libdl and librt on host builds because they
                  # are included by default on Android target builds, and we
                  # don't want to re-include them here since this will change
                  # library order and break (see crbug.com/469973).
                  # These libraries do not exist on Mac hosted builds.
                  'libraries': [
                    '-ldl',
                    '-lrt'
                  ]
                }]
              ]
            },
            'conditions': [
              ['host_os=="mac"', {
                'target_conditions': [
                  ['_toolset=="host"', {
                    'sources': [
                      'base/platform/platform-macos.cc'
                    ]
                  }, {
                    'sources': [
                      'base/platform/platform-linux.cc'
                    ]
                  }],
                ],
              }, {
                'sources': [
                  'base/platform/platform-linux.cc'
                ]
              }],
            ],
          },
        ],
        ['OS=="qnx"', {
            'link_settings': {
              'target_conditions': [
                ['_toolset=="host" and host_os=="linux"', {
                  'libraries': [
                    '-lrt'
                  ],
                }],
                ['_toolset=="target"', {
                  'libraries': [
                    '-lbacktrace'
                  ],
                }],
              ],
            },
            'sources': [
              'base/debug/stack_trace_posix.cc',
              'base/platform/platform-posix.h',
              'base/platform/platform-posix.cc',
              'base/qnx-math.h'
            ],
            'target_conditions': [
              ['_toolset=="host" and host_os=="linux"', {
                'sources': [
                  'base/platform/platform-linux.cc'
                ],
              }],
              ['_toolset=="host" and host_os=="mac"', {
                'sources': [
                  'base/platform/platform-macos.cc'
                ],
              }],
              ['_toolset=="target"', {
                'sources': [
                  'base/platform/platform-qnx.cc'
                ],
              }],
            ],
          },
        ],
        ['OS=="freebsd"', {
            'link_settings': {
              'libraries': [
                '-L/usr/local/lib -lexecinfo',
            ]},
            'sources': [
              'base/debug/stack_trace_posix.cc',
              'base/platform/platform-freebsd.cc',
              'base/platform/platform-posix.h',
              'base/platform/platform-posix.cc',
            ],
          }
        ],
        ['OS=="openbsd"', {
            'link_settings': {
              'libraries': [
                '-L/usr/local/lib -lexecinfo',
            ]},
            'sources': [
              'base/platform/platform-openbsd.cc',
              'base/platform/platform-posix.h',
              'base/platform/platform-posix.cc'
            ],
          }
        ],
        ['OS=="netbsd"', {
            'link_settings': {
              'libraries': [
                '-L/usr/pkg/lib -Wl,-R/usr/pkg/lib -lexecinfo',
            ]},
            'sources': [
              'base/debug/stack_trace_posix.cc',
              'base/platform/platform-openbsd.cc',
              'base/platform/platform-posix.h',
              'base/platform/platform-posix.cc',
            ],
          }
        ],
        ['OS=="aix"', {
          'sources': [
            'base/debug/stack_trace_posix.cc',
            'base/platform/platform-aix.cc',
            'base/platform/platform-posix.h',
            'base/platform/platform-posix.cc'
          ]},
        ],
        ['OS=="solaris"', {
            'link_settings': {
              'libraries': [
                '-lnsl -lrt',
            ]},
            'sources': [
              'base/debug/stack_trace_posix.cc',
              'base/platform/platform-solaris.cc',
              'base/platform/platform-posix.h',
              'base/platform/platform-posix.cc',
            ],
          }
        ],
        ['OS=="mac"', {
          'sources': [
            'base/debug/stack_trace_posix.cc',
            'base/platform/platform-macos.cc',
            'base/platform/platform-posix.h',
            'base/platform/platform-posix.cc',
          ]},
        ],
        ['OS=="win"', {
          'defines': [
            '_CRT_RAND_S'  # for rand_s()
          ],
          'variables': {
            'gyp_generators': '<!(echo $GYP_GENERATORS)',
          },
          'conditions': [
            ['gyp_generators=="make"', {
              'variables': {
                'build_env': '<!(uname -o)',
              },
              'conditions': [
                ['build_env=="Cygwin"', {
                  'sources': [
                    'base/debug/stack_trace_posix.cc',
                    'base/platform/platform-cygwin.cc',
                    'base/platform/platform-posix.h',
                    'base/platform/platform-posix.cc',
                  ],
                }, {
                  'sources': [
                    'base/debug/stack_trace_win.cc',
                    'base/platform/platform-win32.cc',
                    'base/win32-headers.h',
                  ],
                }],
              ],
              'link_settings':  {
                'libraries': [ '-lwinmm', '-lws2_32' ],
              },
            }, {
              'sources': [
                'base/debug/stack_trace_win.cc',
                'base/platform/platform-win32.cc',
                'base/win32-headers.h',
              ],
              'msvs_disabled_warnings': [4351, 4355, 4800],
              'link_settings':  {
                'libraries': [
                  '-ldbghelp.lib',
                  '-lshlwapi.lib',
                  '-lwinmm.lib',
                  '-lws2_32.lib'
                ],
              },
            }],
          ],
        }],
      ],
    },
    {
      'target_name': 'v8_libplatform',
      'type': '<(component)',
      'variables': {
        'optimize': 'max',
      },
      'dependencies': [
        'v8_libbase',
      ],
      'include_dirs+': [
        '..',
        '<(DEPTH)',
        '../include',
      ],
      'sources': [
        '../include/libplatform/libplatform.h',
        '../include/libplatform/libplatform-export.h',
        '../include/libplatform/v8-tracing.h',
        'libplatform/default-platform.cc',
        'libplatform/default-platform.h',
        'libplatform/task-queue.cc',
        'libplatform/task-queue.h',
        'libplatform/tracing/trace-buffer.cc',
        'libplatform/tracing/trace-buffer.h',
        'libplatform/tracing/trace-config.cc',
        'libplatform/tracing/trace-object.cc',
        'libplatform/tracing/trace-writer.cc',
        'libplatform/tracing/trace-writer.h',
        'libplatform/tracing/tracing-controller.cc',
        'libplatform/worker-thread.cc',
        'libplatform/worker-thread.h',
      ],
      'conditions': [
        ['want_separate_host_toolset==1', {
          'toolsets': ['host', 'target'],
        }, {
          'toolsets': ['target'],
        }],
        ['component=="shared_library"', {
          'direct_dependent_settings': {
            'defines': [ 'USING_V8_PLATFORM_SHARED' ],
          },
          'defines': [ 'BUILDING_V8_PLATFORM_SHARED' ],
        }]
      ],
      'direct_dependent_settings': {
        'include_dirs': [
          '../include',
        ],
      },
    },
    {
      'target_name': 'v8_libsampler',
      'type': 'static_library',
      'variables': {
        'optimize': 'max',
      },
      'dependencies': [
        'v8_libbase',
      ],
      'include_dirs+': [
        '..',
        '../include',
      ],
      'sources': [
        'libsampler/sampler.cc',
        'libsampler/sampler.h'
      ],
      'conditions': [
        ['want_separate_host_toolset==1', {
          'toolsets': ['host', 'target'],
        }, {
          'toolsets': ['target'],
        }],
      ],
      'direct_dependent_settings': {
        'include_dirs': [
          '../include',
        ],
      },
    },
    {
      'target_name': 'natives_blob',
      'type': 'none',
      'conditions': [
        [ 'v8_use_external_startup_data==1', {
          'conditions': [
            ['want_separate_host_toolset==1', {
              'dependencies': ['js2c#host'],
            }, {
              'dependencies': ['js2c'],
            }],
          ],
          'actions': [{
            'action_name': 'concatenate_natives_blob',
            'inputs': [
              '../tools/concatenate-files.py',
              '<(SHARED_INTERMEDIATE_DIR)/libraries.bin',
              '<(SHARED_INTERMEDIATE_DIR)/libraries-extras.bin',
              '<(SHARED_INTERMEDIATE_DIR)/libraries-experimental-extras.bin',
            ],
            'conditions': [
              ['want_separate_host_toolset==1', {
                'target_conditions': [
                  ['_toolset=="host"', {
                    'outputs': [
                      '<(PRODUCT_DIR)/natives_blob_host.bin',
                    ],
                    'action': [
                      'python', '<@(_inputs)', '<(PRODUCT_DIR)/natives_blob_host.bin'
                    ],
                  }, {
                    'outputs': [
                      '<(PRODUCT_DIR)/natives_blob.bin',
                    ],
                    'action': [
                      'python', '<@(_inputs)', '<(PRODUCT_DIR)/natives_blob.bin'
                    ],
                  }],
                ],
              }, {
                'outputs': [
                  '<(PRODUCT_DIR)/natives_blob.bin',
                ],
                'action': [
                  'python', '<@(_inputs)', '<(PRODUCT_DIR)/natives_blob.bin'
                ],
              }],
            ],
          }],
        }],
        ['want_separate_host_toolset==1', {
          'toolsets': ['host', 'target'],
        }, {
          'toolsets': ['target'],
        }],
      ]
    },
    {
      'target_name': 'js2c',
      'type': 'none',
      'conditions': [
        ['want_separate_host_toolset==1', {
          'toolsets': ['host'],
        }, {
          'toolsets': ['target'],
        }],
      ],
      'variables': {
        'library_files': [
          'js/macros.py',
          'messages.h',
          'js/prologue.js',
          'js/max-min.js',
          'js/v8natives.js',
          'js/array.js',
          'js/string.js',
          'js/typedarray.js',
          'js/collection.js',
          'js/weak-collection.js',
          'js/collection-iterator.js',
          'js/promise.js',
          'js/messages.js',
          'js/templates.js',
          'js/spread.js',
          'js/proxy.js',
          'debug/mirrors.js',
          'debug/debug.js',
          'debug/liveedit.js',
        ],
        'libraries_bin_file': '<(SHARED_INTERMEDIATE_DIR)/libraries.bin',
        'libraries_extras_bin_file': '<(SHARED_INTERMEDIATE_DIR)/libraries-extras.bin',
        'libraries_experimental_extras_bin_file': '<(SHARED_INTERMEDIATE_DIR)/libraries-experimental-extras.bin',
        'conditions': [
          ['v8_enable_i18n_support==1', {
            'library_files': ['js/intl.js'],
          }],
        ],
      },
      'actions': [
        {
          'action_name': 'js2c',
          'inputs': [
            '../tools/js2c.py',
            '<@(library_files)',
          ],
          'outputs': ['<(SHARED_INTERMEDIATE_DIR)/libraries.cc'],
          'action': [
            'python',
            '../tools/js2c.py',
            '<(SHARED_INTERMEDIATE_DIR)/libraries.cc',
            'CORE',
            '<@(library_files)',
          ],
        },
        {
          'action_name': 'js2c_bin',
          'inputs': [
            '../tools/js2c.py',
            '<@(library_files)',
          ],
          'outputs': ['<@(libraries_bin_file)'],
          'action': [
            'python',
            '../tools/js2c.py',
            '<(SHARED_INTERMEDIATE_DIR)/libraries.cc',
            'CORE',
            '<@(library_files)',
            '--startup_blob', '<@(libraries_bin_file)',
            '--nojs',
          ],
        },
        {
          'action_name': 'js2c_extras',
          'inputs': [
            '../tools/js2c.py',
            '<@(v8_extra_library_files)',
          ],
          'outputs': ['<(SHARED_INTERMEDIATE_DIR)/extras-libraries.cc'],
          'action': [
            'python',
            '../tools/js2c.py',
            '<(SHARED_INTERMEDIATE_DIR)/extras-libraries.cc',
            'EXTRAS',
            '<@(v8_extra_library_files)',
          ],
        },
        {
          'action_name': 'js2c_extras_bin',
          'inputs': [
            '../tools/js2c.py',
            '<@(v8_extra_library_files)',
          ],
          'outputs': ['<@(libraries_extras_bin_file)'],
          'action': [
            'python',
            '../tools/js2c.py',
            '<(SHARED_INTERMEDIATE_DIR)/extras-libraries.cc',
            'EXTRAS',
            '<@(v8_extra_library_files)',
            '--startup_blob', '<@(libraries_extras_bin_file)',
            '--nojs',
          ],
        },
        {
          'action_name': 'js2c_experimental_extras',
          'inputs': [
            '../tools/js2c.py',
            '<@(v8_experimental_extra_library_files)',
          ],
          'outputs': [
            '<(SHARED_INTERMEDIATE_DIR)/experimental-extras-libraries.cc',
          ],
          'action': [
            'python',
            '../tools/js2c.py',
            '<(SHARED_INTERMEDIATE_DIR)/experimental-extras-libraries.cc',
            'EXPERIMENTAL_EXTRAS',
            '<@(v8_experimental_extra_library_files)',
          ],
        },
        {
          'action_name': 'js2c_experimental_extras_bin',
          'inputs': [
            '../tools/js2c.py',
            '<@(v8_experimental_extra_library_files)',
          ],
          'outputs': ['<@(libraries_experimental_extras_bin_file)'],
          'action': [
            'python',
            '../tools/js2c.py',
            '<(SHARED_INTERMEDIATE_DIR)/experimental-extras-libraries.cc',
            'EXPERIMENTAL_EXTRAS',
            '<@(v8_experimental_extra_library_files)',
            '--startup_blob', '<@(libraries_experimental_extras_bin_file)',
            '--nojs',
          ],
        },
      ],
    },
    {
      'target_name': 'postmortem-metadata',
      'type': 'none',
      'variables': {
        'heapobject_files': [
            'objects.h',
            'objects-inl.h',
            'objects/map.h',
            'objects/map-inl.h',
            'objects/script.h',
            'objects/script-inl.h',
            'objects/shared-function-info.h',
            'objects/shared-function-info-inl.h',
        ],
      },
      'actions': [
          {
            'action_name': 'gen-postmortem-metadata',
            'inputs': [
              '../tools/gen-postmortem-metadata.py',
              '<@(heapobject_files)',
            ],
            'outputs': [
              '<(SHARED_INTERMEDIATE_DIR)/debug-support.cc',
            ],
            'action': [
              'python',
              '../tools/gen-postmortem-metadata.py',
              '<@(_outputs)',
              '<@(heapobject_files)'
            ]
          }
        ]
    },
    {
      'target_name': 'mksnapshot',
      'type': 'executable',
      'dependencies': [
        'v8_base',
        'v8_builtins_setup',
        'v8_libbase',
        'v8_libplatform',
        'v8_nosnapshot',
      ],
      'include_dirs+': [
        '..',
        '<(DEPTH)',
      ],
      'sources': [
        'snapshot/mksnapshot.cc',
      ],
      'conditions': [
        ['v8_enable_i18n_support==1', {
          'dependencies': [
            '<(icu_gyp_path):icui18n',
            '<(icu_gyp_path):icuuc',
          ]
        }],
        ['want_separate_host_toolset==1', {
          'toolsets': ['host'],
        }, {
          'toolsets': ['target'],
        }],
      ],
    },
  ],
}
