#!/usr/bin/env python
# Copyright 2015 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

"""Tests for java_google_api_keys.py.

This test suite contains various tests for the C++ -> Java Google API Keys
generator.
"""

import collections
import argparse
import os
import sys
import unittest

import java_google_api_keys

sys.path.append(os.path.join(os.path.dirname(__file__), "gyp"))
from util import build_utils


class TestJavaGoogleAPIKeys(unittest.TestCase):
  def testOutput(self):
    definition = {'E1': 'abc', 'E2': 'defgh'}
    output = java_google_api_keys.GenerateOutput(definition)
    expected = """
// Copyright 2015 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by
//     %s
// From
//     google_api_keys/google_api_keys.h

package org.chromium.chrome;

public class GoogleAPIKeys {
  public static final String E1 = "abc";
  public static final String E2 = "defgh";
}
"""
    self.assertEqual(expected % java_google_api_keys.GetScriptName(), output)


def main(argv):
  parser = argparse.ArgumentParser()
  parser.add_argument("--stamp", help="File to touch on success.")
  options = parser.parse_args(argv)

  suite = unittest.TestLoader().loadTestsFromTestCase(TestJavaGoogleAPIKeys)
  unittest.TextTestRunner(verbosity=0).run(suite)

  if options.stamp:
    build_utils.Touch(options.stamp)

if __name__ == '__main__':
  main(sys.argv[1:])

