// Copyright (c) 2011 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "media/audio/audio_device_name.h"

#include <utility>

#include "media/audio/audio_device_description.h"

namespace media {

AudioDeviceName::AudioDeviceName() = default;

AudioDeviceName::AudioDeviceName(std::string device_name, std::string unique_id)
    : device_name(std::move(device_name)), unique_id(std::move(unique_id)) {}

// static
AudioDeviceName AudioDeviceName::CreateDefault() {
  return AudioDeviceName(AudioDeviceDescription::GetDefaultDeviceName(),
                         AudioDeviceDescription::kDefaultDeviceId);
}

// static
AudioDeviceName AudioDeviceName::CreateCommunications() {
  return AudioDeviceName(AudioDeviceDescription::GetCommunicationsDeviceName(),
                         AudioDeviceDescription::kCommunicationsDeviceId);
}

}  // namespace media
