// Copyright (c) 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef NET_QUIC_CORE_FRAMES_QUIC_NEW_CONNECTION_ID_FRAME_H_
#define NET_QUIC_CORE_FRAMES_QUIC_NEW_CONNECTION_ID_FRAME_H_

#include <ostream>

#include "net/quic/core/frames/quic_control_frame.h"
#include "net/quic/core/quic_error_codes.h"
#include "net/quic/platform/api/quic_uint128.h"

namespace net {

struct QUIC_EXPORT_PRIVATE QuicNewConnectionIdFrame : public QuicControlFrame {
  QuicNewConnectionIdFrame();
  QuicNewConnectionIdFrame(QuicControlFrameId control_frame_id,
                           QuicConnectionId connection_id,
                           QuicConnectionIdSequenceNumber sequence_number,
                           const QuicUint128 stateless_reset_token);

  friend QUIC_EXPORT_PRIVATE std::ostream& operator<<(
      std::ostream& os,
      const QuicNewConnectionIdFrame& frame);

  QuicConnectionId connection_id;
  QuicConnectionIdSequenceNumber sequence_number;
  QuicUint128 stateless_reset_token;
};

}  // namespace net

#endif  // NET_QUIC_CORE_FRAMES_QUIC_NEW_CONNECTION_ID_FRAME_H_
