// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is of the same format as file that generated by
//     base/android/jni_generator/jni_generator.py
// For
//     com/google/vr/ndk/base/GvrApi

// Local modification includes:
// 1. Remove all implementaiton, only keep definition.
// 2. Use absolute path instead of relative path.
// 3. Removed all helper functions such as: Create.
// 4. Removed external functions that don't have implementation in shim file.
// 5. Changed RectF, Point, and PoseTracker to correct package name.
// 6. Added function RegisterGvrApiNatives at the end of this file.

#ifndef com_google_vr_ndk_base_GvrApi_JNI
#define com_google_vr_ndk_base_GvrApi_JNI

#include "base/android/jni_android.h"
// ----------------------------------------------------------------------------
// Native JNI methods
// ----------------------------------------------------------------------------
#include <jni.h>

#include "base/android/jni_generator/jni_generator_helper.h"

#include "base/android/jni_int_wrapper.h"

// Step 1: forward declarations.
namespace {
const char kGvrApiClassPath[] = "com/google/vr/ndk/base/GvrApi";
// Leaking this jclass as we cannot use LazyInstance from some threads.
base::subtle::AtomicWord g_GvrApi_clazz __attribute__((unused)) = 0;
#define GvrApi_clazz(env) \
  base::android::LazyGetClass(env, kGvrApiClassPath, &g_GvrApi_clazz)

}  // namespace

namespace GvrApi {
// Step 2: method stubs.

JNI_GENERATOR_EXPORT jlong
Java_com_google_vr_ndk_base_GvrApi_nativeBufferViewportListCreate(
    JNIEnv* env,
    jobject jcaller,
    jlong nativeGvrContext);

JNI_GENERATOR_EXPORT void
Java_com_google_vr_ndk_base_GvrApi_nativeBufferViewportListDestroy(
    JNIEnv* env,
    jclass jcaller,
    jlong nativeBufferViewportList);

JNI_GENERATOR_EXPORT jint
Java_com_google_vr_ndk_base_GvrApi_nativeBufferViewportListGetSize(
    JNIEnv* env,
    jclass jcaller,
    jlong nativeBufferViewportList);

JNI_GENERATOR_EXPORT void
Java_com_google_vr_ndk_base_GvrApi_nativeBufferViewportListGetItem(
    JNIEnv* env,
    jclass jcaller,
    jlong nativeBufferViewportList,
    jint index,
    jlong nativeBufferViewport);

JNI_GENERATOR_EXPORT void
Java_com_google_vr_ndk_base_GvrApi_nativeBufferViewportListSetItem(
    JNIEnv* env,
    jclass jcaller,
    jlong nativeBufferViewportList,
    jint index,
    jlong nativeBufferViewport);

JNI_GENERATOR_EXPORT jlong
Java_com_google_vr_ndk_base_GvrApi_nativeBufferViewportCreate(
    JNIEnv* env,
    jclass jcaller,
    jlong nativeGvrContext);

JNI_GENERATOR_EXPORT void
Java_com_google_vr_ndk_base_GvrApi_nativeBufferViewportDestroy(
    JNIEnv* env,
    jclass jcaller,
    jlong nativeBufferViewport);

JNI_GENERATOR_EXPORT void
Java_com_google_vr_ndk_base_GvrApi_nativeBufferViewportGetSourceUv(
    JNIEnv* env,
    jclass jcaller,
    jlong nativeBufferViewport,
    jobject out);

JNI_GENERATOR_EXPORT void
Java_com_google_vr_ndk_base_GvrApi_nativeBufferViewportSetSourceUv(
    JNIEnv* env,
    jclass jcaller,
    jlong nativeBufferViewport,
    jfloat left,
    jfloat top,
    jfloat right,
    jfloat bottom);

JNI_GENERATOR_EXPORT void
Java_com_google_vr_ndk_base_GvrApi_nativeBufferViewportGetSourceFov(
    JNIEnv* env,
    jclass jcaller,
    jlong nativeBufferViewport,
    jobject out);

JNI_GENERATOR_EXPORT void
Java_com_google_vr_ndk_base_GvrApi_nativeBufferViewportSetSourceFov(
    JNIEnv* env,
    jclass jcaller,
    jlong nativeBufferViewport,
    jfloat left,
    jfloat top,
    jfloat right,
    jfloat bottom);

JNI_GENERATOR_EXPORT void
Java_com_google_vr_ndk_base_GvrApi_nativeBufferViewportGetTransform(
    JNIEnv* env,
    jclass jcaller,
    jlong nativeBufferViewport,
    jfloatArray matrix);

JNI_GENERATOR_EXPORT void
Java_com_google_vr_ndk_base_GvrApi_nativeBufferViewportSetTransform(
    JNIEnv* env,
    jclass jcaller,
    jlong nativeBufferViewport,
    jfloatArray matrix);

JNI_GENERATOR_EXPORT jboolean
Java_com_google_vr_ndk_base_GvrApi_nativeBufferViewportEqual(JNIEnv* env,
                                                             jclass jcaller,
                                                             jlong nativeA,
                                                             jlong nativeB);

JNI_GENERATOR_EXPORT jint
Java_com_google_vr_ndk_base_GvrApi_nativeBufferViewportGetTargetEye(
    JNIEnv* env,
    jclass jcaller,
    jlong nativeBufferViewport);

JNI_GENERATOR_EXPORT void
Java_com_google_vr_ndk_base_GvrApi_nativeBufferViewportSetTargetEye(
    JNIEnv* env,
    jclass jcaller,
    jlong nativeBufferViewport,
    jint eye);

JNI_GENERATOR_EXPORT jint
Java_com_google_vr_ndk_base_GvrApi_nativeBufferViewportGetSourceBufferIndex(
    JNIEnv* env,
    jclass jcaller,
    jlong nativeBufferViewport);

JNI_GENERATOR_EXPORT void
Java_com_google_vr_ndk_base_GvrApi_nativeBufferViewportSetSourceBufferIndex(
    JNIEnv* env,
    jclass jcaller,
    jlong nativeBufferViewport,
    jint index);

JNI_GENERATOR_EXPORT jint
Java_com_google_vr_ndk_base_GvrApi_nativeBufferViewportGetExternalSurfaceId(
    JNIEnv* env,
    jclass jcaller,
    jlong nativeBufferViewport);

JNI_GENERATOR_EXPORT void
Java_com_google_vr_ndk_base_GvrApi_nativeBufferViewportSetExternalSurfaceId(
    JNIEnv* env,
    jclass jcaller,
    jlong nativeBufferViewport,
    jint id);

JNI_GENERATOR_EXPORT void
Java_com_google_vr_ndk_base_GvrApi_nativeBufferViewportSetExternalSurface(
    JNIEnv* env,
    jclass jcaller,
    jlong nativeBufferViewport,
    jlong nativeExternalSurface);

JNI_GENERATOR_EXPORT jint
Java_com_google_vr_ndk_base_GvrApi_nativeBufferViewportGetReprojection(
    JNIEnv* env,
    jclass jcaller,
    jlong nativeBufferViewport);

JNI_GENERATOR_EXPORT void
Java_com_google_vr_ndk_base_GvrApi_nativeBufferViewportSetReprojection(
    JNIEnv* env,
    jclass jcaller,
    jlong nativeBufferViewport,
    jint reprojection);

JNI_GENERATOR_EXPORT void
Java_com_google_vr_ndk_base_GvrApi_nativeBufferViewportSetSourceLayer(
    JNIEnv* env,
    jclass jcaller,
    jlong nativeBufferViewport,
    jint layerIndex);

JNI_GENERATOR_EXPORT jlong
Java_com_google_vr_ndk_base_GvrApi_nativeBufferSpecCreate(
    JNIEnv* env,
    jclass jcaller,
    jlong nativeGvrContext);

JNI_GENERATOR_EXPORT void
Java_com_google_vr_ndk_base_GvrApi_nativeBufferSpecDestroy(
    JNIEnv* env,
    jclass jcaller,
    jlong nativeBufferSpec);

JNI_GENERATOR_EXPORT void
Java_com_google_vr_ndk_base_GvrApi_nativeBufferSpecGetSize(
    JNIEnv* env,
    jclass jcaller,
    jlong nativeBufferSpec,
    jobject size);

JNI_GENERATOR_EXPORT void
Java_com_google_vr_ndk_base_GvrApi_nativeBufferSpecSetSize(
    JNIEnv* env,
    jclass jcaller,
    jlong nativeBufferSpec,
    jint width,
    jint height);

JNI_GENERATOR_EXPORT void
Java_com_google_vr_ndk_base_GvrApi_nativeBufferSpecSetColorFormat(
    JNIEnv* env,
    jclass jcaller,
    jlong nativeBufferSpec,
    jint format);

JNI_GENERATOR_EXPORT void
Java_com_google_vr_ndk_base_GvrApi_nativeBufferSpecSetDepthStencilFormat(
    JNIEnv* env,
    jclass jcaller,
    jlong nativeBufferSpec,
    jint format);

JNI_GENERATOR_EXPORT void
Java_com_google_vr_ndk_base_GvrApi_nativeBufferSpecSetMultiviewLayers(
    JNIEnv* env,
    jclass jcaller,
    jlong nativeBufferSpec,
    jint numLayers);

JNI_GENERATOR_EXPORT jint
Java_com_google_vr_ndk_base_GvrApi_nativeBufferSpecGetSamples(
    JNIEnv* env,
    jclass jcaller,
    jlong nativeBufferSpec);

JNI_GENERATOR_EXPORT void
Java_com_google_vr_ndk_base_GvrApi_nativeBufferSpecSetSamples(
    JNIEnv* env,
    jclass jcaller,
    jlong nativeBufferSpec,
    jint samples);

JNI_GENERATOR_EXPORT jlong
Java_com_google_vr_ndk_base_GvrApi_nativeExternalSurfaceCreateWithListeners(
    JNIEnv* env,
    jclass jcaller,
    jlong nativeGvrContext,
    jobject surfaceListener,
    jobject frameListener,
    jobject handler);

JNI_GENERATOR_EXPORT void
Java_com_google_vr_ndk_base_GvrApi_nativeExternalSurfaceDestroy(
    JNIEnv* env,
    jclass jcaller,
    jlong nativeBufferSpec);

JNI_GENERATOR_EXPORT jint
Java_com_google_vr_ndk_base_GvrApi_nativeExternalSurfaceGetId(
    JNIEnv* env,
    jclass jcaller,
    jlong nativeBufferSpec);

JNI_GENERATOR_EXPORT jobject
Java_com_google_vr_ndk_base_GvrApi_nativeExternalSurfaceGetSurface(
    JNIEnv* env,
    jclass jcaller,
    jlong nativeBufferSpec);

JNI_GENERATOR_EXPORT jlong
Java_com_google_vr_ndk_base_GvrApi_nativeSwapChainCreate(JNIEnv* env,
                                                         jclass jcaller,
                                                         jlong nativeContext,
                                                         jlongArray specs);

JNI_GENERATOR_EXPORT void
Java_com_google_vr_ndk_base_GvrApi_nativeSwapChainDestroy(JNIEnv* env,
                                                          jclass jcaller,
                                                          jlong nativeContext);

JNI_GENERATOR_EXPORT jint
Java_com_google_vr_ndk_base_GvrApi_nativeSwapChainGetBufferCount(
    JNIEnv* env,
    jclass jcaller,
    jlong nativeSwapChain);

JNI_GENERATOR_EXPORT void
Java_com_google_vr_ndk_base_GvrApi_nativeSwapChainGetBufferSize(
    JNIEnv* env,
    jclass jcaller,
    jlong nativeSwapChain,
    jint bufferIndex,
    jobject size);

JNI_GENERATOR_EXPORT void
Java_com_google_vr_ndk_base_GvrApi_nativeSwapChainResizeBuffer(
    JNIEnv* env,
    jclass jcaller,
    jlong nativeSwapChain,
    jint bufferIndex,
    jint width,
    jint height);

JNI_GENERATOR_EXPORT jlong
Java_com_google_vr_ndk_base_GvrApi_nativeSwapChainAcquireFrame(
    JNIEnv* env,
    jclass jcaller,
    jlong nativeSwapChain);

JNI_GENERATOR_EXPORT void
Java_com_google_vr_ndk_base_GvrApi_nativeFrameBindBuffer(JNIEnv* env,
                                                         jclass jcaller,
                                                         jlong nativeFrame,
                                                         jint bufferIndex);

JNI_GENERATOR_EXPORT void Java_com_google_vr_ndk_base_GvrApi_nativeFrameUnbind(
    JNIEnv* env,
    jclass jcaller,
    jlong nativeFrame);

JNI_GENERATOR_EXPORT jint
Java_com_google_vr_ndk_base_GvrApi_nativeFrameGetFramebufferObject(
    JNIEnv* env,
    jclass jcaller,
    jlong nativeFrame,
    jint bufferIndex);

JNI_GENERATOR_EXPORT void
Java_com_google_vr_ndk_base_GvrApi_nativeFrameGetBufferSize(JNIEnv* env,
                                                            jclass jcaller,
                                                            jlong nativeFrame,
                                                            jint bufferIndex,
                                                            jobject size);

JNI_GENERATOR_EXPORT void Java_com_google_vr_ndk_base_GvrApi_nativeFrameSubmit(
    JNIEnv* env,
    jclass jcaller,
    jlong nativeFrame,
    jlong nativeBufferViewportList,
    jfloatArray headSpaceFromStartSpace);

JNI_GENERATOR_EXPORT jboolean
Java_com_google_vr_ndk_base_GvrApi_nativeUsingDynamicLibrary(JNIEnv* env,
                                                             jclass jcaller);

JNI_GENERATOR_EXPORT jboolean
Java_com_google_vr_ndk_base_GvrApi_nativeUsingShimLibrary(JNIEnv* env,
                                                          jclass jcaller);

JNI_GENERATOR_EXPORT void
Java_com_google_vr_ndk_base_GvrApi_nativeSetApplicationState(JNIEnv* env,
                                                             jclass jcaller,
                                                             jclass classLoader,
                                                             jobject context);

JNI_GENERATOR_EXPORT void
Java_com_google_vr_ndk_base_GvrApi_nativeSetDynamicLibraryLoadingEnabled(
    JNIEnv* env,
    jclass jcaller,
    jboolean enabled);

JNI_GENERATOR_EXPORT jlong Java_com_google_vr_ndk_base_GvrApi_nativeCreate(
    JNIEnv* env,
    jobject jcaller,
    jclass classLoader,
    jobject context,
    jlong synchronizer,
    jint widthPixels,
    jint heightPixels,
    jfloat xDpi,
    jfloat yDpi,
    jobject optionalPoseTrackingForTesting);

JNI_GENERATOR_EXPORT void
Java_com_google_vr_ndk_base_GvrApi_nativeRequestContextSharing(
    JNIEnv* env,
    jobject jcaller,
    jlong nativeGvrContext,
    jobject eglListener);

JNI_GENERATOR_EXPORT jint
Java_com_google_vr_ndk_base_GvrApi_nativeGetError(JNIEnv* env,
                                                  jobject jcaller,
                                                  jlong nativeGvrContext);

JNI_GENERATOR_EXPORT jint
Java_com_google_vr_ndk_base_GvrApi_nativeClearError(JNIEnv* env,
                                                    jobject jcaller,
                                                    jlong nativeGvrContext);

JNI_GENERATOR_EXPORT jstring
Java_com_google_vr_ndk_base_GvrApi_nativeGetErrorString(JNIEnv* env,
                                                        jclass jcaller,
                                                        jint errorCode);

JNI_GENERATOR_EXPORT jlong
Java_com_google_vr_ndk_base_GvrApi_nativeGetUserPrefs(JNIEnv* env,
                                                      jobject jcaller,
                                                      jlong nativeGvrContext);

JNI_GENERATOR_EXPORT jint
Java_com_google_vr_ndk_base_GvrApi_nativeUserPrefsGetControllerHandedness(
    JNIEnv* env,
    jclass jcaller,
    jlong nativeUserPrefs);

JNI_GENERATOR_EXPORT void Java_com_google_vr_ndk_base_GvrApi_nativePause(
    JNIEnv* env,
    jobject jcaller,
    jlong nativeGvrContext);

JNI_GENERATOR_EXPORT void Java_com_google_vr_ndk_base_GvrApi_nativeResume(
    JNIEnv* env,
    jobject jcaller,
    jlong nativeGvrContext);

JNI_GENERATOR_EXPORT void
Java_com_google_vr_ndk_base_GvrApi_nativeReleaseGvrContext(
    JNIEnv* env,
    jobject jcaller,
    jlong nativeGvrContext);

JNI_GENERATOR_EXPORT void Java_com_google_vr_ndk_base_GvrApi_nativeInitializeGl(
    JNIEnv* env,
    jobject jcaller,
    jlong nativeGvrContext);

JNI_GENERATOR_EXPORT void
Java_com_google_vr_ndk_base_GvrApi_nativeOnSurfaceCreatedReprojectionThread(
    JNIEnv* env,
    jobject jcaller,
    jlong nativeGvrContext);

JNI_GENERATOR_EXPORT void
Java_com_google_vr_ndk_base_GvrApi_nativeOnSurfaceChangedReprojectionThread(
    JNIEnv* env,
    jobject jcaller,
    jlong nativeGvrContext);

JNI_GENERATOR_EXPORT void
Java_com_google_vr_ndk_base_GvrApi_nativeGetRecommendedBufferViewports(
    JNIEnv* env,
    jobject jcaller,
    jlong nativeGvrContext,
    jlong nativeBufferViewportList);

JNI_GENERATOR_EXPORT void
Java_com_google_vr_ndk_base_GvrApi_nativeGetScreenBufferViewports(
    JNIEnv* env,
    jobject jcaller,
    jlong nativeGvrContext,
    jlong nativeBufferViewportList);

JNI_GENERATOR_EXPORT void
Java_com_google_vr_ndk_base_GvrApi_nativeGetMaximumEffectiveRenderTargetSize(
    JNIEnv* env,
    jobject jcaller,
    jlong nativeGvrContext,
    jobject size);

JNI_GENERATOR_EXPORT void
Java_com_google_vr_ndk_base_GvrApi_nativeGetScreenTargetSize(
    JNIEnv* env,
    jobject jcaller,
    jlong nativeGvrContext,
    jobject size);

JNI_GENERATOR_EXPORT void
Java_com_google_vr_ndk_base_GvrApi_nativeDistortToScreen(
    JNIEnv* env,
    jobject jcaller,
    jlong nativeGvrContext,
    jint textureId,
    jlong nativeBufferViewportList,
    jfloatArray headSpaceFromStartSpace,
    jlong timeNs);

JNI_GENERATOR_EXPORT void
Java_com_google_vr_ndk_base_GvrApi_nativeSetDefaultFramebufferActive(
    JNIEnv* env,
    jobject jcaller,
    jlong nativeGvrContext);

JNI_GENERATOR_EXPORT jobject
Java_com_google_vr_ndk_base_GvrApi_nativeRenderReprojectionThread(
    JNIEnv* env,
    jobject jcaller,
    jlong nativeGvrContext);

JNI_GENERATOR_EXPORT void
Java_com_google_vr_ndk_base_GvrApi_nativeOnPauseReprojectionThread(
    JNIEnv* env,
    jobject jcaller,
    jlong nativeGvrContext);

JNI_GENERATOR_EXPORT void
Java_com_google_vr_ndk_base_GvrApi_nativeGetHeadSpaceFromStartSpaceRotation(
    JNIEnv* env,
    jobject jcaller,
    jlong nativeGvrContext,
    jfloatArray outRotation,
    jlong timeNs);

JNI_GENERATOR_EXPORT void
Java_com_google_vr_ndk_base_GvrApi_nativeGetHeadSpaceFromStartSpaceTransform(
    JNIEnv* env,
    jobject jcaller,
    jlong nativeGvrContext,
    jfloatArray outTransform,
    jlong timeNs);

JNI_GENERATOR_EXPORT void
Java_com_google_vr_ndk_base_GvrApi_nativeSetIgnoreManualPauseResumeTracker(
    JNIEnv* env,
    jobject jcaller,
    jlong nativeGvrContext,
    jboolean shouldIgnore);

JNI_GENERATOR_EXPORT void
Java_com_google_vr_ndk_base_GvrApi_nativePauseTracking(JNIEnv* env,
                                                       jobject jcaller,
                                                       jlong nativeGvrContext);

JNI_GENERATOR_EXPORT jbyteArray
Java_com_google_vr_ndk_base_GvrApi_nativePauseTrackingGetState(
    JNIEnv* env,
    jobject jcaller,
    jlong nativeGvrContext);

JNI_GENERATOR_EXPORT void
Java_com_google_vr_ndk_base_GvrApi_nativeResumeTracking(JNIEnv* env,
                                                        jobject jcaller,
                                                        jlong nativeGvrContext);

JNI_GENERATOR_EXPORT void
Java_com_google_vr_ndk_base_GvrApi_nativeResumeTrackingSetState(
    JNIEnv* env,
    jobject jcaller,
    jlong nativeGvrContext,
    jbyteArray trackerStateBytes);

JNI_GENERATOR_EXPORT void
Java_com_google_vr_ndk_base_GvrApi_nativeResetTracking(JNIEnv* env,
                                                       jobject jcaller,
                                                       jlong nativeGvrContext);

JNI_GENERATOR_EXPORT void
Java_com_google_vr_ndk_base_GvrApi_nativeRecenterTracking(
    JNIEnv* env,
    jobject jcaller,
    jlong nativeGvrContext);

JNI_GENERATOR_EXPORT void
Java_com_google_vr_ndk_base_GvrApi_nativeGetEyeFromHeadMatrix(
    JNIEnv* env,
    jobject jcaller,
    jlong nativeGvrContext,
    jint eye,
    jfloatArray out);

JNI_GENERATOR_EXPORT jintArray
Java_com_google_vr_ndk_base_GvrApi_nativeGetWindowBounds(
    JNIEnv* env,
    jobject jcaller,
    jlong nativeGvrContext);

JNI_GENERATOR_EXPORT jfloatArray
Java_com_google_vr_ndk_base_GvrApi_nativeComputeDistortedPoint(
    JNIEnv* env,
    jobject jcaller,
    jlong nativeGvrContext,
    jint eyeType,
    jfloatArray uvIn);

JNI_GENERATOR_EXPORT jboolean
Java_com_google_vr_ndk_base_GvrApi_nativeSetDefaultViewerProfile(
    JNIEnv* env,
    jobject jcaller,
    jlong nativeGvrContext,
    jstring viewerProfileUri);

JNI_GENERATOR_EXPORT jstring
Java_com_google_vr_ndk_base_GvrApi_nativeGetViewerVendor(
    JNIEnv* env,
    jobject jcaller,
    jlong nativeGvrContext);

JNI_GENERATOR_EXPORT jstring
Java_com_google_vr_ndk_base_GvrApi_nativeGetViewerModel(JNIEnv* env,
                                                        jobject jcaller,
                                                        jlong nativeGvrContext);

JNI_GENERATOR_EXPORT jint
Java_com_google_vr_ndk_base_GvrApi_nativeGetViewerType(JNIEnv* env,
                                                       jobject jcaller,
                                                       jlong nativeGvrContext);

JNI_GENERATOR_EXPORT jboolean
Java_com_google_vr_ndk_base_GvrApi_nativeSetAsyncReprojectionEnabled(
    JNIEnv* env,
    jobject jcaller,
    jlong nativeGvrContext,
    jboolean enabled);

JNI_GENERATOR_EXPORT jboolean
Java_com_google_vr_ndk_base_GvrApi_nativeGetAsyncReprojectionEnabled(
    JNIEnv* env,
    jobject jcaller,
    jlong nativeGvrContext);

JNI_GENERATOR_EXPORT jboolean
Java_com_google_vr_ndk_base_GvrApi_nativeIsFeatureSupported(
    JNIEnv* env,
    jobject jcaller,
    jlong nativeGvrContext,
    jint feature);

JNI_GENERATOR_EXPORT void
Java_com_google_vr_ndk_base_GvrApi_nativeReconnectSensors(
    JNIEnv* env,
    jobject jcaller,
    jlong nativeGvrContext);

JNI_GENERATOR_EXPORT void
Java_com_google_vr_ndk_base_GvrApi_nativeSetIdleListener(JNIEnv* env,
                                                         jobject jcaller,
                                                         jlong nativeGvrContext,
                                                         jobject idleListener);

JNI_GENERATOR_EXPORT jboolean
Java_com_google_vr_ndk_base_GvrApi_nativeSetViewerParams(
    JNIEnv* env,
    jobject jcaller,
    jlong nativeGvrContext,
    jbyteArray serializedViewerParams);

JNI_GENERATOR_EXPORT void
Java_com_google_vr_ndk_base_GvrApi_nativeSetDisplayMetrics(
    JNIEnv* env,
    jobject jcaller,
    jlong nativeGvrContext,
    jint widthPixels,
    jint heightPixels,
    jfloat xDpi,
    jfloat yDpi);

JNI_GENERATOR_EXPORT jfloat
Java_com_google_vr_ndk_base_GvrApi_nativeGetBorderSizeMeters(
    JNIEnv* env,
    jobject jcaller,
    jlong nativeGvrContext);

JNI_GENERATOR_EXPORT void
Java_com_google_vr_ndk_base_GvrApi_nativeSetSurfaceSize(
    JNIEnv* env,
    jobject jcaller,
    jlong nativeGvrContext,
    jint surfaceWidthPixels,
    jint surfaceHeightPixels);

JNI_GENERATOR_EXPORT void
Java_com_google_vr_ndk_base_GvrApi_nativeSetLensOffset(JNIEnv* env,
                                                       jobject jcaller,
                                                       jlong nativeGvrContext,
                                                       jfloat x,
                                                       jfloat y,
                                                       jfloat rotation);

JNI_GENERATOR_EXPORT void
Java_com_google_vr_ndk_base_GvrApi_nativeDumpDebugData(JNIEnv* env,
                                                       jobject jcaller,
                                                       jlong nativeGvrContext);

JNI_GENERATOR_EXPORT jboolean
Java_com_google_vr_ndk_base_GvrApi_nativeUsingVrDisplayService(
    JNIEnv* env,
    jobject jcaller,
    jlong nativeGvrContext);

JNI_GENERATOR_EXPORT jlong
Java_com_google_vr_ndk_base_GvrApi_nativeCreateEvent(JNIEnv* env, jclass clazz);

JNI_GENERATOR_EXPORT jlong
Java_com_google_vr_ndk_base_GvrApi_nativeCreateValue(JNIEnv* env, jclass clazz);

JNI_GENERATOR_EXPORT void Java_com_google_vr_ndk_base_GvrApi_nativeDestroyEvent(
    JNIEnv* env,
    jclass clazz,
    jlong native_object);

JNI_GENERATOR_EXPORT void Java_com_google_vr_ndk_base_GvrApi_nativeDestroyValue(
    JNIEnv* env,
    jclass clazz,
    jlong native_object);

JNI_GENERATOR_EXPORT jlong
Java_com_google_vr_ndk_base_GvrApi_nativeGetCurrentProperties(
    JNIEnv* env,
    jobject object,
    jlong native_object);

JNI_GENERATOR_EXPORT jlong
Java_com_google_vr_ndk_base_GvrApi_nativeGetEventFlags(JNIEnv* env,
                                                       jclass clazz,
                                                       jlong native_object);

JNI_GENERATOR_EXPORT jlong
Java_com_google_vr_ndk_base_GvrApi_nativeGetEventTimestamp(JNIEnv* env,
                                                           jclass clazz,
                                                           jlong native_object);

JNI_GENERATOR_EXPORT jint
Java_com_google_vr_ndk_base_GvrApi_nativeGetEventType(JNIEnv* env,
                                                      jclass clazz,
                                                      jlong native_object);

JNI_GENERATOR_EXPORT jboolean
Java_com_google_vr_ndk_base_GvrApi_nativeGetProperty(JNIEnv* env,
                                                     jclass clazz,
                                                     jlong native_properties,
                                                     jint property_key,
                                                     jlong native_value);

JNI_GENERATOR_EXPORT jlong
Java_com_google_vr_ndk_base_GvrApi_nativeGetRecenterEventFlags(
    JNIEnv* env,
    jclass clazz,
    jlong native_object);

JNI_GENERATOR_EXPORT void
Java_com_google_vr_ndk_base_GvrApi_nativeGetRecenterEventStartSpaceFromTrackingSpaceTransform(
    JNIEnv* env,
    jclass clazz,
    jlong native_object,
    jfloatArray rotation_out_array);

JNI_GENERATOR_EXPORT jint
Java_com_google_vr_ndk_base_GvrApi_nativeGetRecenterEventType(
    JNIEnv* env,
    jclass clazz,
    jlong native_object);

JNI_GENERATOR_EXPORT jboolean
Java_com_google_vr_ndk_base_GvrApi_nativePollEvent(JNIEnv* env,
                                                   jobject object,
                                                   jlong native_object,
                                                   jlong event_out);

JNI_GENERATOR_EXPORT jlong
Java_com_google_vr_ndk_base_GvrApi_nativeValueAsFlags(JNIEnv* env,
                                                      jclass clazz,
                                                      jlong native_object);

JNI_GENERATOR_EXPORT jfloat
Java_com_google_vr_ndk_base_GvrApi_nativeValueAsFloat(JNIEnv* env,
                                                      jclass clazz,
                                                      jlong native_object);

JNI_GENERATOR_EXPORT jint
Java_com_google_vr_ndk_base_GvrApi_nativeValueAsInt(JNIEnv* env,
                                                    jclass clazz,
                                                    jlong native_object);

JNI_GENERATOR_EXPORT void Java_com_google_vr_ndk_base_GvrApi_nativeValueAsMat4f(
    JNIEnv* env,
    jclass clazz,
    jlong native_object,
    jfloatArray mat4_out_array);

JNI_GENERATOR_EXPORT jlong
Java_com_google_vr_ndk_base_GvrApi_nativeValueGetFlags(JNIEnv* env,
                                                       jclass clazz,
                                                       jlong native_object);

// Step 3: RegisterNatives.

static const JNINativeMethod kMethodsGvrApi[] = {
    {"nativeBufferViewportListCreate",
     "("
     "J"
     ")"
     "J",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeBufferViewportListCreate)},
    {"nativeBufferViewportListDestroy",
     "("
     "J"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeBufferViewportListDestroy)},
    {"nativeBufferViewportListGetSize",
     "("
     "J"
     ")"
     "I",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeBufferViewportListGetSize)},
    {"nativeBufferViewportListGetItem",
     "("
     "J"
     "I"
     "J"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeBufferViewportListGetItem)},
    {"nativeBufferViewportListSetItem",
     "("
     "J"
     "I"
     "J"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeBufferViewportListSetItem)},
    {"nativeBufferViewportCreate",
     "("
     "J"
     ")"
     "J",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeBufferViewportCreate)},
    {"nativeBufferViewportDestroy",
     "("
     "J"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeBufferViewportDestroy)},
    {"nativeBufferViewportGetSourceUv",
     "("
     "J"
     "Landroid/graphics/RectF;"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeBufferViewportGetSourceUv)},
    {"nativeBufferViewportSetSourceUv",
     "("
     "J"
     "F"
     "F"
     "F"
     "F"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeBufferViewportSetSourceUv)},
    {"nativeBufferViewportGetSourceFov",
     "("
     "J"
     "Landroid/graphics/RectF;"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeBufferViewportGetSourceFov)},
    {"nativeBufferViewportSetSourceFov",
     "("
     "J"
     "F"
     "F"
     "F"
     "F"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeBufferViewportSetSourceFov)},
    {"nativeBufferViewportGetTransform",
     "("
     "J"
     "[F"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeBufferViewportGetTransform)},
    {"nativeBufferViewportSetTransform",
     "("
     "J"
     "[F"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeBufferViewportSetTransform)},
    {"nativeBufferViewportEqual",
     "("
     "J"
     "J"
     ")"
     "Z",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeBufferViewportEqual)},
    {"nativeBufferViewportGetTargetEye",
     "("
     "J"
     ")"
     "I",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeBufferViewportGetTargetEye)},
    {"nativeBufferViewportSetTargetEye",
     "("
     "J"
     "I"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeBufferViewportSetTargetEye)},
    {"nativeBufferViewportGetSourceBufferIndex",
     "("
     "J"
     ")"
     "I",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeBufferViewportGetSourceBufferIndex)},
    {"nativeBufferViewportSetSourceBufferIndex",
     "("
     "J"
     "I"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeBufferViewportSetSourceBufferIndex)},
    {"nativeBufferViewportGetExternalSurfaceId",
     "("
     "J"
     ")"
     "I",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeBufferViewportGetExternalSurfaceId)},
    {"nativeBufferViewportSetExternalSurfaceId",
     "("
     "J"
     "I"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeBufferViewportSetExternalSurfaceId)},
    {"nativeBufferViewportSetExternalSurface",
     "("
     "J"
     "J"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeBufferViewportSetExternalSurface)},
    {"nativeBufferViewportGetReprojection",
     "("
     "J"
     ")"
     "I",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeBufferViewportGetReprojection)},
    {"nativeBufferViewportSetReprojection",
     "("
     "J"
     "I"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeBufferViewportSetReprojection)},
    {"nativeBufferViewportSetSourceLayer",
     "("
     "J"
     "I"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeBufferViewportSetSourceLayer)},
    {"nativeBufferSpecCreate",
     "("
     "J"
     ")"
     "J",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeBufferSpecCreate)},
    {"nativeBufferSpecDestroy",
     "("
     "J"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeBufferSpecDestroy)},
    {"nativeBufferSpecGetSize",
     "("
     "J"
     "Landroid/graphics/Point;"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeBufferSpecGetSize)},
    {"nativeBufferSpecSetSize",
     "("
     "J"
     "I"
     "I"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeBufferSpecSetSize)},
    {"nativeBufferSpecSetColorFormat",
     "("
     "J"
     "I"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeBufferSpecSetColorFormat)},
    {"nativeBufferSpecSetDepthStencilFormat",
     "("
     "J"
     "I"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeBufferSpecSetDepthStencilFormat)},
    {"nativeBufferSpecSetMultiviewLayers",
     "("
     "J"
     "I"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeBufferSpecSetMultiviewLayers)},
    {"nativeBufferSpecGetSamples",
     "("
     "J"
     ")"
     "I",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeBufferSpecGetSamples)},
    {"nativeBufferSpecSetSamples",
     "("
     "J"
     "I"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeBufferSpecSetSamples)},
    {"nativeExternalSurfaceCreateWithListeners",
     "("
     "J"
     "Ljava/lang/Runnable;"
     "Ljava/lang/Runnable;"
     "Landroid/os/Handler;"
     ")"
     "J",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeExternalSurfaceCreateWithListeners)},
    {"nativeExternalSurfaceDestroy",
     "("
     "J"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeExternalSurfaceDestroy)},
    {"nativeExternalSurfaceGetId",
     "("
     "J"
     ")"
     "I",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeExternalSurfaceGetId)},
    {"nativeExternalSurfaceGetSurface",
     "("
     "J"
     ")"
     "Landroid/view/Surface;",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeExternalSurfaceGetSurface)},
    {"nativeSwapChainCreate",
     "("
     "J"
     "[J"
     ")"
     "J",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeSwapChainCreate)},
    {"nativeSwapChainDestroy",
     "("
     "J"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeSwapChainDestroy)},
    {"nativeSwapChainGetBufferCount",
     "("
     "J"
     ")"
     "I",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeSwapChainGetBufferCount)},
    {"nativeSwapChainGetBufferSize",
     "("
     "J"
     "I"
     "Landroid/graphics/Point;"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeSwapChainGetBufferSize)},
    {"nativeSwapChainResizeBuffer",
     "("
     "J"
     "I"
     "I"
     "I"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeSwapChainResizeBuffer)},
    {"nativeSwapChainAcquireFrame",
     "("
     "J"
     ")"
     "J",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeSwapChainAcquireFrame)},
    {"nativeFrameBindBuffer",
     "("
     "J"
     "I"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeFrameBindBuffer)},
    {"nativeFrameUnbind",
     "("
     "J"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeFrameUnbind)},
    {"nativeFrameGetFramebufferObject",
     "("
     "J"
     "I"
     ")"
     "I",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeFrameGetFramebufferObject)},
    {"nativeFrameGetBufferSize",
     "("
     "J"
     "I"
     "Landroid/graphics/Point;"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeFrameGetBufferSize)},
    {"nativeFrameSubmit",
     "("
     "J"
     "J"
     "[F"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeFrameSubmit)},
    {"nativeUsingDynamicLibrary",
     "("
     ")"
     "Z",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeUsingDynamicLibrary)},
    {"nativeUsingShimLibrary",
     "("
     ")"
     "Z",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeUsingShimLibrary)},
    {"nativeSetApplicationState",
     "("
     "Ljava/lang/ClassLoader;"
     "Landroid/content/Context;"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeSetApplicationState)},
    {"nativeSetDynamicLibraryLoadingEnabled",
     "("
     "Z"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeSetDynamicLibraryLoadingEnabled)},
    {"nativeCreate",
     "("
     "Ljava/lang/ClassLoader;"
     "Landroid/content/Context;"
     "J"
     "I"
     "I"
     "F"
     "F"
     "Lcom/google/vr/ndk/base/GvrApi$PoseTracker;"
     ")"
     "J",
     reinterpret_cast<void*>(Java_com_google_vr_ndk_base_GvrApi_nativeCreate)},
    {"nativeRequestContextSharing",
     "("
     "J"
     "Lcom/google/vr/cardboard/EglReadyListener;"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeRequestContextSharing)},
    {"nativeGetError",
     "("
     "J"
     ")"
     "I",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeGetError)},
    {"nativeClearError",
     "("
     "J"
     ")"
     "I",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeClearError)},
    {"nativeGetErrorString",
     "("
     "I"
     ")"
     "Ljava/lang/String;",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeGetErrorString)},
    {"nativeGetUserPrefs",
     "("
     "J"
     ")"
     "J",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeGetUserPrefs)},
    {"nativeUserPrefsGetControllerHandedness",
     "("
     "J"
     ")"
     "I",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeUserPrefsGetControllerHandedness)},
    {"nativePause",
     "("
     "J"
     ")"
     "V",
     reinterpret_cast<void*>(Java_com_google_vr_ndk_base_GvrApi_nativePause)},
    {"nativeResume",
     "("
     "J"
     ")"
     "V",
     reinterpret_cast<void*>(Java_com_google_vr_ndk_base_GvrApi_nativeResume)},
    {"nativeReleaseGvrContext",
     "("
     "J"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeReleaseGvrContext)},
    {"nativeInitializeGl",
     "("
     "J"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeInitializeGl)},
    {"nativeOnSurfaceCreatedReprojectionThread",
     "("
     "J"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeOnSurfaceCreatedReprojectionThread)},
    {"nativeOnSurfaceChangedReprojectionThread",
     "("
     "J"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeOnSurfaceChangedReprojectionThread)},
    {"nativeGetRecommendedBufferViewports",
     "("
     "J"
     "J"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeGetRecommendedBufferViewports)},
    {"nativeGetScreenBufferViewports",
     "("
     "J"
     "J"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeGetScreenBufferViewports)},
    {"nativeGetMaximumEffectiveRenderTargetSize",
     "("
     "J"
     "Landroid/graphics/Point;"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeGetMaximumEffectiveRenderTargetSize)},
    {"nativeGetScreenTargetSize",
     "("
     "J"
     "Landroid/graphics/Point;"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeGetScreenTargetSize)},
    {"nativeDistortToScreen",
     "("
     "J"
     "I"
     "J"
     "[F"
     "J"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeDistortToScreen)},
    {"nativeSetDefaultFramebufferActive",
     "("
     "J"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeSetDefaultFramebufferActive)},
    {"nativeRenderReprojectionThread",
     "("
     "J"
     ")"
     "Landroid/graphics/Point;",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeRenderReprojectionThread)},
    {"nativeOnPauseReprojectionThread",
     "("
     "J"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeOnPauseReprojectionThread)},
    {"nativeGetHeadSpaceFromStartSpaceRotation",
     "("
     "J"
     "[F"
     "J"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeGetHeadSpaceFromStartSpaceRotation)},
    {"nativeGetHeadSpaceFromStartSpaceTransform",
     "("
     "J"
     "[F"
     "J"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeGetHeadSpaceFromStartSpaceTransform)},
    {"nativeSetIgnoreManualPauseResumeTracker",
     "("
     "J"
     "Z"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeSetIgnoreManualPauseResumeTracker)},
    {"nativePauseTracking",
     "("
     "J"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativePauseTracking)},
    {"nativePauseTrackingGetState",
     "("
     "J"
     ")"
     "[B",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativePauseTrackingGetState)},
    {"nativeResumeTracking",
     "("
     "J"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeResumeTracking)},
    {"nativeResumeTrackingSetState",
     "("
     "J"
     "[B"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeResumeTrackingSetState)},
    {"nativeResetTracking",
     "("
     "J"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeResetTracking)},
    {"nativeRecenterTracking",
     "("
     "J"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeRecenterTracking)},
    {"nativeGetEyeFromHeadMatrix",
     "("
     "J"
     "I"
     "[F"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeGetEyeFromHeadMatrix)},
    {"nativeGetWindowBounds",
     "("
     "J"
     ")"
     "[I",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeGetWindowBounds)},
    {"nativeComputeDistortedPoint",
     "("
     "J"
     "I"
     "[F"
     ")"
     "[F",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeComputeDistortedPoint)},
    {"nativeSetDefaultViewerProfile",
     "("
     "J"
     "Ljava/lang/String;"
     ")"
     "Z",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeSetDefaultViewerProfile)},
    {"nativeGetViewerVendor",
     "("
     "J"
     ")"
     "Ljava/lang/String;",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeGetViewerVendor)},
    {"nativeGetViewerModel",
     "("
     "J"
     ")"
     "Ljava/lang/String;",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeGetViewerModel)},
    {"nativeGetViewerType",
     "("
     "J"
     ")"
     "I",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeGetViewerType)},
    {"nativeSetAsyncReprojectionEnabled",
     "("
     "J"
     "Z"
     ")"
     "Z",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeSetAsyncReprojectionEnabled)},
    {"nativeGetAsyncReprojectionEnabled",
     "("
     "J"
     ")"
     "Z",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeGetAsyncReprojectionEnabled)},
    {"nativeIsFeatureSupported",
     "("
     "J"
     "I"
     ")"
     "Z",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeIsFeatureSupported)},
    {"nativeReconnectSensors",
     "("
     "J"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeReconnectSensors)},
    {"nativeSetIdleListener",
     "("
     "J"
     "Lcom/google/vr/ndk/base/GvrApi$IdleListener;"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeSetIdleListener)},
    {"nativeSetViewerParams",
     "("
     "J"
     "[B"
     ")"
     "Z",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeSetViewerParams)},
    {"nativeSetDisplayMetrics",
     "("
     "J"
     "I"
     "I"
     "F"
     "F"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeSetDisplayMetrics)},
    {"nativeGetBorderSizeMeters",
     "("
     "J"
     ")"
     "F",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeGetBorderSizeMeters)},
    {"nativeSetSurfaceSize",
     "("
     "J"
     "I"
     "I"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeSetSurfaceSize)},
    {"nativeSetLensOffset",
     "("
     "J"
     "F"
     "F"
     "F"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeSetLensOffset)},
    {"nativeDumpDebugData",
     "("
     "J"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeDumpDebugData)},
    {"nativeUsingVrDisplayService",
     "("
     "J"
     ")"
     "Z",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeUsingVrDisplayService)},
    {"nativeCreateEvent",
     "("
     ")"
     "J",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeCreateEvent)},
    {"nativeCreateValue",
     "("
     ")"
     "J",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeCreateValue)},
    {"nativeDestroyEvent",
     "("
     "J"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeDestroyEvent)},
    {"nativeDestroyValue",
     "("
     "J"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeDestroyValue)},
    {"nativeGetCurrentProperties",
     "("
     "J"
     ")"
     "J",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeGetCurrentProperties)},
    {"nativeGetEventFlags",
     "("
     "J"
     ")"
     "J",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeGetEventFlags)},
    {"nativeGetEventTimestamp",
     "("
     "J"
     ")"
     "J",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeGetEventTimestamp)},
    {"nativeGetEventType",
     "("
     "J"
     ")"
     "I",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeGetEventType)},
    {"nativeGetProperty",
     "("
     "J"
     "I"
     "J"
     ")"
     "Z",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeGetProperty)},
    {"nativeGetRecenterEventFlags",
     "("
     "J"
     ")"
     "J",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeGetRecenterEventFlags)},
    {"nativeGetRecenterEventStartSpaceFromTrackingSpaceTransform",
     "("
     "J"
     "[F"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeGetRecenterEventStartSpaceFromTrackingSpaceTransform)},
    {"nativeGetRecenterEventType",
     "("
     "J"
     ")"
     "I",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeGetRecenterEventType)},
    {"nativePollEvent",
     "("
     "J"
     "J"
     ")"
     "Z",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativePollEvent)},
    {"nativeValueAsFlags",
     "("
     "J"
     ")"
     "J",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeValueAsFlags)},
    {"nativeValueAsFloat",
     "("
     "J"
     ")"
     "F",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeValueAsFloat)},
    {"nativeValueAsInt",
     "("
     "J"
     ")"
     "I",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeValueAsInt)},
    {"nativeValueAsMat4f",
     "("
     "J"
     "[F"
     ")"
     "V",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeValueAsMat4f)},
    {"nativeValueGetFlags",
     "("
     "J"
     ")"
     "J",
     reinterpret_cast<void*>(
         Java_com_google_vr_ndk_base_GvrApi_nativeValueGetFlags)},
};

static bool RegisterNativesImpl(JNIEnv* env) {
  if (base::android::IsSelectiveJniRegistrationEnabled(env))
    return true;

  const int kMethodsGvrApiSize = arraysize(kMethodsGvrApi);

  if (env->RegisterNatives(GvrApi_clazz(env), kMethodsGvrApi,
                           kMethodsGvrApiSize) < 0) {
    jni_generator::HandleRegistrationError(env, GvrApi_clazz(env), __FILE__);
    return false;
  }

  return true;
}

static bool RegisterGvrApiNatives(JNIEnv* env) {
  return RegisterNativesImpl(env);
}

}  // namespace GvrApi

#endif  // com_google_vr_ndk_base_GvrApi_JNI
