/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.phonenumbers;

import com.google.i18n.phonenumbers.MetadataLoader;
import com.google.i18n.phonenumbers.MetadataManager;
import com.google.i18n.phonenumbers.MetadataSource;
import com.google.i18n.phonenumbers.nano.Phonemetadata;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

final class SingleFileMetadataSourceImpl
implements MetadataSource {
    private static final Logger logger = Logger.getLogger(SingleFileMetadataSourceImpl.class.getName());
    private static final String META_DATA_FILE_NAME = "/com/google/i18n/phonenumbers/data/SingleFilePhoneNumberMetadataProto";
    private final Map<String, Phonemetadata.PhoneMetadata> regionToMetadataMap = Collections.synchronizedMap(new HashMap());
    private final Map<Integer, Phonemetadata.PhoneMetadata> countryCodeToNonGeographicalMetadataMap = Collections.synchronizedMap(new HashMap());
    private final String fileName;
    private final MetadataLoader metadataLoader;

    public SingleFileMetadataSourceImpl(String fileName, MetadataLoader metadataLoader) {
        this.fileName = fileName;
        this.metadataLoader = metadataLoader;
    }

    public SingleFileMetadataSourceImpl(MetadataLoader metadataLoader) {
        this(META_DATA_FILE_NAME, metadataLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Phonemetadata.PhoneMetadata getMetadataForRegion(String regionCode) {
        Map<String, Phonemetadata.PhoneMetadata> map = this.regionToMetadataMap;
        synchronized (map) {
            if (!this.regionToMetadataMap.containsKey(regionCode)) {
                this.loadMetadataFromFile();
            }
        }
        return this.regionToMetadataMap.get(regionCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Phonemetadata.PhoneMetadata getMetadataForNonGeographicalRegion(int countryCallingCode) {
        Map<Integer, Phonemetadata.PhoneMetadata> map = this.countryCodeToNonGeographicalMetadataMap;
        synchronized (map) {
            if (!this.countryCodeToNonGeographicalMetadataMap.containsKey(countryCallingCode)) {
                this.loadMetadataFromFile();
            }
        }
        return this.countryCodeToNonGeographicalMetadataMap.get(countryCallingCode);
    }

    void loadMetadataFromFile() {
        InputStream source = this.metadataLoader.loadMetadata(this.fileName);
        if (source == null) {
            logger.log(Level.SEVERE, "missing metadata: " + this.fileName);
            throw new IllegalStateException("missing metadata: " + this.fileName);
        }
        try {
            Phonemetadata.PhoneMetadataCollection metadataCollection = SingleFileMetadataSourceImpl.loadMetadataAndCloseInput(new ObjectInputStream(source));
            Phonemetadata.PhoneMetadata[] metadataList = metadataCollection.metadata;
            if (metadataList.length == 0) {
                logger.log(Level.SEVERE, "empty metadata: " + this.fileName);
                throw new IllegalStateException("empty metadata: " + this.fileName);
            }
            for (Phonemetadata.PhoneMetadata metadata : metadataList) {
                String regionCode = metadata.id;
                int countryCallingCode = metadata.countryCode;
                boolean isNonGeoRegion = "001".equals(regionCode);
                if (isNonGeoRegion) {
                    this.countryCodeToNonGeographicalMetadataMap.put(countryCallingCode, metadata);
                    continue;
                }
                this.regionToMetadataMap.put(regionCode, metadata);
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "cannot load/parse metadata: " + this.fileName, e);
            throw new RuntimeException("cannot load/parse metadata: " + this.fileName, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Phonemetadata.PhoneMetadataCollection loadMetadataAndCloseInput(ObjectInputStream source) {
        int SINGLE_FILE_BUFFER_SIZE = 262144;
        Phonemetadata.PhoneMetadataCollection metadataCollection = new Phonemetadata.PhoneMetadataCollection();
        try {
            metadataCollection.mergeFrom(MetadataManager.convertStreamToByteBuffer(source, 262144));
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "error reading input (ignored)", e);
        }
        finally {
            try {
                source.close();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "error closing input stream (ignored)", e);
            }
        }
        return metadataCollection;
    }
}

