Polymer({
    is: 'reverse-ripple-animation',

    behaviors: [
      Polymer.NeonSharedElementAnimationBehavior
    ],

    configure: function(config) {
      var shared = this.findSharedElements(config);
      if (!shared) {
        return null;
      }

      var translateX, translateY;
      var fromRect = shared.from.getBoundingClientRect();
      if (config.gesture) {
        translateX = config.gesture.x - (fromRect.left + (fromRect.width / 2));
        translateY = config.gesture.y - (fromRect.top + (fromRect.height / 2));
      } else {
        var toRect = shared.to.getBoundingClientRect();
        translateX = (toRect.left + (toRect.width / 2)) - (fromRect.left + (fromRect.width / 2));
        translateY = (toRect.top + (toRect.height / 2)) - (fromRect.top + (fromRect.height / 2));
      }
      var translate = 'translate(' + translateX + 'px,' + translateY + 'px)';

      var size = Math.max(fromRect.width + Math.abs(translateX) * 2, fromRect.height + Math.abs(translateY) * 2);
      var diameter = Math.sqrt(2 * size * size);
      var scaleX = diameter / fromRect.width;
      var scaleY = diameter / fromRect.height;
      var scale = 'scale(' + scaleX + ',' + scaleY + ')';

      this._effect = new KeyframeEffect(shared.from, [
        {'transform': translate + ' ' + scale},
        {'transform': translate + ' scale(0)'}
      ], this.timingFromConfig(config));

      this.setPrefixedProperty(shared.from, 'transformOrigin', '50% 50%');
      shared.from.style.borderRadius = '50%';

      return this._effect;
    },

    complete: function() {
      if (this.sharedElements) {
        this.setPrefixedProperty(this.sharedElements.from, 'transformOrigin', '');
        this.sharedElements.from.style.borderRadius = '';
      }
    }
  });