/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.haha.guava.collect;

import com.squareup.haha.guava.base.Ascii;
import com.squareup.haha.guava.collect.Iterators;
import com.squareup.haha.guava.collect.Multiset;
import com.squareup.haha.guava.collect.Multisets;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nullable;

abstract class AbstractMultiset<E>
extends AbstractCollection<E>
implements Multiset<E> {
    private transient Set<E> elementSet;
    private transient Set<Multiset.Entry<E>> entrySet;

    @Override
    public int size() {
        return Multisets.sizeImpl(this);
    }

    @Override
    public boolean isEmpty() {
        return this.entrySet().isEmpty();
    }

    @Override
    public boolean contains(@Nullable Object element) {
        return this.count(element) > 0;
    }

    @Override
    public Iterator<E> iterator() {
        return Multisets.iteratorImpl(this);
    }

    @Override
    public int count(@Nullable Object element) {
        for (Multiset.Entry<E> entry : this.entrySet()) {
            if (!Ascii.equal(entry.getElement(), element)) continue;
            return entry.getCount();
        }
        return 0;
    }

    @Override
    public boolean add(@Nullable E element) {
        this.add(element, 1);
        return true;
    }

    @Override
    public int add(@Nullable E element, int occurrences) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(@Nullable Object element) {
        return this.remove(element, 1) > 0;
    }

    @Override
    public int remove(@Nullable Object element, int occurrences) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int setCount(@Nullable E element, int count) {
        return Multisets.setCountImpl(this, element, count);
    }

    @Override
    public final boolean setCount(@Nullable E element, int oldCount, int newCount) {
        return Multisets.setCountImpl(this, element, oldCount, newCount);
    }

    @Override
    public boolean addAll(Collection<? extends E> elementsToAdd) {
        return Multisets.addAllImpl(this, elementsToAdd);
    }

    @Override
    public boolean removeAll(Collection<?> elementsToRemove) {
        return Multisets.removeAllImpl(this, elementsToRemove);
    }

    @Override
    public boolean retainAll(Collection<?> elementsToRetain) {
        return Multisets.retainAllImpl(this, elementsToRetain);
    }

    @Override
    public void clear() {
        Iterators.clear(this.entryIterator());
    }

    @Override
    public final Set<E> elementSet() {
        ElementSet result = this.elementSet;
        if (result == null) {
            AbstractMultiset abstractMultiset = this;
            this.elementSet = result = new ElementSet(abstractMultiset);
        }
        return result;
    }

    abstract Iterator<Multiset.Entry<E>> entryIterator();

    abstract int distinctElements();

    @Override
    public Set<Multiset.Entry<E>> entrySet() {
        Set<Multiset.Entry<E>> result = this.entrySet;
        if (result == null) {
            AbstractMultiset abstractMultiset = this;
            this.entrySet = new EntrySet(abstractMultiset);
            return this.entrySet;
        }
        return result;
    }

    @Override
    public boolean equals(@Nullable Object object) {
        return Multisets.equalsImpl(this, object);
    }

    @Override
    public int hashCode() {
        return this.entrySet().hashCode();
    }

    @Override
    public String toString() {
        return this.entrySet().toString();
    }

    final class EntrySet
    extends Multisets.EntrySet<E> {
        private /* synthetic */ AbstractMultiset this$0;

        EntrySet(AbstractMultiset abstractMultiset) {
            this.this$0 = abstractMultiset;
        }

        @Override
        final Multiset<E> multiset() {
            return this.this$0;
        }

        @Override
        public final Iterator<Multiset.Entry<E>> iterator() {
            return this.this$0.entryIterator();
        }

        @Override
        public final int size() {
            return this.this$0.distinctElements();
        }
    }

    final class ElementSet
    extends Multisets.ElementSet<E> {
        private /* synthetic */ AbstractMultiset this$0;

        ElementSet(AbstractMultiset abstractMultiset) {
            this.this$0 = abstractMultiset;
        }

        @Override
        final Multiset<E> multiset() {
            return this.this$0;
        }
    }
}

