Polymer({
      is: 'paper-fab',

      behaviors: [
        Polymer.PaperButtonBehavior
      ],

      properties: {
        /**
         * The URL of an image for the icon. If the src property is specified,
         * the icon property should not be.
         */
        src: {
          type: String,
          value: ''
        },

        /**
         * Specifies the icon name or index in the set of icons available in
         * the icon's icon set. If the icon property is specified,
         * the src property should not be.
         */
        icon: {
          type: String,
          value: ''
        },

        /**
         * Set this to true to style this is a "mini" FAB.
         */
        mini: {
          type: Boolean,
          value: false,
          reflectToAttribute: true
        },

        /**
         * The label displayed in the badge. The label is centered, and ideally
         * should have very few characters.
         */
        label: {
          type: String,
          observer: '_labelChanged'
        }
      },

      _labelChanged: function() {
        this.setAttribute('aria-label', this.label);
      },

      _computeIsIconFab: function(icon, src) {
        return (icon.length > 0) || (src.length > 0);
      }
    });