/*
 * Copyright (c) 2018, Alliance for Open Media. All rights reserved
 *
 * This source code is subject to the terms of the BSD 2 Clause License and
 * the Alliance for Open Media Patent License 1.0. If the BSD 2 Clause License
 * was not distributed with this source code in the LICENSE file, you can
 * obtain it at www.aomedia.org/license/software. If the Alliance for Open
 * Media Patent License 1.0 was not distributed with this source code in the
 * PATENTS file, you can obtain it at www.aomedia.org/license/patent.
 */

#ifndef AV1_ENCODER_AB_PARTITION_MODEL_WEIGHTS_H_
#define AV1_ENCODER_AB_PARTITION_MODEL_WEIGHTS_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "av1/encoder/ml.h"

#define FEATURE_SIZE 10
#define LABEL_SIZE 16
// nn model for ab partition pruning, 128x128.
static const float av1_ab_partition_nn_weights_128_layer0[FEATURE_SIZE * 64] = {
  -0.715251f, -0.015767f, -0.667353f, -0.345255f, 0.177887f,  -0.469759f,
  0.426152f,  0.489798f,  0.469865f,  0.773821f,  0.088517f,  0.074585f,
  0.838754f,  0.048449f,  -0.007584f, 0.638968f,  0.233305f,  -0.319236f,
  -0.257124f, -0.170869f, 0.137180f,  0.114852f,  -0.721241f, -0.947962f,
  -0.411298f, 0.494306f,  -0.060435f, -0.648421f, -0.126624f, 0.072686f,
  -0.143904f, -0.115839f, -0.175527f, -0.117728f, 0.040686f,  -0.189925f,
  0.134361f,  -0.258070f, -0.177558f, 0.158049f,  0.168668f,  -0.062919f,
  0.341986f,  0.038100f,  -0.435577f, -0.321255f, 0.203213f,  0.213061f,
  0.533304f,  0.359296f,  -0.079558f, 0.004637f,  0.663904f,  0.043779f,
  0.383018f,  1.136559f,  -0.084155f, 0.333057f,  -0.199011f, 0.152059f,
  -0.078419f, -0.167752f, -0.093651f, 0.083171f,  -0.190143f, 0.086195f,
  -0.280632f, -0.160663f, -0.017298f, 0.122628f,  -0.138116f, 0.062927f,
  0.222462f,  0.626979f,  0.426928f,  0.117170f,  -0.240457f, 0.053750f,
  0.038017f,  0.007359f,  -0.017595f, 0.101407f,  0.332891f,  0.074933f,
  0.306498f,  0.219380f,  -0.151638f, -0.247976f, 0.343405f,  0.121256f,
  0.049173f,  0.171474f,  -0.139608f, -1.016599f, -0.345553f, -0.901138f,
  0.243401f,  0.059928f,  -0.089396f, -0.195565f, 0.364705f,  -0.020400f,
  -1.383672f, 0.413018f,  0.536950f,  -0.020904f, -1.335306f, -0.732290f,
  0.102885f,  0.315290f,  -0.208521f, -0.081811f, 0.182300f,  0.125712f,
  -0.593833f, -0.220639f, -0.314155f, 0.188327f,  0.118503f,  0.524427f,
  -1.083859f, -1.130640f, 0.390352f,  -0.045591f, 0.113160f,  -0.009149f,
  -0.096183f, 0.115829f,  0.377752f,  0.318396f,  -0.591983f, 0.004797f,
  -0.497377f, -0.342248f, 0.079546f,  -0.025249f, -0.295972f, 0.615501f,
  -0.464372f, 0.418315f,  -0.173556f, 0.105217f,  0.298073f,  0.082478f,
  0.033223f,  0.977341f,  -0.372982f, -0.052337f, 0.154124f,  0.396787f,
  0.536654f,  -0.139061f, -0.223702f, 0.229666f,  -0.846766f, 0.107723f,
  0.563839f,  -0.483141f, 0.304813f,  -0.765283f, 0.070964f,  0.151101f,
  0.275188f,  0.490303f,  1.175892f,  0.085377f,  -0.191200f, 0.544532f,
  -0.365075f, 0.167546f,  0.052183f,  -0.220529f, -0.212227f, -0.144988f,
  -0.273356f, -0.062023f, 0.103993f,  -0.238493f, -0.161204f, -0.054611f,
  -0.166672f, 0.128327f,  0.461751f,  -0.545822f, 0.739798f,  0.594386f,
  -0.163192f, -0.332501f, 0.363834f,  -0.065043f, 0.474812f,  -0.138811f,
  0.170924f,  -0.778142f, -0.316474f, -0.508065f, -0.039986f, -0.478001f,
  0.340591f,  0.041783f,  0.055419f,  0.015155f,  -0.981830f, -1.355237f,
  0.347516f,  1.155327f,  0.081319f,  0.274163f,  -0.327230f, -0.113478f,
  0.556552f,  -0.055986f, 0.217318f,  -0.445351f, 0.325759f,  0.526547f,
  -0.657434f, -0.572214f, -0.037087f, 0.081384f,  0.064518f,  0.014892f,
  0.215279f,  1.834504f,  -0.242107f, 0.079810f,  0.129558f,  0.079588f,
  -0.035189f, -0.221745f, -0.163414f, 0.043978f,  -1.028662f, -0.623609f,
  1.130336f,  0.664661f,  -0.063975f, -0.415863f, 0.018581f,  0.157758f,
  0.200570f,  0.063420f,  0.901039f,  -0.746286f, 0.196230f,  -0.290592f,
  0.042373f,  -0.502500f, 0.183638f,  0.103394f,  -0.298858f, 0.145436f,
  0.196916f,  0.108319f,  -0.448572f, -0.881385f, 0.302497f,  0.121679f,
  -0.021327f, 0.025150f,  0.481306f,  -0.359634f, 0.350257f,  -0.228647f,
  -0.669860f, 0.260025f,  -0.034182f, 0.619247f,  -0.158826f, -0.405864f,
  0.674112f,  -0.027885f, -0.325274f, -0.241492f, 0.036024f,  -0.437685f,
  -0.091458f, -0.109295f, -0.350676f, 0.044706f,  0.297059f,  0.016290f,
  1.121203f,  1.289062f,  -1.299476f, -1.129221f, 0.103752f,  0.131302f,
  -0.263265f, 0.222155f,  -0.229908f, 0.013922f,  -0.226001f, -0.248383f,
  -0.004415f, -0.020958f, 0.055634f,  0.086200f,  0.114556f,  -0.184061f,
  -0.096210f, -0.146466f, -0.249618f, -0.195998f, 0.088758f,  0.023781f,
  -0.264460f, 0.157026f,  -0.235228f, -0.102564f, 0.043463f,  -0.187823f,
  -0.257500f, -0.199049f, -0.242210f, 0.030448f,  0.221604f,  0.151804f,
  -0.100404f, -0.073931f, 0.144749f,  -0.001572f, -1.438079f, -0.233716f,
  0.733422f,  1.727080f,  -0.036397f, 0.027551f,  0.425321f,  0.085703f,
  0.031186f,  0.032333f,  -0.675130f, 1.437733f,  -0.202392f, -0.525003f,
  0.087048f,  0.328194f,  -0.079989f, -0.391088f, -0.238732f, -0.120660f,
  -0.139600f, 0.154665f,  0.026202f,  -0.233501f, -0.009046f, -0.149187f,
  -0.199646f, 0.115375f,  0.209762f,  -0.014875f, 0.124038f,  -0.119985f,
  1.079625f,  -0.461513f, 0.614114f,  0.021003f,  0.439449f,  -0.824834f,
  -0.299701f, 0.193817f,  -0.870551f, -1.262313f, -0.079517f, 0.341570f,
  0.305310f,  -0.089721f, -0.317314f, -0.075631f, 0.127172f,  -0.208635f,
  1.191922f,  0.163141f,  0.564285f,  0.286352f,  0.480865f,  0.173094f,
  -0.094034f, -0.071339f, -0.328992f, -0.006382f, 0.314705f,  0.090258f,
  -0.016099f, 0.193230f,  0.188061f,  0.398144f,  0.722781f,  0.769949f,
  0.025442f,  -0.162016f, 0.070192f,  -0.056946f, -0.100957f, -0.219934f,
  -0.203492f, -0.015454f, -0.013272f, -0.098008f, 0.051707f,  -0.017493f,
  0.527446f,  0.083605f,  0.588318f,  0.878215f,  0.028747f,  -0.146479f,
  -0.345170f, -0.136059f, -0.152005f, -0.203634f, 0.232702f,  -0.101340f,
  -0.027733f, -0.282611f, 0.265366f,  0.082362f,  -0.265420f, -0.131124f,
  0.166303f,  0.040194f,  -0.100710f, 0.579151f,  -0.530136f, 0.163422f,
  -0.998821f, -1.565311f, -1.774785f, -2.493372f, 0.116970f,  -0.090302f,
  1.723272f,  0.552370f,  -0.295954f, -0.439095f, -0.266730f, 0.027936f,
  0.539616f,  -0.234902f, -0.167601f, -0.149877f, -0.242983f, 0.122353f,
  -0.121620f, -0.205517f, -0.180144f, -0.264208f, 0.151500f,  -0.159378f,
  0.029145f,  -0.050892f, -0.223407f, -0.246239f, 0.043152f,  -0.018460f,
  0.169972f,  -0.187769f, -0.034670f, -0.238330f, 0.288070f,  -0.093243f,
  -0.437105f, -0.573376f, 0.660073f,  0.285727f,  0.408470f,  0.158475f,
  0.032699f,  0.056280f,  -0.237176f, -0.083003f, 0.105598f,  -0.169522f,
  -0.260420f, -0.121100f, -0.173983f, -0.195693f, -0.232028f, 0.224940f,
  0.029124f,  0.009580f,  -0.252034f, 0.103087f,  1.156561f,  0.603848f,
  -0.562805f, -1.652742f, -0.568288f, -1.829395f, 0.046169f,  0.076095f,
  1.490819f,  0.415893f,  -0.277788f, -0.115787f, 0.093750f,  0.270726f,
  -0.395983f, -0.353742f, 0.034605f,  0.005342f,  0.184537f,  0.086445f,
  0.156417f,  1.476367f,  0.122587f,  0.002145f,  0.431057f,  -0.381184f,
  -1.646457f, -0.014009f, -0.671224f, 0.193726f,  -0.019247f, -0.031267f,
  -0.046208f, 0.298733f,  0.064734f,  0.616984f,  0.039381f,  0.182722f,
  -0.116670f, 0.233093f,  -1.214374f, -0.817970f, -0.064394f, -0.584783f,
  0.077697f,  -0.266720f, 0.130875f,  -0.235295f, -0.265754f, -0.159999f,
  -0.250114f, -0.183017f, 0.194403f,  -0.105808f, -0.169215f, -0.240866f,
  -0.026662f, -0.045123f, -0.036175f, -0.167471f, -0.192908f, -0.232602f,
  -0.267036f, -0.112500f, -0.257944f, -0.111909f, -0.802226f, -0.008800f,
  0.881460f,  -0.678603f, 0.008666f,  -0.252053f, -0.341035f, -0.175290f,
  0.183012f,  0.385991f,  0.079888f,  -0.014039f, -0.148653f, 0.671778f,
  -0.130219f, 1.086467f,  0.129267f,  -0.040400f, -0.201221f, -0.077005f,
  0.015890f,  0.000781f,  0.137764f,  1.389546f,  0.172152f,  0.047279f,
  -0.042783f, 0.127740f,  0.141467f,  -0.335738f, -1.396392f, 0.031496f,
  0.357385f,  0.343602f,  -0.714553f, 0.311014f,  0.132845f,  0.061149f,
  0.006796f,  0.568106f,  -0.255949f, 0.104134f,  -0.993447f, 0.298135f,
  -0.406590f, -0.049228f, -0.578570f, -0.188561f, -0.107046f, 0.374095f,
  0.068481f,  0.036240f,  -0.495801f, 0.180574f,  -0.766129f, 0.886967f,
  -0.568868f, -0.936062f, -0.418886f, -0.058735f, -0.511964f, -0.438596f,
  0.019016f,  -0.015837f, 0.600197f,  0.429773f,  0.315026f,  0.319667f,
  0.214617f,  -0.017316f, 0.270257f,  -0.040524f, 0.695803f,  -0.015223f,
  -1.554965f, 0.356997f,  -1.472428f, 0.024637f,  -0.562958f, 0.870351f,
  0.193635f,  0.036063f,  0.328638f,  0.200274f,  -1.634707f, 0.110534f,
  0.420104f,  -0.072042f, -0.006404f, 0.171680f,
};

static const float av1_ab_partition_nn_bias_128_layer0[64] = {
  0.643147f,  -1.348826f, 0.431627f,  0.000000f,  0.102717f,  -0.772628f,
  -0.034351f, -0.761977f, -0.638397f, 0.541969f,  -0.391311f, 0.563076f,
  0.148553f,  0.267217f,  -0.788092f, 0.544573f,  -0.546280f, 0.000000f,
  -0.446945f, 0.127732f,  0.270624f,  -0.219435f, -1.220203f, 0.324584f,
  0.110885f,  0.276547f,  0.179726f,  -0.375160f, 0.026401f,  -0.032595f,
  0.000000f,  -0.047932f, -0.648602f, -0.512637f, -0.031661f, -0.236761f,
  0.476453f,  -0.028021f, -0.013673f, -0.015578f, -0.920077f, 0.000000f,
  0.915351f,  -0.209962f, 0.000000f,  -0.025731f, 0.218288f,  0.000000f,
  0.047726f,  -0.813077f, -1.263281f, 0.239087f,  0.278614f,  -0.030753f,
  0.000000f,  0.346744f,  -0.948543f, -1.174211f, 0.216377f,  0.498913f,
  0.853918f,  0.002504f,  -0.190403f, 0.452050f,
};

static const float av1_ab_partition_nn_weights_128_layer1[64 * LABEL_SIZE] = {
  0.179769f,  1.499417f,  -0.445135f, -0.142278f, -0.337661f, 0.682064f,
  -0.203213f, 0.302171f,  0.226877f,  -0.422169f, 1.687586f,  0.783773f,
  0.220995f,  0.253482f,  0.370435f,  -1.342775f, 0.337229f,  -0.271473f,
  0.291796f,  1.362227f,  -1.751397f, -0.086178f, 0.725496f,  -0.118597f,
  0.227963f,  -0.501577f, 0.223849f,  -0.122421f, -0.123437f, -0.051045f,
  -0.020115f, 0.212711f,  0.246025f,  0.088120f,  -0.168995f, 1.740190f,
  -0.195098f, 0.680339f,  -0.589572f, -0.075244f, 0.878766f,  0.064092f,
  -3.548527f, 0.001660f,  0.107926f,  -0.169501f, -0.455212f, 0.123045f,
  -1.836998f, 0.330365f,  1.301475f,  0.454761f,  -0.576552f, -0.190761f,
  0.208459f,  0.618483f,  1.383364f,  0.970718f,  0.390174f,  0.406252f,
  -0.564519f, -0.312062f, 1.345712f,  -0.151873f, 0.109290f,  0.408847f,
  0.391243f,  0.152024f,  0.181764f,  -0.036263f, -0.160466f, 0.153595f,
  0.049163f,  -0.753012f, -1.804062f, 0.347475f,  -2.746580f, 0.575618f,
  0.261799f,  0.210505f,  -0.302054f, -0.109872f, 0.199506f,  -1.182971f,
  0.723668f,  0.177758f,  -0.338202f, 0.254396f,  -0.220023f, 0.043504f,
  0.669866f,  -0.040816f, -0.402730f, 0.017990f,  0.215523f,  -0.216816f,
  0.454826f,  -0.726067f, -0.018750f, -0.928679f, 0.154315f,  -0.465641f,
  0.144566f,  -0.030064f, -0.054667f, -0.154055f, 0.625384f,  1.323795f,
  -0.159496f, 0.097072f,  -0.463197f, -0.057938f, 0.750290f,  -0.233061f,
  0.412631f,  -0.535223f, -0.151423f, -0.154583f, 0.024721f,  -0.494448f,
  0.230594f,  -0.980138f, -0.653968f, 0.126079f,  0.051814f,  -0.053219f,
  -0.421708f, -0.228853f, 0.237885f,  0.888157f,  0.059655f,  0.241295f,
  0.210443f,  0.228238f,  0.119127f,  -0.051989f, -0.355408f, 0.182215f,
  0.244277f,  -0.104577f, -0.558035f, -0.023270f, 0.054571f,  0.700646f,
  -0.223006f, 0.115523f,  0.023391f,  0.437264f,  0.709477f,  -0.531212f,
  -0.094731f, 0.328161f,  -0.105418f, -0.133511f, 0.497168f,  -0.030948f,
  -0.407132f, -0.043943f, 0.155505f,  0.251945f,  0.205010f,  0.167160f,
  0.083654f,  -0.636810f, 0.401315f,  -0.398414f, 0.290046f,  0.206846f,
  0.042218f,  0.168150f,  0.843181f,  -0.671242f, -0.202392f, -0.073301f,
  0.142895f,  0.237466f,  0.212145f,  -0.091828f, 0.187038f,  -0.720841f,
  -0.616069f, -0.238021f, 0.065365f,  0.434119f,  0.179023f,  -0.040107f,
  -0.430734f, -0.297368f, 0.575954f,  0.382619f,  -0.709787f, -0.320810f,
  0.242342f,  -0.047614f, 0.705216f,  0.098077f,  0.357179f,  0.046017f,
  0.115074f,  -0.412305f, -0.272304f, 0.048096f,  -0.803811f, 0.275000f,
  0.642198f,  0.180286f,  -0.087178f, -0.112707f, -0.394443f, 0.201989f,
  0.241759f,  -1.038870f, 0.728124f,  0.800559f,  -1.296268f, 0.198612f,
  -0.053478f, 0.414344f,  -0.510529f, 0.124179f,  -2.219115f, -0.074583f,
  -0.143055f, 0.001697f,  0.810811f,  -0.657140f, 0.186818f,  -0.936414f,
  0.539578f,  -0.308244f, -0.126624f, -0.204767f, 0.091145f,  -0.049340f,
  0.252014f,  0.394582f,  0.018764f,  -0.060377f, -0.019133f, 0.064083f,
  0.069211f,  -0.526693f, 0.209850f,  -0.481466f, -0.468302f, -0.100407f,
  0.241018f,  -1.037781f, 0.038539f,  -2.113840f, -0.974895f, 0.163187f,
  0.425132f,  -0.772546f, -1.261254f, -0.217488f, -0.971748f, -0.805640f,
  -0.745175f, -0.177077f, 0.217658f,  0.381431f,  -0.052338f, 0.087176f,
  -0.165972f, 0.085937f,  0.472564f,  -0.796627f, -2.453307f, 0.569664f,
  -0.233010f, -0.192134f, 0.064339f,  -0.111411f, -0.262469f, -0.410022f,
  0.519993f,  -0.684620f, 0.393460f,  -0.277753f, -0.153624f, 0.528984f,
  -0.415558f, -0.445863f, 0.588512f,  -0.142439f, -0.132127f, 0.199776f,
  -0.579284f, 0.119488f,  -0.033590f, -0.503846f, -0.674979f, 0.335125f,
  0.020519f,  0.233973f,  -0.297998f, -0.051511f, 0.518626f,  -0.412782f,
  -0.074045f, 0.130523f,  0.465751f,  -0.117795f, 2.535813f,  0.352108f,
  -0.499228f, 0.379784f,  0.056699f,  0.173142f,  -0.076519f, -0.026666f,
  0.017834f,  0.492333f,  0.093364f,  0.037867f,  -0.165420f, -0.356429f,
  -0.562334f, 0.057656f,  -0.307544f, 0.085857f,  -0.559851f, 0.107230f,
  -0.398633f, 0.152618f,  -0.216835f, -0.024539f, 0.026044f,  -0.249519f,
  -0.563594f, -0.746025f, 0.025265f,  -0.298888f, -0.185243f, 0.058794f,
  0.233696f,  -0.115223f, 0.144617f,  -0.864390f, 0.619944f,  -0.023980f,
  0.019481f,  0.225252f,  0.416552f,  -0.115993f, 0.935387f,  0.744386f,
  0.053353f,  -0.052582f, -0.065650f, 0.228488f,  -0.032042f, -0.371252f,
  -0.003638f, -0.736984f, -0.203776f, 0.030922f,  -0.065577f, -0.031643f,
  -0.049253f, -0.054640f, 0.787134f,  0.545414f,  -0.140297f, -0.124274f,
  -0.110011f, -0.029552f, 0.657005f,  0.214973f,  -0.374300f, 0.251642f,
  0.276591f,  0.030566f,  -0.145470f, 0.350579f,  -0.356436f, -0.052694f,
  -0.063966f, -0.751008f, -1.042392f, 0.328892f,  -0.425058f, -0.421571f,
  -0.571889f, -1.141472f, -0.125216f, 0.212713f,  -0.485170f, -0.088791f,
  0.124589f,  0.023237f,  0.077635f,  0.020901f,  -0.271402f, -0.321424f,
  -0.513946f, -0.867872f, -0.284593f, 0.106276f,  0.220192f,  -0.143532f,
  -0.014648f, 0.073402f,  0.327256f,  -0.139803f, 0.168763f,  0.048199f,
  -0.122526f, 0.111713f,  -0.134257f, 0.810364f,  -0.085222f, -0.259221f,
  -0.239349f, 0.044448f,  0.205031f,  0.413113f,  -0.107720f, -0.018816f,
  -0.247741f, -0.004963f, 0.041170f,  -0.158019f, 0.134839f,  0.129502f,
  0.800488f,  -1.041584f, -0.129336f, 0.170834f,  0.566586f,  -0.230443f,
  0.437937f,  -0.149922f, -0.046665f, -0.094646f, 0.200070f,  0.072943f,
  -0.076943f, -0.084971f, -0.515843f, -0.146720f, 0.472869f,  -0.444731f,
  -0.100877f, 0.545196f,  -1.786626f, -0.482946f, 0.500509f,  -0.843257f,
  0.200374f,  0.045103f,  -0.575718f, -0.164335f, -0.232522f, -0.021825f,
  -0.139490f, 0.356058f,  -0.352075f, 0.061751f,  -0.200616f, -1.180921f,
  -0.181355f, -0.137459f, 0.247574f,  0.181541f,  0.184314f,  -0.961482f,
  0.493615f,  0.910261f,  -2.279238f, 0.648631f,  -0.055526f, -0.037137f,
  0.038643f,  0.136609f,  -0.819373f, -0.040840f, -0.265989f, 0.006877f,
  0.454651f,  -0.595323f, -0.099500f, -0.263717f, 0.150456f,  0.245077f,
  -0.268666f, 0.162232f,  -0.516451f, -0.024501f, 0.188046f,  -0.002262f,
  0.261319f,  0.004173f,  0.746982f,  0.174761f,  0.470447f,  -0.159558f,
  -0.385240f, 0.023084f,  -0.133520f, -0.220607f, -0.018731f, -0.373558f,
  -0.707763f, -1.850150f, -0.807404f, -0.168063f, -0.071435f, -0.160740f,
  -0.478789f, -1.070674f, -0.489740f, -0.255796f, 0.100486f,  -0.153361f,
  0.334394f,  -0.569472f, -0.198118f, 0.255922f,  0.104717f,  -0.065179f,
  0.111879f,  -0.447237f, 1.373623f,  -0.190191f, -0.063311f, 0.337529f,
  -0.138800f, 0.057009f,  -0.137006f, 0.641378f,  0.883147f,  -0.679655f,
  0.267717f,  -0.351602f, -0.135225f, 0.229398f,  -0.513225f, -1.120345f,
  0.528786f,  -0.051081f, 0.086653f,  0.140141f,  -0.563969f, 0.333402f,
  -0.174745f, 0.321093f,  -0.438641f, -0.005131f, 0.247415f,  0.110120f,
  -0.076308f, -0.083244f, 0.838944f,  -0.113043f, -0.013258f, -0.175028f,
  -0.179941f, 0.272676f,  -0.047946f, -0.088076f, -0.450031f, 0.053929f,
  -0.083549f, -0.089952f, -0.186253f, 0.257483f,  0.011019f,  0.586435f,
  0.060580f,  -0.052078f, 0.090277f,  -0.780869f, 0.969811f,  -0.025349f,
  -0.281917f, 0.014857f,  0.231863f,  -0.228601f, -0.003861f, 0.226550f,
  0.141825f,  -0.102171f, -0.010387f, 0.220378f,  -2.561975f, -0.497071f,
  -0.315117f, 0.371981f,  0.138247f,  0.625031f,  -0.308133f, -0.217876f,
  0.005615f,  -0.860179f, 0.747491f,  0.006356f,  -0.057024f, -0.483189f,
  0.055592f,  -0.316834f, 0.069858f,  0.218788f,  -0.200044f, 0.227588f,
  0.215496f,  -0.055324f, -0.393147f, -0.394062f, -0.253264f, -0.075619f,
  -0.152512f, -0.332995f, 0.129053f,  0.178668f,  -0.302694f, 0.030678f,
  0.925896f,  0.964375f,  0.169021f,  -0.218657f, -0.627204f, 0.206437f,
  -0.521336f, 0.176206f,  0.142733f,  0.139248f,  0.411682f,  0.181544f,
  0.224850f,  -0.935547f, -0.558208f, 0.348096f,  0.342129f,  -0.389340f,
  -0.236308f, -0.132099f, 0.073642f,  0.089391f,  -0.306901f, -0.397842f,
  0.444282f,  0.074623f,  -0.051075f, -0.106617f, -0.184037f, -0.239046f,
  -0.138761f, 0.120794f,  -0.647577f, -0.336471f, 0.527899f,  -0.164234f,
  -0.028354f, 1.083678f,  -0.251534f, -0.145903f, -0.182783f, 0.070976f,
  -0.199590f, -0.400306f, -0.029763f, -0.548042f, -0.266270f, -0.118084f,
  -1.152632f, 0.383685f,  -0.105895f, -0.096829f, 0.118382f,  0.047447f,
  -0.019051f, 0.310180f,  -0.162793f, -0.029574f, 0.058054f,  -0.636017f,
  0.490639f,  0.158347f,  -0.385701f, -0.147057f, 1.285825f,  -1.276083f,
  -0.021795f, -0.101600f, 0.163254f,  0.267160f,  -2.317864f, -0.098598f,
  -0.296337f, -0.309017f, 0.164127f,  -0.270012f, -0.071187f, -0.262270f,
  0.075415f,  -0.368328f, 0.186728f,  -0.158031f, 0.481663f,  0.515950f,
  -0.162551f, 0.497981f,  0.262196f,  0.168479f,  0.726066f,  -0.243856f,
  -0.058998f, 0.140168f,  0.053242f,  -0.624623f, -0.249480f, 0.055197f,
  -1.376804f, 0.417571f,  0.203784f,  0.174370f,  -0.155531f, -0.029400f,
  -0.491473f, 0.079811f,  -0.080123f, 1.345900f,  0.637077f,  0.434862f,
  -1.787438f, 0.005756f,  -0.362706f, 0.179458f,  -0.288263f, 0.516788f,
  -0.921248f, 0.043794f,  -0.137729f, -0.196171f, -0.046295f, -0.793781f,
  -0.156532f, -0.132566f, 0.517989f,  -0.154321f, -0.054174f, -0.077900f,
  -0.373316f, -0.117718f, 0.188986f,  -0.476188f, -0.245312f, 0.181439f,
  -0.161024f, -0.229059f, -3.079907f, -0.225452f, -0.594355f, -0.558027f,
  -0.135429f, 0.125766f,  -0.081314f, -0.350894f, -0.163165f, -1.936507f,
  -0.205966f, 0.031472f,  0.744446f,  -0.006680f, -0.837551f, 0.605862f,
  -0.854929f, -1.543750f, -0.307704f, -0.240517f, 0.178240f,  -0.183586f,
  -0.010307f, 0.099373f,  -0.228278f, 0.175236f,  -0.000133f, 0.104491f,
  -1.540545f, -0.570971f, -0.252885f, 0.483036f,  0.052531f,  0.260214f,
  -0.515016f, -0.602081f, -0.485690f, -0.730710f, 0.163719f,  -1.775975f,
  -0.298634f, 0.323626f,  -0.373579f, -0.872977f, 0.619574f,  0.026862f,
  -0.122531f, -0.084698f, -2.436297f, 0.483996f,  -0.203640f, -0.302157f,
  -0.150666f, -0.238320f, 0.089250f,  0.236485f,  -0.668654f, -0.122863f,
  0.491152f,  -0.226444f, -0.181248f, 0.120158f,  0.294027f,  0.250056f,
  0.307601f,  0.357875f,  -1.746455f, -0.175670f, 0.385447f,  -0.108808f,
  -0.090235f, -0.642504f, -0.486004f, -0.055160f, -0.068692f, 0.009736f,
  0.607555f,  -0.489426f, 0.150624f,  0.598114f,  -0.128816f, -0.445793f,
  -0.066524f, -0.254380f, 0.227106f,  -0.406495f, -0.121632f, -0.275960f,
  -0.136494f, 0.339457f,  -1.318132f, -0.417572f, -2.614077f, 0.324603f,
  -0.001211f, 0.375192f,  -0.473448f, -0.162510f, 0.099329f,  -0.277965f,
  0.101221f,  -0.060263f, 0.121867f,  -1.042140f, 0.440851f,  0.078898f,
  -0.209007f, -0.243699f, 0.715197f,  -0.093997f, 0.086022f,  -0.178203f,
  -2.275496f, -0.098413f, 0.199352f,  -0.526791f, -0.162086f, -0.197806f,
  -0.231657f, -0.269202f, -0.794294f, -0.223461f, 0.503584f,  0.416236f,
  0.064082f,  0.197655f,  0.340871f,  -0.186645f, -0.291498f, 0.433938f,
  -1.110063f, 0.003751f,  0.392738f,  0.069360f,  0.102088f,  -0.302128f,
  -1.518457f, 0.106939f,  0.404527f,  -0.306868f, -0.286928f, 0.729276f,
  -0.531710f, 0.745048f,  -0.168837f, -1.953886f, -0.258828f, -0.190252f,
  0.241877f,  -0.916744f, -0.030326f, -0.070541f, -0.271037f, 0.211303f,
  -0.489957f, 0.100850f,  0.323999f,  -0.802837f, -0.462408f, -0.079350f,
  -0.029374f, 0.131213f,  -0.825032f, 0.040202f,  0.351821f,  0.002869f,
  -0.132516f, -0.471264f, -0.297002f, 0.263913f,  0.033478f,  0.146161f,
  0.533229f,  -0.228608f, -0.200639f, -0.170955f, -0.915037f, 0.724491f,
  0.005151f,  0.018584f,  -0.029771f, -0.396038f, -0.159236f, 0.038691f,
  -1.197056f, 0.146302f,  0.226840f,  -0.852126f, 0.031214f,  0.108880f,
  0.562000f,  -0.134633f, -0.713343f, -0.342252f, -1.764521f, -0.114653f,
  0.515073f,  -0.080515f, -0.121155f, -0.865139f, -0.833694f, -0.368553f,
  0.347673f,  0.623379f,  0.722067f,  -0.492458f, -0.513263f, 0.585167f,
  0.721518f,  -0.693499f, 0.343725f,  -0.273861f, -0.040230f, -0.785664f,
  -0.157500f, -0.308445f, 0.054062f,  0.600131f,  -0.860887f, 0.434470f,
  -0.191382f, -0.306150f, -0.243965f, 0.705444f,  0.007789f,  -0.146154f,
  -0.054499f, -0.073500f, -1.067364f, 0.404936f,  -2.864590f, 0.182323f,
  0.326126f,  0.102405f,  -0.135800f, 1.128095f,  -0.012267f, -0.023996f,
  -0.264834f, -0.108967f, -1.176746f, -0.926666f, 0.082999f,  -0.498361f,
  0.083560f,  -0.210074f, 0.019225f,  -0.201614f, -0.904760f, 0.181421f,
  0.586384f,  -0.177706f, 0.065471f,  0.168552f,  0.054705f,  0.045241f,
  0.048057f,  -0.410957f, -2.188854f, -0.169812f, 0.015521f,  0.176856f,
  -0.179331f, -0.352640f, -0.491735f, -1.743206f, 0.044227f,  0.010454f,
  0.823643f,  -0.119781f, -0.098359f, 0.093119f,
};

static const float av1_ab_partition_nn_bias_128_layer1[LABEL_SIZE] = {
  -0.433195f, -0.120488f, -0.116721f, 0.112134f,  0.118170f, -0.259769f,
  -0.077530f, 0.394044f,  0.279167f,  -0.317988f, 0.189538f, 0.314776f,
  0.325655f,  -0.107123f, 0.591049f,  0.358744f,
};

static const NN_CONFIG av1_ab_partition_nnconfig_128 = {
  FEATURE_SIZE,  // num_inputs
  LABEL_SIZE,    // num_outputs
  1,             // num_hidden_layers
  {
      64,  // num_hidden_nodes
  },
  {
      av1_ab_partition_nn_weights_128_layer0,
      av1_ab_partition_nn_weights_128_layer1,
  },
  {
      av1_ab_partition_nn_bias_128_layer0,
      av1_ab_partition_nn_bias_128_layer1,
  },
};

// nn model for ab partition pruning, 64x64.
static const float av1_ab_partition_nn_weights_64_layer0[FEATURE_SIZE * 64] = {
  -0.495347f, -0.049498f, -0.026804f, 0.030474f,  -0.289308f, -0.264193f,
  -0.141121f, -0.072562f, -0.391665f, -0.051491f, -0.234761f, 0.027155f,
  -0.038217f, 0.014872f,  -0.289728f, -0.233577f, -0.415875f, -0.343615f,
  -0.442543f, -0.482492f, 0.073510f,  0.007503f,  2.162329f,  -0.362849f,
  2.145915f,  -0.883135f, 0.185636f,  -0.062859f, -0.465574f, -0.486205f,
  -0.056710f, -0.330642f, -0.321860f, 0.042321f,  -0.348965f, 0.003542f,
  -0.291365f, -0.078164f, -0.345093f, -0.220272f, -0.471270f, -0.763853f,
  0.246622f,  0.199651f,  -0.663420f, -0.154152f, -1.220383f, 0.047138f,
  0.816811f,  0.083247f,  -0.218839f, 0.038143f,  -0.063436f, 0.015517f,
  -0.307320f, -0.166956f, -0.169499f, -0.399005f, -0.234638f, -0.162266f,
  0.050425f,  -0.221723f, -0.256942f, -0.287285f, 0.144011f,  -0.033245f,
  0.083649f,  0.119428f,  -0.056706f, -0.117805f, 0.021866f,  -0.257300f,
  -0.201378f, -0.217484f, -0.413780f, -0.145793f, 0.082792f,  -0.347247f,
  0.042539f,  -0.302697f, 1.652316f,  0.000701f,  -0.482843f, -0.160332f,
  -0.450099f, 0.212399f,  -4.715360f, -5.336774f, -5.375758f, -6.048339f,
  0.085956f,  -0.037767f, 1.052409f,  -0.931924f, -2.221907f, 0.268946f,
  0.015512f,  1.237094f,  -1.092185f, 0.418247f,  -0.082143f, -0.076914f,
  -0.060749f, -0.325440f, -0.296960f, -0.066815f, -0.158477f, -0.373945f,
  -0.122322f, -0.113495f, -0.097978f, -0.192816f, -0.270418f, 0.035840f,
  -0.015458f, -0.121071f, -0.279582f, -0.067683f, 0.097855f,  0.019839f,
  0.451127f,  0.004376f,  1.410392f,  3.255835f,  -0.344815f, 0.145202f,
  0.204132f,  0.171948f,  -0.527736f, -0.110353f, 0.901448f,  0.003238f,
  -3.822090f, 0.235462f,  1.024823f,  -0.821244f, 0.876056f,  2.553762f,
  -3.478597f, -2.076582f, -0.265515f, -0.055923f, -0.156980f, -0.164097f,
  -0.246040f, 0.039430f,  -0.071769f, -0.118847f, -0.304053f, -0.281541f,
  -0.226021f, -0.263091f, -0.127359f, -0.249410f, -0.051023f, 0.083911f,
  0.084721f,  0.168089f,  -0.272169f, -0.204998f, -0.008303f, -0.173998f,
  0.079376f,  -0.197426f, -0.199052f, -0.118794f, -0.063753f, -0.094769f,
  0.066176f,  -0.175832f, -0.238752f, -0.287960f, -0.134307f, -0.185953f,
  -0.385845f, 0.119769f,  -0.006567f, -0.382126f, -0.214221f, 0.038449f,
  -0.253484f, -0.282766f, -0.020249f, -0.193929f, 0.016281f,  -0.114423f,
  -0.145940f, -0.281621f, -0.007588f, -0.131470f, -0.189012f, -0.185699f,
  -0.279011f, -0.008132f, 0.208463f,  0.020569f,  -0.206803f, -0.213408f,
  -0.206131f, -0.290245f, 0.069701f,  -0.000371f, -0.307572f, -0.451785f,
  -0.300838f, -0.453186f, -0.301691f, 0.046327f,  -0.312668f, 0.058272f,
  -0.303131f, -0.376252f, 0.108384f,  -0.086623f, -0.100630f, -0.027330f,
  -0.003969f, 0.089502f,  -0.200722f, -0.107889f, 0.061843f,  -0.008478f,
  -0.265057f, -0.271132f, -0.073562f, 0.129337f,  -0.283698f, -0.353414f,
  0.076420f,  -0.244280f, -0.119537f, -0.105366f, -0.184692f, -0.038817f,
  -0.478507f, -0.118808f, -0.472979f, -0.305884f, -0.462813f, -0.189581f,
  -0.011932f, -0.585700f, 0.253212f,  -1.061900f, -0.205116f, -0.336407f,
  -0.762199f, 0.577737f,  0.230832f,  0.434440f,  -0.096713f, 0.038552f,
  -0.147800f, -0.213553f, 0.041740f,  -0.281907f, -0.026154f, -0.082356f,
  -0.331871f, -0.408247f, -0.129022f, -0.037550f, -0.310233f, -0.320883f,
  -0.391963f, -0.467392f, 0.027453f,  -0.394761f, -0.045544f, 0.076052f,
  0.483985f,  0.067093f,  0.141361f,  0.576772f,  0.859718f,  2.566515f,
  -0.025476f, 0.769738f,  -0.680235f, -1.683309f, -2.394131f, -0.000714f,
  -0.615021f, -0.195856f, -0.434035f, -0.295010f, -0.668659f, -0.245959f,
  0.551148f,  1.777227f,  -0.461630f, 0.043093f,  0.012293f,  -0.255841f,
  -0.097070f, -0.371156f, -0.146323f, -0.015508f, -0.103873f, -0.087476f,
  -0.297266f, -0.128699f, -0.149555f, 0.016534f,  -0.375498f, -0.346759f,
  -0.455156f, -0.147509f, -0.427076f, -0.354431f, -0.158025f, -0.164604f,
  -0.237038f, -0.010314f, -0.092884f, -0.397084f, -0.217980f, -0.127184f,
  -0.048421f, -0.144133f, 0.889073f,  0.012606f,  3.007608f,  -0.602584f,
  -1.849480f, -0.373159f, -1.890695f, -3.609938f, 0.811923f,  -1.867208f,
  -0.244326f, -0.018012f, -0.211192f, -0.220196f, 0.169363f,  0.119141f,
  -0.230715f, 0.083247f,  0.020367f,  -0.128629f, -0.217455f, -0.159640f,
  1.815952f,  -0.369238f, -1.186447f, -0.658753f, -0.511026f, -0.096934f,
  0.662971f,  0.486475f,  0.159746f,  -0.018932f, 3.692397f,  1.384353f,
  -0.401984f, -0.248380f, -0.140861f, 0.215248f,  -0.023711f, 0.059679f,
  -0.072260f, 0.004271f,  0.039545f,  -0.347971f, -0.081851f, -0.474896f,
  -0.181572f, 0.066736f,  -0.157822f, -0.163760f, -0.171113f, -0.089935f,
  -0.338281f, -0.421444f, -0.306687f, -0.085283f, -0.377953f, -0.138750f,
  -0.102701f, -0.312336f, 0.149831f,  0.007229f,  -0.155700f, -0.173611f,
  4.074261f,  1.342306f,  -1.272712f, 1.570899f,  -0.545093f, -0.317605f,
  -0.189440f, -0.133910f, -0.273190f, -0.108020f, -0.166107f, 0.021413f,
  -0.239130f, -0.067211f, 0.041957f,  -0.039234f, -1.003587f, -0.094412f,
  0.532512f,  -0.870538f, -1.118023f, -1.160983f, -0.736307f, -0.418752f,
  0.419466f,  0.492122f,  -0.004368f, -0.022096f, -1.115132f, 0.150886f,
  2.396852f,  2.660000f,  -0.376537f, 0.468628f,  0.149413f,  -0.074898f,
  -0.067154f, 0.021245f,  0.127857f,  0.294189f,  0.508056f,  0.390232f,
  -3.899177f, -3.414681f, -3.929195f, -4.160545f, -0.274323f, -0.052583f,
  -0.003545f, -0.433084f, -0.404891f, -0.145051f, -0.312367f, 0.004579f,
  -0.398724f, -0.372068f, -0.234279f, 0.017799f,  -0.424760f, -0.646717f,
  -0.047568f, 2.924664f,  -0.644165f, 0.359349f,  -0.294800f, 0.591746f,
  -0.404710f, -0.092358f, -0.250729f, 0.030829f,  -0.147149f, -0.476023f,
  -0.071803f, -0.482516f, -0.293117f, -0.215923f, -0.373122f, -0.085315f,
  -0.377052f, -0.449899f, -0.056452f, 0.138081f,  -0.085350f, -0.308391f,
  0.106661f,  0.176234f,  0.258869f,  -0.230172f, -0.233029f, -0.241208f,
  -0.067509f, -0.223172f, -0.118353f, -0.302478f, -0.579632f, -0.561326f,
  -0.158114f, -0.223167f, -0.026689f, 0.051863f,  0.212834f,  -0.304714f,
  -0.169071f, -0.193695f, -0.075682f, -0.170860f, -0.241008f, -0.044648f,
  0.280815f,  -0.002585f, -0.283552f, -0.037701f, -0.681169f, -0.274535f,
  -0.380595f, 0.109504f,  -0.111141f, -0.437685f, -0.094459f, 0.144206f,
  -0.106139f, -0.211832f, -0.054742f, -0.172813f, -0.295905f, -0.071907f,
  -0.418429f, -0.183240f, 0.031319f,  -0.095785f, -0.315447f, 0.069404f,
  -0.422910f, -0.029867f, -0.357321f, -0.199976f, -0.337707f, -0.070188f,
  -0.178198f, 0.177208f,  0.134688f,  -0.081933f, -0.229452f, -0.208872f,
  0.026287f,  -0.364040f, -0.063696f, -0.227443f, -0.234401f, -0.205699f,
  -0.267238f, -0.494125f, -0.056255f, 0.053715f,  -0.487754f, 0.014818f,
  0.087383f,  -0.077556f, -0.168085f, -0.436851f, -0.276286f, -0.137845f,
  -0.107606f, -0.103653f, -0.233766f, -0.419083f, 0.169185f,  0.010186f,
  -0.001587f, 0.086735f,  -2.465718f, 1.482185f,  1.621193f,  -2.081680f,
  1.386553f,  -3.204335f, -0.267111f, -0.004508f, 0.164712f,  0.274147f,
  1.724306f,  -2.273659f, 0.749574f,  -0.891905f, 0.105965f,  -0.030428f,
  -0.416018f, -0.300762f, 0.122911f,  -0.316908f, -0.292504f, 0.138666f,
  -0.161327f, -0.042143f, -0.249128f, 0.149210f,  -0.088987f, -0.654101f,
  -1.501843f, 0.216777f,  0.955914f,  0.524158f,  -1.642561f, -1.643626f,
  0.864797f,  -0.425451f, -2.115764f, -0.012502f, 0.065172f,  1.297270f,
  0.018845f,  1.167276f,  -0.470970f, -0.244995f, 0.374782f,  -1.811056f,
  -0.055430f, -0.024102f, -0.376519f, -0.339640f, -0.119177f, -0.277995f,
  -0.290095f, -0.081362f, -0.144139f, -0.118037f, -0.180357f, -0.217559f,
  -0.370683f, 0.172816f,  -0.265069f, 0.194321f,  -0.273478f, 0.037442f,
  -0.235552f, -0.078625f, -0.447541f, 0.016836f,  -0.271123f, -0.171481f,
  -0.321477f, -0.184826f, -0.442981f, -0.227273f, -0.370666f, -0.237232f,
  -0.257493f, -0.225714f, -0.153716f, -0.283487f, -0.155399f, 0.067697f,
  0.230343f,  -0.034318f, -0.022687f, -0.047090f,
};

static const float av1_ab_partition_nn_bias_64_layer0[64] = {
  -0.212182f, -0.233725f, -0.758846f, -0.158162f, 0.614743f,  -0.150944f,
  -0.075727f, -0.208414f, 1.054996f,  0.713758f,  -0.300051f, -0.151482f,
  -2.443570f, 0.430590f,  -0.129001f, -0.160733f, -0.230547f, -0.143228f,
  -0.140577f, -0.086812f, -0.212298f, -0.159557f, -0.055647f, -0.211423f,
  0.578161f,  -0.220318f, -0.210107f, -3.111584f, 0.604419f,  -0.232622f,
  -0.209924f, -0.130794f, -0.084097f, -0.036005f, 0.294594f,  -2.535531f,
  -0.209783f, -0.211189f, -2.766337f, 0.000000f,  0.450177f,  -1.754884f,
  3.262664f,  -0.209691f, -0.614886f, -0.211257f, -0.109096f, -0.190492f,
  -0.109007f, -0.026910f, -0.136035f, -0.212321f, -0.139320f, -0.212233f,
  -0.305430f, 0.739171f,  0.991277f,  -0.088150f, 0.086313f,  -0.023379f,
  -0.125366f, -0.063576f, -0.212169f, -0.047463f,
};

static const float av1_ab_partition_nn_weights_64_layer1[64 * LABEL_SIZE] = {
  -0.036800f, 0.528721f,  0.490767f,   0.144409f,  1.103640f,  0.361910f,
  -0.180069f, 0.068033f,  -14.868382f, 0.359013f,  0.322567f,  -0.199212f,
  0.906164f,  -0.488254f, 0.149653f,   -0.216394f, -0.099347f, 0.004936f,
  -0.111391f, 0.074848f,  -0.041709f,  0.147627f,  -0.018905f, 0.096116f,
  0.184817f,  -0.016241f, 0.115739f,   2.376754f,  0.637097f,  0.052954f,
  0.136428f,  0.225267f,  -0.181873f,  -0.142876f, 0.684048f,  0.658791f,
  0.105795f,  0.241705f,  1.381114f,   -0.209379f, 1.145949f,  0.795293f,
  -9.361877f, 0.198302f,  0.539600f,   0.092317f,  -0.081695f, 0.200777f,
  0.102334f,  0.081583f,  0.060948f,   -0.025110f, 0.160951f,  -0.020170f,
  0.234006f,  -0.029369f, 0.375036f,   0.270209f,  -0.556529f, 1.402949f,
  0.101777f,  -0.027331f, 0.004502f,   -0.153166f, -0.116651f, 0.151573f,
  -0.022187f, 0.144044f,  -0.108719f,  -0.129942f, -0.270321f, 0.227363f,
  1.892330f,  -0.661052f, -0.219398f,  -0.229417f, -0.856438f, -1.196988f,
  -0.081774f, 0.078847f,  -0.207057f,  -0.048947f, 0.152073f,  -0.243056f,
  -0.233329f, -0.288689f, -0.158333f,  -0.141177f, -0.715436f, 0.016947f,
  -0.093752f, 0.204984f,  -1.209782f,  0.155683f,  0.092239f,  0.146495f,
  0.813146f,  -0.027757f, 0.330982f,   2.173948f,  -0.028867f, -0.141815f,
  0.292708f,  -0.204794f, 0.014496f,   1.032799f,  1.312155f,  0.107020f,
  0.824752f,  -0.013945f, 0.184829f,   -0.041633f, 0.215300f,  -0.476088f,
  -0.053213f, 0.126862f,  -0.020777f,  0.082893f,  -0.223727f, -0.923063f,
  0.466529f,  0.082140f,  -0.845758f,  -1.140791f, -0.262033f, 0.138491f,
  0.151717f,  -0.182479f, -0.131128f,  0.055411f,  0.106771f,  0.125552f,
  0.297184f,  -0.257403f, -0.059884f,  -0.274903f, 2.694357f,  -0.108244f,
  0.025377f,  0.043092f,  -0.558317f,  3.517159f,  -0.270833f, -0.240676f,
  0.205100f,  -0.057068f, -0.140445f,  -0.193449f, -0.030061f, -0.286762f,
  -0.467523f, -0.012647f, 0.190564f,   0.022394f,  -0.101479f, 0.339684f,
  -0.902743f, -0.169578f, -0.178029f,  -0.041836f, -3.952108f, -0.028298f,
  -0.221137f, -0.733895f, -0.223895f,  0.039012f,  0.687867f,  0.021423f,
  0.113063f,  0.676087f,  -0.961000f,  -0.064847f, 0.712856f,  -0.192765f,
  -0.001132f, 0.016689f,  -0.236020f,  -0.766186f, -0.175729f, 0.012879f,
  -0.251064f, -0.105523f, -0.039212f,  -0.347584f, 0.304352f,  -0.034174f,
  -0.364258f, -0.685252f, -0.266115f,  -0.247345f, -0.155905f, 0.152283f,
  -0.156315f, 0.174082f,  -0.757654f,  0.102303f,  -2.192316f, -0.245815f,
  0.119882f,  -0.086542f, 1.987246f,   -1.353163f, -0.374813f, -0.233504f,
  -1.980895f, 0.692093f,  -0.168351f,  0.172700f,  -0.009052f, -0.015734f,
  0.106679f,  -0.060472f, -0.256813f,  -0.074874f, -0.207488f, -0.329515f,
  -0.418268f, -0.017940f, -0.036081f,  0.064719f,  -1.488016f, 0.020591f,
  -0.176325f, -0.141074f, 0.944494f,   0.150237f,  -0.249805f, -0.277280f,
  0.012686f,  0.132483f,  0.116123f,   0.013737f,  -0.116091f, 0.750340f,
  3.251343f,  -0.188864f, 1.096992f,   0.058467f,  -0.041433f, -0.037937f,
  -0.133294f, -0.137908f, -0.171132f,  0.106362f,  0.069383f,  -0.052662f,
  -0.177883f, -0.408049f, 0.680221f,   -0.117035f, -0.904240f, -1.395228f,
  0.154527f,  0.134427f,  0.022767f,   -0.158886f, -0.230316f, 0.161096f,
  0.362213f,  -0.235060f, -0.941620f,  0.055912f,  -0.049458f, -0.166632f,
  0.481418f,  0.930146f,  0.041108f,   0.033674f,  1.372066f,  -1.847709f,
  0.003324f,  0.259534f,  0.177014f,   -0.202761f, -0.262017f, -0.190852f,
  -0.102839f, 0.028338f,  0.187193f,   -0.041684f, 0.123973f,  -0.198576f,
  -0.110369f, -1.431400f, 0.208369f,   -0.302370f, -0.248549f, 0.062985f,
  0.673409f,  0.036662f,  -0.711340f,  -0.120584f, -0.189789f, 0.098812f,
  2.947819f,  0.216567f,  -0.414472f,  -0.181742f, 1.873779f,  -0.222726f,
  -0.782870f, 0.007889f,  0.015062f,   -0.554328f, 0.182928f,  -0.191430f,
  0.123636f,  -0.215460f, -0.225245f,  0.251516f,  -0.013025f, -1.359595f,
  -0.750602f, 0.342667f,  -0.141899f,  -0.687493f, -0.072639f, 0.048018f,
  -0.242107f, -0.031917f, -0.287472f,  -0.046088f, 0.832197f,  -0.016576f,
  -1.553349f, -0.216341f, 0.023077f,   -0.410867f, 4.243743f,  -0.514878f,
  -0.066007f, -0.160696f, -0.262678f,  -0.648790f, -0.430586f, 0.199940f,
  -0.202496f, -0.222241f, -0.016406f,  -0.121473f, 0.000828f,  -0.081584f,
  -0.152641f, -0.190166f, 0.644400f,   0.040196f,  -0.302104f, -1.143654f,
  -0.160327f, -0.320780f, -0.187006f,  0.037311f,  0.440618f,  -0.070733f,
  -0.117785f, 1.527539f,  -0.419310f,  0.001300f,  1.389956f,  -0.036366f,
  -0.269203f, 0.612265f,  2.721897f,   -0.086836f, -0.446999f, 0.012525f,
  -0.078317f, -0.287052f, -0.111188f,  -0.085181f, -0.164667f, -0.010466f,
  -0.569722f, -0.018888f, -0.101663f,  -1.147130f, -0.465204f, 0.114524f,
  -2.192402f, -0.221325f, 0.375748f,   0.206284f,  -0.261548f, -0.246257f,
  -0.143004f, -0.069981f, -0.057306f,  -0.116481f, -0.435903f, -0.314970f,
  0.013210f,  -0.010175f, 4.630571f,   -0.473226f, -0.197199f, -0.028204f,
  0.122907f,  2.475548f,  0.025011f,   -0.092603f, -0.127561f, -0.151330f,
  -0.077295f, 0.245016f,  -0.045005f,  0.183396f,  -0.330556f, -0.384887f,
  0.356374f,  -0.016618f, -0.463353f,  -1.291546f, -0.071986f, -0.311599f,
  0.072385f,  -0.430786f, -2.094788f,  0.202733f,  -0.910109f, -1.336543f,
  -0.086800f, -0.096413f, 1.544383f,   0.031860f,  -0.796211f, 0.762786f,
  3.250022f,  -0.441798f, -0.698537f,  0.062839f,  0.033525f,  -0.362996f,
  0.027022f,  -1.131264f, -0.228926f,  0.053885f,  -0.338628f, 0.155037f,
  -0.046844f, -0.888172f, -0.241767f,  0.084965f,  -0.617743f, -0.049896f,
  -0.036894f, -0.304783f, -0.002639f,  0.137957f,  0.052121f,  -0.131161f,
  -0.117200f, -0.253380f, -0.205561f,  -0.302450f, -0.047397f, -0.330518f,
  3.613420f,  -1.525951f, -0.026738f,  0.209150f,  -2.103534f, 2.019689f,
  -0.366199f, -0.095260f, 0.027417f,   -0.242512f, 0.162579f,  0.052113f,
  -0.293851f, -0.068138f, -0.005799f,  -0.344696f, -0.114824f, -0.431107f,
  -0.120058f, -1.139926f, -1.048379f,  0.036446f,  -0.323020f, -0.432945f,
  0.454151f,  -0.140058f, 0.050649f,   -0.094900f, -0.017278f, -0.238719f,
  1.193153f,  0.120447f,  -0.496061f,  0.917431f,  2.936126f,  -0.115521f,
  -0.347397f, -0.435325f, -0.004383f,  -0.211864f, 0.162383f,  -1.040726f,
  0.089537f,  -0.128579f, -0.133505f,  0.107129f,  -0.435657f, -0.180388f,
  0.043650f,  0.018709f,  -0.773242f,  -0.687192f, -0.120633f, -0.063626f,
  0.029912f,  0.113972f,  -0.403502f,  -0.127640f, -0.269625f, 0.129794f,
  -0.188539f, 0.041641f,  0.029769f,   -0.198374f, 1.401407f,  0.353887f,
  -0.219925f, 0.260515f,  1.157034f,   -2.992044f, -0.097618f, -0.064417f,
  -0.203626f, -0.008217f, -0.112339f,  -0.227407f, -0.155118f, 0.247705f,
  -0.012304f, -0.248447f, -0.913463f,  -0.064788f, -0.214619f, -0.251761f,
  -0.386861f, -0.040574f, -0.163219f,  -0.100700f, 1.488274f,  -0.071684f,
  -0.033626f, -0.006497f, -0.246945f,  -0.145221f, -3.747390f, 0.149609f,
  -0.263326f, -0.297385f, -1.039896f,  -0.083174f, -0.025473f, -0.235586f,
  -0.001087f, 0.254286f,  0.265106f,   0.007325f,  0.199239f,  0.134103f,
  -0.578211f, -0.259801f, -0.062373f,  2.368348f,  0.560556f,  -0.252260f,
  0.889997f,  -0.447872f, -0.059218f,  -0.095315f, -0.061667f, 0.183580f,
  -0.157479f, 0.055387f,  -0.831734f,  0.007606f,  -1.104906f, 0.301180f,
  -0.117115f, 0.212959f,  4.727223f,   -0.243833f, -0.397495f, -0.025021f,
  -0.367587f, -2.082058f, -0.217699f,  0.148111f,  0.252430f,  0.111088f,
  -0.260692f, 0.095124f,  -0.407774f,  -0.322169f, 0.002927f,  0.126169f,
  -1.272325f, -0.279772f, -0.373680f,  -0.485177f, -0.605458f, 0.021225f,
  -0.092031f, -0.226585f, 1.895162f,   0.037866f,  -0.275475f, 1.614360f,
  -0.014972f, -0.277679f, -3.449082f,  -0.092060f, -0.747873f, 0.020716f,
  2.776178f,  -0.049963f, 0.183999f,   -0.295259f, -0.028868f, 0.221895f,
  0.001265f,  0.336823f,  0.219372f,   0.112824f,  0.408132f,  -0.017940f,
  -0.311666f, 1.489606f,  -0.058093f,  -0.305659f, -0.491933f, -0.143847f,
  0.166115f,  0.042867f,  -0.123447f,  -0.087099f, -0.305395f, -0.365079f,
  -0.755801f, -0.160649f, 0.736260f,   -0.008611f, 0.095836f,  -0.017345f,
  5.697515f,  -0.498971f, -0.125280f,  0.199907f,  0.300053f,  0.605026f,
  -0.228225f, -0.259523f, 0.016384f,   0.146973f,  0.210258f,  0.226766f,
  -0.075178f, -0.050924f, 0.188496f,   -0.415266f, -0.484880f, -0.236384f,
  0.071931f,  -0.331863f, -0.601243f,  -0.232479f, -0.285272f, 0.123789f,
  -1.341333f, 0.037082f,  -0.315202f,  -1.587215f, -0.271576f, 0.003216f,
  -4.437186f, -0.256205f, -0.576589f,  -0.114147f, 2.153916f,  -0.369618f,
  0.271415f,  0.145036f,  -0.158731f,  -0.240938f, -0.187369f, 0.036325f,
  0.254771f,  0.211488f,  -0.240297f,  0.098417f,  -0.415011f, 2.334793f,
  -0.127252f, 0.020069f,  -0.168755f,  -0.448922f, -0.219207f, 0.016232f,
  -0.221935f, -0.269500f, -0.100636f,  0.102545f,  -0.809376f, -0.054979f,
  0.360713f,  -0.326541f, 0.112933f,   0.138073f,  4.229404f,  -0.763801f,
  -0.305429f, 0.199955f,  -1.787713f,  0.272866f,  0.109895f,  0.138466f,
  -0.250259f, -0.167162f, -0.212588f,  -0.217589f, -0.067125f, -0.077490f,
  -0.208970f, -0.006863f, -0.671146f,  -0.298320f, -0.165509f, 0.044597f,
  -1.408624f, -0.213957f, -0.220947f,  0.129718f,  1.316777f,  -0.098928f,
  -0.008121f, -0.558293f, -0.297290f,  -0.218873f, -4.346638f, -0.228174f,
  -0.204710f, -0.388864f, 2.697919f,   0.025260f,  0.857020f,  0.009921f,
  0.036915f,  -0.320275f, -0.087937f,  0.022636f,  0.236667f,  0.135496f,
  -0.059616f, -0.192955f, 0.009470f,   2.139589f,  -0.200449f, 0.129818f,
  1.017444f,  -0.608299f, 0.257914f,   -0.134306f, -0.033327f, 0.002855f,
  -0.338598f, 0.015559f,  0.117362f,   -0.166760f, 0.086903f,  -0.167666f,
  0.193523f,  0.033852f,  -1.147686f,  0.489468f,  -0.006969f, 0.125630f,
  1.557907f,  -1.604449f, -0.071114f,  0.096178f,  0.007065f,  0.200013f,
  0.213393f,  0.168466f,  -0.100568f,  -0.117861f, -0.161542f, -0.072561f,
  -1.069871f, -0.470138f, -0.352578f,  -1.503513f, -0.001394f, -0.380109f,
  0.065089f,  -0.281668f, 0.988953f,   -0.002778f, -0.659026f, -0.470692f,
  -0.407292f, 0.011710f,  -1.362085f,  0.184738f,  -0.135786f, -1.374241f,
  4.487930f,  -0.067274f, -0.956404f,  -0.233995f, 0.224527f,  -0.454556f,
  0.037900f,  -0.281658f, 0.208224f,   -0.254753f, 0.045740f,  0.051444f,
  -0.388281f, 0.257112f,  -0.485030f,  -0.082659f, 0.148103f,  -1.007456f,
  -0.022295f, 0.036984f,  -0.369401f,  -0.076943f, -0.007636f, -0.293022f,
  0.470466f,  0.199012f,  -2.158182f,  0.036577f,  -0.014725f, -0.229516f,
  2.236929f,  0.030945f,  -0.400045f,  0.109348f,  0.214691f,  -0.891516f,
  -0.251379f, -0.217358f, 0.013733f,   0.205573f,  -0.151725f, -0.191782f,
  -0.339630f, -0.163905f, -0.119191f,  -0.032516f, 0.503015f,  0.025772f,
  0.029094f,  -1.146153f, 0.216723f,   -0.330023f, 0.064695f,  -0.262521f,
  0.425612f,  -0.093080f, -0.489648f,  1.051293f,  -0.092332f, 0.095557f,
  -0.874132f, 0.218483f,  -0.127648f,  -1.605802f, 2.763617f,  -0.186734f,
  -1.243166f, -0.193514f, -0.173748f,  0.337822f,  0.183873f,  -0.251594f,
  -0.211582f, 0.144081f,  0.029620f,   -0.024853f, -0.385140f, 0.467341f,
  -0.928316f, -0.195442f, 0.917783f,   0.357084f,  0.174445f,  -0.073659f,
  -0.012811f, -0.115420f, -0.181147f,  -0.364449f, -0.567395f, -0.012969f,
  -1.680714f, 0.065323f,  0.198063f,   -0.244201f, 1.428545f,  -0.432539f,
  -0.208931f, -0.091205f, 0.957125f,   0.813519f,  -0.262677f, 0.246852f,
  0.015536f,  0.055026f,  0.067054f,   0.262103f,  -0.358115f, -0.095206f,
  -0.267522f, -0.402710f, -0.680397f,  -0.123627f, -0.385590f, -1.504680f,
  -0.169513f, -0.215338f, 0.043633f,   -0.079052f, -0.464410f, 0.122894f,
  -0.278231f, -2.456445f, -0.159917f,  -0.015597f, -0.735449f, -0.078854f,
  -0.400290f, -1.153870f, 3.657228f,   -0.287093f, -1.174355f, -0.102001f,
  -0.288281f, 0.185209f,  -0.145228f,  -0.200449f, -0.099914f, -0.138354f,
  0.254428f,  -0.161751f, -0.118206f,  0.296043f,  -0.482613f, 0.080932f,
  1.097605f,  -0.010190f, 0.232439f,   0.447617f,  -0.133508f, 0.115763f,
  -0.388589f, 0.174695f,  -0.236014f,  0.006284f,  -1.374129f, 0.092015f,
  -0.241419f, -0.231667f, 2.763950f,   -0.922932f, -0.061605f, 0.208740f,
  -1.597190f, 1.353325f,  -0.198528f,  0.250498f,  -0.013950f, -0.203861f,
  -0.254563f, 0.081931f,  -0.413369f,  0.011844f,  0.080961f,  -0.231161f,
  -1.234909f, -0.440843f, -0.174980f,  -0.315283f, -0.337474f, -0.123243f,
  -0.310001f, -0.271028f, 0.364179f,   0.022845f,  -0.535517f, -0.772936f,
  -0.188435f, 0.039667f,  -0.807463f,  0.266550f,  -0.288857f, -1.630789f,
  1.280155f,  0.065712f,  -0.279960f,  -0.300056f, 0.258440f,  -0.073781f,
  0.213878f,  0.042196f,  0.021360f,   0.211698f,  -0.003751f, -0.192673f,
  -0.137008f, 0.247878f,  -0.470604f,  0.073164f,  1.523241f,  0.734755f,
  -0.114126f, -0.193834f, -0.025759f,  0.263183f,
};

static const float av1_ab_partition_nn_bias_64_layer1[LABEL_SIZE] = {
  -0.343508f, -0.706936f, -0.160676f, -0.877101f, -0.517567f, -0.253254f,
  -0.148074f, 0.923430f,  -0.364770f, 0.203550f,  0.401216f,  0.938246f,
  -0.872737f, 0.718723f,  0.703398f,  2.560015f,
};

static const NN_CONFIG av1_ab_partition_nnconfig_64 = {
  FEATURE_SIZE,  // num_inputs
  LABEL_SIZE,    // num_outputs
  1,             // num_hidden_layers
  {
      64,  // num_hidden_nodes
  },
  {
      av1_ab_partition_nn_weights_64_layer0,
      av1_ab_partition_nn_weights_64_layer1,
  },
  {
      av1_ab_partition_nn_bias_64_layer0,
      av1_ab_partition_nn_bias_64_layer1,
  },
};

// nn model for ab partition pruning, 32x32.
static const float av1_ab_partition_nn_weights_32_layer0[FEATURE_SIZE * 64] = {
  -0.323723f, -0.214013f, -0.007772f, -0.458851f, -0.125542f, -0.123860f,
  -0.410973f, -0.209389f, -0.087580f, -0.272881f, -0.168500f, -1.130845f,
  0.344916f,  -0.475017f, -0.362262f, -0.195662f, -0.566124f, 0.782163f,
  0.411575f,  -0.013378f, -0.318650f, -0.124678f, -0.612909f, -0.315788f,
  -0.263990f, -0.508783f, -0.048938f, -0.416407f, -0.402648f, -0.156644f,
  0.225887f,  -0.000493f, 2.682241f,  0.871204f,  0.059014f,  0.803542f,
  -1.407028f, -1.154669f, 1.388148f,  -0.293348f, -0.003669f, -0.009607f,
  1.330030f,  -0.337841f, 2.118617f,  1.033059f,  -0.084788f, 0.212904f,
  0.082405f,  -0.070579f, -0.494005f, -0.173392f, 0.039546f,  -0.463865f,
  0.077163f,  -0.434066f, 0.030835f,  -0.427139f, -0.560520f, -0.031606f,
  -0.368541f, -0.027458f, 0.370574f,  0.461418f,  1.087682f,  -0.572137f,
  -1.509596f, -0.765697f, -0.499383f, -0.277998f, -0.106492f, -0.129564f,
  -0.169133f, -0.269834f, -0.114270f, -0.275431f, 0.016339f,  -0.156744f,
  -0.267922f, 0.171216f,  0.110556f,  0.002954f,  -0.200327f, -0.187663f,
  3.691601f,  1.234152f,  0.186315f,  -0.125370f, -0.211235f, -0.554432f,
  -0.131072f, -0.124982f, -0.130339f, -0.235350f, 0.018903f,  0.012896f,
  -0.159372f, -0.269571f, -0.025709f, -0.221251f, 0.061919f,  0.016307f,
  0.384673f,  -0.134525f, -1.599126f, -0.416459f, -0.743052f, 0.670249f,
  -0.169709f, 0.421681f,  -0.033360f, -0.072817f, 0.003647f,  -0.110632f,
  -0.158651f, -0.095136f, 0.223759f,  0.165767f,  -0.269129f, -0.196075f,
  -0.023183f, -0.293420f, 0.014875f,  0.018688f,  -0.153407f, -0.172009f,
  -0.259947f, -0.124015f, 0.173653f,  -0.089103f, -0.021001f, -0.334230f,
  0.027177f,  0.103371f,  -0.183860f, -0.204051f, -0.023721f, -0.192297f,
  -0.143771f, -0.247106f, 0.218116f,  -0.013240f, 2.831783f,  1.483928f,
  -0.877025f, -0.313462f, -0.411320f, -0.447825f, 0.605977f,  0.234684f,
  -0.119150f, -0.075182f, -0.330463f, 0.071503f,  -0.254924f, -0.360071f,
  -0.037022f, 0.063261f,  -0.148759f, -0.238254f, -0.462018f, -0.027166f,
  0.065318f,  -0.235743f, -0.257194f, -0.094784f, 0.022423f,  0.055925f,
  0.086672f,  -0.021010f, 0.009965f,  -0.001648f, -0.104917f, -0.387443f,
  -0.102673f, -0.281706f, 0.145923f,  -0.233391f, -0.378365f, -0.145584f,
  -0.077751f, -0.121166f, 1.134565f,  -0.097500f, -0.749202f, -0.544566f,
  -1.361374f, -0.102494f, 1.089275f,  0.375299f,  -0.105091f, 0.037641f,
  -0.054248f, -0.282691f, -0.377797f, -0.066427f, -0.253815f, -0.329677f,
  -0.339326f, -0.128217f, -0.282905f, 0.014937f,  1.067185f,  -0.171764f,
  0.484458f,  0.396706f,  -0.557055f, -0.891596f, -0.257839f, -0.720879f,
  -0.218449f, -0.004755f, 1.572857f,  0.006229f,  1.962895f,  -0.029746f,
  -4.137691f, -2.185991f, -2.763477f, -0.520437f, -0.208708f, 0.006444f,
  -1.263078f, -0.304560f, 1.072374f,  2.556429f,  0.312850f,  0.257488f,
  -0.634264f, 0.156769f,  -0.188943f, 0.040295f,  -0.389915f, 0.085250f,
  -0.248525f, 0.045667f,  -0.776115f, -0.274680f, -0.448145f, -0.566161f,
  -1.285316f, 0.079060f,  0.389124f,  -0.510401f, -0.015299f, -0.664661f,
  0.099901f,  -0.470694f, -0.051593f, -1.076381f, -0.442104f, -0.197867f,
  -0.330011f, -0.448523f, -0.301018f, -0.442093f, -0.491953f, -0.582091f,
  -0.064569f, -0.156516f, 0.543522f,  -0.005924f, 0.161432f,  0.974793f,
  0.273712f,  1.104850f,  -0.290312f, 0.313417f,  -0.125370f, 0.136234f,
  -0.191227f, -0.165054f, 0.011872f,  -0.298871f, 0.095740f,  0.142760f,
  -0.215771f, -0.031437f, 0.101041f,  -0.085620f, 0.435387f,  0.002786f,
  1.971375f,  0.018392f,  -1.771940f, -0.401433f, 0.808263f,  -3.350013f,
  2.296952f,  -1.024403f, -0.041645f, -0.034799f, -0.024078f, -0.347301f,
  -0.276088f, -0.455907f, 0.266021f,  0.087348f,  -0.146566f, 0.040492f,
  -0.539866f, -0.206851f, -0.387874f, -0.125508f, -0.496676f, -0.373845f,
  -0.472356f, -0.357082f, -0.081254f, -0.456466f, 0.554713f,  0.002185f,
  -4.225019f, 0.344025f,  0.728796f,  -0.262936f, 1.383924f,  1.577300f,
  -2.653320f, -2.516156f, -0.301604f, -0.204105f, -0.138252f, -0.587536f,
  -0.097889f, -0.352414f, -0.288276f, -0.184340f, -0.122741f, -0.243376f,
  0.031970f,  -0.373402f, -0.396079f, 0.045566f,  0.072595f,  -0.222681f,
  -0.243802f, -0.340129f, -0.258494f, -0.192041f, -0.386112f, -0.240940f,
  -0.047268f, -0.555802f, -0.032514f, -0.241341f, -0.167463f, -0.478308f,
  -0.205936f, -0.316275f, 0.103729f,  -0.197893f, -0.128029f, -0.218796f,
  -0.167362f, -0.111814f, -0.126062f, -0.394260f, -0.025357f, -0.402697f,
  -0.587395f, -0.400385f, -0.259664f, -0.415588f, -0.338503f, -0.399166f,
  -0.270504f, 0.234505f,  0.272144f,  0.266938f,  -0.392395f, -0.011717f,
  -0.384221f, -0.473446f, -0.038420f, -0.241101f, -0.234402f, -0.275567f,
  -0.410454f, -0.377599f, -0.179099f, -0.138432f, -0.248083f, -0.543026f,
  -0.428043f, -0.239895f, -0.333193f, -0.103346f, -0.039038f, -0.171109f,
  -0.119432f, -0.222351f, 0.000450f,  0.208724f,  -0.510526f, -0.144656f,
  -0.316721f, -0.344846f, -0.244794f, -0.129134f, -0.045634f, -0.400183f,
  0.043714f,  -0.235414f, 0.115594f,  -0.195616f, -0.106693f, -0.124242f,
  0.083990f,  0.049110f,  -0.196130f, -0.059860f, -0.464235f, -0.516443f,
  -0.101521f, -0.422379f, -0.413955f, -0.042991f, -0.345263f, -0.129264f,
  -0.106911f, -0.140156f, -0.457841f, -0.199848f, -0.218954f, -0.329850f,
  -0.364097f, -0.335262f, -0.312254f, -0.299331f, -0.052710f, -0.251019f,
  -0.023459f, -0.222538f, 0.028849f,  -0.088038f, -0.301550f, -0.273566f,
  0.067295f,  -0.174608f, -0.445784f, -0.158366f, -0.567275f, -0.557652f,
  -0.353503f, -0.302092f, -0.302049f, -0.551793f, -0.034535f, -0.225190f,
  -0.210733f, -0.219377f, -0.057197f, -0.430933f, -0.025185f, -0.388150f,
  -0.086147f, -0.430088f, 0.058466f,  -0.152129f, -0.058411f, -0.236392f,
  -0.547669f, -0.613849f, -0.893774f, -0.351715f, -0.399227f, -0.454909f,
  -0.324501f, 0.000490f,  -0.282167f, -0.073163f, -0.281452f, 0.047932f,
  -0.175500f, 0.165220f,  -0.276212f, 0.062153f,  -0.217054f, -0.255487f,
  -0.146416f, -0.097718f, -0.173809f, -0.559328f, -0.055695f, -0.391193f,
  -0.132020f, -0.561184f, -0.308666f, -0.474053f, -0.219149f, -0.246558f,
  -0.158325f, 0.151907f,  -0.266835f, -0.144697f, -0.193960f, -0.046587f,
  -0.220028f, -0.247355f, 0.135584f,  0.016511f,  0.367705f,  -1.855877f,
  0.435622f,  0.444710f,  -3.372301f, -3.030489f, 1.013267f,  0.380951f,
  -0.170011f, -0.111415f, -0.456146f, -0.107254f, -0.095220f, -0.053078f,
  -0.135864f, -0.591949f, -0.252810f, -0.324799f, -0.094796f, -0.260969f,
  -0.391981f, -0.063170f, -0.336130f, -0.470127f, -0.405168f, -0.433219f,
  -0.309563f, -0.295462f, -0.552270f, -0.012300f, -0.057793f, -0.034494f,
  -0.446843f, -0.640160f, -1.188681f, -0.791361f, 0.543271f,  1.189112f,
  1.458468f,  -0.005876f, -0.927475f, 0.062038f,  -1.170818f, 0.338227f,
  -3.007096f, -4.559296f, -4.045457f, -5.953635f, -0.228386f, -0.266890f,
  -0.092595f, -0.377440f, -0.044534f, -0.053565f, -0.349268f, -0.415030f,
  -0.310094f, 0.062721f,  0.251422f,  -0.014350f, -1.282910f, 1.619560f,
  1.180566f,  -0.032163f, -1.322951f, -0.603601f, 1.443710f,  0.654650f,
  -0.393227f, 0.003536f,  0.029725f,  -0.108925f, -0.053911f, 0.133977f,
  -0.036145f, -0.168438f, 0.046989f,  -0.331463f, -0.176983f, -0.311922f,
  -0.272389f, -0.379592f, -0.399993f, -0.297873f, -0.193425f, -0.177524f,
  -0.258309f, -0.567312f, -0.260217f, -0.241869f, 0.024010f,  -0.032867f,
  -0.039424f, -0.063670f, 0.193808f,  -0.303514f, -0.013376f, -0.057761f,
  0.187922f,  0.006938f,  0.031810f,  0.180594f,  -1.198427f, 2.820662f,
  0.154986f,  -0.375518f, 0.116925f,  -0.795782f, -0.085139f, -0.079365f,
  -0.197936f, -0.321468f, -0.205271f, -0.558203f, -0.296235f, -0.151193f,
  -0.158282f, -0.245402f, -0.208504f, -0.042335f, -0.087426f, -0.557129f,
  -0.381427f, -0.441551f, -0.541011f, -0.060567f, -0.469305f, -0.032326f,
  -2.453587f, -0.045568f, -0.296932f, 0.613061f,  -0.320284f, 0.191620f,
  -0.827145f, -0.225277f, 0.275800f,  1.696635f,
};

static const float av1_ab_partition_nn_bias_32_layer0[64] = {
  -0.176206f, 0.660189f,  -0.186156f, -2.481963f, -1.564218f, -0.280424f,
  0.732684f,  -0.135581f, -2.193132f, -0.172771f, 0.605001f,  -0.060392f,
  -0.067190f, -0.132969f, -1.410812f, -0.298701f, -0.105963f, -0.086173f,
  0.632779f,  0.005585f,  1.310169f,  1.392136f,  -0.563860f, -0.051053f,
  0.660998f,  -0.214726f, -1.894342f, -0.128288f, -0.330721f, -0.053988f,
  -0.177726f, 1.200859f,  -0.178902f, -0.172620f, -0.184476f, -0.175559f,
  0.538503f,  -0.322158f, -0.219080f, -0.058208f, -0.171347f, -0.216060f,
  -0.174950f, -0.295740f, -0.184820f, -0.213896f, 1.317728f,  -0.020116f,
  -0.208096f, 0.000000f,  1.246166f,  -0.225421f, -0.181555f, 0.861761f,
  1.172429f,  -0.172892f, -0.737092f, -0.189904f, -0.179385f, -0.114618f,
  -1.384604f, -0.201713f, -0.271948f, 0.372351f,
};

static const float av1_ab_partition_nn_weights_32_layer1[64 * 16] = {
  -0.037828f,  1.529029f,  0.004927f,  1.475763f,  0.627172f,  0.325872f,
  -0.990757f,  0.129476f,  0.889958f,  -0.082031f, 0.332133f,  0.074422f,
  -0.176212f,  -0.074355f, 0.774378f,  0.110987f,  -0.155469f, 0.253310f,
  0.882538f,   0.253605f,  0.332436f,  -5.389474f, 0.278470f,  0.168644f,
  0.914611f,   0.154165f,  0.809262f,  -0.174734f, 0.923673f,  0.064716f,
  -0.070228f,  -0.228735f, 0.002312f,  0.112222f,  -0.045502f, -0.046004f,
  0.514101f,   0.306480f,  0.021232f,  -0.015955f, -0.288260f, 0.189177f,
  -0.104158f,  0.103273f,  0.096910f,  -0.086328f, 1.327289f,  -0.154247f,
  0.056676f,   -0.243327f, -0.646676f, 0.177221f,  -0.086761f, 0.729729f,
  -14.710893f, -0.044881f, 0.339003f,  -0.134737f, 0.073621f,  -0.162913f,
  1.215237f,   0.140723f,  0.138630f,  1.241719f,  0.204092f,  -0.463080f,
  -0.176086f,  1.125868f,  1.034814f,  0.225455f,  -0.203421f, -0.078787f,
  -0.527498f,  0.012491f,  -0.563307f, -0.170792f, 0.002679f,  0.116153f,
  0.211348f,   -0.191900f, -0.212505f, 0.263445f,  -0.074679f, -0.081441f,
  -0.815405f,  2.448215f,  0.781299f,  0.149542f,  -1.045162f, 0.043014f,
  0.217381f,   -0.094500f, -0.090427f, 0.025784f,  -0.228906f, -2.741798f,
  0.230475f,   -0.256112f, -0.103297f, 0.159121f,  -0.229793f, -0.014883f,
  -0.104131f,  -0.123816f, 0.164148f,  -0.052279f, -0.071845f, -0.041197f,
  0.208527f,   -0.234197f, -0.542336f, 0.020053f,  0.088870f,  0.014346f,
  2.502164f,   -0.010244f, -0.267792f, 0.844394f,  2.711486f,  -0.015262f,
  -0.868053f,  -0.295704f, 0.222289f,  -0.000286f, -0.352098f, -0.079000f,
  0.021267f,   -0.721739f, -0.240558f, -0.384775f, 0.065974f,  -2.161058f,
  0.195889f,   0.268966f,  -0.009329f, 0.014949f,  0.314943f,  0.235885f,
  0.072591f,   -0.127120f, 0.150784f,  0.105697f,  -1.297403f, -0.207509f,
  -0.217688f,  -0.076752f, 0.170952f,  -0.294235f, 0.449973f,  -1.712690f,
  0.860989f,   0.054757f,  -0.812627f, -0.105316f, -0.736230f, -0.133192f,
  -3.741608f,  0.495660f,  -0.288936f, 4.654852f,  -0.021305f, -0.308916f,
  0.049205f,   -0.259996f, 0.114248f,  -0.252647f, -0.253180f, -0.449314f,
  0.022979f,   0.063281f,  -0.196154f, 0.078295f,  -0.322317f, -0.145142f,
  0.300573f,   0.048385f,  -0.254787f, 0.123939f,  -1.263088f, -0.228565f,
  -0.389061f,  0.391084f,  2.322438f,  0.075009f,  0.225743f,  -0.198808f,
  -0.280538f,  -0.173939f, -0.120543f, -0.070792f, -0.417187f, -0.781056f,
  -0.102756f,  -1.760965f, 0.019149f,  -0.867342f, 0.347141f,  0.031588f,
  0.302572f,   -0.203573f, -0.357320f, -0.096078f, -0.527528f, 0.046699f,
  -0.108561f,  -0.167077f, -2.851509f, -0.307116f, 0.202720f,  -0.160280f,
  -0.215525f,  0.064355f,  -0.427220f, 1.516230f,  0.634453f,  0.099400f,
  -1.013887f,  -0.029740f, -0.093426f, -0.044272f, -1.297636f, -0.237614f,
  -0.160953f,  0.399036f,  -0.030685f, -0.113619f, -0.184704f, 0.040519f,
  -0.588252f,  -0.210235f, -0.067623f, -0.031841f, -0.107261f, -0.192582f,
  -0.253959f,  -0.430821f, -0.103184f, -0.280185f, -0.357723f, 0.197761f,
  -0.175087f,  -0.055171f, 1.642014f,  -0.192559f, -0.288147f, 0.610311f,
  4.688195f,   -0.128728f, -0.914869f, -0.108286f, 0.013789f,  0.092125f,
  0.019770f,   -0.178386f, 0.074164f,  -1.152658f, -0.216738f, -0.277286f,
  0.012381f,   0.418259f,  -0.680727f, -0.221917f, -0.485946f, 0.101672f,
  2.009457f,   0.054302f,  1.019838f,  -0.116170f, 0.165134f,  -0.112567f,
  0.852632f,   -0.385796f, -0.108666f, 0.053181f,  -0.311797f, -0.372875f,
  -0.675717f,  2.409268f,  -0.514720f, -0.214245f, -0.646596f, 0.009756f,
  0.203993f,   0.093617f,  -0.301290f, 0.253551f,  -0.128909f, -1.448442f,
  -0.186823f,  -0.278001f, -0.294993f, -0.176928f, -0.473605f, 0.062049f,
  -0.212084f,  -0.137326f, 0.012505f,  0.087850f,  -0.200413f, -0.394119f,
  -0.132224f,  0.146917f,  0.155746f,  0.198725f,  -0.322541f, 0.196391f,
  -0.945500f,  0.036736f,  -0.155646f, -0.677341f, 1.130545f,  -0.339554f,
  0.411628f,   -0.355813f, -0.249843f, 0.213694f,  -2.035607f, 0.055694f,
  -0.111669f,  0.408696f,  -0.067043f, -0.048182f, 0.398110f,  -0.067542f,
  1.459801f,   0.236833f,  -0.178806f, 0.168758f,  0.492387f,  0.099691f,
  -0.776680f,  -0.172865f, 0.204225f,  0.193982f,  0.575685f,  -0.062248f,
  0.011486f,   0.058571f,  -0.493391f, 0.026893f,  -0.900467f, 3.793129f,
  -0.634613f,  -0.064660f, -0.048262f, 0.361905f,  0.033641f,  0.245171f,
  -0.064671f,  0.034954f,  0.204358f,  -0.904023f, -0.052714f, -0.250134f,
  0.136700f,   0.000734f,  -0.371720f, 0.226483f,  0.217958f,  0.060559f,
  0.180111f,   0.000970f,  0.079556f,  -0.096775f, 0.093855f,  -0.026224f,
  -0.243664f,  0.004290f,  0.123281f,  -0.239476f, 1.230374f,  -0.107826f,
  -0.101982f,  -0.153917f, 5.464427f,  0.304375f,  -0.809957f, 0.090564f,
  -0.278416f,  -0.245555f, -2.078421f, 0.243093f,  -0.127666f, 0.052451f,
  -0.126662f,  -0.783505f, 0.025149f,  -1.422675f, -0.207769f, -0.362547f,
  0.115310f,   0.133390f,  1.264754f,  -0.027055f, -0.485312f, -0.240717f,
  -0.239722f,  0.146818f,  -1.265043f, -0.235553f, 0.267104f,  -0.021357f,
  -0.435949f,  -0.309371f, 0.049920f,  1.302721f,  -0.233978f, -0.097551f,
  -0.240631f,  -0.287821f, -0.378380f, -0.273131f, -3.075169f, 0.226404f,
  -0.029361f,  2.703590f,  -0.430659f, 0.067927f,  -0.387520f, -0.370630f,
  -0.229236f,  0.085653f,  -0.370956f, -0.065556f, -0.187859f, 0.068309f,
  -0.109299f,  -0.259898f, -0.103644f, -0.271199f, -0.209350f, 0.140993f,
  -0.196713f,  -0.135508f, -1.423209f, -0.406385f, -0.019956f, -0.864694f,
  5.963707f,   -0.201157f, 0.726377f,  -0.011076f, 0.010553f,  -0.102918f,
  -2.230088f,  -0.258098f, -0.039547f, -0.029262f, -0.082324f, -0.860222f,
  -0.094735f,  -1.381839f, 0.587298f,  -0.173048f, 0.721360f,  0.241900f,
  0.764302f,   -0.023609f, -1.173755f, 0.103912f,  -0.185363f, 0.078435f,
  -2.245062f,  -0.127269f, 0.202234f,  0.158975f,  -0.260909f, 0.098608f,
  -0.348247f,  1.732502f,  -0.412298f, -0.269602f, -0.425771f, -0.146243f,
  -0.530730f,  0.125716f,  -1.004419f, 0.145109f,  -0.059289f, 1.096304f,
  0.012891f,   0.045033f,  -0.306875f, 0.003514f,  -0.176110f, 0.037544f,
  -0.441537f,  -0.518921f, -0.262149f, -0.060407f, -0.379419f, -0.141245f,
  -0.128894f,  -0.176537f, -1.161318f, -0.249100f, -0.118330f, 0.042816f,
  1.173404f,   0.088312f,  -0.393568f, -0.175134f, 6.529819f,  -0.326652f,
  -0.631917f,  -0.393476f, 0.057781f,  -0.217748f, -1.781139f, -0.012614f,
  -0.212621f,  -0.720322f, -0.218498f, -0.388556f, -0.254796f, -0.248399f,
  -0.608744f,  -0.265146f, 0.238517f,  0.066882f,  -2.916806f, 0.054642f,
  0.282590f,   0.075248f,  0.010188f,  -0.133486f, 0.985945f,  -0.045849f,
  -0.347564f,  0.057320f,  -0.417920f, 0.063664f,  0.387062f,  -2.692059f,
  -0.535549f,  0.263736f,  0.327889f,  -0.070273f, -0.775254f, 0.147250f,
  3.309425f,   -0.212191f, -0.067204f, -2.912663f, -0.061496f, 0.084233f,
  0.022907f,   0.138421f,  -0.112159f, -0.288447f, -0.010799f, 0.056049f,
  -0.036527f,  0.021525f,  0.106649f,  -0.291883f, 0.088424f,  -0.057773f,
  -0.086031f,  0.015277f,  -0.318505f, -0.269049f, -1.008913f, -0.224785f,
  -0.025820f,  -0.649037f, 0.706381f,  0.096410f,  0.643776f,  -0.046743f,
  -0.009654f,  -0.024246f, 1.469255f,  -0.183536f, -0.370046f, -0.048442f,
  -0.376527f,  -0.431264f, -0.245109f, -0.093951f, 0.203683f,  -0.099872f,
  0.087210f,   0.160692f,  -3.527694f, -0.068891f, -0.228994f, -0.231817f,
  -0.241949f,  0.193613f,  0.979597f,  -0.091259f, 0.414424f,  -0.047341f,
  -0.209582f,  -0.295134f, -0.016824f, 0.460327f,  -0.072671f, 0.246234f,
  0.235896f,   0.127238f,  -1.068683f, 0.035648f,  2.254888f,  0.180105f,
  -0.260098f,  -2.322120f, -0.184249f, -0.314801f, -0.099969f, -0.272117f,
  -0.237916f,  0.031103f,  -0.274063f, -0.049384f, -0.044917f, 0.102477f,
  -0.342148f,  -0.257558f, -0.346300f, 0.115333f,  -0.115456f, 0.208354f,
  -0.359301f,  -0.167395f, 1.146514f,  -0.177861f, -0.098658f, -0.444570f,
  6.759993f,   -0.369772f, -0.831118f, 0.001866f,  -0.073298f, -0.072095f,
  0.811902f,   -0.431997f, -0.286587f, -0.269500f, 0.111492f,  -0.525364f,
  -0.351785f,  -2.463474f, -1.852659f, 0.135325f,  0.138267f,  0.100643f,
  -2.373278f,  -0.285514f, -0.395388f, -0.185016f, -0.030249f, -0.005767f,
  -0.716424f,  -0.031674f, 0.011147f,  0.057405f,  -0.215873f, -0.094401f,
  0.573528f,   -1.223820f, 0.414852f,  -0.059053f, -0.076488f, -0.287168f,
  -0.842640f,  0.174084f,  -0.567186f, 0.336629f,  -0.062514f, 2.075448f,
  -0.061680f,  -0.131529f, -0.098994f, -0.204111f, -0.347865f, 0.108516f,
  -0.049616f,  -0.069212f, -0.273935f, -0.096545f, -0.210784f, -0.284698f,
  0.141501f,   -0.176924f, -0.361341f, -0.251197f, -0.286694f, 0.245569f,
  -1.521661f,  -0.122639f, -0.015760f, -0.718912f, 5.877828f,  0.146916f,
  0.151767f,   0.220785f,  -0.032298f, 0.230902f,  0.663943f,  -0.252613f,
  0.057718f,   -0.436038f, -0.323994f, -1.139787f, -0.042489f, -1.326298f,
  -1.031206f,  -0.104136f, 0.389897f,  0.127602f,  -2.667789f, -0.212366f,
  -0.506262f,  -0.009115f, -0.213202f, 0.076167f,  -1.629405f, 0.055129f,
  0.375393f,   -0.150272f, -0.241515f, -0.326497f, 0.100069f,  0.410703f,
  0.340622f,   0.042437f,  -0.349945f, 0.041176f,  -1.178950f, 0.030992f,
  0.933908f,   -0.035844f, -0.098660f, 1.030584f,  -0.092043f, -0.355739f,
  -0.305562f,  0.036161f,  -0.049558f, -0.033225f, -0.403856f, -0.088276f,
  0.215493f,   -0.149105f, -0.013363f, 0.025886f,  -0.101306f, -0.205781f,
  -1.072487f,  -0.076019f, 0.077555f,  0.131003f,  1.267763f,  -0.008954f,
  -0.327617f,  -0.246539f, 6.664081f,  -0.404403f, -1.442489f, 0.191301f,
  -0.336361f,  0.181156f,  0.833108f,  0.007879f,  -0.194464f, -1.029408f,
  -0.036268f,  -0.927110f, -0.379190f, -0.293443f, -1.848579f, -0.242548f,
  -0.065990f,  0.203160f,  -0.291788f, 0.000680f,  0.587011f,  -0.241289f,
  0.037034f,   0.000552f,  1.072308f,  -0.387230f, -0.230050f, 0.292322f,
  -0.720001f,  0.034109f,  -0.467260f, 2.211644f,  -1.839191f, -0.048797f,
  -0.083469f,  -0.334686f, -0.269056f, 0.051295f,  1.319904f,  -0.035603f,
  -0.018457f,  -0.824915f, -0.212285f, -0.230516f, -0.035093f, -0.400843f,
  -0.305469f,  -0.099011f, 0.014225f,  -0.452772f, 0.170331f,  -0.389312f,
  -0.115084f,  -0.014770f, -0.429387f, -0.155961f, -0.568200f, -0.037853f,
  -0.125137f,  0.067228f,  -1.329271f, -0.117874f, -0.132499f, -0.218376f,
  -0.588325f,  -0.320024f, 0.085695f,  -0.235047f, -0.217790f, 0.103015f,
  -0.698644f,  0.017766f,  -0.058299f, 0.199411f,  -0.122485f, -0.563949f,
  -0.349011f,  -0.557045f, -0.131165f, 0.002281f,  0.118559f,  -0.210302f,
  -1.153815f,  0.116738f,  -0.236007f, -0.003487f, -0.006885f, -0.244816f,
  0.953222f,   0.093748f,  0.266869f,  0.241869f,  -0.860832f, -0.387012f,
  -0.338986f,  2.097515f,  -1.942512f, -0.298021f, 0.543911f,  -0.043214f,
  0.082125f,   -0.120242f, 0.712231f,  0.213327f,  -0.301687f, -0.544011f,
  -0.392131f,  0.004302f,  0.004825f,  -0.317440f, -0.107518f, -0.293407f,
  -0.159111f,  -0.080367f, 0.132663f,  -0.017726f, -0.237521f, -0.190297f,
  -0.361633f,  0.200518f,  -0.538296f, -0.027975f, -0.381704f, -0.016963f,
  0.630105f,   -0.190997f, -0.287840f, -0.603488f, 3.605598f,  -0.276614f,
  -1.346383f,  0.186912f,  -0.047575f, -0.189232f, -1.519072f, 0.097816f,
  -0.223722f,  0.304924f,  -0.213022f, -1.052433f, -0.322283f, -1.706734f,
  -2.458027f,  0.237976f,  0.171050f,  -0.103139f, -0.278689f, 0.329824f,
  -0.262448f,  -0.122916f, -0.236398f, -0.013848f, -0.969160f, -0.374907f,
  0.091018f,   -0.386471f, -0.723940f, 0.064956f,  -0.057652f, 1.321024f,
  -1.397418f,  -0.143136f, 0.272468f,  -0.030749f, 0.037324f,  0.069316f,
  -0.904925f,  -0.333693f, -0.117709f, 2.279598f,  -0.428065f, -0.131157f,
  -0.014288f,  -0.402862f, -0.666090f, 0.017070f,  -0.028333f, 0.002481f,
  0.197156f,   -0.038120f, -0.271062f, -0.188275f, -0.021370f, -0.070849f,
  -0.905007f,  -0.095886f, -0.093055f, -0.121821f, -1.239812f, -0.411799f,
  -0.089948f,  -0.936827f, 1.437569f,  -0.388908f, 0.126170f,  0.186162f,
  -0.018819f,  -0.138364f, -1.066412f, -0.138222f, -0.022186f, 0.107331f,
  -0.230436f,  -1.352605f, -0.161323f, -1.081810f, -0.933825f, -0.136675f,
  0.378157f,   0.113377f,  -0.850610f, 0.080245f,  -0.087305f, -0.002852f,
  0.044408f,   -0.188172f, -1.891998f, 0.092189f,  0.125325f,  -0.105090f,
  -0.848510f,  -0.396308f, -0.384130f, 2.007509f,  -1.480787f, -0.126946f,
  0.314767f,   0.000195f,  -0.285628f, -0.110442f, -0.293948f, 0.258559f,
  -0.417603f,  1.570705f,  0.092459f,  -0.340974f, -0.284754f, -0.007801f,
  -0.324610f,  -0.004734f, -0.207716f, -0.057175f, 0.055467f,  -0.210830f,
  -0.113005f,  -0.299177f, 0.068074f,  0.017929f,  -2.897598f, -0.260074f,
  -0.014422f,  -0.206467f, 1.246997f,  -0.372863f, -0.214160f, -0.114035f,
  5.805862f,   0.003611f,  -1.340990f, -0.021085f, -0.260431f, -0.002720f,
  -1.251640f,  -0.353531f, -0.304009f, -0.153376f,
};

static const float av1_ab_partition_nn_bias_32_layer1[LABEL_SIZE] = {
  -0.521497f, -1.061572f, -0.078756f, -0.660662f, -0.403741f, -0.960163f,
  0.001427f,  0.523607f,  0.225068f,  -0.055273f, 1.019519f,  1.181880f,
  -0.010198f, 0.130597f,  1.276752f,  2.028188f,
};

static const NN_CONFIG av1_ab_partition_nnconfig_32 = {
  FEATURE_SIZE,  // num_inputs
  LABEL_SIZE,    // num_outputs
  1,             // num_hidden_layers
  {
      64,  // num_hidden_nodes
  },
  {
      av1_ab_partition_nn_weights_32_layer0,
      av1_ab_partition_nn_weights_32_layer1,
  },
  {
      av1_ab_partition_nn_bias_32_layer0,
      av1_ab_partition_nn_bias_32_layer1,
  },
};

// nn model for ab partition pruning, 16x16.
static const float av1_ab_partition_nn_weights_16_layer0[FEATURE_SIZE * 64] = {
  0.151902f,  0.007947f,  -1.788454f, 0.431869f,  -2.971387f, 0.923566f,
  1.632542f,  -1.665136f, -0.338632f, -5.075884f, 0.398267f,  0.030467f,
  2.263534f,  -0.045532f, -1.066128f, 0.915139f,  -0.560500f, -3.293125f,
  2.072793f,  -1.011414f, 0.122716f,  -0.060169f, -0.388860f, 0.031019f,
  -0.381861f, 0.001551f,  -0.328472f, 0.038296f,  -0.060398f, -0.375556f,
  0.209226f,  0.014764f,  -1.443469f, -0.345486f, 2.409269f,  1.524846f,
  -0.640666f, 1.322139f,  -2.074771f, -0.580944f, -0.203960f, -0.072893f,
  0.329701f,  0.115339f,  -1.339542f, 0.249024f,  -0.421545f, -0.409151f,
  -0.258293f, 0.836288f,  -0.073685f, -0.009624f, 0.895712f,  0.320639f,
  0.451002f,  -1.544558f, 0.193709f,  -1.389012f, 1.305451f,  0.089795f,
  0.050338f,  -0.017433f, -0.304667f, 0.500729f,  0.504346f,  0.073757f,
  0.582649f,  -0.993623f, 1.766766f,  -3.067265f, -0.415774f, -0.006036f,
  -1.245281f, 0.253205f,  -0.591245f, -0.626238f, 0.551852f,  0.593755f,
  0.491023f,  1.099384f,  -0.348448f, 0.054564f,  -0.451422f, -0.375781f,
  -0.248390f, -0.052548f, -0.380069f, -0.165391f, -0.297968f, -0.052142f,
  -0.316381f, -0.045246f, -0.243905f, -0.034169f, -0.247523f, -0.180773f,
  0.068066f,  -0.374920f, 0.057536f,  -0.189748f, 0.058375f,  -0.267749f,
  -0.147286f, -0.246153f, 0.006183f,  -0.202029f, -0.059128f, 0.116852f,
  0.134719f,  -0.126900f, -0.064646f, -0.196458f, -0.182331f, 0.108029f,
  -0.264499f, 0.155816f,  -0.107255f, -0.056983f, -0.209771f, -0.099070f,
  0.007313f,  -0.254124f, -0.231964f, -0.275972f, 0.032098f,  -0.264564f,
  -0.208743f, 0.155599f,  -0.121511f, -0.156145f, -0.162315f, -0.059788f,
  -0.257073f, -0.076654f, -0.110616f, -0.321675f, -0.051952f, 0.006301f,
  -0.154114f, 0.017032f,  -0.017364f, -0.233247f, 0.009918f,  -0.179289f,
  -0.190722f, 0.147106f,  -0.063910f, -0.396872f, -0.263123f, -0.003850f,
  -0.040718f, -0.324699f, 0.118660f,  -0.170727f, -0.316788f, 0.100886f,
  -0.202842f, 0.045371f,  0.150561f,  -0.057054f, -0.308150f, 0.028346f,
  -0.381473f, -0.195365f, 0.026221f,  -0.281795f, 0.087204f,  0.047689f,
  -0.027643f, -0.104724f, -0.089030f, -0.117661f, -0.349160f, 0.056982f,
  -0.340273f, 0.048086f,  0.046103f,  -0.121527f, 0.021697f,  0.054109f,
  -0.002768f, -0.008461f, -2.297240f, 0.124651f,  3.621661f,  -0.057120f,
  -1.151656f, 2.296894f,  -3.678720f, -0.290240f, 0.087683f,  -0.186389f,
  0.007656f,  -0.090236f, -0.245217f, 0.110389f,  -0.251719f, -0.029084f,
  -0.128203f, -0.100005f, -0.032779f, 0.007281f,  -0.366596f, -0.267870f,
  -0.215620f, 0.047687f,  0.010303f,  0.097980f,  -0.191569f, -0.341162f,
  0.119249f,  0.026279f,  -2.161546f, 0.459591f,  1.290566f,  1.791797f,
  -0.409835f, 0.127081f,  -1.156367f, 0.198286f,  0.099561f,  -0.067445f,
  -0.034352f, 0.017966f,  -0.277380f, -0.057220f, -0.174198f, -0.014164f,
  0.146090f,  -0.357530f, 0.097644f,  -0.000932f, 0.446603f,  -0.066793f,
  2.448620f,  0.937617f,  -1.232922f, 0.313183f,  0.816827f,  -0.275115f,
  -0.245205f, -0.126895f, 0.156668f,  -0.186977f, -0.273505f, 0.013315f,
  0.168629f,  -0.089084f, 0.006166f,  -0.116107f, -0.199316f, -0.024010f,
  -0.242303f, 0.011612f,  -0.218485f, -0.229661f, -0.123922f, 0.136699f,
  0.006732f,  -0.148718f, -0.164225f, 0.116063f,  1.587898f,  0.690519f,
  0.360566f,  0.009739f,  -0.678702f, -0.046003f, 0.126984f,  0.605212f,
  1.240663f,  -0.000228f, -1.119369f, -0.415589f, -0.721003f, 0.097936f,
  -1.410586f, -2.358833f, -2.773129f, -3.983361f, -0.087144f, -0.050029f,
  -0.242255f, 0.137424f,  -0.307490f, -0.084637f, -0.023812f, -0.196582f,
  -0.078695f, 0.038257f,  -0.012110f, -0.263521f, 0.009839f,  -0.109125f,
  -0.226036f, 0.060712f,  0.093671f,  0.153143f,  0.039116f,  -0.290891f,
  0.227057f,  -0.204633f, -0.207539f, -0.148242f, 0.046204f,  -0.231268f,
  -0.209315f, -0.307579f, -0.436556f, 0.023475f,  0.131793f,  -0.038301f,
  1.650584f,  0.392570f,  1.446576f,  1.254380f,  -0.516867f, -0.057116f,
  0.149320f,  0.414424f,  -0.246309f, 0.003877f,  -0.480238f, -1.037035f,
  -0.830779f, -1.122244f, -0.408267f, -0.253956f, 0.382005f,  0.940609f,
  -1.113370f, -0.018554f, 0.141064f,  -0.182504f, 1.270707f,  0.414904f,
  -0.216036f, 0.203831f,  0.450716f,  -0.452909f, 0.139358f,  -0.027143f,
  1.956892f,  1.643732f,  -0.867839f, -0.620520f, -0.334607f, -0.519982f,
  0.205023f,  0.661159f,  -0.000809f, 0.049033f,  -0.348579f, -0.200338f,
  -0.362144f, -0.346590f, -0.230096f, 0.180746f,  -0.149954f, -0.253429f,
  -0.378170f, -0.040724f, -0.041597f, 0.243659f,  -0.472181f, 0.015401f,
  -0.180376f, 0.153139f,  -0.247738f, -0.010485f, -0.157158f, 0.016825f,
  -0.238925f, -0.265798f, -0.318374f, 0.142352f,  -0.210520f, 0.051928f,
  -0.352190f, -0.179052f, -0.185498f, 0.025540f,  -0.111667f, -0.235187f,
  -0.215454f, 0.010931f,  -0.238372f, -0.126659f, 0.075691f,  -0.091167f,
  -2.462379f, -0.007950f, -0.637990f, 0.285554f,  -0.051275f, 0.282279f,
  -0.744083f, -0.570646f, 0.592198f,  1.421332f,  -0.256027f, -0.140315f,
  0.160247f,  -0.063185f, -0.055895f, -0.199864f, -0.287353f, -0.074561f,
  -0.071228f, 0.055864f,  -1.084764f, -0.263409f, 0.779266f,  0.228187f,
  0.375013f,  0.121204f,  -0.656948f, 0.533561f,  0.272671f,  -0.015423f,
  -0.124180f, -0.009127f, 2.934838f,  -0.150998f, 1.163152f,  0.081997f,
  -4.715939f, -3.676595f, -1.524886f, -0.167593f, 0.281186f,  0.024046f,
  -1.451709f, 0.332558f,  0.990504f,  0.376290f,  -1.466773f, -0.448439f,
  -2.929108f, -4.255188f, 0.065238f,  0.019950f,  1.372393f,  0.444052f,
  -2.538772f, 1.579767f,  -0.464911f, -1.866114f, 1.053958f,  0.434467f,
  -0.125964f, 0.034671f,  0.077116f,  -0.138466f, -0.413395f, -0.223453f,
  -0.172127f, -0.251265f, -0.048239f, -0.395519f, 0.023141f,  0.037459f,
  -0.249593f, -0.062215f, -0.047209f, -0.435189f, -0.164155f, -0.077590f,
  -0.241164f, -0.126128f, -0.038243f, -0.180888f, 0.198840f,  -0.328036f,
  -0.169790f, 0.036506f,  0.052572f,  -0.183570f, -0.073617f, -0.244959f,
  0.266498f,  0.032846f,  -1.902106f, 0.486078f,  2.414993f,  0.975182f,
  -0.382875f, 1.647810f,  -2.197017f, -0.890107f, 0.221287f,  0.010889f,
  3.817042f,  0.572728f,  0.092466f,  0.473337f,  -1.634659f, -1.069455f,
  1.486776f,  -1.023850f, 0.088184f,  0.008842f,  0.518202f,  0.270259f,
  1.757191f,  -0.121839f, -2.912229f, -1.250866f, -2.381808f, 0.335309f,
  -0.120079f, -0.061294f, -0.058725f, -0.315169f, -0.262443f, 0.072434f,
  -0.267836f, -0.319354f, -0.274975f, 0.068970f,  -0.406467f, 0.044074f,
  -0.152311f, -0.333656f, -0.228355f, -0.185613f, 0.017346f,  -0.177674f,
  -0.090675f, -0.102047f, -0.011768f, -0.025280f, -0.271661f, 0.098099f,
  -0.312272f, -0.222217f, -0.100548f, 0.106260f,  -0.034655f, 0.135109f,
  -0.021276f, 0.018177f,  -0.353097f, -0.011128f, 0.061136f,  -0.511662f,
  -0.223236f, -0.308841f, 0.118789f,  -0.154628f, -0.053178f, -0.055973f,
  0.013175f,  -0.368337f, -0.090863f, -0.116920f, 0.178990f,  -0.025278f,
  -0.190553f, -0.238092f, 0.303943f,  -0.024944f, 0.719373f,  0.384332f,
  -0.378480f, -0.423316f, 0.709922f,  0.758514f,  -1.559023f, -2.503173f,
  0.068652f,  -0.234741f, -0.182932f, 0.037878f,  0.020684f,  -0.174142f,
  -0.182300f, -0.052796f, -0.219145f, 0.113028f,  -1.041826f, 0.035317f,
  0.919904f,  -0.676011f, 0.652297f,  1.456447f,  -0.166904f, -0.861823f,
  0.895827f,  0.429821f,  -0.180376f, -0.076587f, -0.273945f, -0.288990f,
  -0.206692f, -0.080745f, -0.085444f, 0.186953f,  -0.050135f, 0.044243f,
  -0.391706f, -0.160498f, -0.292268f, 0.164060f,  0.412649f,  0.211611f,
  -0.327294f, -0.919399f, 0.320297f,  0.385284f,  -0.088848f, -0.072556f,
  -0.384813f, -0.176267f, -0.065918f, 0.134724f,  -0.231104f, -0.337707f,
  -0.195442f, -0.263569f, 0.098090f,  -0.341411f, -0.189211f, -0.439276f,
  -0.404046f, 0.262491f,  -0.311093f, -0.086454f, -0.013400f, -0.061447f,
  -0.026945f, -0.112036f, -0.322985f, 0.078500f,  -0.230205f, -0.344535f,
  -0.021087f, 0.110220f,  -0.128671f, 0.044219f,
};

static const float av1_ab_partition_nn_bias_16_layer0[64] = {
  2.936406f,  -0.396539f, -0.110456f, -1.254954f, 0.785350f,  0.516290f,
  -0.172341f, 0.254386f,  -0.192465f, -0.106751f, -0.055518f, -0.094994f,
  0.000000f,  -0.065018f, -0.004908f, -0.130483f, -0.119580f, -0.142072f,
  0.457446f,  -0.125051f, -0.107712f, 0.714607f,  -0.140809f, -1.788650f,
  -0.087199f, 0.000000f,  -1.290050f, 0.443930f,  -0.110634f, -0.109380f,
  -0.188213f, -1.414179f, 1.193579f,  0.388775f,  -0.873193f, -0.110050f,
  -0.072565f, -0.117050f, -0.119132f, 0.456959f,  -0.132069f, 0.131974f,
  1.160474f,  1.746465f,  0.442628f,  -0.188849f, -0.207794f, -0.108364f,
  -0.856655f, -2.141620f, 0.335476f,  -0.105508f, -0.212162f, -0.109319f,
  -0.237213f, -0.109980f, -0.291044f, -0.137877f, 0.470191f,  -0.023908f,
  0.123809f,  -0.109797f, 0.200510f,  -0.147542f,
};

static const float av1_ab_partition_nn_weights_16_layer1[64 * LABEL_SIZE] = {
  -6.823716f, 1.406568f,  -0.144009f, 2.228765f,  0.838336f,  0.738107f,
  -0.319014f, -0.148756f, 0.240862f,  -0.111089f, -0.004241f, 0.025758f,
  -0.193820f, -0.246362f, -0.181363f, -0.201556f, 0.024268f,  0.252994f,
  -0.289443f, 0.194932f,  0.057467f,  0.724735f,  0.014063f,  1.361352f,
  0.025191f,  0.024274f,  0.231462f,  -7.227959f, -0.094515f, 0.039946f,
  0.412719f,  0.812318f,  3.038903f,  -0.286289f, 0.647482f,  -0.115114f,
  0.053590f,  0.066069f,  0.153134f,  0.996250f,  -0.125700f, 0.951365f,
  -6.243494f, -4.827697f, 0.566320f,  0.239515f,  -0.099702f, 0.054546f,
  1.847330f,  3.680076f,  -3.049829f, -0.127709f, 0.068469f,  -0.017794f,
  0.223864f,  -0.106778f, -0.020425f, -0.040226f, -0.251890f, -0.168673f,
  -0.552073f, 0.043311f,  0.218668f,  0.033209f,  -3.199210f, 0.193079f,
  0.321406f,  0.718307f,  -0.181418f, -0.459612f, -1.981170f, 0.968496f,
  -0.029757f, -0.130065f, 0.043782f,  0.072394f,  -0.088686f, 0.025322f,
  0.129882f,  0.101324f,  0.335707f,  0.072714f,  -2.079774f, 0.203997f,
  0.239321f,  -0.301757f, 0.257845f,  1.288382f,  -0.031275f, -0.234194f,
  0.310722f,  2.045469f,  0.034716f,  0.135638f,  -0.251388f, 0.320071f,
  -1.065301f, -0.322731f, -0.545028f, 0.226276f,  0.090799f,  0.019289f,
  0.048950f,  -1.079300f, 0.231938f,  0.083683f,  4.762127f,  0.145037f,
  -0.145549f, 0.075592f,  0.172336f,  0.108175f,  0.333751f,  1.090501f,
  1.056114f,  0.047073f,  0.182052f,  -0.081587f, 0.089900f,  0.339286f,
  2.049988f,  0.073585f,  0.537355f,  -0.243322f, -0.010179f, -0.052601f,
  -0.174915f, 0.117793f,  2.222990f,  -2.520837f, -0.092699f, 1.199887f,
  0.138720f,  0.679918f,  -0.463155f, -0.659496f, -0.109913f, -0.003398f,
  0.114633f,  -0.128377f, 0.092970f,  -0.107489f, -0.191078f, 0.185182f,
  0.216980f,  -0.019343f, 3.443133f,  0.287953f,  0.099314f,  0.985958f,
  0.157268f,  -0.606516f, 0.049418f,  -0.221809f, -0.453081f, -0.344796f,
  -0.003735f, -0.107269f, -0.128541f, -0.259543f, -0.934806f, -0.542456f,
  -1.011192f, 0.022795f,  0.186363f,  -0.076356f, -0.050932f, -0.165098f,
  0.168177f,  -0.101596f, -5.270886f, 2.553943f,  -0.440870f, -0.017494f,
  0.215208f,  -0.017032f, 1.495915f,  -4.304677f, 0.762211f,  0.182937f,
  0.254406f,  -0.029433f, -0.088364f, -0.110160f, -0.108257f, -0.036538f,
  0.737697f,  -0.234989f, 0.168095f,  0.245118f,  -0.077262f, 0.195718f,
  0.753302f,  -1.637869f, 0.126227f,  0.982129f,  -0.121444f, -0.295570f,
  -1.215799f, 0.147867f,  -0.068496f, 0.132726f,  -0.005772f, -0.181774f,
  0.126513f,  0.204723f,  -0.366123f, 0.103906f,  -0.148053f, -0.075272f,
  0.243884f,  -0.104828f, 0.198988f,  0.501034f,  -0.112671f, 0.111421f,
  0.167508f,  -0.117803f, -0.738624f, 2.046292f,  0.124011f,  0.057983f,
  -0.359154f, -0.648883f, -0.259462f, -0.459041f, -2.501223f, -0.065138f,
  0.122417f,  0.060291f,  -0.129033f, -0.843086f, 0.268241f,  -0.399927f,
  1.585888f,  1.816393f,  -0.631427f, 0.127826f,  0.088105f,  0.073488f,
  0.717694f,  -1.497362f, 2.608528f,  0.066896f,  -0.079230f, 0.223436f,
  -0.010530f, 0.175310f,  1.120365f,  0.034391f,  0.835312f,  0.071652f,
  -0.080615f, 0.111395f,  0.162742f,  0.079927f,  -3.859582f, -0.638431f,
  -0.167880f, -0.992659f, -0.885355f, -1.276197f, 1.334344f,  0.931940f,
  -0.078244f, -0.149030f, -0.070974f, -0.133566f, 0.200034f,  0.102793f,
  -0.048546f, 0.063545f,  0.023864f,  -0.190863f, 1.934257f,  -0.136286f,
  -0.107916f, -0.637468f, 0.066449f,  1.089693f,  -0.214047f, -0.265780f,
  0.899660f,  -0.130333f, 0.288311f,  -0.049024f, 0.090202f,  0.487969f,
  0.339704f,  0.858479f,  0.841253f,  -0.184100f, -0.637070f, -0.125071f,
  -0.077650f, -0.087877f, 0.202268f,  -0.027300f, 2.842862f,  -0.100698f,
  -0.259080f, 0.260556f,  0.157912f,  -0.070364f, 0.467190f,  1.200037f,
  1.419317f,  -0.033588f, -0.227824f, 0.292617f,  0.228574f,  0.213839f,
  -1.091099f, -0.022258f, -1.294681f, 0.136118f,  0.081652f,  -0.185359f,
  -0.039706f, 0.191407f,  -2.053219f, -0.261934f, 0.047812f,  -0.029536f,
  -0.823869f, -1.090534f, -0.755890f, 0.441035f,  -0.167945f, 0.231441f,
  -0.135013f, -0.260762f, 0.256872f,  0.130339f,  -0.243751f, 0.189760f,
  -0.288454f, 0.145363f,  0.338490f,  0.403898f,  -0.022814f, -1.263598f,
  -0.101315f, 0.860135f,  0.136511f,  0.028942f,  0.574047f,  2.656370f,
  0.037587f,  -0.188690f, -0.125312f, 1.100435f,  -1.080402f, 0.380905f,
  0.004635f,  0.097144f,  -0.214309f, 0.085552f,  -0.285066f, -0.705134f,
  -0.054704f, -0.319951f, 5.486626f,  0.958158f,  -1.380585f, 0.223340f,
  -0.169167f, -0.170697f, -0.216748f, 0.324232f,  2.684204f,  -0.008490f,
  -0.211052f, -0.201190f, 0.123466f,  -0.000234f, 0.579907f,  0.096938f,
  -0.042745f, 0.201855f,  0.157195f,  -0.261440f, 0.029699f,  -0.046599f,
  1.618216f,  -2.596280f, -0.377420f, -0.526725f, -0.493592f, -0.579615f,
  0.579699f,  -0.100392f, 0.150694f,  0.061794f,  0.200425f,  -0.062515f,
  -0.179122f, 0.250112f,  -0.344675f, -0.118359f, -0.095670f, 0.152311f,
  3.662276f,  -0.154921f, -0.312991f, 0.972008f,  -0.308596f, -0.190426f,
  0.133889f,  -0.238673f, -0.094726f, 1.683835f,  -0.215629f, -0.198890f,
  -0.035278f, -0.367973f, -0.822435f, 0.240848f,  -0.194656f, 0.034655f,
  -0.079424f, 0.146670f,  0.026646f,  -0.034507f, 0.059467f,  -0.153109f,
  -0.431033f, 2.552991f,  -1.894091f, -0.180462f, -0.306839f, -0.025648f,
  1.026326f,  -3.096230f, 1.346935f,  0.033633f,  -0.181827f, 0.094376f,
  0.001696f,  -0.379264f, -1.069503f, -0.140972f, -0.208769f, -0.195239f,
  0.281795f,  -0.127251f, 0.180776f,  0.067763f,  0.697124f,  -1.040779f,
  0.111280f,  0.188351f,  -0.340234f, -0.207790f, -0.720075f, -0.137409f,
  -0.070310f, -0.032918f, -0.060787f, 0.131484f,  -0.077845f, -0.258652f,
  0.056911f,  -0.062034f, 0.007663f,  -0.185100f, 1.340361f,  0.014096f,
  -0.124602f, 0.194241f,  0.128383f,  0.360465f,  0.082979f,  -0.050475f,
  -0.519294f, 3.323262f,  0.067014f,  0.221203f,  -0.085082f, -0.228606f,
  -0.916668f, -0.022643f, -1.386737f, -0.131902f, -0.349952f, -0.032874f,
  -0.189190f, -0.898790f, -0.102394f, -1.017387f, 2.214050f,  1.790253f,
  -1.913561f, -0.043716f, -0.214924f, -0.194598f, -0.064723f, -1.671793f,
  2.251166f,  -0.146007f, 0.138527f,  -0.003134f, 0.103665f,  0.006928f,
  -0.240253f, -0.227464f, 0.578437f,  -0.214724f, 0.503085f,  0.158093f,
  0.033091f,  0.008061f,  4.815371f,  2.132264f,  0.281850f,  -2.288560f,
  -0.145012f, 1.296832f,  -0.362401f, -0.403252f, 0.109873f,  0.185746f,
  0.244764f,  0.172367f,  -0.185588f, 0.139801f,  -0.178254f, 0.068629f,
  0.358488f,  -0.153969f, -6.433524f, 0.225983f,  -0.138123f, -0.095971f,
  -0.036089f, -1.400083f, 0.265908f,  0.257787f,  0.181144f,  -1.647228f,
  -0.136289f, -0.074206f, 0.122988f,  -0.088895f, -1.266717f, 0.006010f,
  0.536681f,  0.263061f,  -0.032207f, -0.155136f, 0.086431f,  0.441950f,
  -0.060755f, -0.280683f, -0.783475f, -2.567033f, 1.093221f,  0.117667f,
  -0.000408f, 0.225719f,  -2.199698f, 0.141447f,  -1.459051f, 0.051315f,
  0.203228f,  0.354432f,  -0.005775f, -0.028073f, -0.965817f, 0.231083f,
  -0.666884f, 0.026283f,  -0.317486f, 0.210754f,  0.123897f,  0.223827f,
  4.214405f,  1.457334f,  -0.253945f, -1.306733f, -0.391235f, 0.451154f,
  -1.553888f, -0.353429f, 0.069533f,  0.159278f,  -0.173836f, -0.004952f,
  -0.137033f, 0.127012f,  0.143600f,  0.051587f,  -0.070549f, 0.066509f,
  -5.776547f, 0.180021f,  -0.189183f, -1.288504f, -0.233575f, -1.473873f,
  0.140940f,  0.144451f,  -0.104534f, 2.089873f,  -0.168168f, 0.110726f,
  0.132134f,  -0.215223f, -1.682754f, 0.157757f,  -0.146163f, 0.064882f,
  0.117313f,  -0.038780f, -0.124720f, -0.501697f, 0.092047f,  -0.233992f,
  3.324976f,  0.516601f,  1.294202f,  0.119989f,  0.061055f,  0.043420f,
  -2.750727f, -0.382812f, -0.648496f, -0.115353f, -0.334205f, 0.024354f,
  -0.282998f, -0.282705f, 0.073798f,  0.169851f,  0.135651f,  0.182677f,
  -0.040220f, 0.132462f,  -0.303120f, -0.230113f, 6.165739f,  -0.258596f,
  0.024127f,  -1.388283f, -0.006042f, 0.572600f,  0.348411f,  -0.387376f,
  -0.075845f, 0.122319f,  -0.029616f, 0.077873f,  0.154763f,  0.049073f,
  0.018597f,  0.102688f,  -0.204165f, 0.020734f,  -1.389133f, -0.032854f,
  -0.147561f, 0.853944f,  0.132100f,  -3.259659f, 0.243745f,  0.181529f,
  -0.738414f, 1.509994f,  0.023470f,  -0.005329f, 0.066115f,  -1.345081f,
  -1.455402f, -0.172023f, -0.194625f, 0.071885f,  -0.201742f, -0.262402f,
  0.077601f,  -0.048938f, 0.257993f,  -0.504029f, -2.032415f, 1.158880f,
  0.448647f,  -0.025633f, 0.117586f,  -0.072275f, -0.673744f, -3.854342f,
  -0.983843f, 0.047766f,  -0.017193f, -0.215775f, -0.158743f, -0.232042f,
  -0.509112f, 0.148812f,  0.130122f,  0.006486f,  -0.099016f, 0.022514f,
  -0.486850f, -0.059623f, 4.012731f,  0.025454f,  0.029059f,  -0.783546f,
  -0.295260f, 0.322521f,  -0.473201f, -0.172100f, -0.100087f, -0.076516f,
  -0.258367f, -0.112897f, 0.269364f,  -0.065912f, 0.169022f,  -0.178783f,
  -0.095114f, 0.122089f,  -2.790099f, -0.100431f, -0.087963f, -0.009431f,
  -0.087819f, -2.774399f, -0.100757f, 0.013005f,  -0.964533f, 3.236665f,
  -0.354903f, -0.144169f, -0.166869f, -1.396513f, -0.931271f, -0.046261f,
  -1.799262f, -0.365269f, 0.108611f,  0.037994f,  0.024747f,  -1.073639f,
  -0.203158f, -0.935006f, 1.880891f,  1.578385f,  0.726272f,  -0.024546f,
  -0.011626f, -0.151363f, -1.121716f, -1.787484f, 0.232806f,  0.075451f,
  0.182899f,  0.092215f,  -0.207347f, -0.030111f, 0.054316f,  0.192481f,
  0.594639f,  -0.247694f, 0.547471f,  -0.032094f, -0.065000f, 0.007198f,
  1.605377f,  -0.155945f, -0.066200f, -2.343716f, -1.016283f, -0.079321f,
  0.919365f,  0.599980f,  0.125545f,  0.265813f,  0.246884f,  0.095385f,
  -0.260374f, -0.202916f, -0.042770f, 0.234967f,  -0.233139f, -0.326994f,
  -1.375256f, 0.121766f,  0.077433f,  -1.103569f, 0.019497f,  -1.029185f,
  0.253905f,  0.206569f,  0.187334f,  -0.237089f, -0.294351f, 0.164137f,
  0.149696f,  -0.749787f, -0.413433f, 0.976587f,  1.027976f,  -0.285264f,
  0.209273f,  -0.124762f, 0.050884f,  0.250764f,  -0.082031f, -0.646520f,
  4.116680f,  0.437336f,  0.671684f,  0.129509f,  -0.078462f, 0.014072f,
  -0.678232f, 0.094831f,  1.125624f,  0.207070f,  -0.154750f, -0.025780f,
  -0.103030f, 0.118019f,  -0.908186f, -0.263546f, -1.555324f, -0.236887f,
  -0.217854f, -0.051790f, 0.017915f,  0.171001f,  1.355562f,  0.094603f,
  -0.233929f, -1.282169f, -0.773183f, -0.161682f, -0.834565f, -0.286776f,
  -0.298901f, 0.038162f,  0.251899f,  0.039612f,  -0.022935f, -0.232308f,
  -0.043855f, -0.192892f, -0.279009f, -0.182234f, -1.272808f, -0.070344f,
  -0.092432f, -1.915946f, -0.134373f, -1.405496f, -0.067071f, -0.131922f,
  0.185269f,  1.465082f,  0.040240f,  0.112665f,  0.144329f,  -0.286112f,
  -0.617649f, 0.916177f,  0.221044f,  -0.079867f, 0.170251f,  -0.093638f,
  -0.212620f, -0.305945f, -0.234356f, -0.482501f, 3.928472f,  1.241179f,
  0.355922f,  -0.170848f, -0.189168f, 0.080225f,  -1.357793f, 0.190890f,
  0.976800f,  -0.068070f, -0.016295f, -0.088623f, -0.129560f, -0.212267f,
  -0.071537f, -0.219501f, -0.655198f, -0.225188f, -0.116024f, 0.224174f,
  -0.049715f, -0.178005f, 3.029985f,  -1.141546f, 0.080066f,  -1.932316f,
  -0.641137f, -0.189564f, 0.935080f,  0.136119f,  0.015558f,  -0.179331f,
  0.204571f,  0.020350f,  0.009362f,  0.108478f,  0.037076f,  -0.049009f,
  0.081090f,  -0.180202f, 1.455561f,  -0.081559f, 0.059361f,  0.484971f,
  0.160923f,  -2.170744f, -0.013204f, 0.126561f,  -0.407122f, 1.223661f,
  0.044262f,  0.118044f,  0.058274f,  -1.747100f, -0.171318f, 0.971374f,
  0.306995f,  -0.103268f, -0.319443f, -0.333176f, -0.038608f, 0.119674f,
  -0.106479f, -0.907933f, 1.121231f,  1.673840f,  -0.421458f, -0.021146f,
  -0.254838f, 0.097632f,  0.235109f,  -2.901782f, 0.289518f,  -0.355459f,
  -0.068264f, -0.179121f, 0.068560f,  -0.047570f, -0.522523f, -0.228963f,
  -1.037158f, -0.163723f, 0.280563f,  -0.000868f, -0.197220f, -0.239329f,
  1.985274f,  -0.256181f, -0.064341f, -0.822417f, -0.465140f, -0.010942f,
  -0.792024f, -0.114290f, 0.060969f,  0.104106f,  -0.252123f, -0.150400f,
  -0.133277f, 0.267147f,  0.274413f,  0.223744f,  -0.180223f, -0.345415f,
  -0.104883f, 0.119210f,  -0.095041f, -0.301635f, 0.013175f,  -2.128121f,
  -0.147208f, -0.151509f, -0.692013f, 3.418555f,  -0.016541f, 0.171511f,
  0.107159f,  -1.516672f, 0.127408f,  0.687035f,  -0.906486f, -0.145463f,
  -0.169382f, -0.143906f, 0.125091f,  -0.960645f, -0.180869f, -0.716908f,
  2.840951f,  1.904919f,  -0.416268f, -0.425181f, -0.194697f, -0.075932f,
  -0.950604f, -1.599800f, 0.943671f,  -0.022744f, -0.270492f, 0.080843f,
  -0.372916f, 0.047838f,  -0.100300f, -0.026600f, 0.011733f,  -0.226051f,
  0.172790f,  -0.172982f, 0.041258f,  -0.299379f,
};

static const float av1_ab_partition_nn_bias_16_layer1[LABEL_SIZE] = {
  -0.053805f, -1.248639f, 0.520965f, -0.904962f, -0.126425f, -0.118798f,
  0.748430f,  0.203096f,  0.059317f, 0.418219f,  0.841294f,  0.402693f,
  -0.658522f, 0.723479f,  0.544264f, 1.035225f,
};

static const NN_CONFIG av1_ab_partition_nnconfig_16 = {
  FEATURE_SIZE,  // num_inputs
  LABEL_SIZE,    // num_outputs
  1,             // num_hidden_layers
  {
      64,  // num_hidden_nodes
  },
  {
      av1_ab_partition_nn_weights_16_layer0,
      av1_ab_partition_nn_weights_16_layer1,
  },
  {
      av1_ab_partition_nn_bias_16_layer0,
      av1_ab_partition_nn_bias_16_layer1,
  },
};

#undef FEATURE_SIZE
#undef LABEL_SIZE

#define FEATURE_SIZE 18
#define LABEL_SIZE 4

static const float av1_4_partition_nn_weights_16_layer0[FEATURE_SIZE * 48] = {
  0.121894f,  0.058485f,  0.702226f,  0.015457f,  -0.123380f, -0.573450f,
  0.319576f,  0.118808f,  0.166057f,  0.526984f,  0.015211f,  -0.025050f,
  0.085717f,  -0.028221f, -0.580062f, -0.270530f, -0.092371f, 0.037679f,
  0.083573f,  0.007112f,  -0.358623f, -0.264443f, -0.064819f, 0.022013f,
  -0.040077f, -0.291967f, -0.293100f, 0.072266f,  -0.270572f, -0.292253f,
  -0.260105f, -0.294472f, -0.275752f, 0.054315f,  0.000085f,  0.105115f,
  -0.363572f, -0.016542f, 0.185943f,  -0.359903f, 0.038765f,  -0.377668f,
  0.172692f,  0.127749f,  -0.031275f, -0.242528f, -0.145880f, -0.055247f,
  -0.000265f, -0.355224f, 0.089917f,  -0.377841f, -0.209766f, 0.030899f,
  0.039546f,  -0.375030f, -0.041605f, 0.137677f,  0.021282f,  -0.150442f,
  -0.189445f, 0.009293f,  -0.316033f, 0.038745f,  -0.278761f, 0.005692f,
  -0.071763f, -0.302936f, -0.224572f, -0.211841f, 0.057503f,  0.005435f,
  -0.930979f, 0.115513f,  0.689958f,  0.221318f,  1.003891f,  0.359540f,
  -0.640534f, -0.162373f, -0.118105f, 0.205587f,  0.019710f,  0.025067f,
  -0.025344f, 0.002831f,  0.033078f,  0.040175f,  -0.007502f, 0.026272f,
  0.083443f,  -0.880884f, 0.436948f,  0.293297f,  0.051678f,  -0.133328f,
  -0.180323f, 0.667835f,  0.070733f,  -0.003060f, -0.221804f, 0.146601f,
  0.064024f,  0.056758f,  -0.077361f, 0.105587f,  -0.185500f, -0.133552f,
  0.138269f,  0.165055f,  0.628284f,  0.846449f,  0.058825f,  0.223157f,
  0.277896f,  -0.381303f, 0.408241f,  0.643301f,  0.067494f,  0.120822f,
  -0.182491f, -0.111373f, -0.033374f, 0.131387f,  -0.114654f, 0.114318f,
  0.094718f,  -0.052232f, 0.385903f,  1.212304f,  0.425305f,  -0.052993f,
  0.291474f,  -0.319730f, 0.023090f,  -0.317259f, 0.011181f,  -0.034185f,
  -0.100671f, 0.186185f,  -0.432511f, -0.115957f, -0.067746f, -0.177810f,
  -0.226700f, 0.004464f,  0.006809f,  0.171360f,  -0.080723f, 0.099826f,
  -0.062301f, -0.358755f, -0.202549f, -0.084616f, -0.042313f, -0.325560f,
  0.010452f,  -0.341089f, -0.013566f, -0.340129f, 0.034675f,  -0.036518f,
  -0.036473f, -0.192892f, 0.650235f,  0.609437f,  -0.160982f, 0.125535f,
  -1.004575f, 0.521969f,  1.318091f,  0.614004f,  -0.106622f, -0.077453f,
  -0.037328f, -0.081940f, 0.007640f,  0.026654f,  -0.080332f, -0.077356f,
  -0.288170f, -0.319680f, -0.131712f, -0.150985f, 0.073218f,  0.089502f,
  -0.280502f, 0.003941f,  -0.249937f, 0.244263f,  0.023269f,  0.080263f,
  0.073172f,  -0.200036f, 0.022381f,  0.008592f,  -0.339517f, -0.135073f,
  0.177199f,  0.208363f,  0.652360f,  0.272990f,  0.609535f,  0.145805f,
  0.022527f,  -0.088378f, 0.205008f,  0.101021f,  -0.019673f, -0.252681f,
  0.116034f,  -0.062052f, 0.009991f,  0.138933f,  -0.182428f, 0.052542f,
  -0.350825f, -0.122654f, -0.154687f, 0.066747f,  0.021541f,  -0.212169f,
  -0.087093f, -0.087488f, 0.178129f,  -0.146544f, 0.013919f,  -0.273899f,
  0.223753f,  -0.187327f, -0.118795f, -0.191892f, -0.355979f, 0.023794f,
  -0.135236f, 0.058918f,  0.069080f,  0.279287f,  0.369689f,  1.134526f,
  0.659511f,  0.250223f,  0.286040f,  0.515284f,  0.067791f,  -0.156385f,
  0.143283f,  0.050884f,  0.089956f,  -0.040850f, -0.003650f, -0.081162f,
  0.086004f,  0.116578f,  0.826254f,  0.504869f,  -0.196022f, -0.207279f,
  0.200503f,  -0.196801f, 0.008211f,  0.411158f,  -0.075855f, -0.036690f,
  0.111519f,  -0.057838f, -0.005846f, 0.111067f,  0.174712f,  -0.078054f,
  0.765897f,  0.018670f,  -0.306960f, -0.020034f, -0.332875f, 0.662707f,
  -0.461233f, -1.007542f, -0.693995f, -1.243352f, -0.014745f, 0.004036f,
  -0.009141f, 0.003325f,  -0.011233f, -0.000819f, 0.006369f,  0.002418f,
  -0.035906f, -0.005135f, 1.073830f,  1.020736f,  -0.182611f, -1.038976f,
  -0.226695f, -0.375663f, 0.364568f,  0.620995f,  -0.018615f, 0.011347f,
  0.045786f,  0.041077f,  0.010886f,  -0.148428f, 0.028007f,  -0.022322f,
  -0.165985f, 0.233315f,  -0.277531f, -0.329683f, -0.516967f, -0.390750f,
  0.006948f,  0.133744f,  -0.375681f, -0.116877f, -0.009441f, -0.008597f,
  -0.160679f, 0.102150f,  -0.142647f, -0.117501f, 0.035035f,  0.228687f,
  -1.117397f, -0.005171f, -0.008708f, 0.413042f,  -0.298532f, 0.614909f,
  -0.181084f, -0.711770f, 0.344033f,  0.287220f,  -0.112848f, -0.052866f,
  -0.222466f, 0.025029f,  -0.107558f, 0.137036f,  -0.276661f, -0.038808f,
  -0.057448f, 0.037563f,  0.526020f,  0.447997f,  0.288366f,  0.264815f,
  0.319974f,  -0.193091f, 0.353830f,  0.412950f,  -0.280454f, 0.092737f,
  0.070919f,  0.043336f,  0.041214f,  -0.052147f, 0.010860f,  0.191325f,
  0.079783f,  -0.425672f, -0.053469f, -0.005495f, 0.184526f,  -0.166171f,
  0.084459f,  -0.042165f, -0.261759f, -0.248723f, -0.073483f, -0.377884f,
  -0.189614f, -0.054146f, -0.261279f, 0.196347f,  -0.087568f, 0.070533f,
  -0.145492f, -0.041500f, -0.465861f, 0.077369f,  0.020645f,  -0.440232f,
  -0.414585f, -0.168627f, -0.050011f, -0.336676f, -0.344943f, -0.288140f,
  0.085513f,  -0.200425f, 0.218516f,  0.049604f,  -0.280952f, -0.242674f,
  -1.969931f, 0.013374f,  -0.039643f, 1.113947f,  0.018568f,  0.916330f,
  -0.302934f, -0.225816f, 0.189529f,  -0.361971f, 0.021073f,  -0.050143f,
  -0.041415f, 0.015126f,  0.018091f,  -0.082401f, 0.017152f,  0.064856f,
  0.156170f,  0.145323f,  -0.281409f, 0.213357f,  -0.058966f, 0.158668f,
  0.033742f,  0.378820f,  -0.662875f, -0.455532f, -0.702928f, 0.234325f,
  0.139627f,  -1.360650f, 0.040921f,  -0.044373f, -0.059999f, -0.048565f,
  0.115339f,  -0.105888f, -0.170567f, -0.206097f, -0.349537f, 0.107941f,
  -0.356286f, -0.374928f, 0.143257f,  -0.317790f, 0.079875f,  -0.359345f,
  0.081321f,  -0.219772f, -0.077213f, 0.110624f,  -0.252329f, -0.266481f,
  0.190135f,  0.121214f,  0.661064f,  -0.037820f, -0.373068f, -0.065209f,
  -0.286154f, -0.120695f, -0.110670f, -0.193589f, -0.010867f, -0.048054f,
  -0.032010f, 0.110627f,  0.054094f,  -0.884309f, -1.171623f, -0.386911f,
  -0.756058f, 0.030362f,  0.563628f,  -0.334227f, -0.111213f, 1.143898f,
  -0.940454f, 0.084510f,  0.671010f,  0.312244f,  -0.052592f, -0.014376f,
  0.039965f,  -0.010763f, -0.114936f, -0.146020f, 0.015874f,  0.027439f,
  -1.702315f, 0.148702f,  0.153021f,  0.363147f,  -0.488933f, 0.220772f,
  0.640310f,  -0.173911f, -0.169523f, -0.082261f, -0.014854f, 0.024414f,
  0.061041f,  -0.013998f, 0.086539f,  0.000466f,  0.037472f,  -0.010665f,
  -0.326646f, 0.106971f,  0.405589f,  0.555345f,  -0.318315f, 0.526498f,
  0.119246f,  0.022213f,  0.171237f,  0.214651f,  0.062904f,  -0.023764f,
  0.011831f,  0.079644f,  -0.096530f, -0.054373f, -0.306309f, -0.203709f,
  -0.353217f, -0.350005f, -0.329549f, 0.062679f,  -0.387625f, -0.237111f,
  -0.025050f, -0.193987f, 0.002235f,  -0.380821f, -0.051036f, -0.136020f,
  0.077989f,  -0.361691f, 0.120485f,  0.157746f,  0.073394f,  -0.284401f,
  0.113221f,  0.109808f,  0.000197f,  0.122523f,  0.081411f,  -0.048544f,
  -0.136577f, -0.007158f, -0.208952f, -0.276831f, 0.260479f,  -1.392915f,
  -0.865248f, 0.114577f,  -0.000749f, -0.060338f, -0.091176f, -0.108421f,
  0.221256f,  0.100176f,  -0.877560f, -1.248838f, 0.643005f,  0.064580f,
  -0.049878f, 0.267988f,  -0.434340f, -0.299254f, -0.097572f, 0.009606f,
  0.063810f,  -0.090525f, 0.027760f,  0.043484f,  0.041697f,  0.108024f,
  -0.359586f, -0.197090f, 0.121397f,  0.152206f,  -0.391126f, -0.283145f,
  0.008754f,  -0.059022f, -0.218745f, 0.043042f,  -0.056716f, 0.153051f,
  -0.210372f, -0.029681f, -0.288354f, 0.065242f,  -0.189376f, 0.115013f,
  -0.251488f, -0.533091f, 0.037768f,  -0.319107f, -0.161364f, -0.103967f,
  0.063271f,  -0.313289f, -0.312093f, -0.045239f, 0.150607f,  0.001487f,
  0.019602f,  -0.338031f, -0.036214f, 0.112736f,  -0.367762f, 0.122367f,
  0.094670f,  0.175590f,  0.301041f,  -0.135257f, 0.539620f,  0.328619f,
  -0.163971f, 0.137256f,  0.238805f,  0.483722f,  0.121353f,  0.083630f,
  -0.283568f, 0.291661f,  -0.061122f, -0.195295f, 0.153459f,  -0.153727f,
  -0.238839f, -0.071736f, 0.601437f,  -0.664072f, 0.230827f,  0.198753f,
  -0.039196f, 0.206751f,  0.529020f,  0.904132f,  -0.219471f, 0.186694f,
  -0.208608f, -0.093385f, -0.161617f, 0.003930f,  -0.429869f, -0.123563f,
  0.626098f,  -0.002495f, -0.245511f, -1.069848f, 0.296115f,  -0.940267f,
  -1.649122f, -0.512937f, -0.802874f, -1.000239f, -0.027629f, 0.020434f,
  -0.003030f, 0.035986f,  -0.004812f, -0.009193f, -0.004644f, -0.024347f,
  0.068439f,  -0.314339f, 0.095057f,  -0.212372f, 0.197523f,  -0.040878f,
  -0.272164f, -0.243326f, -0.204955f, 0.157199f,  -0.049964f, -0.091537f,
  -0.058012f, -0.306650f, 0.098621f,  -0.146778f, -0.154447f, -0.177889f,
  -0.009698f, 0.025427f,  0.350576f,  -0.448237f, -0.068823f, 1.224960f,
  -0.776883f, -0.692167f, -0.948497f, -0.492598f, 0.029440f,  -0.056460f,
  0.021654f,  0.004352f,  0.041508f,  -0.027179f, 0.006789f,  -0.023573f,
  0.207775f,  -0.280273f, -0.347984f, -0.129935f, 0.151512f,  -0.087294f,
  -0.494352f, -0.341424f, 0.044084f,  -0.064080f, 0.073091f,  -0.145574f,
  0.094715f,  -0.258786f, -0.020419f, -0.401823f, 0.009397f,  -0.138642f,
  -0.034953f, -0.077419f, 0.636610f,  0.314980f,  1.110610f,  -0.343368f,
  0.696647f,  -0.649667f, 0.653491f,  -0.096006f, -0.090469f, -0.066975f,
  -0.105864f, -0.015666f, 0.102056f,  -0.105344f, -0.273495f, -0.014686f,
  0.122031f,  0.139524f,  -1.042029f, -0.562510f, 0.885644f,  1.088059f,
  0.189223f,  0.049404f,  -0.167371f, 0.018703f,  -0.208390f, -0.159002f,
  -0.377130f, -0.151118f, 0.117861f,  0.026986f,  -0.032433f, 0.081603f,
  -0.106729f, -0.040134f, 0.015161f,  0.290572f,  0.241446f,  1.390085f,
  0.438915f,  -0.358097f, -0.171799f, 0.879758f,  -0.014110f, 0.029562f,
  -0.073583f, -0.125817f, -0.036512f, -0.040275f, 0.037997f,  0.120979f,
  0.064538f,  -0.038841f, 0.034797f,  0.110229f,  -0.239779f, -0.004558f,
  0.226534f,  0.111286f,  -0.268198f, 0.237673f,  -0.328237f, -0.090774f,
  -0.269690f, -0.202147f, -0.181808f, -0.305238f, 0.110058f,  -0.169217f,
  -0.300125f, 0.069031f,  -0.081358f, -0.376174f, -0.349980f, 0.071443f,
  -0.396278f, -0.389503f, -0.190410f, -0.014767f, -0.265229f, -0.099787f,
  0.079847f,  -0.214580f, -0.235661f, -0.184227f, 0.111099f,  -0.083945f,
  -0.153809f, -0.284092f, -0.132497f, -0.154841f, -0.517157f, -0.640603f,
  -0.357036f, -0.486142f, -0.182819f, -0.475022f, 0.079282f,  0.081168f,
  -0.120831f, -0.016048f, -0.232495f, 0.214329f,  -0.055058f, 0.032856f,
  0.061753f,  0.003226f,  0.097028f,  0.084535f,  -1.563199f, 0.434928f,
  -0.403710f, 0.520696f,  -0.401696f, 0.450568f,  -0.074121f, 0.076622f,
  -0.098421f, 0.167036f,  -0.255250f, -0.526313f, -0.933693f, -0.558104f,
  0.194341f,  0.173326f,  0.071112f,  -0.651961f, -1.327587f, -0.705289f,
  -1.138889f, 0.197167f,  -0.714654f, -0.113891f, 0.080158f,  0.000301f,
  0.057905f,  0.060718f,  -0.635995f, 0.100026f,  -0.038239f, -0.025530f,
};

static const float av1_4_partition_nn_bias_16_layer0[48] = {
  -0.079252f, -0.083606f, -0.112759f, -0.071622f, 0.444562f,  0.215649f,
  -0.337661f, -0.242379f, -0.053829f, 0.165168f,  -0.076613f, -0.190579f,
  -0.060175f, -0.571661f, -0.454075f, -1.462711f, -0.161563f, -0.088748f,
  -0.030279f, -0.456293f, -0.134473f, -0.194976f, 0.044373f,  -0.503954f,
  -0.083563f, 0.123344f,  0.011821f,  0.085445f,  -0.050294f, -0.135194f,
  0.057815f,  0.543558f,  -0.090602f, -0.104671f, -0.285075f, 0.354335f,
  1.037007f,  -0.023879f, -0.025025f, -0.094408f, -0.101200f, -0.142105f,
  -0.380607f, -0.059067f, -0.113017f, -0.137448f, -0.177840f, 0.468505f,
};

static const float av1_4_partition_nn_weights_16_layer1[48 * LABEL_SIZE] = {
  0.174954f,  -0.239117f, 0.073252f,  0.258881f,  0.579781f,  0.441827f,
  0.372037f,  -0.062362f, 0.068477f,  0.376811f,  -0.130520f, 0.214951f,
  -0.200674f, 0.240347f,  0.152954f,  1.360264f,  0.334630f,  -0.064789f,
  -0.270826f, 0.212699f,  0.045669f,  -0.150852f, -0.412603f, 0.122481f,
  -0.230246f, 0.005004f,  0.321417f,  -0.554083f, -0.186742f, -0.197687f,
  -0.028669f, -0.138559f, -0.117773f, 0.024953f,  0.326367f,  -0.109951f,
  -1.098959f, -0.136134f, 0.563218f,  0.191799f,  0.126191f,  -0.093113f,
  0.185371f,  0.058468f,  0.245247f,  -0.138064f, -0.471573f, -0.209372f,
  -0.111171f, 0.222275f,  -0.350556f, -0.106336f, 0.268877f,  0.090639f,
  -0.083008f, -0.190791f, -0.243922f, -0.121182f, -0.133733f, -0.078450f,
  0.099751f,  0.353020f,  -0.199079f, -0.463492f, -0.647884f, 0.166611f,
  -0.464034f, 0.045096f,  -0.312178f, -0.190972f, -0.468297f, 0.662376f,
  -0.197071f, -0.653123f, -0.354365f, -0.088501f, -0.302671f, 0.140713f,
  0.885444f,  0.350273f,  -0.003345f, 0.217260f,  0.219156f,  0.240653f,
  0.347840f,  0.101849f,  -0.244565f, -0.166971f, 0.091056f,  0.319912f,
  0.268459f,  0.250726f,  -0.155819f, -0.087588f, 0.010749f,  -0.192344f,
  0.344808f,  0.223482f,  -0.189563f, -0.067317f, -0.348191f, -0.085265f,
  0.259318f,  0.102408f,  0.096675f,  -0.255564f, -0.168480f, -0.068189f,
  -0.457704f, 0.010565f,  0.228573f,  -0.124421f, 0.202488f,  0.148519f,
  0.002180f,  0.099099f,  -0.179019f, 0.245414f,  -0.038307f, 0.116897f,
  -0.031377f, 0.368533f,  -0.793891f, 0.148614f,  0.075441f,  0.102465f,
  -0.310002f, -0.355369f, -0.206713f, -0.262276f, 0.068578f,  -0.044980f,
  0.092689f,  -0.181058f, 0.016279f,  0.155965f,  0.545361f,  -0.390699f,
  -0.042457f, 0.110238f,  0.114640f,  0.112525f,  0.522221f,  0.533164f,
  -0.331720f, -0.212966f, 0.140823f,  0.251311f,  -0.006092f, -0.800438f,
  0.007981f,  -0.585140f, -0.006526f, 0.541683f,  -0.298498f, 0.084322f,
  -0.056467f, -0.361806f, -0.256347f, -1.419173f, -0.159093f, 0.023017f,
  0.667915f,  -0.176995f, 0.022307f,  -0.169493f, 0.581377f,  0.044929f,
  0.044914f,  -0.056290f, 0.324196f,  0.648043f,  -0.089381f, -0.054971f,
  0.064782f,  0.629356f,  -0.003760f, -0.123822f, 0.144133f,  -0.378821f,
  1.116858f,  0.128552f,  -0.668783f, 0.207194f,  -0.437781f, -0.283321f,
  -0.549404f, 0.010538f,  0.208997f,  0.231396f,  -0.174347f, 0.161910f,
};

static const float av1_4_partition_nn_bias_16_layer1[LABEL_SIZE] = {
  -0.197883f,
  -0.136696f,
  0.094115f,
  0.612799f,
};

static const NN_CONFIG av1_4_partition_nnconfig_16 = {
  FEATURE_SIZE,  // num_inputs
  LABEL_SIZE,    // num_outputs
  1,             // num_hidden_layers
  {
      48,  // num_hidden_nodes
  },
  {
      av1_4_partition_nn_weights_16_layer0,
      av1_4_partition_nn_weights_16_layer1,
  },
  {
      av1_4_partition_nn_bias_16_layer0,
      av1_4_partition_nn_bias_16_layer1,
  },
};

static const float av1_4_partition_nn_weights_32_layer0[FEATURE_SIZE * 32] = {
  0.114554f,  0.043669f,  0.313291f,  0.167688f,  -0.413357f, 0.088232f,
  0.301915f,  -0.358117f, 0.267711f,  -0.252716f, -0.038531f, -0.032805f,
  -0.025382f, 0.023624f,  -0.949694f, -0.065480f, -0.375721f, -0.697319f,
  -0.117387f, -0.204309f, -0.190797f, -0.223867f, -0.190248f, 0.026668f,
  0.199717f,  0.216902f,  -0.239241f, -0.096894f, -0.225046f, 0.246523f,
  0.002333f,  -0.254385f, -0.205815f, 0.123139f,  -0.476923f, 0.137557f,
  0.059686f,  -0.124013f, 0.974675f,  0.889753f,  0.378940f,  0.526413f,
  -0.208747f, -0.001913f, 0.094081f,  0.848010f,  0.062042f,  0.159831f,
  0.071016f,  0.024437f,  0.212611f,  0.039501f,  -0.149922f, -0.055229f,
  -0.229270f, 0.129004f,  -0.182803f, 0.291223f,  -1.197804f, -0.916991f,
  -0.024095f, 0.738729f,  -0.300326f, 0.402480f,  0.023944f,  -0.022613f,
  -0.004554f, 0.001784f,  0.035143f,  -0.202237f, 0.080252f,  -0.003912f,
  -0.040345f, -0.121881f, 0.126672f,  0.093507f,  -0.081305f, -0.081099f,
  -0.218824f, -0.459254f, -0.055250f, -0.095096f, 0.207278f,  0.245259f,
  -0.380849f, -0.334458f, -0.351449f, -0.513045f, -0.407823f, -0.222423f,
  0.103205f,  -0.299965f, -0.211472f, -0.348690f, -0.283688f, -0.152743f,
  -0.204005f, -0.173636f, 0.020302f,  -0.109112f, 0.081203f,  -0.137344f,
  -0.364582f, -0.343133f, -0.176167f, -0.446541f, 0.144844f,  -0.268105f,
  -0.003889f, -0.309560f, -0.236092f, -0.299450f, 0.248269f,  0.207510f,
  -0.279023f, -0.272472f, -0.166427f, 0.205973f,  -0.345692f, -0.238400f,
  -0.319178f, -0.327246f, -0.321756f, 0.043191f,  -0.027520f, -0.029310f,
  0.161379f,  0.031154f,  -0.605365f, -0.230926f, 0.261142f,  -0.262678f,
  -0.373351f, -0.326245f, 0.279222f,  0.684357f,  -0.864302f, 0.036132f,
  0.239307f,  0.136262f,  0.124002f,  -0.410379f, -0.172722f, -0.376670f,
  -0.195889f, 0.037292f,  -0.055295f, 1.022308f,  0.237600f,  -0.618435f,
  0.366154f,  0.168308f,  -0.473467f, -0.756558f, -0.044830f, 0.019057f,
  -0.084214f, -0.007789f, -0.066028f, -0.074562f, 0.002082f,  0.001007f,
  -0.269676f, -0.164768f, -0.027271f, -0.098935f, 0.009431f,  0.254431f,
  0.124238f,  -0.198181f, 0.142723f,  -0.112997f, -0.164224f, -0.355160f,
  0.135330f,  -0.379557f, 0.079392f,  0.210607f,  -0.354927f, -0.277678f,
  -0.931111f, 0.056208f,  -0.347710f, -0.355415f, 0.826145f,  0.390625f,
  0.374414f,  -0.205685f, 0.562485f,  0.152288f,  0.130635f,  0.056622f,
  0.057972f,  0.095526f,  -0.082436f, -0.085938f, -0.070570f, -0.087634f,
  0.335934f,  0.084860f,  0.544424f,  -0.278917f, 0.476740f,  0.050927f,
  -1.288817f, -0.078320f, -0.553041f, -0.160538f, -0.109365f, -0.127146f,
  -0.032524f, -0.105117f, -0.182965f, -0.024723f, 0.083317f,  0.060073f,
  -0.042945f, 0.015249f,  1.241504f,  0.662613f,  0.530496f,  -0.180519f,
  -1.099086f, -0.825844f, 0.551856f,  -0.025009f, -0.006619f, -0.001049f,
  0.014828f,  -0.035166f, -0.241091f, -0.136364f, -0.003219f, -0.014581f,
  -0.379945f, -0.226191f, -0.161241f, -0.496390f, -0.147175f, -0.118004f,
  -0.128206f, -0.389770f, -0.184288f, -0.119076f, -0.379211f, 0.236180f,
  -0.468730f, -0.175170f, 0.136433f,  0.167739f,  -0.377602f, 0.135772f,
  0.040972f,  -0.193974f, -0.319475f, -0.016469f, -0.412027f, -0.322605f,
  0.111125f,  -0.078456f, -0.387234f, -0.401605f, -0.088717f, -0.340682f,
  0.010556f,  0.058256f,  -0.127352f, 0.017665f,  0.072632f,  -0.171966f,
  -0.117342f, -0.166050f, -0.182689f, -0.073182f, 0.096279f,  -0.260229f,
  0.025216f,  -0.332236f, -0.218706f, -0.200153f, -0.110303f, 0.073499f,
  -0.280123f, 0.132262f,  -0.308330f, -0.119036f, -0.303874f, -0.065445f,
  -0.412137f, 0.057167f,  0.044582f,  -0.330952f, -0.232572f, 0.039732f,
  -0.326877f, -0.300569f, -0.467164f, -0.371499f, 0.034430f,  0.058277f,
  -0.042485f, -0.409028f, -0.110889f, -0.500758f, -0.343141f, 0.042023f,
  -1.071050f, 0.086854f,  -0.004932f, -0.259698f, 0.125301f,  -0.742663f,
  -0.370517f, -0.772840f, 0.193628f,  0.554676f,  0.051283f,  -0.196639f,
  0.040344f,  0.027391f,  -0.040501f, 0.038303f,  0.032972f,  -0.014638f,
  0.097720f,  -0.206897f, -0.015480f, 0.008543f,  0.034469f,  0.127234f,
  -0.396463f, -0.390189f, 0.117538f,  -0.435622f, 0.043420f,  -0.241987f,
  -0.118254f, -0.190349f, 0.190273f,  -0.085625f, -0.141253f, -0.377438f,
  -0.249211f, 0.214512f,  -0.363191f, -0.754851f, 0.238045f,  1.127635f,
  0.173947f,  -0.357620f, 0.073671f,  0.220617f,  0.072067f,  -0.076214f,
  -0.044583f, -0.018371f, 0.010952f,  -0.135116f, 0.076597f,  0.034480f,
  -0.070212f, -0.454429f, -0.135215f, 0.163851f,  -0.625990f, -0.283991f,
  0.284051f,  0.182935f,  -0.048717f, 0.002484f,  -0.009086f, 0.321724f,
  0.125162f,  -0.069624f, -0.430299f, -0.007224f, -0.284725f, -0.475662f,
  0.123807f,  -0.313614f, -0.103142f, 0.072125f,  0.100320f,  -0.185558f,
  -0.481522f, -0.247311f, -0.386762f, -0.258850f, 0.178844f,  -0.381231f,
  -0.436001f, -0.374834f, 0.230104f,  -0.500679f, 0.170880f,  0.029657f,
  -0.105857f, -0.366671f, -0.268833f, 0.036885f,  -0.026776f, 0.037837f,
  -0.362095f, -0.254933f, 0.129650f,  0.007945f,  -0.304715f, -0.100813f,
  -0.342849f, -0.269223f, 0.178490f,  0.186735f,  -0.353995f, 0.050381f,
  -0.440186f, 0.025985f,  1.096969f,  1.132937f,  0.581545f,  0.271734f,
  -0.109169f, -0.014239f, 0.688644f,  0.602702f,  0.048616f,  0.022335f,
  0.037545f,  0.081667f,  -0.109038f, -0.088565f, -0.002506f, -0.041420f,
  -0.132515f, 0.187312f,  0.677273f,  1.111182f,  0.199096f,  -0.211551f,
  -0.896508f, 0.257981f,  0.007803f,  0.160343f,  -0.124864f, -0.097150f,
  0.225090f,  0.242900f,  -0.195665f, 0.011310f,  0.160765f,  0.169195f,
  -0.081994f, -0.017372f, -0.566190f, -0.902086f, 0.027768f,  0.511419f,
  0.076009f,  -0.165861f, 0.240487f,  0.006298f,  -0.153334f, 0.041249f,
  0.387092f,  0.313011f,  -0.032269f, 0.019024f,  0.052568f,  0.124247f,
  0.197640f,  0.002537f,  0.651044f,  0.829828f,  -0.446444f, -0.402042f,
  -0.469399f, -0.019842f, 0.371960f,  0.140373f,  -0.044808f, 0.008283f,
  0.093791f,  0.052149f,  0.143123f,  -0.449571f, -0.868816f, -0.265661f,
  -0.225232f, -0.014704f, 0.543836f,  -0.374498f, 0.561647f,  1.309445f,
  0.056789f,  -0.048447f, 0.255758f,  0.644553f,  -0.124802f, 0.097419f,
  -0.149336f, 0.021596f,  -0.043699f, 0.057591f,  -0.000077f, 0.034488f,
  -0.049353f, -0.007799f, 0.437914f,  0.509369f,  0.674428f,  1.858949f,
  -0.205964f, 0.060776f,  0.184213f,  0.037177f,  -0.062535f, -0.115408f,
  0.076498f,  0.010235f,  -0.142253f, 0.009983f,  0.073436f,  0.038716f,
  -0.369983f, -0.185959f, -0.137867f, 0.032134f,  0.213814f,  -0.125571f,
  0.247874f,  -0.166871f, -0.160890f, 0.147029f,  0.267143f,  -0.298488f,
  -0.210203f, -0.188313f, -0.085024f, -0.244962f, -0.189833f, -0.261242f,
  0.399519f,  0.143200f,  -0.776419f, -0.374639f, -0.022066f, 0.582904f,
  0.006430f,  -0.139134f, -0.491894f, -0.430579f, -0.358221f, -0.231365f,
  -0.398255f, -0.173231f, 0.211789f,  -0.036121f, -0.266856f, 0.042956f,
  -1.138513f, -0.070313f, 0.158803f,  0.406989f,  -0.015974f, 0.651020f,
  -0.468982f, -0.310019f, 0.416922f,  0.895162f,  0.019921f,  0.004023f,
  0.006962f,  0.000863f,  -0.216395f, -0.074913f, -0.002613f, 0.026703f,
};

static const float av1_4_partition_nn_bias_32_layer0[32] = {
  0.133615f,  -0.113389f, -0.575989f, 0.589389f,  -0.193574f, -0.132463f,
  0.000000f,  0.060317f,  0.264577f,  -0.060599f, 0.540147f,  -0.127782f,
  -0.548802f, -0.172235f, -0.193032f, -0.026301f, -0.177527f, 0.267821f,
  -0.115455f, -0.137162f, -0.079595f, -0.041443f, -0.043856f, -0.657220f,
  -0.448931f, 0.446300f,  0.250002f,  0.223559f,  -0.647723f, -0.014369f,
  0.084333f,  -0.056270f,
};

static const float av1_4_partition_nn_weights_32_layer1[32 * LABEL_SIZE] = {
  -0.069633f, -0.087239f, 0.365816f,  -0.068579f, 0.231198f,  -0.067856f,
  -0.139892f, -0.100235f, -0.488166f, -0.150112f, -0.005546f, 0.210832f,
  0.778888f,  0.169624f,  0.089968f,  -0.243569f, 0.353483f,  0.032296f,
  -0.157408f, 0.286885f,  -0.063537f, -0.324055f, -0.161464f, 0.430600f,
  0.277707f,  -0.196463f, 0.154647f,  0.059804f,  0.176408f,  0.303179f,
  -0.040156f, 0.375810f,  -0.363032f, -0.186808f, -0.264561f, -0.158937f,
  -0.007949f, -0.076394f, 0.056475f,  0.308528f,  0.695387f,  0.051336f,
  0.433063f,  -0.229948f, -1.210712f, 0.036286f,  0.183868f,  -0.117660f,
  0.230134f,  -0.093469f, 0.237918f,  0.625986f,  -0.236671f, -0.377172f,
  0.331091f,  -0.394004f, -0.214349f, 0.243940f,  -0.600348f, 0.069843f,
  0.088325f,  0.225775f,  0.276884f,  -0.604493f, 0.769812f,  0.259574f,
  0.086220f,  0.511515f,  -0.282584f, -0.157719f, 0.278778f,  -0.332732f,
  0.068985f,  -0.237236f, -0.006102f, -0.154883f, 0.710288f,  -0.245896f,
  -0.255895f, -0.398038f, 0.304084f,  -0.317065f, 0.192609f,  -0.235613f,
  0.461340f,  0.117194f,  0.116817f,  0.196150f,  0.421622f,  -0.264495f,
  0.617852f,  -0.351756f, -0.310016f, 0.135932f,  -0.242622f, -0.073094f,
  0.042077f,  0.039230f,  -0.482715f, 0.553187f,  0.360637f,  0.313484f,
  -0.131540f, -0.104731f, 0.374704f,  0.222173f,  0.437657f,  0.029827f,
  -0.545156f, -0.203176f, 0.267824f,  0.169237f,  -0.057871f, 0.552197f,
  0.272243f,  0.025681f,  -0.262192f, 0.255934f,  -0.202407f, -0.483317f,
  -0.204721f, 0.288807f,  -0.030735f, -0.047161f, -0.780724f, 0.381939f,
  -0.295318f, 0.537378f,
};

static const float av1_4_partition_nn_bias_32_layer1[LABEL_SIZE] = {
  -0.332518f,
  0.114452f,
  0.098949f,
  0.465896f,
};

static const NN_CONFIG av1_4_partition_nnconfig_32 = {
  FEATURE_SIZE,  // num_inputs
  LABEL_SIZE,    // num_outputs
  1,             // num_hidden_layers
  {
      32,  // num_hidden_nodes
  },
  {
      av1_4_partition_nn_weights_32_layer0,
      av1_4_partition_nn_weights_32_layer1,
  },
  {
      av1_4_partition_nn_bias_32_layer0,
      av1_4_partition_nn_bias_32_layer1,
  },
};

static const float av1_4_partition_nn_weights_64_layer0[FEATURE_SIZE * 16] = {
  0.256343f,  -0.021774f, -0.117102f, 0.416930f,  0.188160f,  0.148768f,
  -0.611181f, -0.121607f, -0.394825f, -0.875025f, -0.167071f, 0.016408f,
  0.222769f,  -0.199332f, 0.058667f,  -0.679529f, 0.081744f,  0.044438f,
  -0.182941f, -0.110339f, -0.137822f, -0.096164f, -0.132319f, 0.140036f,
  -0.049503f, -0.309894f, -0.323991f, 0.166113f,  0.138104f,  -0.263629f,
  -0.368460f, -0.273989f, 0.147239f,  0.044566f,  -0.363357f, -0.030792f,
  0.020734f,  0.068506f,  -0.434214f, 0.581644f,  -1.244146f, -0.569162f,
  0.179499f,  -0.188900f, 0.078431f,  -0.392126f, -0.006431f, 0.112146f,
  -0.065892f, -0.051319f, 0.094607f,  0.251700f,  -0.000650f, 0.011911f,
  0.080449f,  0.022816f,  0.322382f,  0.577070f,  0.927738f,  0.178707f,
  -0.101237f, -0.212521f, 0.560261f,  -0.206492f, -0.077591f, -0.069960f,
  0.025727f,  0.041122f,  -0.735228f, -0.506091f, -0.600776f, -0.117829f,
  0.103556f,  0.141823f,  0.853448f,  0.339488f,  0.994022f,  0.121693f,
  -2.065366f, -0.352510f, -0.174323f, -0.323400f, -0.002193f, 0.004161f,
  0.042469f,  -0.005319f, -0.305784f, -0.371353f, 0.011194f,  -0.018597f,
  0.209260f,  0.071577f,  0.242470f,  -0.856593f, 0.288842f,  1.062608f,
  -0.300472f, 0.221623f,  -0.813563f, -0.250347f, -0.081455f, -0.092779f,
  -0.168132f, -0.180640f, -0.075130f, -0.052906f, -0.015645f, 0.127158f,
  -0.006546f, 0.051671f,  0.545608f,  1.101804f,  0.288086f,  1.107046f,
  -0.200012f, 0.220182f,  -0.189220f, -0.554973f, 0.040711f,  -0.058029f,
  0.043737f,  0.016164f,  -0.391790f, -0.287770f, -0.046545f, 0.045071f,
  0.190005f,  -0.076963f, 0.836839f,  1.633266f,  0.902928f,  0.991972f,
  -0.127932f, 0.293680f,  -0.035984f, 0.476179f,  -0.098024f, 0.068314f,
  -0.058365f, 0.096221f,  -0.000321f, -0.128840f, 0.136441f,  -0.061853f,
  0.270367f,  -0.184129f, -0.373670f, -0.177381f, 0.262109f,  -0.378013f,
  -0.053249f, -0.456389f, 0.222972f,  -0.228067f, -0.115210f, -0.277797f,
  0.096913f,  -0.014512f, -0.015533f, 0.026389f,  -0.360536f, -0.078477f,
  -0.203186f, 0.199574f,  0.770476f,  0.595592f,  0.360828f,  0.547721f,
  -0.804787f, 0.389690f,  -0.437645f, 0.576776f,  0.081903f,  0.082750f,
  0.007166f,  -0.143755f, 0.114462f,  0.472432f,  -0.058974f, 0.077761f,
  -2.015181f, -0.054942f, -0.110894f, 0.529188f,  -0.003300f, 0.913895f,
  -0.324643f, 0.316135f,  -0.291729f, 1.072647f,  -0.029236f, 0.045592f,
  -0.039399f, 0.043472f,  -0.303244f, -0.108761f, -0.011154f, 0.009693f,
  -0.374985f, 0.027758f,  0.302075f,  -0.295758f, -0.165563f, -0.297259f,
  -0.485624f, -0.469310f, -0.028247f, -0.124440f, -0.428082f, 0.096325f,
  0.089003f,  -0.301585f, 0.022474f,  0.077477f,  -0.032233f, -0.231036f,
  0.143206f,  0.169113f,  -0.556486f, 0.346327f,  -0.667790f, 0.126983f,
  0.179727f,  0.397307f,  -0.490612f, -1.708789f, -0.040336f, -0.028547f,
  -0.091319f, -0.119367f, -0.518796f, -0.543383f, 0.037162f,  0.031344f,
  -0.131692f, 0.119353f,  0.799313f,  0.443848f,  -0.499919f, -1.002983f,
  0.375477f,  0.221096f,  -0.238033f, 0.284849f,  0.021897f,  0.023338f,
  -0.059067f, 0.117276f,  0.039540f,  0.049630f,  0.175150f,  0.014166f,
  -0.071486f, 0.091234f,  -1.007432f, -1.417378f, 0.640528f,  1.442576f,
  -0.257183f, -0.597016f, 0.861785f,  0.276121f,  -0.098017f, 0.120514f,
  -0.133184f, 0.106529f,  0.171644f,  0.059513f,  0.215952f,  -0.009441f,
  -0.505313f, 0.063174f,  0.229148f,  -0.344213f, 0.862721f,  1.549941f,
  -0.220129f, 0.493094f,  0.264095f,  0.143641f,  0.084968f,  -0.078266f,
  0.032335f,  -0.019006f, -0.098205f, 0.119213f,  -0.103465f, 0.072811f,
};

static const float av1_4_partition_nn_bias_64_layer0[16] = {
  0.111611f,  -0.067682f, 0.633594f,  0.143559f,  -1.051284f, -0.266625f,
  -0.829789f, -0.956123f, -0.153484f, -0.787741f, 0.004832f,  -0.080769f,
  0.235166f,  0.449468f,  0.294689f,  -0.395300f,
};

static const float av1_4_partition_nn_weights_64_layer1[16 * LABEL_SIZE] = {
  -0.069999f, -0.093710f, -0.423714f, -0.028138f, 0.684415f,  0.141445f,
  0.507161f,  0.435533f,  -0.263268f, 0.585105f,  0.235301f,  0.127536f,
  -0.688639f, -0.217993f, -0.540066f, 0.406718f,  0.018210f,  -0.077349f,
  -0.124823f, -0.488220f, -0.957026f, 0.302632f,  0.285490f,  -0.411356f,
  0.091089f,  0.103862f,  -0.549291f, 0.148628f,  0.640603f,  -0.601018f,
  0.178024f,  0.601370f,  0.313780f,  0.051938f,  0.524083f,  0.814631f,
  -0.415522f, -0.738849f, 0.477881f,  -0.342864f, 0.105181f,  0.040010f,
  -0.177521f, 0.400646f,  0.167093f,  0.388279f,  -0.898439f, -0.111936f,
  0.469875f,  -0.099528f, -0.217370f, 0.283742f,  -0.033798f, -0.142797f,
  -0.174057f, -1.293311f, -0.038777f, -0.003846f, 0.093642f,  -0.527150f,
  -0.021259f, 0.194651f,  -0.276294f, -0.109514f,
};

static const float av1_4_partition_nn_bias_64_layer1[LABEL_SIZE] = {
  -0.688947f,
  0.121075f,
  0.289597f,
  0.948091f,
};

static const NN_CONFIG av1_4_partition_nnconfig_64 = {
  FEATURE_SIZE,  // num_inputs
  LABEL_SIZE,    // num_outputs
  1,             // num_hidden_layers
  {
      16,  // num_hidden_nodes
  },
  {
      av1_4_partition_nn_weights_64_layer0,
      av1_4_partition_nn_weights_64_layer1,
  },
  {
      av1_4_partition_nn_bias_64_layer0,
      av1_4_partition_nn_bias_64_layer1,
  },
};

#undef FEATURE_SIZE
#undef LABEL_SIZE

#ifdef __cplusplus
}  // extern "C"
#endif

#endif  // AV1_ENCODER_AB_PARTITION_MODEL_WEIGHTS_H_
