/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.haha.guava.collect;

import com.squareup.haha.guava.base.Ascii;
import com.squareup.haha.guava.collect.Maps;
import com.squareup.haha.guava.collect.Multimap;
import com.squareup.haha.guava.collect.Multimaps$Entries;
import com.squareup.haha.guava.collect.SetMultimap;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

abstract class AbstractMultimap<K, V>
implements Multimap<K, V> {
    private transient Collection<Map.Entry<K, V>> entries;
    private transient Set<K> keySet;
    private transient Collection<V> values;
    private transient Map<K, Collection<V>> asMap;

    AbstractMultimap() {
    }

    public boolean containsValue(@Nullable Object value) {
        for (Collection<V> collection : this.asMap().values()) {
            if (!collection.contains(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsEntry(@Nullable Object key, @Nullable Object value) {
        Collection<V> collection = this.asMap().get(key);
        return collection != null && collection.contains(value);
    }

    @Override
    public boolean remove(@Nullable Object key, @Nullable Object value) {
        Collection<V> collection = this.asMap().get(key);
        return collection != null && collection.remove(value);
    }

    @Override
    public boolean put(@Nullable K key, @Nullable V value) {
        return this.get(key).add(value);
    }

    public Collection<Map.Entry<K, V>> entries() {
        Collection<Map.Entry<K, V>> result = this.entries;
        if (result == null) {
            this.entries = this.createEntries();
            return this.entries;
        }
        return result;
    }

    Collection<Map.Entry<K, V>> createEntries() {
        if (this instanceof SetMultimap) {
            return new EntrySet(this, 0);
        }
        return new Entries(this, 0);
    }

    abstract Iterator<Map.Entry<K, V>> entryIterator();

    public Set<K> keySet() {
        Set<K> result = this.keySet;
        if (result == null) {
            this.keySet = this.createKeySet();
            return this.keySet;
        }
        return result;
    }

    Set<K> createKeySet() {
        return new Maps.KeySet<K, Collection<V>>(this.asMap());
    }

    @Override
    public Collection<V> values() {
        Collection<V> result = this.values;
        if (result == null) {
            this.values = this.createValues();
            return this.values;
        }
        return result;
    }

    Collection<V> createValues() {
        return new Values(this);
    }

    Iterator<V> valueIterator() {
        return Maps.valueIterator(this.entries().iterator());
    }

    @Override
    public Map<K, Collection<V>> asMap() {
        Map<K, Collection<V>> result = this.asMap;
        if (result == null) {
            this.asMap = this.createAsMap();
            return this.asMap;
        }
        return result;
    }

    abstract Map<K, Collection<V>> createAsMap();

    @Override
    public boolean equals(@Nullable Object object) {
        Object object2 = object;
        AbstractMultimap abstractMultimap = this;
        if (object2 == abstractMultimap) {
            return true;
        }
        if (object2 instanceof Multimap) {
            Multimap multimap = (Multimap)object2;
            return abstractMultimap.asMap().equals(multimap.asMap());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.asMap().hashCode();
    }

    public String toString() {
        return this.asMap().toString();
    }

    final class Values
    extends AbstractCollection<V> {
        private /* synthetic */ AbstractMultimap this$0;

        Values(AbstractMultimap abstractMultimap) {
            this.this$0 = abstractMultimap;
        }

        @Override
        public final Iterator<V> iterator() {
            return this.this$0.valueIterator();
        }

        @Override
        public final int size() {
            return this.this$0.size();
        }

        @Override
        public final boolean contains(@Nullable Object o) {
            return this.this$0.containsValue(o);
        }

        @Override
        public final void clear() {
            this.this$0.clear();
        }
    }

    /*
     * Signature claims super is com.squareup.haha.guava.collect.AbstractMultimap$com.squareup.haha.guava.collect.AbstractMultimap$Entries, not com.squareup.haha.guava.collect.AbstractMultimap$Entries - discarding signature.
     */
    final class EntrySet
    extends Entries
    implements Set {
        private EntrySet(AbstractMultimap abstractMultimap) {
            super(abstractMultimap, (byte)0);
        }

        @Override
        public final int hashCode() {
            return Ascii.hashCodeImpl(this);
        }

        @Override
        public final boolean equals(@Nullable Object obj) {
            return Ascii.equalsImpl(this, obj);
        }

        /* synthetic */ EntrySet(AbstractMultimap x0, byte by) {
            this(x0);
        }
    }

    class Entries
    extends Multimaps$Entries<K, V> {
        private /* synthetic */ AbstractMultimap this$0;

        private Entries(AbstractMultimap abstractMultimap) {
            this.this$0 = abstractMultimap;
        }

        @Override
        final Multimap<K, V> multimap() {
            return this.this$0;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return this.this$0.entryIterator();
        }

        /* synthetic */ Entries(AbstractMultimap x0, byte by) {
            this(x0);
        }
    }
}

