# libFuzzer Integration Reference

## Additional Sanitizer Configuration

### MSan

You need to [download prebuilt instrumented libraries](https://www.chromium.org/developers/testing/memorysanitizer#TOC-How-to-build-and-run)
to use MSan ([crbug/653712](https://bugs.chromium.org/p/chromium/issues/detail?id=653712)):
```bash
GYP_DEFINES='use_goma=1 msan=1 use_prebuilt_instrumented_libraries=1' gclient runhooks
```

### UBSan

By default, UBSan does not crash when undefined behavior is detected.
To make it crash, the following option needs to be set in environment:
```bash
UBSAN_OPTIONS=halt_on_error=1 ./fuzzer <corpus_directory_or_single_testcase_path>
```
Other useful options are (also used by ClusterFuzz):
```bash
UBSAN_OPTIONS=symbolize=1:halt_on_error=1:print_stacktrace=1 ./fuzzer <corpus_directory_or_single_testcase_path>
```

## Supported Platforms and Configurations

### Builder configurations

The exact GN arguments that are used on our builders can be generated by
running:

| Builder | Description |
|---------|-------------|
|Linux ASan | `tools/mb/mb.py gen -m chromium.fyi -b 'Libfuzzer Upload Linux ASan' out/Directory` |
|Linux ASan Debug | `tools/mb/mb.py gen -m chromium.fyi -b 'Libfuzzer Upload Linux ASan Debug' out/Directory` |
|Linux MSan \[[*](#MSan)\] | `tools/mb/mb.py gen -m chromium.fyi -b 'Libfuzzer Upload Linux MSan' out/Directory` |
|Linux UBSan \[[*](#UBSan)\]| `tools/mb/mb.py gen -m chromium.fyi -b 'Libfuzzer Upload Linux UBSan' out/Directory` |
|Mac ASan | `tools/mb/mb.py gen -m chromium.fyi -b 'Libfuzzer Upload Mac ASan' out/Directory` |
|Windows ASan | `tools/mb/mb.py gen -m chromium.fyi -b 'Libfuzzer Upload Windows ASan' out/Directory` |


### Linux
Linux is fully supported by libFuzzer and ClusterFuzz with following sanitizer
configurations:

| GN Argument | Description |
|--------------|----|
| is_asan=true | enables [Address Sanitizer] to catch problems like buffer overruns. |
| is_msan=true | enables [Memory Sanitizer] to catch problems like uninitialized reads. \[[*](#MSan)\] |
| is_ubsan_security=true | enables [Undefined Behavior Sanitizer] to catch undefined behavior like integer overflow. \[[*](#UBSan)\] |

Configuration example:

```bash
# With address sanitizer
gn gen out/libfuzzer '--args=use_libfuzzer=true is_asan=true' --check
```

### Mac

Mac is supported by libFuzzer with `is_asan` configuration.

Configuration example:

```bash
gn gen out/libfuzzer '--args=use_libfuzzer=true is_asan=true mac_deployment_target="10.7"' --check
```

### Windows

Windows is supported by libFuzzer with `is_asan` configuration.

Configuration example:

```bash
gn gen out/libfuzzer '--args=use_libfuzzer=true is_asan=true is_debug=false is_component_build=false' --check
```

On Windows you must use `is_component_build=true` as libFuzzer does not support
component builds on Windows. If you are using `is_asan=true` then you must use
`is_debug=false` as ASan does not support debug builds on Windows.
You may also want to consider using `symbol_level=1` which will reduce build
size by reducing symbol level to the level necessary for libFuzzer (useful
if building many fuzz targets).

## fuzzer_test GN Template

Use `fuzzer_test` to define libFuzzer targets:

```
fuzzer_test("my_fuzzer") {
  ...
}
```

Following arguments are supported:

| Argument | Description |
|----------|-------------|
| `sources` | **required** list of fuzzer test source files |
| `deps` | fuzzer dependencies |
| `additional_configs` | additional GN configurations to be used for compilation |
| `dict` | a dictionary file for the fuzzer |
| `libfuzzer_options` | runtime options file for the fuzzer. See [Fuzzer Runtime Options](#Fuzzer-Runtime-Options) |
| `seed_corpus` | single directory containing test inputs, parsed recursively |
| `seed_corpuses` | multiple directories with the same purpose as `seed_corpus` |


## Fuzzer Runtime Options

There are many different runtime options supported by libFuzzer. Options
are passed as command line arguments:

```
./fuzzer [-flag1=val1 [-flag2=val2 ...] ] [dir1 [dir2 ...] ]
```

Most common flags are:

| Flag | Description |
|------|-------------|
| max_len | Maximum length of test input. |
| timeout | Timeout of seconds. Units slower than this value will be reported as bugs. |

Full list of options can be found at [libFuzzer options] page and by running
the binary with `-help=1`.

To specify these options for ClusterFuzz, list all parameters in
`libfuzzer_options` target attribute:

```
fuzzer_test("my_fuzzer") {
  ...
  libfuzzer_options = [
    "max_len=2048",
    "use_traces=1",
  ]
}
```

[libFuzzer options]: http://llvm.org/docs/LibFuzzer.html#options
[Address Sanitizer]: http://clang.llvm.org/docs/AddressSanitizer.html
[Memory Sanitizer]: http://clang.llvm.org/docs/MemorySanitizer.html
[Undefined Behavior Sanitizer]: http://clang.llvm.org/docs/UndefinedBehaviorSanitizer.html

