/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.phonenumbers;

import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.nano.Phonemetadata;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildMetadataFromXml {
    private static final Logger LOGGER = Logger.getLogger(BuildMetadataFromXml.class.getName());
    private static final String CARRIER_CODE_FORMATTING_RULE = "carrierCodeFormattingRule";
    private static final String CARRIER_SPECIFIC = "carrierSpecific";
    private static final String COUNTRY_CODE = "countryCode";
    private static final String EMERGENCY = "emergency";
    private static final String EXAMPLE_NUMBER = "exampleNumber";
    private static final String FIXED_LINE = "fixedLine";
    private static final String FORMAT = "format";
    private static final String GENERAL_DESC = "generalDesc";
    private static final String INTERNATIONAL_PREFIX = "internationalPrefix";
    private static final String INTL_FORMAT = "intlFormat";
    private static final String LEADING_DIGITS = "leadingDigits";
    private static final String LEADING_ZERO_POSSIBLE = "leadingZeroPossible";
    private static final String MAIN_COUNTRY_FOR_CODE = "mainCountryForCode";
    private static final String MOBILE = "mobile";
    private static final String MOBILE_NUMBER_PORTABLE_REGION = "mobileNumberPortableRegion";
    private static final String NATIONAL_NUMBER_PATTERN = "nationalNumberPattern";
    private static final String NATIONAL_PREFIX = "nationalPrefix";
    private static final String NATIONAL_PREFIX_FORMATTING_RULE = "nationalPrefixFormattingRule";
    private static final String NATIONAL_PREFIX_OPTIONAL_WHEN_FORMATTING = "nationalPrefixOptionalWhenFormatting";
    private static final String NATIONAL_PREFIX_FOR_PARSING = "nationalPrefixForParsing";
    private static final String NATIONAL_PREFIX_TRANSFORM_RULE = "nationalPrefixTransformRule";
    private static final String NO_INTERNATIONAL_DIALLING = "noInternationalDialling";
    private static final String NUMBER_FORMAT = "numberFormat";
    private static final String PAGER = "pager";
    private static final String PATTERN = "pattern";
    private static final String PERSONAL_NUMBER = "personalNumber";
    private static final String POSSIBLE_NUMBER_PATTERN = "possibleNumberPattern";
    private static final String PREFERRED_EXTN_PREFIX = "preferredExtnPrefix";
    private static final String PREFERRED_INTERNATIONAL_PREFIX = "preferredInternationalPrefix";
    private static final String PREMIUM_RATE = "premiumRate";
    private static final String SHARED_COST = "sharedCost";
    private static final String SHORT_CODE = "shortCode";
    private static final String STANDARD_RATE = "standardRate";
    private static final String TOLL_FREE = "tollFree";
    private static final String UAN = "uan";
    private static final String VOICEMAIL = "voicemail";
    private static final String VOIP = "voip";

    public static Phonemetadata.PhoneMetadataCollection buildPhoneMetadataCollection(String inputXmlFile, boolean liteBuild) throws Exception {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        File xmlFile = new File(inputXmlFile);
        Document document = builder.parse(xmlFile);
        document.getDocumentElement().normalize();
        Element rootElement = document.getDocumentElement();
        NodeList territory = rootElement.getElementsByTagName("territory");
        Phonemetadata.PhoneMetadataCollection metadataCollection = new Phonemetadata.PhoneMetadataCollection();
        int numOfTerritories = territory.getLength();
        boolean isShortNumberMetadata = inputXmlFile.contains("ShortNumberMetadata");
        boolean isAlternateFormatsMetadata = inputXmlFile.contains("PhoneNumberAlternateFormats");
        ArrayList<Phonemetadata.PhoneMetadata> phoneMetadataList = new ArrayList<Phonemetadata.PhoneMetadata>();
        for (int i = 0; i < numOfTerritories; ++i) {
            Element territoryElement = (Element)territory.item(i);
            String regionCode = "";
            if (territoryElement.hasAttribute("id")) {
                regionCode = territoryElement.getAttribute("id");
            }
            Phonemetadata.PhoneMetadata metadata = BuildMetadataFromXml.loadCountryMetadata(regionCode, territoryElement, liteBuild, isShortNumberMetadata, isAlternateFormatsMetadata);
            phoneMetadataList.add(metadata);
        }
        metadataCollection.metadata = phoneMetadataList.toArray(new Phonemetadata.PhoneMetadata[phoneMetadataList.size()]);
        return metadataCollection;
    }

    public static Map<Integer, List<String>> buildCountryCodeToRegionCodeMap(Phonemetadata.PhoneMetadataCollection metadataCollection) {
        TreeMap<Integer, List<String>> countryCodeToRegionCodeMap = new TreeMap<Integer, List<String>>();
        for (Phonemetadata.PhoneMetadata metadata : metadataCollection.metadata) {
            String regionCode = metadata.id;
            int countryCode = metadata.countryCode;
            if (countryCodeToRegionCodeMap.containsKey(countryCode)) {
                if (metadata.mainCountryForCode) {
                    ((List)countryCodeToRegionCodeMap.get(countryCode)).add(0, regionCode);
                    continue;
                }
                ((List)countryCodeToRegionCodeMap.get(countryCode)).add(regionCode);
                continue;
            }
            ArrayList<String> listWithRegionCode = new ArrayList<String>(1);
            if (!regionCode.equals("")) {
                listWithRegionCode.add(regionCode);
            }
            countryCodeToRegionCodeMap.put(countryCode, listWithRegionCode);
        }
        return countryCodeToRegionCodeMap;
    }

    private static String validateRE(String regex) {
        return BuildMetadataFromXml.validateRE(regex, false);
    }

    static String validateRE(String regex, boolean removeWhitespace) {
        String compressedRegex = removeWhitespace ? regex.replaceAll("\\s", "") : regex;
        Pattern.compile(compressedRegex);
        int errorIndex = compressedRegex.indexOf("|)");
        if (errorIndex >= 0) {
            LOGGER.log(Level.SEVERE, "Error with original regex: " + regex + "\n| should not be followed directly " + "by ) in phone number regular expressions.");
            throw new PatternSyntaxException("| followed by )", compressedRegex, errorIndex);
        }
        return compressedRegex;
    }

    static String getNationalPrefix(Element element) {
        return element.hasAttribute(NATIONAL_PREFIX) ? element.getAttribute(NATIONAL_PREFIX) : "";
    }

    static Phonemetadata.PhoneMetadata loadTerritoryTagMetadata(String regionCode, Element element, String nationalPrefix) {
        Phonemetadata.PhoneMetadata metadata = new Phonemetadata.PhoneMetadata();
        metadata.id = regionCode;
        if (element.hasAttribute(COUNTRY_CODE)) {
            metadata.countryCode = Integer.parseInt(element.getAttribute(COUNTRY_CODE));
        }
        if (element.hasAttribute(LEADING_DIGITS)) {
            metadata.leadingDigits = BuildMetadataFromXml.validateRE(element.getAttribute(LEADING_DIGITS));
        }
        metadata.internationalPrefix = BuildMetadataFromXml.validateRE(element.getAttribute(INTERNATIONAL_PREFIX));
        if (element.hasAttribute(PREFERRED_INTERNATIONAL_PREFIX)) {
            metadata.preferredInternationalPrefix = element.getAttribute(PREFERRED_INTERNATIONAL_PREFIX);
        }
        if (element.hasAttribute(NATIONAL_PREFIX_FOR_PARSING)) {
            metadata.nationalPrefixForParsing = BuildMetadataFromXml.validateRE(element.getAttribute(NATIONAL_PREFIX_FOR_PARSING), true);
            if (element.hasAttribute(NATIONAL_PREFIX_TRANSFORM_RULE)) {
                metadata.nationalPrefixTransformRule = BuildMetadataFromXml.validateRE(element.getAttribute(NATIONAL_PREFIX_TRANSFORM_RULE));
            }
        }
        if (!nationalPrefix.isEmpty()) {
            metadata.nationalPrefix = nationalPrefix;
            if (metadata.nationalPrefixForParsing.equals("")) {
                metadata.nationalPrefixForParsing = nationalPrefix;
            }
        }
        if (element.hasAttribute(PREFERRED_EXTN_PREFIX)) {
            metadata.preferredExtnPrefix = element.getAttribute(PREFERRED_EXTN_PREFIX);
        }
        if (element.hasAttribute(MAIN_COUNTRY_FOR_CODE)) {
            metadata.mainCountryForCode = true;
        }
        if (element.hasAttribute(LEADING_ZERO_POSSIBLE)) {
            metadata.leadingZeroPossible = true;
        }
        if (element.hasAttribute(MOBILE_NUMBER_PORTABLE_REGION)) {
            metadata.mobileNumberPortableRegion = true;
        }
        return metadata;
    }

    static boolean loadInternationalFormat(Phonemetadata.PhoneMetadata metadata, Element numberFormatElement, Phonemetadata.NumberFormat nationalFormat) {
        Phonemetadata.NumberFormat intlFormat = new Phonemetadata.NumberFormat();
        NodeList intlFormatPattern = numberFormatElement.getElementsByTagName(INTL_FORMAT);
        boolean hasExplicitIntlFormatDefined = false;
        if (intlFormatPattern.getLength() > 1) {
            LOGGER.log(Level.SEVERE, "A maximum of one intlFormat pattern for a numberFormat element should be defined.");
            String countryId = metadata.id.length() > 0 ? metadata.id : Integer.toString(metadata.countryCode);
            throw new RuntimeException("Invalid number of intlFormat patterns for country: " + countryId);
        }
        if (intlFormatPattern.getLength() == 0) {
            intlFormat = PhoneNumberUtil.copyNumberFormat(nationalFormat);
        } else {
            intlFormat.pattern = numberFormatElement.getAttribute(PATTERN);
            BuildMetadataFromXml.setLeadingDigitsPatterns(numberFormatElement, intlFormat);
            String intlFormatPatternValue = intlFormatPattern.item(0).getFirstChild().getNodeValue();
            if (!intlFormatPatternValue.equals("NA")) {
                intlFormat.format = intlFormatPatternValue;
            }
            hasExplicitIntlFormatDefined = true;
        }
        if (!intlFormat.format.equals("")) {
            ArrayList<Phonemetadata.NumberFormat> formatList = new ArrayList<Phonemetadata.NumberFormat>(Arrays.asList(metadata.intlNumberFormat));
            formatList.add(intlFormat);
            metadata.intlNumberFormat = formatList.toArray(new Phonemetadata.NumberFormat[formatList.size()]);
        }
        return hasExplicitIntlFormatDefined;
    }

    static void loadNationalFormat(Phonemetadata.PhoneMetadata metadata, Element numberFormatElement, Phonemetadata.NumberFormat format) {
        BuildMetadataFromXml.setLeadingDigitsPatterns(numberFormatElement, format);
        format.pattern = BuildMetadataFromXml.validateRE(numberFormatElement.getAttribute(PATTERN));
        NodeList formatPattern = numberFormatElement.getElementsByTagName(FORMAT);
        int numFormatPatterns = formatPattern.getLength();
        if (numFormatPatterns != 1) {
            LOGGER.log(Level.SEVERE, "One format pattern for a numberFormat element should be defined.");
            String countryId = metadata.id.length() > 0 ? metadata.id : Integer.toString(metadata.countryCode);
            throw new RuntimeException("Invalid number of format patterns (" + numFormatPatterns + ") for country: " + countryId);
        }
        format.format = formatPattern.item(0).getFirstChild().getNodeValue();
    }

    static void loadAvailableFormats(Phonemetadata.PhoneMetadata metadata, Element element, String nationalPrefix, String nationalPrefixFormattingRule, boolean nationalPrefixOptionalWhenFormatting) {
        String carrierCodeFormattingRule = "";
        if (element.hasAttribute(CARRIER_CODE_FORMATTING_RULE)) {
            carrierCodeFormattingRule = BuildMetadataFromXml.validateRE(BuildMetadataFromXml.getDomesticCarrierCodeFormattingRuleFromElement(element, nationalPrefix));
        }
        NodeList numberFormatElements = element.getElementsByTagName(NUMBER_FORMAT);
        boolean hasExplicitIntlFormatDefined = false;
        int numOfFormatElements = numberFormatElements.getLength();
        if (numOfFormatElements > 0) {
            for (int i = 0; i < numOfFormatElements; ++i) {
                Element numberFormatElement = (Element)numberFormatElements.item(i);
                Phonemetadata.NumberFormat format = new Phonemetadata.NumberFormat();
                format.nationalPrefixFormattingRule = numberFormatElement.hasAttribute(NATIONAL_PREFIX_FORMATTING_RULE) ? BuildMetadataFromXml.getNationalPrefixFormattingRuleFromElement(numberFormatElement, nationalPrefix) : nationalPrefixFormattingRule;
                format.nationalPrefixOptionalWhenFormatting = numberFormatElement.hasAttribute(NATIONAL_PREFIX_OPTIONAL_WHEN_FORMATTING) ? Boolean.valueOf(numberFormatElement.getAttribute(NATIONAL_PREFIX_OPTIONAL_WHEN_FORMATTING)) : nationalPrefixOptionalWhenFormatting;
                format.domesticCarrierCodeFormattingRule = numberFormatElement.hasAttribute(CARRIER_CODE_FORMATTING_RULE) ? BuildMetadataFromXml.validateRE(BuildMetadataFromXml.getDomesticCarrierCodeFormattingRuleFromElement(numberFormatElement, nationalPrefix)) : carrierCodeFormattingRule;
                BuildMetadataFromXml.loadNationalFormat(metadata, numberFormatElement, format);
                ArrayList<Phonemetadata.NumberFormat> formatList = new ArrayList<Phonemetadata.NumberFormat>(Arrays.asList(metadata.numberFormat));
                formatList.add(format);
                metadata.numberFormat = formatList.toArray(new Phonemetadata.NumberFormat[formatList.size()]);
                if (!BuildMetadataFromXml.loadInternationalFormat(metadata, numberFormatElement, format)) continue;
                hasExplicitIntlFormatDefined = true;
            }
            if (!hasExplicitIntlFormatDefined) {
                metadata.intlNumberFormat = new Phonemetadata.NumberFormat[0];
            }
        }
    }

    static void setLeadingDigitsPatterns(Element numberFormatElement, Phonemetadata.NumberFormat format) {
        NodeList leadingDigitsPatternNodes = numberFormatElement.getElementsByTagName(LEADING_DIGITS);
        int numOfLeadingDigitsPatterns = leadingDigitsPatternNodes.getLength();
        if (numOfLeadingDigitsPatterns > 0) {
            ArrayList<String> patternList = new ArrayList<String>(Arrays.asList(format.leadingDigitsPattern));
            for (int i = 0; i < numOfLeadingDigitsPatterns; ++i) {
                patternList.add(BuildMetadataFromXml.validateRE(leadingDigitsPatternNodes.item(i).getFirstChild().getNodeValue(), true));
            }
            format.leadingDigitsPattern = patternList.toArray(new String[patternList.size()]);
        }
    }

    static String getNationalPrefixFormattingRuleFromElement(Element element, String nationalPrefix) {
        String nationalPrefixFormattingRule = element.getAttribute(NATIONAL_PREFIX_FORMATTING_RULE);
        nationalPrefixFormattingRule = nationalPrefixFormattingRule.replaceFirst("\\$NP", nationalPrefix).replaceFirst("\\$FG", "\\$1");
        return nationalPrefixFormattingRule;
    }

    static String getDomesticCarrierCodeFormattingRuleFromElement(Element element, String nationalPrefix) {
        String carrierCodeFormattingRule = element.getAttribute(CARRIER_CODE_FORMATTING_RULE);
        carrierCodeFormattingRule = carrierCodeFormattingRule.replaceFirst("\\$FG", "\\$1").replaceFirst("\\$NP", nationalPrefix);
        return carrierCodeFormattingRule;
    }

    static boolean isValidNumberType(String numberType) {
        return numberType.equals(FIXED_LINE) || numberType.equals(MOBILE) || numberType.equals(GENERAL_DESC);
    }

    static Phonemetadata.PhoneNumberDesc processPhoneNumberDescElement(Phonemetadata.PhoneNumberDesc generalDesc, Element countryElement, String numberType, boolean liteBuild) {
        NodeList phoneNumberDescList = countryElement.getElementsByTagName(numberType);
        Phonemetadata.PhoneNumberDesc numberDesc = new Phonemetadata.PhoneNumberDesc();
        if (phoneNumberDescList.getLength() == 0 && !BuildMetadataFromXml.isValidNumberType(numberType)) {
            numberDesc.nationalNumberPattern = "NA";
            numberDesc.possibleNumberPattern = "NA";
            return numberDesc;
        }
        if (!generalDesc.nationalNumberPattern.equals("")) {
            numberDesc.nationalNumberPattern = generalDesc.nationalNumberPattern;
        }
        if (!generalDesc.possibleNumberPattern.equals("")) {
            numberDesc.possibleNumberPattern = generalDesc.possibleNumberPattern;
        }
        if (!generalDesc.exampleNumber.equals("")) {
            numberDesc.exampleNumber = generalDesc.exampleNumber;
        }
        if (phoneNumberDescList.getLength() > 0) {
            NodeList exampleNumber;
            NodeList validPattern;
            Element element = (Element)phoneNumberDescList.item(0);
            NodeList possiblePattern = element.getElementsByTagName(POSSIBLE_NUMBER_PATTERN);
            if (possiblePattern.getLength() > 0) {
                numberDesc.possibleNumberPattern = BuildMetadataFromXml.validateRE(possiblePattern.item(0).getFirstChild().getNodeValue(), true);
            }
            if ((validPattern = element.getElementsByTagName(NATIONAL_NUMBER_PATTERN)).getLength() > 0) {
                numberDesc.nationalNumberPattern = BuildMetadataFromXml.validateRE(validPattern.item(0).getFirstChild().getNodeValue(), true);
            }
            if (!liteBuild && (exampleNumber = element.getElementsByTagName(EXAMPLE_NUMBER)).getLength() > 0) {
                numberDesc.exampleNumber = exampleNumber.item(0).getFirstChild().getNodeValue();
            }
        }
        return numberDesc;
    }

    static void setRelevantDescPatterns(Phonemetadata.PhoneMetadata metadata, Element element, boolean liteBuild, boolean isShortNumberMetadata) {
        Phonemetadata.PhoneNumberDesc generalDesc = new Phonemetadata.PhoneNumberDesc();
        metadata.generalDesc = generalDesc = BuildMetadataFromXml.processPhoneNumberDescElement(generalDesc, element, GENERAL_DESC, liteBuild);
        if (!isShortNumberMetadata) {
            metadata.fixedLine = BuildMetadataFromXml.processPhoneNumberDescElement(generalDesc, element, FIXED_LINE, liteBuild);
            metadata.mobile = BuildMetadataFromXml.processPhoneNumberDescElement(generalDesc, element, MOBILE, liteBuild);
            metadata.sharedCost = BuildMetadataFromXml.processPhoneNumberDescElement(generalDesc, element, SHARED_COST, liteBuild);
            metadata.voip = BuildMetadataFromXml.processPhoneNumberDescElement(generalDesc, element, VOIP, liteBuild);
            metadata.personalNumber = BuildMetadataFromXml.processPhoneNumberDescElement(generalDesc, element, PERSONAL_NUMBER, liteBuild);
            metadata.pager = BuildMetadataFromXml.processPhoneNumberDescElement(generalDesc, element, PAGER, liteBuild);
            metadata.uan = BuildMetadataFromXml.processPhoneNumberDescElement(generalDesc, element, UAN, liteBuild);
            metadata.voicemail = BuildMetadataFromXml.processPhoneNumberDescElement(generalDesc, element, VOICEMAIL, liteBuild);
            metadata.noInternationalDialling = BuildMetadataFromXml.processPhoneNumberDescElement(generalDesc, element, NO_INTERNATIONAL_DIALLING, liteBuild);
            metadata.sameMobileAndFixedLinePattern = metadata.mobile.nationalNumberPattern.equals(metadata.fixedLine.nationalNumberPattern);
        } else {
            metadata.standardRate = BuildMetadataFromXml.processPhoneNumberDescElement(generalDesc, element, STANDARD_RATE, liteBuild);
            metadata.shortCode = BuildMetadataFromXml.processPhoneNumberDescElement(generalDesc, element, SHORT_CODE, liteBuild);
            metadata.carrierSpecific = BuildMetadataFromXml.processPhoneNumberDescElement(generalDesc, element, CARRIER_SPECIFIC, liteBuild);
            metadata.emergency = BuildMetadataFromXml.processPhoneNumberDescElement(generalDesc, element, EMERGENCY, liteBuild);
        }
        metadata.tollFree = BuildMetadataFromXml.processPhoneNumberDescElement(generalDesc, element, TOLL_FREE, liteBuild);
        metadata.premiumRate = BuildMetadataFromXml.processPhoneNumberDescElement(generalDesc, element, PREMIUM_RATE, liteBuild);
    }

    static Phonemetadata.PhoneMetadata loadCountryMetadata(String regionCode, Element element, boolean liteBuild, boolean isShortNumberMetadata, boolean isAlternateFormatsMetadata) {
        String nationalPrefix = BuildMetadataFromXml.getNationalPrefix(element);
        Phonemetadata.PhoneMetadata metadata = BuildMetadataFromXml.loadTerritoryTagMetadata(regionCode, element, nationalPrefix);
        String nationalPrefixFormattingRule = BuildMetadataFromXml.getNationalPrefixFormattingRuleFromElement(element, nationalPrefix);
        BuildMetadataFromXml.loadAvailableFormats(metadata, element, nationalPrefix, nationalPrefixFormattingRule, element.hasAttribute(NATIONAL_PREFIX_OPTIONAL_WHEN_FORMATTING));
        if (!isAlternateFormatsMetadata) {
            BuildMetadataFromXml.setRelevantDescPatterns(metadata, element, liteBuild, isShortNumberMetadata);
        }
        return metadata;
    }
}

