// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_WEB_APPLICATIONS_COMPONENTS_INSTALL_MANAGER_OBSERVER_H_
#define CHROME_BROWSER_WEB_APPLICATIONS_COMPONENTS_INSTALL_MANAGER_OBSERVER_H_

#include "base/observer_list_types.h"

namespace web_app {

class InstallManagerObserver : public base::CheckedObserver {
 public:
  // Called before InstallManager subsystem gets destroyed.
  virtual void InstallManagerReset() = 0;
};

}  // namespace web_app

#endif  // CHROME_BROWSER_WEB_APPLICATIONS_COMPONENTS_INSTALL_MANAGER_OBSERVER_H_
