//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

// <valarray>

// template<class T> class valarray;

// valarray operator[](slice s) const;

#include <valarray>
#include <cassert>

int main(int, char**)
{
    {
        int a1[] = {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        const std::valarray<int> v1(a1, sizeof(a1)/sizeof(a1[0]));
        std::valarray<int> v2 = v1[std::slice(1, 5, 3)];
        assert(v2.size() == 5);
        assert(v2[0] ==  1);
        assert(v2[1] ==  4);
        assert(v2[2] ==  7);
        assert(v2[3] == 10);
        assert(v2[4] == 13);
    }
    {
        int a1[] = {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        const std::valarray<int> v1(a1, sizeof(a1)/sizeof(a1[0]));
        std::valarray<int> v2 = (v1 + 0)[std::slice(0, 2, 3)];
        assert(v2.size() == 2);
        assert(v2[0] ==  0);
        assert(v2[1] == 3);
    }
  return 0;
}
