// Copyright 2018 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_WEB_APPLICATIONS_WEB_APP_DATABASE_FACTORY_H_
#define CHROME_BROWSER_WEB_APPLICATIONS_WEB_APP_DATABASE_FACTORY_H_

#include <memory>

#include "base/macros.h"
#include "components/sync/model/model_type_store.h"

class Profile;

namespace syncer {
class ModelTypeStoreService;
}  // namespace syncer

namespace web_app {

class AbstractWebAppDatabaseFactory {
 public:
  virtual ~AbstractWebAppDatabaseFactory() = default;
  virtual syncer::OnceModelTypeStoreFactory GetStoreFactory() = 0;
};

class WebAppDatabaseFactory : public AbstractWebAppDatabaseFactory {
 public:
  explicit WebAppDatabaseFactory(Profile* profile);
  ~WebAppDatabaseFactory() override;

  // AbstractWebAppDatabaseFactory implementation.
  syncer::OnceModelTypeStoreFactory GetStoreFactory() override;

 private:
  // TODO(loyso): Consider using shared ModelTypeStoreService from profile.
  // crbug.com/902214.
  std::unique_ptr<syncer::ModelTypeStoreService> model_type_store_service_;

  DISALLOW_COPY_AND_ASSIGN(WebAppDatabaseFactory);
};

}  // namespace web_app

#endif  // CHROME_BROWSER_WEB_APPLICATIONS_WEB_APP_DATABASE_FACTORY_H_
