// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_VIZ_SERVICE_DISPLAY_EMBEDDER_SKIA_OUTPUT_SURFACE_DEPENDENCY_IMPL_H_
#define COMPONENTS_VIZ_SERVICE_DISPLAY_EMBEDDER_SKIA_OUTPUT_SURFACE_DEPENDENCY_IMPL_H_

#include "base/macros.h"
#include "build/build_config.h"
#include "components/viz/service/display_embedder/skia_output_surface_dependency.h"

namespace base {
class SingleThreadTaskRunner;
}

namespace viz {

class GpuServiceImpl;

class VIZ_SERVICE_EXPORT SkiaOutputSurfaceDependencyImpl
    : public SkiaOutputSurfaceDependency {
 public:
  SkiaOutputSurfaceDependencyImpl(GpuServiceImpl* gpu_service_impl,
                                  gpu::SurfaceHandle surface_handle);
  ~SkiaOutputSurfaceDependencyImpl() override;

  void ScheduleGpuTask(base::OnceClosure task,
                       std::vector<gpu::SyncToken> sync_tokens) override;
  bool IsUsingVulkan() override;
  gpu::SharedImageManager* GetSharedImageManager() override;
  gpu::SyncPointManager* GetSyncPointManager() override;
  const gpu::GpuDriverBugWorkarounds& GetGpuDriverBugWorkarounds() override;
  scoped_refptr<gpu::SharedContextState> GetSharedContextState() override;
  gpu::raster::GrShaderCache* GetGrShaderCache() override;
  VulkanContextProvider* GetVulkanContextProvider() override;
  const gpu::GpuPreferences& GetGpuPreferences() override;
  gpu::SequenceId GetSequenceId() override;
  const gpu::GpuFeatureInfo& GetGpuFeatureInfo() override;
  gpu::MailboxManager* GetMailboxManager() override;
  bool IsOffscreen() override;
  gpu::SurfaceHandle GetSurfaceHandle() override;
  scoped_refptr<gl::GLSurface> CreateGLSurface(
      base::WeakPtr<gpu::ImageTransportSurfaceDelegate> stub) override;
  void PostTaskToClientThread(base::OnceClosure closure) override;
  void ScheduleGrContextCleanup() override;

#if defined(OS_WIN)
  void DidCreateAcceleratedSurfaceChildWindow(
      gpu::SurfaceHandle parent_window,
      gpu::SurfaceHandle child_window) override;
#endif

 private:
  GpuServiceImpl* const gpu_service_impl_;
  const gpu::SurfaceHandle surface_handle_;
  scoped_refptr<base::SingleThreadTaskRunner> client_thread_task_runner_;

  DISALLOW_COPY_AND_ASSIGN(SkiaOutputSurfaceDependencyImpl);
};

}  // namespace viz

#endif  // COMPONENTS_VIZ_SERVICE_DISPLAY_EMBEDDER_SKIA_OUTPUT_SURFACE_DEPENDENCY_IMPL_H_
