// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from gl.xml and gl_angle_ext.xml.
//
// Copyright 2019 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// capture_gles_2_0_autogen.cpp:
//   Capture functions for the OpenGL ES 2.0 entry points.

#include "libANGLE/capture_gles_2_0_autogen.h"

#include "libANGLE/Context.h"
#include "libANGLE/FrameCapture.h"
#include "libANGLE/validationES2.h"

using namespace angle;

namespace gl
{

CallCapture CaptureActiveTexture(const Context *context, bool isCallValid, GLenum texture)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("texture", ParamType::TGLenum, texture);

    return CallCapture("glActiveTexture", std::move(paramBuffer));
}

CallCapture CaptureAttachShader(const Context *context,
                                bool isCallValid,
                                GLuint program,
                                GLuint shader)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::TGLuint, program);
    paramBuffer.addValueParam("shader", ParamType::TGLuint, shader);

    return CallCapture("glAttachShader", std::move(paramBuffer));
}

CallCapture CaptureBindAttribLocation(const Context *context,
                                      bool isCallValid,
                                      GLuint program,
                                      GLuint index,
                                      const GLchar *name)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::TGLuint, program);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
    InitParamValue(ParamType::TGLcharConstPointer, name, &nameParam.value);
    CaptureBindAttribLocation_name(context, isCallValid, program, index, name, &nameParam);
    paramBuffer.addParam(std::move(nameParam));

    return CallCapture("glBindAttribLocation", std::move(paramBuffer));
}

CallCapture CaptureBindBuffer(const Context *context,
                              bool isCallValid,
                              BufferBinding targetPacked,
                              GLuint buffer)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);
    paramBuffer.addValueParam("buffer", ParamType::TGLuint, buffer);

    return CallCapture("glBindBuffer", std::move(paramBuffer));
}

CallCapture CaptureBindFramebuffer(const Context *context,
                                   bool isCallValid,
                                   GLenum target,
                                   GLuint framebuffer)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("target", ParamType::TGLenum, target);
    paramBuffer.addValueParam("framebuffer", ParamType::TGLuint, framebuffer);

    return CallCapture("glBindFramebuffer", std::move(paramBuffer));
}

CallCapture CaptureBindRenderbuffer(const Context *context,
                                    bool isCallValid,
                                    GLenum target,
                                    GLuint renderbuffer)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("target", ParamType::TGLenum, target);
    paramBuffer.addValueParam("renderbuffer", ParamType::TGLuint, renderbuffer);

    return CallCapture("glBindRenderbuffer", std::move(paramBuffer));
}

CallCapture CaptureBindTexture(const Context *context,
                               bool isCallValid,
                               TextureType targetPacked,
                               GLuint texture)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("texture", ParamType::TGLuint, texture);

    return CallCapture("glBindTexture", std::move(paramBuffer));
}

CallCapture CaptureBlendColor(const Context *context,
                              bool isCallValid,
                              GLfloat red,
                              GLfloat green,
                              GLfloat blue,
                              GLfloat alpha)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("red", ParamType::TGLfloat, red);
    paramBuffer.addValueParam("green", ParamType::TGLfloat, green);
    paramBuffer.addValueParam("blue", ParamType::TGLfloat, blue);
    paramBuffer.addValueParam("alpha", ParamType::TGLfloat, alpha);

    return CallCapture("glBlendColor", std::move(paramBuffer));
}

CallCapture CaptureBlendEquation(const Context *context, bool isCallValid, GLenum mode)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("mode", ParamType::TGLenum, mode);

    return CallCapture("glBlendEquation", std::move(paramBuffer));
}

CallCapture CaptureBlendEquationSeparate(const Context *context,
                                         bool isCallValid,
                                         GLenum modeRGB,
                                         GLenum modeAlpha)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modeRGB", ParamType::TGLenum, modeRGB);
    paramBuffer.addValueParam("modeAlpha", ParamType::TGLenum, modeAlpha);

    return CallCapture("glBlendEquationSeparate", std::move(paramBuffer));
}

CallCapture CaptureBlendFunc(const Context *context,
                             bool isCallValid,
                             GLenum sfactor,
                             GLenum dfactor)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("sfactor", ParamType::TGLenum, sfactor);
    paramBuffer.addValueParam("dfactor", ParamType::TGLenum, dfactor);

    return CallCapture("glBlendFunc", std::move(paramBuffer));
}

CallCapture CaptureBlendFuncSeparate(const Context *context,
                                     bool isCallValid,
                                     GLenum sfactorRGB,
                                     GLenum dfactorRGB,
                                     GLenum sfactorAlpha,
                                     GLenum dfactorAlpha)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("sfactorRGB", ParamType::TGLenum, sfactorRGB);
    paramBuffer.addValueParam("dfactorRGB", ParamType::TGLenum, dfactorRGB);
    paramBuffer.addValueParam("sfactorAlpha", ParamType::TGLenum, sfactorAlpha);
    paramBuffer.addValueParam("dfactorAlpha", ParamType::TGLenum, dfactorAlpha);

    return CallCapture("glBlendFuncSeparate", std::move(paramBuffer));
}

CallCapture CaptureBufferData(const Context *context,
                              bool isCallValid,
                              BufferBinding targetPacked,
                              GLsizeiptr size,
                              const void *data,
                              BufferUsage usagePacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);
    paramBuffer.addValueParam("size", ParamType::TGLsizeiptr, size);

    ParamCapture dataParam("data", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, data, &dataParam.value);
    CaptureBufferData_data(context, isCallValid, targetPacked, size, data, usagePacked, &dataParam);
    paramBuffer.addParam(std::move(dataParam));

    paramBuffer.addValueParam("usagePacked", ParamType::TBufferUsage, usagePacked);

    return CallCapture("glBufferData", std::move(paramBuffer));
}

CallCapture CaptureBufferSubData(const Context *context,
                                 bool isCallValid,
                                 BufferBinding targetPacked,
                                 GLintptr offset,
                                 GLsizeiptr size,
                                 const void *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);
    paramBuffer.addValueParam("offset", ParamType::TGLintptr, offset);
    paramBuffer.addValueParam("size", ParamType::TGLsizeiptr, size);

    ParamCapture dataParam("data", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, data, &dataParam.value);
    CaptureBufferSubData_data(context, isCallValid, targetPacked, offset, size, data, &dataParam);
    paramBuffer.addParam(std::move(dataParam));

    return CallCapture("glBufferSubData", std::move(paramBuffer));
}

CallCapture CaptureCheckFramebufferStatus(const Context *context, bool isCallValid, GLenum target)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("target", ParamType::TGLenum, target);

    return CallCapture("glCheckFramebufferStatus", std::move(paramBuffer));
}

CallCapture CaptureClear(const Context *context, bool isCallValid, GLbitfield mask)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("mask", ParamType::TGLbitfield, mask);

    return CallCapture("glClear", std::move(paramBuffer));
}

CallCapture CaptureClearColor(const Context *context,
                              bool isCallValid,
                              GLfloat red,
                              GLfloat green,
                              GLfloat blue,
                              GLfloat alpha)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("red", ParamType::TGLfloat, red);
    paramBuffer.addValueParam("green", ParamType::TGLfloat, green);
    paramBuffer.addValueParam("blue", ParamType::TGLfloat, blue);
    paramBuffer.addValueParam("alpha", ParamType::TGLfloat, alpha);

    return CallCapture("glClearColor", std::move(paramBuffer));
}

CallCapture CaptureClearDepthf(const Context *context, bool isCallValid, GLfloat d)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("d", ParamType::TGLfloat, d);

    return CallCapture("glClearDepthf", std::move(paramBuffer));
}

CallCapture CaptureClearStencil(const Context *context, bool isCallValid, GLint s)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("s", ParamType::TGLint, s);

    return CallCapture("glClearStencil", std::move(paramBuffer));
}

CallCapture CaptureColorMask(const Context *context,
                             bool isCallValid,
                             GLboolean red,
                             GLboolean green,
                             GLboolean blue,
                             GLboolean alpha)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("red", ParamType::TGLboolean, red);
    paramBuffer.addValueParam("green", ParamType::TGLboolean, green);
    paramBuffer.addValueParam("blue", ParamType::TGLboolean, blue);
    paramBuffer.addValueParam("alpha", ParamType::TGLboolean, alpha);

    return CallCapture("glColorMask", std::move(paramBuffer));
}

CallCapture CaptureCompileShader(const Context *context, bool isCallValid, GLuint shader)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("shader", ParamType::TGLuint, shader);

    return CallCapture("glCompileShader", std::move(paramBuffer));
}

CallCapture CaptureCompressedTexImage2D(const Context *context,
                                        bool isCallValid,
                                        TextureTarget targetPacked,
                                        GLint level,
                                        GLenum internalformat,
                                        GLsizei width,
                                        GLsizei height,
                                        GLint border,
                                        GLsizei imageSize,
                                        const void *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("internalformat", ParamType::TGLenum, internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("border", ParamType::TGLint, border);
    paramBuffer.addValueParam("imageSize", ParamType::TGLsizei, imageSize);

    ParamCapture dataParam("data", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, data, &dataParam.value);
    CaptureCompressedTexImage2D_data(context, isCallValid, targetPacked, level, internalformat,
                                     width, height, border, imageSize, data, &dataParam);
    paramBuffer.addParam(std::move(dataParam));

    return CallCapture("glCompressedTexImage2D", std::move(paramBuffer));
}

CallCapture CaptureCompressedTexSubImage2D(const Context *context,
                                           bool isCallValid,
                                           TextureTarget targetPacked,
                                           GLint level,
                                           GLint xoffset,
                                           GLint yoffset,
                                           GLsizei width,
                                           GLsizei height,
                                           GLenum format,
                                           GLsizei imageSize,
                                           const void *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLint, yoffset);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("format", ParamType::TGLenum, format);
    paramBuffer.addValueParam("imageSize", ParamType::TGLsizei, imageSize);

    ParamCapture dataParam("data", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, data, &dataParam.value);
    CaptureCompressedTexSubImage2D_data(context, isCallValid, targetPacked, level, xoffset, yoffset,
                                        width, height, format, imageSize, data, &dataParam);
    paramBuffer.addParam(std::move(dataParam));

    return CallCapture("glCompressedTexSubImage2D", std::move(paramBuffer));
}

CallCapture CaptureCopyTexImage2D(const Context *context,
                                  bool isCallValid,
                                  TextureTarget targetPacked,
                                  GLint level,
                                  GLenum internalformat,
                                  GLint x,
                                  GLint y,
                                  GLsizei width,
                                  GLsizei height,
                                  GLint border)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("internalformat", ParamType::TGLenum, internalformat);
    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("border", ParamType::TGLint, border);

    return CallCapture("glCopyTexImage2D", std::move(paramBuffer));
}

CallCapture CaptureCopyTexSubImage2D(const Context *context,
                                     bool isCallValid,
                                     TextureTarget targetPacked,
                                     GLint level,
                                     GLint xoffset,
                                     GLint yoffset,
                                     GLint x,
                                     GLint y,
                                     GLsizei width,
                                     GLsizei height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLint, yoffset);
    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);

    return CallCapture("glCopyTexSubImage2D", std::move(paramBuffer));
}

CallCapture CaptureCreateProgram(const Context *context, bool isCallValid)
{
    ParamBuffer paramBuffer;

    return CallCapture("glCreateProgram", std::move(paramBuffer));
}

CallCapture CaptureCreateShader(const Context *context, bool isCallValid, ShaderType typePacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("typePacked", ParamType::TShaderType, typePacked);

    return CallCapture("glCreateShader", std::move(paramBuffer));
}

CallCapture CaptureCullFace(const Context *context, bool isCallValid, CullFaceMode modePacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TCullFaceMode, modePacked);

    return CallCapture("glCullFace", std::move(paramBuffer));
}

CallCapture CaptureDeleteBuffers(const Context *context,
                                 bool isCallValid,
                                 GLsizei n,
                                 const GLuint *buffers)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture buffersParam("buffers", ParamType::TGLuintConstPointer);
    InitParamValue(ParamType::TGLuintConstPointer, buffers, &buffersParam.value);
    CaptureDeleteBuffers_buffers(context, isCallValid, n, buffers, &buffersParam);
    paramBuffer.addParam(std::move(buffersParam));

    return CallCapture("glDeleteBuffers", std::move(paramBuffer));
}

CallCapture CaptureDeleteFramebuffers(const Context *context,
                                      bool isCallValid,
                                      GLsizei n,
                                      const GLuint *framebuffers)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture framebuffersParam("framebuffers", ParamType::TGLuintConstPointer);
    InitParamValue(ParamType::TGLuintConstPointer, framebuffers, &framebuffersParam.value);
    CaptureDeleteFramebuffers_framebuffers(context, isCallValid, n, framebuffers,
                                           &framebuffersParam);
    paramBuffer.addParam(std::move(framebuffersParam));

    return CallCapture("glDeleteFramebuffers", std::move(paramBuffer));
}

CallCapture CaptureDeleteProgram(const Context *context, bool isCallValid, GLuint program)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::TGLuint, program);

    return CallCapture("glDeleteProgram", std::move(paramBuffer));
}

CallCapture CaptureDeleteRenderbuffers(const Context *context,
                                       bool isCallValid,
                                       GLsizei n,
                                       const GLuint *renderbuffers)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture renderbuffersParam("renderbuffers", ParamType::TGLuintConstPointer);
    InitParamValue(ParamType::TGLuintConstPointer, renderbuffers, &renderbuffersParam.value);
    CaptureDeleteRenderbuffers_renderbuffers(context, isCallValid, n, renderbuffers,
                                             &renderbuffersParam);
    paramBuffer.addParam(std::move(renderbuffersParam));

    return CallCapture("glDeleteRenderbuffers", std::move(paramBuffer));
}

CallCapture CaptureDeleteShader(const Context *context, bool isCallValid, GLuint shader)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("shader", ParamType::TGLuint, shader);

    return CallCapture("glDeleteShader", std::move(paramBuffer));
}

CallCapture CaptureDeleteTextures(const Context *context,
                                  bool isCallValid,
                                  GLsizei n,
                                  const GLuint *textures)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture texturesParam("textures", ParamType::TGLuintConstPointer);
    InitParamValue(ParamType::TGLuintConstPointer, textures, &texturesParam.value);
    CaptureDeleteTextures_textures(context, isCallValid, n, textures, &texturesParam);
    paramBuffer.addParam(std::move(texturesParam));

    return CallCapture("glDeleteTextures", std::move(paramBuffer));
}

CallCapture CaptureDepthFunc(const Context *context, bool isCallValid, GLenum func)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("func", ParamType::TGLenum, func);

    return CallCapture("glDepthFunc", std::move(paramBuffer));
}

CallCapture CaptureDepthMask(const Context *context, bool isCallValid, GLboolean flag)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("flag", ParamType::TGLboolean, flag);

    return CallCapture("glDepthMask", std::move(paramBuffer));
}

CallCapture CaptureDepthRangef(const Context *context, bool isCallValid, GLfloat n, GLfloat f)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLfloat, n);
    paramBuffer.addValueParam("f", ParamType::TGLfloat, f);

    return CallCapture("glDepthRangef", std::move(paramBuffer));
}

CallCapture CaptureDetachShader(const Context *context,
                                bool isCallValid,
                                GLuint program,
                                GLuint shader)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::TGLuint, program);
    paramBuffer.addValueParam("shader", ParamType::TGLuint, shader);

    return CallCapture("glDetachShader", std::move(paramBuffer));
}

CallCapture CaptureDisable(const Context *context, bool isCallValid, GLenum cap)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("cap", ParamType::TGLenum, cap);

    return CallCapture("glDisable", std::move(paramBuffer));
}

CallCapture CaptureDisableVertexAttribArray(const Context *context, bool isCallValid, GLuint index)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    return CallCapture("glDisableVertexAttribArray", std::move(paramBuffer));
}

CallCapture CaptureDrawArrays(const Context *context,
                              bool isCallValid,
                              PrimitiveMode modePacked,
                              GLint first,
                              GLsizei count)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("first", ParamType::TGLint, first);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    return CallCapture("glDrawArrays", std::move(paramBuffer));
}

CallCapture CaptureDrawElements(const Context *context,
                                bool isCallValid,
                                PrimitiveMode modePacked,
                                GLsizei count,
                                DrawElementsType typePacked,
                                const void *indices)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("typePacked", ParamType::TDrawElementsType, typePacked);

    ParamCapture indicesParam("indices", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, indices, &indicesParam.value);
    CaptureDrawElements_indices(context, isCallValid, modePacked, count, typePacked, indices,
                                &indicesParam);
    paramBuffer.addParam(std::move(indicesParam));

    return CallCapture("glDrawElements", std::move(paramBuffer));
}

CallCapture CaptureEnable(const Context *context, bool isCallValid, GLenum cap)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("cap", ParamType::TGLenum, cap);

    return CallCapture("glEnable", std::move(paramBuffer));
}

CallCapture CaptureEnableVertexAttribArray(const Context *context, bool isCallValid, GLuint index)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    return CallCapture("glEnableVertexAttribArray", std::move(paramBuffer));
}

CallCapture CaptureFinish(const Context *context, bool isCallValid)
{
    ParamBuffer paramBuffer;

    return CallCapture("glFinish", std::move(paramBuffer));
}

CallCapture CaptureFlush(const Context *context, bool isCallValid)
{
    ParamBuffer paramBuffer;

    return CallCapture("glFlush", std::move(paramBuffer));
}

CallCapture CaptureFramebufferRenderbuffer(const Context *context,
                                           bool isCallValid,
                                           GLenum target,
                                           GLenum attachment,
                                           GLenum renderbuffertarget,
                                           GLuint renderbuffer)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("target", ParamType::TGLenum, target);
    paramBuffer.addValueParam("attachment", ParamType::TGLenum, attachment);
    paramBuffer.addValueParam("renderbuffertarget", ParamType::TGLenum, renderbuffertarget);
    paramBuffer.addValueParam("renderbuffer", ParamType::TGLuint, renderbuffer);

    return CallCapture("glFramebufferRenderbuffer", std::move(paramBuffer));
}

CallCapture CaptureFramebufferTexture2D(const Context *context,
                                        bool isCallValid,
                                        GLenum target,
                                        GLenum attachment,
                                        TextureTarget textargetPacked,
                                        GLuint texture,
                                        GLint level)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("target", ParamType::TGLenum, target);
    paramBuffer.addValueParam("attachment", ParamType::TGLenum, attachment);
    paramBuffer.addValueParam("textargetPacked", ParamType::TTextureTarget, textargetPacked);
    paramBuffer.addValueParam("texture", ParamType::TGLuint, texture);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);

    return CallCapture("glFramebufferTexture2D", std::move(paramBuffer));
}

CallCapture CaptureFrontFace(const Context *context, bool isCallValid, GLenum mode)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("mode", ParamType::TGLenum, mode);

    return CallCapture("glFrontFace", std::move(paramBuffer));
}

CallCapture CaptureGenBuffers(const Context *context, bool isCallValid, GLsizei n, GLuint *buffers)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture buffersParam("buffers", ParamType::TGLuintPointer);
    InitParamValue(ParamType::TGLuintPointer, buffers, &buffersParam.value);
    CaptureGenBuffers_buffers(context, isCallValid, n, buffers, &buffersParam);
    paramBuffer.addParam(std::move(buffersParam));

    return CallCapture("glGenBuffers", std::move(paramBuffer));
}

CallCapture CaptureGenFramebuffers(const Context *context,
                                   bool isCallValid,
                                   GLsizei n,
                                   GLuint *framebuffers)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture framebuffersParam("framebuffers", ParamType::TGLuintPointer);
    InitParamValue(ParamType::TGLuintPointer, framebuffers, &framebuffersParam.value);
    CaptureGenFramebuffers_framebuffers(context, isCallValid, n, framebuffers, &framebuffersParam);
    paramBuffer.addParam(std::move(framebuffersParam));

    return CallCapture("glGenFramebuffers", std::move(paramBuffer));
}

CallCapture CaptureGenRenderbuffers(const Context *context,
                                    bool isCallValid,
                                    GLsizei n,
                                    GLuint *renderbuffers)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture renderbuffersParam("renderbuffers", ParamType::TGLuintPointer);
    InitParamValue(ParamType::TGLuintPointer, renderbuffers, &renderbuffersParam.value);
    CaptureGenRenderbuffers_renderbuffers(context, isCallValid, n, renderbuffers,
                                          &renderbuffersParam);
    paramBuffer.addParam(std::move(renderbuffersParam));

    return CallCapture("glGenRenderbuffers", std::move(paramBuffer));
}

CallCapture CaptureGenTextures(const Context *context,
                               bool isCallValid,
                               GLsizei n,
                               GLuint *textures)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture texturesParam("textures", ParamType::TGLuintPointer);
    InitParamValue(ParamType::TGLuintPointer, textures, &texturesParam.value);
    CaptureGenTextures_textures(context, isCallValid, n, textures, &texturesParam);
    paramBuffer.addParam(std::move(texturesParam));

    return CallCapture("glGenTextures", std::move(paramBuffer));
}

CallCapture CaptureGenerateMipmap(const Context *context,
                                  bool isCallValid,
                                  TextureType targetPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);

    return CallCapture("glGenerateMipmap", std::move(paramBuffer));
}

CallCapture CaptureGetActiveAttrib(const Context *context,
                                   bool isCallValid,
                                   GLuint program,
                                   GLuint index,
                                   GLsizei bufSize,
                                   GLsizei *length,
                                   GLint *size,
                                   GLenum *type,
                                   GLchar *name)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::TGLuint, program);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetActiveAttrib_length(context, isCallValid, program, index, bufSize, length, size, type,
                                  name, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture sizeParam("size", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, size, &sizeParam.value);
    CaptureGetActiveAttrib_size(context, isCallValid, program, index, bufSize, length, size, type,
                                name, &sizeParam);
    paramBuffer.addParam(std::move(sizeParam));

    ParamCapture typeParam("type", ParamType::TGLenumPointer);
    InitParamValue(ParamType::TGLenumPointer, type, &typeParam.value);
    CaptureGetActiveAttrib_type(context, isCallValid, program, index, bufSize, length, size, type,
                                name, &typeParam);
    paramBuffer.addParam(std::move(typeParam));

    ParamCapture nameParam("name", ParamType::TGLcharPointer);
    InitParamValue(ParamType::TGLcharPointer, name, &nameParam.value);
    CaptureGetActiveAttrib_name(context, isCallValid, program, index, bufSize, length, size, type,
                                name, &nameParam);
    paramBuffer.addParam(std::move(nameParam));

    return CallCapture("glGetActiveAttrib", std::move(paramBuffer));
}

CallCapture CaptureGetActiveUniform(const Context *context,
                                    bool isCallValid,
                                    GLuint program,
                                    GLuint index,
                                    GLsizei bufSize,
                                    GLsizei *length,
                                    GLint *size,
                                    GLenum *type,
                                    GLchar *name)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::TGLuint, program);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetActiveUniform_length(context, isCallValid, program, index, bufSize, length, size,
                                   type, name, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture sizeParam("size", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, size, &sizeParam.value);
    CaptureGetActiveUniform_size(context, isCallValid, program, index, bufSize, length, size, type,
                                 name, &sizeParam);
    paramBuffer.addParam(std::move(sizeParam));

    ParamCapture typeParam("type", ParamType::TGLenumPointer);
    InitParamValue(ParamType::TGLenumPointer, type, &typeParam.value);
    CaptureGetActiveUniform_type(context, isCallValid, program, index, bufSize, length, size, type,
                                 name, &typeParam);
    paramBuffer.addParam(std::move(typeParam));

    ParamCapture nameParam("name", ParamType::TGLcharPointer);
    InitParamValue(ParamType::TGLcharPointer, name, &nameParam.value);
    CaptureGetActiveUniform_name(context, isCallValid, program, index, bufSize, length, size, type,
                                 name, &nameParam);
    paramBuffer.addParam(std::move(nameParam));

    return CallCapture("glGetActiveUniform", std::move(paramBuffer));
}

CallCapture CaptureGetAttachedShaders(const Context *context,
                                      bool isCallValid,
                                      GLuint program,
                                      GLsizei maxCount,
                                      GLsizei *count,
                                      GLuint *shaders)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::TGLuint, program);
    paramBuffer.addValueParam("maxCount", ParamType::TGLsizei, maxCount);

    ParamCapture countParam("count", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, count, &countParam.value);
    CaptureGetAttachedShaders_count(context, isCallValid, program, maxCount, count, shaders,
                                    &countParam);
    paramBuffer.addParam(std::move(countParam));

    ParamCapture shadersParam("shaders", ParamType::TGLuintPointer);
    InitParamValue(ParamType::TGLuintPointer, shaders, &shadersParam.value);
    CaptureGetAttachedShaders_shaders(context, isCallValid, program, maxCount, count, shaders,
                                      &shadersParam);
    paramBuffer.addParam(std::move(shadersParam));

    return CallCapture("glGetAttachedShaders", std::move(paramBuffer));
}

CallCapture CaptureGetAttribLocation(const Context *context,
                                     bool isCallValid,
                                     GLuint program,
                                     const GLchar *name)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::TGLuint, program);

    ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
    InitParamValue(ParamType::TGLcharConstPointer, name, &nameParam.value);
    CaptureGetAttribLocation_name(context, isCallValid, program, name, &nameParam);
    paramBuffer.addParam(std::move(nameParam));

    return CallCapture("glGetAttribLocation", std::move(paramBuffer));
}

CallCapture CaptureGetBooleanv(const Context *context,
                               bool isCallValid,
                               GLenum pname,
                               GLboolean *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);

    ParamCapture dataParam("data", ParamType::TGLbooleanPointer);
    InitParamValue(ParamType::TGLbooleanPointer, data, &dataParam.value);
    CaptureGetBooleanv_data(context, isCallValid, pname, data, &dataParam);
    paramBuffer.addParam(std::move(dataParam));

    return CallCapture("glGetBooleanv", std::move(paramBuffer));
}

CallCapture CaptureGetBufferParameteriv(const Context *context,
                                        bool isCallValid,
                                        BufferBinding targetPacked,
                                        GLenum pname,
                                        GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetBufferParameteriv_params(context, isCallValid, targetPacked, pname, params,
                                       &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetBufferParameteriv", std::move(paramBuffer));
}

CallCapture CaptureGetError(const Context *context, bool isCallValid)
{
    ParamBuffer paramBuffer;

    return CallCapture("glGetError", std::move(paramBuffer));
}

CallCapture CaptureGetFloatv(const Context *context, bool isCallValid, GLenum pname, GLfloat *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);

    ParamCapture dataParam("data", ParamType::TGLfloatPointer);
    InitParamValue(ParamType::TGLfloatPointer, data, &dataParam.value);
    CaptureGetFloatv_data(context, isCallValid, pname, data, &dataParam);
    paramBuffer.addParam(std::move(dataParam));

    return CallCapture("glGetFloatv", std::move(paramBuffer));
}

CallCapture CaptureGetFramebufferAttachmentParameteriv(const Context *context,
                                                       bool isCallValid,
                                                       GLenum target,
                                                       GLenum attachment,
                                                       GLenum pname,
                                                       GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("target", ParamType::TGLenum, target);
    paramBuffer.addValueParam("attachment", ParamType::TGLenum, attachment);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetFramebufferAttachmentParameteriv_params(context, isCallValid, target, attachment,
                                                      pname, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetFramebufferAttachmentParameteriv", std::move(paramBuffer));
}

CallCapture CaptureGetIntegerv(const Context *context, bool isCallValid, GLenum pname, GLint *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);

    ParamCapture dataParam("data", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, data, &dataParam.value);
    CaptureGetIntegerv_data(context, isCallValid, pname, data, &dataParam);
    paramBuffer.addParam(std::move(dataParam));

    return CallCapture("glGetIntegerv", std::move(paramBuffer));
}

CallCapture CaptureGetProgramInfoLog(const Context *context,
                                     bool isCallValid,
                                     GLuint program,
                                     GLsizei bufSize,
                                     GLsizei *length,
                                     GLchar *infoLog)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::TGLuint, program);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetProgramInfoLog_length(context, isCallValid, program, bufSize, length, infoLog,
                                    &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture infoLogParam("infoLog", ParamType::TGLcharPointer);
    InitParamValue(ParamType::TGLcharPointer, infoLog, &infoLogParam.value);
    CaptureGetProgramInfoLog_infoLog(context, isCallValid, program, bufSize, length, infoLog,
                                     &infoLogParam);
    paramBuffer.addParam(std::move(infoLogParam));

    return CallCapture("glGetProgramInfoLog", std::move(paramBuffer));
}

CallCapture CaptureGetProgramiv(const Context *context,
                                bool isCallValid,
                                GLuint program,
                                GLenum pname,
                                GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::TGLuint, program);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetProgramiv_params(context, isCallValid, program, pname, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetProgramiv", std::move(paramBuffer));
}

CallCapture CaptureGetRenderbufferParameteriv(const Context *context,
                                              bool isCallValid,
                                              GLenum target,
                                              GLenum pname,
                                              GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("target", ParamType::TGLenum, target);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetRenderbufferParameteriv_params(context, isCallValid, target, pname, params,
                                             &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetRenderbufferParameteriv", std::move(paramBuffer));
}

CallCapture CaptureGetShaderInfoLog(const Context *context,
                                    bool isCallValid,
                                    GLuint shader,
                                    GLsizei bufSize,
                                    GLsizei *length,
                                    GLchar *infoLog)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("shader", ParamType::TGLuint, shader);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetShaderInfoLog_length(context, isCallValid, shader, bufSize, length, infoLog,
                                   &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture infoLogParam("infoLog", ParamType::TGLcharPointer);
    InitParamValue(ParamType::TGLcharPointer, infoLog, &infoLogParam.value);
    CaptureGetShaderInfoLog_infoLog(context, isCallValid, shader, bufSize, length, infoLog,
                                    &infoLogParam);
    paramBuffer.addParam(std::move(infoLogParam));

    return CallCapture("glGetShaderInfoLog", std::move(paramBuffer));
}

CallCapture CaptureGetShaderPrecisionFormat(const Context *context,
                                            bool isCallValid,
                                            GLenum shadertype,
                                            GLenum precisiontype,
                                            GLint *range,
                                            GLint *precision)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("shadertype", ParamType::TGLenum, shadertype);
    paramBuffer.addValueParam("precisiontype", ParamType::TGLenum, precisiontype);

    ParamCapture rangeParam("range", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, range, &rangeParam.value);
    CaptureGetShaderPrecisionFormat_range(context, isCallValid, shadertype, precisiontype, range,
                                          precision, &rangeParam);
    paramBuffer.addParam(std::move(rangeParam));

    ParamCapture precisionParam("precision", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, precision, &precisionParam.value);
    CaptureGetShaderPrecisionFormat_precision(context, isCallValid, shadertype, precisiontype,
                                              range, precision, &precisionParam);
    paramBuffer.addParam(std::move(precisionParam));

    return CallCapture("glGetShaderPrecisionFormat", std::move(paramBuffer));
}

CallCapture CaptureGetShaderSource(const Context *context,
                                   bool isCallValid,
                                   GLuint shader,
                                   GLsizei bufSize,
                                   GLsizei *length,
                                   GLchar *source)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("shader", ParamType::TGLuint, shader);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetShaderSource_length(context, isCallValid, shader, bufSize, length, source,
                                  &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture sourceParam("source", ParamType::TGLcharPointer);
    InitParamValue(ParamType::TGLcharPointer, source, &sourceParam.value);
    CaptureGetShaderSource_source(context, isCallValid, shader, bufSize, length, source,
                                  &sourceParam);
    paramBuffer.addParam(std::move(sourceParam));

    return CallCapture("glGetShaderSource", std::move(paramBuffer));
}

CallCapture CaptureGetShaderiv(const Context *context,
                               bool isCallValid,
                               GLuint shader,
                               GLenum pname,
                               GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("shader", ParamType::TGLuint, shader);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetShaderiv_params(context, isCallValid, shader, pname, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetShaderiv", std::move(paramBuffer));
}

CallCapture CaptureGetString(const Context *context, bool isCallValid, GLenum name)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("name", ParamType::TGLenum, name);

    return CallCapture("glGetString", std::move(paramBuffer));
}

CallCapture CaptureGetTexParameterfv(const Context *context,
                                     bool isCallValid,
                                     TextureType targetPacked,
                                     GLenum pname,
                                     GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
    InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
    CaptureGetTexParameterfv_params(context, isCallValid, targetPacked, pname, params,
                                    &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetTexParameterfv", std::move(paramBuffer));
}

CallCapture CaptureGetTexParameteriv(const Context *context,
                                     bool isCallValid,
                                     TextureType targetPacked,
                                     GLenum pname,
                                     GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetTexParameteriv_params(context, isCallValid, targetPacked, pname, params,
                                    &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetTexParameteriv", std::move(paramBuffer));
}

CallCapture CaptureGetUniformLocation(const Context *context,
                                      bool isCallValid,
                                      GLuint program,
                                      const GLchar *name)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::TGLuint, program);

    ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
    InitParamValue(ParamType::TGLcharConstPointer, name, &nameParam.value);
    CaptureGetUniformLocation_name(context, isCallValid, program, name, &nameParam);
    paramBuffer.addParam(std::move(nameParam));

    return CallCapture("glGetUniformLocation", std::move(paramBuffer));
}

CallCapture CaptureGetUniformfv(const Context *context,
                                bool isCallValid,
                                GLuint program,
                                GLint location,
                                GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::TGLuint, program);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);

    ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
    InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
    CaptureGetUniformfv_params(context, isCallValid, program, location, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetUniformfv", std::move(paramBuffer));
}

CallCapture CaptureGetUniformiv(const Context *context,
                                bool isCallValid,
                                GLuint program,
                                GLint location,
                                GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::TGLuint, program);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetUniformiv_params(context, isCallValid, program, location, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetUniformiv", std::move(paramBuffer));
}

CallCapture CaptureGetVertexAttribPointerv(const Context *context,
                                           bool isCallValid,
                                           GLuint index,
                                           GLenum pname,
                                           void **pointer)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);

    ParamCapture pointerParam("pointer", ParamType::TvoidPointerPointer);
    InitParamValue(ParamType::TvoidPointerPointer, pointer, &pointerParam.value);
    CaptureGetVertexAttribPointerv_pointer(context, isCallValid, index, pname, pointer,
                                           &pointerParam);
    paramBuffer.addParam(std::move(pointerParam));

    return CallCapture("glGetVertexAttribPointerv", std::move(paramBuffer));
}

CallCapture CaptureGetVertexAttribfv(const Context *context,
                                     bool isCallValid,
                                     GLuint index,
                                     GLenum pname,
                                     GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
    InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
    CaptureGetVertexAttribfv_params(context, isCallValid, index, pname, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetVertexAttribfv", std::move(paramBuffer));
}

CallCapture CaptureGetVertexAttribiv(const Context *context,
                                     bool isCallValid,
                                     GLuint index,
                                     GLenum pname,
                                     GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetVertexAttribiv_params(context, isCallValid, index, pname, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetVertexAttribiv", std::move(paramBuffer));
}

CallCapture CaptureHint(const Context *context, bool isCallValid, GLenum target, GLenum mode)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("target", ParamType::TGLenum, target);
    paramBuffer.addValueParam("mode", ParamType::TGLenum, mode);

    return CallCapture("glHint", std::move(paramBuffer));
}

CallCapture CaptureIsBuffer(const Context *context, bool isCallValid, GLuint buffer)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("buffer", ParamType::TGLuint, buffer);

    return CallCapture("glIsBuffer", std::move(paramBuffer));
}

CallCapture CaptureIsEnabled(const Context *context, bool isCallValid, GLenum cap)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("cap", ParamType::TGLenum, cap);

    return CallCapture("glIsEnabled", std::move(paramBuffer));
}

CallCapture CaptureIsFramebuffer(const Context *context, bool isCallValid, GLuint framebuffer)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("framebuffer", ParamType::TGLuint, framebuffer);

    return CallCapture("glIsFramebuffer", std::move(paramBuffer));
}

CallCapture CaptureIsProgram(const Context *context, bool isCallValid, GLuint program)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::TGLuint, program);

    return CallCapture("glIsProgram", std::move(paramBuffer));
}

CallCapture CaptureIsRenderbuffer(const Context *context, bool isCallValid, GLuint renderbuffer)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("renderbuffer", ParamType::TGLuint, renderbuffer);

    return CallCapture("glIsRenderbuffer", std::move(paramBuffer));
}

CallCapture CaptureIsShader(const Context *context, bool isCallValid, GLuint shader)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("shader", ParamType::TGLuint, shader);

    return CallCapture("glIsShader", std::move(paramBuffer));
}

CallCapture CaptureIsTexture(const Context *context, bool isCallValid, GLuint texture)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("texture", ParamType::TGLuint, texture);

    return CallCapture("glIsTexture", std::move(paramBuffer));
}

CallCapture CaptureLineWidth(const Context *context, bool isCallValid, GLfloat width)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("width", ParamType::TGLfloat, width);

    return CallCapture("glLineWidth", std::move(paramBuffer));
}

CallCapture CaptureLinkProgram(const Context *context, bool isCallValid, GLuint program)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::TGLuint, program);

    return CallCapture("glLinkProgram", std::move(paramBuffer));
}

CallCapture CapturePixelStorei(const Context *context, bool isCallValid, GLenum pname, GLint param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);
    paramBuffer.addValueParam("param", ParamType::TGLint, param);

    return CallCapture("glPixelStorei", std::move(paramBuffer));
}

CallCapture CapturePolygonOffset(const Context *context,
                                 bool isCallValid,
                                 GLfloat factor,
                                 GLfloat units)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("factor", ParamType::TGLfloat, factor);
    paramBuffer.addValueParam("units", ParamType::TGLfloat, units);

    return CallCapture("glPolygonOffset", std::move(paramBuffer));
}

CallCapture CaptureReadPixels(const Context *context,
                              bool isCallValid,
                              GLint x,
                              GLint y,
                              GLsizei width,
                              GLsizei height,
                              GLenum format,
                              GLenum type,
                              void *pixels)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("format", ParamType::TGLenum, format);
    paramBuffer.addValueParam("type", ParamType::TGLenum, type);

    ParamCapture pixelsParam("pixels", ParamType::TvoidPointer);
    InitParamValue(ParamType::TvoidPointer, pixels, &pixelsParam.value);
    CaptureReadPixels_pixels(context, isCallValid, x, y, width, height, format, type, pixels,
                             &pixelsParam);
    paramBuffer.addParam(std::move(pixelsParam));

    return CallCapture("glReadPixels", std::move(paramBuffer));
}

CallCapture CaptureReleaseShaderCompiler(const Context *context, bool isCallValid)
{
    ParamBuffer paramBuffer;

    return CallCapture("glReleaseShaderCompiler", std::move(paramBuffer));
}

CallCapture CaptureRenderbufferStorage(const Context *context,
                                       bool isCallValid,
                                       GLenum target,
                                       GLenum internalformat,
                                       GLsizei width,
                                       GLsizei height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("target", ParamType::TGLenum, target);
    paramBuffer.addValueParam("internalformat", ParamType::TGLenum, internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);

    return CallCapture("glRenderbufferStorage", std::move(paramBuffer));
}

CallCapture CaptureSampleCoverage(const Context *context,
                                  bool isCallValid,
                                  GLfloat value,
                                  GLboolean invert)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("value", ParamType::TGLfloat, value);
    paramBuffer.addValueParam("invert", ParamType::TGLboolean, invert);

    return CallCapture("glSampleCoverage", std::move(paramBuffer));
}

CallCapture CaptureScissor(const Context *context,
                           bool isCallValid,
                           GLint x,
                           GLint y,
                           GLsizei width,
                           GLsizei height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);

    return CallCapture("glScissor", std::move(paramBuffer));
}

CallCapture CaptureShaderBinary(const Context *context,
                                bool isCallValid,
                                GLsizei count,
                                const GLuint *shaders,
                                GLenum binaryformat,
                                const void *binary,
                                GLsizei length)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture shadersParam("shaders", ParamType::TGLuintConstPointer);
    InitParamValue(ParamType::TGLuintConstPointer, shaders, &shadersParam.value);
    CaptureShaderBinary_shaders(context, isCallValid, count, shaders, binaryformat, binary, length,
                                &shadersParam);
    paramBuffer.addParam(std::move(shadersParam));

    paramBuffer.addValueParam("binaryformat", ParamType::TGLenum, binaryformat);

    ParamCapture binaryParam("binary", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, binary, &binaryParam.value);
    CaptureShaderBinary_binary(context, isCallValid, count, shaders, binaryformat, binary, length,
                               &binaryParam);
    paramBuffer.addParam(std::move(binaryParam));

    paramBuffer.addValueParam("length", ParamType::TGLsizei, length);

    return CallCapture("glShaderBinary", std::move(paramBuffer));
}

CallCapture CaptureShaderSource(const Context *context,
                                bool isCallValid,
                                GLuint shader,
                                GLsizei count,
                                const GLchar *const *string,
                                const GLint *length)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("shader", ParamType::TGLuint, shader);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture stringParam("string", ParamType::TGLcharConstPointerPointer);
    InitParamValue(ParamType::TGLcharConstPointerPointer, string, &stringParam.value);
    CaptureShaderSource_string(context, isCallValid, shader, count, string, length, &stringParam);
    paramBuffer.addParam(std::move(stringParam));

    ParamCapture lengthParam("length", ParamType::TGLintConstPointer);
    InitParamValue(ParamType::TGLintConstPointer, length, &lengthParam.value);
    CaptureShaderSource_length(context, isCallValid, shader, count, string, length, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    return CallCapture("glShaderSource", std::move(paramBuffer));
}

CallCapture CaptureStencilFunc(const Context *context,
                               bool isCallValid,
                               GLenum func,
                               GLint ref,
                               GLuint mask)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("func", ParamType::TGLenum, func);
    paramBuffer.addValueParam("ref", ParamType::TGLint, ref);
    paramBuffer.addValueParam("mask", ParamType::TGLuint, mask);

    return CallCapture("glStencilFunc", std::move(paramBuffer));
}

CallCapture CaptureStencilFuncSeparate(const Context *context,
                                       bool isCallValid,
                                       GLenum face,
                                       GLenum func,
                                       GLint ref,
                                       GLuint mask)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("face", ParamType::TGLenum, face);
    paramBuffer.addValueParam("func", ParamType::TGLenum, func);
    paramBuffer.addValueParam("ref", ParamType::TGLint, ref);
    paramBuffer.addValueParam("mask", ParamType::TGLuint, mask);

    return CallCapture("glStencilFuncSeparate", std::move(paramBuffer));
}

CallCapture CaptureStencilMask(const Context *context, bool isCallValid, GLuint mask)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("mask", ParamType::TGLuint, mask);

    return CallCapture("glStencilMask", std::move(paramBuffer));
}

CallCapture CaptureStencilMaskSeparate(const Context *context,
                                       bool isCallValid,
                                       GLenum face,
                                       GLuint mask)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("face", ParamType::TGLenum, face);
    paramBuffer.addValueParam("mask", ParamType::TGLuint, mask);

    return CallCapture("glStencilMaskSeparate", std::move(paramBuffer));
}

CallCapture CaptureStencilOp(const Context *context,
                             bool isCallValid,
                             GLenum fail,
                             GLenum zfail,
                             GLenum zpass)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("fail", ParamType::TGLenum, fail);
    paramBuffer.addValueParam("zfail", ParamType::TGLenum, zfail);
    paramBuffer.addValueParam("zpass", ParamType::TGLenum, zpass);

    return CallCapture("glStencilOp", std::move(paramBuffer));
}

CallCapture CaptureStencilOpSeparate(const Context *context,
                                     bool isCallValid,
                                     GLenum face,
                                     GLenum sfail,
                                     GLenum dpfail,
                                     GLenum dppass)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("face", ParamType::TGLenum, face);
    paramBuffer.addValueParam("sfail", ParamType::TGLenum, sfail);
    paramBuffer.addValueParam("dpfail", ParamType::TGLenum, dpfail);
    paramBuffer.addValueParam("dppass", ParamType::TGLenum, dppass);

    return CallCapture("glStencilOpSeparate", std::move(paramBuffer));
}

CallCapture CaptureTexImage2D(const Context *context,
                              bool isCallValid,
                              TextureTarget targetPacked,
                              GLint level,
                              GLint internalformat,
                              GLsizei width,
                              GLsizei height,
                              GLint border,
                              GLenum format,
                              GLenum type,
                              const void *pixels)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("internalformat", ParamType::TGLint, internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("border", ParamType::TGLint, border);
    paramBuffer.addValueParam("format", ParamType::TGLenum, format);
    paramBuffer.addValueParam("type", ParamType::TGLenum, type);

    ParamCapture pixelsParam("pixels", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, pixels, &pixelsParam.value);
    CaptureTexImage2D_pixels(context, isCallValid, targetPacked, level, internalformat, width,
                             height, border, format, type, pixels, &pixelsParam);
    paramBuffer.addParam(std::move(pixelsParam));

    return CallCapture("glTexImage2D", std::move(paramBuffer));
}

CallCapture CaptureTexParameterf(const Context *context,
                                 bool isCallValid,
                                 TextureType targetPacked,
                                 GLenum pname,
                                 GLfloat param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);
    paramBuffer.addValueParam("param", ParamType::TGLfloat, param);

    return CallCapture("glTexParameterf", std::move(paramBuffer));
}

CallCapture CaptureTexParameterfv(const Context *context,
                                  bool isCallValid,
                                  TextureType targetPacked,
                                  GLenum pname,
                                  const GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, params, &paramsParam.value);
    CaptureTexParameterfv_params(context, isCallValid, targetPacked, pname, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glTexParameterfv", std::move(paramBuffer));
}

CallCapture CaptureTexParameteri(const Context *context,
                                 bool isCallValid,
                                 TextureType targetPacked,
                                 GLenum pname,
                                 GLint param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);
    paramBuffer.addValueParam("param", ParamType::TGLint, param);

    return CallCapture("glTexParameteri", std::move(paramBuffer));
}

CallCapture CaptureTexParameteriv(const Context *context,
                                  bool isCallValid,
                                  TextureType targetPacked,
                                  GLenum pname,
                                  const GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintConstPointer);
    InitParamValue(ParamType::TGLintConstPointer, params, &paramsParam.value);
    CaptureTexParameteriv_params(context, isCallValid, targetPacked, pname, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glTexParameteriv", std::move(paramBuffer));
}

CallCapture CaptureTexSubImage2D(const Context *context,
                                 bool isCallValid,
                                 TextureTarget targetPacked,
                                 GLint level,
                                 GLint xoffset,
                                 GLint yoffset,
                                 GLsizei width,
                                 GLsizei height,
                                 GLenum format,
                                 GLenum type,
                                 const void *pixels)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLint, yoffset);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("format", ParamType::TGLenum, format);
    paramBuffer.addValueParam("type", ParamType::TGLenum, type);

    ParamCapture pixelsParam("pixels", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, pixels, &pixelsParam.value);
    CaptureTexSubImage2D_pixels(context, isCallValid, targetPacked, level, xoffset, yoffset, width,
                                height, format, type, pixels, &pixelsParam);
    paramBuffer.addParam(std::move(pixelsParam));

    return CallCapture("glTexSubImage2D", std::move(paramBuffer));
}

CallCapture CaptureUniform1f(const Context *context, bool isCallValid, GLint location, GLfloat v0)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("v0", ParamType::TGLfloat, v0);

    return CallCapture("glUniform1f", std::move(paramBuffer));
}

CallCapture CaptureUniform1fv(const Context *context,
                              bool isCallValid,
                              GLint location,
                              GLsizei count,
                              const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
    CaptureUniform1fv_value(context, isCallValid, location, count, value, &valueParam);
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture("glUniform1fv", std::move(paramBuffer));
}

CallCapture CaptureUniform1i(const Context *context, bool isCallValid, GLint location, GLint v0)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("v0", ParamType::TGLint, v0);

    return CallCapture("glUniform1i", std::move(paramBuffer));
}

CallCapture CaptureUniform1iv(const Context *context,
                              bool isCallValid,
                              GLint location,
                              GLsizei count,
                              const GLint *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture valueParam("value", ParamType::TGLintConstPointer);
    InitParamValue(ParamType::TGLintConstPointer, value, &valueParam.value);
    CaptureUniform1iv_value(context, isCallValid, location, count, value, &valueParam);
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture("glUniform1iv", std::move(paramBuffer));
}

CallCapture CaptureUniform2f(const Context *context,
                             bool isCallValid,
                             GLint location,
                             GLfloat v0,
                             GLfloat v1)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("v0", ParamType::TGLfloat, v0);
    paramBuffer.addValueParam("v1", ParamType::TGLfloat, v1);

    return CallCapture("glUniform2f", std::move(paramBuffer));
}

CallCapture CaptureUniform2fv(const Context *context,
                              bool isCallValid,
                              GLint location,
                              GLsizei count,
                              const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
    CaptureUniform2fv_value(context, isCallValid, location, count, value, &valueParam);
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture("glUniform2fv", std::move(paramBuffer));
}

CallCapture CaptureUniform2i(const Context *context,
                             bool isCallValid,
                             GLint location,
                             GLint v0,
                             GLint v1)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("v0", ParamType::TGLint, v0);
    paramBuffer.addValueParam("v1", ParamType::TGLint, v1);

    return CallCapture("glUniform2i", std::move(paramBuffer));
}

CallCapture CaptureUniform2iv(const Context *context,
                              bool isCallValid,
                              GLint location,
                              GLsizei count,
                              const GLint *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture valueParam("value", ParamType::TGLintConstPointer);
    InitParamValue(ParamType::TGLintConstPointer, value, &valueParam.value);
    CaptureUniform2iv_value(context, isCallValid, location, count, value, &valueParam);
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture("glUniform2iv", std::move(paramBuffer));
}

CallCapture CaptureUniform3f(const Context *context,
                             bool isCallValid,
                             GLint location,
                             GLfloat v0,
                             GLfloat v1,
                             GLfloat v2)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("v0", ParamType::TGLfloat, v0);
    paramBuffer.addValueParam("v1", ParamType::TGLfloat, v1);
    paramBuffer.addValueParam("v2", ParamType::TGLfloat, v2);

    return CallCapture("glUniform3f", std::move(paramBuffer));
}

CallCapture CaptureUniform3fv(const Context *context,
                              bool isCallValid,
                              GLint location,
                              GLsizei count,
                              const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
    CaptureUniform3fv_value(context, isCallValid, location, count, value, &valueParam);
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture("glUniform3fv", std::move(paramBuffer));
}

CallCapture CaptureUniform3i(const Context *context,
                             bool isCallValid,
                             GLint location,
                             GLint v0,
                             GLint v1,
                             GLint v2)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("v0", ParamType::TGLint, v0);
    paramBuffer.addValueParam("v1", ParamType::TGLint, v1);
    paramBuffer.addValueParam("v2", ParamType::TGLint, v2);

    return CallCapture("glUniform3i", std::move(paramBuffer));
}

CallCapture CaptureUniform3iv(const Context *context,
                              bool isCallValid,
                              GLint location,
                              GLsizei count,
                              const GLint *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture valueParam("value", ParamType::TGLintConstPointer);
    InitParamValue(ParamType::TGLintConstPointer, value, &valueParam.value);
    CaptureUniform3iv_value(context, isCallValid, location, count, value, &valueParam);
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture("glUniform3iv", std::move(paramBuffer));
}

CallCapture CaptureUniform4f(const Context *context,
                             bool isCallValid,
                             GLint location,
                             GLfloat v0,
                             GLfloat v1,
                             GLfloat v2,
                             GLfloat v3)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("v0", ParamType::TGLfloat, v0);
    paramBuffer.addValueParam("v1", ParamType::TGLfloat, v1);
    paramBuffer.addValueParam("v2", ParamType::TGLfloat, v2);
    paramBuffer.addValueParam("v3", ParamType::TGLfloat, v3);

    return CallCapture("glUniform4f", std::move(paramBuffer));
}

CallCapture CaptureUniform4fv(const Context *context,
                              bool isCallValid,
                              GLint location,
                              GLsizei count,
                              const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
    CaptureUniform4fv_value(context, isCallValid, location, count, value, &valueParam);
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture("glUniform4fv", std::move(paramBuffer));
}

CallCapture CaptureUniform4i(const Context *context,
                             bool isCallValid,
                             GLint location,
                             GLint v0,
                             GLint v1,
                             GLint v2,
                             GLint v3)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("v0", ParamType::TGLint, v0);
    paramBuffer.addValueParam("v1", ParamType::TGLint, v1);
    paramBuffer.addValueParam("v2", ParamType::TGLint, v2);
    paramBuffer.addValueParam("v3", ParamType::TGLint, v3);

    return CallCapture("glUniform4i", std::move(paramBuffer));
}

CallCapture CaptureUniform4iv(const Context *context,
                              bool isCallValid,
                              GLint location,
                              GLsizei count,
                              const GLint *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture valueParam("value", ParamType::TGLintConstPointer);
    InitParamValue(ParamType::TGLintConstPointer, value, &valueParam.value);
    CaptureUniform4iv_value(context, isCallValid, location, count, value, &valueParam);
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture("glUniform4iv", std::move(paramBuffer));
}

CallCapture CaptureUniformMatrix2fv(const Context *context,
                                    bool isCallValid,
                                    GLint location,
                                    GLsizei count,
                                    GLboolean transpose,
                                    const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
    CaptureUniformMatrix2fv_value(context, isCallValid, location, count, transpose, value,
                                  &valueParam);
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture("glUniformMatrix2fv", std::move(paramBuffer));
}

CallCapture CaptureUniformMatrix3fv(const Context *context,
                                    bool isCallValid,
                                    GLint location,
                                    GLsizei count,
                                    GLboolean transpose,
                                    const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
    CaptureUniformMatrix3fv_value(context, isCallValid, location, count, transpose, value,
                                  &valueParam);
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture("glUniformMatrix3fv", std::move(paramBuffer));
}

CallCapture CaptureUniformMatrix4fv(const Context *context,
                                    bool isCallValid,
                                    GLint location,
                                    GLsizei count,
                                    GLboolean transpose,
                                    const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
    CaptureUniformMatrix4fv_value(context, isCallValid, location, count, transpose, value,
                                  &valueParam);
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture("glUniformMatrix4fv", std::move(paramBuffer));
}

CallCapture CaptureUseProgram(const Context *context, bool isCallValid, GLuint program)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::TGLuint, program);

    return CallCapture("glUseProgram", std::move(paramBuffer));
}

CallCapture CaptureValidateProgram(const Context *context, bool isCallValid, GLuint program)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::TGLuint, program);

    return CallCapture("glValidateProgram", std::move(paramBuffer));
}

CallCapture CaptureVertexAttrib1f(const Context *context, bool isCallValid, GLuint index, GLfloat x)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("x", ParamType::TGLfloat, x);

    return CallCapture("glVertexAttrib1f", std::move(paramBuffer));
}

CallCapture CaptureVertexAttrib1fv(const Context *context,
                                   bool isCallValid,
                                   GLuint index,
                                   const GLfloat *v)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    ParamCapture vParam("v", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, v, &vParam.value);
    CaptureVertexAttrib1fv_v(context, isCallValid, index, v, &vParam);
    paramBuffer.addParam(std::move(vParam));

    return CallCapture("glVertexAttrib1fv", std::move(paramBuffer));
}

CallCapture CaptureVertexAttrib2f(const Context *context,
                                  bool isCallValid,
                                  GLuint index,
                                  GLfloat x,
                                  GLfloat y)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("x", ParamType::TGLfloat, x);
    paramBuffer.addValueParam("y", ParamType::TGLfloat, y);

    return CallCapture("glVertexAttrib2f", std::move(paramBuffer));
}

CallCapture CaptureVertexAttrib2fv(const Context *context,
                                   bool isCallValid,
                                   GLuint index,
                                   const GLfloat *v)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    ParamCapture vParam("v", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, v, &vParam.value);
    CaptureVertexAttrib2fv_v(context, isCallValid, index, v, &vParam);
    paramBuffer.addParam(std::move(vParam));

    return CallCapture("glVertexAttrib2fv", std::move(paramBuffer));
}

CallCapture CaptureVertexAttrib3f(const Context *context,
                                  bool isCallValid,
                                  GLuint index,
                                  GLfloat x,
                                  GLfloat y,
                                  GLfloat z)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("x", ParamType::TGLfloat, x);
    paramBuffer.addValueParam("y", ParamType::TGLfloat, y);
    paramBuffer.addValueParam("z", ParamType::TGLfloat, z);

    return CallCapture("glVertexAttrib3f", std::move(paramBuffer));
}

CallCapture CaptureVertexAttrib3fv(const Context *context,
                                   bool isCallValid,
                                   GLuint index,
                                   const GLfloat *v)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    ParamCapture vParam("v", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, v, &vParam.value);
    CaptureVertexAttrib3fv_v(context, isCallValid, index, v, &vParam);
    paramBuffer.addParam(std::move(vParam));

    return CallCapture("glVertexAttrib3fv", std::move(paramBuffer));
}

CallCapture CaptureVertexAttrib4f(const Context *context,
                                  bool isCallValid,
                                  GLuint index,
                                  GLfloat x,
                                  GLfloat y,
                                  GLfloat z,
                                  GLfloat w)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("x", ParamType::TGLfloat, x);
    paramBuffer.addValueParam("y", ParamType::TGLfloat, y);
    paramBuffer.addValueParam("z", ParamType::TGLfloat, z);
    paramBuffer.addValueParam("w", ParamType::TGLfloat, w);

    return CallCapture("glVertexAttrib4f", std::move(paramBuffer));
}

CallCapture CaptureVertexAttrib4fv(const Context *context,
                                   bool isCallValid,
                                   GLuint index,
                                   const GLfloat *v)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    ParamCapture vParam("v", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, v, &vParam.value);
    CaptureVertexAttrib4fv_v(context, isCallValid, index, v, &vParam);
    paramBuffer.addParam(std::move(vParam));

    return CallCapture("glVertexAttrib4fv", std::move(paramBuffer));
}

CallCapture CaptureVertexAttribPointer(const Context *context,
                                       bool isCallValid,
                                       GLuint index,
                                       GLint size,
                                       VertexAttribType typePacked,
                                       GLboolean normalized,
                                       GLsizei stride,
                                       const void *pointer)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("size", ParamType::TGLint, size);
    paramBuffer.addValueParam("typePacked", ParamType::TVertexAttribType, typePacked);
    paramBuffer.addValueParam("normalized", ParamType::TGLboolean, normalized);
    paramBuffer.addValueParam("stride", ParamType::TGLsizei, stride);

    ParamCapture pointerParam("pointer", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, pointer, &pointerParam.value);
    CaptureVertexAttribPointer_pointer(context, isCallValid, index, size, typePacked, normalized,
                                       stride, pointer, &pointerParam);
    paramBuffer.addParam(std::move(pointerParam));

    return CallCapture("glVertexAttribPointer", std::move(paramBuffer));
}

CallCapture CaptureViewport(const Context *context,
                            bool isCallValid,
                            GLint x,
                            GLint y,
                            GLsizei width,
                            GLsizei height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);

    return CallCapture("glViewport", std::move(paramBuffer));
}

}  // namespace gl
