// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from gl.xml and gl_angle_ext.xml.
//
// Copyright 2019 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// capture_gles_3_0_autogen.cpp:
//   Capture functions for the OpenGL ES 3.0 entry points.

#include "libANGLE/capture_gles_3_0_autogen.h"

#include "libANGLE/Context.h"
#include "libANGLE/FrameCapture.h"
#include "libANGLE/validationES3.h"

using namespace angle;

namespace gl
{

CallCapture CaptureBeginQuery(const Context *context,
                              bool isCallValid,
                              QueryType targetPacked,
                              GLuint id)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TQueryType, targetPacked);
    paramBuffer.addValueParam("id", ParamType::TGLuint, id);

    return CallCapture("glBeginQuery", std::move(paramBuffer));
}

CallCapture CaptureBeginTransformFeedback(const Context *context,
                                          bool isCallValid,
                                          PrimitiveMode primitiveModePacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("primitiveModePacked", ParamType::TPrimitiveMode,
                              primitiveModePacked);

    return CallCapture("glBeginTransformFeedback", std::move(paramBuffer));
}

CallCapture CaptureBindBufferBase(const Context *context,
                                  bool isCallValid,
                                  BufferBinding targetPacked,
                                  GLuint index,
                                  GLuint buffer)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("buffer", ParamType::TGLuint, buffer);

    return CallCapture("glBindBufferBase", std::move(paramBuffer));
}

CallCapture CaptureBindBufferRange(const Context *context,
                                   bool isCallValid,
                                   BufferBinding targetPacked,
                                   GLuint index,
                                   GLuint buffer,
                                   GLintptr offset,
                                   GLsizeiptr size)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("buffer", ParamType::TGLuint, buffer);
    paramBuffer.addValueParam("offset", ParamType::TGLintptr, offset);
    paramBuffer.addValueParam("size", ParamType::TGLsizeiptr, size);

    return CallCapture("glBindBufferRange", std::move(paramBuffer));
}

CallCapture CaptureBindSampler(const Context *context,
                               bool isCallValid,
                               GLuint unit,
                               GLuint sampler)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("unit", ParamType::TGLuint, unit);
    paramBuffer.addValueParam("sampler", ParamType::TGLuint, sampler);

    return CallCapture("glBindSampler", std::move(paramBuffer));
}

CallCapture CaptureBindTransformFeedback(const Context *context,
                                         bool isCallValid,
                                         GLenum target,
                                         GLuint id)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("target", ParamType::TGLenum, target);
    paramBuffer.addValueParam("id", ParamType::TGLuint, id);

    return CallCapture("glBindTransformFeedback", std::move(paramBuffer));
}

CallCapture CaptureBindVertexArray(const Context *context, bool isCallValid, GLuint array)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("array", ParamType::TGLuint, array);

    return CallCapture("glBindVertexArray", std::move(paramBuffer));
}

CallCapture CaptureBlitFramebuffer(const Context *context,
                                   bool isCallValid,
                                   GLint srcX0,
                                   GLint srcY0,
                                   GLint srcX1,
                                   GLint srcY1,
                                   GLint dstX0,
                                   GLint dstY0,
                                   GLint dstX1,
                                   GLint dstY1,
                                   GLbitfield mask,
                                   GLenum filter)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("srcX0", ParamType::TGLint, srcX0);
    paramBuffer.addValueParam("srcY0", ParamType::TGLint, srcY0);
    paramBuffer.addValueParam("srcX1", ParamType::TGLint, srcX1);
    paramBuffer.addValueParam("srcY1", ParamType::TGLint, srcY1);
    paramBuffer.addValueParam("dstX0", ParamType::TGLint, dstX0);
    paramBuffer.addValueParam("dstY0", ParamType::TGLint, dstY0);
    paramBuffer.addValueParam("dstX1", ParamType::TGLint, dstX1);
    paramBuffer.addValueParam("dstY1", ParamType::TGLint, dstY1);
    paramBuffer.addValueParam("mask", ParamType::TGLbitfield, mask);
    paramBuffer.addValueParam("filter", ParamType::TGLenum, filter);

    return CallCapture("glBlitFramebuffer", std::move(paramBuffer));
}

CallCapture CaptureClearBufferfi(const Context *context,
                                 bool isCallValid,
                                 GLenum buffer,
                                 GLint drawbuffer,
                                 GLfloat depth,
                                 GLint stencil)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("buffer", ParamType::TGLenum, buffer);
    paramBuffer.addValueParam("drawbuffer", ParamType::TGLint, drawbuffer);
    paramBuffer.addValueParam("depth", ParamType::TGLfloat, depth);
    paramBuffer.addValueParam("stencil", ParamType::TGLint, stencil);

    return CallCapture("glClearBufferfi", std::move(paramBuffer));
}

CallCapture CaptureClearBufferfv(const Context *context,
                                 bool isCallValid,
                                 GLenum buffer,
                                 GLint drawbuffer,
                                 const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("buffer", ParamType::TGLenum, buffer);
    paramBuffer.addValueParam("drawbuffer", ParamType::TGLint, drawbuffer);

    ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
    CaptureClearBufferfv_value(context, isCallValid, buffer, drawbuffer, value, &valueParam);
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture("glClearBufferfv", std::move(paramBuffer));
}

CallCapture CaptureClearBufferiv(const Context *context,
                                 bool isCallValid,
                                 GLenum buffer,
                                 GLint drawbuffer,
                                 const GLint *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("buffer", ParamType::TGLenum, buffer);
    paramBuffer.addValueParam("drawbuffer", ParamType::TGLint, drawbuffer);

    ParamCapture valueParam("value", ParamType::TGLintConstPointer);
    InitParamValue(ParamType::TGLintConstPointer, value, &valueParam.value);
    CaptureClearBufferiv_value(context, isCallValid, buffer, drawbuffer, value, &valueParam);
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture("glClearBufferiv", std::move(paramBuffer));
}

CallCapture CaptureClearBufferuiv(const Context *context,
                                  bool isCallValid,
                                  GLenum buffer,
                                  GLint drawbuffer,
                                  const GLuint *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("buffer", ParamType::TGLenum, buffer);
    paramBuffer.addValueParam("drawbuffer", ParamType::TGLint, drawbuffer);

    ParamCapture valueParam("value", ParamType::TGLuintConstPointer);
    InitParamValue(ParamType::TGLuintConstPointer, value, &valueParam.value);
    CaptureClearBufferuiv_value(context, isCallValid, buffer, drawbuffer, value, &valueParam);
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture("glClearBufferuiv", std::move(paramBuffer));
}

CallCapture CaptureClientWaitSync(const Context *context,
                                  bool isCallValid,
                                  GLsync sync,
                                  GLbitfield flags,
                                  GLuint64 timeout)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("sync", ParamType::TGLsync, sync);
    paramBuffer.addValueParam("flags", ParamType::TGLbitfield, flags);
    paramBuffer.addValueParam("timeout", ParamType::TGLuint64, timeout);

    return CallCapture("glClientWaitSync", std::move(paramBuffer));
}

CallCapture CaptureCompressedTexImage3D(const Context *context,
                                        bool isCallValid,
                                        TextureTarget targetPacked,
                                        GLint level,
                                        GLenum internalformat,
                                        GLsizei width,
                                        GLsizei height,
                                        GLsizei depth,
                                        GLint border,
                                        GLsizei imageSize,
                                        const void *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("internalformat", ParamType::TGLenum, internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addValueParam("border", ParamType::TGLint, border);
    paramBuffer.addValueParam("imageSize", ParamType::TGLsizei, imageSize);

    ParamCapture dataParam("data", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, data, &dataParam.value);
    CaptureCompressedTexImage3D_data(context, isCallValid, targetPacked, level, internalformat,
                                     width, height, depth, border, imageSize, data, &dataParam);
    paramBuffer.addParam(std::move(dataParam));

    return CallCapture("glCompressedTexImage3D", std::move(paramBuffer));
}

CallCapture CaptureCompressedTexSubImage3D(const Context *context,
                                           bool isCallValid,
                                           TextureTarget targetPacked,
                                           GLint level,
                                           GLint xoffset,
                                           GLint yoffset,
                                           GLint zoffset,
                                           GLsizei width,
                                           GLsizei height,
                                           GLsizei depth,
                                           GLenum format,
                                           GLsizei imageSize,
                                           const void *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLint, yoffset);
    paramBuffer.addValueParam("zoffset", ParamType::TGLint, zoffset);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addValueParam("format", ParamType::TGLenum, format);
    paramBuffer.addValueParam("imageSize", ParamType::TGLsizei, imageSize);

    ParamCapture dataParam("data", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, data, &dataParam.value);
    CaptureCompressedTexSubImage3D_data(context, isCallValid, targetPacked, level, xoffset, yoffset,
                                        zoffset, width, height, depth, format, imageSize, data,
                                        &dataParam);
    paramBuffer.addParam(std::move(dataParam));

    return CallCapture("glCompressedTexSubImage3D", std::move(paramBuffer));
}

CallCapture CaptureCopyBufferSubData(const Context *context,
                                     bool isCallValid,
                                     BufferBinding readTargetPacked,
                                     BufferBinding writeTargetPacked,
                                     GLintptr readOffset,
                                     GLintptr writeOffset,
                                     GLsizeiptr size)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("readTargetPacked", ParamType::TBufferBinding, readTargetPacked);
    paramBuffer.addValueParam("writeTargetPacked", ParamType::TBufferBinding, writeTargetPacked);
    paramBuffer.addValueParam("readOffset", ParamType::TGLintptr, readOffset);
    paramBuffer.addValueParam("writeOffset", ParamType::TGLintptr, writeOffset);
    paramBuffer.addValueParam("size", ParamType::TGLsizeiptr, size);

    return CallCapture("glCopyBufferSubData", std::move(paramBuffer));
}

CallCapture CaptureCopyTexSubImage3D(const Context *context,
                                     bool isCallValid,
                                     TextureTarget targetPacked,
                                     GLint level,
                                     GLint xoffset,
                                     GLint yoffset,
                                     GLint zoffset,
                                     GLint x,
                                     GLint y,
                                     GLsizei width,
                                     GLsizei height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLint, yoffset);
    paramBuffer.addValueParam("zoffset", ParamType::TGLint, zoffset);
    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);

    return CallCapture("glCopyTexSubImage3D", std::move(paramBuffer));
}

CallCapture CaptureDeleteQueries(const Context *context,
                                 bool isCallValid,
                                 GLsizei n,
                                 const GLuint *ids)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture idsParam("ids", ParamType::TGLuintConstPointer);
    InitParamValue(ParamType::TGLuintConstPointer, ids, &idsParam.value);
    CaptureDeleteQueries_ids(context, isCallValid, n, ids, &idsParam);
    paramBuffer.addParam(std::move(idsParam));

    return CallCapture("glDeleteQueries", std::move(paramBuffer));
}

CallCapture CaptureDeleteSamplers(const Context *context,
                                  bool isCallValid,
                                  GLsizei count,
                                  const GLuint *samplers)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture samplersParam("samplers", ParamType::TGLuintConstPointer);
    InitParamValue(ParamType::TGLuintConstPointer, samplers, &samplersParam.value);
    CaptureDeleteSamplers_samplers(context, isCallValid, count, samplers, &samplersParam);
    paramBuffer.addParam(std::move(samplersParam));

    return CallCapture("glDeleteSamplers", std::move(paramBuffer));
}

CallCapture CaptureDeleteSync(const Context *context, bool isCallValid, GLsync sync)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("sync", ParamType::TGLsync, sync);

    return CallCapture("glDeleteSync", std::move(paramBuffer));
}

CallCapture CaptureDeleteTransformFeedbacks(const Context *context,
                                            bool isCallValid,
                                            GLsizei n,
                                            const GLuint *ids)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture idsParam("ids", ParamType::TGLuintConstPointer);
    InitParamValue(ParamType::TGLuintConstPointer, ids, &idsParam.value);
    CaptureDeleteTransformFeedbacks_ids(context, isCallValid, n, ids, &idsParam);
    paramBuffer.addParam(std::move(idsParam));

    return CallCapture("glDeleteTransformFeedbacks", std::move(paramBuffer));
}

CallCapture CaptureDeleteVertexArrays(const Context *context,
                                      bool isCallValid,
                                      GLsizei n,
                                      const GLuint *arrays)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture arraysParam("arrays", ParamType::TGLuintConstPointer);
    InitParamValue(ParamType::TGLuintConstPointer, arrays, &arraysParam.value);
    CaptureDeleteVertexArrays_arrays(context, isCallValid, n, arrays, &arraysParam);
    paramBuffer.addParam(std::move(arraysParam));

    return CallCapture("glDeleteVertexArrays", std::move(paramBuffer));
}

CallCapture CaptureDrawArraysInstanced(const Context *context,
                                       bool isCallValid,
                                       PrimitiveMode modePacked,
                                       GLint first,
                                       GLsizei count,
                                       GLsizei instancecount)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("first", ParamType::TGLint, first);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("instancecount", ParamType::TGLsizei, instancecount);

    return CallCapture("glDrawArraysInstanced", std::move(paramBuffer));
}

CallCapture CaptureDrawBuffers(const Context *context,
                               bool isCallValid,
                               GLsizei n,
                               const GLenum *bufs)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture bufsParam("bufs", ParamType::TGLenumConstPointer);
    InitParamValue(ParamType::TGLenumConstPointer, bufs, &bufsParam.value);
    CaptureDrawBuffers_bufs(context, isCallValid, n, bufs, &bufsParam);
    paramBuffer.addParam(std::move(bufsParam));

    return CallCapture("glDrawBuffers", std::move(paramBuffer));
}

CallCapture CaptureDrawElementsInstanced(const Context *context,
                                         bool isCallValid,
                                         PrimitiveMode modePacked,
                                         GLsizei count,
                                         DrawElementsType typePacked,
                                         const void *indices,
                                         GLsizei instancecount)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("typePacked", ParamType::TDrawElementsType, typePacked);

    ParamCapture indicesParam("indices", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, indices, &indicesParam.value);
    CaptureDrawElementsInstanced_indices(context, isCallValid, modePacked, count, typePacked,
                                         indices, instancecount, &indicesParam);
    paramBuffer.addParam(std::move(indicesParam));

    paramBuffer.addValueParam("instancecount", ParamType::TGLsizei, instancecount);

    return CallCapture("glDrawElementsInstanced", std::move(paramBuffer));
}

CallCapture CaptureDrawRangeElements(const Context *context,
                                     bool isCallValid,
                                     PrimitiveMode modePacked,
                                     GLuint start,
                                     GLuint end,
                                     GLsizei count,
                                     DrawElementsType typePacked,
                                     const void *indices)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("start", ParamType::TGLuint, start);
    paramBuffer.addValueParam("end", ParamType::TGLuint, end);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("typePacked", ParamType::TDrawElementsType, typePacked);

    ParamCapture indicesParam("indices", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, indices, &indicesParam.value);
    CaptureDrawRangeElements_indices(context, isCallValid, modePacked, start, end, count,
                                     typePacked, indices, &indicesParam);
    paramBuffer.addParam(std::move(indicesParam));

    return CallCapture("glDrawRangeElements", std::move(paramBuffer));
}

CallCapture CaptureEndQuery(const Context *context, bool isCallValid, QueryType targetPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TQueryType, targetPacked);

    return CallCapture("glEndQuery", std::move(paramBuffer));
}

CallCapture CaptureEndTransformFeedback(const Context *context, bool isCallValid)
{
    ParamBuffer paramBuffer;

    return CallCapture("glEndTransformFeedback", std::move(paramBuffer));
}

CallCapture CaptureFenceSync(const Context *context,
                             bool isCallValid,
                             GLenum condition,
                             GLbitfield flags)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("condition", ParamType::TGLenum, condition);
    paramBuffer.addValueParam("flags", ParamType::TGLbitfield, flags);

    return CallCapture("glFenceSync", std::move(paramBuffer));
}

CallCapture CaptureFlushMappedBufferRange(const Context *context,
                                          bool isCallValid,
                                          BufferBinding targetPacked,
                                          GLintptr offset,
                                          GLsizeiptr length)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);
    paramBuffer.addValueParam("offset", ParamType::TGLintptr, offset);
    paramBuffer.addValueParam("length", ParamType::TGLsizeiptr, length);

    return CallCapture("glFlushMappedBufferRange", std::move(paramBuffer));
}

CallCapture CaptureFramebufferTextureLayer(const Context *context,
                                           bool isCallValid,
                                           GLenum target,
                                           GLenum attachment,
                                           GLuint texture,
                                           GLint level,
                                           GLint layer)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("target", ParamType::TGLenum, target);
    paramBuffer.addValueParam("attachment", ParamType::TGLenum, attachment);
    paramBuffer.addValueParam("texture", ParamType::TGLuint, texture);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("layer", ParamType::TGLint, layer);

    return CallCapture("glFramebufferTextureLayer", std::move(paramBuffer));
}

CallCapture CaptureGenQueries(const Context *context, bool isCallValid, GLsizei n, GLuint *ids)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture idsParam("ids", ParamType::TGLuintPointer);
    InitParamValue(ParamType::TGLuintPointer, ids, &idsParam.value);
    CaptureGenQueries_ids(context, isCallValid, n, ids, &idsParam);
    paramBuffer.addParam(std::move(idsParam));

    return CallCapture("glGenQueries", std::move(paramBuffer));
}

CallCapture CaptureGenSamplers(const Context *context,
                               bool isCallValid,
                               GLsizei count,
                               GLuint *samplers)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture samplersParam("samplers", ParamType::TGLuintPointer);
    InitParamValue(ParamType::TGLuintPointer, samplers, &samplersParam.value);
    CaptureGenSamplers_samplers(context, isCallValid, count, samplers, &samplersParam);
    paramBuffer.addParam(std::move(samplersParam));

    return CallCapture("glGenSamplers", std::move(paramBuffer));
}

CallCapture CaptureGenTransformFeedbacks(const Context *context,
                                         bool isCallValid,
                                         GLsizei n,
                                         GLuint *ids)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture idsParam("ids", ParamType::TGLuintPointer);
    InitParamValue(ParamType::TGLuintPointer, ids, &idsParam.value);
    CaptureGenTransformFeedbacks_ids(context, isCallValid, n, ids, &idsParam);
    paramBuffer.addParam(std::move(idsParam));

    return CallCapture("glGenTransformFeedbacks", std::move(paramBuffer));
}

CallCapture CaptureGenVertexArrays(const Context *context,
                                   bool isCallValid,
                                   GLsizei n,
                                   GLuint *arrays)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture arraysParam("arrays", ParamType::TGLuintPointer);
    InitParamValue(ParamType::TGLuintPointer, arrays, &arraysParam.value);
    CaptureGenVertexArrays_arrays(context, isCallValid, n, arrays, &arraysParam);
    paramBuffer.addParam(std::move(arraysParam));

    return CallCapture("glGenVertexArrays", std::move(paramBuffer));
}

CallCapture CaptureGetActiveUniformBlockName(const Context *context,
                                             bool isCallValid,
                                             GLuint program,
                                             GLuint uniformBlockIndex,
                                             GLsizei bufSize,
                                             GLsizei *length,
                                             GLchar *uniformBlockName)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::TGLuint, program);
    paramBuffer.addValueParam("uniformBlockIndex", ParamType::TGLuint, uniformBlockIndex);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetActiveUniformBlockName_length(context, isCallValid, program, uniformBlockIndex,
                                            bufSize, length, uniformBlockName, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture uniformBlockNameParam("uniformBlockName", ParamType::TGLcharPointer);
    InitParamValue(ParamType::TGLcharPointer, uniformBlockName, &uniformBlockNameParam.value);
    CaptureGetActiveUniformBlockName_uniformBlockName(context, isCallValid, program,
                                                      uniformBlockIndex, bufSize, length,
                                                      uniformBlockName, &uniformBlockNameParam);
    paramBuffer.addParam(std::move(uniformBlockNameParam));

    return CallCapture("glGetActiveUniformBlockName", std::move(paramBuffer));
}

CallCapture CaptureGetActiveUniformBlockiv(const Context *context,
                                           bool isCallValid,
                                           GLuint program,
                                           GLuint uniformBlockIndex,
                                           GLenum pname,
                                           GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::TGLuint, program);
    paramBuffer.addValueParam("uniformBlockIndex", ParamType::TGLuint, uniformBlockIndex);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetActiveUniformBlockiv_params(context, isCallValid, program, uniformBlockIndex, pname,
                                          params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetActiveUniformBlockiv", std::move(paramBuffer));
}

CallCapture CaptureGetActiveUniformsiv(const Context *context,
                                       bool isCallValid,
                                       GLuint program,
                                       GLsizei uniformCount,
                                       const GLuint *uniformIndices,
                                       GLenum pname,
                                       GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::TGLuint, program);
    paramBuffer.addValueParam("uniformCount", ParamType::TGLsizei, uniformCount);

    ParamCapture uniformIndicesParam("uniformIndices", ParamType::TGLuintConstPointer);
    InitParamValue(ParamType::TGLuintConstPointer, uniformIndices, &uniformIndicesParam.value);
    CaptureGetActiveUniformsiv_uniformIndices(context, isCallValid, program, uniformCount,
                                              uniformIndices, pname, params, &uniformIndicesParam);
    paramBuffer.addParam(std::move(uniformIndicesParam));

    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetActiveUniformsiv_params(context, isCallValid, program, uniformCount, uniformIndices,
                                      pname, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetActiveUniformsiv", std::move(paramBuffer));
}

CallCapture CaptureGetBufferParameteri64v(const Context *context,
                                          bool isCallValid,
                                          BufferBinding targetPacked,
                                          GLenum pname,
                                          GLint64 *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLint64Pointer);
    InitParamValue(ParamType::TGLint64Pointer, params, &paramsParam.value);
    CaptureGetBufferParameteri64v_params(context, isCallValid, targetPacked, pname, params,
                                         &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetBufferParameteri64v", std::move(paramBuffer));
}

CallCapture CaptureGetBufferPointerv(const Context *context,
                                     bool isCallValid,
                                     BufferBinding targetPacked,
                                     GLenum pname,
                                     void **params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TvoidPointerPointer);
    InitParamValue(ParamType::TvoidPointerPointer, params, &paramsParam.value);
    CaptureGetBufferPointerv_params(context, isCallValid, targetPacked, pname, params,
                                    &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetBufferPointerv", std::move(paramBuffer));
}

CallCapture CaptureGetFragDataLocation(const Context *context,
                                       bool isCallValid,
                                       GLuint program,
                                       const GLchar *name)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::TGLuint, program);

    ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
    InitParamValue(ParamType::TGLcharConstPointer, name, &nameParam.value);
    CaptureGetFragDataLocation_name(context, isCallValid, program, name, &nameParam);
    paramBuffer.addParam(std::move(nameParam));

    return CallCapture("glGetFragDataLocation", std::move(paramBuffer));
}

CallCapture CaptureGetInteger64i_v(const Context *context,
                                   bool isCallValid,
                                   GLenum target,
                                   GLuint index,
                                   GLint64 *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("target", ParamType::TGLenum, target);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    ParamCapture dataParam("data", ParamType::TGLint64Pointer);
    InitParamValue(ParamType::TGLint64Pointer, data, &dataParam.value);
    CaptureGetInteger64i_v_data(context, isCallValid, target, index, data, &dataParam);
    paramBuffer.addParam(std::move(dataParam));

    return CallCapture("glGetInteger64i_v", std::move(paramBuffer));
}

CallCapture CaptureGetInteger64v(const Context *context,
                                 bool isCallValid,
                                 GLenum pname,
                                 GLint64 *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);

    ParamCapture dataParam("data", ParamType::TGLint64Pointer);
    InitParamValue(ParamType::TGLint64Pointer, data, &dataParam.value);
    CaptureGetInteger64v_data(context, isCallValid, pname, data, &dataParam);
    paramBuffer.addParam(std::move(dataParam));

    return CallCapture("glGetInteger64v", std::move(paramBuffer));
}

CallCapture CaptureGetIntegeri_v(const Context *context,
                                 bool isCallValid,
                                 GLenum target,
                                 GLuint index,
                                 GLint *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("target", ParamType::TGLenum, target);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    ParamCapture dataParam("data", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, data, &dataParam.value);
    CaptureGetIntegeri_v_data(context, isCallValid, target, index, data, &dataParam);
    paramBuffer.addParam(std::move(dataParam));

    return CallCapture("glGetIntegeri_v", std::move(paramBuffer));
}

CallCapture CaptureGetInternalformativ(const Context *context,
                                       bool isCallValid,
                                       GLenum target,
                                       GLenum internalformat,
                                       GLenum pname,
                                       GLsizei bufSize,
                                       GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("target", ParamType::TGLenum, target);
    paramBuffer.addValueParam("internalformat", ParamType::TGLenum, internalformat);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetInternalformativ_params(context, isCallValid, target, internalformat, pname, bufSize,
                                      params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetInternalformativ", std::move(paramBuffer));
}

CallCapture CaptureGetProgramBinary(const Context *context,
                                    bool isCallValid,
                                    GLuint program,
                                    GLsizei bufSize,
                                    GLsizei *length,
                                    GLenum *binaryFormat,
                                    void *binary)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::TGLuint, program);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetProgramBinary_length(context, isCallValid, program, bufSize, length, binaryFormat,
                                   binary, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture binaryFormatParam("binaryFormat", ParamType::TGLenumPointer);
    InitParamValue(ParamType::TGLenumPointer, binaryFormat, &binaryFormatParam.value);
    CaptureGetProgramBinary_binaryFormat(context, isCallValid, program, bufSize, length,
                                         binaryFormat, binary, &binaryFormatParam);
    paramBuffer.addParam(std::move(binaryFormatParam));

    ParamCapture binaryParam("binary", ParamType::TvoidPointer);
    InitParamValue(ParamType::TvoidPointer, binary, &binaryParam.value);
    CaptureGetProgramBinary_binary(context, isCallValid, program, bufSize, length, binaryFormat,
                                   binary, &binaryParam);
    paramBuffer.addParam(std::move(binaryParam));

    return CallCapture("glGetProgramBinary", std::move(paramBuffer));
}

CallCapture CaptureGetQueryObjectuiv(const Context *context,
                                     bool isCallValid,
                                     GLuint id,
                                     GLenum pname,
                                     GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("id", ParamType::TGLuint, id);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLuintPointer);
    InitParamValue(ParamType::TGLuintPointer, params, &paramsParam.value);
    CaptureGetQueryObjectuiv_params(context, isCallValid, id, pname, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetQueryObjectuiv", std::move(paramBuffer));
}

CallCapture CaptureGetQueryiv(const Context *context,
                              bool isCallValid,
                              QueryType targetPacked,
                              GLenum pname,
                              GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TQueryType, targetPacked);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetQueryiv_params(context, isCallValid, targetPacked, pname, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetQueryiv", std::move(paramBuffer));
}

CallCapture CaptureGetSamplerParameterfv(const Context *context,
                                         bool isCallValid,
                                         GLuint sampler,
                                         GLenum pname,
                                         GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("sampler", ParamType::TGLuint, sampler);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
    InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
    CaptureGetSamplerParameterfv_params(context, isCallValid, sampler, pname, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetSamplerParameterfv", std::move(paramBuffer));
}

CallCapture CaptureGetSamplerParameteriv(const Context *context,
                                         bool isCallValid,
                                         GLuint sampler,
                                         GLenum pname,
                                         GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("sampler", ParamType::TGLuint, sampler);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetSamplerParameteriv_params(context, isCallValid, sampler, pname, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetSamplerParameteriv", std::move(paramBuffer));
}

CallCapture CaptureGetStringi(const Context *context, bool isCallValid, GLenum name, GLuint index)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("name", ParamType::TGLenum, name);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    return CallCapture("glGetStringi", std::move(paramBuffer));
}

CallCapture CaptureGetSynciv(const Context *context,
                             bool isCallValid,
                             GLsync sync,
                             GLenum pname,
                             GLsizei bufSize,
                             GLsizei *length,
                             GLint *values)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("sync", ParamType::TGLsync, sync);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetSynciv_length(context, isCallValid, sync, pname, bufSize, length, values,
                            &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture valuesParam("values", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, values, &valuesParam.value);
    CaptureGetSynciv_values(context, isCallValid, sync, pname, bufSize, length, values,
                            &valuesParam);
    paramBuffer.addParam(std::move(valuesParam));

    return CallCapture("glGetSynciv", std::move(paramBuffer));
}

CallCapture CaptureGetTransformFeedbackVarying(const Context *context,
                                               bool isCallValid,
                                               GLuint program,
                                               GLuint index,
                                               GLsizei bufSize,
                                               GLsizei *length,
                                               GLsizei *size,
                                               GLenum *type,
                                               GLchar *name)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::TGLuint, program);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetTransformFeedbackVarying_length(context, isCallValid, program, index, bufSize, length,
                                              size, type, name, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture sizeParam("size", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, size, &sizeParam.value);
    CaptureGetTransformFeedbackVarying_size(context, isCallValid, program, index, bufSize, length,
                                            size, type, name, &sizeParam);
    paramBuffer.addParam(std::move(sizeParam));

    ParamCapture typeParam("type", ParamType::TGLenumPointer);
    InitParamValue(ParamType::TGLenumPointer, type, &typeParam.value);
    CaptureGetTransformFeedbackVarying_type(context, isCallValid, program, index, bufSize, length,
                                            size, type, name, &typeParam);
    paramBuffer.addParam(std::move(typeParam));

    ParamCapture nameParam("name", ParamType::TGLcharPointer);
    InitParamValue(ParamType::TGLcharPointer, name, &nameParam.value);
    CaptureGetTransformFeedbackVarying_name(context, isCallValid, program, index, bufSize, length,
                                            size, type, name, &nameParam);
    paramBuffer.addParam(std::move(nameParam));

    return CallCapture("glGetTransformFeedbackVarying", std::move(paramBuffer));
}

CallCapture CaptureGetUniformBlockIndex(const Context *context,
                                        bool isCallValid,
                                        GLuint program,
                                        const GLchar *uniformBlockName)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::TGLuint, program);

    ParamCapture uniformBlockNameParam("uniformBlockName", ParamType::TGLcharConstPointer);
    InitParamValue(ParamType::TGLcharConstPointer, uniformBlockName, &uniformBlockNameParam.value);
    CaptureGetUniformBlockIndex_uniformBlockName(context, isCallValid, program, uniformBlockName,
                                                 &uniformBlockNameParam);
    paramBuffer.addParam(std::move(uniformBlockNameParam));

    return CallCapture("glGetUniformBlockIndex", std::move(paramBuffer));
}

CallCapture CaptureGetUniformIndices(const Context *context,
                                     bool isCallValid,
                                     GLuint program,
                                     GLsizei uniformCount,
                                     const GLchar *const *uniformNames,
                                     GLuint *uniformIndices)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::TGLuint, program);
    paramBuffer.addValueParam("uniformCount", ParamType::TGLsizei, uniformCount);

    ParamCapture uniformNamesParam("uniformNames", ParamType::TGLcharConstPointerPointer);
    InitParamValue(ParamType::TGLcharConstPointerPointer, uniformNames, &uniformNamesParam.value);
    CaptureGetUniformIndices_uniformNames(context, isCallValid, program, uniformCount, uniformNames,
                                          uniformIndices, &uniformNamesParam);
    paramBuffer.addParam(std::move(uniformNamesParam));

    ParamCapture uniformIndicesParam("uniformIndices", ParamType::TGLuintPointer);
    InitParamValue(ParamType::TGLuintPointer, uniformIndices, &uniformIndicesParam.value);
    CaptureGetUniformIndices_uniformIndices(context, isCallValid, program, uniformCount,
                                            uniformNames, uniformIndices, &uniformIndicesParam);
    paramBuffer.addParam(std::move(uniformIndicesParam));

    return CallCapture("glGetUniformIndices", std::move(paramBuffer));
}

CallCapture CaptureGetUniformuiv(const Context *context,
                                 bool isCallValid,
                                 GLuint program,
                                 GLint location,
                                 GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::TGLuint, program);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);

    ParamCapture paramsParam("params", ParamType::TGLuintPointer);
    InitParamValue(ParamType::TGLuintPointer, params, &paramsParam.value);
    CaptureGetUniformuiv_params(context, isCallValid, program, location, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetUniformuiv", std::move(paramBuffer));
}

CallCapture CaptureGetVertexAttribIiv(const Context *context,
                                      bool isCallValid,
                                      GLuint index,
                                      GLenum pname,
                                      GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetVertexAttribIiv_params(context, isCallValid, index, pname, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetVertexAttribIiv", std::move(paramBuffer));
}

CallCapture CaptureGetVertexAttribIuiv(const Context *context,
                                       bool isCallValid,
                                       GLuint index,
                                       GLenum pname,
                                       GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLuintPointer);
    InitParamValue(ParamType::TGLuintPointer, params, &paramsParam.value);
    CaptureGetVertexAttribIuiv_params(context, isCallValid, index, pname, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetVertexAttribIuiv", std::move(paramBuffer));
}

CallCapture CaptureInvalidateFramebuffer(const Context *context,
                                         bool isCallValid,
                                         GLenum target,
                                         GLsizei numAttachments,
                                         const GLenum *attachments)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("target", ParamType::TGLenum, target);
    paramBuffer.addValueParam("numAttachments", ParamType::TGLsizei, numAttachments);

    ParamCapture attachmentsParam("attachments", ParamType::TGLenumConstPointer);
    InitParamValue(ParamType::TGLenumConstPointer, attachments, &attachmentsParam.value);
    CaptureInvalidateFramebuffer_attachments(context, isCallValid, target, numAttachments,
                                             attachments, &attachmentsParam);
    paramBuffer.addParam(std::move(attachmentsParam));

    return CallCapture("glInvalidateFramebuffer", std::move(paramBuffer));
}

CallCapture CaptureInvalidateSubFramebuffer(const Context *context,
                                            bool isCallValid,
                                            GLenum target,
                                            GLsizei numAttachments,
                                            const GLenum *attachments,
                                            GLint x,
                                            GLint y,
                                            GLsizei width,
                                            GLsizei height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("target", ParamType::TGLenum, target);
    paramBuffer.addValueParam("numAttachments", ParamType::TGLsizei, numAttachments);

    ParamCapture attachmentsParam("attachments", ParamType::TGLenumConstPointer);
    InitParamValue(ParamType::TGLenumConstPointer, attachments, &attachmentsParam.value);
    CaptureInvalidateSubFramebuffer_attachments(context, isCallValid, target, numAttachments,
                                                attachments, x, y, width, height,
                                                &attachmentsParam);
    paramBuffer.addParam(std::move(attachmentsParam));

    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);

    return CallCapture("glInvalidateSubFramebuffer", std::move(paramBuffer));
}

CallCapture CaptureIsQuery(const Context *context, bool isCallValid, GLuint id)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("id", ParamType::TGLuint, id);

    return CallCapture("glIsQuery", std::move(paramBuffer));
}

CallCapture CaptureIsSampler(const Context *context, bool isCallValid, GLuint sampler)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("sampler", ParamType::TGLuint, sampler);

    return CallCapture("glIsSampler", std::move(paramBuffer));
}

CallCapture CaptureIsSync(const Context *context, bool isCallValid, GLsync sync)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("sync", ParamType::TGLsync, sync);

    return CallCapture("glIsSync", std::move(paramBuffer));
}

CallCapture CaptureIsTransformFeedback(const Context *context, bool isCallValid, GLuint id)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("id", ParamType::TGLuint, id);

    return CallCapture("glIsTransformFeedback", std::move(paramBuffer));
}

CallCapture CaptureIsVertexArray(const Context *context, bool isCallValid, GLuint array)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("array", ParamType::TGLuint, array);

    return CallCapture("glIsVertexArray", std::move(paramBuffer));
}

CallCapture CaptureMapBufferRange(const Context *context,
                                  bool isCallValid,
                                  BufferBinding targetPacked,
                                  GLintptr offset,
                                  GLsizeiptr length,
                                  GLbitfield access)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);
    paramBuffer.addValueParam("offset", ParamType::TGLintptr, offset);
    paramBuffer.addValueParam("length", ParamType::TGLsizeiptr, length);
    paramBuffer.addValueParam("access", ParamType::TGLbitfield, access);

    return CallCapture("glMapBufferRange", std::move(paramBuffer));
}

CallCapture CapturePauseTransformFeedback(const Context *context, bool isCallValid)
{
    ParamBuffer paramBuffer;

    return CallCapture("glPauseTransformFeedback", std::move(paramBuffer));
}

CallCapture CaptureProgramBinary(const Context *context,
                                 bool isCallValid,
                                 GLuint program,
                                 GLenum binaryFormat,
                                 const void *binary,
                                 GLsizei length)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::TGLuint, program);
    paramBuffer.addValueParam("binaryFormat", ParamType::TGLenum, binaryFormat);

    ParamCapture binaryParam("binary", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, binary, &binaryParam.value);
    CaptureProgramBinary_binary(context, isCallValid, program, binaryFormat, binary, length,
                                &binaryParam);
    paramBuffer.addParam(std::move(binaryParam));

    paramBuffer.addValueParam("length", ParamType::TGLsizei, length);

    return CallCapture("glProgramBinary", std::move(paramBuffer));
}

CallCapture CaptureProgramParameteri(const Context *context,
                                     bool isCallValid,
                                     GLuint program,
                                     GLenum pname,
                                     GLint value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::TGLuint, program);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);
    paramBuffer.addValueParam("value", ParamType::TGLint, value);

    return CallCapture("glProgramParameteri", std::move(paramBuffer));
}

CallCapture CaptureReadBuffer(const Context *context, bool isCallValid, GLenum src)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("src", ParamType::TGLenum, src);

    return CallCapture("glReadBuffer", std::move(paramBuffer));
}

CallCapture CaptureRenderbufferStorageMultisample(const Context *context,
                                                  bool isCallValid,
                                                  GLenum target,
                                                  GLsizei samples,
                                                  GLenum internalformat,
                                                  GLsizei width,
                                                  GLsizei height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("target", ParamType::TGLenum, target);
    paramBuffer.addValueParam("samples", ParamType::TGLsizei, samples);
    paramBuffer.addValueParam("internalformat", ParamType::TGLenum, internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);

    return CallCapture("glRenderbufferStorageMultisample", std::move(paramBuffer));
}

CallCapture CaptureResumeTransformFeedback(const Context *context, bool isCallValid)
{
    ParamBuffer paramBuffer;

    return CallCapture("glResumeTransformFeedback", std::move(paramBuffer));
}

CallCapture CaptureSamplerParameterf(const Context *context,
                                     bool isCallValid,
                                     GLuint sampler,
                                     GLenum pname,
                                     GLfloat param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("sampler", ParamType::TGLuint, sampler);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);
    paramBuffer.addValueParam("param", ParamType::TGLfloat, param);

    return CallCapture("glSamplerParameterf", std::move(paramBuffer));
}

CallCapture CaptureSamplerParameterfv(const Context *context,
                                      bool isCallValid,
                                      GLuint sampler,
                                      GLenum pname,
                                      const GLfloat *param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("sampler", ParamType::TGLuint, sampler);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);

    ParamCapture paramParam("param", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, param, &paramParam.value);
    CaptureSamplerParameterfv_param(context, isCallValid, sampler, pname, param, &paramParam);
    paramBuffer.addParam(std::move(paramParam));

    return CallCapture("glSamplerParameterfv", std::move(paramBuffer));
}

CallCapture CaptureSamplerParameteri(const Context *context,
                                     bool isCallValid,
                                     GLuint sampler,
                                     GLenum pname,
                                     GLint param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("sampler", ParamType::TGLuint, sampler);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);
    paramBuffer.addValueParam("param", ParamType::TGLint, param);

    return CallCapture("glSamplerParameteri", std::move(paramBuffer));
}

CallCapture CaptureSamplerParameteriv(const Context *context,
                                      bool isCallValid,
                                      GLuint sampler,
                                      GLenum pname,
                                      const GLint *param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("sampler", ParamType::TGLuint, sampler);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);

    ParamCapture paramParam("param", ParamType::TGLintConstPointer);
    InitParamValue(ParamType::TGLintConstPointer, param, &paramParam.value);
    CaptureSamplerParameteriv_param(context, isCallValid, sampler, pname, param, &paramParam);
    paramBuffer.addParam(std::move(paramParam));

    return CallCapture("glSamplerParameteriv", std::move(paramBuffer));
}

CallCapture CaptureTexImage3D(const Context *context,
                              bool isCallValid,
                              TextureTarget targetPacked,
                              GLint level,
                              GLint internalformat,
                              GLsizei width,
                              GLsizei height,
                              GLsizei depth,
                              GLint border,
                              GLenum format,
                              GLenum type,
                              const void *pixels)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("internalformat", ParamType::TGLint, internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addValueParam("border", ParamType::TGLint, border);
    paramBuffer.addValueParam("format", ParamType::TGLenum, format);
    paramBuffer.addValueParam("type", ParamType::TGLenum, type);

    ParamCapture pixelsParam("pixels", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, pixels, &pixelsParam.value);
    CaptureTexImage3D_pixels(context, isCallValid, targetPacked, level, internalformat, width,
                             height, depth, border, format, type, pixels, &pixelsParam);
    paramBuffer.addParam(std::move(pixelsParam));

    return CallCapture("glTexImage3D", std::move(paramBuffer));
}

CallCapture CaptureTexStorage2D(const Context *context,
                                bool isCallValid,
                                TextureType targetPacked,
                                GLsizei levels,
                                GLenum internalformat,
                                GLsizei width,
                                GLsizei height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("levels", ParamType::TGLsizei, levels);
    paramBuffer.addValueParam("internalformat", ParamType::TGLenum, internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);

    return CallCapture("glTexStorage2D", std::move(paramBuffer));
}

CallCapture CaptureTexStorage3D(const Context *context,
                                bool isCallValid,
                                TextureType targetPacked,
                                GLsizei levels,
                                GLenum internalformat,
                                GLsizei width,
                                GLsizei height,
                                GLsizei depth)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("levels", ParamType::TGLsizei, levels);
    paramBuffer.addValueParam("internalformat", ParamType::TGLenum, internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);

    return CallCapture("glTexStorage3D", std::move(paramBuffer));
}

CallCapture CaptureTexSubImage3D(const Context *context,
                                 bool isCallValid,
                                 TextureTarget targetPacked,
                                 GLint level,
                                 GLint xoffset,
                                 GLint yoffset,
                                 GLint zoffset,
                                 GLsizei width,
                                 GLsizei height,
                                 GLsizei depth,
                                 GLenum format,
                                 GLenum type,
                                 const void *pixels)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLint, yoffset);
    paramBuffer.addValueParam("zoffset", ParamType::TGLint, zoffset);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addValueParam("format", ParamType::TGLenum, format);
    paramBuffer.addValueParam("type", ParamType::TGLenum, type);

    ParamCapture pixelsParam("pixels", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, pixels, &pixelsParam.value);
    CaptureTexSubImage3D_pixels(context, isCallValid, targetPacked, level, xoffset, yoffset,
                                zoffset, width, height, depth, format, type, pixels, &pixelsParam);
    paramBuffer.addParam(std::move(pixelsParam));

    return CallCapture("glTexSubImage3D", std::move(paramBuffer));
}

CallCapture CaptureTransformFeedbackVaryings(const Context *context,
                                             bool isCallValid,
                                             GLuint program,
                                             GLsizei count,
                                             const GLchar *const *varyings,
                                             GLenum bufferMode)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::TGLuint, program);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture varyingsParam("varyings", ParamType::TGLcharConstPointerPointer);
    InitParamValue(ParamType::TGLcharConstPointerPointer, varyings, &varyingsParam.value);
    CaptureTransformFeedbackVaryings_varyings(context, isCallValid, program, count, varyings,
                                              bufferMode, &varyingsParam);
    paramBuffer.addParam(std::move(varyingsParam));

    paramBuffer.addValueParam("bufferMode", ParamType::TGLenum, bufferMode);

    return CallCapture("glTransformFeedbackVaryings", std::move(paramBuffer));
}

CallCapture CaptureUniform1ui(const Context *context, bool isCallValid, GLint location, GLuint v0)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("v0", ParamType::TGLuint, v0);

    return CallCapture("glUniform1ui", std::move(paramBuffer));
}

CallCapture CaptureUniform1uiv(const Context *context,
                               bool isCallValid,
                               GLint location,
                               GLsizei count,
                               const GLuint *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture valueParam("value", ParamType::TGLuintConstPointer);
    InitParamValue(ParamType::TGLuintConstPointer, value, &valueParam.value);
    CaptureUniform1uiv_value(context, isCallValid, location, count, value, &valueParam);
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture("glUniform1uiv", std::move(paramBuffer));
}

CallCapture CaptureUniform2ui(const Context *context,
                              bool isCallValid,
                              GLint location,
                              GLuint v0,
                              GLuint v1)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("v0", ParamType::TGLuint, v0);
    paramBuffer.addValueParam("v1", ParamType::TGLuint, v1);

    return CallCapture("glUniform2ui", std::move(paramBuffer));
}

CallCapture CaptureUniform2uiv(const Context *context,
                               bool isCallValid,
                               GLint location,
                               GLsizei count,
                               const GLuint *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture valueParam("value", ParamType::TGLuintConstPointer);
    InitParamValue(ParamType::TGLuintConstPointer, value, &valueParam.value);
    CaptureUniform2uiv_value(context, isCallValid, location, count, value, &valueParam);
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture("glUniform2uiv", std::move(paramBuffer));
}

CallCapture CaptureUniform3ui(const Context *context,
                              bool isCallValid,
                              GLint location,
                              GLuint v0,
                              GLuint v1,
                              GLuint v2)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("v0", ParamType::TGLuint, v0);
    paramBuffer.addValueParam("v1", ParamType::TGLuint, v1);
    paramBuffer.addValueParam("v2", ParamType::TGLuint, v2);

    return CallCapture("glUniform3ui", std::move(paramBuffer));
}

CallCapture CaptureUniform3uiv(const Context *context,
                               bool isCallValid,
                               GLint location,
                               GLsizei count,
                               const GLuint *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture valueParam("value", ParamType::TGLuintConstPointer);
    InitParamValue(ParamType::TGLuintConstPointer, value, &valueParam.value);
    CaptureUniform3uiv_value(context, isCallValid, location, count, value, &valueParam);
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture("glUniform3uiv", std::move(paramBuffer));
}

CallCapture CaptureUniform4ui(const Context *context,
                              bool isCallValid,
                              GLint location,
                              GLuint v0,
                              GLuint v1,
                              GLuint v2,
                              GLuint v3)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("v0", ParamType::TGLuint, v0);
    paramBuffer.addValueParam("v1", ParamType::TGLuint, v1);
    paramBuffer.addValueParam("v2", ParamType::TGLuint, v2);
    paramBuffer.addValueParam("v3", ParamType::TGLuint, v3);

    return CallCapture("glUniform4ui", std::move(paramBuffer));
}

CallCapture CaptureUniform4uiv(const Context *context,
                               bool isCallValid,
                               GLint location,
                               GLsizei count,
                               const GLuint *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture valueParam("value", ParamType::TGLuintConstPointer);
    InitParamValue(ParamType::TGLuintConstPointer, value, &valueParam.value);
    CaptureUniform4uiv_value(context, isCallValid, location, count, value, &valueParam);
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture("glUniform4uiv", std::move(paramBuffer));
}

CallCapture CaptureUniformBlockBinding(const Context *context,
                                       bool isCallValid,
                                       GLuint program,
                                       GLuint uniformBlockIndex,
                                       GLuint uniformBlockBinding)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::TGLuint, program);
    paramBuffer.addValueParam("uniformBlockIndex", ParamType::TGLuint, uniformBlockIndex);
    paramBuffer.addValueParam("uniformBlockBinding", ParamType::TGLuint, uniformBlockBinding);

    return CallCapture("glUniformBlockBinding", std::move(paramBuffer));
}

CallCapture CaptureUniformMatrix2x3fv(const Context *context,
                                      bool isCallValid,
                                      GLint location,
                                      GLsizei count,
                                      GLboolean transpose,
                                      const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
    CaptureUniformMatrix2x3fv_value(context, isCallValid, location, count, transpose, value,
                                    &valueParam);
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture("glUniformMatrix2x3fv", std::move(paramBuffer));
}

CallCapture CaptureUniformMatrix2x4fv(const Context *context,
                                      bool isCallValid,
                                      GLint location,
                                      GLsizei count,
                                      GLboolean transpose,
                                      const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
    CaptureUniformMatrix2x4fv_value(context, isCallValid, location, count, transpose, value,
                                    &valueParam);
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture("glUniformMatrix2x4fv", std::move(paramBuffer));
}

CallCapture CaptureUniformMatrix3x2fv(const Context *context,
                                      bool isCallValid,
                                      GLint location,
                                      GLsizei count,
                                      GLboolean transpose,
                                      const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
    CaptureUniformMatrix3x2fv_value(context, isCallValid, location, count, transpose, value,
                                    &valueParam);
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture("glUniformMatrix3x2fv", std::move(paramBuffer));
}

CallCapture CaptureUniformMatrix3x4fv(const Context *context,
                                      bool isCallValid,
                                      GLint location,
                                      GLsizei count,
                                      GLboolean transpose,
                                      const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
    CaptureUniformMatrix3x4fv_value(context, isCallValid, location, count, transpose, value,
                                    &valueParam);
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture("glUniformMatrix3x4fv", std::move(paramBuffer));
}

CallCapture CaptureUniformMatrix4x2fv(const Context *context,
                                      bool isCallValid,
                                      GLint location,
                                      GLsizei count,
                                      GLboolean transpose,
                                      const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
    CaptureUniformMatrix4x2fv_value(context, isCallValid, location, count, transpose, value,
                                    &valueParam);
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture("glUniformMatrix4x2fv", std::move(paramBuffer));
}

CallCapture CaptureUniformMatrix4x3fv(const Context *context,
                                      bool isCallValid,
                                      GLint location,
                                      GLsizei count,
                                      GLboolean transpose,
                                      const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
    CaptureUniformMatrix4x3fv_value(context, isCallValid, location, count, transpose, value,
                                    &valueParam);
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture("glUniformMatrix4x3fv", std::move(paramBuffer));
}

CallCapture CaptureUnmapBuffer(const Context *context, bool isCallValid, BufferBinding targetPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);

    return CallCapture("glUnmapBuffer", std::move(paramBuffer));
}

CallCapture CaptureVertexAttribDivisor(const Context *context,
                                       bool isCallValid,
                                       GLuint index,
                                       GLuint divisor)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("divisor", ParamType::TGLuint, divisor);

    return CallCapture("glVertexAttribDivisor", std::move(paramBuffer));
}

CallCapture CaptureVertexAttribI4i(const Context *context,
                                   bool isCallValid,
                                   GLuint index,
                                   GLint x,
                                   GLint y,
                                   GLint z,
                                   GLint w)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("z", ParamType::TGLint, z);
    paramBuffer.addValueParam("w", ParamType::TGLint, w);

    return CallCapture("glVertexAttribI4i", std::move(paramBuffer));
}

CallCapture CaptureVertexAttribI4iv(const Context *context,
                                    bool isCallValid,
                                    GLuint index,
                                    const GLint *v)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    ParamCapture vParam("v", ParamType::TGLintConstPointer);
    InitParamValue(ParamType::TGLintConstPointer, v, &vParam.value);
    CaptureVertexAttribI4iv_v(context, isCallValid, index, v, &vParam);
    paramBuffer.addParam(std::move(vParam));

    return CallCapture("glVertexAttribI4iv", std::move(paramBuffer));
}

CallCapture CaptureVertexAttribI4ui(const Context *context,
                                    bool isCallValid,
                                    GLuint index,
                                    GLuint x,
                                    GLuint y,
                                    GLuint z,
                                    GLuint w)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("x", ParamType::TGLuint, x);
    paramBuffer.addValueParam("y", ParamType::TGLuint, y);
    paramBuffer.addValueParam("z", ParamType::TGLuint, z);
    paramBuffer.addValueParam("w", ParamType::TGLuint, w);

    return CallCapture("glVertexAttribI4ui", std::move(paramBuffer));
}

CallCapture CaptureVertexAttribI4uiv(const Context *context,
                                     bool isCallValid,
                                     GLuint index,
                                     const GLuint *v)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    ParamCapture vParam("v", ParamType::TGLuintConstPointer);
    InitParamValue(ParamType::TGLuintConstPointer, v, &vParam.value);
    CaptureVertexAttribI4uiv_v(context, isCallValid, index, v, &vParam);
    paramBuffer.addParam(std::move(vParam));

    return CallCapture("glVertexAttribI4uiv", std::move(paramBuffer));
}

CallCapture CaptureVertexAttribIPointer(const Context *context,
                                        bool isCallValid,
                                        GLuint index,
                                        GLint size,
                                        VertexAttribType typePacked,
                                        GLsizei stride,
                                        const void *pointer)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("size", ParamType::TGLint, size);
    paramBuffer.addValueParam("typePacked", ParamType::TVertexAttribType, typePacked);
    paramBuffer.addValueParam("stride", ParamType::TGLsizei, stride);

    ParamCapture pointerParam("pointer", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, pointer, &pointerParam.value);
    CaptureVertexAttribIPointer_pointer(context, isCallValid, index, size, typePacked, stride,
                                        pointer, &pointerParam);
    paramBuffer.addParam(std::move(pointerParam));

    return CallCapture("glVertexAttribIPointer", std::move(paramBuffer));
}

CallCapture CaptureWaitSync(const Context *context,
                            bool isCallValid,
                            GLsync sync,
                            GLbitfield flags,
                            GLuint64 timeout)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("sync", ParamType::TGLsync, sync);
    paramBuffer.addValueParam("flags", ParamType::TGLbitfield, flags);
    paramBuffer.addValueParam("timeout", ParamType::TGLuint64, timeout);

    return CallCapture("glWaitSync", std::move(paramBuffer));
}

}  // namespace gl
