// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from gl.xml and gl_angle_ext.xml.
//
// Copyright 2019 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// capture_gles_ext_autogen.cpp:
//   Capture functions for the OpenGL ES extension entry points.

#include "libANGLE/capture_gles_ext_autogen.h"

#include "libANGLE/Context.h"
#include "libANGLE/FrameCapture.h"
#include "libANGLE/validationESEXT.h"

using namespace angle;

namespace gl
{

CallCapture CaptureCopyTexture3DANGLE(const Context *context,
                                      bool isCallValid,
                                      GLuint sourceId,
                                      GLint sourceLevel,
                                      TextureTarget destTargetPacked,
                                      GLuint destId,
                                      GLint destLevel,
                                      GLint internalFormat,
                                      GLenum destType,
                                      GLboolean unpackFlipY,
                                      GLboolean unpackPremultiplyAlpha,
                                      GLboolean unpackUnmultiplyAlpha)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("sourceId", ParamType::TGLuint, sourceId);
    paramBuffer.addValueParam("sourceLevel", ParamType::TGLint, sourceLevel);
    paramBuffer.addValueParam("destTargetPacked", ParamType::TTextureTarget, destTargetPacked);
    paramBuffer.addValueParam("destId", ParamType::TGLuint, destId);
    paramBuffer.addValueParam("destLevel", ParamType::TGLint, destLevel);
    paramBuffer.addValueParam("internalFormat", ParamType::TGLint, internalFormat);
    paramBuffer.addValueParam("destType", ParamType::TGLenum, destType);
    paramBuffer.addValueParam("unpackFlipY", ParamType::TGLboolean, unpackFlipY);
    paramBuffer.addValueParam("unpackPremultiplyAlpha", ParamType::TGLboolean,
                              unpackPremultiplyAlpha);
    paramBuffer.addValueParam("unpackUnmultiplyAlpha", ParamType::TGLboolean,
                              unpackUnmultiplyAlpha);

    return CallCapture("glCopyTexture3DANGLE", std::move(paramBuffer));
}

CallCapture CaptureCopySubTexture3DANGLE(const Context *context,
                                         bool isCallValid,
                                         GLuint sourceId,
                                         GLint sourceLevel,
                                         TextureTarget destTargetPacked,
                                         GLuint destId,
                                         GLint destLevel,
                                         GLint xoffset,
                                         GLint yoffset,
                                         GLint zoffset,
                                         GLint x,
                                         GLint y,
                                         GLint z,
                                         GLint width,
                                         GLint height,
                                         GLint depth,
                                         GLboolean unpackFlipY,
                                         GLboolean unpackPremultiplyAlpha,
                                         GLboolean unpackUnmultiplyAlpha)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("sourceId", ParamType::TGLuint, sourceId);
    paramBuffer.addValueParam("sourceLevel", ParamType::TGLint, sourceLevel);
    paramBuffer.addValueParam("destTargetPacked", ParamType::TTextureTarget, destTargetPacked);
    paramBuffer.addValueParam("destId", ParamType::TGLuint, destId);
    paramBuffer.addValueParam("destLevel", ParamType::TGLint, destLevel);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLint, yoffset);
    paramBuffer.addValueParam("zoffset", ParamType::TGLint, zoffset);
    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("z", ParamType::TGLint, z);
    paramBuffer.addValueParam("width", ParamType::TGLint, width);
    paramBuffer.addValueParam("height", ParamType::TGLint, height);
    paramBuffer.addValueParam("depth", ParamType::TGLint, depth);
    paramBuffer.addValueParam("unpackFlipY", ParamType::TGLboolean, unpackFlipY);
    paramBuffer.addValueParam("unpackPremultiplyAlpha", ParamType::TGLboolean,
                              unpackPremultiplyAlpha);
    paramBuffer.addValueParam("unpackUnmultiplyAlpha", ParamType::TGLboolean,
                              unpackUnmultiplyAlpha);

    return CallCapture("glCopySubTexture3DANGLE", std::move(paramBuffer));
}

CallCapture CaptureBlitFramebufferANGLE(const Context *context,
                                        bool isCallValid,
                                        GLint srcX0,
                                        GLint srcY0,
                                        GLint srcX1,
                                        GLint srcY1,
                                        GLint dstX0,
                                        GLint dstY0,
                                        GLint dstX1,
                                        GLint dstY1,
                                        GLbitfield mask,
                                        GLenum filter)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("srcX0", ParamType::TGLint, srcX0);
    paramBuffer.addValueParam("srcY0", ParamType::TGLint, srcY0);
    paramBuffer.addValueParam("srcX1", ParamType::TGLint, srcX1);
    paramBuffer.addValueParam("srcY1", ParamType::TGLint, srcY1);
    paramBuffer.addValueParam("dstX0", ParamType::TGLint, dstX0);
    paramBuffer.addValueParam("dstY0", ParamType::TGLint, dstY0);
    paramBuffer.addValueParam("dstX1", ParamType::TGLint, dstX1);
    paramBuffer.addValueParam("dstY1", ParamType::TGLint, dstY1);
    paramBuffer.addValueParam("mask", ParamType::TGLbitfield, mask);
    paramBuffer.addValueParam("filter", ParamType::TGLenum, filter);

    return CallCapture("glBlitFramebufferANGLE", std::move(paramBuffer));
}

CallCapture CaptureRenderbufferStorageMultisampleANGLE(const Context *context,
                                                       bool isCallValid,
                                                       GLenum target,
                                                       GLsizei samples,
                                                       GLenum internalformat,
                                                       GLsizei width,
                                                       GLsizei height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("target", ParamType::TGLenum, target);
    paramBuffer.addValueParam("samples", ParamType::TGLsizei, samples);
    paramBuffer.addValueParam("internalformat", ParamType::TGLenum, internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);

    return CallCapture("glRenderbufferStorageMultisampleANGLE", std::move(paramBuffer));
}

CallCapture CaptureDrawArraysInstancedANGLE(const Context *context,
                                            bool isCallValid,
                                            PrimitiveMode modePacked,
                                            GLint first,
                                            GLsizei count,
                                            GLsizei primcount)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("first", ParamType::TGLint, first);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("primcount", ParamType::TGLsizei, primcount);

    return CallCapture("glDrawArraysInstancedANGLE", std::move(paramBuffer));
}

CallCapture CaptureDrawElementsInstancedANGLE(const Context *context,
                                              bool isCallValid,
                                              PrimitiveMode modePacked,
                                              GLsizei count,
                                              DrawElementsType typePacked,
                                              const void *indices,
                                              GLsizei primcount)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("typePacked", ParamType::TDrawElementsType, typePacked);

    ParamCapture indicesParam("indices", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, indices, &indicesParam.value);
    CaptureDrawElementsInstancedANGLE_indices(context, isCallValid, modePacked, count, typePacked,
                                              indices, primcount, &indicesParam);
    paramBuffer.addParam(std::move(indicesParam));

    paramBuffer.addValueParam("primcount", ParamType::TGLsizei, primcount);

    return CallCapture("glDrawElementsInstancedANGLE", std::move(paramBuffer));
}

CallCapture CaptureVertexAttribDivisorANGLE(const Context *context,
                                            bool isCallValid,
                                            GLuint index,
                                            GLuint divisor)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("divisor", ParamType::TGLuint, divisor);

    return CallCapture("glVertexAttribDivisorANGLE", std::move(paramBuffer));
}

CallCapture CaptureMultiDrawArraysANGLE(const Context *context,
                                        bool isCallValid,
                                        PrimitiveMode modePacked,
                                        const GLint *firsts,
                                        const GLsizei *counts,
                                        GLsizei drawcount)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);

    ParamCapture firstsParam("firsts", ParamType::TGLintConstPointer);
    InitParamValue(ParamType::TGLintConstPointer, firsts, &firstsParam.value);
    CaptureMultiDrawArraysANGLE_firsts(context, isCallValid, modePacked, firsts, counts, drawcount,
                                       &firstsParam);
    paramBuffer.addParam(std::move(firstsParam));

    ParamCapture countsParam("counts", ParamType::TGLsizeiConstPointer);
    InitParamValue(ParamType::TGLsizeiConstPointer, counts, &countsParam.value);
    CaptureMultiDrawArraysANGLE_counts(context, isCallValid, modePacked, firsts, counts, drawcount,
                                       &countsParam);
    paramBuffer.addParam(std::move(countsParam));

    paramBuffer.addValueParam("drawcount", ParamType::TGLsizei, drawcount);

    return CallCapture("glMultiDrawArraysANGLE", std::move(paramBuffer));
}

CallCapture CaptureMultiDrawArraysInstancedANGLE(const Context *context,
                                                 bool isCallValid,
                                                 PrimitiveMode modePacked,
                                                 const GLint *firsts,
                                                 const GLsizei *counts,
                                                 const GLsizei *instanceCounts,
                                                 GLsizei drawcount)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);

    ParamCapture firstsParam("firsts", ParamType::TGLintConstPointer);
    InitParamValue(ParamType::TGLintConstPointer, firsts, &firstsParam.value);
    CaptureMultiDrawArraysInstancedANGLE_firsts(context, isCallValid, modePacked, firsts, counts,
                                                instanceCounts, drawcount, &firstsParam);
    paramBuffer.addParam(std::move(firstsParam));

    ParamCapture countsParam("counts", ParamType::TGLsizeiConstPointer);
    InitParamValue(ParamType::TGLsizeiConstPointer, counts, &countsParam.value);
    CaptureMultiDrawArraysInstancedANGLE_counts(context, isCallValid, modePacked, firsts, counts,
                                                instanceCounts, drawcount, &countsParam);
    paramBuffer.addParam(std::move(countsParam));

    ParamCapture instanceCountsParam("instanceCounts", ParamType::TGLsizeiConstPointer);
    InitParamValue(ParamType::TGLsizeiConstPointer, instanceCounts, &instanceCountsParam.value);
    CaptureMultiDrawArraysInstancedANGLE_instanceCounts(context, isCallValid, modePacked, firsts,
                                                        counts, instanceCounts, drawcount,
                                                        &instanceCountsParam);
    paramBuffer.addParam(std::move(instanceCountsParam));

    paramBuffer.addValueParam("drawcount", ParamType::TGLsizei, drawcount);

    return CallCapture("glMultiDrawArraysInstancedANGLE", std::move(paramBuffer));
}

CallCapture CaptureMultiDrawElementsANGLE(const Context *context,
                                          bool isCallValid,
                                          PrimitiveMode modePacked,
                                          const GLsizei *counts,
                                          DrawElementsType typePacked,
                                          const GLvoid *const *indices,
                                          GLsizei drawcount)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);

    ParamCapture countsParam("counts", ParamType::TGLsizeiConstPointer);
    InitParamValue(ParamType::TGLsizeiConstPointer, counts, &countsParam.value);
    CaptureMultiDrawElementsANGLE_counts(context, isCallValid, modePacked, counts, typePacked,
                                         indices, drawcount, &countsParam);
    paramBuffer.addParam(std::move(countsParam));

    paramBuffer.addValueParam("typePacked", ParamType::TDrawElementsType, typePacked);

    ParamCapture indicesParam("indices", ParamType::TGLvoidConstPointerPointer);
    InitParamValue(ParamType::TGLvoidConstPointerPointer, indices, &indicesParam.value);
    CaptureMultiDrawElementsANGLE_indices(context, isCallValid, modePacked, counts, typePacked,
                                          indices, drawcount, &indicesParam);
    paramBuffer.addParam(std::move(indicesParam));

    paramBuffer.addValueParam("drawcount", ParamType::TGLsizei, drawcount);

    return CallCapture("glMultiDrawElementsANGLE", std::move(paramBuffer));
}

CallCapture CaptureMultiDrawElementsInstancedANGLE(const Context *context,
                                                   bool isCallValid,
                                                   PrimitiveMode modePacked,
                                                   const GLsizei *counts,
                                                   DrawElementsType typePacked,
                                                   const GLvoid *const *indices,
                                                   const GLsizei *instanceCounts,
                                                   GLsizei drawcount)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);

    ParamCapture countsParam("counts", ParamType::TGLsizeiConstPointer);
    InitParamValue(ParamType::TGLsizeiConstPointer, counts, &countsParam.value);
    CaptureMultiDrawElementsInstancedANGLE_counts(context, isCallValid, modePacked, counts,
                                                  typePacked, indices, instanceCounts, drawcount,
                                                  &countsParam);
    paramBuffer.addParam(std::move(countsParam));

    paramBuffer.addValueParam("typePacked", ParamType::TDrawElementsType, typePacked);

    ParamCapture indicesParam("indices", ParamType::TGLvoidConstPointerPointer);
    InitParamValue(ParamType::TGLvoidConstPointerPointer, indices, &indicesParam.value);
    CaptureMultiDrawElementsInstancedANGLE_indices(context, isCallValid, modePacked, counts,
                                                   typePacked, indices, instanceCounts, drawcount,
                                                   &indicesParam);
    paramBuffer.addParam(std::move(indicesParam));

    ParamCapture instanceCountsParam("instanceCounts", ParamType::TGLsizeiConstPointer);
    InitParamValue(ParamType::TGLsizeiConstPointer, instanceCounts, &instanceCountsParam.value);
    CaptureMultiDrawElementsInstancedANGLE_instanceCounts(context, isCallValid, modePacked, counts,
                                                          typePacked, indices, instanceCounts,
                                                          drawcount, &instanceCountsParam);
    paramBuffer.addParam(std::move(instanceCountsParam));

    paramBuffer.addValueParam("drawcount", ParamType::TGLsizei, drawcount);

    return CallCapture("glMultiDrawElementsInstancedANGLE", std::move(paramBuffer));
}

CallCapture CaptureProvokingVertexANGLE(const Context *context,
                                        bool isCallValid,
                                        ProvokingVertex modePacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TProvokingVertex, modePacked);

    return CallCapture("glProvokingVertexANGLE", std::move(paramBuffer));
}

CallCapture CaptureRequestExtensionANGLE(const Context *context,
                                         bool isCallValid,
                                         const GLchar *name)
{
    ParamBuffer paramBuffer;

    ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
    InitParamValue(ParamType::TGLcharConstPointer, name, &nameParam.value);
    CaptureRequestExtensionANGLE_name(context, isCallValid, name, &nameParam);
    paramBuffer.addParam(std::move(nameParam));

    return CallCapture("glRequestExtensionANGLE", std::move(paramBuffer));
}

CallCapture CaptureGetBooleanvRobustANGLE(const Context *context,
                                          bool isCallValid,
                                          GLenum pname,
                                          GLsizei bufSize,
                                          GLsizei *length,
                                          GLboolean *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetBooleanvRobustANGLE_length(context, isCallValid, pname, bufSize, length, params,
                                         &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLbooleanPointer);
    InitParamValue(ParamType::TGLbooleanPointer, params, &paramsParam.value);
    CaptureGetBooleanvRobustANGLE_params(context, isCallValid, pname, bufSize, length, params,
                                         &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetBooleanvRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureGetBufferParameterivRobustANGLE(const Context *context,
                                                   bool isCallValid,
                                                   BufferBinding targetPacked,
                                                   GLenum pname,
                                                   GLsizei bufSize,
                                                   GLsizei *length,
                                                   GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetBufferParameterivRobustANGLE_length(context, isCallValid, targetPacked, pname,
                                                  bufSize, length, params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetBufferParameterivRobustANGLE_params(context, isCallValid, targetPacked, pname,
                                                  bufSize, length, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetBufferParameterivRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureGetFloatvRobustANGLE(const Context *context,
                                        bool isCallValid,
                                        GLenum pname,
                                        GLsizei bufSize,
                                        GLsizei *length,
                                        GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetFloatvRobustANGLE_length(context, isCallValid, pname, bufSize, length, params,
                                       &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
    InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
    CaptureGetFloatvRobustANGLE_params(context, isCallValid, pname, bufSize, length, params,
                                       &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetFloatvRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureGetFramebufferAttachmentParameterivRobustANGLE(const Context *context,
                                                                  bool isCallValid,
                                                                  GLenum target,
                                                                  GLenum attachment,
                                                                  GLenum pname,
                                                                  GLsizei bufSize,
                                                                  GLsizei *length,
                                                                  GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("target", ParamType::TGLenum, target);
    paramBuffer.addValueParam("attachment", ParamType::TGLenum, attachment);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetFramebufferAttachmentParameterivRobustANGLE_length(
        context, isCallValid, target, attachment, pname, bufSize, length, params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetFramebufferAttachmentParameterivRobustANGLE_params(
        context, isCallValid, target, attachment, pname, bufSize, length, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetFramebufferAttachmentParameterivRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureGetIntegervRobustANGLE(const Context *context,
                                          bool isCallValid,
                                          GLenum pname,
                                          GLsizei bufSize,
                                          GLsizei *length,
                                          GLint *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetIntegervRobustANGLE_length(context, isCallValid, pname, bufSize, length, data,
                                         &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture dataParam("data", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, data, &dataParam.value);
    CaptureGetIntegervRobustANGLE_data(context, isCallValid, pname, bufSize, length, data,
                                       &dataParam);
    paramBuffer.addParam(std::move(dataParam));

    return CallCapture("glGetIntegervRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureGetProgramivRobustANGLE(const Context *context,
                                           bool isCallValid,
                                           GLuint program,
                                           GLenum pname,
                                           GLsizei bufSize,
                                           GLsizei *length,
                                           GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::TGLuint, program);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetProgramivRobustANGLE_length(context, isCallValid, program, pname, bufSize, length,
                                          params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetProgramivRobustANGLE_params(context, isCallValid, program, pname, bufSize, length,
                                          params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetProgramivRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureGetRenderbufferParameterivRobustANGLE(const Context *context,
                                                         bool isCallValid,
                                                         GLenum target,
                                                         GLenum pname,
                                                         GLsizei bufSize,
                                                         GLsizei *length,
                                                         GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("target", ParamType::TGLenum, target);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetRenderbufferParameterivRobustANGLE_length(context, isCallValid, target, pname,
                                                        bufSize, length, params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetRenderbufferParameterivRobustANGLE_params(context, isCallValid, target, pname,
                                                        bufSize, length, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetRenderbufferParameterivRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureGetShaderivRobustANGLE(const Context *context,
                                          bool isCallValid,
                                          GLuint shader,
                                          GLenum pname,
                                          GLsizei bufSize,
                                          GLsizei *length,
                                          GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("shader", ParamType::TGLuint, shader);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetShaderivRobustANGLE_length(context, isCallValid, shader, pname, bufSize, length,
                                         params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetShaderivRobustANGLE_params(context, isCallValid, shader, pname, bufSize, length,
                                         params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetShaderivRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureGetTexParameterfvRobustANGLE(const Context *context,
                                                bool isCallValid,
                                                TextureType targetPacked,
                                                GLenum pname,
                                                GLsizei bufSize,
                                                GLsizei *length,
                                                GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetTexParameterfvRobustANGLE_length(context, isCallValid, targetPacked, pname, bufSize,
                                               length, params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
    InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
    CaptureGetTexParameterfvRobustANGLE_params(context, isCallValid, targetPacked, pname, bufSize,
                                               length, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetTexParameterfvRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureGetTexParameterivRobustANGLE(const Context *context,
                                                bool isCallValid,
                                                TextureType targetPacked,
                                                GLenum pname,
                                                GLsizei bufSize,
                                                GLsizei *length,
                                                GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetTexParameterivRobustANGLE_length(context, isCallValid, targetPacked, pname, bufSize,
                                               length, params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetTexParameterivRobustANGLE_params(context, isCallValid, targetPacked, pname, bufSize,
                                               length, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetTexParameterivRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureGetUniformfvRobustANGLE(const Context *context,
                                           bool isCallValid,
                                           GLuint program,
                                           GLint location,
                                           GLsizei bufSize,
                                           GLsizei *length,
                                           GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::TGLuint, program);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetUniformfvRobustANGLE_length(context, isCallValid, program, location, bufSize, length,
                                          params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
    InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
    CaptureGetUniformfvRobustANGLE_params(context, isCallValid, program, location, bufSize, length,
                                          params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetUniformfvRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureGetUniformivRobustANGLE(const Context *context,
                                           bool isCallValid,
                                           GLuint program,
                                           GLint location,
                                           GLsizei bufSize,
                                           GLsizei *length,
                                           GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::TGLuint, program);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetUniformivRobustANGLE_length(context, isCallValid, program, location, bufSize, length,
                                          params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetUniformivRobustANGLE_params(context, isCallValid, program, location, bufSize, length,
                                          params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetUniformivRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureGetVertexAttribfvRobustANGLE(const Context *context,
                                                bool isCallValid,
                                                GLuint index,
                                                GLenum pname,
                                                GLsizei bufSize,
                                                GLsizei *length,
                                                GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetVertexAttribfvRobustANGLE_length(context, isCallValid, index, pname, bufSize, length,
                                               params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
    InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
    CaptureGetVertexAttribfvRobustANGLE_params(context, isCallValid, index, pname, bufSize, length,
                                               params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetVertexAttribfvRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureGetVertexAttribivRobustANGLE(const Context *context,
                                                bool isCallValid,
                                                GLuint index,
                                                GLenum pname,
                                                GLsizei bufSize,
                                                GLsizei *length,
                                                GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetVertexAttribivRobustANGLE_length(context, isCallValid, index, pname, bufSize, length,
                                               params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetVertexAttribivRobustANGLE_params(context, isCallValid, index, pname, bufSize, length,
                                               params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetVertexAttribivRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureGetVertexAttribPointervRobustANGLE(const Context *context,
                                                      bool isCallValid,
                                                      GLuint index,
                                                      GLenum pname,
                                                      GLsizei bufSize,
                                                      GLsizei *length,
                                                      void **pointer)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetVertexAttribPointervRobustANGLE_length(context, isCallValid, index, pname, bufSize,
                                                     length, pointer, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture pointerParam("pointer", ParamType::TvoidPointerPointer);
    InitParamValue(ParamType::TvoidPointerPointer, pointer, &pointerParam.value);
    CaptureGetVertexAttribPointervRobustANGLE_pointer(context, isCallValid, index, pname, bufSize,
                                                      length, pointer, &pointerParam);
    paramBuffer.addParam(std::move(pointerParam));

    return CallCapture("glGetVertexAttribPointervRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureReadPixelsRobustANGLE(const Context *context,
                                         bool isCallValid,
                                         GLint x,
                                         GLint y,
                                         GLsizei width,
                                         GLsizei height,
                                         GLenum format,
                                         GLenum type,
                                         GLsizei bufSize,
                                         GLsizei *length,
                                         GLsizei *columns,
                                         GLsizei *rows,
                                         void *pixels)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("format", ParamType::TGLenum, format);
    paramBuffer.addValueParam("type", ParamType::TGLenum, type);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureReadPixelsRobustANGLE_length(context, isCallValid, x, y, width, height, format, type,
                                        bufSize, length, columns, rows, pixels, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture columnsParam("columns", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, columns, &columnsParam.value);
    CaptureReadPixelsRobustANGLE_columns(context, isCallValid, x, y, width, height, format, type,
                                         bufSize, length, columns, rows, pixels, &columnsParam);
    paramBuffer.addParam(std::move(columnsParam));

    ParamCapture rowsParam("rows", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, rows, &rowsParam.value);
    CaptureReadPixelsRobustANGLE_rows(context, isCallValid, x, y, width, height, format, type,
                                      bufSize, length, columns, rows, pixels, &rowsParam);
    paramBuffer.addParam(std::move(rowsParam));

    ParamCapture pixelsParam("pixels", ParamType::TvoidPointer);
    InitParamValue(ParamType::TvoidPointer, pixels, &pixelsParam.value);
    CaptureReadPixelsRobustANGLE_pixels(context, isCallValid, x, y, width, height, format, type,
                                        bufSize, length, columns, rows, pixels, &pixelsParam);
    paramBuffer.addParam(std::move(pixelsParam));

    return CallCapture("glReadPixelsRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureTexImage2DRobustANGLE(const Context *context,
                                         bool isCallValid,
                                         TextureTarget targetPacked,
                                         GLint level,
                                         GLint internalformat,
                                         GLsizei width,
                                         GLsizei height,
                                         GLint border,
                                         GLenum format,
                                         GLenum type,
                                         GLsizei bufSize,
                                         const void *pixels)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("internalformat", ParamType::TGLint, internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("border", ParamType::TGLint, border);
    paramBuffer.addValueParam("format", ParamType::TGLenum, format);
    paramBuffer.addValueParam("type", ParamType::TGLenum, type);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture pixelsParam("pixels", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, pixels, &pixelsParam.value);
    CaptureTexImage2DRobustANGLE_pixels(context, isCallValid, targetPacked, level, internalformat,
                                        width, height, border, format, type, bufSize, pixels,
                                        &pixelsParam);
    paramBuffer.addParam(std::move(pixelsParam));

    return CallCapture("glTexImage2DRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureTexParameterfvRobustANGLE(const Context *context,
                                             bool isCallValid,
                                             TextureType targetPacked,
                                             GLenum pname,
                                             GLsizei bufSize,
                                             const GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture paramsParam("params", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, params, &paramsParam.value);
    CaptureTexParameterfvRobustANGLE_params(context, isCallValid, targetPacked, pname, bufSize,
                                            params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glTexParameterfvRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureTexParameterivRobustANGLE(const Context *context,
                                             bool isCallValid,
                                             TextureType targetPacked,
                                             GLenum pname,
                                             GLsizei bufSize,
                                             const GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture paramsParam("params", ParamType::TGLintConstPointer);
    InitParamValue(ParamType::TGLintConstPointer, params, &paramsParam.value);
    CaptureTexParameterivRobustANGLE_params(context, isCallValid, targetPacked, pname, bufSize,
                                            params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glTexParameterivRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureTexSubImage2DRobustANGLE(const Context *context,
                                            bool isCallValid,
                                            TextureTarget targetPacked,
                                            GLint level,
                                            GLint xoffset,
                                            GLint yoffset,
                                            GLsizei width,
                                            GLsizei height,
                                            GLenum format,
                                            GLenum type,
                                            GLsizei bufSize,
                                            const void *pixels)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLint, yoffset);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("format", ParamType::TGLenum, format);
    paramBuffer.addValueParam("type", ParamType::TGLenum, type);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture pixelsParam("pixels", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, pixels, &pixelsParam.value);
    CaptureTexSubImage2DRobustANGLE_pixels(context, isCallValid, targetPacked, level, xoffset,
                                           yoffset, width, height, format, type, bufSize, pixels,
                                           &pixelsParam);
    paramBuffer.addParam(std::move(pixelsParam));

    return CallCapture("glTexSubImage2DRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureTexImage3DRobustANGLE(const Context *context,
                                         bool isCallValid,
                                         TextureTarget targetPacked,
                                         GLint level,
                                         GLint internalformat,
                                         GLsizei width,
                                         GLsizei height,
                                         GLsizei depth,
                                         GLint border,
                                         GLenum format,
                                         GLenum type,
                                         GLsizei bufSize,
                                         const void *pixels)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("internalformat", ParamType::TGLint, internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addValueParam("border", ParamType::TGLint, border);
    paramBuffer.addValueParam("format", ParamType::TGLenum, format);
    paramBuffer.addValueParam("type", ParamType::TGLenum, type);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture pixelsParam("pixels", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, pixels, &pixelsParam.value);
    CaptureTexImage3DRobustANGLE_pixels(context, isCallValid, targetPacked, level, internalformat,
                                        width, height, depth, border, format, type, bufSize, pixels,
                                        &pixelsParam);
    paramBuffer.addParam(std::move(pixelsParam));

    return CallCapture("glTexImage3DRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureTexSubImage3DRobustANGLE(const Context *context,
                                            bool isCallValid,
                                            TextureTarget targetPacked,
                                            GLint level,
                                            GLint xoffset,
                                            GLint yoffset,
                                            GLint zoffset,
                                            GLsizei width,
                                            GLsizei height,
                                            GLsizei depth,
                                            GLenum format,
                                            GLenum type,
                                            GLsizei bufSize,
                                            const void *pixels)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLint, yoffset);
    paramBuffer.addValueParam("zoffset", ParamType::TGLint, zoffset);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addValueParam("format", ParamType::TGLenum, format);
    paramBuffer.addValueParam("type", ParamType::TGLenum, type);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture pixelsParam("pixels", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, pixels, &pixelsParam.value);
    CaptureTexSubImage3DRobustANGLE_pixels(context, isCallValid, targetPacked, level, xoffset,
                                           yoffset, zoffset, width, height, depth, format, type,
                                           bufSize, pixels, &pixelsParam);
    paramBuffer.addParam(std::move(pixelsParam));

    return CallCapture("glTexSubImage3DRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureCompressedTexImage2DRobustANGLE(const Context *context,
                                                   bool isCallValid,
                                                   TextureTarget targetPacked,
                                                   GLint level,
                                                   GLenum internalformat,
                                                   GLsizei width,
                                                   GLsizei height,
                                                   GLint border,
                                                   GLsizei imageSize,
                                                   GLsizei dataSize,
                                                   const GLvoid *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("internalformat", ParamType::TGLenum, internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("border", ParamType::TGLint, border);
    paramBuffer.addValueParam("imageSize", ParamType::TGLsizei, imageSize);
    paramBuffer.addValueParam("dataSize", ParamType::TGLsizei, dataSize);

    ParamCapture dataParam("data", ParamType::TGLvoidConstPointer);
    InitParamValue(ParamType::TGLvoidConstPointer, data, &dataParam.value);
    CaptureCompressedTexImage2DRobustANGLE_data(context, isCallValid, targetPacked, level,
                                                internalformat, width, height, border, imageSize,
                                                dataSize, data, &dataParam);
    paramBuffer.addParam(std::move(dataParam));

    return CallCapture("glCompressedTexImage2DRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureCompressedTexSubImage2DRobustANGLE(const Context *context,
                                                      bool isCallValid,
                                                      TextureTarget targetPacked,
                                                      GLint level,
                                                      GLsizei xoffset,
                                                      GLsizei yoffset,
                                                      GLsizei width,
                                                      GLsizei height,
                                                      GLenum format,
                                                      GLsizei imageSize,
                                                      GLsizei dataSize,
                                                      const GLvoid *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("xoffset", ParamType::TGLsizei, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLsizei, yoffset);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("format", ParamType::TGLenum, format);
    paramBuffer.addValueParam("imageSize", ParamType::TGLsizei, imageSize);
    paramBuffer.addValueParam("dataSize", ParamType::TGLsizei, dataSize);

    ParamCapture dataParam("data", ParamType::TGLvoidConstPointer);
    InitParamValue(ParamType::TGLvoidConstPointer, data, &dataParam.value);
    CaptureCompressedTexSubImage2DRobustANGLE_data(context, isCallValid, targetPacked, level,
                                                   xoffset, yoffset, width, height, format,
                                                   imageSize, dataSize, data, &dataParam);
    paramBuffer.addParam(std::move(dataParam));

    return CallCapture("glCompressedTexSubImage2DRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureCompressedTexImage3DRobustANGLE(const Context *context,
                                                   bool isCallValid,
                                                   TextureTarget targetPacked,
                                                   GLint level,
                                                   GLenum internalformat,
                                                   GLsizei width,
                                                   GLsizei height,
                                                   GLsizei depth,
                                                   GLint border,
                                                   GLsizei imageSize,
                                                   GLsizei dataSize,
                                                   const GLvoid *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("internalformat", ParamType::TGLenum, internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addValueParam("border", ParamType::TGLint, border);
    paramBuffer.addValueParam("imageSize", ParamType::TGLsizei, imageSize);
    paramBuffer.addValueParam("dataSize", ParamType::TGLsizei, dataSize);

    ParamCapture dataParam("data", ParamType::TGLvoidConstPointer);
    InitParamValue(ParamType::TGLvoidConstPointer, data, &dataParam.value);
    CaptureCompressedTexImage3DRobustANGLE_data(context, isCallValid, targetPacked, level,
                                                internalformat, width, height, depth, border,
                                                imageSize, dataSize, data, &dataParam);
    paramBuffer.addParam(std::move(dataParam));

    return CallCapture("glCompressedTexImage3DRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureCompressedTexSubImage3DRobustANGLE(const Context *context,
                                                      bool isCallValid,
                                                      TextureTarget targetPacked,
                                                      GLint level,
                                                      GLint xoffset,
                                                      GLint yoffset,
                                                      GLint zoffset,
                                                      GLsizei width,
                                                      GLsizei height,
                                                      GLsizei depth,
                                                      GLenum format,
                                                      GLsizei imageSize,
                                                      GLsizei dataSize,
                                                      const GLvoid *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLint, yoffset);
    paramBuffer.addValueParam("zoffset", ParamType::TGLint, zoffset);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addValueParam("format", ParamType::TGLenum, format);
    paramBuffer.addValueParam("imageSize", ParamType::TGLsizei, imageSize);
    paramBuffer.addValueParam("dataSize", ParamType::TGLsizei, dataSize);

    ParamCapture dataParam("data", ParamType::TGLvoidConstPointer);
    InitParamValue(ParamType::TGLvoidConstPointer, data, &dataParam.value);
    CaptureCompressedTexSubImage3DRobustANGLE_data(context, isCallValid, targetPacked, level,
                                                   xoffset, yoffset, zoffset, width, height, depth,
                                                   format, imageSize, dataSize, data, &dataParam);
    paramBuffer.addParam(std::move(dataParam));

    return CallCapture("glCompressedTexSubImage3DRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureGetQueryivRobustANGLE(const Context *context,
                                         bool isCallValid,
                                         QueryType targetPacked,
                                         GLenum pname,
                                         GLsizei bufSize,
                                         GLsizei *length,
                                         GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TQueryType, targetPacked);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetQueryivRobustANGLE_length(context, isCallValid, targetPacked, pname, bufSize, length,
                                        params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetQueryivRobustANGLE_params(context, isCallValid, targetPacked, pname, bufSize, length,
                                        params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetQueryivRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureGetQueryObjectuivRobustANGLE(const Context *context,
                                                bool isCallValid,
                                                GLuint id,
                                                GLenum pname,
                                                GLsizei bufSize,
                                                GLsizei *length,
                                                GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("id", ParamType::TGLuint, id);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetQueryObjectuivRobustANGLE_length(context, isCallValid, id, pname, bufSize, length,
                                               params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLuintPointer);
    InitParamValue(ParamType::TGLuintPointer, params, &paramsParam.value);
    CaptureGetQueryObjectuivRobustANGLE_params(context, isCallValid, id, pname, bufSize, length,
                                               params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetQueryObjectuivRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureGetBufferPointervRobustANGLE(const Context *context,
                                                bool isCallValid,
                                                BufferBinding targetPacked,
                                                GLenum pname,
                                                GLsizei bufSize,
                                                GLsizei *length,
                                                void **params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetBufferPointervRobustANGLE_length(context, isCallValid, targetPacked, pname, bufSize,
                                               length, params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TvoidPointerPointer);
    InitParamValue(ParamType::TvoidPointerPointer, params, &paramsParam.value);
    CaptureGetBufferPointervRobustANGLE_params(context, isCallValid, targetPacked, pname, bufSize,
                                               length, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetBufferPointervRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureGetIntegeri_vRobustANGLE(const Context *context,
                                            bool isCallValid,
                                            GLenum target,
                                            GLuint index,
                                            GLsizei bufSize,
                                            GLsizei *length,
                                            GLint *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("target", ParamType::TGLenum, target);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetIntegeri_vRobustANGLE_length(context, isCallValid, target, index, bufSize, length,
                                           data, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture dataParam("data", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, data, &dataParam.value);
    CaptureGetIntegeri_vRobustANGLE_data(context, isCallValid, target, index, bufSize, length, data,
                                         &dataParam);
    paramBuffer.addParam(std::move(dataParam));

    return CallCapture("glGetIntegeri_vRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureGetInternalformativRobustANGLE(const Context *context,
                                                  bool isCallValid,
                                                  GLenum target,
                                                  GLenum internalformat,
                                                  GLenum pname,
                                                  GLsizei bufSize,
                                                  GLsizei *length,
                                                  GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("target", ParamType::TGLenum, target);
    paramBuffer.addValueParam("internalformat", ParamType::TGLenum, internalformat);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetInternalformativRobustANGLE_length(context, isCallValid, target, internalformat,
                                                 pname, bufSize, length, params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetInternalformativRobustANGLE_params(context, isCallValid, target, internalformat,
                                                 pname, bufSize, length, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetInternalformativRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureGetVertexAttribIivRobustANGLE(const Context *context,
                                                 bool isCallValid,
                                                 GLuint index,
                                                 GLenum pname,
                                                 GLsizei bufSize,
                                                 GLsizei *length,
                                                 GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetVertexAttribIivRobustANGLE_length(context, isCallValid, index, pname, bufSize, length,
                                                params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetVertexAttribIivRobustANGLE_params(context, isCallValid, index, pname, bufSize, length,
                                                params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetVertexAttribIivRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureGetVertexAttribIuivRobustANGLE(const Context *context,
                                                  bool isCallValid,
                                                  GLuint index,
                                                  GLenum pname,
                                                  GLsizei bufSize,
                                                  GLsizei *length,
                                                  GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetVertexAttribIuivRobustANGLE_length(context, isCallValid, index, pname, bufSize,
                                                 length, params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLuintPointer);
    InitParamValue(ParamType::TGLuintPointer, params, &paramsParam.value);
    CaptureGetVertexAttribIuivRobustANGLE_params(context, isCallValid, index, pname, bufSize,
                                                 length, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetVertexAttribIuivRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureGetUniformuivRobustANGLE(const Context *context,
                                            bool isCallValid,
                                            GLuint program,
                                            GLint location,
                                            GLsizei bufSize,
                                            GLsizei *length,
                                            GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::TGLuint, program);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetUniformuivRobustANGLE_length(context, isCallValid, program, location, bufSize, length,
                                           params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLuintPointer);
    InitParamValue(ParamType::TGLuintPointer, params, &paramsParam.value);
    CaptureGetUniformuivRobustANGLE_params(context, isCallValid, program, location, bufSize, length,
                                           params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetUniformuivRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureGetActiveUniformBlockivRobustANGLE(const Context *context,
                                                      bool isCallValid,
                                                      GLuint program,
                                                      GLuint uniformBlockIndex,
                                                      GLenum pname,
                                                      GLsizei bufSize,
                                                      GLsizei *length,
                                                      GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::TGLuint, program);
    paramBuffer.addValueParam("uniformBlockIndex", ParamType::TGLuint, uniformBlockIndex);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetActiveUniformBlockivRobustANGLE_length(context, isCallValid, program,
                                                     uniformBlockIndex, pname, bufSize, length,
                                                     params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetActiveUniformBlockivRobustANGLE_params(context, isCallValid, program,
                                                     uniformBlockIndex, pname, bufSize, length,
                                                     params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetActiveUniformBlockivRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureGetInteger64vRobustANGLE(const Context *context,
                                            bool isCallValid,
                                            GLenum pname,
                                            GLsizei bufSize,
                                            GLsizei *length,
                                            GLint64 *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetInteger64vRobustANGLE_length(context, isCallValid, pname, bufSize, length, data,
                                           &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture dataParam("data", ParamType::TGLint64Pointer);
    InitParamValue(ParamType::TGLint64Pointer, data, &dataParam.value);
    CaptureGetInteger64vRobustANGLE_data(context, isCallValid, pname, bufSize, length, data,
                                         &dataParam);
    paramBuffer.addParam(std::move(dataParam));

    return CallCapture("glGetInteger64vRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureGetInteger64i_vRobustANGLE(const Context *context,
                                              bool isCallValid,
                                              GLenum target,
                                              GLuint index,
                                              GLsizei bufSize,
                                              GLsizei *length,
                                              GLint64 *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("target", ParamType::TGLenum, target);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetInteger64i_vRobustANGLE_length(context, isCallValid, target, index, bufSize, length,
                                             data, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture dataParam("data", ParamType::TGLint64Pointer);
    InitParamValue(ParamType::TGLint64Pointer, data, &dataParam.value);
    CaptureGetInteger64i_vRobustANGLE_data(context, isCallValid, target, index, bufSize, length,
                                           data, &dataParam);
    paramBuffer.addParam(std::move(dataParam));

    return CallCapture("glGetInteger64i_vRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureGetBufferParameteri64vRobustANGLE(const Context *context,
                                                     bool isCallValid,
                                                     BufferBinding targetPacked,
                                                     GLenum pname,
                                                     GLsizei bufSize,
                                                     GLsizei *length,
                                                     GLint64 *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetBufferParameteri64vRobustANGLE_length(context, isCallValid, targetPacked, pname,
                                                    bufSize, length, params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLint64Pointer);
    InitParamValue(ParamType::TGLint64Pointer, params, &paramsParam.value);
    CaptureGetBufferParameteri64vRobustANGLE_params(context, isCallValid, targetPacked, pname,
                                                    bufSize, length, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetBufferParameteri64vRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureSamplerParameterivRobustANGLE(const Context *context,
                                                 bool isCallValid,
                                                 GLuint sampler,
                                                 GLuint pname,
                                                 GLsizei bufSize,
                                                 const GLint *param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("sampler", ParamType::TGLuint, sampler);
    paramBuffer.addValueParam("pname", ParamType::TGLuint, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture paramParam("param", ParamType::TGLintConstPointer);
    InitParamValue(ParamType::TGLintConstPointer, param, &paramParam.value);
    CaptureSamplerParameterivRobustANGLE_param(context, isCallValid, sampler, pname, bufSize, param,
                                               &paramParam);
    paramBuffer.addParam(std::move(paramParam));

    return CallCapture("glSamplerParameterivRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureSamplerParameterfvRobustANGLE(const Context *context,
                                                 bool isCallValid,
                                                 GLuint sampler,
                                                 GLenum pname,
                                                 GLsizei bufSize,
                                                 const GLfloat *param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("sampler", ParamType::TGLuint, sampler);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture paramParam("param", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, param, &paramParam.value);
    CaptureSamplerParameterfvRobustANGLE_param(context, isCallValid, sampler, pname, bufSize, param,
                                               &paramParam);
    paramBuffer.addParam(std::move(paramParam));

    return CallCapture("glSamplerParameterfvRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureGetSamplerParameterivRobustANGLE(const Context *context,
                                                    bool isCallValid,
                                                    GLuint sampler,
                                                    GLenum pname,
                                                    GLsizei bufSize,
                                                    GLsizei *length,
                                                    GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("sampler", ParamType::TGLuint, sampler);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetSamplerParameterivRobustANGLE_length(context, isCallValid, sampler, pname, bufSize,
                                                   length, params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetSamplerParameterivRobustANGLE_params(context, isCallValid, sampler, pname, bufSize,
                                                   length, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetSamplerParameterivRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureGetSamplerParameterfvRobustANGLE(const Context *context,
                                                    bool isCallValid,
                                                    GLuint sampler,
                                                    GLenum pname,
                                                    GLsizei bufSize,
                                                    GLsizei *length,
                                                    GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("sampler", ParamType::TGLuint, sampler);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetSamplerParameterfvRobustANGLE_length(context, isCallValid, sampler, pname, bufSize,
                                                   length, params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
    InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
    CaptureGetSamplerParameterfvRobustANGLE_params(context, isCallValid, sampler, pname, bufSize,
                                                   length, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetSamplerParameterfvRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureGetFramebufferParameterivRobustANGLE(const Context *context,
                                                        bool isCallValid,
                                                        GLuint sampler,
                                                        GLenum pname,
                                                        GLsizei bufSize,
                                                        GLsizei *length,
                                                        GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("sampler", ParamType::TGLuint, sampler);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetFramebufferParameterivRobustANGLE_length(context, isCallValid, sampler, pname,
                                                       bufSize, length, params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetFramebufferParameterivRobustANGLE_params(context, isCallValid, sampler, pname,
                                                       bufSize, length, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetFramebufferParameterivRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureGetProgramInterfaceivRobustANGLE(const Context *context,
                                                    bool isCallValid,
                                                    GLuint program,
                                                    GLenum programInterface,
                                                    GLenum pname,
                                                    GLsizei bufSize,
                                                    GLsizei *length,
                                                    GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::TGLuint, program);
    paramBuffer.addValueParam("programInterface", ParamType::TGLenum, programInterface);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetProgramInterfaceivRobustANGLE_length(context, isCallValid, program, programInterface,
                                                   pname, bufSize, length, params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetProgramInterfaceivRobustANGLE_params(context, isCallValid, program, programInterface,
                                                   pname, bufSize, length, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetProgramInterfaceivRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureGetBooleani_vRobustANGLE(const Context *context,
                                            bool isCallValid,
                                            GLenum target,
                                            GLuint index,
                                            GLsizei bufSize,
                                            GLsizei *length,
                                            GLboolean *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("target", ParamType::TGLenum, target);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetBooleani_vRobustANGLE_length(context, isCallValid, target, index, bufSize, length,
                                           data, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture dataParam("data", ParamType::TGLbooleanPointer);
    InitParamValue(ParamType::TGLbooleanPointer, data, &dataParam.value);
    CaptureGetBooleani_vRobustANGLE_data(context, isCallValid, target, index, bufSize, length, data,
                                         &dataParam);
    paramBuffer.addParam(std::move(dataParam));

    return CallCapture("glGetBooleani_vRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureGetMultisamplefvRobustANGLE(const Context *context,
                                               bool isCallValid,
                                               GLenum pname,
                                               GLuint index,
                                               GLsizei bufSize,
                                               GLsizei *length,
                                               GLfloat *val)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetMultisamplefvRobustANGLE_length(context, isCallValid, pname, index, bufSize, length,
                                              val, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture valParam("val", ParamType::TGLfloatPointer);
    InitParamValue(ParamType::TGLfloatPointer, val, &valParam.value);
    CaptureGetMultisamplefvRobustANGLE_val(context, isCallValid, pname, index, bufSize, length, val,
                                           &valParam);
    paramBuffer.addParam(std::move(valParam));

    return CallCapture("glGetMultisamplefvRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureGetTexLevelParameterivRobustANGLE(const Context *context,
                                                     bool isCallValid,
                                                     TextureTarget targetPacked,
                                                     GLint level,
                                                     GLenum pname,
                                                     GLsizei bufSize,
                                                     GLsizei *length,
                                                     GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetTexLevelParameterivRobustANGLE_length(context, isCallValid, targetPacked, level,
                                                    pname, bufSize, length, params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetTexLevelParameterivRobustANGLE_params(context, isCallValid, targetPacked, level,
                                                    pname, bufSize, length, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetTexLevelParameterivRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureGetTexLevelParameterfvRobustANGLE(const Context *context,
                                                     bool isCallValid,
                                                     TextureTarget targetPacked,
                                                     GLint level,
                                                     GLenum pname,
                                                     GLsizei bufSize,
                                                     GLsizei *length,
                                                     GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetTexLevelParameterfvRobustANGLE_length(context, isCallValid, targetPacked, level,
                                                    pname, bufSize, length, params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
    InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
    CaptureGetTexLevelParameterfvRobustANGLE_params(context, isCallValid, targetPacked, level,
                                                    pname, bufSize, length, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetTexLevelParameterfvRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureGetPointervRobustANGLERobustANGLE(const Context *context,
                                                     bool isCallValid,
                                                     GLenum pname,
                                                     GLsizei bufSize,
                                                     GLsizei *length,
                                                     void **params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetPointervRobustANGLERobustANGLE_length(context, isCallValid, pname, bufSize, length,
                                                    params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TvoidPointerPointer);
    InitParamValue(ParamType::TvoidPointerPointer, params, &paramsParam.value);
    CaptureGetPointervRobustANGLERobustANGLE_params(context, isCallValid, pname, bufSize, length,
                                                    params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetPointervRobustANGLERobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureReadnPixelsRobustANGLE(const Context *context,
                                          bool isCallValid,
                                          GLint x,
                                          GLint y,
                                          GLsizei width,
                                          GLsizei height,
                                          GLenum format,
                                          GLenum type,
                                          GLsizei bufSize,
                                          GLsizei *length,
                                          GLsizei *columns,
                                          GLsizei *rows,
                                          void *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("format", ParamType::TGLenum, format);
    paramBuffer.addValueParam("type", ParamType::TGLenum, type);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureReadnPixelsRobustANGLE_length(context, isCallValid, x, y, width, height, format, type,
                                         bufSize, length, columns, rows, data, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture columnsParam("columns", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, columns, &columnsParam.value);
    CaptureReadnPixelsRobustANGLE_columns(context, isCallValid, x, y, width, height, format, type,
                                          bufSize, length, columns, rows, data, &columnsParam);
    paramBuffer.addParam(std::move(columnsParam));

    ParamCapture rowsParam("rows", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, rows, &rowsParam.value);
    CaptureReadnPixelsRobustANGLE_rows(context, isCallValid, x, y, width, height, format, type,
                                       bufSize, length, columns, rows, data, &rowsParam);
    paramBuffer.addParam(std::move(rowsParam));

    ParamCapture dataParam("data", ParamType::TvoidPointer);
    InitParamValue(ParamType::TvoidPointer, data, &dataParam.value);
    CaptureReadnPixelsRobustANGLE_data(context, isCallValid, x, y, width, height, format, type,
                                       bufSize, length, columns, rows, data, &dataParam);
    paramBuffer.addParam(std::move(dataParam));

    return CallCapture("glReadnPixelsRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureGetnUniformfvRobustANGLE(const Context *context,
                                            bool isCallValid,
                                            GLuint program,
                                            GLint location,
                                            GLsizei bufSize,
                                            GLsizei *length,
                                            GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::TGLuint, program);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetnUniformfvRobustANGLE_length(context, isCallValid, program, location, bufSize, length,
                                           params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
    InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
    CaptureGetnUniformfvRobustANGLE_params(context, isCallValid, program, location, bufSize, length,
                                           params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetnUniformfvRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureGetnUniformivRobustANGLE(const Context *context,
                                            bool isCallValid,
                                            GLuint program,
                                            GLint location,
                                            GLsizei bufSize,
                                            GLsizei *length,
                                            GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::TGLuint, program);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetnUniformivRobustANGLE_length(context, isCallValid, program, location, bufSize, length,
                                           params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetnUniformivRobustANGLE_params(context, isCallValid, program, location, bufSize, length,
                                           params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetnUniformivRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureGetnUniformuivRobustANGLE(const Context *context,
                                             bool isCallValid,
                                             GLuint program,
                                             GLint location,
                                             GLsizei bufSize,
                                             GLsizei *length,
                                             GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::TGLuint, program);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetnUniformuivRobustANGLE_length(context, isCallValid, program, location, bufSize,
                                            length, params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLuintPointer);
    InitParamValue(ParamType::TGLuintPointer, params, &paramsParam.value);
    CaptureGetnUniformuivRobustANGLE_params(context, isCallValid, program, location, bufSize,
                                            length, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetnUniformuivRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureTexParameterIivRobustANGLE(const Context *context,
                                              bool isCallValid,
                                              TextureType targetPacked,
                                              GLenum pname,
                                              GLsizei bufSize,
                                              const GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture paramsParam("params", ParamType::TGLintConstPointer);
    InitParamValue(ParamType::TGLintConstPointer, params, &paramsParam.value);
    CaptureTexParameterIivRobustANGLE_params(context, isCallValid, targetPacked, pname, bufSize,
                                             params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glTexParameterIivRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureTexParameterIuivRobustANGLE(const Context *context,
                                               bool isCallValid,
                                               TextureType targetPacked,
                                               GLenum pname,
                                               GLsizei bufSize,
                                               const GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture paramsParam("params", ParamType::TGLuintConstPointer);
    InitParamValue(ParamType::TGLuintConstPointer, params, &paramsParam.value);
    CaptureTexParameterIuivRobustANGLE_params(context, isCallValid, targetPacked, pname, bufSize,
                                              params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glTexParameterIuivRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureGetTexParameterIivRobustANGLE(const Context *context,
                                                 bool isCallValid,
                                                 TextureType targetPacked,
                                                 GLenum pname,
                                                 GLsizei bufSize,
                                                 GLsizei *length,
                                                 GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetTexParameterIivRobustANGLE_length(context, isCallValid, targetPacked, pname, bufSize,
                                                length, params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetTexParameterIivRobustANGLE_params(context, isCallValid, targetPacked, pname, bufSize,
                                                length, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetTexParameterIivRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureGetTexParameterIuivRobustANGLE(const Context *context,
                                                  bool isCallValid,
                                                  TextureType targetPacked,
                                                  GLenum pname,
                                                  GLsizei bufSize,
                                                  GLsizei *length,
                                                  GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetTexParameterIuivRobustANGLE_length(context, isCallValid, targetPacked, pname, bufSize,
                                                 length, params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLuintPointer);
    InitParamValue(ParamType::TGLuintPointer, params, &paramsParam.value);
    CaptureGetTexParameterIuivRobustANGLE_params(context, isCallValid, targetPacked, pname, bufSize,
                                                 length, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetTexParameterIuivRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureSamplerParameterIivRobustANGLE(const Context *context,
                                                  bool isCallValid,
                                                  GLuint sampler,
                                                  GLenum pname,
                                                  GLsizei bufSize,
                                                  const GLint *param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("sampler", ParamType::TGLuint, sampler);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture paramParam("param", ParamType::TGLintConstPointer);
    InitParamValue(ParamType::TGLintConstPointer, param, &paramParam.value);
    CaptureSamplerParameterIivRobustANGLE_param(context, isCallValid, sampler, pname, bufSize,
                                                param, &paramParam);
    paramBuffer.addParam(std::move(paramParam));

    return CallCapture("glSamplerParameterIivRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureSamplerParameterIuivRobustANGLE(const Context *context,
                                                   bool isCallValid,
                                                   GLuint sampler,
                                                   GLenum pname,
                                                   GLsizei bufSize,
                                                   const GLuint *param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("sampler", ParamType::TGLuint, sampler);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture paramParam("param", ParamType::TGLuintConstPointer);
    InitParamValue(ParamType::TGLuintConstPointer, param, &paramParam.value);
    CaptureSamplerParameterIuivRobustANGLE_param(context, isCallValid, sampler, pname, bufSize,
                                                 param, &paramParam);
    paramBuffer.addParam(std::move(paramParam));

    return CallCapture("glSamplerParameterIuivRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureGetSamplerParameterIivRobustANGLE(const Context *context,
                                                     bool isCallValid,
                                                     GLuint sampler,
                                                     GLenum pname,
                                                     GLsizei bufSize,
                                                     GLsizei *length,
                                                     GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("sampler", ParamType::TGLuint, sampler);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetSamplerParameterIivRobustANGLE_length(context, isCallValid, sampler, pname, bufSize,
                                                    length, params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetSamplerParameterIivRobustANGLE_params(context, isCallValid, sampler, pname, bufSize,
                                                    length, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetSamplerParameterIivRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureGetSamplerParameterIuivRobustANGLE(const Context *context,
                                                      bool isCallValid,
                                                      GLuint sampler,
                                                      GLenum pname,
                                                      GLsizei bufSize,
                                                      GLsizei *length,
                                                      GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("sampler", ParamType::TGLuint, sampler);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetSamplerParameterIuivRobustANGLE_length(context, isCallValid, sampler, pname, bufSize,
                                                     length, params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLuintPointer);
    InitParamValue(ParamType::TGLuintPointer, params, &paramsParam.value);
    CaptureGetSamplerParameterIuivRobustANGLE_params(context, isCallValid, sampler, pname, bufSize,
                                                     length, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetSamplerParameterIuivRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureGetQueryObjectivRobustANGLE(const Context *context,
                                               bool isCallValid,
                                               GLuint id,
                                               GLenum pname,
                                               GLsizei bufSize,
                                               GLsizei *length,
                                               GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("id", ParamType::TGLuint, id);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetQueryObjectivRobustANGLE_length(context, isCallValid, id, pname, bufSize, length,
                                              params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetQueryObjectivRobustANGLE_params(context, isCallValid, id, pname, bufSize, length,
                                              params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetQueryObjectivRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureGetQueryObjecti64vRobustANGLE(const Context *context,
                                                 bool isCallValid,
                                                 GLuint id,
                                                 GLenum pname,
                                                 GLsizei bufSize,
                                                 GLsizei *length,
                                                 GLint64 *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("id", ParamType::TGLuint, id);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetQueryObjecti64vRobustANGLE_length(context, isCallValid, id, pname, bufSize, length,
                                                params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLint64Pointer);
    InitParamValue(ParamType::TGLint64Pointer, params, &paramsParam.value);
    CaptureGetQueryObjecti64vRobustANGLE_params(context, isCallValid, id, pname, bufSize, length,
                                                params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetQueryObjecti64vRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureGetQueryObjectui64vRobustANGLE(const Context *context,
                                                  bool isCallValid,
                                                  GLuint id,
                                                  GLenum pname,
                                                  GLsizei bufSize,
                                                  GLsizei *length,
                                                  GLuint64 *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("id", ParamType::TGLuint, id);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetQueryObjectui64vRobustANGLE_length(context, isCallValid, id, pname, bufSize, length,
                                                 params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLuint64Pointer);
    InitParamValue(ParamType::TGLuint64Pointer, params, &paramsParam.value);
    CaptureGetQueryObjectui64vRobustANGLE_params(context, isCallValid, id, pname, bufSize, length,
                                                 params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetQueryObjectui64vRobustANGLE", std::move(paramBuffer));
}

CallCapture CaptureTexImage2DExternalANGLE(const Context *context,
                                           bool isCallValid,
                                           TextureTarget targetPacked,
                                           GLint level,
                                           GLint internalformat,
                                           GLsizei width,
                                           GLsizei height,
                                           GLint border,
                                           GLenum format,
                                           GLenum type)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("internalformat", ParamType::TGLint, internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("border", ParamType::TGLint, border);
    paramBuffer.addValueParam("format", ParamType::TGLenum, format);
    paramBuffer.addValueParam("type", ParamType::TGLenum, type);

    return CallCapture("glTexImage2DExternalANGLE", std::move(paramBuffer));
}

CallCapture CaptureInvalidateTextureANGLE(const Context *context,
                                          bool isCallValid,
                                          TextureType targetPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);

    return CallCapture("glInvalidateTextureANGLE", std::move(paramBuffer));
}

CallCapture CaptureTexStorage2DMultisampleANGLE(const Context *context,
                                                bool isCallValid,
                                                TextureType targetPacked,
                                                GLsizei samples,
                                                GLenum internalformat,
                                                GLsizei width,
                                                GLsizei height,
                                                GLboolean fixedsamplelocations)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("samples", ParamType::TGLsizei, samples);
    paramBuffer.addValueParam("internalformat", ParamType::TGLenum, internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("fixedsamplelocations", ParamType::TGLboolean, fixedsamplelocations);

    return CallCapture("glTexStorage2DMultisampleANGLE", std::move(paramBuffer));
}

CallCapture CaptureGetTexLevelParameterivANGLE(const Context *context,
                                               bool isCallValid,
                                               TextureTarget targetPacked,
                                               GLint level,
                                               GLenum pname,
                                               GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetTexLevelParameterivANGLE_params(context, isCallValid, targetPacked, level, pname,
                                              params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetTexLevelParameterivANGLE", std::move(paramBuffer));
}

CallCapture CaptureGetTexLevelParameterfvANGLE(const Context *context,
                                               bool isCallValid,
                                               TextureTarget targetPacked,
                                               GLint level,
                                               GLenum pname,
                                               GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
    InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
    CaptureGetTexLevelParameterfvANGLE_params(context, isCallValid, targetPacked, level, pname,
                                              params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetTexLevelParameterfvANGLE", std::move(paramBuffer));
}

CallCapture CaptureGetMultisamplefvANGLE(const Context *context,
                                         bool isCallValid,
                                         GLenum pname,
                                         GLuint index,
                                         GLfloat *val)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    ParamCapture valParam("val", ParamType::TGLfloatPointer);
    InitParamValue(ParamType::TGLfloatPointer, val, &valParam.value);
    CaptureGetMultisamplefvANGLE_val(context, isCallValid, pname, index, val, &valParam);
    paramBuffer.addParam(std::move(valParam));

    return CallCapture("glGetMultisamplefvANGLE", std::move(paramBuffer));
}

CallCapture CaptureSampleMaskiANGLE(const Context *context,
                                    bool isCallValid,
                                    GLuint maskNumber,
                                    GLbitfield mask)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("maskNumber", ParamType::TGLuint, maskNumber);
    paramBuffer.addValueParam("mask", ParamType::TGLbitfield, mask);

    return CallCapture("glSampleMaskiANGLE", std::move(paramBuffer));
}

CallCapture CaptureGetTranslatedShaderSourceANGLE(const Context *context,
                                                  bool isCallValid,
                                                  GLuint shader,
                                                  GLsizei bufsize,
                                                  GLsizei *length,
                                                  GLchar *source)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("shader", ParamType::TGLuint, shader);
    paramBuffer.addValueParam("bufsize", ParamType::TGLsizei, bufsize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetTranslatedShaderSourceANGLE_length(context, isCallValid, shader, bufsize, length,
                                                 source, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture sourceParam("source", ParamType::TGLcharPointer);
    InitParamValue(ParamType::TGLcharPointer, source, &sourceParam.value);
    CaptureGetTranslatedShaderSourceANGLE_source(context, isCallValid, shader, bufsize, length,
                                                 source, &sourceParam);
    paramBuffer.addParam(std::move(sourceParam));

    return CallCapture("glGetTranslatedShaderSourceANGLE", std::move(paramBuffer));
}

CallCapture CaptureBindUniformLocationCHROMIUM(const Context *context,
                                               bool isCallValid,
                                               GLuint program,
                                               GLint location,
                                               const GLchar *name)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::TGLuint, program);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);

    ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
    InitParamValue(ParamType::TGLcharConstPointer, name, &nameParam.value);
    CaptureBindUniformLocationCHROMIUM_name(context, isCallValid, program, location, name,
                                            &nameParam);
    paramBuffer.addParam(std::move(nameParam));

    return CallCapture("glBindUniformLocationCHROMIUM", std::move(paramBuffer));
}

CallCapture CaptureCompressedCopyTextureCHROMIUM(const Context *context,
                                                 bool isCallValid,
                                                 GLuint sourceId,
                                                 GLuint destId)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("sourceId", ParamType::TGLuint, sourceId);
    paramBuffer.addValueParam("destId", ParamType::TGLuint, destId);

    return CallCapture("glCompressedCopyTextureCHROMIUM", std::move(paramBuffer));
}

CallCapture CaptureCopyTextureCHROMIUM(const Context *context,
                                       bool isCallValid,
                                       GLuint sourceId,
                                       GLint sourceLevel,
                                       TextureTarget destTargetPacked,
                                       GLuint destId,
                                       GLint destLevel,
                                       GLint internalFormat,
                                       GLenum destType,
                                       GLboolean unpackFlipY,
                                       GLboolean unpackPremultiplyAlpha,
                                       GLboolean unpackUnmultiplyAlpha)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("sourceId", ParamType::TGLuint, sourceId);
    paramBuffer.addValueParam("sourceLevel", ParamType::TGLint, sourceLevel);
    paramBuffer.addValueParam("destTargetPacked", ParamType::TTextureTarget, destTargetPacked);
    paramBuffer.addValueParam("destId", ParamType::TGLuint, destId);
    paramBuffer.addValueParam("destLevel", ParamType::TGLint, destLevel);
    paramBuffer.addValueParam("internalFormat", ParamType::TGLint, internalFormat);
    paramBuffer.addValueParam("destType", ParamType::TGLenum, destType);
    paramBuffer.addValueParam("unpackFlipY", ParamType::TGLboolean, unpackFlipY);
    paramBuffer.addValueParam("unpackPremultiplyAlpha", ParamType::TGLboolean,
                              unpackPremultiplyAlpha);
    paramBuffer.addValueParam("unpackUnmultiplyAlpha", ParamType::TGLboolean,
                              unpackUnmultiplyAlpha);

    return CallCapture("glCopyTextureCHROMIUM", std::move(paramBuffer));
}

CallCapture CaptureCopySubTextureCHROMIUM(const Context *context,
                                          bool isCallValid,
                                          GLuint sourceId,
                                          GLint sourceLevel,
                                          TextureTarget destTargetPacked,
                                          GLuint destId,
                                          GLint destLevel,
                                          GLint xoffset,
                                          GLint yoffset,
                                          GLint x,
                                          GLint y,
                                          GLint width,
                                          GLint height,
                                          GLboolean unpackFlipY,
                                          GLboolean unpackPremultiplyAlpha,
                                          GLboolean unpackUnmultiplyAlpha)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("sourceId", ParamType::TGLuint, sourceId);
    paramBuffer.addValueParam("sourceLevel", ParamType::TGLint, sourceLevel);
    paramBuffer.addValueParam("destTargetPacked", ParamType::TTextureTarget, destTargetPacked);
    paramBuffer.addValueParam("destId", ParamType::TGLuint, destId);
    paramBuffer.addValueParam("destLevel", ParamType::TGLint, destLevel);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLint, yoffset);
    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("width", ParamType::TGLint, width);
    paramBuffer.addValueParam("height", ParamType::TGLint, height);
    paramBuffer.addValueParam("unpackFlipY", ParamType::TGLboolean, unpackFlipY);
    paramBuffer.addValueParam("unpackPremultiplyAlpha", ParamType::TGLboolean,
                              unpackPremultiplyAlpha);
    paramBuffer.addValueParam("unpackUnmultiplyAlpha", ParamType::TGLboolean,
                              unpackUnmultiplyAlpha);

    return CallCapture("glCopySubTextureCHROMIUM", std::move(paramBuffer));
}

CallCapture CaptureCoverageModulationCHROMIUM(const Context *context,
                                              bool isCallValid,
                                              GLenum components)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("components", ParamType::TGLenum, components);

    return CallCapture("glCoverageModulationCHROMIUM", std::move(paramBuffer));
}

CallCapture CaptureMatrixLoadfCHROMIUM(const Context *context,
                                       bool isCallValid,
                                       GLenum matrixMode,
                                       const GLfloat *matrix)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("matrixMode", ParamType::TGLenum, matrixMode);

    ParamCapture matrixParam("matrix", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, matrix, &matrixParam.value);
    CaptureMatrixLoadfCHROMIUM_matrix(context, isCallValid, matrixMode, matrix, &matrixParam);
    paramBuffer.addParam(std::move(matrixParam));

    return CallCapture("glMatrixLoadfCHROMIUM", std::move(paramBuffer));
}

CallCapture CaptureMatrixLoadIdentityCHROMIUM(const Context *context,
                                              bool isCallValid,
                                              GLenum matrixMode)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("matrixMode", ParamType::TGLenum, matrixMode);

    return CallCapture("glMatrixLoadIdentityCHROMIUM", std::move(paramBuffer));
}

CallCapture CaptureLoseContextCHROMIUM(const Context *context,
                                       bool isCallValid,
                                       GraphicsResetStatus currentPacked,
                                       GraphicsResetStatus otherPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("currentPacked", ParamType::TGraphicsResetStatus, currentPacked);
    paramBuffer.addValueParam("otherPacked", ParamType::TGraphicsResetStatus, otherPacked);

    return CallCapture("glLoseContextCHROMIUM", std::move(paramBuffer));
}

CallCapture CaptureGenPathsCHROMIUM(const Context *context, bool isCallValid, GLsizei range)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("range", ParamType::TGLsizei, range);

    return CallCapture("glGenPathsCHROMIUM", std::move(paramBuffer));
}

CallCapture CaptureDeletePathsCHROMIUM(const Context *context,
                                       bool isCallValid,
                                       GLuint first,
                                       GLsizei range)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("first", ParamType::TGLuint, first);
    paramBuffer.addValueParam("range", ParamType::TGLsizei, range);

    return CallCapture("glDeletePathsCHROMIUM", std::move(paramBuffer));
}

CallCapture CaptureIsPathCHROMIUM(const Context *context, bool isCallValid, GLuint path)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("path", ParamType::TGLuint, path);

    return CallCapture("glIsPathCHROMIUM", std::move(paramBuffer));
}

CallCapture CapturePathCommandsCHROMIUM(const Context *context,
                                        bool isCallValid,
                                        GLuint path,
                                        GLsizei numCommands,
                                        const GLubyte *commands,
                                        GLsizei numCoords,
                                        GLenum coordType,
                                        const void *coords)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("path", ParamType::TGLuint, path);
    paramBuffer.addValueParam("numCommands", ParamType::TGLsizei, numCommands);

    ParamCapture commandsParam("commands", ParamType::TGLubyteConstPointer);
    InitParamValue(ParamType::TGLubyteConstPointer, commands, &commandsParam.value);
    CapturePathCommandsCHROMIUM_commands(context, isCallValid, path, numCommands, commands,
                                         numCoords, coordType, coords, &commandsParam);
    paramBuffer.addParam(std::move(commandsParam));

    paramBuffer.addValueParam("numCoords", ParamType::TGLsizei, numCoords);
    paramBuffer.addValueParam("coordType", ParamType::TGLenum, coordType);

    ParamCapture coordsParam("coords", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, coords, &coordsParam.value);
    CapturePathCommandsCHROMIUM_coords(context, isCallValid, path, numCommands, commands, numCoords,
                                       coordType, coords, &coordsParam);
    paramBuffer.addParam(std::move(coordsParam));

    return CallCapture("glPathCommandsCHROMIUM", std::move(paramBuffer));
}

CallCapture CapturePathParameterfCHROMIUM(const Context *context,
                                          bool isCallValid,
                                          GLuint path,
                                          GLenum pname,
                                          GLfloat value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("path", ParamType::TGLuint, path);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);
    paramBuffer.addValueParam("value", ParamType::TGLfloat, value);

    return CallCapture("glPathParameterfCHROMIUM", std::move(paramBuffer));
}

CallCapture CapturePathParameteriCHROMIUM(const Context *context,
                                          bool isCallValid,
                                          GLuint path,
                                          GLenum pname,
                                          GLint value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("path", ParamType::TGLuint, path);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);
    paramBuffer.addValueParam("value", ParamType::TGLint, value);

    return CallCapture("glPathParameteriCHROMIUM", std::move(paramBuffer));
}

CallCapture CaptureGetPathParameterfvCHROMIUM(const Context *context,
                                              bool isCallValid,
                                              GLuint path,
                                              GLenum pname,
                                              GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("path", ParamType::TGLuint, path);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);

    ParamCapture valueParam("value", ParamType::TGLfloatPointer);
    InitParamValue(ParamType::TGLfloatPointer, value, &valueParam.value);
    CaptureGetPathParameterfvCHROMIUM_value(context, isCallValid, path, pname, value, &valueParam);
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture("glGetPathParameterfvCHROMIUM", std::move(paramBuffer));
}

CallCapture CaptureGetPathParameterivCHROMIUM(const Context *context,
                                              bool isCallValid,
                                              GLuint path,
                                              GLenum pname,
                                              GLint *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("path", ParamType::TGLuint, path);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);

    ParamCapture valueParam("value", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, value, &valueParam.value);
    CaptureGetPathParameterivCHROMIUM_value(context, isCallValid, path, pname, value, &valueParam);
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture("glGetPathParameterivCHROMIUM", std::move(paramBuffer));
}

CallCapture CapturePathStencilFuncCHROMIUM(const Context *context,
                                           bool isCallValid,
                                           GLenum func,
                                           GLint ref,
                                           GLuint mask)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("func", ParamType::TGLenum, func);
    paramBuffer.addValueParam("ref", ParamType::TGLint, ref);
    paramBuffer.addValueParam("mask", ParamType::TGLuint, mask);

    return CallCapture("glPathStencilFuncCHROMIUM", std::move(paramBuffer));
}

CallCapture CaptureStencilFillPathCHROMIUM(const Context *context,
                                           bool isCallValid,
                                           GLuint path,
                                           GLenum fillMode,
                                           GLuint mask)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("path", ParamType::TGLuint, path);
    paramBuffer.addValueParam("fillMode", ParamType::TGLenum, fillMode);
    paramBuffer.addValueParam("mask", ParamType::TGLuint, mask);

    return CallCapture("glStencilFillPathCHROMIUM", std::move(paramBuffer));
}

CallCapture CaptureStencilStrokePathCHROMIUM(const Context *context,
                                             bool isCallValid,
                                             GLuint path,
                                             GLint reference,
                                             GLuint mask)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("path", ParamType::TGLuint, path);
    paramBuffer.addValueParam("reference", ParamType::TGLint, reference);
    paramBuffer.addValueParam("mask", ParamType::TGLuint, mask);

    return CallCapture("glStencilStrokePathCHROMIUM", std::move(paramBuffer));
}

CallCapture CaptureCoverFillPathCHROMIUM(const Context *context,
                                         bool isCallValid,
                                         GLuint path,
                                         GLenum coverMode)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("path", ParamType::TGLuint, path);
    paramBuffer.addValueParam("coverMode", ParamType::TGLenum, coverMode);

    return CallCapture("glCoverFillPathCHROMIUM", std::move(paramBuffer));
}

CallCapture CaptureCoverStrokePathCHROMIUM(const Context *context,
                                           bool isCallValid,
                                           GLuint path,
                                           GLenum coverMode)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("path", ParamType::TGLuint, path);
    paramBuffer.addValueParam("coverMode", ParamType::TGLenum, coverMode);

    return CallCapture("glCoverStrokePathCHROMIUM", std::move(paramBuffer));
}

CallCapture CaptureStencilThenCoverFillPathCHROMIUM(const Context *context,
                                                    bool isCallValid,
                                                    GLuint path,
                                                    GLenum fillMode,
                                                    GLuint mask,
                                                    GLenum coverMode)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("path", ParamType::TGLuint, path);
    paramBuffer.addValueParam("fillMode", ParamType::TGLenum, fillMode);
    paramBuffer.addValueParam("mask", ParamType::TGLuint, mask);
    paramBuffer.addValueParam("coverMode", ParamType::TGLenum, coverMode);

    return CallCapture("glStencilThenCoverFillPathCHROMIUM", std::move(paramBuffer));
}

CallCapture CaptureStencilThenCoverStrokePathCHROMIUM(const Context *context,
                                                      bool isCallValid,
                                                      GLuint path,
                                                      GLint reference,
                                                      GLuint mask,
                                                      GLenum coverMode)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("path", ParamType::TGLuint, path);
    paramBuffer.addValueParam("reference", ParamType::TGLint, reference);
    paramBuffer.addValueParam("mask", ParamType::TGLuint, mask);
    paramBuffer.addValueParam("coverMode", ParamType::TGLenum, coverMode);

    return CallCapture("glStencilThenCoverStrokePathCHROMIUM", std::move(paramBuffer));
}

CallCapture CaptureCoverFillPathInstancedCHROMIUM(const Context *context,
                                                  bool isCallValid,
                                                  GLsizei numPath,
                                                  GLenum pathNameType,
                                                  const void *paths,
                                                  GLuint pathBase,
                                                  GLenum coverMode,
                                                  GLenum transformType,
                                                  const GLfloat *transformValues)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("numPath", ParamType::TGLsizei, numPath);
    paramBuffer.addValueParam("pathNameType", ParamType::TGLenum, pathNameType);

    ParamCapture pathsParam("paths", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, paths, &pathsParam.value);
    CaptureCoverFillPathInstancedCHROMIUM_paths(context, isCallValid, numPath, pathNameType, paths,
                                                pathBase, coverMode, transformType, transformValues,
                                                &pathsParam);
    paramBuffer.addParam(std::move(pathsParam));

    paramBuffer.addValueParam("pathBase", ParamType::TGLuint, pathBase);
    paramBuffer.addValueParam("coverMode", ParamType::TGLenum, coverMode);
    paramBuffer.addValueParam("transformType", ParamType::TGLenum, transformType);

    ParamCapture transformValuesParam("transformValues", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, transformValues, &transformValuesParam.value);
    CaptureCoverFillPathInstancedCHROMIUM_transformValues(
        context, isCallValid, numPath, pathNameType, paths, pathBase, coverMode, transformType,
        transformValues, &transformValuesParam);
    paramBuffer.addParam(std::move(transformValuesParam));

    return CallCapture("glCoverFillPathInstancedCHROMIUM", std::move(paramBuffer));
}

CallCapture CaptureCoverStrokePathInstancedCHROMIUM(const Context *context,
                                                    bool isCallValid,
                                                    GLsizei numPath,
                                                    GLenum pathNameType,
                                                    const void *paths,
                                                    GLuint pathBase,
                                                    GLenum coverMode,
                                                    GLenum transformType,
                                                    const GLfloat *transformValues)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("numPath", ParamType::TGLsizei, numPath);
    paramBuffer.addValueParam("pathNameType", ParamType::TGLenum, pathNameType);

    ParamCapture pathsParam("paths", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, paths, &pathsParam.value);
    CaptureCoverStrokePathInstancedCHROMIUM_paths(context, isCallValid, numPath, pathNameType,
                                                  paths, pathBase, coverMode, transformType,
                                                  transformValues, &pathsParam);
    paramBuffer.addParam(std::move(pathsParam));

    paramBuffer.addValueParam("pathBase", ParamType::TGLuint, pathBase);
    paramBuffer.addValueParam("coverMode", ParamType::TGLenum, coverMode);
    paramBuffer.addValueParam("transformType", ParamType::TGLenum, transformType);

    ParamCapture transformValuesParam("transformValues", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, transformValues, &transformValuesParam.value);
    CaptureCoverStrokePathInstancedCHROMIUM_transformValues(
        context, isCallValid, numPath, pathNameType, paths, pathBase, coverMode, transformType,
        transformValues, &transformValuesParam);
    paramBuffer.addParam(std::move(transformValuesParam));

    return CallCapture("glCoverStrokePathInstancedCHROMIUM", std::move(paramBuffer));
}

CallCapture CaptureStencilStrokePathInstancedCHROMIUM(const Context *context,
                                                      bool isCallValid,
                                                      GLsizei numPath,
                                                      GLenum pathNameType,
                                                      const void *paths,
                                                      GLuint pathBase,
                                                      GLint reference,
                                                      GLuint mask,
                                                      GLenum transformType,
                                                      const GLfloat *transformValues)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("numPath", ParamType::TGLsizei, numPath);
    paramBuffer.addValueParam("pathNameType", ParamType::TGLenum, pathNameType);

    ParamCapture pathsParam("paths", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, paths, &pathsParam.value);
    CaptureStencilStrokePathInstancedCHROMIUM_paths(context, isCallValid, numPath, pathNameType,
                                                    paths, pathBase, reference, mask, transformType,
                                                    transformValues, &pathsParam);
    paramBuffer.addParam(std::move(pathsParam));

    paramBuffer.addValueParam("pathBase", ParamType::TGLuint, pathBase);
    paramBuffer.addValueParam("reference", ParamType::TGLint, reference);
    paramBuffer.addValueParam("mask", ParamType::TGLuint, mask);
    paramBuffer.addValueParam("transformType", ParamType::TGLenum, transformType);

    ParamCapture transformValuesParam("transformValues", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, transformValues, &transformValuesParam.value);
    CaptureStencilStrokePathInstancedCHROMIUM_transformValues(
        context, isCallValid, numPath, pathNameType, paths, pathBase, reference, mask,
        transformType, transformValues, &transformValuesParam);
    paramBuffer.addParam(std::move(transformValuesParam));

    return CallCapture("glStencilStrokePathInstancedCHROMIUM", std::move(paramBuffer));
}

CallCapture CaptureStencilFillPathInstancedCHROMIUM(const Context *context,
                                                    bool isCallValid,
                                                    GLsizei numPaths,
                                                    GLenum pathNameType,
                                                    const void *paths,
                                                    GLuint pathBase,
                                                    GLenum fillMode,
                                                    GLuint mask,
                                                    GLenum transformType,
                                                    const GLfloat *transformValues)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("numPaths", ParamType::TGLsizei, numPaths);
    paramBuffer.addValueParam("pathNameType", ParamType::TGLenum, pathNameType);

    ParamCapture pathsParam("paths", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, paths, &pathsParam.value);
    CaptureStencilFillPathInstancedCHROMIUM_paths(context, isCallValid, numPaths, pathNameType,
                                                  paths, pathBase, fillMode, mask, transformType,
                                                  transformValues, &pathsParam);
    paramBuffer.addParam(std::move(pathsParam));

    paramBuffer.addValueParam("pathBase", ParamType::TGLuint, pathBase);
    paramBuffer.addValueParam("fillMode", ParamType::TGLenum, fillMode);
    paramBuffer.addValueParam("mask", ParamType::TGLuint, mask);
    paramBuffer.addValueParam("transformType", ParamType::TGLenum, transformType);

    ParamCapture transformValuesParam("transformValues", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, transformValues, &transformValuesParam.value);
    CaptureStencilFillPathInstancedCHROMIUM_transformValues(
        context, isCallValid, numPaths, pathNameType, paths, pathBase, fillMode, mask,
        transformType, transformValues, &transformValuesParam);
    paramBuffer.addParam(std::move(transformValuesParam));

    return CallCapture("glStencilFillPathInstancedCHROMIUM", std::move(paramBuffer));
}

CallCapture CaptureStencilThenCoverFillPathInstancedCHROMIUM(const Context *context,
                                                             bool isCallValid,
                                                             GLsizei numPaths,
                                                             GLenum pathNameType,
                                                             const void *paths,
                                                             GLuint pathBase,
                                                             GLenum fillMode,
                                                             GLuint mask,
                                                             GLenum coverMode,
                                                             GLenum transformType,
                                                             const GLfloat *transformValues)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("numPaths", ParamType::TGLsizei, numPaths);
    paramBuffer.addValueParam("pathNameType", ParamType::TGLenum, pathNameType);

    ParamCapture pathsParam("paths", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, paths, &pathsParam.value);
    CaptureStencilThenCoverFillPathInstancedCHROMIUM_paths(
        context, isCallValid, numPaths, pathNameType, paths, pathBase, fillMode, mask, coverMode,
        transformType, transformValues, &pathsParam);
    paramBuffer.addParam(std::move(pathsParam));

    paramBuffer.addValueParam("pathBase", ParamType::TGLuint, pathBase);
    paramBuffer.addValueParam("fillMode", ParamType::TGLenum, fillMode);
    paramBuffer.addValueParam("mask", ParamType::TGLuint, mask);
    paramBuffer.addValueParam("coverMode", ParamType::TGLenum, coverMode);
    paramBuffer.addValueParam("transformType", ParamType::TGLenum, transformType);

    ParamCapture transformValuesParam("transformValues", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, transformValues, &transformValuesParam.value);
    CaptureStencilThenCoverFillPathInstancedCHROMIUM_transformValues(
        context, isCallValid, numPaths, pathNameType, paths, pathBase, fillMode, mask, coverMode,
        transformType, transformValues, &transformValuesParam);
    paramBuffer.addParam(std::move(transformValuesParam));

    return CallCapture("glStencilThenCoverFillPathInstancedCHROMIUM", std::move(paramBuffer));
}

CallCapture CaptureStencilThenCoverStrokePathInstancedCHROMIUM(const Context *context,
                                                               bool isCallValid,
                                                               GLsizei numPaths,
                                                               GLenum pathNameType,
                                                               const void *paths,
                                                               GLuint pathBase,
                                                               GLint reference,
                                                               GLuint mask,
                                                               GLenum coverMode,
                                                               GLenum transformType,
                                                               const GLfloat *transformValues)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("numPaths", ParamType::TGLsizei, numPaths);
    paramBuffer.addValueParam("pathNameType", ParamType::TGLenum, pathNameType);

    ParamCapture pathsParam("paths", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, paths, &pathsParam.value);
    CaptureStencilThenCoverStrokePathInstancedCHROMIUM_paths(
        context, isCallValid, numPaths, pathNameType, paths, pathBase, reference, mask, coverMode,
        transformType, transformValues, &pathsParam);
    paramBuffer.addParam(std::move(pathsParam));

    paramBuffer.addValueParam("pathBase", ParamType::TGLuint, pathBase);
    paramBuffer.addValueParam("reference", ParamType::TGLint, reference);
    paramBuffer.addValueParam("mask", ParamType::TGLuint, mask);
    paramBuffer.addValueParam("coverMode", ParamType::TGLenum, coverMode);
    paramBuffer.addValueParam("transformType", ParamType::TGLenum, transformType);

    ParamCapture transformValuesParam("transformValues", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, transformValues, &transformValuesParam.value);
    CaptureStencilThenCoverStrokePathInstancedCHROMIUM_transformValues(
        context, isCallValid, numPaths, pathNameType, paths, pathBase, reference, mask, coverMode,
        transformType, transformValues, &transformValuesParam);
    paramBuffer.addParam(std::move(transformValuesParam));

    return CallCapture("glStencilThenCoverStrokePathInstancedCHROMIUM", std::move(paramBuffer));
}

CallCapture CaptureBindFragmentInputLocationCHROMIUM(const Context *context,
                                                     bool isCallValid,
                                                     GLuint programs,
                                                     GLint location,
                                                     const GLchar *name)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programs", ParamType::TGLuint, programs);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);

    ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
    InitParamValue(ParamType::TGLcharConstPointer, name, &nameParam.value);
    CaptureBindFragmentInputLocationCHROMIUM_name(context, isCallValid, programs, location, name,
                                                  &nameParam);
    paramBuffer.addParam(std::move(nameParam));

    return CallCapture("glBindFragmentInputLocationCHROMIUM", std::move(paramBuffer));
}

CallCapture CaptureProgramPathFragmentInputGenCHROMIUM(const Context *context,
                                                       bool isCallValid,
                                                       GLuint program,
                                                       GLint location,
                                                       GLenum genMode,
                                                       GLint components,
                                                       const GLfloat *coeffs)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::TGLuint, program);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("genMode", ParamType::TGLenum, genMode);
    paramBuffer.addValueParam("components", ParamType::TGLint, components);

    ParamCapture coeffsParam("coeffs", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, coeffs, &coeffsParam.value);
    CaptureProgramPathFragmentInputGenCHROMIUM_coeffs(context, isCallValid, program, location,
                                                      genMode, components, coeffs, &coeffsParam);
    paramBuffer.addParam(std::move(coeffsParam));

    return CallCapture("glProgramPathFragmentInputGenCHROMIUM", std::move(paramBuffer));
}

CallCapture CaptureBindFragDataLocationEXT(const Context *context,
                                           bool isCallValid,
                                           GLuint program,
                                           GLuint color,
                                           const GLchar *name)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::TGLuint, program);
    paramBuffer.addValueParam("color", ParamType::TGLuint, color);

    ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
    InitParamValue(ParamType::TGLcharConstPointer, name, &nameParam.value);
    CaptureBindFragDataLocationEXT_name(context, isCallValid, program, color, name, &nameParam);
    paramBuffer.addParam(std::move(nameParam));

    return CallCapture("glBindFragDataLocationEXT", std::move(paramBuffer));
}

CallCapture CaptureBindFragDataLocationIndexedEXT(const Context *context,
                                                  bool isCallValid,
                                                  GLuint program,
                                                  GLuint colorNumber,
                                                  GLuint index,
                                                  const GLchar *name)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::TGLuint, program);
    paramBuffer.addValueParam("colorNumber", ParamType::TGLuint, colorNumber);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
    InitParamValue(ParamType::TGLcharConstPointer, name, &nameParam.value);
    CaptureBindFragDataLocationIndexedEXT_name(context, isCallValid, program, colorNumber, index,
                                               name, &nameParam);
    paramBuffer.addParam(std::move(nameParam));

    return CallCapture("glBindFragDataLocationIndexedEXT", std::move(paramBuffer));
}

CallCapture CaptureGetFragDataIndexEXT(const Context *context,
                                       bool isCallValid,
                                       GLuint program,
                                       const GLchar *name)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::TGLuint, program);

    ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
    InitParamValue(ParamType::TGLcharConstPointer, name, &nameParam.value);
    CaptureGetFragDataIndexEXT_name(context, isCallValid, program, name, &nameParam);
    paramBuffer.addParam(std::move(nameParam));

    return CallCapture("glGetFragDataIndexEXT", std::move(paramBuffer));
}

CallCapture CaptureGetProgramResourceLocationIndexEXT(const Context *context,
                                                      bool isCallValid,
                                                      GLuint program,
                                                      GLenum programInterface,
                                                      const GLchar *name)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::TGLuint, program);
    paramBuffer.addValueParam("programInterface", ParamType::TGLenum, programInterface);

    ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
    InitParamValue(ParamType::TGLcharConstPointer, name, &nameParam.value);
    CaptureGetProgramResourceLocationIndexEXT_name(context, isCallValid, program, programInterface,
                                                   name, &nameParam);
    paramBuffer.addParam(std::move(nameParam));

    return CallCapture("glGetProgramResourceLocationIndexEXT", std::move(paramBuffer));
}

CallCapture CaptureInsertEventMarkerEXT(const Context *context,
                                        bool isCallValid,
                                        GLsizei length,
                                        const GLchar *marker)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("length", ParamType::TGLsizei, length);

    ParamCapture markerParam("marker", ParamType::TGLcharConstPointer);
    InitParamValue(ParamType::TGLcharConstPointer, marker, &markerParam.value);
    CaptureInsertEventMarkerEXT_marker(context, isCallValid, length, marker, &markerParam);
    paramBuffer.addParam(std::move(markerParam));

    return CallCapture("glInsertEventMarkerEXT", std::move(paramBuffer));
}

CallCapture CapturePopGroupMarkerEXT(const Context *context, bool isCallValid)
{
    ParamBuffer paramBuffer;

    return CallCapture("glPopGroupMarkerEXT", std::move(paramBuffer));
}

CallCapture CapturePushGroupMarkerEXT(const Context *context,
                                      bool isCallValid,
                                      GLsizei length,
                                      const GLchar *marker)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("length", ParamType::TGLsizei, length);

    ParamCapture markerParam("marker", ParamType::TGLcharConstPointer);
    InitParamValue(ParamType::TGLcharConstPointer, marker, &markerParam.value);
    CapturePushGroupMarkerEXT_marker(context, isCallValid, length, marker, &markerParam);
    paramBuffer.addParam(std::move(markerParam));

    return CallCapture("glPushGroupMarkerEXT", std::move(paramBuffer));
}

CallCapture CaptureDiscardFramebufferEXT(const Context *context,
                                         bool isCallValid,
                                         GLenum target,
                                         GLsizei numAttachments,
                                         const GLenum *attachments)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("target", ParamType::TGLenum, target);
    paramBuffer.addValueParam("numAttachments", ParamType::TGLsizei, numAttachments);

    ParamCapture attachmentsParam("attachments", ParamType::TGLenumConstPointer);
    InitParamValue(ParamType::TGLenumConstPointer, attachments, &attachmentsParam.value);
    CaptureDiscardFramebufferEXT_attachments(context, isCallValid, target, numAttachments,
                                             attachments, &attachmentsParam);
    paramBuffer.addParam(std::move(attachmentsParam));

    return CallCapture("glDiscardFramebufferEXT", std::move(paramBuffer));
}

CallCapture CaptureBeginQueryEXT(const Context *context,
                                 bool isCallValid,
                                 QueryType targetPacked,
                                 GLuint id)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TQueryType, targetPacked);
    paramBuffer.addValueParam("id", ParamType::TGLuint, id);

    return CallCapture("glBeginQueryEXT", std::move(paramBuffer));
}

CallCapture CaptureDeleteQueriesEXT(const Context *context,
                                    bool isCallValid,
                                    GLsizei n,
                                    const GLuint *ids)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture idsParam("ids", ParamType::TGLuintConstPointer);
    InitParamValue(ParamType::TGLuintConstPointer, ids, &idsParam.value);
    CaptureDeleteQueriesEXT_ids(context, isCallValid, n, ids, &idsParam);
    paramBuffer.addParam(std::move(idsParam));

    return CallCapture("glDeleteQueriesEXT", std::move(paramBuffer));
}

CallCapture CaptureEndQueryEXT(const Context *context, bool isCallValid, QueryType targetPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TQueryType, targetPacked);

    return CallCapture("glEndQueryEXT", std::move(paramBuffer));
}

CallCapture CaptureGenQueriesEXT(const Context *context, bool isCallValid, GLsizei n, GLuint *ids)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture idsParam("ids", ParamType::TGLuintPointer);
    InitParamValue(ParamType::TGLuintPointer, ids, &idsParam.value);
    CaptureGenQueriesEXT_ids(context, isCallValid, n, ids, &idsParam);
    paramBuffer.addParam(std::move(idsParam));

    return CallCapture("glGenQueriesEXT", std::move(paramBuffer));
}

CallCapture CaptureGetQueryObjecti64vEXT(const Context *context,
                                         bool isCallValid,
                                         GLuint id,
                                         GLenum pname,
                                         GLint64 *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("id", ParamType::TGLuint, id);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLint64Pointer);
    InitParamValue(ParamType::TGLint64Pointer, params, &paramsParam.value);
    CaptureGetQueryObjecti64vEXT_params(context, isCallValid, id, pname, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetQueryObjecti64vEXT", std::move(paramBuffer));
}

CallCapture CaptureGetQueryObjectivEXT(const Context *context,
                                       bool isCallValid,
                                       GLuint id,
                                       GLenum pname,
                                       GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("id", ParamType::TGLuint, id);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetQueryObjectivEXT_params(context, isCallValid, id, pname, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetQueryObjectivEXT", std::move(paramBuffer));
}

CallCapture CaptureGetQueryObjectui64vEXT(const Context *context,
                                          bool isCallValid,
                                          GLuint id,
                                          GLenum pname,
                                          GLuint64 *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("id", ParamType::TGLuint, id);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLuint64Pointer);
    InitParamValue(ParamType::TGLuint64Pointer, params, &paramsParam.value);
    CaptureGetQueryObjectui64vEXT_params(context, isCallValid, id, pname, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetQueryObjectui64vEXT", std::move(paramBuffer));
}

CallCapture CaptureGetQueryObjectuivEXT(const Context *context,
                                        bool isCallValid,
                                        GLuint id,
                                        GLenum pname,
                                        GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("id", ParamType::TGLuint, id);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLuintPointer);
    InitParamValue(ParamType::TGLuintPointer, params, &paramsParam.value);
    CaptureGetQueryObjectuivEXT_params(context, isCallValid, id, pname, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetQueryObjectuivEXT", std::move(paramBuffer));
}

CallCapture CaptureGetQueryivEXT(const Context *context,
                                 bool isCallValid,
                                 QueryType targetPacked,
                                 GLenum pname,
                                 GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TQueryType, targetPacked);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetQueryivEXT_params(context, isCallValid, targetPacked, pname, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetQueryivEXT", std::move(paramBuffer));
}

CallCapture CaptureIsQueryEXT(const Context *context, bool isCallValid, GLuint id)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("id", ParamType::TGLuint, id);

    return CallCapture("glIsQueryEXT", std::move(paramBuffer));
}

CallCapture CaptureQueryCounterEXT(const Context *context,
                                   bool isCallValid,
                                   GLuint id,
                                   QueryType targetPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("id", ParamType::TGLuint, id);
    paramBuffer.addValueParam("targetPacked", ParamType::TQueryType, targetPacked);

    return CallCapture("glQueryCounterEXT", std::move(paramBuffer));
}

CallCapture CaptureDrawBuffersEXT(const Context *context,
                                  bool isCallValid,
                                  GLsizei n,
                                  const GLenum *bufs)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture bufsParam("bufs", ParamType::TGLenumConstPointer);
    InitParamValue(ParamType::TGLenumConstPointer, bufs, &bufsParam.value);
    CaptureDrawBuffersEXT_bufs(context, isCallValid, n, bufs, &bufsParam);
    paramBuffer.addParam(std::move(bufsParam));

    return CallCapture("glDrawBuffersEXT", std::move(paramBuffer));
}

CallCapture CaptureFramebufferTextureEXT(const Context *context,
                                         bool isCallValid,
                                         GLenum target,
                                         GLenum attachment,
                                         GLuint texture,
                                         GLint level)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("target", ParamType::TGLenum, target);
    paramBuffer.addValueParam("attachment", ParamType::TGLenum, attachment);
    paramBuffer.addValueParam("texture", ParamType::TGLuint, texture);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);

    return CallCapture("glFramebufferTextureEXT", std::move(paramBuffer));
}

CallCapture CaptureDrawArraysInstancedEXT(const Context *context,
                                          bool isCallValid,
                                          PrimitiveMode modePacked,
                                          GLint start,
                                          GLsizei count,
                                          GLsizei primcount)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("start", ParamType::TGLint, start);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("primcount", ParamType::TGLsizei, primcount);

    return CallCapture("glDrawArraysInstancedEXT", std::move(paramBuffer));
}

CallCapture CaptureDrawElementsInstancedEXT(const Context *context,
                                            bool isCallValid,
                                            PrimitiveMode modePacked,
                                            GLsizei count,
                                            DrawElementsType typePacked,
                                            const void *indices,
                                            GLsizei primcount)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("typePacked", ParamType::TDrawElementsType, typePacked);

    ParamCapture indicesParam("indices", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, indices, &indicesParam.value);
    CaptureDrawElementsInstancedEXT_indices(context, isCallValid, modePacked, count, typePacked,
                                            indices, primcount, &indicesParam);
    paramBuffer.addParam(std::move(indicesParam));

    paramBuffer.addValueParam("primcount", ParamType::TGLsizei, primcount);

    return CallCapture("glDrawElementsInstancedEXT", std::move(paramBuffer));
}

CallCapture CaptureVertexAttribDivisorEXT(const Context *context,
                                          bool isCallValid,
                                          GLuint index,
                                          GLuint divisor)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("divisor", ParamType::TGLuint, divisor);

    return CallCapture("glVertexAttribDivisorEXT", std::move(paramBuffer));
}

CallCapture CaptureFlushMappedBufferRangeEXT(const Context *context,
                                             bool isCallValid,
                                             BufferBinding targetPacked,
                                             GLintptr offset,
                                             GLsizeiptr length)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);
    paramBuffer.addValueParam("offset", ParamType::TGLintptr, offset);
    paramBuffer.addValueParam("length", ParamType::TGLsizeiptr, length);

    return CallCapture("glFlushMappedBufferRangeEXT", std::move(paramBuffer));
}

CallCapture CaptureMapBufferRangeEXT(const Context *context,
                                     bool isCallValid,
                                     BufferBinding targetPacked,
                                     GLintptr offset,
                                     GLsizeiptr length,
                                     GLbitfield access)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);
    paramBuffer.addValueParam("offset", ParamType::TGLintptr, offset);
    paramBuffer.addValueParam("length", ParamType::TGLsizeiptr, length);
    paramBuffer.addValueParam("access", ParamType::TGLbitfield, access);

    return CallCapture("glMapBufferRangeEXT", std::move(paramBuffer));
}

CallCapture CaptureBufferStorageMemEXT(const Context *context,
                                       bool isCallValid,
                                       TextureType targetPacked,
                                       GLsizeiptr size,
                                       GLuint memory,
                                       GLuint64 offset)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("size", ParamType::TGLsizeiptr, size);
    paramBuffer.addValueParam("memory", ParamType::TGLuint, memory);
    paramBuffer.addValueParam("offset", ParamType::TGLuint64, offset);

    return CallCapture("glBufferStorageMemEXT", std::move(paramBuffer));
}

CallCapture CaptureCreateMemoryObjectsEXT(const Context *context,
                                          bool isCallValid,
                                          GLsizei n,
                                          GLuint *memoryObjects)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture memoryObjectsParam("memoryObjects", ParamType::TGLuintPointer);
    InitParamValue(ParamType::TGLuintPointer, memoryObjects, &memoryObjectsParam.value);
    CaptureCreateMemoryObjectsEXT_memoryObjects(context, isCallValid, n, memoryObjects,
                                                &memoryObjectsParam);
    paramBuffer.addParam(std::move(memoryObjectsParam));

    return CallCapture("glCreateMemoryObjectsEXT", std::move(paramBuffer));
}

CallCapture CaptureDeleteMemoryObjectsEXT(const Context *context,
                                          bool isCallValid,
                                          GLsizei n,
                                          const GLuint *memoryObjects)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture memoryObjectsParam("memoryObjects", ParamType::TGLuintConstPointer);
    InitParamValue(ParamType::TGLuintConstPointer, memoryObjects, &memoryObjectsParam.value);
    CaptureDeleteMemoryObjectsEXT_memoryObjects(context, isCallValid, n, memoryObjects,
                                                &memoryObjectsParam);
    paramBuffer.addParam(std::move(memoryObjectsParam));

    return CallCapture("glDeleteMemoryObjectsEXT", std::move(paramBuffer));
}

CallCapture CaptureGetMemoryObjectParameterivEXT(const Context *context,
                                                 bool isCallValid,
                                                 GLuint memoryObject,
                                                 GLenum pname,
                                                 GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("memoryObject", ParamType::TGLuint, memoryObject);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetMemoryObjectParameterivEXT_params(context, isCallValid, memoryObject, pname, params,
                                                &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetMemoryObjectParameterivEXT", std::move(paramBuffer));
}

CallCapture CaptureGetUnsignedBytevEXT(const Context *context,
                                       bool isCallValid,
                                       GLenum pname,
                                       GLubyte *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);

    ParamCapture dataParam("data", ParamType::TGLubytePointer);
    InitParamValue(ParamType::TGLubytePointer, data, &dataParam.value);
    CaptureGetUnsignedBytevEXT_data(context, isCallValid, pname, data, &dataParam);
    paramBuffer.addParam(std::move(dataParam));

    return CallCapture("glGetUnsignedBytevEXT", std::move(paramBuffer));
}

CallCapture CaptureGetUnsignedBytei_vEXT(const Context *context,
                                         bool isCallValid,
                                         GLenum target,
                                         GLuint index,
                                         GLubyte *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("target", ParamType::TGLenum, target);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    ParamCapture dataParam("data", ParamType::TGLubytePointer);
    InitParamValue(ParamType::TGLubytePointer, data, &dataParam.value);
    CaptureGetUnsignedBytei_vEXT_data(context, isCallValid, target, index, data, &dataParam);
    paramBuffer.addParam(std::move(dataParam));

    return CallCapture("glGetUnsignedBytei_vEXT", std::move(paramBuffer));
}

CallCapture CaptureIsMemoryObjectEXT(const Context *context, bool isCallValid, GLuint memoryObject)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("memoryObject", ParamType::TGLuint, memoryObject);

    return CallCapture("glIsMemoryObjectEXT", std::move(paramBuffer));
}

CallCapture CaptureMemoryObjectParameterivEXT(const Context *context,
                                              bool isCallValid,
                                              GLuint memoryObject,
                                              GLenum pname,
                                              const GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("memoryObject", ParamType::TGLuint, memoryObject);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintConstPointer);
    InitParamValue(ParamType::TGLintConstPointer, params, &paramsParam.value);
    CaptureMemoryObjectParameterivEXT_params(context, isCallValid, memoryObject, pname, params,
                                             &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glMemoryObjectParameterivEXT", std::move(paramBuffer));
}

CallCapture CaptureTexStorageMem2DEXT(const Context *context,
                                      bool isCallValid,
                                      TextureType targetPacked,
                                      GLsizei levels,
                                      GLenum internalFormat,
                                      GLsizei width,
                                      GLsizei height,
                                      GLuint memory,
                                      GLuint64 offset)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("levels", ParamType::TGLsizei, levels);
    paramBuffer.addValueParam("internalFormat", ParamType::TGLenum, internalFormat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("memory", ParamType::TGLuint, memory);
    paramBuffer.addValueParam("offset", ParamType::TGLuint64, offset);

    return CallCapture("glTexStorageMem2DEXT", std::move(paramBuffer));
}

CallCapture CaptureTexStorageMem2DMultisampleEXT(const Context *context,
                                                 bool isCallValid,
                                                 TextureType targetPacked,
                                                 GLsizei samples,
                                                 GLenum internalFormat,
                                                 GLsizei width,
                                                 GLsizei height,
                                                 GLboolean fixedSampleLocations,
                                                 GLuint memory,
                                                 GLuint64 offset)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("samples", ParamType::TGLsizei, samples);
    paramBuffer.addValueParam("internalFormat", ParamType::TGLenum, internalFormat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("fixedSampleLocations", ParamType::TGLboolean, fixedSampleLocations);
    paramBuffer.addValueParam("memory", ParamType::TGLuint, memory);
    paramBuffer.addValueParam("offset", ParamType::TGLuint64, offset);

    return CallCapture("glTexStorageMem2DMultisampleEXT", std::move(paramBuffer));
}

CallCapture CaptureTexStorageMem3DEXT(const Context *context,
                                      bool isCallValid,
                                      TextureType targetPacked,
                                      GLsizei levels,
                                      GLenum internalFormat,
                                      GLsizei width,
                                      GLsizei height,
                                      GLsizei depth,
                                      GLuint memory,
                                      GLuint64 offset)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("levels", ParamType::TGLsizei, levels);
    paramBuffer.addValueParam("internalFormat", ParamType::TGLenum, internalFormat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addValueParam("memory", ParamType::TGLuint, memory);
    paramBuffer.addValueParam("offset", ParamType::TGLuint64, offset);

    return CallCapture("glTexStorageMem3DEXT", std::move(paramBuffer));
}

CallCapture CaptureTexStorageMem3DMultisampleEXT(const Context *context,
                                                 bool isCallValid,
                                                 TextureType targetPacked,
                                                 GLsizei samples,
                                                 GLenum internalFormat,
                                                 GLsizei width,
                                                 GLsizei height,
                                                 GLsizei depth,
                                                 GLboolean fixedSampleLocations,
                                                 GLuint memory,
                                                 GLuint64 offset)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("samples", ParamType::TGLsizei, samples);
    paramBuffer.addValueParam("internalFormat", ParamType::TGLenum, internalFormat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addValueParam("fixedSampleLocations", ParamType::TGLboolean, fixedSampleLocations);
    paramBuffer.addValueParam("memory", ParamType::TGLuint, memory);
    paramBuffer.addValueParam("offset", ParamType::TGLuint64, offset);

    return CallCapture("glTexStorageMem3DMultisampleEXT", std::move(paramBuffer));
}

CallCapture CaptureImportMemoryFdEXT(const Context *context,
                                     bool isCallValid,
                                     GLuint memory,
                                     GLuint64 size,
                                     HandleType handleTypePacked,
                                     GLint fd)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("memory", ParamType::TGLuint, memory);
    paramBuffer.addValueParam("size", ParamType::TGLuint64, size);
    paramBuffer.addValueParam("handleTypePacked", ParamType::THandleType, handleTypePacked);
    paramBuffer.addValueParam("fd", ParamType::TGLint, fd);

    return CallCapture("glImportMemoryFdEXT", std::move(paramBuffer));
}

CallCapture CaptureGetGraphicsResetStatusEXT(const Context *context, bool isCallValid)
{
    ParamBuffer paramBuffer;

    return CallCapture("glGetGraphicsResetStatusEXT", std::move(paramBuffer));
}

CallCapture CaptureGetnUniformfvEXT(const Context *context,
                                    bool isCallValid,
                                    GLuint program,
                                    GLint location,
                                    GLsizei bufSize,
                                    GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::TGLuint, program);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
    InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
    CaptureGetnUniformfvEXT_params(context, isCallValid, program, location, bufSize, params,
                                   &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetnUniformfvEXT", std::move(paramBuffer));
}

CallCapture CaptureGetnUniformivEXT(const Context *context,
                                    bool isCallValid,
                                    GLuint program,
                                    GLint location,
                                    GLsizei bufSize,
                                    GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::TGLuint, program);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetnUniformivEXT_params(context, isCallValid, program, location, bufSize, params,
                                   &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetnUniformivEXT", std::move(paramBuffer));
}

CallCapture CaptureReadnPixelsEXT(const Context *context,
                                  bool isCallValid,
                                  GLint x,
                                  GLint y,
                                  GLsizei width,
                                  GLsizei height,
                                  GLenum format,
                                  GLenum type,
                                  GLsizei bufSize,
                                  void *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("format", ParamType::TGLenum, format);
    paramBuffer.addValueParam("type", ParamType::TGLenum, type);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture dataParam("data", ParamType::TvoidPointer);
    InitParamValue(ParamType::TvoidPointer, data, &dataParam.value);
    CaptureReadnPixelsEXT_data(context, isCallValid, x, y, width, height, format, type, bufSize,
                               data, &dataParam);
    paramBuffer.addParam(std::move(dataParam));

    return CallCapture("glReadnPixelsEXT", std::move(paramBuffer));
}

CallCapture CaptureDeleteSemaphoresEXT(const Context *context,
                                       bool isCallValid,
                                       GLsizei n,
                                       const GLuint *semaphores)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture semaphoresParam("semaphores", ParamType::TGLuintConstPointer);
    InitParamValue(ParamType::TGLuintConstPointer, semaphores, &semaphoresParam.value);
    CaptureDeleteSemaphoresEXT_semaphores(context, isCallValid, n, semaphores, &semaphoresParam);
    paramBuffer.addParam(std::move(semaphoresParam));

    return CallCapture("glDeleteSemaphoresEXT", std::move(paramBuffer));
}

CallCapture CaptureGenSemaphoresEXT(const Context *context,
                                    bool isCallValid,
                                    GLsizei n,
                                    GLuint *semaphores)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture semaphoresParam("semaphores", ParamType::TGLuintPointer);
    InitParamValue(ParamType::TGLuintPointer, semaphores, &semaphoresParam.value);
    CaptureGenSemaphoresEXT_semaphores(context, isCallValid, n, semaphores, &semaphoresParam);
    paramBuffer.addParam(std::move(semaphoresParam));

    return CallCapture("glGenSemaphoresEXT", std::move(paramBuffer));
}

CallCapture CaptureGetSemaphoreParameterui64vEXT(const Context *context,
                                                 bool isCallValid,
                                                 GLuint semaphore,
                                                 GLenum pname,
                                                 GLuint64 *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("semaphore", ParamType::TGLuint, semaphore);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLuint64Pointer);
    InitParamValue(ParamType::TGLuint64Pointer, params, &paramsParam.value);
    CaptureGetSemaphoreParameterui64vEXT_params(context, isCallValid, semaphore, pname, params,
                                                &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetSemaphoreParameterui64vEXT", std::move(paramBuffer));
}

CallCapture CaptureIsSemaphoreEXT(const Context *context, bool isCallValid, GLuint semaphore)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("semaphore", ParamType::TGLuint, semaphore);

    return CallCapture("glIsSemaphoreEXT", std::move(paramBuffer));
}

CallCapture CaptureSemaphoreParameterui64vEXT(const Context *context,
                                              bool isCallValid,
                                              GLuint semaphore,
                                              GLenum pname,
                                              const GLuint64 *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("semaphore", ParamType::TGLuint, semaphore);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLuint64ConstPointer);
    InitParamValue(ParamType::TGLuint64ConstPointer, params, &paramsParam.value);
    CaptureSemaphoreParameterui64vEXT_params(context, isCallValid, semaphore, pname, params,
                                             &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glSemaphoreParameterui64vEXT", std::move(paramBuffer));
}

CallCapture CaptureSignalSemaphoreEXT(const Context *context,
                                      bool isCallValid,
                                      GLuint semaphore,
                                      GLuint numBufferBarriers,
                                      const GLuint *buffers,
                                      GLuint numTextureBarriers,
                                      const GLuint *textures,
                                      const GLenum *dstLayouts)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("semaphore", ParamType::TGLuint, semaphore);
    paramBuffer.addValueParam("numBufferBarriers", ParamType::TGLuint, numBufferBarriers);

    ParamCapture buffersParam("buffers", ParamType::TGLuintConstPointer);
    InitParamValue(ParamType::TGLuintConstPointer, buffers, &buffersParam.value);
    CaptureSignalSemaphoreEXT_buffers(context, isCallValid, semaphore, numBufferBarriers, buffers,
                                      numTextureBarriers, textures, dstLayouts, &buffersParam);
    paramBuffer.addParam(std::move(buffersParam));

    paramBuffer.addValueParam("numTextureBarriers", ParamType::TGLuint, numTextureBarriers);

    ParamCapture texturesParam("textures", ParamType::TGLuintConstPointer);
    InitParamValue(ParamType::TGLuintConstPointer, textures, &texturesParam.value);
    CaptureSignalSemaphoreEXT_textures(context, isCallValid, semaphore, numBufferBarriers, buffers,
                                       numTextureBarriers, textures, dstLayouts, &texturesParam);
    paramBuffer.addParam(std::move(texturesParam));

    ParamCapture dstLayoutsParam("dstLayouts", ParamType::TGLenumConstPointer);
    InitParamValue(ParamType::TGLenumConstPointer, dstLayouts, &dstLayoutsParam.value);
    CaptureSignalSemaphoreEXT_dstLayouts(context, isCallValid, semaphore, numBufferBarriers,
                                         buffers, numTextureBarriers, textures, dstLayouts,
                                         &dstLayoutsParam);
    paramBuffer.addParam(std::move(dstLayoutsParam));

    return CallCapture("glSignalSemaphoreEXT", std::move(paramBuffer));
}

CallCapture CaptureWaitSemaphoreEXT(const Context *context,
                                    bool isCallValid,
                                    GLuint semaphore,
                                    GLuint numBufferBarriers,
                                    const GLuint *buffers,
                                    GLuint numTextureBarriers,
                                    const GLuint *textures,
                                    const GLenum *srcLayouts)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("semaphore", ParamType::TGLuint, semaphore);
    paramBuffer.addValueParam("numBufferBarriers", ParamType::TGLuint, numBufferBarriers);

    ParamCapture buffersParam("buffers", ParamType::TGLuintConstPointer);
    InitParamValue(ParamType::TGLuintConstPointer, buffers, &buffersParam.value);
    CaptureWaitSemaphoreEXT_buffers(context, isCallValid, semaphore, numBufferBarriers, buffers,
                                    numTextureBarriers, textures, srcLayouts, &buffersParam);
    paramBuffer.addParam(std::move(buffersParam));

    paramBuffer.addValueParam("numTextureBarriers", ParamType::TGLuint, numTextureBarriers);

    ParamCapture texturesParam("textures", ParamType::TGLuintConstPointer);
    InitParamValue(ParamType::TGLuintConstPointer, textures, &texturesParam.value);
    CaptureWaitSemaphoreEXT_textures(context, isCallValid, semaphore, numBufferBarriers, buffers,
                                     numTextureBarriers, textures, srcLayouts, &texturesParam);
    paramBuffer.addParam(std::move(texturesParam));

    ParamCapture srcLayoutsParam("srcLayouts", ParamType::TGLenumConstPointer);
    InitParamValue(ParamType::TGLenumConstPointer, srcLayouts, &srcLayoutsParam.value);
    CaptureWaitSemaphoreEXT_srcLayouts(context, isCallValid, semaphore, numBufferBarriers, buffers,
                                       numTextureBarriers, textures, srcLayouts, &srcLayoutsParam);
    paramBuffer.addParam(std::move(srcLayoutsParam));

    return CallCapture("glWaitSemaphoreEXT", std::move(paramBuffer));
}

CallCapture CaptureImportSemaphoreFdEXT(const Context *context,
                                        bool isCallValid,
                                        GLuint semaphore,
                                        HandleType handleTypePacked,
                                        GLint fd)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("semaphore", ParamType::TGLuint, semaphore);
    paramBuffer.addValueParam("handleTypePacked", ParamType::THandleType, handleTypePacked);
    paramBuffer.addValueParam("fd", ParamType::TGLint, fd);

    return CallCapture("glImportSemaphoreFdEXT", std::move(paramBuffer));
}

CallCapture CaptureTexStorage1DEXT(const Context *context,
                                   bool isCallValid,
                                   GLenum target,
                                   GLsizei levels,
                                   GLenum internalformat,
                                   GLsizei width)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("target", ParamType::TGLenum, target);
    paramBuffer.addValueParam("levels", ParamType::TGLsizei, levels);
    paramBuffer.addValueParam("internalformat", ParamType::TGLenum, internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);

    return CallCapture("glTexStorage1DEXT", std::move(paramBuffer));
}

CallCapture CaptureTexStorage2DEXT(const Context *context,
                                   bool isCallValid,
                                   TextureType targetPacked,
                                   GLsizei levels,
                                   GLenum internalformat,
                                   GLsizei width,
                                   GLsizei height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("levels", ParamType::TGLsizei, levels);
    paramBuffer.addValueParam("internalformat", ParamType::TGLenum, internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);

    return CallCapture("glTexStorage2DEXT", std::move(paramBuffer));
}

CallCapture CaptureTexStorage3DEXT(const Context *context,
                                   bool isCallValid,
                                   TextureType targetPacked,
                                   GLsizei levels,
                                   GLenum internalformat,
                                   GLsizei width,
                                   GLsizei height,
                                   GLsizei depth)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("levels", ParamType::TGLsizei, levels);
    paramBuffer.addValueParam("internalformat", ParamType::TGLenum, internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);

    return CallCapture("glTexStorage3DEXT", std::move(paramBuffer));
}

CallCapture CaptureDebugMessageCallbackKHR(const Context *context,
                                           bool isCallValid,
                                           GLDEBUGPROCKHR callback,
                                           const void *userParam)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("callback", ParamType::TGLDEBUGPROCKHR, callback);

    ParamCapture userParamParam("userParam", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, userParam, &userParamParam.value);
    CaptureDebugMessageCallbackKHR_userParam(context, isCallValid, callback, userParam,
                                             &userParamParam);
    paramBuffer.addParam(std::move(userParamParam));

    return CallCapture("glDebugMessageCallbackKHR", std::move(paramBuffer));
}

CallCapture CaptureDebugMessageControlKHR(const Context *context,
                                          bool isCallValid,
                                          GLenum source,
                                          GLenum type,
                                          GLenum severity,
                                          GLsizei count,
                                          const GLuint *ids,
                                          GLboolean enabled)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("source", ParamType::TGLenum, source);
    paramBuffer.addValueParam("type", ParamType::TGLenum, type);
    paramBuffer.addValueParam("severity", ParamType::TGLenum, severity);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture idsParam("ids", ParamType::TGLuintConstPointer);
    InitParamValue(ParamType::TGLuintConstPointer, ids, &idsParam.value);
    CaptureDebugMessageControlKHR_ids(context, isCallValid, source, type, severity, count, ids,
                                      enabled, &idsParam);
    paramBuffer.addParam(std::move(idsParam));

    paramBuffer.addValueParam("enabled", ParamType::TGLboolean, enabled);

    return CallCapture("glDebugMessageControlKHR", std::move(paramBuffer));
}

CallCapture CaptureDebugMessageInsertKHR(const Context *context,
                                         bool isCallValid,
                                         GLenum source,
                                         GLenum type,
                                         GLuint id,
                                         GLenum severity,
                                         GLsizei length,
                                         const GLchar *buf)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("source", ParamType::TGLenum, source);
    paramBuffer.addValueParam("type", ParamType::TGLenum, type);
    paramBuffer.addValueParam("id", ParamType::TGLuint, id);
    paramBuffer.addValueParam("severity", ParamType::TGLenum, severity);
    paramBuffer.addValueParam("length", ParamType::TGLsizei, length);

    ParamCapture bufParam("buf", ParamType::TGLcharConstPointer);
    InitParamValue(ParamType::TGLcharConstPointer, buf, &bufParam.value);
    CaptureDebugMessageInsertKHR_buf(context, isCallValid, source, type, id, severity, length, buf,
                                     &bufParam);
    paramBuffer.addParam(std::move(bufParam));

    return CallCapture("glDebugMessageInsertKHR", std::move(paramBuffer));
}

CallCapture CaptureGetDebugMessageLogKHR(const Context *context,
                                         bool isCallValid,
                                         GLuint count,
                                         GLsizei bufSize,
                                         GLenum *sources,
                                         GLenum *types,
                                         GLuint *ids,
                                         GLenum *severities,
                                         GLsizei *lengths,
                                         GLchar *messageLog)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("count", ParamType::TGLuint, count);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture sourcesParam("sources", ParamType::TGLenumPointer);
    InitParamValue(ParamType::TGLenumPointer, sources, &sourcesParam.value);
    CaptureGetDebugMessageLogKHR_sources(context, isCallValid, count, bufSize, sources, types, ids,
                                         severities, lengths, messageLog, &sourcesParam);
    paramBuffer.addParam(std::move(sourcesParam));

    ParamCapture typesParam("types", ParamType::TGLenumPointer);
    InitParamValue(ParamType::TGLenumPointer, types, &typesParam.value);
    CaptureGetDebugMessageLogKHR_types(context, isCallValid, count, bufSize, sources, types, ids,
                                       severities, lengths, messageLog, &typesParam);
    paramBuffer.addParam(std::move(typesParam));

    ParamCapture idsParam("ids", ParamType::TGLuintPointer);
    InitParamValue(ParamType::TGLuintPointer, ids, &idsParam.value);
    CaptureGetDebugMessageLogKHR_ids(context, isCallValid, count, bufSize, sources, types, ids,
                                     severities, lengths, messageLog, &idsParam);
    paramBuffer.addParam(std::move(idsParam));

    ParamCapture severitiesParam("severities", ParamType::TGLenumPointer);
    InitParamValue(ParamType::TGLenumPointer, severities, &severitiesParam.value);
    CaptureGetDebugMessageLogKHR_severities(context, isCallValid, count, bufSize, sources, types,
                                            ids, severities, lengths, messageLog, &severitiesParam);
    paramBuffer.addParam(std::move(severitiesParam));

    ParamCapture lengthsParam("lengths", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, lengths, &lengthsParam.value);
    CaptureGetDebugMessageLogKHR_lengths(context, isCallValid, count, bufSize, sources, types, ids,
                                         severities, lengths, messageLog, &lengthsParam);
    paramBuffer.addParam(std::move(lengthsParam));

    ParamCapture messageLogParam("messageLog", ParamType::TGLcharPointer);
    InitParamValue(ParamType::TGLcharPointer, messageLog, &messageLogParam.value);
    CaptureGetDebugMessageLogKHR_messageLog(context, isCallValid, count, bufSize, sources, types,
                                            ids, severities, lengths, messageLog, &messageLogParam);
    paramBuffer.addParam(std::move(messageLogParam));

    return CallCapture("glGetDebugMessageLogKHR", std::move(paramBuffer));
}

CallCapture CaptureGetObjectLabelKHR(const Context *context,
                                     bool isCallValid,
                                     GLenum identifier,
                                     GLuint name,
                                     GLsizei bufSize,
                                     GLsizei *length,
                                     GLchar *label)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("identifier", ParamType::TGLenum, identifier);
    paramBuffer.addValueParam("name", ParamType::TGLuint, name);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetObjectLabelKHR_length(context, isCallValid, identifier, name, bufSize, length, label,
                                    &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture labelParam("label", ParamType::TGLcharPointer);
    InitParamValue(ParamType::TGLcharPointer, label, &labelParam.value);
    CaptureGetObjectLabelKHR_label(context, isCallValid, identifier, name, bufSize, length, label,
                                   &labelParam);
    paramBuffer.addParam(std::move(labelParam));

    return CallCapture("glGetObjectLabelKHR", std::move(paramBuffer));
}

CallCapture CaptureGetObjectPtrLabelKHR(const Context *context,
                                        bool isCallValid,
                                        const void *ptr,
                                        GLsizei bufSize,
                                        GLsizei *length,
                                        GLchar *label)
{
    ParamBuffer paramBuffer;

    ParamCapture ptrParam("ptr", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, ptr, &ptrParam.value);
    CaptureGetObjectPtrLabelKHR_ptr(context, isCallValid, ptr, bufSize, length, label, &ptrParam);
    paramBuffer.addParam(std::move(ptrParam));

    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetObjectPtrLabelKHR_length(context, isCallValid, ptr, bufSize, length, label,
                                       &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture labelParam("label", ParamType::TGLcharPointer);
    InitParamValue(ParamType::TGLcharPointer, label, &labelParam.value);
    CaptureGetObjectPtrLabelKHR_label(context, isCallValid, ptr, bufSize, length, label,
                                      &labelParam);
    paramBuffer.addParam(std::move(labelParam));

    return CallCapture("glGetObjectPtrLabelKHR", std::move(paramBuffer));
}

CallCapture CaptureGetPointervKHR(const Context *context,
                                  bool isCallValid,
                                  GLenum pname,
                                  void **params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TvoidPointerPointer);
    InitParamValue(ParamType::TvoidPointerPointer, params, &paramsParam.value);
    CaptureGetPointervKHR_params(context, isCallValid, pname, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetPointervKHR", std::move(paramBuffer));
}

CallCapture CaptureObjectLabelKHR(const Context *context,
                                  bool isCallValid,
                                  GLenum identifier,
                                  GLuint name,
                                  GLsizei length,
                                  const GLchar *label)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("identifier", ParamType::TGLenum, identifier);
    paramBuffer.addValueParam("name", ParamType::TGLuint, name);
    paramBuffer.addValueParam("length", ParamType::TGLsizei, length);

    ParamCapture labelParam("label", ParamType::TGLcharConstPointer);
    InitParamValue(ParamType::TGLcharConstPointer, label, &labelParam.value);
    CaptureObjectLabelKHR_label(context, isCallValid, identifier, name, length, label, &labelParam);
    paramBuffer.addParam(std::move(labelParam));

    return CallCapture("glObjectLabelKHR", std::move(paramBuffer));
}

CallCapture CaptureObjectPtrLabelKHR(const Context *context,
                                     bool isCallValid,
                                     const void *ptr,
                                     GLsizei length,
                                     const GLchar *label)
{
    ParamBuffer paramBuffer;

    ParamCapture ptrParam("ptr", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, ptr, &ptrParam.value);
    CaptureObjectPtrLabelKHR_ptr(context, isCallValid, ptr, length, label, &ptrParam);
    paramBuffer.addParam(std::move(ptrParam));

    paramBuffer.addValueParam("length", ParamType::TGLsizei, length);

    ParamCapture labelParam("label", ParamType::TGLcharConstPointer);
    InitParamValue(ParamType::TGLcharConstPointer, label, &labelParam.value);
    CaptureObjectPtrLabelKHR_label(context, isCallValid, ptr, length, label, &labelParam);
    paramBuffer.addParam(std::move(labelParam));

    return CallCapture("glObjectPtrLabelKHR", std::move(paramBuffer));
}

CallCapture CapturePopDebugGroupKHR(const Context *context, bool isCallValid)
{
    ParamBuffer paramBuffer;

    return CallCapture("glPopDebugGroupKHR", std::move(paramBuffer));
}

CallCapture CapturePushDebugGroupKHR(const Context *context,
                                     bool isCallValid,
                                     GLenum source,
                                     GLuint id,
                                     GLsizei length,
                                     const GLchar *message)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("source", ParamType::TGLenum, source);
    paramBuffer.addValueParam("id", ParamType::TGLuint, id);
    paramBuffer.addValueParam("length", ParamType::TGLsizei, length);

    ParamCapture messageParam("message", ParamType::TGLcharConstPointer);
    InitParamValue(ParamType::TGLcharConstPointer, message, &messageParam.value);
    CapturePushDebugGroupKHR_message(context, isCallValid, source, id, length, message,
                                     &messageParam);
    paramBuffer.addParam(std::move(messageParam));

    return CallCapture("glPushDebugGroupKHR", std::move(paramBuffer));
}

CallCapture CaptureMaxShaderCompilerThreadsKHR(const Context *context,
                                               bool isCallValid,
                                               GLuint count)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("count", ParamType::TGLuint, count);

    return CallCapture("glMaxShaderCompilerThreadsKHR", std::move(paramBuffer));
}

CallCapture CaptureDeleteFencesNV(const Context *context,
                                  bool isCallValid,
                                  GLsizei n,
                                  const GLuint *fences)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture fencesParam("fences", ParamType::TGLuintConstPointer);
    InitParamValue(ParamType::TGLuintConstPointer, fences, &fencesParam.value);
    CaptureDeleteFencesNV_fences(context, isCallValid, n, fences, &fencesParam);
    paramBuffer.addParam(std::move(fencesParam));

    return CallCapture("glDeleteFencesNV", std::move(paramBuffer));
}

CallCapture CaptureFinishFenceNV(const Context *context, bool isCallValid, GLuint fence)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("fence", ParamType::TGLuint, fence);

    return CallCapture("glFinishFenceNV", std::move(paramBuffer));
}

CallCapture CaptureGenFencesNV(const Context *context, bool isCallValid, GLsizei n, GLuint *fences)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture fencesParam("fences", ParamType::TGLuintPointer);
    InitParamValue(ParamType::TGLuintPointer, fences, &fencesParam.value);
    CaptureGenFencesNV_fences(context, isCallValid, n, fences, &fencesParam);
    paramBuffer.addParam(std::move(fencesParam));

    return CallCapture("glGenFencesNV", std::move(paramBuffer));
}

CallCapture CaptureGetFenceivNV(const Context *context,
                                bool isCallValid,
                                GLuint fence,
                                GLenum pname,
                                GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("fence", ParamType::TGLuint, fence);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetFenceivNV_params(context, isCallValid, fence, pname, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetFenceivNV", std::move(paramBuffer));
}

CallCapture CaptureIsFenceNV(const Context *context, bool isCallValid, GLuint fence)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("fence", ParamType::TGLuint, fence);

    return CallCapture("glIsFenceNV", std::move(paramBuffer));
}

CallCapture CaptureSetFenceNV(const Context *context,
                              bool isCallValid,
                              GLuint fence,
                              GLenum condition)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("fence", ParamType::TGLuint, fence);
    paramBuffer.addValueParam("condition", ParamType::TGLenum, condition);

    return CallCapture("glSetFenceNV", std::move(paramBuffer));
}

CallCapture CaptureTestFenceNV(const Context *context, bool isCallValid, GLuint fence)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("fence", ParamType::TGLuint, fence);

    return CallCapture("glTestFenceNV", std::move(paramBuffer));
}

CallCapture CaptureEGLImageTargetRenderbufferStorageOES(const Context *context,
                                                        bool isCallValid,
                                                        GLenum target,
                                                        GLeglImageOES image)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("target", ParamType::TGLenum, target);
    paramBuffer.addValueParam("image", ParamType::TGLeglImageOES, image);

    return CallCapture("glEGLImageTargetRenderbufferStorageOES", std::move(paramBuffer));
}

CallCapture CaptureEGLImageTargetTexture2DOES(const Context *context,
                                              bool isCallValid,
                                              TextureType targetPacked,
                                              GLeglImageOES image)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("image", ParamType::TGLeglImageOES, image);

    return CallCapture("glEGLImageTargetTexture2DOES", std::move(paramBuffer));
}

CallCapture CaptureDrawTexfOES(const Context *context,
                               bool isCallValid,
                               GLfloat x,
                               GLfloat y,
                               GLfloat z,
                               GLfloat width,
                               GLfloat height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLfloat, x);
    paramBuffer.addValueParam("y", ParamType::TGLfloat, y);
    paramBuffer.addValueParam("z", ParamType::TGLfloat, z);
    paramBuffer.addValueParam("width", ParamType::TGLfloat, width);
    paramBuffer.addValueParam("height", ParamType::TGLfloat, height);

    return CallCapture("glDrawTexfOES", std::move(paramBuffer));
}

CallCapture CaptureDrawTexfvOES(const Context *context, bool isCallValid, const GLfloat *coords)
{
    ParamBuffer paramBuffer;

    ParamCapture coordsParam("coords", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, coords, &coordsParam.value);
    CaptureDrawTexfvOES_coords(context, isCallValid, coords, &coordsParam);
    paramBuffer.addParam(std::move(coordsParam));

    return CallCapture("glDrawTexfvOES", std::move(paramBuffer));
}

CallCapture CaptureDrawTexiOES(const Context *context,
                               bool isCallValid,
                               GLint x,
                               GLint y,
                               GLint z,
                               GLint width,
                               GLint height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("z", ParamType::TGLint, z);
    paramBuffer.addValueParam("width", ParamType::TGLint, width);
    paramBuffer.addValueParam("height", ParamType::TGLint, height);

    return CallCapture("glDrawTexiOES", std::move(paramBuffer));
}

CallCapture CaptureDrawTexivOES(const Context *context, bool isCallValid, const GLint *coords)
{
    ParamBuffer paramBuffer;

    ParamCapture coordsParam("coords", ParamType::TGLintConstPointer);
    InitParamValue(ParamType::TGLintConstPointer, coords, &coordsParam.value);
    CaptureDrawTexivOES_coords(context, isCallValid, coords, &coordsParam);
    paramBuffer.addParam(std::move(coordsParam));

    return CallCapture("glDrawTexivOES", std::move(paramBuffer));
}

CallCapture CaptureDrawTexsOES(const Context *context,
                               bool isCallValid,
                               GLshort x,
                               GLshort y,
                               GLshort z,
                               GLshort width,
                               GLshort height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLshort, x);
    paramBuffer.addValueParam("y", ParamType::TGLshort, y);
    paramBuffer.addValueParam("z", ParamType::TGLshort, z);
    paramBuffer.addValueParam("width", ParamType::TGLshort, width);
    paramBuffer.addValueParam("height", ParamType::TGLshort, height);

    return CallCapture("glDrawTexsOES", std::move(paramBuffer));
}

CallCapture CaptureDrawTexsvOES(const Context *context, bool isCallValid, const GLshort *coords)
{
    ParamBuffer paramBuffer;

    ParamCapture coordsParam("coords", ParamType::TGLshortConstPointer);
    InitParamValue(ParamType::TGLshortConstPointer, coords, &coordsParam.value);
    CaptureDrawTexsvOES_coords(context, isCallValid, coords, &coordsParam);
    paramBuffer.addParam(std::move(coordsParam));

    return CallCapture("glDrawTexsvOES", std::move(paramBuffer));
}

CallCapture CaptureDrawTexxOES(const Context *context,
                               bool isCallValid,
                               GLfixed x,
                               GLfixed y,
                               GLfixed z,
                               GLfixed width,
                               GLfixed height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLfixed, x);
    paramBuffer.addValueParam("y", ParamType::TGLfixed, y);
    paramBuffer.addValueParam("z", ParamType::TGLfixed, z);
    paramBuffer.addValueParam("width", ParamType::TGLfixed, width);
    paramBuffer.addValueParam("height", ParamType::TGLfixed, height);

    return CallCapture("glDrawTexxOES", std::move(paramBuffer));
}

CallCapture CaptureDrawTexxvOES(const Context *context, bool isCallValid, const GLfixed *coords)
{
    ParamBuffer paramBuffer;

    ParamCapture coordsParam("coords", ParamType::TGLfixedConstPointer);
    InitParamValue(ParamType::TGLfixedConstPointer, coords, &coordsParam.value);
    CaptureDrawTexxvOES_coords(context, isCallValid, coords, &coordsParam);
    paramBuffer.addParam(std::move(coordsParam));

    return CallCapture("glDrawTexxvOES", std::move(paramBuffer));
}

CallCapture CaptureBindFramebufferOES(const Context *context,
                                      bool isCallValid,
                                      GLenum target,
                                      GLuint framebuffer)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("target", ParamType::TGLenum, target);
    paramBuffer.addValueParam("framebuffer", ParamType::TGLuint, framebuffer);

    return CallCapture("glBindFramebufferOES", std::move(paramBuffer));
}

CallCapture CaptureBindRenderbufferOES(const Context *context,
                                       bool isCallValid,
                                       GLenum target,
                                       GLuint renderbuffer)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("target", ParamType::TGLenum, target);
    paramBuffer.addValueParam("renderbuffer", ParamType::TGLuint, renderbuffer);

    return CallCapture("glBindRenderbufferOES", std::move(paramBuffer));
}

CallCapture CaptureCheckFramebufferStatusOES(const Context *context,
                                             bool isCallValid,
                                             GLenum target)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("target", ParamType::TGLenum, target);

    return CallCapture("glCheckFramebufferStatusOES", std::move(paramBuffer));
}

CallCapture CaptureDeleteFramebuffersOES(const Context *context,
                                         bool isCallValid,
                                         GLsizei n,
                                         const GLuint *framebuffers)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture framebuffersParam("framebuffers", ParamType::TGLuintConstPointer);
    InitParamValue(ParamType::TGLuintConstPointer, framebuffers, &framebuffersParam.value);
    CaptureDeleteFramebuffersOES_framebuffers(context, isCallValid, n, framebuffers,
                                              &framebuffersParam);
    paramBuffer.addParam(std::move(framebuffersParam));

    return CallCapture("glDeleteFramebuffersOES", std::move(paramBuffer));
}

CallCapture CaptureDeleteRenderbuffersOES(const Context *context,
                                          bool isCallValid,
                                          GLsizei n,
                                          const GLuint *renderbuffers)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture renderbuffersParam("renderbuffers", ParamType::TGLuintConstPointer);
    InitParamValue(ParamType::TGLuintConstPointer, renderbuffers, &renderbuffersParam.value);
    CaptureDeleteRenderbuffersOES_renderbuffers(context, isCallValid, n, renderbuffers,
                                                &renderbuffersParam);
    paramBuffer.addParam(std::move(renderbuffersParam));

    return CallCapture("glDeleteRenderbuffersOES", std::move(paramBuffer));
}

CallCapture CaptureFramebufferRenderbufferOES(const Context *context,
                                              bool isCallValid,
                                              GLenum target,
                                              GLenum attachment,
                                              GLenum renderbuffertarget,
                                              GLuint renderbuffer)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("target", ParamType::TGLenum, target);
    paramBuffer.addValueParam("attachment", ParamType::TGLenum, attachment);
    paramBuffer.addValueParam("renderbuffertarget", ParamType::TGLenum, renderbuffertarget);
    paramBuffer.addValueParam("renderbuffer", ParamType::TGLuint, renderbuffer);

    return CallCapture("glFramebufferRenderbufferOES", std::move(paramBuffer));
}

CallCapture CaptureFramebufferTexture2DOES(const Context *context,
                                           bool isCallValid,
                                           GLenum target,
                                           GLenum attachment,
                                           TextureTarget textargetPacked,
                                           GLuint texture,
                                           GLint level)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("target", ParamType::TGLenum, target);
    paramBuffer.addValueParam("attachment", ParamType::TGLenum, attachment);
    paramBuffer.addValueParam("textargetPacked", ParamType::TTextureTarget, textargetPacked);
    paramBuffer.addValueParam("texture", ParamType::TGLuint, texture);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);

    return CallCapture("glFramebufferTexture2DOES", std::move(paramBuffer));
}

CallCapture CaptureGenFramebuffersOES(const Context *context,
                                      bool isCallValid,
                                      GLsizei n,
                                      GLuint *framebuffers)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture framebuffersParam("framebuffers", ParamType::TGLuintPointer);
    InitParamValue(ParamType::TGLuintPointer, framebuffers, &framebuffersParam.value);
    CaptureGenFramebuffersOES_framebuffers(context, isCallValid, n, framebuffers,
                                           &framebuffersParam);
    paramBuffer.addParam(std::move(framebuffersParam));

    return CallCapture("glGenFramebuffersOES", std::move(paramBuffer));
}

CallCapture CaptureGenRenderbuffersOES(const Context *context,
                                       bool isCallValid,
                                       GLsizei n,
                                       GLuint *renderbuffers)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture renderbuffersParam("renderbuffers", ParamType::TGLuintPointer);
    InitParamValue(ParamType::TGLuintPointer, renderbuffers, &renderbuffersParam.value);
    CaptureGenRenderbuffersOES_renderbuffers(context, isCallValid, n, renderbuffers,
                                             &renderbuffersParam);
    paramBuffer.addParam(std::move(renderbuffersParam));

    return CallCapture("glGenRenderbuffersOES", std::move(paramBuffer));
}

CallCapture CaptureGenerateMipmapOES(const Context *context,
                                     bool isCallValid,
                                     TextureType targetPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);

    return CallCapture("glGenerateMipmapOES", std::move(paramBuffer));
}

CallCapture CaptureGetFramebufferAttachmentParameterivOES(const Context *context,
                                                          bool isCallValid,
                                                          GLenum target,
                                                          GLenum attachment,
                                                          GLenum pname,
                                                          GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("target", ParamType::TGLenum, target);
    paramBuffer.addValueParam("attachment", ParamType::TGLenum, attachment);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetFramebufferAttachmentParameterivOES_params(context, isCallValid, target, attachment,
                                                         pname, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetFramebufferAttachmentParameterivOES", std::move(paramBuffer));
}

CallCapture CaptureGetRenderbufferParameterivOES(const Context *context,
                                                 bool isCallValid,
                                                 GLenum target,
                                                 GLenum pname,
                                                 GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("target", ParamType::TGLenum, target);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetRenderbufferParameterivOES_params(context, isCallValid, target, pname, params,
                                                &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetRenderbufferParameterivOES", std::move(paramBuffer));
}

CallCapture CaptureIsFramebufferOES(const Context *context, bool isCallValid, GLuint framebuffer)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("framebuffer", ParamType::TGLuint, framebuffer);

    return CallCapture("glIsFramebufferOES", std::move(paramBuffer));
}

CallCapture CaptureIsRenderbufferOES(const Context *context, bool isCallValid, GLuint renderbuffer)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("renderbuffer", ParamType::TGLuint, renderbuffer);

    return CallCapture("glIsRenderbufferOES", std::move(paramBuffer));
}

CallCapture CaptureRenderbufferStorageOES(const Context *context,
                                          bool isCallValid,
                                          GLenum target,
                                          GLenum internalformat,
                                          GLsizei width,
                                          GLsizei height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("target", ParamType::TGLenum, target);
    paramBuffer.addValueParam("internalformat", ParamType::TGLenum, internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);

    return CallCapture("glRenderbufferStorageOES", std::move(paramBuffer));
}

CallCapture CaptureGetProgramBinaryOES(const Context *context,
                                       bool isCallValid,
                                       GLuint program,
                                       GLsizei bufSize,
                                       GLsizei *length,
                                       GLenum *binaryFormat,
                                       void *binary)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::TGLuint, program);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetProgramBinaryOES_length(context, isCallValid, program, bufSize, length, binaryFormat,
                                      binary, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture binaryFormatParam("binaryFormat", ParamType::TGLenumPointer);
    InitParamValue(ParamType::TGLenumPointer, binaryFormat, &binaryFormatParam.value);
    CaptureGetProgramBinaryOES_binaryFormat(context, isCallValid, program, bufSize, length,
                                            binaryFormat, binary, &binaryFormatParam);
    paramBuffer.addParam(std::move(binaryFormatParam));

    ParamCapture binaryParam("binary", ParamType::TvoidPointer);
    InitParamValue(ParamType::TvoidPointer, binary, &binaryParam.value);
    CaptureGetProgramBinaryOES_binary(context, isCallValid, program, bufSize, length, binaryFormat,
                                      binary, &binaryParam);
    paramBuffer.addParam(std::move(binaryParam));

    return CallCapture("glGetProgramBinaryOES", std::move(paramBuffer));
}

CallCapture CaptureProgramBinaryOES(const Context *context,
                                    bool isCallValid,
                                    GLuint program,
                                    GLenum binaryFormat,
                                    const void *binary,
                                    GLint length)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::TGLuint, program);
    paramBuffer.addValueParam("binaryFormat", ParamType::TGLenum, binaryFormat);

    ParamCapture binaryParam("binary", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, binary, &binaryParam.value);
    CaptureProgramBinaryOES_binary(context, isCallValid, program, binaryFormat, binary, length,
                                   &binaryParam);
    paramBuffer.addParam(std::move(binaryParam));

    paramBuffer.addValueParam("length", ParamType::TGLint, length);

    return CallCapture("glProgramBinaryOES", std::move(paramBuffer));
}

CallCapture CaptureGetBufferPointervOES(const Context *context,
                                        bool isCallValid,
                                        BufferBinding targetPacked,
                                        GLenum pname,
                                        void **params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TvoidPointerPointer);
    InitParamValue(ParamType::TvoidPointerPointer, params, &paramsParam.value);
    CaptureGetBufferPointervOES_params(context, isCallValid, targetPacked, pname, params,
                                       &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetBufferPointervOES", std::move(paramBuffer));
}

CallCapture CaptureMapBufferOES(const Context *context,
                                bool isCallValid,
                                BufferBinding targetPacked,
                                GLenum access)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);
    paramBuffer.addValueParam("access", ParamType::TGLenum, access);

    return CallCapture("glMapBufferOES", std::move(paramBuffer));
}

CallCapture CaptureUnmapBufferOES(const Context *context,
                                  bool isCallValid,
                                  BufferBinding targetPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);

    return CallCapture("glUnmapBufferOES", std::move(paramBuffer));
}

CallCapture CaptureCurrentPaletteMatrixOES(const Context *context,
                                           bool isCallValid,
                                           GLuint matrixpaletteindex)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("matrixpaletteindex", ParamType::TGLuint, matrixpaletteindex);

    return CallCapture("glCurrentPaletteMatrixOES", std::move(paramBuffer));
}

CallCapture CaptureLoadPaletteFromModelViewMatrixOES(const Context *context, bool isCallValid)
{
    ParamBuffer paramBuffer;

    return CallCapture("glLoadPaletteFromModelViewMatrixOES", std::move(paramBuffer));
}

CallCapture CaptureMatrixIndexPointerOES(const Context *context,
                                         bool isCallValid,
                                         GLint size,
                                         GLenum type,
                                         GLsizei stride,
                                         const void *pointer)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("size", ParamType::TGLint, size);
    paramBuffer.addValueParam("type", ParamType::TGLenum, type);
    paramBuffer.addValueParam("stride", ParamType::TGLsizei, stride);

    ParamCapture pointerParam("pointer", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, pointer, &pointerParam.value);
    CaptureMatrixIndexPointerOES_pointer(context, isCallValid, size, type, stride, pointer,
                                         &pointerParam);
    paramBuffer.addParam(std::move(pointerParam));

    return CallCapture("glMatrixIndexPointerOES", std::move(paramBuffer));
}

CallCapture CaptureWeightPointerOES(const Context *context,
                                    bool isCallValid,
                                    GLint size,
                                    GLenum type,
                                    GLsizei stride,
                                    const void *pointer)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("size", ParamType::TGLint, size);
    paramBuffer.addValueParam("type", ParamType::TGLenum, type);
    paramBuffer.addValueParam("stride", ParamType::TGLsizei, stride);

    ParamCapture pointerParam("pointer", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, pointer, &pointerParam.value);
    CaptureWeightPointerOES_pointer(context, isCallValid, size, type, stride, pointer,
                                    &pointerParam);
    paramBuffer.addParam(std::move(pointerParam));

    return CallCapture("glWeightPointerOES", std::move(paramBuffer));
}

CallCapture CapturePointSizePointerOES(const Context *context,
                                       bool isCallValid,
                                       VertexAttribType typePacked,
                                       GLsizei stride,
                                       const void *pointer)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("typePacked", ParamType::TVertexAttribType, typePacked);
    paramBuffer.addValueParam("stride", ParamType::TGLsizei, stride);

    ParamCapture pointerParam("pointer", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, pointer, &pointerParam.value);
    CapturePointSizePointerOES_pointer(context, isCallValid, typePacked, stride, pointer,
                                       &pointerParam);
    paramBuffer.addParam(std::move(pointerParam));

    return CallCapture("glPointSizePointerOES", std::move(paramBuffer));
}

CallCapture CaptureQueryMatrixxOES(const Context *context,
                                   bool isCallValid,
                                   GLfixed *mantissa,
                                   GLint *exponent)
{
    ParamBuffer paramBuffer;

    ParamCapture mantissaParam("mantissa", ParamType::TGLfixedPointer);
    InitParamValue(ParamType::TGLfixedPointer, mantissa, &mantissaParam.value);
    CaptureQueryMatrixxOES_mantissa(context, isCallValid, mantissa, exponent, &mantissaParam);
    paramBuffer.addParam(std::move(mantissaParam));

    ParamCapture exponentParam("exponent", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, exponent, &exponentParam.value);
    CaptureQueryMatrixxOES_exponent(context, isCallValid, mantissa, exponent, &exponentParam);
    paramBuffer.addParam(std::move(exponentParam));

    return CallCapture("glQueryMatrixxOES", std::move(paramBuffer));
}

CallCapture CaptureCompressedTexImage3DOES(const Context *context,
                                           bool isCallValid,
                                           TextureTarget targetPacked,
                                           GLint level,
                                           GLenum internalformat,
                                           GLsizei width,
                                           GLsizei height,
                                           GLsizei depth,
                                           GLint border,
                                           GLsizei imageSize,
                                           const void *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("internalformat", ParamType::TGLenum, internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addValueParam("border", ParamType::TGLint, border);
    paramBuffer.addValueParam("imageSize", ParamType::TGLsizei, imageSize);

    ParamCapture dataParam("data", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, data, &dataParam.value);
    CaptureCompressedTexImage3DOES_data(context, isCallValid, targetPacked, level, internalformat,
                                        width, height, depth, border, imageSize, data, &dataParam);
    paramBuffer.addParam(std::move(dataParam));

    return CallCapture("glCompressedTexImage3DOES", std::move(paramBuffer));
}

CallCapture CaptureCompressedTexSubImage3DOES(const Context *context,
                                              bool isCallValid,
                                              TextureTarget targetPacked,
                                              GLint level,
                                              GLint xoffset,
                                              GLint yoffset,
                                              GLint zoffset,
                                              GLsizei width,
                                              GLsizei height,
                                              GLsizei depth,
                                              GLenum format,
                                              GLsizei imageSize,
                                              const void *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLint, yoffset);
    paramBuffer.addValueParam("zoffset", ParamType::TGLint, zoffset);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addValueParam("format", ParamType::TGLenum, format);
    paramBuffer.addValueParam("imageSize", ParamType::TGLsizei, imageSize);

    ParamCapture dataParam("data", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, data, &dataParam.value);
    CaptureCompressedTexSubImage3DOES_data(context, isCallValid, targetPacked, level, xoffset,
                                           yoffset, zoffset, width, height, depth, format,
                                           imageSize, data, &dataParam);
    paramBuffer.addParam(std::move(dataParam));

    return CallCapture("glCompressedTexSubImage3DOES", std::move(paramBuffer));
}

CallCapture CaptureCopyTexSubImage3DOES(const Context *context,
                                        bool isCallValid,
                                        TextureTarget targetPacked,
                                        GLint level,
                                        GLint xoffset,
                                        GLint yoffset,
                                        GLint zoffset,
                                        GLint x,
                                        GLint y,
                                        GLsizei width,
                                        GLsizei height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLint, yoffset);
    paramBuffer.addValueParam("zoffset", ParamType::TGLint, zoffset);
    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);

    return CallCapture("glCopyTexSubImage3DOES", std::move(paramBuffer));
}

CallCapture CaptureFramebufferTexture3DOES(const Context *context,
                                           bool isCallValid,
                                           GLenum target,
                                           GLenum attachment,
                                           TextureTarget textargetPacked,
                                           GLuint texture,
                                           GLint level,
                                           GLint zoffset)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("target", ParamType::TGLenum, target);
    paramBuffer.addValueParam("attachment", ParamType::TGLenum, attachment);
    paramBuffer.addValueParam("textargetPacked", ParamType::TTextureTarget, textargetPacked);
    paramBuffer.addValueParam("texture", ParamType::TGLuint, texture);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("zoffset", ParamType::TGLint, zoffset);

    return CallCapture("glFramebufferTexture3DOES", std::move(paramBuffer));
}

CallCapture CaptureTexImage3DOES(const Context *context,
                                 bool isCallValid,
                                 TextureTarget targetPacked,
                                 GLint level,
                                 GLenum internalformat,
                                 GLsizei width,
                                 GLsizei height,
                                 GLsizei depth,
                                 GLint border,
                                 GLenum format,
                                 GLenum type,
                                 const void *pixels)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("internalformat", ParamType::TGLenum, internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addValueParam("border", ParamType::TGLint, border);
    paramBuffer.addValueParam("format", ParamType::TGLenum, format);
    paramBuffer.addValueParam("type", ParamType::TGLenum, type);

    ParamCapture pixelsParam("pixels", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, pixels, &pixelsParam.value);
    CaptureTexImage3DOES_pixels(context, isCallValid, targetPacked, level, internalformat, width,
                                height, depth, border, format, type, pixels, &pixelsParam);
    paramBuffer.addParam(std::move(pixelsParam));

    return CallCapture("glTexImage3DOES", std::move(paramBuffer));
}

CallCapture CaptureTexSubImage3DOES(const Context *context,
                                    bool isCallValid,
                                    TextureTarget targetPacked,
                                    GLint level,
                                    GLint xoffset,
                                    GLint yoffset,
                                    GLint zoffset,
                                    GLsizei width,
                                    GLsizei height,
                                    GLsizei depth,
                                    GLenum format,
                                    GLenum type,
                                    const void *pixels)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLint, yoffset);
    paramBuffer.addValueParam("zoffset", ParamType::TGLint, zoffset);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addValueParam("format", ParamType::TGLenum, format);
    paramBuffer.addValueParam("type", ParamType::TGLenum, type);

    ParamCapture pixelsParam("pixels", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, pixels, &pixelsParam.value);
    CaptureTexSubImage3DOES_pixels(context, isCallValid, targetPacked, level, xoffset, yoffset,
                                   zoffset, width, height, depth, format, type, pixels,
                                   &pixelsParam);
    paramBuffer.addParam(std::move(pixelsParam));

    return CallCapture("glTexSubImage3DOES", std::move(paramBuffer));
}

CallCapture CaptureGetSamplerParameterIivOES(const Context *context,
                                             bool isCallValid,
                                             GLuint sampler,
                                             GLenum pname,
                                             GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("sampler", ParamType::TGLuint, sampler);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetSamplerParameterIivOES_params(context, isCallValid, sampler, pname, params,
                                            &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetSamplerParameterIivOES", std::move(paramBuffer));
}

CallCapture CaptureGetSamplerParameterIuivOES(const Context *context,
                                              bool isCallValid,
                                              GLuint sampler,
                                              GLenum pname,
                                              GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("sampler", ParamType::TGLuint, sampler);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLuintPointer);
    InitParamValue(ParamType::TGLuintPointer, params, &paramsParam.value);
    CaptureGetSamplerParameterIuivOES_params(context, isCallValid, sampler, pname, params,
                                             &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetSamplerParameterIuivOES", std::move(paramBuffer));
}

CallCapture CaptureGetTexParameterIivOES(const Context *context,
                                         bool isCallValid,
                                         TextureType targetPacked,
                                         GLenum pname,
                                         GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetTexParameterIivOES_params(context, isCallValid, targetPacked, pname, params,
                                        &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetTexParameterIivOES", std::move(paramBuffer));
}

CallCapture CaptureGetTexParameterIuivOES(const Context *context,
                                          bool isCallValid,
                                          TextureType targetPacked,
                                          GLenum pname,
                                          GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLuintPointer);
    InitParamValue(ParamType::TGLuintPointer, params, &paramsParam.value);
    CaptureGetTexParameterIuivOES_params(context, isCallValid, targetPacked, pname, params,
                                         &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetTexParameterIuivOES", std::move(paramBuffer));
}

CallCapture CaptureSamplerParameterIivOES(const Context *context,
                                          bool isCallValid,
                                          GLuint sampler,
                                          GLenum pname,
                                          const GLint *param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("sampler", ParamType::TGLuint, sampler);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);

    ParamCapture paramParam("param", ParamType::TGLintConstPointer);
    InitParamValue(ParamType::TGLintConstPointer, param, &paramParam.value);
    CaptureSamplerParameterIivOES_param(context, isCallValid, sampler, pname, param, &paramParam);
    paramBuffer.addParam(std::move(paramParam));

    return CallCapture("glSamplerParameterIivOES", std::move(paramBuffer));
}

CallCapture CaptureSamplerParameterIuivOES(const Context *context,
                                           bool isCallValid,
                                           GLuint sampler,
                                           GLenum pname,
                                           const GLuint *param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("sampler", ParamType::TGLuint, sampler);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);

    ParamCapture paramParam("param", ParamType::TGLuintConstPointer);
    InitParamValue(ParamType::TGLuintConstPointer, param, &paramParam.value);
    CaptureSamplerParameterIuivOES_param(context, isCallValid, sampler, pname, param, &paramParam);
    paramBuffer.addParam(std::move(paramParam));

    return CallCapture("glSamplerParameterIuivOES", std::move(paramBuffer));
}

CallCapture CaptureTexParameterIivOES(const Context *context,
                                      bool isCallValid,
                                      TextureType targetPacked,
                                      GLenum pname,
                                      const GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintConstPointer);
    InitParamValue(ParamType::TGLintConstPointer, params, &paramsParam.value);
    CaptureTexParameterIivOES_params(context, isCallValid, targetPacked, pname, params,
                                     &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glTexParameterIivOES", std::move(paramBuffer));
}

CallCapture CaptureTexParameterIuivOES(const Context *context,
                                       bool isCallValid,
                                       TextureType targetPacked,
                                       GLenum pname,
                                       const GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLuintConstPointer);
    InitParamValue(ParamType::TGLuintConstPointer, params, &paramsParam.value);
    CaptureTexParameterIuivOES_params(context, isCallValid, targetPacked, pname, params,
                                      &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glTexParameterIuivOES", std::move(paramBuffer));
}

CallCapture CaptureGetTexGenfvOES(const Context *context,
                                  bool isCallValid,
                                  GLenum coord,
                                  GLenum pname,
                                  GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("coord", ParamType::TGLenum, coord);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
    InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
    CaptureGetTexGenfvOES_params(context, isCallValid, coord, pname, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetTexGenfvOES", std::move(paramBuffer));
}

CallCapture CaptureGetTexGenivOES(const Context *context,
                                  bool isCallValid,
                                  GLenum coord,
                                  GLenum pname,
                                  GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("coord", ParamType::TGLenum, coord);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetTexGenivOES_params(context, isCallValid, coord, pname, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetTexGenivOES", std::move(paramBuffer));
}

CallCapture CaptureGetTexGenxvOES(const Context *context,
                                  bool isCallValid,
                                  GLenum coord,
                                  GLenum pname,
                                  GLfixed *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("coord", ParamType::TGLenum, coord);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLfixedPointer);
    InitParamValue(ParamType::TGLfixedPointer, params, &paramsParam.value);
    CaptureGetTexGenxvOES_params(context, isCallValid, coord, pname, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glGetTexGenxvOES", std::move(paramBuffer));
}

CallCapture CaptureTexGenfOES(const Context *context,
                              bool isCallValid,
                              GLenum coord,
                              GLenum pname,
                              GLfloat param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("coord", ParamType::TGLenum, coord);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);
    paramBuffer.addValueParam("param", ParamType::TGLfloat, param);

    return CallCapture("glTexGenfOES", std::move(paramBuffer));
}

CallCapture CaptureTexGenfvOES(const Context *context,
                               bool isCallValid,
                               GLenum coord,
                               GLenum pname,
                               const GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("coord", ParamType::TGLenum, coord);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, params, &paramsParam.value);
    CaptureTexGenfvOES_params(context, isCallValid, coord, pname, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glTexGenfvOES", std::move(paramBuffer));
}

CallCapture CaptureTexGeniOES(const Context *context,
                              bool isCallValid,
                              GLenum coord,
                              GLenum pname,
                              GLint param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("coord", ParamType::TGLenum, coord);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);
    paramBuffer.addValueParam("param", ParamType::TGLint, param);

    return CallCapture("glTexGeniOES", std::move(paramBuffer));
}

CallCapture CaptureTexGenivOES(const Context *context,
                               bool isCallValid,
                               GLenum coord,
                               GLenum pname,
                               const GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("coord", ParamType::TGLenum, coord);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintConstPointer);
    InitParamValue(ParamType::TGLintConstPointer, params, &paramsParam.value);
    CaptureTexGenivOES_params(context, isCallValid, coord, pname, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glTexGenivOES", std::move(paramBuffer));
}

CallCapture CaptureTexGenxOES(const Context *context,
                              bool isCallValid,
                              GLenum coord,
                              GLenum pname,
                              GLfixed param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("coord", ParamType::TGLenum, coord);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);
    paramBuffer.addValueParam("param", ParamType::TGLfixed, param);

    return CallCapture("glTexGenxOES", std::move(paramBuffer));
}

CallCapture CaptureTexGenxvOES(const Context *context,
                               bool isCallValid,
                               GLenum coord,
                               GLenum pname,
                               const GLfixed *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("coord", ParamType::TGLenum, coord);
    paramBuffer.addValueParam("pname", ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLfixedConstPointer);
    InitParamValue(ParamType::TGLfixedConstPointer, params, &paramsParam.value);
    CaptureTexGenxvOES_params(context, isCallValid, coord, pname, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture("glTexGenxvOES", std::move(paramBuffer));
}

CallCapture CaptureTexStorage3DMultisampleOES(const Context *context,
                                              bool isCallValid,
                                              TextureType targetPacked,
                                              GLsizei samples,
                                              GLenum internalformat,
                                              GLsizei width,
                                              GLsizei height,
                                              GLsizei depth,
                                              GLboolean fixedsamplelocations)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("samples", ParamType::TGLsizei, samples);
    paramBuffer.addValueParam("internalformat", ParamType::TGLenum, internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addValueParam("fixedsamplelocations", ParamType::TGLboolean, fixedsamplelocations);

    return CallCapture("glTexStorage3DMultisampleOES", std::move(paramBuffer));
}

CallCapture CaptureBindVertexArrayOES(const Context *context, bool isCallValid, GLuint array)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("array", ParamType::TGLuint, array);

    return CallCapture("glBindVertexArrayOES", std::move(paramBuffer));
}

CallCapture CaptureDeleteVertexArraysOES(const Context *context,
                                         bool isCallValid,
                                         GLsizei n,
                                         const GLuint *arrays)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture arraysParam("arrays", ParamType::TGLuintConstPointer);
    InitParamValue(ParamType::TGLuintConstPointer, arrays, &arraysParam.value);
    CaptureDeleteVertexArraysOES_arrays(context, isCallValid, n, arrays, &arraysParam);
    paramBuffer.addParam(std::move(arraysParam));

    return CallCapture("glDeleteVertexArraysOES", std::move(paramBuffer));
}

CallCapture CaptureGenVertexArraysOES(const Context *context,
                                      bool isCallValid,
                                      GLsizei n,
                                      GLuint *arrays)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture arraysParam("arrays", ParamType::TGLuintPointer);
    InitParamValue(ParamType::TGLuintPointer, arrays, &arraysParam.value);
    CaptureGenVertexArraysOES_arrays(context, isCallValid, n, arrays, &arraysParam);
    paramBuffer.addParam(std::move(arraysParam));

    return CallCapture("glGenVertexArraysOES", std::move(paramBuffer));
}

CallCapture CaptureIsVertexArrayOES(const Context *context, bool isCallValid, GLuint array)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("array", ParamType::TGLuint, array);

    return CallCapture("glIsVertexArrayOES", std::move(paramBuffer));
}

CallCapture CaptureFramebufferTextureMultiviewOVR(const Context *context,
                                                  bool isCallValid,
                                                  GLenum target,
                                                  GLenum attachment,
                                                  GLuint texture,
                                                  GLint level,
                                                  GLint baseViewIndex,
                                                  GLsizei numViews)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("target", ParamType::TGLenum, target);
    paramBuffer.addValueParam("attachment", ParamType::TGLenum, attachment);
    paramBuffer.addValueParam("texture", ParamType::TGLuint, texture);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("baseViewIndex", ParamType::TGLint, baseViewIndex);
    paramBuffer.addValueParam("numViews", ParamType::TGLsizei, numViews);

    return CallCapture("glFramebufferTextureMultiviewOVR", std::move(paramBuffer));
}

}  // namespace gl
