// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from gl.xml.
//
// Copyright 2019 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// entry_points_gl_1_0_autogen.cpp:
//   Defines the GL 1.0 entry points.

#include "libGL/entry_points_gl_1_0_autogen.h"

#include "libANGLE/Context.h"
#include "libANGLE/Context.inl.h"
#include "libANGLE/entry_points_utils.h"
#include "libANGLE/validationEGL.h"
#include "libANGLE/validationES.h"
#include "libANGLE/validationES1.h"
#include "libANGLE/validationES2.h"
#include "libANGLE/validationES3.h"
#include "libANGLE/validationES31.h"
#include "libANGLE/validationESEXT.h"
#include "libANGLE/validationGL1_autogen.h"
#include "libGLESv2/global_state.h"

namespace gl
{
void GL_APIENTRY Accum(GLenum op, GLfloat value)
{
    EVENT("(GLenum op = 0x%X, GLfloat value = %f)", op, value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Accum, context, op, value);
        if (context->skipValidation() || ValidateAccum(context, op, value))
        {
            context->accum(op, value);
        }
    }
}

void GL_APIENTRY AlphaFunc(GLenum func, GLfloat ref)
{
    EVENT("(GLenum func = 0x%X, GLfloat ref = %f)", func, ref);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        AlphaTestFunc funcPacked = FromGLenum<AlphaTestFunc>(func);
        ANGLE_CAPTURE(AlphaFunc, context, funcPacked, ref);
        if (context->skipValidation() || ValidateAlphaFunc(context, funcPacked, ref))
        {
            context->alphaFunc(funcPacked, ref);
        }
    }
}

void GL_APIENTRY Begin(GLenum mode)
{
    EVENT("(GLenum mode = 0x%X)", mode);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Begin, context, mode);
        if (context->skipValidation() || ValidateBegin(context, mode))
        {
            context->begin(mode);
        }
    }
}

void GL_APIENTRY Bitmap(GLsizei width,
                        GLsizei height,
                        GLfloat xorig,
                        GLfloat yorig,
                        GLfloat xmove,
                        GLfloat ymove,
                        const GLubyte *bitmap)
{
    EVENT(
        "(GLsizei width = %d, GLsizei height = %d, GLfloat xorig = %f, GLfloat yorig = %f, GLfloat "
        "xmove = %f, GLfloat ymove = %f, const GLubyte *bitmap = 0x%016" PRIxPTR ")",
        width, height, xorig, yorig, xmove, ymove, (uintptr_t)bitmap);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Bitmap, context, width, height, xorig, yorig, xmove, ymove, bitmap);
        if (context->skipValidation() ||
            ValidateBitmap(context, width, height, xorig, yorig, xmove, ymove, bitmap))
        {
            context->bitmap(width, height, xorig, yorig, xmove, ymove, bitmap);
        }
    }
}

void GL_APIENTRY BlendFunc(GLenum sfactor, GLenum dfactor)
{
    EVENT("(GLenum sfactor = 0x%X, GLenum dfactor = 0x%X)", sfactor, dfactor);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(BlendFunc, context, sfactor, dfactor);
        if (context->skipValidation() || ValidateBlendFunc(context, sfactor, dfactor))
        {
            context->blendFunc(sfactor, dfactor);
        }
    }
}

void GL_APIENTRY CallList(GLuint list)
{
    EVENT("(GLuint list = %u)", list);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(CallList, context, list);
        if (context->skipValidation() || ValidateCallList(context, list))
        {
            context->callList(list);
        }
    }
}

void GL_APIENTRY CallLists(GLsizei n, GLenum type, const void *lists)
{
    EVENT("(GLsizei n = %d, GLenum type = 0x%X, const void *lists = 0x%016" PRIxPTR ")", n, type,
          (uintptr_t)lists);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(CallLists, context, n, type, lists);
        if (context->skipValidation() || ValidateCallLists(context, n, type, lists))
        {
            context->callLists(n, type, lists);
        }
    }
}

void GL_APIENTRY Clear(GLbitfield mask)
{
    EVENT("(GLbitfield mask = 0x%X)", mask);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Clear, context, mask);
        if (context->skipValidation() || ValidateClear(context, mask))
        {
            context->clear(mask);
        }
    }
}

void GL_APIENTRY ClearAccum(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)
{
    EVENT("(GLfloat red = %f, GLfloat green = %f, GLfloat blue = %f, GLfloat alpha = %f)", red,
          green, blue, alpha);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(ClearAccum, context, red, green, blue, alpha);
        if (context->skipValidation() || ValidateClearAccum(context, red, green, blue, alpha))
        {
            context->clearAccum(red, green, blue, alpha);
        }
    }
}

void GL_APIENTRY ClearColor(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)
{
    EVENT("(GLfloat red = %f, GLfloat green = %f, GLfloat blue = %f, GLfloat alpha = %f)", red,
          green, blue, alpha);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(ClearColor, context, red, green, blue, alpha);
        if (context->skipValidation() || ValidateClearColor(context, red, green, blue, alpha))
        {
            context->clearColor(red, green, blue, alpha);
        }
    }
}

void GL_APIENTRY ClearDepth(GLdouble depth)
{
    EVENT("(GLdouble depth = %f)", depth);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(ClearDepth, context, depth);
        if (context->skipValidation() || ValidateClearDepth(context, depth))
        {
            context->clearDepth(depth);
        }
    }
}

void GL_APIENTRY ClearIndex(GLfloat c)
{
    EVENT("(GLfloat c = %f)", c);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(ClearIndex, context, c);
        if (context->skipValidation() || ValidateClearIndex(context, c))
        {
            context->clearIndex(c);
        }
    }
}

void GL_APIENTRY ClearStencil(GLint s)
{
    EVENT("(GLint s = %d)", s);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(ClearStencil, context, s);
        if (context->skipValidation() || ValidateClearStencil(context, s))
        {
            context->clearStencil(s);
        }
    }
}

void GL_APIENTRY ClipPlane(GLenum plane, const GLdouble *equation)
{
    EVENT("(GLenum plane = 0x%X, const GLdouble *equation = 0x%016" PRIxPTR ")", plane,
          (uintptr_t)equation);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(ClipPlane, context, plane, equation);
        if (context->skipValidation() || ValidateClipPlane(context, plane, equation))
        {
            context->clipPlane(plane, equation);
        }
    }
}

void GL_APIENTRY Color3b(GLbyte red, GLbyte green, GLbyte blue)
{
    EVENT("(GLbyte red = %d, GLbyte green = %d, GLbyte blue = %d)", red, green, blue);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Color3b, context, red, green, blue);
        if (context->skipValidation() || ValidateColor3b(context, red, green, blue))
        {
            context->color3b(red, green, blue);
        }
    }
}

void GL_APIENTRY Color3bv(const GLbyte *v)
{
    EVENT("(const GLbyte *v = 0x%016" PRIxPTR ")", (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Color3bv, context, v);
        if (context->skipValidation() || ValidateColor3bv(context, v))
        {
            context->color3bv(v);
        }
    }
}

void GL_APIENTRY Color3d(GLdouble red, GLdouble green, GLdouble blue)
{
    EVENT("(GLdouble red = %f, GLdouble green = %f, GLdouble blue = %f)", red, green, blue);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Color3d, context, red, green, blue);
        if (context->skipValidation() || ValidateColor3d(context, red, green, blue))
        {
            context->color3d(red, green, blue);
        }
    }
}

void GL_APIENTRY Color3dv(const GLdouble *v)
{
    EVENT("(const GLdouble *v = 0x%016" PRIxPTR ")", (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Color3dv, context, v);
        if (context->skipValidation() || ValidateColor3dv(context, v))
        {
            context->color3dv(v);
        }
    }
}

void GL_APIENTRY Color3f(GLfloat red, GLfloat green, GLfloat blue)
{
    EVENT("(GLfloat red = %f, GLfloat green = %f, GLfloat blue = %f)", red, green, blue);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Color3f, context, red, green, blue);
        if (context->skipValidation() || ValidateColor3f(context, red, green, blue))
        {
            context->color3f(red, green, blue);
        }
    }
}

void GL_APIENTRY Color3fv(const GLfloat *v)
{
    EVENT("(const GLfloat *v = 0x%016" PRIxPTR ")", (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Color3fv, context, v);
        if (context->skipValidation() || ValidateColor3fv(context, v))
        {
            context->color3fv(v);
        }
    }
}

void GL_APIENTRY Color3i(GLint red, GLint green, GLint blue)
{
    EVENT("(GLint red = %d, GLint green = %d, GLint blue = %d)", red, green, blue);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Color3i, context, red, green, blue);
        if (context->skipValidation() || ValidateColor3i(context, red, green, blue))
        {
            context->color3i(red, green, blue);
        }
    }
}

void GL_APIENTRY Color3iv(const GLint *v)
{
    EVENT("(const GLint *v = 0x%016" PRIxPTR ")", (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Color3iv, context, v);
        if (context->skipValidation() || ValidateColor3iv(context, v))
        {
            context->color3iv(v);
        }
    }
}

void GL_APIENTRY Color3s(GLshort red, GLshort green, GLshort blue)
{
    EVENT("(GLshort red = %d, GLshort green = %d, GLshort blue = %d)", red, green, blue);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Color3s, context, red, green, blue);
        if (context->skipValidation() || ValidateColor3s(context, red, green, blue))
        {
            context->color3s(red, green, blue);
        }
    }
}

void GL_APIENTRY Color3sv(const GLshort *v)
{
    EVENT("(const GLshort *v = 0x%016" PRIxPTR ")", (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Color3sv, context, v);
        if (context->skipValidation() || ValidateColor3sv(context, v))
        {
            context->color3sv(v);
        }
    }
}

void GL_APIENTRY Color3ub(GLubyte red, GLubyte green, GLubyte blue)
{
    EVENT("(GLubyte red = %d, GLubyte green = %d, GLubyte blue = %d)", red, green, blue);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Color3ub, context, red, green, blue);
        if (context->skipValidation() || ValidateColor3ub(context, red, green, blue))
        {
            context->color3ub(red, green, blue);
        }
    }
}

void GL_APIENTRY Color3ubv(const GLubyte *v)
{
    EVENT("(const GLubyte *v = 0x%016" PRIxPTR ")", (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Color3ubv, context, v);
        if (context->skipValidation() || ValidateColor3ubv(context, v))
        {
            context->color3ubv(v);
        }
    }
}

void GL_APIENTRY Color3ui(GLuint red, GLuint green, GLuint blue)
{
    EVENT("(GLuint red = %u, GLuint green = %u, GLuint blue = %u)", red, green, blue);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Color3ui, context, red, green, blue);
        if (context->skipValidation() || ValidateColor3ui(context, red, green, blue))
        {
            context->color3ui(red, green, blue);
        }
    }
}

void GL_APIENTRY Color3uiv(const GLuint *v)
{
    EVENT("(const GLuint *v = 0x%016" PRIxPTR ")", (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Color3uiv, context, v);
        if (context->skipValidation() || ValidateColor3uiv(context, v))
        {
            context->color3uiv(v);
        }
    }
}

void GL_APIENTRY Color3us(GLushort red, GLushort green, GLushort blue)
{
    EVENT("(GLushort red = %u, GLushort green = %u, GLushort blue = %u)", red, green, blue);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Color3us, context, red, green, blue);
        if (context->skipValidation() || ValidateColor3us(context, red, green, blue))
        {
            context->color3us(red, green, blue);
        }
    }
}

void GL_APIENTRY Color3usv(const GLushort *v)
{
    EVENT("(const GLushort *v = 0x%016" PRIxPTR ")", (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Color3usv, context, v);
        if (context->skipValidation() || ValidateColor3usv(context, v))
        {
            context->color3usv(v);
        }
    }
}

void GL_APIENTRY Color4b(GLbyte red, GLbyte green, GLbyte blue, GLbyte alpha)
{
    EVENT("(GLbyte red = %d, GLbyte green = %d, GLbyte blue = %d, GLbyte alpha = %d)", red, green,
          blue, alpha);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Color4b, context, red, green, blue, alpha);
        if (context->skipValidation() || ValidateColor4b(context, red, green, blue, alpha))
        {
            context->color4b(red, green, blue, alpha);
        }
    }
}

void GL_APIENTRY Color4bv(const GLbyte *v)
{
    EVENT("(const GLbyte *v = 0x%016" PRIxPTR ")", (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Color4bv, context, v);
        if (context->skipValidation() || ValidateColor4bv(context, v))
        {
            context->color4bv(v);
        }
    }
}

void GL_APIENTRY Color4d(GLdouble red, GLdouble green, GLdouble blue, GLdouble alpha)
{
    EVENT("(GLdouble red = %f, GLdouble green = %f, GLdouble blue = %f, GLdouble alpha = %f)", red,
          green, blue, alpha);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Color4d, context, red, green, blue, alpha);
        if (context->skipValidation() || ValidateColor4d(context, red, green, blue, alpha))
        {
            context->color4d(red, green, blue, alpha);
        }
    }
}

void GL_APIENTRY Color4dv(const GLdouble *v)
{
    EVENT("(const GLdouble *v = 0x%016" PRIxPTR ")", (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Color4dv, context, v);
        if (context->skipValidation() || ValidateColor4dv(context, v))
        {
            context->color4dv(v);
        }
    }
}

void GL_APIENTRY Color4f(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)
{
    EVENT("(GLfloat red = %f, GLfloat green = %f, GLfloat blue = %f, GLfloat alpha = %f)", red,
          green, blue, alpha);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Color4f, context, red, green, blue, alpha);
        if (context->skipValidation() || ValidateColor4f(context, red, green, blue, alpha))
        {
            context->color4f(red, green, blue, alpha);
        }
    }
}

void GL_APIENTRY Color4fv(const GLfloat *v)
{
    EVENT("(const GLfloat *v = 0x%016" PRIxPTR ")", (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Color4fv, context, v);
        if (context->skipValidation() || ValidateColor4fv(context, v))
        {
            context->color4fv(v);
        }
    }
}

void GL_APIENTRY Color4i(GLint red, GLint green, GLint blue, GLint alpha)
{
    EVENT("(GLint red = %d, GLint green = %d, GLint blue = %d, GLint alpha = %d)", red, green, blue,
          alpha);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Color4i, context, red, green, blue, alpha);
        if (context->skipValidation() || ValidateColor4i(context, red, green, blue, alpha))
        {
            context->color4i(red, green, blue, alpha);
        }
    }
}

void GL_APIENTRY Color4iv(const GLint *v)
{
    EVENT("(const GLint *v = 0x%016" PRIxPTR ")", (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Color4iv, context, v);
        if (context->skipValidation() || ValidateColor4iv(context, v))
        {
            context->color4iv(v);
        }
    }
}

void GL_APIENTRY Color4s(GLshort red, GLshort green, GLshort blue, GLshort alpha)
{
    EVENT("(GLshort red = %d, GLshort green = %d, GLshort blue = %d, GLshort alpha = %d)", red,
          green, blue, alpha);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Color4s, context, red, green, blue, alpha);
        if (context->skipValidation() || ValidateColor4s(context, red, green, blue, alpha))
        {
            context->color4s(red, green, blue, alpha);
        }
    }
}

void GL_APIENTRY Color4sv(const GLshort *v)
{
    EVENT("(const GLshort *v = 0x%016" PRIxPTR ")", (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Color4sv, context, v);
        if (context->skipValidation() || ValidateColor4sv(context, v))
        {
            context->color4sv(v);
        }
    }
}

void GL_APIENTRY Color4ub(GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha)
{
    EVENT("(GLubyte red = %d, GLubyte green = %d, GLubyte blue = %d, GLubyte alpha = %d)", red,
          green, blue, alpha);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Color4ub, context, red, green, blue, alpha);
        if (context->skipValidation() || ValidateColor4ub(context, red, green, blue, alpha))
        {
            context->color4ub(red, green, blue, alpha);
        }
    }
}

void GL_APIENTRY Color4ubv(const GLubyte *v)
{
    EVENT("(const GLubyte *v = 0x%016" PRIxPTR ")", (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Color4ubv, context, v);
        if (context->skipValidation() || ValidateColor4ubv(context, v))
        {
            context->color4ubv(v);
        }
    }
}

void GL_APIENTRY Color4ui(GLuint red, GLuint green, GLuint blue, GLuint alpha)
{
    EVENT("(GLuint red = %u, GLuint green = %u, GLuint blue = %u, GLuint alpha = %u)", red, green,
          blue, alpha);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Color4ui, context, red, green, blue, alpha);
        if (context->skipValidation() || ValidateColor4ui(context, red, green, blue, alpha))
        {
            context->color4ui(red, green, blue, alpha);
        }
    }
}

void GL_APIENTRY Color4uiv(const GLuint *v)
{
    EVENT("(const GLuint *v = 0x%016" PRIxPTR ")", (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Color4uiv, context, v);
        if (context->skipValidation() || ValidateColor4uiv(context, v))
        {
            context->color4uiv(v);
        }
    }
}

void GL_APIENTRY Color4us(GLushort red, GLushort green, GLushort blue, GLushort alpha)
{
    EVENT("(GLushort red = %u, GLushort green = %u, GLushort blue = %u, GLushort alpha = %u)", red,
          green, blue, alpha);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Color4us, context, red, green, blue, alpha);
        if (context->skipValidation() || ValidateColor4us(context, red, green, blue, alpha))
        {
            context->color4us(red, green, blue, alpha);
        }
    }
}

void GL_APIENTRY Color4usv(const GLushort *v)
{
    EVENT("(const GLushort *v = 0x%016" PRIxPTR ")", (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Color4usv, context, v);
        if (context->skipValidation() || ValidateColor4usv(context, v))
        {
            context->color4usv(v);
        }
    }
}

void GL_APIENTRY ColorMask(GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha)
{
    EVENT("(GLboolean red = %u, GLboolean green = %u, GLboolean blue = %u, GLboolean alpha = %u)",
          red, green, blue, alpha);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(ColorMask, context, red, green, blue, alpha);
        if (context->skipValidation() || ValidateColorMask(context, red, green, blue, alpha))
        {
            context->colorMask(red, green, blue, alpha);
        }
    }
}

void GL_APIENTRY ColorMaterial(GLenum face, GLenum mode)
{
    EVENT("(GLenum face = 0x%X, GLenum mode = 0x%X)", face, mode);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(ColorMaterial, context, face, mode);
        if (context->skipValidation() || ValidateColorMaterial(context, face, mode))
        {
            context->colorMaterial(face, mode);
        }
    }
}

void GL_APIENTRY CopyPixels(GLint x, GLint y, GLsizei width, GLsizei height, GLenum type)
{
    EVENT(
        "(GLint x = %d, GLint y = %d, GLsizei width = %d, GLsizei height = %d, GLenum type = 0x%X)",
        x, y, width, height, type);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(CopyPixels, context, x, y, width, height, type);
        if (context->skipValidation() || ValidateCopyPixels(context, x, y, width, height, type))
        {
            context->copyPixels(x, y, width, height, type);
        }
    }
}

void GL_APIENTRY CullFace(GLenum mode)
{
    EVENT("(GLenum mode = 0x%X)", mode);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        CullFaceMode modePacked = FromGLenum<CullFaceMode>(mode);
        ANGLE_CAPTURE(CullFace, context, modePacked);
        if (context->skipValidation() || ValidateCullFace(context, modePacked))
        {
            context->cullFace(modePacked);
        }
    }
}

void GL_APIENTRY DeleteLists(GLuint list, GLsizei range)
{
    EVENT("(GLuint list = %u, GLsizei range = %d)", list, range);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(DeleteLists, context, list, range);
        if (context->skipValidation() || ValidateDeleteLists(context, list, range))
        {
            context->deleteLists(list, range);
        }
    }
}

void GL_APIENTRY DepthFunc(GLenum func)
{
    EVENT("(GLenum func = 0x%X)", func);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(DepthFunc, context, func);
        if (context->skipValidation() || ValidateDepthFunc(context, func))
        {
            context->depthFunc(func);
        }
    }
}

void GL_APIENTRY DepthMask(GLboolean flag)
{
    EVENT("(GLboolean flag = %u)", flag);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(DepthMask, context, flag);
        if (context->skipValidation() || ValidateDepthMask(context, flag))
        {
            context->depthMask(flag);
        }
    }
}

void GL_APIENTRY DepthRange(GLdouble n, GLdouble f)
{
    EVENT("(GLdouble n = %f, GLdouble f = %f)", n, f);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(DepthRange, context, n, f);
        if (context->skipValidation() || ValidateDepthRange(context, n, f))
        {
            context->depthRange(n, f);
        }
    }
}

void GL_APIENTRY Disable(GLenum cap)
{
    EVENT("(GLenum cap = 0x%X)", cap);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Disable, context, cap);
        if (context->skipValidation() || ValidateDisable(context, cap))
        {
            context->disable(cap);
        }
    }
}

void GL_APIENTRY DrawBuffer(GLenum buf)
{
    EVENT("(GLenum buf = 0x%X)", buf);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(DrawBuffer, context, buf);
        if (context->skipValidation() || ValidateDrawBuffer(context, buf))
        {
            context->drawBuffer(buf);
        }
    }
}

void GL_APIENTRY
DrawPixels(GLsizei width, GLsizei height, GLenum format, GLenum type, const void *pixels)
{
    EVENT(
        "(GLsizei width = %d, GLsizei height = %d, GLenum format = 0x%X, GLenum type = 0x%X, const "
        "void *pixels = 0x%016" PRIxPTR ")",
        width, height, format, type, (uintptr_t)pixels);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(DrawPixels, context, width, height, format, type, pixels);
        if (context->skipValidation() ||
            ValidateDrawPixels(context, width, height, format, type, pixels))
        {
            context->drawPixels(width, height, format, type, pixels);
        }
    }
}

void GL_APIENTRY EdgeFlag(GLboolean flag)
{
    EVENT("(GLboolean flag = %u)", flag);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(EdgeFlag, context, flag);
        if (context->skipValidation() || ValidateEdgeFlag(context, flag))
        {
            context->edgeFlag(flag);
        }
    }
}

void GL_APIENTRY EdgeFlagv(const GLboolean *flag)
{
    EVENT("(const GLboolean *flag = 0x%016" PRIxPTR ")", (uintptr_t)flag);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(EdgeFlagv, context, flag);
        if (context->skipValidation() || ValidateEdgeFlagv(context, flag))
        {
            context->edgeFlagv(flag);
        }
    }
}

void GL_APIENTRY Enable(GLenum cap)
{
    EVENT("(GLenum cap = 0x%X)", cap);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Enable, context, cap);
        if (context->skipValidation() || ValidateEnable(context, cap))
        {
            context->enable(cap);
        }
    }
}

void GL_APIENTRY End()
{
    EVENT("()");

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(End, context);
        if (context->skipValidation() || ValidateEnd(context))
        {
            context->end();
        }
    }
}

void GL_APIENTRY EndList()
{
    EVENT("()");

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(EndList, context);
        if (context->skipValidation() || ValidateEndList(context))
        {
            context->endList();
        }
    }
}

void GL_APIENTRY EvalCoord1d(GLdouble u)
{
    EVENT("(GLdouble u = %f)", u);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(EvalCoord1d, context, u);
        if (context->skipValidation() || ValidateEvalCoord1d(context, u))
        {
            context->evalCoord1d(u);
        }
    }
}

void GL_APIENTRY EvalCoord1dv(const GLdouble *u)
{
    EVENT("(const GLdouble *u = 0x%016" PRIxPTR ")", (uintptr_t)u);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(EvalCoord1dv, context, u);
        if (context->skipValidation() || ValidateEvalCoord1dv(context, u))
        {
            context->evalCoord1dv(u);
        }
    }
}

void GL_APIENTRY EvalCoord1f(GLfloat u)
{
    EVENT("(GLfloat u = %f)", u);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(EvalCoord1f, context, u);
        if (context->skipValidation() || ValidateEvalCoord1f(context, u))
        {
            context->evalCoord1f(u);
        }
    }
}

void GL_APIENTRY EvalCoord1fv(const GLfloat *u)
{
    EVENT("(const GLfloat *u = 0x%016" PRIxPTR ")", (uintptr_t)u);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(EvalCoord1fv, context, u);
        if (context->skipValidation() || ValidateEvalCoord1fv(context, u))
        {
            context->evalCoord1fv(u);
        }
    }
}

void GL_APIENTRY EvalCoord2d(GLdouble u, GLdouble v)
{
    EVENT("(GLdouble u = %f, GLdouble v = %f)", u, v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(EvalCoord2d, context, u, v);
        if (context->skipValidation() || ValidateEvalCoord2d(context, u, v))
        {
            context->evalCoord2d(u, v);
        }
    }
}

void GL_APIENTRY EvalCoord2dv(const GLdouble *u)
{
    EVENT("(const GLdouble *u = 0x%016" PRIxPTR ")", (uintptr_t)u);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(EvalCoord2dv, context, u);
        if (context->skipValidation() || ValidateEvalCoord2dv(context, u))
        {
            context->evalCoord2dv(u);
        }
    }
}

void GL_APIENTRY EvalCoord2f(GLfloat u, GLfloat v)
{
    EVENT("(GLfloat u = %f, GLfloat v = %f)", u, v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(EvalCoord2f, context, u, v);
        if (context->skipValidation() || ValidateEvalCoord2f(context, u, v))
        {
            context->evalCoord2f(u, v);
        }
    }
}

void GL_APIENTRY EvalCoord2fv(const GLfloat *u)
{
    EVENT("(const GLfloat *u = 0x%016" PRIxPTR ")", (uintptr_t)u);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(EvalCoord2fv, context, u);
        if (context->skipValidation() || ValidateEvalCoord2fv(context, u))
        {
            context->evalCoord2fv(u);
        }
    }
}

void GL_APIENTRY EvalMesh1(GLenum mode, GLint i1, GLint i2)
{
    EVENT("(GLenum mode = 0x%X, GLint i1 = %d, GLint i2 = %d)", mode, i1, i2);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(EvalMesh1, context, mode, i1, i2);
        if (context->skipValidation() || ValidateEvalMesh1(context, mode, i1, i2))
        {
            context->evalMesh1(mode, i1, i2);
        }
    }
}

void GL_APIENTRY EvalMesh2(GLenum mode, GLint i1, GLint i2, GLint j1, GLint j2)
{
    EVENT("(GLenum mode = 0x%X, GLint i1 = %d, GLint i2 = %d, GLint j1 = %d, GLint j2 = %d)", mode,
          i1, i2, j1, j2);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(EvalMesh2, context, mode, i1, i2, j1, j2);
        if (context->skipValidation() || ValidateEvalMesh2(context, mode, i1, i2, j1, j2))
        {
            context->evalMesh2(mode, i1, i2, j1, j2);
        }
    }
}

void GL_APIENTRY EvalPoint1(GLint i)
{
    EVENT("(GLint i = %d)", i);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(EvalPoint1, context, i);
        if (context->skipValidation() || ValidateEvalPoint1(context, i))
        {
            context->evalPoint1(i);
        }
    }
}

void GL_APIENTRY EvalPoint2(GLint i, GLint j)
{
    EVENT("(GLint i = %d, GLint j = %d)", i, j);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(EvalPoint2, context, i, j);
        if (context->skipValidation() || ValidateEvalPoint2(context, i, j))
        {
            context->evalPoint2(i, j);
        }
    }
}

void GL_APIENTRY FeedbackBuffer(GLsizei size, GLenum type, GLfloat *buffer)
{
    EVENT("(GLsizei size = %d, GLenum type = 0x%X, GLfloat *buffer = 0x%016" PRIxPTR ")", size,
          type, (uintptr_t)buffer);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(FeedbackBuffer, context, size, type, buffer);
        if (context->skipValidation() || ValidateFeedbackBuffer(context, size, type, buffer))
        {
            context->feedbackBuffer(size, type, buffer);
        }
    }
}

void GL_APIENTRY Finish()
{
    EVENT("()");

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Finish, context);
        if (context->skipValidation() || ValidateFinish(context))
        {
            context->finish();
        }
    }
}

void GL_APIENTRY Flush()
{
    EVENT("()");

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Flush, context);
        if (context->skipValidation() || ValidateFlush(context))
        {
            context->flush();
        }
    }
}

void GL_APIENTRY Fogf(GLenum pname, GLfloat param)
{
    EVENT("(GLenum pname = 0x%X, GLfloat param = %f)", pname, param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Fogf, context, pname, param);
        if (context->skipValidation() || ValidateFogf(context, pname, param))
        {
            context->fogf(pname, param);
        }
    }
}

void GL_APIENTRY Fogfv(GLenum pname, const GLfloat *params)
{
    EVENT("(GLenum pname = 0x%X, const GLfloat *params = 0x%016" PRIxPTR ")", pname,
          (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Fogfv, context, pname, params);
        if (context->skipValidation() || ValidateFogfv(context, pname, params))
        {
            context->fogfv(pname, params);
        }
    }
}

void GL_APIENTRY Fogi(GLenum pname, GLint param)
{
    EVENT("(GLenum pname = 0x%X, GLint param = %d)", pname, param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Fogi, context, pname, param);
        if (context->skipValidation() || ValidateFogi(context, pname, param))
        {
            context->fogi(pname, param);
        }
    }
}

void GL_APIENTRY Fogiv(GLenum pname, const GLint *params)
{
    EVENT("(GLenum pname = 0x%X, const GLint *params = 0x%016" PRIxPTR ")", pname,
          (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Fogiv, context, pname, params);
        if (context->skipValidation() || ValidateFogiv(context, pname, params))
        {
            context->fogiv(pname, params);
        }
    }
}

void GL_APIENTRY FrontFace(GLenum mode)
{
    EVENT("(GLenum mode = 0x%X)", mode);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(FrontFace, context, mode);
        if (context->skipValidation() || ValidateFrontFace(context, mode))
        {
            context->frontFace(mode);
        }
    }
}

void GL_APIENTRY
Frustum(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar)
{
    EVENT(
        "(GLdouble left = %f, GLdouble right = %f, GLdouble bottom = %f, GLdouble top = %f, "
        "GLdouble zNear = %f, GLdouble zFar = %f)",
        left, right, bottom, top, zNear, zFar);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Frustum, context, left, right, bottom, top, zNear, zFar);
        if (context->skipValidation() ||
            ValidateFrustum(context, left, right, bottom, top, zNear, zFar))
        {
            context->frustum(left, right, bottom, top, zNear, zFar);
        }
    }
}

GLuint GL_APIENTRY GenLists(GLsizei range)
{
    EVENT("(GLsizei range = %d)", range);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GenLists, context, range);
        if (context->skipValidation() || ValidateGenLists(context, range))
        {
            return context->genLists(range);
        }
    }

    return GetDefaultReturnValue<EntryPoint::GenLists, GLuint>();
}

void GL_APIENTRY GetBooleanv(GLenum pname, GLboolean *data)
{
    EVENT("(GLenum pname = 0x%X, GLboolean *data = 0x%016" PRIxPTR ")", pname, (uintptr_t)data);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetBooleanv, context, pname, data);
        if (context->skipValidation() || ValidateGetBooleanv(context, pname, data))
        {
            context->getBooleanv(pname, data);
        }
    }
}

void GL_APIENTRY GetClipPlane(GLenum plane, GLdouble *equation)
{
    EVENT("(GLenum plane = 0x%X, GLdouble *equation = 0x%016" PRIxPTR ")", plane,
          (uintptr_t)equation);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetClipPlane, context, plane, equation);
        if (context->skipValidation() || ValidateGetClipPlane(context, plane, equation))
        {
            context->getClipPlane(plane, equation);
        }
    }
}

void GL_APIENTRY GetDoublev(GLenum pname, GLdouble *data)
{
    EVENT("(GLenum pname = 0x%X, GLdouble *data = 0x%016" PRIxPTR ")", pname, (uintptr_t)data);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetDoublev, context, pname, data);
        if (context->skipValidation() || ValidateGetDoublev(context, pname, data))
        {
            context->getDoublev(pname, data);
        }
    }
}

GLenum GL_APIENTRY GetError()
{
    EVENT("()");

    Context *context = GetGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetError, context);
        if (context->skipValidation() || ValidateGetError(context))
        {
            return context->getError();
        }
    }

    return GetDefaultReturnValue<EntryPoint::GetError, GLenum>();
}

void GL_APIENTRY GetFloatv(GLenum pname, GLfloat *data)
{
    EVENT("(GLenum pname = 0x%X, GLfloat *data = 0x%016" PRIxPTR ")", pname, (uintptr_t)data);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetFloatv, context, pname, data);
        if (context->skipValidation() || ValidateGetFloatv(context, pname, data))
        {
            context->getFloatv(pname, data);
        }
    }
}

void GL_APIENTRY GetIntegerv(GLenum pname, GLint *data)
{
    EVENT("(GLenum pname = 0x%X, GLint *data = 0x%016" PRIxPTR ")", pname, (uintptr_t)data);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetIntegerv, context, pname, data);
        if (context->skipValidation() || ValidateGetIntegerv(context, pname, data))
        {
            context->getIntegerv(pname, data);
        }
    }
}

void GL_APIENTRY GetLightfv(GLenum light, GLenum pname, GLfloat *params)
{
    EVENT("(GLenum light = 0x%X, GLenum pname = 0x%X, GLfloat *params = 0x%016" PRIxPTR ")", light,
          pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        LightParameter pnamePacked = FromGLenum<LightParameter>(pname);
        ANGLE_CAPTURE(GetLightfv, context, light, pnamePacked, params);
        if (context->skipValidation() || ValidateGetLightfv(context, light, pnamePacked, params))
        {
            context->getLightfv(light, pnamePacked, params);
        }
    }
}

void GL_APIENTRY GetLightiv(GLenum light, GLenum pname, GLint *params)
{
    EVENT("(GLenum light = 0x%X, GLenum pname = 0x%X, GLint *params = 0x%016" PRIxPTR ")", light,
          pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetLightiv, context, light, pname, params);
        if (context->skipValidation() || ValidateGetLightiv(context, light, pname, params))
        {
            context->getLightiv(light, pname, params);
        }
    }
}

void GL_APIENTRY GetMapdv(GLenum target, GLenum query, GLdouble *v)
{
    EVENT("(GLenum target = 0x%X, GLenum query = 0x%X, GLdouble *v = 0x%016" PRIxPTR ")", target,
          query, (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetMapdv, context, target, query, v);
        if (context->skipValidation() || ValidateGetMapdv(context, target, query, v))
        {
            context->getMapdv(target, query, v);
        }
    }
}

void GL_APIENTRY GetMapfv(GLenum target, GLenum query, GLfloat *v)
{
    EVENT("(GLenum target = 0x%X, GLenum query = 0x%X, GLfloat *v = 0x%016" PRIxPTR ")", target,
          query, (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetMapfv, context, target, query, v);
        if (context->skipValidation() || ValidateGetMapfv(context, target, query, v))
        {
            context->getMapfv(target, query, v);
        }
    }
}

void GL_APIENTRY GetMapiv(GLenum target, GLenum query, GLint *v)
{
    EVENT("(GLenum target = 0x%X, GLenum query = 0x%X, GLint *v = 0x%016" PRIxPTR ")", target,
          query, (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetMapiv, context, target, query, v);
        if (context->skipValidation() || ValidateGetMapiv(context, target, query, v))
        {
            context->getMapiv(target, query, v);
        }
    }
}

void GL_APIENTRY GetMaterialfv(GLenum face, GLenum pname, GLfloat *params)
{
    EVENT("(GLenum face = 0x%X, GLenum pname = 0x%X, GLfloat *params = 0x%016" PRIxPTR ")", face,
          pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        MaterialParameter pnamePacked = FromGLenum<MaterialParameter>(pname);
        ANGLE_CAPTURE(GetMaterialfv, context, face, pnamePacked, params);
        if (context->skipValidation() || ValidateGetMaterialfv(context, face, pnamePacked, params))
        {
            context->getMaterialfv(face, pnamePacked, params);
        }
    }
}

void GL_APIENTRY GetMaterialiv(GLenum face, GLenum pname, GLint *params)
{
    EVENT("(GLenum face = 0x%X, GLenum pname = 0x%X, GLint *params = 0x%016" PRIxPTR ")", face,
          pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetMaterialiv, context, face, pname, params);
        if (context->skipValidation() || ValidateGetMaterialiv(context, face, pname, params))
        {
            context->getMaterialiv(face, pname, params);
        }
    }
}

void GL_APIENTRY GetPixelMapfv(GLenum map, GLfloat *values)
{
    EVENT("(GLenum map = 0x%X, GLfloat *values = 0x%016" PRIxPTR ")", map, (uintptr_t)values);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetPixelMapfv, context, map, values);
        if (context->skipValidation() || ValidateGetPixelMapfv(context, map, values))
        {
            context->getPixelMapfv(map, values);
        }
    }
}

void GL_APIENTRY GetPixelMapuiv(GLenum map, GLuint *values)
{
    EVENT("(GLenum map = 0x%X, GLuint *values = 0x%016" PRIxPTR ")", map, (uintptr_t)values);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetPixelMapuiv, context, map, values);
        if (context->skipValidation() || ValidateGetPixelMapuiv(context, map, values))
        {
            context->getPixelMapuiv(map, values);
        }
    }
}

void GL_APIENTRY GetPixelMapusv(GLenum map, GLushort *values)
{
    EVENT("(GLenum map = 0x%X, GLushort *values = 0x%016" PRIxPTR ")", map, (uintptr_t)values);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetPixelMapusv, context, map, values);
        if (context->skipValidation() || ValidateGetPixelMapusv(context, map, values))
        {
            context->getPixelMapusv(map, values);
        }
    }
}

void GL_APIENTRY GetPolygonStipple(GLubyte *mask)
{
    EVENT("(GLubyte *mask = 0x%016" PRIxPTR ")", (uintptr_t)mask);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetPolygonStipple, context, mask);
        if (context->skipValidation() || ValidateGetPolygonStipple(context, mask))
        {
            context->getPolygonStipple(mask);
        }
    }
}

const GLubyte *GL_APIENTRY GetString(GLenum name)
{
    EVENT("(GLenum name = 0x%X)", name);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetString, context, name);
        if (context->skipValidation() || ValidateGetString(context, name))
        {
            return context->getString(name);
        }
    }

    return GetDefaultReturnValue<EntryPoint::GetString, const GLubyte *>();
}

void GL_APIENTRY GetTexEnvfv(GLenum target, GLenum pname, GLfloat *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLfloat *params = 0x%016" PRIxPTR ")",
          target, pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureEnvTarget targetPacked   = FromGLenum<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked = FromGLenum<TextureEnvParameter>(pname);
        ANGLE_CAPTURE(GetTexEnvfv, context, targetPacked, pnamePacked, params);
        if (context->skipValidation() ||
            ValidateGetTexEnvfv(context, targetPacked, pnamePacked, params))
        {
            context->getTexEnvfv(targetPacked, pnamePacked, params);
        }
    }
}

void GL_APIENTRY GetTexEnviv(GLenum target, GLenum pname, GLint *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLint *params = 0x%016" PRIxPTR ")", target,
          pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureEnvTarget targetPacked   = FromGLenum<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked = FromGLenum<TextureEnvParameter>(pname);
        ANGLE_CAPTURE(GetTexEnviv, context, targetPacked, pnamePacked, params);
        if (context->skipValidation() ||
            ValidateGetTexEnviv(context, targetPacked, pnamePacked, params))
        {
            context->getTexEnviv(targetPacked, pnamePacked, params);
        }
    }
}

void GL_APIENTRY GetTexGendv(GLenum coord, GLenum pname, GLdouble *params)
{
    EVENT("(GLenum coord = 0x%X, GLenum pname = 0x%X, GLdouble *params = 0x%016" PRIxPTR ")", coord,
          pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetTexGendv, context, coord, pname, params);
        if (context->skipValidation() || ValidateGetTexGendv(context, coord, pname, params))
        {
            context->getTexGendv(coord, pname, params);
        }
    }
}

void GL_APIENTRY GetTexGenfv(GLenum coord, GLenum pname, GLfloat *params)
{
    EVENT("(GLenum coord = 0x%X, GLenum pname = 0x%X, GLfloat *params = 0x%016" PRIxPTR ")", coord,
          pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetTexGenfv, context, coord, pname, params);
        if (context->skipValidation() || ValidateGetTexGenfv(context, coord, pname, params))
        {
            context->getTexGenfv(coord, pname, params);
        }
    }
}

void GL_APIENTRY GetTexGeniv(GLenum coord, GLenum pname, GLint *params)
{
    EVENT("(GLenum coord = 0x%X, GLenum pname = 0x%X, GLint *params = 0x%016" PRIxPTR ")", coord,
          pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetTexGeniv, context, coord, pname, params);
        if (context->skipValidation() || ValidateGetTexGeniv(context, coord, pname, params))
        {
            context->getTexGeniv(coord, pname, params);
        }
    }
}

void GL_APIENTRY GetTexImage(GLenum target, GLint level, GLenum format, GLenum type, void *pixels)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLenum format = 0x%X, GLenum type = 0x%X, void "
        "*pixels = 0x%016" PRIxPTR ")",
        target, level, format, type, (uintptr_t)pixels);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetTexImage, context, target, level, format, type, pixels);
        if (context->skipValidation() ||
            ValidateGetTexImage(context, target, level, format, type, pixels))
        {
            context->getTexImage(target, level, format, type, pixels);
        }
    }
}

void GL_APIENTRY GetTexLevelParameterfv(GLenum target, GLint level, GLenum pname, GLfloat *params)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLenum pname = 0x%X, GLfloat *params = "
        "0x%016" PRIxPTR ")",
        target, level, pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        ANGLE_CAPTURE(GetTexLevelParameterfv, context, targetPacked, level, pname, params);
        if (context->skipValidation() ||
            ValidateGetTexLevelParameterfv(context, targetPacked, level, pname, params))
        {
            context->getTexLevelParameterfv(targetPacked, level, pname, params);
        }
    }
}

void GL_APIENTRY GetTexLevelParameteriv(GLenum target, GLint level, GLenum pname, GLint *params)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLenum pname = 0x%X, GLint *params = "
        "0x%016" PRIxPTR ")",
        target, level, pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        ANGLE_CAPTURE(GetTexLevelParameteriv, context, targetPacked, level, pname, params);
        if (context->skipValidation() ||
            ValidateGetTexLevelParameteriv(context, targetPacked, level, pname, params))
        {
            context->getTexLevelParameteriv(targetPacked, level, pname, params);
        }
    }
}

void GL_APIENTRY GetTexParameterfv(GLenum target, GLenum pname, GLfloat *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLfloat *params = 0x%016" PRIxPTR ")",
          target, pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(GetTexParameterfv, context, targetPacked, pname, params);
        if (context->skipValidation() ||
            ValidateGetTexParameterfv(context, targetPacked, pname, params))
        {
            context->getTexParameterfv(targetPacked, pname, params);
        }
    }
}

void GL_APIENTRY GetTexParameteriv(GLenum target, GLenum pname, GLint *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLint *params = 0x%016" PRIxPTR ")", target,
          pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(GetTexParameteriv, context, targetPacked, pname, params);
        if (context->skipValidation() ||
            ValidateGetTexParameteriv(context, targetPacked, pname, params))
        {
            context->getTexParameteriv(targetPacked, pname, params);
        }
    }
}

void GL_APIENTRY Hint(GLenum target, GLenum mode)
{
    EVENT("(GLenum target = 0x%X, GLenum mode = 0x%X)", target, mode);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Hint, context, target, mode);
        if (context->skipValidation() || ValidateHint(context, target, mode))
        {
            context->hint(target, mode);
        }
    }
}

void GL_APIENTRY IndexMask(GLuint mask)
{
    EVENT("(GLuint mask = %u)", mask);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(IndexMask, context, mask);
        if (context->skipValidation() || ValidateIndexMask(context, mask))
        {
            context->indexMask(mask);
        }
    }
}

void GL_APIENTRY Indexd(GLdouble c)
{
    EVENT("(GLdouble c = %f)", c);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Indexd, context, c);
        if (context->skipValidation() || ValidateIndexd(context, c))
        {
            context->indexd(c);
        }
    }
}

void GL_APIENTRY Indexdv(const GLdouble *c)
{
    EVENT("(const GLdouble *c = 0x%016" PRIxPTR ")", (uintptr_t)c);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Indexdv, context, c);
        if (context->skipValidation() || ValidateIndexdv(context, c))
        {
            context->indexdv(c);
        }
    }
}

void GL_APIENTRY Indexf(GLfloat c)
{
    EVENT("(GLfloat c = %f)", c);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Indexf, context, c);
        if (context->skipValidation() || ValidateIndexf(context, c))
        {
            context->indexf(c);
        }
    }
}

void GL_APIENTRY Indexfv(const GLfloat *c)
{
    EVENT("(const GLfloat *c = 0x%016" PRIxPTR ")", (uintptr_t)c);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Indexfv, context, c);
        if (context->skipValidation() || ValidateIndexfv(context, c))
        {
            context->indexfv(c);
        }
    }
}

void GL_APIENTRY Indexi(GLint c)
{
    EVENT("(GLint c = %d)", c);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Indexi, context, c);
        if (context->skipValidation() || ValidateIndexi(context, c))
        {
            context->indexi(c);
        }
    }
}

void GL_APIENTRY Indexiv(const GLint *c)
{
    EVENT("(const GLint *c = 0x%016" PRIxPTR ")", (uintptr_t)c);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Indexiv, context, c);
        if (context->skipValidation() || ValidateIndexiv(context, c))
        {
            context->indexiv(c);
        }
    }
}

void GL_APIENTRY Indexs(GLshort c)
{
    EVENT("(GLshort c = %d)", c);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Indexs, context, c);
        if (context->skipValidation() || ValidateIndexs(context, c))
        {
            context->indexs(c);
        }
    }
}

void GL_APIENTRY Indexsv(const GLshort *c)
{
    EVENT("(const GLshort *c = 0x%016" PRIxPTR ")", (uintptr_t)c);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Indexsv, context, c);
        if (context->skipValidation() || ValidateIndexsv(context, c))
        {
            context->indexsv(c);
        }
    }
}

void GL_APIENTRY InitNames()
{
    EVENT("()");

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(InitNames, context);
        if (context->skipValidation() || ValidateInitNames(context))
        {
            context->initNames();
        }
    }
}

GLboolean GL_APIENTRY IsEnabled(GLenum cap)
{
    EVENT("(GLenum cap = 0x%X)", cap);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(IsEnabled, context, cap);
        if (context->skipValidation() || ValidateIsEnabled(context, cap))
        {
            return context->isEnabled(cap);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsEnabled, GLboolean>();
}

GLboolean GL_APIENTRY IsList(GLuint list)
{
    EVENT("(GLuint list = %u)", list);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(IsList, context, list);
        if (context->skipValidation() || ValidateIsList(context, list))
        {
            return context->isList(list);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsList, GLboolean>();
}

void GL_APIENTRY LightModelf(GLenum pname, GLfloat param)
{
    EVENT("(GLenum pname = 0x%X, GLfloat param = %f)", pname, param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(LightModelf, context, pname, param);
        if (context->skipValidation() || ValidateLightModelf(context, pname, param))
        {
            context->lightModelf(pname, param);
        }
    }
}

void GL_APIENTRY LightModelfv(GLenum pname, const GLfloat *params)
{
    EVENT("(GLenum pname = 0x%X, const GLfloat *params = 0x%016" PRIxPTR ")", pname,
          (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(LightModelfv, context, pname, params);
        if (context->skipValidation() || ValidateLightModelfv(context, pname, params))
        {
            context->lightModelfv(pname, params);
        }
    }
}

void GL_APIENTRY LightModeli(GLenum pname, GLint param)
{
    EVENT("(GLenum pname = 0x%X, GLint param = %d)", pname, param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(LightModeli, context, pname, param);
        if (context->skipValidation() || ValidateLightModeli(context, pname, param))
        {
            context->lightModeli(pname, param);
        }
    }
}

void GL_APIENTRY LightModeliv(GLenum pname, const GLint *params)
{
    EVENT("(GLenum pname = 0x%X, const GLint *params = 0x%016" PRIxPTR ")", pname,
          (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(LightModeliv, context, pname, params);
        if (context->skipValidation() || ValidateLightModeliv(context, pname, params))
        {
            context->lightModeliv(pname, params);
        }
    }
}

void GL_APIENTRY Lightf(GLenum light, GLenum pname, GLfloat param)
{
    EVENT("(GLenum light = 0x%X, GLenum pname = 0x%X, GLfloat param = %f)", light, pname, param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        LightParameter pnamePacked = FromGLenum<LightParameter>(pname);
        ANGLE_CAPTURE(Lightf, context, light, pnamePacked, param);
        if (context->skipValidation() || ValidateLightf(context, light, pnamePacked, param))
        {
            context->lightf(light, pnamePacked, param);
        }
    }
}

void GL_APIENTRY Lightfv(GLenum light, GLenum pname, const GLfloat *params)
{
    EVENT("(GLenum light = 0x%X, GLenum pname = 0x%X, const GLfloat *params = 0x%016" PRIxPTR ")",
          light, pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        LightParameter pnamePacked = FromGLenum<LightParameter>(pname);
        ANGLE_CAPTURE(Lightfv, context, light, pnamePacked, params);
        if (context->skipValidation() || ValidateLightfv(context, light, pnamePacked, params))
        {
            context->lightfv(light, pnamePacked, params);
        }
    }
}

void GL_APIENTRY Lighti(GLenum light, GLenum pname, GLint param)
{
    EVENT("(GLenum light = 0x%X, GLenum pname = 0x%X, GLint param = %d)", light, pname, param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Lighti, context, light, pname, param);
        if (context->skipValidation() || ValidateLighti(context, light, pname, param))
        {
            context->lighti(light, pname, param);
        }
    }
}

void GL_APIENTRY Lightiv(GLenum light, GLenum pname, const GLint *params)
{
    EVENT("(GLenum light = 0x%X, GLenum pname = 0x%X, const GLint *params = 0x%016" PRIxPTR ")",
          light, pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Lightiv, context, light, pname, params);
        if (context->skipValidation() || ValidateLightiv(context, light, pname, params))
        {
            context->lightiv(light, pname, params);
        }
    }
}

void GL_APIENTRY LineStipple(GLint factor, GLushort pattern)
{
    EVENT("(GLint factor = %d, GLushort pattern = %u)", factor, pattern);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(LineStipple, context, factor, pattern);
        if (context->skipValidation() || ValidateLineStipple(context, factor, pattern))
        {
            context->lineStipple(factor, pattern);
        }
    }
}

void GL_APIENTRY LineWidth(GLfloat width)
{
    EVENT("(GLfloat width = %f)", width);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(LineWidth, context, width);
        if (context->skipValidation() || ValidateLineWidth(context, width))
        {
            context->lineWidth(width);
        }
    }
}

void GL_APIENTRY ListBase(GLuint base)
{
    EVENT("(GLuint base = %u)", base);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(ListBase, context, base);
        if (context->skipValidation() || ValidateListBase(context, base))
        {
            context->listBase(base);
        }
    }
}

void GL_APIENTRY LoadIdentity()
{
    EVENT("()");

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(LoadIdentity, context);
        if (context->skipValidation() || ValidateLoadIdentity(context))
        {
            context->loadIdentity();
        }
    }
}

void GL_APIENTRY LoadMatrixd(const GLdouble *m)
{
    EVENT("(const GLdouble *m = 0x%016" PRIxPTR ")", (uintptr_t)m);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(LoadMatrixd, context, m);
        if (context->skipValidation() || ValidateLoadMatrixd(context, m))
        {
            context->loadMatrixd(m);
        }
    }
}

void GL_APIENTRY LoadMatrixf(const GLfloat *m)
{
    EVENT("(const GLfloat *m = 0x%016" PRIxPTR ")", (uintptr_t)m);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(LoadMatrixf, context, m);
        if (context->skipValidation() || ValidateLoadMatrixf(context, m))
        {
            context->loadMatrixf(m);
        }
    }
}

void GL_APIENTRY LoadName(GLuint name)
{
    EVENT("(GLuint name = %u)", name);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(LoadName, context, name);
        if (context->skipValidation() || ValidateLoadName(context, name))
        {
            context->loadName(name);
        }
    }
}

void GL_APIENTRY LogicOp(GLenum opcode)
{
    EVENT("(GLenum opcode = 0x%X)", opcode);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        LogicalOperation opcodePacked = FromGLenum<LogicalOperation>(opcode);
        ANGLE_CAPTURE(LogicOp, context, opcodePacked);
        if (context->skipValidation() || ValidateLogicOp(context, opcodePacked))
        {
            context->logicOp(opcodePacked);
        }
    }
}

void GL_APIENTRY
Map1d(GLenum target, GLdouble u1, GLdouble u2, GLint stride, GLint order, const GLdouble *points)
{
    EVENT(
        "(GLenum target = 0x%X, GLdouble u1 = %f, GLdouble u2 = %f, GLint stride = %d, GLint order "
        "= %d, const GLdouble *points = 0x%016" PRIxPTR ")",
        target, u1, u2, stride, order, (uintptr_t)points);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Map1d, context, target, u1, u2, stride, order, points);
        if (context->skipValidation() ||
            ValidateMap1d(context, target, u1, u2, stride, order, points))
        {
            context->map1d(target, u1, u2, stride, order, points);
        }
    }
}

void GL_APIENTRY
Map1f(GLenum target, GLfloat u1, GLfloat u2, GLint stride, GLint order, const GLfloat *points)
{
    EVENT(
        "(GLenum target = 0x%X, GLfloat u1 = %f, GLfloat u2 = %f, GLint stride = %d, GLint order = "
        "%d, const GLfloat *points = 0x%016" PRIxPTR ")",
        target, u1, u2, stride, order, (uintptr_t)points);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Map1f, context, target, u1, u2, stride, order, points);
        if (context->skipValidation() ||
            ValidateMap1f(context, target, u1, u2, stride, order, points))
        {
            context->map1f(target, u1, u2, stride, order, points);
        }
    }
}

void GL_APIENTRY Map2d(GLenum target,
                       GLdouble u1,
                       GLdouble u2,
                       GLint ustride,
                       GLint uorder,
                       GLdouble v1,
                       GLdouble v2,
                       GLint vstride,
                       GLint vorder,
                       const GLdouble *points)
{
    EVENT(
        "(GLenum target = 0x%X, GLdouble u1 = %f, GLdouble u2 = %f, GLint ustride = %d, GLint "
        "uorder = %d, GLdouble v1 = %f, GLdouble v2 = %f, GLint vstride = %d, GLint vorder = %d, "
        "const GLdouble *points = 0x%016" PRIxPTR ")",
        target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, (uintptr_t)points);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Map2d, context, target, u1, u2, ustride, uorder, v1, v2, vstride, vorder,
                      points);
        if (context->skipValidation() || ValidateMap2d(context, target, u1, u2, ustride, uorder, v1,
                                                       v2, vstride, vorder, points))
        {
            context->map2d(target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, points);
        }
    }
}

void GL_APIENTRY Map2f(GLenum target,
                       GLfloat u1,
                       GLfloat u2,
                       GLint ustride,
                       GLint uorder,
                       GLfloat v1,
                       GLfloat v2,
                       GLint vstride,
                       GLint vorder,
                       const GLfloat *points)
{
    EVENT(
        "(GLenum target = 0x%X, GLfloat u1 = %f, GLfloat u2 = %f, GLint ustride = %d, GLint uorder "
        "= %d, GLfloat v1 = %f, GLfloat v2 = %f, GLint vstride = %d, GLint vorder = %d, const "
        "GLfloat *points = 0x%016" PRIxPTR ")",
        target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, (uintptr_t)points);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Map2f, context, target, u1, u2, ustride, uorder, v1, v2, vstride, vorder,
                      points);
        if (context->skipValidation() || ValidateMap2f(context, target, u1, u2, ustride, uorder, v1,
                                                       v2, vstride, vorder, points))
        {
            context->map2f(target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, points);
        }
    }
}

void GL_APIENTRY MapGrid1d(GLint un, GLdouble u1, GLdouble u2)
{
    EVENT("(GLint un = %d, GLdouble u1 = %f, GLdouble u2 = %f)", un, u1, u2);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(MapGrid1d, context, un, u1, u2);
        if (context->skipValidation() || ValidateMapGrid1d(context, un, u1, u2))
        {
            context->mapGrid1d(un, u1, u2);
        }
    }
}

void GL_APIENTRY MapGrid1f(GLint un, GLfloat u1, GLfloat u2)
{
    EVENT("(GLint un = %d, GLfloat u1 = %f, GLfloat u2 = %f)", un, u1, u2);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(MapGrid1f, context, un, u1, u2);
        if (context->skipValidation() || ValidateMapGrid1f(context, un, u1, u2))
        {
            context->mapGrid1f(un, u1, u2);
        }
    }
}

void GL_APIENTRY MapGrid2d(GLint un, GLdouble u1, GLdouble u2, GLint vn, GLdouble v1, GLdouble v2)
{
    EVENT(
        "(GLint un = %d, GLdouble u1 = %f, GLdouble u2 = %f, GLint vn = %d, GLdouble v1 = %f, "
        "GLdouble v2 = %f)",
        un, u1, u2, vn, v1, v2);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(MapGrid2d, context, un, u1, u2, vn, v1, v2);
        if (context->skipValidation() || ValidateMapGrid2d(context, un, u1, u2, vn, v1, v2))
        {
            context->mapGrid2d(un, u1, u2, vn, v1, v2);
        }
    }
}

void GL_APIENTRY MapGrid2f(GLint un, GLfloat u1, GLfloat u2, GLint vn, GLfloat v1, GLfloat v2)
{
    EVENT(
        "(GLint un = %d, GLfloat u1 = %f, GLfloat u2 = %f, GLint vn = %d, GLfloat v1 = %f, GLfloat "
        "v2 = %f)",
        un, u1, u2, vn, v1, v2);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(MapGrid2f, context, un, u1, u2, vn, v1, v2);
        if (context->skipValidation() || ValidateMapGrid2f(context, un, u1, u2, vn, v1, v2))
        {
            context->mapGrid2f(un, u1, u2, vn, v1, v2);
        }
    }
}

void GL_APIENTRY Materialf(GLenum face, GLenum pname, GLfloat param)
{
    EVENT("(GLenum face = 0x%X, GLenum pname = 0x%X, GLfloat param = %f)", face, pname, param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        MaterialParameter pnamePacked = FromGLenum<MaterialParameter>(pname);
        ANGLE_CAPTURE(Materialf, context, face, pnamePacked, param);
        if (context->skipValidation() || ValidateMaterialf(context, face, pnamePacked, param))
        {
            context->materialf(face, pnamePacked, param);
        }
    }
}

void GL_APIENTRY Materialfv(GLenum face, GLenum pname, const GLfloat *params)
{
    EVENT("(GLenum face = 0x%X, GLenum pname = 0x%X, const GLfloat *params = 0x%016" PRIxPTR ")",
          face, pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        MaterialParameter pnamePacked = FromGLenum<MaterialParameter>(pname);
        ANGLE_CAPTURE(Materialfv, context, face, pnamePacked, params);
        if (context->skipValidation() || ValidateMaterialfv(context, face, pnamePacked, params))
        {
            context->materialfv(face, pnamePacked, params);
        }
    }
}

void GL_APIENTRY Materiali(GLenum face, GLenum pname, GLint param)
{
    EVENT("(GLenum face = 0x%X, GLenum pname = 0x%X, GLint param = %d)", face, pname, param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Materiali, context, face, pname, param);
        if (context->skipValidation() || ValidateMateriali(context, face, pname, param))
        {
            context->materiali(face, pname, param);
        }
    }
}

void GL_APIENTRY Materialiv(GLenum face, GLenum pname, const GLint *params)
{
    EVENT("(GLenum face = 0x%X, GLenum pname = 0x%X, const GLint *params = 0x%016" PRIxPTR ")",
          face, pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Materialiv, context, face, pname, params);
        if (context->skipValidation() || ValidateMaterialiv(context, face, pname, params))
        {
            context->materialiv(face, pname, params);
        }
    }
}

void GL_APIENTRY MatrixMode(GLenum mode)
{
    EVENT("(GLenum mode = 0x%X)", mode);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        MatrixType modePacked = FromGLenum<MatrixType>(mode);
        ANGLE_CAPTURE(MatrixMode, context, modePacked);
        if (context->skipValidation() || ValidateMatrixMode(context, modePacked))
        {
            context->matrixMode(modePacked);
        }
    }
}

void GL_APIENTRY MultMatrixd(const GLdouble *m)
{
    EVENT("(const GLdouble *m = 0x%016" PRIxPTR ")", (uintptr_t)m);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(MultMatrixd, context, m);
        if (context->skipValidation() || ValidateMultMatrixd(context, m))
        {
            context->multMatrixd(m);
        }
    }
}

void GL_APIENTRY MultMatrixf(const GLfloat *m)
{
    EVENT("(const GLfloat *m = 0x%016" PRIxPTR ")", (uintptr_t)m);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(MultMatrixf, context, m);
        if (context->skipValidation() || ValidateMultMatrixf(context, m))
        {
            context->multMatrixf(m);
        }
    }
}

void GL_APIENTRY NewList(GLuint list, GLenum mode)
{
    EVENT("(GLuint list = %u, GLenum mode = 0x%X)", list, mode);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(NewList, context, list, mode);
        if (context->skipValidation() || ValidateNewList(context, list, mode))
        {
            context->newList(list, mode);
        }
    }
}

void GL_APIENTRY Normal3b(GLbyte nx, GLbyte ny, GLbyte nz)
{
    EVENT("(GLbyte nx = %d, GLbyte ny = %d, GLbyte nz = %d)", nx, ny, nz);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Normal3b, context, nx, ny, nz);
        if (context->skipValidation() || ValidateNormal3b(context, nx, ny, nz))
        {
            context->normal3b(nx, ny, nz);
        }
    }
}

void GL_APIENTRY Normal3bv(const GLbyte *v)
{
    EVENT("(const GLbyte *v = 0x%016" PRIxPTR ")", (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Normal3bv, context, v);
        if (context->skipValidation() || ValidateNormal3bv(context, v))
        {
            context->normal3bv(v);
        }
    }
}

void GL_APIENTRY Normal3d(GLdouble nx, GLdouble ny, GLdouble nz)
{
    EVENT("(GLdouble nx = %f, GLdouble ny = %f, GLdouble nz = %f)", nx, ny, nz);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Normal3d, context, nx, ny, nz);
        if (context->skipValidation() || ValidateNormal3d(context, nx, ny, nz))
        {
            context->normal3d(nx, ny, nz);
        }
    }
}

void GL_APIENTRY Normal3dv(const GLdouble *v)
{
    EVENT("(const GLdouble *v = 0x%016" PRIxPTR ")", (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Normal3dv, context, v);
        if (context->skipValidation() || ValidateNormal3dv(context, v))
        {
            context->normal3dv(v);
        }
    }
}

void GL_APIENTRY Normal3f(GLfloat nx, GLfloat ny, GLfloat nz)
{
    EVENT("(GLfloat nx = %f, GLfloat ny = %f, GLfloat nz = %f)", nx, ny, nz);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Normal3f, context, nx, ny, nz);
        if (context->skipValidation() || ValidateNormal3f(context, nx, ny, nz))
        {
            context->normal3f(nx, ny, nz);
        }
    }
}

void GL_APIENTRY Normal3fv(const GLfloat *v)
{
    EVENT("(const GLfloat *v = 0x%016" PRIxPTR ")", (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Normal3fv, context, v);
        if (context->skipValidation() || ValidateNormal3fv(context, v))
        {
            context->normal3fv(v);
        }
    }
}

void GL_APIENTRY Normal3i(GLint nx, GLint ny, GLint nz)
{
    EVENT("(GLint nx = %d, GLint ny = %d, GLint nz = %d)", nx, ny, nz);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Normal3i, context, nx, ny, nz);
        if (context->skipValidation() || ValidateNormal3i(context, nx, ny, nz))
        {
            context->normal3i(nx, ny, nz);
        }
    }
}

void GL_APIENTRY Normal3iv(const GLint *v)
{
    EVENT("(const GLint *v = 0x%016" PRIxPTR ")", (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Normal3iv, context, v);
        if (context->skipValidation() || ValidateNormal3iv(context, v))
        {
            context->normal3iv(v);
        }
    }
}

void GL_APIENTRY Normal3s(GLshort nx, GLshort ny, GLshort nz)
{
    EVENT("(GLshort nx = %d, GLshort ny = %d, GLshort nz = %d)", nx, ny, nz);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Normal3s, context, nx, ny, nz);
        if (context->skipValidation() || ValidateNormal3s(context, nx, ny, nz))
        {
            context->normal3s(nx, ny, nz);
        }
    }
}

void GL_APIENTRY Normal3sv(const GLshort *v)
{
    EVENT("(const GLshort *v = 0x%016" PRIxPTR ")", (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Normal3sv, context, v);
        if (context->skipValidation() || ValidateNormal3sv(context, v))
        {
            context->normal3sv(v);
        }
    }
}

void GL_APIENTRY
Ortho(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar)
{
    EVENT(
        "(GLdouble left = %f, GLdouble right = %f, GLdouble bottom = %f, GLdouble top = %f, "
        "GLdouble zNear = %f, GLdouble zFar = %f)",
        left, right, bottom, top, zNear, zFar);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Ortho, context, left, right, bottom, top, zNear, zFar);
        if (context->skipValidation() ||
            ValidateOrtho(context, left, right, bottom, top, zNear, zFar))
        {
            context->ortho(left, right, bottom, top, zNear, zFar);
        }
    }
}

void GL_APIENTRY PassThrough(GLfloat token)
{
    EVENT("(GLfloat token = %f)", token);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(PassThrough, context, token);
        if (context->skipValidation() || ValidatePassThrough(context, token))
        {
            context->passThrough(token);
        }
    }
}

void GL_APIENTRY PixelMapfv(GLenum map, GLsizei mapsize, const GLfloat *values)
{
    EVENT("(GLenum map = 0x%X, GLsizei mapsize = %d, const GLfloat *values = 0x%016" PRIxPTR ")",
          map, mapsize, (uintptr_t)values);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(PixelMapfv, context, map, mapsize, values);
        if (context->skipValidation() || ValidatePixelMapfv(context, map, mapsize, values))
        {
            context->pixelMapfv(map, mapsize, values);
        }
    }
}

void GL_APIENTRY PixelMapuiv(GLenum map, GLsizei mapsize, const GLuint *values)
{
    EVENT("(GLenum map = 0x%X, GLsizei mapsize = %d, const GLuint *values = 0x%016" PRIxPTR ")",
          map, mapsize, (uintptr_t)values);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(PixelMapuiv, context, map, mapsize, values);
        if (context->skipValidation() || ValidatePixelMapuiv(context, map, mapsize, values))
        {
            context->pixelMapuiv(map, mapsize, values);
        }
    }
}

void GL_APIENTRY PixelMapusv(GLenum map, GLsizei mapsize, const GLushort *values)
{
    EVENT("(GLenum map = 0x%X, GLsizei mapsize = %d, const GLushort *values = 0x%016" PRIxPTR ")",
          map, mapsize, (uintptr_t)values);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(PixelMapusv, context, map, mapsize, values);
        if (context->skipValidation() || ValidatePixelMapusv(context, map, mapsize, values))
        {
            context->pixelMapusv(map, mapsize, values);
        }
    }
}

void GL_APIENTRY PixelStoref(GLenum pname, GLfloat param)
{
    EVENT("(GLenum pname = 0x%X, GLfloat param = %f)", pname, param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(PixelStoref, context, pname, param);
        if (context->skipValidation() || ValidatePixelStoref(context, pname, param))
        {
            context->pixelStoref(pname, param);
        }
    }
}

void GL_APIENTRY PixelStorei(GLenum pname, GLint param)
{
    EVENT("(GLenum pname = 0x%X, GLint param = %d)", pname, param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(PixelStorei, context, pname, param);
        if (context->skipValidation() || ValidatePixelStorei(context, pname, param))
        {
            context->pixelStorei(pname, param);
        }
    }
}

void GL_APIENTRY PixelTransferf(GLenum pname, GLfloat param)
{
    EVENT("(GLenum pname = 0x%X, GLfloat param = %f)", pname, param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(PixelTransferf, context, pname, param);
        if (context->skipValidation() || ValidatePixelTransferf(context, pname, param))
        {
            context->pixelTransferf(pname, param);
        }
    }
}

void GL_APIENTRY PixelTransferi(GLenum pname, GLint param)
{
    EVENT("(GLenum pname = 0x%X, GLint param = %d)", pname, param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(PixelTransferi, context, pname, param);
        if (context->skipValidation() || ValidatePixelTransferi(context, pname, param))
        {
            context->pixelTransferi(pname, param);
        }
    }
}

void GL_APIENTRY PixelZoom(GLfloat xfactor, GLfloat yfactor)
{
    EVENT("(GLfloat xfactor = %f, GLfloat yfactor = %f)", xfactor, yfactor);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(PixelZoom, context, xfactor, yfactor);
        if (context->skipValidation() || ValidatePixelZoom(context, xfactor, yfactor))
        {
            context->pixelZoom(xfactor, yfactor);
        }
    }
}

void GL_APIENTRY PointSize(GLfloat size)
{
    EVENT("(GLfloat size = %f)", size);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(PointSize, context, size);
        if (context->skipValidation() || ValidatePointSize(context, size))
        {
            context->pointSize(size);
        }
    }
}

void GL_APIENTRY PolygonMode(GLenum face, GLenum mode)
{
    EVENT("(GLenum face = 0x%X, GLenum mode = 0x%X)", face, mode);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(PolygonMode, context, face, mode);
        if (context->skipValidation() || ValidatePolygonMode(context, face, mode))
        {
            context->polygonMode(face, mode);
        }
    }
}

void GL_APIENTRY PolygonStipple(const GLubyte *mask)
{
    EVENT("(const GLubyte *mask = 0x%016" PRIxPTR ")", (uintptr_t)mask);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(PolygonStipple, context, mask);
        if (context->skipValidation() || ValidatePolygonStipple(context, mask))
        {
            context->polygonStipple(mask);
        }
    }
}

void GL_APIENTRY PopAttrib()
{
    EVENT("()");

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(PopAttrib, context);
        if (context->skipValidation() || ValidatePopAttrib(context))
        {
            context->popAttrib();
        }
    }
}

void GL_APIENTRY PopMatrix()
{
    EVENT("()");

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(PopMatrix, context);
        if (context->skipValidation() || ValidatePopMatrix(context))
        {
            context->popMatrix();
        }
    }
}

void GL_APIENTRY PopName()
{
    EVENT("()");

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(PopName, context);
        if (context->skipValidation() || ValidatePopName(context))
        {
            context->popName();
        }
    }
}

void GL_APIENTRY PushAttrib(GLbitfield mask)
{
    EVENT("(GLbitfield mask = 0x%X)", mask);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(PushAttrib, context, mask);
        if (context->skipValidation() || ValidatePushAttrib(context, mask))
        {
            context->pushAttrib(mask);
        }
    }
}

void GL_APIENTRY PushMatrix()
{
    EVENT("()");

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(PushMatrix, context);
        if (context->skipValidation() || ValidatePushMatrix(context))
        {
            context->pushMatrix();
        }
    }
}

void GL_APIENTRY PushName(GLuint name)
{
    EVENT("(GLuint name = %u)", name);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(PushName, context, name);
        if (context->skipValidation() || ValidatePushName(context, name))
        {
            context->pushName(name);
        }
    }
}

void GL_APIENTRY RasterPos2d(GLdouble x, GLdouble y)
{
    EVENT("(GLdouble x = %f, GLdouble y = %f)", x, y);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(RasterPos2d, context, x, y);
        if (context->skipValidation() || ValidateRasterPos2d(context, x, y))
        {
            context->rasterPos2d(x, y);
        }
    }
}

void GL_APIENTRY RasterPos2dv(const GLdouble *v)
{
    EVENT("(const GLdouble *v = 0x%016" PRIxPTR ")", (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(RasterPos2dv, context, v);
        if (context->skipValidation() || ValidateRasterPos2dv(context, v))
        {
            context->rasterPos2dv(v);
        }
    }
}

void GL_APIENTRY RasterPos2f(GLfloat x, GLfloat y)
{
    EVENT("(GLfloat x = %f, GLfloat y = %f)", x, y);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(RasterPos2f, context, x, y);
        if (context->skipValidation() || ValidateRasterPos2f(context, x, y))
        {
            context->rasterPos2f(x, y);
        }
    }
}

void GL_APIENTRY RasterPos2fv(const GLfloat *v)
{
    EVENT("(const GLfloat *v = 0x%016" PRIxPTR ")", (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(RasterPos2fv, context, v);
        if (context->skipValidation() || ValidateRasterPos2fv(context, v))
        {
            context->rasterPos2fv(v);
        }
    }
}

void GL_APIENTRY RasterPos2i(GLint x, GLint y)
{
    EVENT("(GLint x = %d, GLint y = %d)", x, y);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(RasterPos2i, context, x, y);
        if (context->skipValidation() || ValidateRasterPos2i(context, x, y))
        {
            context->rasterPos2i(x, y);
        }
    }
}

void GL_APIENTRY RasterPos2iv(const GLint *v)
{
    EVENT("(const GLint *v = 0x%016" PRIxPTR ")", (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(RasterPos2iv, context, v);
        if (context->skipValidation() || ValidateRasterPos2iv(context, v))
        {
            context->rasterPos2iv(v);
        }
    }
}

void GL_APIENTRY RasterPos2s(GLshort x, GLshort y)
{
    EVENT("(GLshort x = %d, GLshort y = %d)", x, y);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(RasterPos2s, context, x, y);
        if (context->skipValidation() || ValidateRasterPos2s(context, x, y))
        {
            context->rasterPos2s(x, y);
        }
    }
}

void GL_APIENTRY RasterPos2sv(const GLshort *v)
{
    EVENT("(const GLshort *v = 0x%016" PRIxPTR ")", (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(RasterPos2sv, context, v);
        if (context->skipValidation() || ValidateRasterPos2sv(context, v))
        {
            context->rasterPos2sv(v);
        }
    }
}

void GL_APIENTRY RasterPos3d(GLdouble x, GLdouble y, GLdouble z)
{
    EVENT("(GLdouble x = %f, GLdouble y = %f, GLdouble z = %f)", x, y, z);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(RasterPos3d, context, x, y, z);
        if (context->skipValidation() || ValidateRasterPos3d(context, x, y, z))
        {
            context->rasterPos3d(x, y, z);
        }
    }
}

void GL_APIENTRY RasterPos3dv(const GLdouble *v)
{
    EVENT("(const GLdouble *v = 0x%016" PRIxPTR ")", (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(RasterPos3dv, context, v);
        if (context->skipValidation() || ValidateRasterPos3dv(context, v))
        {
            context->rasterPos3dv(v);
        }
    }
}

void GL_APIENTRY RasterPos3f(GLfloat x, GLfloat y, GLfloat z)
{
    EVENT("(GLfloat x = %f, GLfloat y = %f, GLfloat z = %f)", x, y, z);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(RasterPos3f, context, x, y, z);
        if (context->skipValidation() || ValidateRasterPos3f(context, x, y, z))
        {
            context->rasterPos3f(x, y, z);
        }
    }
}

void GL_APIENTRY RasterPos3fv(const GLfloat *v)
{
    EVENT("(const GLfloat *v = 0x%016" PRIxPTR ")", (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(RasterPos3fv, context, v);
        if (context->skipValidation() || ValidateRasterPos3fv(context, v))
        {
            context->rasterPos3fv(v);
        }
    }
}

void GL_APIENTRY RasterPos3i(GLint x, GLint y, GLint z)
{
    EVENT("(GLint x = %d, GLint y = %d, GLint z = %d)", x, y, z);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(RasterPos3i, context, x, y, z);
        if (context->skipValidation() || ValidateRasterPos3i(context, x, y, z))
        {
            context->rasterPos3i(x, y, z);
        }
    }
}

void GL_APIENTRY RasterPos3iv(const GLint *v)
{
    EVENT("(const GLint *v = 0x%016" PRIxPTR ")", (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(RasterPos3iv, context, v);
        if (context->skipValidation() || ValidateRasterPos3iv(context, v))
        {
            context->rasterPos3iv(v);
        }
    }
}

void GL_APIENTRY RasterPos3s(GLshort x, GLshort y, GLshort z)
{
    EVENT("(GLshort x = %d, GLshort y = %d, GLshort z = %d)", x, y, z);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(RasterPos3s, context, x, y, z);
        if (context->skipValidation() || ValidateRasterPos3s(context, x, y, z))
        {
            context->rasterPos3s(x, y, z);
        }
    }
}

void GL_APIENTRY RasterPos3sv(const GLshort *v)
{
    EVENT("(const GLshort *v = 0x%016" PRIxPTR ")", (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(RasterPos3sv, context, v);
        if (context->skipValidation() || ValidateRasterPos3sv(context, v))
        {
            context->rasterPos3sv(v);
        }
    }
}

void GL_APIENTRY RasterPos4d(GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
    EVENT("(GLdouble x = %f, GLdouble y = %f, GLdouble z = %f, GLdouble w = %f)", x, y, z, w);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(RasterPos4d, context, x, y, z, w);
        if (context->skipValidation() || ValidateRasterPos4d(context, x, y, z, w))
        {
            context->rasterPos4d(x, y, z, w);
        }
    }
}

void GL_APIENTRY RasterPos4dv(const GLdouble *v)
{
    EVENT("(const GLdouble *v = 0x%016" PRIxPTR ")", (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(RasterPos4dv, context, v);
        if (context->skipValidation() || ValidateRasterPos4dv(context, v))
        {
            context->rasterPos4dv(v);
        }
    }
}

void GL_APIENTRY RasterPos4f(GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
    EVENT("(GLfloat x = %f, GLfloat y = %f, GLfloat z = %f, GLfloat w = %f)", x, y, z, w);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(RasterPos4f, context, x, y, z, w);
        if (context->skipValidation() || ValidateRasterPos4f(context, x, y, z, w))
        {
            context->rasterPos4f(x, y, z, w);
        }
    }
}

void GL_APIENTRY RasterPos4fv(const GLfloat *v)
{
    EVENT("(const GLfloat *v = 0x%016" PRIxPTR ")", (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(RasterPos4fv, context, v);
        if (context->skipValidation() || ValidateRasterPos4fv(context, v))
        {
            context->rasterPos4fv(v);
        }
    }
}

void GL_APIENTRY RasterPos4i(GLint x, GLint y, GLint z, GLint w)
{
    EVENT("(GLint x = %d, GLint y = %d, GLint z = %d, GLint w = %d)", x, y, z, w);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(RasterPos4i, context, x, y, z, w);
        if (context->skipValidation() || ValidateRasterPos4i(context, x, y, z, w))
        {
            context->rasterPos4i(x, y, z, w);
        }
    }
}

void GL_APIENTRY RasterPos4iv(const GLint *v)
{
    EVENT("(const GLint *v = 0x%016" PRIxPTR ")", (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(RasterPos4iv, context, v);
        if (context->skipValidation() || ValidateRasterPos4iv(context, v))
        {
            context->rasterPos4iv(v);
        }
    }
}

void GL_APIENTRY RasterPos4s(GLshort x, GLshort y, GLshort z, GLshort w)
{
    EVENT("(GLshort x = %d, GLshort y = %d, GLshort z = %d, GLshort w = %d)", x, y, z, w);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(RasterPos4s, context, x, y, z, w);
        if (context->skipValidation() || ValidateRasterPos4s(context, x, y, z, w))
        {
            context->rasterPos4s(x, y, z, w);
        }
    }
}

void GL_APIENTRY RasterPos4sv(const GLshort *v)
{
    EVENT("(const GLshort *v = 0x%016" PRIxPTR ")", (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(RasterPos4sv, context, v);
        if (context->skipValidation() || ValidateRasterPos4sv(context, v))
        {
            context->rasterPos4sv(v);
        }
    }
}

void GL_APIENTRY ReadBuffer(GLenum src)
{
    EVENT("(GLenum src = 0x%X)", src);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(ReadBuffer, context, src);
        if (context->skipValidation() || ValidateReadBuffer(context, src))
        {
            context->readBuffer(src);
        }
    }
}

void GL_APIENTRY ReadPixels(GLint x,
                            GLint y,
                            GLsizei width,
                            GLsizei height,
                            GLenum format,
                            GLenum type,
                            void *pixels)
{
    EVENT(
        "(GLint x = %d, GLint y = %d, GLsizei width = %d, GLsizei height = %d, GLenum format = "
        "0x%X, GLenum type = 0x%X, void *pixels = 0x%016" PRIxPTR ")",
        x, y, width, height, format, type, (uintptr_t)pixels);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(ReadPixels, context, x, y, width, height, format, type, pixels);
        if (context->skipValidation() ||
            ValidateReadPixels(context, x, y, width, height, format, type, pixels))
        {
            context->readPixels(x, y, width, height, format, type, pixels);
        }
    }
}

void GL_APIENTRY Rectd(GLdouble x1, GLdouble y1, GLdouble x2, GLdouble y2)
{
    EVENT("(GLdouble x1 = %f, GLdouble y1 = %f, GLdouble x2 = %f, GLdouble y2 = %f)", x1, y1, x2,
          y2);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Rectd, context, x1, y1, x2, y2);
        if (context->skipValidation() || ValidateRectd(context, x1, y1, x2, y2))
        {
            context->rectd(x1, y1, x2, y2);
        }
    }
}

void GL_APIENTRY Rectdv(const GLdouble *v1, const GLdouble *v2)
{
    EVENT("(const GLdouble *v1 = 0x%016" PRIxPTR ", const GLdouble *v2 = 0x%016" PRIxPTR ")",
          (uintptr_t)v1, (uintptr_t)v2);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Rectdv, context, v1, v2);
        if (context->skipValidation() || ValidateRectdv(context, v1, v2))
        {
            context->rectdv(v1, v2);
        }
    }
}

void GL_APIENTRY Rectf(GLfloat x1, GLfloat y1, GLfloat x2, GLfloat y2)
{
    EVENT("(GLfloat x1 = %f, GLfloat y1 = %f, GLfloat x2 = %f, GLfloat y2 = %f)", x1, y1, x2, y2);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Rectf, context, x1, y1, x2, y2);
        if (context->skipValidation() || ValidateRectf(context, x1, y1, x2, y2))
        {
            context->rectf(x1, y1, x2, y2);
        }
    }
}

void GL_APIENTRY Rectfv(const GLfloat *v1, const GLfloat *v2)
{
    EVENT("(const GLfloat *v1 = 0x%016" PRIxPTR ", const GLfloat *v2 = 0x%016" PRIxPTR ")",
          (uintptr_t)v1, (uintptr_t)v2);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Rectfv, context, v1, v2);
        if (context->skipValidation() || ValidateRectfv(context, v1, v2))
        {
            context->rectfv(v1, v2);
        }
    }
}

void GL_APIENTRY Recti(GLint x1, GLint y1, GLint x2, GLint y2)
{
    EVENT("(GLint x1 = %d, GLint y1 = %d, GLint x2 = %d, GLint y2 = %d)", x1, y1, x2, y2);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Recti, context, x1, y1, x2, y2);
        if (context->skipValidation() || ValidateRecti(context, x1, y1, x2, y2))
        {
            context->recti(x1, y1, x2, y2);
        }
    }
}

void GL_APIENTRY Rectiv(const GLint *v1, const GLint *v2)
{
    EVENT("(const GLint *v1 = 0x%016" PRIxPTR ", const GLint *v2 = 0x%016" PRIxPTR ")",
          (uintptr_t)v1, (uintptr_t)v2);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Rectiv, context, v1, v2);
        if (context->skipValidation() || ValidateRectiv(context, v1, v2))
        {
            context->rectiv(v1, v2);
        }
    }
}

void GL_APIENTRY Rects(GLshort x1, GLshort y1, GLshort x2, GLshort y2)
{
    EVENT("(GLshort x1 = %d, GLshort y1 = %d, GLshort x2 = %d, GLshort y2 = %d)", x1, y1, x2, y2);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Rects, context, x1, y1, x2, y2);
        if (context->skipValidation() || ValidateRects(context, x1, y1, x2, y2))
        {
            context->rects(x1, y1, x2, y2);
        }
    }
}

void GL_APIENTRY Rectsv(const GLshort *v1, const GLshort *v2)
{
    EVENT("(const GLshort *v1 = 0x%016" PRIxPTR ", const GLshort *v2 = 0x%016" PRIxPTR ")",
          (uintptr_t)v1, (uintptr_t)v2);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Rectsv, context, v1, v2);
        if (context->skipValidation() || ValidateRectsv(context, v1, v2))
        {
            context->rectsv(v1, v2);
        }
    }
}

GLint GL_APIENTRY RenderMode(GLenum mode)
{
    EVENT("(GLenum mode = 0x%X)", mode);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(RenderMode, context, mode);
        if (context->skipValidation() || ValidateRenderMode(context, mode))
        {
            return context->renderMode(mode);
        }
    }

    return GetDefaultReturnValue<EntryPoint::RenderMode, GLint>();
}

void GL_APIENTRY Rotated(GLdouble angle, GLdouble x, GLdouble y, GLdouble z)
{
    EVENT("(GLdouble angle = %f, GLdouble x = %f, GLdouble y = %f, GLdouble z = %f)", angle, x, y,
          z);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Rotated, context, angle, x, y, z);
        if (context->skipValidation() || ValidateRotated(context, angle, x, y, z))
        {
            context->rotated(angle, x, y, z);
        }
    }
}

void GL_APIENTRY Rotatef(GLfloat angle, GLfloat x, GLfloat y, GLfloat z)
{
    EVENT("(GLfloat angle = %f, GLfloat x = %f, GLfloat y = %f, GLfloat z = %f)", angle, x, y, z);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Rotatef, context, angle, x, y, z);
        if (context->skipValidation() || ValidateRotatef(context, angle, x, y, z))
        {
            context->rotatef(angle, x, y, z);
        }
    }
}

void GL_APIENTRY Scaled(GLdouble x, GLdouble y, GLdouble z)
{
    EVENT("(GLdouble x = %f, GLdouble y = %f, GLdouble z = %f)", x, y, z);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Scaled, context, x, y, z);
        if (context->skipValidation() || ValidateScaled(context, x, y, z))
        {
            context->scaled(x, y, z);
        }
    }
}

void GL_APIENTRY Scalef(GLfloat x, GLfloat y, GLfloat z)
{
    EVENT("(GLfloat x = %f, GLfloat y = %f, GLfloat z = %f)", x, y, z);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Scalef, context, x, y, z);
        if (context->skipValidation() || ValidateScalef(context, x, y, z))
        {
            context->scalef(x, y, z);
        }
    }
}

void GL_APIENTRY Scissor(GLint x, GLint y, GLsizei width, GLsizei height)
{
    EVENT("(GLint x = %d, GLint y = %d, GLsizei width = %d, GLsizei height = %d)", x, y, width,
          height);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Scissor, context, x, y, width, height);
        if (context->skipValidation() || ValidateScissor(context, x, y, width, height))
        {
            context->scissor(x, y, width, height);
        }
    }
}

void GL_APIENTRY SelectBuffer(GLsizei size, GLuint *buffer)
{
    EVENT("(GLsizei size = %d, GLuint *buffer = 0x%016" PRIxPTR ")", size, (uintptr_t)buffer);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(SelectBuffer, context, size, buffer);
        if (context->skipValidation() || ValidateSelectBuffer(context, size, buffer))
        {
            context->selectBuffer(size, buffer);
        }
    }
}

void GL_APIENTRY ShadeModel(GLenum mode)
{
    EVENT("(GLenum mode = 0x%X)", mode);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ShadingModel modePacked = FromGLenum<ShadingModel>(mode);
        ANGLE_CAPTURE(ShadeModel, context, modePacked);
        if (context->skipValidation() || ValidateShadeModel(context, modePacked))
        {
            context->shadeModel(modePacked);
        }
    }
}

void GL_APIENTRY StencilFunc(GLenum func, GLint ref, GLuint mask)
{
    EVENT("(GLenum func = 0x%X, GLint ref = %d, GLuint mask = %u)", func, ref, mask);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(StencilFunc, context, func, ref, mask);
        if (context->skipValidation() || ValidateStencilFunc(context, func, ref, mask))
        {
            context->stencilFunc(func, ref, mask);
        }
    }
}

void GL_APIENTRY StencilMask(GLuint mask)
{
    EVENT("(GLuint mask = %u)", mask);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(StencilMask, context, mask);
        if (context->skipValidation() || ValidateStencilMask(context, mask))
        {
            context->stencilMask(mask);
        }
    }
}

void GL_APIENTRY StencilOp(GLenum fail, GLenum zfail, GLenum zpass)
{
    EVENT("(GLenum fail = 0x%X, GLenum zfail = 0x%X, GLenum zpass = 0x%X)", fail, zfail, zpass);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(StencilOp, context, fail, zfail, zpass);
        if (context->skipValidation() || ValidateStencilOp(context, fail, zfail, zpass))
        {
            context->stencilOp(fail, zfail, zpass);
        }
    }
}

void GL_APIENTRY TexCoord1d(GLdouble s)
{
    EVENT("(GLdouble s = %f)", s);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(TexCoord1d, context, s);
        if (context->skipValidation() || ValidateTexCoord1d(context, s))
        {
            context->texCoord1d(s);
        }
    }
}

void GL_APIENTRY TexCoord1dv(const GLdouble *v)
{
    EVENT("(const GLdouble *v = 0x%016" PRIxPTR ")", (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(TexCoord1dv, context, v);
        if (context->skipValidation() || ValidateTexCoord1dv(context, v))
        {
            context->texCoord1dv(v);
        }
    }
}

void GL_APIENTRY TexCoord1f(GLfloat s)
{
    EVENT("(GLfloat s = %f)", s);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(TexCoord1f, context, s);
        if (context->skipValidation() || ValidateTexCoord1f(context, s))
        {
            context->texCoord1f(s);
        }
    }
}

void GL_APIENTRY TexCoord1fv(const GLfloat *v)
{
    EVENT("(const GLfloat *v = 0x%016" PRIxPTR ")", (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(TexCoord1fv, context, v);
        if (context->skipValidation() || ValidateTexCoord1fv(context, v))
        {
            context->texCoord1fv(v);
        }
    }
}

void GL_APIENTRY TexCoord1i(GLint s)
{
    EVENT("(GLint s = %d)", s);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(TexCoord1i, context, s);
        if (context->skipValidation() || ValidateTexCoord1i(context, s))
        {
            context->texCoord1i(s);
        }
    }
}

void GL_APIENTRY TexCoord1iv(const GLint *v)
{
    EVENT("(const GLint *v = 0x%016" PRIxPTR ")", (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(TexCoord1iv, context, v);
        if (context->skipValidation() || ValidateTexCoord1iv(context, v))
        {
            context->texCoord1iv(v);
        }
    }
}

void GL_APIENTRY TexCoord1s(GLshort s)
{
    EVENT("(GLshort s = %d)", s);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(TexCoord1s, context, s);
        if (context->skipValidation() || ValidateTexCoord1s(context, s))
        {
            context->texCoord1s(s);
        }
    }
}

void GL_APIENTRY TexCoord1sv(const GLshort *v)
{
    EVENT("(const GLshort *v = 0x%016" PRIxPTR ")", (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(TexCoord1sv, context, v);
        if (context->skipValidation() || ValidateTexCoord1sv(context, v))
        {
            context->texCoord1sv(v);
        }
    }
}

void GL_APIENTRY TexCoord2d(GLdouble s, GLdouble t)
{
    EVENT("(GLdouble s = %f, GLdouble t = %f)", s, t);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(TexCoord2d, context, s, t);
        if (context->skipValidation() || ValidateTexCoord2d(context, s, t))
        {
            context->texCoord2d(s, t);
        }
    }
}

void GL_APIENTRY TexCoord2dv(const GLdouble *v)
{
    EVENT("(const GLdouble *v = 0x%016" PRIxPTR ")", (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(TexCoord2dv, context, v);
        if (context->skipValidation() || ValidateTexCoord2dv(context, v))
        {
            context->texCoord2dv(v);
        }
    }
}

void GL_APIENTRY TexCoord2f(GLfloat s, GLfloat t)
{
    EVENT("(GLfloat s = %f, GLfloat t = %f)", s, t);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(TexCoord2f, context, s, t);
        if (context->skipValidation() || ValidateTexCoord2f(context, s, t))
        {
            context->texCoord2f(s, t);
        }
    }
}

void GL_APIENTRY TexCoord2fv(const GLfloat *v)
{
    EVENT("(const GLfloat *v = 0x%016" PRIxPTR ")", (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(TexCoord2fv, context, v);
        if (context->skipValidation() || ValidateTexCoord2fv(context, v))
        {
            context->texCoord2fv(v);
        }
    }
}

void GL_APIENTRY TexCoord2i(GLint s, GLint t)
{
    EVENT("(GLint s = %d, GLint t = %d)", s, t);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(TexCoord2i, context, s, t);
        if (context->skipValidation() || ValidateTexCoord2i(context, s, t))
        {
            context->texCoord2i(s, t);
        }
    }
}

void GL_APIENTRY TexCoord2iv(const GLint *v)
{
    EVENT("(const GLint *v = 0x%016" PRIxPTR ")", (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(TexCoord2iv, context, v);
        if (context->skipValidation() || ValidateTexCoord2iv(context, v))
        {
            context->texCoord2iv(v);
        }
    }
}

void GL_APIENTRY TexCoord2s(GLshort s, GLshort t)
{
    EVENT("(GLshort s = %d, GLshort t = %d)", s, t);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(TexCoord2s, context, s, t);
        if (context->skipValidation() || ValidateTexCoord2s(context, s, t))
        {
            context->texCoord2s(s, t);
        }
    }
}

void GL_APIENTRY TexCoord2sv(const GLshort *v)
{
    EVENT("(const GLshort *v = 0x%016" PRIxPTR ")", (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(TexCoord2sv, context, v);
        if (context->skipValidation() || ValidateTexCoord2sv(context, v))
        {
            context->texCoord2sv(v);
        }
    }
}

void GL_APIENTRY TexCoord3d(GLdouble s, GLdouble t, GLdouble r)
{
    EVENT("(GLdouble s = %f, GLdouble t = %f, GLdouble r = %f)", s, t, r);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(TexCoord3d, context, s, t, r);
        if (context->skipValidation() || ValidateTexCoord3d(context, s, t, r))
        {
            context->texCoord3d(s, t, r);
        }
    }
}

void GL_APIENTRY TexCoord3dv(const GLdouble *v)
{
    EVENT("(const GLdouble *v = 0x%016" PRIxPTR ")", (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(TexCoord3dv, context, v);
        if (context->skipValidation() || ValidateTexCoord3dv(context, v))
        {
            context->texCoord3dv(v);
        }
    }
}

void GL_APIENTRY TexCoord3f(GLfloat s, GLfloat t, GLfloat r)
{
    EVENT("(GLfloat s = %f, GLfloat t = %f, GLfloat r = %f)", s, t, r);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(TexCoord3f, context, s, t, r);
        if (context->skipValidation() || ValidateTexCoord3f(context, s, t, r))
        {
            context->texCoord3f(s, t, r);
        }
    }
}

void GL_APIENTRY TexCoord3fv(const GLfloat *v)
{
    EVENT("(const GLfloat *v = 0x%016" PRIxPTR ")", (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(TexCoord3fv, context, v);
        if (context->skipValidation() || ValidateTexCoord3fv(context, v))
        {
            context->texCoord3fv(v);
        }
    }
}

void GL_APIENTRY TexCoord3i(GLint s, GLint t, GLint r)
{
    EVENT("(GLint s = %d, GLint t = %d, GLint r = %d)", s, t, r);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(TexCoord3i, context, s, t, r);
        if (context->skipValidation() || ValidateTexCoord3i(context, s, t, r))
        {
            context->texCoord3i(s, t, r);
        }
    }
}

void GL_APIENTRY TexCoord3iv(const GLint *v)
{
    EVENT("(const GLint *v = 0x%016" PRIxPTR ")", (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(TexCoord3iv, context, v);
        if (context->skipValidation() || ValidateTexCoord3iv(context, v))
        {
            context->texCoord3iv(v);
        }
    }
}

void GL_APIENTRY TexCoord3s(GLshort s, GLshort t, GLshort r)
{
    EVENT("(GLshort s = %d, GLshort t = %d, GLshort r = %d)", s, t, r);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(TexCoord3s, context, s, t, r);
        if (context->skipValidation() || ValidateTexCoord3s(context, s, t, r))
        {
            context->texCoord3s(s, t, r);
        }
    }
}

void GL_APIENTRY TexCoord3sv(const GLshort *v)
{
    EVENT("(const GLshort *v = 0x%016" PRIxPTR ")", (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(TexCoord3sv, context, v);
        if (context->skipValidation() || ValidateTexCoord3sv(context, v))
        {
            context->texCoord3sv(v);
        }
    }
}

void GL_APIENTRY TexCoord4d(GLdouble s, GLdouble t, GLdouble r, GLdouble q)
{
    EVENT("(GLdouble s = %f, GLdouble t = %f, GLdouble r = %f, GLdouble q = %f)", s, t, r, q);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(TexCoord4d, context, s, t, r, q);
        if (context->skipValidation() || ValidateTexCoord4d(context, s, t, r, q))
        {
            context->texCoord4d(s, t, r, q);
        }
    }
}

void GL_APIENTRY TexCoord4dv(const GLdouble *v)
{
    EVENT("(const GLdouble *v = 0x%016" PRIxPTR ")", (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(TexCoord4dv, context, v);
        if (context->skipValidation() || ValidateTexCoord4dv(context, v))
        {
            context->texCoord4dv(v);
        }
    }
}

void GL_APIENTRY TexCoord4f(GLfloat s, GLfloat t, GLfloat r, GLfloat q)
{
    EVENT("(GLfloat s = %f, GLfloat t = %f, GLfloat r = %f, GLfloat q = %f)", s, t, r, q);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(TexCoord4f, context, s, t, r, q);
        if (context->skipValidation() || ValidateTexCoord4f(context, s, t, r, q))
        {
            context->texCoord4f(s, t, r, q);
        }
    }
}

void GL_APIENTRY TexCoord4fv(const GLfloat *v)
{
    EVENT("(const GLfloat *v = 0x%016" PRIxPTR ")", (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(TexCoord4fv, context, v);
        if (context->skipValidation() || ValidateTexCoord4fv(context, v))
        {
            context->texCoord4fv(v);
        }
    }
}

void GL_APIENTRY TexCoord4i(GLint s, GLint t, GLint r, GLint q)
{
    EVENT("(GLint s = %d, GLint t = %d, GLint r = %d, GLint q = %d)", s, t, r, q);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(TexCoord4i, context, s, t, r, q);
        if (context->skipValidation() || ValidateTexCoord4i(context, s, t, r, q))
        {
            context->texCoord4i(s, t, r, q);
        }
    }
}

void GL_APIENTRY TexCoord4iv(const GLint *v)
{
    EVENT("(const GLint *v = 0x%016" PRIxPTR ")", (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(TexCoord4iv, context, v);
        if (context->skipValidation() || ValidateTexCoord4iv(context, v))
        {
            context->texCoord4iv(v);
        }
    }
}

void GL_APIENTRY TexCoord4s(GLshort s, GLshort t, GLshort r, GLshort q)
{
    EVENT("(GLshort s = %d, GLshort t = %d, GLshort r = %d, GLshort q = %d)", s, t, r, q);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(TexCoord4s, context, s, t, r, q);
        if (context->skipValidation() || ValidateTexCoord4s(context, s, t, r, q))
        {
            context->texCoord4s(s, t, r, q);
        }
    }
}

void GL_APIENTRY TexCoord4sv(const GLshort *v)
{
    EVENT("(const GLshort *v = 0x%016" PRIxPTR ")", (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(TexCoord4sv, context, v);
        if (context->skipValidation() || ValidateTexCoord4sv(context, v))
        {
            context->texCoord4sv(v);
        }
    }
}

void GL_APIENTRY TexEnvf(GLenum target, GLenum pname, GLfloat param)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLfloat param = %f)", target, pname, param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureEnvTarget targetPacked   = FromGLenum<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked = FromGLenum<TextureEnvParameter>(pname);
        ANGLE_CAPTURE(TexEnvf, context, targetPacked, pnamePacked, param);
        if (context->skipValidation() || ValidateTexEnvf(context, targetPacked, pnamePacked, param))
        {
            context->texEnvf(targetPacked, pnamePacked, param);
        }
    }
}

void GL_APIENTRY TexEnvfv(GLenum target, GLenum pname, const GLfloat *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, const GLfloat *params = 0x%016" PRIxPTR ")",
          target, pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureEnvTarget targetPacked   = FromGLenum<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked = FromGLenum<TextureEnvParameter>(pname);
        ANGLE_CAPTURE(TexEnvfv, context, targetPacked, pnamePacked, params);
        if (context->skipValidation() ||
            ValidateTexEnvfv(context, targetPacked, pnamePacked, params))
        {
            context->texEnvfv(targetPacked, pnamePacked, params);
        }
    }
}

void GL_APIENTRY TexEnvi(GLenum target, GLenum pname, GLint param)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLint param = %d)", target, pname, param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureEnvTarget targetPacked   = FromGLenum<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked = FromGLenum<TextureEnvParameter>(pname);
        ANGLE_CAPTURE(TexEnvi, context, targetPacked, pnamePacked, param);
        if (context->skipValidation() || ValidateTexEnvi(context, targetPacked, pnamePacked, param))
        {
            context->texEnvi(targetPacked, pnamePacked, param);
        }
    }
}

void GL_APIENTRY TexEnviv(GLenum target, GLenum pname, const GLint *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, const GLint *params = 0x%016" PRIxPTR ")",
          target, pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureEnvTarget targetPacked   = FromGLenum<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked = FromGLenum<TextureEnvParameter>(pname);
        ANGLE_CAPTURE(TexEnviv, context, targetPacked, pnamePacked, params);
        if (context->skipValidation() ||
            ValidateTexEnviv(context, targetPacked, pnamePacked, params))
        {
            context->texEnviv(targetPacked, pnamePacked, params);
        }
    }
}

void GL_APIENTRY TexGend(GLenum coord, GLenum pname, GLdouble param)
{
    EVENT("(GLenum coord = 0x%X, GLenum pname = 0x%X, GLdouble param = %f)", coord, pname, param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(TexGend, context, coord, pname, param);
        if (context->skipValidation() || ValidateTexGend(context, coord, pname, param))
        {
            context->texGend(coord, pname, param);
        }
    }
}

void GL_APIENTRY TexGendv(GLenum coord, GLenum pname, const GLdouble *params)
{
    EVENT("(GLenum coord = 0x%X, GLenum pname = 0x%X, const GLdouble *params = 0x%016" PRIxPTR ")",
          coord, pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(TexGendv, context, coord, pname, params);
        if (context->skipValidation() || ValidateTexGendv(context, coord, pname, params))
        {
            context->texGendv(coord, pname, params);
        }
    }
}

void GL_APIENTRY TexGenf(GLenum coord, GLenum pname, GLfloat param)
{
    EVENT("(GLenum coord = 0x%X, GLenum pname = 0x%X, GLfloat param = %f)", coord, pname, param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(TexGenf, context, coord, pname, param);
        if (context->skipValidation() || ValidateTexGenf(context, coord, pname, param))
        {
            context->texGenf(coord, pname, param);
        }
    }
}

void GL_APIENTRY TexGenfv(GLenum coord, GLenum pname, const GLfloat *params)
{
    EVENT("(GLenum coord = 0x%X, GLenum pname = 0x%X, const GLfloat *params = 0x%016" PRIxPTR ")",
          coord, pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(TexGenfv, context, coord, pname, params);
        if (context->skipValidation() || ValidateTexGenfv(context, coord, pname, params))
        {
            context->texGenfv(coord, pname, params);
        }
    }
}

void GL_APIENTRY TexGeni(GLenum coord, GLenum pname, GLint param)
{
    EVENT("(GLenum coord = 0x%X, GLenum pname = 0x%X, GLint param = %d)", coord, pname, param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(TexGeni, context, coord, pname, param);
        if (context->skipValidation() || ValidateTexGeni(context, coord, pname, param))
        {
            context->texGeni(coord, pname, param);
        }
    }
}

void GL_APIENTRY TexGeniv(GLenum coord, GLenum pname, const GLint *params)
{
    EVENT("(GLenum coord = 0x%X, GLenum pname = 0x%X, const GLint *params = 0x%016" PRIxPTR ")",
          coord, pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(TexGeniv, context, coord, pname, params);
        if (context->skipValidation() || ValidateTexGeniv(context, coord, pname, params))
        {
            context->texGeniv(coord, pname, params);
        }
    }
}

void GL_APIENTRY TexImage1D(GLenum target,
                            GLint level,
                            GLint internalformat,
                            GLsizei width,
                            GLint border,
                            GLenum format,
                            GLenum type,
                            const void *pixels)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLint internalformat = %d, GLsizei width = %d, "
        "GLint border = %d, GLenum format = 0x%X, GLenum type = 0x%X, const void *pixels = "
        "0x%016" PRIxPTR ")",
        target, level, internalformat, width, border, format, type, (uintptr_t)pixels);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(TexImage1D, context, target, level, internalformat, width, border, format,
                      type, pixels);
        if (context->skipValidation() || ValidateTexImage1D(context, target, level, internalformat,
                                                            width, border, format, type, pixels))
        {
            context->texImage1D(target, level, internalformat, width, border, format, type, pixels);
        }
    }
}

void GL_APIENTRY TexImage2D(GLenum target,
                            GLint level,
                            GLint internalformat,
                            GLsizei width,
                            GLsizei height,
                            GLint border,
                            GLenum format,
                            GLenum type,
                            const void *pixels)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLint internalformat = %d, GLsizei width = %d, "
        "GLsizei height = %d, GLint border = %d, GLenum format = 0x%X, GLenum type = 0x%X, const "
        "void *pixels = 0x%016" PRIxPTR ")",
        target, level, internalformat, width, height, border, format, type, (uintptr_t)pixels);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        ANGLE_CAPTURE(TexImage2D, context, targetPacked, level, internalformat, width, height,
                      border, format, type, pixels);
        if (context->skipValidation() ||
            ValidateTexImage2D(context, targetPacked, level, internalformat, width, height, border,
                               format, type, pixels))
        {
            context->texImage2D(targetPacked, level, internalformat, width, height, border, format,
                                type, pixels);
        }
    }
}

void GL_APIENTRY TexParameterf(GLenum target, GLenum pname, GLfloat param)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLfloat param = %f)", target, pname, param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(TexParameterf, context, targetPacked, pname, param);
        if (context->skipValidation() || ValidateTexParameterf(context, targetPacked, pname, param))
        {
            context->texParameterf(targetPacked, pname, param);
        }
    }
}

void GL_APIENTRY TexParameterfv(GLenum target, GLenum pname, const GLfloat *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, const GLfloat *params = 0x%016" PRIxPTR ")",
          target, pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(TexParameterfv, context, targetPacked, pname, params);
        if (context->skipValidation() ||
            ValidateTexParameterfv(context, targetPacked, pname, params))
        {
            context->texParameterfv(targetPacked, pname, params);
        }
    }
}

void GL_APIENTRY TexParameteri(GLenum target, GLenum pname, GLint param)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLint param = %d)", target, pname, param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(TexParameteri, context, targetPacked, pname, param);
        if (context->skipValidation() || ValidateTexParameteri(context, targetPacked, pname, param))
        {
            context->texParameteri(targetPacked, pname, param);
        }
    }
}

void GL_APIENTRY TexParameteriv(GLenum target, GLenum pname, const GLint *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, const GLint *params = 0x%016" PRIxPTR ")",
          target, pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(TexParameteriv, context, targetPacked, pname, params);
        if (context->skipValidation() ||
            ValidateTexParameteriv(context, targetPacked, pname, params))
        {
            context->texParameteriv(targetPacked, pname, params);
        }
    }
}

void GL_APIENTRY Translated(GLdouble x, GLdouble y, GLdouble z)
{
    EVENT("(GLdouble x = %f, GLdouble y = %f, GLdouble z = %f)", x, y, z);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Translated, context, x, y, z);
        if (context->skipValidation() || ValidateTranslated(context, x, y, z))
        {
            context->translated(x, y, z);
        }
    }
}

void GL_APIENTRY Translatef(GLfloat x, GLfloat y, GLfloat z)
{
    EVENT("(GLfloat x = %f, GLfloat y = %f, GLfloat z = %f)", x, y, z);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Translatef, context, x, y, z);
        if (context->skipValidation() || ValidateTranslatef(context, x, y, z))
        {
            context->translatef(x, y, z);
        }
    }
}

void GL_APIENTRY Vertex2d(GLdouble x, GLdouble y)
{
    EVENT("(GLdouble x = %f, GLdouble y = %f)", x, y);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Vertex2d, context, x, y);
        if (context->skipValidation() || ValidateVertex2d(context, x, y))
        {
            context->vertex2d(x, y);
        }
    }
}

void GL_APIENTRY Vertex2dv(const GLdouble *v)
{
    EVENT("(const GLdouble *v = 0x%016" PRIxPTR ")", (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Vertex2dv, context, v);
        if (context->skipValidation() || ValidateVertex2dv(context, v))
        {
            context->vertex2dv(v);
        }
    }
}

void GL_APIENTRY Vertex2f(GLfloat x, GLfloat y)
{
    EVENT("(GLfloat x = %f, GLfloat y = %f)", x, y);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Vertex2f, context, x, y);
        if (context->skipValidation() || ValidateVertex2f(context, x, y))
        {
            context->vertex2f(x, y);
        }
    }
}

void GL_APIENTRY Vertex2fv(const GLfloat *v)
{
    EVENT("(const GLfloat *v = 0x%016" PRIxPTR ")", (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Vertex2fv, context, v);
        if (context->skipValidation() || ValidateVertex2fv(context, v))
        {
            context->vertex2fv(v);
        }
    }
}

void GL_APIENTRY Vertex2i(GLint x, GLint y)
{
    EVENT("(GLint x = %d, GLint y = %d)", x, y);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Vertex2i, context, x, y);
        if (context->skipValidation() || ValidateVertex2i(context, x, y))
        {
            context->vertex2i(x, y);
        }
    }
}

void GL_APIENTRY Vertex2iv(const GLint *v)
{
    EVENT("(const GLint *v = 0x%016" PRIxPTR ")", (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Vertex2iv, context, v);
        if (context->skipValidation() || ValidateVertex2iv(context, v))
        {
            context->vertex2iv(v);
        }
    }
}

void GL_APIENTRY Vertex2s(GLshort x, GLshort y)
{
    EVENT("(GLshort x = %d, GLshort y = %d)", x, y);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Vertex2s, context, x, y);
        if (context->skipValidation() || ValidateVertex2s(context, x, y))
        {
            context->vertex2s(x, y);
        }
    }
}

void GL_APIENTRY Vertex2sv(const GLshort *v)
{
    EVENT("(const GLshort *v = 0x%016" PRIxPTR ")", (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Vertex2sv, context, v);
        if (context->skipValidation() || ValidateVertex2sv(context, v))
        {
            context->vertex2sv(v);
        }
    }
}

void GL_APIENTRY Vertex3d(GLdouble x, GLdouble y, GLdouble z)
{
    EVENT("(GLdouble x = %f, GLdouble y = %f, GLdouble z = %f)", x, y, z);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Vertex3d, context, x, y, z);
        if (context->skipValidation() || ValidateVertex3d(context, x, y, z))
        {
            context->vertex3d(x, y, z);
        }
    }
}

void GL_APIENTRY Vertex3dv(const GLdouble *v)
{
    EVENT("(const GLdouble *v = 0x%016" PRIxPTR ")", (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Vertex3dv, context, v);
        if (context->skipValidation() || ValidateVertex3dv(context, v))
        {
            context->vertex3dv(v);
        }
    }
}

void GL_APIENTRY Vertex3f(GLfloat x, GLfloat y, GLfloat z)
{
    EVENT("(GLfloat x = %f, GLfloat y = %f, GLfloat z = %f)", x, y, z);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Vertex3f, context, x, y, z);
        if (context->skipValidation() || ValidateVertex3f(context, x, y, z))
        {
            context->vertex3f(x, y, z);
        }
    }
}

void GL_APIENTRY Vertex3fv(const GLfloat *v)
{
    EVENT("(const GLfloat *v = 0x%016" PRIxPTR ")", (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Vertex3fv, context, v);
        if (context->skipValidation() || ValidateVertex3fv(context, v))
        {
            context->vertex3fv(v);
        }
    }
}

void GL_APIENTRY Vertex3i(GLint x, GLint y, GLint z)
{
    EVENT("(GLint x = %d, GLint y = %d, GLint z = %d)", x, y, z);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Vertex3i, context, x, y, z);
        if (context->skipValidation() || ValidateVertex3i(context, x, y, z))
        {
            context->vertex3i(x, y, z);
        }
    }
}

void GL_APIENTRY Vertex3iv(const GLint *v)
{
    EVENT("(const GLint *v = 0x%016" PRIxPTR ")", (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Vertex3iv, context, v);
        if (context->skipValidation() || ValidateVertex3iv(context, v))
        {
            context->vertex3iv(v);
        }
    }
}

void GL_APIENTRY Vertex3s(GLshort x, GLshort y, GLshort z)
{
    EVENT("(GLshort x = %d, GLshort y = %d, GLshort z = %d)", x, y, z);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Vertex3s, context, x, y, z);
        if (context->skipValidation() || ValidateVertex3s(context, x, y, z))
        {
            context->vertex3s(x, y, z);
        }
    }
}

void GL_APIENTRY Vertex3sv(const GLshort *v)
{
    EVENT("(const GLshort *v = 0x%016" PRIxPTR ")", (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Vertex3sv, context, v);
        if (context->skipValidation() || ValidateVertex3sv(context, v))
        {
            context->vertex3sv(v);
        }
    }
}

void GL_APIENTRY Vertex4d(GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
    EVENT("(GLdouble x = %f, GLdouble y = %f, GLdouble z = %f, GLdouble w = %f)", x, y, z, w);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Vertex4d, context, x, y, z, w);
        if (context->skipValidation() || ValidateVertex4d(context, x, y, z, w))
        {
            context->vertex4d(x, y, z, w);
        }
    }
}

void GL_APIENTRY Vertex4dv(const GLdouble *v)
{
    EVENT("(const GLdouble *v = 0x%016" PRIxPTR ")", (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Vertex4dv, context, v);
        if (context->skipValidation() || ValidateVertex4dv(context, v))
        {
            context->vertex4dv(v);
        }
    }
}

void GL_APIENTRY Vertex4f(GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
    EVENT("(GLfloat x = %f, GLfloat y = %f, GLfloat z = %f, GLfloat w = %f)", x, y, z, w);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Vertex4f, context, x, y, z, w);
        if (context->skipValidation() || ValidateVertex4f(context, x, y, z, w))
        {
            context->vertex4f(x, y, z, w);
        }
    }
}

void GL_APIENTRY Vertex4fv(const GLfloat *v)
{
    EVENT("(const GLfloat *v = 0x%016" PRIxPTR ")", (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Vertex4fv, context, v);
        if (context->skipValidation() || ValidateVertex4fv(context, v))
        {
            context->vertex4fv(v);
        }
    }
}

void GL_APIENTRY Vertex4i(GLint x, GLint y, GLint z, GLint w)
{
    EVENT("(GLint x = %d, GLint y = %d, GLint z = %d, GLint w = %d)", x, y, z, w);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Vertex4i, context, x, y, z, w);
        if (context->skipValidation() || ValidateVertex4i(context, x, y, z, w))
        {
            context->vertex4i(x, y, z, w);
        }
    }
}

void GL_APIENTRY Vertex4iv(const GLint *v)
{
    EVENT("(const GLint *v = 0x%016" PRIxPTR ")", (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Vertex4iv, context, v);
        if (context->skipValidation() || ValidateVertex4iv(context, v))
        {
            context->vertex4iv(v);
        }
    }
}

void GL_APIENTRY Vertex4s(GLshort x, GLshort y, GLshort z, GLshort w)
{
    EVENT("(GLshort x = %d, GLshort y = %d, GLshort z = %d, GLshort w = %d)", x, y, z, w);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Vertex4s, context, x, y, z, w);
        if (context->skipValidation() || ValidateVertex4s(context, x, y, z, w))
        {
            context->vertex4s(x, y, z, w);
        }
    }
}

void GL_APIENTRY Vertex4sv(const GLshort *v)
{
    EVENT("(const GLshort *v = 0x%016" PRIxPTR ")", (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Vertex4sv, context, v);
        if (context->skipValidation() || ValidateVertex4sv(context, v))
        {
            context->vertex4sv(v);
        }
    }
}

void GL_APIENTRY Viewport(GLint x, GLint y, GLsizei width, GLsizei height)
{
    EVENT("(GLint x = %d, GLint y = %d, GLsizei width = %d, GLsizei height = %d)", x, y, width,
          height);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Viewport, context, x, y, width, height);
        if (context->skipValidation() || ValidateViewport(context, x, y, width, height))
        {
            context->viewport(x, y, width, height);
        }
    }
}
}  // namespace gl
