// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from gl.xml.
//
// Copyright 2019 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// entry_points_gl_1_2_autogen.cpp:
//   Defines the GL 1.2 entry points.

#include "libGL/entry_points_gl_1_2_autogen.h"

#include "libANGLE/Context.h"
#include "libANGLE/Context.inl.h"
#include "libANGLE/entry_points_utils.h"
#include "libANGLE/validationEGL.h"
#include "libANGLE/validationES.h"
#include "libANGLE/validationES1.h"
#include "libANGLE/validationES2.h"
#include "libANGLE/validationES3.h"
#include "libANGLE/validationES31.h"
#include "libANGLE/validationESEXT.h"
#include "libANGLE/validationGL12_autogen.h"
#include "libGLESv2/global_state.h"

namespace gl
{
void GL_APIENTRY CopyTexSubImage3D(GLenum target,
                                   GLint level,
                                   GLint xoffset,
                                   GLint yoffset,
                                   GLint zoffset,
                                   GLint x,
                                   GLint y,
                                   GLsizei width,
                                   GLsizei height)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLint xoffset = %d, GLint yoffset = %d, GLint "
        "zoffset = %d, GLint x = %d, GLint y = %d, GLsizei width = %d, GLsizei height = %d)",
        target, level, xoffset, yoffset, zoffset, x, y, width, height);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        ANGLE_CAPTURE(CopyTexSubImage3D, context, targetPacked, level, xoffset, yoffset, zoffset, x,
                      y, width, height);
        if (context->skipValidation() ||
            ValidateCopyTexSubImage3D(context, targetPacked, level, xoffset, yoffset, zoffset, x, y,
                                      width, height))
        {
            context->copyTexSubImage3D(targetPacked, level, xoffset, yoffset, zoffset, x, y, width,
                                       height);
        }
    }
}

void GL_APIENTRY DrawRangeElements(GLenum mode,
                                   GLuint start,
                                   GLuint end,
                                   GLsizei count,
                                   GLenum type,
                                   const void *indices)
{
    EVENT(
        "(GLenum mode = 0x%X, GLuint start = %u, GLuint end = %u, GLsizei count = %d, GLenum type "
        "= 0x%X, const void *indices = 0x%016" PRIxPTR ")",
        mode, start, end, count, type, (uintptr_t)indices);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        PrimitiveMode modePacked    = FromGLenum<PrimitiveMode>(mode);
        DrawElementsType typePacked = FromGLenum<DrawElementsType>(type);
        ANGLE_CAPTURE(DrawRangeElements, context, modePacked, start, end, count, typePacked,
                      indices);
        if (context->skipValidation() ||
            ValidateDrawRangeElements(context, modePacked, start, end, count, typePacked, indices))
        {
            context->drawRangeElements(modePacked, start, end, count, typePacked, indices);
        }
    }
}

void GL_APIENTRY TexImage3D(GLenum target,
                            GLint level,
                            GLint internalformat,
                            GLsizei width,
                            GLsizei height,
                            GLsizei depth,
                            GLint border,
                            GLenum format,
                            GLenum type,
                            const void *pixels)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLint internalformat = %d, GLsizei width = %d, "
        "GLsizei height = %d, GLsizei depth = %d, GLint border = %d, GLenum format = 0x%X, GLenum "
        "type = 0x%X, const void *pixels = 0x%016" PRIxPTR ")",
        target, level, internalformat, width, height, depth, border, format, type,
        (uintptr_t)pixels);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        ANGLE_CAPTURE(TexImage3D, context, targetPacked, level, internalformat, width, height,
                      depth, border, format, type, pixels);
        if (context->skipValidation() ||
            ValidateTexImage3D(context, targetPacked, level, internalformat, width, height, depth,
                               border, format, type, pixels))
        {
            context->texImage3D(targetPacked, level, internalformat, width, height, depth, border,
                                format, type, pixels);
        }
    }
}

void GL_APIENTRY TexSubImage3D(GLenum target,
                               GLint level,
                               GLint xoffset,
                               GLint yoffset,
                               GLint zoffset,
                               GLsizei width,
                               GLsizei height,
                               GLsizei depth,
                               GLenum format,
                               GLenum type,
                               const void *pixels)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLint xoffset = %d, GLint yoffset = %d, GLint "
        "zoffset = %d, GLsizei width = %d, GLsizei height = %d, GLsizei depth = %d, GLenum format "
        "= 0x%X, GLenum type = 0x%X, const void *pixels = 0x%016" PRIxPTR ")",
        target, level, xoffset, yoffset, zoffset, width, height, depth, format, type,
        (uintptr_t)pixels);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        ANGLE_CAPTURE(TexSubImage3D, context, targetPacked, level, xoffset, yoffset, zoffset, width,
                      height, depth, format, type, pixels);
        if (context->skipValidation() ||
            ValidateTexSubImage3D(context, targetPacked, level, xoffset, yoffset, zoffset, width,
                                  height, depth, format, type, pixels))
        {
            context->texSubImage3D(targetPacked, level, xoffset, yoffset, zoffset, width, height,
                                   depth, format, type, pixels);
        }
    }
}
}  // namespace gl
