// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from gl.xml.
//
// Copyright 2019 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// entry_points_gl_1_5_autogen.cpp:
//   Defines the GL 1.5 entry points.

#include "libGL/entry_points_gl_1_5_autogen.h"

#include "libANGLE/Context.h"
#include "libANGLE/Context.inl.h"
#include "libANGLE/entry_points_utils.h"
#include "libANGLE/validationEGL.h"
#include "libANGLE/validationES.h"
#include "libANGLE/validationES1.h"
#include "libANGLE/validationES2.h"
#include "libANGLE/validationES3.h"
#include "libANGLE/validationES31.h"
#include "libANGLE/validationESEXT.h"
#include "libANGLE/validationGL15_autogen.h"
#include "libGLESv2/global_state.h"

namespace gl
{
void GL_APIENTRY BeginQuery(GLenum target, GLuint id)
{
    EVENT("(GLenum target = 0x%X, GLuint id = %u)", target, id);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        QueryType targetPacked = FromGLenum<QueryType>(target);
        ANGLE_CAPTURE(BeginQuery, context, targetPacked, id);
        if (context->skipValidation() || ValidateBeginQuery(context, targetPacked, id))
        {
            context->beginQuery(targetPacked, id);
        }
    }
}

void GL_APIENTRY BindBuffer(GLenum target, GLuint buffer)
{
    EVENT("(GLenum target = 0x%X, GLuint buffer = %u)", target, buffer);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        BufferBinding targetPacked = FromGLenum<BufferBinding>(target);
        ANGLE_CAPTURE(BindBuffer, context, targetPacked, buffer);
        if (context->skipValidation() || ValidateBindBuffer(context, targetPacked, buffer))
        {
            context->bindBuffer(targetPacked, buffer);
        }
    }
}

void GL_APIENTRY BufferData(GLenum target, GLsizeiptr size, const void *data, GLenum usage)
{
    EVENT("(GLenum target = 0x%X, GLsizeiptr size = %llu, const void *data = 0x%016" PRIxPTR
          ", GLenum usage = 0x%X)",
          target, static_cast<unsigned long long>(size), (uintptr_t)data, usage);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        BufferBinding targetPacked = FromGLenum<BufferBinding>(target);
        BufferUsage usagePacked    = FromGLenum<BufferUsage>(usage);
        ANGLE_CAPTURE(BufferData, context, targetPacked, size, data, usagePacked);
        if (context->skipValidation() ||
            ValidateBufferData(context, targetPacked, size, data, usagePacked))
        {
            context->bufferData(targetPacked, size, data, usagePacked);
        }
    }
}

void GL_APIENTRY BufferSubData(GLenum target, GLintptr offset, GLsizeiptr size, const void *data)
{
    EVENT(
        "(GLenum target = 0x%X, GLintptr offset = %llu, GLsizeiptr size = %llu, const void *data = "
        "0x%016" PRIxPTR ")",
        target, static_cast<unsigned long long>(offset), static_cast<unsigned long long>(size),
        (uintptr_t)data);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        BufferBinding targetPacked = FromGLenum<BufferBinding>(target);
        ANGLE_CAPTURE(BufferSubData, context, targetPacked, offset, size, data);
        if (context->skipValidation() ||
            ValidateBufferSubData(context, targetPacked, offset, size, data))
        {
            context->bufferSubData(targetPacked, offset, size, data);
        }
    }
}

void GL_APIENTRY DeleteBuffers(GLsizei n, const GLuint *buffers)
{
    EVENT("(GLsizei n = %d, const GLuint *buffers = 0x%016" PRIxPTR ")", n, (uintptr_t)buffers);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(DeleteBuffers, context, n, buffers);
        if (context->skipValidation() || ValidateDeleteBuffers(context, n, buffers))
        {
            context->deleteBuffers(n, buffers);
        }
    }
}

void GL_APIENTRY DeleteQueries(GLsizei n, const GLuint *ids)
{
    EVENT("(GLsizei n = %d, const GLuint *ids = 0x%016" PRIxPTR ")", n, (uintptr_t)ids);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(DeleteQueries, context, n, ids);
        if (context->skipValidation() || ValidateDeleteQueries(context, n, ids))
        {
            context->deleteQueries(n, ids);
        }
    }
}

void GL_APIENTRY EndQuery(GLenum target)
{
    EVENT("(GLenum target = 0x%X)", target);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        QueryType targetPacked = FromGLenum<QueryType>(target);
        ANGLE_CAPTURE(EndQuery, context, targetPacked);
        if (context->skipValidation() || ValidateEndQuery(context, targetPacked))
        {
            context->endQuery(targetPacked);
        }
    }
}

void GL_APIENTRY GenBuffers(GLsizei n, GLuint *buffers)
{
    EVENT("(GLsizei n = %d, GLuint *buffers = 0x%016" PRIxPTR ")", n, (uintptr_t)buffers);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GenBuffers, context, n, buffers);
        if (context->skipValidation() || ValidateGenBuffers(context, n, buffers))
        {
            context->genBuffers(n, buffers);
        }
    }
}

void GL_APIENTRY GenQueries(GLsizei n, GLuint *ids)
{
    EVENT("(GLsizei n = %d, GLuint *ids = 0x%016" PRIxPTR ")", n, (uintptr_t)ids);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GenQueries, context, n, ids);
        if (context->skipValidation() || ValidateGenQueries(context, n, ids))
        {
            context->genQueries(n, ids);
        }
    }
}

void GL_APIENTRY GetBufferParameteriv(GLenum target, GLenum pname, GLint *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLint *params = 0x%016" PRIxPTR ")", target,
          pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        BufferBinding targetPacked = FromGLenum<BufferBinding>(target);
        ANGLE_CAPTURE(GetBufferParameteriv, context, targetPacked, pname, params);
        if (context->skipValidation() ||
            ValidateGetBufferParameteriv(context, targetPacked, pname, params))
        {
            context->getBufferParameteriv(targetPacked, pname, params);
        }
    }
}

void GL_APIENTRY GetBufferPointerv(GLenum target, GLenum pname, void **params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, void **params = 0x%016" PRIxPTR ")", target,
          pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        BufferBinding targetPacked = FromGLenum<BufferBinding>(target);
        ANGLE_CAPTURE(GetBufferPointerv, context, targetPacked, pname, params);
        if (context->skipValidation() ||
            ValidateGetBufferPointerv(context, targetPacked, pname, params))
        {
            context->getBufferPointerv(targetPacked, pname, params);
        }
    }
}

void GL_APIENTRY GetBufferSubData(GLenum target, GLintptr offset, GLsizeiptr size, void *data)
{
    EVENT(
        "(GLenum target = 0x%X, GLintptr offset = %llu, GLsizeiptr size = %llu, void *data = "
        "0x%016" PRIxPTR ")",
        target, static_cast<unsigned long long>(offset), static_cast<unsigned long long>(size),
        (uintptr_t)data);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetBufferSubData, context, target, offset, size, data);
        if (context->skipValidation() ||
            ValidateGetBufferSubData(context, target, offset, size, data))
        {
            context->getBufferSubData(target, offset, size, data);
        }
    }
}

void GL_APIENTRY GetQueryObjectiv(GLuint id, GLenum pname, GLint *params)
{
    EVENT("(GLuint id = %u, GLenum pname = 0x%X, GLint *params = 0x%016" PRIxPTR ")", id, pname,
          (uintptr_t)params);

    Context *context = GetGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetQueryObjectiv, context, id, pname, params);
        if (context->skipValidation() || ValidateGetQueryObjectiv(context, id, pname, params))
        {
            context->getQueryObjectiv(id, pname, params);
        }
    }
}

void GL_APIENTRY GetQueryObjectuiv(GLuint id, GLenum pname, GLuint *params)
{
    EVENT("(GLuint id = %u, GLenum pname = 0x%X, GLuint *params = 0x%016" PRIxPTR ")", id, pname,
          (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetQueryObjectuiv, context, id, pname, params);
        if (context->skipValidation() || ValidateGetQueryObjectuiv(context, id, pname, params))
        {
            context->getQueryObjectuiv(id, pname, params);
        }
    }
}

void GL_APIENTRY GetQueryiv(GLenum target, GLenum pname, GLint *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLint *params = 0x%016" PRIxPTR ")", target,
          pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        QueryType targetPacked = FromGLenum<QueryType>(target);
        ANGLE_CAPTURE(GetQueryiv, context, targetPacked, pname, params);
        if (context->skipValidation() || ValidateGetQueryiv(context, targetPacked, pname, params))
        {
            context->getQueryiv(targetPacked, pname, params);
        }
    }
}

GLboolean GL_APIENTRY IsBuffer(GLuint buffer)
{
    EVENT("(GLuint buffer = %u)", buffer);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(IsBuffer, context, buffer);
        if (context->skipValidation() || ValidateIsBuffer(context, buffer))
        {
            return context->isBuffer(buffer);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsBuffer, GLboolean>();
}

GLboolean GL_APIENTRY IsQuery(GLuint id)
{
    EVENT("(GLuint id = %u)", id);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(IsQuery, context, id);
        if (context->skipValidation() || ValidateIsQuery(context, id))
        {
            return context->isQuery(id);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsQuery, GLboolean>();
}

void *GL_APIENTRY MapBuffer(GLenum target, GLenum access)
{
    EVENT("(GLenum target = 0x%X, GLenum access = 0x%X)", target, access);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        BufferBinding targetPacked = FromGLenum<BufferBinding>(target);
        ANGLE_CAPTURE(MapBuffer, context, targetPacked, access);
        if (context->skipValidation() || ValidateMapBuffer(context, targetPacked, access))
        {
            return context->mapBuffer(targetPacked, access);
        }
    }

    return GetDefaultReturnValue<EntryPoint::MapBuffer, void *>();
}

GLboolean GL_APIENTRY UnmapBuffer(GLenum target)
{
    EVENT("(GLenum target = 0x%X)", target);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        BufferBinding targetPacked = FromGLenum<BufferBinding>(target);
        ANGLE_CAPTURE(UnmapBuffer, context, targetPacked);
        if (context->skipValidation() || ValidateUnmapBuffer(context, targetPacked))
        {
            return context->unmapBuffer(targetPacked);
        }
    }

    return GetDefaultReturnValue<EntryPoint::UnmapBuffer, GLboolean>();
}
}  // namespace gl
