// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from gl.xml.
//
// Copyright 2019 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// entry_points_gl_2_0_autogen.cpp:
//   Defines the GL 2.0 entry points.

#include "libGL/entry_points_gl_2_0_autogen.h"

#include "libANGLE/Context.h"
#include "libANGLE/Context.inl.h"
#include "libANGLE/entry_points_utils.h"
#include "libANGLE/validationEGL.h"
#include "libANGLE/validationES.h"
#include "libANGLE/validationES1.h"
#include "libANGLE/validationES2.h"
#include "libANGLE/validationES3.h"
#include "libANGLE/validationES31.h"
#include "libANGLE/validationESEXT.h"
#include "libANGLE/validationGL2_autogen.h"
#include "libGLESv2/global_state.h"

namespace gl
{
void GL_APIENTRY AttachShader(GLuint program, GLuint shader)
{
    EVENT("(GLuint program = %u, GLuint shader = %u)", program, shader);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(AttachShader, context, program, shader);
        if (context->skipValidation() || ValidateAttachShader(context, program, shader))
        {
            context->attachShader(program, shader);
        }
    }
}

void GL_APIENTRY BindAttribLocation(GLuint program, GLuint index, const GLchar *name)
{
    EVENT("(GLuint program = %u, GLuint index = %u, const GLchar *name = 0x%016" PRIxPTR ")",
          program, index, (uintptr_t)name);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(BindAttribLocation, context, program, index, name);
        if (context->skipValidation() || ValidateBindAttribLocation(context, program, index, name))
        {
            context->bindAttribLocation(program, index, name);
        }
    }
}

void GL_APIENTRY BlendEquationSeparate(GLenum modeRGB, GLenum modeAlpha)
{
    EVENT("(GLenum modeRGB = 0x%X, GLenum modeAlpha = 0x%X)", modeRGB, modeAlpha);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(BlendEquationSeparate, context, modeRGB, modeAlpha);
        if (context->skipValidation() || ValidateBlendEquationSeparate(context, modeRGB, modeAlpha))
        {
            context->blendEquationSeparate(modeRGB, modeAlpha);
        }
    }
}

void GL_APIENTRY CompileShader(GLuint shader)
{
    EVENT("(GLuint shader = %u)", shader);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(CompileShader, context, shader);
        if (context->skipValidation() || ValidateCompileShader(context, shader))
        {
            context->compileShader(shader);
        }
    }
}

GLuint GL_APIENTRY CreateProgram()
{
    EVENT("()");

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(CreateProgram, context);
        if (context->skipValidation() || ValidateCreateProgram(context))
        {
            return context->createProgram();
        }
    }

    return GetDefaultReturnValue<EntryPoint::CreateProgram, GLuint>();
}

GLuint GL_APIENTRY CreateShader(GLenum type)
{
    EVENT("(GLenum type = 0x%X)", type);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ShaderType typePacked = FromGLenum<ShaderType>(type);
        ANGLE_CAPTURE(CreateShader, context, typePacked);
        if (context->skipValidation() || ValidateCreateShader(context, typePacked))
        {
            return context->createShader(typePacked);
        }
    }

    return GetDefaultReturnValue<EntryPoint::CreateShader, GLuint>();
}

void GL_APIENTRY DeleteProgram(GLuint program)
{
    EVENT("(GLuint program = %u)", program);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(DeleteProgram, context, program);
        if (context->skipValidation() || ValidateDeleteProgram(context, program))
        {
            context->deleteProgram(program);
        }
    }
}

void GL_APIENTRY DeleteShader(GLuint shader)
{
    EVENT("(GLuint shader = %u)", shader);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(DeleteShader, context, shader);
        if (context->skipValidation() || ValidateDeleteShader(context, shader))
        {
            context->deleteShader(shader);
        }
    }
}

void GL_APIENTRY DetachShader(GLuint program, GLuint shader)
{
    EVENT("(GLuint program = %u, GLuint shader = %u)", program, shader);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(DetachShader, context, program, shader);
        if (context->skipValidation() || ValidateDetachShader(context, program, shader))
        {
            context->detachShader(program, shader);
        }
    }
}

void GL_APIENTRY DisableVertexAttribArray(GLuint index)
{
    EVENT("(GLuint index = %u)", index);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(DisableVertexAttribArray, context, index);
        if (context->skipValidation() || ValidateDisableVertexAttribArray(context, index))
        {
            context->disableVertexAttribArray(index);
        }
    }
}

void GL_APIENTRY DrawBuffers(GLsizei n, const GLenum *bufs)
{
    EVENT("(GLsizei n = %d, const GLenum *bufs = 0x%016" PRIxPTR ")", n, (uintptr_t)bufs);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(DrawBuffers, context, n, bufs);
        if (context->skipValidation() || ValidateDrawBuffers(context, n, bufs))
        {
            context->drawBuffers(n, bufs);
        }
    }
}

void GL_APIENTRY EnableVertexAttribArray(GLuint index)
{
    EVENT("(GLuint index = %u)", index);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(EnableVertexAttribArray, context, index);
        if (context->skipValidation() || ValidateEnableVertexAttribArray(context, index))
        {
            context->enableVertexAttribArray(index);
        }
    }
}

void GL_APIENTRY GetActiveAttrib(GLuint program,
                                 GLuint index,
                                 GLsizei bufSize,
                                 GLsizei *length,
                                 GLint *size,
                                 GLenum *type,
                                 GLchar *name)
{
    EVENT(
        "(GLuint program = %u, GLuint index = %u, GLsizei bufSize = %d, GLsizei *length = "
        "0x%016" PRIxPTR ", GLint *size = 0x%016" PRIxPTR ", GLenum *type = 0x%016" PRIxPTR
        ", GLchar *name = 0x%016" PRIxPTR ")",
        program, index, bufSize, (uintptr_t)length, (uintptr_t)size, (uintptr_t)type,
        (uintptr_t)name);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetActiveAttrib, context, program, index, bufSize, length, size, type, name);
        if (context->skipValidation() ||
            ValidateGetActiveAttrib(context, program, index, bufSize, length, size, type, name))
        {
            context->getActiveAttrib(program, index, bufSize, length, size, type, name);
        }
    }
}

void GL_APIENTRY GetActiveUniform(GLuint program,
                                  GLuint index,
                                  GLsizei bufSize,
                                  GLsizei *length,
                                  GLint *size,
                                  GLenum *type,
                                  GLchar *name)
{
    EVENT(
        "(GLuint program = %u, GLuint index = %u, GLsizei bufSize = %d, GLsizei *length = "
        "0x%016" PRIxPTR ", GLint *size = 0x%016" PRIxPTR ", GLenum *type = 0x%016" PRIxPTR
        ", GLchar *name = 0x%016" PRIxPTR ")",
        program, index, bufSize, (uintptr_t)length, (uintptr_t)size, (uintptr_t)type,
        (uintptr_t)name);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetActiveUniform, context, program, index, bufSize, length, size, type, name);
        if (context->skipValidation() ||
            ValidateGetActiveUniform(context, program, index, bufSize, length, size, type, name))
        {
            context->getActiveUniform(program, index, bufSize, length, size, type, name);
        }
    }
}

void GL_APIENTRY GetAttachedShaders(GLuint program,
                                    GLsizei maxCount,
                                    GLsizei *count,
                                    GLuint *shaders)
{
    EVENT("(GLuint program = %u, GLsizei maxCount = %d, GLsizei *count = 0x%016" PRIxPTR
          ", GLuint *shaders = 0x%016" PRIxPTR ")",
          program, maxCount, (uintptr_t)count, (uintptr_t)shaders);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetAttachedShaders, context, program, maxCount, count, shaders);
        if (context->skipValidation() ||
            ValidateGetAttachedShaders(context, program, maxCount, count, shaders))
        {
            context->getAttachedShaders(program, maxCount, count, shaders);
        }
    }
}

GLint GL_APIENTRY GetAttribLocation(GLuint program, const GLchar *name)
{
    EVENT("(GLuint program = %u, const GLchar *name = 0x%016" PRIxPTR ")", program,
          (uintptr_t)name);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetAttribLocation, context, program, name);
        if (context->skipValidation() || ValidateGetAttribLocation(context, program, name))
        {
            return context->getAttribLocation(program, name);
        }
    }

    return GetDefaultReturnValue<EntryPoint::GetAttribLocation, GLint>();
}

void GL_APIENTRY GetProgramInfoLog(GLuint program,
                                   GLsizei bufSize,
                                   GLsizei *length,
                                   GLchar *infoLog)
{
    EVENT("(GLuint program = %u, GLsizei bufSize = %d, GLsizei *length = 0x%016" PRIxPTR
          ", GLchar *infoLog = 0x%016" PRIxPTR ")",
          program, bufSize, (uintptr_t)length, (uintptr_t)infoLog);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetProgramInfoLog, context, program, bufSize, length, infoLog);
        if (context->skipValidation() ||
            ValidateGetProgramInfoLog(context, program, bufSize, length, infoLog))
        {
            context->getProgramInfoLog(program, bufSize, length, infoLog);
        }
    }
}

void GL_APIENTRY GetProgramiv(GLuint program, GLenum pname, GLint *params)
{
    EVENT("(GLuint program = %u, GLenum pname = 0x%X, GLint *params = 0x%016" PRIxPTR ")", program,
          pname, (uintptr_t)params);

    Context *context = GetGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetProgramiv, context, program, pname, params);
        if (context->skipValidation() || ValidateGetProgramiv(context, program, pname, params))
        {
            context->getProgramiv(program, pname, params);
        }
    }
}

void GL_APIENTRY GetShaderInfoLog(GLuint shader, GLsizei bufSize, GLsizei *length, GLchar *infoLog)
{
    EVENT("(GLuint shader = %u, GLsizei bufSize = %d, GLsizei *length = 0x%016" PRIxPTR
          ", GLchar *infoLog = 0x%016" PRIxPTR ")",
          shader, bufSize, (uintptr_t)length, (uintptr_t)infoLog);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetShaderInfoLog, context, shader, bufSize, length, infoLog);
        if (context->skipValidation() ||
            ValidateGetShaderInfoLog(context, shader, bufSize, length, infoLog))
        {
            context->getShaderInfoLog(shader, bufSize, length, infoLog);
        }
    }
}

void GL_APIENTRY GetShaderSource(GLuint shader, GLsizei bufSize, GLsizei *length, GLchar *source)
{
    EVENT("(GLuint shader = %u, GLsizei bufSize = %d, GLsizei *length = 0x%016" PRIxPTR
          ", GLchar *source = 0x%016" PRIxPTR ")",
          shader, bufSize, (uintptr_t)length, (uintptr_t)source);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetShaderSource, context, shader, bufSize, length, source);
        if (context->skipValidation() ||
            ValidateGetShaderSource(context, shader, bufSize, length, source))
        {
            context->getShaderSource(shader, bufSize, length, source);
        }
    }
}

void GL_APIENTRY GetShaderiv(GLuint shader, GLenum pname, GLint *params)
{
    EVENT("(GLuint shader = %u, GLenum pname = 0x%X, GLint *params = 0x%016" PRIxPTR ")", shader,
          pname, (uintptr_t)params);

    Context *context = GetGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetShaderiv, context, shader, pname, params);
        if (context->skipValidation() || ValidateGetShaderiv(context, shader, pname, params))
        {
            context->getShaderiv(shader, pname, params);
        }
    }
}

GLint GL_APIENTRY GetUniformLocation(GLuint program, const GLchar *name)
{
    EVENT("(GLuint program = %u, const GLchar *name = 0x%016" PRIxPTR ")", program,
          (uintptr_t)name);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetUniformLocation, context, program, name);
        if (context->skipValidation() || ValidateGetUniformLocation(context, program, name))
        {
            return context->getUniformLocation(program, name);
        }
    }

    return GetDefaultReturnValue<EntryPoint::GetUniformLocation, GLint>();
}

void GL_APIENTRY GetUniformfv(GLuint program, GLint location, GLfloat *params)
{
    EVENT("(GLuint program = %u, GLint location = %d, GLfloat *params = 0x%016" PRIxPTR ")",
          program, location, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetUniformfv, context, program, location, params);
        if (context->skipValidation() || ValidateGetUniformfv(context, program, location, params))
        {
            context->getUniformfv(program, location, params);
        }
    }
}

void GL_APIENTRY GetUniformiv(GLuint program, GLint location, GLint *params)
{
    EVENT("(GLuint program = %u, GLint location = %d, GLint *params = 0x%016" PRIxPTR ")", program,
          location, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetUniformiv, context, program, location, params);
        if (context->skipValidation() || ValidateGetUniformiv(context, program, location, params))
        {
            context->getUniformiv(program, location, params);
        }
    }
}

void GL_APIENTRY GetVertexAttribPointerv(GLuint index, GLenum pname, void **pointer)
{
    EVENT("(GLuint index = %u, GLenum pname = 0x%X, void **pointer = 0x%016" PRIxPTR ")", index,
          pname, (uintptr_t)pointer);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetVertexAttribPointerv, context, index, pname, pointer);
        if (context->skipValidation() ||
            ValidateGetVertexAttribPointerv(context, index, pname, pointer))
        {
            context->getVertexAttribPointerv(index, pname, pointer);
        }
    }
}

void GL_APIENTRY GetVertexAttribdv(GLuint index, GLenum pname, GLdouble *params)
{
    EVENT("(GLuint index = %u, GLenum pname = 0x%X, GLdouble *params = 0x%016" PRIxPTR ")", index,
          pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetVertexAttribdv, context, index, pname, params);
        if (context->skipValidation() || ValidateGetVertexAttribdv(context, index, pname, params))
        {
            context->getVertexAttribdv(index, pname, params);
        }
    }
}

void GL_APIENTRY GetVertexAttribfv(GLuint index, GLenum pname, GLfloat *params)
{
    EVENT("(GLuint index = %u, GLenum pname = 0x%X, GLfloat *params = 0x%016" PRIxPTR ")", index,
          pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetVertexAttribfv, context, index, pname, params);
        if (context->skipValidation() || ValidateGetVertexAttribfv(context, index, pname, params))
        {
            context->getVertexAttribfv(index, pname, params);
        }
    }
}

void GL_APIENTRY GetVertexAttribiv(GLuint index, GLenum pname, GLint *params)
{
    EVENT("(GLuint index = %u, GLenum pname = 0x%X, GLint *params = 0x%016" PRIxPTR ")", index,
          pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetVertexAttribiv, context, index, pname, params);
        if (context->skipValidation() || ValidateGetVertexAttribiv(context, index, pname, params))
        {
            context->getVertexAttribiv(index, pname, params);
        }
    }
}

GLboolean GL_APIENTRY IsProgram(GLuint program)
{
    EVENT("(GLuint program = %u)", program);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(IsProgram, context, program);
        if (context->skipValidation() || ValidateIsProgram(context, program))
        {
            return context->isProgram(program);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsProgram, GLboolean>();
}

GLboolean GL_APIENTRY IsShader(GLuint shader)
{
    EVENT("(GLuint shader = %u)", shader);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(IsShader, context, shader);
        if (context->skipValidation() || ValidateIsShader(context, shader))
        {
            return context->isShader(shader);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsShader, GLboolean>();
}

void GL_APIENTRY LinkProgram(GLuint program)
{
    EVENT("(GLuint program = %u)", program);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(LinkProgram, context, program);
        if (context->skipValidation() || ValidateLinkProgram(context, program))
        {
            context->linkProgram(program);
        }
    }
}

void GL_APIENTRY ShaderSource(GLuint shader,
                              GLsizei count,
                              const GLchar *const *string,
                              const GLint *length)
{
    EVENT("(GLuint shader = %u, GLsizei count = %d, const GLchar *const*string = 0x%016" PRIxPTR
          ", const GLint *length = 0x%016" PRIxPTR ")",
          shader, count, (uintptr_t)string, (uintptr_t)length);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(ShaderSource, context, shader, count, string, length);
        if (context->skipValidation() ||
            ValidateShaderSource(context, shader, count, string, length))
        {
            context->shaderSource(shader, count, string, length);
        }
    }
}

void GL_APIENTRY StencilFuncSeparate(GLenum face, GLenum func, GLint ref, GLuint mask)
{
    EVENT("(GLenum face = 0x%X, GLenum func = 0x%X, GLint ref = %d, GLuint mask = %u)", face, func,
          ref, mask);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(StencilFuncSeparate, context, face, func, ref, mask);
        if (context->skipValidation() ||
            ValidateStencilFuncSeparate(context, face, func, ref, mask))
        {
            context->stencilFuncSeparate(face, func, ref, mask);
        }
    }
}

void GL_APIENTRY StencilMaskSeparate(GLenum face, GLuint mask)
{
    EVENT("(GLenum face = 0x%X, GLuint mask = %u)", face, mask);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(StencilMaskSeparate, context, face, mask);
        if (context->skipValidation() || ValidateStencilMaskSeparate(context, face, mask))
        {
            context->stencilMaskSeparate(face, mask);
        }
    }
}

void GL_APIENTRY StencilOpSeparate(GLenum face, GLenum sfail, GLenum dpfail, GLenum dppass)
{
    EVENT("(GLenum face = 0x%X, GLenum sfail = 0x%X, GLenum dpfail = 0x%X, GLenum dppass = 0x%X)",
          face, sfail, dpfail, dppass);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(StencilOpSeparate, context, face, sfail, dpfail, dppass);
        if (context->skipValidation() ||
            ValidateStencilOpSeparate(context, face, sfail, dpfail, dppass))
        {
            context->stencilOpSeparate(face, sfail, dpfail, dppass);
        }
    }
}

void GL_APIENTRY Uniform1f(GLint location, GLfloat v0)
{
    EVENT("(GLint location = %d, GLfloat v0 = %f)", location, v0);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Uniform1f, context, location, v0);
        if (context->skipValidation() || ValidateUniform1f(context, location, v0))
        {
            context->uniform1f(location, v0);
        }
    }
}

void GL_APIENTRY Uniform1fv(GLint location, GLsizei count, const GLfloat *value)
{
    EVENT("(GLint location = %d, GLsizei count = %d, const GLfloat *value = 0x%016" PRIxPTR ")",
          location, count, (uintptr_t)value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Uniform1fv, context, location, count, value);
        if (context->skipValidation() || ValidateUniform1fv(context, location, count, value))
        {
            context->uniform1fv(location, count, value);
        }
    }
}

void GL_APIENTRY Uniform1i(GLint location, GLint v0)
{
    EVENT("(GLint location = %d, GLint v0 = %d)", location, v0);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Uniform1i, context, location, v0);
        if (context->skipValidation() || ValidateUniform1i(context, location, v0))
        {
            context->uniform1i(location, v0);
        }
    }
}

void GL_APIENTRY Uniform1iv(GLint location, GLsizei count, const GLint *value)
{
    EVENT("(GLint location = %d, GLsizei count = %d, const GLint *value = 0x%016" PRIxPTR ")",
          location, count, (uintptr_t)value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Uniform1iv, context, location, count, value);
        if (context->skipValidation() || ValidateUniform1iv(context, location, count, value))
        {
            context->uniform1iv(location, count, value);
        }
    }
}

void GL_APIENTRY Uniform2f(GLint location, GLfloat v0, GLfloat v1)
{
    EVENT("(GLint location = %d, GLfloat v0 = %f, GLfloat v1 = %f)", location, v0, v1);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Uniform2f, context, location, v0, v1);
        if (context->skipValidation() || ValidateUniform2f(context, location, v0, v1))
        {
            context->uniform2f(location, v0, v1);
        }
    }
}

void GL_APIENTRY Uniform2fv(GLint location, GLsizei count, const GLfloat *value)
{
    EVENT("(GLint location = %d, GLsizei count = %d, const GLfloat *value = 0x%016" PRIxPTR ")",
          location, count, (uintptr_t)value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Uniform2fv, context, location, count, value);
        if (context->skipValidation() || ValidateUniform2fv(context, location, count, value))
        {
            context->uniform2fv(location, count, value);
        }
    }
}

void GL_APIENTRY Uniform2i(GLint location, GLint v0, GLint v1)
{
    EVENT("(GLint location = %d, GLint v0 = %d, GLint v1 = %d)", location, v0, v1);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Uniform2i, context, location, v0, v1);
        if (context->skipValidation() || ValidateUniform2i(context, location, v0, v1))
        {
            context->uniform2i(location, v0, v1);
        }
    }
}

void GL_APIENTRY Uniform2iv(GLint location, GLsizei count, const GLint *value)
{
    EVENT("(GLint location = %d, GLsizei count = %d, const GLint *value = 0x%016" PRIxPTR ")",
          location, count, (uintptr_t)value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Uniform2iv, context, location, count, value);
        if (context->skipValidation() || ValidateUniform2iv(context, location, count, value))
        {
            context->uniform2iv(location, count, value);
        }
    }
}

void GL_APIENTRY Uniform3f(GLint location, GLfloat v0, GLfloat v1, GLfloat v2)
{
    EVENT("(GLint location = %d, GLfloat v0 = %f, GLfloat v1 = %f, GLfloat v2 = %f)", location, v0,
          v1, v2);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Uniform3f, context, location, v0, v1, v2);
        if (context->skipValidation() || ValidateUniform3f(context, location, v0, v1, v2))
        {
            context->uniform3f(location, v0, v1, v2);
        }
    }
}

void GL_APIENTRY Uniform3fv(GLint location, GLsizei count, const GLfloat *value)
{
    EVENT("(GLint location = %d, GLsizei count = %d, const GLfloat *value = 0x%016" PRIxPTR ")",
          location, count, (uintptr_t)value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Uniform3fv, context, location, count, value);
        if (context->skipValidation() || ValidateUniform3fv(context, location, count, value))
        {
            context->uniform3fv(location, count, value);
        }
    }
}

void GL_APIENTRY Uniform3i(GLint location, GLint v0, GLint v1, GLint v2)
{
    EVENT("(GLint location = %d, GLint v0 = %d, GLint v1 = %d, GLint v2 = %d)", location, v0, v1,
          v2);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Uniform3i, context, location, v0, v1, v2);
        if (context->skipValidation() || ValidateUniform3i(context, location, v0, v1, v2))
        {
            context->uniform3i(location, v0, v1, v2);
        }
    }
}

void GL_APIENTRY Uniform3iv(GLint location, GLsizei count, const GLint *value)
{
    EVENT("(GLint location = %d, GLsizei count = %d, const GLint *value = 0x%016" PRIxPTR ")",
          location, count, (uintptr_t)value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Uniform3iv, context, location, count, value);
        if (context->skipValidation() || ValidateUniform3iv(context, location, count, value))
        {
            context->uniform3iv(location, count, value);
        }
    }
}

void GL_APIENTRY Uniform4f(GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3)
{
    EVENT(
        "(GLint location = %d, GLfloat v0 = %f, GLfloat v1 = %f, GLfloat v2 = %f, GLfloat v3 = %f)",
        location, v0, v1, v2, v3);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Uniform4f, context, location, v0, v1, v2, v3);
        if (context->skipValidation() || ValidateUniform4f(context, location, v0, v1, v2, v3))
        {
            context->uniform4f(location, v0, v1, v2, v3);
        }
    }
}

void GL_APIENTRY Uniform4fv(GLint location, GLsizei count, const GLfloat *value)
{
    EVENT("(GLint location = %d, GLsizei count = %d, const GLfloat *value = 0x%016" PRIxPTR ")",
          location, count, (uintptr_t)value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Uniform4fv, context, location, count, value);
        if (context->skipValidation() || ValidateUniform4fv(context, location, count, value))
        {
            context->uniform4fv(location, count, value);
        }
    }
}

void GL_APIENTRY Uniform4i(GLint location, GLint v0, GLint v1, GLint v2, GLint v3)
{
    EVENT("(GLint location = %d, GLint v0 = %d, GLint v1 = %d, GLint v2 = %d, GLint v3 = %d)",
          location, v0, v1, v2, v3);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Uniform4i, context, location, v0, v1, v2, v3);
        if (context->skipValidation() || ValidateUniform4i(context, location, v0, v1, v2, v3))
        {
            context->uniform4i(location, v0, v1, v2, v3);
        }
    }
}

void GL_APIENTRY Uniform4iv(GLint location, GLsizei count, const GLint *value)
{
    EVENT("(GLint location = %d, GLsizei count = %d, const GLint *value = 0x%016" PRIxPTR ")",
          location, count, (uintptr_t)value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Uniform4iv, context, location, count, value);
        if (context->skipValidation() || ValidateUniform4iv(context, location, count, value))
        {
            context->uniform4iv(location, count, value);
        }
    }
}

void GL_APIENTRY UniformMatrix2fv(GLint location,
                                  GLsizei count,
                                  GLboolean transpose,
                                  const GLfloat *value)
{
    EVENT(
        "(GLint location = %d, GLsizei count = %d, GLboolean transpose = %u, const GLfloat *value "
        "= 0x%016" PRIxPTR ")",
        location, count, transpose, (uintptr_t)value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(UniformMatrix2fv, context, location, count, transpose, value);
        if (context->skipValidation() ||
            ValidateUniformMatrix2fv(context, location, count, transpose, value))
        {
            context->uniformMatrix2fv(location, count, transpose, value);
        }
    }
}

void GL_APIENTRY UniformMatrix3fv(GLint location,
                                  GLsizei count,
                                  GLboolean transpose,
                                  const GLfloat *value)
{
    EVENT(
        "(GLint location = %d, GLsizei count = %d, GLboolean transpose = %u, const GLfloat *value "
        "= 0x%016" PRIxPTR ")",
        location, count, transpose, (uintptr_t)value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(UniformMatrix3fv, context, location, count, transpose, value);
        if (context->skipValidation() ||
            ValidateUniformMatrix3fv(context, location, count, transpose, value))
        {
            context->uniformMatrix3fv(location, count, transpose, value);
        }
    }
}

void GL_APIENTRY UniformMatrix4fv(GLint location,
                                  GLsizei count,
                                  GLboolean transpose,
                                  const GLfloat *value)
{
    EVENT(
        "(GLint location = %d, GLsizei count = %d, GLboolean transpose = %u, const GLfloat *value "
        "= 0x%016" PRIxPTR ")",
        location, count, transpose, (uintptr_t)value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(UniformMatrix4fv, context, location, count, transpose, value);
        if (context->skipValidation() ||
            ValidateUniformMatrix4fv(context, location, count, transpose, value))
        {
            context->uniformMatrix4fv(location, count, transpose, value);
        }
    }
}

void GL_APIENTRY UseProgram(GLuint program)
{
    EVENT("(GLuint program = %u)", program);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(UseProgram, context, program);
        if (context->skipValidation() || ValidateUseProgram(context, program))
        {
            context->useProgram(program);
        }
    }
}

void GL_APIENTRY ValidateProgram(GLuint program)
{
    EVENT("(GLuint program = %u)", program);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(ValidateProgram, context, program);
        if (context->skipValidation() || ValidateValidateProgram(context, program))
        {
            context->validateProgram(program);
        }
    }
}

void GL_APIENTRY VertexAttrib1d(GLuint index, GLdouble x)
{
    EVENT("(GLuint index = %u, GLdouble x = %f)", index, x);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttrib1d, context, index, x);
        if (context->skipValidation() || ValidateVertexAttrib1d(context, index, x))
        {
            context->vertexAttrib1d(index, x);
        }
    }
}

void GL_APIENTRY VertexAttrib1dv(GLuint index, const GLdouble *v)
{
    EVENT("(GLuint index = %u, const GLdouble *v = 0x%016" PRIxPTR ")", index, (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttrib1dv, context, index, v);
        if (context->skipValidation() || ValidateVertexAttrib1dv(context, index, v))
        {
            context->vertexAttrib1dv(index, v);
        }
    }
}

void GL_APIENTRY VertexAttrib1f(GLuint index, GLfloat x)
{
    EVENT("(GLuint index = %u, GLfloat x = %f)", index, x);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttrib1f, context, index, x);
        if (context->skipValidation() || ValidateVertexAttrib1f(context, index, x))
        {
            context->vertexAttrib1f(index, x);
        }
    }
}

void GL_APIENTRY VertexAttrib1fv(GLuint index, const GLfloat *v)
{
    EVENT("(GLuint index = %u, const GLfloat *v = 0x%016" PRIxPTR ")", index, (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttrib1fv, context, index, v);
        if (context->skipValidation() || ValidateVertexAttrib1fv(context, index, v))
        {
            context->vertexAttrib1fv(index, v);
        }
    }
}

void GL_APIENTRY VertexAttrib1s(GLuint index, GLshort x)
{
    EVENT("(GLuint index = %u, GLshort x = %d)", index, x);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttrib1s, context, index, x);
        if (context->skipValidation() || ValidateVertexAttrib1s(context, index, x))
        {
            context->vertexAttrib1s(index, x);
        }
    }
}

void GL_APIENTRY VertexAttrib1sv(GLuint index, const GLshort *v)
{
    EVENT("(GLuint index = %u, const GLshort *v = 0x%016" PRIxPTR ")", index, (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttrib1sv, context, index, v);
        if (context->skipValidation() || ValidateVertexAttrib1sv(context, index, v))
        {
            context->vertexAttrib1sv(index, v);
        }
    }
}

void GL_APIENTRY VertexAttrib2d(GLuint index, GLdouble x, GLdouble y)
{
    EVENT("(GLuint index = %u, GLdouble x = %f, GLdouble y = %f)", index, x, y);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttrib2d, context, index, x, y);
        if (context->skipValidation() || ValidateVertexAttrib2d(context, index, x, y))
        {
            context->vertexAttrib2d(index, x, y);
        }
    }
}

void GL_APIENTRY VertexAttrib2dv(GLuint index, const GLdouble *v)
{
    EVENT("(GLuint index = %u, const GLdouble *v = 0x%016" PRIxPTR ")", index, (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttrib2dv, context, index, v);
        if (context->skipValidation() || ValidateVertexAttrib2dv(context, index, v))
        {
            context->vertexAttrib2dv(index, v);
        }
    }
}

void GL_APIENTRY VertexAttrib2f(GLuint index, GLfloat x, GLfloat y)
{
    EVENT("(GLuint index = %u, GLfloat x = %f, GLfloat y = %f)", index, x, y);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttrib2f, context, index, x, y);
        if (context->skipValidation() || ValidateVertexAttrib2f(context, index, x, y))
        {
            context->vertexAttrib2f(index, x, y);
        }
    }
}

void GL_APIENTRY VertexAttrib2fv(GLuint index, const GLfloat *v)
{
    EVENT("(GLuint index = %u, const GLfloat *v = 0x%016" PRIxPTR ")", index, (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttrib2fv, context, index, v);
        if (context->skipValidation() || ValidateVertexAttrib2fv(context, index, v))
        {
            context->vertexAttrib2fv(index, v);
        }
    }
}

void GL_APIENTRY VertexAttrib2s(GLuint index, GLshort x, GLshort y)
{
    EVENT("(GLuint index = %u, GLshort x = %d, GLshort y = %d)", index, x, y);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttrib2s, context, index, x, y);
        if (context->skipValidation() || ValidateVertexAttrib2s(context, index, x, y))
        {
            context->vertexAttrib2s(index, x, y);
        }
    }
}

void GL_APIENTRY VertexAttrib2sv(GLuint index, const GLshort *v)
{
    EVENT("(GLuint index = %u, const GLshort *v = 0x%016" PRIxPTR ")", index, (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttrib2sv, context, index, v);
        if (context->skipValidation() || ValidateVertexAttrib2sv(context, index, v))
        {
            context->vertexAttrib2sv(index, v);
        }
    }
}

void GL_APIENTRY VertexAttrib3d(GLuint index, GLdouble x, GLdouble y, GLdouble z)
{
    EVENT("(GLuint index = %u, GLdouble x = %f, GLdouble y = %f, GLdouble z = %f)", index, x, y, z);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttrib3d, context, index, x, y, z);
        if (context->skipValidation() || ValidateVertexAttrib3d(context, index, x, y, z))
        {
            context->vertexAttrib3d(index, x, y, z);
        }
    }
}

void GL_APIENTRY VertexAttrib3dv(GLuint index, const GLdouble *v)
{
    EVENT("(GLuint index = %u, const GLdouble *v = 0x%016" PRIxPTR ")", index, (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttrib3dv, context, index, v);
        if (context->skipValidation() || ValidateVertexAttrib3dv(context, index, v))
        {
            context->vertexAttrib3dv(index, v);
        }
    }
}

void GL_APIENTRY VertexAttrib3f(GLuint index, GLfloat x, GLfloat y, GLfloat z)
{
    EVENT("(GLuint index = %u, GLfloat x = %f, GLfloat y = %f, GLfloat z = %f)", index, x, y, z);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttrib3f, context, index, x, y, z);
        if (context->skipValidation() || ValidateVertexAttrib3f(context, index, x, y, z))
        {
            context->vertexAttrib3f(index, x, y, z);
        }
    }
}

void GL_APIENTRY VertexAttrib3fv(GLuint index, const GLfloat *v)
{
    EVENT("(GLuint index = %u, const GLfloat *v = 0x%016" PRIxPTR ")", index, (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttrib3fv, context, index, v);
        if (context->skipValidation() || ValidateVertexAttrib3fv(context, index, v))
        {
            context->vertexAttrib3fv(index, v);
        }
    }
}

void GL_APIENTRY VertexAttrib3s(GLuint index, GLshort x, GLshort y, GLshort z)
{
    EVENT("(GLuint index = %u, GLshort x = %d, GLshort y = %d, GLshort z = %d)", index, x, y, z);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttrib3s, context, index, x, y, z);
        if (context->skipValidation() || ValidateVertexAttrib3s(context, index, x, y, z))
        {
            context->vertexAttrib3s(index, x, y, z);
        }
    }
}

void GL_APIENTRY VertexAttrib3sv(GLuint index, const GLshort *v)
{
    EVENT("(GLuint index = %u, const GLshort *v = 0x%016" PRIxPTR ")", index, (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttrib3sv, context, index, v);
        if (context->skipValidation() || ValidateVertexAttrib3sv(context, index, v))
        {
            context->vertexAttrib3sv(index, v);
        }
    }
}

void GL_APIENTRY VertexAttrib4Nbv(GLuint index, const GLbyte *v)
{
    EVENT("(GLuint index = %u, const GLbyte *v = 0x%016" PRIxPTR ")", index, (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttrib4Nbv, context, index, v);
        if (context->skipValidation() || ValidateVertexAttrib4Nbv(context, index, v))
        {
            context->vertexAttrib4Nbv(index, v);
        }
    }
}

void GL_APIENTRY VertexAttrib4Niv(GLuint index, const GLint *v)
{
    EVENT("(GLuint index = %u, const GLint *v = 0x%016" PRIxPTR ")", index, (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttrib4Niv, context, index, v);
        if (context->skipValidation() || ValidateVertexAttrib4Niv(context, index, v))
        {
            context->vertexAttrib4Niv(index, v);
        }
    }
}

void GL_APIENTRY VertexAttrib4Nsv(GLuint index, const GLshort *v)
{
    EVENT("(GLuint index = %u, const GLshort *v = 0x%016" PRIxPTR ")", index, (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttrib4Nsv, context, index, v);
        if (context->skipValidation() || ValidateVertexAttrib4Nsv(context, index, v))
        {
            context->vertexAttrib4Nsv(index, v);
        }
    }
}

void GL_APIENTRY VertexAttrib4Nub(GLuint index, GLubyte x, GLubyte y, GLubyte z, GLubyte w)
{
    EVENT("(GLuint index = %u, GLubyte x = %d, GLubyte y = %d, GLubyte z = %d, GLubyte w = %d)",
          index, x, y, z, w);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttrib4Nub, context, index, x, y, z, w);
        if (context->skipValidation() || ValidateVertexAttrib4Nub(context, index, x, y, z, w))
        {
            context->vertexAttrib4Nub(index, x, y, z, w);
        }
    }
}

void GL_APIENTRY VertexAttrib4Nubv(GLuint index, const GLubyte *v)
{
    EVENT("(GLuint index = %u, const GLubyte *v = 0x%016" PRIxPTR ")", index, (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttrib4Nubv, context, index, v);
        if (context->skipValidation() || ValidateVertexAttrib4Nubv(context, index, v))
        {
            context->vertexAttrib4Nubv(index, v);
        }
    }
}

void GL_APIENTRY VertexAttrib4Nuiv(GLuint index, const GLuint *v)
{
    EVENT("(GLuint index = %u, const GLuint *v = 0x%016" PRIxPTR ")", index, (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttrib4Nuiv, context, index, v);
        if (context->skipValidation() || ValidateVertexAttrib4Nuiv(context, index, v))
        {
            context->vertexAttrib4Nuiv(index, v);
        }
    }
}

void GL_APIENTRY VertexAttrib4Nusv(GLuint index, const GLushort *v)
{
    EVENT("(GLuint index = %u, const GLushort *v = 0x%016" PRIxPTR ")", index, (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttrib4Nusv, context, index, v);
        if (context->skipValidation() || ValidateVertexAttrib4Nusv(context, index, v))
        {
            context->vertexAttrib4Nusv(index, v);
        }
    }
}

void GL_APIENTRY VertexAttrib4bv(GLuint index, const GLbyte *v)
{
    EVENT("(GLuint index = %u, const GLbyte *v = 0x%016" PRIxPTR ")", index, (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttrib4bv, context, index, v);
        if (context->skipValidation() || ValidateVertexAttrib4bv(context, index, v))
        {
            context->vertexAttrib4bv(index, v);
        }
    }
}

void GL_APIENTRY VertexAttrib4d(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
    EVENT("(GLuint index = %u, GLdouble x = %f, GLdouble y = %f, GLdouble z = %f, GLdouble w = %f)",
          index, x, y, z, w);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttrib4d, context, index, x, y, z, w);
        if (context->skipValidation() || ValidateVertexAttrib4d(context, index, x, y, z, w))
        {
            context->vertexAttrib4d(index, x, y, z, w);
        }
    }
}

void GL_APIENTRY VertexAttrib4dv(GLuint index, const GLdouble *v)
{
    EVENT("(GLuint index = %u, const GLdouble *v = 0x%016" PRIxPTR ")", index, (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttrib4dv, context, index, v);
        if (context->skipValidation() || ValidateVertexAttrib4dv(context, index, v))
        {
            context->vertexAttrib4dv(index, v);
        }
    }
}

void GL_APIENTRY VertexAttrib4f(GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
    EVENT("(GLuint index = %u, GLfloat x = %f, GLfloat y = %f, GLfloat z = %f, GLfloat w = %f)",
          index, x, y, z, w);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttrib4f, context, index, x, y, z, w);
        if (context->skipValidation() || ValidateVertexAttrib4f(context, index, x, y, z, w))
        {
            context->vertexAttrib4f(index, x, y, z, w);
        }
    }
}

void GL_APIENTRY VertexAttrib4fv(GLuint index, const GLfloat *v)
{
    EVENT("(GLuint index = %u, const GLfloat *v = 0x%016" PRIxPTR ")", index, (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttrib4fv, context, index, v);
        if (context->skipValidation() || ValidateVertexAttrib4fv(context, index, v))
        {
            context->vertexAttrib4fv(index, v);
        }
    }
}

void GL_APIENTRY VertexAttrib4iv(GLuint index, const GLint *v)
{
    EVENT("(GLuint index = %u, const GLint *v = 0x%016" PRIxPTR ")", index, (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttrib4iv, context, index, v);
        if (context->skipValidation() || ValidateVertexAttrib4iv(context, index, v))
        {
            context->vertexAttrib4iv(index, v);
        }
    }
}

void GL_APIENTRY VertexAttrib4s(GLuint index, GLshort x, GLshort y, GLshort z, GLshort w)
{
    EVENT("(GLuint index = %u, GLshort x = %d, GLshort y = %d, GLshort z = %d, GLshort w = %d)",
          index, x, y, z, w);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttrib4s, context, index, x, y, z, w);
        if (context->skipValidation() || ValidateVertexAttrib4s(context, index, x, y, z, w))
        {
            context->vertexAttrib4s(index, x, y, z, w);
        }
    }
}

void GL_APIENTRY VertexAttrib4sv(GLuint index, const GLshort *v)
{
    EVENT("(GLuint index = %u, const GLshort *v = 0x%016" PRIxPTR ")", index, (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttrib4sv, context, index, v);
        if (context->skipValidation() || ValidateVertexAttrib4sv(context, index, v))
        {
            context->vertexAttrib4sv(index, v);
        }
    }
}

void GL_APIENTRY VertexAttrib4ubv(GLuint index, const GLubyte *v)
{
    EVENT("(GLuint index = %u, const GLubyte *v = 0x%016" PRIxPTR ")", index, (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttrib4ubv, context, index, v);
        if (context->skipValidation() || ValidateVertexAttrib4ubv(context, index, v))
        {
            context->vertexAttrib4ubv(index, v);
        }
    }
}

void GL_APIENTRY VertexAttrib4uiv(GLuint index, const GLuint *v)
{
    EVENT("(GLuint index = %u, const GLuint *v = 0x%016" PRIxPTR ")", index, (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttrib4uiv, context, index, v);
        if (context->skipValidation() || ValidateVertexAttrib4uiv(context, index, v))
        {
            context->vertexAttrib4uiv(index, v);
        }
    }
}

void GL_APIENTRY VertexAttrib4usv(GLuint index, const GLushort *v)
{
    EVENT("(GLuint index = %u, const GLushort *v = 0x%016" PRIxPTR ")", index, (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttrib4usv, context, index, v);
        if (context->skipValidation() || ValidateVertexAttrib4usv(context, index, v))
        {
            context->vertexAttrib4usv(index, v);
        }
    }
}

void GL_APIENTRY VertexAttribPointer(GLuint index,
                                     GLint size,
                                     GLenum type,
                                     GLboolean normalized,
                                     GLsizei stride,
                                     const void *pointer)
{
    EVENT(
        "(GLuint index = %u, GLint size = %d, GLenum type = 0x%X, GLboolean normalized = %u, "
        "GLsizei stride = %d, const void *pointer = 0x%016" PRIxPTR ")",
        index, size, type, normalized, stride, (uintptr_t)pointer);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        VertexAttribType typePacked = FromGLenum<VertexAttribType>(type);
        ANGLE_CAPTURE(VertexAttribPointer, context, index, size, typePacked, normalized, stride,
                      pointer);
        if (context->skipValidation() ||
            ValidateVertexAttribPointer(context, index, size, typePacked, normalized, stride,
                                        pointer))
        {
            context->vertexAttribPointer(index, size, typePacked, normalized, stride, pointer);
        }
    }
}
}  // namespace gl
