// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from gl.xml.
//
// Copyright 2019 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// entry_points_gl_3_0_autogen.cpp:
//   Defines the GL 3.0 entry points.

#include "libGL/entry_points_gl_3_0_autogen.h"

#include "libANGLE/Context.h"
#include "libANGLE/Context.inl.h"
#include "libANGLE/entry_points_utils.h"
#include "libANGLE/validationEGL.h"
#include "libANGLE/validationES.h"
#include "libANGLE/validationES1.h"
#include "libANGLE/validationES2.h"
#include "libANGLE/validationES3.h"
#include "libANGLE/validationES31.h"
#include "libANGLE/validationESEXT.h"
#include "libANGLE/validationGL3_autogen.h"
#include "libGLESv2/global_state.h"

namespace gl
{
void GL_APIENTRY BeginConditionalRender(GLuint id, GLenum mode)
{
    EVENT("(GLuint id = %u, GLenum mode = 0x%X)", id, mode);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(BeginConditionalRender, context, id, mode);
        if (context->skipValidation() || ValidateBeginConditionalRender(context, id, mode))
        {
            context->beginConditionalRender(id, mode);
        }
    }
}

void GL_APIENTRY BeginTransformFeedback(GLenum primitiveMode)
{
    EVENT("(GLenum primitiveMode = 0x%X)", primitiveMode);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        PrimitiveMode primitiveModePacked = FromGLenum<PrimitiveMode>(primitiveMode);
        ANGLE_CAPTURE(BeginTransformFeedback, context, primitiveModePacked);
        if (context->skipValidation() ||
            ValidateBeginTransformFeedback(context, primitiveModePacked))
        {
            context->beginTransformFeedback(primitiveModePacked);
        }
    }
}

void GL_APIENTRY BindBufferBase(GLenum target, GLuint index, GLuint buffer)
{
    EVENT("(GLenum target = 0x%X, GLuint index = %u, GLuint buffer = %u)", target, index, buffer);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        BufferBinding targetPacked = FromGLenum<BufferBinding>(target);
        ANGLE_CAPTURE(BindBufferBase, context, targetPacked, index, buffer);
        if (context->skipValidation() ||
            ValidateBindBufferBase(context, targetPacked, index, buffer))
        {
            context->bindBufferBase(targetPacked, index, buffer);
        }
    }
}

void GL_APIENTRY
BindBufferRange(GLenum target, GLuint index, GLuint buffer, GLintptr offset, GLsizeiptr size)
{
    EVENT(
        "(GLenum target = 0x%X, GLuint index = %u, GLuint buffer = %u, GLintptr offset = %llu, "
        "GLsizeiptr size = %llu)",
        target, index, buffer, static_cast<unsigned long long>(offset),
        static_cast<unsigned long long>(size));

    Context *context = GetValidGlobalContext();
    if (context)
    {
        BufferBinding targetPacked = FromGLenum<BufferBinding>(target);
        ANGLE_CAPTURE(BindBufferRange, context, targetPacked, index, buffer, offset, size);
        if (context->skipValidation() ||
            ValidateBindBufferRange(context, targetPacked, index, buffer, offset, size))
        {
            context->bindBufferRange(targetPacked, index, buffer, offset, size);
        }
    }
}

void GL_APIENTRY BindFragDataLocation(GLuint program, GLuint color, const GLchar *name)
{
    EVENT("(GLuint program = %u, GLuint color = %u, const GLchar *name = 0x%016" PRIxPTR ")",
          program, color, (uintptr_t)name);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(BindFragDataLocation, context, program, color, name);
        if (context->skipValidation() ||
            ValidateBindFragDataLocation(context, program, color, name))
        {
            context->bindFragDataLocation(program, color, name);
        }
    }
}

void GL_APIENTRY BindFramebuffer(GLenum target, GLuint framebuffer)
{
    EVENT("(GLenum target = 0x%X, GLuint framebuffer = %u)", target, framebuffer);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(BindFramebuffer, context, target, framebuffer);
        if (context->skipValidation() || ValidateBindFramebuffer(context, target, framebuffer))
        {
            context->bindFramebuffer(target, framebuffer);
        }
    }
}

void GL_APIENTRY BindRenderbuffer(GLenum target, GLuint renderbuffer)
{
    EVENT("(GLenum target = 0x%X, GLuint renderbuffer = %u)", target, renderbuffer);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(BindRenderbuffer, context, target, renderbuffer);
        if (context->skipValidation() || ValidateBindRenderbuffer(context, target, renderbuffer))
        {
            context->bindRenderbuffer(target, renderbuffer);
        }
    }
}

void GL_APIENTRY BindVertexArray(GLuint array)
{
    EVENT("(GLuint array = %u)", array);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(BindVertexArray, context, array);
        if (context->skipValidation() || ValidateBindVertexArray(context, array))
        {
            context->bindVertexArray(array);
        }
    }
}

void GL_APIENTRY BlitFramebuffer(GLint srcX0,
                                 GLint srcY0,
                                 GLint srcX1,
                                 GLint srcY1,
                                 GLint dstX0,
                                 GLint dstY0,
                                 GLint dstX1,
                                 GLint dstY1,
                                 GLbitfield mask,
                                 GLenum filter)
{
    EVENT(
        "(GLint srcX0 = %d, GLint srcY0 = %d, GLint srcX1 = %d, GLint srcY1 = %d, GLint dstX0 = "
        "%d, GLint dstY0 = %d, GLint dstX1 = %d, GLint dstY1 = %d, GLbitfield mask = 0x%X, GLenum "
        "filter = 0x%X)",
        srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(BlitFramebuffer, context, srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1,
                      dstY1, mask, filter);
        if (context->skipValidation() ||
            ValidateBlitFramebuffer(context, srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1,
                                    mask, filter))
        {
            context->blitFramebuffer(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask,
                                     filter);
        }
    }
}

GLenum GL_APIENTRY CheckFramebufferStatus(GLenum target)
{
    EVENT("(GLenum target = 0x%X)", target);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(CheckFramebufferStatus, context, target);
        if (context->skipValidation() || ValidateCheckFramebufferStatus(context, target))
        {
            return context->checkFramebufferStatus(target);
        }
    }

    return GetDefaultReturnValue<EntryPoint::CheckFramebufferStatus, GLenum>();
}

void GL_APIENTRY ClampColor(GLenum target, GLenum clamp)
{
    EVENT("(GLenum target = 0x%X, GLenum clamp = 0x%X)", target, clamp);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(ClampColor, context, target, clamp);
        if (context->skipValidation() || ValidateClampColor(context, target, clamp))
        {
            context->clampColor(target, clamp);
        }
    }
}

void GL_APIENTRY ClearBufferfi(GLenum buffer, GLint drawbuffer, GLfloat depth, GLint stencil)
{
    EVENT("(GLenum buffer = 0x%X, GLint drawbuffer = %d, GLfloat depth = %f, GLint stencil = %d)",
          buffer, drawbuffer, depth, stencil);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(ClearBufferfi, context, buffer, drawbuffer, depth, stencil);
        if (context->skipValidation() ||
            ValidateClearBufferfi(context, buffer, drawbuffer, depth, stencil))
        {
            context->clearBufferfi(buffer, drawbuffer, depth, stencil);
        }
    }
}

void GL_APIENTRY ClearBufferfv(GLenum buffer, GLint drawbuffer, const GLfloat *value)
{
    EVENT("(GLenum buffer = 0x%X, GLint drawbuffer = %d, const GLfloat *value = 0x%016" PRIxPTR ")",
          buffer, drawbuffer, (uintptr_t)value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(ClearBufferfv, context, buffer, drawbuffer, value);
        if (context->skipValidation() || ValidateClearBufferfv(context, buffer, drawbuffer, value))
        {
            context->clearBufferfv(buffer, drawbuffer, value);
        }
    }
}

void GL_APIENTRY ClearBufferiv(GLenum buffer, GLint drawbuffer, const GLint *value)
{
    EVENT("(GLenum buffer = 0x%X, GLint drawbuffer = %d, const GLint *value = 0x%016" PRIxPTR ")",
          buffer, drawbuffer, (uintptr_t)value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(ClearBufferiv, context, buffer, drawbuffer, value);
        if (context->skipValidation() || ValidateClearBufferiv(context, buffer, drawbuffer, value))
        {
            context->clearBufferiv(buffer, drawbuffer, value);
        }
    }
}

void GL_APIENTRY ClearBufferuiv(GLenum buffer, GLint drawbuffer, const GLuint *value)
{
    EVENT("(GLenum buffer = 0x%X, GLint drawbuffer = %d, const GLuint *value = 0x%016" PRIxPTR ")",
          buffer, drawbuffer, (uintptr_t)value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(ClearBufferuiv, context, buffer, drawbuffer, value);
        if (context->skipValidation() || ValidateClearBufferuiv(context, buffer, drawbuffer, value))
        {
            context->clearBufferuiv(buffer, drawbuffer, value);
        }
    }
}

void GL_APIENTRY ColorMaski(GLuint index, GLboolean r, GLboolean g, GLboolean b, GLboolean a)
{
    EVENT(
        "(GLuint index = %u, GLboolean r = %u, GLboolean g = %u, GLboolean b = %u, GLboolean a = "
        "%u)",
        index, r, g, b, a);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(ColorMaski, context, index, r, g, b, a);
        if (context->skipValidation() || ValidateColorMaski(context, index, r, g, b, a))
        {
            context->colorMaski(index, r, g, b, a);
        }
    }
}

void GL_APIENTRY DeleteFramebuffers(GLsizei n, const GLuint *framebuffers)
{
    EVENT("(GLsizei n = %d, const GLuint *framebuffers = 0x%016" PRIxPTR ")", n,
          (uintptr_t)framebuffers);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(DeleteFramebuffers, context, n, framebuffers);
        if (context->skipValidation() || ValidateDeleteFramebuffers(context, n, framebuffers))
        {
            context->deleteFramebuffers(n, framebuffers);
        }
    }
}

void GL_APIENTRY DeleteRenderbuffers(GLsizei n, const GLuint *renderbuffers)
{
    EVENT("(GLsizei n = %d, const GLuint *renderbuffers = 0x%016" PRIxPTR ")", n,
          (uintptr_t)renderbuffers);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(DeleteRenderbuffers, context, n, renderbuffers);
        if (context->skipValidation() || ValidateDeleteRenderbuffers(context, n, renderbuffers))
        {
            context->deleteRenderbuffers(n, renderbuffers);
        }
    }
}

void GL_APIENTRY DeleteVertexArrays(GLsizei n, const GLuint *arrays)
{
    EVENT("(GLsizei n = %d, const GLuint *arrays = 0x%016" PRIxPTR ")", n, (uintptr_t)arrays);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(DeleteVertexArrays, context, n, arrays);
        if (context->skipValidation() || ValidateDeleteVertexArrays(context, n, arrays))
        {
            context->deleteVertexArrays(n, arrays);
        }
    }
}

void GL_APIENTRY Disablei(GLenum target, GLuint index)
{
    EVENT("(GLenum target = 0x%X, GLuint index = %u)", target, index);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Disablei, context, target, index);
        if (context->skipValidation() || ValidateDisablei(context, target, index))
        {
            context->disablei(target, index);
        }
    }
}

void GL_APIENTRY Enablei(GLenum target, GLuint index)
{
    EVENT("(GLenum target = 0x%X, GLuint index = %u)", target, index);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Enablei, context, target, index);
        if (context->skipValidation() || ValidateEnablei(context, target, index))
        {
            context->enablei(target, index);
        }
    }
}

void GL_APIENTRY EndConditionalRender()
{
    EVENT("()");

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(EndConditionalRender, context);
        if (context->skipValidation() || ValidateEndConditionalRender(context))
        {
            context->endConditionalRender();
        }
    }
}

void GL_APIENTRY EndTransformFeedback()
{
    EVENT("()");

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(EndTransformFeedback, context);
        if (context->skipValidation() || ValidateEndTransformFeedback(context))
        {
            context->endTransformFeedback();
        }
    }
}

void GL_APIENTRY FlushMappedBufferRange(GLenum target, GLintptr offset, GLsizeiptr length)
{
    EVENT("(GLenum target = 0x%X, GLintptr offset = %llu, GLsizeiptr length = %llu)", target,
          static_cast<unsigned long long>(offset), static_cast<unsigned long long>(length));

    Context *context = GetValidGlobalContext();
    if (context)
    {
        BufferBinding targetPacked = FromGLenum<BufferBinding>(target);
        ANGLE_CAPTURE(FlushMappedBufferRange, context, targetPacked, offset, length);
        if (context->skipValidation() ||
            ValidateFlushMappedBufferRange(context, targetPacked, offset, length))
        {
            context->flushMappedBufferRange(targetPacked, offset, length);
        }
    }
}

void GL_APIENTRY FramebufferRenderbuffer(GLenum target,
                                         GLenum attachment,
                                         GLenum renderbuffertarget,
                                         GLuint renderbuffer)
{
    EVENT(
        "(GLenum target = 0x%X, GLenum attachment = 0x%X, GLenum renderbuffertarget = 0x%X, GLuint "
        "renderbuffer = %u)",
        target, attachment, renderbuffertarget, renderbuffer);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(FramebufferRenderbuffer, context, target, attachment, renderbuffertarget,
                      renderbuffer);
        if (context->skipValidation() ||
            ValidateFramebufferRenderbuffer(context, target, attachment, renderbuffertarget,
                                            renderbuffer))
        {
            context->framebufferRenderbuffer(target, attachment, renderbuffertarget, renderbuffer);
        }
    }
}

void GL_APIENTRY FramebufferTexture1D(GLenum target,
                                      GLenum attachment,
                                      GLenum textarget,
                                      GLuint texture,
                                      GLint level)
{
    EVENT(
        "(GLenum target = 0x%X, GLenum attachment = 0x%X, GLenum textarget = 0x%X, GLuint texture "
        "= %u, GLint level = %d)",
        target, attachment, textarget, texture, level);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(FramebufferTexture1D, context, target, attachment, textarget, texture, level);
        if (context->skipValidation() ||
            ValidateFramebufferTexture1D(context, target, attachment, textarget, texture, level))
        {
            context->framebufferTexture1D(target, attachment, textarget, texture, level);
        }
    }
}

void GL_APIENTRY FramebufferTexture2D(GLenum target,
                                      GLenum attachment,
                                      GLenum textarget,
                                      GLuint texture,
                                      GLint level)
{
    EVENT(
        "(GLenum target = 0x%X, GLenum attachment = 0x%X, GLenum textarget = 0x%X, GLuint texture "
        "= %u, GLint level = %d)",
        target, attachment, textarget, texture, level);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureTarget textargetPacked = FromGLenum<TextureTarget>(textarget);
        ANGLE_CAPTURE(FramebufferTexture2D, context, target, attachment, textargetPacked, texture,
                      level);
        if (context->skipValidation() ||
            ValidateFramebufferTexture2D(context, target, attachment, textargetPacked, texture,
                                         level))
        {
            context->framebufferTexture2D(target, attachment, textargetPacked, texture, level);
        }
    }
}

void GL_APIENTRY FramebufferTexture3D(GLenum target,
                                      GLenum attachment,
                                      GLenum textarget,
                                      GLuint texture,
                                      GLint level,
                                      GLint zoffset)
{
    EVENT(
        "(GLenum target = 0x%X, GLenum attachment = 0x%X, GLenum textarget = 0x%X, GLuint texture "
        "= %u, GLint level = %d, GLint zoffset = %d)",
        target, attachment, textarget, texture, level, zoffset);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureTarget textargetPacked = FromGLenum<TextureTarget>(textarget);
        ANGLE_CAPTURE(FramebufferTexture3D, context, target, attachment, textargetPacked, texture,
                      level, zoffset);
        if (context->skipValidation() ||
            ValidateFramebufferTexture3D(context, target, attachment, textargetPacked, texture,
                                         level, zoffset))
        {
            context->framebufferTexture3D(target, attachment, textargetPacked, texture, level,
                                          zoffset);
        }
    }
}

void GL_APIENTRY
FramebufferTextureLayer(GLenum target, GLenum attachment, GLuint texture, GLint level, GLint layer)
{
    EVENT(
        "(GLenum target = 0x%X, GLenum attachment = 0x%X, GLuint texture = %u, GLint level = %d, "
        "GLint layer = %d)",
        target, attachment, texture, level, layer);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(FramebufferTextureLayer, context, target, attachment, texture, level, layer);
        if (context->skipValidation() ||
            ValidateFramebufferTextureLayer(context, target, attachment, texture, level, layer))
        {
            context->framebufferTextureLayer(target, attachment, texture, level, layer);
        }
    }
}

void GL_APIENTRY GenFramebuffers(GLsizei n, GLuint *framebuffers)
{
    EVENT("(GLsizei n = %d, GLuint *framebuffers = 0x%016" PRIxPTR ")", n, (uintptr_t)framebuffers);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GenFramebuffers, context, n, framebuffers);
        if (context->skipValidation() || ValidateGenFramebuffers(context, n, framebuffers))
        {
            context->genFramebuffers(n, framebuffers);
        }
    }
}

void GL_APIENTRY GenRenderbuffers(GLsizei n, GLuint *renderbuffers)
{
    EVENT("(GLsizei n = %d, GLuint *renderbuffers = 0x%016" PRIxPTR ")", n,
          (uintptr_t)renderbuffers);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GenRenderbuffers, context, n, renderbuffers);
        if (context->skipValidation() || ValidateGenRenderbuffers(context, n, renderbuffers))
        {
            context->genRenderbuffers(n, renderbuffers);
        }
    }
}

void GL_APIENTRY GenVertexArrays(GLsizei n, GLuint *arrays)
{
    EVENT("(GLsizei n = %d, GLuint *arrays = 0x%016" PRIxPTR ")", n, (uintptr_t)arrays);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GenVertexArrays, context, n, arrays);
        if (context->skipValidation() || ValidateGenVertexArrays(context, n, arrays))
        {
            context->genVertexArrays(n, arrays);
        }
    }
}

void GL_APIENTRY GenerateMipmap(GLenum target)
{
    EVENT("(GLenum target = 0x%X)", target);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(GenerateMipmap, context, targetPacked);
        if (context->skipValidation() || ValidateGenerateMipmap(context, targetPacked))
        {
            context->generateMipmap(targetPacked);
        }
    }
}

void GL_APIENTRY GetBooleani_v(GLenum target, GLuint index, GLboolean *data)
{
    EVENT("(GLenum target = 0x%X, GLuint index = %u, GLboolean *data = 0x%016" PRIxPTR ")", target,
          index, (uintptr_t)data);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetBooleani_v, context, target, index, data);
        if (context->skipValidation() || ValidateGetBooleani_v(context, target, index, data))
        {
            context->getBooleani_v(target, index, data);
        }
    }
}

GLint GL_APIENTRY GetFragDataLocation(GLuint program, const GLchar *name)
{
    EVENT("(GLuint program = %u, const GLchar *name = 0x%016" PRIxPTR ")", program,
          (uintptr_t)name);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetFragDataLocation, context, program, name);
        if (context->skipValidation() || ValidateGetFragDataLocation(context, program, name))
        {
            return context->getFragDataLocation(program, name);
        }
    }

    return GetDefaultReturnValue<EntryPoint::GetFragDataLocation, GLint>();
}

void GL_APIENTRY GetFramebufferAttachmentParameteriv(GLenum target,
                                                     GLenum attachment,
                                                     GLenum pname,
                                                     GLint *params)
{
    EVENT(
        "(GLenum target = 0x%X, GLenum attachment = 0x%X, GLenum pname = 0x%X, GLint *params = "
        "0x%016" PRIxPTR ")",
        target, attachment, pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetFramebufferAttachmentParameteriv, context, target, attachment, pname,
                      params);
        if (context->skipValidation() ||
            ValidateGetFramebufferAttachmentParameteriv(context, target, attachment, pname, params))
        {
            context->getFramebufferAttachmentParameteriv(target, attachment, pname, params);
        }
    }
}

void GL_APIENTRY GetIntegeri_v(GLenum target, GLuint index, GLint *data)
{
    EVENT("(GLenum target = 0x%X, GLuint index = %u, GLint *data = 0x%016" PRIxPTR ")", target,
          index, (uintptr_t)data);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetIntegeri_v, context, target, index, data);
        if (context->skipValidation() || ValidateGetIntegeri_v(context, target, index, data))
        {
            context->getIntegeri_v(target, index, data);
        }
    }
}

void GL_APIENTRY GetRenderbufferParameteriv(GLenum target, GLenum pname, GLint *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLint *params = 0x%016" PRIxPTR ")", target,
          pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetRenderbufferParameteriv, context, target, pname, params);
        if (context->skipValidation() ||
            ValidateGetRenderbufferParameteriv(context, target, pname, params))
        {
            context->getRenderbufferParameteriv(target, pname, params);
        }
    }
}

const GLubyte *GL_APIENTRY GetStringi(GLenum name, GLuint index)
{
    EVENT("(GLenum name = 0x%X, GLuint index = %u)", name, index);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetStringi, context, name, index);
        if (context->skipValidation() || ValidateGetStringi(context, name, index))
        {
            return context->getStringi(name, index);
        }
    }

    return GetDefaultReturnValue<EntryPoint::GetStringi, const GLubyte *>();
}

void GL_APIENTRY GetTexParameterIiv(GLenum target, GLenum pname, GLint *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLint *params = 0x%016" PRIxPTR ")", target,
          pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(GetTexParameterIiv, context, targetPacked, pname, params);
        if (context->skipValidation() ||
            ValidateGetTexParameterIiv(context, targetPacked, pname, params))
        {
            context->getTexParameterIiv(targetPacked, pname, params);
        }
    }
}

void GL_APIENTRY GetTexParameterIuiv(GLenum target, GLenum pname, GLuint *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLuint *params = 0x%016" PRIxPTR ")", target,
          pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(GetTexParameterIuiv, context, targetPacked, pname, params);
        if (context->skipValidation() ||
            ValidateGetTexParameterIuiv(context, targetPacked, pname, params))
        {
            context->getTexParameterIuiv(targetPacked, pname, params);
        }
    }
}

void GL_APIENTRY GetTransformFeedbackVarying(GLuint program,
                                             GLuint index,
                                             GLsizei bufSize,
                                             GLsizei *length,
                                             GLsizei *size,
                                             GLenum *type,
                                             GLchar *name)
{
    EVENT(
        "(GLuint program = %u, GLuint index = %u, GLsizei bufSize = %d, GLsizei *length = "
        "0x%016" PRIxPTR ", GLsizei *size = 0x%016" PRIxPTR ", GLenum *type = 0x%016" PRIxPTR
        ", GLchar *name = 0x%016" PRIxPTR ")",
        program, index, bufSize, (uintptr_t)length, (uintptr_t)size, (uintptr_t)type,
        (uintptr_t)name);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetTransformFeedbackVarying, context, program, index, bufSize, length, size,
                      type, name);
        if (context->skipValidation() ||
            ValidateGetTransformFeedbackVarying(context, program, index, bufSize, length, size,
                                                type, name))
        {
            context->getTransformFeedbackVarying(program, index, bufSize, length, size, type, name);
        }
    }
}

void GL_APIENTRY GetUniformuiv(GLuint program, GLint location, GLuint *params)
{
    EVENT("(GLuint program = %u, GLint location = %d, GLuint *params = 0x%016" PRIxPTR ")", program,
          location, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetUniformuiv, context, program, location, params);
        if (context->skipValidation() || ValidateGetUniformuiv(context, program, location, params))
        {
            context->getUniformuiv(program, location, params);
        }
    }
}

void GL_APIENTRY GetVertexAttribIiv(GLuint index, GLenum pname, GLint *params)
{
    EVENT("(GLuint index = %u, GLenum pname = 0x%X, GLint *params = 0x%016" PRIxPTR ")", index,
          pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetVertexAttribIiv, context, index, pname, params);
        if (context->skipValidation() || ValidateGetVertexAttribIiv(context, index, pname, params))
        {
            context->getVertexAttribIiv(index, pname, params);
        }
    }
}

void GL_APIENTRY GetVertexAttribIuiv(GLuint index, GLenum pname, GLuint *params)
{
    EVENT("(GLuint index = %u, GLenum pname = 0x%X, GLuint *params = 0x%016" PRIxPTR ")", index,
          pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetVertexAttribIuiv, context, index, pname, params);
        if (context->skipValidation() || ValidateGetVertexAttribIuiv(context, index, pname, params))
        {
            context->getVertexAttribIuiv(index, pname, params);
        }
    }
}

GLboolean GL_APIENTRY IsEnabledi(GLenum target, GLuint index)
{
    EVENT("(GLenum target = 0x%X, GLuint index = %u)", target, index);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(IsEnabledi, context, target, index);
        if (context->skipValidation() || ValidateIsEnabledi(context, target, index))
        {
            return context->isEnabledi(target, index);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsEnabledi, GLboolean>();
}

GLboolean GL_APIENTRY IsFramebuffer(GLuint framebuffer)
{
    EVENT("(GLuint framebuffer = %u)", framebuffer);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(IsFramebuffer, context, framebuffer);
        if (context->skipValidation() || ValidateIsFramebuffer(context, framebuffer))
        {
            return context->isFramebuffer(framebuffer);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsFramebuffer, GLboolean>();
}

GLboolean GL_APIENTRY IsRenderbuffer(GLuint renderbuffer)
{
    EVENT("(GLuint renderbuffer = %u)", renderbuffer);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(IsRenderbuffer, context, renderbuffer);
        if (context->skipValidation() || ValidateIsRenderbuffer(context, renderbuffer))
        {
            return context->isRenderbuffer(renderbuffer);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsRenderbuffer, GLboolean>();
}

GLboolean GL_APIENTRY IsVertexArray(GLuint array)
{
    EVENT("(GLuint array = %u)", array);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(IsVertexArray, context, array);
        if (context->skipValidation() || ValidateIsVertexArray(context, array))
        {
            return context->isVertexArray(array);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsVertexArray, GLboolean>();
}

void *GL_APIENTRY MapBufferRange(GLenum target,
                                 GLintptr offset,
                                 GLsizeiptr length,
                                 GLbitfield access)
{
    EVENT(
        "(GLenum target = 0x%X, GLintptr offset = %llu, GLsizeiptr length = %llu, GLbitfield "
        "access = 0x%X)",
        target, static_cast<unsigned long long>(offset), static_cast<unsigned long long>(length),
        access);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        BufferBinding targetPacked = FromGLenum<BufferBinding>(target);
        ANGLE_CAPTURE(MapBufferRange, context, targetPacked, offset, length, access);
        if (context->skipValidation() ||
            ValidateMapBufferRange(context, targetPacked, offset, length, access))
        {
            return context->mapBufferRange(targetPacked, offset, length, access);
        }
    }

    return GetDefaultReturnValue<EntryPoint::MapBufferRange, void *>();
}

void GL_APIENTRY RenderbufferStorage(GLenum target,
                                     GLenum internalformat,
                                     GLsizei width,
                                     GLsizei height)
{
    EVENT(
        "(GLenum target = 0x%X, GLenum internalformat = 0x%X, GLsizei width = %d, GLsizei height = "
        "%d)",
        target, internalformat, width, height);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(RenderbufferStorage, context, target, internalformat, width, height);
        if (context->skipValidation() ||
            ValidateRenderbufferStorage(context, target, internalformat, width, height))
        {
            context->renderbufferStorage(target, internalformat, width, height);
        }
    }
}

void GL_APIENTRY RenderbufferStorageMultisample(GLenum target,
                                                GLsizei samples,
                                                GLenum internalformat,
                                                GLsizei width,
                                                GLsizei height)
{
    EVENT(
        "(GLenum target = 0x%X, GLsizei samples = %d, GLenum internalformat = 0x%X, GLsizei width "
        "= %d, GLsizei height = %d)",
        target, samples, internalformat, width, height);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(RenderbufferStorageMultisample, context, target, samples, internalformat,
                      width, height);
        if (context->skipValidation() ||
            ValidateRenderbufferStorageMultisample(context, target, samples, internalformat, width,
                                                   height))
        {
            context->renderbufferStorageMultisample(target, samples, internalformat, width, height);
        }
    }
}

void GL_APIENTRY TexParameterIiv(GLenum target, GLenum pname, const GLint *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, const GLint *params = 0x%016" PRIxPTR ")",
          target, pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(TexParameterIiv, context, targetPacked, pname, params);
        if (context->skipValidation() ||
            ValidateTexParameterIiv(context, targetPacked, pname, params))
        {
            context->texParameterIiv(targetPacked, pname, params);
        }
    }
}

void GL_APIENTRY TexParameterIuiv(GLenum target, GLenum pname, const GLuint *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, const GLuint *params = 0x%016" PRIxPTR ")",
          target, pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(TexParameterIuiv, context, targetPacked, pname, params);
        if (context->skipValidation() ||
            ValidateTexParameterIuiv(context, targetPacked, pname, params))
        {
            context->texParameterIuiv(targetPacked, pname, params);
        }
    }
}

void GL_APIENTRY TransformFeedbackVaryings(GLuint program,
                                           GLsizei count,
                                           const GLchar *const *varyings,
                                           GLenum bufferMode)
{
    EVENT("(GLuint program = %u, GLsizei count = %d, const GLchar *const*varyings = 0x%016" PRIxPTR
          ", GLenum bufferMode = 0x%X)",
          program, count, (uintptr_t)varyings, bufferMode);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(TransformFeedbackVaryings, context, program, count, varyings, bufferMode);
        if (context->skipValidation() ||
            ValidateTransformFeedbackVaryings(context, program, count, varyings, bufferMode))
        {
            context->transformFeedbackVaryings(program, count, varyings, bufferMode);
        }
    }
}

void GL_APIENTRY Uniform1ui(GLint location, GLuint v0)
{
    EVENT("(GLint location = %d, GLuint v0 = %u)", location, v0);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Uniform1ui, context, location, v0);
        if (context->skipValidation() || ValidateUniform1ui(context, location, v0))
        {
            context->uniform1ui(location, v0);
        }
    }
}

void GL_APIENTRY Uniform1uiv(GLint location, GLsizei count, const GLuint *value)
{
    EVENT("(GLint location = %d, GLsizei count = %d, const GLuint *value = 0x%016" PRIxPTR ")",
          location, count, (uintptr_t)value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Uniform1uiv, context, location, count, value);
        if (context->skipValidation() || ValidateUniform1uiv(context, location, count, value))
        {
            context->uniform1uiv(location, count, value);
        }
    }
}

void GL_APIENTRY Uniform2ui(GLint location, GLuint v0, GLuint v1)
{
    EVENT("(GLint location = %d, GLuint v0 = %u, GLuint v1 = %u)", location, v0, v1);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Uniform2ui, context, location, v0, v1);
        if (context->skipValidation() || ValidateUniform2ui(context, location, v0, v1))
        {
            context->uniform2ui(location, v0, v1);
        }
    }
}

void GL_APIENTRY Uniform2uiv(GLint location, GLsizei count, const GLuint *value)
{
    EVENT("(GLint location = %d, GLsizei count = %d, const GLuint *value = 0x%016" PRIxPTR ")",
          location, count, (uintptr_t)value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Uniform2uiv, context, location, count, value);
        if (context->skipValidation() || ValidateUniform2uiv(context, location, count, value))
        {
            context->uniform2uiv(location, count, value);
        }
    }
}

void GL_APIENTRY Uniform3ui(GLint location, GLuint v0, GLuint v1, GLuint v2)
{
    EVENT("(GLint location = %d, GLuint v0 = %u, GLuint v1 = %u, GLuint v2 = %u)", location, v0, v1,
          v2);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Uniform3ui, context, location, v0, v1, v2);
        if (context->skipValidation() || ValidateUniform3ui(context, location, v0, v1, v2))
        {
            context->uniform3ui(location, v0, v1, v2);
        }
    }
}

void GL_APIENTRY Uniform3uiv(GLint location, GLsizei count, const GLuint *value)
{
    EVENT("(GLint location = %d, GLsizei count = %d, const GLuint *value = 0x%016" PRIxPTR ")",
          location, count, (uintptr_t)value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Uniform3uiv, context, location, count, value);
        if (context->skipValidation() || ValidateUniform3uiv(context, location, count, value))
        {
            context->uniform3uiv(location, count, value);
        }
    }
}

void GL_APIENTRY Uniform4ui(GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3)
{
    EVENT("(GLint location = %d, GLuint v0 = %u, GLuint v1 = %u, GLuint v2 = %u, GLuint v3 = %u)",
          location, v0, v1, v2, v3);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Uniform4ui, context, location, v0, v1, v2, v3);
        if (context->skipValidation() || ValidateUniform4ui(context, location, v0, v1, v2, v3))
        {
            context->uniform4ui(location, v0, v1, v2, v3);
        }
    }
}

void GL_APIENTRY Uniform4uiv(GLint location, GLsizei count, const GLuint *value)
{
    EVENT("(GLint location = %d, GLsizei count = %d, const GLuint *value = 0x%016" PRIxPTR ")",
          location, count, (uintptr_t)value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Uniform4uiv, context, location, count, value);
        if (context->skipValidation() || ValidateUniform4uiv(context, location, count, value))
        {
            context->uniform4uiv(location, count, value);
        }
    }
}

void GL_APIENTRY VertexAttribI1i(GLuint index, GLint x)
{
    EVENT("(GLuint index = %u, GLint x = %d)", index, x);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttribI1i, context, index, x);
        if (context->skipValidation() || ValidateVertexAttribI1i(context, index, x))
        {
            context->vertexAttribI1i(index, x);
        }
    }
}

void GL_APIENTRY VertexAttribI1iv(GLuint index, const GLint *v)
{
    EVENT("(GLuint index = %u, const GLint *v = 0x%016" PRIxPTR ")", index, (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttribI1iv, context, index, v);
        if (context->skipValidation() || ValidateVertexAttribI1iv(context, index, v))
        {
            context->vertexAttribI1iv(index, v);
        }
    }
}

void GL_APIENTRY VertexAttribI1ui(GLuint index, GLuint x)
{
    EVENT("(GLuint index = %u, GLuint x = %u)", index, x);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttribI1ui, context, index, x);
        if (context->skipValidation() || ValidateVertexAttribI1ui(context, index, x))
        {
            context->vertexAttribI1ui(index, x);
        }
    }
}

void GL_APIENTRY VertexAttribI1uiv(GLuint index, const GLuint *v)
{
    EVENT("(GLuint index = %u, const GLuint *v = 0x%016" PRIxPTR ")", index, (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttribI1uiv, context, index, v);
        if (context->skipValidation() || ValidateVertexAttribI1uiv(context, index, v))
        {
            context->vertexAttribI1uiv(index, v);
        }
    }
}

void GL_APIENTRY VertexAttribI2i(GLuint index, GLint x, GLint y)
{
    EVENT("(GLuint index = %u, GLint x = %d, GLint y = %d)", index, x, y);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttribI2i, context, index, x, y);
        if (context->skipValidation() || ValidateVertexAttribI2i(context, index, x, y))
        {
            context->vertexAttribI2i(index, x, y);
        }
    }
}

void GL_APIENTRY VertexAttribI2iv(GLuint index, const GLint *v)
{
    EVENT("(GLuint index = %u, const GLint *v = 0x%016" PRIxPTR ")", index, (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttribI2iv, context, index, v);
        if (context->skipValidation() || ValidateVertexAttribI2iv(context, index, v))
        {
            context->vertexAttribI2iv(index, v);
        }
    }
}

void GL_APIENTRY VertexAttribI2ui(GLuint index, GLuint x, GLuint y)
{
    EVENT("(GLuint index = %u, GLuint x = %u, GLuint y = %u)", index, x, y);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttribI2ui, context, index, x, y);
        if (context->skipValidation() || ValidateVertexAttribI2ui(context, index, x, y))
        {
            context->vertexAttribI2ui(index, x, y);
        }
    }
}

void GL_APIENTRY VertexAttribI2uiv(GLuint index, const GLuint *v)
{
    EVENT("(GLuint index = %u, const GLuint *v = 0x%016" PRIxPTR ")", index, (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttribI2uiv, context, index, v);
        if (context->skipValidation() || ValidateVertexAttribI2uiv(context, index, v))
        {
            context->vertexAttribI2uiv(index, v);
        }
    }
}

void GL_APIENTRY VertexAttribI3i(GLuint index, GLint x, GLint y, GLint z)
{
    EVENT("(GLuint index = %u, GLint x = %d, GLint y = %d, GLint z = %d)", index, x, y, z);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttribI3i, context, index, x, y, z);
        if (context->skipValidation() || ValidateVertexAttribI3i(context, index, x, y, z))
        {
            context->vertexAttribI3i(index, x, y, z);
        }
    }
}

void GL_APIENTRY VertexAttribI3iv(GLuint index, const GLint *v)
{
    EVENT("(GLuint index = %u, const GLint *v = 0x%016" PRIxPTR ")", index, (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttribI3iv, context, index, v);
        if (context->skipValidation() || ValidateVertexAttribI3iv(context, index, v))
        {
            context->vertexAttribI3iv(index, v);
        }
    }
}

void GL_APIENTRY VertexAttribI3ui(GLuint index, GLuint x, GLuint y, GLuint z)
{
    EVENT("(GLuint index = %u, GLuint x = %u, GLuint y = %u, GLuint z = %u)", index, x, y, z);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttribI3ui, context, index, x, y, z);
        if (context->skipValidation() || ValidateVertexAttribI3ui(context, index, x, y, z))
        {
            context->vertexAttribI3ui(index, x, y, z);
        }
    }
}

void GL_APIENTRY VertexAttribI3uiv(GLuint index, const GLuint *v)
{
    EVENT("(GLuint index = %u, const GLuint *v = 0x%016" PRIxPTR ")", index, (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttribI3uiv, context, index, v);
        if (context->skipValidation() || ValidateVertexAttribI3uiv(context, index, v))
        {
            context->vertexAttribI3uiv(index, v);
        }
    }
}

void GL_APIENTRY VertexAttribI4bv(GLuint index, const GLbyte *v)
{
    EVENT("(GLuint index = %u, const GLbyte *v = 0x%016" PRIxPTR ")", index, (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttribI4bv, context, index, v);
        if (context->skipValidation() || ValidateVertexAttribI4bv(context, index, v))
        {
            context->vertexAttribI4bv(index, v);
        }
    }
}

void GL_APIENTRY VertexAttribI4i(GLuint index, GLint x, GLint y, GLint z, GLint w)
{
    EVENT("(GLuint index = %u, GLint x = %d, GLint y = %d, GLint z = %d, GLint w = %d)", index, x,
          y, z, w);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttribI4i, context, index, x, y, z, w);
        if (context->skipValidation() || ValidateVertexAttribI4i(context, index, x, y, z, w))
        {
            context->vertexAttribI4i(index, x, y, z, w);
        }
    }
}

void GL_APIENTRY VertexAttribI4iv(GLuint index, const GLint *v)
{
    EVENT("(GLuint index = %u, const GLint *v = 0x%016" PRIxPTR ")", index, (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttribI4iv, context, index, v);
        if (context->skipValidation() || ValidateVertexAttribI4iv(context, index, v))
        {
            context->vertexAttribI4iv(index, v);
        }
    }
}

void GL_APIENTRY VertexAttribI4sv(GLuint index, const GLshort *v)
{
    EVENT("(GLuint index = %u, const GLshort *v = 0x%016" PRIxPTR ")", index, (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttribI4sv, context, index, v);
        if (context->skipValidation() || ValidateVertexAttribI4sv(context, index, v))
        {
            context->vertexAttribI4sv(index, v);
        }
    }
}

void GL_APIENTRY VertexAttribI4ubv(GLuint index, const GLubyte *v)
{
    EVENT("(GLuint index = %u, const GLubyte *v = 0x%016" PRIxPTR ")", index, (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttribI4ubv, context, index, v);
        if (context->skipValidation() || ValidateVertexAttribI4ubv(context, index, v))
        {
            context->vertexAttribI4ubv(index, v);
        }
    }
}

void GL_APIENTRY VertexAttribI4ui(GLuint index, GLuint x, GLuint y, GLuint z, GLuint w)
{
    EVENT("(GLuint index = %u, GLuint x = %u, GLuint y = %u, GLuint z = %u, GLuint w = %u)", index,
          x, y, z, w);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttribI4ui, context, index, x, y, z, w);
        if (context->skipValidation() || ValidateVertexAttribI4ui(context, index, x, y, z, w))
        {
            context->vertexAttribI4ui(index, x, y, z, w);
        }
    }
}

void GL_APIENTRY VertexAttribI4uiv(GLuint index, const GLuint *v)
{
    EVENT("(GLuint index = %u, const GLuint *v = 0x%016" PRIxPTR ")", index, (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttribI4uiv, context, index, v);
        if (context->skipValidation() || ValidateVertexAttribI4uiv(context, index, v))
        {
            context->vertexAttribI4uiv(index, v);
        }
    }
}

void GL_APIENTRY VertexAttribI4usv(GLuint index, const GLushort *v)
{
    EVENT("(GLuint index = %u, const GLushort *v = 0x%016" PRIxPTR ")", index, (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttribI4usv, context, index, v);
        if (context->skipValidation() || ValidateVertexAttribI4usv(context, index, v))
        {
            context->vertexAttribI4usv(index, v);
        }
    }
}

void GL_APIENTRY
VertexAttribIPointer(GLuint index, GLint size, GLenum type, GLsizei stride, const void *pointer)
{
    EVENT(
        "(GLuint index = %u, GLint size = %d, GLenum type = 0x%X, GLsizei stride = %d, const void "
        "*pointer = 0x%016" PRIxPTR ")",
        index, size, type, stride, (uintptr_t)pointer);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        VertexAttribType typePacked = FromGLenum<VertexAttribType>(type);
        ANGLE_CAPTURE(VertexAttribIPointer, context, index, size, typePacked, stride, pointer);
        if (context->skipValidation() ||
            ValidateVertexAttribIPointer(context, index, size, typePacked, stride, pointer))
        {
            context->vertexAttribIPointer(index, size, typePacked, stride, pointer);
        }
    }
}
}  // namespace gl
