// GENERATED FILE - DO NOT EDIT.
// Generated by gen_builtin_symbols.py using data from builtin_function_declarations.txt.
//
// Copyright 2019 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// ImmutableString_test_autogen.cpp:
//   Tests for matching script-generated hashes with runtime computed hashes.

#include "compiler/translator/ImmutableString.h"
#include "gtest/gtest.h"

namespace sh
{

TEST(ImmutableStringTest, ScriptGeneratedHashesMatch)
{
    ASSERT_EQ(0x0848139au, ImmutableString("atan(8B0A").mangledNameHash());
    ASSERT_EQ(0x0e52e500u, ImmutableString("radians(0B").mangledNameHash());
    ASSERT_EQ(0x0e55ac28u, ImmutableString("radians(1B").mangledNameHash());
    ASSERT_EQ(0x0e547683u, ImmutableString("radians(2B").mangledNameHash());
    ASSERT_EQ(0x0e537b7au, ImmutableString("radians(3B").mangledNameHash());
    ASSERT_EQ(0x0e52b187u, ImmutableString("degrees(0B").mangledNameHash());
    ASSERT_EQ(0x0e541edeu, ImmutableString("degrees(1B").mangledNameHash());
    ASSERT_EQ(0x0e507f22u, ImmutableString("degrees(2B").mangledNameHash());
    ASSERT_EQ(0x0e519bd4u, ImmutableString("degrees(3B").mangledNameHash());
    ASSERT_EQ(0x06344570u, ImmutableString("sin(0B").mangledNameHash());
    ASSERT_EQ(0x063314b1u, ImmutableString("sin(1B").mangledNameHash());
    ASSERT_EQ(0x0635d3b3u, ImmutableString("sin(2B").mangledNameHash());
    ASSERT_EQ(0x0634cf9au, ImmutableString("sin(3B").mangledNameHash());
    ASSERT_EQ(0x06366a98u, ImmutableString("cos(0B").mangledNameHash());
    ASSERT_EQ(0x063786f1u, ImmutableString("cos(1B").mangledNameHash());
    ASSERT_EQ(0x0630bc6au, ImmutableString("cos(2B").mangledNameHash());
    ASSERT_EQ(0x06320b8bu, ImmutableString("cos(3B").mangledNameHash());
    ASSERT_EQ(0x063770d0u, ImmutableString("tan(0B").mangledNameHash());
    ASSERT_EQ(0x06309ccau, ImmutableString("tan(1B").mangledNameHash());
    ASSERT_EQ(0x0635a80fu, ImmutableString("tan(2B").mangledNameHash());
    ASSERT_EQ(0x063719d6u, ImmutableString("tan(3B").mangledNameHash());
    ASSERT_EQ(0x083ca453u, ImmutableString("asin(0B").mangledNameHash());
    ASSERT_EQ(0x083df752u, ImmutableString("asin(1B").mangledNameHash());
    ASSERT_EQ(0x083e6948u, ImmutableString("asin(2B").mangledNameHash());
    ASSERT_EQ(0x083f6552u, ImmutableString("asin(3B").mangledNameHash());
    ASSERT_EQ(0x083afbc8u, ImmutableString("acos(0B").mangledNameHash());
    ASSERT_EQ(0x0839e751u, ImmutableString("acos(1B").mangledNameHash());
    ASSERT_EQ(0x08396a55u, ImmutableString("acos(2B").mangledNameHash());
    ASSERT_EQ(0x08383aacu, ImmutableString("acos(3B").mangledNameHash());
    ASSERT_EQ(0x084c10fau, ImmutableString("atan(0B0B").mangledNameHash());
    ASSERT_EQ(0x084aa6bfu, ImmutableString("atan(1B1B").mangledNameHash());
    ASSERT_EQ(0x084ee899u, ImmutableString("atan(2B2B").mangledNameHash());
    ASSERT_EQ(0x08482806u, ImmutableString("atan(3B3B").mangledNameHash());
    ASSERT_EQ(0x083c624bu, ImmutableString("atan(0B").mangledNameHash());
    ASSERT_EQ(0x083b7e52u, ImmutableString("atan(1B").mangledNameHash());
    ASSERT_EQ(0x083aea5fu, ImmutableString("atan(2B").mangledNameHash());
    ASSERT_EQ(0x083dac10u, ImmutableString("atan(3B").mangledNameHash());
    ASSERT_EQ(0x083aa373u, ImmutableString("sinh(0B").mangledNameHash());
    ASSERT_EQ(0x08398f4au, ImmutableString("sinh(1B").mangledNameHash());
    ASSERT_EQ(0x08392747u, ImmutableString("sinh(2B").mangledNameHash());
    ASSERT_EQ(0x083bd9f8u, ImmutableString("sinh(3B").mangledNameHash());
    ASSERT_EQ(0x083b5c45u, ImmutableString("cosh(0B").mangledNameHash());
    ASSERT_EQ(0x083c57c4u, ImmutableString("cosh(1B").mangledNameHash());
    ASSERT_EQ(0x083d8227u, ImmutableString("cosh(2B").mangledNameHash());
    ASSERT_EQ(0x083ed2deu, ImmutableString("cosh(3B").mangledNameHash());
    ASSERT_EQ(0x0838944cu, ImmutableString("tanh(0B").mangledNameHash());
    ASSERT_EQ(0x083991ddu, ImmutableString("tanh(1B").mangledNameHash());
    ASSERT_EQ(0x083acb5eu, ImmutableString("tanh(2B").mangledNameHash());
    ASSERT_EQ(0x0838025eu, ImmutableString("tanh(3B").mangledNameHash());
    ASSERT_EQ(0x0a464ad3u, ImmutableString("asinh(0B").mangledNameHash());
    ASSERT_EQ(0x0a47bb52u, ImmutableString("asinh(1B").mangledNameHash());
    ASSERT_EQ(0x0a400148u, ImmutableString("asinh(2B").mangledNameHash());
    ASSERT_EQ(0x0a4125d1u, ImmutableString("asinh(3B").mangledNameHash());
    ASSERT_EQ(0x0a461d10u, ImmutableString("acosh(0B").mangledNameHash());
    ASSERT_EQ(0x0a44ad91u, ImmutableString("acosh(1B").mangledNameHash());
    ASSERT_EQ(0x0a478c93u, ImmutableString("acosh(2B").mangledNameHash());
    ASSERT_EQ(0x0a46778au, ImmutableString("acosh(3B").mangledNameHash());
    ASSERT_EQ(0x0a4582c9u, ImmutableString("atanh(0B").mangledNameHash());
    ASSERT_EQ(0x0a4431a8u, ImmutableString("atanh(1B").mangledNameHash());
    ASSERT_EQ(0x0a430643u, ImmutableString("atanh(2B").mangledNameHash());
    ASSERT_EQ(0x0a45fcfdu, ImmutableString("atanh(3B").mangledNameHash());
    ASSERT_EQ(0x0646b392u, ImmutableString("pow(0B0B").mangledNameHash());
    ASSERT_EQ(0x06439435u, ImmutableString("pow(1B1B").mangledNameHash());
    ASSERT_EQ(0x064318fcu, ImmutableString("pow(2B2B").mangledNameHash());
    ASSERT_EQ(0x06418e42u, ImmutableString("pow(3B3B").mangledNameHash());
    ASSERT_EQ(0x063595b9u, ImmutableString("exp(0B").mangledNameHash());
    ASSERT_EQ(0x0636b1f1u, ImmutableString("exp(1B").mangledNameHash());
    ASSERT_EQ(0x0637ca4au, ImmutableString("exp(2B").mangledNameHash());
    ASSERT_EQ(0x06352335u, ImmutableString("exp(3B").mangledNameHash());
    ASSERT_EQ(0x063055e6u, ImmutableString("log(0B").mangledNameHash());
    ASSERT_EQ(0x06330b41u, ImmutableString("log(1B").mangledNameHash());
    ASSERT_EQ(0x0631d12au, ImmutableString("log(2B").mangledNameHash());
    ASSERT_EQ(0x0630dce3u, ImmutableString("log(3B").mangledNameHash());
    ASSERT_EQ(0x0839daf2u, ImmutableString("exp2(0B").mangledNameHash());
    ASSERT_EQ(0x083b2b93u, ImmutableString("exp2(1B").mangledNameHash());
    ASSERT_EQ(0x083f8b90u, ImmutableString("exp2(2B").mangledNameHash());
    ASSERT_EQ(0x0838ac89u, ImmutableString("exp2(3B").mangledNameHash());
    ASSERT_EQ(0x083f4babu, ImmutableString("log2(0B").mangledNameHash());
    ASSERT_EQ(0x083e1b7au, ImmutableString("log2(1B").mangledNameHash());
    ASSERT_EQ(0x083cc6e1u, ImmutableString("log2(2B").mangledNameHash());
    ASSERT_EQ(0x083fd32eu, ImmutableString("log2(3B").mangledNameHash());
    ASSERT_EQ(0x0838dc31u, ImmutableString("sqrt(0B").mangledNameHash());
    ASSERT_EQ(0x083bcf76u, ImmutableString("sqrt(1B").mangledNameHash());
    ASSERT_EQ(0x083b577bu, ImmutableString("sqrt(2B").mangledNameHash());
    ASSERT_EQ(0x083a07bau, ImmutableString("sqrt(3B").mangledNameHash());
    ASSERT_EQ(0x16772b69u, ImmutableString("inversesqrt(0B").mangledNameHash());
    ASSERT_EQ(0x1671d38eu, ImmutableString("inversesqrt(1B").mangledNameHash());
    ASSERT_EQ(0x1670b92du, ImmutableString("inversesqrt(2B").mangledNameHash());
    ASSERT_EQ(0x1677857cu, ImmutableString("inversesqrt(3B").mangledNameHash());
    ASSERT_EQ(0x0630942fu, ImmutableString("abs(0B").mangledNameHash());
    ASSERT_EQ(0x063770dfu, ImmutableString("abs(1B").mangledNameHash());
    ASSERT_EQ(0x06371aefu, ImmutableString("abs(2B").mangledNameHash());
    ASSERT_EQ(0x0631a1ccu, ImmutableString("abs(3B").mangledNameHash());
    ASSERT_EQ(0x06309dbcu, ImmutableString("abs(0C").mangledNameHash());
    ASSERT_EQ(0x06378eb0u, ImmutableString("abs(1C").mangledNameHash());
    ASSERT_EQ(0x06370c70u, ImmutableString("abs(2C").mangledNameHash());
    ASSERT_EQ(0x0631d85fu, ImmutableString("abs(3C").mangledNameHash());
    ASSERT_EQ(0x083dd4deu, ImmutableString("sign(0B").mangledNameHash());
    ASSERT_EQ(0x083af266u, ImmutableString("sign(1B").mangledNameHash());
    ASSERT_EQ(0x083c1fc5u, ImmutableString("sign(2B").mangledNameHash());
    ASSERT_EQ(0x083d6eacu, ImmutableString("sign(3B").mangledNameHash());
    ASSERT_EQ(0x083dd369u, ImmutableString("sign(0C").mangledNameHash());
    ASSERT_EQ(0x083acbf5u, ImmutableString("sign(1C").mangledNameHash());
    ASSERT_EQ(0x083c1656u, ImmutableString("sign(2C").mangledNameHash());
    ASSERT_EQ(0x083d503bu, ImmutableString("sign(3C").mangledNameHash());
    ASSERT_EQ(0x0a43465eu, ImmutableString("floor(0B").mangledNameHash());
    ASSERT_EQ(0x0a45ecc0u, ImmutableString("floor(1B").mangledNameHash());
    ASSERT_EQ(0x0a44da6bu, ImmutableString("floor(2B").mangledNameHash());
    ASSERT_EQ(0x0a43be63u, ImmutableString("floor(3B").mangledNameHash());
    ASSERT_EQ(0x0a412446u, ImmutableString("trunc(0B").mangledNameHash());
    ASSERT_EQ(0x0a43edf9u, ImmutableString("trunc(1B").mangledNameHash());
    ASSERT_EQ(0x0a42b872u, ImmutableString("trunc(2B").mangledNameHash());
    ASSERT_EQ(0x0a41bc4bu, ImmutableString("trunc(3B").mangledNameHash());
    ASSERT_EQ(0x0a407c52u, ImmutableString("round(0B").mangledNameHash());
    ASSERT_EQ(0x0a4758c8u, ImmutableString("round(1B").mangledNameHash());
    ASSERT_EQ(0x0a46f2d2u, ImmutableString("round(2B").mangledNameHash());
    ASSERT_EQ(0x0a4189d9u, ImmutableString("round(3B").mangledNameHash());
    ASSERT_EQ(0x1266c2deu, ImmutableString("roundEven(0B").mangledNameHash());
    ASSERT_EQ(0x1265cf4cu, ImmutableString("roundEven(1B").mangledNameHash());
    ASSERT_EQ(0x12614fd4u, ImmutableString("roundEven(2B").mangledNameHash());
    ASSERT_EQ(0x12601c9du, ImmutableString("roundEven(3B").mangledNameHash());
    ASSERT_EQ(0x083a7922u, ImmutableString("ceil(0B").mangledNameHash());
    ASSERT_EQ(0x083f6afdu, ImmutableString("ceil(1B").mangledNameHash());
    ASSERT_EQ(0x0838a17eu, ImmutableString("ceil(2B").mangledNameHash());
    ASSERT_EQ(0x0839f1a7u, ImmutableString("ceil(3B").mangledNameHash());
    ASSERT_EQ(0x0a402a9cu, ImmutableString("fract(0B").mangledNameHash());
    ASSERT_EQ(0x0a4726f2u, ImmutableString("fract(1B").mangledNameHash());
    ASSERT_EQ(0x0a42a596u, ImmutableString("fract(2B").mangledNameHash());
    ASSERT_EQ(0x0a41745fu, ImmutableString("fract(3B").mangledNameHash());
    ASSERT_EQ(0x064778feu, ImmutableString("mod(0B0B").mangledNameHash());
    ASSERT_EQ(0x064082ceu, ImmutableString("mod(1B0B").mangledNameHash());
    ASSERT_EQ(0x06403847u, ImmutableString("mod(2B0B").mangledNameHash());
    ASSERT_EQ(0x0645f03eu, ImmutableString("mod(3B0B").mangledNameHash());
    ASSERT_EQ(0x0641f1d7u, ImmutableString("mod(1B1B").mangledNameHash());
    ASSERT_EQ(0x0642b54du, ImmutableString("mod(2B2B").mangledNameHash());
    ASSERT_EQ(0x06457883u, ImmutableString("mod(3B3B").mangledNameHash());
    ASSERT_EQ(0x0641ceeeu, ImmutableString("min(0B0B").mangledNameHash());
    ASSERT_EQ(0x064107b7u, ImmutableString("min(1B0B").mangledNameHash());
    ASSERT_EQ(0x06462cf0u, ImmutableString("min(2B0B").mangledNameHash());
    ASSERT_EQ(0x06467507u, ImmutableString("min(3B0B").mangledNameHash());
    ASSERT_EQ(0x064274eeu, ImmutableString("min(1B1B").mangledNameHash());
    ASSERT_EQ(0x0640a98au, ImmutableString("min(2B2B").mangledNameHash());
    ASSERT_EQ(0x0645fd82u, ImmutableString("min(3B3B").mangledNameHash());
    ASSERT_EQ(0x0645e25du, ImmutableString("min(0C0C").mangledNameHash());
    ASSERT_EQ(0x0644176eu, ImmutableString("min(1C1C").mangledNameHash());
    ASSERT_EQ(0x06441467u, ImmutableString("min(2C2C").mangledNameHash());
    ASSERT_EQ(0x0642dbfeu, ImmutableString("min(3C3C").mangledNameHash());
    ASSERT_EQ(0x06450593u, ImmutableString("min(1C0C").mangledNameHash());
    ASSERT_EQ(0x06425db3u, ImmutableString("min(2C0C").mangledNameHash());
    ASSERT_EQ(0x06425522u, ImmutableString("min(3C0C").mangledNameHash());
    ASSERT_EQ(0x06420bb0u, ImmutableString("min(0D0D").mangledNameHash());
    ASSERT_EQ(0x0644a6dfu, ImmutableString("min(1D1D").mangledNameHash());
    ASSERT_EQ(0x064236d1u, ImmutableString("min(2D2D").mangledNameHash());
    ASSERT_EQ(0x064305b5u, ImmutableString("min(3D3D").mangledNameHash());
    ASSERT_EQ(0x06436c9au, ImmutableString("min(1D0D").mangledNameHash());
    ASSERT_EQ(0x06408ba2u, ImmutableString("min(2D0D").mangledNameHash());
    ASSERT_EQ(0x0643ebd5u, ImmutableString("min(3D0D").mangledNameHash());
    ASSERT_EQ(0x06472996u, ImmutableString("max(0B0B").mangledNameHash());
    ASSERT_EQ(0x0645114fu, ImmutableString("max(1B0B").mangledNameHash());
    ASSERT_EQ(0x06468fb1u, ImmutableString("max(2B0B").mangledNameHash());
    ASSERT_EQ(0x0643486cu, ImmutableString("max(3B0B").mangledNameHash());
    ASSERT_EQ(0x0646155eu, ImmutableString("max(1B1B").mangledNameHash());
    ASSERT_EQ(0x06400261u, ImmutableString("max(2B2B").mangledNameHash());
    ASSERT_EQ(0x064225ceu, ImmutableString("max(3B3B").mangledNameHash());
    ASSERT_EQ(0x06454045u, ImmutableString("max(0C0C").mangledNameHash());
    ASSERT_EQ(0x0647bc75u, ImmutableString("max(1C1C").mangledNameHash());
    ASSERT_EQ(0x0644cd73u, ImmutableString("max(2C2C").mangledNameHash());
    ASSERT_EQ(0x06448798u, ImmutableString("max(3C3C").mangledNameHash());
    ASSERT_EQ(0x0640f128u, ImmutableString("max(1C0C").mangledNameHash());
    ASSERT_EQ(0x06429e9cu, ImmutableString("max(2C0C").mangledNameHash());
    ASSERT_EQ(0x06475b89u, ImmutableString("max(3C0C").mangledNameHash());
    ASSERT_EQ(0x06473146u, ImmutableString("max(0D0D").mangledNameHash());
    ASSERT_EQ(0x06460349u, ImmutableString("max(1D1D").mangledNameHash());
    ASSERT_EQ(0x06429550u, ImmutableString("max(2D2D").mangledNameHash());
    ASSERT_EQ(0x0642c869u, ImmutableString("max(3D3D").mangledNameHash());
    ASSERT_EQ(0x06452105u, ImmutableString("max(1D0D").mangledNameHash());
    ASSERT_EQ(0x06443b94u, ImmutableString("max(2D0D").mangledNameHash());
    ASSERT_EQ(0x06472b16u, ImmutableString("max(3D0D").mangledNameHash());
    ASSERT_EQ(0x0a65f6b4u, ImmutableString("clamp(0B0B0B").mangledNameHash());
    ASSERT_EQ(0x0a62e0c3u, ImmutableString("clamp(1B0B0B").mangledNameHash());
    ASSERT_EQ(0x0a6670deu, ImmutableString("clamp(2B0B0B").mangledNameHash());
    ASSERT_EQ(0x0a658fc9u, ImmutableString("clamp(3B0B0B").mangledNameHash());
    ASSERT_EQ(0x0a635d1au, ImmutableString("clamp(1B1B1B").mangledNameHash());
    ASSERT_EQ(0x0a679af4u, ImmutableString("clamp(2B2B2B").mangledNameHash());
    ASSERT_EQ(0x0a619e65u, ImmutableString("clamp(3B3B3B").mangledNameHash());
    ASSERT_EQ(0x0a621a2bu, ImmutableString("clamp(0C0C0C").mangledNameHash());
    ASSERT_EQ(0x0a60d0c5u, ImmutableString("clamp(1C0C0C").mangledNameHash());
    ASSERT_EQ(0x0a660047u, ImmutableString("clamp(2C0C0C").mangledNameHash());
    ASSERT_EQ(0x0a624f01u, ImmutableString("clamp(3C0C0C").mangledNameHash());
    ASSERT_EQ(0x0a62ab50u, ImmutableString("clamp(1C1C1C").mangledNameHash());
    ASSERT_EQ(0x0a601dd8u, ImmutableString("clamp(2C2C2C").mangledNameHash());
    ASSERT_EQ(0x0a656274u, ImmutableString("clamp(3C3C3C").mangledNameHash());
    ASSERT_EQ(0x0a660f60u, ImmutableString("clamp(0D0D0D").mangledNameHash());
    ASSERT_EQ(0x0a60570du, ImmutableString("clamp(1D0D0D").mangledNameHash());
    ASSERT_EQ(0x0a623042u, ImmutableString("clamp(2D0D0D").mangledNameHash());
    ASSERT_EQ(0x0a65a625u, ImmutableString("clamp(3D0D0D").mangledNameHash());
    ASSERT_EQ(0x0a631d0bu, ImmutableString("clamp(1D1D1D").mangledNameHash());
    ASSERT_EQ(0x0a64f567u, ImmutableString("clamp(2D2D2D").mangledNameHash());
    ASSERT_EQ(0x0a674065u, ImmutableString("clamp(3D3D3D").mangledNameHash());
    ASSERT_EQ(0x0655be57u, ImmutableString("mix(0B0B0B").mangledNameHash());
    ASSERT_EQ(0x0650f1c9u, ImmutableString("mix(1B1B0B").mangledNameHash());
    ASSERT_EQ(0x0653049du, ImmutableString("mix(2B2B0B").mangledNameHash());
    ASSERT_EQ(0x06561bdcu, ImmutableString("mix(3B3B0B").mangledNameHash());
    ASSERT_EQ(0x0657a0a8u, ImmutableString("mix(1B1B1B").mangledNameHash());
    ASSERT_EQ(0x06549219u, ImmutableString("mix(2B2B2B").mangledNameHash());
    ASSERT_EQ(0x06568deeu, ImmutableString("mix(3B3B3B").mangledNameHash());
    ASSERT_EQ(0x0655a7e2u, ImmutableString("mix(0B0B0E").mangledNameHash());
    ASSERT_EQ(0x0657f3adu, ImmutableString("mix(1B1B1E").mangledNameHash());
    ASSERT_EQ(0x0654b2f8u, ImmutableString("mix(2B2B2E").mangledNameHash());
    ASSERT_EQ(0x06567d08u, ImmutableString("mix(3B3B3E").mangledNameHash());
    ASSERT_EQ(0x084e7be4u, ImmutableString("step(0B0B").mangledNameHash());
    ASSERT_EQ(0x084c9765u, ImmutableString("step(1B1B").mangledNameHash());
    ASSERT_EQ(0x0849bcfdu, ImmutableString("step(2B2B").mangledNameHash());
    ASSERT_EQ(0x084e7af1u, ImmutableString("step(3B3B").mangledNameHash());
    ASSERT_EQ(0x08491304u, ImmutableString("step(0B1B").mangledNameHash());
    ASSERT_EQ(0x084feda7u, ImmutableString("step(0B2B").mangledNameHash());
    ASSERT_EQ(0x084ec1e6u, ImmutableString("step(0B3B").mangledNameHash());
    ASSERT_EQ(0x148de9b5u, ImmutableString("smoothstep(0B0B0B").mangledNameHash());
    ASSERT_EQ(0x1489436du, ImmutableString("smoothstep(1B1B1B").mangledNameHash());
    ASSERT_EQ(0x148a33b9u, ImmutableString("smoothstep(2B2B2B").mangledNameHash());
    ASSERT_EQ(0x1489bfb6u, ImmutableString("smoothstep(3B3B3B").mangledNameHash());
    ASSERT_EQ(0x14888e72u, ImmutableString("smoothstep(0B0B1B").mangledNameHash());
    ASSERT_EQ(0x148f7bf9u, ImmutableString("smoothstep(0B0B2B").mangledNameHash());
    ASSERT_EQ(0x148e5c11u, ImmutableString("smoothstep(0B0B3B").mangledNameHash());
    ASSERT_EQ(0x084bf445u, ImmutableString("modf(0B0B").mangledNameHash());
    ASSERT_EQ(0x084a908au, ImmutableString("modf(1B1B").mangledNameHash());
    ASSERT_EQ(0x084fa835u, ImmutableString("modf(2B2B").mangledNameHash());
    ASSERT_EQ(0x084807e9u, ImmutableString("modf(3B3B").mangledNameHash());
    ASSERT_EQ(0x0a46ab3bu, ImmutableString("isnan(0B").mangledNameHash());
    ASSERT_EQ(0x0a47fa7au, ImmutableString("isnan(1B").mangledNameHash());
    ASSERT_EQ(0x0a406460u, ImmutableString("isnan(2B").mangledNameHash());
    ASSERT_EQ(0x0a4561b0u, ImmutableString("isnan(3B").mangledNameHash());
    ASSERT_EQ(0x0a443a26u, ImmutableString("isinf(0B").mangledNameHash());
    ASSERT_EQ(0x0a452617u, ImmutableString("isinf(1B").mangledNameHash());
    ASSERT_EQ(0x0a4262ceu, ImmutableString("isinf(2B").mangledNameHash());
    ASSERT_EQ(0x0a43b397u, ImmutableString("isinf(3B").mangledNameHash());
    ASSERT_EQ(0x1c8ae0a5u, ImmutableString("floatBitsToInt(0B").mangledNameHash());
    ASSERT_EQ(0x1c89b11cu, ImmutableString("floatBitsToInt(1B").mangledNameHash());
    ASSERT_EQ(0x1c887f5eu, ImmutableString("floatBitsToInt(2B").mangledNameHash());
    ASSERT_EQ(0x1c8f60afu, ImmutableString("floatBitsToInt(3B").mangledNameHash());
    ASSERT_EQ(0x1e903284u, ImmutableString("floatBitsToUint(0B").mangledNameHash());
    ASSERT_EQ(0x1e95201fu, ImmutableString("floatBitsToUint(1B").mangledNameHash());
    ASSERT_EQ(0x1e966adcu, ImmutableString("floatBitsToUint(2B").mangledNameHash());
    ASSERT_EQ(0x1e97a505u, ImmutableString("floatBitsToUint(3B").mangledNameHash());
    ASSERT_EQ(0x1c89e261u, ImmutableString("intBitsToFloat(0C").mangledNameHash());
    ASSERT_EQ(0x1c88f18cu, ImmutableString("intBitsToFloat(1C").mangledNameHash());
    ASSERT_EQ(0x1c887424u, ImmutableString("intBitsToFloat(2C").mangledNameHash());
    ASSERT_EQ(0x1c8b20dau, ImmutableString("intBitsToFloat(3C").mangledNameHash());
    ASSERT_EQ(0x1e93c13fu, ImmutableString("uintBitsToFloat(0D").mangledNameHash());
    ASSERT_EQ(0x1e95582au, ImmutableString("uintBitsToFloat(1D").mangledNameHash());
    ASSERT_EQ(0x1e95b0a7u, ImmutableString("uintBitsToFloat(2D").mangledNameHash());
    ASSERT_EQ(0x1e92e353u, ImmutableString("uintBitsToFloat(3D").mangledNameHash());
    ASSERT_EQ(0x0a5799e7u, ImmutableString("frexp(0B0C").mangledNameHash());
    ASSERT_EQ(0x0a55008fu, ImmutableString("frexp(1B1C").mangledNameHash());
    ASSERT_EQ(0x0a50a6eeu, ImmutableString("frexp(2B2C").mangledNameHash());
    ASSERT_EQ(0x0a53e9c4u, ImmutableString("frexp(3B3C").mangledNameHash());
    ASSERT_EQ(0x0a52bed1u, ImmutableString("ldexp(0B0C").mangledNameHash());
    ASSERT_EQ(0x0a50832eu, ImmutableString("ldexp(1B1C").mangledNameHash());
    ASSERT_EQ(0x0a54aa52u, ImmutableString("ldexp(2B2C").mangledNameHash());
    ASSERT_EQ(0x0a57c201u, ImmutableString("ldexp(3B3C").mangledNameHash());
    ASSERT_EQ(0x1a84fa77u, ImmutableString("packSnorm2x16(1B").mangledNameHash());
    ASSERT_EQ(0x1a873678u, ImmutableString("packUnorm2x16(1B").mangledNameHash());
    ASSERT_EQ(0x187df788u, ImmutableString("packHalf2x16(1B").mangledNameHash());
    ASSERT_EQ(0x1e95511bu, ImmutableString("unpackSnorm2x16(0D").mangledNameHash());
    ASSERT_EQ(0x1e9718ffu, ImmutableString("unpackUnorm2x16(0D").mangledNameHash());
    ASSERT_EQ(0x1c8dd4e6u, ImmutableString("unpackHalf2x16(0D").mangledNameHash());
    ASSERT_EQ(0x187c1f3fu, ImmutableString("packUnorm4x8(3B").mangledNameHash());
    ASSERT_EQ(0x187b7b7cu, ImmutableString("packSnorm4x8(3B").mangledNameHash());
    ASSERT_EQ(0x1c8be3bau, ImmutableString("unpackUnorm4x8(0D").mangledNameHash());
    ASSERT_EQ(0x1c894fb3u, ImmutableString("unpackSnorm4x8(0D").mangledNameHash());
    ASSERT_EQ(0x0c48bffau, ImmutableString("length(0B").mangledNameHash());
    ASSERT_EQ(0x0c4f6cbbu, ImmutableString("length(1B").mangledNameHash());
    ASSERT_EQ(0x0c4a38b6u, ImmutableString("length(2B").mangledNameHash());
    ASSERT_EQ(0x0c4924f7u, ImmutableString("length(3B").mangledNameHash());
    ASSERT_EQ(0x106caf4fu, ImmutableString("distance(0B0B").mangledNameHash());
    ASSERT_EQ(0x106ff564u, ImmutableString("distance(1B1B").mangledNameHash());
    ASSERT_EQ(0x1068c0bfu, ImmutableString("distance(2B2B").mangledNameHash());
    ASSERT_EQ(0x1068425fu, ImmutableString("distance(3B3B").mangledNameHash());
    ASSERT_EQ(0x06450933u, ImmutableString("dot(0B0B").mangledNameHash());
    ASSERT_EQ(0x06421555u, ImmutableString("dot(1B1B").mangledNameHash());
    ASSERT_EQ(0x06463219u, ImmutableString("dot(2B2B").mangledNameHash());
    ASSERT_EQ(0x06415ae6u, ImmutableString("dot(3B3B").mangledNameHash());
    ASSERT_EQ(0x0a527d10u, ImmutableString("cross(2B2B").mangledNameHash());
    ASSERT_EQ(0x12650243u, ImmutableString("normalize(0B").mangledNameHash());
    ASSERT_EQ(0x126235c4u, ImmutableString("normalize(1B").mangledNameHash());
    ASSERT_EQ(0x12635a67u, ImmutableString("normalize(2B").mangledNameHash());
    ASSERT_EQ(0x1264aa3eu, ImmutableString("normalize(3B").mangledNameHash());
    ASSERT_EQ(0x1697cde8u, ImmutableString("faceforward(0B0B0B").mangledNameHash());
    ASSERT_EQ(0x1691c40bu, ImmutableString("faceforward(1B1B1B").mangledNameHash());
    ASSERT_EQ(0x1696babeu, ImmutableString("faceforward(2B2B2B").mangledNameHash());
    ASSERT_EQ(0x1690b84du, ImmutableString("faceforward(3B3B3B").mangledNameHash());
    ASSERT_EQ(0x0e63358eu, ImmutableString("reflect(0B0B").mangledNameHash());
    ASSERT_EQ(0x0e665b7bu, ImmutableString("reflect(1B1B").mangledNameHash());
    ASSERT_EQ(0x0e620f44u, ImmutableString("reflect(2B2B").mangledNameHash());
    ASSERT_EQ(0x0e631c50u, ImmutableString("reflect(3B3B").mangledNameHash());
    ASSERT_EQ(0x0e73b594u, ImmutableString("refract(0B0B0B").mangledNameHash());
    ASSERT_EQ(0x0e706684u, ImmutableString("refract(1B1B0B").mangledNameHash());
    ASSERT_EQ(0x0e71a4fcu, ImmutableString("refract(2B2B0B").mangledNameHash());
    ASSERT_EQ(0x0e71b28du, ImmutableString("refract(3B3B0B").mangledNameHash());
    ASSERT_EQ(0x1c993bdfu, ImmutableString("matrixCompMult(5B5B").mangledNameHash());
    ASSERT_EQ(0x1c9e72dbu, ImmutableString("matrixCompMult(ABAB").mangledNameHash());
    ASSERT_EQ(0x1c9b357cu, ImmutableString("matrixCompMult(FBFB").mangledNameHash());
    ASSERT_EQ(0x1c9876e4u, ImmutableString("matrixCompMult(9B9B").mangledNameHash());
    ASSERT_EQ(0x1c9c8697u, ImmutableString("matrixCompMult(6B6B").mangledNameHash());
    ASSERT_EQ(0x1c9ea241u, ImmutableString("matrixCompMult(DBDB").mangledNameHash());
    ASSERT_EQ(0x1c99affcu, ImmutableString("matrixCompMult(7B7B").mangledNameHash());
    ASSERT_EQ(0x1c9fa571u, ImmutableString("matrixCompMult(EBEB").mangledNameHash());
    ASSERT_EQ(0x1c9ccd5au, ImmutableString("matrixCompMult(BBBB").mangledNameHash());
    ASSERT_EQ(0x188880cbu, ImmutableString("outerProduct(1B1B").mangledNameHash());
    ASSERT_EQ(0x188db87au, ImmutableString("outerProduct(2B2B").mangledNameHash());
    ASSERT_EQ(0x188e0232u, ImmutableString("outerProduct(3B3B").mangledNameHash());
    ASSERT_EQ(0x188e2270u, ImmutableString("outerProduct(2B1B").mangledNameHash());
    ASSERT_EQ(0x188916c3u, ImmutableString("outerProduct(1B2B").mangledNameHash());
    ASSERT_EQ(0x188f8feeu, ImmutableString("outerProduct(3B1B").mangledNameHash());
    ASSERT_EQ(0x188a12cau, ImmutableString("outerProduct(1B3B").mangledNameHash());
    ASSERT_EQ(0x1888c44du, ImmutableString("outerProduct(3B2B").mangledNameHash());
    ASSERT_EQ(0x18887331u, ImmutableString("outerProduct(2B3B").mangledNameHash());
    ASSERT_EQ(0x1267db60u, ImmutableString("transpose(5B").mangledNameHash());
    ASSERT_EQ(0x12602fd7u, ImmutableString("transpose(AB").mangledNameHash());
    ASSERT_EQ(0x12661b07u, ImmutableString("transpose(FB").mangledNameHash());
    ASSERT_EQ(0x12650771u, ImmutableString("transpose(6B").mangledNameHash());
    ASSERT_EQ(0x12658f24u, ImmutableString("transpose(9B").mangledNameHash());
    ASSERT_EQ(0x12665430u, ImmutableString("transpose(7B").mangledNameHash());
    ASSERT_EQ(0x1267de6cu, ImmutableString("transpose(DB").mangledNameHash());
    ASSERT_EQ(0x12655b22u, ImmutableString("transpose(BB").mangledNameHash());
    ASSERT_EQ(0x1264f5e4u, ImmutableString("transpose(EB").mangledNameHash());
    ASSERT_EQ(0x1676ad75u, ImmutableString("determinant(5B").mangledNameHash());
    ASSERT_EQ(0x167719ccu, ImmutableString("determinant(AB").mangledNameHash());
    ASSERT_EQ(0x1674ed12u, ImmutableString("determinant(FB").mangledNameHash());
    ASSERT_EQ(0x0e503084u, ImmutableString("inverse(5B").mangledNameHash());
    ASSERT_EQ(0x0e507cbdu, ImmutableString("inverse(AB").mangledNameHash());
    ASSERT_EQ(0x0e50cc43u, ImmutableString("inverse(FB").mangledNameHash());
    ASSERT_EQ(0x1069b2c0u, ImmutableString("lessThan(1B1B").mangledNameHash());
    ASSERT_EQ(0x106a713eu, ImmutableString("lessThan(2B2B").mangledNameHash());
    ASSERT_EQ(0x106d2c39u, ImmutableString("lessThan(3B3B").mangledNameHash());
    ASSERT_EQ(0x106b4468u, ImmutableString("lessThan(1C1C").mangledNameHash());
    ASSERT_EQ(0x106faaeau, ImmutableString("lessThan(2C2C").mangledNameHash());
    ASSERT_EQ(0x106a110cu, ImmutableString("lessThan(3C3C").mangledNameHash());
    ASSERT_EQ(0x106d7bd6u, ImmutableString("lessThan(1D1D").mangledNameHash());
    ASSERT_EQ(0x10697de8u, ImmutableString("lessThan(2D2D").mangledNameHash());
    ASSERT_EQ(0x106843efu, ImmutableString("lessThan(3D3D").mangledNameHash());
    ASSERT_EQ(0x1a95c72au, ImmutableString("lessThanEqual(1B1B").mangledNameHash());
    ASSERT_EQ(0x1a97d055u, ImmutableString("lessThanEqual(2B2B").mangledNameHash());
    ASSERT_EQ(0x1a9642f7u, ImmutableString("lessThanEqual(3B3B").mangledNameHash());
    ASSERT_EQ(0x1a977782u, ImmutableString("lessThanEqual(1C1C").mangledNameHash());
    ASSERT_EQ(0x1a9481a8u, ImmutableString("lessThanEqual(2C2C").mangledNameHash());
    ASSERT_EQ(0x1a94a164u, ImmutableString("lessThanEqual(3C3C").mangledNameHash());
    ASSERT_EQ(0x1a95efdcu, ImmutableString("lessThanEqual(1D1D").mangledNameHash());
    ASSERT_EQ(0x1a92589du, ImmutableString("lessThanEqual(2D2D").mangledNameHash());
    ASSERT_EQ(0x1a96ec62u, ImmutableString("lessThanEqual(3D3D").mangledNameHash());
    ASSERT_EQ(0x16817df9u, ImmutableString("greaterThan(1B1B").mangledNameHash());
    ASSERT_EQ(0x16853112u, ImmutableString("greaterThan(2B2B").mangledNameHash());
    ASSERT_EQ(0x16829d5du, ImmutableString("greaterThan(3B3B").mangledNameHash());
    ASSERT_EQ(0x1685db46u, ImmutableString("greaterThan(1C1C").mangledNameHash());
    ASSERT_EQ(0x1685d025u, ImmutableString("greaterThan(2C2C").mangledNameHash());
    ASSERT_EQ(0x1681b963u, ImmutableString("greaterThan(3C3C").mangledNameHash());
    ASSERT_EQ(0x168174f7u, ImmutableString("greaterThan(1D1D").mangledNameHash());
    ASSERT_EQ(0x1681d6b4u, ImmutableString("greaterThan(2D2D").mangledNameHash());
    ASSERT_EQ(0x16812c54u, ImmutableString("greaterThan(3D3D").mangledNameHash());
    ASSERT_EQ(0x20acdd3au, ImmutableString("greaterThanEqual(1B1B").mangledNameHash());
    ASSERT_EQ(0x20ae6ffbu, ImmutableString("greaterThanEqual(2B2B").mangledNameHash());
    ASSERT_EQ(0x20adfc96u, ImmutableString("greaterThanEqual(3B3B").mangledNameHash());
    ASSERT_EQ(0x20af1dd4u, ImmutableString("greaterThanEqual(1C1C").mangledNameHash());
    ASSERT_EQ(0x20ab1dc0u, ImmutableString("greaterThanEqual(2C2C").mangledNameHash());
    ASSERT_EQ(0x20ad192cu, ImmutableString("greaterThanEqual(3C3C").mangledNameHash());
    ASSERT_EQ(0x20aedbacu, ImmutableString("greaterThanEqual(1D1D").mangledNameHash());
    ASSERT_EQ(0x20a92dc6u, ImmutableString("greaterThanEqual(2D2D").mangledNameHash());
    ASSERT_EQ(0x20ae96edu, ImmutableString("greaterThanEqual(3D3D").mangledNameHash());
    ASSERT_EQ(0x0a57a8f5u, ImmutableString("equal(1B1B").mangledNameHash());
    ASSERT_EQ(0x0a54c30cu, ImmutableString("equal(2B2B").mangledNameHash());
    ASSERT_EQ(0x0a51bddcu, ImmutableString("equal(3B3B").mangledNameHash());
    ASSERT_EQ(0x0a554046u, ImmutableString("equal(1C1C").mangledNameHash());
    ASSERT_EQ(0x0a542036u, ImmutableString("equal(2C2C").mangledNameHash());
    ASSERT_EQ(0x0a56874bu, ImmutableString("equal(3C3C").mangledNameHash());
    ASSERT_EQ(0x0a5613e7u, ImmutableString("equal(1D1D").mangledNameHash());
    ASSERT_EQ(0x0a524bc4u, ImmutableString("equal(2D2D").mangledNameHash());
    ASSERT_EQ(0x0a56ba24u, ImmutableString("equal(3D3D").mangledNameHash());
    ASSERT_EQ(0x0a5744dcu, ImmutableString("equal(1E1E").mangledNameHash());
    ASSERT_EQ(0x0a56fc88u, ImmutableString("equal(2E2E").mangledNameHash());
    ASSERT_EQ(0x0a513a26u, ImmutableString("equal(3E3E").mangledNameHash());
    ASSERT_EQ(0x106ade94u, ImmutableString("notEqual(1B1B").mangledNameHash());
    ASSERT_EQ(0x106dabccu, ImmutableString("notEqual(2B2B").mangledNameHash());
    ASSERT_EQ(0x106b8219u, ImmutableString("notEqual(3B3B").mangledNameHash());
    ASSERT_EQ(0x106b25c9u, ImmutableString("notEqual(1C1C").mangledNameHash());
    ASSERT_EQ(0x106a63f2u, ImmutableString("notEqual(2C2C").mangledNameHash());
    ASSERT_EQ(0x106eaf65u, ImmutableString("notEqual(3C3C").mangledNameHash());
    ASSERT_EQ(0x106ad530u, ImmutableString("notEqual(1D1D").mangledNameHash());
    ASSERT_EQ(0x106e7a45u, ImmutableString("notEqual(2D2D").mangledNameHash());
    ASSERT_EQ(0x106e2903u, ImmutableString("notEqual(3D3D").mangledNameHash());
    ASSERT_EQ(0x1068f060u, ImmutableString("notEqual(1E1E").mangledNameHash());
    ASSERT_EQ(0x10695fe7u, ImmutableString("notEqual(2E2E").mangledNameHash());
    ASSERT_EQ(0x106bc4fcu, ImmutableString("notEqual(3E3E").mangledNameHash());
    ASSERT_EQ(0x063194bfu, ImmutableString("any(1E").mangledNameHash());
    ASSERT_EQ(0x063415e2u, ImmutableString("any(2E").mangledNameHash());
    ASSERT_EQ(0x0632fcb3u, ImmutableString("any(3E").mangledNameHash());
    ASSERT_EQ(0x06307fbcu, ImmutableString("all(1E").mangledNameHash());
    ASSERT_EQ(0x0635eb79u, ImmutableString("all(2E").mangledNameHash());
    ASSERT_EQ(0x0636dda0u, ImmutableString("all(3E").mangledNameHash());
    ASSERT_EQ(0x0636e0efu, ImmutableString("not(1E").mangledNameHash());
    ASSERT_EQ(0x06376a86u, ImmutableString("not(2E").mangledNameHash());
    ASSERT_EQ(0x0630826fu, ImmutableString("not(3E").mangledNameHash());
    ASSERT_EQ(0x1eb17f7du, ImmutableString("bitfieldExtract(0C0C0C").mangledNameHash());
    ASSERT_EQ(0x1eb19a50u, ImmutableString("bitfieldExtract(1C0C0C").mangledNameHash());
    ASSERT_EQ(0x1eb0c64fu, ImmutableString("bitfieldExtract(2C0C0C").mangledNameHash());
    ASSERT_EQ(0x1eb17d11u, ImmutableString("bitfieldExtract(3C0C0C").mangledNameHash());
    ASSERT_EQ(0x1eb0f9fau, ImmutableString("bitfieldExtract(0D0C0C").mangledNameHash());
    ASSERT_EQ(0x1eb5f0c8u, ImmutableString("bitfieldExtract(1D0C0C").mangledNameHash());
    ASSERT_EQ(0x1eb28b55u, ImmutableString("bitfieldExtract(2D0C0C").mangledNameHash());
    ASSERT_EQ(0x1eb12f29u, ImmutableString("bitfieldExtract(3D0C0C").mangledNameHash());
    ASSERT_EQ(0x1cbdf898u, ImmutableString("bitfieldInsert(0C0C0C0C").mangledNameHash());
    ASSERT_EQ(0x1cb90fd0u, ImmutableString("bitfieldInsert(1C1C0C0C").mangledNameHash());
    ASSERT_EQ(0x1cbfaf73u, ImmutableString("bitfieldInsert(2C2C0C0C").mangledNameHash());
    ASSERT_EQ(0x1cb880bfu, ImmutableString("bitfieldInsert(3C3C0C0C").mangledNameHash());
    ASSERT_EQ(0x1cbb43f5u, ImmutableString("bitfieldInsert(0D0D0C0C").mangledNameHash());
    ASSERT_EQ(0x1cb9fb13u, ImmutableString("bitfieldInsert(1D1D0C0C").mangledNameHash());
    ASSERT_EQ(0x1cbb9db3u, ImmutableString("bitfieldInsert(2D2D0C0C").mangledNameHash());
    ASSERT_EQ(0x1cb84b0cu, ImmutableString("bitfieldInsert(3D3D0C0C").mangledNameHash());
    ASSERT_EQ(0x1e91c654u, ImmutableString("bitfieldReverse(0C").mangledNameHash());
    ASSERT_EQ(0x1e970da3u, ImmutableString("bitfieldReverse(1C").mangledNameHash());
    ASSERT_EQ(0x1e9797d2u, ImmutableString("bitfieldReverse(2C").mangledNameHash());
    ASSERT_EQ(0x1e9088f7u, ImmutableString("bitfieldReverse(3C").mangledNameHash());
    ASSERT_EQ(0x1e91e675u, ImmutableString("bitfieldReverse(0D").mangledNameHash());
    ASSERT_EQ(0x1e96ddc2u, ImmutableString("bitfieldReverse(1D").mangledNameHash());
    ASSERT_EQ(0x1e9744d7u, ImmutableString("bitfieldReverse(2D").mangledNameHash());
    ASSERT_EQ(0x1e907f62u, ImmutableString("bitfieldReverse(3D").mangledNameHash());
    ASSERT_EQ(0x1059dae9u, ImmutableString("bitCount(0C").mangledNameHash());
    ASSERT_EQ(0x1058cbf7u, ImmutableString("bitCount(1C").mangledNameHash());
    ASSERT_EQ(0x10584c2du, ImmutableString("bitCount(2C").mangledNameHash());
    ASSERT_EQ(0x105b1832u, ImmutableString("bitCount(3C").mangledNameHash());
    ASSERT_EQ(0x1059a37cu, ImmutableString("bitCount(0D").mangledNameHash());
    ASSERT_EQ(0x105896f1u, ImmutableString("bitCount(1D").mangledNameHash());
    ASSERT_EQ(0x10581cccu, ImmutableString("bitCount(2D").mangledNameHash());
    ASSERT_EQ(0x105b2810u, ImmutableString("bitCount(3D").mangledNameHash());
    ASSERT_EQ(0x0e5607c2u, ImmutableString("findLSB(0C").mangledNameHash());
    ASSERT_EQ(0x0e5514e7u, ImmutableString("findLSB(1C").mangledNameHash());
    ASSERT_EQ(0x0e54832eu, ImmutableString("findLSB(2C").mangledNameHash());
    ASSERT_EQ(0x0e574a59u, ImmutableString("findLSB(3C").mangledNameHash());
    ASSERT_EQ(0x0e5650c7u, ImmutableString("findLSB(0D").mangledNameHash());
    ASSERT_EQ(0x0e550f72u, ImmutableString("findLSB(1D").mangledNameHash());
    ASSERT_EQ(0x0e54b667u, ImmutableString("findLSB(2D").mangledNameHash());
    ASSERT_EQ(0x0e573680u, ImmutableString("findLSB(3D").mangledNameHash());
    ASSERT_EQ(0x0e508070u, ImmutableString("findMSB(0C").mangledNameHash());
    ASSERT_EQ(0x0e51917du, ImmutableString("findMSB(1C").mangledNameHash());
    ASSERT_EQ(0x0e56cd55u, ImmutableString("findMSB(2C").mangledNameHash());
    ASSERT_EQ(0x0e500330u, ImmutableString("findMSB(3C").mangledNameHash());
    ASSERT_EQ(0x0e508a05u, ImmutableString("findMSB(0D").mangledNameHash());
    ASSERT_EQ(0x0e51dc78u, ImmutableString("findMSB(1D").mangledNameHash());
    ASSERT_EQ(0x0e56a99cu, ImmutableString("findMSB(2D").mangledNameHash());
    ASSERT_EQ(0x0e503089u, ImmutableString("findMSB(3D").mangledNameHash());
    ASSERT_EQ(0x1283ba95u, ImmutableString("uaddCarry(0D0D0D").mangledNameHash());
    ASSERT_EQ(0x12843bc0u, ImmutableString("uaddCarry(1D1D1D").mangledNameHash());
    ASSERT_EQ(0x12840dfbu, ImmutableString("uaddCarry(2D2D2D").mangledNameHash());
    ASSERT_EQ(0x12842566u, ImmutableString("uaddCarry(3D3D3D").mangledNameHash());
    ASSERT_EQ(0x148f6fe1u, ImmutableString("usubBorrow(0D0D0D").mangledNameHash());
    ASSERT_EQ(0x148ab5f1u, ImmutableString("usubBorrow(1D1D1D").mangledNameHash());
    ASSERT_EQ(0x14896692u, ImmutableString("usubBorrow(2D2D2D").mangledNameHash());
    ASSERT_EQ(0x1488ffa7u, ImmutableString("usubBorrow(3D3D3D").mangledNameHash());
    ASSERT_EQ(0x18a93bdcu, ImmutableString("umulExtended(0D0D0D0D").mangledNameHash());
    ASSERT_EQ(0x18ab4baeu, ImmutableString("umulExtended(1D1D1D1D").mangledNameHash());
    ASSERT_EQ(0x18aa71ceu, ImmutableString("umulExtended(2D2D2D2D").mangledNameHash());
    ASSERT_EQ(0x18a94b63u, ImmutableString("umulExtended(3D3D3D3D").mangledNameHash());
    ASSERT_EQ(0x18ac377fu, ImmutableString("imulExtended(0C0C0C0C").mangledNameHash());
    ASSERT_EQ(0x18ae7b8cu, ImmutableString("imulExtended(1C1C1C1C").mangledNameHash());
    ASSERT_EQ(0x18a851efu, ImmutableString("imulExtended(2C2C2C2C").mangledNameHash());
    ASSERT_EQ(0x18ac1df0u, ImmutableString("imulExtended(3C3C3C3C").mangledNameHash());
    ASSERT_EQ(0x1271689cu, ImmutableString("texture2D(0H1B").mangledNameHash());
    ASSERT_EQ(0x1a96b8d6u, ImmutableString("texture2DProj(0H2B").mangledNameHash());
    ASSERT_EQ(0x1a95bcc7u, ImmutableString("texture2DProj(0H3B").mangledNameHash());
    ASSERT_EQ(0x1680927du, ImmutableString("textureCube(0J2B").mangledNameHash());
    ASSERT_EQ(0x127728cau, ImmutableString("texture2D(0L1B").mangledNameHash());
    ASSERT_EQ(0x1a92969du, ImmutableString("texture2DProj(0L2B").mangledNameHash());
    ASSERT_EQ(0x1a9584eau, ImmutableString("texture2DProj(0L3B").mangledNameHash());
    ASSERT_EQ(0x1a902408u, ImmutableString("texture2DRect(0N1B").mangledNameHash());
    ASSERT_EQ(0x22b65e05u, ImmutableString("texture2DRectProj(0N2B").mangledNameHash());
    ASSERT_EQ(0x22b53a05u, ImmutableString("texture2DRectProj(0N3B").mangledNameHash());
    ASSERT_EQ(0x0e663be3u, ImmutableString("texture(0N1B").mangledNameHash());
    ASSERT_EQ(0x1686cb94u, ImmutableString("textureProj(0N2B").mangledNameHash());
    ASSERT_EQ(0x1685b785u, ImmutableString("textureProj(0N3B").mangledNameHash());
    ASSERT_EQ(0x20cb8d71u, ImmutableString("texture2DGradEXT(0H1B1B1B").mangledNameHash());
    ASSERT_EQ(0x28ed5178u, ImmutableString("texture2DProjGradEXT(0H2B1B1B").mangledNameHash());
    ASSERT_EQ(0x28e995cbu, ImmutableString("texture2DProjGradEXT(0H3B1B1B").mangledNameHash());
    ASSERT_EQ(0x24dbd51eu, ImmutableString("textureCubeGradEXT(0J2B2B2B").mangledNameHash());
    ASSERT_EQ(0x12846ba6u, ImmutableString("texture2D(0H1B0B").mangledNameHash());
    ASSERT_EQ(0x1aa44389u, ImmutableString("texture2DProj(0H2B0B").mangledNameHash());
    ASSERT_EQ(0x1aa197a7u, ImmutableString("texture2DProj(0H3B0B").mangledNameHash());
    ASSERT_EQ(0x1696a314u, ImmutableString("textureCube(0J2B0B").mangledNameHash());
    ASSERT_EQ(0x08398819u, ImmutableString("dFdx(0B").mangledNameHash());
    ASSERT_EQ(0x083c6796u, ImmutableString("dFdx(1B").mangledNameHash());
    ASSERT_EQ(0x083c0d13u, ImmutableString("dFdx(2B").mangledNameHash());
    ASSERT_EQ(0x083abe52u, ImmutableString("dFdx(3B").mangledNameHash());
    ASSERT_EQ(0x08394c88u, ImmutableString("dFdy(0B").mangledNameHash());
    ASSERT_EQ(0x083a7081u, ImmutableString("dFdy(1B").mangledNameHash());
    ASSERT_EQ(0x083b9d7au, ImmutableString("dFdy(2B").mangledNameHash());
    ASSERT_EQ(0x083ced8bu, ImmutableString("dFdy(3B").mangledNameHash());
    ASSERT_EQ(0x0c4d354eu, ImmutableString("fwidth(0B").mangledNameHash());
    ASSERT_EQ(0x0c483e39u, ImmutableString("fwidth(1B").mangledNameHash());
    ASSERT_EQ(0x0c4fa8b5u, ImmutableString("fwidth(2B").mangledNameHash());
    ASSERT_EQ(0x0c4e7b0cu, ImmutableString("fwidth(3B").mangledNameHash());
    ASSERT_EQ(0x1eb43b6cu, ImmutableString("texture2DLodEXT(0H1B0B").mangledNameHash());
    ASSERT_EQ(0x26d60d82u, ImmutableString("texture2DProjLodEXT(0H2B0B").mangledNameHash());
    ASSERT_EQ(0x26d1d3beu, ImmutableString("texture2DProjLodEXT(0H3B0B").mangledNameHash());
    ASSERT_EQ(0x22c206a5u, ImmutableString("textureCubeLodEXT(0J2B0B").mangledNameHash());
    ASSERT_EQ(0x12764e24u, ImmutableString("texture3D(0I2B").mangledNameHash());
    ASSERT_EQ(0x12810dc6u, ImmutableString("texture3D(0I2B0B").mangledNameHash());
    ASSERT_EQ(0x1a93312fu, ImmutableString("texture3DProj(0I3B").mangledNameHash());
    ASSERT_EQ(0x1aa7eecdu, ImmutableString("texture3DProj(0I3B0B").mangledNameHash());
    ASSERT_EQ(0x189e8416u, ImmutableString("texture3DLod(0I2B0B").mangledNameHash());
    ASSERT_EQ(0x20b9ceecu, ImmutableString("texture3DProjLod(0I3B0B").mangledNameHash());
    ASSERT_EQ(0x18986fc2u, ImmutableString("texture2DLod(0H1B0B").mangledNameHash());
    ASSERT_EQ(0x20bc6337u, ImmutableString("texture2DProjLod(0H2B0B").mangledNameHash());
    ASSERT_EQ(0x20b8a0c3u, ImmutableString("texture2DProjLod(0H3B0B").mangledNameHash());
    ASSERT_EQ(0x1cac1f4du, ImmutableString("textureCubeLod(0J2B0B").mangledNameHash());
    ASSERT_EQ(0x0e65ea73u, ImmutableString("texture(0H1B").mangledNameHash());
    ASSERT_EQ(0x0e60bb56u, ImmutableString("texture(0Q1B").mangledNameHash());
    ASSERT_EQ(0x0e64ec86u, ImmutableString("texture(0W1B").mangledNameHash());
    ASSERT_EQ(0x0e625169u, ImmutableString("texture(0I2B").mangledNameHash());
    ASSERT_EQ(0x0e67a979u, ImmutableString("texture(0R2B").mangledNameHash());
    ASSERT_EQ(0x0e64854cu, ImmutableString("texture(0X2B").mangledNameHash());
    ASSERT_EQ(0x0e6470f1u, ImmutableString("texture(0J2B").mangledNameHash());
    ASSERT_EQ(0x0e60445cu, ImmutableString("texture(0S2B").mangledNameHash());
    ASSERT_EQ(0x0e67dce5u, ImmutableString("texture(0Y2B").mangledNameHash());
    ASSERT_EQ(0x0e61222eu, ImmutableString("texture(0K2B").mangledNameHash());
    ASSERT_EQ(0x0e62790eu, ImmutableString("texture(0T2B").mangledNameHash());
    ASSERT_EQ(0x0e61e49du, ImmutableString("texture(0Z2B").mangledNameHash());
    ASSERT_EQ(0x168178c7u, ImmutableString("textureProj(0H2B").mangledNameHash());
    ASSERT_EQ(0x1685011eu, ImmutableString("textureProj(0Q2B").mangledNameHash());
    ASSERT_EQ(0x1687d107u, ImmutableString("textureProj(0W2B").mangledNameHash());
    ASSERT_EQ(0x16840064u, ImmutableString("textureProj(0H3B").mangledNameHash());
    ASSERT_EQ(0x16860d28u, ImmutableString("textureProj(0Q3B").mangledNameHash());
    ASSERT_EQ(0x16812eeeu, ImmutableString("textureProj(0W3B").mangledNameHash());
    ASSERT_EQ(0x1685ca01u, ImmutableString("textureProj(0I3B").mangledNameHash());
    ASSERT_EQ(0x1687c54du, ImmutableString("textureProj(0R3B").mangledNameHash());
    ASSERT_EQ(0x1682b6c4u, ImmutableString("textureProj(0X3B").mangledNameHash());
    ASSERT_EQ(0x148b33b6u, ImmutableString("textureLod(0H1B0B").mangledNameHash());
    ASSERT_EQ(0x148fa8bbu, ImmutableString("textureLod(0Q1B0B").mangledNameHash());
    ASSERT_EQ(0x1488a5bfu, ImmutableString("textureLod(0W1B0B").mangledNameHash());
    ASSERT_EQ(0x148d335cu, ImmutableString("textureLod(0I2B0B").mangledNameHash());
    ASSERT_EQ(0x148cccafu, ImmutableString("textureLod(0R2B0B").mangledNameHash());
    ASSERT_EQ(0x14882ba7u, ImmutableString("textureLod(0X2B0B").mangledNameHash());
    ASSERT_EQ(0x148b00dbu, ImmutableString("textureLod(0J2B0B").mangledNameHash());
    ASSERT_EQ(0x148a66beu, ImmutableString("textureLod(0S2B0B").mangledNameHash());
    ASSERT_EQ(0x148e44d3u, ImmutableString("textureLod(0Y2B0B").mangledNameHash());
    ASSERT_EQ(0x148ed87fu, ImmutableString("textureLod(0K2B0B").mangledNameHash());
    ASSERT_EQ(0x1489e510u, ImmutableString("textureLod(0T2B0B").mangledNameHash());
    ASSERT_EQ(0x148fe911u, ImmutableString("textureLod(0Z2B0B").mangledNameHash());
    ASSERT_EQ(0x0e600d82u, ImmutableString("texture(0c2B").mangledNameHash());
    ASSERT_EQ(0x0e67665bu, ImmutableString("texture(0d3B").mangledNameHash());
    ASSERT_EQ(0x0e6044aeu, ImmutableString("texture(0e3B").mangledNameHash());
    ASSERT_EQ(0x16875a59u, ImmutableString("textureProj(0c3B").mangledNameHash());
    ASSERT_EQ(0x148a95e7u, ImmutableString("textureLod(0c2B0B").mangledNameHash());
    ASSERT_EQ(0x168434eeu, ImmutableString("textureSize(0H0C").mangledNameHash());
    ASSERT_EQ(0x16869d00u, ImmutableString("textureSize(0Q0C").mangledNameHash());
    ASSERT_EQ(0x16846c6cu, ImmutableString("textureSize(0W0C").mangledNameHash());
    ASSERT_EQ(0x16803d05u, ImmutableString("textureSize(0I0C").mangledNameHash());
    ASSERT_EQ(0x16863c73u, ImmutableString("textureSize(0R0C").mangledNameHash());
    ASSERT_EQ(0x1686a82au, ImmutableString("textureSize(0X0C").mangledNameHash());
    ASSERT_EQ(0x1681f153u, ImmutableString("textureSize(0J0C").mangledNameHash());
    ASSERT_EQ(0x168245a4u, ImmutableString("textureSize(0S0C").mangledNameHash());
    ASSERT_EQ(0x1682d660u, ImmutableString("textureSize(0Y0C").mangledNameHash());
    ASSERT_EQ(0x16861104u, ImmutableString("textureSize(0K0C").mangledNameHash());
    ASSERT_EQ(0x168093aau, ImmutableString("textureSize(0T0C").mangledNameHash());
    ASSERT_EQ(0x16849618u, ImmutableString("textureSize(0Z0C").mangledNameHash());
    ASSERT_EQ(0x1686aa87u, ImmutableString("textureSize(0c0C").mangledNameHash());
    ASSERT_EQ(0x1684f1b3u, ImmutableString("textureSize(0d0C").mangledNameHash());
    ASSERT_EQ(0x168115fbu, ImmutableString("textureSize(0e0C").mangledNameHash());
    ASSERT_EQ(0x1caa108bu, ImmutableString("textureProjLod(0H2B0B").mangledNameHash());
    ASSERT_EQ(0x1caa957cu, ImmutableString("textureProjLod(0Q2B0B").mangledNameHash());
    ASSERT_EQ(0x1ca9ff27u, ImmutableString("textureProjLod(0W2B0B").mangledNameHash());
    ASSERT_EQ(0x1ca8c89au, ImmutableString("textureProjLod(0H3B0B").mangledNameHash());
    ASSERT_EQ(0x1ca85d55u, ImmutableString("textureProjLod(0Q3B0B").mangledNameHash());
    ASSERT_EQ(0x1cab3a35u, ImmutableString("textureProjLod(0W3B0B").mangledNameHash());
    ASSERT_EQ(0x1caf96afu, ImmutableString("textureProjLod(0I3B0B").mangledNameHash());
    ASSERT_EQ(0x1cae6ef8u, ImmutableString("textureProjLod(0R3B0B").mangledNameHash());
    ASSERT_EQ(0x1cadb5feu, ImmutableString("textureProjLod(0X3B0B").mangledNameHash());
    ASSERT_EQ(0x1ca81af6u, ImmutableString("textureProjLod(0c3B0B").mangledNameHash());
    ASSERT_EQ(0x148fd5b6u, ImmutableString("texelFetch(0H1C0C").mangledNameHash());
    ASSERT_EQ(0x148e5d86u, ImmutableString("texelFetch(0Q1C0C").mangledNameHash());
    ASSERT_EQ(0x148e6d96u, ImmutableString("texelFetch(0W1C0C").mangledNameHash());
    ASSERT_EQ(0x148bab65u, ImmutableString("texelFetch(0I2C0C").mangledNameHash());
    ASSERT_EQ(0x14885983u, ImmutableString("texelFetch(0R2C0C").mangledNameHash());
    ASSERT_EQ(0x148e100eu, ImmutableString("texelFetch(0X2C0C").mangledNameHash());
    ASSERT_EQ(0x148d0a7bu, ImmutableString("texelFetch(0K2C0C").mangledNameHash());
    ASSERT_EQ(0x148fb13cu, ImmutableString("texelFetch(0T2C0C").mangledNameHash());
    ASSERT_EQ(0x14885e67u, ImmutableString("texelFetch(0Z2C0C").mangledNameHash());
    ASSERT_EQ(0x16a19c8du, ImmutableString("textureGrad(0H1B1B1B").mangledNameHash());
    ASSERT_EQ(0x16a2ff3du, ImmutableString("textureGrad(0Q1B1B1B").mangledNameHash());
    ASSERT_EQ(0x16a4a66cu, ImmutableString("textureGrad(0W1B1B1B").mangledNameHash());
    ASSERT_EQ(0x16a00e04u, ImmutableString("textureGrad(0I2B2B2B").mangledNameHash());
    ASSERT_EQ(0x16a34692u, ImmutableString("textureGrad(0R2B2B2B").mangledNameHash());
    ASSERT_EQ(0x16a04ad9u, ImmutableString("textureGrad(0X2B2B2B").mangledNameHash());
    ASSERT_EQ(0x16a1ec87u, ImmutableString("textureGrad(0J2B2B2B").mangledNameHash());
    ASSERT_EQ(0x16a68a81u, ImmutableString("textureGrad(0S2B2B2B").mangledNameHash());
    ASSERT_EQ(0x16a3b8f6u, ImmutableString("textureGrad(0Y2B2B2B").mangledNameHash());
    ASSERT_EQ(0x16a3a842u, ImmutableString("textureGrad(0c2B1B1B").mangledNameHash());
    ASSERT_EQ(0x16a4e27cu, ImmutableString("textureGrad(0d3B2B2B").mangledNameHash());
    ASSERT_EQ(0x16a71104u, ImmutableString("textureGrad(0K2B1B1B").mangledNameHash());
    ASSERT_EQ(0x16a66883u, ImmutableString("textureGrad(0T2B1B1B").mangledNameHash());
    ASSERT_EQ(0x16a6a742u, ImmutableString("textureGrad(0Z2B1B1B").mangledNameHash());
    ASSERT_EQ(0x16a1478fu, ImmutableString("textureGrad(0e3B1B1B").mangledNameHash());
    ASSERT_EQ(0x1ec5ab9du, ImmutableString("textureProjGrad(0H2B1B1B").mangledNameHash());
    ASSERT_EQ(0x1ec1a98bu, ImmutableString("textureProjGrad(0Q2B1B1B").mangledNameHash());
    ASSERT_EQ(0x1ec25826u, ImmutableString("textureProjGrad(0W2B1B1B").mangledNameHash());
    ASSERT_EQ(0x1ec323fdu, ImmutableString("textureProjGrad(0H3B1B1B").mangledNameHash());
    ASSERT_EQ(0x1ec5fc9fu, ImmutableString("textureProjGrad(0Q3B1B1B").mangledNameHash());
    ASSERT_EQ(0x1ec67b05u, ImmutableString("textureProjGrad(0W3B1B1B").mangledNameHash());
    ASSERT_EQ(0x1ec3ee61u, ImmutableString("textureProjGrad(0I3B2B2B").mangledNameHash());
    ASSERT_EQ(0x1ec578cfu, ImmutableString("textureProjGrad(0R3B2B2B").mangledNameHash());
    ASSERT_EQ(0x1ec2304bu, ImmutableString("textureProjGrad(0X3B2B2B").mangledNameHash());
    ASSERT_EQ(0x1ec719d1u, ImmutableString("textureProjGrad(0c3B1B1B").mangledNameHash());
    ASSERT_EQ(0x1673f496u, ImmutableString("textureSize(0O").mangledNameHash());
    ASSERT_EQ(0x167394d8u, ImmutableString("textureSize(0U").mangledNameHash());
    ASSERT_EQ(0x16752ab6u, ImmutableString("textureSize(0a").mangledNameHash());
    ASSERT_EQ(0x1673b4b7u, ImmutableString("textureSize(0P").mangledNameHash());
    ASSERT_EQ(0x1673a791u, ImmutableString("textureSize(0V").mangledNameHash());
    ASSERT_EQ(0x1675566fu, ImmutableString("textureSize(0b").mangledNameHash());
    ASSERT_EQ(0x1aa11785u, ImmutableString("textureOffset(0H1B1C").mangledNameHash());
    ASSERT_EQ(0x1aa01270u, ImmutableString("textureOffset(0Q1B1C").mangledNameHash());
    ASSERT_EQ(0x1aa541b7u, ImmutableString("textureOffset(0W1B1C").mangledNameHash());
    ASSERT_EQ(0x1aa64995u, ImmutableString("textureOffset(0I2B2C").mangledNameHash());
    ASSERT_EQ(0x1aa7a781u, ImmutableString("textureOffset(0R2B2C").mangledNameHash());
    ASSERT_EQ(0x1aa31637u, ImmutableString("textureOffset(0X2B2C").mangledNameHash());
    ASSERT_EQ(0x1aa05156u, ImmutableString("textureOffset(0c2B1C").mangledNameHash());
    ASSERT_EQ(0x1aa41f4au, ImmutableString("textureOffset(0K2B1C").mangledNameHash());
    ASSERT_EQ(0x1aa26095u, ImmutableString("textureOffset(0T2B1C").mangledNameHash());
    ASSERT_EQ(0x1aa385c2u, ImmutableString("textureOffset(0Z2B1C").mangledNameHash());
    ASSERT_EQ(0x22c0a359u, ImmutableString("textureProjOffset(0H2B1C").mangledNameHash());
    ASSERT_EQ(0x22c29005u, ImmutableString("textureProjOffset(0Q2B1C").mangledNameHash());
    ASSERT_EQ(0x22c03489u, ImmutableString("textureProjOffset(0W2B1C").mangledNameHash());
    ASSERT_EQ(0x22c2da46u, ImmutableString("textureProjOffset(0H3B1C").mangledNameHash());
    ASSERT_EQ(0x22c246a2u, ImmutableString("textureProjOffset(0Q3B1C").mangledNameHash());
    ASSERT_EQ(0x22c3e359u, ImmutableString("textureProjOffset(0W3B1C").mangledNameHash());
    ASSERT_EQ(0x22c458dcu, ImmutableString("textureProjOffset(0I3B2C").mangledNameHash());
    ASSERT_EQ(0x22c43880u, ImmutableString("textureProjOffset(0R3B2C").mangledNameHash());
    ASSERT_EQ(0x22c47909u, ImmutableString("textureProjOffset(0X3B2C").mangledNameHash());
    ASSERT_EQ(0x22c19992u, ImmutableString("textureProjOffset(0c3B1C").mangledNameHash());
    ASSERT_EQ(0x20cc9477u, ImmutableString("textureLodOffset(0H1B0B1C").mangledNameHash());
    ASSERT_EQ(0x20ccf3edu, ImmutableString("textureLodOffset(0Q1B0B1C").mangledNameHash());
    ASSERT_EQ(0x20cdc61au, ImmutableString("textureLodOffset(0W1B0B1C").mangledNameHash());
    ASSERT_EQ(0x20cde748u, ImmutableString("textureLodOffset(0I2B0B2C").mangledNameHash());
    ASSERT_EQ(0x20ceb3dau, ImmutableString("textureLodOffset(0R2B0B2C").mangledNameHash());
    ASSERT_EQ(0x20cde370u, ImmutableString("textureLodOffset(0X2B0B2C").mangledNameHash());
    ASSERT_EQ(0x20c9733bu, ImmutableString("textureLodOffset(0c2B0B1C").mangledNameHash());
    ASSERT_EQ(0x20cd0de3u, ImmutableString("textureLodOffset(0K2B0B1C").mangledNameHash());
    ASSERT_EQ(0x20cd8d8du, ImmutableString("textureLodOffset(0T2B0B1C").mangledNameHash());
    ASSERT_EQ(0x20ca4914u, ImmutableString("textureLodOffset(0Z2B0B1C").mangledNameHash());
    ASSERT_EQ(0x28eab462u, ImmutableString("textureProjLodOffset(0H2B0B1C").mangledNameHash());
    ASSERT_EQ(0x28ef956cu, ImmutableString("textureProjLodOffset(0Q2B0B1C").mangledNameHash());
    ASSERT_EQ(0x28e9a246u, ImmutableString("textureProjLodOffset(0W2B0B1C").mangledNameHash());
    ASSERT_EQ(0x28ebf99eu, ImmutableString("textureProjLodOffset(0H3B0B1C").mangledNameHash());
    ASSERT_EQ(0x28ec29a7u, ImmutableString("textureProjLodOffset(0Q3B0B1C").mangledNameHash());
    ASSERT_EQ(0x28e8b7d0u, ImmutableString("textureProjLodOffset(0W3B0B1C").mangledNameHash());
    ASSERT_EQ(0x28eb8605u, ImmutableString("textureProjLodOffset(0I3B0B2C").mangledNameHash());
    ASSERT_EQ(0x28e91d51u, ImmutableString("textureProjLodOffset(0R3B0B2C").mangledNameHash());
    ASSERT_EQ(0x28eecd92u, ImmutableString("textureProjLodOffset(0X3B0B2C").mangledNameHash());
    ASSERT_EQ(0x28efb13bu, ImmutableString("textureProjLodOffset(0c3B0B1C").mangledNameHash());
    ASSERT_EQ(0x20cb3102u, ImmutableString("texelFetchOffset(0H1C0C1C").mangledNameHash());
    ASSERT_EQ(0x20cc1a52u, ImmutableString("texelFetchOffset(0Q1C0C1C").mangledNameHash());
    ASSERT_EQ(0x20cbf8d9u, ImmutableString("texelFetchOffset(0W1C0C1C").mangledNameHash());
    ASSERT_EQ(0x20c8fa96u, ImmutableString("texelFetchOffset(0I2C0C2C").mangledNameHash());
    ASSERT_EQ(0x20cbfefau, ImmutableString("texelFetchOffset(0R2C0C2C").mangledNameHash());
    ASSERT_EQ(0x20c9a178u, ImmutableString("texelFetchOffset(0X2C0C2C").mangledNameHash());
    ASSERT_EQ(0x20cac068u, ImmutableString("texelFetchOffset(0K2C0C1C").mangledNameHash());
    ASSERT_EQ(0x20cfe609u, ImmutableString("texelFetchOffset(0T2C0C1C").mangledNameHash());
    ASSERT_EQ(0x20cb952du, ImmutableString("texelFetchOffset(0Z2C0C1C").mangledNameHash());
    ASSERT_EQ(0x22e71012u, ImmutableString("textureGradOffset(0H1B1B1B1C").mangledNameHash());
    ASSERT_EQ(0x22e5c876u, ImmutableString("textureGradOffset(0Q1B1B1B1C").mangledNameHash());
    ASSERT_EQ(0x22e0fe8cu, ImmutableString("textureGradOffset(0W1B1B1B1C").mangledNameHash());
    ASSERT_EQ(0x22e3e9eau, ImmutableString("textureGradOffset(0I2B2B2B2C").mangledNameHash());
    ASSERT_EQ(0x22e5bb38u, ImmutableString("textureGradOffset(0R2B2B2B2C").mangledNameHash());
    ASSERT_EQ(0x22e61729u, ImmutableString("textureGradOffset(0X2B2B2B2C").mangledNameHash());
    ASSERT_EQ(0x22e7429eu, ImmutableString("textureGradOffset(0c2B1B1B1C").mangledNameHash());
    ASSERT_EQ(0x22e165b8u, ImmutableString("textureGradOffset(0K2B1B1B1C").mangledNameHash());
    ASSERT_EQ(0x22e28d80u, ImmutableString("textureGradOffset(0T2B1B1B1C").mangledNameHash());
    ASSERT_EQ(0x22e68293u, ImmutableString("textureGradOffset(0Z2B1B1B1C").mangledNameHash());
    ASSERT_EQ(0x22e3ab1cu, ImmutableString("textureGradOffset(0e3B1B1B1C").mangledNameHash());
    ASSERT_EQ(0x2b077535u, ImmutableString("textureProjGradOffset(0H2B1B1B1C").mangledNameHash());
    ASSERT_EQ(0x2b03ccf9u, ImmutableString("textureProjGradOffset(0Q2B1B1B1C").mangledNameHash());
    ASSERT_EQ(0x2b03db51u, ImmutableString("textureProjGradOffset(0W2B1B1B1C").mangledNameHash());
    ASSERT_EQ(0x2b022418u, ImmutableString("textureProjGradOffset(0H3B1B1B1C").mangledNameHash());
    ASSERT_EQ(0x2b06f874u, ImmutableString("textureProjGradOffset(0Q3B1B1B1C").mangledNameHash());
    ASSERT_EQ(0x2b07f768u, ImmutableString("textureProjGradOffset(0W3B1B1B1C").mangledNameHash());
    ASSERT_EQ(0x2b02af8fu, ImmutableString("textureProjGradOffset(0I3B2B2B2C").mangledNameHash());
    ASSERT_EQ(0x2b047dfau, ImmutableString("textureProjGradOffset(0R3B2B2B2C").mangledNameHash());
    ASSERT_EQ(0x2b0252ccu, ImmutableString("textureProjGradOffset(0X3B2B2B2C").mangledNameHash());
    ASSERT_EQ(0x2b00aacdu, ImmutableString("textureProjGradOffset(0c3B1B1B1C").mangledNameHash());
    ASSERT_EQ(0x1ab57bbcu, ImmutableString("textureOffset(0H1B1C0B").mangledNameHash());
    ASSERT_EQ(0x1ab55c9du, ImmutableString("textureOffset(0Q1B1C0B").mangledNameHash());
    ASSERT_EQ(0x1ab5d795u, ImmutableString("textureOffset(0W1B1C0B").mangledNameHash());
    ASSERT_EQ(0x1ab59b6cu, ImmutableString("textureOffset(0I2B2C0B").mangledNameHash());
    ASSERT_EQ(0x1ab63f72u, ImmutableString("textureOffset(0R2B2C0B").mangledNameHash());
    ASSERT_EQ(0x1ab0a952u, ImmutableString("textureOffset(0X2B2C0B").mangledNameHash());
    ASSERT_EQ(0x1ab7e533u, ImmutableString("textureOffset(0c2B1C0B").mangledNameHash());
    ASSERT_EQ(0x1ab63ddau, ImmutableString("textureOffset(0K2B1C0B").mangledNameHash());
    ASSERT_EQ(0x1ab5753fu, ImmutableString("textureOffset(0T2B1C0B").mangledNameHash());
    ASSERT_EQ(0x1ab29724u, ImmutableString("textureOffset(0Z2B1C0B").mangledNameHash());
    ASSERT_EQ(0x22d6ee53u, ImmutableString("textureProjOffset(0H2B1C0B").mangledNameHash());
    ASSERT_EQ(0x22d60e91u, ImmutableString("textureProjOffset(0Q2B1C0B").mangledNameHash());
    ASSERT_EQ(0x22d1425bu, ImmutableString("textureProjOffset(0W2B1C0B").mangledNameHash());
    ASSERT_EQ(0x22d62e81u, ImmutableString("textureProjOffset(0H3B1C0B").mangledNameHash());
    ASSERT_EQ(0x22d11d67u, ImmutableString("textureProjOffset(0Q3B1C0B").mangledNameHash());
    ASSERT_EQ(0x22d17100u, ImmutableString("textureProjOffset(0W3B1C0B").mangledNameHash());
    ASSERT_EQ(0x22d6b2e8u, ImmutableString("textureProjOffset(0I3B2C0B").mangledNameHash());
    ASSERT_EQ(0x22d6074cu, ImmutableString("textureProjOffset(0R3B2C0B").mangledNameHash());
    ASSERT_EQ(0x22d60cd3u, ImmutableString("textureProjOffset(0X3B2C0B").mangledNameHash());
    ASSERT_EQ(0x22d1ca54u, ImmutableString("textureProjOffset(0c3B1C0B").mangledNameHash());
    ASSERT_EQ(0x0e661665u, ImmutableString("texture(0L1B").mangledNameHash());
    ASSERT_EQ(0x16838d15u, ImmutableString("textureProj(0L2B").mangledNameHash());
    ASSERT_EQ(0x16865716u, ImmutableString("textureProj(0L3B").mangledNameHash());
    ASSERT_EQ(0x16845c90u, ImmutableString("textureSize(0L0C").mangledNameHash());
    ASSERT_EQ(0x148eff58u, ImmutableString("texelFetch(0L1C0C").mangledNameHash());
    ASSERT_EQ(0x0e63b9efu, ImmutableString("texture(0M1B").mangledNameHash());
    ASSERT_EQ(0x1682d0c8u, ImmutableString("textureProj(0M2B").mangledNameHash());
    ASSERT_EQ(0x1683ecb1u, ImmutableString("textureProj(0M3B").mangledNameHash());
    ASSERT_EQ(0x127589a7u, ImmutableString("rgb_2_yuv(2B0G").mangledNameHash());
    ASSERT_EQ(0x1273f9dbu, ImmutableString("yuv_2_rgb(2B0G").mangledNameHash());
    ASSERT_EQ(0x168046b0u, ImmutableString("textureSize(0M0C").mangledNameHash());
    ASSERT_EQ(0x148a14a7u, ImmutableString("texelFetch(0M1C0C").mangledNameHash());
    ASSERT_EQ(0x0e76e7c1u, ImmutableString("texture(0H1B0B").mangledNameHash());
    ASSERT_EQ(0x0e7386b0u, ImmutableString("texture(0Q1B0B").mangledNameHash());
    ASSERT_EQ(0x0e70d11du, ImmutableString("texture(0W1B0B").mangledNameHash());
    ASSERT_EQ(0x0e77d1c8u, ImmutableString("texture(0I2B0B").mangledNameHash());
    ASSERT_EQ(0x0e7720c0u, ImmutableString("texture(0R2B0B").mangledNameHash());
    ASSERT_EQ(0x0e70eff9u, ImmutableString("texture(0X2B0B").mangledNameHash());
    ASSERT_EQ(0x0e75d15fu, ImmutableString("texture(0J2B0B").mangledNameHash());
    ASSERT_EQ(0x0e75399eu, ImmutableString("texture(0S2B0B").mangledNameHash());
    ASSERT_EQ(0x0e755c73u, ImmutableString("texture(0Y2B0B").mangledNameHash());
    ASSERT_EQ(0x0e742a66u, ImmutableString("texture(0K2B0B").mangledNameHash());
    ASSERT_EQ(0x0e7013d9u, ImmutableString("texture(0T2B0B").mangledNameHash());
    ASSERT_EQ(0x0e734ff8u, ImmutableString("texture(0Z2B0B").mangledNameHash());
    ASSERT_EQ(0x1696f029u, ImmutableString("textureProj(0H2B0B").mangledNameHash());
    ASSERT_EQ(0x16939955u, ImmutableString("textureProj(0Q2B0B").mangledNameHash());
    ASSERT_EQ(0x169465e2u, ImmutableString("textureProj(0W2B0B").mangledNameHash());
    ASSERT_EQ(0x16965fd9u, ImmutableString("textureProj(0H3B0B").mangledNameHash());
    ASSERT_EQ(0x16925badu, ImmutableString("textureProj(0Q3B0B").mangledNameHash());
    ASSERT_EQ(0x1690a3cfu, ImmutableString("textureProj(0W3B0B").mangledNameHash());
    ASSERT_EQ(0x169350d8u, ImmutableString("textureProj(0I3B0B").mangledNameHash());
    ASSERT_EQ(0x1694622au, ImmutableString("textureProj(0R3B0B").mangledNameHash());
    ASSERT_EQ(0x1695f573u, ImmutableString("textureProj(0X3B0B").mangledNameHash());
    ASSERT_EQ(0x0e716d8fu, ImmutableString("texture(0c2B0B").mangledNameHash());
    ASSERT_EQ(0x0e740087u, ImmutableString("texture(0d3B0B").mangledNameHash());
    ASSERT_EQ(0x1692d089u, ImmutableString("textureProj(0c3B0B").mangledNameHash());
    ASSERT_EQ(0x0e723219u, ImmutableString("texture(0L1B0B").mangledNameHash());
    ASSERT_EQ(0x1697e9b9u, ImmutableString("textureProj(0L2B0B").mangledNameHash());
    ASSERT_EQ(0x16900558u, ImmutableString("textureProj(0L3B0B").mangledNameHash());
    ASSERT_EQ(0x0e71856cu, ImmutableString("texture(0M1B0B").mangledNameHash());
    ASSERT_EQ(0x1691c2edu, ImmutableString("textureProj(0M2B0B").mangledNameHash());
    ASSERT_EQ(0x1690ae9fu, ImmutableString("textureProj(0M3B0B").mangledNameHash());
    ASSERT_EQ(0x14896e41u, ImmutableString("texelFetch(0O1C0C").mangledNameHash());
    ASSERT_EQ(0x148ed16fu, ImmutableString("texelFetch(0U1C0C").mangledNameHash());
    ASSERT_EQ(0x148ddb10u, ImmutableString("texelFetch(0a1C0C").mangledNameHash());
    ASSERT_EQ(0x148e872bu, ImmutableString("texelFetch(0P2C0C").mangledNameHash());
    ASSERT_EQ(0x14880e11u, ImmutableString("texelFetch(0V2C0C").mangledNameHash());
    ASSERT_EQ(0x1489244fu, ImmutableString("texelFetch(0b2C0C").mangledNameHash());
    ASSERT_EQ(0x1a92a1ceu, ImmutableString("textureGather(0H1B").mangledNameHash());
    ASSERT_EQ(0x1a92c882u, ImmutableString("textureGather(0Q1B").mangledNameHash());
    ASSERT_EQ(0x1a92a168u, ImmutableString("textureGather(0W1B").mangledNameHash());
    ASSERT_EQ(0x1aa4c59du, ImmutableString("textureGather(0H1B0C").mangledNameHash());
    ASSERT_EQ(0x1aa133bcu, ImmutableString("textureGather(0Q1B0C").mangledNameHash());
    ASSERT_EQ(0x1aa220b0u, ImmutableString("textureGather(0W1B0C").mangledNameHash());
    ASSERT_EQ(0x1a94543du, ImmutableString("textureGather(0K2B").mangledNameHash());
    ASSERT_EQ(0x1a95f707u, ImmutableString("textureGather(0T2B").mangledNameHash());
    ASSERT_EQ(0x1a94eb48u, ImmutableString("textureGather(0Z2B").mangledNameHash());
    ASSERT_EQ(0x1aa78b86u, ImmutableString("textureGather(0K2B0C").mangledNameHash());
    ASSERT_EQ(0x1aa2aafeu, ImmutableString("textureGather(0T2B0C").mangledNameHash());
    ASSERT_EQ(0x1aa17115u, ImmutableString("textureGather(0Z2B0C").mangledNameHash());
    ASSERT_EQ(0x1a979ae3u, ImmutableString("textureGather(0J2B").mangledNameHash());
    ASSERT_EQ(0x1a9418e8u, ImmutableString("textureGather(0S2B").mangledNameHash());
    ASSERT_EQ(0x1a910beau, ImmutableString("textureGather(0Y2B").mangledNameHash());
    ASSERT_EQ(0x1aa4986bu, ImmutableString("textureGather(0J2B0C").mangledNameHash());
    ASSERT_EQ(0x1aa3ef46u, ImmutableString("textureGather(0S2B0C").mangledNameHash());
    ASSERT_EQ(0x1aa7fa48u, ImmutableString("textureGather(0Y2B0C").mangledNameHash());
    ASSERT_EQ(0x1a926b0du, ImmutableString("textureGather(0c1B").mangledNameHash());
    ASSERT_EQ(0x1aa182eeu, ImmutableString("textureGather(0c1B0B").mangledNameHash());
    ASSERT_EQ(0x1a94d27du, ImmutableString("textureGather(0e2B").mangledNameHash());
    ASSERT_EQ(0x1aa039c7u, ImmutableString("textureGather(0e2B0B").mangledNameHash());
    ASSERT_EQ(0x1a91963cu, ImmutableString("textureGather(0d2B").mangledNameHash());
    ASSERT_EQ(0x1aa353f8u, ImmutableString("textureGather(0d2B0B").mangledNameHash());
    ASSERT_EQ(0x26d71952u, ImmutableString("textureGatherOffset(0H1B1C").mangledNameHash());
    ASSERT_EQ(0x26d0b451u, ImmutableString("textureGatherOffset(0Q1B1C").mangledNameHash());
    ASSERT_EQ(0x26d00e91u, ImmutableString("textureGatherOffset(0W1B1C").mangledNameHash());
    ASSERT_EQ(0x26e476d0u, ImmutableString("textureGatherOffset(0H1B1C0C").mangledNameHash());
    ASSERT_EQ(0x26e567feu, ImmutableString("textureGatherOffset(0Q1B1C0C").mangledNameHash());
    ASSERT_EQ(0x26e737a0u, ImmutableString("textureGatherOffset(0W1B1C0C").mangledNameHash());
    ASSERT_EQ(0x26d1f440u, ImmutableString("textureGatherOffset(0K2B1C").mangledNameHash());
    ASSERT_EQ(0x26d2d875u, ImmutableString("textureGatherOffset(0T2B1C").mangledNameHash());
    ASSERT_EQ(0x26d0db41u, ImmutableString("textureGatherOffset(0Z2B1C").mangledNameHash());
    ASSERT_EQ(0x26e459f8u, ImmutableString("textureGatherOffset(0K2B1C0C").mangledNameHash());
    ASSERT_EQ(0x26e1982cu, ImmutableString("textureGatherOffset(0T2B1C0C").mangledNameHash());
    ASSERT_EQ(0x26e47c82u, ImmutableString("textureGatherOffset(0Z2B1C0C").mangledNameHash());
    ASSERT_EQ(0x26e580eau, ImmutableString("textureGatherOffset(0c1B0B1C").mangledNameHash());
    ASSERT_EQ(0x26e53ca1u, ImmutableString("textureGatherOffset(0e2B0B1C").mangledNameHash());
    ASSERT_EQ(0x1a805162u, ImmutableString("atomicCounter(0F").mangledNameHash());
    ASSERT_EQ(0x2ccf8f34u, ImmutableString("atomicCounterIncrement(0F").mangledNameHash());
    ASSERT_EQ(0x2ccfbbbeu, ImmutableString("atomicCounterDecrement(0F").mangledNameHash());
    ASSERT_EQ(0x127258f0u, ImmutableString("atomicAdd(0D0D").mangledNameHash());
    ASSERT_EQ(0x1270b3f8u, ImmutableString("atomicAdd(0C0C").mangledNameHash());
    ASSERT_EQ(0x1273e62au, ImmutableString("atomicMin(0D0D").mangledNameHash());
    ASSERT_EQ(0x12717c89u, ImmutableString("atomicMin(0C0C").mangledNameHash());
    ASSERT_EQ(0x1273d1adu, ImmutableString("atomicMax(0D0D").mangledNameHash());
    ASSERT_EQ(0x1277882au, ImmutableString("atomicMax(0C0C").mangledNameHash());
    ASSERT_EQ(0x127648cau, ImmutableString("atomicAnd(0D0D").mangledNameHash());
    ASSERT_EQ(0x127478d9u, ImmutableString("atomicAnd(0C0C").mangledNameHash());
    ASSERT_EQ(0x106a2daeu, ImmutableString("atomicOr(0D0D").mangledNameHash());
    ASSERT_EQ(0x106bd5b6u, ImmutableString("atomicOr(0C0C").mangledNameHash());
    ASSERT_EQ(0x12771119u, ImmutableString("atomicXor(0D0D").mangledNameHash());
    ASSERT_EQ(0x1270b766u, ImmutableString("atomicXor(0C0C").mangledNameHash());
    ASSERT_EQ(0x1c9986beu, ImmutableString("atomicExchange(0D0D").mangledNameHash());
    ASSERT_EQ(0x1c9b5eecu, ImmutableString("atomicExchange(0C0C").mangledNameHash());
    ASSERT_EQ(0x1caa900cu, ImmutableString("atomicCompSwap(0D0D0D").mangledNameHash());
    ASSERT_EQ(0x1ca86085u, ImmutableString("atomicCompSwap(0C0C0C").mangledNameHash());
    ASSERT_EQ(0x1265cc8du, ImmutableString("imageSize(0f").mangledNameHash());
    ASSERT_EQ(0x1265b53eu, ImmutableString("imageSize(0g").mangledNameHash());
    ASSERT_EQ(0x1265e603u, ImmutableString("imageSize(0h").mangledNameHash());
    ASSERT_EQ(0x1265fcacu, ImmutableString("imageSize(0i").mangledNameHash());
    ASSERT_EQ(0x1265f559u, ImmutableString("imageSize(0j").mangledNameHash());
    ASSERT_EQ(0x1265cbcau, ImmutableString("imageSize(0k").mangledNameHash());
    ASSERT_EQ(0x12660ccfu, ImmutableString("imageSize(0l").mangledNameHash());
    ASSERT_EQ(0x12661578u, ImmutableString("imageSize(0m").mangledNameHash());
    ASSERT_EQ(0x12661be5u, ImmutableString("imageSize(0n").mangledNameHash());
    ASSERT_EQ(0x1265e196u, ImmutableString("imageSize(0o").mangledNameHash());
    ASSERT_EQ(0x126520f8u, ImmutableString("imageSize(0p").mangledNameHash());
    ASSERT_EQ(0x12653967u, ImmutableString("imageSize(0q").mangledNameHash());
    ASSERT_EQ(0x12739c87u, ImmutableString("imageLoad(0f1C").mangledNameHash());
    ASSERT_EQ(0x12755603u, ImmutableString("imageLoad(0g1C").mangledNameHash());
    ASSERT_EQ(0x12700109u, ImmutableString("imageLoad(0h1C").mangledNameHash());
    ASSERT_EQ(0x127539b2u, ImmutableString("imageLoad(0i2C").mangledNameHash());
    ASSERT_EQ(0x12715f47u, ImmutableString("imageLoad(0j2C").mangledNameHash());
    ASSERT_EQ(0x127474cau, ImmutableString("imageLoad(0k2C").mangledNameHash());
    ASSERT_EQ(0x1276656cu, ImmutableString("imageLoad(0l2C").mangledNameHash());
    ASSERT_EQ(0x12731984u, ImmutableString("imageLoad(0m2C").mangledNameHash());
    ASSERT_EQ(0x12712664u, ImmutableString("imageLoad(0n2C").mangledNameHash());
    ASSERT_EQ(0x12744c0du, ImmutableString("imageLoad(0o2C").mangledNameHash());
    ASSERT_EQ(0x1274d54bu, ImmutableString("imageLoad(0p2C").mangledNameHash());
    ASSERT_EQ(0x12737ed6u, ImmutableString("imageLoad(0q2C").mangledNameHash());
    ASSERT_EQ(0x148d86dcu, ImmutableString("imageStore(0f1C3B").mangledNameHash());
    ASSERT_EQ(0x148bb1bdu, ImmutableString("imageStore(0g1C3C").mangledNameHash());
    ASSERT_EQ(0x148ffee8u, ImmutableString("imageStore(0h1C3D").mangledNameHash());
    ASSERT_EQ(0x148fd5f1u, ImmutableString("imageStore(0i2C3B").mangledNameHash());
    ASSERT_EQ(0x148e668au, ImmutableString("imageStore(0j2C3C").mangledNameHash());
    ASSERT_EQ(0x1488078cu, ImmutableString("imageStore(0k2C3D").mangledNameHash());
    ASSERT_EQ(0x148dcfd5u, ImmutableString("imageStore(0l2C3B").mangledNameHash());
    ASSERT_EQ(0x148e37b8u, ImmutableString("imageStore(0m2C3C").mangledNameHash());
    ASSERT_EQ(0x148ed534u, ImmutableString("imageStore(0n2C3D").mangledNameHash());
    ASSERT_EQ(0x148f7a82u, ImmutableString("imageStore(0o2C3B").mangledNameHash());
    ASSERT_EQ(0x148a0cecu, ImmutableString("imageStore(0p2C3C").mangledNameHash());
    ASSERT_EQ(0x148c1e41u, ImmutableString("imageStore(0q2C3D").mangledNameHash());
    ASSERT_EQ(0x1a7538dfu, ImmutableString("memoryBarrier(").mangledNameHash());
    ASSERT_EQ(0x34ded18du, ImmutableString("memoryBarrierAtomicCounter(").mangledNameHash());
    ASSERT_EQ(0x26a7e24bu, ImmutableString("memoryBarrierBuffer(").mangledNameHash());
    ASSERT_EQ(0x249e7359u, ImmutableString("memoryBarrierImage(").mangledNameHash());
    ASSERT_EQ(0x0e41a660u, ImmutableString("barrier(").mangledNameHash());
    ASSERT_EQ(0x26a4d8e6u, ImmutableString("memoryBarrierShared(").mangledNameHash());
    ASSERT_EQ(0x249ee97cu, ImmutableString("groupMemoryBarrier(").mangledNameHash());
    ASSERT_EQ(0x145d55c9u, ImmutableString("EmitVertex(").mangledNameHash());
    ASSERT_EQ(0x186fcde2u, ImmutableString("EndPrimitive(").mangledNameHash());
    ASSERT_EQ(0x7e2d0692u, ImmutableString("frexp").mangledNameHash());
    ASSERT_EQ(0x7e2c727fu, ImmutableString("ldexp").mangledNameHash());
    ASSERT_EQ(0x7e657e29u, ImmutableString("packUnorm4x8").mangledNameHash());
    ASSERT_EQ(0x7e6273e5u, ImmutableString("packSnorm4x8").mangledNameHash());
    ASSERT_EQ(0x7e71963eu, ImmutableString("unpackUnorm4x8").mangledNameHash());
    ASSERT_EQ(0x7e73f1d1u, ImmutableString("unpackSnorm4x8").mangledNameHash());
    ASSERT_EQ(0x7e7fa0c1u, ImmutableString("bitfieldExtract").mangledNameHash());
    ASSERT_EQ(0x7e77c121u, ImmutableString("bitfieldInsert").mangledNameHash());
    ASSERT_EQ(0x7e7f2cb2u, ImmutableString("bitfieldReverse").mangledNameHash());
    ASSERT_EQ(0x7e41283bu, ImmutableString("bitCount").mangledNameHash());
    ASSERT_EQ(0x7e399596u, ImmutableString("findLSB").mangledNameHash());
    ASSERT_EQ(0x7e3bdf3fu, ImmutableString("findMSB").mangledNameHash());
    ASSERT_EQ(0x7e4e5094u, ImmutableString("uaddCarry").mangledNameHash());
    ASSERT_EQ(0x7e55de86u, ImmutableString("usubBorrow").mangledNameHash());
    ASSERT_EQ(0x7e6746f4u, ImmutableString("umulExtended").mangledNameHash());
    ASSERT_EQ(0x7e62a9a0u, ImmutableString("imulExtended").mangledNameHash());
    ASSERT_EQ(0x7e5e217eu, ImmutableString("textureSize").mangledNameHash());
    ASSERT_EQ(0x7e5237e1u, ImmutableString("texelFetch").mangledNameHash());
    ASSERT_EQ(0x7e6d0f32u, ImmutableString("textureGather").mangledNameHash());
    ASSERT_EQ(0x7e9d8ad9u, ImmutableString("textureGatherOffset").mangledNameHash());
    ASSERT_EQ(0x7e6e00a5u, ImmutableString("atomicCounter").mangledNameHash());
    ASSERT_EQ(0x7eb323ddu, ImmutableString("atomicCounterIncrement").mangledNameHash());
    ASSERT_EQ(0x7eb6aed0u, ImmutableString("atomicCounterDecrement").mangledNameHash());
    ASSERT_EQ(0x7e4800e3u, ImmutableString("atomicAdd").mangledNameHash());
    ASSERT_EQ(0x7e49061fu, ImmutableString("atomicMin").mangledNameHash());
    ASSERT_EQ(0x7e4893a8u, ImmutableString("atomicMax").mangledNameHash());
    ASSERT_EQ(0x7e4f21aeu, ImmutableString("atomicAnd").mangledNameHash());
    ASSERT_EQ(0x7e4690b3u, ImmutableString("atomicOr").mangledNameHash());
    ASSERT_EQ(0x7e4dea77u, ImmutableString("atomicXor").mangledNameHash());
    ASSERT_EQ(0x7e75cfb1u, ImmutableString("atomicExchange").mangledNameHash());
    ASSERT_EQ(0x7e778ffcu, ImmutableString("atomicCompSwap").mangledNameHash());
    ASSERT_EQ(0x7e4b6656u, ImmutableString("imageSize").mangledNameHash());
    ASSERT_EQ(0x7e4a45b6u, ImmutableString("imageLoad").mangledNameHash());
    ASSERT_EQ(0x7e5276efu, ImmutableString("imageStore").mangledNameHash());
    ASSERT_EQ(0x7e69d0dbu, ImmutableString("memoryBarrier").mangledNameHash());
    ASSERT_EQ(0x7ed5b06bu, ImmutableString("memoryBarrierAtomicCounter").mangledNameHash());
    ASSERT_EQ(0x7e9b7f32u, ImmutableString("memoryBarrierBuffer").mangledNameHash());
    ASSERT_EQ(0x7e9269d7u, ImmutableString("memoryBarrierImage").mangledNameHash());
    ASSERT_EQ(0x7e39f4e9u, ImmutableString("barrier").mangledNameHash());
    ASSERT_EQ(0x7e9f4b19u, ImmutableString("memoryBarrierShared").mangledNameHash());
    ASSERT_EQ(0x7e93c6b9u, ImmutableString("groupMemoryBarrier").mangledNameHash());
    ASSERT_EQ(0x7e55adc2u, ImmutableString("EmitVertex").mangledNameHash());
    ASSERT_EQ(0x7e65b2cau, ImmutableString("EndPrimitive").mangledNameHash());
    ASSERT_EQ(0x7e209eadu, ImmutableString("sinh").mangledNameHash());
    ASSERT_EQ(0x7e27a4feu, ImmutableString("cosh").mangledNameHash());
    ASSERT_EQ(0x7e205c92u, ImmutableString("tanh").mangledNameHash());
    ASSERT_EQ(0x7e2dcbc6u, ImmutableString("asinh").mangledNameHash());
    ASSERT_EQ(0x7e2f67c3u, ImmutableString("acosh").mangledNameHash());
    ASSERT_EQ(0x7e28294fu, ImmutableString("atanh").mangledNameHash());
    ASSERT_EQ(0x7e19507bu, ImmutableString("abs").mangledNameHash());
    ASSERT_EQ(0x7e206e40u, ImmutableString("sign").mangledNameHash());
    ASSERT_EQ(0x7e2eab16u, ImmutableString("trunc").mangledNameHash());
    ASSERT_EQ(0x7e2a7a64u, ImmutableString("round").mangledNameHash());
    ASSERT_EQ(0x7e4d323bu, ImmutableString("roundEven").mangledNameHash());
    ASSERT_EQ(0x7e1e492du, ImmutableString("min").mangledNameHash());
    ASSERT_EQ(0x7e1ebe0eu, ImmutableString("max").mangledNameHash());
    ASSERT_EQ(0x7e2d5dcbu, ImmutableString("clamp").mangledNameHash());
    ASSERT_EQ(0x7e1ea71bu, ImmutableString("mix").mangledNameHash());
    ASSERT_EQ(0x7e274509u, ImmutableString("modf").mangledNameHash());
    ASSERT_EQ(0x7e2d8df4u, ImmutableString("isnan").mangledNameHash());
    ASSERT_EQ(0x7e2924b8u, ImmutableString("isinf").mangledNameHash());
    ASSERT_EQ(0x7e759618u, ImmutableString("floatBitsToInt").mangledNameHash());
    ASSERT_EQ(0x7e7e5132u, ImmutableString("floatBitsToUint").mangledNameHash());
    ASSERT_EQ(0x7e77fc97u, ImmutableString("intBitsToFloat").mangledNameHash());
    ASSERT_EQ(0x7e7e0e81u, ImmutableString("uintBitsToFloat").mangledNameHash());
    ASSERT_EQ(0x7e6a013du, ImmutableString("packSnorm2x16").mangledNameHash());
    ASSERT_EQ(0x7e6b72b8u, ImmutableString("packUnorm2x16").mangledNameHash());
    ASSERT_EQ(0x7e62daa3u, ImmutableString("packHalf2x16").mangledNameHash());
    ASSERT_EQ(0x7e7b6a0eu, ImmutableString("unpackSnorm2x16").mangledNameHash());
    ASSERT_EQ(0x7e792d39u, ImmutableString("unpackUnorm2x16").mangledNameHash());
    ASSERT_EQ(0x7e715db5u, ImmutableString("unpackHalf2x16").mangledNameHash());
    ASSERT_EQ(0x7e76bea7u, ImmutableString("matrixCompMult").mangledNameHash());
    ASSERT_EQ(0x7e646b9bu, ImmutableString("outerProduct").mangledNameHash());
    ASSERT_EQ(0x7e4e024cu, ImmutableString("transpose").mangledNameHash());
    ASSERT_EQ(0x7e5ba531u, ImmutableString("determinant").mangledNameHash());
    ASSERT_EQ(0x7e3d828cu, ImmutableString("inverse").mangledNameHash());
    ASSERT_EQ(0x7e403a20u, ImmutableString("lessThan").mangledNameHash());
    ASSERT_EQ(0x7e683586u, ImmutableString("lessThanEqual").mangledNameHash());
    ASSERT_EQ(0x7e582ffcu, ImmutableString("greaterThan").mangledNameHash());
    ASSERT_EQ(0x7e876cccu, ImmutableString("greaterThanEqual").mangledNameHash());
    ASSERT_EQ(0x7e297347u, ImmutableString("equal").mangledNameHash());
    ASSERT_EQ(0x7e413f93u, ImmutableString("notEqual").mangledNameHash());
    ASSERT_EQ(0x7e39ebd7u, ImmutableString("texture").mangledNameHash());
    ASSERT_EQ(0x7e5caafbu, ImmutableString("textureProj").mangledNameHash());
    ASSERT_EQ(0x7e501e0cu, ImmutableString("textureLod").mangledNameHash());
    ASSERT_EQ(0x7e75ae2fu, ImmutableString("textureProjLod").mangledNameHash());
    ASSERT_EQ(0x7e599347u, ImmutableString("textureGrad").mangledNameHash());
    ASSERT_EQ(0x7e7bc1fdu, ImmutableString("textureProjGrad").mangledNameHash());
    ASSERT_EQ(0x7e6c5187u, ImmutableString("textureOffset").mangledNameHash());
    ASSERT_EQ(0x7e8d2d2du, ImmutableString("textureProjOffset").mangledNameHash());
    ASSERT_EQ(0x7e81c71au, ImmutableString("textureLodOffset").mangledNameHash());
    ASSERT_EQ(0x7ea0be08u, ImmutableString("textureProjLodOffset").mangledNameHash());
    ASSERT_EQ(0x7e80919du, ImmutableString("texelFetchOffset").mangledNameHash());
    ASSERT_EQ(0x7e8b5832u, ImmutableString("textureGradOffset").mangledNameHash());
    ASSERT_EQ(0x7eac5717u, ImmutableString("textureProjGradOffset").mangledNameHash());
    ASSERT_EQ(0x7e4d27c2u, ImmutableString("rgb_2_yuv").mangledNameHash());
    ASSERT_EQ(0x7e4e33aeu, ImmutableString("yuv_2_rgb").mangledNameHash());
    ASSERT_EQ(0x7e265ea7u, ImmutableString("dFdx").mangledNameHash());
    ASSERT_EQ(0x7e2624d4u, ImmutableString("dFdy").mangledNameHash());
    ASSERT_EQ(0x7e324ea1u, ImmutableString("fwidth").mangledNameHash());
    ASSERT_EQ(0x7e48c50cu, ImmutableString("texture2D").mangledNameHash());
    ASSERT_EQ(0x7e6e3735u, ImmutableString("texture2DProj").mangledNameHash());
    ASSERT_EQ(0x7e5ffc48u, ImmutableString("textureCube").mangledNameHash());
    ASSERT_EQ(0x7e69f545u, ImmutableString("texture2DRect").mangledNameHash());
    ASSERT_EQ(0x7e8b66e4u, ImmutableString("texture2DRectProj").mangledNameHash());
    ASSERT_EQ(0x7e868a22u, ImmutableString("texture2DGradEXT").mangledNameHash());
    ASSERT_EQ(0x7ea20b8fu, ImmutableString("texture2DProjGradEXT").mangledNameHash());
    ASSERT_EQ(0x7e90fa5bu, ImmutableString("textureCubeGradEXT").mangledNameHash());
    ASSERT_EQ(0x7e7b843eu, ImmutableString("texture2DLodEXT").mangledNameHash());
    ASSERT_EQ(0x7e9ddba0u, ImmutableString("texture2DProjLodEXT").mangledNameHash());
    ASSERT_EQ(0x7e8b81cau, ImmutableString("textureCubeLodEXT").mangledNameHash());
    ASSERT_EQ(0x7e4db1c8u, ImmutableString("texture3D").mangledNameHash());
    ASSERT_EQ(0x7e687e40u, ImmutableString("texture3DProj").mangledNameHash());
    ASSERT_EQ(0x7e63c1d1u, ImmutableString("texture3DLod").mangledNameHash());
    ASSERT_EQ(0x7e85692eu, ImmutableString("texture3DProjLod").mangledNameHash());
    ASSERT_EQ(0x7e67c7ceu, ImmutableString("texture2DLod").mangledNameHash());
    ASSERT_EQ(0x7e819b90u, ImmutableString("texture2DProjLod").mangledNameHash());
    ASSERT_EQ(0x7e758eddu, ImmutableString("textureCubeLod").mangledNameHash());
    ASSERT_EQ(0x7e3c3cb3u, ImmutableString("radians").mangledNameHash());
    ASSERT_EQ(0x7e3d784cu, ImmutableString("degrees").mangledNameHash());
    ASSERT_EQ(0x7e1f0bccu, ImmutableString("sin").mangledNameHash());
    ASSERT_EQ(0x7e1fdef3u, ImmutableString("cos").mangledNameHash());
    ASSERT_EQ(0x7e1cf321u, ImmutableString("tan").mangledNameHash());
    ASSERT_EQ(0x7e27ebd5u, ImmutableString("asin").mangledNameHash());
    ASSERT_EQ(0x7e21ff11u, ImmutableString("acos").mangledNameHash());
    ASSERT_EQ(0x7e203979u, ImmutableString("atan").mangledNameHash());
    ASSERT_EQ(0x7e1acb4eu, ImmutableString("pow").mangledNameHash());
    ASSERT_EQ(0x7e1b921cu, ImmutableString("exp").mangledNameHash());
    ASSERT_EQ(0x7e19ebdbu, ImmutableString("log").mangledNameHash());
    ASSERT_EQ(0x7e24bcdbu, ImmutableString("exp2").mangledNameHash());
    ASSERT_EQ(0x7e209ec1u, ImmutableString("log2").mangledNameHash());
    ASSERT_EQ(0x7e23f4beu, ImmutableString("sqrt").mangledNameHash());
    ASSERT_EQ(0x7e5f4d0fu, ImmutableString("inversesqrt").mangledNameHash());
    ASSERT_EQ(0x7e2dcb25u, ImmutableString("floor").mangledNameHash());
    ASSERT_EQ(0x7e23152fu, ImmutableString("ceil").mangledNameHash());
    ASSERT_EQ(0x7e2f6df3u, ImmutableString("fract").mangledNameHash());
    ASSERT_EQ(0x7e1eee70u, ImmutableString("mod").mangledNameHash());
    ASSERT_EQ(0x7e26202fu, ImmutableString("step").mangledNameHash());
    ASSERT_EQ(0x7e54a2cfu, ImmutableString("smoothstep").mangledNameHash());
    ASSERT_EQ(0x7e340894u, ImmutableString("length").mangledNameHash());
    ASSERT_EQ(0x7e4161fau, ImmutableString("distance").mangledNameHash());
    ASSERT_EQ(0x7e1e8464u, ImmutableString("dot").mangledNameHash());
    ASSERT_EQ(0x7e295733u, ImmutableString("cross").mangledNameHash());
    ASSERT_EQ(0x7e4e7aa5u, ImmutableString("normalize").mangledNameHash());
    ASSERT_EQ(0x7e5ae14bu, ImmutableString("faceforward").mangledNameHash());
    ASSERT_EQ(0x7e3c8e91u, ImmutableString("reflect").mangledNameHash());
    ASSERT_EQ(0x7e38233fu, ImmutableString("refract").mangledNameHash());
    ASSERT_EQ(0x7e197102u, ImmutableString("any").mangledNameHash());
    ASSERT_EQ(0x7e1892eeu, ImmutableString("all").mangledNameHash());
    ASSERT_EQ(0x7e195106u, ImmutableString("not").mangledNameHash());
    ASSERT_EQ(0x7e8166efu, ImmutableString("gl_MaxImageUnits").mangledNameHash());
    ASSERT_EQ(0x7ecf4a1bu, ImmutableString("gl_MaxVertexImageUniforms").mangledNameHash());
    ASSERT_EQ(0x7edf534au, ImmutableString("gl_MaxFragmentImageUniforms").mangledNameHash());
    ASSERT_EQ(0x7ed2bd5cu, ImmutableString("gl_MaxComputeImageUniforms").mangledNameHash());
    ASSERT_EQ(0x7ed9ae57u, ImmutableString("gl_MaxCombinedImageUniforms").mangledNameHash());
    ASSERT_EQ(0x7f1c60f8u,
              ImmutableString("gl_MaxCombinedShaderOutputResources").mangledNameHash());
    ASSERT_EQ(0x7edeadeeu, ImmutableString("gl_MaxComputeWorkGroupCount").mangledNameHash());
    ASSERT_EQ(0x7ed77973u, ImmutableString("gl_MaxComputeWorkGroupSize").mangledNameHash());
    ASSERT_EQ(0x7ef3740bu, ImmutableString("gl_MaxComputeUniformComponents").mangledNameHash());
    ASSERT_EQ(0x7ef00fc2u, ImmutableString("gl_MaxComputeTextureImageUnits").mangledNameHash());
    ASSERT_EQ(0x7ede0db3u, ImmutableString("gl_MaxComputeAtomicCounters").mangledNameHash());
    ASSERT_EQ(0x7f0d626fu, ImmutableString("gl_MaxComputeAtomicCounterBuffers").mangledNameHash());
    ASSERT_EQ(0x7ed27574u, ImmutableString("gl_MaxVertexAtomicCounters").mangledNameHash());
    ASSERT_EQ(0x7ee23dcau, ImmutableString("gl_MaxFragmentAtomicCounters").mangledNameHash());
    ASSERT_EQ(0x7ee400c5u, ImmutableString("gl_MaxCombinedAtomicCounters").mangledNameHash());
    ASSERT_EQ(0x7edacc17u, ImmutableString("gl_MaxAtomicCounterBindings").mangledNameHash());
    ASSERT_EQ(0x7f008375u, ImmutableString("gl_MaxVertexAtomicCounterBuffers").mangledNameHash());
    ASSERT_EQ(0x7f17bd18u, ImmutableString("gl_MaxFragmentAtomicCounterBuffers").mangledNameHash());
    ASSERT_EQ(0x7f11e359u, ImmutableString("gl_MaxCombinedAtomicCounterBuffers").mangledNameHash());
    ASSERT_EQ(0x7eecdfadu, ImmutableString("gl_MaxAtomicCounterBufferSize").mangledNameHash());
    ASSERT_EQ(0x7eec3ae1u, ImmutableString("gl_MaxGeometryInputComponents").mangledNameHash());
    ASSERT_EQ(0x7ef69ab4u, ImmutableString("gl_MaxGeometryOutputComponents").mangledNameHash());
    ASSERT_EQ(0x7ed9f437u, ImmutableString("gl_MaxGeometryImageUniforms").mangledNameHash());
    ASSERT_EQ(0x7ef9b17du, ImmutableString("gl_MaxGeometryTextureImageUnits").mangledNameHash());
    ASSERT_EQ(0x7ee1b439u, ImmutableString("gl_MaxGeometryOutputVertices").mangledNameHash());
    ASSERT_EQ(0x7f1cd073u,
              ImmutableString("gl_MaxGeometryTotalOutputComponents").mangledNameHash());
    ASSERT_EQ(0x7efe1865u, ImmutableString("gl_MaxGeometryUniformComponents").mangledNameHash());
    ASSERT_EQ(0x7ee6d3cfu, ImmutableString("gl_MaxGeometryAtomicCounters").mangledNameHash());
    ASSERT_EQ(0x7f170f84u, ImmutableString("gl_MaxGeometryAtomicCounterBuffers").mangledNameHash());
    ASSERT_EQ(0x7e2bef7au, ImmutableString("gl_in").mangledNameHash());
    ASSERT_EQ(0x7e82b146u, ImmutableString("gl_NumWorkGroups").mangledNameHash());
    ASSERT_EQ(0x7e808e8fu, ImmutableString("gl_WorkGroupSize").mangledNameHash());
    ASSERT_EQ(0x7e736b62u, ImmutableString("gl_WorkGroupID").mangledNameHash());
    ASSERT_EQ(0x7ea251edu, ImmutableString("gl_LocalInvocationID").mangledNameHash());
    ASSERT_EQ(0x7ead13a8u, ImmutableString("gl_GlobalInvocationID").mangledNameHash());
    ASSERT_EQ(0x7ebcd395u, ImmutableString("gl_LocalInvocationIndex").mangledNameHash());
    ASSERT_EQ(0x7e865240u, ImmutableString("gl_PrimitiveIDIn").mangledNameHash());
    ASSERT_EQ(0x7e7fe684u, ImmutableString("gl_InvocationID").mangledNameHash());
    ASSERT_EQ(0x7e742076u, ImmutableString("gl_PrimitiveID").mangledNameHash());
    ASSERT_EQ(0x7e400f84u, ImmutableString("gl_Layer").mangledNameHash());
    ASSERT_EQ(0x7e67167au, ImmutableString("gl_PerVertex").mangledNameHash());
    ASSERT_EQ(0x7e580bc5u, ImmutableString("gl_Position").mangledNameHash());
    ASSERT_EQ(0x7ec8d677u, ImmutableString("gl_MaxVertexOutputVectors").mangledNameHash());
    ASSERT_EQ(0x7ed1aaebu, ImmutableString("gl_MaxFragmentInputVectors").mangledNameHash());
    ASSERT_EQ(0x7ec3c4d1u, ImmutableString("gl_MinProgramTexelOffset").mangledNameHash());
    ASSERT_EQ(0x7ec10648u, ImmutableString("gl_MaxProgramTexelOffset").mangledNameHash());
    ASSERT_EQ(0x7e645c89u, ImmutableString("gl_FragDepth").mangledNameHash());
    ASSERT_EQ(0x7e6be47fu, ImmutableString("gl_InstanceID").mangledNameHash());
    ASSERT_EQ(0x7e5f8987u, ImmutableString("gl_VertexID").mangledNameHash());
    ASSERT_EQ(0x7e4c3c42u, ImmutableString("gl_DrawID").mangledNameHash());
    ASSERT_EQ(0x7e695e00u, ImmutableString("gl_BaseVertex").mangledNameHash());
    ASSERT_EQ(0x7e785b75u, ImmutableString("gl_BaseInstance").mangledNameHash());
    ASSERT_EQ(0x7e6f6de9u, ImmutableString("gl_ViewID_OVR").mangledNameHash());
    ASSERT_EQ(0x7ea6cdf6u, ImmutableString("gl_MaxVaryingVectors").mangledNameHash());
    ASSERT_EQ(0x7e5a0c08u, ImmutableString("gl_FragData").mangledNameHash());
    ASSERT_EQ(0x7ebce486u, ImmutableString("gl_SecondaryFragDataEXT").mangledNameHash());
    ASSERT_EQ(0x7e7c38efu, ImmutableString("gl_FragDepthEXT").mangledNameHash());
    ASSERT_EQ(0x7e60c438u, ImmutableString("gl_FragColor").mangledNameHash());
    ASSERT_EQ(0x7ec56cbeu, ImmutableString("gl_SecondaryFragColorEXT").mangledNameHash());
    ASSERT_EQ(0x7e7970c2u, ImmutableString("gl_LastFragData").mangledNameHash());
    ASSERT_EQ(0x7e802016u, ImmutableString("gl_LastFragColor").mangledNameHash());
    ASSERT_EQ(0x7e9f0a88u, ImmutableString("gl_LastFragColorARM").mangledNameHash());
    ASSERT_EQ(0x7ebeff64u, ImmutableString("gl_DepthRangeParameters").mangledNameHash());
    ASSERT_EQ(0x7e6af03cu, ImmutableString("gl_DepthRange").mangledNameHash());
    ASSERT_EQ(0x7e9ad799u, ImmutableString("gl_MaxVertexAttribs").mangledNameHash());
    ASSERT_EQ(0x7ed35151u, ImmutableString("gl_MaxVertexUniformVectors").mangledNameHash());
    ASSERT_EQ(0x7eea039au, ImmutableString("gl_MaxVertexTextureImageUnits").mangledNameHash());
    ASSERT_EQ(0x7ef84293u, ImmutableString("gl_MaxCombinedTextureImageUnits").mangledNameHash());
    ASSERT_EQ(0x7ebaa8e5u, ImmutableString("gl_MaxTextureImageUnits").mangledNameHash());
    ASSERT_EQ(0x7ee45ba1u, ImmutableString("gl_MaxFragmentUniformVectors").mangledNameHash());
    ASSERT_EQ(0x7e8ab02eu, ImmutableString("gl_MaxDrawBuffers").mangledNameHash());
    ASSERT_EQ(0x7ef1e608u, ImmutableString("gl_MaxDualSourceDrawBuffersEXT").mangledNameHash());
    ASSERT_EQ(0x7e64c010u, ImmutableString("gl_FragCoord").mangledNameHash());
    ASSERT_EQ(0x7e73011eu, ImmutableString("gl_FrontFacing").mangledNameHash());
    ASSERT_EQ(0x7e6c2088u, ImmutableString("gl_PointCoord").mangledNameHash());
    ASSERT_EQ(0x7e63931cu, ImmutableString("gl_PointSize").mangledNameHash());
}

}  // namespace sh
