// GENERATED FILE - DO NOT EDIT.
// Generated by gen_vk_format_table.py using data from vk_format_map.json
//
// Copyright 2019 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// vk_format_table_autogen.cpp:
//   Queries for full Vulkan format information based on GL format.

#include "libANGLE/renderer/vulkan/vk_format_utils.h"

#include "image_util/copyimage.h"
#include "image_util/generatemip.h"
#include "image_util/loadimage.h"

using namespace angle;

namespace rx
{

namespace vk
{

void Format::initialize(RendererVk *renderer, const angle::Format &angleFormat)
{
    switch (angleFormat.id)
    {
        case angle::FormatID::A16_FLOAT:
            internalFormat           = GL_ALPHA16F_EXT;
            imageFormatID            = angle::FormatID::R16_FLOAT;
            vkImageFormat            = VK_FORMAT_R16_SFLOAT;
            imageInitializerFunction = nullptr;

            break;

        case angle::FormatID::A1R5G5B5_UNORM:
            internalFormat               = GL_A1RGB5_ANGLEX;
            imageFormatID                = angle::FormatID::A1R5G5B5_UNORM;
            vkImageFormat                = VK_FORMAT_A1R5G5B5_UNORM_PACK16;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::A1R5G5B5_UNORM;
            vkBufferFormat               = VK_FORMAT_A1R5G5B5_UNORM_PACK16;
            vkBufferFormatIsPacked       = true;
            vertexLoadFunction           = CopyNativeVertexData<GLushort, 1, 1, 0>;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::A32_FLOAT:
            internalFormat           = GL_ALPHA32F_EXT;
            imageFormatID            = angle::FormatID::R32_FLOAT;
            vkImageFormat            = VK_FORMAT_R32_SFLOAT;
            imageInitializerFunction = nullptr;

            break;

        case angle::FormatID::A8_UNORM:
            internalFormat           = GL_ALPHA8_EXT;
            imageFormatID            = angle::FormatID::R8_UNORM;
            vkImageFormat            = VK_FORMAT_R8_UNORM;
            imageInitializerFunction = nullptr;

            break;

        case angle::FormatID::ASTC_10x10_SRGB_BLOCK:
            internalFormat               = GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR;
            imageFormatID                = angle::FormatID::ASTC_10x10_SRGB_BLOCK;
            vkImageFormat                = VK_FORMAT_ASTC_10x10_SRGB_BLOCK;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::ASTC_10x10_SRGB_BLOCK;
            vkBufferFormat               = VK_FORMAT_ASTC_10x10_SRGB_BLOCK;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = nullptr;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ASTC_10x10_UNORM_BLOCK:
            internalFormat               = GL_COMPRESSED_RGBA_ASTC_10x10_KHR;
            imageFormatID                = angle::FormatID::ASTC_10x10_UNORM_BLOCK;
            vkImageFormat                = VK_FORMAT_ASTC_10x10_UNORM_BLOCK;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::ASTC_10x10_UNORM_BLOCK;
            vkBufferFormat               = VK_FORMAT_ASTC_10x10_UNORM_BLOCK;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = nullptr;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ASTC_10x5_SRGB_BLOCK:
            internalFormat               = GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR;
            imageFormatID                = angle::FormatID::ASTC_10x5_SRGB_BLOCK;
            vkImageFormat                = VK_FORMAT_ASTC_10x5_SRGB_BLOCK;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::ASTC_10x5_SRGB_BLOCK;
            vkBufferFormat               = VK_FORMAT_ASTC_10x5_SRGB_BLOCK;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = nullptr;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ASTC_10x5_UNORM_BLOCK:
            internalFormat               = GL_COMPRESSED_RGBA_ASTC_10x5_KHR;
            imageFormatID                = angle::FormatID::ASTC_10x5_UNORM_BLOCK;
            vkImageFormat                = VK_FORMAT_ASTC_10x5_UNORM_BLOCK;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::ASTC_10x5_UNORM_BLOCK;
            vkBufferFormat               = VK_FORMAT_ASTC_10x5_UNORM_BLOCK;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = nullptr;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ASTC_10x6_SRGB_BLOCK:
            internalFormat               = GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR;
            imageFormatID                = angle::FormatID::ASTC_10x6_SRGB_BLOCK;
            vkImageFormat                = VK_FORMAT_ASTC_10x6_SRGB_BLOCK;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::ASTC_10x6_SRGB_BLOCK;
            vkBufferFormat               = VK_FORMAT_ASTC_10x6_SRGB_BLOCK;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = nullptr;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ASTC_10x6_UNORM_BLOCK:
            internalFormat               = GL_COMPRESSED_RGBA_ASTC_10x6_KHR;
            imageFormatID                = angle::FormatID::ASTC_10x6_UNORM_BLOCK;
            vkImageFormat                = VK_FORMAT_ASTC_10x6_UNORM_BLOCK;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::ASTC_10x6_UNORM_BLOCK;
            vkBufferFormat               = VK_FORMAT_ASTC_10x6_UNORM_BLOCK;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = nullptr;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ASTC_10x8_SRGB_BLOCK:
            internalFormat               = GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR;
            imageFormatID                = angle::FormatID::ASTC_10x8_SRGB_BLOCK;
            vkImageFormat                = VK_FORMAT_ASTC_10x8_SRGB_BLOCK;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::ASTC_10x8_SRGB_BLOCK;
            vkBufferFormat               = VK_FORMAT_ASTC_10x8_SRGB_BLOCK;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = nullptr;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ASTC_10x8_UNORM_BLOCK:
            internalFormat               = GL_COMPRESSED_RGBA_ASTC_10x8_KHR;
            imageFormatID                = angle::FormatID::ASTC_10x8_UNORM_BLOCK;
            vkImageFormat                = VK_FORMAT_ASTC_10x8_UNORM_BLOCK;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::ASTC_10x8_UNORM_BLOCK;
            vkBufferFormat               = VK_FORMAT_ASTC_10x8_UNORM_BLOCK;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = nullptr;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ASTC_12x10_SRGB_BLOCK:
            internalFormat               = GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR;
            imageFormatID                = angle::FormatID::ASTC_12x10_SRGB_BLOCK;
            vkImageFormat                = VK_FORMAT_ASTC_12x10_SRGB_BLOCK;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::ASTC_12x10_SRGB_BLOCK;
            vkBufferFormat               = VK_FORMAT_ASTC_12x10_SRGB_BLOCK;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = nullptr;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ASTC_12x10_UNORM_BLOCK:
            internalFormat               = GL_COMPRESSED_RGBA_ASTC_12x10_KHR;
            imageFormatID                = angle::FormatID::ASTC_12x10_UNORM_BLOCK;
            vkImageFormat                = VK_FORMAT_ASTC_12x10_UNORM_BLOCK;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::ASTC_12x10_UNORM_BLOCK;
            vkBufferFormat               = VK_FORMAT_ASTC_12x10_UNORM_BLOCK;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = nullptr;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ASTC_12x12_SRGB_BLOCK:
            internalFormat               = GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR;
            imageFormatID                = angle::FormatID::ASTC_12x12_SRGB_BLOCK;
            vkImageFormat                = VK_FORMAT_ASTC_12x12_SRGB_BLOCK;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::ASTC_12x12_SRGB_BLOCK;
            vkBufferFormat               = VK_FORMAT_ASTC_12x12_SRGB_BLOCK;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = nullptr;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ASTC_12x12_UNORM_BLOCK:
            internalFormat               = GL_COMPRESSED_RGBA_ASTC_12x12_KHR;
            imageFormatID                = angle::FormatID::ASTC_12x12_UNORM_BLOCK;
            vkImageFormat                = VK_FORMAT_ASTC_12x12_UNORM_BLOCK;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::ASTC_12x12_UNORM_BLOCK;
            vkBufferFormat               = VK_FORMAT_ASTC_12x12_UNORM_BLOCK;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = nullptr;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ASTC_3x3x3_UNORM_BLOCK:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::ASTC_3x3x3_UNORM_SRGB_BLOCK:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::ASTC_4x3x3_UNORM_BLOCK:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::ASTC_4x3x3_UNORM_SRGB_BLOCK:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::ASTC_4x4_SRGB_BLOCK:
            internalFormat               = GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR;
            imageFormatID                = angle::FormatID::ASTC_4x4_SRGB_BLOCK;
            vkImageFormat                = VK_FORMAT_ASTC_4x4_SRGB_BLOCK;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::ASTC_4x4_SRGB_BLOCK;
            vkBufferFormat               = VK_FORMAT_ASTC_4x4_SRGB_BLOCK;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = nullptr;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ASTC_4x4_UNORM_BLOCK:
            internalFormat               = GL_COMPRESSED_RGBA_ASTC_4x4_KHR;
            imageFormatID                = angle::FormatID::ASTC_4x4_UNORM_BLOCK;
            vkImageFormat                = VK_FORMAT_ASTC_4x4_UNORM_BLOCK;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::ASTC_4x4_UNORM_BLOCK;
            vkBufferFormat               = VK_FORMAT_ASTC_4x4_UNORM_BLOCK;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = nullptr;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ASTC_4x4x3_UNORM_BLOCK:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::ASTC_4x4x3_UNORM_SRGB_BLOCK:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::ASTC_4x4x4_UNORM_BLOCK:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::ASTC_4x4x4_UNORM_SRGB_BLOCK:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::ASTC_5x4_SRGB_BLOCK:
            internalFormat               = GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4_KHR;
            imageFormatID                = angle::FormatID::ASTC_5x4_SRGB_BLOCK;
            vkImageFormat                = VK_FORMAT_ASTC_5x4_SRGB_BLOCK;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::ASTC_5x4_SRGB_BLOCK;
            vkBufferFormat               = VK_FORMAT_ASTC_5x4_SRGB_BLOCK;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = nullptr;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ASTC_5x4_UNORM_BLOCK:
            internalFormat               = GL_COMPRESSED_RGBA_ASTC_5x4_KHR;
            imageFormatID                = angle::FormatID::ASTC_5x4_UNORM_BLOCK;
            vkImageFormat                = VK_FORMAT_ASTC_5x4_UNORM_BLOCK;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::ASTC_5x4_UNORM_BLOCK;
            vkBufferFormat               = VK_FORMAT_ASTC_5x4_UNORM_BLOCK;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = nullptr;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ASTC_5x4x4_UNORM_BLOCK:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::ASTC_5x4x4_UNORM_SRGB_BLOCK:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::ASTC_5x5_SRGB_BLOCK:
            internalFormat               = GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR;
            imageFormatID                = angle::FormatID::ASTC_5x5_SRGB_BLOCK;
            vkImageFormat                = VK_FORMAT_ASTC_5x5_SRGB_BLOCK;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::ASTC_5x5_SRGB_BLOCK;
            vkBufferFormat               = VK_FORMAT_ASTC_5x5_SRGB_BLOCK;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = nullptr;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ASTC_5x5_UNORM_BLOCK:
            internalFormat               = GL_COMPRESSED_RGBA_ASTC_5x5_KHR;
            imageFormatID                = angle::FormatID::ASTC_5x5_UNORM_BLOCK;
            vkImageFormat                = VK_FORMAT_ASTC_5x5_UNORM_BLOCK;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::ASTC_5x5_UNORM_BLOCK;
            vkBufferFormat               = VK_FORMAT_ASTC_5x5_UNORM_BLOCK;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = nullptr;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ASTC_5x5x4_UNORM_BLOCK:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::ASTC_5x5x4_UNORM_SRGB_BLOCK:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::ASTC_5x5x5_UNORM_BLOCK:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::ASTC_5x5x5_UNORM_SRGB_BLOCK:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::ASTC_6x5_SRGB_BLOCK:
            internalFormat               = GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR;
            imageFormatID                = angle::FormatID::ASTC_6x5_SRGB_BLOCK;
            vkImageFormat                = VK_FORMAT_ASTC_6x5_SRGB_BLOCK;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::ASTC_6x5_SRGB_BLOCK;
            vkBufferFormat               = VK_FORMAT_ASTC_6x5_SRGB_BLOCK;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = nullptr;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ASTC_6x5_UNORM_BLOCK:
            internalFormat               = GL_COMPRESSED_RGBA_ASTC_6x5_KHR;
            imageFormatID                = angle::FormatID::ASTC_6x5_UNORM_BLOCK;
            vkImageFormat                = VK_FORMAT_ASTC_6x5_UNORM_BLOCK;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::ASTC_6x5_UNORM_BLOCK;
            vkBufferFormat               = VK_FORMAT_ASTC_6x5_UNORM_BLOCK;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = nullptr;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ASTC_6x5x5_UNORM_BLOCK:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::ASTC_6x5x5_UNORM_SRGB_BLOCK:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::ASTC_6x6_SRGB_BLOCK:
            internalFormat               = GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR;
            imageFormatID                = angle::FormatID::ASTC_6x6_SRGB_BLOCK;
            vkImageFormat                = VK_FORMAT_ASTC_6x6_SRGB_BLOCK;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::ASTC_6x6_SRGB_BLOCK;
            vkBufferFormat               = VK_FORMAT_ASTC_6x6_SRGB_BLOCK;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = nullptr;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ASTC_6x6_UNORM_BLOCK:
            internalFormat               = GL_COMPRESSED_RGBA_ASTC_6x6_KHR;
            imageFormatID                = angle::FormatID::ASTC_6x6_UNORM_BLOCK;
            vkImageFormat                = VK_FORMAT_ASTC_6x6_UNORM_BLOCK;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::ASTC_6x6_UNORM_BLOCK;
            vkBufferFormat               = VK_FORMAT_ASTC_6x6_UNORM_BLOCK;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = nullptr;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ASTC_6x6x5_UNORM_BLOCK:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::ASTC_6x6x5_UNORM_SRGB_BLOCK:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::ASTC_6x6x6_UNORM_BLOCK:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::ASTC_6x6x6_UNORM_SRGB_BLOCK:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::ASTC_8x5_SRGB_BLOCK:
            internalFormat               = GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR;
            imageFormatID                = angle::FormatID::ASTC_8x5_SRGB_BLOCK;
            vkImageFormat                = VK_FORMAT_ASTC_8x5_SRGB_BLOCK;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::ASTC_8x5_SRGB_BLOCK;
            vkBufferFormat               = VK_FORMAT_ASTC_8x5_SRGB_BLOCK;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = nullptr;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ASTC_8x5_UNORM_BLOCK:
            internalFormat               = GL_COMPRESSED_RGBA_ASTC_8x5_KHR;
            imageFormatID                = angle::FormatID::ASTC_8x5_UNORM_BLOCK;
            vkImageFormat                = VK_FORMAT_ASTC_8x5_UNORM_BLOCK;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::ASTC_8x5_UNORM_BLOCK;
            vkBufferFormat               = VK_FORMAT_ASTC_8x5_UNORM_BLOCK;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = nullptr;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ASTC_8x6_SRGB_BLOCK:
            internalFormat               = GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR;
            imageFormatID                = angle::FormatID::ASTC_8x6_SRGB_BLOCK;
            vkImageFormat                = VK_FORMAT_ASTC_8x6_SRGB_BLOCK;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::ASTC_8x6_SRGB_BLOCK;
            vkBufferFormat               = VK_FORMAT_ASTC_8x6_SRGB_BLOCK;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = nullptr;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ASTC_8x6_UNORM_BLOCK:
            internalFormat               = GL_COMPRESSED_RGBA_ASTC_8x6_KHR;
            imageFormatID                = angle::FormatID::ASTC_8x6_UNORM_BLOCK;
            vkImageFormat                = VK_FORMAT_ASTC_8x6_UNORM_BLOCK;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::ASTC_8x6_UNORM_BLOCK;
            vkBufferFormat               = VK_FORMAT_ASTC_8x6_UNORM_BLOCK;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = nullptr;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ASTC_8x8_SRGB_BLOCK:
            internalFormat               = GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR;
            imageFormatID                = angle::FormatID::ASTC_8x8_SRGB_BLOCK;
            vkImageFormat                = VK_FORMAT_ASTC_8x8_SRGB_BLOCK;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::ASTC_8x8_SRGB_BLOCK;
            vkBufferFormat               = VK_FORMAT_ASTC_8x8_SRGB_BLOCK;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = nullptr;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ASTC_8x8_UNORM_BLOCK:
            internalFormat               = GL_COMPRESSED_RGBA_ASTC_8x8_KHR;
            imageFormatID                = angle::FormatID::ASTC_8x8_UNORM_BLOCK;
            vkImageFormat                = VK_FORMAT_ASTC_8x8_UNORM_BLOCK;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::ASTC_8x8_UNORM_BLOCK;
            vkBufferFormat               = VK_FORMAT_ASTC_8x8_UNORM_BLOCK;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = nullptr;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::B4G4R4A4_UNORM:
            internalFormat               = GL_BGRA4_ANGLEX;
            imageFormatID                = angle::FormatID::B4G4R4A4_UNORM;
            vkImageFormat                = VK_FORMAT_B4G4R4A4_UNORM_PACK16;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::B4G4R4A4_UNORM;
            vkBufferFormat               = VK_FORMAT_B4G4R4A4_UNORM_PACK16;
            vkBufferFormatIsPacked       = true;
            vertexLoadFunction           = CopyNativeVertexData<GLushort, 1, 1, 0>;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::B5G5R5A1_UNORM:
            internalFormat               = GL_BGR5_A1_ANGLEX;
            imageFormatID                = angle::FormatID::B5G5R5A1_UNORM;
            vkImageFormat                = VK_FORMAT_B5G5R5A1_UNORM_PACK16;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::B5G5R5A1_UNORM;
            vkBufferFormat               = VK_FORMAT_B5G5R5A1_UNORM_PACK16;
            vkBufferFormatIsPacked       = true;
            vertexLoadFunction           = CopyNativeVertexData<GLushort, 1, 1, 0>;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::B5G6R5_UNORM:
            internalFormat               = GL_BGR565_ANGLEX;
            imageFormatID                = angle::FormatID::B5G6R5_UNORM;
            vkImageFormat                = VK_FORMAT_B5G6R5_UNORM_PACK16;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::B5G6R5_UNORM;
            vkBufferFormat               = VK_FORMAT_B5G6R5_UNORM_PACK16;
            vkBufferFormatIsPacked       = true;
            vertexLoadFunction           = CopyNativeVertexData<GLushort, 1, 1, 0>;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::B8G8R8A8_TYPELESS:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::B8G8R8A8_TYPELESS_SRGB:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::B8G8R8A8_UNORM:
            internalFormat               = GL_BGRA8_EXT;
            imageFormatID                = angle::FormatID::B8G8R8A8_UNORM;
            vkImageFormat                = VK_FORMAT_B8G8R8A8_UNORM;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::B8G8R8A8_UNORM;
            vkBufferFormat               = VK_FORMAT_B8G8R8A8_UNORM;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = CopyNativeVertexData<GLubyte, 4, 4, 0>;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::B8G8R8A8_UNORM_SRGB:
            internalFormat               = GL_BGRA8_SRGB_ANGLEX;
            imageFormatID                = angle::FormatID::B8G8R8A8_UNORM_SRGB;
            vkImageFormat                = VK_FORMAT_B8G8R8A8_SRGB;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::B8G8R8A8_UNORM_SRGB;
            vkBufferFormat               = VK_FORMAT_B8G8R8A8_SRGB;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = CopyNativeVertexData<GLubyte, 4, 4, 0>;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::B8G8R8X8_UNORM:
            internalFormat               = GL_BGRX8_ANGLEX;
            imageFormatID                = angle::FormatID::B8G8R8A8_UNORM;
            vkImageFormat                = VK_FORMAT_B8G8R8A8_UNORM;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::NONE;
            vkBufferFormat               = VK_FORMAT_UNDEFINED;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = nullptr;
            vertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::BC1_RGBA_UNORM_BLOCK:
            internalFormat               = GL_COMPRESSED_RGBA_S3TC_DXT1_EXT;
            imageFormatID                = angle::FormatID::BC1_RGBA_UNORM_BLOCK;
            vkImageFormat                = VK_FORMAT_BC1_RGBA_UNORM_BLOCK;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::BC1_RGBA_UNORM_BLOCK;
            vkBufferFormat               = VK_FORMAT_BC1_RGBA_UNORM_BLOCK;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = nullptr;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::BC1_RGBA_UNORM_SRGB_BLOCK:
            internalFormat               = GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT;
            imageFormatID                = angle::FormatID::BC1_RGBA_UNORM_SRGB_BLOCK;
            vkImageFormat                = VK_FORMAT_BC1_RGBA_SRGB_BLOCK;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::BC1_RGBA_UNORM_SRGB_BLOCK;
            vkBufferFormat               = VK_FORMAT_BC1_RGBA_SRGB_BLOCK;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = nullptr;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::BC1_RGB_UNORM_BLOCK:
            internalFormat               = GL_COMPRESSED_RGB_S3TC_DXT1_EXT;
            imageFormatID                = angle::FormatID::BC1_RGB_UNORM_BLOCK;
            vkImageFormat                = VK_FORMAT_BC1_RGB_UNORM_BLOCK;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::BC1_RGB_UNORM_BLOCK;
            vkBufferFormat               = VK_FORMAT_BC1_RGB_UNORM_BLOCK;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = nullptr;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::BC1_RGB_UNORM_SRGB_BLOCK:
            internalFormat               = GL_COMPRESSED_SRGB_S3TC_DXT1_EXT;
            imageFormatID                = angle::FormatID::BC1_RGB_UNORM_SRGB_BLOCK;
            vkImageFormat                = VK_FORMAT_BC1_RGB_SRGB_BLOCK;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::BC1_RGB_UNORM_SRGB_BLOCK;
            vkBufferFormat               = VK_FORMAT_BC1_RGB_SRGB_BLOCK;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = nullptr;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::BC2_RGBA_UNORM_BLOCK:
            internalFormat               = GL_COMPRESSED_RGBA_S3TC_DXT3_ANGLE;
            imageFormatID                = angle::FormatID::BC2_RGBA_UNORM_BLOCK;
            vkImageFormat                = VK_FORMAT_BC2_UNORM_BLOCK;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::BC2_RGBA_UNORM_BLOCK;
            vkBufferFormat               = VK_FORMAT_BC2_UNORM_BLOCK;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = nullptr;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::BC2_RGBA_UNORM_SRGB_BLOCK:
            internalFormat               = GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT;
            imageFormatID                = angle::FormatID::BC2_RGBA_UNORM_SRGB_BLOCK;
            vkImageFormat                = VK_FORMAT_BC2_SRGB_BLOCK;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::BC2_RGBA_UNORM_SRGB_BLOCK;
            vkBufferFormat               = VK_FORMAT_BC2_SRGB_BLOCK;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = nullptr;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::BC3_RGBA_UNORM_BLOCK:
            internalFormat               = GL_COMPRESSED_RGBA_S3TC_DXT5_ANGLE;
            imageFormatID                = angle::FormatID::BC3_RGBA_UNORM_BLOCK;
            vkImageFormat                = VK_FORMAT_BC3_UNORM_BLOCK;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::BC3_RGBA_UNORM_BLOCK;
            vkBufferFormat               = VK_FORMAT_BC3_UNORM_BLOCK;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = nullptr;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::BC3_RGBA_UNORM_SRGB_BLOCK:
            internalFormat               = GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT;
            imageFormatID                = angle::FormatID::BC3_RGBA_UNORM_SRGB_BLOCK;
            vkImageFormat                = VK_FORMAT_BC3_SRGB_BLOCK;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::BC3_RGBA_UNORM_SRGB_BLOCK;
            vkBufferFormat               = VK_FORMAT_BC3_SRGB_BLOCK;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = nullptr;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::BPTC_RGBA_UNORM_BLOCK:
            internalFormat               = GL_COMPRESSED_RGBA_BPTC_UNORM_EXT;
            imageFormatID                = angle::FormatID::BPTC_RGBA_UNORM_BLOCK;
            vkImageFormat                = VK_FORMAT_BC7_UNORM_BLOCK;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::BPTC_RGBA_UNORM_BLOCK;
            vkBufferFormat               = VK_FORMAT_BC7_UNORM_BLOCK;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = nullptr;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::BPTC_RGB_SIGNED_FLOAT_BLOCK:
            internalFormat               = GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT_EXT;
            imageFormatID                = angle::FormatID::BPTC_RGB_SIGNED_FLOAT_BLOCK;
            vkImageFormat                = VK_FORMAT_BC6H_SFLOAT_BLOCK;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::BPTC_RGB_SIGNED_FLOAT_BLOCK;
            vkBufferFormat               = VK_FORMAT_BC6H_SFLOAT_BLOCK;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = nullptr;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::BPTC_RGB_UNSIGNED_FLOAT_BLOCK:
            internalFormat               = GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT_EXT;
            imageFormatID                = angle::FormatID::BPTC_RGB_UNSIGNED_FLOAT_BLOCK;
            vkImageFormat                = VK_FORMAT_BC6H_UFLOAT_BLOCK;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::BPTC_RGB_UNSIGNED_FLOAT_BLOCK;
            vkBufferFormat               = VK_FORMAT_BC6H_UFLOAT_BLOCK;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = nullptr;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::BPTC_SRGB_ALPHA_UNORM_BLOCK:
            internalFormat               = GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM_EXT;
            imageFormatID                = angle::FormatID::BPTC_SRGB_ALPHA_UNORM_BLOCK;
            vkImageFormat                = VK_FORMAT_BC7_SRGB_BLOCK;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::BPTC_SRGB_ALPHA_UNORM_BLOCK;
            vkBufferFormat               = VK_FORMAT_BC7_SRGB_BLOCK;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = nullptr;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::D16_UNORM:
            internalFormat               = GL_DEPTH_COMPONENT16;
            imageFormatID                = angle::FormatID::D16_UNORM;
            vkImageFormat                = VK_FORMAT_D16_UNORM;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::D16_UNORM;
            vkBufferFormat               = VK_FORMAT_D16_UNORM;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = nullptr;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::D24_UNORM_S8_UINT:
            internalFormat = GL_DEPTH24_STENCIL8;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::D24_UNORM_S8_UINT, VK_FORMAT_D24_UNORM_S8_UINT, nullptr},
                    {angle::FormatID::D32_FLOAT_S8X24_UINT, VK_FORMAT_D32_SFLOAT_S8_UINT, nullptr},
                    {angle::FormatID::D24_UNORM_S8_UINT, VK_FORMAT_D24_UNORM_S8_UINT, nullptr}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            bufferFormatID               = angle::FormatID::D24_UNORM_S8_UINT;
            vkBufferFormat               = VK_FORMAT_D24_UNORM_S8_UINT;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = nullptr;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::D24_UNORM_X8_UINT:
            internalFormat = GL_DEPTH_COMPONENT24;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::D24_UNORM_S8_UINT, VK_FORMAT_D24_UNORM_S8_UINT, nullptr},
                    {angle::FormatID::D32_FLOAT_S8X24_UINT, VK_FORMAT_D32_SFLOAT_S8_UINT, nullptr},
                    {angle::FormatID::D24_UNORM_S8_UINT, VK_FORMAT_D24_UNORM_S8_UINT, nullptr}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            bufferFormatID               = angle::FormatID::NONE;
            vkBufferFormat               = VK_FORMAT_UNDEFINED;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = nullptr;
            vertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::D32_FLOAT:
            internalFormat               = GL_DEPTH_COMPONENT32F;
            imageFormatID                = angle::FormatID::D32_FLOAT;
            vkImageFormat                = VK_FORMAT_D32_SFLOAT;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::D32_FLOAT;
            vkBufferFormat               = VK_FORMAT_D32_SFLOAT;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = CopyNativeVertexData<GLfloat, 1, 1, 0>;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::D32_FLOAT_S8X24_UINT:
            internalFormat = GL_DEPTH32F_STENCIL8;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::D32_FLOAT_S8X24_UINT, VK_FORMAT_D32_SFLOAT_S8_UINT, nullptr},
                    {angle::FormatID::D24_UNORM_S8_UINT, VK_FORMAT_D24_UNORM_S8_UINT, nullptr},
                    {angle::FormatID::D32_FLOAT_S8X24_UINT, VK_FORMAT_D32_SFLOAT_S8_UINT, nullptr}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            bufferFormatID               = angle::FormatID::D32_FLOAT_S8X24_UINT;
            vkBufferFormat               = VK_FORMAT_D32_SFLOAT_S8_UINT;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = CopyNativeVertexData<GLfloat, 3, 3, 0>;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::D32_UNORM:
            internalFormat = GL_DEPTH_COMPONENT32_OES;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::D24_UNORM_S8_UINT, VK_FORMAT_D24_UNORM_S8_UINT, nullptr},
                    {angle::FormatID::D32_FLOAT_S8X24_UINT, VK_FORMAT_D32_SFLOAT_S8_UINT, nullptr},
                    {angle::FormatID::D24_UNORM_S8_UINT, VK_FORMAT_D24_UNORM_S8_UINT, nullptr}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            bufferFormatID               = angle::FormatID::NONE;
            vkBufferFormat               = VK_FORMAT_UNDEFINED;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = nullptr;
            vertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::EAC_R11G11_SNORM_BLOCK:
            internalFormat               = GL_COMPRESSED_SIGNED_RG11_EAC;
            imageFormatID                = angle::FormatID::EAC_R11G11_SNORM_BLOCK;
            vkImageFormat                = VK_FORMAT_EAC_R11G11_SNORM_BLOCK;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::EAC_R11G11_SNORM_BLOCK;
            vkBufferFormat               = VK_FORMAT_EAC_R11G11_SNORM_BLOCK;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = nullptr;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::EAC_R11G11_UNORM_BLOCK:
            internalFormat               = GL_COMPRESSED_RG11_EAC;
            imageFormatID                = angle::FormatID::EAC_R11G11_UNORM_BLOCK;
            vkImageFormat                = VK_FORMAT_EAC_R11G11_UNORM_BLOCK;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::EAC_R11G11_UNORM_BLOCK;
            vkBufferFormat               = VK_FORMAT_EAC_R11G11_UNORM_BLOCK;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = nullptr;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::EAC_R11_SNORM_BLOCK:
            internalFormat               = GL_COMPRESSED_SIGNED_R11_EAC;
            imageFormatID                = angle::FormatID::EAC_R11_SNORM_BLOCK;
            vkImageFormat                = VK_FORMAT_EAC_R11_SNORM_BLOCK;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::EAC_R11_SNORM_BLOCK;
            vkBufferFormat               = VK_FORMAT_EAC_R11_SNORM_BLOCK;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = nullptr;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::EAC_R11_UNORM_BLOCK:
            internalFormat               = GL_COMPRESSED_R11_EAC;
            imageFormatID                = angle::FormatID::EAC_R11_UNORM_BLOCK;
            vkImageFormat                = VK_FORMAT_EAC_R11_UNORM_BLOCK;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::EAC_R11_UNORM_BLOCK;
            vkBufferFormat               = VK_FORMAT_EAC_R11_UNORM_BLOCK;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = nullptr;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ETC1_LOSSY_DECODE_R8G8B8_UNORM_BLOCK:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::ETC1_R8G8B8_UNORM_BLOCK:
            internalFormat               = GL_ETC1_RGB8_OES;
            imageFormatID                = angle::FormatID::ETC2_R8G8B8_UNORM_BLOCK;
            vkImageFormat                = VK_FORMAT_ETC2_R8G8B8_UNORM_BLOCK;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::NONE;
            vkBufferFormat               = VK_FORMAT_UNDEFINED;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = nullptr;
            vertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::ETC2_R8G8B8A1_SRGB_BLOCK:
            internalFormat               = GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2;
            imageFormatID                = angle::FormatID::ETC2_R8G8B8A1_SRGB_BLOCK;
            vkImageFormat                = VK_FORMAT_ETC2_R8G8B8A1_SRGB_BLOCK;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::ETC2_R8G8B8A1_SRGB_BLOCK;
            vkBufferFormat               = VK_FORMAT_ETC2_R8G8B8A1_SRGB_BLOCK;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = CopyNativeVertexData<GLbyte, 4, 4, 0>;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ETC2_R8G8B8A1_UNORM_BLOCK:
            internalFormat           = GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2;
            imageFormatID            = angle::FormatID::ETC2_R8G8B8A1_UNORM_BLOCK;
            vkImageFormat            = VK_FORMAT_ETC2_R8G8B8A1_UNORM_BLOCK;
            imageInitializerFunction = Initialize4ComponentData<GLubyte, 0x00, 0x00, 0x00, 0xFF>;
            bufferFormatID           = angle::FormatID::ETC2_R8G8B8A1_UNORM_BLOCK;
            vkBufferFormat           = VK_FORMAT_ETC2_R8G8B8A1_UNORM_BLOCK;
            vkBufferFormatIsPacked   = false;
            vertexLoadFunction       = CopyNativeVertexData<GLubyte, 4, 4, 0>;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ETC2_R8G8B8A8_SRGB_BLOCK:
            internalFormat               = GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC;
            imageFormatID                = angle::FormatID::ETC2_R8G8B8A8_SRGB_BLOCK;
            vkImageFormat                = VK_FORMAT_ETC2_R8G8B8A8_SRGB_BLOCK;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::ETC2_R8G8B8A8_SRGB_BLOCK;
            vkBufferFormat               = VK_FORMAT_ETC2_R8G8B8A8_SRGB_BLOCK;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = CopyNativeVertexData<GLbyte, 4, 4, 0>;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ETC2_R8G8B8A8_UNORM_BLOCK:
            internalFormat               = GL_COMPRESSED_RGBA8_ETC2_EAC;
            imageFormatID                = angle::FormatID::ETC2_R8G8B8A8_UNORM_BLOCK;
            vkImageFormat                = VK_FORMAT_ETC2_R8G8B8A8_UNORM_BLOCK;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::ETC2_R8G8B8A8_UNORM_BLOCK;
            vkBufferFormat               = VK_FORMAT_ETC2_R8G8B8A8_UNORM_BLOCK;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = CopyNativeVertexData<GLubyte, 4, 4, 0>;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ETC2_R8G8B8_SRGB_BLOCK:
            internalFormat               = GL_COMPRESSED_SRGB8_ETC2;
            imageFormatID                = angle::FormatID::ETC2_R8G8B8_SRGB_BLOCK;
            vkImageFormat                = VK_FORMAT_ETC2_R8G8B8_SRGB_BLOCK;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::ETC2_R8G8B8_SRGB_BLOCK;
            vkBufferFormat               = VK_FORMAT_ETC2_R8G8B8_SRGB_BLOCK;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = CopyNativeVertexData<GLbyte, 3, 3, 0>;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ETC2_R8G8B8_UNORM_BLOCK:
            internalFormat               = GL_COMPRESSED_RGB8_ETC2;
            imageFormatID                = angle::FormatID::ETC2_R8G8B8_UNORM_BLOCK;
            vkImageFormat                = VK_FORMAT_ETC2_R8G8B8_UNORM_BLOCK;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::ETC2_R8G8B8_UNORM_BLOCK;
            vkBufferFormat               = VK_FORMAT_ETC2_R8G8B8_UNORM_BLOCK;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = CopyNativeVertexData<GLubyte, 3, 3, 0>;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::L16A16_FLOAT:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::L16_FLOAT:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::L32A32_FLOAT:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::L32_FLOAT:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::L8A8_UNORM:
            internalFormat           = GL_LUMINANCE8_ALPHA8_EXT;
            imageFormatID            = angle::FormatID::R8G8_UNORM;
            vkImageFormat            = VK_FORMAT_R8G8_UNORM;
            imageInitializerFunction = nullptr;

            break;

        case angle::FormatID::L8_UNORM:
            internalFormat           = GL_LUMINANCE8_EXT;
            imageFormatID            = angle::FormatID::R8_UNORM;
            vkImageFormat            = VK_FORMAT_R8_UNORM;
            imageInitializerFunction = nullptr;

            break;

        case angle::FormatID::NONE:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::R10G10B10A2_SINT:
            internalFormat               = GL_RGB10_A2_SINT_ANGLEX;
            imageFormatID                = angle::FormatID::R10G10B10A2_SINT;
            vkImageFormat                = VK_FORMAT_A2B10G10R10_SINT_PACK32;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::R10G10B10A2_SINT;
            vkBufferFormat               = VK_FORMAT_A2B10G10R10_SINT_PACK32;
            vkBufferFormatIsPacked       = true;
            vertexLoadFunction           = CopyNativeVertexData<GLuint, 1, 1, 0>;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R10G10B10A2_SNORM:
            internalFormat               = GL_RGB10_A2_SNORM_ANGLEX;
            imageFormatID                = angle::FormatID::R10G10B10A2_SNORM;
            vkImageFormat                = VK_FORMAT_A2B10G10R10_SNORM_PACK32;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::R10G10B10A2_SNORM;
            vkBufferFormat               = VK_FORMAT_A2B10G10R10_SNORM_PACK32;
            vkBufferFormatIsPacked       = true;
            vertexLoadFunction           = CopyNativeVertexData<GLuint, 1, 1, 0>;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R10G10B10A2_SSCALED:
            internalFormat               = GL_RGB10_A2_SSCALED_ANGLEX;
            imageFormatID                = angle::FormatID::R10G10B10A2_SSCALED;
            vkImageFormat                = VK_FORMAT_A2B10G10R10_SSCALED_PACK32;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::R10G10B10A2_SSCALED;
            vkBufferFormat               = VK_FORMAT_A2B10G10R10_SSCALED_PACK32;
            vkBufferFormatIsPacked       = true;
            vertexLoadFunction           = CopyNativeVertexData<GLuint, 1, 1, 0>;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R10G10B10A2_UINT:
            internalFormat               = GL_RGB10_A2UI;
            imageFormatID                = angle::FormatID::R10G10B10A2_UINT;
            vkImageFormat                = VK_FORMAT_A2B10G10R10_UINT_PACK32;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::R10G10B10A2_UINT;
            vkBufferFormat               = VK_FORMAT_A2B10G10R10_UINT_PACK32;
            vkBufferFormatIsPacked       = true;
            vertexLoadFunction           = CopyNativeVertexData<GLuint, 1, 1, 0>;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R10G10B10A2_UNORM:
            internalFormat               = GL_RGB10_A2;
            imageFormatID                = angle::FormatID::R10G10B10A2_UNORM;
            vkImageFormat                = VK_FORMAT_A2B10G10R10_UNORM_PACK32;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::R10G10B10A2_UNORM;
            vkBufferFormat               = VK_FORMAT_A2B10G10R10_UNORM_PACK32;
            vkBufferFormatIsPacked       = true;
            vertexLoadFunction           = CopyNativeVertexData<GLuint, 1, 1, 0>;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R10G10B10A2_USCALED:
            internalFormat               = GL_RGB10_A2_USCALED_ANGLEX;
            imageFormatID                = angle::FormatID::R10G10B10A2_USCALED;
            vkImageFormat                = VK_FORMAT_A2B10G10R10_USCALED_PACK32;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::R10G10B10A2_USCALED;
            vkBufferFormat               = VK_FORMAT_A2B10G10R10_USCALED_PACK32;
            vkBufferFormatIsPacked       = true;
            vertexLoadFunction           = CopyNativeVertexData<GLuint, 1, 1, 0>;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R11G11B10_FLOAT:
            internalFormat               = GL_R11F_G11F_B10F;
            imageFormatID                = angle::FormatID::R11G11B10_FLOAT;
            vkImageFormat                = VK_FORMAT_B10G11R11_UFLOAT_PACK32;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::R11G11B10_FLOAT;
            vkBufferFormat               = VK_FORMAT_B10G11R11_UFLOAT_PACK32;
            vkBufferFormatIsPacked       = true;
            vertexLoadFunction           = CopyNativeVertexData<GLuint, 1, 1, 0>;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R16G16B16A16_FLOAT:
            internalFormat               = GL_RGBA16F;
            imageFormatID                = angle::FormatID::R16G16B16A16_FLOAT;
            vkImageFormat                = VK_FORMAT_R16G16B16A16_SFLOAT;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::R16G16B16A16_FLOAT;
            vkBufferFormat               = VK_FORMAT_R16G16B16A16_SFLOAT;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = CopyNativeVertexData<GLhalf, 4, 4, 0>;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R16G16B16A16_SINT:
            internalFormat               = GL_RGBA16I;
            imageFormatID                = angle::FormatID::R16G16B16A16_SINT;
            vkImageFormat                = VK_FORMAT_R16G16B16A16_SINT;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::R16G16B16A16_SINT;
            vkBufferFormat               = VK_FORMAT_R16G16B16A16_SINT;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = CopyNativeVertexData<GLshort, 4, 4, 0>;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R16G16B16A16_SNORM:
            internalFormat           = GL_RGBA16_SNORM_EXT;
            imageFormatID            = angle::FormatID::R16G16B16A16_SNORM;
            vkImageFormat            = VK_FORMAT_R16G16B16A16_SNORM;
            imageInitializerFunction = nullptr;
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R16G16B16A16_SNORM, VK_FORMAT_R16G16B16A16_SNORM, false,
                     CopyNativeVertexData<GLshort, 4, 4, 0>, false},
                    {angle::FormatID::R32G32B32A32_FLOAT, VK_FORMAT_R32G32B32A32_SFLOAT, false,
                     CopyTo32FVertexData<GLshort, 4, 4, true>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo));
            }
            break;

        case angle::FormatID::R16G16B16A16_SSCALED:
            internalFormat           = GL_RGBA16_SSCALED_ANGLEX;
            imageFormatID            = angle::FormatID::R16G16B16A16_SSCALED;
            vkImageFormat            = VK_FORMAT_R16G16B16A16_SSCALED;
            imageInitializerFunction = nullptr;
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R16G16B16A16_SSCALED, VK_FORMAT_R16G16B16A16_SSCALED, false,
                     CopyNativeVertexData<GLshort, 4, 4, 0>, false},
                    {angle::FormatID::R32G32B32A32_FLOAT, VK_FORMAT_R32G32B32A32_SFLOAT, false,
                     CopyTo32FVertexData<GLshort, 4, 4, false>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo));
            }
            break;

        case angle::FormatID::R16G16B16A16_UINT:
            internalFormat               = GL_RGBA16UI;
            imageFormatID                = angle::FormatID::R16G16B16A16_UINT;
            vkImageFormat                = VK_FORMAT_R16G16B16A16_UINT;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::R16G16B16A16_UINT;
            vkBufferFormat               = VK_FORMAT_R16G16B16A16_UINT;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = CopyNativeVertexData<GLushort, 4, 4, 0>;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R16G16B16A16_UNORM:
            internalFormat           = GL_RGBA16_EXT;
            imageFormatID            = angle::FormatID::R16G16B16A16_UNORM;
            vkImageFormat            = VK_FORMAT_R16G16B16A16_UNORM;
            imageInitializerFunction = nullptr;
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R16G16B16A16_UNORM, VK_FORMAT_R16G16B16A16_UNORM, false,
                     CopyNativeVertexData<GLushort, 4, 4, 0>, false},
                    {angle::FormatID::R32G32B32A32_FLOAT, VK_FORMAT_R32G32B32A32_SFLOAT, false,
                     CopyTo32FVertexData<GLushort, 4, 4, true>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo));
            }
            break;

        case angle::FormatID::R16G16B16A16_USCALED:
            internalFormat           = GL_RGBA16_USCALED_ANGLEX;
            imageFormatID            = angle::FormatID::R16G16B16A16_USCALED;
            vkImageFormat            = VK_FORMAT_R16G16B16A16_USCALED;
            imageInitializerFunction = nullptr;
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R16G16B16A16_USCALED, VK_FORMAT_R16G16B16A16_USCALED, false,
                     CopyNativeVertexData<GLushort, 4, 4, 0>, false},
                    {angle::FormatID::R32G32B32A32_FLOAT, VK_FORMAT_R32G32B32A32_SFLOAT, false,
                     CopyTo32FVertexData<GLushort, 4, 4, false>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo));
            }
            break;

        case angle::FormatID::R16G16B16_FLOAT:
            internalFormat = GL_RGB16F;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::R16G16B16_FLOAT, VK_FORMAT_R16G16B16_SFLOAT, nullptr},
                    {angle::FormatID::R16G16B16A16_FLOAT, VK_FORMAT_R16G16B16A16_SFLOAT,
                     Initialize4ComponentData<GLhalf, 0x0000, 0x0000, 0x0000, gl::Float16One>}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R16G16B16_FLOAT, VK_FORMAT_R16G16B16_SFLOAT, false,
                     CopyNativeVertexData<GLhalf, 3, 3, 0>, false},
                    {angle::FormatID::R16G16B16A16_FLOAT, VK_FORMAT_R16G16B16A16_SFLOAT, false,
                     CopyNativeVertexData<GLhalf, 3, 4, 0>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo));
            }
            break;

        case angle::FormatID::R16G16B16_SINT:
            internalFormat = GL_RGB16I;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::R16G16B16_SINT, VK_FORMAT_R16G16B16_SINT, nullptr},
                    {angle::FormatID::R16G16B16A16_SINT, VK_FORMAT_R16G16B16A16_SINT,
                     Initialize4ComponentData<GLshort, 0x0000, 0x0000, 0x0000, 0x0001>}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R16G16B16_SINT, VK_FORMAT_R16G16B16_SINT, false,
                     CopyNativeVertexData<GLshort, 3, 3, 0>, false},
                    {angle::FormatID::R16G16B16A16_SINT, VK_FORMAT_R16G16B16A16_SINT, false,
                     CopyNativeVertexData<GLshort, 3, 4, 0>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo));
            }
            break;

        case angle::FormatID::R16G16B16_SNORM:
            internalFormat           = GL_RGB16_SNORM_EXT;
            imageFormatID            = angle::FormatID::R16G16B16_SNORM;
            vkImageFormat            = VK_FORMAT_R16G16B16_SNORM;
            imageInitializerFunction = nullptr;
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R16G16B16_SNORM, VK_FORMAT_R16G16B16_SNORM, false,
                     CopyNativeVertexData<GLshort, 3, 3, 0>, false},
                    {angle::FormatID::R32G32B32_FLOAT, VK_FORMAT_R32G32B32_SFLOAT, false,
                     CopyTo32FVertexData<GLshort, 3, 3, true>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo));
            }
            break;

        case angle::FormatID::R16G16B16_SSCALED:
            internalFormat           = GL_RGB16_SSCALED_ANGLEX;
            imageFormatID            = angle::FormatID::R16G16B16_SSCALED;
            vkImageFormat            = VK_FORMAT_R16G16B16_SSCALED;
            imageInitializerFunction = nullptr;
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R16G16B16_SSCALED, VK_FORMAT_R16G16B16_SSCALED, false,
                     CopyNativeVertexData<GLshort, 3, 3, 0>, false},
                    {angle::FormatID::R32G32B32_FLOAT, VK_FORMAT_R32G32B32_SFLOAT, false,
                     CopyTo32FVertexData<GLshort, 3, 3, false>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo));
            }
            break;

        case angle::FormatID::R16G16B16_UINT:
            internalFormat = GL_RGB16UI;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::R16G16B16_UINT, VK_FORMAT_R16G16B16_UINT, nullptr},
                    {angle::FormatID::R16G16B16A16_UINT, VK_FORMAT_R16G16B16A16_UINT,
                     Initialize4ComponentData<GLushort, 0x0000, 0x0000, 0x0000, 0x0001>}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R16G16B16_UINT, VK_FORMAT_R16G16B16_UINT, false,
                     CopyNativeVertexData<GLushort, 3, 3, 0>, false},
                    {angle::FormatID::R16G16B16A16_UINT, VK_FORMAT_R16G16B16A16_UINT, false,
                     CopyNativeVertexData<GLushort, 3, 4, 0>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo));
            }
            break;

        case angle::FormatID::R16G16B16_UNORM:
            internalFormat           = GL_RGB16_EXT;
            imageFormatID            = angle::FormatID::R16G16B16_UNORM;
            vkImageFormat            = VK_FORMAT_R16G16B16_UNORM;
            imageInitializerFunction = nullptr;
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R16G16B16_UNORM, VK_FORMAT_R16G16B16_UNORM, false,
                     CopyNativeVertexData<GLushort, 3, 3, 0>, false},
                    {angle::FormatID::R32G32B32_FLOAT, VK_FORMAT_R32G32B32_SFLOAT, false,
                     CopyTo32FVertexData<GLushort, 3, 3, true>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo));
            }
            break;

        case angle::FormatID::R16G16B16_USCALED:
            internalFormat           = GL_RGB16_USCALED_ANGLEX;
            imageFormatID            = angle::FormatID::R16G16B16_USCALED;
            vkImageFormat            = VK_FORMAT_R16G16B16_USCALED;
            imageInitializerFunction = nullptr;
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R16G16B16_USCALED, VK_FORMAT_R16G16B16_USCALED, false,
                     CopyNativeVertexData<GLushort, 3, 3, 0>, false},
                    {angle::FormatID::R32G32B32_FLOAT, VK_FORMAT_R32G32B32_SFLOAT, false,
                     CopyTo32FVertexData<GLushort, 3, 3, false>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo));
            }
            break;

        case angle::FormatID::R16G16_FLOAT:
            internalFormat               = GL_RG16F;
            imageFormatID                = angle::FormatID::R16G16_FLOAT;
            vkImageFormat                = VK_FORMAT_R16G16_SFLOAT;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::R16G16_FLOAT;
            vkBufferFormat               = VK_FORMAT_R16G16_SFLOAT;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = CopyNativeVertexData<GLhalf, 2, 2, 0>;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R16G16_SINT:
            internalFormat               = GL_RG16I;
            imageFormatID                = angle::FormatID::R16G16_SINT;
            vkImageFormat                = VK_FORMAT_R16G16_SINT;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::R16G16_SINT;
            vkBufferFormat               = VK_FORMAT_R16G16_SINT;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = CopyNativeVertexData<GLshort, 2, 2, 0>;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R16G16_SNORM:
            internalFormat           = GL_RG16_SNORM_EXT;
            imageFormatID            = angle::FormatID::R16G16_SNORM;
            vkImageFormat            = VK_FORMAT_R16G16_SNORM;
            imageInitializerFunction = nullptr;
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R16G16_SNORM, VK_FORMAT_R16G16_SNORM, false,
                     CopyNativeVertexData<GLshort, 2, 2, 0>, false},
                    {angle::FormatID::R32G32_FLOAT, VK_FORMAT_R32G32_SFLOAT, false,
                     CopyTo32FVertexData<GLshort, 2, 2, true>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo));
            }
            break;

        case angle::FormatID::R16G16_SSCALED:
            internalFormat           = GL_RG16_SSCALED_ANGLEX;
            imageFormatID            = angle::FormatID::R16G16_SSCALED;
            vkImageFormat            = VK_FORMAT_R16G16_SSCALED;
            imageInitializerFunction = nullptr;
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R16G16_SSCALED, VK_FORMAT_R16G16_SSCALED, false,
                     CopyNativeVertexData<GLshort, 2, 2, 0>, false},
                    {angle::FormatID::R32G32_FLOAT, VK_FORMAT_R32G32_SFLOAT, false,
                     CopyTo32FVertexData<GLshort, 2, 2, false>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo));
            }
            break;

        case angle::FormatID::R16G16_UINT:
            internalFormat               = GL_RG16UI;
            imageFormatID                = angle::FormatID::R16G16_UINT;
            vkImageFormat                = VK_FORMAT_R16G16_UINT;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::R16G16_UINT;
            vkBufferFormat               = VK_FORMAT_R16G16_UINT;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = CopyNativeVertexData<GLushort, 2, 2, 0>;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R16G16_UNORM:
            internalFormat           = GL_RG16_EXT;
            imageFormatID            = angle::FormatID::R16G16_UNORM;
            vkImageFormat            = VK_FORMAT_R16G16_UNORM;
            imageInitializerFunction = nullptr;
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R16G16_UNORM, VK_FORMAT_R16G16_UNORM, false,
                     CopyNativeVertexData<GLushort, 2, 2, 0>, false},
                    {angle::FormatID::R32G32_FLOAT, VK_FORMAT_R32G32_SFLOAT, false,
                     CopyTo32FVertexData<GLushort, 2, 2, true>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo));
            }
            break;

        case angle::FormatID::R16G16_USCALED:
            internalFormat           = GL_RG16_USCALED_ANGLEX;
            imageFormatID            = angle::FormatID::R16G16_USCALED;
            vkImageFormat            = VK_FORMAT_R16G16_USCALED;
            imageInitializerFunction = nullptr;
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R16G16_USCALED, VK_FORMAT_R16G16_USCALED, false,
                     CopyNativeVertexData<GLushort, 2, 2, 0>, false},
                    {angle::FormatID::R32G32_FLOAT, VK_FORMAT_R32G32_SFLOAT, false,
                     CopyTo32FVertexData<GLushort, 2, 2, false>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo));
            }
            break;

        case angle::FormatID::R16_FLOAT:
            internalFormat               = GL_R16F;
            imageFormatID                = angle::FormatID::R16_FLOAT;
            vkImageFormat                = VK_FORMAT_R16_SFLOAT;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::R16_FLOAT;
            vkBufferFormat               = VK_FORMAT_R16_SFLOAT;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = CopyNativeVertexData<GLhalf, 1, 1, 0>;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R16_SINT:
            internalFormat               = GL_R16I;
            imageFormatID                = angle::FormatID::R16_SINT;
            vkImageFormat                = VK_FORMAT_R16_SINT;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::R16_SINT;
            vkBufferFormat               = VK_FORMAT_R16_SINT;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = CopyNativeVertexData<GLshort, 1, 1, 0>;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R16_SNORM:
            internalFormat           = GL_R16_SNORM_EXT;
            imageFormatID            = angle::FormatID::R16_SNORM;
            vkImageFormat            = VK_FORMAT_R16_SNORM;
            imageInitializerFunction = nullptr;
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R16_SNORM, VK_FORMAT_R16_SNORM, false,
                     CopyNativeVertexData<GLshort, 1, 1, 0>, false},
                    {angle::FormatID::R32_FLOAT, VK_FORMAT_R32_SFLOAT, false,
                     CopyTo32FVertexData<GLshort, 1, 1, true>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo));
            }
            break;

        case angle::FormatID::R16_SSCALED:
            internalFormat           = GL_R16_SSCALED_ANGLEX;
            imageFormatID            = angle::FormatID::R16_SSCALED;
            vkImageFormat            = VK_FORMAT_R16_SSCALED;
            imageInitializerFunction = nullptr;
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R16_SSCALED, VK_FORMAT_R16_SSCALED, false,
                     CopyNativeVertexData<GLshort, 1, 1, 0>, false},
                    {angle::FormatID::R32_FLOAT, VK_FORMAT_R32_SFLOAT, false,
                     CopyTo32FVertexData<GLshort, 1, 1, false>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo));
            }
            break;

        case angle::FormatID::R16_UINT:
            internalFormat               = GL_R16UI;
            imageFormatID                = angle::FormatID::R16_UINT;
            vkImageFormat                = VK_FORMAT_R16_UINT;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::R16_UINT;
            vkBufferFormat               = VK_FORMAT_R16_UINT;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = CopyNativeVertexData<GLushort, 1, 1, 0>;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R16_UNORM:
            internalFormat           = GL_R16_EXT;
            imageFormatID            = angle::FormatID::R16_UNORM;
            vkImageFormat            = VK_FORMAT_R16_UNORM;
            imageInitializerFunction = nullptr;
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R16_UNORM, VK_FORMAT_R16_UNORM, false,
                     CopyNativeVertexData<GLushort, 1, 1, 0>, false},
                    {angle::FormatID::R32_FLOAT, VK_FORMAT_R32_SFLOAT, false,
                     CopyTo32FVertexData<GLushort, 1, 1, true>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo));
            }
            break;

        case angle::FormatID::R16_USCALED:
            internalFormat           = GL_R16_USCALED_ANGLEX;
            imageFormatID            = angle::FormatID::R16_USCALED;
            vkImageFormat            = VK_FORMAT_R16_USCALED;
            imageInitializerFunction = nullptr;
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R16_USCALED, VK_FORMAT_R16_USCALED, false,
                     CopyNativeVertexData<GLushort, 1, 1, 0>, false},
                    {angle::FormatID::R32_FLOAT, VK_FORMAT_R32_SFLOAT, false,
                     CopyTo32FVertexData<GLushort, 1, 1, false>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo));
            }
            break;

        case angle::FormatID::R32G32B32A32_FIXED:
            internalFormat = GL_RGBA32_FIXED_ANGLEX;

            bufferFormatID               = angle::FormatID::R32G32B32A32_FLOAT;
            vkBufferFormat               = VK_FORMAT_R32G32B32A32_SFLOAT;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = Copy32FixedTo32FVertexData<4, 4>;
            vertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R32G32B32A32_FLOAT:
            internalFormat               = GL_RGBA32F;
            imageFormatID                = angle::FormatID::R32G32B32A32_FLOAT;
            vkImageFormat                = VK_FORMAT_R32G32B32A32_SFLOAT;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::R32G32B32A32_FLOAT;
            vkBufferFormat               = VK_FORMAT_R32G32B32A32_SFLOAT;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = CopyNativeVertexData<GLfloat, 4, 4, 0>;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R32G32B32A32_SINT:
            internalFormat               = GL_RGBA32I;
            imageFormatID                = angle::FormatID::R32G32B32A32_SINT;
            vkImageFormat                = VK_FORMAT_R32G32B32A32_SINT;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::R32G32B32A32_SINT;
            vkBufferFormat               = VK_FORMAT_R32G32B32A32_SINT;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = CopyNativeVertexData<GLint, 4, 4, 0>;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R32G32B32A32_SNORM:
            internalFormat = GL_RGBA32_SNORM_ANGLEX;

            bufferFormatID               = angle::FormatID::R32G32B32A32_FLOAT;
            vkBufferFormat               = VK_FORMAT_R32G32B32A32_SFLOAT;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = CopyTo32FVertexData<GLint, 4, 4, true>;
            vertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R32G32B32A32_SSCALED:
            internalFormat = GL_RGBA32_SSCALED_ANGLEX;

            bufferFormatID               = angle::FormatID::R32G32B32A32_FLOAT;
            vkBufferFormat               = VK_FORMAT_R32G32B32A32_SFLOAT;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = CopyTo32FVertexData<GLint, 4, 4, false>;
            vertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R32G32B32A32_UINT:
            internalFormat               = GL_RGBA32UI;
            imageFormatID                = angle::FormatID::R32G32B32A32_UINT;
            vkImageFormat                = VK_FORMAT_R32G32B32A32_UINT;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::R32G32B32A32_UINT;
            vkBufferFormat               = VK_FORMAT_R32G32B32A32_UINT;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = CopyNativeVertexData<GLuint, 4, 4, 0>;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R32G32B32A32_UNORM:
            internalFormat = GL_RGBA32_UNORM_ANGLEX;

            bufferFormatID               = angle::FormatID::R32G32B32A32_FLOAT;
            vkBufferFormat               = VK_FORMAT_R32G32B32A32_SFLOAT;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = CopyTo32FVertexData<GLuint, 4, 4, true>;
            vertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R32G32B32A32_USCALED:
            internalFormat = GL_RGBA32_USCALED_ANGLEX;

            bufferFormatID               = angle::FormatID::R32G32B32A32_FLOAT;
            vkBufferFormat               = VK_FORMAT_R32G32B32A32_SFLOAT;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = CopyTo32FVertexData<GLuint, 4, 4, false>;
            vertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R32G32B32_FIXED:
            internalFormat = GL_RGB32_FIXED_ANGLEX;

            bufferFormatID               = angle::FormatID::R32G32B32_FLOAT;
            vkBufferFormat               = VK_FORMAT_R32G32B32_SFLOAT;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = Copy32FixedTo32FVertexData<3, 3>;
            vertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R32G32B32_FLOAT:
            internalFormat = GL_RGB32F;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::R32G32B32_FLOAT, VK_FORMAT_R32G32B32_SFLOAT, nullptr},
                    {angle::FormatID::R32G32B32A32_FLOAT, VK_FORMAT_R32G32B32A32_SFLOAT,
                     Initialize4ComponentData<GLfloat, 0x00000000, 0x00000000, 0x00000000,
                                              gl::Float32One>}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            bufferFormatID               = angle::FormatID::R32G32B32_FLOAT;
            vkBufferFormat               = VK_FORMAT_R32G32B32_SFLOAT;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = CopyNativeVertexData<GLfloat, 3, 3, 0>;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R32G32B32_SINT:
            internalFormat = GL_RGB32I;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::R32G32B32_SINT, VK_FORMAT_R32G32B32_SINT, nullptr},
                    {angle::FormatID::R32G32B32A32_SINT, VK_FORMAT_R32G32B32A32_SINT,
                     Initialize4ComponentData<GLint, 0x00000000, 0x00000000, 0x00000000,
                                              0x00000001>}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            bufferFormatID               = angle::FormatID::R32G32B32_SINT;
            vkBufferFormat               = VK_FORMAT_R32G32B32_SINT;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = CopyNativeVertexData<GLint, 3, 3, 0>;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R32G32B32_SNORM:
            internalFormat = GL_RGB32_SNORM_ANGLEX;

            bufferFormatID               = angle::FormatID::R32G32B32_FLOAT;
            vkBufferFormat               = VK_FORMAT_R32G32B32_SFLOAT;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = CopyTo32FVertexData<GLint, 3, 3, true>;
            vertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R32G32B32_SSCALED:
            internalFormat = GL_RGB32_SSCALED_ANGLEX;

            bufferFormatID               = angle::FormatID::R32G32B32_FLOAT;
            vkBufferFormat               = VK_FORMAT_R32G32B32_SFLOAT;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = CopyTo32FVertexData<GLint, 3, 3, false>;
            vertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R32G32B32_UINT:
            internalFormat = GL_RGB32UI;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::R32G32B32_UINT, VK_FORMAT_R32G32B32_UINT, nullptr},
                    {angle::FormatID::R32G32B32A32_UINT, VK_FORMAT_R32G32B32A32_UINT,
                     Initialize4ComponentData<GLuint, 0x00000000, 0x00000000, 0x00000000,
                                              0x00000001>}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            bufferFormatID               = angle::FormatID::R32G32B32_UINT;
            vkBufferFormat               = VK_FORMAT_R32G32B32_UINT;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = CopyNativeVertexData<GLuint, 3, 3, 0>;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R32G32B32_UNORM:
            internalFormat = GL_RGB32_UNORM_ANGLEX;

            bufferFormatID               = angle::FormatID::R32G32B32_FLOAT;
            vkBufferFormat               = VK_FORMAT_R32G32B32_SFLOAT;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = CopyTo32FVertexData<GLuint, 3, 3, true>;
            vertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R32G32B32_USCALED:
            internalFormat = GL_RGB32_USCALED_ANGLEX;

            bufferFormatID               = angle::FormatID::R32G32B32_FLOAT;
            vkBufferFormat               = VK_FORMAT_R32G32B32_SFLOAT;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = CopyTo32FVertexData<GLuint, 3, 3, false>;
            vertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R32G32_FIXED:
            internalFormat = GL_RG32_FIXED_ANGLEX;

            bufferFormatID               = angle::FormatID::R32G32_FLOAT;
            vkBufferFormat               = VK_FORMAT_R32G32_SFLOAT;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = Copy32FixedTo32FVertexData<2, 2>;
            vertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R32G32_FLOAT:
            internalFormat               = GL_RG32F;
            imageFormatID                = angle::FormatID::R32G32_FLOAT;
            vkImageFormat                = VK_FORMAT_R32G32_SFLOAT;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::R32G32_FLOAT;
            vkBufferFormat               = VK_FORMAT_R32G32_SFLOAT;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = CopyNativeVertexData<GLfloat, 2, 2, 0>;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R32G32_SINT:
            internalFormat               = GL_RG32I;
            imageFormatID                = angle::FormatID::R32G32_SINT;
            vkImageFormat                = VK_FORMAT_R32G32_SINT;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::R32G32_SINT;
            vkBufferFormat               = VK_FORMAT_R32G32_SINT;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = CopyNativeVertexData<GLint, 2, 2, 0>;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R32G32_SNORM:
            internalFormat = GL_RG32_SNORM_ANGLEX;

            bufferFormatID               = angle::FormatID::R32G32_FLOAT;
            vkBufferFormat               = VK_FORMAT_R32G32_SFLOAT;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = CopyTo32FVertexData<GLint, 2, 2, true>;
            vertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R32G32_SSCALED:
            internalFormat = GL_RG32_SSCALED_ANGLEX;

            bufferFormatID               = angle::FormatID::R32G32_FLOAT;
            vkBufferFormat               = VK_FORMAT_R32G32_SFLOAT;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = CopyTo32FVertexData<GLint, 2, 2, false>;
            vertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R32G32_UINT:
            internalFormat               = GL_RG32UI;
            imageFormatID                = angle::FormatID::R32G32_UINT;
            vkImageFormat                = VK_FORMAT_R32G32_UINT;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::R32G32_UINT;
            vkBufferFormat               = VK_FORMAT_R32G32_UINT;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = CopyNativeVertexData<GLuint, 2, 2, 0>;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R32G32_UNORM:
            internalFormat = GL_RG32_UNORM_ANGLEX;

            bufferFormatID               = angle::FormatID::R32G32_FLOAT;
            vkBufferFormat               = VK_FORMAT_R32G32_SFLOAT;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = CopyTo32FVertexData<GLuint, 2, 2, true>;
            vertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R32G32_USCALED:
            internalFormat = GL_RG32_USCALED_ANGLEX;

            bufferFormatID               = angle::FormatID::R32G32_FLOAT;
            vkBufferFormat               = VK_FORMAT_R32G32_SFLOAT;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = CopyTo32FVertexData<GLuint, 2, 2, false>;
            vertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R32_FIXED:
            internalFormat = GL_R32_FIXED_ANGLEX;

            bufferFormatID               = angle::FormatID::R32_FLOAT;
            vkBufferFormat               = VK_FORMAT_R32_SFLOAT;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = Copy32FixedTo32FVertexData<1, 1>;
            vertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R32_FLOAT:
            internalFormat               = GL_R32F;
            imageFormatID                = angle::FormatID::R32_FLOAT;
            vkImageFormat                = VK_FORMAT_R32_SFLOAT;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::R32_FLOAT;
            vkBufferFormat               = VK_FORMAT_R32_SFLOAT;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = CopyNativeVertexData<GLfloat, 1, 1, 0>;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R32_SINT:
            internalFormat               = GL_R32I;
            imageFormatID                = angle::FormatID::R32_SINT;
            vkImageFormat                = VK_FORMAT_R32_SINT;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::R32_SINT;
            vkBufferFormat               = VK_FORMAT_R32_SINT;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = CopyNativeVertexData<GLint, 1, 1, 0>;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R32_SNORM:
            internalFormat = GL_R32_SNORM_ANGLEX;

            bufferFormatID               = angle::FormatID::R32_FLOAT;
            vkBufferFormat               = VK_FORMAT_R32_SFLOAT;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = CopyTo32FVertexData<GLint, 1, 1, true>;
            vertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R32_SSCALED:
            internalFormat = GL_R32_SSCALED_ANGLEX;

            bufferFormatID               = angle::FormatID::R32_FLOAT;
            vkBufferFormat               = VK_FORMAT_R32_SFLOAT;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = CopyTo32FVertexData<GLint, 1, 1, false>;
            vertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R32_UINT:
            internalFormat               = GL_R32UI;
            imageFormatID                = angle::FormatID::R32_UINT;
            vkImageFormat                = VK_FORMAT_R32_UINT;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::R32_UINT;
            vkBufferFormat               = VK_FORMAT_R32_UINT;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = CopyNativeVertexData<GLuint, 1, 1, 0>;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R32_UNORM:
            internalFormat = GL_R32_UNORM_ANGLEX;

            bufferFormatID               = angle::FormatID::R32_FLOAT;
            vkBufferFormat               = VK_FORMAT_R32_SFLOAT;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = CopyTo32FVertexData<GLuint, 1, 1, true>;
            vertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R32_USCALED:
            internalFormat = GL_R32_USCALED_ANGLEX;

            bufferFormatID               = angle::FormatID::R32_FLOAT;
            vkBufferFormat               = VK_FORMAT_R32_SFLOAT;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = CopyTo32FVertexData<GLuint, 1, 1, false>;
            vertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R4G4B4A4_UNORM:
            internalFormat               = GL_RGBA4;
            imageFormatID                = angle::FormatID::R8G8B8A8_UNORM;
            vkImageFormat                = VK_FORMAT_R8G8B8A8_UNORM;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::R4G4B4A4_UNORM;
            vkBufferFormat               = VK_FORMAT_R4G4B4A4_UNORM_PACK16;
            vkBufferFormatIsPacked       = true;
            vertexLoadFunction           = CopyNativeVertexData<GLushort, 1, 1, 0>;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R5G5B5A1_UNORM:
            internalFormat               = GL_RGB5_A1;
            imageFormatID                = angle::FormatID::A1R5G5B5_UNORM;
            vkImageFormat                = VK_FORMAT_A1R5G5B5_UNORM_PACK16;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::R5G5B5A1_UNORM;
            vkBufferFormat               = VK_FORMAT_R5G5B5A1_UNORM_PACK16;
            vkBufferFormatIsPacked       = true;
            vertexLoadFunction           = CopyNativeVertexData<GLushort, 1, 1, 0>;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R5G6B5_UNORM:
            internalFormat               = GL_RGB565;
            imageFormatID                = angle::FormatID::R5G6B5_UNORM;
            vkImageFormat                = VK_FORMAT_R5G6B5_UNORM_PACK16;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::R5G6B5_UNORM;
            vkBufferFormat               = VK_FORMAT_R5G6B5_UNORM_PACK16;
            vkBufferFormatIsPacked       = true;
            vertexLoadFunction           = CopyNativeVertexData<GLushort, 1, 1, 0>;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R8G8B8A8_SINT:
            internalFormat               = GL_RGBA8I;
            imageFormatID                = angle::FormatID::R8G8B8A8_SINT;
            vkImageFormat                = VK_FORMAT_R8G8B8A8_SINT;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::R8G8B8A8_SINT;
            vkBufferFormat               = VK_FORMAT_R8G8B8A8_SINT;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = CopyNativeVertexData<GLbyte, 4, 4, 0>;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R8G8B8A8_SNORM:
            internalFormat           = GL_RGBA8_SNORM;
            imageFormatID            = angle::FormatID::R8G8B8A8_SNORM;
            vkImageFormat            = VK_FORMAT_R8G8B8A8_SNORM;
            imageInitializerFunction = nullptr;
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R8G8B8A8_SNORM, VK_FORMAT_R8G8B8A8_SNORM, false,
                     CopyNativeVertexData<GLbyte, 4, 4, 0>, false},
                    {angle::FormatID::R32G32B32A32_FLOAT, VK_FORMAT_R32G32B32A32_SFLOAT, false,
                     CopyTo32FVertexData<GLbyte, 4, 4, true>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo));
            }
            break;

        case angle::FormatID::R8G8B8A8_SSCALED:
            internalFormat           = GL_RGBA8_SSCALED_ANGLEX;
            imageFormatID            = angle::FormatID::R8G8B8A8_SSCALED;
            vkImageFormat            = VK_FORMAT_R8G8B8A8_SSCALED;
            imageInitializerFunction = nullptr;
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R8G8B8A8_SSCALED, VK_FORMAT_R8G8B8A8_SSCALED, false,
                     CopyNativeVertexData<GLbyte, 4, 4, 0>, false},
                    {angle::FormatID::R32G32B32A32_FLOAT, VK_FORMAT_R32G32B32A32_SFLOAT, false,
                     CopyTo32FVertexData<GLbyte, 4, 4, false>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo));
            }
            break;

        case angle::FormatID::R8G8B8A8_TYPELESS:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::R8G8B8A8_TYPELESS_SRGB:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::R8G8B8A8_UINT:
            internalFormat               = GL_RGBA8UI;
            imageFormatID                = angle::FormatID::R8G8B8A8_UINT;
            vkImageFormat                = VK_FORMAT_R8G8B8A8_UINT;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::R8G8B8A8_UINT;
            vkBufferFormat               = VK_FORMAT_R8G8B8A8_UINT;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = CopyNativeVertexData<GLubyte, 4, 4, 0>;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R8G8B8A8_UNORM:
            internalFormat           = GL_RGBA8;
            imageFormatID            = angle::FormatID::R8G8B8A8_UNORM;
            vkImageFormat            = VK_FORMAT_R8G8B8A8_UNORM;
            imageInitializerFunction = nullptr;
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R8G8B8A8_UNORM, VK_FORMAT_R8G8B8A8_UNORM, false,
                     CopyNativeVertexData<GLubyte, 4, 4, 0>, false},
                    {angle::FormatID::R32G32B32A32_FLOAT, VK_FORMAT_R32G32B32A32_SFLOAT, false,
                     CopyTo32FVertexData<GLubyte, 4, 4, true>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo));
            }
            break;

        case angle::FormatID::R8G8B8A8_UNORM_SRGB:
            internalFormat               = GL_SRGB8_ALPHA8;
            imageFormatID                = angle::FormatID::R8G8B8A8_UNORM_SRGB;
            vkImageFormat                = VK_FORMAT_R8G8B8A8_SRGB;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::R8G8B8A8_UNORM_SRGB;
            vkBufferFormat               = VK_FORMAT_R8G8B8A8_SRGB;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = CopyNativeVertexData<GLubyte, 4, 4, 0>;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R8G8B8A8_USCALED:
            internalFormat           = GL_RGBA8_USCALED_ANGLEX;
            imageFormatID            = angle::FormatID::R8G8B8A8_USCALED;
            vkImageFormat            = VK_FORMAT_R8G8B8A8_USCALED;
            imageInitializerFunction = nullptr;
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R8G8B8A8_USCALED, VK_FORMAT_R8G8B8A8_USCALED, false,
                     CopyNativeVertexData<GLubyte, 4, 4, 0>, false},
                    {angle::FormatID::R32G32B32A32_FLOAT, VK_FORMAT_R32G32B32A32_SFLOAT, false,
                     CopyTo32FVertexData<GLubyte, 4, 4, false>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo));
            }
            break;

        case angle::FormatID::R8G8B8_SINT:
            internalFormat = GL_RGB8I;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::R8G8B8_SINT, VK_FORMAT_R8G8B8_SINT, nullptr},
                    {angle::FormatID::R8G8B8A8_SINT, VK_FORMAT_R8G8B8A8_SINT,
                     Initialize4ComponentData<GLbyte, 0x00, 0x00, 0x00, 0x01>}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R8G8B8_SINT, VK_FORMAT_R8G8B8_SINT, false,
                     CopyNativeVertexData<GLbyte, 3, 3, 0>, false},
                    {angle::FormatID::R8G8B8A8_SINT, VK_FORMAT_R8G8B8A8_SINT, false,
                     CopyNativeVertexData<GLbyte, 3, 4, 0>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo));
            }
            break;

        case angle::FormatID::R8G8B8_SNORM:
            internalFormat = GL_RGB8_SNORM;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::R8G8B8_SNORM, VK_FORMAT_R8G8B8_SNORM, nullptr},
                    {angle::FormatID::R8G8B8A8_SNORM, VK_FORMAT_R8G8B8A8_SNORM,
                     Initialize4ComponentData<GLbyte, 0x00, 0x00, 0x00, 0x7F>}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R8G8B8_SNORM, VK_FORMAT_R8G8B8_SNORM, false,
                     CopyNativeVertexData<GLbyte, 3, 3, 0>, false},
                    {angle::FormatID::R32G32B32_FLOAT, VK_FORMAT_R32G32B32_SFLOAT, false,
                     CopyTo32FVertexData<GLbyte, 3, 3, true>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo));
            }
            break;

        case angle::FormatID::R8G8B8_SSCALED:
            internalFormat           = GL_RGB8_SSCALED_ANGLEX;
            imageFormatID            = angle::FormatID::R8G8B8_SSCALED;
            vkImageFormat            = VK_FORMAT_R8G8B8_SSCALED;
            imageInitializerFunction = nullptr;
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R8G8B8_SSCALED, VK_FORMAT_R8G8B8_SSCALED, false,
                     CopyNativeVertexData<GLbyte, 3, 3, 0>, false},
                    {angle::FormatID::R32G32B32_FLOAT, VK_FORMAT_R32G32B32_SFLOAT, false,
                     CopyTo32FVertexData<GLbyte, 3, 3, false>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo));
            }
            break;

        case angle::FormatID::R8G8B8_UINT:
            internalFormat = GL_RGB8UI;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::R8G8B8_UINT, VK_FORMAT_R8G8B8_UINT, nullptr},
                    {angle::FormatID::R8G8B8A8_UINT, VK_FORMAT_R8G8B8A8_UINT,
                     Initialize4ComponentData<GLubyte, 0x00, 0x00, 0x00, 0x01>}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R8G8B8_UINT, VK_FORMAT_R8G8B8_UINT, false,
                     CopyNativeVertexData<GLubyte, 3, 3, 0>, false},
                    {angle::FormatID::R8G8B8A8_UINT, VK_FORMAT_R8G8B8A8_UINT, false,
                     CopyNativeVertexData<GLubyte, 3, 4, 0>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo));
            }
            break;

        case angle::FormatID::R8G8B8_UNORM:
            internalFormat           = GL_RGB8;
            imageFormatID            = angle::FormatID::R8G8B8A8_UNORM;
            vkImageFormat            = VK_FORMAT_R8G8B8A8_UNORM;
            imageInitializerFunction = Initialize4ComponentData<GLubyte, 0x00, 0x00, 0x00, 0xFF>;
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R8G8B8_UNORM, VK_FORMAT_R8G8B8_UNORM, false,
                     CopyNativeVertexData<GLubyte, 3, 3, 0>, false},
                    {angle::FormatID::R32G32B32_FLOAT, VK_FORMAT_R32G32B32_SFLOAT, false,
                     CopyTo32FVertexData<GLubyte, 3, 3, true>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo));
            }
            break;

        case angle::FormatID::R8G8B8_UNORM_SRGB:
            internalFormat           = GL_SRGB8;
            imageFormatID            = angle::FormatID::R8G8B8A8_UNORM_SRGB;
            vkImageFormat            = VK_FORMAT_R8G8B8A8_SRGB;
            imageInitializerFunction = Initialize4ComponentData<GLubyte, 0x00, 0x00, 0x00, 0xFF>;
            bufferFormatID           = angle::FormatID::R8G8B8_UNORM_SRGB;
            vkBufferFormat           = VK_FORMAT_R8G8B8_SRGB;
            vkBufferFormatIsPacked   = false;
            vertexLoadFunction       = CopyNativeVertexData<GLubyte, 3, 3, 0>;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R8G8B8_USCALED:
            internalFormat           = GL_RGB8_USCALED_ANGLEX;
            imageFormatID            = angle::FormatID::R8G8B8_USCALED;
            vkImageFormat            = VK_FORMAT_R8G8B8_USCALED;
            imageInitializerFunction = nullptr;
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R8G8B8_USCALED, VK_FORMAT_R8G8B8_USCALED, false,
                     CopyNativeVertexData<GLubyte, 3, 3, 0>, false},
                    {angle::FormatID::R32G32B32_FLOAT, VK_FORMAT_R32G32B32_SFLOAT, false,
                     CopyTo32FVertexData<GLubyte, 3, 3, false>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo));
            }
            break;

        case angle::FormatID::R8G8_SINT:
            internalFormat               = GL_RG8I;
            imageFormatID                = angle::FormatID::R8G8_SINT;
            vkImageFormat                = VK_FORMAT_R8G8_SINT;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::R8G8_SINT;
            vkBufferFormat               = VK_FORMAT_R8G8_SINT;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = CopyNativeVertexData<GLbyte, 2, 2, 0>;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R8G8_SNORM:
            internalFormat           = GL_RG8_SNORM;
            imageFormatID            = angle::FormatID::R8G8_SNORM;
            vkImageFormat            = VK_FORMAT_R8G8_SNORM;
            imageInitializerFunction = nullptr;
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R8G8_SNORM, VK_FORMAT_R8G8_SNORM, false,
                     CopyNativeVertexData<GLbyte, 2, 2, 0>, false},
                    {angle::FormatID::R32G32_FLOAT, VK_FORMAT_R32G32_SFLOAT, false,
                     CopyTo32FVertexData<GLbyte, 2, 2, true>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo));
            }
            break;

        case angle::FormatID::R8G8_SSCALED:
            internalFormat           = GL_RG8_SSCALED_ANGLEX;
            imageFormatID            = angle::FormatID::R8G8_SSCALED;
            vkImageFormat            = VK_FORMAT_R8G8_SSCALED;
            imageInitializerFunction = nullptr;
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R8G8_SSCALED, VK_FORMAT_R8G8_SSCALED, false,
                     CopyNativeVertexData<GLbyte, 2, 2, 0>, false},
                    {angle::FormatID::R32G32_FLOAT, VK_FORMAT_R32G32_SFLOAT, false,
                     CopyTo32FVertexData<GLbyte, 2, 2, false>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo));
            }
            break;

        case angle::FormatID::R8G8_UINT:
            internalFormat               = GL_RG8UI;
            imageFormatID                = angle::FormatID::R8G8_UINT;
            vkImageFormat                = VK_FORMAT_R8G8_UINT;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::R8G8_UINT;
            vkBufferFormat               = VK_FORMAT_R8G8_UINT;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = CopyNativeVertexData<GLubyte, 2, 2, 0>;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R8G8_UNORM:
            internalFormat           = GL_RG8;
            imageFormatID            = angle::FormatID::R8G8_UNORM;
            vkImageFormat            = VK_FORMAT_R8G8_UNORM;
            imageInitializerFunction = nullptr;
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R8G8_UNORM, VK_FORMAT_R8G8_UNORM, false,
                     CopyNativeVertexData<GLubyte, 2, 2, 0>, false},
                    {angle::FormatID::R32G32_FLOAT, VK_FORMAT_R32G32_SFLOAT, false,
                     CopyTo32FVertexData<GLubyte, 2, 2, true>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo));
            }
            break;

        case angle::FormatID::R8G8_USCALED:
            internalFormat           = GL_RG8_USCALED_ANGLEX;
            imageFormatID            = angle::FormatID::R8G8_USCALED;
            vkImageFormat            = VK_FORMAT_R8G8_USCALED;
            imageInitializerFunction = nullptr;
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R8G8_USCALED, VK_FORMAT_R8G8_USCALED, false,
                     CopyNativeVertexData<GLubyte, 2, 2, 0>, false},
                    {angle::FormatID::R32G32_FLOAT, VK_FORMAT_R32G32_SFLOAT, false,
                     CopyTo32FVertexData<GLubyte, 2, 2, false>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo));
            }
            break;

        case angle::FormatID::R8_SINT:
            internalFormat               = GL_R8I;
            imageFormatID                = angle::FormatID::R8_SINT;
            vkImageFormat                = VK_FORMAT_R8_SINT;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::R8_SINT;
            vkBufferFormat               = VK_FORMAT_R8_SINT;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = CopyNativeVertexData<GLbyte, 1, 1, 0>;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R8_SNORM:
            internalFormat           = GL_R8_SNORM;
            imageFormatID            = angle::FormatID::R8_SNORM;
            vkImageFormat            = VK_FORMAT_R8_SNORM;
            imageInitializerFunction = nullptr;
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R8_SNORM, VK_FORMAT_R8_SNORM, false,
                     CopyNativeVertexData<GLbyte, 1, 1, 0>, false},
                    {angle::FormatID::R32_FLOAT, VK_FORMAT_R32_SFLOAT, false,
                     CopyTo32FVertexData<GLbyte, 1, 1, true>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo));
            }
            break;

        case angle::FormatID::R8_SSCALED:
            internalFormat           = GL_R8_SSCALED_ANGLEX;
            imageFormatID            = angle::FormatID::R8_SSCALED;
            vkImageFormat            = VK_FORMAT_R8_SSCALED;
            imageInitializerFunction = nullptr;
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R8_SSCALED, VK_FORMAT_R8_SSCALED, false,
                     CopyNativeVertexData<GLbyte, 1, 1, 0>, false},
                    {angle::FormatID::R32_FLOAT, VK_FORMAT_R32_SFLOAT, false,
                     CopyTo32FVertexData<GLbyte, 1, 1, false>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo));
            }
            break;

        case angle::FormatID::R8_UINT:
            internalFormat               = GL_R8UI;
            imageFormatID                = angle::FormatID::R8_UINT;
            vkImageFormat                = VK_FORMAT_R8_UINT;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::R8_UINT;
            vkBufferFormat               = VK_FORMAT_R8_UINT;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = CopyNativeVertexData<GLubyte, 1, 1, 0>;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R8_UNORM:
            internalFormat           = GL_R8;
            imageFormatID            = angle::FormatID::R8_UNORM;
            vkImageFormat            = VK_FORMAT_R8_UNORM;
            imageInitializerFunction = nullptr;
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R8_UNORM, VK_FORMAT_R8_UNORM, false,
                     CopyNativeVertexData<GLubyte, 1, 1, 0>, false},
                    {angle::FormatID::R32_FLOAT, VK_FORMAT_R32_SFLOAT, false,
                     CopyTo32FVertexData<GLubyte, 1, 1, true>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo));
            }
            break;

        case angle::FormatID::R8_USCALED:
            internalFormat           = GL_R8_USCALED_ANGLEX;
            imageFormatID            = angle::FormatID::R8_USCALED;
            vkImageFormat            = VK_FORMAT_R8_USCALED;
            imageInitializerFunction = nullptr;
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R8_USCALED, VK_FORMAT_R8_USCALED, false,
                     CopyNativeVertexData<GLubyte, 1, 1, 0>, false},
                    {angle::FormatID::R32_FLOAT, VK_FORMAT_R32_SFLOAT, false,
                     CopyTo32FVertexData<GLubyte, 1, 1, false>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo));
            }
            break;

        case angle::FormatID::R9G9B9E5_SHAREDEXP:
            internalFormat               = GL_RGB9_E5;
            imageFormatID                = angle::FormatID::R9G9B9E5_SHAREDEXP;
            vkImageFormat                = VK_FORMAT_E5B9G9R9_UFLOAT_PACK32;
            imageInitializerFunction     = nullptr;
            bufferFormatID               = angle::FormatID::R9G9B9E5_SHAREDEXP;
            vkBufferFormat               = VK_FORMAT_E5B9G9R9_UFLOAT_PACK32;
            vkBufferFormatIsPacked       = true;
            vertexLoadFunction           = CopyNativeVertexData<GLuint, 1, 1, 0>;
            vertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::S8_UINT:
            internalFormat = GL_STENCIL_INDEX8;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::S8_UINT, VK_FORMAT_S8_UINT, nullptr},
                    {angle::FormatID::D24_UNORM_S8_UINT, VK_FORMAT_D24_UNORM_S8_UINT, nullptr},
                    {angle::FormatID::D32_FLOAT_S8X24_UINT, VK_FORMAT_D32_SFLOAT_S8_UINT, nullptr},
                    {angle::FormatID::S8_UINT, VK_FORMAT_S8_UINT, nullptr}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            bufferFormatID               = angle::FormatID::S8_UINT;
            vkBufferFormat               = VK_FORMAT_S8_UINT;
            vkBufferFormatIsPacked       = false;
            vertexLoadFunction           = nullptr;
            vertexLoadRequiresConversion = false;
            break;

        default:
            UNREACHABLE();
            break;
    }
}

}  // namespace vk

}  // namespace rx
